; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt -passes='print<scalar-evolution>' -disable-output %s 2>&1 | FileCheck %s

; Tests for PR47904.

define void @test_trip_multiple_4(i32 %num) {
; CHECK-LABEL: @test_trip_multiple_4
; CHECK:       Loop %for.body: backedge-taken count is (-1 + %num)
; CHECK-NEXT:  Loop %for.body: max backedge-taken count is -2
; CHECK-NEXT:  Loop %for.body: Predicated backedge-taken count is (-1 + %num)
; CHECK:       Loop %for.body: Trip multiple is 4
;
entry:
  %u = urem i32 %num, 4
  %cmp = icmp eq i32 %u, 0
  tail call void @llvm.assume(i1 %cmp)
  %cmp.1 = icmp uge i32 %num, 4
  tail call void @llvm.assume(i1 %cmp.1)
  br label %for.body

for.body:
  %i.010 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
  %inc = add nuw nsw i32 %i.010, 1
  %cmp2 = icmp ult i32 %inc, %num
  br i1 %cmp2, label %for.body, label %exit

exit:
  ret void
}


define void @test_trip_multiple_4_ugt_5(i32 %num) {
; CHECK-LABEL: @test_trip_multiple_4_ugt_5
; CHECK:       Loop %for.body: backedge-taken count is (-1 + %num)
; CHECK-NEXT:  Loop %for.body: max backedge-taken count is -2
; CHECK-NEXT:  Loop %for.body: Predicated backedge-taken count is (-1 + %num)
; CHECK:       Loop %for.body: Trip multiple is 4
;
entry:
  %u = urem i32 %num, 4
  %cmp = icmp eq i32 %u, 0
  tail call void @llvm.assume(i1 %cmp)
  %cmp.1 = icmp ugt i32 %num, 5
  tail call void @llvm.assume(i1 %cmp.1)
  br label %for.body

for.body:
  %i.010 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
  %inc = add nuw nsw i32 %i.010, 1
  %cmp2 = icmp ult i32 %inc, %num
  br i1 %cmp2, label %for.body, label %exit

exit:
  ret void
}

define void @test_trip_multiple_4_ugt_5_order_swapped(i32 %num) {
; TODO: Trip multiple can be 4, it is missed due to the processing order of the assumes.
; CHECK-LABEL: @test_trip_multiple_4_ugt_5_order_swapped
; CHECK:       Loop %for.body: backedge-taken count is (-1 + %num)
; CHECK-NEXT:  Loop %for.body: max backedge-taken count is -2
; CHECK-NEXT:  Loop %for.body: Predicated backedge-taken count is (-1 + %num)
; CHECK:       Loop %for.body: Trip multiple is 2
;
entry:
  %u = urem i32 %num, 4
  %cmp.1 = icmp ugt i32 %num, 5
  tail call void @llvm.assume(i1 %cmp.1)
  %cmp = icmp eq i32 %u, 0
  tail call void @llvm.assume(i1 %cmp)
  br label %for.body

for.body:
  %i.010 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
  %inc = add nuw nsw i32 %i.010, 1
  %cmp2 = icmp ult i32 %inc, %num
  br i1 %cmp2, label %for.body, label %exit

exit:
  ret void
}

define void @test_trip_multiple_4_sgt_5(i32 %num) {
; CHECK-LABEL: @test_trip_multiple_4_sgt_5
; CHECK:       Loop %for.body: backedge-taken count is (-1 + %num)
; CHECK-NEXT:  Loop %for.body: max backedge-taken count is 2147483646
; CHECK-NEXT:  Loop %for.body: Predicated backedge-taken count is (-1 + %num)
; CHECK:       Loop %for.body: Trip multiple is 4
;
entry:
  %u = urem i32 %num, 4
  %cmp = icmp eq i32 %u, 0
  tail call void @llvm.assume(i1 %cmp)
  %cmp.1 = icmp sgt i32 %num, 5
  tail call void @llvm.assume(i1 %cmp.1)
  br label %for.body

for.body:
  %i.010 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
  %inc = add nuw nsw i32 %i.010, 1
  %cmp2 = icmp slt i32 %inc, %num
  br i1 %cmp2, label %for.body, label %exit

exit:
  ret void
}

define void @test_trip_multiple_4_sgt_5_order_swapped(i32 %num) {
; TODO: Trip multiple can be 4, it is missed due to the processing order of the assumes.
; CHECK-LABEL: @test_trip_multiple_4_sgt_5_order_swapped
; CHECK:       Loop %for.body: backedge-taken count is (-1 + %num)
; CHECK-NEXT:  Loop %for.body: max backedge-taken count is 2147483646
; CHECK-NEXT:  Loop %for.body: Predicated backedge-taken count is (-1 + %num)
; CHECK:       Loop %for.body: Trip multiple is 2
;
entry:
  %u = urem i32 %num, 4
  %cmp.1 = icmp sgt i32 %num, 5
  tail call void @llvm.assume(i1 %cmp.1)
  %cmp = icmp eq i32 %u, 0
  tail call void @llvm.assume(i1 %cmp)
  br label %for.body

for.body:
  %i.010 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
  %inc = add nuw nsw i32 %i.010, 1
  %cmp2 = icmp slt i32 %inc, %num
  br i1 %cmp2, label %for.body, label %exit

exit:
  ret void
}

define void @test_trip_multiple_4_uge_5(i32 %num) {
; CHECK-LABEL: @test_trip_multiple_4_uge_5
; CHECK:       Loop %for.body: backedge-taken count is (-1 + %num)
; CHECK-NEXT:  Loop %for.body: max backedge-taken count is -2
; CHECK-NEXT:  Loop %for.body: Predicated backedge-taken count is (-1 + %num)
; CHECK:       Loop %for.body: Trip multiple is 4
;
entry:
  %u = urem i32 %num, 4
  %cmp = icmp eq i32 %u, 0
  tail call void @llvm.assume(i1 %cmp)
  %cmp.1 = icmp uge i32 %num, 5
  tail call void @llvm.assume(i1 %cmp.1)
  br label %for.body

for.body:
  %i.010 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
  %inc = add nuw nsw i32 %i.010, 1
  %cmp2 = icmp ult i32 %inc, %num
  br i1 %cmp2, label %for.body, label %exit

exit:
  ret void
}

define void @test_trip_multiple_4_uge_5_order_swapped(i32 %num) {
; TODO: Trip multiple can be 4, it is missed due to the processing order of the assumes.
; CHECK-LABEL: @test_trip_multiple_4_uge_5_order_swapped
; CHECK:       Loop %for.body: backedge-taken count is (-1 + %num)
; CHECK-NEXT:  Loop %for.body: max backedge-taken count is -2
; CHECK-NEXT:  Loop %for.body: Predicated backedge-taken count is (-1 + %num)
; CHECK:       Loop %for.body: Trip multiple is 1
;
entry:
  %u = urem i32 %num, 4
  %cmp = icmp eq i32 %u, 0
  %cmp.1 = icmp uge i32 %num, 5
  tail call void @llvm.assume(i1 %cmp.1)
  tail call void @llvm.assume(i1 %cmp)
  br label %for.body

for.body:
  %i.010 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
  %inc = add nuw nsw i32 %i.010, 1
  %cmp2 = icmp ult i32 %inc, %num
  br i1 %cmp2, label %for.body, label %exit

exit:
  ret void
}

define void @test_trip_multiple_4_sge_5(i32 %num) {
; TODO: Trip multiple can be 4, it is missed due to the processing order of the assumes.
; CHECK-LABEL: @test_trip_multiple_4_sge_5
; CHECK:       Loop %for.body: backedge-taken count is (-1 + %num)
; CHECK-NEXT:  Loop %for.body: max backedge-taken count is 2147483646
; CHECK-NEXT:  Loop %for.body: Predicated backedge-taken count is (-1 + %num)
; CHECK:       Loop %for.body: Trip multiple is 4
;
entry:
  %u = urem i32 %num, 4
  %cmp = icmp eq i32 %u, 0
  tail call void @llvm.assume(i1 %cmp)
  %cmp.1 = icmp sge i32 %num, 5
  tail call void @llvm.assume(i1 %cmp.1)
  br label %for.body

for.body:
  %i.010 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
  %inc = add nuw nsw i32 %i.010, 1
  %cmp2 = icmp slt i32 %inc, %num
  br i1 %cmp2, label %for.body, label %exit

exit:
  ret void
}

define void @test_trip_multiple_4_sge_5_order_swapped(i32 %num) {
; CHECK-LABEL: @test_trip_multiple_4_sge_5_order_swapped
; CHECK:       Loop %for.body: backedge-taken count is (-1 + %num)
; CHECK-NEXT:  Loop %for.body: max backedge-taken count is 2147483646
; CHECK-NEXT:  Loop %for.body: Predicated backedge-taken count is (-1 + %num)
; CHECK:       Loop %for.body: Trip multiple is 1
;
entry:
  %u = urem i32 %num, 4
  %cmp = icmp eq i32 %u, 0
  %cmp.1 = icmp sge i32 %num, 5
  tail call void @llvm.assume(i1 %cmp.1)
  tail call void @llvm.assume(i1 %cmp)
  br label %for.body

for.body:
  %i.010 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
  %inc = add nuw nsw i32 %i.010, 1
  %cmp2 = icmp slt i32 %inc, %num
  br i1 %cmp2, label %for.body, label %exit

exit:
  ret void
}

; Same as @test_trip_multiple_4 but with the icmp operands swapped.
define void @test_trip_multiple_4_icmp_ops_swapped(i32 %num) {
; CHECK-LABEL: @test_trip_multiple_4_icmp_ops_swapped
; CHECK:       Loop %for.body: backedge-taken count is (-1 + %num)
; CHECK-NEXT:  Loop %for.body: max backedge-taken count is -2
; CHECK-NEXT:  Loop %for.body: Predicated backedge-taken count is (-1 + %num)
; CHECK:       Loop %for.body: Trip multiple is 4
;
entry:
  %u = urem i32 %num, 4
  %cmp = icmp eq i32 0, %u
  tail call void @llvm.assume(i1 %cmp)
  %cmp.1 = icmp uge i32 %num, 4
  tail call void @llvm.assume(i1 %cmp.1)
  br label %for.body

for.body:
  %i.010 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
  %inc = add nuw nsw i32 %i.010, 1
  %cmp2 = icmp ult i32 %inc, %num
  br i1 %cmp2, label %for.body, label %exit

exit:
  ret void
}

define void @test_trip_multiple_5(i32 %num) {
; CHECK-LABEL: @test_trip_multiple_5
; CHECK:       Loop %for.body: backedge-taken count is (-1 + %num)
; CHECK-NEXT:  Loop %for.body: max backedge-taken count is -2
; CHECK-NEXT:  Loop %for.body: Predicated backedge-taken count is (-1 + %num)
; CHECK:       Loop %for.body: Trip multiple is 1
;
entry:
  %u = urem i32 %num, 5
  %cmp = icmp eq i32 %u, 0
  tail call void @llvm.assume(i1 %cmp)
  %cmp.1 = icmp uge i32 %num, 5
  tail call void @llvm.assume(i1 %cmp.1)
  br label %for.body

for.body:
  %i.010 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
  %inc = add nuw nsw i32 %i.010, 1
  %cmp2 = icmp ult i32 %inc, %num
  br i1 %cmp2, label %for.body, label %exit

exit:
  ret void
}

define void @test_trunc_operand_larger_than_urem_expr(i64 %N) {
; CHECK-LABEL: @test_trunc_operand_larger_than_urem_expr
; CHECK:       Loop %for.body: backedge-taken count is (-1 + %N)
; CHECK-NEXT:  Loop %for.body: max backedge-taken count is -1
; CHECK-NEXT:  Loop %for.body: Predicated backedge-taken count is (-1 + %N)
;
entry:
  %conv = trunc i64 %N to i32
  %and = and i32 %conv, 1
  %cmp.pre = icmp eq i32 %and, 0
  br i1 %cmp.pre, label %for.body, label %exit

for.body:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %for.body ]
  %iv.next = add nuw nsw i64 %iv, 1
  %cmp.1 = icmp ne i64 %iv.next, %N
  br i1 %cmp.1, label %for.body, label %exit

exit:
  ret void
}

declare void @llvm.assume(i1)
