//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#include <clc/internal/clc.h>
#include <clc/math/tables.h>

DECLARE_TABLE(float, LOG_INV_TBL_EP_HEAD, 129) = {
    0x1.000000p+1f, 0x1.fc0000p+0f, 0x1.f80000p+0f, 0x1.f40000p+0f,
    0x1.f00000p+0f, 0x1.ec0000p+0f, 0x1.e80000p+0f, 0x1.e40000p+0f,
    0x1.e00000p+0f, 0x1.de0000p+0f, 0x1.da0000p+0f, 0x1.d60000p+0f,
    0x1.d40000p+0f, 0x1.d00000p+0f, 0x1.cc0000p+0f, 0x1.ca0000p+0f,
    0x1.c60000p+0f, 0x1.c20000p+0f, 0x1.c00000p+0f, 0x1.bc0000p+0f,
    0x1.ba0000p+0f, 0x1.b60000p+0f, 0x1.b40000p+0f, 0x1.b20000p+0f,
    0x1.ae0000p+0f, 0x1.ac0000p+0f, 0x1.a80000p+0f, 0x1.a60000p+0f,
    0x1.a40000p+0f, 0x1.a00000p+0f, 0x1.9e0000p+0f, 0x1.9c0000p+0f,
    0x1.980000p+0f, 0x1.960000p+0f, 0x1.940000p+0f, 0x1.920000p+0f,
    0x1.8e0000p+0f, 0x1.8c0000p+0f, 0x1.8a0000p+0f, 0x1.880000p+0f,
    0x1.860000p+0f, 0x1.820000p+0f, 0x1.800000p+0f, 0x1.7e0000p+0f,
    0x1.7c0000p+0f, 0x1.7a0000p+0f, 0x1.780000p+0f, 0x1.760000p+0f,
    0x1.740000p+0f, 0x1.720000p+0f, 0x1.700000p+0f, 0x1.6e0000p+0f,
    0x1.6c0000p+0f, 0x1.6a0000p+0f, 0x1.680000p+0f, 0x1.660000p+0f,
    0x1.640000p+0f, 0x1.620000p+0f, 0x1.600000p+0f, 0x1.5e0000p+0f,
    0x1.5c0000p+0f, 0x1.5a0000p+0f, 0x1.580000p+0f, 0x1.560000p+0f,
    0x1.540000p+0f, 0x1.520000p+0f, 0x1.500000p+0f, 0x1.500000p+0f,
    0x1.4e0000p+0f, 0x1.4c0000p+0f, 0x1.4a0000p+0f, 0x1.480000p+0f,
    0x1.460000p+0f, 0x1.460000p+0f, 0x1.440000p+0f, 0x1.420000p+0f,
    0x1.400000p+0f, 0x1.3e0000p+0f, 0x1.3e0000p+0f, 0x1.3c0000p+0f,
    0x1.3a0000p+0f, 0x1.380000p+0f, 0x1.380000p+0f, 0x1.360000p+0f,
    0x1.340000p+0f, 0x1.320000p+0f, 0x1.320000p+0f, 0x1.300000p+0f,
    0x1.2e0000p+0f, 0x1.2e0000p+0f, 0x1.2c0000p+0f, 0x1.2a0000p+0f,
    0x1.280000p+0f, 0x1.280000p+0f, 0x1.260000p+0f, 0x1.240000p+0f,
    0x1.240000p+0f, 0x1.220000p+0f, 0x1.200000p+0f, 0x1.200000p+0f,
    0x1.1e0000p+0f, 0x1.1e0000p+0f, 0x1.1c0000p+0f, 0x1.1a0000p+0f,
    0x1.1a0000p+0f, 0x1.180000p+0f, 0x1.180000p+0f, 0x1.160000p+0f,
    0x1.140000p+0f, 0x1.140000p+0f, 0x1.120000p+0f, 0x1.120000p+0f,
    0x1.100000p+0f, 0x1.0e0000p+0f, 0x1.0e0000p+0f, 0x1.0c0000p+0f,
    0x1.0c0000p+0f, 0x1.0a0000p+0f, 0x1.0a0000p+0f, 0x1.080000p+0f,
    0x1.080000p+0f, 0x1.060000p+0f, 0x1.060000p+0f, 0x1.040000p+0f,
    0x1.040000p+0f, 0x1.020000p+0f, 0x1.020000p+0f, 0x1.000000p+0f,
    0x1.000000p+0f,
};

CLC_TABLE_FUNCTION(float, LOG_INV_TBL_EP_HEAD, log_inv_tbl_ep_head);

DECLARE_TABLE(float, LOG_INV_TBL_EP_TAIL, 129) = {
    0x0.000000p+0f,  0x1.fc07f0p-14f, 0x1.f81f82p-12f, 0x1.196792p-10f,
    0x1.f07c20p-10f, 0x1.80f660p-9f,  0x1.131ac0p-8f,  0x1.73ac90p-8f,
    0x1.e1e1e2p-8f,  0x1.75b8fep-10f, 0x1.cc0ed8p-9f,  0x1.7b654cp-8f,
    0x1.d41d42p-12f, 0x1.96b1eep-9f,  0x1.856890p-8f,  0x1.2cc158p-10f,
    0x1.1c71c8p-8f,  0x1.f8f01cp-8f,  0x1.c0e070p-9f,  0x1.d2b89ap-8f,
    0x1.9f2298p-9f,  0x1.d6c3dep-8f,  0x1.d0369ep-9f,  0x1.b20364p-15f,
    0x1.286bcap-8f,  0x1.5c06b2p-10f, 0x1.8ef606p-8f,  0x1.a034dap-9f,
    0x1.a41a42p-12f, 0x1.6d3f98p-8f,  0x1.91d2a2p-9f,  0x1.68a772p-11f,
    0x1.99999ap-8f,  0x1.0e4f80p-8f,  0x1.161f9ap-9f,  0x1.f693a2p-13f,
    0x1.9c18fap-8f,  0x1.3018d4p-8f,  0x1.9721eep-9f,  0x1.b97c2ap-10f,
    0x1.861862p-12f, 0x1.c977acp-8f,  0x1.818182p-8f,  0x1.405fd0p-8f,
    0x1.05f418p-8f,  0x1.a4411cp-9f,  0x1.499030p-9f,  0x1.f7390ep-10f,
    0x1.745d18p-10f, 0x1.0a1fd2p-10f, 0x1.702e06p-11f, 0x1.f76b44p-12f,
    0x1.6c16c2p-12f, 0x1.3cd154p-12f, 0x1.681682p-12f, 0x1.ec6a52p-12f,
    0x1.642c86p-11f, 0x1.fd3b80p-11f, 0x1.605816p-10f, 0x1.d6ee34p-10f,
    0x1.310572p-9f,  0x1.80ad60p-9f,  0x1.da4610p-9f,  0x1.1ed3c6p-8f,
    0x1.555556p-8f,  0x1.909490p-8f,  0x1.d07eaep-8f,  0x1.501502p-12f,
    0x1.7829ccp-10f, 0x1.5710e4p-9f,  0x1.fad40ap-9f,  0x1.539e3cp-8f,
    0x1.ae147ap-8f,  0x1.978fecp-13f, 0x1.be1958p-10f, 0x1.acc4bap-9f,
    0x1.414142p-8f,  0x1.b013fcp-8f,  0x1.165e72p-11f, 0x1.32b490p-9f,
    0x1.13b13cp-8f,  0x1.91c2c2p-8f,  0x1.381382p-12f, 0x1.31be7cp-9f,
    0x1.21cfb2p-8f,  0x1.ae45b6p-8f,  0x1.f1a516p-11f, 0x1.a32026p-9f,
    0x1.684bdap-8f,  0x1.2e025cp-15f, 0x1.3f69b0p-9f,  0x1.404ad0p-8f,
    0x1.e4129ep-8f,  0x1.160252p-9f,  0x1.350b88p-8f,  0x1.e22708p-8f,
    0x1.24924ap-9f,  0x1.45678ap-8f,  0x1.fb7812p-8f,  0x1.68e18cp-9f,
    0x1.7047dcp-8f,  0x1.779da0p-11f, 0x1.e0d5b4p-9f,  0x1.b4a404p-8f,
    0x1.ee5846p-10f, 0x1.453808p-8f,  0x1.181182p-12f, 0x1.c0d128p-9f,
    0x1.b1e5f8p-8f,  0x1.0be1c2p-9f,  0x1.5c8114p-8f,  0x1.ac73aep-11f,
    0x1.111112p-8f,  0x1.ef0110p-8f,  0x1.9ead7cp-9f,  0x1.b20a88p-8f,
    0x1.2e29f8p-9f,  0x1.7e6ec2p-8f,  0x1.a0429ap-10f, 0x1.53f390p-8f,
    0x1.084210p-10f, 0x1.3260a4p-8f,  0x1.26e978p-11f, 0x1.197f7ep-8f,
    0x1.041042p-12f, 0x1.091b52p-8f,  0x1.020408p-14f, 0x1.010102p-8f,
    0x0.000000p+0f,
};
CLC_TABLE_FUNCTION(float, LOG_INV_TBL_EP_TAIL, log_inv_tbl_ep_tail);

DECLARE_TABLE(float, LOGE_TBL_LO, 129) = {
    0x0.000000p+0f, 0x1.fe0000p-8f, 0x1.fc0000p-7f, 0x1.7b8000p-6f,
    0x1.f82000p-6f, 0x1.39e000p-5f, 0x1.774000p-5f, 0x1.b42000p-5f,
    0x1.f0a000p-5f, 0x1.164000p-4f, 0x1.340000p-4f, 0x1.51a000p-4f,
    0x1.6f0000p-4f, 0x1.8c2000p-4f, 0x1.a92000p-4f, 0x1.c5e000p-4f,
    0x1.e26000p-4f, 0x1.fec000p-4f, 0x1.0d6000p-3f, 0x1.1b6000p-3f,
    0x1.294000p-3f, 0x1.370000p-3f, 0x1.44c000p-3f, 0x1.526000p-3f,
    0x1.5fe000p-3f, 0x1.6d6000p-3f, 0x1.7aa000p-3f, 0x1.87e000p-3f,
    0x1.952000p-3f, 0x1.a22000p-3f, 0x1.af2000p-3f, 0x1.bc2000p-3f,
    0x1.c8e000p-3f, 0x1.d5c000p-3f, 0x1.e26000p-3f, 0x1.ef0000p-3f,
    0x1.fb8000p-3f, 0x1.040000p-2f, 0x1.0a2000p-2f, 0x1.104000p-2f,
    0x1.166000p-2f, 0x1.1c8000p-2f, 0x1.228000p-2f, 0x1.288000p-2f,
    0x1.2e8000p-2f, 0x1.346000p-2f, 0x1.3a6000p-2f, 0x1.404000p-2f,
    0x1.460000p-2f, 0x1.4be000p-2f, 0x1.51a000p-2f, 0x1.576000p-2f,
    0x1.5d0000p-2f, 0x1.62c000p-2f, 0x1.686000p-2f, 0x1.6e0000p-2f,
    0x1.738000p-2f, 0x1.792000p-2f, 0x1.7ea000p-2f, 0x1.842000p-2f,
    0x1.89a000p-2f, 0x1.8f0000p-2f, 0x1.946000p-2f, 0x1.99c000p-2f,
    0x1.9f2000p-2f, 0x1.a48000p-2f, 0x1.a9c000p-2f, 0x1.af0000p-2f,
    0x1.b44000p-2f, 0x1.b98000p-2f, 0x1.bea000p-2f, 0x1.c3c000p-2f,
    0x1.c8e000p-2f, 0x1.ce0000p-2f, 0x1.d32000p-2f, 0x1.d82000p-2f,
    0x1.dd4000p-2f, 0x1.e24000p-2f, 0x1.e74000p-2f, 0x1.ec2000p-2f,
    0x1.f12000p-2f, 0x1.f60000p-2f, 0x1.fae000p-2f, 0x1.ffc000p-2f,
    0x1.024000p-1f, 0x1.04a000p-1f, 0x1.072000p-1f, 0x1.098000p-1f,
    0x1.0be000p-1f, 0x1.0e4000p-1f, 0x1.108000p-1f, 0x1.12e000p-1f,
    0x1.154000p-1f, 0x1.178000p-1f, 0x1.19e000p-1f, 0x1.1c2000p-1f,
    0x1.1e8000p-1f, 0x1.20c000p-1f, 0x1.230000p-1f, 0x1.254000p-1f,
    0x1.278000p-1f, 0x1.29c000p-1f, 0x1.2c0000p-1f, 0x1.2e4000p-1f,
    0x1.306000p-1f, 0x1.32a000p-1f, 0x1.34e000p-1f, 0x1.370000p-1f,
    0x1.392000p-1f, 0x1.3b6000p-1f, 0x1.3d8000p-1f, 0x1.3fa000p-1f,
    0x1.41c000p-1f, 0x1.43e000p-1f, 0x1.460000p-1f, 0x1.482000p-1f,
    0x1.4a4000p-1f, 0x1.4c6000p-1f, 0x1.4e6000p-1f, 0x1.508000p-1f,
    0x1.52a000p-1f, 0x1.54a000p-1f, 0x1.56a000p-1f, 0x1.58c000p-1f,
    0x1.5ac000p-1f, 0x1.5cc000p-1f, 0x1.5ee000p-1f, 0x1.60e000p-1f,
    0x1.62e000p-1f,
};

DECLARE_TABLE(float, LOGE_TBL_HI, 129) = {
    0x0.000000p+0f,  0x1.535882p-23f, 0x1.5161f8p-20f, 0x1.1b07d4p-18f,
    0x1.361cf0p-19f, 0x1.0f73fcp-18f, 0x1.63d8cap-19f, 0x1.bae232p-18f,
    0x1.86008ap-20f, 0x1.36eea2p-16f, 0x1.d7961ap-16f, 0x1.073f06p-16f,
    0x1.a515cap-17f, 0x1.45d630p-16f, 0x1.b4e92ap-18f, 0x1.523d6ep-18f,
    0x1.076e2ap-16f, 0x1.2263b6p-17f, 0x1.7e7cd0p-15f, 0x1.2ad52ep-15f,
    0x1.52f81ep-15f, 0x1.fc201ep-15f, 0x1.2b6ccap-15f, 0x1.cbc742p-16f,
    0x1.3070a6p-15f, 0x1.fce33ap-20f, 0x1.890210p-15f, 0x1.a06520p-15f,
    0x1.6a73d0p-17f, 0x1.bc1fe2p-15f, 0x1.c94e80p-15f, 0x1.0ce85ap-16f,
    0x1.f7c79ap-15f, 0x1.0b5a7cp-18f, 0x1.076e2ap-15f, 0x1.5b97b8p-16f,
    0x1.186d5ep-15f, 0x1.2ca5a6p-17f, 0x1.24e272p-14f, 0x1.8bf9aep-14f,
    0x1.5cabaap-14f, 0x1.3182d2p-15f, 0x1.41fbcep-14f, 0x1.5a13dep-14f,
    0x1.c575c2p-15f, 0x1.dd9a98p-14f, 0x1.3155a4p-16f, 0x1.843434p-17f,
    0x1.8bc21cp-14f, 0x1.7e55dcp-16f, 0x1.5b0e5ap-15f, 0x1.dc5d14p-16f,
    0x1.bdbf58p-14f, 0x1.05e572p-15f, 0x1.903d36p-15f, 0x1.1d5456p-15f,
    0x1.d7f6bap-14f, 0x1.4abfbap-15f, 0x1.f07704p-15f, 0x1.a3b43cp-15f,
    0x1.9c360ap-17f, 0x1.1e8736p-14f, 0x1.941c20p-14f, 0x1.958116p-14f,
    0x1.23ecbep-14f, 0x1.024396p-16f, 0x1.d93534p-15f, 0x1.293246p-14f,
    0x1.eef798p-15f, 0x1.625a4cp-16f, 0x1.4d9da6p-14f, 0x1.d7a7ccp-14f,
    0x1.f7c79ap-14f, 0x1.af0b84p-14f, 0x1.fcfc00p-15f, 0x1.e7258ap-14f,
    0x1.a81306p-16f, 0x1.1034f8p-15f, 0x1.09875ap-16f, 0x1.99d246p-14f,
    0x1.1ebf5ep-15f, 0x1.23fa70p-14f, 0x1.588f78p-14f, 0x1.2e0856p-14f,
    0x1.52a5a4p-13f, 0x1.df9da8p-13f, 0x1.f2e0e6p-16f, 0x1.bd3d5cp-15f,
    0x1.cb9094p-15f, 0x1.261746p-15f, 0x1.f39e2cp-13f, 0x1.719592p-13f,
    0x1.87a5e8p-14f, 0x1.eabbd8p-13f, 0x1.cd68cep-14f, 0x1.b81f70p-13f,
    0x1.7d79c0p-15f, 0x1.b9a324p-14f, 0x1.30d7bep-13f, 0x1.5bce98p-13f,
    0x1.5e1288p-13f, 0x1.37fec2p-13f, 0x1.d3da88p-14f, 0x1.d0db90p-15f,
    0x1.d7334ep-13f, 0x1.133912p-13f, 0x1.44ece6p-16f, 0x1.17b546p-13f,
    0x1.e0d356p-13f, 0x1.0893fep-14f, 0x1.026a70p-13f, 0x1.5b84d0p-13f,
    0x1.8fe846p-13f, 0x1.9fe2f8p-13f, 0x1.8bc21cp-13f, 0x1.53d1eap-13f,
    0x1.f0bb60p-14f, 0x1.e6bf32p-15f, 0x1.d811b6p-13f, 0x1.13cc00p-13f,
    0x1.6932dep-16f, 0x1.246798p-13f, 0x1.f9d5b2p-13f, 0x1.5b6b9ap-14f,
    0x1.404c34p-13f, 0x1.b1dc6cp-13f, 0x1.54920ap-20f, 0x1.97a23cp-16f,
    0x1.0bfbe8p-15f,
};

CLC_TABLE_FUNCTION(float, LOGE_TBL_LO, loge_tbl_lo);
CLC_TABLE_FUNCTION(float, LOGE_TBL_HI, loge_tbl_hi);

DECLARE_TABLE(float, LOG_INV_TBL, 129) = {
    0x1.000000p+1f, 0x1.fc07f0p+0f, 0x1.f81f82p+0f, 0x1.f4465ap+0f,
    0x1.f07c20p+0f, 0x1.ecc07cp+0f, 0x1.e9131ap+0f, 0x1.e573acp+0f,
    0x1.e1e1e2p+0f, 0x1.de5d6ep+0f, 0x1.dae608p+0f, 0x1.d77b66p+0f,
    0x1.d41d42p+0f, 0x1.d0cb58p+0f, 0x1.cd8568p+0f, 0x1.ca4b30p+0f,
    0x1.c71c72p+0f, 0x1.c3f8f0p+0f, 0x1.c0e070p+0f, 0x1.bdd2b8p+0f,
    0x1.bacf92p+0f, 0x1.b7d6c4p+0f, 0x1.b4e81cp+0f, 0x1.b20364p+0f,
    0x1.af286cp+0f, 0x1.ac5702p+0f, 0x1.a98ef6p+0f, 0x1.a6d01ap+0f,
    0x1.a41a42p+0f, 0x1.a16d40p+0f, 0x1.9ec8eap+0f, 0x1.9c2d14p+0f,
    0x1.99999ap+0f, 0x1.970e50p+0f, 0x1.948b10p+0f, 0x1.920fb4p+0f,
    0x1.8f9c18p+0f, 0x1.8d3018p+0f, 0x1.8acb90p+0f, 0x1.886e60p+0f,
    0x1.861862p+0f, 0x1.83c978p+0f, 0x1.818182p+0f, 0x1.7f4060p+0f,
    0x1.7d05f4p+0f, 0x1.7ad220p+0f, 0x1.78a4c8p+0f, 0x1.767dcep+0f,
    0x1.745d18p+0f, 0x1.724288p+0f, 0x1.702e06p+0f, 0x1.6e1f76p+0f,
    0x1.6c16c2p+0f, 0x1.6a13cep+0f, 0x1.681682p+0f, 0x1.661ec6p+0f,
    0x1.642c86p+0f, 0x1.623fa8p+0f, 0x1.605816p+0f, 0x1.5e75bcp+0f,
    0x1.5c9882p+0f, 0x1.5ac056p+0f, 0x1.58ed24p+0f, 0x1.571ed4p+0f,
    0x1.555556p+0f, 0x1.539094p+0f, 0x1.51d07ep+0f, 0x1.501502p+0f,
    0x1.4e5e0ap+0f, 0x1.4cab88p+0f, 0x1.4afd6ap+0f, 0x1.49539ep+0f,
    0x1.47ae14p+0f, 0x1.460cbcp+0f, 0x1.446f86p+0f, 0x1.42d662p+0f,
    0x1.414142p+0f, 0x1.3fb014p+0f, 0x1.3e22ccp+0f, 0x1.3c995ap+0f,
    0x1.3b13b2p+0f, 0x1.3991c2p+0f, 0x1.381382p+0f, 0x1.3698e0p+0f,
    0x1.3521d0p+0f, 0x1.33ae46p+0f, 0x1.323e34p+0f, 0x1.30d190p+0f,
    0x1.2f684cp+0f, 0x1.2e025cp+0f, 0x1.2c9fb4p+0f, 0x1.2b404ap+0f,
    0x1.29e412p+0f, 0x1.288b02p+0f, 0x1.27350cp+0f, 0x1.25e228p+0f,
    0x1.24924ap+0f, 0x1.234568p+0f, 0x1.21fb78p+0f, 0x1.20b470p+0f,
    0x1.1f7048p+0f, 0x1.1e2ef4p+0f, 0x1.1cf06ap+0f, 0x1.1bb4a4p+0f,
    0x1.1a7b96p+0f, 0x1.194538p+0f, 0x1.181182p+0f, 0x1.16e068p+0f,
    0x1.15b1e6p+0f, 0x1.1485f0p+0f, 0x1.135c82p+0f, 0x1.12358ep+0f,
    0x1.111112p+0f, 0x1.0fef02p+0f, 0x1.0ecf56p+0f, 0x1.0db20ap+0f,
    0x1.0c9714p+0f, 0x1.0b7e6ep+0f, 0x1.0a6810p+0f, 0x1.0953f4p+0f,
    0x1.084210p+0f, 0x1.073260p+0f, 0x1.0624dep+0f, 0x1.051980p+0f,
    0x1.041042p+0f, 0x1.03091cp+0f, 0x1.020408p+0f, 0x1.010102p+0f,
    0x1.000000p+0f,
};

CLC_TABLE_FUNCTION(float, LOG_INV_TBL, log_inv_tbl);

DECLARE_TABLE(float2, LOG2_TBL, 129) = {
    (float2)(0x0.000000p+0f, 0x0.000000p+0f),
    (float2)(0x1.6f8000p-7f, 0x1.942dbap-17f),
    (float2)(0x1.6e0000p-6f, 0x1.e5a170p-16f),
    (float2)(0x1.118000p-5f, 0x1.347544p-15f),
    (float2)(0x1.6b8000p-5f, 0x1.69bac6p-16f),
    (float2)(0x1.c48000p-5f, 0x1.7eae42p-15f),
    (float2)(0x1.0e8000p-4f, 0x1.9c4fd0p-15f),
    (float2)(0x1.3a8000p-4f, 0x1.17ee92p-15f),
    (float2)(0x1.660000p-4f, 0x1.fb7d64p-15f),
    (float2)(0x1.918000p-4f, 0x1.42dc8cp-17f),
    (float2)(0x1.bc8000p-4f, 0x1.0902b6p-18f),
    (float2)(0x1.e70000p-4f, 0x1.7608bep-15f),
    (float2)(0x1.088000p-3f, 0x1.162336p-13f),
    (float2)(0x1.1d8000p-3f, 0x1.3465d4p-13f),
    (float2)(0x1.328000p-3f, 0x1.74f13cp-14f),
    (float2)(0x1.470000p-3f, 0x1.aa7e60p-13f),
    (float2)(0x1.5c0000p-3f, 0x1.a39fbcp-19f),
    (float2)(0x1.700000p-3f, 0x1.d0b53ap-13f),
    (float2)(0x1.848000p-3f, 0x1.0af40ap-13f),
    (float2)(0x1.988000p-3f, 0x1.b741dep-13f),
    (float2)(0x1.ac8000p-3f, 0x1.d78b6cp-13f),
    (float2)(0x1.c08000p-3f, 0x1.6db376p-13f),
    (float2)(0x1.d48000p-3f, 0x1.ee4c32p-15f),
    (float2)(0x1.e80000p-3f, 0x1.02f9d2p-13f),
    (float2)(0x1.fb8000p-3f, 0x1.05ae40p-13f),
    (float2)(0x1.078000p-2f, 0x1.0adbb0p-14f),
    (float2)(0x1.110000p-2f, 0x1.83ed68p-13f),
    (float2)(0x1.1a8000p-2f, 0x1.016ca4p-12f),
    (float2)(0x1.240000p-2f, 0x1.01eac2p-12f),
    (float2)(0x1.2d8000p-2f, 0x1.887e26p-13f),
    (float2)(0x1.370000p-2f, 0x1.24cea4p-14f),
    (float2)(0x1.400000p-2f, 0x1.918ec6p-12f),
    (float2)(0x1.498000p-2f, 0x1.3c25e6p-13f),
    (float2)(0x1.528000p-2f, 0x1.6f7f12p-12f),
    (float2)(0x1.5c0000p-2f, 0x1.a39fbcp-18f),
    (float2)(0x1.650000p-2f, 0x1.8fe466p-14f),
    (float2)(0x1.6e0000p-2f, 0x1.10e6cep-13f),
    (float2)(0x1.770000p-2f, 0x1.d2ba7ep-14f),
    (float2)(0x1.800000p-2f, 0x1.4ac62cp-15f),
    (float2)(0x1.888000p-2f, 0x1.a71cb8p-12f),
    (float2)(0x1.918000p-2f, 0x1.dd448ep-13f),
    (float2)(0x1.9a8000p-2f, 0x1.1c8f10p-21f),
    (float2)(0x1.a30000p-2f, 0x1.bb053ep-13f),
    (float2)(0x1.ab8000p-2f, 0x1.861e5ep-12f),
    (float2)(0x1.b40000p-2f, 0x1.fafdcep-12f),
    (float2)(0x1.bd0000p-2f, 0x1.e5d3cep-15f),
    (float2)(0x1.c58000p-2f, 0x1.2fad28p-14f),
    (float2)(0x1.ce0000p-2f, 0x1.492474p-15f),
    (float2)(0x1.d60000p-2f, 0x1.d4f80cp-12f),
    (float2)(0x1.de8000p-2f, 0x1.4ff510p-12f),
    (float2)(0x1.e70000p-2f, 0x1.3550f2p-13f),
    (float2)(0x1.ef0000p-2f, 0x1.b59ccap-12f),
    (float2)(0x1.f78000p-2f, 0x1.42b464p-13f),
    (float2)(0x1.ff8000p-2f, 0x1.5e66a0p-12f),
    (float2)(0x1.038000p-1f, 0x1.f6a2e4p-11f),
    (float2)(0x1.080000p-1f, 0x1.39e4fep-14f),
    (float2)(0x1.0c0000p-1f, 0x1.0500d6p-13f),
    (float2)(0x1.100000p-1f, 0x1.13b152p-13f),
    (float2)(0x1.140000p-1f, 0x1.93f542p-14f),
    (float2)(0x1.180000p-1f, 0x1.467b94p-16f),
    (float2)(0x1.1b8000p-1f, 0x1.cc47a4p-11f),
    (float2)(0x1.1f8000p-1f, 0x1.78f4c2p-11f),
    (float2)(0x1.238000p-1f, 0x1.107508p-11f),
    (float2)(0x1.278000p-1f, 0x1.2602c2p-12f),
    (float2)(0x1.2b8000p-1f, 0x1.a39fbcp-20f),
    (float2)(0x1.2f0000p-1f, 0x1.5a1d7ap-11f),
    (float2)(0x1.330000p-1f, 0x1.3e355ap-12f),
    (float2)(0x1.368000p-1f, 0x1.cffedap-11f),
    (float2)(0x1.3a8000p-1f, 0x1.d9fd50p-12f),
    (float2)(0x1.3e0000p-1f, 0x1.f64de6p-11f),
    (float2)(0x1.420000p-1f, 0x1.d83f4cp-12f),
    (float2)(0x1.458000p-1f, 0x1.cea628p-11f),
    (float2)(0x1.498000p-1f, 0x1.3c25e6p-12f),
    (float2)(0x1.4d0000p-1f, 0x1.5a96ccp-11f),
    (float2)(0x1.510000p-1f, 0x1.18708ap-17f),
    (float2)(0x1.548000p-1f, 0x1.374652p-12f),
    (float2)(0x1.580000p-1f, 0x1.2089a6p-11f),
    (float2)(0x1.5b8000p-1f, 0x1.93432cp-11f),
    (float2)(0x1.5f0000p-1f, 0x1.f3fd06p-11f),
    (float2)(0x1.630000p-1f, 0x1.0b8f54p-13f),
    (float2)(0x1.668000p-1f, 0x1.004722p-12f),
    (float2)(0x1.6a0000p-1f, 0x1.57cf2cp-12f),
    (float2)(0x1.6d8000p-1f, 0x1.8cb53ap-12f),
    (float2)(0x1.710000p-1f, 0x1.9f4d8ap-12f),
    (float2)(0x1.748000p-1f, 0x1.8feb26p-12f),
    (float2)(0x1.780000p-1f, 0x1.5edfeep-12f),
    (float2)(0x1.7b8000p-1f, 0x1.0c7c9ap-12f),
    (float2)(0x1.7f0000p-1f, 0x1.322182p-13f),
    (float2)(0x1.828000p-1f, 0x1.3ab7cep-18f),
    (float2)(0x1.858000p-1f, 0x1.a82c2cp-11f),
    (float2)(0x1.890000p-1f, 0x1.3dd2c0p-11f),
    (float2)(0x1.8c8000p-1f, 0x1.871da4p-12f),
    (float2)(0x1.900000p-1f, 0x1.cc2c00p-14f),
    (float2)(0x1.930000p-1f, 0x1.9fdb68p-11f),
    (float2)(0x1.968000p-1f, 0x1.ed6956p-12f),
    (float2)(0x1.9a0000p-1f, 0x1.f1a760p-14f),
    (float2)(0x1.9d0000p-1f, 0x1.767f54p-11f),
    (float2)(0x1.a08000p-1f, 0x1.3f6d26p-12f),
    (float2)(0x1.a38000p-1f, 0x1.b9fce2p-11f),
    (float2)(0x1.a70000p-1f, 0x1.8ae816p-12f),
    (float2)(0x1.aa0000p-1f, 0x1.c23d60p-11f),
    (float2)(0x1.ad8000p-1f, 0x1.60f388p-12f),
    (float2)(0x1.b08000p-1f, 0x1.9049aep-11f),
    (float2)(0x1.b40000p-1f, 0x1.8734a8p-13f),
    (float2)(0x1.b70000p-1f, 0x1.2523d4p-11f),
    (float2)(0x1.ba0000p-1f, 0x1.da6ce6p-11f),
    (float2)(0x1.bd8000p-1f, 0x1.038e62p-12f),
    (float2)(0x1.c08000p-1f, 0x1.1b511ep-11f),
    (float2)(0x1.c38000p-1f, 0x1.a728b8p-11f),
    (float2)(0x1.c70000p-1f, 0x1.2b5d22p-14f),
    (float2)(0x1.ca0000p-1f, 0x1.2c6e54p-12f),
    (float2)(0x1.cd0000p-1f, 0x1.f35064p-12f),
    (float2)(0x1.d00000p-1f, 0x1.4fdb48p-11f),
    (float2)(0x1.d30000p-1f, 0x1.98ec9ep-11f),
    (float2)(0x1.d60000p-1f, 0x1.d4f80cp-11f),
    (float2)(0x1.d98000p-1f, 0x1.0643d6p-17f),
    (float2)(0x1.dc8000p-1f, 0x1.33567ep-14f),
    (float2)(0x1.df8000p-1f, 0x1.e0410cp-14f),
    (float2)(0x1.e28000p-1f, 0x1.142e0ep-13f),
    (float2)(0x1.e58000p-1f, 0x1.063c88p-13f),
    (float2)(0x1.e88000p-1f, 0x1.8d66c4p-14f),
    (float2)(0x1.eb8000p-1f, 0x1.57e32ap-15f),
    (float2)(0x1.ee0000p-1f, 0x1.ed1c6cp-11f),
    (float2)(0x1.f10000p-1f, 0x1.b8a076p-11f),
    (float2)(0x1.f40000p-1f, 0x1.7822f2p-11f),
    (float2)(0x1.f70000p-1f, 0x1.2bbc3ap-11f),
    (float2)(0x1.fa0000p-1f, 0x1.a708bap-12f),
    (float2)(0x1.fd0000p-1f, 0x1.be4c7ep-13f),
    (float2)(0x1.000000p+0f, 0x0.000000p+0f)
};

TABLE_FUNCTION(float2, LOG2_TBL, log2_tbl);

DECLARE_TABLE(float2, LOG10_TBL, 129) = {
    (float2)(0x0.000000p+0f, 0x0.000000p+0f),
    (float2)(0x1.ba8000p-9f, 0x1.f51c88p-19f),
    (float2)(0x1.b90000p-8f, 0x1.1da93ep-18f),
    (float2)(0x1.498000p-7f, 0x1.8428a2p-18f),
    (float2)(0x1.b58000p-7f, 0x1.a423acp-17f),
    (float2)(0x1.108000p-6f, 0x1.41d422p-17f),
    (float2)(0x1.458000p-6f, 0x1.d3d6b2p-16f),
    (float2)(0x1.7a8000p-6f, 0x1.70f7cep-16f),
    (float2)(0x1.af0000p-6f, 0x1.7e4ac0p-16f),
    (float2)(0x1.e38000p-6f, 0x1.ab2f40p-24f),
    (float2)(0x1.0b8000p-5f, 0x1.00d40ap-16f),
    (float2)(0x1.250000p-5f, 0x1.40b03ep-15f),
    (float2)(0x1.3e8000p-5f, 0x1.446668p-15f),
    (float2)(0x1.580000p-5f, 0x1.1c7758p-16f),
    (float2)(0x1.710000p-5f, 0x1.20d09ep-15f),
    (float2)(0x1.8a0000p-5f, 0x1.fd6f5cp-16f),
    (float2)(0x1.a30000p-5f, 0x1.53ac12p-18f),
    (float2)(0x1.bb8000p-5f, 0x1.4d02c6p-16f),
    (float2)(0x1.d40000p-5f, 0x1.d5164ep-17f),
    (float2)(0x1.ec0000p-5f, 0x1.991facp-15f),
    (float2)(0x1.020000p-4f, 0x1.0a307cp-14f),
    (float2)(0x1.0e0000p-4f, 0x1.e94ec0p-15f),
    (float2)(0x1.1a0000p-4f, 0x1.1a22a8p-15f),
    (float2)(0x1.258000p-4f, 0x1.d4857ap-14f),
    (float2)(0x1.318000p-4f, 0x1.982ae2p-15f),
    (float2)(0x1.3d0000p-4f, 0x1.74cd70p-14f),
    (float2)(0x1.488000p-4f, 0x1.cfb476p-14f),
    (float2)(0x1.540000p-4f, 0x1.ddcc64p-14f),
    (float2)(0x1.5f8000p-4f, 0x1.a01222p-14f),
    (float2)(0x1.6b0000p-4f, 0x1.177dbcp-14f),
    (float2)(0x1.768000p-4f, 0x1.140a24p-16f),
    (float2)(0x1.818000p-4f, 0x1.298f40p-14f),
    (float2)(0x1.8c8000p-4f, 0x1.c60e20p-14f),
    (float2)(0x1.980000p-4f, 0x1.b65052p-18f),
    (float2)(0x1.a30000p-4f, 0x1.53ac12p-17f),
    (float2)(0x1.ad8000p-4f, 0x1.f41d04p-14f),
    (float2)(0x1.b88000p-4f, 0x1.7934eap-14f),
    (float2)(0x1.c38000p-4f, 0x1.75252ep-15f),
    (float2)(0x1.ce0000p-4f, 0x1.b90790p-14f),
    (float2)(0x1.d90000p-4f, 0x1.d5866ap-16f),
    (float2)(0x1.e38000p-4f, 0x1.e0d586p-15f),
    (float2)(0x1.ee0000p-4f, 0x1.2ae984p-14f),
    (float2)(0x1.f88000p-4f, 0x1.25a0d0p-14f),
    (float2)(0x1.018000p-3f, 0x1.c2a064p-15f),
    (float2)(0x1.068000p-3f, 0x1.2f59e8p-13f),
    (float2)(0x1.0b8000p-3f, 0x1.cf424cp-13f),
    (float2)(0x1.110000p-3f, 0x1.42f080p-15f),
    (float2)(0x1.160000p-3f, 0x1.684156p-14f),
    (float2)(0x1.1b0000p-3f, 0x1.f38f64p-14f),
    (float2)(0x1.200000p-3f, 0x1.22077ap-13f),
    (float2)(0x1.250000p-3f, 0x1.2d34d6p-13f),
    (float2)(0x1.2a0000p-3f, 0x1.1ba328p-13f),
    (float2)(0x1.2f0000p-3f, 0x1.db48e2p-14f),
    (float2)(0x1.340000p-3f, 0x1.4712a0p-14f),
    (float2)(0x1.390000p-3f, 0x1.ed0894p-16f),
    (float2)(0x1.3d8000p-3f, 0x1.bc39b6p-13f),
    (float2)(0x1.428000p-3f, 0x1.1f9ff8p-13f),
    (float2)(0x1.478000p-3f, 0x1.a07d3ap-15f),
    (float2)(0x1.4c0000p-3f, 0x1.9601fap-13f),
    (float2)(0x1.510000p-3f, 0x1.532214p-14f),
    (float2)(0x1.558000p-3f, 0x1.a31462p-13f),
    (float2)(0x1.5a8000p-3f, 0x1.05a584p-14f),
    (float2)(0x1.5f0000p-3f, 0x1.4911c8p-13f),
    (float2)(0x1.638000p-3f, 0x1.f615fep-13f),
    (float2)(0x1.688000p-3f, 0x1.1445b0p-14f),
    (float2)(0x1.6d0000p-3f, 0x1.057abcp-13f),
    (float2)(0x1.718000p-3f, 0x1.685f0ap-13f),
    (float2)(0x1.760000p-3f, 0x1.b31022p-13f),
    (float2)(0x1.7a8000p-3f, 0x1.e5cd62p-13f),
    (float2)(0x1.7f8000p-3f, 0x1.aa6ca8p-22f),
    (float2)(0x1.840000p-3f, 0x1.1944bcp-19f),
    (float2)(0x1.880000p-3f, 0x1.f0b980p-13f),
    (float2)(0x1.8c8000p-3f, 0x1.c60e20p-13f),
    (float2)(0x1.910000p-3f, 0x1.849daep-13f),
    (float2)(0x1.958000p-3f, 0x1.2ca202p-13f),
    (float2)(0x1.9a0000p-3f, 0x1.7ca842p-14f),
    (float2)(0x1.9e8000p-3f, 0x1.cf6180p-16f),
    (float2)(0x1.a28000p-3f, 0x1.9fa186p-13f),
    (float2)(0x1.a70000p-3f, 0x1.df5554p-14f),
    (float2)(0x1.ab8000p-3f, 0x1.51eaccp-16f),
    (float2)(0x1.af8000p-3f, 0x1.4f8e88p-13f),
    (float2)(0x1.b40000p-3f, 0x1.7f49aap-15f),
    (float2)(0x1.b80000p-3f, 0x1.5b3c72p-13f),
    (float2)(0x1.bc8000p-3f, 0x1.07fd5cp-15f),
    (float2)(0x1.c08000p-3f, 0x1.144d18p-13f),
    (float2)(0x1.c48000p-3f, 0x1.d25700p-13f),
    (float2)(0x1.c90000p-3f, 0x1.f1369ep-15f),
    (float2)(0x1.cd0000p-3f, 0x1.1260fap-13f),
    (float2)(0x1.d10000p-3f, 0x1.94c038p-13f),
    (float2)(0x1.d58000p-3f, 0x1.ccfdb8p-20f),
    (float2)(0x1.d98000p-3f, 0x1.7c70dap-15f),
    (float2)(0x1.dd8000p-3f, 0x1.4ee87ap-14f),
    (float2)(0x1.e18000p-3f, 0x1.b99d86p-14f),
    (float2)(0x1.e58000p-3f, 0x1.feafc0p-14f),
    (float2)(0x1.e98000p-3f, 0x1.0f3b16p-13f),
    (float2)(0x1.ed8000p-3f, 0x1.0ca34cp-13f),
    (float2)(0x1.f18000p-3f, 0x1.ef75b2p-14f),
    (float2)(0x1.f58000p-3f, 0x1.a15704p-14f),
    (float2)(0x1.f98000p-3f, 0x1.2f3cfap-14f),
    (float2)(0x1.fd8000p-3f, 0x1.32f1dcp-15f),
    (float2)(0x1.008000p-2f, 0x1.f02d90p-13f),
    (float2)(0x1.028000p-2f, 0x1.821964p-13f),
    (float2)(0x1.048000p-2f, 0x1.02a708p-13f),
    (float2)(0x1.068000p-2f, 0x1.c7f450p-15f),
    (float2)(0x1.080000p-2f, 0x1.e820cap-12f),
    (float2)(0x1.0a0000p-2f, 0x1.8ecd14p-12f),
    (float2)(0x1.0c0000p-2f, 0x1.2d15f4p-12f),
    (float2)(0x1.0e0000p-2f, 0x1.861b72p-13f),
    (float2)(0x1.100000p-2f, 0x1.4319e6p-14f),
    (float2)(0x1.118000p-2f, 0x1.d6520ep-12f),
    (float2)(0x1.138000p-2f, 0x1.53c218p-12f),
    (float2)(0x1.158000p-2f, 0x1.925000p-13f),
    (float2)(0x1.178000p-2f, 0x1.b4a7a2p-15f),
    (float2)(0x1.190000p-2f, 0x1.9c19eep-12f),
    (float2)(0x1.1b0000p-2f, 0x1.f38f64p-13f),
    (float2)(0x1.1d0000p-2f, 0x1.3ebb32p-14f),
    (float2)(0x1.1e8000p-2f, 0x1.9ddf96p-12f),
    (float2)(0x1.208000p-2f, 0x1.c8d472p-13f),
    (float2)(0x1.228000p-2f, 0x1.1af536p-15f),
    (float2)(0x1.240000p-2f, 0x1.5acca0p-12f),
    (float2)(0x1.260000p-2f, 0x1.158770p-13f),
    (float2)(0x1.278000p-2f, 0x1.b35350p-12f),
    (float2)(0x1.298000p-2f, 0x1.a91532p-13f),
    (float2)(0x1.2b0000p-2f, 0x1.ee7896p-12f),
    (float2)(0x1.2d0000p-2f, 0x1.012c1cp-12f),
    (float2)(0x1.2f0000p-2f, 0x1.967ab4p-17f),
    (float2)(0x1.308000p-2f, 0x1.111e3cp-12f),
    (float2)(0x1.328000p-2f, 0x1.cf340ep-17f),
    (float2)(0x1.340000p-2f, 0x1.04d426p-12f),
};

TABLE_FUNCTION(float2, LOG10_TBL, log10_tbl);


DECLARE_TABLE(float, EXP_TBL, 65) = {
    0x1.000000p+0f, 0x1.02c9a4p+0f, 0x1.059b0ep+0f, 0x1.087452p+0f,
    0x1.0b5586p+0f, 0x1.0e3ec4p+0f, 0x1.11301ep+0f, 0x1.1429aap+0f,
    0x1.172b84p+0f, 0x1.1a35bep+0f, 0x1.1d4874p+0f, 0x1.2063b8p+0f,
    0x1.2387a6p+0f, 0x1.26b456p+0f, 0x1.29e9e0p+0f, 0x1.2d285ap+0f,
    0x1.306fe0p+0f, 0x1.33c08cp+0f, 0x1.371a74p+0f, 0x1.3a7db4p+0f,
    0x1.3dea64p+0f, 0x1.4160a2p+0f, 0x1.44e086p+0f, 0x1.486a2cp+0f,
    0x1.4bfdaep+0f, 0x1.4f9b28p+0f, 0x1.5342b6p+0f, 0x1.56f474p+0f,
    0x1.5ab07ep+0f, 0x1.5e76f2p+0f, 0x1.6247ecp+0f, 0x1.662388p+0f,
    0x1.6a09e6p+0f, 0x1.6dfb24p+0f, 0x1.71f75ep+0f, 0x1.75feb6p+0f,
    0x1.7a1148p+0f, 0x1.7e2f34p+0f, 0x1.82589ap+0f, 0x1.868d9ap+0f,
    0x1.8ace54p+0f, 0x1.8f1aeap+0f, 0x1.93737cp+0f, 0x1.97d82ap+0f,
    0x1.9c4918p+0f, 0x1.a0c668p+0f, 0x1.a5503cp+0f, 0x1.a9e6b6p+0f,
    0x1.ae89fap+0f, 0x1.b33a2cp+0f, 0x1.b7f770p+0f, 0x1.bcc1eap+0f,
    0x1.c199bep+0f, 0x1.c67f12p+0f, 0x1.cb720ep+0f, 0x1.d072d4p+0f,
    0x1.d5818ep+0f, 0x1.da9e60p+0f, 0x1.dfc974p+0f, 0x1.e502eep+0f,
    0x1.ea4afap+0f, 0x1.efa1bep+0f, 0x1.f50766p+0f, 0x1.fa7c18p+0f,
    0x1.000000p+1f,
};

CLC_TABLE_FUNCTION(float, EXP_TBL, exp_tbl);

DECLARE_TABLE(float, EXP_TBL_EP_HEAD, 65) = {
    0x1.000000p+0f, 0x1.02c000p+0f, 0x1.058000p+0f, 0x1.084000p+0f,
    0x1.0b4000p+0f, 0x1.0e0000p+0f, 0x1.110000p+0f, 0x1.140000p+0f,
    0x1.170000p+0f, 0x1.1a0000p+0f, 0x1.1d4000p+0f, 0x1.204000p+0f,
    0x1.238000p+0f, 0x1.268000p+0f, 0x1.29c000p+0f, 0x1.2d0000p+0f,
    0x1.304000p+0f, 0x1.33c000p+0f, 0x1.370000p+0f, 0x1.3a4000p+0f,
    0x1.3dc000p+0f, 0x1.414000p+0f, 0x1.44c000p+0f, 0x1.484000p+0f,
    0x1.4bc000p+0f, 0x1.4f8000p+0f, 0x1.534000p+0f, 0x1.56c000p+0f,
    0x1.5a8000p+0f, 0x1.5e4000p+0f, 0x1.624000p+0f, 0x1.660000p+0f,
    0x1.6a0000p+0f, 0x1.6dc000p+0f, 0x1.71c000p+0f, 0x1.75c000p+0f,
    0x1.7a0000p+0f, 0x1.7e0000p+0f, 0x1.824000p+0f, 0x1.868000p+0f,
    0x1.8ac000p+0f, 0x1.8f0000p+0f, 0x1.934000p+0f, 0x1.97c000p+0f,
    0x1.9c4000p+0f, 0x1.a0c000p+0f, 0x1.a54000p+0f, 0x1.a9c000p+0f,
    0x1.ae8000p+0f, 0x1.b30000p+0f, 0x1.b7c000p+0f, 0x1.bcc000p+0f,
    0x1.c18000p+0f, 0x1.c64000p+0f, 0x1.cb4000p+0f, 0x1.d04000p+0f,
    0x1.d58000p+0f, 0x1.da8000p+0f, 0x1.dfc000p+0f, 0x1.e50000p+0f,
    0x1.ea4000p+0f, 0x1.ef8000p+0f, 0x1.f50000p+0f, 0x1.fa4000p+0f,
    0x1.000000p+1f,
};

CLC_TABLE_FUNCTION(float, EXP_TBL_EP_HEAD, exp_tbl_ep_head);

DECLARE_TABLE(float, EXP_TBL_EP_TAIL, 65) = {
    0x0.000000p+0f,  0x1.347ceep-13f, 0x1.b0d314p-12f, 0x1.a28c3ap-11f,
    0x1.586cf8p-12f, 0x1.f61968p-11f, 0x1.80e808p-11f, 0x1.4d5754p-11f,
    0x1.5c1e3ep-11f, 0x1.adf5b6p-11f, 0x1.0e62d0p-13f, 0x1.1dc430p-11f,
    0x1.e9b9d4p-14f, 0x1.a2b2f0p-11f, 0x1.4efa8ep-11f, 0x1.42d372p-11f,
    0x1.7f0518p-11f, 0x1.164c82p-17f, 0x1.a7373ap-12f, 0x1.ed9a72p-11f,
    0x1.532608p-11f, 0x1.0510fap-11f, 0x1.043030p-11f, 0x1.515ae0p-11f,
    0x1.ed6a9ap-11f, 0x1.b2769cp-12f, 0x1.5ab4eap-15f, 0x1.a39b5ap-11f,
    0x1.83eea4p-11f, 0x1.b78ad6p-11f, 0x1.fac0e8p-14f, 0x1.1c412ap-11f,
    0x1.3cccfep-13f, 0x1.d91e32p-11f, 0x1.baf476p-11f, 0x1.f5ab20p-11f,
    0x1.1473eap-12f, 0x1.799b66p-11f, 0x1.89994cp-12f, 0x1.b33688p-13f,
    0x1.ca8454p-13f, 0x1.ae9914p-12f, 0x1.9bd866p-11f, 0x1.829fdep-12f,
    0x1.230546p-13f, 0x1.99ed76p-14f, 0x1.03b23ep-12f, 0x1.35aabcp-11f,
    0x1.3f32b4p-13f, 0x1.d15c26p-11f, 0x1.bb797cp-11f, 0x1.e904bcp-16f,
    0x1.9bdd84p-12f, 0x1.f8972ap-11f, 0x1.906e76p-11f, 0x1.96a502p-11f,
    0x1.8dcfbap-16f, 0x1.e603dap-12f, 0x1.2e66f6p-13f, 0x1.773c58p-15f,
    0x1.5f4548p-13f, 0x1.0df730p-11f, 0x1.d96db8p-14f, 0x1.e0c0cep-11f,
    0x0.000000p+0f,
};

CLC_TABLE_FUNCTION(float, EXP_TBL_EP_TAIL, exp_tbl_ep_tail);

DECLARE_TABLE(float, CBRT_TBL_HEAD, 129) = {
    0x1.000000p+0f, 0x1.008000p+0f, 0x1.014000p+0f, 0x1.01c000p+0f,
    0x1.028000p+0f, 0x1.034000p+0f, 0x1.03c000p+0f, 0x1.048000p+0f,
    0x1.050000p+0f, 0x1.05c000p+0f, 0x1.068000p+0f, 0x1.070000p+0f,
    0x1.07c000p+0f, 0x1.084000p+0f, 0x1.090000p+0f, 0x1.098000p+0f,
    0x1.0a4000p+0f, 0x1.0ac000p+0f, 0x1.0b4000p+0f, 0x1.0c0000p+0f,
    0x1.0c8000p+0f, 0x1.0d4000p+0f, 0x1.0dc000p+0f, 0x1.0e4000p+0f,
    0x1.0f0000p+0f, 0x1.0f8000p+0f, 0x1.104000p+0f, 0x1.10c000p+0f,
    0x1.114000p+0f, 0x1.120000p+0f, 0x1.128000p+0f, 0x1.130000p+0f,
    0x1.13c000p+0f, 0x1.144000p+0f, 0x1.14c000p+0f, 0x1.154000p+0f,
    0x1.160000p+0f, 0x1.168000p+0f, 0x1.170000p+0f, 0x1.178000p+0f,
    0x1.184000p+0f, 0x1.18c000p+0f, 0x1.194000p+0f, 0x1.19c000p+0f,
    0x1.1a4000p+0f, 0x1.1b0000p+0f, 0x1.1b8000p+0f, 0x1.1c0000p+0f,
    0x1.1c8000p+0f, 0x1.1d0000p+0f, 0x1.1d8000p+0f, 0x1.1e4000p+0f,
    0x1.1ec000p+0f, 0x1.1f4000p+0f, 0x1.1fc000p+0f, 0x1.204000p+0f,
    0x1.20c000p+0f, 0x1.214000p+0f, 0x1.21c000p+0f, 0x1.224000p+0f,
    0x1.22c000p+0f, 0x1.238000p+0f, 0x1.240000p+0f, 0x1.248000p+0f,
    0x1.250000p+0f, 0x1.258000p+0f, 0x1.260000p+0f, 0x1.268000p+0f,
    0x1.270000p+0f, 0x1.278000p+0f, 0x1.280000p+0f, 0x1.288000p+0f,
    0x1.290000p+0f, 0x1.298000p+0f, 0x1.2a0000p+0f, 0x1.2a8000p+0f,
    0x1.2b0000p+0f, 0x1.2b8000p+0f, 0x1.2c0000p+0f, 0x1.2c4000p+0f,
    0x1.2cc000p+0f, 0x1.2d4000p+0f, 0x1.2dc000p+0f, 0x1.2e4000p+0f,
    0x1.2ec000p+0f, 0x1.2f4000p+0f, 0x1.2fc000p+0f, 0x1.304000p+0f,
    0x1.30c000p+0f, 0x1.314000p+0f, 0x1.318000p+0f, 0x1.320000p+0f,
    0x1.328000p+0f, 0x1.330000p+0f, 0x1.338000p+0f, 0x1.340000p+0f,
    0x1.344000p+0f, 0x1.34c000p+0f, 0x1.354000p+0f, 0x1.35c000p+0f,
    0x1.364000p+0f, 0x1.36c000p+0f, 0x1.370000p+0f, 0x1.378000p+0f,
    0x1.380000p+0f, 0x1.388000p+0f, 0x1.390000p+0f, 0x1.394000p+0f,
    0x1.39c000p+0f, 0x1.3a4000p+0f, 0x1.3ac000p+0f, 0x1.3b0000p+0f,
    0x1.3b8000p+0f, 0x1.3c0000p+0f, 0x1.3c8000p+0f, 0x1.3cc000p+0f,
    0x1.3d4000p+0f, 0x1.3dc000p+0f, 0x1.3e4000p+0f, 0x1.3e8000p+0f,
    0x1.3f0000p+0f, 0x1.3f8000p+0f, 0x1.400000p+0f, 0x1.404000p+0f,
    0x1.40c000p+0f, 0x1.414000p+0f, 0x1.418000p+0f, 0x1.420000p+0f,
    0x1.428000p+0f,
};

CLC_TABLE_FUNCTION(float, CBRT_TBL_HEAD, cbrt_tbl_head);

DECLARE_TABLE(float, CBRT_TBL_TAIL, 129) = {
    0x0.000000p+0f,  0x1.51cb0ap-11f, 0x1.39221ep-12f, 0x1.e06908p-11f,
    0x1.1d6978p-11f, 0x1.4ea1bep-13f, 0x1.833b8ep-11f, 0x1.587002p-12f,
    0x1.ceb290p-11f, 0x1.d57f34p-12f, 0x1.cc53acp-21f, 0x1.0fe098p-11f,
    0x1.91b586p-15f, 0x1.1c362ep-11f, 0x1.94398ep-15f, 0x1.1055bcp-11f,
    0x1.7e63cap-19f, 0x1.d99e1ap-12f, 0x1.d258dep-11f, 0x1.645962p-12f,
    0x1.8c5b0ep-11f, 0x1.83d0c8p-13f, 0x1.300812p-11f, 0x1.f9a65ap-11f,
    0x1.7bbcd8p-12f, 0x1.7cbf68p-11f, 0x1.b2c166p-14f, 0x1.d56ea4p-12f,
    0x1.99eb32p-11f, 0x1.1007a2p-13f, 0x1.d212aap-12f, 0x1.890f18p-11f,
    0x1.2104e2p-14f, 0x1.74961ep-12f, 0x1.4b9b66p-11f, 0x1.d81e66p-11f,
    0x1.7f825cp-13f, 0x1.c5dca2p-12f, 0x1.6153bap-11f, 0x1.db1cc2p-11f,
    0x1.4154b0p-13f, 0x1.821114p-12f, 0x1.2d4240p-11f, 0x1.950d82p-11f,
    0x1.f8755cp-11f, 0x1.5e12a4p-13f, 0x1.648c38p-12f, 0x1.08c43ep-11f,
    0x1.5b0970p-11f, 0x1.a91fe8p-11f, 0x1.f311b6p-11f, 0x1.c74618p-14f,
    0x1.eabb54p-13f, 0x1.70db14p-12f, 0x1.e45cbcp-12f, 0x1.27faa6p-11f,
    0x1.59db98p-11f, 0x1.87da46p-11f, 0x1.b1ffa0p-11f, 0x1.d85478p-11f,
    0x1.fae17ep-11f, 0x1.9af40cp-15f, 0x1.a6319ep-14f, 0x1.30baa6p-13f,
    0x1.7fc362p-13f, 0x1.c05362p-13f, 0x1.f28a98p-13f, 0x1.0b4442p-12f,
    0x1.16361ap-12f, 0x1.1a2a2ap-12f, 0x1.172f8ep-12f, 0x1.0d5530p-12f,
    0x1.f9538ep-13f, 0x1.ca77b0p-13f, 0x1.8e336ap-13f, 0x1.44a304p-13f,
    0x1.dbc4c8p-14f, 0x1.141a2ap-14f, 0x1.93e44cp-17f, 0x1.e6e432p-11f,
    0x1.c447c6p-11f, 0x1.9e80d8p-11f, 0x1.7595dcp-11f, 0x1.498d30p-11f,
    0x1.1a6d1ep-11f, 0x1.d077bap-12f, 0x1.65ff1ep-12f, 0x1.eaf912p-13f,
    0x1.fbefb8p-14f, 0x1.44905ap-19f, 0x1.c017e6p-11f, 0x1.7bfdbep-11f,
    0x1.34fbc6p-11f, 0x1.d62f48p-12f, 0x1.3cadc6p-12f, 0x1.3afc06p-13f,
    0x1.fc556ep-11f, 0x1.a71f84p-11f, 0x1.4f2290p-11f, 0x1.e8c79cp-12f,
    0x1.2dd0d8p-12f, 0x1.b5ac2ep-14f, 0x1.d3d02ap-11f, 0x1.6e3d58p-11f,
    0x1.060200p-11f, 0x1.364608p-12f, 0x1.6d29b6p-14f, 0x1.bd8d5ep-11f,
    0x1.4ae030p-11f, 0x1.ab44b2p-12f, 0x1.7761cep-13f, 0x1.e38710p-11f,
    0x1.66b2b0p-11f, 0x1.cebf96p-12f, 0x1.964b20p-13f, 0x1.e15004p-11f,
    0x1.5a9bcep-11f, 0x1.a2f4d8p-12f, 0x1.17c056p-13f, 0x1.b800f8p-11f,
    0x1.27b132p-11f, 0x1.2a09b8p-12f, 0x0.000000p+0f,  0x1.68a69cp-11f,
    0x1.9df950p-12f, 0x1.983050p-14f, 0x1.94c6a4p-11f, 0x1.e88494p-12f,
    0x1.45f31ap-13f,
};

CLC_TABLE_FUNCTION(float, CBRT_TBL_TAIL, cbrt_tbl_tail);

// Tabulated values of sinh(i) and cosh(i) for i = 0,...,36.
DECLARE_TABLE(float, SINHCOSH_TBL_HEAD, 37) = {
    0x0.000000p+0f,  0x1.2cd9fcp+0f,  0x1.d03cf6p+1f,  0x1.40926ep+3f,
    0x1.b4a380p+4f,  0x1.28d016p+6f,  0x1.936d22p+7f,  0x1.122876p+9f,
    0x1.749ea6p+10f, 0x1.fa7158p+11f, 0x1.5829dcp+13f, 0x1.d3c448p+14f,
    0x1.3de166p+16f, 0x1.b00b5ap+17f, 0x1.259ac4p+19f, 0x1.8f0ccap+20f,
    0x1.0f2ebep+22f, 0x1.709348p+23f, 0x1.f4f220p+24f, 0x1.546d90p+26f,
    0x1.ceb088p+27f, 0x1.3a6e20p+29f, 0x1.ab5adcp+30f, 0x1.226af4p+32f,
    0x1.8ab7fcp+33f, 0x1.0c3d3ap+35f, 0x1.6c9326p+36f, 0x1.ef8230p+37f,
    0x1.50bba4p+39f, 0x1.c9aae4p+40f, 0x1.370470p+42f, 0x1.a6b766p+43f,
    0x1.1f43fcp+45f, 0x1.866f34p+46f, 0x1.0953e2p+48f, 0x1.689e22p+49f,
    0x1.ea215ap+50f,
};

CLC_TABLE_FUNCTION(float, SINHCOSH_TBL_HEAD, sinhcosh_tbl_head);

DECLARE_TABLE(float, SINHCOSH_TBL_TAIL, 37) = {
    0x1.000000p+0f,  0x1.8b0756p+0f,  0x1.e18fa0p+1f,  0x1.422a4ap+3f,
    0x1.b4ee86p+4f,  0x1.28d6fcp+6f,  0x1.936e68p+7f,  0x1.122894p+9f,
    0x1.749eaap+10f, 0x1.fa7158p+11f, 0x1.5829dep+13f, 0x1.d3c448p+14f,
    0x1.3de166p+16f, 0x1.b00b5ap+17f, 0x1.259ac4p+19f, 0x1.8f0ccap+20f,
    0x1.0f2ebep+22f, 0x1.709348p+23f, 0x1.f4f220p+24f, 0x1.546d90p+26f,
    0x1.ceb088p+27f, 0x1.3a6e20p+29f, 0x1.ab5adcp+30f, 0x1.226af4p+32f,
    0x1.8ab7fcp+33f, 0x1.0c3d3ap+35f, 0x1.6c9326p+36f, 0x1.ef8230p+37f,
    0x1.50bba4p+39f, 0x1.c9aae4p+40f, 0x1.370470p+42f, 0x1.a6b766p+43f,
    0x1.1f43fcp+45f, 0x1.866f34p+46f, 0x1.0953e2p+48f, 0x1.689e22p+49f,
    0x1.ea215ap+50f,
};

CLC_TABLE_FUNCTION(float, SINHCOSH_TBL_TAIL, sinhcosh_tbl_tail);

#ifdef cl_khr_fp64

#pragma OPENCL EXTENSION cl_khr_fp64 : enable

DECLARE_TABLE(double, LN_TBL_LO, 65) = {
    0x0.0000000000000p+0, 0x1.fc0a800000000p-7, 0x1.f829800000000p-6,
    0x1.7745800000000p-5, 0x1.f0a3000000000p-5, 0x1.341d700000000p-4,
    0x1.6f0d200000000p-4, 0x1.a926d00000000p-4, 0x1.e270700000000p-4,
    0x1.0d77e00000000p-3, 0x1.2955280000000p-3, 0x1.44d2b00000000p-3,
    0x1.5ff3000000000p-3, 0x1.7ab8900000000p-3, 0x1.9525a80000000p-3,
    0x1.af3c900000000p-3, 0x1.c8ff780000000p-3, 0x1.e270700000000p-3,
    0x1.fb91800000000p-3, 0x1.0a324c0000000p-2, 0x1.1675c80000000p-2,
    0x1.22941c0000000p-2, 0x1.2e8e280000000p-2, 0x1.3a64c40000000p-2,
    0x1.4618bc0000000p-2, 0x1.51aad80000000p-2, 0x1.5d1bd80000000p-2,
    0x1.686c800000000p-2, 0x1.739d7c0000000p-2, 0x1.7eaf800000000p-2,
    0x1.89a3380000000p-2, 0x1.9479400000000p-2, 0x1.9f323c0000000p-2,
    0x1.a9cec80000000p-2, 0x1.b44f740000000p-2, 0x1.beb4d80000000p-2,
    0x1.c8ff7c0000000p-2, 0x1.d32fe40000000p-2, 0x1.dd46a00000000p-2,
    0x1.e744240000000p-2, 0x1.f128f40000000p-2, 0x1.faf5880000000p-2,
    0x1.02552a0000000p-1, 0x1.0723e40000000p-1, 0x1.0be72e0000000p-1,
    0x1.109f380000000p-1, 0x1.154c3c0000000p-1, 0x1.19ee6a0000000p-1,
    0x1.1e85f40000000p-1, 0x1.23130c0000000p-1, 0x1.2795e00000000p-1,
    0x1.2c0e9e0000000p-1, 0x1.307d720000000p-1, 0x1.34e2880000000p-1,
    0x1.393e0c0000000p-1, 0x1.3d90260000000p-1, 0x1.41d8fe0000000p-1,
    0x1.4618bc0000000p-1, 0x1.4a4f840000000p-1, 0x1.4e7d800000000p-1,
    0x1.52a2d20000000p-1, 0x1.56bf9c0000000p-1, 0x1.5ad4040000000p-1,
    0x1.5ee02a0000000p-1, 0x1.62e42e0000000p-1,
};

CLC_TABLE_FUNCTION(double, LN_TBL_LO, ln_tbl_lo);

DECLARE_TABLE(double, LN_TBL_HI, 65) = {
    0x0.0000000000000p+0,  0x1.61f807c79f3dbp-28, 0x1.873c1980267c8p-25,
    0x1.ec65b9f88c69ep-26, 0x1.8022c54cc2f99p-26, 0x1.2c37a3a125330p-25,
    0x1.15cad69737c93p-25, 0x1.d256ab1b285e9p-27, 0x1.b8abcb97a7aa2p-26,
    0x1.f34239659a5dcp-25, 0x1.e07fd48d30177p-25, 0x1.b32df4799f4f6p-25,
    0x1.c29e4f4f21cf8p-25, 0x1.086c848df1b59p-30, 0x1.cf456b4764130p-27,
    0x1.3a02ffcb63398p-25, 0x1.1e6a6886b0976p-25, 0x1.b8abcb97a7aa2p-25,
    0x1.b578f8aa35552p-25, 0x1.139c871afb9fcp-25, 0x1.5d5d30701ce64p-25,
    0x1.de7bcb2d12142p-25, 0x1.d708e984e1664p-25, 0x1.56945e9c72f36p-26,
    0x1.0e2f613e85bdap-29, 0x1.cb7e0b42724f6p-28, 0x1.fac04e52846c7p-25,
    0x1.e9b14aec442bep-26, 0x1.b5de8034e7126p-25, 0x1.dc157e1b259d3p-25,
    0x1.b05096ad69c62p-28, 0x1.c2116faba4cddp-26, 0x1.65fcc25f95b47p-25,
    0x1.a9a08498d4850p-26, 0x1.de647b1465f77p-25, 0x1.da71b7bf7861dp-26,
    0x1.e6a6886b09760p-28, 0x1.f0075eab0ef64p-25, 0x1.3071282fb989bp-28,
    0x1.0eb43c3f1bed2p-25, 0x1.faf06ecb35c84p-26, 0x1.ef1e63db35f68p-27,
    0x1.69743fb1a71a5p-27, 0x1.c1cdf404e5796p-25, 0x1.094aa0ada625ep-27,
    0x1.e2d4c96fde3ecp-25, 0x1.2f4d5e9a98f34p-25, 0x1.467c96ecc5cbep-25,
    0x1.e7040d03dec5ap-25, 0x1.7bebf4282de36p-25, 0x1.289b11aeb783fp-25,
    0x1.a891d1772f538p-26, 0x1.34f10be1fb591p-25, 0x1.d9ce1d316eb93p-25,
    0x1.3562a19a9c442p-25, 0x1.4e2adf548084cp-26, 0x1.08ce55cc8c97ap-26,
    0x1.0e2f613e85bdap-28, 0x1.db03ebb0227bfp-25, 0x1.1b75bb09cb098p-25,
    0x1.96f16abb9df22p-27, 0x1.5b3f399411c62p-25, 0x1.86b3e59f65355p-26,
    0x1.2482ceae1ac12p-26, 0x1.efa39ef35793cp-25,
};

CLC_TABLE_FUNCTION(double, LN_TBL_HI, ln_tbl_hi);

// Arrays atan_jby256_head and atan_jby256_tail contain leading and trailing
// parts respectively of precomputed values of atan(j/256), for j = 16, 17, ...,
// 256. atan_jby256_head contains the first 21 bits of precision, and
// atan_jby256_tail contains a further 53 bits precision.

DECLARE_TABLE(double, ATAN_JBY256_TBL_HEAD, 241) = {
    0x1.ff55b00000000p-5, 0x1.0f99e00000000p-4, 0x1.1f86d00000000p-4,
    0x1.2f71900000000p-4, 0x1.3f59f00000000p-4, 0x1.4f3fd00000000p-4,
    0x1.5f23200000000p-4, 0x1.6f03b00000000p-4, 0x1.7ee1800000000p-4,
    0x1.8ebc500000000p-4, 0x1.9e94100000000p-4, 0x1.ae68a00000000p-4,
    0x1.be39e00000000p-4, 0x1.ce07c00000000p-4, 0x1.ddd2100000000p-4,
    0x1.ed98c00000000p-4, 0x1.fd5ba00000000p-4, 0x1.068d500000000p-3,
    0x1.0e6ad00000000p-3, 0x1.1646500000000p-3, 0x1.1e1fa00000000p-3,
    0x1.25f6e00000000p-3, 0x1.2dcbd00000000p-3, 0x1.359e800000000p-3,
    0x1.3d6ee00000000p-3, 0x1.453ce00000000p-3, 0x1.4d08700000000p-3,
    0x1.54d1800000000p-3, 0x1.5c98100000000p-3, 0x1.645bf00000000p-3,
    0x1.6c1d400000000p-3, 0x1.73dbd00000000p-3, 0x1.7b97b00000000p-3,
    0x1.8350b00000000p-3, 0x1.8b06e00000000p-3, 0x1.92ba300000000p-3,
    0x1.9a6a800000000p-3, 0x1.a217e00000000p-3, 0x1.a9c2300000000p-3,
    0x1.b169600000000p-3, 0x1.b90d700000000p-3, 0x1.c0ae500000000p-3,
    0x1.c84bf00000000p-3, 0x1.cfe6500000000p-3, 0x1.d77d500000000p-3,
    0x1.df11000000000p-3, 0x1.e6a1400000000p-3, 0x1.ee2e100000000p-3,
    0x1.f5b7500000000p-3, 0x1.fd3d100000000p-3, 0x1.025fa00000000p-2,
    0x1.061ee00000000p-2, 0x1.09dc500000000p-2, 0x1.0d97e00000000p-2,
    0x1.1151a00000000p-2, 0x1.1509700000000p-2, 0x1.18bf500000000p-2,
    0x1.1c73500000000p-2, 0x1.2025500000000p-2, 0x1.23d5600000000p-2,
    0x1.2783700000000p-2, 0x1.2b2f700000000p-2, 0x1.2ed9800000000p-2,
    0x1.3281800000000p-2, 0x1.3627700000000p-2, 0x1.39cb400000000p-2,
    0x1.3d6d100000000p-2, 0x1.410cb00000000p-2, 0x1.44aa400000000p-2,
    0x1.4845a00000000p-2, 0x1.4bdee00000000p-2, 0x1.4f75f00000000p-2,
    0x1.530ad00000000p-2, 0x1.569d800000000p-2, 0x1.5a2e000000000p-2,
    0x1.5dbc300000000p-2, 0x1.6148400000000p-2, 0x1.64d1f00000000p-2,
    0x1.6859700000000p-2, 0x1.6bdea00000000p-2, 0x1.6f61900000000p-2,
    0x1.72e2200000000p-2, 0x1.7660700000000p-2, 0x1.79dc600000000p-2,
    0x1.7d56000000000p-2, 0x1.80cd400000000p-2, 0x1.8442200000000p-2,
    0x1.87b4b00000000p-2, 0x1.8b24d00000000p-2, 0x1.8e92900000000p-2,
    0x1.91fde00000000p-2, 0x1.9566d00000000p-2, 0x1.98cd500000000p-2,
    0x1.9c31600000000p-2, 0x1.9f93000000000p-2, 0x1.a2f2300000000p-2,
    0x1.a64ee00000000p-2, 0x1.a9a9200000000p-2, 0x1.ad00f00000000p-2,
    0x1.b056400000000p-2, 0x1.b3a9100000000p-2, 0x1.b6f9600000000p-2,
    0x1.ba47300000000p-2, 0x1.bd92800000000p-2, 0x1.c0db400000000p-2,
    0x1.c421900000000p-2, 0x1.c765500000000p-2, 0x1.caa6800000000p-2,
    0x1.cde5300000000p-2, 0x1.d121500000000p-2, 0x1.d45ae00000000p-2,
    0x1.d791f00000000p-2, 0x1.dac6700000000p-2, 0x1.ddf8500000000p-2,
    0x1.e127b00000000p-2, 0x1.e454800000000p-2, 0x1.e77eb00000000p-2,
    0x1.eaa6500000000p-2, 0x1.edcb600000000p-2, 0x1.f0ede00000000p-2,
    0x1.f40dd00000000p-2, 0x1.f72b200000000p-2, 0x1.fa45d00000000p-2,
    0x1.fd5e000000000p-2, 0x1.0039c00000000p-1, 0x1.01c3400000000p-1,
    0x1.034b700000000p-1, 0x1.04d2500000000p-1, 0x1.0657e00000000p-1,
    0x1.07dc300000000p-1, 0x1.095f300000000p-1, 0x1.0ae0e00000000p-1,
    0x1.0c61400000000p-1, 0x1.0de0500000000p-1, 0x1.0f5e200000000p-1,
    0x1.10daa00000000p-1, 0x1.1255d00000000p-1, 0x1.13cfb00000000p-1,
    0x1.1548500000000p-1, 0x1.16bfa00000000p-1, 0x1.1835a00000000p-1,
    0x1.19aa500000000p-1, 0x1.1b1dc00000000p-1, 0x1.1c8fe00000000p-1,
    0x1.1e00b00000000p-1, 0x1.1f70400000000p-1, 0x1.20de800000000p-1,
    0x1.224b700000000p-1, 0x1.23b7100000000p-1, 0x1.2521700000000p-1,
    0x1.268a900000000p-1, 0x1.27f2600000000p-1, 0x1.2958e00000000p-1,
    0x1.2abe200000000p-1, 0x1.2c22100000000p-1, 0x1.2d84c00000000p-1,
    0x1.2ee6200000000p-1, 0x1.3046400000000p-1, 0x1.31a5200000000p-1,
    0x1.3302b00000000p-1, 0x1.345f000000000p-1, 0x1.35ba000000000p-1,
    0x1.3713d00000000p-1, 0x1.386c500000000p-1, 0x1.39c3900000000p-1,
    0x1.3b19800000000p-1, 0x1.3c6e400000000p-1, 0x1.3dc1c00000000p-1,
    0x1.3f13f00000000p-1, 0x1.4064f00000000p-1, 0x1.41b4a00000000p-1,
    0x1.4303200000000p-1, 0x1.4450600000000p-1, 0x1.459c600000000p-1,
    0x1.46e7200000000p-1, 0x1.4830a00000000p-1, 0x1.4978f00000000p-1,
    0x1.4ac0000000000p-1, 0x1.4c05e00000000p-1, 0x1.4d4a800000000p-1,
    0x1.4e8de00000000p-1, 0x1.4fd0100000000p-1, 0x1.5111000000000p-1,
    0x1.5250c00000000p-1, 0x1.538f500000000p-1, 0x1.54cca00000000p-1,
    0x1.5608d00000000p-1, 0x1.5743c00000000p-1, 0x1.587d800000000p-1,
    0x1.59b6000000000p-1, 0x1.5aed600000000p-1, 0x1.5c23900000000p-1,
    0x1.5d58900000000p-1, 0x1.5e8c600000000p-1, 0x1.5fbf000000000p-1,
    0x1.60f0800000000p-1, 0x1.6220d00000000p-1, 0x1.634ff00000000p-1,
    0x1.647de00000000p-1, 0x1.65aab00000000p-1, 0x1.66d6600000000p-1,
    0x1.6800e00000000p-1, 0x1.692a400000000p-1, 0x1.6a52700000000p-1,
    0x1.6b79800000000p-1, 0x1.6c9f700000000p-1, 0x1.6dc4400000000p-1,
    0x1.6ee7f00000000p-1, 0x1.700a700000000p-1, 0x1.712be00000000p-1,
    0x1.724c300000000p-1, 0x1.736b600000000p-1, 0x1.7489700000000p-1,
    0x1.75a6700000000p-1, 0x1.76c2400000000p-1, 0x1.77dd100000000p-1,
    0x1.78f6b00000000p-1, 0x1.7a0f400000000p-1, 0x1.7b26c00000000p-1,
    0x1.7c3d300000000p-1, 0x1.7d52800000000p-1, 0x1.7e66c00000000p-1,
    0x1.7f79e00000000p-1, 0x1.808c000000000p-1, 0x1.819d000000000p-1,
    0x1.82ad000000000p-1, 0x1.83bbe00000000p-1, 0x1.84c9c00000000p-1,
    0x1.85d6900000000p-1, 0x1.86e2500000000p-1, 0x1.87ed000000000p-1,
    0x1.88f6b00000000p-1, 0x1.89ff500000000p-1, 0x1.8b06f00000000p-1,
    0x1.8c0d900000000p-1, 0x1.8d13200000000p-1, 0x1.8e17a00000000p-1,
    0x1.8f1b300000000p-1, 0x1.901db00000000p-1, 0x1.911f300000000p-1,
    0x1.921fb00000000p-1,
};

CLC_TABLE_FUNCTION(double, ATAN_JBY256_TBL_HEAD, atan_jby256_tbl_head);

DECLARE_TABLE(double, ATAN_JBY256_TBL_TAIL, 241) = {
    0x1.6e59fbd38db2cp-26, 0x1.4e3aa54dedf96p-25, 0x1.7e105ab1bda88p-25,
    0x1.8c5254d013fd0p-27, 0x1.cf8ab3ad62670p-29, 0x1.9dca4bec80468p-26,
    0x1.3f4b5ec98a8dap-26, 0x1.b9d49619d81fep-25, 0x1.3017887460934p-27,
    0x1.11e3eca0b9944p-26, 0x1.4f3f73c5a332ep-26, 0x1.c71c8ae0e00a6p-26,
    0x1.7cde0f86fbdc7p-25, 0x1.70f328c889c72p-26, 0x1.c07ae9b994efep-26,
    0x1.0c8021d7b1698p-27, 0x1.35585edb8cb22p-25, 0x1.0842567b30e96p-24,
    0x1.99e811031472ep-24, 0x1.041821416bceep-25, 0x1.f6086e4dc96f4p-24,
    0x1.71a535c5f1b58p-27, 0x1.65f743fe63ca1p-24, 0x1.dbd733472d014p-24,
    0x1.d18cc4d8b0d1dp-24, 0x1.8c12553c8fb29p-24, 0x1.53b49e2e8f991p-24,
    0x1.7422ae148c141p-24, 0x1.e3ec269df56a8p-27, 0x1.ff6754e7e0ac9p-24,
    0x1.131267b1b5aadp-24, 0x1.d14fa403a94bcp-24, 0x1.2f396c089a3d8p-25,
    0x1.c731d78fa95bbp-24, 0x1.c50f385177399p-24, 0x1.f41409c6f2c20p-25,
    0x1.d2d90c4c39ec0p-24, 0x1.80420696f2106p-25, 0x1.b40327943a2e8p-27,
    0x1.5d35e02f3d2a2p-25, 0x1.4a498288117b0p-25, 0x1.35da119afb324p-25,
    0x1.14e85cdb9a908p-24, 0x1.38754e5547b9ap-25, 0x1.be40ae6ce3246p-24,
    0x1.0c993b3bea7e7p-24, 0x1.1d2dd89ac3359p-24, 0x1.1476603332c46p-25,
    0x1.f25901bac55b7p-24, 0x1.f881b7c826e28p-24, 0x1.441996d698d20p-24,
    0x1.407ac521ea089p-23, 0x1.2fb0c6c4b1723p-23, 0x1.ca135966a3e18p-23,
    0x1.b1218e4d646e4p-25, 0x1.d4e72a350d288p-25, 0x1.4617e2f04c329p-23,
    0x1.096ec41e82650p-25, 0x1.9f91f25773e6ep-24, 0x1.59c0820f1d674p-25,
    0x1.02bf7a2df1064p-25, 0x1.fb36bfc40508fp-23, 0x1.ea08f3f8dc892p-24,
    0x1.3ed6254656a0ep-24, 0x1.b83f5e5e69c58p-25, 0x1.d6ec2af768592p-23,
    0x1.493889a226f94p-25, 0x1.5ad8fa65279bap-23, 0x1.b615784d45434p-25,
    0x1.09a184368f145p-23, 0x1.61a2439b0d91cp-24, 0x1.ce1a65e39a978p-24,
    0x1.32a39a93b6a66p-23, 0x1.1c3699af804e7p-23, 0x1.75e0f4e44ede8p-26,
    0x1.f77ced1a7a83bp-23, 0x1.84e7f0cb1b500p-29, 0x1.ec6b838b02dfep-23,
    0x1.3ebf4dfbeda87p-23, 0x1.9397aed9cb475p-23, 0x1.07937bc239c54p-24,
    0x1.aa754553131b6p-23, 0x1.4a05d407c45dcp-24, 0x1.132231a206dd0p-23,
    0x1.2d8ecfdd69c88p-24, 0x1.a852c74218606p-24, 0x1.71bf2baeebb50p-23,
    0x1.83d7db7491820p-27, 0x1.ca50d92b6da14p-25, 0x1.6f5cde8530298p-26,
    0x1.f343198910740p-24, 0x1.0e8d241ccd80ap-24, 0x1.1535ac619e6c8p-24,
    0x1.7316041c36cd2p-24, 0x1.985a000637d8ep-24, 0x1.f2f29858c0a68p-25,
    0x1.879847f96d909p-23, 0x1.ab3d319e12e42p-23, 0x1.5088162dfc4c2p-24,
    0x1.05749a1cd9d8cp-25, 0x1.da65c6c6b8618p-26, 0x1.739bf7df1ad64p-25,
    0x1.bc31252aa3340p-25, 0x1.e528191ad3aa8p-26, 0x1.929d93df19f18p-23,
    0x1.ff11eb693a080p-26, 0x1.55ae3f145a3a0p-27, 0x1.cbcd8c6c0ca82p-24,
    0x1.0cb04d425d304p-24, 0x1.9adfcab5be678p-24, 0x1.93d90c5662508p-23,
    0x1.68489bd35ff40p-24, 0x1.586ed3da2b7e0p-28, 0x1.7604d2e850eeep-23,
    0x1.ac1d12bfb53d8p-24, 0x1.9b3d468274740p-28, 0x1.fc5d68d10e53cp-24,
    0x1.8f9e51884becbp-23, 0x1.a87f0869c06d1p-23, 0x1.31e7279f685fap-23,
    0x1.6a8282f9719b0p-27, 0x1.0d2724a8a44e0p-25, 0x1.a60524b11ad4ep-23,
    0x1.75fdf832750f0p-26, 0x1.cf06902e4cd36p-23, 0x1.e82422d4f6d10p-25,
    0x1.24a091063e6c0p-26, 0x1.8a1a172dc6f38p-24, 0x1.29b6619f8a92dp-22,
    0x1.9274d9c1b70c8p-24, 0x1.0c34b1fbb7930p-26, 0x1.639866c20eb50p-25,
    0x1.6d6d0f6832e9ep-23, 0x1.af54def99f25ep-22, 0x1.16cfc52a00262p-22,
    0x1.dcc1e83569c32p-23, 0x1.37f7a551ed425p-22, 0x1.f6360adc98887p-22,
    0x1.2c6ec8d35a2c1p-22, 0x1.bd44df84cb036p-23, 0x1.117cf826e310ep-22,
    0x1.ca533f332cfc9p-22, 0x1.0f208509dbc2ep-22, 0x1.cd07d93c945dep-23,
    0x1.57bdfd67e6d72p-22, 0x1.aab89c516c658p-24, 0x1.3e823b1a1b8a0p-25,
    0x1.307464a9d6d3cp-23, 0x1.c5993cd438843p-22, 0x1.ba2fca02ab554p-22,
    0x1.01a5b6983a268p-23, 0x1.273d1b350efc8p-25, 0x1.64c238c37b0c6p-23,
    0x1.aded07370a300p-25, 0x1.78091197eb47ep-23, 0x1.4b0f245e0dabcp-24,
    0x1.080d9794e2eafp-22, 0x1.d4ec242b60c76p-23, 0x1.221d2f940caa0p-27,
    0x1.cdbc42b2bba5cp-24, 0x1.cce37bb440840p-25, 0x1.6c1d999cf1dd0p-22,
    0x1.bed8a07eb0870p-26, 0x1.69ed88f490e3cp-24, 0x1.cd41719b73ef0p-25,
    0x1.cbc4ac95b41b7p-22, 0x1.238f1b890f5d7p-22, 0x1.50c4282259cc4p-24,
    0x1.713d2de87b3e2p-22, 0x1.1d5a7d2255276p-23, 0x1.c0dfd48227ac1p-22,
    0x1.1c964dab76753p-22, 0x1.6de56d5704496p-23, 0x1.4aeb71fd19968p-23,
    0x1.fbf91c57b1918p-23, 0x1.d6bef7fbe5d9ap-22, 0x1.464d3dc249066p-22,
    0x1.638e2ec4d9073p-22, 0x1.16f4a7247ea7cp-24, 0x1.1a0a740f1d440p-28,
    0x1.6edbb0114a33cp-23, 0x1.dbee8bf1d513cp-24, 0x1.5b8bdb0248f73p-22,
    0x1.7de3d3f5eac64p-22, 0x1.ee24187ae448ap-23, 0x1.e06c591ec5192p-22,
    0x1.4e3861a332738p-24, 0x1.a9599dcc2bfe4p-24, 0x1.f732fbad43468p-25,
    0x1.eb9f573b727d9p-22, 0x1.8b212a2eb9897p-22, 0x1.384884c167215p-22,
    0x1.0e2d363020051p-22, 0x1.2820879fbd022p-22, 0x1.a1ab9893e4b30p-22,
    0x1.2d1b817a24478p-23, 0x1.15d7b8ded4878p-25, 0x1.8968f9db3a5e4p-24,
    0x1.71c4171fe135fp-22, 0x1.6d80f605d0d8cp-22, 0x1.c91f043691590p-24,
    0x1.39f8a15fce2b2p-23, 0x1.55beda9d94b80p-27, 0x1.b12c15d60949ap-23,
    0x1.24167b312bfe3p-22, 0x1.0ab8633070277p-22, 0x1.54554ebbc80eep-23,
    0x1.0204aef5a4bb8p-25, 0x1.8af08c679cf2cp-22, 0x1.0852a330ae6c8p-22,
    0x1.6d3eb9ec32916p-23, 0x1.685cb7fcbbafep-23, 0x1.1f751c1e0bd95p-22,
    0x1.705b1b0f72560p-26, 0x1.b98d8d808ca92p-22, 0x1.2ea22c75cc980p-25,
    0x1.7aba62bca0350p-22, 0x1.d73833442278cp-22, 0x1.5a5ca1fb18bf9p-22,
    0x1.1a6092b6ecf28p-25, 0x1.44fd049aac104p-24, 0x1.c114fd8df5180p-29,
    0x1.5972f130feae5p-22, 0x1.ca034a55fe198p-24, 0x1.6e2b149990227p-22,
    0x1.b00000294592cp-24, 0x1.8b9bdc442620ep-22, 0x1.d94fdfabf3e4ep-23,
    0x1.5db30b145ad9ap-23, 0x1.e3e1eb95022b0p-23, 0x1.d5b8b45442bd6p-22,
    0x1.7a046231ecd2ep-22, 0x1.feafe3ef55232p-22, 0x1.839e7bfd78267p-22,
    0x1.45cf49d6fa900p-25, 0x1.be3132b27f380p-27, 0x1.533980bb84f9fp-22,
    0x1.889e2ce3ba390p-26, 0x1.f7778c3ad0cc8p-24, 0x1.46660cec4eba2p-23,
    0x1.5110b4611a626p-23,
};

CLC_TABLE_FUNCTION(double, ATAN_JBY256_TBL_TAIL, atan_jby256_tbl_tail);

DECLARE_TABLE(double, LOG_F_INV_TBL_HEAD, 258) = {
    0x1.0000000000000p+1, 0x1.fe00000000000p+0, 0x1.fc00000000000p+0,
    0x1.fa00000000000p+0, 0x1.f800000000000p+0, 0x1.f600000000000p+0,
    0x1.f400000000000p+0, 0x1.f200000000000p+0, 0x1.f000000000000p+0,
    0x1.ee00000000000p+0, 0x1.ec00000000000p+0, 0x1.ea00000000000p+0,
    0x1.e900000000000p+0, 0x1.e700000000000p+0, 0x1.e500000000000p+0,
    0x1.e300000000000p+0, 0x1.e100000000000p+0, 0x1.e000000000000p+0,
    0x1.de00000000000p+0, 0x1.dc00000000000p+0, 0x1.da00000000000p+0,
    0x1.d900000000000p+0, 0x1.d700000000000p+0, 0x1.d500000000000p+0,
    0x1.d400000000000p+0, 0x1.d200000000000p+0, 0x1.d000000000000p+0,
    0x1.cf00000000000p+0, 0x1.cd00000000000p+0, 0x1.cb00000000000p+0,
    0x1.ca00000000000p+0, 0x1.c800000000000p+0, 0x1.c700000000000p+0,
    0x1.c500000000000p+0, 0x1.c300000000000p+0, 0x1.c200000000000p+0,
    0x1.c000000000000p+0, 0x1.bf00000000000p+0, 0x1.bd00000000000p+0,
    0x1.bc00000000000p+0, 0x1.ba00000000000p+0, 0x1.b900000000000p+0,
    0x1.b700000000000p+0, 0x1.b600000000000p+0, 0x1.b400000000000p+0,
    0x1.b300000000000p+0, 0x1.b200000000000p+0, 0x1.b000000000000p+0,
    0x1.af00000000000p+0, 0x1.ad00000000000p+0, 0x1.ac00000000000p+0,
    0x1.aa00000000000p+0, 0x1.a900000000000p+0, 0x1.a800000000000p+0,
    0x1.a600000000000p+0, 0x1.a500000000000p+0, 0x1.a400000000000p+0,
    0x1.a200000000000p+0, 0x1.a100000000000p+0, 0x1.a000000000000p+0,
    0x1.9e00000000000p+0, 0x1.9d00000000000p+0, 0x1.9c00000000000p+0,
    0x1.9a00000000000p+0, 0x1.9900000000000p+0, 0x1.9800000000000p+0,
    0x1.9700000000000p+0, 0x1.9500000000000p+0, 0x1.9400000000000p+0,
    0x1.9300000000000p+0, 0x1.9200000000000p+0, 0x1.9000000000000p+0,
    0x1.8f00000000000p+0, 0x1.8e00000000000p+0, 0x1.8d00000000000p+0,
    0x1.8b00000000000p+0, 0x1.8a00000000000p+0, 0x1.8900000000000p+0,
    0x1.8800000000000p+0, 0x1.8700000000000p+0, 0x1.8600000000000p+0,
    0x1.8400000000000p+0, 0x1.8300000000000p+0, 0x1.8200000000000p+0,
    0x1.8100000000000p+0, 0x1.8000000000000p+0, 0x1.7f00000000000p+0,
    0x1.7e00000000000p+0, 0x1.7d00000000000p+0, 0x1.7b00000000000p+0,
    0x1.7a00000000000p+0, 0x1.7900000000000p+0, 0x1.7800000000000p+0,
    0x1.7700000000000p+0, 0x1.7600000000000p+0, 0x1.7500000000000p+0,
    0x1.7400000000000p+0, 0x1.7300000000000p+0, 0x1.7200000000000p+0,
    0x1.7100000000000p+0, 0x1.7000000000000p+0, 0x1.6f00000000000p+0,
    0x1.6e00000000000p+0, 0x1.6d00000000000p+0, 0x1.6c00000000000p+0,
    0x1.6b00000000000p+0, 0x1.6a00000000000p+0, 0x1.6900000000000p+0,
    0x1.6800000000000p+0, 0x1.6700000000000p+0, 0x1.6600000000000p+0,
    0x1.6500000000000p+0, 0x1.6400000000000p+0, 0x1.6300000000000p+0,
    0x1.6200000000000p+0, 0x1.6100000000000p+0, 0x1.6000000000000p+0,
    0x1.5f00000000000p+0, 0x1.5e00000000000p+0, 0x1.5d00000000000p+0,
    0x1.5c00000000000p+0, 0x1.5b00000000000p+0, 0x1.5a00000000000p+0,
    0x1.5900000000000p+0, 0x1.5800000000000p+0, 0x1.5800000000000p+0,
    0x1.5700000000000p+0, 0x1.5600000000000p+0, 0x1.5500000000000p+0,
    0x1.5400000000000p+0, 0x1.5300000000000p+0, 0x1.5200000000000p+0,
    0x1.5100000000000p+0, 0x1.5000000000000p+0, 0x1.5000000000000p+0,
    0x1.4f00000000000p+0, 0x1.4e00000000000p+0, 0x1.4d00000000000p+0,
    0x1.4c00000000000p+0, 0x1.4b00000000000p+0, 0x1.4a00000000000p+0,
    0x1.4a00000000000p+0, 0x1.4900000000000p+0, 0x1.4800000000000p+0,
    0x1.4700000000000p+0, 0x1.4600000000000p+0, 0x1.4600000000000p+0,
    0x1.4500000000000p+0, 0x1.4400000000000p+0, 0x1.4300000000000p+0,
    0x1.4200000000000p+0, 0x1.4200000000000p+0, 0x1.4100000000000p+0,
    0x1.4000000000000p+0, 0x1.3f00000000000p+0, 0x1.3e00000000000p+0,
    0x1.3e00000000000p+0, 0x1.3d00000000000p+0, 0x1.3c00000000000p+0,
    0x1.3b00000000000p+0, 0x1.3b00000000000p+0, 0x1.3a00000000000p+0,
    0x1.3900000000000p+0, 0x1.3800000000000p+0, 0x1.3800000000000p+0,
    0x1.3700000000000p+0, 0x1.3600000000000p+0, 0x1.3500000000000p+0,
    0x1.3500000000000p+0, 0x1.3400000000000p+0, 0x1.3300000000000p+0,
    0x1.3200000000000p+0, 0x1.3200000000000p+0, 0x1.3100000000000p+0,
    0x1.3000000000000p+0, 0x1.3000000000000p+0, 0x1.2f00000000000p+0,
    0x1.2e00000000000p+0, 0x1.2e00000000000p+0, 0x1.2d00000000000p+0,
    0x1.2c00000000000p+0, 0x1.2b00000000000p+0, 0x1.2b00000000000p+0,
    0x1.2a00000000000p+0, 0x1.2900000000000p+0, 0x1.2900000000000p+0,
    0x1.2800000000000p+0, 0x1.2700000000000p+0, 0x1.2700000000000p+0,
    0x1.2600000000000p+0, 0x1.2500000000000p+0, 0x1.2500000000000p+0,
    0x1.2400000000000p+0, 0x1.2300000000000p+0, 0x1.2300000000000p+0,
    0x1.2200000000000p+0, 0x1.2100000000000p+0, 0x1.2100000000000p+0,
    0x1.2000000000000p+0, 0x1.2000000000000p+0, 0x1.1f00000000000p+0,
    0x1.1e00000000000p+0, 0x1.1e00000000000p+0, 0x1.1d00000000000p+0,
    0x1.1c00000000000p+0, 0x1.1c00000000000p+0, 0x1.1b00000000000p+0,
    0x1.1b00000000000p+0, 0x1.1a00000000000p+0, 0x1.1900000000000p+0,
    0x1.1900000000000p+0, 0x1.1800000000000p+0, 0x1.1800000000000p+0,
    0x1.1700000000000p+0, 0x1.1600000000000p+0, 0x1.1600000000000p+0,
    0x1.1500000000000p+0, 0x1.1500000000000p+0, 0x1.1400000000000p+0,
    0x1.1300000000000p+0, 0x1.1300000000000p+0, 0x1.1200000000000p+0,
    0x1.1200000000000p+0, 0x1.1100000000000p+0, 0x1.1100000000000p+0,
    0x1.1000000000000p+0, 0x1.0f00000000000p+0, 0x1.0f00000000000p+0,
    0x1.0e00000000000p+0, 0x1.0e00000000000p+0, 0x1.0d00000000000p+0,
    0x1.0d00000000000p+0, 0x1.0c00000000000p+0, 0x1.0c00000000000p+0,
    0x1.0b00000000000p+0, 0x1.0a00000000000p+0, 0x1.0a00000000000p+0,
    0x1.0900000000000p+0, 0x1.0900000000000p+0, 0x1.0800000000000p+0,
    0x1.0800000000000p+0, 0x1.0700000000000p+0, 0x1.0700000000000p+0,
    0x1.0600000000000p+0, 0x1.0600000000000p+0, 0x1.0500000000000p+0,
    0x1.0500000000000p+0, 0x1.0400000000000p+0, 0x1.0400000000000p+0,
    0x1.0300000000000p+0, 0x1.0300000000000p+0, 0x1.0200000000000p+0,
    0x1.0200000000000p+0, 0x1.0100000000000p+0, 0x1.0100000000000p+0,
    0x1.0000000000000p+0, 0x1.0000000000000p+0,
};

CLC_TABLE_FUNCTION(double, LOG_F_INV_TBL_HEAD, log_f_inv_tbl_head);

DECLARE_TABLE(double, LOG_F_INV_TBL_TAIL, 258) = {
    0x0.0000000000000p+0,  0x1.fe01fe01fe020p-16, 0x1.fc07f01fc07f0p-14,
    0x1.1caa01fa11caap-12, 0x1.f81f81f81f820p-12, 0x1.8856506ddaba6p-11,
    0x1.196792909c560p-10, 0x1.7d9108c2ad433p-10, 0x1.f07c1f07c1f08p-10,
    0x1.38ff08b1c03ddp-9,  0x1.80f6603d980f6p-9,  0x1.d00f57403d5d0p-9,
    0x1.31abf0b7672a0p-12, 0x1.06a965d43919bp-10, 0x1.ceb240795ceb2p-10,
    0x1.522f3b834e67fp-9,  0x1.c3c3c3c3c3c3cp-9,  0x1.e01e01e01e01ep-12,
    0x1.75b8fe21a291cp-10, 0x1.403b9403b9404p-9,  0x1.cc0ed7303b5ccp-9,
    0x1.79118f3fc4da2p-11, 0x1.ed952e0b0ce46p-10, 0x1.95900eae56404p-9,
    0x1.d41d41d41d41dp-12, 0x1.cb28ff16c69aep-10, 0x1.96b1edd80e866p-9,
    0x1.372e225fe30d9p-11, 0x1.0ad12073615a2p-9,  0x1.cdb2c0397cdb3p-9,
    0x1.2cc157b864407p-10, 0x1.64cb5f7148404p-9,  0x1.c71c71c71c71cp-12,
    0x1.129a21a930b84p-9,  0x1.f1e0387f1e038p-9,  0x1.ad4e4ba80709bp-10,
    0x1.c0e070381c0e0p-9,  0x1.60fba1a362bb0p-10, 0x1.a5713280dee96p-9,
    0x1.3f59620f9ece9p-10, 0x1.9f22983759f23p-9,  0x1.478ac63fc8d5cp-10,
    0x1.ad87bb4671656p-9,  0x1.78b8efbb8148cp-10, 0x1.d0369d0369d03p-9,
    0x1.d212b601b3748p-10, 0x1.b2036406c80d9p-15, 0x1.29663b24547d1p-9,
    0x1.435e50d79435ep-11, 0x1.7d0ff2920bc03p-9,  0x1.5c06b15c06b16p-10,
    0x1.e3a5f0fd7f954p-9,  0x1.1dec0d4c77b03p-9,  0x1.73289870ac52ep-11,
    0x1.a034da034da03p-9,  0x1.d041da2292856p-10, 0x1.a41a41a41a41ap-12,
    0x1.8550f8a39409dp-9,  0x1.b4fe5e92c0686p-10, 0x1.a01a01a01a01ap-12,
    0x1.91d2a2067b23ap-9,  0x1.e7c5dada0b4e5p-10, 0x1.68a7725080ce1p-11,
    0x1.c49d4aa21b490p-9,  0x1.3333333333333p-9,  0x1.4bc363b03fccfp-10,
    0x1.c9f01970e4f81p-13, 0x1.97617c6ef5b25p-9,  0x1.161f9add3c0cap-9,
    0x1.319fe6cb39806p-10, 0x1.f693a1c451ab3p-13, 0x1.a9e240321a9e2p-9,
    0x1.3831f3831f383p-9,  0x1.949ebc4dcfc1cp-10, 0x1.80c6980c6980cp-11,
    0x1.f9d00c5fe7403p-9,  0x1.9721ed7e75347p-9,  0x1.381ec0313381fp-9,
    0x1.b97c2aec12653p-10, 0x1.09ef3024ae3bap-10, 0x1.8618618618618p-12,
    0x1.e0184f00c2780p-9,  0x1.92ef5657dba52p-9,  0x1.4940305494030p-9,
    0x1.0303030303030p-9,  0x1.8060180601806p-10, 0x1.017f405fd017fp-10,
    0x1.12a8ad278e8ddp-11, 0x1.7d05f417d05f4p-14, 0x1.d67245c02f7d6p-9,
    0x1.a4411c1d986a9p-9,  0x1.754d76c7316dfp-9,  0x1.49902f149902fp-9,
    0x1.21023358c1a68p-9,  0x1.f7390d2a6c406p-10, 0x1.b2b0805d5b2b1p-10,
    0x1.745d1745d1746p-10, 0x1.3c31507fa32c4p-10, 0x1.0a1fd1b7af017p-10,
    0x1.bc36ce3e0453ap-11, 0x1.702e05c0b8170p-11, 0x1.300b79300b793p-11,
    0x1.f76b4337c6cb1p-12, 0x1.a62681c860fb0p-12, 0x1.6c16c16c16c17p-12,
    0x1.490aa31a3cfc7p-12, 0x1.3cd153729043ep-12, 0x1.473a88d0bfd2ep-12,
    0x1.6816816816817p-12, 0x1.9f36016719f36p-12, 0x1.ec6a5122f9016p-12,
    0x1.27c29da5519cfp-11, 0x1.642c8590b2164p-11, 0x1.ab5c45606f00bp-11,
    0x1.fd3b80b11fd3cp-11, 0x1.2cda0c6ba4eaap-10, 0x1.6058160581606p-10,
    0x1.990d0a4b7ef87p-10, 0x1.d6ee340579d6fp-10, 0x1.0cf87d9c54a69p-9,
    0x1.310572620ae4cp-9,  0x1.5798c8ff522a2p-9,  0x1.80ad602b580adp-9,
    0x1.ac3e24799546fp-9,  0x1.da46102b1da46p-9,  0x1.5805601580560p-14,
    0x1.ed3c506b39a23p-12, 0x1.cbdd3e2970f60p-11, 0x1.5555555555555p-10,
    0x1.c979aee0bf805p-10, 0x1.21291e81fd58ep-9,  0x1.5fead500a9580p-9,
    0x1.a0fd5c5f02a3ap-9,  0x1.e45c223898adcp-9,  0x1.5015015015015p-12,
    0x1.c7b16ea64d422p-11, 0x1.7829cbc14e5e1p-10, 0x1.0877db8589720p-9,
    0x1.5710e4b5edceap-9,  0x1.a7dbb4d1fc1c8p-9,  0x1.fad40a57eb503p-9,
    0x1.3fd6bb00a5140p-11, 0x1.4e78ecb419ba9p-10, 0x1.00a44029100a4p-9,
    0x1.5c28f5c28f5c3p-9,  0x1.b9c68b2c0cc4ap-9,  0x1.978feb9f34381p-13,
    0x1.ecf163bb6500ap-11, 0x1.be1958b67ebb9p-10, 0x1.44e6157dc9a3bp-9,
    0x1.acc4baa3f0ddfp-9,  0x1.6a4cbcb2a247bp-13, 0x1.0505050505050p-10,
    0x1.e0b4439959819p-10, 0x1.6027f6027f602p-9,  0x1.d1e854b5e0db4p-9,
    0x1.165e7254813e2p-11, 0x1.76646a9d716efp-10, 0x1.32b48f757ce88p-9,
    0x1.ac1b24652a906p-9,  0x1.3b13b13b13b14p-12, 0x1.490e1eb208984p-10,
    0x1.2385830fec66ep-9,  0x1.a45a6cc111b7ep-9,  0x1.3813813813814p-12,
    0x1.56f472517b708p-10, 0x1.31be7bc0e8f2ap-9,  0x1.b9cbf3e55f044p-9,
    0x1.0e7d95bc609a9p-11, 0x1.9e6b3804d19e7p-10, 0x1.5c8b6af7963c2p-9,
    0x1.eb9dad43bf402p-9,  0x1.f1a515885fb37p-11, 0x1.0eeb1d3d76c02p-9,
    0x1.a320261a32026p-9,  0x1.c82ac40260390p-12, 0x1.a12f684bda12fp-10,
    0x1.69d43fda2962cp-9,  0x1.2e025c04b8097p-15, 0x1.42804b542804bp-10,
    0x1.3f69b02593f6ap-9,  0x1.df31cb46e21fap-9,  0x1.012b404ad012bp-10,
    0x1.23925e7820a7fp-9,  0x1.c8253c8253c82p-9,  0x1.b92ddc02526e5p-11,
    0x1.1602511602511p-9,  0x1.bf471439c9adfp-9,  0x1.a85c40939a85cp-11,
    0x1.166f9ac024d16p-9,  0x1.c44e10125e227p-9,  0x1.cebf48bbd90e5p-11,
    0x1.2492492492492p-9,  0x1.d6f2e2ec0b673p-9,  0x1.159e26af37c05p-10,
    0x1.4024540245402p-9,  0x1.f6f0243f6f024p-9,  0x1.5e60121579805p-10,
    0x1.68e18cf81b10fp-9,  0x1.2012012012012p-12, 0x1.c11f7047dc11fp-10,
    0x1.9e878ff70985ep-9,  0x1.779d9fdc3a219p-11, 0x1.1eace5c957907p-9,
    0x1.e0d5b450239e1p-9,  0x1.48bf073816367p-10, 0x1.694808dda5202p-9,
    0x1.7c67f2bae2b21p-12, 0x1.ee58469ee5847p-10, 0x1.c0233c0233c02p-9,
    0x1.14e02328a7012p-10, 0x1.561072057b573p-9,  0x1.1811811811812p-12,
    0x1.e28646f5a1060p-10, 0x1.c0d1284e6f1d7p-9,  0x1.23543f0c80459p-10,
    0x1.63cbeea4e1a09p-9,  0x1.b9a3fdd5c8cb8p-12, 0x1.0be1c159a76d2p-9,
    0x1.e1d1a688e4838p-9,  0x1.72044d72044d7p-10, 0x1.91713db81577bp-9,
    0x1.ac73ae9819b50p-11, 0x1.460334e904cf6p-9,  0x1.1111111111111p-12,
    0x1.feef80441fef0p-10, 0x1.de021fde021fep-9,  0x1.7b7eacc9686a0p-10,
    0x1.9ead7cd391fbcp-9,  0x1.0195609804390p-10, 0x1.641511e8d2b32p-9,
    0x1.222b1acf1ce96p-11, 0x1.2e29f79b47582p-9,  0x1.4f0d1682e11cdp-13,
    0x1.f9bb096771e4dp-10, 0x1.e5ee45dd96ae2p-9,  0x1.a0429a0429a04p-10,
    0x1.bb74d5f06c021p-9,  0x1.4fce404254fcep-10, 0x1.95766eacbc402p-9,
    0x1.0842108421084p-10, 0x1.73e5371d5c338p-9,  0x1.930523fbe3368p-11,
    0x1.56b38f225f6c4p-9,  0x1.26e978d4fdf3bp-11, 0x1.3dd40e4eb0cc6p-9,
    0x1.97f7d73404146p-12, 0x1.293982cc98af1p-9,  0x1.0410410410410p-12,
    0x1.18d6f048ff7e4p-9,  0x1.236a3ebc349dep-13, 0x1.0c9f8ee53d18cp-9,
    0x1.0204081020408p-14, 0x1.0486ca2f46ea6p-9,  0x1.0101010101010p-16,
    0x1.0080402010080p-9,  0x0.0000000000000p+0,
};

CLC_TABLE_FUNCTION(double, LOG_F_INV_TBL_TAIL, log_f_inv_tbl_tail);

DECLARE_TABLE(double, POWLOG_TBL_HEAD, 258) = {
    0x0.0000000000000p+0, 0x1.ff00aa0000000p-9, 0x1.fe02a60000000p-8,
    0x1.7dc4750000000p-7, 0x1.fc0a8b0000000p-7, 0x1.3cea440000000p-6,
    0x1.7b91b00000000p-6, 0x1.b9fc020000000p-6, 0x1.f829b00000000p-6,
    0x1.1b0d980000000p-5, 0x1.39e87b0000000p-5, 0x1.58a5ba0000000p-5,
    0x1.77458f0000000p-5, 0x1.95c8300000000p-5, 0x1.b42dd70000000p-5,
    0x1.d276b80000000p-5, 0x1.f0a30c0000000p-5, 0x1.0759830000000p-4,
    0x1.16536e0000000p-4, 0x1.253f620000000p-4, 0x1.341d790000000p-4,
    0x1.42edcb0000000p-4, 0x1.51b0730000000p-4, 0x1.60658a0000000p-4,
    0x1.6f0d280000000p-4, 0x1.7da7660000000p-4, 0x1.8c345d0000000p-4,
    0x1.9ab4240000000p-4, 0x1.a926d30000000p-4, 0x1.b78c820000000p-4,
    0x1.c5e5480000000p-4, 0x1.d4313d0000000p-4, 0x1.e270760000000p-4,
    0x1.f0a30c0000000p-4, 0x1.fec9130000000p-4, 0x1.0671510000000p-3,
    0x1.0d77e70000000p-3, 0x1.1478580000000p-3, 0x1.1b72ad0000000p-3,
    0x1.2266f10000000p-3, 0x1.29552f0000000p-3, 0x1.303d710000000p-3,
    0x1.371fc20000000p-3, 0x1.3dfc2b0000000p-3, 0x1.44d2b60000000p-3,
    0x1.4ba36f0000000p-3, 0x1.526e5e0000000p-3, 0x1.59338d0000000p-3,
    0x1.5ff3070000000p-3, 0x1.66acd40000000p-3, 0x1.6d60fe0000000p-3,
    0x1.740f8f0000000p-3, 0x1.7ab8900000000p-3, 0x1.815c0a0000000p-3,
    0x1.87fa060000000p-3, 0x1.8e928d0000000p-3, 0x1.9525a90000000p-3,
    0x1.9bb3620000000p-3, 0x1.a23bc10000000p-3, 0x1.a8becf0000000p-3,
    0x1.af3c940000000p-3, 0x1.b5b5190000000p-3, 0x1.bc28670000000p-3,
    0x1.c296850000000p-3, 0x1.c8ff7c0000000p-3, 0x1.cf63540000000p-3,
    0x1.d5c2160000000p-3, 0x1.dc1bca0000000p-3, 0x1.e270760000000p-3,
    0x1.e8c0250000000p-3, 0x1.ef0adc0000000p-3, 0x1.f550a50000000p-3,
    0x1.fb91860000000p-3, 0x1.00e6c40000000p-2, 0x1.0402590000000p-2,
    0x1.071b850000000p-2, 0x1.0a324e0000000p-2, 0x1.0d46b50000000p-2,
    0x1.1058bf0000000p-2, 0x1.1368700000000p-2, 0x1.1675ca0000000p-2,
    0x1.1980d20000000p-2, 0x1.1c898c0000000p-2, 0x1.1f8ff90000000p-2,
    0x1.22941f0000000p-2, 0x1.2596010000000p-2, 0x1.2895a10000000p-2,
    0x1.2b93030000000p-2, 0x1.2e8e2b0000000p-2, 0x1.31871c0000000p-2,
    0x1.347dd90000000p-2, 0x1.3772660000000p-2, 0x1.3a64c50000000p-2,
    0x1.3d54fa0000000p-2, 0x1.4043080000000p-2, 0x1.432ef20000000p-2,
    0x1.4618bc0000000p-2, 0x1.4900680000000p-2, 0x1.4be5f90000000p-2,
    0x1.4ec9730000000p-2, 0x1.51aad80000000p-2, 0x1.548a2c0000000p-2,
    0x1.5767710000000p-2, 0x1.5a42ab0000000p-2, 0x1.5d1bdb0000000p-2,
    0x1.5ff3070000000p-2, 0x1.62c82f0000000p-2, 0x1.659b570000000p-2,
    0x1.686c810000000p-2, 0x1.6b3bb20000000p-2, 0x1.6e08ea0000000p-2,
    0x1.70d42e0000000p-2, 0x1.739d7f0000000p-2, 0x1.7664e10000000p-2,
    0x1.792a550000000p-2, 0x1.7bede00000000p-2, 0x1.7eaf830000000p-2,
    0x1.816f410000000p-2, 0x1.842d1d0000000p-2, 0x1.86e9190000000p-2,
    0x1.89a3380000000p-2, 0x1.8c5b7c0000000p-2, 0x1.8f11e80000000p-2,
    0x1.91c67e0000000p-2, 0x1.9479410000000p-2, 0x1.972a340000000p-2,
    0x1.99d9580000000p-2, 0x1.9c86b00000000p-2, 0x1.9f323e0000000p-2,
    0x1.a1dc060000000p-2, 0x1.a484090000000p-2, 0x1.a72a490000000p-2,
    0x1.a9cec90000000p-2, 0x1.ac718c0000000p-2, 0x1.af12930000000p-2,
    0x1.b1b1e00000000p-2, 0x1.b44f770000000p-2, 0x1.b6eb590000000p-2,
    0x1.b985890000000p-2, 0x1.bc1e080000000p-2, 0x1.beb4d90000000p-2,
    0x1.c149ff0000000p-2, 0x1.c3dd7a0000000p-2, 0x1.c66f4e0000000p-2,
    0x1.c8ff7c0000000p-2, 0x1.cb8e070000000p-2, 0x1.ce1af00000000p-2,
    0x1.d0a63a0000000p-2, 0x1.d32fe70000000p-2, 0x1.d5b7f90000000p-2,
    0x1.d83e720000000p-2, 0x1.dac3530000000p-2, 0x1.dd46a00000000p-2,
    0x1.dfc8590000000p-2, 0x1.e248810000000p-2, 0x1.e4c71a0000000p-2,
    0x1.e744260000000p-2, 0x1.e9bfa60000000p-2, 0x1.ec399d0000000p-2,
    0x1.eeb20c0000000p-2, 0x1.f128f50000000p-2, 0x1.f39e5b0000000p-2,
    0x1.f6123f0000000p-2, 0x1.f884a30000000p-2, 0x1.faf5880000000p-2,
    0x1.fd64f20000000p-2, 0x1.ffd2e00000000p-2, 0x1.011fab0000000p-1,
    0x1.02552a0000000p-1, 0x1.0389ee0000000p-1, 0x1.04bdf90000000p-1,
    0x1.05f14b0000000p-1, 0x1.0723e50000000p-1, 0x1.0855c80000000p-1,
    0x1.0986f40000000p-1, 0x1.0ab76b0000000p-1, 0x1.0be72e0000000p-1,
    0x1.0d163c0000000p-1, 0x1.0e44980000000p-1, 0x1.0f72410000000p-1,
    0x1.109f390000000p-1, 0x1.11cb810000000p-1, 0x1.12f7190000000p-1,
    0x1.1422020000000p-1, 0x1.154c3d0000000p-1, 0x1.1675ca0000000p-1,
    0x1.179eab0000000p-1, 0x1.18c6e00000000p-1, 0x1.19ee6b0000000p-1,
    0x1.1b154b0000000p-1, 0x1.1c3b810000000p-1, 0x1.1d610f0000000p-1,
    0x1.1e85f50000000p-1, 0x1.1faa340000000p-1, 0x1.20cdcd0000000p-1,
    0x1.21f0bf0000000p-1, 0x1.23130d0000000p-1, 0x1.2434b60000000p-1,
    0x1.2555bc0000000p-1, 0x1.2676200000000p-1, 0x1.2795e10000000p-1,
    0x1.28b5000000000p-1, 0x1.29d37f0000000p-1, 0x1.2af15f0000000p-1,
    0x1.2c0e9e0000000p-1, 0x1.2d2b400000000p-1, 0x1.2e47430000000p-1,
    0x1.2f62a90000000p-1, 0x1.307d730000000p-1, 0x1.3197a00000000p-1,
    0x1.32b1330000000p-1, 0x1.33ca2b0000000p-1, 0x1.34e2890000000p-1,
    0x1.35fa4e0000000p-1, 0x1.37117b0000000p-1, 0x1.38280f0000000p-1,
    0x1.393e0d0000000p-1, 0x1.3a53730000000p-1, 0x1.3b68440000000p-1,
    0x1.3c7c7f0000000p-1, 0x1.3d90260000000p-1, 0x1.3ea3390000000p-1,
    0x1.3fb5b80000000p-1, 0x1.40c7a40000000p-1, 0x1.41d8fe0000000p-1,
    0x1.42e9c60000000p-1, 0x1.43f9fe0000000p-1, 0x1.4509a50000000p-1,
    0x1.4618bc0000000p-1, 0x1.4727430000000p-1, 0x1.48353d0000000p-1,
    0x1.4942a80000000p-1, 0x1.4a4f850000000p-1, 0x1.4b5bd60000000p-1,
    0x1.4c679a0000000p-1, 0x1.4d72d30000000p-1, 0x1.4e7d810000000p-1,
    0x1.4f87a30000000p-1, 0x1.50913c0000000p-1, 0x1.519a4c0000000p-1,
    0x1.52a2d20000000p-1, 0x1.53aad00000000p-1, 0x1.54b2460000000p-1,
    0x1.55b9350000000p-1, 0x1.56bf9d0000000p-1, 0x1.57c57f0000000p-1,
    0x1.58cadb0000000p-1, 0x1.59cfb20000000p-1, 0x1.5ad4040000000p-1,
    0x1.5bd7d30000000p-1, 0x1.5cdb1d0000000p-1, 0x1.5ddde50000000p-1,
    0x1.5ee02a0000000p-1, 0x1.5fe1ed0000000p-1, 0x1.60e32f0000000p-1,
    0x1.61e3ef0000000p-1, 0x1.62e42e0000000p-1, 0x0.0000000000000p+0,
};

CLC_TABLE_FUNCTION(double, POWLOG_TBL_HEAD, powlog_tbl_head);

DECLARE_TABLE(double, POWLOG_TBL_TAIL, 258) = {
    0x0.0000000000000p+0,  0x1.5885e0250435ap-36, 0x1.620cf11f86ed2p-33,
    0x1.f0214edba4a25p-32, 0x1.f807c79f3db4ep-36, 0x1.a352ba779a52bp-33,
    0x1.f56c46aa49fd5p-32, 0x1.ebe465fef5196p-32, 0x1.cf0660099f1f8p-31,
    0x1.247b2ff85945dp-30, 0x1.3fd7abf5202b6p-30, 0x1.f91c9a918d51ep-30,
    0x1.8cb73f118d3cap-31, 0x1.d91c7d6fad074p-30, 0x1.1971bec28d14cp-33,
    0x1.5b616a423c78ap-30, 0x1.162a6617cc971p-37, 0x1.66391c4c06d29p-30,
    0x1.d46f5c1d0c4b8p-29, 0x1.e14282df1f6d3p-29, 0x1.86f47424a660dp-30,
    0x1.d4c8de077753ep-29, 0x1.e0c307ed24f1cp-29, 0x1.26ea18763bdd3p-29,
    0x1.5cad69737c933p-29, 0x1.af62599088901p-29, 0x1.8c66c83d6b2d0p-30,
    0x1.880ceb36fb30fp-30, 0x1.495aac6ca17a4p-29, 0x1.761db4210878cp-29,
    0x1.eb78e862bac2fp-29, 0x1.9b2cd75790dd9p-30, 0x1.c55e5cbd3d50fp-29,
    0x1.162a6617cc971p-36, 0x1.dbeabaaa2e519p-32, 0x1.652cb7150c647p-30,
    0x1.9a11cb2cd2ee2p-28, 0x1.19d0ab1a28813p-29, 0x1.4bd9e80a41811p-29,
    0x1.214b596faa3dfp-28, 0x1.03fea46980bb8p-28, 0x1.1c8ffa5fd28c7p-28,
    0x1.e8f743bcd96c5p-35, 0x1.d98c5395315c6p-32, 0x1.996fa3ccfa7b2p-28,
    0x1.cd2af2ad13037p-30, 0x1.d0da1bd17200ep-30, 0x1.330410ba68b75p-28,
    0x1.4f27a790e7c41p-32, 0x1.3956a86f6ff1bp-30, 0x1.c6748723551d9p-29,
    0x1.500de9326cdfcp-29, 0x1.086c848df1b59p-30, 0x1.4357ead6836ffp-31,
    0x1.4832442408024p-29, 0x1.d10da8154b13dp-28, 0x1.9e8ad68ec8260p-28,
    0x1.cfbf706abaf18p-28, 0x1.fc56ac6326e23p-28, 0x1.9105e3185cf21p-28,
    0x1.d017fe5b19cc0p-28, 0x1.d1f6b48dd13fep-28, 0x1.0b63358a7e73ap-29,
    0x1.63063028c211cp-29, 0x1.e6a6886b09760p-29, 0x1.c138bb891cd03p-28,
    0x1.69f7722b7221ap-28, 0x1.57d8fac1a628cp-32, 0x1.c55e5cbd3d50fp-28,
    0x1.552d2ff48fe2ep-30, 0x1.7b8b26ca431bcp-28, 0x1.92decdc1c5f6dp-29,
    0x1.abc7c551aaa8cp-28, 0x1.6b540731a354bp-28, 0x1.2d341036b89efp-28,
    0x1.f9ab21a3a2e0fp-27, 0x1.39c871afb9fbdp-29, 0x1.e6add2c81f640p-28,
    0x1.35c95aa313f41p-27, 0x1.49d4582f6cc53p-29, 0x1.7574c1c07398fp-27,
    0x1.ba846dece9e8dp-27, 0x1.6999fafbc68e7p-30, 0x1.c9145e51b0103p-27,
    0x1.79ef2cb44850ap-27, 0x1.beec73de11275p-31, 0x1.ef4351af5a498p-29,
    0x1.5713a493b4a50p-27, 0x1.5c23a61385992p-27, 0x1.2a88309f57299p-27,
    0x1.530faa9ac8acep-27, 0x1.5fec2d792a758p-29, 0x1.5a517a71cbcd7p-28,
    0x1.707dc3e1cd9a3p-28, 0x1.a1a9f8ef43049p-28, 0x1.409d0276b3674p-27,
    0x1.0e2f613e85bd9p-29, 0x1.0027433001e5fp-32, 0x1.5dde2836d3265p-28,
    0x1.300134d7aaf04p-29, 0x1.cb7e0b42724f5p-28, 0x1.d6e93167e6308p-29,
    0x1.d1569b1526adbp-28, 0x1.e99fc338a1a41p-31, 0x1.eb01394a11b1cp-27,
    0x1.4f27a790e7c41p-31, 0x1.5ce3ca97b7af9p-29, 0x1.81f0f940ed857p-29,
    0x1.d36295d88857cp-27, 0x1.1aca1ec4af526p-29, 0x1.45743c7182726p-27,
    0x1.3c491aead337ep-29, 0x1.aef401a738931p-28, 0x1.1cede76092a29p-29,
    0x1.fba8f44f82bb4p-27, 0x1.46f5f7f3c3e1ap-27, 0x1.7055f86c9674bp-27,
    0x1.b41a92b6b6e1ap-27, 0x1.43d162e927628p-27, 0x1.466174013f9b1p-27,
    0x1.b05096ad69c62p-28, 0x1.0b169150faa58p-27, 0x1.cd98b1df85da7p-28,
    0x1.68b507b0f8fa8p-27, 0x1.8422df57499bap-27, 0x1.1351586970274p-30,
    0x1.17e08acba92eep-30, 0x1.6e04314dd0229p-29, 0x1.97f3097e56d1ap-27,
    0x1.356e655901286p-28, 0x1.cb761457f94d6p-31, 0x1.9af67a85a9dacp-28,
    0x1.53410931a909fp-27, 0x1.2c587206058f5p-29, 0x1.23bc358899c22p-29,
    0x1.d7bf8b6d223cbp-27, 0x1.7991ec5197ddbp-27, 0x1.a79e6bb3a9219p-27,
    0x1.a4c43ed663ec5p-28, 0x1.61b5a1484f438p-27, 0x1.b4e36f7ef0c3ap-27,
    0x1.15f026acd0d1bp-30, 0x1.f36b535cecf05p-28, 0x1.ffb7fbf3eb5c6p-29,
    0x1.e6a6886b09760p-28, 0x1.135eb27f5bbc3p-28, 0x1.70be7d6f6fa57p-27,
    0x1.ce43cc84ab338p-27, 0x1.c01d7aac3bd91p-27, 0x1.5c58d07961060p-27,
    0x1.628bcf941456ep-28, 0x1.c58b2a8461cd2p-27, 0x1.3071282fb989ap-28,
    0x1.20dab6a80f09cp-27, 0x1.4f8d84c397b1ep-27, 0x1.0d0ee08599e48p-27,
    0x1.d68787e37da36p-30, 0x1.66187d591bafcp-28, 0x1.2346600bae772p-29,
    0x1.90377d0d61b8ep-28, 0x1.f5e0dd966b907p-27, 0x1.9023cb79a00e2p-27,
    0x1.4e05158c28ad8p-27, 0x1.bfa7b08b18ae4p-28, 0x1.ef1e63db35f67p-27,
    0x1.ec2ae39493d4fp-31, 0x1.0afe930ab2fa0p-27, 0x1.25ff8a1810dd4p-29,
    0x1.69743fb1a71a5p-27, 0x1.f9cc676785571p-26, 0x1.b524da4cbf982p-26,
    0x1.a4c8b381535b8p-26, 0x1.839be809caf2cp-26, 0x1.0968a1cb82c13p-26,
    0x1.eae6a41723fb5p-26, 0x1.d9c29a380a4dbp-26, 0x1.094aa0ada625ep-27,
    0x1.973ad6fc108cap-26, 0x1.747322fdbab97p-27, 0x1.93692fa9d4221p-26,
    0x1.c5a992dfbc7d9p-26, 0x1.e1f33e102387ap-27, 0x1.64fbef14c048cp-27,
    0x1.490f513ca5e3bp-27, 0x1.7a6af4d4c799dp-28, 0x1.7574c1c07398fp-26,
    0x1.7b133417f8c1cp-26, 0x1.feb9e0c176514p-26, 0x1.19f25bb3172f7p-27,
    0x1.5f68a7bbfb852p-27, 0x1.ee278497929f1p-26, 0x1.ccee006109d58p-26,
    0x1.ce081a07bd8b3p-26, 0x1.70e12981817b8p-26, 0x1.92ab6d93503d0p-29,
    0x1.8cb7dd7c3b61ep-26, 0x1.efafd0a0b78dap-27, 0x1.e907267c4288ep-26,
    0x1.d31ef96780875p-26, 0x1.3430dfcd2ad50p-29, 0x1.44d88d75bc1f9p-28,
    0x1.bec0f055e04fcp-26, 0x1.d85611590b9adp-26, 0x1.320568e583229p-32,
    0x1.a891d1772f538p-26, 0x1.2edc9dabba74dp-29, 0x1.b9009a1015086p-27,
    0x1.2a12a8c5b1a19p-26, 0x1.a7885f0fdac85p-28, 0x1.f4ffcd43ac691p-26,
    0x1.2243ae2640aadp-26, 0x1.46513299035d3p-26, 0x1.b39c3a62dd725p-26,
    0x1.ba6dd40049f51p-26, 0x1.51d1ed7177409p-27, 0x1.cb0f2fd7f5216p-26,
    0x1.ab150cd4e2213p-28, 0x1.cfd7bf3193844p-26, 0x1.3fff8455f1dbdp-26,
    0x1.fee640b905fc9p-26, 0x1.4e2adf548084cp-26, 0x1.b597adc1ecdd2p-28,
    0x1.345bd096d3a75p-27, 0x1.101b9d2453c8bp-26, 0x1.08ce55cc8c979p-26,
    0x1.bbf017e595f71p-26, 0x1.7ce733bd393dcp-28, 0x1.33bb0a503f8a1p-29,
    0x1.0e2f613e85bd9p-28, 0x1.e67555a635b3cp-26, 0x1.ea88df73d5e8bp-29,
    0x1.d17e03bda18a8p-28, 0x1.b607d76044f7ep-26, 0x1.2adc4e71bc2fcp-26,
    0x1.f99dc7362d1d9p-26, 0x1.473fa008e6a6ap-26, 0x1.b75bb09cb0985p-29,
    0x1.ea04dd10b9abap-26, 0x1.802d0d6979674p-26, 0x1.74688ccd99094p-30,
    0x1.96f16abb9df22p-27, 0x1.6e66df2aa374fp-27, 0x1.e66525ea4550ap-27,
    0x1.2d02f34f20cbdp-27, 0x1.6cfce65047188p-27, 0x1.9b78c842d58b8p-28,
    0x1.735e624c24bc9p-27, 0x1.7eba1f7dd1adfp-27, 0x1.86b3e59f65355p-26,
    0x1.ce38e637f1b4dp-30, 0x1.8d82ec919edc7p-26, 0x1.c52648ddcfa37p-27,
    0x1.2482ceae1ac12p-26, 0x1.5a312311aba4fp-26, 0x1.11e236329f225p-27,
    0x1.b48c8cd2f246cp-26, 0x1.efa39ef35793cp-25, 0x0.0000000000000p+0,
};

CLC_TABLE_FUNCTION(double, POWLOG_TBL_TAIL, powlog_tbl_tail);

DECLARE_TABLE(double, TWO_TO_JBY64_EP_HEAD, 64) = {
    0x1.0000000000000p+0, 0x1.02c9a30000000p+0, 0x1.059b0d0000000p+0,
    0x1.0874510000000p+0, 0x1.0b55860000000p+0, 0x1.0e3ec30000000p+0,
    0x1.11301d0000000p+0, 0x1.1429aa0000000p+0, 0x1.172b830000000p+0,
    0x1.1a35be0000000p+0, 0x1.1d48730000000p+0, 0x1.2063b80000000p+0,
    0x1.2387a60000000p+0, 0x1.26b4560000000p+0, 0x1.29e9df0000000p+0,
    0x1.2d285a0000000p+0, 0x1.306fe00000000p+0, 0x1.33c08b0000000p+0,
    0x1.371a730000000p+0, 0x1.3a7db30000000p+0, 0x1.3dea640000000p+0,
    0x1.4160a20000000p+0, 0x1.44e0860000000p+0, 0x1.486a2b0000000p+0,
    0x1.4bfdad0000000p+0, 0x1.4f9b270000000p+0, 0x1.5342b50000000p+0,
    0x1.56f4730000000p+0, 0x1.5ab07d0000000p+0, 0x1.5e76f10000000p+0,
    0x1.6247eb0000000p+0, 0x1.6623880000000p+0, 0x1.6a09e60000000p+0,
    0x1.6dfb230000000p+0, 0x1.71f75e0000000p+0, 0x1.75feb50000000p+0,
    0x1.7a11470000000p+0, 0x1.7e2f330000000p+0, 0x1.8258990000000p+0,
    0x1.868d990000000p+0, 0x1.8ace540000000p+0, 0x1.8f1ae90000000p+0,
    0x1.93737b0000000p+0, 0x1.97d8290000000p+0, 0x1.9c49180000000p+0,
    0x1.a0c6670000000p+0, 0x1.a5503b0000000p+0, 0x1.a9e6b50000000p+0,
    0x1.ae89f90000000p+0, 0x1.b33a2b0000000p+0, 0x1.b7f76f0000000p+0,
    0x1.bcc1e90000000p+0, 0x1.c199bd0000000p+0, 0x1.c67f120000000p+0,
    0x1.cb720d0000000p+0, 0x1.d072d40000000p+0, 0x1.d5818d0000000p+0,
    0x1.da9e600000000p+0, 0x1.dfc9730000000p+0, 0x1.e502ee0000000p+0,
    0x1.ea4afa0000000p+0, 0x1.efa1be0000000p+0, 0x1.f507650000000p+0,
    0x1.fa7c180000000p+0,
};

CLC_TABLE_FUNCTION(double, TWO_TO_JBY64_EP_HEAD, two_to_jby64_ep_tbl_head);

DECLARE_TABLE(double, TWO_TO_JBY64_EP_TAIL, 64) = {
    0x0.0000000000000p+0,  0x1.cef00c1dcdef9p-25, 0x1.8ac2ba1d73e2ap-27,
    0x1.0eb37901186bep-25, 0x1.9f3121ec53172p-25, 0x1.69e8d10103a17p-27,
    0x1.25b50a4ebbf1ap-32, 0x1.d525bbf668203p-25, 0x1.8faa2f5b9bef9p-25,
    0x1.6df96ea796d31p-25, 0x1.68b9aa7805b80p-28, 0x1.0c519ac771dd6p-25,
    0x1.ceac470cd83f5p-25, 0x1.789f37495e99cp-26, 0x1.47f7b84b09745p-26,
    0x1.b900c2d002475p-26, 0x1.4636e2a5bd1abp-25, 0x1.320b7fa64e430p-27,
    0x1.ceaa72a9c5154p-26, 0x1.3967fdba86f24p-26, 0x1.82468446b6824p-25,
    0x1.f72e29f84325bp-28, 0x1.8624b40c4dbd0p-30, 0x1.704f3404f068ep-26,
    0x1.4d8a89c750e5ep-26, 0x1.a74b29ab4cf62p-26, 0x1.a753e077c2a0fp-26,
    0x1.ad49f699bb2c0p-26, 0x1.a90a852b19260p-25, 0x1.6b48521ba6f93p-26,
    0x1.d2ac258f87d03p-31, 0x1.2a91124893ecfp-27, 0x1.9fcef32422cbep-26,
    0x1.8ca345de441c5p-25, 0x1.1d8bee7ba46e1p-25, 0x1.9099f22fdba6ap-26,
    0x1.f580c36bea881p-27, 0x1.b3d398841740ap-26, 0x1.2999c25159f11p-25,
    0x1.68925d901c83bp-25, 0x1.15506dadd3e2ap-27, 0x1.22aee6c57304ep-25,
    0x1.9b8bc9e8a0387p-29, 0x1.fbc9c9f173d24p-25, 0x1.51f8480e3e235p-27,
    0x1.6bbcac96535b5p-25, 0x1.1f12ae45a1224p-27, 0x1.5e7f6fd0fac90p-26,
    0x1.2b5a75abd0e69p-25, 0x1.09e2bf5ed7fa1p-25, 0x1.7daf237553d84p-27,
    0x1.2f074891ee83dp-30, 0x1.b0aa538444196p-25, 0x1.cafa29694426fp-25,
    0x1.9df20d22a0797p-25, 0x1.40f12f71a1e45p-25, 0x1.9f7490e4bb40bp-25,
    0x1.ed9942b84600dp-27, 0x1.bdcdaf5cb4656p-27, 0x1.e2cffd89cf44cp-26,
    0x1.52486cc2c7b9dp-27, 0x1.cc2b44eee3fa4p-25, 0x1.6dc8a80ce9f09p-25,
    0x1.9e90d82e90a7ep-28,
};

CLC_TABLE_FUNCTION(double, TWO_TO_JBY64_EP_TAIL, two_to_jby64_ep_tbl_tail);

DECLARE_TABLE(double, CBRT_INV_TBL, 257) = {
    0x1.0000000000000p+1, 0x1.fe01fe01fe020p+0, 0x1.fc07f01fc07f0p+0,
    0x1.fa11caa01fa12p+0, 0x1.f81f81f81f820p+0, 0x1.f6310aca0dbb5p+0,
    0x1.f44659e4a4271p+0, 0x1.f25f644230ab5p+0, 0x1.f07c1f07c1f08p+0,
    0x1.ee9c7f8458e02p+0, 0x1.ecc07b301ecc0p+0, 0x1.eae807aba01ebp+0,
    0x1.e9131abf0b767p+0, 0x1.e741aa59750e4p+0, 0x1.e573ac901e574p+0,
    0x1.e3a9179dc1a73p+0, 0x1.e1e1e1e1e1e1ep+0, 0x1.e01e01e01e01ep+0,
    0x1.de5d6e3f8868ap+0, 0x1.dca01dca01dcap+0, 0x1.dae6076b981dbp+0,
    0x1.d92f2231e7f8ap+0, 0x1.d77b654b82c34p+0, 0x1.d5cac807572b2p+0,
    0x1.d41d41d41d41dp+0, 0x1.d272ca3fc5b1ap+0, 0x1.d0cb58f6ec074p+0,
    0x1.cf26e5c44bfc6p+0, 0x1.cd85689039b0bp+0, 0x1.cbe6d9601cbe7p+0,
    0x1.ca4b3055ee191p+0, 0x1.c8b265afb8a42p+0, 0x1.c71c71c71c71cp+0,
    0x1.c5894d10d4986p+0, 0x1.c3f8f01c3f8f0p+0, 0x1.c26b5392ea01cp+0,
    0x1.c0e070381c0e0p+0, 0x1.bf583ee868d8bp+0, 0x1.bdd2b899406f7p+0,
    0x1.bc4fd65883e7bp+0, 0x1.bacf914c1bad0p+0, 0x1.b951e2b18ff23p+0,
    0x1.b7d6c3dda338bp+0, 0x1.b65e2e3beee05p+0, 0x1.b4e81b4e81b4fp+0,
    0x1.b37484ad806cep+0, 0x1.b2036406c80d9p+0, 0x1.b094b31d922a4p+0,
    0x1.af286bca1af28p+0, 0x1.adbe87f94905ep+0, 0x1.ac5701ac5701bp+0,
    0x1.aaf1d2f87ebfdp+0, 0x1.a98ef606a63bep+0, 0x1.a82e65130e159p+0,
    0x1.a6d01a6d01a6dp+0, 0x1.a574107688a4ap+0, 0x1.a41a41a41a41ap+0,
    0x1.a2c2a87c51ca0p+0, 0x1.a16d3f97a4b02p+0, 0x1.a01a01a01a01ap+0,
    0x1.9ec8e951033d9p+0, 0x1.9d79f176b682dp+0, 0x1.9c2d14ee4a102p+0,
    0x1.9ae24ea5510dap+0, 0x1.999999999999ap+0, 0x1.9852f0d8ec0ffp+0,
    0x1.970e4f80cb872p+0, 0x1.95cbb0be377aep+0, 0x1.948b0fcd6e9e0p+0,
    0x1.934c67f9b2ce6p+0, 0x1.920fb49d0e229p+0, 0x1.90d4f120190d5p+0,
    0x1.8f9c18f9c18fap+0, 0x1.8e6527af1373fp+0, 0x1.8d3018d3018d3p+0,
    0x1.8bfce8062ff3ap+0, 0x1.8acb90f6bf3aap+0, 0x1.899c0f601899cp+0,
    0x1.886e5f0abb04ap+0, 0x1.87427bcc092b9p+0, 0x1.8618618618618p+0,
    0x1.84f00c2780614p+0, 0x1.83c977ab2beddp+0, 0x1.82a4a0182a4a0p+0,
    0x1.8181818181818p+0, 0x1.8060180601806p+0, 0x1.7f405fd017f40p+0,
    0x1.7e225515a4f1dp+0, 0x1.7d05f417d05f4p+0, 0x1.7beb3922e017cp+0,
    0x1.7ad2208e0ecc3p+0, 0x1.79baa6bb6398bp+0, 0x1.78a4c8178a4c8p+0,
    0x1.77908119ac60dp+0, 0x1.767dce434a9b1p+0, 0x1.756cac201756dp+0,
    0x1.745d1745d1746p+0, 0x1.734f0c541fe8dp+0, 0x1.724287f46debcp+0,
    0x1.713786d9c7c09p+0, 0x1.702e05c0b8170p+0, 0x1.6f26016f26017p+0,
    0x1.6e1f76b4337c7p+0, 0x1.6d1a62681c861p+0, 0x1.6c16c16c16c17p+0,
    0x1.6b1490aa31a3dp+0, 0x1.6a13cd1537290p+0, 0x1.691473a88d0c0p+0,
    0x1.6816816816817p+0, 0x1.6719f3601671ap+0, 0x1.661ec6a5122f9p+0,
    0x1.6524f853b4aa3p+0, 0x1.642c8590b2164p+0, 0x1.63356b88ac0dep+0,
    0x1.623fa77016240p+0, 0x1.614b36831ae94p+0, 0x1.6058160581606p+0,
    0x1.5f66434292dfcp+0, 0x1.5e75bb8d015e7p+0, 0x1.5d867c3ece2a5p+0,
    0x1.5c9882b931057p+0, 0x1.5babcc647fa91p+0, 0x1.5ac056b015ac0p+0,
    0x1.59d61f123ccaap+0, 0x1.58ed2308158edp+0, 0x1.5805601580560p+0,
    0x1.571ed3c506b3ap+0, 0x1.56397ba7c52e2p+0, 0x1.5555555555555p+0,
    0x1.54725e6bb82fep+0, 0x1.5390948f40febp+0, 0x1.52aff56a8054bp+0,
    0x1.51d07eae2f815p+0, 0x1.50f22e111c4c5p+0, 0x1.5015015015015p+0,
    0x1.4f38f62dd4c9bp+0, 0x1.4e5e0a72f0539p+0, 0x1.4d843bedc2c4cp+0,
    0x1.4cab88725af6ep+0, 0x1.4bd3edda68fe1p+0, 0x1.4afd6a052bf5bp+0,
    0x1.4a27fad76014ap+0, 0x1.49539e3b2d067p+0, 0x1.4880522014880p+0,
    0x1.47ae147ae147bp+0, 0x1.46dce34596066p+0, 0x1.460cbc7f5cf9ap+0,
    0x1.453d9e2c776cap+0, 0x1.446f86562d9fbp+0, 0x1.43a2730abee4dp+0,
    0x1.42d6625d51f87p+0, 0x1.420b5265e5951p+0, 0x1.4141414141414p+0,
    0x1.40782d10e6566p+0, 0x1.3fb013fb013fbp+0, 0x1.3ee8f42a5af07p+0,
    0x1.3e22cbce4a902p+0, 0x1.3d5d991aa75c6p+0, 0x1.3c995a47babe7p+0,
    0x1.3bd60d9232955p+0, 0x1.3b13b13b13b14p+0, 0x1.3a524387ac822p+0,
    0x1.3991c2c187f63p+0, 0x1.38d22d366088ep+0, 0x1.3813813813814p+0,
    0x1.3755bd1c945eep+0, 0x1.3698df3de0748p+0, 0x1.35dce5f9f2af8p+0,
    0x1.3521cfb2b78c1p+0, 0x1.34679ace01346p+0, 0x1.33ae45b57bcb2p+0,
    0x1.32f5ced6a1dfap+0, 0x1.323e34a2b10bfp+0, 0x1.3187758e9ebb6p+0,
    0x1.30d190130d190p+0, 0x1.301c82ac40260p+0, 0x1.2f684bda12f68p+0,
    0x1.2eb4ea1fed14bp+0, 0x1.2e025c04b8097p+0, 0x1.2d50a012d50a0p+0,
    0x1.2c9fb4d812ca0p+0, 0x1.2bef98e5a3711p+0, 0x1.2b404ad012b40p+0,
    0x1.2a91c92f3c105p+0, 0x1.29e4129e4129ep+0, 0x1.293725bb804a5p+0,
    0x1.288b01288b013p+0, 0x1.27dfa38a1ce4dp+0, 0x1.27350b8812735p+0,
    0x1.268b37cd60127p+0, 0x1.25e22708092f1p+0, 0x1.2539d7e9177b2p+0,
    0x1.2492492492492p+0, 0x1.23eb79717605bp+0, 0x1.23456789abcdfp+0,
    0x1.22a0122a0122ap+0, 0x1.21fb78121fb78p+0, 0x1.21579804855e6p+0,
    0x1.20b470c67c0d9p+0, 0x1.2012012012012p+0, 0x1.1f7047dc11f70p+0,
    0x1.1ecf43c7fb84cp+0, 0x1.1e2ef3b3fb874p+0, 0x1.1d8f5672e4abdp+0,
    0x1.1cf06ada2811dp+0, 0x1.1c522fc1ce059p+0, 0x1.1bb4a4046ed29p+0,
    0x1.1b17c67f2bae3p+0, 0x1.1a7b9611a7b96p+0, 0x1.19e0119e0119ep+0,
    0x1.19453808ca29cp+0, 0x1.18ab083902bdbp+0, 0x1.1811811811812p+0,
    0x1.1778a191bd684p+0, 0x1.16e0689427379p+0, 0x1.1648d50fc3201p+0,
    0x1.15b1e5f75270dp+0, 0x1.151b9a3fdd5c9p+0, 0x1.1485f0e0acd3bp+0,
    0x1.13f0e8d344724p+0, 0x1.135c81135c811p+0, 0x1.12c8b89edc0acp+0,
    0x1.12358e75d3033p+0, 0x1.11a3019a74826p+0, 0x1.1111111111111p+0,
    0x1.107fbbe011080p+0, 0x1.0fef010fef011p+0, 0x1.0f5edfab325a2p+0,
    0x1.0ecf56be69c90p+0, 0x1.0e40655826011p+0, 0x1.0db20a88f4696p+0,
    0x1.0d24456359e3ap+0, 0x1.0c9714fbcda3bp+0, 0x1.0c0a7868b4171p+0,
    0x1.0b7e6ec259dc8p+0, 0x1.0af2f722eecb5p+0, 0x1.0a6810a6810a7p+0,
    0x1.09ddba6af8360p+0, 0x1.0953f39010954p+0, 0x1.08cabb37565e2p+0,
    0x1.0842108421084p+0, 0x1.07b9f29b8eae2p+0, 0x1.073260a47f7c6p+0,
    0x1.06ab59c7912fbp+0, 0x1.0624dd2f1a9fcp+0, 0x1.059eea0727586p+0,
    0x1.05197f7d73404p+0, 0x1.04949cc1664c5p+0, 0x1.0410410410410p+0,
    0x1.038c6b78247fcp+0, 0x1.03091b51f5e1ap+0, 0x1.02864fc7729e9p+0,
    0x1.0204081020408p+0, 0x1.0182436517a37p+0, 0x1.0101010101010p+0,
    0x1.0080402010080p+0, 0x1.0000000000000p+0,
};

CLC_TABLE_FUNCTION(double, CBRT_INV_TBL, cbrt_inv_tbl);

DECLARE_TABLE(double, CBRT_DBL_TBL_HEAD, 257) = {
    0x1.0000000000000p+0, 0x1.0055380000000p+0, 0x1.00aa390000000p+0,
    0x1.00ff010000000p+0, 0x1.0153920000000p+0, 0x1.01a7eb0000000p+0,
    0x1.01fc0d0000000p+0, 0x1.024ff80000000p+0, 0x1.02a3ad0000000p+0,
    0x1.02f72b0000000p+0, 0x1.034a750000000p+0, 0x1.039d880000000p+0,
    0x1.03f0670000000p+0, 0x1.0443110000000p+0, 0x1.0495870000000p+0,
    0x1.04e7c80000000p+0, 0x1.0539d60000000p+0, 0x1.058bb00000000p+0,
    0x1.05dd570000000p+0, 0x1.062ecc0000000p+0, 0x1.06800e0000000p+0,
    0x1.06d11e0000000p+0, 0x1.0721fc0000000p+0, 0x1.0772a80000000p+0,
    0x1.07c3230000000p+0, 0x1.08136d0000000p+0, 0x1.0863860000000p+0,
    0x1.08b36f0000000p+0, 0x1.0903280000000p+0, 0x1.0952b10000000p+0,
    0x1.09a20a0000000p+0, 0x1.09f1340000000p+0, 0x1.0a402f0000000p+0,
    0x1.0a8efc0000000p+0, 0x1.0add990000000p+0, 0x1.0b2c090000000p+0,
    0x1.0b7a4b0000000p+0, 0x1.0bc85f0000000p+0, 0x1.0c16450000000p+0,
    0x1.0c63fe0000000p+0, 0x1.0cb18b0000000p+0, 0x1.0cfeeb0000000p+0,
    0x1.0d4c1e0000000p+0, 0x1.0d99250000000p+0, 0x1.0de6010000000p+0,
    0x1.0e32b00000000p+0, 0x1.0e7f340000000p+0, 0x1.0ecb8d0000000p+0,
    0x1.0f17bb0000000p+0, 0x1.0f63bf0000000p+0, 0x1.0faf970000000p+0,
    0x1.0ffb460000000p+0, 0x1.1046cb0000000p+0, 0x1.1092250000000p+0,
    0x1.10dd560000000p+0, 0x1.11285e0000000p+0, 0x1.11733d0000000p+0,
    0x1.11bdf30000000p+0, 0x1.1208800000000p+0, 0x1.1252e40000000p+0,
    0x1.129d210000000p+0, 0x1.12e7350000000p+0, 0x1.1331210000000p+0,
    0x1.137ae60000000p+0, 0x1.13c4840000000p+0, 0x1.140dfa0000000p+0,
    0x1.1457490000000p+0, 0x1.14a0710000000p+0, 0x1.14e9730000000p+0,
    0x1.15324e0000000p+0, 0x1.157b030000000p+0, 0x1.15c3920000000p+0,
    0x1.160bfc0000000p+0, 0x1.16543f0000000p+0, 0x1.169c5d0000000p+0,
    0x1.16e4560000000p+0, 0x1.172c2a0000000p+0, 0x1.1773d90000000p+0,
    0x1.17bb630000000p+0, 0x1.1802c90000000p+0, 0x1.184a0a0000000p+0,
    0x1.1891270000000p+0, 0x1.18d8210000000p+0, 0x1.191ef60000000p+0,
    0x1.1965a80000000p+0, 0x1.19ac360000000p+0, 0x1.19f2a10000000p+0,
    0x1.1a38e90000000p+0, 0x1.1a7f0e0000000p+0, 0x1.1ac5100000000p+0,
    0x1.1b0af00000000p+0, 0x1.1b50ad0000000p+0, 0x1.1b96480000000p+0,
    0x1.1bdbc10000000p+0, 0x1.1c21180000000p+0, 0x1.1c664d0000000p+0,
    0x1.1cab610000000p+0, 0x1.1cf0530000000p+0, 0x1.1d35230000000p+0,
    0x1.1d79d30000000p+0, 0x1.1dbe620000000p+0, 0x1.1e02cf0000000p+0,
    0x1.1e471d0000000p+0, 0x1.1e8b490000000p+0, 0x1.1ecf550000000p+0,
    0x1.1f13410000000p+0, 0x1.1f570d0000000p+0, 0x1.1f9ab90000000p+0,
    0x1.1fde450000000p+0, 0x1.2021b20000000p+0, 0x1.2064ff0000000p+0,
    0x1.20a82c0000000p+0, 0x1.20eb3b0000000p+0, 0x1.212e2a0000000p+0,
    0x1.2170fb0000000p+0, 0x1.21b3ac0000000p+0, 0x1.21f63f0000000p+0,
    0x1.2238b40000000p+0, 0x1.227b0a0000000p+0, 0x1.22bd420000000p+0,
    0x1.22ff5c0000000p+0, 0x1.2341570000000p+0, 0x1.2383350000000p+0,
    0x1.23c4f60000000p+0, 0x1.2406980000000p+0, 0x1.24481d0000000p+0,
    0x1.2489850000000p+0, 0x1.24cad00000000p+0, 0x1.250bfe0000000p+0,
    0x1.254d0e0000000p+0, 0x1.258e020000000p+0, 0x1.25ced90000000p+0,
    0x1.260f940000000p+0, 0x1.2650320000000p+0, 0x1.2690b40000000p+0,
    0x1.26d1190000000p+0, 0x1.2711630000000p+0, 0x1.2751900000000p+0,
    0x1.2791a20000000p+0, 0x1.27d1980000000p+0, 0x1.2811720000000p+0,
    0x1.2851310000000p+0, 0x1.2890d50000000p+0, 0x1.28d05d0000000p+0,
    0x1.290fca0000000p+0, 0x1.294f1c0000000p+0, 0x1.298e530000000p+0,
    0x1.29cd700000000p+0, 0x1.2a0c710000000p+0, 0x1.2a4b580000000p+0,
    0x1.2a8a250000000p+0, 0x1.2ac8d70000000p+0, 0x1.2b076f0000000p+0,
    0x1.2b45ec0000000p+0, 0x1.2b84500000000p+0, 0x1.2bc29a0000000p+0,
    0x1.2c00c90000000p+0, 0x1.2c3ee00000000p+0, 0x1.2c7cdc0000000p+0,
    0x1.2cbabf0000000p+0, 0x1.2cf8880000000p+0, 0x1.2d36390000000p+0,
    0x1.2d73d00000000p+0, 0x1.2db14d0000000p+0, 0x1.2deeb20000000p+0,
    0x1.2e2bfe0000000p+0, 0x1.2e69310000000p+0, 0x1.2ea64b0000000p+0,
    0x1.2ee34d0000000p+0, 0x1.2f20360000000p+0, 0x1.2f5d070000000p+0,
    0x1.2f99bf0000000p+0, 0x1.2fd65f0000000p+0, 0x1.3012e70000000p+0,
    0x1.304f570000000p+0, 0x1.308baf0000000p+0, 0x1.30c7ef0000000p+0,
    0x1.3104180000000p+0, 0x1.3140280000000p+0, 0x1.317c210000000p+0,
    0x1.31b8020000000p+0, 0x1.31f3cd0000000p+0, 0x1.322f7f0000000p+0,
    0x1.326b1b0000000p+0, 0x1.32a69f0000000p+0, 0x1.32e20c0000000p+0,
    0x1.331d620000000p+0, 0x1.3358a20000000p+0, 0x1.3393ca0000000p+0,
    0x1.33cedc0000000p+0, 0x1.3409d70000000p+0, 0x1.3444bc0000000p+0,
    0x1.347f8a0000000p+0, 0x1.34ba420000000p+0, 0x1.34f4e30000000p+0,
    0x1.352f6f0000000p+0, 0x1.3569e40000000p+0, 0x1.35a4430000000p+0,
    0x1.35de8c0000000p+0, 0x1.3618bf0000000p+0, 0x1.3652dd0000000p+0,
    0x1.368ce40000000p+0, 0x1.36c6d60000000p+0, 0x1.3700b30000000p+0,
    0x1.373a7a0000000p+0, 0x1.37742b0000000p+0, 0x1.37adc70000000p+0,
    0x1.37e74e0000000p+0, 0x1.3820c00000000p+0, 0x1.385a1c0000000p+0,
    0x1.3893640000000p+0, 0x1.38cc960000000p+0, 0x1.3905b40000000p+0,
    0x1.393ebd0000000p+0, 0x1.3977b10000000p+0, 0x1.39b0910000000p+0,
    0x1.39e95c0000000p+0, 0x1.3a22120000000p+0, 0x1.3a5ab40000000p+0,
    0x1.3a93410000000p+0, 0x1.3acbbb0000000p+0, 0x1.3b04200000000p+0,
    0x1.3b3c700000000p+0, 0x1.3b74ad0000000p+0, 0x1.3bacd60000000p+0,
    0x1.3be4eb0000000p+0, 0x1.3c1ceb0000000p+0, 0x1.3c54d90000000p+0,
    0x1.3c8cb20000000p+0, 0x1.3cc4770000000p+0, 0x1.3cfc2a0000000p+0,
    0x1.3d33c80000000p+0, 0x1.3d6b530000000p+0, 0x1.3da2cb0000000p+0,
    0x1.3dda2f0000000p+0, 0x1.3e11800000000p+0, 0x1.3e48be0000000p+0,
    0x1.3e7fe80000000p+0, 0x1.3eb7000000000p+0, 0x1.3eee040000000p+0,
    0x1.3f24f60000000p+0, 0x1.3f5bd40000000p+0, 0x1.3f92a00000000p+0,
    0x1.3fc9590000000p+0, 0x1.3fffff0000000p+0, 0x1.4036930000000p+0,
    0x1.406d140000000p+0, 0x1.40a3830000000p+0, 0x1.40d9df0000000p+0,
    0x1.4110290000000p+0, 0x1.4146600000000p+0, 0x1.417c850000000p+0,
    0x1.41b2980000000p+0, 0x1.41e8990000000p+0, 0x1.421e880000000p+0,
    0x1.4254640000000p+0, 0x1.428a2f0000000p+0,
};

CLC_TABLE_FUNCTION(double, CBRT_DBL_TBL_HEAD, cbrt_dbl_tbl_head);

DECLARE_TABLE(double, CBRT_DBL_TBL_TAIL, 257) = {
    0x0.0000000000000p+0,  0x1.e6a24c81e4294p-25, 0x1.8548511e3a785p-26,
    0x1.4eb9336ec07f6p-25, 0x1.0ea64b8b750e1p-27, 0x1.61637cff8a53cp-27,
    0x1.0733bf7bd1943p-27, 0x1.666911345ccedp-26, 0x1.77b7a3f592f14p-27,
    0x1.f18d3dd1a5402p-25, 0x1.be2f5a58ee9a4p-29, 0x1.8901f8f085fa7p-25,
    0x1.c68b8cd5b5d69p-26, 0x1.a6b0e8624be42p-26, 0x1.c4b22b06f68e7p-36,
    0x1.0f3f0afcabe9bp-25, 0x1.48495bca4e1b7p-26, 0x1.6107f1abdfdc3p-25,
    0x1.e67261878288ap-25, 0x1.a6bc155286f1ep-26, 0x1.8a759c64a85f2p-26,
    0x1.5fce70a4a8d09p-27, 0x1.2f9cbf373fe1dp-28, 0x1.90564ce4ac359p-26,
    0x1.ac29ce761b02fp-26, 0x1.cb752f497381cp-26, 0x1.8bb9e1cfb35e0p-25,
    0x1.5b4917099de90p-25, 0x1.cc77ac9c65ef2p-26, 0x1.7a0f3e7be3dbap-26,
    0x1.6ec851ee0c16fp-25, 0x1.89449bf2946dap-25, 0x1.98f25301ba223p-25,
    0x1.47d5ec651f549p-28, 0x1.c33ec9a86007ap-25, 0x1.e0b6653e92649p-26,
    0x1.bd64ac09d755fp-28, 0x1.f537506f78167p-29, 0x1.2c382d1b3735ep-25,
    0x1.e20ed659f99e1p-25, 0x1.86b633a9c182ap-26, 0x1.45cfd5a65e777p-27,
    0x1.0c8770f58bca4p-25, 0x1.739e44b0933c5p-25, 0x1.27dc3d9ce7bd8p-31,
    0x1.3c53c7c5a7b64p-25, 0x1.9669683830cecp-25, 0x1.8d772c39bdcc4p-25,
    0x1.9b0008bcf6d7bp-25, 0x1.bbb305825ce4fp-28, 0x1.da3f4af13a406p-25,
    0x1.f36b96f74ce86p-26, 0x1.65c002303f790p-30, 0x1.82f84095ba7d5p-25,
    0x1.d46433541b2c6p-25, 0x1.71c3d56e93a89p-25, 0x1.98dcef4e40012p-26,
    0x1.530ebef17fe03p-27, 0x1.e8b8fa3715066p-27, 0x1.ab26eb3b211dcp-25,
    0x1.54dd4dc906307p-27, 0x1.c9f962387984ep-26, 0x1.c62a959afec09p-25,
    0x1.638d9ac6a866ap-25, 0x1.38704eca8a22dp-28, 0x1.e6c9e1db14f8fp-27,
    0x1.8744b7f9c9eaap-26, 0x1.6c2893486373bp-25, 0x1.b36bce31699b7p-26,
    0x1.71e3813d200c7p-25, 0x1.99755ab40aa88p-25, 0x1.b45ca0e4bcfc0p-25,
    0x1.2dd090d869c5dp-28, 0x1.4fe0516b917dap-25, 0x1.94563226317a2p-25,
    0x1.53d8fafc2c851p-25, 0x1.dcbd41fbd41a3p-26, 0x1.862ff5285f59cp-26,
    0x1.3072ea97a1e1cp-25, 0x1.2839075184805p-26, 0x1.4b0323e9eff42p-25,
    0x1.b158893c45484p-25, 0x1.149ef0fc35826p-28, 0x1.f2e77ea96acaap-26,
    0x1.200074c471a95p-26, 0x1.3f8cc517f6f04p-25, 0x1.60ba2e311bb55p-25,
    0x1.4b788730bbec3p-25, 0x1.57090795ee20cp-25, 0x1.d9ffe983670b1p-25,
    0x1.2a463ff61bfdap-25, 0x1.9d1bc6a5e65cfp-25, 0x1.8718abaa9e922p-25,
    0x1.3c2f52ffa342ep-25, 0x1.0fae13ff42c80p-25, 0x1.5440f0ef00d57p-25,
    0x1.6fcd22d4e3c1ep-27, 0x1.e0c60b409e863p-27, 0x1.f9cab5a5f0333p-25,
    0x1.30f24744c333dp-25, 0x1.b50622a76b2fep-27, 0x1.fdb94ba595375p-25,
    0x1.861b9b945a171p-28, 0x1.54348015188c4p-25, 0x1.b54d149865523p-25,
    0x1.a0bb783d9de33p-25, 0x1.629d12b1a2157p-25, 0x1.467fe35d179dfp-25,
    0x1.9763f3e26c8f7p-25, 0x1.3f798bb9f7679p-26, 0x1.52e577e855898p-26,
    0x1.fde47e5502c3ap-25, 0x1.cbd0b548d96a0p-26, 0x1.a9cd9f7be8de8p-25,
    0x1.22bbe704886dep-26, 0x1.e3dea8317f020p-25, 0x1.e812085ac8855p-25,
    0x1.c87144f24cb07p-26, 0x1.1e128ee311fa2p-25, 0x1.b5c163d61a2d3p-26,
    0x1.7d97e7fb90633p-27, 0x1.efe899d50f6a7p-25, 0x1.d0333eb75de5ap-25,
    0x1.0e590be73a573p-27, 0x1.8ce8dcac3cdd2p-25, 0x1.ee8a48954064bp-25,
    0x1.aa62f18461e09p-25, 0x1.01e5940986a15p-25, 0x1.b082f4f9b8d4cp-28,
    0x1.876e0e5527f5ap-25, 0x1.3617080831e6bp-25, 0x1.81b26e34aa4a2p-25,
    0x1.52ee66dfab0c1p-26, 0x1.d85a5329e8819p-26, 0x1.105c1b646b5d1p-26,
    0x1.bb6690c1a379cp-25, 0x1.86aeba73ce3a9p-26, 0x1.dd16198294dd4p-25,
    0x1.454e675775e83p-25, 0x1.3842e026197eap-25, 0x1.f1ce0e70c44d2p-25,
    0x1.ad636441a5627p-25, 0x1.4c205d7212abbp-26, 0x1.167c86c116419p-25,
    0x1.38ec3ef16e294p-25, 0x1.473fceace9321p-25, 0x1.7af53a836dba7p-25,
    0x1.a51f3c383b652p-30, 0x1.3696da190822dp-25, 0x1.2f9adec77074bp-25,
    0x1.8190fd5bee55fp-28, 0x1.bfee8fac68e55p-27, 0x1.31c9d6bc5f68ap-28,
    0x1.89d0523737edfp-25, 0x1.a295943bf47bbp-26, 0x1.96be32e5b3207p-28,
    0x1.e44c7d909fa0ep-25, 0x1.b2505da94d9eap-29, 0x1.0c851f46c9c98p-25,
    0x1.da71f7d9aa3b7p-26, 0x1.f1b605d019ef1p-25, 0x1.386e8a2189563p-27,
    0x1.b19fa5d306ba7p-28, 0x1.dd749b67aef76p-25, 0x1.76ff6f1dc04b0p-25,
    0x1.35a33d0b232a6p-25, 0x1.4bdc80024a4e1p-25, 0x1.ebd61770fd723p-25,
    0x1.4769fc537264dp-25, 0x1.9021f429f3b98p-25, 0x1.ee7083efbd606p-26,
    0x1.ad985552a6b1ap-25, 0x1.e3df778772160p-25, 0x1.ca5d76ddc9b34p-25,
    0x1.91154ffdbaf74p-25, 0x1.67bdd57fb306ap-25, 0x1.7dc255ac40886p-25,
    0x1.219f38e8afafep-32, 0x1.2416bf9669a04p-25, 0x1.11c96b2b3987fp-25,
    0x1.f99ed447e1177p-25, 0x1.3245826328a11p-30, 0x1.6f56dd1e645f8p-25,
    0x1.6164946945535p-27, 0x1.e37d59d190028p-26, 0x1.68671f12bf828p-25,
    0x1.e8ecbca6aabbdp-25, 0x1.3f49e109a5912p-26, 0x1.b8a0e11ec3043p-25,
    0x1.5fae00aed691ap-25, 0x1.c0569bece3e4ap-25, 0x1.05e26744efbfep-25,
    0x1.5b570a94be5c5p-25, 0x1.d6f156ea0e063p-26, 0x1.e0ca7612fc484p-25,
    0x1.963c927b25258p-27, 0x1.47930aa725a5cp-26, 0x1.8a79fe3af43b3p-26,
    0x1.e6dc29c41bdafp-26, 0x1.57a2e76f863a5p-25, 0x1.ae3b61716354dp-29,
    0x1.65fb5df6906b1p-25, 0x1.6177d7f588f7bp-25, 0x1.ad55abd091b67p-28,
    0x1.55337b2422d76p-30, 0x1.084ebe86972d5p-25, 0x1.56395808e1ea3p-25,
    0x1.1bce21b40fba7p-25, 0x1.006f94605b515p-26, 0x1.aa676aceb1f7dp-25,
    0x1.8229f76554ce6p-26, 0x1.eabfc6cf57330p-25, 0x1.4daed9c0ce8bcp-25,
    0x1.0ff1768237141p-25, 0x1.575f83051b085p-25, 0x1.2667deb523e29p-27,
    0x1.816996954f4fdp-30, 0x1.87cfccf4d9cd4p-26, 0x1.2c5d018198353p-26,
    0x1.a7a898dcc34aap-25, 0x1.cead6dadc36d1p-29, 0x1.a55759c498bdfp-29,
    0x1.c414a9ef6de04p-25, 0x1.3e2108a6e58fap-25, 0x1.587fd7643d77cp-26,
    0x1.901eb1d3ff3dfp-28, 0x1.f2ccd7c812fc6p-25, 0x1.1c8ee70a01049p-29,
    0x1.63e8d02831eecp-26, 0x1.f61a42a92c7ffp-25, 0x1.a917399c84d24p-34,
    0x1.e9197c8eec2f0p-26, 0x1.e6f842f5a1378p-26, 0x1.fac242a90a0fcp-29,
    0x1.35ed726610227p-26, 0x1.0e0d64804b15bp-26, 0x1.560675daba814p-31,
    0x1.37388c8768032p-25, 0x1.ee3c89f9e01f5p-28, 0x1.39f6f0d09747cp-25,
    0x1.322c327abb8f0p-27, 0x1.961b347c8ac80p-25, 0x1.3711fbbd0f118p-25,
    0x1.4fad8d7718ffbp-25, 0x1.fffffffffffffp-25, 0x1.67efa79ec35b4p-25,
    0x1.a737687a254a8p-25, 0x1.bace0f87d924dp-26, 0x1.29e37c237e392p-25,
    0x1.57ce7ac3f3012p-26, 0x1.82829359f8fbdp-25, 0x1.cc9be42d14676p-25,
    0x1.a8f001c137d0bp-25, 0x1.36127687dda05p-25, 0x1.24dba322646f0p-26,
    0x1.dc43f1ed210b4p-25, 0x1.31ae515c447bbp-25,
};

CLC_TABLE_FUNCTION(double, CBRT_DBL_TBL_TAIL, cbrt_dbl_tbl_tail);

DECLARE_TABLE(double, CBRT_REM_TBL_HEAD, 5) = {
    0x1.428a2f0000000p-1, 0x1.965fea0000000p-1, 0x1.0000000000000p+0,
    0x1.428a2f0000000p+0, 0x1.965fea0000000p+0,
};

CLC_TABLE_FUNCTION(double, CBRT_REM_TBL_HEAD, cbrt_rem_tbl_head);

DECLARE_TABLE(double, CBRT_REM_TBL_TAIL, 5) = {
    0x1.31ae515c447bbp-26, 0x1.4f5b8f20ac166p-27, 0x0.0000000000000p+0,
    0x1.31ae515c447bbp-25, 0x1.4f5b8f20ac166p-26,
};

CLC_TABLE_FUNCTION(double, CBRT_REM_TBL_TAIL, cbrt_rem_tbl_tail);

DECLARE_TABLE(double, SINH_TBL_HEAD, 37) = {
    0x0.0000000000000p+0,  0x1.2cd9fc0000000p+0,  0x1.d03cf60000000p+1,
    0x1.40926e0000000p+3,  0x1.b4a3800000000p+4,  0x1.28d0160000000p+6,
    0x1.936d228000000p+7,  0x1.1228768000000p+9,  0x1.749ea50000000p+10,
    0x1.fa71570000000p+11, 0x1.5829dc8000000p+13, 0x1.d3c4488000000p+14,
    0x1.3de1650000000p+16, 0x1.b00b590000000p+17, 0x1.259ac48000000p+19,
    0x1.8f0cca8000000p+20, 0x1.0f2ebd0000000p+22, 0x1.7093488000000p+23,
    0x1.f4f2208000000p+24, 0x1.546d8f8000000p+26, 0x1.ceb0888000000p+27,
    0x1.3a6e1f8000000p+29, 0x1.ab5adb8000000p+30, 0x1.226af30000000p+32,
    0x1.8ab7fb0000000p+33, 0x1.0c3d390000000p+35, 0x1.6c93268000000p+36,
    0x1.ef822f0000000p+37, 0x1.50bba30000000p+39, 0x1.c9aae40000000p+40,
    0x1.3704708000000p+42, 0x1.a6b7658000000p+43, 0x1.1f43fc8000000p+45,
    0x1.866f348000000p+46, 0x1.0953e28000000p+48, 0x1.689e220000000p+49,
    0x1.ea215a0000000p+50,
};

DECLARE_TABLE(double, SINH_TBL_TAIL, 37) = {
    0x0.0000000000000p+0,  0x1.13ae6096a0092p-26, 0x1.db70cfb79a640p-26,
    0x1.c2526b66dc067p-23, 0x1.b81b18647f380p-23, 0x1.bc1cdd1e1eb08p-20,
    0x1.d9f201534fb09p-19, 0x1.d1c064a4e9954p-18, 0x1.4eca65d06ea74p-18,
    0x1.0c259bcc0ecc5p-15, 0x1.b5a6647cf9016p-13, 0x1.9691adefb0870p-15,
    0x1.3410fc29cde38p-10, 0x1.6a31a50b6fb3cp-11, 0x1.7defc71805c40p-10,
    0x1.eb49fd80e0babp-6,  0x1.4fffc7bcd5920p-7,  0x1.03a93b6c63435p-3,
    0x1.1940bb255fd1cp-4,  0x1.ed26e14260b50p-2,  0x1.b47401fc9f2a2p+0,
    0x1.67bb3f55634f1p+3,  0x1.c435ff8194ddcp+2,  0x1.d8fee052ba63ap+5,
    0x1.51d7edccde3f6p+7,  0x1.04b1644557d1ap+8,  0x1.6a6b5ca0a9dc4p+8,
    0x1.fd9cc72249abap+11, 0x1.e58de693edab5p+13, 0x1.8c70158ac6363p+14,
    0x1.7614764f43e20p+15, 0x1.6337db36fc718p+17, 0x1.12d98b1f611e2p+19,
    0x1.392bc108b37ccp+19, 0x1.ce87bdc3473dcp+22, 0x1.bc8d5ae99ad14p+21,
    0x1.d20d76744835cp+22,
};

DECLARE_TABLE(double, COSH_TBL_HEAD, 37) = {
    0x1.0000000000000p+0,  0x1.8b07550000000p+0,  0x1.e18fa08000000p+1,
    0x1.422a490000000p+3,  0x1.b4ee858000000p+4,  0x1.28d6fc8000000p+6,
    0x1.936e678000000p+7,  0x1.1228948000000p+9,  0x1.749eaa8000000p+10,
    0x1.fa71580000000p+11, 0x1.5829dd0000000p+13, 0x1.d3c4488000000p+14,
    0x1.3de1650000000p+16, 0x1.b00b590000000p+17, 0x1.259ac48000000p+19,
    0x1.8f0cca8000000p+20, 0x1.0f2ebd0000000p+22, 0x1.7093488000000p+23,
    0x1.f4f2208000000p+24, 0x1.546d8f8000000p+26, 0x1.ceb0888000000p+27,
    0x1.3a6e1f8000000p+29, 0x1.ab5adb8000000p+30, 0x1.226af30000000p+32,
    0x1.8ab7fb0000000p+33, 0x1.0c3d390000000p+35, 0x1.6c93268000000p+36,
    0x1.ef822f0000000p+37, 0x1.50bba30000000p+39, 0x1.c9aae40000000p+40,
    0x1.3704708000000p+42, 0x1.a6b7658000000p+43, 0x1.1f43fc8000000p+45,
    0x1.866f348000000p+46, 0x1.0953e28000000p+48, 0x1.689e220000000p+49,
    0x1.ea215a0000000p+50,
};

DECLARE_TABLE(double, COSH_TBL_TAIL, 37) = {
    0x0.0000000000000p+0,  0x1.d9f5504c2bd28p-28, 0x1.7cb66f0a4c9fdp-25,
    0x1.f58617928e588p-23, 0x1.bc7d000c38d48p-25, 0x1.f7f9d4e329998p-21,
    0x1.6e6e464885269p-19, 0x1.ba3a8b946c154p-19, 0x1.3f4e76110d5a4p-18,
    0x1.17622515a3e2bp-15, 0x1.4dc4b528af3d0p-17, 0x1.1156278615e10p-14,
    0x1.35ad50ed821f5p-10, 0x1.6b61055f2935cp-11, 0x1.7e2794a601240p-10,
    0x1.eb4b45f6aadd3p-6,  0x1.5000b967b3698p-7,  0x1.03a940fadc092p-3,
    0x1.1940bf3bf874cp-4,  0x1.ed26e1a2a2110p-2,  0x1.b4740205796d6p+0,
    0x1.67bb3f55cb85dp+3,  0x1.c435ff81e18acp+2,  0x1.d8fee052bdea4p+5,
    0x1.51d7edccde926p+7,  0x1.04b1644557e0ep+8,  0x1.6a6b5ca0a9e1cp+8,
    0x1.fd9cc72249abep+11, 0x1.e58de693edab5p+13, 0x1.8c70158ac6364p+14,
    0x1.7614764f43e20p+15, 0x1.6337db36fc718p+17, 0x1.12d98b1f611e2p+19,
    0x1.392bc108b37ccp+19, 0x1.ce87bdc3473dcp+22, 0x1.bc8d5ae99ad14p+21,
    0x1.d20d76744835cp+22,
};

CLC_TABLE_FUNCTION(double, SINH_TBL_HEAD, sinh_tbl_head);
CLC_TABLE_FUNCTION(double, SINH_TBL_TAIL, sinh_tbl_tail);
CLC_TABLE_FUNCTION(double, COSH_TBL_HEAD, cosh_tbl_head);
CLC_TABLE_FUNCTION(double, COSH_TBL_TAIL, cosh_tbl_tail);

DECLARE_TABLE(uchar, PIBITS_TBL, ) = {
    224, 241, 27,  193, 12,  88,  33,  116, 53,  126, 196, 126, 237, 175, 169,
    75,  74,  41,  222, 231, 28,  244, 236, 197, 151, 175, 31,  235, 158, 212,
    181, 168, 127, 121, 154, 253, 24,  61,  221, 38,  44,  159, 60,  251, 217,
    180, 125, 180, 41,  104, 45,  70,  188, 188, 63,  96,  22,  120, 255, 95,
    226, 127, 236, 160, 228, 247, 46,  126, 17,  114, 210, 231, 76,  13,  230,
    88,  71,  230, 4,   249, 125, 209, 154, 192, 113, 166, 19,  18,  237, 186,
    212, 215, 8,   162, 251, 156, 166, 196, 114, 172, 119, 248, 115, 72,  70,
    39,  168, 187, 36,  25,  128, 75,  55,  9,   233, 184, 145, 220, 134, 21,
    239, 122, 175, 142, 69,  249, 7,   65,  14,  241, 100, 86,  138, 109, 3,
    119, 211, 212, 71,  95,  157, 240, 167, 84,  16,  57,  185, 13,  230, 139,
    2,   0,   0,   0,   0,   0,   0,   0};

_CLC_DEF _CLC_OVERLOAD ulong TABLE_MANGLE(pibits_tbl)(int idx) {
  return *(__constant ulong *)(PIBITS_TBL + idx);
}
_CLC_DEF _CLC_OVERLOAD ulong2 TABLE_MANGLE(pibits_tbl)(int2 idx) {
  return (ulong2){*(__constant ulong *)(PIBITS_TBL + idx.s0),
                  *(__constant ulong *)(PIBITS_TBL + idx.s1)};
}
_CLC_DEF _CLC_OVERLOAD ulong3 TABLE_MANGLE(pibits_tbl)(int3 idx) {
  return (ulong3){*(__constant ulong *)(PIBITS_TBL + idx.s0),
                  *(__constant ulong *)(PIBITS_TBL + idx.s1),
                  *(__constant ulong *)(PIBITS_TBL + idx.s2)};
}
_CLC_DEF _CLC_OVERLOAD ulong4 TABLE_MANGLE(pibits_tbl)(int4 idx) {
  return (ulong4){*(__constant ulong *)(PIBITS_TBL + idx.s0),
                  *(__constant ulong *)(PIBITS_TBL + idx.s1),
                  *(__constant ulong *)(PIBITS_TBL + idx.s2),
                  *(__constant ulong *)(PIBITS_TBL + idx.s3)};
}
_CLC_DEF _CLC_OVERLOAD ulong8 TABLE_MANGLE(pibits_tbl)(int8 idx) {
  return (ulong8){*(__constant ulong *)(PIBITS_TBL + idx.s0),
                  *(__constant ulong *)(PIBITS_TBL + idx.s1),
                  *(__constant ulong *)(PIBITS_TBL + idx.s2),
                  *(__constant ulong *)(PIBITS_TBL + idx.s3),
                  *(__constant ulong *)(PIBITS_TBL + idx.s4),
                  *(__constant ulong *)(PIBITS_TBL + idx.s5),
                  *(__constant ulong *)(PIBITS_TBL + idx.s6),
                  *(__constant ulong *)(PIBITS_TBL + idx.s7)};
}
_CLC_DEF _CLC_OVERLOAD ulong16 TABLE_MANGLE(pibits_tbl)(int16 idx) {
  return (ulong16){*(__constant ulong *)(PIBITS_TBL + idx.s0),
                   *(__constant ulong *)(PIBITS_TBL + idx.s1),
                   *(__constant ulong *)(PIBITS_TBL + idx.s2),
                   *(__constant ulong *)(PIBITS_TBL + idx.s3),
                   *(__constant ulong *)(PIBITS_TBL + idx.s4),
                   *(__constant ulong *)(PIBITS_TBL + idx.s5),
                   *(__constant ulong *)(PIBITS_TBL + idx.s6),
                   *(__constant ulong *)(PIBITS_TBL + idx.s7),
                   *(__constant ulong *)(PIBITS_TBL + idx.s8),
                   *(__constant ulong *)(PIBITS_TBL + idx.s9),
                   *(__constant ulong *)(PIBITS_TBL + idx.sA),
                   *(__constant ulong *)(PIBITS_TBL + idx.sB),
                   *(__constant ulong *)(PIBITS_TBL + idx.sC),
                   *(__constant ulong *)(PIBITS_TBL + idx.sD),
                   *(__constant ulong *)(PIBITS_TBL + idx.sE),
                   *(__constant ulong *)(PIBITS_TBL + idx.sF)};
}

#endif // cl_khr_fp64
