; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -O0 --march=ve -mattr=+vpu | FileCheck %s

declare i64 @llvm.vector.reduce.or.v256i64(<256 x i64>)

define fastcc i64 @vec_reduce_or_v256i64(<256 x i64> %v) {
; CHECK-LABEL: vec_reduce_or_v256i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s0, 256
; CHECK-NEXT:    # kill: def $sw0 killed $sw0 killed $sx0
; CHECK-NEXT:    lvl %s0
; CHECK-NEXT:    vror %v0, %v0
; CHECK-NEXT:    lvs %s0, %v0(0)
; CHECK-NEXT:    b.l.t (, %s10)
  %r = call i64 @llvm.vector.reduce.or.v256i64( <256 x i64> %v)
  ret i64 %r
}

declare i32 @llvm.vector.reduce.or.v256i32(<256 x i32>)

define fastcc i32 @vec_reduce_or_v256i32(<256 x i32> %v) {
; CHECK-LABEL: vec_reduce_or_v256i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s0, 256
; CHECK-NEXT:    # kill: def $sw0 killed $sw0 killed $sx0
; CHECK-NEXT:    lvl %s0
; CHECK-NEXT:    vror %v0, %v0
; CHECK-NEXT:    lvs %s0, %v0(0)
; CHECK-NEXT:    or %s1, 0, %s0
; CHECK-NEXT:    # implicit-def: $sx0
; CHECK-NEXT:    or %s0, 0, %s1
; CHECK-NEXT:    b.l.t (, %s10)
  %r = call i32 @llvm.vector.reduce.or.v256i32( <256 x i32> %v)
  ret i32 %r
}
