; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=riscv32 -global-isel -global-isel-abort=1 -verify-machineinstrs < %s 2>&1 | FileCheck %s --check-prefixes=RV32
; RUN: llc -mtriple=riscv64 -global-isel -global-isel-abort=1 -verify-machineinstrs < %s 2>&1 | FileCheck %s --check-prefixes=RV64

define i16 @test_lshr_i48(i48 %x) {
; RV32-LABEL: test_lshr_i48:
; RV32:       # %bb.0:
; RV32-NEXT:    srli a0, a0, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: test_lshr_i48:
; RV64:       # %bb.0:
; RV64-NEXT:    srliw a0, a0, 16
; RV64-NEXT:    ret
  %lshr = lshr i48 %x, 16
  %trunc = trunc i48 %lshr to i16
  ret i16 %trunc
}

define i16 @test_ashr_i48(i48 %x) {
; RV32-LABEL: test_ashr_i48:
; RV32:       # %bb.0:
; RV32-NEXT:    srai a0, a0, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: test_ashr_i48:
; RV64:       # %bb.0:
; RV64-NEXT:    sraiw a0, a0, 16
; RV64-NEXT:    ret
  %ashr = ashr i48 %x, 16
  %trunc = trunc i48 %ashr to i16
  ret i16 %trunc
}

define i16 @test_shl_i48(i48 %x) {
; RV32-LABEL: test_shl_i48:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a0, a0, 8
; RV32-NEXT:    ret
;
; RV64-LABEL: test_shl_i48:
; RV64:       # %bb.0:
; RV64-NEXT:    slliw a0, a0, 8
; RV64-NEXT:    ret
  %shl = shl i48 %x, 8
  %trunc = trunc i48 %shl to i16
  ret i16 %trunc
}
