; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc -mtriple=aarch64-- -O1 -fast-isel=0 -global-isel=false %s -o - | FileCheck -check-prefixes=CHECK,NOLSE %s
; RUN: llc -mtriple=aarch64-- -mattr=+lse -O1 -fast-isel=0 -global-isel=false %s -o - | FileCheck -check-prefixes=CHECK,LSE %s

define <2 x half> @test_atomicrmw_fadd_v2f16_align4(ptr addrspace(1) %ptr, <2 x half> %value) #0 {
; NOLSE-LABEL: test_atomicrmw_fadd_v2f16_align4:
; NOLSE:       // %bb.0:
; NOLSE-NEXT:    fcvtl v1.4s, v0.4h
; NOLSE-NEXT:    ldr s0, [x0]
; NOLSE-NEXT:    b .LBB0_2
; NOLSE-NEXT:  .LBB0_1: // %atomicrmw.start
; NOLSE-NEXT:    // in Loop: Header=BB0_2 Depth=1
; NOLSE-NEXT:    fmov s0, w10
; NOLSE-NEXT:    cmp w10, w9
; NOLSE-NEXT:    b.eq .LBB0_5
; NOLSE-NEXT:  .LBB0_2: // %atomicrmw.start
; NOLSE-NEXT:    // =>This Loop Header: Depth=1
; NOLSE-NEXT:    // Child Loop BB0_3 Depth 2
; NOLSE-NEXT:    fcvtl v2.4s, v0.4h
; NOLSE-NEXT:    fmov w9, s0
; NOLSE-NEXT:    fadd v2.4s, v2.4s, v1.4s
; NOLSE-NEXT:    fcvtn v2.4h, v2.4s
; NOLSE-NEXT:    fmov w8, s2
; NOLSE-NEXT:  .LBB0_3: // %atomicrmw.start
; NOLSE-NEXT:    // Parent Loop BB0_2 Depth=1
; NOLSE-NEXT:    // => This Inner Loop Header: Depth=2
; NOLSE-NEXT:    ldaxr w10, [x0]
; NOLSE-NEXT:    cmp w10, w9
; NOLSE-NEXT:    b.ne .LBB0_1
; NOLSE-NEXT:  // %bb.4: // %atomicrmw.start
; NOLSE-NEXT:    // in Loop: Header=BB0_3 Depth=2
; NOLSE-NEXT:    stlxr wzr, w8, [x0]
; NOLSE-NEXT:    cbnz wzr, .LBB0_3
; NOLSE-NEXT:    b .LBB0_1
; NOLSE-NEXT:  .LBB0_5: // %atomicrmw.end
; NOLSE-NEXT:    // kill: def $d0 killed $d0 killed $q0
; NOLSE-NEXT:    ret
;
; LSE-LABEL: test_atomicrmw_fadd_v2f16_align4:
; LSE:       // %bb.0:
; LSE-NEXT:    fcvtl v1.4s, v0.4h
; LSE-NEXT:    ldr s0, [x0]
; LSE-NEXT:  .LBB0_1: // %atomicrmw.start
; LSE-NEXT:    // =>This Inner Loop Header: Depth=1
; LSE-NEXT:    fcvtl v2.4s, v0.4h
; LSE-NEXT:    fmov w8, s0
; LSE-NEXT:    mov w10, w8
; LSE-NEXT:    fadd v2.4s, v2.4s, v1.4s
; LSE-NEXT:    fcvtn v2.4h, v2.4s
; LSE-NEXT:    fmov w9, s2
; LSE-NEXT:    casal w10, w9, [x0]
; LSE-NEXT:    fmov s0, w10
; LSE-NEXT:    cmp w10, w8
; LSE-NEXT:    b.ne .LBB0_1
; LSE-NEXT:  // %bb.2: // %atomicrmw.end
; LSE-NEXT:    // kill: def $d0 killed $d0 killed $q0
; LSE-NEXT:    ret
  %res = atomicrmw fadd ptr addrspace(1) %ptr, <2 x half> %value seq_cst, align 4
  ret <2 x half> %res
}

define <2 x float> @test_atomicrmw_fadd_v2f32_align8(ptr addrspace(1) %ptr, <2 x float> %value) #0 {
; NOLSE-LABEL: test_atomicrmw_fadd_v2f32_align8:
; NOLSE:       // %bb.0:
; NOLSE-NEXT:    ldr d1, [x0]
; NOLSE-NEXT:    b .LBB1_2
; NOLSE-NEXT:  .LBB1_1: // %atomicrmw.start
; NOLSE-NEXT:    // in Loop: Header=BB1_2 Depth=1
; NOLSE-NEXT:    fmov d1, x10
; NOLSE-NEXT:    cmp x10, x9
; NOLSE-NEXT:    b.eq .LBB1_5
; NOLSE-NEXT:  .LBB1_2: // %atomicrmw.start
; NOLSE-NEXT:    // =>This Loop Header: Depth=1
; NOLSE-NEXT:    // Child Loop BB1_3 Depth 2
; NOLSE-NEXT:    fadd v2.2s, v1.2s, v0.2s
; NOLSE-NEXT:    fmov x9, d1
; NOLSE-NEXT:    fmov x8, d2
; NOLSE-NEXT:  .LBB1_3: // %atomicrmw.start
; NOLSE-NEXT:    // Parent Loop BB1_2 Depth=1
; NOLSE-NEXT:    // => This Inner Loop Header: Depth=2
; NOLSE-NEXT:    ldaxr x10, [x0]
; NOLSE-NEXT:    cmp x10, x9
; NOLSE-NEXT:    b.ne .LBB1_1
; NOLSE-NEXT:  // %bb.4: // %atomicrmw.start
; NOLSE-NEXT:    // in Loop: Header=BB1_3 Depth=2
; NOLSE-NEXT:    stlxr wzr, x8, [x0]
; NOLSE-NEXT:    cbnz wzr, .LBB1_3
; NOLSE-NEXT:    b .LBB1_1
; NOLSE-NEXT:  .LBB1_5: // %atomicrmw.end
; NOLSE-NEXT:    fmov d0, d1
; NOLSE-NEXT:    ret
;
; LSE-LABEL: test_atomicrmw_fadd_v2f32_align8:
; LSE:       // %bb.0:
; LSE-NEXT:    ldr d1, [x0]
; LSE-NEXT:  .LBB1_1: // %atomicrmw.start
; LSE-NEXT:    // =>This Inner Loop Header: Depth=1
; LSE-NEXT:    fadd v2.2s, v1.2s, v0.2s
; LSE-NEXT:    fmov x8, d1
; LSE-NEXT:    mov x10, x8
; LSE-NEXT:    fmov x9, d2
; LSE-NEXT:    casal x10, x9, [x0]
; LSE-NEXT:    fmov d1, x10
; LSE-NEXT:    cmp x10, x8
; LSE-NEXT:    b.ne .LBB1_1
; LSE-NEXT:  // %bb.2: // %atomicrmw.end
; LSE-NEXT:    fmov d0, d1
; LSE-NEXT:    ret
  %res = atomicrmw fadd ptr addrspace(1) %ptr, <2 x float> %value seq_cst, align 8
  ret <2 x float> %res
}

attributes #0 = { nounwind }
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; CHECK: {{.*}}
