; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+d,+zfh,+zvfh,+v,+m \
; RUN:   -verify-machineinstrs < %s | FileCheck %s --check-prefixes=RV32
; RUN: llc -mtriple=riscv64 -mattr=+d,+zfh,+zvfh,+v,+m \
; RUN:   -verify-machineinstrs < %s | FileCheck %s --check-prefixes=RV64

declare void @llvm.vp.scatter.v2i8.v2p0(<2 x i8>, <2 x ptr>, <2 x i1>, i32)

define void @vpscatter_v2i8(<2 x i8> %val, <2 x ptr> %ptrs, <2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_v2i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_v2i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (zero), v9, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.v2i8.v2p0(<2 x i8> %val, <2 x ptr> %ptrs, <2 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_v2i16_truncstore_v2i8(<2 x i16> %val, <2 x ptr> %ptrs, <2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_v2i16_truncstore_v2i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 2, e8, mf8, ta, ma
; RV32-NEXT:    vnsrl.wi v8, v8, 0
; RV32-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_v2i16_truncstore_v2i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 2, e8, mf8, ta, ma
; RV64-NEXT:    vnsrl.wi v8, v8, 0
; RV64-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (zero), v9, v0.t
; RV64-NEXT:    ret
  %tval = trunc <2 x i16> %val to <2 x i8>
  call void @llvm.vp.scatter.v2i8.v2p0(<2 x i8> %tval, <2 x ptr> %ptrs, <2 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_v2i32_truncstore_v2i8(<2 x i32> %val, <2 x ptr> %ptrs, <2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_v2i32_truncstore_v2i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; RV32-NEXT:    vnsrl.wi v8, v8, 0
; RV32-NEXT:    vsetvli zero, zero, e8, mf8, ta, ma
; RV32-NEXT:    vnsrl.wi v8, v8, 0
; RV32-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_v2i32_truncstore_v2i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; RV64-NEXT:    vnsrl.wi v8, v8, 0
; RV64-NEXT:    vsetvli zero, zero, e8, mf8, ta, ma
; RV64-NEXT:    vnsrl.wi v8, v8, 0
; RV64-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (zero), v9, v0.t
; RV64-NEXT:    ret
  %tval = trunc <2 x i32> %val to <2 x i8>
  call void @llvm.vp.scatter.v2i8.v2p0(<2 x i8> %tval, <2 x ptr> %ptrs, <2 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_v2i64_truncstore_v2i8(<2 x i64> %val, <2 x ptr> %ptrs, <2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_v2i64_truncstore_v2i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; RV32-NEXT:    vnsrl.wi v8, v8, 0
; RV32-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; RV32-NEXT:    vnsrl.wi v8, v8, 0
; RV32-NEXT:    vsetvli zero, zero, e8, mf8, ta, ma
; RV32-NEXT:    vnsrl.wi v8, v8, 0
; RV32-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_v2i64_truncstore_v2i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; RV64-NEXT:    vnsrl.wi v8, v8, 0
; RV64-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; RV64-NEXT:    vnsrl.wi v8, v8, 0
; RV64-NEXT:    vsetvli zero, zero, e8, mf8, ta, ma
; RV64-NEXT:    vnsrl.wi v8, v8, 0
; RV64-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (zero), v9, v0.t
; RV64-NEXT:    ret
  %tval = trunc <2 x i64> %val to <2 x i8>
  call void @llvm.vp.scatter.v2i8.v2p0(<2 x i8> %tval, <2 x ptr> %ptrs, <2 x i1> %m, i32 %evl)
  ret void
}

declare void @llvm.vp.scatter.v4i8.v4p0(<4 x i8>, <4 x ptr>, <4 x i1>, i32)

define void @vpscatter_v4i8(<4 x i8> %val, <4 x ptr> %ptrs, <4 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_v4i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_v4i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (zero), v10, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.v4i8.v4p0(<4 x i8> %val, <4 x ptr> %ptrs, <4 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_truemask_v4i8(<4 x i8> %val, <4 x ptr> %ptrs, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_truemask_v4i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (zero), v9
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_truemask_v4i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (zero), v10
; RV64-NEXT:    ret
  %mhead = insertelement <4 x i1> poison, i1 1, i32 0
  %mtrue = shufflevector <4 x i1> %mhead, <4 x i1> poison, <4 x i32> zeroinitializer
  call void @llvm.vp.scatter.v4i8.v4p0(<4 x i8> %val, <4 x ptr> %ptrs, <4 x i1> %mtrue, i32 %evl)
  ret void
}

declare void @llvm.vp.scatter.v8i8.v8p0(<8 x i8>, <8 x ptr>, <8 x i1>, i32)

define void @vpscatter_v8i8(<8 x i8> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_v8i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (zero), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_v8i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (zero), v12, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.v8i8.v8p0(<8 x i8> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_v8i8(<8 x i8> %val, ptr %base, <8 x i8> %idxs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_v8i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV32-NEXT:    vsext.vf4 v10, v9
; RV32-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (a0), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_v8i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV64-NEXT:    vsext.vf8 v12, v9
; RV64-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i8, ptr %base, <8 x i8> %idxs
  call void @llvm.vp.scatter.v8i8.v8p0(<8 x i8> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

declare void @llvm.vp.scatter.v2i16.v2p0(<2 x i16>, <2 x ptr>, <2 x i1>, i32)

define void @vpscatter_v2i16(<2 x i16> %val, <2 x ptr> %ptrs, <2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_v2i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_v2i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (zero), v9, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.v2i16.v2p0(<2 x i16> %val, <2 x ptr> %ptrs, <2 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_v2i32_truncstore_v2i16(<2 x i32> %val, <2 x ptr> %ptrs, <2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_v2i32_truncstore_v2i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; RV32-NEXT:    vnsrl.wi v8, v8, 0
; RV32-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_v2i32_truncstore_v2i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; RV64-NEXT:    vnsrl.wi v8, v8, 0
; RV64-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (zero), v9, v0.t
; RV64-NEXT:    ret
  %tval = trunc <2 x i32> %val to <2 x i16>
  call void @llvm.vp.scatter.v2i16.v2p0(<2 x i16> %tval, <2 x ptr> %ptrs, <2 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_v2i64_truncstore_v2i16(<2 x i64> %val, <2 x ptr> %ptrs, <2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_v2i64_truncstore_v2i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; RV32-NEXT:    vnsrl.wi v8, v8, 0
; RV32-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; RV32-NEXT:    vnsrl.wi v8, v8, 0
; RV32-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_v2i64_truncstore_v2i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; RV64-NEXT:    vnsrl.wi v8, v8, 0
; RV64-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; RV64-NEXT:    vnsrl.wi v8, v8, 0
; RV64-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (zero), v9, v0.t
; RV64-NEXT:    ret
  %tval = trunc <2 x i64> %val to <2 x i16>
  call void @llvm.vp.scatter.v2i16.v2p0(<2 x i16> %tval, <2 x ptr> %ptrs, <2 x i1> %m, i32 %evl)
  ret void
}

declare void @llvm.vp.scatter.v3i16.v3p0(<3 x i16>, <3 x ptr>, <3 x i1>, i32)

define void @vpscatter_v3i16(<3 x i16> %val, <3 x ptr> %ptrs, <3 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_v3i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_v3i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (zero), v10, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.v3i16.v3p0(<3 x i16> %val, <3 x ptr> %ptrs, <3 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_truemask_v3i16(<3 x i16> %val, <3 x ptr> %ptrs, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_truemask_v3i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (zero), v9
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_truemask_v3i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (zero), v10
; RV64-NEXT:    ret
  %mhead = insertelement <3 x i1> poison, i1 1, i32 0
  %mtrue = shufflevector <3 x i1> %mhead, <3 x i1> poison, <3 x i32> zeroinitializer
  call void @llvm.vp.scatter.v3i16.v3p0(<3 x i16> %val, <3 x ptr> %ptrs, <3 x i1> %mtrue, i32 %evl)
  ret void
}

declare void @llvm.vp.scatter.v4i16.v4p0(<4 x i16>, <4 x ptr>, <4 x i1>, i32)

define void @vpscatter_v4i16(<4 x i16> %val, <4 x ptr> %ptrs, <4 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_v4i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_v4i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (zero), v10, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.v4i16.v4p0(<4 x i16> %val, <4 x ptr> %ptrs, <4 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_truemask_v4i16(<4 x i16> %val, <4 x ptr> %ptrs, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_truemask_v4i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (zero), v9
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_truemask_v4i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (zero), v10
; RV64-NEXT:    ret
  %mhead = insertelement <4 x i1> poison, i1 1, i32 0
  %mtrue = shufflevector <4 x i1> %mhead, <4 x i1> poison, <4 x i32> zeroinitializer
  call void @llvm.vp.scatter.v4i16.v4p0(<4 x i16> %val, <4 x ptr> %ptrs, <4 x i1> %mtrue, i32 %evl)
  ret void
}

declare void @llvm.vp.scatter.v8i16.v8p0(<8 x i16>, <8 x ptr>, <8 x i1>, i32)

define void @vpscatter_v8i16(<8 x i16> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_v8i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (zero), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_v8i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (zero), v12, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.v8i16.v8p0(<8 x i16> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_v8i8_v8i16(<8 x i16> %val, ptr %base, <8 x i8> %idxs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_v8i8_v8i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV32-NEXT:    vsext.vf4 v10, v9
; RV32-NEXT:    vadd.vv v10, v10, v10
; RV32-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (a0), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_v8i8_v8i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV64-NEXT:    vsext.vf8 v12, v9
; RV64-NEXT:    vadd.vv v12, v12, v12
; RV64-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i16, ptr %base, <8 x i8> %idxs
  call void @llvm.vp.scatter.v8i16.v8p0(<8 x i16> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_sext_v8i8_v8i16(<8 x i16> %val, ptr %base, <8 x i8> %idxs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_sext_v8i8_v8i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV32-NEXT:    vsext.vf4 v10, v9
; RV32-NEXT:    vadd.vv v10, v10, v10
; RV32-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (a0), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_sext_v8i8_v8i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV64-NEXT:    vsext.vf8 v12, v9
; RV64-NEXT:    vadd.vv v12, v12, v12
; RV64-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %eidxs = sext <8 x i8> %idxs to <8 x i16>
  %ptrs = getelementptr inbounds i16, ptr %base, <8 x i16> %eidxs
  call void @llvm.vp.scatter.v8i16.v8p0(<8 x i16> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_zext_v8i8_v8i16(<8 x i16> %val, ptr %base, <8 x i8> %idxs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_zext_v8i8_v8i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e8, mf2, ta, ma
; RV32-NEXT:    vwaddu.vv v10, v9, v9
; RV32-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; RV32-NEXT:    vsoxei16.v v8, (a0), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_zext_v8i8_v8i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e8, mf2, ta, ma
; RV64-NEXT:    vwaddu.vv v10, v9, v9
; RV64-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; RV64-NEXT:    vsoxei16.v v8, (a0), v10, v0.t
; RV64-NEXT:    ret
  %eidxs = zext <8 x i8> %idxs to <8 x i16>
  %ptrs = getelementptr inbounds i16, ptr %base, <8 x i16> %eidxs
  call void @llvm.vp.scatter.v8i16.v8p0(<8 x i16> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_v8i16(<8 x i16> %val, ptr %base, <8 x i16> %idxs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_v8i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; RV32-NEXT:    vwadd.vv v10, v9, v9
; RV32-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (a0), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_v8i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV64-NEXT:    vsext.vf4 v12, v9
; RV64-NEXT:    vadd.vv v12, v12, v12
; RV64-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i16, ptr %base, <8 x i16> %idxs
  call void @llvm.vp.scatter.v8i16.v8p0(<8 x i16> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

declare void @llvm.vp.scatter.v2i32.v2p0(<2 x i32>, <2 x ptr>, <2 x i1>, i32)

define void @vpscatter_v2i32(<2 x i32> %val, <2 x ptr> %ptrs, <2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_v2i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_v2i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (zero), v9, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.v2i32.v2p0(<2 x i32> %val, <2 x ptr> %ptrs, <2 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_v2i64_truncstore_v2i32(<2 x i64> %val, <2 x ptr> %ptrs, <2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_v2i64_truncstore_v2i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; RV32-NEXT:    vnsrl.wi v8, v8, 0
; RV32-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_v2i64_truncstore_v2i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; RV64-NEXT:    vnsrl.wi v8, v8, 0
; RV64-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (zero), v9, v0.t
; RV64-NEXT:    ret
  %tval = trunc <2 x i64> %val to <2 x i32>
  call void @llvm.vp.scatter.v2i32.v2p0(<2 x i32> %tval, <2 x ptr> %ptrs, <2 x i1> %m, i32 %evl)
  ret void
}

declare void @llvm.vp.scatter.v4i32.v4p0(<4 x i32>, <4 x ptr>, <4 x i1>, i32)

define void @vpscatter_v4i32(<4 x i32> %val, <4 x ptr> %ptrs, <4 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_v4i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_v4i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (zero), v10, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.v4i32.v4p0(<4 x i32> %val, <4 x ptr> %ptrs, <4 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_truemask_v4i32(<4 x i32> %val, <4 x ptr> %ptrs, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_truemask_v4i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (zero), v9
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_truemask_v4i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (zero), v10
; RV64-NEXT:    ret
  %mhead = insertelement <4 x i1> poison, i1 1, i32 0
  %mtrue = shufflevector <4 x i1> %mhead, <4 x i1> poison, <4 x i32> zeroinitializer
  call void @llvm.vp.scatter.v4i32.v4p0(<4 x i32> %val, <4 x ptr> %ptrs, <4 x i1> %mtrue, i32 %evl)
  ret void
}

declare void @llvm.vp.scatter.v8i32.v8p0(<8 x i32>, <8 x ptr>, <8 x i1>, i32)

define void @vpscatter_v8i32(<8 x i32> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_v8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (zero), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_v8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (zero), v12, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.v8i32.v8p0(<8 x i32> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_v8i8_v8i32(<8 x i32> %val, ptr %base, <8 x i8> %idxs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_v8i8_v8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV32-NEXT:    vsext.vf4 v12, v10
; RV32-NEXT:    vsll.vi v10, v12, 2
; RV32-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (a0), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_v8i8_v8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV64-NEXT:    vsext.vf8 v12, v10
; RV64-NEXT:    vsll.vi v12, v12, 2
; RV64-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i32, ptr %base, <8 x i8> %idxs
  call void @llvm.vp.scatter.v8i32.v8p0(<8 x i32> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_sext_v8i8_v8i32(<8 x i32> %val, ptr %base, <8 x i8> %idxs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_sext_v8i8_v8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV32-NEXT:    vsext.vf4 v12, v10
; RV32-NEXT:    vsll.vi v10, v12, 2
; RV32-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (a0), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_sext_v8i8_v8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV64-NEXT:    vsext.vf8 v12, v10
; RV64-NEXT:    vsll.vi v12, v12, 2
; RV64-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %eidxs = sext <8 x i8> %idxs to <8 x i32>
  %ptrs = getelementptr inbounds i32, ptr %base, <8 x i32> %eidxs
  call void @llvm.vp.scatter.v8i32.v8p0(<8 x i32> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_zext_v8i8_v8i32(<8 x i32> %val, ptr %base, <8 x i8> %idxs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_zext_v8i8_v8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; RV32-NEXT:    vzext.vf2 v11, v10
; RV32-NEXT:    vsll.vi v10, v11, 2
; RV32-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; RV32-NEXT:    vsoxei16.v v8, (a0), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_zext_v8i8_v8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; RV64-NEXT:    vzext.vf2 v11, v10
; RV64-NEXT:    vsll.vi v10, v11, 2
; RV64-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; RV64-NEXT:    vsoxei16.v v8, (a0), v10, v0.t
; RV64-NEXT:    ret
  %eidxs = zext <8 x i8> %idxs to <8 x i32>
  %ptrs = getelementptr inbounds i32, ptr %base, <8 x i32> %eidxs
  call void @llvm.vp.scatter.v8i32.v8p0(<8 x i32> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_v8i16_v8i32(<8 x i32> %val, ptr %base, <8 x i16> %idxs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_v8i16_v8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV32-NEXT:    vsext.vf2 v12, v10
; RV32-NEXT:    vsll.vi v10, v12, 2
; RV32-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (a0), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_v8i16_v8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV64-NEXT:    vsext.vf4 v12, v10
; RV64-NEXT:    vsll.vi v12, v12, 2
; RV64-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i32, ptr %base, <8 x i16> %idxs
  call void @llvm.vp.scatter.v8i32.v8p0(<8 x i32> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_sext_v8i16_v8i32(<8 x i32> %val, ptr %base, <8 x i16> %idxs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_sext_v8i16_v8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV32-NEXT:    vsext.vf2 v12, v10
; RV32-NEXT:    vsll.vi v10, v12, 2
; RV32-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (a0), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_sext_v8i16_v8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV64-NEXT:    vsext.vf4 v12, v10
; RV64-NEXT:    vsll.vi v12, v12, 2
; RV64-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %eidxs = sext <8 x i16> %idxs to <8 x i32>
  %ptrs = getelementptr inbounds i32, ptr %base, <8 x i32> %eidxs
  call void @llvm.vp.scatter.v8i32.v8p0(<8 x i32> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_zext_v8i16_v8i32(<8 x i32> %val, ptr %base, <8 x i16> %idxs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_zext_v8i16_v8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV32-NEXT:    vzext.vf2 v12, v10
; RV32-NEXT:    vsll.vi v10, v12, 2
; RV32-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (a0), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_zext_v8i16_v8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV64-NEXT:    vzext.vf2 v12, v10
; RV64-NEXT:    vsll.vi v10, v12, 2
; RV64-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; RV64-NEXT:    vsoxei32.v v8, (a0), v10, v0.t
; RV64-NEXT:    ret
  %eidxs = zext <8 x i16> %idxs to <8 x i32>
  %ptrs = getelementptr inbounds i32, ptr %base, <8 x i32> %eidxs
  call void @llvm.vp.scatter.v8i32.v8p0(<8 x i32> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_v8i32(<8 x i32> %val, ptr %base, <8 x i32> %idxs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_v8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV32-NEXT:    vsll.vi v10, v10, 2
; RV32-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (a0), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_v8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV64-NEXT:    vsext.vf2 v12, v10
; RV64-NEXT:    vsll.vi v12, v12, 2
; RV64-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i32, ptr %base, <8 x i32> %idxs
  call void @llvm.vp.scatter.v8i32.v8p0(<8 x i32> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

declare void @llvm.vp.scatter.v2i64.v2p0(<2 x i64>, <2 x ptr>, <2 x i1>, i32)

define void @vpscatter_v2i64(<2 x i64> %val, <2 x ptr> %ptrs, <2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_v2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_v2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (zero), v9, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.v2i64.v2p0(<2 x i64> %val, <2 x ptr> %ptrs, <2 x i1> %m, i32 %evl)
  ret void
}

declare void @llvm.vp.scatter.v4i64.v4p0(<4 x i64>, <4 x ptr>, <4 x i1>, i32)

define void @vpscatter_v4i64(<4 x i64> %val, <4 x ptr> %ptrs, <4 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_v4i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (zero), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_v4i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (zero), v10, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.v4i64.v4p0(<4 x i64> %val, <4 x ptr> %ptrs, <4 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_truemask_v4i64(<4 x i64> %val, <4 x ptr> %ptrs, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_truemask_v4i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (zero), v10
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_truemask_v4i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (zero), v10
; RV64-NEXT:    ret
  %mhead = insertelement <4 x i1> poison, i1 1, i32 0
  %mtrue = shufflevector <4 x i1> %mhead, <4 x i1> poison, <4 x i32> zeroinitializer
  call void @llvm.vp.scatter.v4i64.v4p0(<4 x i64> %val, <4 x ptr> %ptrs, <4 x i1> %mtrue, i32 %evl)
  ret void
}

declare void @llvm.vp.scatter.v8i64.v8p0(<8 x i64>, <8 x ptr>, <8 x i1>, i32)

define void @vpscatter_v8i64(<8 x i64> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_v8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (zero), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_v8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (zero), v12, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.v8i64.v8p0(<8 x i64> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_v8i8_v8i64(<8 x i64> %val, ptr %base, <8 x i8> %idxs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_v8i8_v8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV32-NEXT:    vsext.vf4 v14, v12
; RV32-NEXT:    vsll.vi v12, v14, 3
; RV32-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_v8i8_v8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV64-NEXT:    vsext.vf8 v16, v12
; RV64-NEXT:    vsll.vi v12, v16, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i64, ptr %base, <8 x i8> %idxs
  call void @llvm.vp.scatter.v8i64.v8p0(<8 x i64> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_sext_v8i8_v8i64(<8 x i64> %val, ptr %base, <8 x i8> %idxs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_sext_v8i8_v8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV32-NEXT:    vsext.vf4 v14, v12
; RV32-NEXT:    vsll.vi v12, v14, 3
; RV32-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_sext_v8i8_v8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV64-NEXT:    vsext.vf8 v16, v12
; RV64-NEXT:    vsll.vi v12, v16, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %eidxs = sext <8 x i8> %idxs to <8 x i64>
  %ptrs = getelementptr inbounds i64, ptr %base, <8 x i64> %eidxs
  call void @llvm.vp.scatter.v8i64.v8p0(<8 x i64> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_zext_v8i8_v8i64(<8 x i64> %val, ptr %base, <8 x i8> %idxs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_zext_v8i8_v8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; RV32-NEXT:    vzext.vf2 v13, v12
; RV32-NEXT:    vsll.vi v12, v13, 3
; RV32-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; RV32-NEXT:    vsoxei16.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_zext_v8i8_v8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; RV64-NEXT:    vzext.vf2 v13, v12
; RV64-NEXT:    vsll.vi v12, v13, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; RV64-NEXT:    vsoxei16.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %eidxs = zext <8 x i8> %idxs to <8 x i64>
  %ptrs = getelementptr inbounds i64, ptr %base, <8 x i64> %eidxs
  call void @llvm.vp.scatter.v8i64.v8p0(<8 x i64> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_v8i16_v8i64(<8 x i64> %val, ptr %base, <8 x i16> %idxs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_v8i16_v8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV32-NEXT:    vsext.vf2 v14, v12
; RV32-NEXT:    vsll.vi v12, v14, 3
; RV32-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_v8i16_v8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV64-NEXT:    vsext.vf4 v16, v12
; RV64-NEXT:    vsll.vi v12, v16, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i64, ptr %base, <8 x i16> %idxs
  call void @llvm.vp.scatter.v8i64.v8p0(<8 x i64> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_sext_v8i16_v8i64(<8 x i64> %val, ptr %base, <8 x i16> %idxs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_sext_v8i16_v8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV32-NEXT:    vsext.vf2 v14, v12
; RV32-NEXT:    vsll.vi v12, v14, 3
; RV32-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_sext_v8i16_v8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV64-NEXT:    vsext.vf4 v16, v12
; RV64-NEXT:    vsll.vi v12, v16, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %eidxs = sext <8 x i16> %idxs to <8 x i64>
  %ptrs = getelementptr inbounds i64, ptr %base, <8 x i64> %eidxs
  call void @llvm.vp.scatter.v8i64.v8p0(<8 x i64> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_zext_v8i16_v8i64(<8 x i64> %val, ptr %base, <8 x i16> %idxs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_zext_v8i16_v8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV32-NEXT:    vzext.vf2 v14, v12
; RV32-NEXT:    vsll.vi v12, v14, 3
; RV32-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_zext_v8i16_v8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV64-NEXT:    vzext.vf2 v14, v12
; RV64-NEXT:    vsll.vi v12, v14, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; RV64-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %eidxs = zext <8 x i16> %idxs to <8 x i64>
  %ptrs = getelementptr inbounds i64, ptr %base, <8 x i64> %eidxs
  call void @llvm.vp.scatter.v8i64.v8p0(<8 x i64> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_v8i32_v8i64(<8 x i64> %val, ptr %base, <8 x i32> %idxs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_v8i32_v8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV32-NEXT:    vsll.vi v12, v12, 3
; RV32-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_v8i32_v8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV64-NEXT:    vsext.vf2 v16, v12
; RV64-NEXT:    vsll.vi v12, v16, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i64, ptr %base, <8 x i32> %idxs
  call void @llvm.vp.scatter.v8i64.v8p0(<8 x i64> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_sext_v8i32_v8i64(<8 x i64> %val, ptr %base, <8 x i32> %idxs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_sext_v8i32_v8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV32-NEXT:    vsll.vi v12, v12, 3
; RV32-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_sext_v8i32_v8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV64-NEXT:    vsext.vf2 v16, v12
; RV64-NEXT:    vsll.vi v12, v16, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %eidxs = sext <8 x i32> %idxs to <8 x i64>
  %ptrs = getelementptr inbounds i64, ptr %base, <8 x i64> %eidxs
  call void @llvm.vp.scatter.v8i64.v8p0(<8 x i64> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_zext_v8i32_v8i64(<8 x i64> %val, ptr %base, <8 x i32> %idxs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_zext_v8i32_v8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV32-NEXT:    vsll.vi v12, v12, 3
; RV32-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_zext_v8i32_v8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV64-NEXT:    vzext.vf2 v16, v12
; RV64-NEXT:    vsll.vi v12, v16, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %eidxs = zext <8 x i32> %idxs to <8 x i64>
  %ptrs = getelementptr inbounds i64, ptr %base, <8 x i64> %eidxs
  call void @llvm.vp.scatter.v8i64.v8p0(<8 x i64> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_v8i64(<8 x i64> %val, ptr %base, <8 x i64> %idxs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_v8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV32-NEXT:    vnsrl.wi v16, v12, 0
; RV32-NEXT:    vsll.vi v12, v16, 3
; RV32-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_v8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV64-NEXT:    vsll.vi v12, v12, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i64, ptr %base, <8 x i64> %idxs
  call void @llvm.vp.scatter.v8i64.v8p0(<8 x i64> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

declare void @llvm.vp.scatter.v2f16.v2p0(<2 x half>, <2 x ptr>, <2 x i1>, i32)

define void @vpscatter_v2f16(<2 x half> %val, <2 x ptr> %ptrs, <2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_v2f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_v2f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (zero), v9, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.v2f16.v2p0(<2 x half> %val, <2 x ptr> %ptrs, <2 x i1> %m, i32 %evl)
  ret void
}

declare void @llvm.vp.scatter.v4f16.v4p0(<4 x half>, <4 x ptr>, <4 x i1>, i32)

define void @vpscatter_v4f16(<4 x half> %val, <4 x ptr> %ptrs, <4 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_v4f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_v4f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (zero), v10, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.v4f16.v4p0(<4 x half> %val, <4 x ptr> %ptrs, <4 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_truemask_v4f16(<4 x half> %val, <4 x ptr> %ptrs, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_truemask_v4f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (zero), v9
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_truemask_v4f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (zero), v10
; RV64-NEXT:    ret
  %mhead = insertelement <4 x i1> poison, i1 1, i32 0
  %mtrue = shufflevector <4 x i1> %mhead, <4 x i1> poison, <4 x i32> zeroinitializer
  call void @llvm.vp.scatter.v4f16.v4p0(<4 x half> %val, <4 x ptr> %ptrs, <4 x i1> %mtrue, i32 %evl)
  ret void
}

declare void @llvm.vp.scatter.v8f16.v8p0(<8 x half>, <8 x ptr>, <8 x i1>, i32)

define void @vpscatter_v8f16(<8 x half> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_v8f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (zero), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_v8f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (zero), v12, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.v8f16.v8p0(<8 x half> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_v8i8_v8f16(<8 x half> %val, ptr %base, <8 x i8> %idxs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_v8i8_v8f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV32-NEXT:    vsext.vf4 v10, v9
; RV32-NEXT:    vadd.vv v10, v10, v10
; RV32-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (a0), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_v8i8_v8f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV64-NEXT:    vsext.vf8 v12, v9
; RV64-NEXT:    vadd.vv v12, v12, v12
; RV64-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds half, ptr %base, <8 x i8> %idxs
  call void @llvm.vp.scatter.v8f16.v8p0(<8 x half> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_sext_v8i8_v8f16(<8 x half> %val, ptr %base, <8 x i8> %idxs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_sext_v8i8_v8f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV32-NEXT:    vsext.vf4 v10, v9
; RV32-NEXT:    vadd.vv v10, v10, v10
; RV32-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (a0), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_sext_v8i8_v8f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV64-NEXT:    vsext.vf8 v12, v9
; RV64-NEXT:    vadd.vv v12, v12, v12
; RV64-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %eidxs = sext <8 x i8> %idxs to <8 x i16>
  %ptrs = getelementptr inbounds half, ptr %base, <8 x i16> %eidxs
  call void @llvm.vp.scatter.v8f16.v8p0(<8 x half> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_zext_v8i8_v8f16(<8 x half> %val, ptr %base, <8 x i8> %idxs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_zext_v8i8_v8f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e8, mf2, ta, ma
; RV32-NEXT:    vwaddu.vv v10, v9, v9
; RV32-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; RV32-NEXT:    vsoxei16.v v8, (a0), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_zext_v8i8_v8f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e8, mf2, ta, ma
; RV64-NEXT:    vwaddu.vv v10, v9, v9
; RV64-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; RV64-NEXT:    vsoxei16.v v8, (a0), v10, v0.t
; RV64-NEXT:    ret
  %eidxs = zext <8 x i8> %idxs to <8 x i16>
  %ptrs = getelementptr inbounds half, ptr %base, <8 x i16> %eidxs
  call void @llvm.vp.scatter.v8f16.v8p0(<8 x half> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_v8f16(<8 x half> %val, ptr %base, <8 x i16> %idxs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_v8f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; RV32-NEXT:    vwadd.vv v10, v9, v9
; RV32-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (a0), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_v8f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV64-NEXT:    vsext.vf4 v12, v9
; RV64-NEXT:    vadd.vv v12, v12, v12
; RV64-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds half, ptr %base, <8 x i16> %idxs
  call void @llvm.vp.scatter.v8f16.v8p0(<8 x half> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

declare void @llvm.vp.scatter.v2f32.v2p0(<2 x float>, <2 x ptr>, <2 x i1>, i32)

define void @vpscatter_v2f32(<2 x float> %val, <2 x ptr> %ptrs, <2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_v2f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_v2f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (zero), v9, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.v2f32.v2p0(<2 x float> %val, <2 x ptr> %ptrs, <2 x i1> %m, i32 %evl)
  ret void
}

declare void @llvm.vp.scatter.v4f32.v4p0(<4 x float>, <4 x ptr>, <4 x i1>, i32)

define void @vpscatter_v4f32(<4 x float> %val, <4 x ptr> %ptrs, <4 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_v4f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_v4f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (zero), v10, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.v4f32.v4p0(<4 x float> %val, <4 x ptr> %ptrs, <4 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_truemask_v4f32(<4 x float> %val, <4 x ptr> %ptrs, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_truemask_v4f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (zero), v9
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_truemask_v4f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (zero), v10
; RV64-NEXT:    ret
  %mhead = insertelement <4 x i1> poison, i1 1, i32 0
  %mtrue = shufflevector <4 x i1> %mhead, <4 x i1> poison, <4 x i32> zeroinitializer
  call void @llvm.vp.scatter.v4f32.v4p0(<4 x float> %val, <4 x ptr> %ptrs, <4 x i1> %mtrue, i32 %evl)
  ret void
}

declare void @llvm.vp.scatter.v8f32.v8p0(<8 x float>, <8 x ptr>, <8 x i1>, i32)

define void @vpscatter_v8f32(<8 x float> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_v8f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (zero), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_v8f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (zero), v12, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.v8f32.v8p0(<8 x float> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_v8i8_v8f32(<8 x float> %val, ptr %base, <8 x i8> %idxs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_v8i8_v8f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV32-NEXT:    vsext.vf4 v12, v10
; RV32-NEXT:    vsll.vi v10, v12, 2
; RV32-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (a0), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_v8i8_v8f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV64-NEXT:    vsext.vf8 v12, v10
; RV64-NEXT:    vsll.vi v12, v12, 2
; RV64-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds float, ptr %base, <8 x i8> %idxs
  call void @llvm.vp.scatter.v8f32.v8p0(<8 x float> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_sext_v8i8_v8f32(<8 x float> %val, ptr %base, <8 x i8> %idxs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_sext_v8i8_v8f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV32-NEXT:    vsext.vf4 v12, v10
; RV32-NEXT:    vsll.vi v10, v12, 2
; RV32-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (a0), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_sext_v8i8_v8f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV64-NEXT:    vsext.vf8 v12, v10
; RV64-NEXT:    vsll.vi v12, v12, 2
; RV64-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %eidxs = sext <8 x i8> %idxs to <8 x i32>
  %ptrs = getelementptr inbounds float, ptr %base, <8 x i32> %eidxs
  call void @llvm.vp.scatter.v8f32.v8p0(<8 x float> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_zext_v8i8_v8f32(<8 x float> %val, ptr %base, <8 x i8> %idxs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_zext_v8i8_v8f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; RV32-NEXT:    vzext.vf2 v11, v10
; RV32-NEXT:    vsll.vi v10, v11, 2
; RV32-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; RV32-NEXT:    vsoxei16.v v8, (a0), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_zext_v8i8_v8f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; RV64-NEXT:    vzext.vf2 v11, v10
; RV64-NEXT:    vsll.vi v10, v11, 2
; RV64-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; RV64-NEXT:    vsoxei16.v v8, (a0), v10, v0.t
; RV64-NEXT:    ret
  %eidxs = zext <8 x i8> %idxs to <8 x i32>
  %ptrs = getelementptr inbounds float, ptr %base, <8 x i32> %eidxs
  call void @llvm.vp.scatter.v8f32.v8p0(<8 x float> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_v8i16_v8f32(<8 x float> %val, ptr %base, <8 x i16> %idxs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_v8i16_v8f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV32-NEXT:    vsext.vf2 v12, v10
; RV32-NEXT:    vsll.vi v10, v12, 2
; RV32-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (a0), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_v8i16_v8f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV64-NEXT:    vsext.vf4 v12, v10
; RV64-NEXT:    vsll.vi v12, v12, 2
; RV64-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds float, ptr %base, <8 x i16> %idxs
  call void @llvm.vp.scatter.v8f32.v8p0(<8 x float> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_sext_v8i16_v8f32(<8 x float> %val, ptr %base, <8 x i16> %idxs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_sext_v8i16_v8f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV32-NEXT:    vsext.vf2 v12, v10
; RV32-NEXT:    vsll.vi v10, v12, 2
; RV32-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (a0), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_sext_v8i16_v8f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV64-NEXT:    vsext.vf4 v12, v10
; RV64-NEXT:    vsll.vi v12, v12, 2
; RV64-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %eidxs = sext <8 x i16> %idxs to <8 x i32>
  %ptrs = getelementptr inbounds float, ptr %base, <8 x i32> %eidxs
  call void @llvm.vp.scatter.v8f32.v8p0(<8 x float> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_zext_v8i16_v8f32(<8 x float> %val, ptr %base, <8 x i16> %idxs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_zext_v8i16_v8f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV32-NEXT:    vzext.vf2 v12, v10
; RV32-NEXT:    vsll.vi v10, v12, 2
; RV32-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (a0), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_zext_v8i16_v8f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV64-NEXT:    vzext.vf2 v12, v10
; RV64-NEXT:    vsll.vi v10, v12, 2
; RV64-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; RV64-NEXT:    vsoxei32.v v8, (a0), v10, v0.t
; RV64-NEXT:    ret
  %eidxs = zext <8 x i16> %idxs to <8 x i32>
  %ptrs = getelementptr inbounds float, ptr %base, <8 x i32> %eidxs
  call void @llvm.vp.scatter.v8f32.v8p0(<8 x float> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_v8f32(<8 x float> %val, ptr %base, <8 x i32> %idxs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_v8f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV32-NEXT:    vsll.vi v10, v10, 2
; RV32-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (a0), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_v8f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV64-NEXT:    vsext.vf2 v12, v10
; RV64-NEXT:    vsll.vi v12, v12, 2
; RV64-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds float, ptr %base, <8 x i32> %idxs
  call void @llvm.vp.scatter.v8f32.v8p0(<8 x float> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

declare void @llvm.vp.scatter.v2f64.v2p0(<2 x double>, <2 x ptr>, <2 x i1>, i32)

define void @vpscatter_v2f64(<2 x double> %val, <2 x ptr> %ptrs, <2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_v2f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_v2f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (zero), v9, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.v2f64.v2p0(<2 x double> %val, <2 x ptr> %ptrs, <2 x i1> %m, i32 %evl)
  ret void
}

declare void @llvm.vp.scatter.v4f64.v4p0(<4 x double>, <4 x ptr>, <4 x i1>, i32)

define void @vpscatter_v4f64(<4 x double> %val, <4 x ptr> %ptrs, <4 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_v4f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (zero), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_v4f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (zero), v10, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.v4f64.v4p0(<4 x double> %val, <4 x ptr> %ptrs, <4 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_truemask_v4f64(<4 x double> %val, <4 x ptr> %ptrs, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_truemask_v4f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (zero), v10
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_truemask_v4f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (zero), v10
; RV64-NEXT:    ret
  %mhead = insertelement <4 x i1> poison, i1 1, i32 0
  %mtrue = shufflevector <4 x i1> %mhead, <4 x i1> poison, <4 x i32> zeroinitializer
  call void @llvm.vp.scatter.v4f64.v4p0(<4 x double> %val, <4 x ptr> %ptrs, <4 x i1> %mtrue, i32 %evl)
  ret void
}

declare void @llvm.vp.scatter.v8f64.v8p0(<8 x double>, <8 x ptr>, <8 x i1>, i32)

define void @vpscatter_v8f64(<8 x double> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_v8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (zero), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_v8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (zero), v12, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.v8f64.v8p0(<8 x double> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_v8i8_v8f64(<8 x double> %val, ptr %base, <8 x i8> %idxs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_v8i8_v8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV32-NEXT:    vsext.vf4 v14, v12
; RV32-NEXT:    vsll.vi v12, v14, 3
; RV32-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_v8i8_v8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV64-NEXT:    vsext.vf8 v16, v12
; RV64-NEXT:    vsll.vi v12, v16, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds double, ptr %base, <8 x i8> %idxs
  call void @llvm.vp.scatter.v8f64.v8p0(<8 x double> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_sext_v8i8_v8f64(<8 x double> %val, ptr %base, <8 x i8> %idxs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_sext_v8i8_v8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV32-NEXT:    vsext.vf4 v14, v12
; RV32-NEXT:    vsll.vi v12, v14, 3
; RV32-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_sext_v8i8_v8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV64-NEXT:    vsext.vf8 v16, v12
; RV64-NEXT:    vsll.vi v12, v16, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %eidxs = sext <8 x i8> %idxs to <8 x i64>
  %ptrs = getelementptr inbounds double, ptr %base, <8 x i64> %eidxs
  call void @llvm.vp.scatter.v8f64.v8p0(<8 x double> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_zext_v8i8_v8f64(<8 x double> %val, ptr %base, <8 x i8> %idxs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_zext_v8i8_v8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; RV32-NEXT:    vzext.vf2 v13, v12
; RV32-NEXT:    vsll.vi v12, v13, 3
; RV32-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; RV32-NEXT:    vsoxei16.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_zext_v8i8_v8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; RV64-NEXT:    vzext.vf2 v13, v12
; RV64-NEXT:    vsll.vi v12, v13, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; RV64-NEXT:    vsoxei16.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %eidxs = zext <8 x i8> %idxs to <8 x i64>
  %ptrs = getelementptr inbounds double, ptr %base, <8 x i64> %eidxs
  call void @llvm.vp.scatter.v8f64.v8p0(<8 x double> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_v8i16_v8f64(<8 x double> %val, ptr %base, <8 x i16> %idxs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_v8i16_v8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV32-NEXT:    vsext.vf2 v14, v12
; RV32-NEXT:    vsll.vi v12, v14, 3
; RV32-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_v8i16_v8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV64-NEXT:    vsext.vf4 v16, v12
; RV64-NEXT:    vsll.vi v12, v16, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds double, ptr %base, <8 x i16> %idxs
  call void @llvm.vp.scatter.v8f64.v8p0(<8 x double> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_sext_v8i16_v8f64(<8 x double> %val, ptr %base, <8 x i16> %idxs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_sext_v8i16_v8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV32-NEXT:    vsext.vf2 v14, v12
; RV32-NEXT:    vsll.vi v12, v14, 3
; RV32-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_sext_v8i16_v8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV64-NEXT:    vsext.vf4 v16, v12
; RV64-NEXT:    vsll.vi v12, v16, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %eidxs = sext <8 x i16> %idxs to <8 x i64>
  %ptrs = getelementptr inbounds double, ptr %base, <8 x i64> %eidxs
  call void @llvm.vp.scatter.v8f64.v8p0(<8 x double> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_zext_v8i16_v8f64(<8 x double> %val, ptr %base, <8 x i16> %idxs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_zext_v8i16_v8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV32-NEXT:    vzext.vf2 v14, v12
; RV32-NEXT:    vsll.vi v12, v14, 3
; RV32-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_zext_v8i16_v8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV64-NEXT:    vzext.vf2 v14, v12
; RV64-NEXT:    vsll.vi v12, v14, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; RV64-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %eidxs = zext <8 x i16> %idxs to <8 x i64>
  %ptrs = getelementptr inbounds double, ptr %base, <8 x i64> %eidxs
  call void @llvm.vp.scatter.v8f64.v8p0(<8 x double> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_v8i32_v8f64(<8 x double> %val, ptr %base, <8 x i32> %idxs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_v8i32_v8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV32-NEXT:    vsll.vi v12, v12, 3
; RV32-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_v8i32_v8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV64-NEXT:    vsext.vf2 v16, v12
; RV64-NEXT:    vsll.vi v12, v16, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds double, ptr %base, <8 x i32> %idxs
  call void @llvm.vp.scatter.v8f64.v8p0(<8 x double> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_sext_v8i32_v8f64(<8 x double> %val, ptr %base, <8 x i32> %idxs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_sext_v8i32_v8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV32-NEXT:    vsll.vi v12, v12, 3
; RV32-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_sext_v8i32_v8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV64-NEXT:    vsext.vf2 v16, v12
; RV64-NEXT:    vsll.vi v12, v16, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %eidxs = sext <8 x i32> %idxs to <8 x i64>
  %ptrs = getelementptr inbounds double, ptr %base, <8 x i64> %eidxs
  call void @llvm.vp.scatter.v8f64.v8p0(<8 x double> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_zext_v8i32_v8f64(<8 x double> %val, ptr %base, <8 x i32> %idxs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_zext_v8i32_v8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV32-NEXT:    vsll.vi v12, v12, 3
; RV32-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_zext_v8i32_v8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV64-NEXT:    vzext.vf2 v16, v12
; RV64-NEXT:    vsll.vi v12, v16, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %eidxs = zext <8 x i32> %idxs to <8 x i64>
  %ptrs = getelementptr inbounds double, ptr %base, <8 x i64> %eidxs
  call void @llvm.vp.scatter.v8f64.v8p0(<8 x double> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_v8f64(<8 x double> %val, ptr %base, <8 x i64> %idxs, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_v8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV32-NEXT:    vnsrl.wi v16, v12, 0
; RV32-NEXT:    vsll.vi v12, v16, 3
; RV32-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_v8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV64-NEXT:    vsll.vi v12, v12, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds double, ptr %base, <8 x i64> %idxs
  call void @llvm.vp.scatter.v8f64.v8p0(<8 x double> %val, <8 x ptr> %ptrs, <8 x i1> %m, i32 %evl)
  ret void
}

declare void @llvm.vp.scatter.v32f64.v32p0(<32 x double>, <32 x ptr>, <32 x i1>, i32)

define void @vpscatter_v32f64(<32 x double> %val, <32 x ptr> %ptrs, <32 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_v32f64:
; RV32:       # %bb.0:
; RV32-NEXT:    li a2, 32
; RV32-NEXT:    vsetvli zero, a2, e32, m8, ta, ma
; RV32-NEXT:    vle32.v v24, (a0)
; RV32-NEXT:    li a2, 16
; RV32-NEXT:    mv a0, a1
; RV32-NEXT:    bltu a1, a2, .LBB79_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    li a0, 16
; RV32-NEXT:  .LBB79_2:
; RV32-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (zero), v24, v0.t
; RV32-NEXT:    addi a0, a1, -16
; RV32-NEXT:    sltu a1, a1, a0
; RV32-NEXT:    addi a1, a1, -1
; RV32-NEXT:    and a0, a1, a0
; RV32-NEXT:    vsetivli zero, 16, e32, m8, ta, ma
; RV32-NEXT:    vslidedown.vi v8, v24, 16
; RV32-NEXT:    vsetivli zero, 2, e8, mf4, ta, ma
; RV32-NEXT:    vslidedown.vi v0, v0, 2
; RV32-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; RV32-NEXT:    vsoxei32.v v16, (zero), v8, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_v32f64:
; RV64:       # %bb.0:
; RV64-NEXT:    addi sp, sp, -16
; RV64-NEXT:    .cfi_def_cfa_offset 16
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    slli a1, a1, 3
; RV64-NEXT:    sub sp, sp, a1
; RV64-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x08, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 8 * vlenb
; RV64-NEXT:    addi a1, a0, 128
; RV64-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; RV64-NEXT:    vle64.v v24, (a1)
; RV64-NEXT:    addi a1, sp, 16
; RV64-NEXT:    vs8r.v v24, (a1) # Unknown-size Folded Spill
; RV64-NEXT:    vle64.v v24, (a0)
; RV64-NEXT:    li a1, 16
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:    bltu a2, a1, .LBB79_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    li a0, 16
; RV64-NEXT:  .LBB79_2:
; RV64-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; RV64-NEXT:    vsoxei64.v v8, (zero), v24, v0.t
; RV64-NEXT:    addi a0, a2, -16
; RV64-NEXT:    sltu a1, a2, a0
; RV64-NEXT:    addi a1, a1, -1
; RV64-NEXT:    and a0, a1, a0
; RV64-NEXT:    vsetivli zero, 2, e8, mf4, ta, ma
; RV64-NEXT:    vslidedown.vi v0, v0, 2
; RV64-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; RV64-NEXT:    addi a0, sp, 16
; RV64-NEXT:    vl8r.v v8, (a0) # Unknown-size Folded Reload
; RV64-NEXT:    vsoxei64.v v16, (zero), v8, v0.t
; RV64-NEXT:    csrr a0, vlenb
; RV64-NEXT:    slli a0, a0, 3
; RV64-NEXT:    add sp, sp, a0
; RV64-NEXT:    addi sp, sp, 16
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.v32f64.v32p0(<32 x double> %val, <32 x ptr> %ptrs, <32 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_v32i32_v32f64(<32 x double> %val, ptr %base, <32 x i32> %idxs, <32 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_v32i32_v32f64:
; RV32:       # %bb.0:
; RV32-NEXT:    li a3, 32
; RV32-NEXT:    vsetvli zero, a3, e32, m8, ta, ma
; RV32-NEXT:    vle32.v v24, (a1)
; RV32-NEXT:    li a3, 16
; RV32-NEXT:    vsll.vi v24, v24, 3
; RV32-NEXT:    mv a1, a2
; RV32-NEXT:    bltu a2, a3, .LBB80_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    li a1, 16
; RV32-NEXT:  .LBB80_2:
; RV32-NEXT:    vsetvli zero, a1, e64, m8, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (a0), v24, v0.t
; RV32-NEXT:    addi a1, a2, -16
; RV32-NEXT:    sltu a2, a2, a1
; RV32-NEXT:    addi a2, a2, -1
; RV32-NEXT:    and a1, a2, a1
; RV32-NEXT:    vsetivli zero, 16, e32, m8, ta, ma
; RV32-NEXT:    vslidedown.vi v8, v24, 16
; RV32-NEXT:    vsetivli zero, 2, e8, mf4, ta, ma
; RV32-NEXT:    vslidedown.vi v0, v0, 2
; RV32-NEXT:    vsetvli zero, a1, e64, m8, ta, ma
; RV32-NEXT:    vsoxei32.v v16, (a0), v8, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_v32i32_v32f64:
; RV64:       # %bb.0:
; RV64-NEXT:    addi sp, sp, -16
; RV64-NEXT:    .cfi_def_cfa_offset 16
; RV64-NEXT:    csrr a3, vlenb
; RV64-NEXT:    li a4, 10
; RV64-NEXT:    mul a3, a3, a4
; RV64-NEXT:    sub sp, sp, a3
; RV64-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x0a, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 10 * vlenb
; RV64-NEXT:    li a3, 32
; RV64-NEXT:    vsetvli zero, a3, e32, m8, ta, ma
; RV64-NEXT:    vle32.v v24, (a1)
; RV64-NEXT:    addi a1, sp, 16
; RV64-NEXT:    vs1r.v v0, (a1) # Unknown-size Folded Spill
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    add a1, sp, a1
; RV64-NEXT:    addi a1, a1, 16
; RV64-NEXT:    vs8r.v v16, (a1) # Unknown-size Folded Spill
; RV64-NEXT:    vsetivli zero, 16, e32, m8, ta, ma
; RV64-NEXT:    vslidedown.vi v0, v24, 16
; RV64-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; RV64-NEXT:    vsext.vf2 v16, v0
; RV64-NEXT:    vsll.vi v16, v16, 3
; RV64-NEXT:    vsext.vf2 v0, v24
; RV64-NEXT:    li a3, 16
; RV64-NEXT:    vsll.vi v24, v0, 3
; RV64-NEXT:    mv a1, a2
; RV64-NEXT:    bltu a2, a3, .LBB80_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    li a1, 16
; RV64-NEXT:  .LBB80_2:
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, ma
; RV64-NEXT:    addi a1, sp, 16
; RV64-NEXT:    vl1r.v v0, (a1) # Unknown-size Folded Reload
; RV64-NEXT:    vsoxei64.v v8, (a0), v24, v0.t
; RV64-NEXT:    addi a1, a2, -16
; RV64-NEXT:    sltu a2, a2, a1
; RV64-NEXT:    addi a2, a2, -1
; RV64-NEXT:    and a1, a2, a1
; RV64-NEXT:    vsetivli zero, 2, e8, mf4, ta, ma
; RV64-NEXT:    vslidedown.vi v0, v0, 2
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, ma
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    add a1, sp, a1
; RV64-NEXT:    addi a1, a1, 16
; RV64-NEXT:    vl8r.v v8, (a1) # Unknown-size Folded Reload
; RV64-NEXT:    vsoxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    csrr a0, vlenb
; RV64-NEXT:    li a1, 10
; RV64-NEXT:    mul a0, a0, a1
; RV64-NEXT:    add sp, sp, a0
; RV64-NEXT:    addi sp, sp, 16
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds double, ptr %base, <32 x i32> %idxs
  call void @llvm.vp.scatter.v32f64.v32p0(<32 x double> %val, <32 x ptr> %ptrs, <32 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_sext_v32i32_v32f64(<32 x double> %val, ptr %base, <32 x i32> %idxs, <32 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_sext_v32i32_v32f64:
; RV32:       # %bb.0:
; RV32-NEXT:    li a3, 32
; RV32-NEXT:    vsetvli zero, a3, e32, m8, ta, ma
; RV32-NEXT:    vle32.v v24, (a1)
; RV32-NEXT:    li a3, 16
; RV32-NEXT:    vsll.vi v24, v24, 3
; RV32-NEXT:    mv a1, a2
; RV32-NEXT:    bltu a2, a3, .LBB81_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    li a1, 16
; RV32-NEXT:  .LBB81_2:
; RV32-NEXT:    vsetvli zero, a1, e64, m8, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (a0), v24, v0.t
; RV32-NEXT:    addi a1, a2, -16
; RV32-NEXT:    sltu a2, a2, a1
; RV32-NEXT:    addi a2, a2, -1
; RV32-NEXT:    and a1, a2, a1
; RV32-NEXT:    vsetivli zero, 16, e32, m8, ta, ma
; RV32-NEXT:    vslidedown.vi v8, v24, 16
; RV32-NEXT:    vsetivli zero, 2, e8, mf4, ta, ma
; RV32-NEXT:    vslidedown.vi v0, v0, 2
; RV32-NEXT:    vsetvli zero, a1, e64, m8, ta, ma
; RV32-NEXT:    vsoxei32.v v16, (a0), v8, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_sext_v32i32_v32f64:
; RV64:       # %bb.0:
; RV64-NEXT:    addi sp, sp, -16
; RV64-NEXT:    .cfi_def_cfa_offset 16
; RV64-NEXT:    csrr a3, vlenb
; RV64-NEXT:    li a4, 10
; RV64-NEXT:    mul a3, a3, a4
; RV64-NEXT:    sub sp, sp, a3
; RV64-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x0a, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 10 * vlenb
; RV64-NEXT:    li a3, 32
; RV64-NEXT:    vsetvli zero, a3, e32, m8, ta, ma
; RV64-NEXT:    vle32.v v24, (a1)
; RV64-NEXT:    addi a1, sp, 16
; RV64-NEXT:    vs1r.v v0, (a1) # Unknown-size Folded Spill
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    add a1, sp, a1
; RV64-NEXT:    addi a1, a1, 16
; RV64-NEXT:    vs8r.v v16, (a1) # Unknown-size Folded Spill
; RV64-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; RV64-NEXT:    vsext.vf2 v0, v24
; RV64-NEXT:    vsetivli zero, 16, e32, m8, ta, ma
; RV64-NEXT:    vslidedown.vi v24, v24, 16
; RV64-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; RV64-NEXT:    vsext.vf2 v16, v24
; RV64-NEXT:    vsll.vi v16, v16, 3
; RV64-NEXT:    li a3, 16
; RV64-NEXT:    vsll.vi v24, v0, 3
; RV64-NEXT:    mv a1, a2
; RV64-NEXT:    bltu a2, a3, .LBB81_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    li a1, 16
; RV64-NEXT:  .LBB81_2:
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, ma
; RV64-NEXT:    addi a1, sp, 16
; RV64-NEXT:    vl1r.v v0, (a1) # Unknown-size Folded Reload
; RV64-NEXT:    vsoxei64.v v8, (a0), v24, v0.t
; RV64-NEXT:    addi a1, a2, -16
; RV64-NEXT:    sltu a2, a2, a1
; RV64-NEXT:    addi a2, a2, -1
; RV64-NEXT:    and a1, a2, a1
; RV64-NEXT:    vsetivli zero, 2, e8, mf4, ta, ma
; RV64-NEXT:    vslidedown.vi v0, v0, 2
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, ma
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    add a1, sp, a1
; RV64-NEXT:    addi a1, a1, 16
; RV64-NEXT:    vl8r.v v8, (a1) # Unknown-size Folded Reload
; RV64-NEXT:    vsoxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    csrr a0, vlenb
; RV64-NEXT:    li a1, 10
; RV64-NEXT:    mul a0, a0, a1
; RV64-NEXT:    add sp, sp, a0
; RV64-NEXT:    addi sp, sp, 16
; RV64-NEXT:    ret
  %eidxs = sext <32 x i32> %idxs to <32 x i64>
  %ptrs = getelementptr inbounds double, ptr %base, <32 x i64> %eidxs
  call void @llvm.vp.scatter.v32f64.v32p0(<32 x double> %val, <32 x ptr> %ptrs, <32 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_zext_v32i32_v32f64(<32 x double> %val, ptr %base, <32 x i32> %idxs, <32 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_zext_v32i32_v32f64:
; RV32:       # %bb.0:
; RV32-NEXT:    li a3, 32
; RV32-NEXT:    vsetvli zero, a3, e32, m8, ta, ma
; RV32-NEXT:    vle32.v v24, (a1)
; RV32-NEXT:    li a3, 16
; RV32-NEXT:    vsll.vi v24, v24, 3
; RV32-NEXT:    mv a1, a2
; RV32-NEXT:    bltu a2, a3, .LBB82_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    li a1, 16
; RV32-NEXT:  .LBB82_2:
; RV32-NEXT:    vsetvli zero, a1, e64, m8, ta, ma
; RV32-NEXT:    vsoxei32.v v8, (a0), v24, v0.t
; RV32-NEXT:    addi a1, a2, -16
; RV32-NEXT:    sltu a2, a2, a1
; RV32-NEXT:    addi a2, a2, -1
; RV32-NEXT:    and a1, a2, a1
; RV32-NEXT:    vsetivli zero, 16, e32, m8, ta, ma
; RV32-NEXT:    vslidedown.vi v8, v24, 16
; RV32-NEXT:    vsetivli zero, 2, e8, mf4, ta, ma
; RV32-NEXT:    vslidedown.vi v0, v0, 2
; RV32-NEXT:    vsetvli zero, a1, e64, m8, ta, ma
; RV32-NEXT:    vsoxei32.v v16, (a0), v8, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_zext_v32i32_v32f64:
; RV64:       # %bb.0:
; RV64-NEXT:    addi sp, sp, -16
; RV64-NEXT:    .cfi_def_cfa_offset 16
; RV64-NEXT:    csrr a3, vlenb
; RV64-NEXT:    li a4, 10
; RV64-NEXT:    mul a3, a3, a4
; RV64-NEXT:    sub sp, sp, a3
; RV64-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x0a, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 10 * vlenb
; RV64-NEXT:    li a3, 32
; RV64-NEXT:    vsetvli zero, a3, e32, m8, ta, ma
; RV64-NEXT:    vle32.v v24, (a1)
; RV64-NEXT:    addi a1, sp, 16
; RV64-NEXT:    vs1r.v v0, (a1) # Unknown-size Folded Spill
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    add a1, sp, a1
; RV64-NEXT:    addi a1, a1, 16
; RV64-NEXT:    vs8r.v v16, (a1) # Unknown-size Folded Spill
; RV64-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; RV64-NEXT:    vzext.vf2 v0, v24
; RV64-NEXT:    vsetivli zero, 16, e32, m8, ta, ma
; RV64-NEXT:    vslidedown.vi v24, v24, 16
; RV64-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; RV64-NEXT:    vzext.vf2 v16, v24
; RV64-NEXT:    vsll.vi v16, v16, 3
; RV64-NEXT:    li a3, 16
; RV64-NEXT:    vsll.vi v24, v0, 3
; RV64-NEXT:    mv a1, a2
; RV64-NEXT:    bltu a2, a3, .LBB82_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    li a1, 16
; RV64-NEXT:  .LBB82_2:
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, ma
; RV64-NEXT:    addi a1, sp, 16
; RV64-NEXT:    vl1r.v v0, (a1) # Unknown-size Folded Reload
; RV64-NEXT:    vsoxei64.v v8, (a0), v24, v0.t
; RV64-NEXT:    addi a1, a2, -16
; RV64-NEXT:    sltu a2, a2, a1
; RV64-NEXT:    addi a2, a2, -1
; RV64-NEXT:    and a1, a2, a1
; RV64-NEXT:    vsetivli zero, 2, e8, mf4, ta, ma
; RV64-NEXT:    vslidedown.vi v0, v0, 2
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, ma
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    add a1, sp, a1
; RV64-NEXT:    addi a1, a1, 16
; RV64-NEXT:    vl8r.v v8, (a1) # Unknown-size Folded Reload
; RV64-NEXT:    vsoxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    csrr a0, vlenb
; RV64-NEXT:    li a1, 10
; RV64-NEXT:    mul a0, a0, a1
; RV64-NEXT:    add sp, sp, a0
; RV64-NEXT:    addi sp, sp, 16
; RV64-NEXT:    ret
  %eidxs = zext <32 x i32> %idxs to <32 x i64>
  %ptrs = getelementptr inbounds double, ptr %base, <32 x i64> %eidxs
  call void @llvm.vp.scatter.v32f64.v32p0(<32 x double> %val, <32 x ptr> %ptrs, <32 x i1> %m, i32 %evl)
  ret void
}
