#pragma once

// Generated by grammar/asdl_cpp.py

#include <libasr/alloc.h>
#include <libasr/location.h>
#include <libasr/colors.h>
#include <libasr/containers.h>
#include <libasr/exception.h>
#include <libasr/asr_scopes.h>
#include <libasr/string_utils.h>
#include <libasr/asr_base_visitor.h>


namespace LCompilers::ASR {
/******************************************************************************/
// Serialization Visitor base class

template <class StructType>
class SerializationBaseVisitor : public BaseVisitor<StructType>
{
private:
    StructType& self() { return static_cast<StructType&>(*this); }
public:
    void visit_TranslationUnit(const TranslationUnit_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.m_symtab->counter);
        self().write_int64(x.m_symtab->get_scope().size());
        for (auto &a : x.m_symtab->get_scope()) {
            if (ASR::is_a<ASR::Function_t>(*a.second)) {
                continue;
            }
            self().write_string(a.first);
            this->visit_symbol(*a.second);
        }
        for (auto &a : x.m_symtab->get_scope()) {
            if (ASR::is_a<ASR::Function_t>(*a.second)) {
                self().write_string(a.first);
                this->visit_symbol(*a.second);
            }
        }
        self().write_int64(x.n_items);
        for (size_t i=0; i<x.n_items; i++) {
            self().write_int8(x.m_items[i]->type);
            self().visit_asr(*x.m_items[i]);
        }
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Program(const Program_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.m_symtab->counter);
        self().write_int64(x.m_symtab->get_scope().size());
        for (auto &a : x.m_symtab->get_scope()) {
            if (ASR::is_a<ASR::Function_t>(*a.second)) {
                continue;
            }
            self().write_string(a.first);
            this->visit_symbol(*a.second);
        }
        for (auto &a : x.m_symtab->get_scope()) {
            if (ASR::is_a<ASR::Function_t>(*a.second)) {
                self().write_string(a.first);
                this->visit_symbol(*a.second);
            }
        }
        self().write_string(x.m_name);
        self().write_int64(x.n_dependencies);
        for (size_t i=0; i<x.n_dependencies; i++) {
            self().write_string(x.m_dependencies[i]);
        }
        self().write_int64(x.n_body);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
        self().write_int64(0);
        self().write_int64(0);
        self().write_int64(0);
        self().write_int64(0);
    }
    void visit_Module(const Module_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.m_symtab->counter);
        self().write_int64(x.m_symtab->get_scope().size());
        for (auto &a : x.m_symtab->get_scope()) {
            if (ASR::is_a<ASR::Function_t>(*a.second)) {
                continue;
            }
            self().write_string(a.first);
            this->visit_symbol(*a.second);
        }
        for (auto &a : x.m_symtab->get_scope()) {
            if (ASR::is_a<ASR::Function_t>(*a.second)) {
                self().write_string(a.first);
                this->visit_symbol(*a.second);
            }
        }
        self().write_string(x.m_name);
        self().write_int64(x.n_dependencies);
        for (size_t i=0; i<x.n_dependencies; i++) {
            self().write_string(x.m_dependencies[i]);
        }
        if (x.m_loaded_from_mod) {
            self().write_bool(true);
        } else {
            self().write_bool(false);
        }
        if (x.m_intrinsic) {
            self().write_bool(true);
        } else {
            self().write_bool(false);
        }
        self().write_int64(0);
        self().write_int64(0);
        self().write_int64(0);
        self().write_int64(0);
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Function(const Function_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.m_symtab->counter);
        self().write_int64(x.m_symtab->get_scope().size());
        for (auto &a : x.m_symtab->get_scope()) {
            if (ASR::is_a<ASR::Function_t>(*a.second)) {
                continue;
            }
            self().write_string(a.first);
            this->visit_symbol(*a.second);
        }
        for (auto &a : x.m_symtab->get_scope()) {
            if (ASR::is_a<ASR::Function_t>(*a.second)) {
                self().write_string(a.first);
                this->visit_symbol(*a.second);
            }
        }
        self().write_string(x.m_name);
        self().visit_ttype(*x.m_function_signature);
        self().write_int64(x.n_dependencies);
        for (size_t i=0; i<x.n_dependencies; i++) {
            self().write_string(x.m_dependencies[i]);
        }
        self().write_int64(x.n_args);
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
        }
        self().write_int64(x.n_body);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
        if (x.m_return_var) {
            self().write_bool(true);
            self().visit_expr(*x.m_return_var);
        } else {
            self().write_bool(false);
        }
        visit_accessType(x.m_access);
        if (x.m_deterministic) {
            self().write_bool(true);
        } else {
            self().write_bool(false);
        }
        if (x.m_side_effect_free) {
            self().write_bool(true);
        } else {
            self().write_bool(false);
        }
        if (x.m_module_file) {
            self().write_bool(true);
            self().write_string(x.m_module_file);
        } else {
            self().write_bool(false);
        }
        self().write_int64(0);
        self().write_int64(0);
        self().write_int64(0);
        self().write_int64(0);
    }
    void visit_GenericProcedure(const GenericProcedure_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.m_parent_symtab->counter);
        self().write_string(x.m_name);
        self().write_int64(x.n_procs);
        for (size_t i=0; i<x.n_procs; i++) {
            self().write_symbol(*x.m_procs[i]);
        }
        visit_accessType(x.m_access);
    }
    void visit_CustomOperator(const CustomOperator_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.m_parent_symtab->counter);
        self().write_string(x.m_name);
        self().write_int64(x.n_procs);
        for (size_t i=0; i<x.n_procs; i++) {
            self().write_symbol(*x.m_procs[i]);
        }
        visit_accessType(x.m_access);
    }
    void visit_ExternalSymbol(const ExternalSymbol_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.m_parent_symtab->counter);
        self().write_string(x.m_name);
        // We skip the symbol for ExternalSymbol
        self().write_string(x.m_module_name);
        self().write_int64(x.n_scope_names);
        for (size_t i=0; i<x.n_scope_names; i++) {
            self().write_string(x.m_scope_names[i]);
        }
        self().write_string(x.m_original_name);
        visit_accessType(x.m_access);
    }
    void visit_Struct(const Struct_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.m_symtab->counter);
        self().write_int64(x.m_symtab->get_scope().size());
        for (auto &a : x.m_symtab->get_scope()) {
            if (ASR::is_a<ASR::Function_t>(*a.second)) {
                continue;
            }
            self().write_string(a.first);
            this->visit_symbol(*a.second);
        }
        for (auto &a : x.m_symtab->get_scope()) {
            if (ASR::is_a<ASR::Function_t>(*a.second)) {
                self().write_string(a.first);
                this->visit_symbol(*a.second);
            }
        }
        self().write_string(x.m_name);
        self().write_int64(x.n_dependencies);
        for (size_t i=0; i<x.n_dependencies; i++) {
            self().write_string(x.m_dependencies[i]);
        }
        self().write_int64(x.n_members);
        for (size_t i=0; i<x.n_members; i++) {
            self().write_string(x.m_members[i]);
        }
        self().write_int64(x.n_member_functions);
        for (size_t i=0; i<x.n_member_functions; i++) {
            self().write_string(x.m_member_functions[i]);
        }
        visit_abiType(x.m_abi);
        visit_accessType(x.m_access);
        if (x.m_is_packed) {
            self().write_bool(true);
        } else {
            self().write_bool(false);
        }
        if (x.m_is_abstract) {
            self().write_bool(true);
        } else {
            self().write_bool(false);
        }
        self().write_int64(x.n_initializers);
        for (size_t i=0; i<x.n_initializers; i++) {
            self().visit_call_arg(x.m_initializers[i]);
        }
        if (x.m_alignment) {
            self().write_bool(true);
            self().visit_expr(*x.m_alignment);
        } else {
            self().write_bool(false);
        }
        if (x.m_parent) {
            self().write_bool(true);
            self().write_symbol(*x.m_parent);
        } else {
            self().write_bool(false);
        }
    }
    void visit_Enum(const Enum_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.m_symtab->counter);
        self().write_int64(x.m_symtab->get_scope().size());
        for (auto &a : x.m_symtab->get_scope()) {
            if (ASR::is_a<ASR::Function_t>(*a.second)) {
                continue;
            }
            self().write_string(a.first);
            this->visit_symbol(*a.second);
        }
        for (auto &a : x.m_symtab->get_scope()) {
            if (ASR::is_a<ASR::Function_t>(*a.second)) {
                self().write_string(a.first);
                this->visit_symbol(*a.second);
            }
        }
        self().write_string(x.m_name);
        self().write_int64(x.n_dependencies);
        for (size_t i=0; i<x.n_dependencies; i++) {
            self().write_string(x.m_dependencies[i]);
        }
        self().write_int64(x.n_members);
        for (size_t i=0; i<x.n_members; i++) {
            self().write_string(x.m_members[i]);
        }
        visit_abiType(x.m_abi);
        visit_accessType(x.m_access);
        visit_enumtypeType(x.m_enum_value_type);
        self().visit_ttype(*x.m_type);
        if (x.m_parent) {
            self().write_bool(true);
            self().write_symbol(*x.m_parent);
        } else {
            self().write_bool(false);
        }
    }
    void visit_Union(const Union_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.m_symtab->counter);
        self().write_int64(x.m_symtab->get_scope().size());
        for (auto &a : x.m_symtab->get_scope()) {
            if (ASR::is_a<ASR::Function_t>(*a.second)) {
                continue;
            }
            self().write_string(a.first);
            this->visit_symbol(*a.second);
        }
        for (auto &a : x.m_symtab->get_scope()) {
            if (ASR::is_a<ASR::Function_t>(*a.second)) {
                self().write_string(a.first);
                this->visit_symbol(*a.second);
            }
        }
        self().write_string(x.m_name);
        self().write_int64(x.n_dependencies);
        for (size_t i=0; i<x.n_dependencies; i++) {
            self().write_string(x.m_dependencies[i]);
        }
        self().write_int64(x.n_members);
        for (size_t i=0; i<x.n_members; i++) {
            self().write_string(x.m_members[i]);
        }
        visit_abiType(x.m_abi);
        visit_accessType(x.m_access);
        self().write_int64(x.n_initializers);
        for (size_t i=0; i<x.n_initializers; i++) {
            self().visit_call_arg(x.m_initializers[i]);
        }
        if (x.m_parent) {
            self().write_bool(true);
            self().write_symbol(*x.m_parent);
        } else {
            self().write_bool(false);
        }
    }
    void visit_Variable(const Variable_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.m_parent_symtab->counter);
        self().write_string(x.m_name);
        self().write_int64(x.n_dependencies);
        for (size_t i=0; i<x.n_dependencies; i++) {
            self().write_string(x.m_dependencies[i]);
        }
        visit_intentType(x.m_intent);
        if (x.m_symbolic_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_symbolic_value);
        } else {
            self().write_bool(false);
        }
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
        visit_storage_typeType(x.m_storage);
        self().visit_ttype(*x.m_type);
        if (x.m_type_declaration) {
            self().write_bool(true);
            self().write_symbol(*x.m_type_declaration);
        } else {
            self().write_bool(false);
        }
        visit_abiType(x.m_abi);
        visit_accessType(x.m_access);
        visit_presenceType(x.m_presence);
        if (x.m_value_attr) {
            self().write_bool(true);
        } else {
            self().write_bool(false);
        }
        if (x.m_target_attr) {
            self().write_bool(true);
        } else {
            self().write_bool(false);
        }
        if (x.m_contiguous_attr) {
            self().write_bool(true);
        } else {
            self().write_bool(false);
        }
        if (x.m_bindc_name) {
            self().write_bool(true);
            self().write_string(x.m_bindc_name);
        } else {
            self().write_bool(false);
        }
    }
    void visit_Class(const Class_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.m_symtab->counter);
        self().write_int64(x.m_symtab->get_scope().size());
        for (auto &a : x.m_symtab->get_scope()) {
            if (ASR::is_a<ASR::Function_t>(*a.second)) {
                continue;
            }
            self().write_string(a.first);
            this->visit_symbol(*a.second);
        }
        for (auto &a : x.m_symtab->get_scope()) {
            if (ASR::is_a<ASR::Function_t>(*a.second)) {
                self().write_string(a.first);
                this->visit_symbol(*a.second);
            }
        }
        self().write_string(x.m_name);
        visit_abiType(x.m_abi);
        visit_accessType(x.m_access);
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ClassProcedure(const ClassProcedure_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.m_parent_symtab->counter);
        self().write_string(x.m_name);
        if (x.m_self_argument) {
            self().write_bool(true);
            self().write_string(x.m_self_argument);
        } else {
            self().write_bool(false);
        }
        self().write_string(x.m_proc_name);
        self().write_symbol(*x.m_proc);
        visit_abiType(x.m_abi);
        if (x.m_is_deferred) {
            self().write_bool(true);
        } else {
            self().write_bool(false);
        }
        if (x.m_is_nopass) {
            self().write_bool(true);
        } else {
            self().write_bool(false);
        }
    }
    void visit_AssociateBlock(const AssociateBlock_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.m_symtab->counter);
        self().write_int64(x.m_symtab->get_scope().size());
        for (auto &a : x.m_symtab->get_scope()) {
            if (ASR::is_a<ASR::Function_t>(*a.second)) {
                continue;
            }
            self().write_string(a.first);
            this->visit_symbol(*a.second);
        }
        for (auto &a : x.m_symtab->get_scope()) {
            if (ASR::is_a<ASR::Function_t>(*a.second)) {
                self().write_string(a.first);
                this->visit_symbol(*a.second);
            }
        }
        self().write_string(x.m_name);
        self().write_int64(x.n_body);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
    }
    void visit_Block(const Block_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.m_symtab->counter);
        self().write_int64(x.m_symtab->get_scope().size());
        for (auto &a : x.m_symtab->get_scope()) {
            if (ASR::is_a<ASR::Function_t>(*a.second)) {
                continue;
            }
            self().write_string(a.first);
            this->visit_symbol(*a.second);
        }
        for (auto &a : x.m_symtab->get_scope()) {
            if (ASR::is_a<ASR::Function_t>(*a.second)) {
                self().write_string(a.first);
                this->visit_symbol(*a.second);
            }
        }
        self().write_string(x.m_name);
        self().write_int64(x.n_body);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
    }
    void visit_Requirement(const Requirement_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.m_symtab->counter);
        self().write_int64(x.m_symtab->get_scope().size());
        for (auto &a : x.m_symtab->get_scope()) {
            if (ASR::is_a<ASR::Function_t>(*a.second)) {
                continue;
            }
            self().write_string(a.first);
            this->visit_symbol(*a.second);
        }
        for (auto &a : x.m_symtab->get_scope()) {
            if (ASR::is_a<ASR::Function_t>(*a.second)) {
                self().write_string(a.first);
                this->visit_symbol(*a.second);
            }
        }
        self().write_string(x.m_name);
        self().write_int64(x.n_args);
        for (size_t i=0; i<x.n_args; i++) {
            self().write_string(x.m_args[i]);
        }
        self().write_int64(x.n_requires);
        for (size_t i=0; i<x.n_requires; i++) {
            self().visit_require_instantiation(*x.m_requires[i]);
        }
    }
    void visit_Template(const Template_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.m_symtab->counter);
        self().write_int64(x.m_symtab->get_scope().size());
        for (auto &a : x.m_symtab->get_scope()) {
            if (ASR::is_a<ASR::Function_t>(*a.second)) {
                continue;
            }
            self().write_string(a.first);
            this->visit_symbol(*a.second);
        }
        for (auto &a : x.m_symtab->get_scope()) {
            if (ASR::is_a<ASR::Function_t>(*a.second)) {
                self().write_string(a.first);
                this->visit_symbol(*a.second);
            }
        }
        self().write_string(x.m_name);
        self().write_int64(x.n_args);
        for (size_t i=0; i<x.n_args; i++) {
            self().write_string(x.m_args[i]);
        }
        self().write_int64(x.n_requires);
        for (size_t i=0; i<x.n_requires; i++) {
            self().visit_require_instantiation(*x.m_requires[i]);
        }
    }
    void visit_Allocate(const Allocate_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.n_args);
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_alloc_arg(x.m_args[i]);
        }
        if (x.m_stat) {
            self().write_bool(true);
            self().visit_expr(*x.m_stat);
        } else {
            self().write_bool(false);
        }
        if (x.m_errmsg) {
            self().write_bool(true);
            self().visit_expr(*x.m_errmsg);
        } else {
            self().write_bool(false);
        }
        if (x.m_source) {
            self().write_bool(true);
            self().visit_expr(*x.m_source);
        } else {
            self().write_bool(false);
        }
    }
    void visit_ReAlloc(const ReAlloc_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.n_args);
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_alloc_arg(x.m_args[i]);
        }
    }
    void visit_Assign(const Assign_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.m_label);
        self().write_string(x.m_variable);
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Assignment(const Assignment_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_target);
        self().visit_expr(*x.m_value);
        if (x.m_overloaded) {
            self().write_bool(true);
            self().visit_stmt(*x.m_overloaded);
        } else {
            self().write_bool(false);
        }
        if (x.m_realloc_lhs) {
            self().write_bool(true);
        } else {
            self().write_bool(false);
        }
    }
    void visit_Associate(const Associate_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_target);
        self().visit_expr(*x.m_value);
    }
    void visit_Cycle(const Cycle_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        if (x.m_stmt_name) {
            self().write_bool(true);
            self().write_string(x.m_stmt_name);
        } else {
            self().write_bool(false);
        }
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ExplicitDeallocate(const ExplicitDeallocate_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.n_vars);
        for (size_t i=0; i<x.n_vars; i++) {
            self().visit_expr(*x.m_vars[i]);
        }
    }
    void visit_ImplicitDeallocate(const ImplicitDeallocate_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.n_vars);
        for (size_t i=0; i<x.n_vars; i++) {
            self().visit_expr(*x.m_vars[i]);
        }
    }
    void visit_DoConcurrentLoop(const DoConcurrentLoop_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.n_head);
        for (size_t i=0; i<x.n_head; i++) {
            self().visit_do_loop_head(x.m_head[i]);
        }
        self().write_int64(x.n_shared);
        for (size_t i=0; i<x.n_shared; i++) {
            self().visit_expr(*x.m_shared[i]);
        }
        self().write_int64(x.n_local);
        for (size_t i=0; i<x.n_local; i++) {
            self().visit_expr(*x.m_local[i]);
        }
        self().write_int64(x.n_reduction);
        for (size_t i=0; i<x.n_reduction; i++) {
            self().visit_reduction_expr(x.m_reduction[i]);
        }
        self().write_int64(x.n_body);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
    }
    void visit_DoLoop(const DoLoop_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        if (x.m_name) {
            self().write_bool(true);
            self().write_string(x.m_name);
        } else {
            self().write_bool(false);
        }
        self().visit_do_loop_head(x.m_head);
        self().write_int64(x.n_body);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
        self().write_int64(x.n_orelse);
        for (size_t i=0; i<x.n_orelse; i++) {
            self().visit_stmt(*x.m_orelse[i]);
        }
    }
    void visit_ErrorStop(const ErrorStop_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        if (x.m_code) {
            self().write_bool(true);
            self().visit_expr(*x.m_code);
        } else {
            self().write_bool(false);
        }
    }
    void visit_Exit(const Exit_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        if (x.m_stmt_name) {
            self().write_bool(true);
            self().write_string(x.m_stmt_name);
        } else {
            self().write_bool(false);
        }
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ForAllSingle(const ForAllSingle_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_do_loop_head(x.m_head);
        self().visit_stmt(*x.m_assign_stmt);
    }
    void visit_ForEach(const ForEach_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_var);
        self().visit_expr(*x.m_container);
        self().write_int64(x.n_body);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
    }
    void visit_GoTo(const GoTo_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.m_target_id);
        self().write_string(x.m_name);
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_GoToTarget(const GoToTarget_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.m_id);
        self().write_string(x.m_name);
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_If(const If_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_test);
        self().write_int64(x.n_body);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
        self().write_int64(x.n_orelse);
        for (size_t i=0; i<x.n_orelse; i++) {
            self().visit_stmt(*x.m_orelse[i]);
        }
    }
    void visit_IfArithmetic(const IfArithmetic_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_test);
        self().write_int64(x.m_lt_label);
        self().write_int64(x.m_eq_label);
        self().write_int64(x.m_gt_label);
    }
    void visit_Print(const Print_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_text);
    }
    void visit_FileOpen(const FileOpen_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.m_label);
        if (x.m_newunit) {
            self().write_bool(true);
            self().visit_expr(*x.m_newunit);
        } else {
            self().write_bool(false);
        }
        if (x.m_filename) {
            self().write_bool(true);
            self().visit_expr(*x.m_filename);
        } else {
            self().write_bool(false);
        }
        if (x.m_status) {
            self().write_bool(true);
            self().visit_expr(*x.m_status);
        } else {
            self().write_bool(false);
        }
        if (x.m_form) {
            self().write_bool(true);
            self().visit_expr(*x.m_form);
        } else {
            self().write_bool(false);
        }
        if (x.m_access) {
            self().write_bool(true);
            self().visit_expr(*x.m_access);
        } else {
            self().write_bool(false);
        }
        if (x.m_iostat) {
            self().write_bool(true);
            self().visit_expr(*x.m_iostat);
        } else {
            self().write_bool(false);
        }
        if (x.m_iomsg) {
            self().write_bool(true);
            self().visit_expr(*x.m_iomsg);
        } else {
            self().write_bool(false);
        }
    }
    void visit_FileClose(const FileClose_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.m_label);
        if (x.m_unit) {
            self().write_bool(true);
            self().visit_expr(*x.m_unit);
        } else {
            self().write_bool(false);
        }
        if (x.m_iostat) {
            self().write_bool(true);
            self().visit_expr(*x.m_iostat);
        } else {
            self().write_bool(false);
        }
        if (x.m_iomsg) {
            self().write_bool(true);
            self().visit_expr(*x.m_iomsg);
        } else {
            self().write_bool(false);
        }
        if (x.m_err) {
            self().write_bool(true);
            self().visit_expr(*x.m_err);
        } else {
            self().write_bool(false);
        }
        if (x.m_status) {
            self().write_bool(true);
            self().visit_expr(*x.m_status);
        } else {
            self().write_bool(false);
        }
    }
    void visit_FileRead(const FileRead_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.m_label);
        if (x.m_unit) {
            self().write_bool(true);
            self().visit_expr(*x.m_unit);
        } else {
            self().write_bool(false);
        }
        if (x.m_fmt) {
            self().write_bool(true);
            self().visit_expr(*x.m_fmt);
        } else {
            self().write_bool(false);
        }
        if (x.m_iomsg) {
            self().write_bool(true);
            self().visit_expr(*x.m_iomsg);
        } else {
            self().write_bool(false);
        }
        if (x.m_iostat) {
            self().write_bool(true);
            self().visit_expr(*x.m_iostat);
        } else {
            self().write_bool(false);
        }
        if (x.m_advance) {
            self().write_bool(true);
            self().visit_expr(*x.m_advance);
        } else {
            self().write_bool(false);
        }
        if (x.m_size) {
            self().write_bool(true);
            self().visit_expr(*x.m_size);
        } else {
            self().write_bool(false);
        }
        if (x.m_id) {
            self().write_bool(true);
            self().visit_expr(*x.m_id);
        } else {
            self().write_bool(false);
        }
        self().write_int64(x.n_values);
        for (size_t i=0; i<x.n_values; i++) {
            self().visit_expr(*x.m_values[i]);
        }
        if (x.m_overloaded) {
            self().write_bool(true);
            self().visit_stmt(*x.m_overloaded);
        } else {
            self().write_bool(false);
        }
        if (x.m_is_formatted) {
            self().write_bool(true);
        } else {
            self().write_bool(false);
        }
    }
    void visit_FileBackspace(const FileBackspace_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.m_label);
        if (x.m_unit) {
            self().write_bool(true);
            self().visit_expr(*x.m_unit);
        } else {
            self().write_bool(false);
        }
        if (x.m_iostat) {
            self().write_bool(true);
            self().visit_expr(*x.m_iostat);
        } else {
            self().write_bool(false);
        }
        if (x.m_err) {
            self().write_bool(true);
            self().visit_expr(*x.m_err);
        } else {
            self().write_bool(false);
        }
    }
    void visit_FileRewind(const FileRewind_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.m_label);
        if (x.m_unit) {
            self().write_bool(true);
            self().visit_expr(*x.m_unit);
        } else {
            self().write_bool(false);
        }
        if (x.m_iostat) {
            self().write_bool(true);
            self().visit_expr(*x.m_iostat);
        } else {
            self().write_bool(false);
        }
        if (x.m_err) {
            self().write_bool(true);
            self().visit_expr(*x.m_err);
        } else {
            self().write_bool(false);
        }
    }
    void visit_FileInquire(const FileInquire_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.m_label);
        if (x.m_unit) {
            self().write_bool(true);
            self().visit_expr(*x.m_unit);
        } else {
            self().write_bool(false);
        }
        if (x.m_file) {
            self().write_bool(true);
            self().visit_expr(*x.m_file);
        } else {
            self().write_bool(false);
        }
        if (x.m_iostat) {
            self().write_bool(true);
            self().visit_expr(*x.m_iostat);
        } else {
            self().write_bool(false);
        }
        if (x.m_err) {
            self().write_bool(true);
            self().visit_expr(*x.m_err);
        } else {
            self().write_bool(false);
        }
        if (x.m_exist) {
            self().write_bool(true);
            self().visit_expr(*x.m_exist);
        } else {
            self().write_bool(false);
        }
        if (x.m_opened) {
            self().write_bool(true);
            self().visit_expr(*x.m_opened);
        } else {
            self().write_bool(false);
        }
        if (x.m_number) {
            self().write_bool(true);
            self().visit_expr(*x.m_number);
        } else {
            self().write_bool(false);
        }
        if (x.m_named) {
            self().write_bool(true);
            self().visit_expr(*x.m_named);
        } else {
            self().write_bool(false);
        }
        if (x.m_name) {
            self().write_bool(true);
            self().visit_expr(*x.m_name);
        } else {
            self().write_bool(false);
        }
        if (x.m_access) {
            self().write_bool(true);
            self().visit_expr(*x.m_access);
        } else {
            self().write_bool(false);
        }
        if (x.m_sequential) {
            self().write_bool(true);
            self().visit_expr(*x.m_sequential);
        } else {
            self().write_bool(false);
        }
        if (x.m_direct) {
            self().write_bool(true);
            self().visit_expr(*x.m_direct);
        } else {
            self().write_bool(false);
        }
        if (x.m_form) {
            self().write_bool(true);
            self().visit_expr(*x.m_form);
        } else {
            self().write_bool(false);
        }
        if (x.m_formatted) {
            self().write_bool(true);
            self().visit_expr(*x.m_formatted);
        } else {
            self().write_bool(false);
        }
        if (x.m_unformatted) {
            self().write_bool(true);
            self().visit_expr(*x.m_unformatted);
        } else {
            self().write_bool(false);
        }
        if (x.m_recl) {
            self().write_bool(true);
            self().visit_expr(*x.m_recl);
        } else {
            self().write_bool(false);
        }
        if (x.m_nextrec) {
            self().write_bool(true);
            self().visit_expr(*x.m_nextrec);
        } else {
            self().write_bool(false);
        }
        if (x.m_blank) {
            self().write_bool(true);
            self().visit_expr(*x.m_blank);
        } else {
            self().write_bool(false);
        }
        if (x.m_position) {
            self().write_bool(true);
            self().visit_expr(*x.m_position);
        } else {
            self().write_bool(false);
        }
        if (x.m_action) {
            self().write_bool(true);
            self().visit_expr(*x.m_action);
        } else {
            self().write_bool(false);
        }
        if (x.m_read) {
            self().write_bool(true);
            self().visit_expr(*x.m_read);
        } else {
            self().write_bool(false);
        }
        if (x.m_write) {
            self().write_bool(true);
            self().visit_expr(*x.m_write);
        } else {
            self().write_bool(false);
        }
        if (x.m_readwrite) {
            self().write_bool(true);
            self().visit_expr(*x.m_readwrite);
        } else {
            self().write_bool(false);
        }
        if (x.m_delim) {
            self().write_bool(true);
            self().visit_expr(*x.m_delim);
        } else {
            self().write_bool(false);
        }
        if (x.m_pad) {
            self().write_bool(true);
            self().visit_expr(*x.m_pad);
        } else {
            self().write_bool(false);
        }
        if (x.m_flen) {
            self().write_bool(true);
            self().visit_expr(*x.m_flen);
        } else {
            self().write_bool(false);
        }
        if (x.m_blocksize) {
            self().write_bool(true);
            self().visit_expr(*x.m_blocksize);
        } else {
            self().write_bool(false);
        }
        if (x.m_convert) {
            self().write_bool(true);
            self().visit_expr(*x.m_convert);
        } else {
            self().write_bool(false);
        }
        if (x.m_carriagecontrol) {
            self().write_bool(true);
            self().visit_expr(*x.m_carriagecontrol);
        } else {
            self().write_bool(false);
        }
        if (x.m_size) {
            self().write_bool(true);
            self().visit_expr(*x.m_size);
        } else {
            self().write_bool(false);
        }
        if (x.m_pos) {
            self().write_bool(true);
            self().visit_expr(*x.m_pos);
        } else {
            self().write_bool(false);
        }
        if (x.m_iolength) {
            self().write_bool(true);
            self().visit_expr(*x.m_iolength);
        } else {
            self().write_bool(false);
        }
    }
    void visit_FileWrite(const FileWrite_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.m_label);
        if (x.m_unit) {
            self().write_bool(true);
            self().visit_expr(*x.m_unit);
        } else {
            self().write_bool(false);
        }
        if (x.m_iomsg) {
            self().write_bool(true);
            self().visit_expr(*x.m_iomsg);
        } else {
            self().write_bool(false);
        }
        if (x.m_iostat) {
            self().write_bool(true);
            self().visit_expr(*x.m_iostat);
        } else {
            self().write_bool(false);
        }
        if (x.m_id) {
            self().write_bool(true);
            self().visit_expr(*x.m_id);
        } else {
            self().write_bool(false);
        }
        self().write_int64(x.n_values);
        for (size_t i=0; i<x.n_values; i++) {
            self().visit_expr(*x.m_values[i]);
        }
        if (x.m_separator) {
            self().write_bool(true);
            self().visit_expr(*x.m_separator);
        } else {
            self().write_bool(false);
        }
        if (x.m_end) {
            self().write_bool(true);
            self().visit_expr(*x.m_end);
        } else {
            self().write_bool(false);
        }
        if (x.m_overloaded) {
            self().write_bool(true);
            self().visit_stmt(*x.m_overloaded);
        } else {
            self().write_bool(false);
        }
        if (x.m_is_formatted) {
            self().write_bool(true);
        } else {
            self().write_bool(false);
        }
    }
    void visit_Return(const Return_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Select(const Select_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_test);
        self().write_int64(x.n_body);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_case_stmt(*x.m_body[i]);
        }
        self().write_int64(x.n_default);
        for (size_t i=0; i<x.n_default; i++) {
            self().visit_stmt(*x.m_default[i]);
        }
        if (x.m_enable_fall_through) {
            self().write_bool(true);
        } else {
            self().write_bool(false);
        }
    }
    void visit_Stop(const Stop_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        if (x.m_code) {
            self().write_bool(true);
            self().visit_expr(*x.m_code);
        } else {
            self().write_bool(false);
        }
    }
    void visit_Assert(const Assert_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_test);
        if (x.m_msg) {
            self().write_bool(true);
            self().visit_expr(*x.m_msg);
        } else {
            self().write_bool(false);
        }
    }
    void visit_SubroutineCall(const SubroutineCall_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_symbol(*x.m_name);
        if (x.m_original_name) {
            self().write_bool(true);
            self().write_symbol(*x.m_original_name);
        } else {
            self().write_bool(false);
        }
        self().write_int64(x.n_args);
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_call_arg(x.m_args[i]);
        }
        if (x.m_dt) {
            self().write_bool(true);
            self().visit_expr(*x.m_dt);
        } else {
            self().write_bool(false);
        }
    }
    void visit_IntrinsicImpureSubroutine(const IntrinsicImpureSubroutine_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.m_sub_intrinsic_id);
        self().write_int64(x.n_args);
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
        }
        self().write_int64(x.m_overload_id);
    }
    void visit_Where(const Where_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_test);
        self().write_int64(x.n_body);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
        self().write_int64(x.n_orelse);
        for (size_t i=0; i<x.n_orelse; i++) {
            self().visit_stmt(*x.m_orelse[i]);
        }
    }
    void visit_WhileLoop(const WhileLoop_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        if (x.m_name) {
            self().write_bool(true);
            self().write_string(x.m_name);
        } else {
            self().write_bool(false);
        }
        self().visit_expr(*x.m_test);
        self().write_int64(x.n_body);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
        self().write_int64(x.n_orelse);
        for (size_t i=0; i<x.n_orelse; i++) {
            self().visit_stmt(*x.m_orelse[i]);
        }
    }
    void visit_Nullify(const Nullify_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.n_vars);
        for (size_t i=0; i<x.n_vars; i++) {
            self().visit_expr(*x.m_vars[i]);
        }
    }
    void visit_Flush(const Flush_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.m_label);
        self().visit_expr(*x.m_unit);
        if (x.m_err) {
            self().write_bool(true);
            self().visit_expr(*x.m_err);
        } else {
            self().write_bool(false);
        }
        if (x.m_iomsg) {
            self().write_bool(true);
            self().visit_expr(*x.m_iomsg);
        } else {
            self().write_bool(false);
        }
        if (x.m_iostat) {
            self().write_bool(true);
            self().visit_expr(*x.m_iostat);
        } else {
            self().write_bool(false);
        }
    }
    void visit_ListAppend(const ListAppend_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_a);
        self().visit_expr(*x.m_ele);
    }
    void visit_AssociateBlockCall(const AssociateBlockCall_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_symbol(*x.m_m);
    }
    void visit_SelectType(const SelectType_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_selector);
        self().write_int64(x.n_body);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_type_stmt(*x.m_body[i]);
        }
        self().write_int64(x.n_default);
        for (size_t i=0; i<x.n_default; i++) {
            self().visit_stmt(*x.m_default[i]);
        }
    }
    void visit_CPtrToPointer(const CPtrToPointer_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_cptr);
        self().visit_expr(*x.m_ptr);
        if (x.m_shape) {
            self().write_bool(true);
            self().visit_expr(*x.m_shape);
        } else {
            self().write_bool(false);
        }
        if (x.m_lower_bounds) {
            self().write_bool(true);
            self().visit_expr(*x.m_lower_bounds);
        } else {
            self().write_bool(false);
        }
    }
    void visit_BlockCall(const BlockCall_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.m_label);
        self().write_symbol(*x.m_m);
    }
    void visit_SetInsert(const SetInsert_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_a);
        self().visit_expr(*x.m_ele);
    }
    void visit_SetRemove(const SetRemove_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_a);
        self().visit_expr(*x.m_ele);
    }
    void visit_ListInsert(const ListInsert_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_a);
        self().visit_expr(*x.m_pos);
        self().visit_expr(*x.m_ele);
    }
    void visit_ListRemove(const ListRemove_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_a);
        self().visit_expr(*x.m_ele);
    }
    void visit_ListClear(const ListClear_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_a);
    }
    void visit_DictInsert(const DictInsert_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_a);
        self().visit_expr(*x.m_key);
        self().visit_expr(*x.m_value);
    }
    void visit_DictClear(const DictClear_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_a);
    }
    void visit_SetClear(const SetClear_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_a);
    }
    void visit_Expr(const Expr_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_expression);
    }
    void visit_IfExp(const IfExp_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_test);
        self().visit_expr(*x.m_body);
        self().visit_expr(*x.m_orelse);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_ComplexConstructor(const ComplexConstructor_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_re);
        self().visit_expr(*x.m_im);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_NamedExpr(const NamedExpr_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_target);
        self().visit_expr(*x.m_value);
        self().visit_ttype(*x.m_type);
    }
    void visit_FunctionCall(const FunctionCall_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_symbol(*x.m_name);
        if (x.m_original_name) {
            self().write_bool(true);
            self().write_symbol(*x.m_original_name);
        } else {
            self().write_bool(false);
        }
        self().write_int64(x.n_args);
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_call_arg(x.m_args[i]);
        }
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
        if (x.m_dt) {
            self().write_bool(true);
            self().visit_expr(*x.m_dt);
        } else {
            self().write_bool(false);
        }
    }
    void visit_IntrinsicElementalFunction(const IntrinsicElementalFunction_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.m_intrinsic_id);
        self().write_int64(x.n_args);
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
        }
        self().write_int64(x.m_overload_id);
        if (x.m_type) {
            self().write_bool(true);
            self().visit_ttype(*x.m_type);
        } else {
            self().write_bool(false);
        }
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_IntrinsicArrayFunction(const IntrinsicArrayFunction_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.m_arr_intrinsic_id);
        self().write_int64(x.n_args);
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
        }
        self().write_int64(x.m_overload_id);
        if (x.m_type) {
            self().write_bool(true);
            self().visit_ttype(*x.m_type);
        } else {
            self().write_bool(false);
        }
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_IntrinsicImpureFunction(const IntrinsicImpureFunction_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.m_impure_intrinsic_id);
        self().write_int64(x.n_args);
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
        }
        self().write_int64(x.m_overload_id);
        if (x.m_type) {
            self().write_bool(true);
            self().visit_ttype(*x.m_type);
        } else {
            self().write_bool(false);
        }
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_TypeInquiry(const TypeInquiry_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.m_inquiry_id);
        self().visit_ttype(*x.m_arg_type);
        if (x.m_arg) {
            self().write_bool(true);
            self().visit_expr(*x.m_arg);
        } else {
            self().write_bool(false);
        }
        self().visit_ttype(*x.m_type);
        self().visit_expr(*x.m_value);
    }
    void visit_StructConstructor(const StructConstructor_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_symbol(*x.m_dt_sym);
        self().write_int64(x.n_args);
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_call_arg(x.m_args[i]);
        }
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_StructConstant(const StructConstant_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_symbol(*x.m_dt_sym);
        self().write_int64(x.n_args);
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_call_arg(x.m_args[i]);
        }
        self().visit_ttype(*x.m_type);
    }
    void visit_EnumConstructor(const EnumConstructor_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_symbol(*x.m_dt_sym);
        self().write_int64(x.n_args);
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
        }
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_UnionConstructor(const UnionConstructor_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_symbol(*x.m_dt_sym);
        self().write_int64(x.n_args);
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
        }
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_ImpliedDoLoop(const ImpliedDoLoop_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.n_values);
        for (size_t i=0; i<x.n_values; i++) {
            self().visit_expr(*x.m_values[i]);
        }
        self().visit_expr(*x.m_var);
        self().visit_expr(*x.m_start);
        self().visit_expr(*x.m_end);
        if (x.m_increment) {
            self().write_bool(true);
            self().visit_expr(*x.m_increment);
        } else {
            self().write_bool(false);
        }
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_IntegerConstant(const IntegerConstant_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.m_n);
        self().visit_ttype(*x.m_type);
        visit_integerbozType(x.m_intboz_type);
    }
    void visit_IntegerBitNot(const IntegerBitNot_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_IntegerUnaryMinus(const IntegerUnaryMinus_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_IntegerCompare(const IntegerCompare_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_left);
        visit_cmpopType(x.m_op);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_IntegerBinOp(const IntegerBinOp_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_left);
        visit_binopType(x.m_op);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_UnsignedIntegerConstant(const UnsignedIntegerConstant_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.m_n);
        self().visit_ttype(*x.m_type);
    }
    void visit_UnsignedIntegerUnaryMinus(const UnsignedIntegerUnaryMinus_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_UnsignedIntegerBitNot(const UnsignedIntegerBitNot_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_UnsignedIntegerCompare(const UnsignedIntegerCompare_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_left);
        visit_cmpopType(x.m_op);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_UnsignedIntegerBinOp(const UnsignedIntegerBinOp_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_left);
        visit_binopType(x.m_op);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_RealConstant(const RealConstant_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_float64(x.m_r);
        self().visit_ttype(*x.m_type);
    }
    void visit_RealUnaryMinus(const RealUnaryMinus_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_RealCompare(const RealCompare_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_left);
        visit_cmpopType(x.m_op);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_RealBinOp(const RealBinOp_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_left);
        visit_binopType(x.m_op);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_RealCopySign(const RealCopySign_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_target);
        self().visit_expr(*x.m_source);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_ComplexConstant(const ComplexConstant_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_float64(x.m_re);
        self().write_float64(x.m_im);
        self().visit_ttype(*x.m_type);
    }
    void visit_ComplexUnaryMinus(const ComplexUnaryMinus_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_ComplexCompare(const ComplexCompare_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_left);
        visit_cmpopType(x.m_op);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_ComplexBinOp(const ComplexBinOp_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_left);
        visit_binopType(x.m_op);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_LogicalConstant(const LogicalConstant_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        if (x.m_value) {
            self().write_bool(true);
        } else {
            self().write_bool(false);
        }
        self().visit_ttype(*x.m_type);
    }
    void visit_LogicalNot(const LogicalNot_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_LogicalCompare(const LogicalCompare_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_left);
        visit_cmpopType(x.m_op);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_LogicalBinOp(const LogicalBinOp_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_left);
        visit_logicalbinopType(x.m_op);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_ListConstant(const ListConstant_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.n_args);
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
        }
        self().visit_ttype(*x.m_type);
    }
    void visit_ListLen(const ListLen_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_ListConcat(const ListConcat_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_ListCompare(const ListCompare_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_left);
        visit_cmpopType(x.m_op);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_ListCount(const ListCount_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_arg);
        self().visit_expr(*x.m_ele);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_ListContains(const ListContains_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_SetConstant(const SetConstant_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.n_elements);
        for (size_t i=0; i<x.n_elements; i++) {
            self().visit_expr(*x.m_elements[i]);
        }
        self().visit_ttype(*x.m_type);
    }
    void visit_SetLen(const SetLen_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_TupleConstant(const TupleConstant_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.n_elements);
        for (size_t i=0; i<x.n_elements; i++) {
            self().visit_expr(*x.m_elements[i]);
        }
        self().visit_ttype(*x.m_type);
    }
    void visit_TupleLen(const TupleLen_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        self().visit_expr(*x.m_value);
    }
    void visit_TupleCompare(const TupleCompare_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_left);
        visit_cmpopType(x.m_op);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_TupleConcat(const TupleConcat_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_TupleContains(const TupleContains_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_StringConstant(const StringConstant_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_string(x.m_s);
        self().visit_ttype(*x.m_type);
    }
    void visit_StringConcat(const StringConcat_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_StringRepeat(const StringRepeat_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_StringLen(const StringLen_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_StringItem(const StringItem_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_arg);
        self().visit_expr(*x.m_idx);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_StringSection(const StringSection_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_arg);
        if (x.m_start) {
            self().write_bool(true);
            self().visit_expr(*x.m_start);
        } else {
            self().write_bool(false);
        }
        if (x.m_end) {
            self().write_bool(true);
            self().visit_expr(*x.m_end);
        } else {
            self().write_bool(false);
        }
        if (x.m_step) {
            self().write_bool(true);
            self().visit_expr(*x.m_step);
        } else {
            self().write_bool(false);
        }
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_StringCompare(const StringCompare_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_left);
        visit_cmpopType(x.m_op);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_StringContains(const StringContains_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_substr);
        self().visit_expr(*x.m_str);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_StringOrd(const StringOrd_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_StringChr(const StringChr_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_StringFormat(const StringFormat_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        if (x.m_fmt) {
            self().write_bool(true);
            self().visit_expr(*x.m_fmt);
        } else {
            self().write_bool(false);
        }
        self().write_int64(x.n_args);
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
        }
        visit_string_format_kindType(x.m_kind);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_StringPhysicalCast(const StringPhysicalCast_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_arg);
        visit_string_physical_typeType(x.m_old);
        visit_string_physical_typeType(x.m_new);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_CPtrCompare(const CPtrCompare_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_left);
        visit_cmpopType(x.m_op);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_SymbolicCompare(const SymbolicCompare_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_left);
        visit_cmpopType(x.m_op);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_DictConstant(const DictConstant_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.n_keys);
        for (size_t i=0; i<x.n_keys; i++) {
            self().visit_expr(*x.m_keys[i]);
        }
        self().write_int64(x.n_values);
        for (size_t i=0; i<x.n_values; i++) {
            self().visit_expr(*x.m_values[i]);
        }
        self().visit_ttype(*x.m_type);
    }
    void visit_DictLen(const DictLen_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_Var(const Var_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_symbol(*x.m_v);
    }
    void visit_FunctionParam(const FunctionParam_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.m_param_number);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_ArrayConstructor(const ArrayConstructor_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.n_args);
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
        }
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
        visit_arraystorageType(x.m_storage_format);
    }
    void visit_ArrayConstant(const ArrayConstant_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.m_n_data);
        self().write_void(x.m_data, x.m_n_data);
        self().visit_ttype(*x.m_type);
        visit_arraystorageType(x.m_storage_format);
    }
    void visit_ArrayItem(const ArrayItem_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_v);
        self().write_int64(x.n_args);
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_array_index(x.m_args[i]);
        }
        self().visit_ttype(*x.m_type);
        visit_arraystorageType(x.m_storage_format);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_ArraySection(const ArraySection_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_v);
        self().write_int64(x.n_args);
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_array_index(x.m_args[i]);
        }
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_ArraySize(const ArraySize_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_v);
        if (x.m_dim) {
            self().write_bool(true);
            self().visit_expr(*x.m_dim);
        } else {
            self().write_bool(false);
        }
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_ArrayBound(const ArrayBound_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_v);
        if (x.m_dim) {
            self().write_bool(true);
            self().visit_expr(*x.m_dim);
        } else {
            self().write_bool(false);
        }
        self().visit_ttype(*x.m_type);
        visit_arrayboundType(x.m_bound);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_ArrayTranspose(const ArrayTranspose_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_matrix);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_ArrayPack(const ArrayPack_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_array);
        self().visit_expr(*x.m_mask);
        if (x.m_vector) {
            self().write_bool(true);
            self().visit_expr(*x.m_vector);
        } else {
            self().write_bool(false);
        }
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_ArrayReshape(const ArrayReshape_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_array);
        self().visit_expr(*x.m_shape);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_ArrayBroadcast(const ArrayBroadcast_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_array);
        self().visit_expr(*x.m_shape);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_BitCast(const BitCast_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_source);
        self().visit_expr(*x.m_mold);
        if (x.m_size) {
            self().write_bool(true);
            self().visit_expr(*x.m_size);
        } else {
            self().write_bool(false);
        }
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_StructInstanceMember(const StructInstanceMember_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_v);
        self().write_symbol(*x.m_m);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_StructStaticMember(const StructStaticMember_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_v);
        self().write_symbol(*x.m_m);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_EnumStaticMember(const EnumStaticMember_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_v);
        self().write_symbol(*x.m_m);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_UnionInstanceMember(const UnionInstanceMember_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_v);
        self().write_symbol(*x.m_m);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_EnumName(const EnumName_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_v);
        self().visit_ttype(*x.m_enum_type);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_EnumValue(const EnumValue_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_v);
        self().visit_ttype(*x.m_enum_type);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_OverloadedCompare(const OverloadedCompare_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_left);
        visit_cmpopType(x.m_op);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
        self().visit_expr(*x.m_overloaded);
    }
    void visit_OverloadedBinOp(const OverloadedBinOp_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_left);
        visit_binopType(x.m_op);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
        self().visit_expr(*x.m_overloaded);
    }
    void visit_OverloadedUnaryMinus(const OverloadedUnaryMinus_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
        self().visit_expr(*x.m_overloaded);
    }
    void visit_OverloadedStringConcat(const OverloadedStringConcat_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
        self().visit_expr(*x.m_overloaded);
    }
    void visit_Cast(const Cast_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_arg);
        visit_cast_kindType(x.m_kind);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_ArrayPhysicalCast(const ArrayPhysicalCast_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_arg);
        visit_array_physical_typeType(x.m_old);
        visit_array_physical_typeType(x.m_new);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_ComplexRe(const ComplexRe_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_ComplexIm(const ComplexIm_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_DictItem(const DictItem_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_a);
        self().visit_expr(*x.m_key);
        if (x.m_default) {
            self().write_bool(true);
            self().visit_expr(*x.m_default);
        } else {
            self().write_bool(false);
        }
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_CLoc(const CLoc_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_PointerToCPtr(const PointerToCPtr_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_GetPointer(const GetPointer_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_ListItem(const ListItem_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_a);
        self().visit_expr(*x.m_pos);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_TupleItem(const TupleItem_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_a);
        self().visit_expr(*x.m_pos);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_ListSection(const ListSection_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_a);
        self().visit_array_index(x.m_section);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_ListRepeat(const ListRepeat_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_DictPop(const DictPop_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_a);
        self().visit_expr(*x.m_key);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_SetPop(const SetPop_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_a);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_SetContains(const SetContains_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_DictContains(const DictContains_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_IntegerBitLen(const IntegerBitLen_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_a);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_Ichar(const Ichar_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_Iachar(const Iachar_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_SizeOfType(const SizeOfType_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_ttype(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_PointerNullConstant(const PointerNullConstant_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_ttype(*x.m_type);
    }
    void visit_PointerAssociated(const PointerAssociated_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_ptr);
        if (x.m_tgt) {
            self().write_bool(true);
            self().visit_expr(*x.m_tgt);
        } else {
            self().write_bool(false);
        }
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_RealSqrt(const RealSqrt_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_ArrayIsContiguous(const ArrayIsContiguous_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_expr(*x.m_array);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_Integer(const Integer_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.m_kind);
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_UnsignedInteger(const UnsignedInteger_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.m_kind);
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Real(const Real_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.m_kind);
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Complex(const Complex_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.m_kind);
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_String(const String_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.m_kind);
        self().write_int64(x.m_len);
        if (x.m_len_expr) {
            self().write_bool(true);
            self().visit_expr(*x.m_len_expr);
        } else {
            self().write_bool(false);
        }
        visit_string_physical_typeType(x.m_physical_type);
    }
    void visit_Logical(const Logical_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.m_kind);
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Set(const Set_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_ttype(*x.m_type);
    }
    void visit_List(const List_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_ttype(*x.m_type);
    }
    void visit_Tuple(const Tuple_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.n_type);
        for (size_t i=0; i<x.n_type; i++) {
            self().visit_ttype(*x.m_type[i]);
        }
    }
    void visit_StructType(const StructType_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.n_data_member_types);
        for (size_t i=0; i<x.n_data_member_types; i++) {
            self().visit_ttype(*x.m_data_member_types[i]);
        }
        self().write_int64(x.n_member_function_types);
        for (size_t i=0; i<x.n_member_function_types; i++) {
            self().visit_ttype(*x.m_member_function_types[i]);
        }
        if (x.m_is_cstruct) {
            self().write_bool(true);
        } else {
            self().write_bool(false);
        }
        self().write_symbol(*x.m_derived_type);
    }
    void visit_EnumType(const EnumType_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_symbol(*x.m_enum_type);
    }
    void visit_UnionType(const UnionType_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_symbol(*x.m_union_type);
    }
    void visit_ClassType(const ClassType_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_symbol(*x.m_class_type);
    }
    void visit_Dict(const Dict_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_ttype(*x.m_key_type);
        self().visit_ttype(*x.m_value_type);
    }
    void visit_Pointer(const Pointer_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_ttype(*x.m_type);
    }
    void visit_Allocatable(const Allocatable_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_ttype(*x.m_type);
    }
    void visit_CPtr(const CPtr_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_SymbolicExpression(const SymbolicExpression_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_TypeParameter(const TypeParameter_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_string(x.m_param);
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Array(const Array_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_ttype(*x.m_type);
        self().write_int64(x.n_dims);
        for (size_t i=0; i<x.n_dims; i++) {
            self().visit_dimension(x.m_dims[i]);
        }
        visit_array_physical_typeType(x.m_physical_type);
    }
    void visit_FunctionType(const FunctionType_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.n_arg_types);
        for (size_t i=0; i<x.n_arg_types; i++) {
            self().visit_ttype(*x.m_arg_types[i]);
        }
        if (x.m_return_var_type) {
            self().write_bool(true);
            self().visit_ttype(*x.m_return_var_type);
        } else {
            self().write_bool(false);
        }
        visit_abiType(x.m_abi);
        visit_deftypeType(x.m_deftype);
        if (x.m_bindc_name) {
            self().write_bool(true);
            self().write_string(x.m_bindc_name);
        } else {
            self().write_bool(false);
        }
        if (x.m_elemental) {
            self().write_bool(true);
        } else {
            self().write_bool(false);
        }
        if (x.m_pure) {
            self().write_bool(true);
        } else {
            self().write_bool(false);
        }
        if (x.m_module) {
            self().write_bool(true);
        } else {
            self().write_bool(false);
        }
        if (x.m_inline) {
            self().write_bool(true);
        } else {
            self().write_bool(false);
        }
        if (x.m_static) {
            self().write_bool(true);
        } else {
            self().write_bool(false);
        }
        self().write_int64(x.n_restrictions);
        for (size_t i=0; i<x.n_restrictions; i++) {
            self().write_symbol(*x.m_restrictions[i]);
        }
        if (x.m_is_restriction) {
            self().write_bool(true);
        } else {
            self().write_bool(false);
        }
    }
    void visit_cast_kindType(const cast_kindType &x) {
        self().write_int8(x);
    }
    void visit_storage_typeType(const storage_typeType &x) {
        self().write_int8(x);
    }
    void visit_accessType(const accessType &x) {
        self().write_int8(x);
    }
    void visit_intentType(const intentType &x) {
        self().write_int8(x);
    }
    void visit_deftypeType(const deftypeType &x) {
        self().write_int8(x);
    }
    void visit_presenceType(const presenceType &x) {
        self().write_int8(x);
    }
    void visit_abiType(const abiType &x) {
        self().write_int8(x);
    }
    void visit_dimension(const dimension_t &x) {
        if (x.m_start) {
            self().write_bool(true);
            self().visit_expr(*x.m_start);
        } else {
            self().write_bool(false);
        }
        if (x.m_length) {
            self().write_bool(true);
            self().visit_expr(*x.m_length);
        } else {
            self().write_bool(false);
        }
    }
    void visit_alloc_arg(const alloc_arg_t &x) {
        self().visit_expr(*x.m_a);
        self().write_int64(x.n_dims);
        for (size_t i=0; i<x.n_dims; i++) {
            self().visit_dimension(x.m_dims[i]);
        }
        if (x.m_len_expr) {
            self().write_bool(true);
            self().visit_expr(*x.m_len_expr);
        } else {
            self().write_bool(false);
        }
        if (x.m_type) {
            self().write_bool(true);
            self().visit_ttype(*x.m_type);
        } else {
            self().write_bool(false);
        }
    }
    void visit_Attribute(const Attribute_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_string(x.m_name);
        self().write_int64(x.n_args);
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_attribute_arg(x.m_args[i]);
        }
    }
    void visit_attribute_arg(const attribute_arg_t &x) {
        self().write_string(x.m_arg);
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_call_arg(const call_arg_t &x) {
        if (x.m_value) {
            self().write_bool(true);
            self().visit_expr(*x.m_value);
        } else {
            self().write_bool(false);
        }
    }
    void visit_reduction_expr(const reduction_expr_t &x) {
        visit_reduction_opType(x.m_op);
        self().visit_expr(*x.m_arg);
    }
    void visit_Bind(const Bind_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_string(x.m_lang);
        self().write_string(x.m_name);
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_array_index(const array_index_t &x) {
        if (x.m_left) {
            self().write_bool(true);
            self().visit_expr(*x.m_left);
        } else {
            self().write_bool(false);
        }
        if (x.m_right) {
            self().write_bool(true);
            self().visit_expr(*x.m_right);
        } else {
            self().write_bool(false);
        }
        if (x.m_step) {
            self().write_bool(true);
            self().visit_expr(*x.m_step);
        } else {
            self().write_bool(false);
        }
    }
    void visit_do_loop_head(const do_loop_head_t &x) {
        if (x.m_v) {
            self().write_bool(true);
            self().visit_expr(*x.m_v);
        } else {
            self().write_bool(false);
        }
        if (x.m_start) {
            self().write_bool(true);
            self().visit_expr(*x.m_start);
        } else {
            self().write_bool(false);
        }
        if (x.m_end) {
            self().write_bool(true);
            self().visit_expr(*x.m_end);
        } else {
            self().write_bool(false);
        }
        if (x.m_increment) {
            self().write_bool(true);
            self().visit_expr(*x.m_increment);
        } else {
            self().write_bool(false);
        }
    }
    void visit_CaseStmt(const CaseStmt_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_int64(x.n_test);
        for (size_t i=0; i<x.n_test; i++) {
            self().visit_expr(*x.m_test[i]);
        }
        self().write_int64(x.n_body);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
        if (x.m_fall_through) {
            self().write_bool(true);
        } else {
            self().write_bool(false);
        }
    }
    void visit_CaseStmt_Range(const CaseStmt_Range_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        if (x.m_start) {
            self().write_bool(true);
            self().visit_expr(*x.m_start);
        } else {
            self().write_bool(false);
        }
        if (x.m_end) {
            self().write_bool(true);
            self().visit_expr(*x.m_end);
        } else {
            self().write_bool(false);
        }
        self().write_int64(x.n_body);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
    }
    void visit_TypeStmtName(const TypeStmtName_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_symbol(*x.m_sym);
        self().write_int64(x.n_body);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
    }
    void visit_ClassStmt(const ClassStmt_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_symbol(*x.m_sym);
        self().write_int64(x.n_body);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
    }
    void visit_TypeStmtType(const TypeStmtType_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().visit_ttype(*x.m_type);
        self().write_int64(x.n_body);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
    }
    void visit_enumtypeType(const enumtypeType &x) {
        self().write_int8(x);
    }
    void visit_Require(const Require_t &x) {
        self().write_int8(x.base.type);
        self().write_int64(x.base.base.loc.first);
        self().write_int64(x.base.base.loc.last);
        self().write_string(x.m_name);
        self().write_int64(x.n_args);
        for (size_t i=0; i<x.n_args; i++) {
            self().write_string(x.m_args[i]);
        }
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_array_physical_typeType(const array_physical_typeType &x) {
        self().write_int8(x);
    }
    void visit_string_physical_typeType(const string_physical_typeType &x) {
        self().write_int8(x);
    }
    void visit_binopType(const binopType &x) {
        self().write_int8(x);
    }
    void visit_reduction_opType(const reduction_opType &x) {
        self().write_int8(x);
    }
    void visit_logicalbinopType(const logicalbinopType &x) {
        self().write_int8(x);
    }
    void visit_cmpopType(const cmpopType &x) {
        self().write_int8(x);
    }
    void visit_integerbozType(const integerbozType &x) {
        self().write_int8(x);
    }
    void visit_arrayboundType(const arrayboundType &x) {
        self().write_int8(x);
    }
    void visit_arraystorageType(const arraystorageType &x) {
        self().write_int8(x);
    }
    void visit_string_format_kindType(const string_format_kindType &x) {
        self().write_int8(x);
    }
};


}
