/*
 * Copyright (C) 2023 Alexander Borisov
 *
 * Author: Alexander Borisov <borisov@lexbor.com>
 */

#ifndef LEXBOR_UNICODE_TABLES_13_H
#define LEXBOR_UNICODE_TABLES_13_H

#ifdef __cplusplus
extern "C" {
#endif


static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDF0 = {.cps = (lxb_codepoint_t[]) {0x0635, 0x0644, 0x06D2}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDF1 = {.cps = (lxb_codepoint_t[]) {0x0642, 0x0644, 0x06D2}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDF2 = {.cps = (lxb_codepoint_t[]) {0x0627, 0x0644, 0x0644, 0x0647}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDF3 = {.cps = (lxb_codepoint_t[]) {0x0627, 0x0643, 0x0628, 0x0631}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDF4 = {.cps = (lxb_codepoint_t[]) {0x0645, 0x062D, 0x0645, 0x062F}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDF5 = {.cps = (lxb_codepoint_t[]) {0x0635, 0x0644, 0x0639, 0x0645}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDF6 = {.cps = (lxb_codepoint_t[]) {0x0631, 0x0633, 0x0648, 0x0644}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDF7 = {.cps = (lxb_codepoint_t[]) {0x0639, 0x0644, 0x064A, 0x0647}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDF8 = {.cps = (lxb_codepoint_t[]) {0x0648, 0x0633, 0x0644, 0x0645}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDF9 = {.cps = (lxb_codepoint_t[]) {0x0635, 0x0644, 0x0649}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDFA = {.cps = (lxb_codepoint_t[]) {0x0635, 0x0644, 0x0649, 0x0020, 0x0627, 0x0644, 0x0644, 0x0647, 0x0020, 0x0639, 0x0644, 0x064A, 0x0647, 0x0020, 0x0648, 0x0633, 0x0644, 0x0645}, .length = 18};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDFB = {.cps = (lxb_codepoint_t[]) {0x062C, 0x0644, 0x0020, 0x062C, 0x0644, 0x0627, 0x0644, 0x0647}, .length = 8};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDFC = {.cps = (lxb_codepoint_t[]) {0x0631, 0x06CC, 0x0627, 0x0644}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE10 = {.cps = (lxb_codepoint_t[]) {0x002C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE11 = {.cps = (lxb_codepoint_t[]) {0x3001}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE13 = {.cps = (lxb_codepoint_t[]) {0x003A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE14 = {.cps = (lxb_codepoint_t[]) {0x003B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE15 = {.cps = (lxb_codepoint_t[]) {0x0021}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE16 = {.cps = (lxb_codepoint_t[]) {0x003F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE17 = {.cps = (lxb_codepoint_t[]) {0x3016}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE18 = {.cps = (lxb_codepoint_t[]) {0x3017}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE31 = {.cps = (lxb_codepoint_t[]) {0x2014}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE32 = {.cps = (lxb_codepoint_t[]) {0x2013}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE33 = {.cps = (lxb_codepoint_t[]) {0x005F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE34 = {.cps = (lxb_codepoint_t[]) {0x005F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE35 = {.cps = (lxb_codepoint_t[]) {0x0028}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE36 = {.cps = (lxb_codepoint_t[]) {0x0029}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE37 = {.cps = (lxb_codepoint_t[]) {0x007B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE38 = {.cps = (lxb_codepoint_t[]) {0x007D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE39 = {.cps = (lxb_codepoint_t[]) {0x3014}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE3A = {.cps = (lxb_codepoint_t[]) {0x3015}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE3B = {.cps = (lxb_codepoint_t[]) {0x3010}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE3C = {.cps = (lxb_codepoint_t[]) {0x3011}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE3D = {.cps = (lxb_codepoint_t[]) {0x300A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE3E = {.cps = (lxb_codepoint_t[]) {0x300B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE3F = {.cps = (lxb_codepoint_t[]) {0x3008}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE40 = {.cps = (lxb_codepoint_t[]) {0x3009}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE41 = {.cps = (lxb_codepoint_t[]) {0x300C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE42 = {.cps = (lxb_codepoint_t[]) {0x300D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE43 = {.cps = (lxb_codepoint_t[]) {0x300E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE44 = {.cps = (lxb_codepoint_t[]) {0x300F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE47 = {.cps = (lxb_codepoint_t[]) {0x005B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE48 = {.cps = (lxb_codepoint_t[]) {0x005D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE49 = {.cps = (lxb_codepoint_t[]) {0x0020, 0x0305}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE4A = {.cps = (lxb_codepoint_t[]) {0x0020, 0x0305}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE4B = {.cps = (lxb_codepoint_t[]) {0x0020, 0x0305}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE4C = {.cps = (lxb_codepoint_t[]) {0x0020, 0x0305}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE4D = {.cps = (lxb_codepoint_t[]) {0x005F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE4E = {.cps = (lxb_codepoint_t[]) {0x005F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE4F = {.cps = (lxb_codepoint_t[]) {0x005F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE50 = {.cps = (lxb_codepoint_t[]) {0x002C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE51 = {.cps = (lxb_codepoint_t[]) {0x3001}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE54 = {.cps = (lxb_codepoint_t[]) {0x003B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE55 = {.cps = (lxb_codepoint_t[]) {0x003A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE56 = {.cps = (lxb_codepoint_t[]) {0x003F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE57 = {.cps = (lxb_codepoint_t[]) {0x0021}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE58 = {.cps = (lxb_codepoint_t[]) {0x2014}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE59 = {.cps = (lxb_codepoint_t[]) {0x0028}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE5A = {.cps = (lxb_codepoint_t[]) {0x0029}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE5B = {.cps = (lxb_codepoint_t[]) {0x007B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE5C = {.cps = (lxb_codepoint_t[]) {0x007D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE5D = {.cps = (lxb_codepoint_t[]) {0x3014}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE5E = {.cps = (lxb_codepoint_t[]) {0x3015}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE5F = {.cps = (lxb_codepoint_t[]) {0x0023}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE60 = {.cps = (lxb_codepoint_t[]) {0x0026}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE61 = {.cps = (lxb_codepoint_t[]) {0x002A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE62 = {.cps = (lxb_codepoint_t[]) {0x002B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE63 = {.cps = (lxb_codepoint_t[]) {0x002D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE64 = {.cps = (lxb_codepoint_t[]) {0x003C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE65 = {.cps = (lxb_codepoint_t[]) {0x003E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE66 = {.cps = (lxb_codepoint_t[]) {0x003D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE68 = {.cps = (lxb_codepoint_t[]) {0x005C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE69 = {.cps = (lxb_codepoint_t[]) {0x0024}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE6A = {.cps = (lxb_codepoint_t[]) {0x0025}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE6B = {.cps = (lxb_codepoint_t[]) {0x0040}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE70 = {.cps = (lxb_codepoint_t[]) {0x0020, 0x064B}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE71 = {.cps = (lxb_codepoint_t[]) {0x0640, 0x064B}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE72 = {.cps = (lxb_codepoint_t[]) {0x0020, 0x064C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE74 = {.cps = (lxb_codepoint_t[]) {0x0020, 0x064D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE76 = {.cps = (lxb_codepoint_t[]) {0x0020, 0x064E}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE77 = {.cps = (lxb_codepoint_t[]) {0x0640, 0x064E}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE78 = {.cps = (lxb_codepoint_t[]) {0x0020, 0x064F}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE79 = {.cps = (lxb_codepoint_t[]) {0x0640, 0x064F}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE7A = {.cps = (lxb_codepoint_t[]) {0x0020, 0x0650}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE7B = {.cps = (lxb_codepoint_t[]) {0x0640, 0x0650}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE7C = {.cps = (lxb_codepoint_t[]) {0x0020, 0x0651}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE7D = {.cps = (lxb_codepoint_t[]) {0x0640, 0x0651}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE7E = {.cps = (lxb_codepoint_t[]) {0x0020, 0x0652}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE7F = {.cps = (lxb_codepoint_t[]) {0x0640, 0x0652}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE80 = {.cps = (lxb_codepoint_t[]) {0x0621}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE81 = {.cps = (lxb_codepoint_t[]) {0x0622}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE82 = {.cps = (lxb_codepoint_t[]) {0x0622}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE83 = {.cps = (lxb_codepoint_t[]) {0x0623}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE84 = {.cps = (lxb_codepoint_t[]) {0x0623}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE85 = {.cps = (lxb_codepoint_t[]) {0x0624}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE86 = {.cps = (lxb_codepoint_t[]) {0x0624}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE87 = {.cps = (lxb_codepoint_t[]) {0x0625}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE88 = {.cps = (lxb_codepoint_t[]) {0x0625}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE89 = {.cps = (lxb_codepoint_t[]) {0x0626}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE8A = {.cps = (lxb_codepoint_t[]) {0x0626}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE8B = {.cps = (lxb_codepoint_t[]) {0x0626}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE8C = {.cps = (lxb_codepoint_t[]) {0x0626}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE8D = {.cps = (lxb_codepoint_t[]) {0x0627}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE8E = {.cps = (lxb_codepoint_t[]) {0x0627}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE8F = {.cps = (lxb_codepoint_t[]) {0x0628}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE90 = {.cps = (lxb_codepoint_t[]) {0x0628}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE91 = {.cps = (lxb_codepoint_t[]) {0x0628}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE92 = {.cps = (lxb_codepoint_t[]) {0x0628}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE93 = {.cps = (lxb_codepoint_t[]) {0x0629}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE94 = {.cps = (lxb_codepoint_t[]) {0x0629}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE95 = {.cps = (lxb_codepoint_t[]) {0x062A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE96 = {.cps = (lxb_codepoint_t[]) {0x062A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE97 = {.cps = (lxb_codepoint_t[]) {0x062A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE98 = {.cps = (lxb_codepoint_t[]) {0x062A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE99 = {.cps = (lxb_codepoint_t[]) {0x062B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE9A = {.cps = (lxb_codepoint_t[]) {0x062B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE9B = {.cps = (lxb_codepoint_t[]) {0x062B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE9C = {.cps = (lxb_codepoint_t[]) {0x062B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE9D = {.cps = (lxb_codepoint_t[]) {0x062C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE9E = {.cps = (lxb_codepoint_t[]) {0x062C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FE9F = {.cps = (lxb_codepoint_t[]) {0x062C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEA0 = {.cps = (lxb_codepoint_t[]) {0x062C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEA1 = {.cps = (lxb_codepoint_t[]) {0x062D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEA2 = {.cps = (lxb_codepoint_t[]) {0x062D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEA3 = {.cps = (lxb_codepoint_t[]) {0x062D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEA4 = {.cps = (lxb_codepoint_t[]) {0x062D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEA5 = {.cps = (lxb_codepoint_t[]) {0x062E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEA6 = {.cps = (lxb_codepoint_t[]) {0x062E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEA7 = {.cps = (lxb_codepoint_t[]) {0x062E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEA8 = {.cps = (lxb_codepoint_t[]) {0x062E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEA9 = {.cps = (lxb_codepoint_t[]) {0x062F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEAA = {.cps = (lxb_codepoint_t[]) {0x062F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEAB = {.cps = (lxb_codepoint_t[]) {0x0630}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEAC = {.cps = (lxb_codepoint_t[]) {0x0630}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEAD = {.cps = (lxb_codepoint_t[]) {0x0631}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEAE = {.cps = (lxb_codepoint_t[]) {0x0631}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEAF = {.cps = (lxb_codepoint_t[]) {0x0632}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEB0 = {.cps = (lxb_codepoint_t[]) {0x0632}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEB1 = {.cps = (lxb_codepoint_t[]) {0x0633}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEB2 = {.cps = (lxb_codepoint_t[]) {0x0633}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEB3 = {.cps = (lxb_codepoint_t[]) {0x0633}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEB4 = {.cps = (lxb_codepoint_t[]) {0x0633}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEB5 = {.cps = (lxb_codepoint_t[]) {0x0634}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEB6 = {.cps = (lxb_codepoint_t[]) {0x0634}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEB7 = {.cps = (lxb_codepoint_t[]) {0x0634}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEB8 = {.cps = (lxb_codepoint_t[]) {0x0634}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEB9 = {.cps = (lxb_codepoint_t[]) {0x0635}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEBA = {.cps = (lxb_codepoint_t[]) {0x0635}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEBB = {.cps = (lxb_codepoint_t[]) {0x0635}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEBC = {.cps = (lxb_codepoint_t[]) {0x0635}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEBD = {.cps = (lxb_codepoint_t[]) {0x0636}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEBE = {.cps = (lxb_codepoint_t[]) {0x0636}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEBF = {.cps = (lxb_codepoint_t[]) {0x0636}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEC0 = {.cps = (lxb_codepoint_t[]) {0x0636}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEC1 = {.cps = (lxb_codepoint_t[]) {0x0637}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEC2 = {.cps = (lxb_codepoint_t[]) {0x0637}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEC3 = {.cps = (lxb_codepoint_t[]) {0x0637}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEC4 = {.cps = (lxb_codepoint_t[]) {0x0637}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEC5 = {.cps = (lxb_codepoint_t[]) {0x0638}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEC6 = {.cps = (lxb_codepoint_t[]) {0x0638}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEC7 = {.cps = (lxb_codepoint_t[]) {0x0638}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEC8 = {.cps = (lxb_codepoint_t[]) {0x0638}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEC9 = {.cps = (lxb_codepoint_t[]) {0x0639}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FECA = {.cps = (lxb_codepoint_t[]) {0x0639}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FECB = {.cps = (lxb_codepoint_t[]) {0x0639}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FECC = {.cps = (lxb_codepoint_t[]) {0x0639}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FECD = {.cps = (lxb_codepoint_t[]) {0x063A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FECE = {.cps = (lxb_codepoint_t[]) {0x063A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FECF = {.cps = (lxb_codepoint_t[]) {0x063A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FED0 = {.cps = (lxb_codepoint_t[]) {0x063A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FED1 = {.cps = (lxb_codepoint_t[]) {0x0641}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FED2 = {.cps = (lxb_codepoint_t[]) {0x0641}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FED3 = {.cps = (lxb_codepoint_t[]) {0x0641}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FED4 = {.cps = (lxb_codepoint_t[]) {0x0641}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FED5 = {.cps = (lxb_codepoint_t[]) {0x0642}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FED6 = {.cps = (lxb_codepoint_t[]) {0x0642}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FED7 = {.cps = (lxb_codepoint_t[]) {0x0642}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FED8 = {.cps = (lxb_codepoint_t[]) {0x0642}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FED9 = {.cps = (lxb_codepoint_t[]) {0x0643}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEDA = {.cps = (lxb_codepoint_t[]) {0x0643}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEDB = {.cps = (lxb_codepoint_t[]) {0x0643}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEDC = {.cps = (lxb_codepoint_t[]) {0x0643}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEDD = {.cps = (lxb_codepoint_t[]) {0x0644}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEDE = {.cps = (lxb_codepoint_t[]) {0x0644}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEDF = {.cps = (lxb_codepoint_t[]) {0x0644}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEE0 = {.cps = (lxb_codepoint_t[]) {0x0644}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEE1 = {.cps = (lxb_codepoint_t[]) {0x0645}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEE2 = {.cps = (lxb_codepoint_t[]) {0x0645}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEE3 = {.cps = (lxb_codepoint_t[]) {0x0645}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEE4 = {.cps = (lxb_codepoint_t[]) {0x0645}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEE5 = {.cps = (lxb_codepoint_t[]) {0x0646}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEE6 = {.cps = (lxb_codepoint_t[]) {0x0646}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEE7 = {.cps = (lxb_codepoint_t[]) {0x0646}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEE8 = {.cps = (lxb_codepoint_t[]) {0x0646}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEE9 = {.cps = (lxb_codepoint_t[]) {0x0647}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEEA = {.cps = (lxb_codepoint_t[]) {0x0647}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEEB = {.cps = (lxb_codepoint_t[]) {0x0647}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEEC = {.cps = (lxb_codepoint_t[]) {0x0647}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEED = {.cps = (lxb_codepoint_t[]) {0x0648}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEEE = {.cps = (lxb_codepoint_t[]) {0x0648}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEEF = {.cps = (lxb_codepoint_t[]) {0x0649}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEF0 = {.cps = (lxb_codepoint_t[]) {0x0649}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEF1 = {.cps = (lxb_codepoint_t[]) {0x064A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEF2 = {.cps = (lxb_codepoint_t[]) {0x064A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEF3 = {.cps = (lxb_codepoint_t[]) {0x064A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEF4 = {.cps = (lxb_codepoint_t[]) {0x064A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEF5 = {.cps = (lxb_codepoint_t[]) {0x0644, 0x0622}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEF6 = {.cps = (lxb_codepoint_t[]) {0x0644, 0x0622}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEF7 = {.cps = (lxb_codepoint_t[]) {0x0644, 0x0623}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEF8 = {.cps = (lxb_codepoint_t[]) {0x0644, 0x0623}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEF9 = {.cps = (lxb_codepoint_t[]) {0x0644, 0x0625}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEFA = {.cps = (lxb_codepoint_t[]) {0x0644, 0x0625}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEFB = {.cps = (lxb_codepoint_t[]) {0x0644, 0x0627}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FEFC = {.cps = (lxb_codepoint_t[]) {0x0644, 0x0627}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF01 = {.cps = (lxb_codepoint_t[]) {0x0021}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF02 = {.cps = (lxb_codepoint_t[]) {0x0022}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF03 = {.cps = (lxb_codepoint_t[]) {0x0023}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF04 = {.cps = (lxb_codepoint_t[]) {0x0024}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF05 = {.cps = (lxb_codepoint_t[]) {0x0025}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF06 = {.cps = (lxb_codepoint_t[]) {0x0026}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF07 = {.cps = (lxb_codepoint_t[]) {0x0027}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF08 = {.cps = (lxb_codepoint_t[]) {0x0028}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF09 = {.cps = (lxb_codepoint_t[]) {0x0029}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF0A = {.cps = (lxb_codepoint_t[]) {0x002A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF0B = {.cps = (lxb_codepoint_t[]) {0x002B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF0C = {.cps = (lxb_codepoint_t[]) {0x002C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF0D = {.cps = (lxb_codepoint_t[]) {0x002D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF0E = {.cps = (lxb_codepoint_t[]) {0x002E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF0F = {.cps = (lxb_codepoint_t[]) {0x002F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF10 = {.cps = (lxb_codepoint_t[]) {0x0030}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF11 = {.cps = (lxb_codepoint_t[]) {0x0031}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF12 = {.cps = (lxb_codepoint_t[]) {0x0032}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF13 = {.cps = (lxb_codepoint_t[]) {0x0033}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF14 = {.cps = (lxb_codepoint_t[]) {0x0034}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF15 = {.cps = (lxb_codepoint_t[]) {0x0035}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF16 = {.cps = (lxb_codepoint_t[]) {0x0036}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF17 = {.cps = (lxb_codepoint_t[]) {0x0037}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF18 = {.cps = (lxb_codepoint_t[]) {0x0038}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF19 = {.cps = (lxb_codepoint_t[]) {0x0039}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF1A = {.cps = (lxb_codepoint_t[]) {0x003A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF1B = {.cps = (lxb_codepoint_t[]) {0x003B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF1C = {.cps = (lxb_codepoint_t[]) {0x003C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF1D = {.cps = (lxb_codepoint_t[]) {0x003D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF1E = {.cps = (lxb_codepoint_t[]) {0x003E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF1F = {.cps = (lxb_codepoint_t[]) {0x003F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF20 = {.cps = (lxb_codepoint_t[]) {0x0040}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF21 = {.cps = (lxb_codepoint_t[]) {0x0061}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF22 = {.cps = (lxb_codepoint_t[]) {0x0062}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF23 = {.cps = (lxb_codepoint_t[]) {0x0063}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF24 = {.cps = (lxb_codepoint_t[]) {0x0064}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF25 = {.cps = (lxb_codepoint_t[]) {0x0065}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF26 = {.cps = (lxb_codepoint_t[]) {0x0066}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF27 = {.cps = (lxb_codepoint_t[]) {0x0067}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF28 = {.cps = (lxb_codepoint_t[]) {0x0068}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF29 = {.cps = (lxb_codepoint_t[]) {0x0069}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF2A = {.cps = (lxb_codepoint_t[]) {0x006A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF2B = {.cps = (lxb_codepoint_t[]) {0x006B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF2C = {.cps = (lxb_codepoint_t[]) {0x006C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF2D = {.cps = (lxb_codepoint_t[]) {0x006D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF2E = {.cps = (lxb_codepoint_t[]) {0x006E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF2F = {.cps = (lxb_codepoint_t[]) {0x006F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF30 = {.cps = (lxb_codepoint_t[]) {0x0070}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF31 = {.cps = (lxb_codepoint_t[]) {0x0071}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF32 = {.cps = (lxb_codepoint_t[]) {0x0072}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF33 = {.cps = (lxb_codepoint_t[]) {0x0073}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF34 = {.cps = (lxb_codepoint_t[]) {0x0074}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF35 = {.cps = (lxb_codepoint_t[]) {0x0075}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF36 = {.cps = (lxb_codepoint_t[]) {0x0076}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF37 = {.cps = (lxb_codepoint_t[]) {0x0077}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF38 = {.cps = (lxb_codepoint_t[]) {0x0078}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF39 = {.cps = (lxb_codepoint_t[]) {0x0079}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF3A = {.cps = (lxb_codepoint_t[]) {0x007A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF3B = {.cps = (lxb_codepoint_t[]) {0x005B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF3C = {.cps = (lxb_codepoint_t[]) {0x005C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF3D = {.cps = (lxb_codepoint_t[]) {0x005D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF3E = {.cps = (lxb_codepoint_t[]) {0x005E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF3F = {.cps = (lxb_codepoint_t[]) {0x005F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF40 = {.cps = (lxb_codepoint_t[]) {0x0060}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF41 = {.cps = (lxb_codepoint_t[]) {0x0061}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF42 = {.cps = (lxb_codepoint_t[]) {0x0062}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF43 = {.cps = (lxb_codepoint_t[]) {0x0063}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF44 = {.cps = (lxb_codepoint_t[]) {0x0064}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF45 = {.cps = (lxb_codepoint_t[]) {0x0065}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF46 = {.cps = (lxb_codepoint_t[]) {0x0066}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF47 = {.cps = (lxb_codepoint_t[]) {0x0067}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF48 = {.cps = (lxb_codepoint_t[]) {0x0068}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF49 = {.cps = (lxb_codepoint_t[]) {0x0069}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF4A = {.cps = (lxb_codepoint_t[]) {0x006A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF4B = {.cps = (lxb_codepoint_t[]) {0x006B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF4C = {.cps = (lxb_codepoint_t[]) {0x006C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF4D = {.cps = (lxb_codepoint_t[]) {0x006D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF4E = {.cps = (lxb_codepoint_t[]) {0x006E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF4F = {.cps = (lxb_codepoint_t[]) {0x006F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF50 = {.cps = (lxb_codepoint_t[]) {0x0070}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF51 = {.cps = (lxb_codepoint_t[]) {0x0071}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF52 = {.cps = (lxb_codepoint_t[]) {0x0072}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF53 = {.cps = (lxb_codepoint_t[]) {0x0073}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF54 = {.cps = (lxb_codepoint_t[]) {0x0074}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF55 = {.cps = (lxb_codepoint_t[]) {0x0075}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF56 = {.cps = (lxb_codepoint_t[]) {0x0076}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF57 = {.cps = (lxb_codepoint_t[]) {0x0077}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF58 = {.cps = (lxb_codepoint_t[]) {0x0078}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF59 = {.cps = (lxb_codepoint_t[]) {0x0079}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF5A = {.cps = (lxb_codepoint_t[]) {0x007A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF5B = {.cps = (lxb_codepoint_t[]) {0x007B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF5C = {.cps = (lxb_codepoint_t[]) {0x007C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF5D = {.cps = (lxb_codepoint_t[]) {0x007D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF5E = {.cps = (lxb_codepoint_t[]) {0x007E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF5F = {.cps = (lxb_codepoint_t[]) {0x2985}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF60 = {.cps = (lxb_codepoint_t[]) {0x2986}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF61 = {.cps = (lxb_codepoint_t[]) {0x002E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF62 = {.cps = (lxb_codepoint_t[]) {0x300C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF63 = {.cps = (lxb_codepoint_t[]) {0x300D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF64 = {.cps = (lxb_codepoint_t[]) {0x3001}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF65 = {.cps = (lxb_codepoint_t[]) {0x30FB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF66 = {.cps = (lxb_codepoint_t[]) {0x30F2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF67 = {.cps = (lxb_codepoint_t[]) {0x30A1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF68 = {.cps = (lxb_codepoint_t[]) {0x30A3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF69 = {.cps = (lxb_codepoint_t[]) {0x30A5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF6A = {.cps = (lxb_codepoint_t[]) {0x30A7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF6B = {.cps = (lxb_codepoint_t[]) {0x30A9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF6C = {.cps = (lxb_codepoint_t[]) {0x30E3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF6D = {.cps = (lxb_codepoint_t[]) {0x30E5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF6E = {.cps = (lxb_codepoint_t[]) {0x30E7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF6F = {.cps = (lxb_codepoint_t[]) {0x30C3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF70 = {.cps = (lxb_codepoint_t[]) {0x30FC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF71 = {.cps = (lxb_codepoint_t[]) {0x30A2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF72 = {.cps = (lxb_codepoint_t[]) {0x30A4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF73 = {.cps = (lxb_codepoint_t[]) {0x30A6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF74 = {.cps = (lxb_codepoint_t[]) {0x30A8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF75 = {.cps = (lxb_codepoint_t[]) {0x30AA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF76 = {.cps = (lxb_codepoint_t[]) {0x30AB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF77 = {.cps = (lxb_codepoint_t[]) {0x30AD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF78 = {.cps = (lxb_codepoint_t[]) {0x30AF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF79 = {.cps = (lxb_codepoint_t[]) {0x30B1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF7A = {.cps = (lxb_codepoint_t[]) {0x30B3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF7B = {.cps = (lxb_codepoint_t[]) {0x30B5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF7C = {.cps = (lxb_codepoint_t[]) {0x30B7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF7D = {.cps = (lxb_codepoint_t[]) {0x30B9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF7E = {.cps = (lxb_codepoint_t[]) {0x30BB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF7F = {.cps = (lxb_codepoint_t[]) {0x30BD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF80 = {.cps = (lxb_codepoint_t[]) {0x30BF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF81 = {.cps = (lxb_codepoint_t[]) {0x30C1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF82 = {.cps = (lxb_codepoint_t[]) {0x30C4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF83 = {.cps = (lxb_codepoint_t[]) {0x30C6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF84 = {.cps = (lxb_codepoint_t[]) {0x30C8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF85 = {.cps = (lxb_codepoint_t[]) {0x30CA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF86 = {.cps = (lxb_codepoint_t[]) {0x30CB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF87 = {.cps = (lxb_codepoint_t[]) {0x30CC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF88 = {.cps = (lxb_codepoint_t[]) {0x30CD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF89 = {.cps = (lxb_codepoint_t[]) {0x30CE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF8A = {.cps = (lxb_codepoint_t[]) {0x30CF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF8B = {.cps = (lxb_codepoint_t[]) {0x30D2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF8C = {.cps = (lxb_codepoint_t[]) {0x30D5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF8D = {.cps = (lxb_codepoint_t[]) {0x30D8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF8E = {.cps = (lxb_codepoint_t[]) {0x30DB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF8F = {.cps = (lxb_codepoint_t[]) {0x30DE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF90 = {.cps = (lxb_codepoint_t[]) {0x30DF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF91 = {.cps = (lxb_codepoint_t[]) {0x30E0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF92 = {.cps = (lxb_codepoint_t[]) {0x30E1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF93 = {.cps = (lxb_codepoint_t[]) {0x30E2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF94 = {.cps = (lxb_codepoint_t[]) {0x30E4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF95 = {.cps = (lxb_codepoint_t[]) {0x30E6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF96 = {.cps = (lxb_codepoint_t[]) {0x30E8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF97 = {.cps = (lxb_codepoint_t[]) {0x30E9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF98 = {.cps = (lxb_codepoint_t[]) {0x30EA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF99 = {.cps = (lxb_codepoint_t[]) {0x30EB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF9A = {.cps = (lxb_codepoint_t[]) {0x30EC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF9B = {.cps = (lxb_codepoint_t[]) {0x30ED}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF9C = {.cps = (lxb_codepoint_t[]) {0x30EF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF9D = {.cps = (lxb_codepoint_t[]) {0x30F3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF9E = {.cps = (lxb_codepoint_t[]) {0x3099}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FF9F = {.cps = (lxb_codepoint_t[]) {0x309A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFA1 = {.cps = (lxb_codepoint_t[]) {0x1100}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFA2 = {.cps = (lxb_codepoint_t[]) {0x1101}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFA3 = {.cps = (lxb_codepoint_t[]) {0x11AA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFA4 = {.cps = (lxb_codepoint_t[]) {0x1102}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFA5 = {.cps = (lxb_codepoint_t[]) {0x11AC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFA6 = {.cps = (lxb_codepoint_t[]) {0x11AD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFA7 = {.cps = (lxb_codepoint_t[]) {0x1103}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFA8 = {.cps = (lxb_codepoint_t[]) {0x1104}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFA9 = {.cps = (lxb_codepoint_t[]) {0x1105}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFAA = {.cps = (lxb_codepoint_t[]) {0x11B0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFAB = {.cps = (lxb_codepoint_t[]) {0x11B1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFAC = {.cps = (lxb_codepoint_t[]) {0x11B2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFAD = {.cps = (lxb_codepoint_t[]) {0x11B3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFAE = {.cps = (lxb_codepoint_t[]) {0x11B4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFAF = {.cps = (lxb_codepoint_t[]) {0x11B5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFB0 = {.cps = (lxb_codepoint_t[]) {0x111A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFB1 = {.cps = (lxb_codepoint_t[]) {0x1106}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFB2 = {.cps = (lxb_codepoint_t[]) {0x1107}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFB3 = {.cps = (lxb_codepoint_t[]) {0x1108}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFB4 = {.cps = (lxb_codepoint_t[]) {0x1121}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFB5 = {.cps = (lxb_codepoint_t[]) {0x1109}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFB6 = {.cps = (lxb_codepoint_t[]) {0x110A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFB7 = {.cps = (lxb_codepoint_t[]) {0x110B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFB8 = {.cps = (lxb_codepoint_t[]) {0x110C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFB9 = {.cps = (lxb_codepoint_t[]) {0x110D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFBA = {.cps = (lxb_codepoint_t[]) {0x110E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFBB = {.cps = (lxb_codepoint_t[]) {0x110F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFBC = {.cps = (lxb_codepoint_t[]) {0x1110}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFBD = {.cps = (lxb_codepoint_t[]) {0x1111}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFBE = {.cps = (lxb_codepoint_t[]) {0x1112}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFC2 = {.cps = (lxb_codepoint_t[]) {0x1161}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFC3 = {.cps = (lxb_codepoint_t[]) {0x1162}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFC4 = {.cps = (lxb_codepoint_t[]) {0x1163}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFC5 = {.cps = (lxb_codepoint_t[]) {0x1164}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFC6 = {.cps = (lxb_codepoint_t[]) {0x1165}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFC7 = {.cps = (lxb_codepoint_t[]) {0x1166}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFCA = {.cps = (lxb_codepoint_t[]) {0x1167}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFCB = {.cps = (lxb_codepoint_t[]) {0x1168}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFCC = {.cps = (lxb_codepoint_t[]) {0x1169}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFCD = {.cps = (lxb_codepoint_t[]) {0x116A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFCE = {.cps = (lxb_codepoint_t[]) {0x116B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFCF = {.cps = (lxb_codepoint_t[]) {0x116C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFD2 = {.cps = (lxb_codepoint_t[]) {0x116D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFD3 = {.cps = (lxb_codepoint_t[]) {0x116E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFD4 = {.cps = (lxb_codepoint_t[]) {0x116F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFD5 = {.cps = (lxb_codepoint_t[]) {0x1170}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFD6 = {.cps = (lxb_codepoint_t[]) {0x1171}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFD7 = {.cps = (lxb_codepoint_t[]) {0x1172}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFDA = {.cps = (lxb_codepoint_t[]) {0x1173}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFDB = {.cps = (lxb_codepoint_t[]) {0x1174}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFDC = {.cps = (lxb_codepoint_t[]) {0x1175}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFE0 = {.cps = (lxb_codepoint_t[]) {0x00A2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFE1 = {.cps = (lxb_codepoint_t[]) {0x00A3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFE2 = {.cps = (lxb_codepoint_t[]) {0x00AC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFE3 = {.cps = (lxb_codepoint_t[]) {0x0020, 0x0304}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFE4 = {.cps = (lxb_codepoint_t[]) {0x00A6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFE5 = {.cps = (lxb_codepoint_t[]) {0x00A5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFE6 = {.cps = (lxb_codepoint_t[]) {0x20A9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFE8 = {.cps = (lxb_codepoint_t[]) {0x2502}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFE9 = {.cps = (lxb_codepoint_t[]) {0x2190}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFEA = {.cps = (lxb_codepoint_t[]) {0x2191}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFEB = {.cps = (lxb_codepoint_t[]) {0x2192}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFEC = {.cps = (lxb_codepoint_t[]) {0x2193}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFED = {.cps = (lxb_codepoint_t[]) {0x25A0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FFEE = {.cps = (lxb_codepoint_t[]) {0x25CB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10400 = {.cps = (lxb_codepoint_t[]) {0x10428}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10401 = {.cps = (lxb_codepoint_t[]) {0x10429}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10402 = {.cps = (lxb_codepoint_t[]) {0x1042A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10403 = {.cps = (lxb_codepoint_t[]) {0x1042B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10404 = {.cps = (lxb_codepoint_t[]) {0x1042C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10405 = {.cps = (lxb_codepoint_t[]) {0x1042D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10406 = {.cps = (lxb_codepoint_t[]) {0x1042E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10407 = {.cps = (lxb_codepoint_t[]) {0x1042F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10408 = {.cps = (lxb_codepoint_t[]) {0x10430}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10409 = {.cps = (lxb_codepoint_t[]) {0x10431}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1040A = {.cps = (lxb_codepoint_t[]) {0x10432}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1040B = {.cps = (lxb_codepoint_t[]) {0x10433}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1040C = {.cps = (lxb_codepoint_t[]) {0x10434}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1040D = {.cps = (lxb_codepoint_t[]) {0x10435}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1040E = {.cps = (lxb_codepoint_t[]) {0x10436}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1040F = {.cps = (lxb_codepoint_t[]) {0x10437}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10410 = {.cps = (lxb_codepoint_t[]) {0x10438}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10411 = {.cps = (lxb_codepoint_t[]) {0x10439}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10412 = {.cps = (lxb_codepoint_t[]) {0x1043A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10413 = {.cps = (lxb_codepoint_t[]) {0x1043B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10414 = {.cps = (lxb_codepoint_t[]) {0x1043C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10415 = {.cps = (lxb_codepoint_t[]) {0x1043D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10416 = {.cps = (lxb_codepoint_t[]) {0x1043E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10417 = {.cps = (lxb_codepoint_t[]) {0x1043F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10418 = {.cps = (lxb_codepoint_t[]) {0x10440}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10419 = {.cps = (lxb_codepoint_t[]) {0x10441}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1041A = {.cps = (lxb_codepoint_t[]) {0x10442}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1041B = {.cps = (lxb_codepoint_t[]) {0x10443}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1041C = {.cps = (lxb_codepoint_t[]) {0x10444}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1041D = {.cps = (lxb_codepoint_t[]) {0x10445}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1041E = {.cps = (lxb_codepoint_t[]) {0x10446}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1041F = {.cps = (lxb_codepoint_t[]) {0x10447}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10420 = {.cps = (lxb_codepoint_t[]) {0x10448}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10421 = {.cps = (lxb_codepoint_t[]) {0x10449}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10422 = {.cps = (lxb_codepoint_t[]) {0x1044A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10423 = {.cps = (lxb_codepoint_t[]) {0x1044B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10424 = {.cps = (lxb_codepoint_t[]) {0x1044C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10425 = {.cps = (lxb_codepoint_t[]) {0x1044D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10426 = {.cps = (lxb_codepoint_t[]) {0x1044E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10427 = {.cps = (lxb_codepoint_t[]) {0x1044F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_104B0 = {.cps = (lxb_codepoint_t[]) {0x104D8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_104B1 = {.cps = (lxb_codepoint_t[]) {0x104D9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_104B2 = {.cps = (lxb_codepoint_t[]) {0x104DA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_104B3 = {.cps = (lxb_codepoint_t[]) {0x104DB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_104B4 = {.cps = (lxb_codepoint_t[]) {0x104DC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_104B5 = {.cps = (lxb_codepoint_t[]) {0x104DD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_104B6 = {.cps = (lxb_codepoint_t[]) {0x104DE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_104B7 = {.cps = (lxb_codepoint_t[]) {0x104DF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_104B8 = {.cps = (lxb_codepoint_t[]) {0x104E0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_104B9 = {.cps = (lxb_codepoint_t[]) {0x104E1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_104BA = {.cps = (lxb_codepoint_t[]) {0x104E2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_104BB = {.cps = (lxb_codepoint_t[]) {0x104E3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_104BC = {.cps = (lxb_codepoint_t[]) {0x104E4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_104BD = {.cps = (lxb_codepoint_t[]) {0x104E5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_104BE = {.cps = (lxb_codepoint_t[]) {0x104E6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_104BF = {.cps = (lxb_codepoint_t[]) {0x104E7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_104C0 = {.cps = (lxb_codepoint_t[]) {0x104E8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_104C1 = {.cps = (lxb_codepoint_t[]) {0x104E9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_104C2 = {.cps = (lxb_codepoint_t[]) {0x104EA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_104C3 = {.cps = (lxb_codepoint_t[]) {0x104EB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_104C4 = {.cps = (lxb_codepoint_t[]) {0x104EC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_104C5 = {.cps = (lxb_codepoint_t[]) {0x104ED}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_104C6 = {.cps = (lxb_codepoint_t[]) {0x104EE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_104C7 = {.cps = (lxb_codepoint_t[]) {0x104EF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_104C8 = {.cps = (lxb_codepoint_t[]) {0x104F0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_104C9 = {.cps = (lxb_codepoint_t[]) {0x104F1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_104CA = {.cps = (lxb_codepoint_t[]) {0x104F2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_104CB = {.cps = (lxb_codepoint_t[]) {0x104F3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_104CC = {.cps = (lxb_codepoint_t[]) {0x104F4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_104CD = {.cps = (lxb_codepoint_t[]) {0x104F5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_104CE = {.cps = (lxb_codepoint_t[]) {0x104F6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_104CF = {.cps = (lxb_codepoint_t[]) {0x104F7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_104D0 = {.cps = (lxb_codepoint_t[]) {0x104F8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_104D1 = {.cps = (lxb_codepoint_t[]) {0x104F9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_104D2 = {.cps = (lxb_codepoint_t[]) {0x104FA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_104D3 = {.cps = (lxb_codepoint_t[]) {0x104FB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10570 = {.cps = (lxb_codepoint_t[]) {0x10597}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10571 = {.cps = (lxb_codepoint_t[]) {0x10598}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10572 = {.cps = (lxb_codepoint_t[]) {0x10599}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10573 = {.cps = (lxb_codepoint_t[]) {0x1059A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10574 = {.cps = (lxb_codepoint_t[]) {0x1059B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10575 = {.cps = (lxb_codepoint_t[]) {0x1059C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10576 = {.cps = (lxb_codepoint_t[]) {0x1059D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10577 = {.cps = (lxb_codepoint_t[]) {0x1059E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10578 = {.cps = (lxb_codepoint_t[]) {0x1059F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10579 = {.cps = (lxb_codepoint_t[]) {0x105A0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1057A = {.cps = (lxb_codepoint_t[]) {0x105A1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1057C = {.cps = (lxb_codepoint_t[]) {0x105A3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1057D = {.cps = (lxb_codepoint_t[]) {0x105A4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1057E = {.cps = (lxb_codepoint_t[]) {0x105A5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1057F = {.cps = (lxb_codepoint_t[]) {0x105A6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10580 = {.cps = (lxb_codepoint_t[]) {0x105A7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10581 = {.cps = (lxb_codepoint_t[]) {0x105A8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10582 = {.cps = (lxb_codepoint_t[]) {0x105A9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10583 = {.cps = (lxb_codepoint_t[]) {0x105AA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10584 = {.cps = (lxb_codepoint_t[]) {0x105AB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10585 = {.cps = (lxb_codepoint_t[]) {0x105AC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10586 = {.cps = (lxb_codepoint_t[]) {0x105AD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10587 = {.cps = (lxb_codepoint_t[]) {0x105AE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10588 = {.cps = (lxb_codepoint_t[]) {0x105AF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10589 = {.cps = (lxb_codepoint_t[]) {0x105B0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1058A = {.cps = (lxb_codepoint_t[]) {0x105B1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1058C = {.cps = (lxb_codepoint_t[]) {0x105B3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1058D = {.cps = (lxb_codepoint_t[]) {0x105B4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1058E = {.cps = (lxb_codepoint_t[]) {0x105B5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1058F = {.cps = (lxb_codepoint_t[]) {0x105B6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10590 = {.cps = (lxb_codepoint_t[]) {0x105B7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10591 = {.cps = (lxb_codepoint_t[]) {0x105B8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10592 = {.cps = (lxb_codepoint_t[]) {0x105B9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10594 = {.cps = (lxb_codepoint_t[]) {0x105BB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10595 = {.cps = (lxb_codepoint_t[]) {0x105BC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10781 = {.cps = (lxb_codepoint_t[]) {0x02D0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10782 = {.cps = (lxb_codepoint_t[]) {0x02D1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10783 = {.cps = (lxb_codepoint_t[]) {0x00E6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10784 = {.cps = (lxb_codepoint_t[]) {0x0299}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10785 = {.cps = (lxb_codepoint_t[]) {0x0253}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10787 = {.cps = (lxb_codepoint_t[]) {0x02A3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10788 = {.cps = (lxb_codepoint_t[]) {0xAB66}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10789 = {.cps = (lxb_codepoint_t[]) {0x02A5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1078A = {.cps = (lxb_codepoint_t[]) {0x02A4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1078B = {.cps = (lxb_codepoint_t[]) {0x0256}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1078C = {.cps = (lxb_codepoint_t[]) {0x0257}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1078D = {.cps = (lxb_codepoint_t[]) {0x1D91}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1078E = {.cps = (lxb_codepoint_t[]) {0x0258}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1078F = {.cps = (lxb_codepoint_t[]) {0x025E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10790 = {.cps = (lxb_codepoint_t[]) {0x02A9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10791 = {.cps = (lxb_codepoint_t[]) {0x0264}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10792 = {.cps = (lxb_codepoint_t[]) {0x0262}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10793 = {.cps = (lxb_codepoint_t[]) {0x0260}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10794 = {.cps = (lxb_codepoint_t[]) {0x029B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10795 = {.cps = (lxb_codepoint_t[]) {0x0127}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10796 = {.cps = (lxb_codepoint_t[]) {0x029C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10797 = {.cps = (lxb_codepoint_t[]) {0x0267}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10798 = {.cps = (lxb_codepoint_t[]) {0x0284}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10799 = {.cps = (lxb_codepoint_t[]) {0x02AA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1079A = {.cps = (lxb_codepoint_t[]) {0x02AB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1079B = {.cps = (lxb_codepoint_t[]) {0x026C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1079C = {.cps = (lxb_codepoint_t[]) {0x1DF04}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1079D = {.cps = (lxb_codepoint_t[]) {0xA78E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1079E = {.cps = (lxb_codepoint_t[]) {0x026E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1079F = {.cps = (lxb_codepoint_t[]) {0x1DF05}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_107A0 = {.cps = (lxb_codepoint_t[]) {0x028E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_107A1 = {.cps = (lxb_codepoint_t[]) {0x1DF06}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_107A2 = {.cps = (lxb_codepoint_t[]) {0x00F8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_107A3 = {.cps = (lxb_codepoint_t[]) {0x0276}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_107A4 = {.cps = (lxb_codepoint_t[]) {0x0277}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_107A5 = {.cps = (lxb_codepoint_t[]) {0x0071}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_107A6 = {.cps = (lxb_codepoint_t[]) {0x027A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_107A7 = {.cps = (lxb_codepoint_t[]) {0x1DF08}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_107A8 = {.cps = (lxb_codepoint_t[]) {0x027D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_107A9 = {.cps = (lxb_codepoint_t[]) {0x027E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_107AA = {.cps = (lxb_codepoint_t[]) {0x0280}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_107AB = {.cps = (lxb_codepoint_t[]) {0x02A8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_107AC = {.cps = (lxb_codepoint_t[]) {0x02A6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_107AD = {.cps = (lxb_codepoint_t[]) {0xAB67}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_107AE = {.cps = (lxb_codepoint_t[]) {0x02A7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_107AF = {.cps = (lxb_codepoint_t[]) {0x0288}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_107B0 = {.cps = (lxb_codepoint_t[]) {0x2C71}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_107B2 = {.cps = (lxb_codepoint_t[]) {0x028F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_107B3 = {.cps = (lxb_codepoint_t[]) {0x02A1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_107B4 = {.cps = (lxb_codepoint_t[]) {0x02A2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_107B5 = {.cps = (lxb_codepoint_t[]) {0x0298}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_107B6 = {.cps = (lxb_codepoint_t[]) {0x01C0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_107B7 = {.cps = (lxb_codepoint_t[]) {0x01C1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_107B8 = {.cps = (lxb_codepoint_t[]) {0x01C2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_107B9 = {.cps = (lxb_codepoint_t[]) {0x1DF0A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_107BA = {.cps = (lxb_codepoint_t[]) {0x1DF1E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10C80 = {.cps = (lxb_codepoint_t[]) {0x10CC0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10C81 = {.cps = (lxb_codepoint_t[]) {0x10CC1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10C82 = {.cps = (lxb_codepoint_t[]) {0x10CC2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10C83 = {.cps = (lxb_codepoint_t[]) {0x10CC3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10C84 = {.cps = (lxb_codepoint_t[]) {0x10CC4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10C85 = {.cps = (lxb_codepoint_t[]) {0x10CC5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10C86 = {.cps = (lxb_codepoint_t[]) {0x10CC6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10C87 = {.cps = (lxb_codepoint_t[]) {0x10CC7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10C88 = {.cps = (lxb_codepoint_t[]) {0x10CC8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10C89 = {.cps = (lxb_codepoint_t[]) {0x10CC9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10C8A = {.cps = (lxb_codepoint_t[]) {0x10CCA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10C8B = {.cps = (lxb_codepoint_t[]) {0x10CCB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10C8C = {.cps = (lxb_codepoint_t[]) {0x10CCC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10C8D = {.cps = (lxb_codepoint_t[]) {0x10CCD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10C8E = {.cps = (lxb_codepoint_t[]) {0x10CCE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10C8F = {.cps = (lxb_codepoint_t[]) {0x10CCF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10C90 = {.cps = (lxb_codepoint_t[]) {0x10CD0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10C91 = {.cps = (lxb_codepoint_t[]) {0x10CD1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10C92 = {.cps = (lxb_codepoint_t[]) {0x10CD2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10C93 = {.cps = (lxb_codepoint_t[]) {0x10CD3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10C94 = {.cps = (lxb_codepoint_t[]) {0x10CD4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10C95 = {.cps = (lxb_codepoint_t[]) {0x10CD5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10C96 = {.cps = (lxb_codepoint_t[]) {0x10CD6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10C97 = {.cps = (lxb_codepoint_t[]) {0x10CD7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10C98 = {.cps = (lxb_codepoint_t[]) {0x10CD8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10C99 = {.cps = (lxb_codepoint_t[]) {0x10CD9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10C9A = {.cps = (lxb_codepoint_t[]) {0x10CDA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10C9B = {.cps = (lxb_codepoint_t[]) {0x10CDB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10C9C = {.cps = (lxb_codepoint_t[]) {0x10CDC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10C9D = {.cps = (lxb_codepoint_t[]) {0x10CDD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10C9E = {.cps = (lxb_codepoint_t[]) {0x10CDE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10C9F = {.cps = (lxb_codepoint_t[]) {0x10CDF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10CA0 = {.cps = (lxb_codepoint_t[]) {0x10CE0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10CA1 = {.cps = (lxb_codepoint_t[]) {0x10CE1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10CA2 = {.cps = (lxb_codepoint_t[]) {0x10CE2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10CA3 = {.cps = (lxb_codepoint_t[]) {0x10CE3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10CA4 = {.cps = (lxb_codepoint_t[]) {0x10CE4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10CA5 = {.cps = (lxb_codepoint_t[]) {0x10CE5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10CA6 = {.cps = (lxb_codepoint_t[]) {0x10CE6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10CA7 = {.cps = (lxb_codepoint_t[]) {0x10CE7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10CA8 = {.cps = (lxb_codepoint_t[]) {0x10CE8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10CA9 = {.cps = (lxb_codepoint_t[]) {0x10CE9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10CAA = {.cps = (lxb_codepoint_t[]) {0x10CEA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10CAB = {.cps = (lxb_codepoint_t[]) {0x10CEB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10CAC = {.cps = (lxb_codepoint_t[]) {0x10CEC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10CAD = {.cps = (lxb_codepoint_t[]) {0x10CED}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10CAE = {.cps = (lxb_codepoint_t[]) {0x10CEE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10CAF = {.cps = (lxb_codepoint_t[]) {0x10CEF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10CB0 = {.cps = (lxb_codepoint_t[]) {0x10CF0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10CB1 = {.cps = (lxb_codepoint_t[]) {0x10CF1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10CB2 = {.cps = (lxb_codepoint_t[]) {0x10CF2}, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FDF0[3] = {0x0635, 0x0644, 0x06D2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FDF0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FDF0, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FDF0[3] = {0x0635, 0x0644, 0x06D2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FDF0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FDF0, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FDF0[3] = {0x0635, 0x0644, 0x06D2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FDF0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FDF0, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_FDF0 = {.cp = 0xFDF0, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FDF0, .cde = &lxb_unicode_decomposition_c_FDF0, .kde = &lxb_unicode_decomposition_k_FDF0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FDF1[3] = {0x0642, 0x0644, 0x06D2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FDF1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FDF1, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FDF1[3] = {0x0642, 0x0644, 0x06D2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FDF1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FDF1, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FDF1[3] = {0x0642, 0x0644, 0x06D2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FDF1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FDF1, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_FDF1 = {.cp = 0xFDF1, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FDF1, .cde = &lxb_unicode_decomposition_c_FDF1, .kde = &lxb_unicode_decomposition_k_FDF1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FDF2[4] = {0x0627, 0x0644, 0x0644, 0x0647};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FDF2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FDF2, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FDF2[4] = {0x0627, 0x0644, 0x0644, 0x0647};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FDF2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FDF2, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FDF2[4] = {0x0627, 0x0644, 0x0644, 0x0647};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FDF2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FDF2, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_FDF2 = {.cp = 0xFDF2, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FDF2, .cde = &lxb_unicode_decomposition_c_FDF2, .kde = &lxb_unicode_decomposition_k_FDF2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FDF3[4] = {0x0627, 0x0643, 0x0628, 0x0631};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FDF3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FDF3, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FDF3[4] = {0x0627, 0x0643, 0x0628, 0x0631};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FDF3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FDF3, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FDF3[4] = {0x0627, 0x0643, 0x0628, 0x0631};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FDF3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FDF3, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_FDF3 = {.cp = 0xFDF3, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FDF3, .cde = &lxb_unicode_decomposition_c_FDF3, .kde = &lxb_unicode_decomposition_k_FDF3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FDF4[4] = {0x0645, 0x062D, 0x0645, 0x062F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FDF4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FDF4, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FDF4[4] = {0x0645, 0x062D, 0x0645, 0x062F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FDF4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FDF4, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FDF4[4] = {0x0645, 0x062D, 0x0645, 0x062F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FDF4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FDF4, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_FDF4 = {.cp = 0xFDF4, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FDF4, .cde = &lxb_unicode_decomposition_c_FDF4, .kde = &lxb_unicode_decomposition_k_FDF4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FDF5[4] = {0x0635, 0x0644, 0x0639, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FDF5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FDF5, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FDF5[4] = {0x0635, 0x0644, 0x0639, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FDF5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FDF5, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FDF5[4] = {0x0635, 0x0644, 0x0639, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FDF5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FDF5, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_FDF5 = {.cp = 0xFDF5, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FDF5, .cde = &lxb_unicode_decomposition_c_FDF5, .kde = &lxb_unicode_decomposition_k_FDF5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FDF6[4] = {0x0631, 0x0633, 0x0648, 0x0644};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FDF6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FDF6, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FDF6[4] = {0x0631, 0x0633, 0x0648, 0x0644};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FDF6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FDF6, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FDF6[4] = {0x0631, 0x0633, 0x0648, 0x0644};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FDF6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FDF6, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_FDF6 = {.cp = 0xFDF6, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FDF6, .cde = &lxb_unicode_decomposition_c_FDF6, .kde = &lxb_unicode_decomposition_k_FDF6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FDF7[4] = {0x0639, 0x0644, 0x064A, 0x0647};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FDF7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FDF7, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FDF7[4] = {0x0639, 0x0644, 0x064A, 0x0647};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FDF7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FDF7, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FDF7[4] = {0x0639, 0x0644, 0x064A, 0x0647};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FDF7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FDF7, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_FDF7 = {.cp = 0xFDF7, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FDF7, .cde = &lxb_unicode_decomposition_c_FDF7, .kde = &lxb_unicode_decomposition_k_FDF7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FDF8[4] = {0x0648, 0x0633, 0x0644, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FDF8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FDF8, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FDF8[4] = {0x0648, 0x0633, 0x0644, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FDF8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FDF8, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FDF8[4] = {0x0648, 0x0633, 0x0644, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FDF8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FDF8, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_FDF8 = {.cp = 0xFDF8, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FDF8, .cde = &lxb_unicode_decomposition_c_FDF8, .kde = &lxb_unicode_decomposition_k_FDF8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FDF9[3] = {0x0635, 0x0644, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FDF9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FDF9, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FDF9[3] = {0x0635, 0x0644, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FDF9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FDF9, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FDF9[3] = {0x0635, 0x0644, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FDF9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FDF9, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_FDF9 = {.cp = 0xFDF9, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FDF9, .cde = &lxb_unicode_decomposition_c_FDF9, .kde = &lxb_unicode_decomposition_k_FDF9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FDFA[18] = {0x0635, 0x0644, 0x0649, 0x0020, 0x0627, 0x0644, 0x0644, 0x0647, 0x0020, 0x0639, 0x0644, 0x064A, 0x0647, 0x0020, 0x0648, 0x0633, 0x0644, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FDFA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FDFA, .length = 18};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FDFA[18] = {0x0635, 0x0644, 0x0649, 0x0020, 0x0627, 0x0644, 0x0644, 0x0647, 0x0020, 0x0639, 0x0644, 0x064A, 0x0647, 0x0020, 0x0648, 0x0633, 0x0644, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FDFA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FDFA, .length = 18};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FDFA[18] = {0x0635, 0x0644, 0x0649, 0x0020, 0x0627, 0x0644, 0x0644, 0x0647, 0x0020, 0x0639, 0x0644, 0x064A, 0x0647, 0x0020, 0x0648, 0x0633, 0x0644, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FDFA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FDFA, .length = 18};
static const lxb_unicode_entry_t lxb_unicode_entry_FDFA = {.cp = 0xFDFA, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FDFA, .cde = &lxb_unicode_decomposition_c_FDFA, .kde = &lxb_unicode_decomposition_k_FDFA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FDFB[8] = {0x062C, 0x0644, 0x0020, 0x062C, 0x0644, 0x0627, 0x0644, 0x0647};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FDFB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FDFB, .length = 8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FDFB[8] = {0x062C, 0x0644, 0x0020, 0x062C, 0x0644, 0x0627, 0x0644, 0x0647};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FDFB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FDFB, .length = 8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FDFB[8] = {0x062C, 0x0644, 0x0020, 0x062C, 0x0644, 0x0627, 0x0644, 0x0647};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FDFB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FDFB, .length = 8};
static const lxb_unicode_entry_t lxb_unicode_entry_FDFB = {.cp = 0xFDFB, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FDFB, .cde = &lxb_unicode_decomposition_c_FDFB, .kde = &lxb_unicode_decomposition_k_FDFB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FDFC[4] = {0x0631, 0x06CC, 0x0627, 0x0644};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FDFC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FDFC, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FDFC[4] = {0x0631, 0x06CC, 0x0627, 0x0644};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FDFC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FDFC, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FDFC[4] = {0x0631, 0x06CC, 0x0627, 0x0644};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FDFC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FDFC, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_FDFC = {.cp = 0xFDFC, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FDFC, .cde = &lxb_unicode_decomposition_c_FDFC, .kde = &lxb_unicode_decomposition_k_FDFC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE10[1] = {0x002C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE10 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_c_FE10, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE10[1] = {0x002C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE10 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_k_FE10, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE10[1] = {0x002C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE10 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp__FE10, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE10 = {.cp = 0xFE10, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE10, .cde = &lxb_unicode_decomposition_c_FE10, .kde = &lxb_unicode_decomposition_k_FE10};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE11[1] = {0x3001};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE11 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_c_FE11, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE11[1] = {0x3001};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE11 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_k_FE11, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE11[1] = {0x3001};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE11 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp__FE11, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE11 = {.cp = 0xFE11, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE11, .cde = &lxb_unicode_decomposition_c_FE11, .kde = &lxb_unicode_decomposition_k_FE11};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE12[1] = {0x3002};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE12 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_c_FE12, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE12[1] = {0x3002};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE12 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_k_FE12, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE12[1] = {0x3002};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE12 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp__FE12, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE12 = {.cp = 0xFE12, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE12, .cde = &lxb_unicode_decomposition_c_FE12, .kde = &lxb_unicode_decomposition_k_FE12};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE13[1] = {0x003A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE13 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_c_FE13, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE13[1] = {0x003A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE13 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_k_FE13, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE13[1] = {0x003A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE13 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp__FE13, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE13 = {.cp = 0xFE13, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE13, .cde = &lxb_unicode_decomposition_c_FE13, .kde = &lxb_unicode_decomposition_k_FE13};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE14[1] = {0x003B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE14 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_c_FE14, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE14[1] = {0x003B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE14 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_k_FE14, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE14[1] = {0x003B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE14 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp__FE14, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE14 = {.cp = 0xFE14, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE14, .cde = &lxb_unicode_decomposition_c_FE14, .kde = &lxb_unicode_decomposition_k_FE14};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE15[1] = {0x0021};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE15 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_c_FE15, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE15[1] = {0x0021};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE15 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_k_FE15, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE15[1] = {0x0021};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE15 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp__FE15, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE15 = {.cp = 0xFE15, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE15, .cde = &lxb_unicode_decomposition_c_FE15, .kde = &lxb_unicode_decomposition_k_FE15};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE16[1] = {0x003F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE16 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_c_FE16, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE16[1] = {0x003F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE16 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_k_FE16, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE16[1] = {0x003F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE16 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp__FE16, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE16 = {.cp = 0xFE16, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE16, .cde = &lxb_unicode_decomposition_c_FE16, .kde = &lxb_unicode_decomposition_k_FE16};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE17[1] = {0x3016};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE17 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_c_FE17, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE17[1] = {0x3016};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE17 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_k_FE17, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE17[1] = {0x3016};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE17 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp__FE17, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE17 = {.cp = 0xFE17, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE17, .cde = &lxb_unicode_decomposition_c_FE17, .kde = &lxb_unicode_decomposition_k_FE17};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE18[1] = {0x3017};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE18 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_c_FE18, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE18[1] = {0x3017};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE18 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_k_FE18, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE18[1] = {0x3017};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE18 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp__FE18, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE18 = {.cp = 0xFE18, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE18, .cde = &lxb_unicode_decomposition_c_FE18, .kde = &lxb_unicode_decomposition_k_FE18};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE19[1] = {0x2026};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE19 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_c_FE19, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE19[3] = {0x002E, 0x002E, 0x002E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE19 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_k_FE19, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE19[1] = {0x2026};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE19 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp__FE19, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE19 = {.cp = 0xFE19, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE19, .cde = &lxb_unicode_decomposition_c_FE19, .kde = &lxb_unicode_decomposition_k_FE19};

static const lxb_unicode_entry_t lxb_unicode_entry_FE20 = {.cp = 0xFE20, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_FE21 = {.cp = 0xFE21, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_FE22 = {.cp = 0xFE22, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_FE23 = {.cp = 0xFE23, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_FE24 = {.cp = 0xFE24, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_FE25 = {.cp = 0xFE25, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_FE26 = {.cp = 0xFE26, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_FE27 = {.cp = 0xFE27, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_FE28 = {.cp = 0xFE28, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_FE29 = {.cp = 0xFE29, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_FE2A = {.cp = 0xFE2A, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_FE2B = {.cp = 0xFE2B, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_FE2C = {.cp = 0xFE2C, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_FE2D = {.cp = 0xFE2D, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_FE2E = {.cp = 0xFE2E, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_FE2F = {.cp = 0xFE2F, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE30[1] = {0x2025};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE30 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_c_FE30, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE30[2] = {0x002E, 0x002E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE30 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_k_FE30, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE30[1] = {0x2025};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE30 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp__FE30, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE30 = {.cp = 0xFE30, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE30, .cde = &lxb_unicode_decomposition_c_FE30, .kde = &lxb_unicode_decomposition_k_FE30};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE31[1] = {0x2014};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE31 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_c_FE31, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE31[1] = {0x2014};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE31 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_k_FE31, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE31[1] = {0x2014};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE31 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp__FE31, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE31 = {.cp = 0xFE31, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE31, .cde = &lxb_unicode_decomposition_c_FE31, .kde = &lxb_unicode_decomposition_k_FE31};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE32[1] = {0x2013};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE32 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_c_FE32, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE32[1] = {0x2013};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE32 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_k_FE32, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE32[1] = {0x2013};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE32 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp__FE32, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE32 = {.cp = 0xFE32, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE32, .cde = &lxb_unicode_decomposition_c_FE32, .kde = &lxb_unicode_decomposition_k_FE32};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE33[1] = {0x005F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE33 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_c_FE33, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE33[1] = {0x005F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE33 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_k_FE33, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE33[1] = {0x005F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE33 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp__FE33, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE33 = {.cp = 0xFE33, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE33, .cde = &lxb_unicode_decomposition_c_FE33, .kde = &lxb_unicode_decomposition_k_FE33};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE34[1] = {0x005F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE34 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_c_FE34, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE34[1] = {0x005F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE34 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_k_FE34, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE34[1] = {0x005F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE34 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp__FE34, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE34 = {.cp = 0xFE34, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE34, .cde = &lxb_unicode_decomposition_c_FE34, .kde = &lxb_unicode_decomposition_k_FE34};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE35[1] = {0x0028};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE35 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_c_FE35, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE35[1] = {0x0028};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE35 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_k_FE35, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE35[1] = {0x0028};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE35 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp__FE35, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE35 = {.cp = 0xFE35, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE35, .cde = &lxb_unicode_decomposition_c_FE35, .kde = &lxb_unicode_decomposition_k_FE35};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE36[1] = {0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE36 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_c_FE36, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE36[1] = {0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE36 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_k_FE36, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE36[1] = {0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE36 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp__FE36, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE36 = {.cp = 0xFE36, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE36, .cde = &lxb_unicode_decomposition_c_FE36, .kde = &lxb_unicode_decomposition_k_FE36};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE37[1] = {0x007B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE37 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_c_FE37, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE37[1] = {0x007B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE37 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_k_FE37, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE37[1] = {0x007B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE37 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp__FE37, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE37 = {.cp = 0xFE37, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE37, .cde = &lxb_unicode_decomposition_c_FE37, .kde = &lxb_unicode_decomposition_k_FE37};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE38[1] = {0x007D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE38 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_c_FE38, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE38[1] = {0x007D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE38 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_k_FE38, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE38[1] = {0x007D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE38 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp__FE38, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE38 = {.cp = 0xFE38, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE38, .cde = &lxb_unicode_decomposition_c_FE38, .kde = &lxb_unicode_decomposition_k_FE38};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE39[1] = {0x3014};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE39 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_c_FE39, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE39[1] = {0x3014};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE39 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_k_FE39, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE39[1] = {0x3014};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE39 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp__FE39, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE39 = {.cp = 0xFE39, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE39, .cde = &lxb_unicode_decomposition_c_FE39, .kde = &lxb_unicode_decomposition_k_FE39};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE3A[1] = {0x3015};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE3A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_c_FE3A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE3A[1] = {0x3015};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE3A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_k_FE3A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE3A[1] = {0x3015};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE3A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp__FE3A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE3A = {.cp = 0xFE3A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE3A, .cde = &lxb_unicode_decomposition_c_FE3A, .kde = &lxb_unicode_decomposition_k_FE3A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE3B[1] = {0x3010};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE3B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_c_FE3B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE3B[1] = {0x3010};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE3B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_k_FE3B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE3B[1] = {0x3010};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE3B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp__FE3B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE3B = {.cp = 0xFE3B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE3B, .cde = &lxb_unicode_decomposition_c_FE3B, .kde = &lxb_unicode_decomposition_k_FE3B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE3C[1] = {0x3011};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE3C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_c_FE3C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE3C[1] = {0x3011};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE3C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_k_FE3C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE3C[1] = {0x3011};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE3C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp__FE3C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE3C = {.cp = 0xFE3C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE3C, .cde = &lxb_unicode_decomposition_c_FE3C, .kde = &lxb_unicode_decomposition_k_FE3C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE3D[1] = {0x300A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE3D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_c_FE3D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE3D[1] = {0x300A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE3D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_k_FE3D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE3D[1] = {0x300A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE3D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp__FE3D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE3D = {.cp = 0xFE3D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE3D, .cde = &lxb_unicode_decomposition_c_FE3D, .kde = &lxb_unicode_decomposition_k_FE3D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE3E[1] = {0x300B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE3E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_c_FE3E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE3E[1] = {0x300B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE3E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_k_FE3E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE3E[1] = {0x300B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE3E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp__FE3E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE3E = {.cp = 0xFE3E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE3E, .cde = &lxb_unicode_decomposition_c_FE3E, .kde = &lxb_unicode_decomposition_k_FE3E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE3F[1] = {0x3008};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE3F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_c_FE3F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE3F[1] = {0x3008};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE3F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_k_FE3F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE3F[1] = {0x3008};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE3F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp__FE3F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE3F = {.cp = 0xFE3F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE3F, .cde = &lxb_unicode_decomposition_c_FE3F, .kde = &lxb_unicode_decomposition_k_FE3F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE40[1] = {0x3009};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE40 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_c_FE40, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE40[1] = {0x3009};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE40 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_k_FE40, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE40[1] = {0x3009};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE40 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp__FE40, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE40 = {.cp = 0xFE40, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE40, .cde = &lxb_unicode_decomposition_c_FE40, .kde = &lxb_unicode_decomposition_k_FE40};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE41[1] = {0x300C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE41 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_c_FE41, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE41[1] = {0x300C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE41 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_k_FE41, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE41[1] = {0x300C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE41 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp__FE41, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE41 = {.cp = 0xFE41, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE41, .cde = &lxb_unicode_decomposition_c_FE41, .kde = &lxb_unicode_decomposition_k_FE41};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE42[1] = {0x300D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE42 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_c_FE42, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE42[1] = {0x300D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE42 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_k_FE42, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE42[1] = {0x300D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE42 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp__FE42, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE42 = {.cp = 0xFE42, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE42, .cde = &lxb_unicode_decomposition_c_FE42, .kde = &lxb_unicode_decomposition_k_FE42};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE43[1] = {0x300E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE43 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_c_FE43, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE43[1] = {0x300E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE43 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_k_FE43, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE43[1] = {0x300E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE43 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp__FE43, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE43 = {.cp = 0xFE43, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE43, .cde = &lxb_unicode_decomposition_c_FE43, .kde = &lxb_unicode_decomposition_k_FE43};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE44[1] = {0x300F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE44 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_c_FE44, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE44[1] = {0x300F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE44 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_k_FE44, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE44[1] = {0x300F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE44 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp__FE44, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE44 = {.cp = 0xFE44, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE44, .cde = &lxb_unicode_decomposition_c_FE44, .kde = &lxb_unicode_decomposition_k_FE44};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE47[1] = {0x005B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE47 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_c_FE47, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE47[1] = {0x005B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE47 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_k_FE47, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE47[1] = {0x005B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE47 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp__FE47, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE47 = {.cp = 0xFE47, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE47, .cde = &lxb_unicode_decomposition_c_FE47, .kde = &lxb_unicode_decomposition_k_FE47};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE48[1] = {0x005D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE48 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_c_FE48, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE48[1] = {0x005D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE48 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_k_FE48, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE48[1] = {0x005D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE48 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp__FE48, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE48 = {.cp = 0xFE48, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE48, .cde = &lxb_unicode_decomposition_c_FE48, .kde = &lxb_unicode_decomposition_k_FE48};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE49[1] = {0x203E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE49 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_FE49, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE49[2] = {0x0020, 0x0305};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE49 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_FE49, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE49[1] = {0x203E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE49 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__FE49, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE49 = {.cp = 0xFE49, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE49, .cde = &lxb_unicode_decomposition_c_FE49, .kde = &lxb_unicode_decomposition_k_FE49};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE4A[1] = {0x203E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE4A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_FE4A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE4A[2] = {0x0020, 0x0305};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE4A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_FE4A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE4A[1] = {0x203E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE4A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__FE4A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE4A = {.cp = 0xFE4A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE4A, .cde = &lxb_unicode_decomposition_c_FE4A, .kde = &lxb_unicode_decomposition_k_FE4A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE4B[1] = {0x203E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE4B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_FE4B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE4B[2] = {0x0020, 0x0305};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE4B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_FE4B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE4B[1] = {0x203E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE4B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__FE4B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE4B = {.cp = 0xFE4B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE4B, .cde = &lxb_unicode_decomposition_c_FE4B, .kde = &lxb_unicode_decomposition_k_FE4B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE4C[1] = {0x203E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE4C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_FE4C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE4C[2] = {0x0020, 0x0305};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE4C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_FE4C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE4C[1] = {0x203E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE4C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__FE4C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE4C = {.cp = 0xFE4C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE4C, .cde = &lxb_unicode_decomposition_c_FE4C, .kde = &lxb_unicode_decomposition_k_FE4C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE4D[1] = {0x005F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE4D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_FE4D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE4D[1] = {0x005F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE4D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_FE4D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE4D[1] = {0x005F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE4D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__FE4D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE4D = {.cp = 0xFE4D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE4D, .cde = &lxb_unicode_decomposition_c_FE4D, .kde = &lxb_unicode_decomposition_k_FE4D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE4E[1] = {0x005F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE4E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_FE4E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE4E[1] = {0x005F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE4E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_FE4E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE4E[1] = {0x005F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE4E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__FE4E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE4E = {.cp = 0xFE4E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE4E, .cde = &lxb_unicode_decomposition_c_FE4E, .kde = &lxb_unicode_decomposition_k_FE4E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE4F[1] = {0x005F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE4F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_FE4F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE4F[1] = {0x005F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE4F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_FE4F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE4F[1] = {0x005F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE4F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__FE4F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE4F = {.cp = 0xFE4F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE4F, .cde = &lxb_unicode_decomposition_c_FE4F, .kde = &lxb_unicode_decomposition_k_FE4F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE50[1] = {0x002C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE50 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_c_FE50, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE50[1] = {0x002C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE50 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_k_FE50, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE50[1] = {0x002C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE50 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp__FE50, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE50 = {.cp = 0xFE50, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE50, .cde = &lxb_unicode_decomposition_c_FE50, .kde = &lxb_unicode_decomposition_k_FE50};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE51[1] = {0x3001};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE51 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_c_FE51, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE51[1] = {0x3001};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE51 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_k_FE51, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE51[1] = {0x3001};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE51 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp__FE51, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE51 = {.cp = 0xFE51, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE51, .cde = &lxb_unicode_decomposition_c_FE51, .kde = &lxb_unicode_decomposition_k_FE51};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE52[1] = {0x002E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE52 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_c_FE52, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE52[1] = {0x002E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE52 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_k_FE52, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE52[1] = {0x002E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE52 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp__FE52, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE52 = {.cp = 0xFE52, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE52, .cde = &lxb_unicode_decomposition_c_FE52, .kde = &lxb_unicode_decomposition_k_FE52};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE54[1] = {0x003B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE54 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_c_FE54, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE54[1] = {0x003B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE54 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_k_FE54, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE54[1] = {0x003B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE54 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp__FE54, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE54 = {.cp = 0xFE54, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE54, .cde = &lxb_unicode_decomposition_c_FE54, .kde = &lxb_unicode_decomposition_k_FE54};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE55[1] = {0x003A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE55 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_c_FE55, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE55[1] = {0x003A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE55 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_k_FE55, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE55[1] = {0x003A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE55 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp__FE55, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE55 = {.cp = 0xFE55, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE55, .cde = &lxb_unicode_decomposition_c_FE55, .kde = &lxb_unicode_decomposition_k_FE55};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE56[1] = {0x003F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE56 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_c_FE56, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE56[1] = {0x003F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE56 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_k_FE56, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE56[1] = {0x003F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE56 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp__FE56, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE56 = {.cp = 0xFE56, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE56, .cde = &lxb_unicode_decomposition_c_FE56, .kde = &lxb_unicode_decomposition_k_FE56};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE57[1] = {0x0021};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE57 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_c_FE57, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE57[1] = {0x0021};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE57 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_k_FE57, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE57[1] = {0x0021};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE57 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp__FE57, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE57 = {.cp = 0xFE57, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE57, .cde = &lxb_unicode_decomposition_c_FE57, .kde = &lxb_unicode_decomposition_k_FE57};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE58[1] = {0x2014};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE58 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_c_FE58, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE58[1] = {0x2014};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE58 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_k_FE58, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE58[1] = {0x2014};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE58 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp__FE58, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE58 = {.cp = 0xFE58, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE58, .cde = &lxb_unicode_decomposition_c_FE58, .kde = &lxb_unicode_decomposition_k_FE58};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE59[1] = {0x0028};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE59 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_c_FE59, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE59[1] = {0x0028};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE59 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_k_FE59, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE59[1] = {0x0028};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE59 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp__FE59, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE59 = {.cp = 0xFE59, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE59, .cde = &lxb_unicode_decomposition_c_FE59, .kde = &lxb_unicode_decomposition_k_FE59};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE5A[1] = {0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE5A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_c_FE5A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE5A[1] = {0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE5A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_k_FE5A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE5A[1] = {0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE5A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp__FE5A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE5A = {.cp = 0xFE5A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE5A, .cde = &lxb_unicode_decomposition_c_FE5A, .kde = &lxb_unicode_decomposition_k_FE5A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE5B[1] = {0x007B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE5B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_c_FE5B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE5B[1] = {0x007B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE5B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_k_FE5B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE5B[1] = {0x007B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE5B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp__FE5B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE5B = {.cp = 0xFE5B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE5B, .cde = &lxb_unicode_decomposition_c_FE5B, .kde = &lxb_unicode_decomposition_k_FE5B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE5C[1] = {0x007D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE5C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_c_FE5C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE5C[1] = {0x007D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE5C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_k_FE5C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE5C[1] = {0x007D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE5C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp__FE5C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE5C = {.cp = 0xFE5C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE5C, .cde = &lxb_unicode_decomposition_c_FE5C, .kde = &lxb_unicode_decomposition_k_FE5C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE5D[1] = {0x3014};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE5D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_c_FE5D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE5D[1] = {0x3014};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE5D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_k_FE5D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE5D[1] = {0x3014};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE5D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp__FE5D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE5D = {.cp = 0xFE5D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE5D, .cde = &lxb_unicode_decomposition_c_FE5D, .kde = &lxb_unicode_decomposition_k_FE5D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE5E[1] = {0x3015};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE5E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_c_FE5E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE5E[1] = {0x3015};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE5E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_k_FE5E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE5E[1] = {0x3015};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE5E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp__FE5E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE5E = {.cp = 0xFE5E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE5E, .cde = &lxb_unicode_decomposition_c_FE5E, .kde = &lxb_unicode_decomposition_k_FE5E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE5F[1] = {0x0023};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE5F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_c_FE5F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE5F[1] = {0x0023};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE5F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_k_FE5F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE5F[1] = {0x0023};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE5F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp__FE5F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE5F = {.cp = 0xFE5F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE5F, .cde = &lxb_unicode_decomposition_c_FE5F, .kde = &lxb_unicode_decomposition_k_FE5F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE60[1] = {0x0026};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE60 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_c_FE60, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE60[1] = {0x0026};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE60 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_k_FE60, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE60[1] = {0x0026};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE60 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp__FE60, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE60 = {.cp = 0xFE60, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE60, .cde = &lxb_unicode_decomposition_c_FE60, .kde = &lxb_unicode_decomposition_k_FE60};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE61[1] = {0x002A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE61 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_c_FE61, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE61[1] = {0x002A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE61 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_k_FE61, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE61[1] = {0x002A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE61 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp__FE61, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE61 = {.cp = 0xFE61, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE61, .cde = &lxb_unicode_decomposition_c_FE61, .kde = &lxb_unicode_decomposition_k_FE61};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE62[1] = {0x002B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE62 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_c_FE62, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE62[1] = {0x002B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE62 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_k_FE62, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE62[1] = {0x002B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE62 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp__FE62, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE62 = {.cp = 0xFE62, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE62, .cde = &lxb_unicode_decomposition_c_FE62, .kde = &lxb_unicode_decomposition_k_FE62};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE63[1] = {0x002D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE63 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_c_FE63, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE63[1] = {0x002D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE63 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_k_FE63, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE63[1] = {0x002D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE63 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp__FE63, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE63 = {.cp = 0xFE63, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE63, .cde = &lxb_unicode_decomposition_c_FE63, .kde = &lxb_unicode_decomposition_k_FE63};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE64[1] = {0x003C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE64 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_c_FE64, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE64[1] = {0x003C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE64 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_k_FE64, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE64[1] = {0x003C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE64 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp__FE64, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE64 = {.cp = 0xFE64, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE64, .cde = &lxb_unicode_decomposition_c_FE64, .kde = &lxb_unicode_decomposition_k_FE64};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE65[1] = {0x003E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE65 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_c_FE65, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE65[1] = {0x003E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE65 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_k_FE65, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE65[1] = {0x003E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE65 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp__FE65, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE65 = {.cp = 0xFE65, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE65, .cde = &lxb_unicode_decomposition_c_FE65, .kde = &lxb_unicode_decomposition_k_FE65};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE66[1] = {0x003D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE66 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_c_FE66, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE66[1] = {0x003D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE66 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_k_FE66, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE66[1] = {0x003D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE66 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp__FE66, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE66 = {.cp = 0xFE66, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE66, .cde = &lxb_unicode_decomposition_c_FE66, .kde = &lxb_unicode_decomposition_k_FE66};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE68[1] = {0x005C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE68 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_c_FE68, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE68[1] = {0x005C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE68 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_k_FE68, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE68[1] = {0x005C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE68 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp__FE68, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE68 = {.cp = 0xFE68, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE68, .cde = &lxb_unicode_decomposition_c_FE68, .kde = &lxb_unicode_decomposition_k_FE68};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE69[1] = {0x0024};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE69 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_c_FE69, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE69[1] = {0x0024};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE69 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_k_FE69, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE69[1] = {0x0024};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE69 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp__FE69, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE69 = {.cp = 0xFE69, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE69, .cde = &lxb_unicode_decomposition_c_FE69, .kde = &lxb_unicode_decomposition_k_FE69};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE6A[1] = {0x0025};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE6A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_c_FE6A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE6A[1] = {0x0025};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE6A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_k_FE6A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE6A[1] = {0x0025};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE6A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp__FE6A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE6A = {.cp = 0xFE6A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE6A, .cde = &lxb_unicode_decomposition_c_FE6A, .kde = &lxb_unicode_decomposition_k_FE6A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE6B[1] = {0x0040};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE6B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_c_FE6B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE6B[1] = {0x0040};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE6B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp_k_FE6B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE6B[1] = {0x0040};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE6B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SMALL, .mapping = lxb_unicode_decomposition_cp__FE6B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE6B = {.cp = 0xFE6B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE6B, .cde = &lxb_unicode_decomposition_c_FE6B, .kde = &lxb_unicode_decomposition_k_FE6B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE70[2] = {0x0020, 0x064B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE70 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FE70, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE70[2] = {0x0020, 0x064B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE70 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FE70, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE70[2] = {0x0020, 0x064B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE70 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FE70, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FE70 = {.cp = 0xFE70, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE70, .cde = &lxb_unicode_decomposition_c_FE70, .kde = &lxb_unicode_decomposition_k_FE70};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE71[2] = {0x0640, 0x064B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE71 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FE71, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE71[2] = {0x0640, 0x064B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE71 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FE71, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE71[2] = {0x0640, 0x064B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE71 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FE71, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FE71 = {.cp = 0xFE71, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE71, .cde = &lxb_unicode_decomposition_c_FE71, .kde = &lxb_unicode_decomposition_k_FE71};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE72[2] = {0x0020, 0x064C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE72 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FE72, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE72[2] = {0x0020, 0x064C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE72 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FE72, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE72[2] = {0x0020, 0x064C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE72 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FE72, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FE72 = {.cp = 0xFE72, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE72, .cde = &lxb_unicode_decomposition_c_FE72, .kde = &lxb_unicode_decomposition_k_FE72};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE74[2] = {0x0020, 0x064D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE74 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FE74, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE74[2] = {0x0020, 0x064D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE74 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FE74, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE74[2] = {0x0020, 0x064D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE74 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FE74, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FE74 = {.cp = 0xFE74, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE74, .cde = &lxb_unicode_decomposition_c_FE74, .kde = &lxb_unicode_decomposition_k_FE74};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE76[2] = {0x0020, 0x064E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE76 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FE76, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE76[2] = {0x0020, 0x064E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE76 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FE76, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE76[2] = {0x0020, 0x064E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE76 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FE76, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FE76 = {.cp = 0xFE76, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE76, .cde = &lxb_unicode_decomposition_c_FE76, .kde = &lxb_unicode_decomposition_k_FE76};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE77[2] = {0x0640, 0x064E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE77 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FE77, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE77[2] = {0x0640, 0x064E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE77 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FE77, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE77[2] = {0x0640, 0x064E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE77 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FE77, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FE77 = {.cp = 0xFE77, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE77, .cde = &lxb_unicode_decomposition_c_FE77, .kde = &lxb_unicode_decomposition_k_FE77};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE78[2] = {0x0020, 0x064F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE78 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FE78, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE78[2] = {0x0020, 0x064F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE78 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FE78, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE78[2] = {0x0020, 0x064F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE78 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FE78, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FE78 = {.cp = 0xFE78, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE78, .cde = &lxb_unicode_decomposition_c_FE78, .kde = &lxb_unicode_decomposition_k_FE78};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE79[2] = {0x0640, 0x064F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE79 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FE79, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE79[2] = {0x0640, 0x064F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE79 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FE79, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE79[2] = {0x0640, 0x064F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE79 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FE79, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FE79 = {.cp = 0xFE79, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE79, .cde = &lxb_unicode_decomposition_c_FE79, .kde = &lxb_unicode_decomposition_k_FE79};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE7A[2] = {0x0020, 0x0650};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE7A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FE7A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE7A[2] = {0x0020, 0x0650};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE7A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FE7A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE7A[2] = {0x0020, 0x0650};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE7A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FE7A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FE7A = {.cp = 0xFE7A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE7A, .cde = &lxb_unicode_decomposition_c_FE7A, .kde = &lxb_unicode_decomposition_k_FE7A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE7B[2] = {0x0640, 0x0650};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE7B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FE7B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE7B[2] = {0x0640, 0x0650};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE7B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FE7B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE7B[2] = {0x0640, 0x0650};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE7B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FE7B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FE7B = {.cp = 0xFE7B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE7B, .cde = &lxb_unicode_decomposition_c_FE7B, .kde = &lxb_unicode_decomposition_k_FE7B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE7C[2] = {0x0020, 0x0651};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE7C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FE7C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE7C[2] = {0x0020, 0x0651};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE7C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FE7C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE7C[2] = {0x0020, 0x0651};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE7C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FE7C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FE7C = {.cp = 0xFE7C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE7C, .cde = &lxb_unicode_decomposition_c_FE7C, .kde = &lxb_unicode_decomposition_k_FE7C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE7D[2] = {0x0640, 0x0651};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE7D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FE7D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE7D[2] = {0x0640, 0x0651};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE7D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FE7D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE7D[2] = {0x0640, 0x0651};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE7D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FE7D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FE7D = {.cp = 0xFE7D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE7D, .cde = &lxb_unicode_decomposition_c_FE7D, .kde = &lxb_unicode_decomposition_k_FE7D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE7E[2] = {0x0020, 0x0652};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE7E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FE7E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE7E[2] = {0x0020, 0x0652};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE7E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FE7E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE7E[2] = {0x0020, 0x0652};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE7E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FE7E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FE7E = {.cp = 0xFE7E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE7E, .cde = &lxb_unicode_decomposition_c_FE7E, .kde = &lxb_unicode_decomposition_k_FE7E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE7F[2] = {0x0640, 0x0652};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE7F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FE7F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE7F[2] = {0x0640, 0x0652};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE7F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FE7F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE7F[2] = {0x0640, 0x0652};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE7F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FE7F, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FE7F = {.cp = 0xFE7F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE7F, .cde = &lxb_unicode_decomposition_c_FE7F, .kde = &lxb_unicode_decomposition_k_FE7F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE80[1] = {0x0621};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE80 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FE80, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE80[1] = {0x0621};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE80 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FE80, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE80[1] = {0x0621};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE80 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FE80, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE80 = {.cp = 0xFE80, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE80, .cde = &lxb_unicode_decomposition_c_FE80, .kde = &lxb_unicode_decomposition_k_FE80};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE81[2] = {0x0627, 0x0653};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE81 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FE81, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE81[2] = {0x0627, 0x0653};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE81 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FE81, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE81[1] = {0x0622};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE81 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FE81, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE81 = {.cp = 0xFE81, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE81, .cde = &lxb_unicode_decomposition_c_FE81, .kde = &lxb_unicode_decomposition_k_FE81};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE82[2] = {0x0627, 0x0653};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE82 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FE82, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE82[2] = {0x0627, 0x0653};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE82 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FE82, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE82[1] = {0x0622};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE82 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FE82, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE82 = {.cp = 0xFE82, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE82, .cde = &lxb_unicode_decomposition_c_FE82, .kde = &lxb_unicode_decomposition_k_FE82};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE83[2] = {0x0627, 0x0654};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE83 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FE83, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE83[2] = {0x0627, 0x0654};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE83 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FE83, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE83[1] = {0x0623};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE83 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FE83, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE83 = {.cp = 0xFE83, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE83, .cde = &lxb_unicode_decomposition_c_FE83, .kde = &lxb_unicode_decomposition_k_FE83};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE84[2] = {0x0627, 0x0654};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE84 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FE84, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE84[2] = {0x0627, 0x0654};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE84 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FE84, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE84[1] = {0x0623};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE84 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FE84, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE84 = {.cp = 0xFE84, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE84, .cde = &lxb_unicode_decomposition_c_FE84, .kde = &lxb_unicode_decomposition_k_FE84};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE85[2] = {0x0648, 0x0654};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE85 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FE85, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE85[2] = {0x0648, 0x0654};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE85 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FE85, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE85[1] = {0x0624};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE85 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FE85, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE85 = {.cp = 0xFE85, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE85, .cde = &lxb_unicode_decomposition_c_FE85, .kde = &lxb_unicode_decomposition_k_FE85};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE86[2] = {0x0648, 0x0654};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE86 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FE86, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE86[2] = {0x0648, 0x0654};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE86 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FE86, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE86[1] = {0x0624};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE86 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FE86, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE86 = {.cp = 0xFE86, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE86, .cde = &lxb_unicode_decomposition_c_FE86, .kde = &lxb_unicode_decomposition_k_FE86};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE87[2] = {0x0627, 0x0655};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE87 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FE87, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE87[2] = {0x0627, 0x0655};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE87 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FE87, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE87[1] = {0x0625};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE87 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FE87, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE87 = {.cp = 0xFE87, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE87, .cde = &lxb_unicode_decomposition_c_FE87, .kde = &lxb_unicode_decomposition_k_FE87};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE88[2] = {0x0627, 0x0655};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE88 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FE88, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE88[2] = {0x0627, 0x0655};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE88 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FE88, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE88[1] = {0x0625};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE88 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FE88, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE88 = {.cp = 0xFE88, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE88, .cde = &lxb_unicode_decomposition_c_FE88, .kde = &lxb_unicode_decomposition_k_FE88};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE89[2] = {0x064A, 0x0654};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE89 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FE89, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE89[2] = {0x064A, 0x0654};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE89 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FE89, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE89[1] = {0x0626};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE89 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FE89, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE89 = {.cp = 0xFE89, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE89, .cde = &lxb_unicode_decomposition_c_FE89, .kde = &lxb_unicode_decomposition_k_FE89};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE8A[2] = {0x064A, 0x0654};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE8A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FE8A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE8A[2] = {0x064A, 0x0654};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE8A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FE8A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE8A[1] = {0x0626};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE8A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FE8A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE8A = {.cp = 0xFE8A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE8A, .cde = &lxb_unicode_decomposition_c_FE8A, .kde = &lxb_unicode_decomposition_k_FE8A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE8B[2] = {0x064A, 0x0654};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE8B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_c_FE8B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE8B[2] = {0x064A, 0x0654};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE8B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_k_FE8B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE8B[1] = {0x0626};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE8B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp__FE8B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE8B = {.cp = 0xFE8B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE8B, .cde = &lxb_unicode_decomposition_c_FE8B, .kde = &lxb_unicode_decomposition_k_FE8B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE8C[2] = {0x064A, 0x0654};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE8C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FE8C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE8C[2] = {0x064A, 0x0654};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE8C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FE8C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE8C[1] = {0x0626};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE8C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FE8C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE8C = {.cp = 0xFE8C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE8C, .cde = &lxb_unicode_decomposition_c_FE8C, .kde = &lxb_unicode_decomposition_k_FE8C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE8D[1] = {0x0627};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE8D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FE8D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE8D[1] = {0x0627};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE8D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FE8D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE8D[1] = {0x0627};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE8D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FE8D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE8D = {.cp = 0xFE8D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE8D, .cde = &lxb_unicode_decomposition_c_FE8D, .kde = &lxb_unicode_decomposition_k_FE8D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE8E[1] = {0x0627};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE8E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FE8E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE8E[1] = {0x0627};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE8E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FE8E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE8E[1] = {0x0627};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE8E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FE8E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE8E = {.cp = 0xFE8E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE8E, .cde = &lxb_unicode_decomposition_c_FE8E, .kde = &lxb_unicode_decomposition_k_FE8E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE8F[1] = {0x0628};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE8F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FE8F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE8F[1] = {0x0628};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE8F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FE8F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE8F[1] = {0x0628};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE8F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FE8F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE8F = {.cp = 0xFE8F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE8F, .cde = &lxb_unicode_decomposition_c_FE8F, .kde = &lxb_unicode_decomposition_k_FE8F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE90[1] = {0x0628};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE90 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FE90, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE90[1] = {0x0628};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE90 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FE90, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE90[1] = {0x0628};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE90 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FE90, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE90 = {.cp = 0xFE90, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE90, .cde = &lxb_unicode_decomposition_c_FE90, .kde = &lxb_unicode_decomposition_k_FE90};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE91[1] = {0x0628};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE91 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_c_FE91, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE91[1] = {0x0628};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE91 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_k_FE91, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE91[1] = {0x0628};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE91 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp__FE91, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE91 = {.cp = 0xFE91, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE91, .cde = &lxb_unicode_decomposition_c_FE91, .kde = &lxb_unicode_decomposition_k_FE91};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE92[1] = {0x0628};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE92 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FE92, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE92[1] = {0x0628};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE92 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FE92, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE92[1] = {0x0628};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE92 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FE92, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE92 = {.cp = 0xFE92, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE92, .cde = &lxb_unicode_decomposition_c_FE92, .kde = &lxb_unicode_decomposition_k_FE92};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE93[1] = {0x0629};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE93 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FE93, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE93[1] = {0x0629};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE93 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FE93, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE93[1] = {0x0629};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE93 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FE93, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE93 = {.cp = 0xFE93, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE93, .cde = &lxb_unicode_decomposition_c_FE93, .kde = &lxb_unicode_decomposition_k_FE93};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE94[1] = {0x0629};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE94 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FE94, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE94[1] = {0x0629};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE94 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FE94, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE94[1] = {0x0629};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE94 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FE94, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE94 = {.cp = 0xFE94, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE94, .cde = &lxb_unicode_decomposition_c_FE94, .kde = &lxb_unicode_decomposition_k_FE94};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE95[1] = {0x062A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE95 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FE95, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE95[1] = {0x062A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE95 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FE95, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE95[1] = {0x062A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE95 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FE95, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE95 = {.cp = 0xFE95, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE95, .cde = &lxb_unicode_decomposition_c_FE95, .kde = &lxb_unicode_decomposition_k_FE95};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE96[1] = {0x062A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE96 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FE96, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE96[1] = {0x062A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE96 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FE96, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE96[1] = {0x062A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE96 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FE96, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE96 = {.cp = 0xFE96, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE96, .cde = &lxb_unicode_decomposition_c_FE96, .kde = &lxb_unicode_decomposition_k_FE96};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE97[1] = {0x062A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE97 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_c_FE97, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE97[1] = {0x062A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE97 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_k_FE97, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE97[1] = {0x062A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE97 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp__FE97, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE97 = {.cp = 0xFE97, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE97, .cde = &lxb_unicode_decomposition_c_FE97, .kde = &lxb_unicode_decomposition_k_FE97};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE98[1] = {0x062A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE98 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FE98, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE98[1] = {0x062A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE98 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FE98, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE98[1] = {0x062A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE98 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FE98, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE98 = {.cp = 0xFE98, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE98, .cde = &lxb_unicode_decomposition_c_FE98, .kde = &lxb_unicode_decomposition_k_FE98};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE99[1] = {0x062B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE99 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FE99, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE99[1] = {0x062B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE99 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FE99, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE99[1] = {0x062B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE99 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FE99, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE99 = {.cp = 0xFE99, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE99, .cde = &lxb_unicode_decomposition_c_FE99, .kde = &lxb_unicode_decomposition_k_FE99};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE9A[1] = {0x062B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE9A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FE9A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE9A[1] = {0x062B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE9A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FE9A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE9A[1] = {0x062B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE9A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FE9A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE9A = {.cp = 0xFE9A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE9A, .cde = &lxb_unicode_decomposition_c_FE9A, .kde = &lxb_unicode_decomposition_k_FE9A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE9B[1] = {0x062B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE9B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_c_FE9B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE9B[1] = {0x062B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE9B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_k_FE9B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE9B[1] = {0x062B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE9B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp__FE9B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE9B = {.cp = 0xFE9B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE9B, .cde = &lxb_unicode_decomposition_c_FE9B, .kde = &lxb_unicode_decomposition_k_FE9B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE9C[1] = {0x062B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE9C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FE9C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE9C[1] = {0x062B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE9C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FE9C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE9C[1] = {0x062B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE9C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FE9C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE9C = {.cp = 0xFE9C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE9C, .cde = &lxb_unicode_decomposition_c_FE9C, .kde = &lxb_unicode_decomposition_k_FE9C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE9D[1] = {0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE9D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FE9D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE9D[1] = {0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE9D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FE9D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE9D[1] = {0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE9D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FE9D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE9D = {.cp = 0xFE9D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE9D, .cde = &lxb_unicode_decomposition_c_FE9D, .kde = &lxb_unicode_decomposition_k_FE9D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE9E[1] = {0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE9E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FE9E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE9E[1] = {0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE9E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FE9E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE9E[1] = {0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE9E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FE9E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE9E = {.cp = 0xFE9E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE9E, .cde = &lxb_unicode_decomposition_c_FE9E, .kde = &lxb_unicode_decomposition_k_FE9E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FE9F[1] = {0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FE9F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_c_FE9F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FE9F[1] = {0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FE9F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_k_FE9F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FE9F[1] = {0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FE9F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp__FE9F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FE9F = {.cp = 0xFE9F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FE9F, .cde = &lxb_unicode_decomposition_c_FE9F, .kde = &lxb_unicode_decomposition_k_FE9F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEA0[1] = {0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEA0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FEA0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEA0[1] = {0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEA0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FEA0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEA0[1] = {0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEA0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FEA0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEA0 = {.cp = 0xFEA0, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEA0, .cde = &lxb_unicode_decomposition_c_FEA0, .kde = &lxb_unicode_decomposition_k_FEA0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEA1[1] = {0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEA1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FEA1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEA1[1] = {0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEA1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FEA1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEA1[1] = {0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEA1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FEA1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEA1 = {.cp = 0xFEA1, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEA1, .cde = &lxb_unicode_decomposition_c_FEA1, .kde = &lxb_unicode_decomposition_k_FEA1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEA2[1] = {0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEA2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FEA2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEA2[1] = {0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEA2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FEA2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEA2[1] = {0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEA2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FEA2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEA2 = {.cp = 0xFEA2, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEA2, .cde = &lxb_unicode_decomposition_c_FEA2, .kde = &lxb_unicode_decomposition_k_FEA2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEA3[1] = {0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEA3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_c_FEA3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEA3[1] = {0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEA3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_k_FEA3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEA3[1] = {0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEA3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp__FEA3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEA3 = {.cp = 0xFEA3, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEA3, .cde = &lxb_unicode_decomposition_c_FEA3, .kde = &lxb_unicode_decomposition_k_FEA3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEA4[1] = {0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEA4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FEA4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEA4[1] = {0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEA4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FEA4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEA4[1] = {0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEA4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FEA4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEA4 = {.cp = 0xFEA4, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEA4, .cde = &lxb_unicode_decomposition_c_FEA4, .kde = &lxb_unicode_decomposition_k_FEA4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEA5[1] = {0x062E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEA5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FEA5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEA5[1] = {0x062E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEA5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FEA5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEA5[1] = {0x062E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEA5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FEA5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEA5 = {.cp = 0xFEA5, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEA5, .cde = &lxb_unicode_decomposition_c_FEA5, .kde = &lxb_unicode_decomposition_k_FEA5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEA6[1] = {0x062E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEA6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FEA6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEA6[1] = {0x062E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEA6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FEA6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEA6[1] = {0x062E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEA6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FEA6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEA6 = {.cp = 0xFEA6, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEA6, .cde = &lxb_unicode_decomposition_c_FEA6, .kde = &lxb_unicode_decomposition_k_FEA6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEA7[1] = {0x062E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEA7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_c_FEA7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEA7[1] = {0x062E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEA7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_k_FEA7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEA7[1] = {0x062E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEA7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp__FEA7, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEA7 = {.cp = 0xFEA7, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEA7, .cde = &lxb_unicode_decomposition_c_FEA7, .kde = &lxb_unicode_decomposition_k_FEA7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEA8[1] = {0x062E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEA8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FEA8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEA8[1] = {0x062E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEA8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FEA8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEA8[1] = {0x062E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEA8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FEA8, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEA8 = {.cp = 0xFEA8, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEA8, .cde = &lxb_unicode_decomposition_c_FEA8, .kde = &lxb_unicode_decomposition_k_FEA8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEA9[1] = {0x062F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEA9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FEA9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEA9[1] = {0x062F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEA9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FEA9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEA9[1] = {0x062F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEA9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FEA9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEA9 = {.cp = 0xFEA9, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEA9, .cde = &lxb_unicode_decomposition_c_FEA9, .kde = &lxb_unicode_decomposition_k_FEA9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEAA[1] = {0x062F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEAA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FEAA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEAA[1] = {0x062F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEAA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FEAA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEAA[1] = {0x062F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEAA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FEAA, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEAA = {.cp = 0xFEAA, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEAA, .cde = &lxb_unicode_decomposition_c_FEAA, .kde = &lxb_unicode_decomposition_k_FEAA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEAB[1] = {0x0630};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEAB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FEAB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEAB[1] = {0x0630};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEAB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FEAB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEAB[1] = {0x0630};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEAB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FEAB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEAB = {.cp = 0xFEAB, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEAB, .cde = &lxb_unicode_decomposition_c_FEAB, .kde = &lxb_unicode_decomposition_k_FEAB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEAC[1] = {0x0630};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEAC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FEAC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEAC[1] = {0x0630};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEAC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FEAC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEAC[1] = {0x0630};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEAC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FEAC, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEAC = {.cp = 0xFEAC, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEAC, .cde = &lxb_unicode_decomposition_c_FEAC, .kde = &lxb_unicode_decomposition_k_FEAC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEAD[1] = {0x0631};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEAD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FEAD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEAD[1] = {0x0631};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEAD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FEAD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEAD[1] = {0x0631};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEAD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FEAD, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEAD = {.cp = 0xFEAD, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEAD, .cde = &lxb_unicode_decomposition_c_FEAD, .kde = &lxb_unicode_decomposition_k_FEAD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEAE[1] = {0x0631};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEAE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FEAE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEAE[1] = {0x0631};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEAE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FEAE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEAE[1] = {0x0631};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEAE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FEAE, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEAE = {.cp = 0xFEAE, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEAE, .cde = &lxb_unicode_decomposition_c_FEAE, .kde = &lxb_unicode_decomposition_k_FEAE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEAF[1] = {0x0632};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEAF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FEAF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEAF[1] = {0x0632};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEAF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FEAF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEAF[1] = {0x0632};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEAF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FEAF, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEAF = {.cp = 0xFEAF, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEAF, .cde = &lxb_unicode_decomposition_c_FEAF, .kde = &lxb_unicode_decomposition_k_FEAF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEB0[1] = {0x0632};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEB0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FEB0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEB0[1] = {0x0632};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEB0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FEB0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEB0[1] = {0x0632};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEB0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FEB0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEB0 = {.cp = 0xFEB0, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEB0, .cde = &lxb_unicode_decomposition_c_FEB0, .kde = &lxb_unicode_decomposition_k_FEB0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEB1[1] = {0x0633};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEB1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FEB1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEB1[1] = {0x0633};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEB1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FEB1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEB1[1] = {0x0633};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEB1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FEB1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEB1 = {.cp = 0xFEB1, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEB1, .cde = &lxb_unicode_decomposition_c_FEB1, .kde = &lxb_unicode_decomposition_k_FEB1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEB2[1] = {0x0633};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEB2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FEB2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEB2[1] = {0x0633};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEB2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FEB2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEB2[1] = {0x0633};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEB2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FEB2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEB2 = {.cp = 0xFEB2, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEB2, .cde = &lxb_unicode_decomposition_c_FEB2, .kde = &lxb_unicode_decomposition_k_FEB2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEB3[1] = {0x0633};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEB3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_c_FEB3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEB3[1] = {0x0633};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEB3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_k_FEB3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEB3[1] = {0x0633};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEB3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp__FEB3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEB3 = {.cp = 0xFEB3, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEB3, .cde = &lxb_unicode_decomposition_c_FEB3, .kde = &lxb_unicode_decomposition_k_FEB3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEB4[1] = {0x0633};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEB4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FEB4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEB4[1] = {0x0633};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEB4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FEB4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEB4[1] = {0x0633};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEB4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FEB4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEB4 = {.cp = 0xFEB4, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEB4, .cde = &lxb_unicode_decomposition_c_FEB4, .kde = &lxb_unicode_decomposition_k_FEB4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEB5[1] = {0x0634};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEB5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FEB5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEB5[1] = {0x0634};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEB5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FEB5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEB5[1] = {0x0634};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEB5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FEB5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEB5 = {.cp = 0xFEB5, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEB5, .cde = &lxb_unicode_decomposition_c_FEB5, .kde = &lxb_unicode_decomposition_k_FEB5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEB6[1] = {0x0634};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEB6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FEB6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEB6[1] = {0x0634};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEB6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FEB6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEB6[1] = {0x0634};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEB6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FEB6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEB6 = {.cp = 0xFEB6, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEB6, .cde = &lxb_unicode_decomposition_c_FEB6, .kde = &lxb_unicode_decomposition_k_FEB6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEB7[1] = {0x0634};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEB7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_c_FEB7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEB7[1] = {0x0634};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEB7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_k_FEB7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEB7[1] = {0x0634};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEB7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp__FEB7, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEB7 = {.cp = 0xFEB7, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEB7, .cde = &lxb_unicode_decomposition_c_FEB7, .kde = &lxb_unicode_decomposition_k_FEB7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEB8[1] = {0x0634};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEB8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FEB8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEB8[1] = {0x0634};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEB8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FEB8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEB8[1] = {0x0634};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEB8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FEB8, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEB8 = {.cp = 0xFEB8, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEB8, .cde = &lxb_unicode_decomposition_c_FEB8, .kde = &lxb_unicode_decomposition_k_FEB8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEB9[1] = {0x0635};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEB9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FEB9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEB9[1] = {0x0635};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEB9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FEB9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEB9[1] = {0x0635};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEB9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FEB9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEB9 = {.cp = 0xFEB9, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEB9, .cde = &lxb_unicode_decomposition_c_FEB9, .kde = &lxb_unicode_decomposition_k_FEB9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEBA[1] = {0x0635};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEBA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FEBA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEBA[1] = {0x0635};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEBA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FEBA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEBA[1] = {0x0635};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEBA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FEBA, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEBA = {.cp = 0xFEBA, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEBA, .cde = &lxb_unicode_decomposition_c_FEBA, .kde = &lxb_unicode_decomposition_k_FEBA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEBB[1] = {0x0635};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEBB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_c_FEBB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEBB[1] = {0x0635};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEBB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_k_FEBB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEBB[1] = {0x0635};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEBB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp__FEBB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEBB = {.cp = 0xFEBB, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEBB, .cde = &lxb_unicode_decomposition_c_FEBB, .kde = &lxb_unicode_decomposition_k_FEBB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEBC[1] = {0x0635};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEBC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FEBC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEBC[1] = {0x0635};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEBC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FEBC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEBC[1] = {0x0635};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEBC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FEBC, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEBC = {.cp = 0xFEBC, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEBC, .cde = &lxb_unicode_decomposition_c_FEBC, .kde = &lxb_unicode_decomposition_k_FEBC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEBD[1] = {0x0636};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEBD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FEBD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEBD[1] = {0x0636};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEBD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FEBD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEBD[1] = {0x0636};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEBD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FEBD, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEBD = {.cp = 0xFEBD, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEBD, .cde = &lxb_unicode_decomposition_c_FEBD, .kde = &lxb_unicode_decomposition_k_FEBD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEBE[1] = {0x0636};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEBE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FEBE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEBE[1] = {0x0636};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEBE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FEBE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEBE[1] = {0x0636};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEBE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FEBE, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEBE = {.cp = 0xFEBE, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEBE, .cde = &lxb_unicode_decomposition_c_FEBE, .kde = &lxb_unicode_decomposition_k_FEBE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEBF[1] = {0x0636};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEBF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_c_FEBF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEBF[1] = {0x0636};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEBF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_k_FEBF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEBF[1] = {0x0636};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEBF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp__FEBF, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEBF = {.cp = 0xFEBF, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEBF, .cde = &lxb_unicode_decomposition_c_FEBF, .kde = &lxb_unicode_decomposition_k_FEBF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEC0[1] = {0x0636};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEC0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FEC0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEC0[1] = {0x0636};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEC0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FEC0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEC0[1] = {0x0636};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEC0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FEC0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEC0 = {.cp = 0xFEC0, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEC0, .cde = &lxb_unicode_decomposition_c_FEC0, .kde = &lxb_unicode_decomposition_k_FEC0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEC1[1] = {0x0637};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEC1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FEC1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEC1[1] = {0x0637};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEC1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FEC1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEC1[1] = {0x0637};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEC1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FEC1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEC1 = {.cp = 0xFEC1, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEC1, .cde = &lxb_unicode_decomposition_c_FEC1, .kde = &lxb_unicode_decomposition_k_FEC1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEC2[1] = {0x0637};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEC2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FEC2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEC2[1] = {0x0637};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEC2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FEC2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEC2[1] = {0x0637};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEC2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FEC2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEC2 = {.cp = 0xFEC2, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEC2, .cde = &lxb_unicode_decomposition_c_FEC2, .kde = &lxb_unicode_decomposition_k_FEC2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEC3[1] = {0x0637};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEC3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_c_FEC3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEC3[1] = {0x0637};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEC3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_k_FEC3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEC3[1] = {0x0637};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEC3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp__FEC3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEC3 = {.cp = 0xFEC3, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEC3, .cde = &lxb_unicode_decomposition_c_FEC3, .kde = &lxb_unicode_decomposition_k_FEC3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEC4[1] = {0x0637};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEC4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FEC4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEC4[1] = {0x0637};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEC4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FEC4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEC4[1] = {0x0637};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEC4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FEC4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEC4 = {.cp = 0xFEC4, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEC4, .cde = &lxb_unicode_decomposition_c_FEC4, .kde = &lxb_unicode_decomposition_k_FEC4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEC5[1] = {0x0638};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEC5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FEC5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEC5[1] = {0x0638};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEC5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FEC5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEC5[1] = {0x0638};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEC5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FEC5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEC5 = {.cp = 0xFEC5, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEC5, .cde = &lxb_unicode_decomposition_c_FEC5, .kde = &lxb_unicode_decomposition_k_FEC5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEC6[1] = {0x0638};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEC6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FEC6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEC6[1] = {0x0638};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEC6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FEC6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEC6[1] = {0x0638};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEC6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FEC6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEC6 = {.cp = 0xFEC6, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEC6, .cde = &lxb_unicode_decomposition_c_FEC6, .kde = &lxb_unicode_decomposition_k_FEC6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEC7[1] = {0x0638};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEC7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_c_FEC7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEC7[1] = {0x0638};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEC7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_k_FEC7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEC7[1] = {0x0638};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEC7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp__FEC7, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEC7 = {.cp = 0xFEC7, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEC7, .cde = &lxb_unicode_decomposition_c_FEC7, .kde = &lxb_unicode_decomposition_k_FEC7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEC8[1] = {0x0638};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEC8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FEC8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEC8[1] = {0x0638};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEC8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FEC8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEC8[1] = {0x0638};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEC8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FEC8, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEC8 = {.cp = 0xFEC8, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEC8, .cde = &lxb_unicode_decomposition_c_FEC8, .kde = &lxb_unicode_decomposition_k_FEC8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEC9[1] = {0x0639};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEC9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FEC9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEC9[1] = {0x0639};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEC9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FEC9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEC9[1] = {0x0639};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEC9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FEC9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEC9 = {.cp = 0xFEC9, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEC9, .cde = &lxb_unicode_decomposition_c_FEC9, .kde = &lxb_unicode_decomposition_k_FEC9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FECA[1] = {0x0639};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FECA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FECA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FECA[1] = {0x0639};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FECA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FECA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FECA[1] = {0x0639};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FECA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FECA, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FECA = {.cp = 0xFECA, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FECA, .cde = &lxb_unicode_decomposition_c_FECA, .kde = &lxb_unicode_decomposition_k_FECA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FECB[1] = {0x0639};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FECB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_c_FECB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FECB[1] = {0x0639};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FECB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_k_FECB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FECB[1] = {0x0639};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FECB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp__FECB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FECB = {.cp = 0xFECB, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FECB, .cde = &lxb_unicode_decomposition_c_FECB, .kde = &lxb_unicode_decomposition_k_FECB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FECC[1] = {0x0639};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FECC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FECC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FECC[1] = {0x0639};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FECC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FECC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FECC[1] = {0x0639};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FECC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FECC, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FECC = {.cp = 0xFECC, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FECC, .cde = &lxb_unicode_decomposition_c_FECC, .kde = &lxb_unicode_decomposition_k_FECC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FECD[1] = {0x063A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FECD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FECD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FECD[1] = {0x063A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FECD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FECD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FECD[1] = {0x063A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FECD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FECD, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FECD = {.cp = 0xFECD, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FECD, .cde = &lxb_unicode_decomposition_c_FECD, .kde = &lxb_unicode_decomposition_k_FECD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FECE[1] = {0x063A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FECE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FECE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FECE[1] = {0x063A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FECE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FECE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FECE[1] = {0x063A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FECE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FECE, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FECE = {.cp = 0xFECE, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FECE, .cde = &lxb_unicode_decomposition_c_FECE, .kde = &lxb_unicode_decomposition_k_FECE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FECF[1] = {0x063A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FECF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_c_FECF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FECF[1] = {0x063A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FECF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_k_FECF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FECF[1] = {0x063A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FECF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp__FECF, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FECF = {.cp = 0xFECF, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FECF, .cde = &lxb_unicode_decomposition_c_FECF, .kde = &lxb_unicode_decomposition_k_FECF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FED0[1] = {0x063A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FED0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FED0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FED0[1] = {0x063A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FED0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FED0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FED0[1] = {0x063A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FED0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FED0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FED0 = {.cp = 0xFED0, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FED0, .cde = &lxb_unicode_decomposition_c_FED0, .kde = &lxb_unicode_decomposition_k_FED0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FED1[1] = {0x0641};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FED1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FED1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FED1[1] = {0x0641};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FED1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FED1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FED1[1] = {0x0641};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FED1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FED1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FED1 = {.cp = 0xFED1, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FED1, .cde = &lxb_unicode_decomposition_c_FED1, .kde = &lxb_unicode_decomposition_k_FED1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FED2[1] = {0x0641};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FED2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FED2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FED2[1] = {0x0641};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FED2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FED2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FED2[1] = {0x0641};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FED2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FED2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FED2 = {.cp = 0xFED2, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FED2, .cde = &lxb_unicode_decomposition_c_FED2, .kde = &lxb_unicode_decomposition_k_FED2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FED3[1] = {0x0641};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FED3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_c_FED3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FED3[1] = {0x0641};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FED3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_k_FED3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FED3[1] = {0x0641};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FED3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp__FED3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FED3 = {.cp = 0xFED3, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FED3, .cde = &lxb_unicode_decomposition_c_FED3, .kde = &lxb_unicode_decomposition_k_FED3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FED4[1] = {0x0641};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FED4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FED4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FED4[1] = {0x0641};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FED4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FED4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FED4[1] = {0x0641};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FED4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FED4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FED4 = {.cp = 0xFED4, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FED4, .cde = &lxb_unicode_decomposition_c_FED4, .kde = &lxb_unicode_decomposition_k_FED4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FED5[1] = {0x0642};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FED5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FED5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FED5[1] = {0x0642};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FED5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FED5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FED5[1] = {0x0642};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FED5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FED5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FED5 = {.cp = 0xFED5, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FED5, .cde = &lxb_unicode_decomposition_c_FED5, .kde = &lxb_unicode_decomposition_k_FED5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FED6[1] = {0x0642};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FED6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FED6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FED6[1] = {0x0642};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FED6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FED6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FED6[1] = {0x0642};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FED6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FED6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FED6 = {.cp = 0xFED6, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FED6, .cde = &lxb_unicode_decomposition_c_FED6, .kde = &lxb_unicode_decomposition_k_FED6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FED7[1] = {0x0642};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FED7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_c_FED7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FED7[1] = {0x0642};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FED7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_k_FED7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FED7[1] = {0x0642};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FED7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp__FED7, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FED7 = {.cp = 0xFED7, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FED7, .cde = &lxb_unicode_decomposition_c_FED7, .kde = &lxb_unicode_decomposition_k_FED7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FED8[1] = {0x0642};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FED8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FED8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FED8[1] = {0x0642};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FED8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FED8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FED8[1] = {0x0642};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FED8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FED8, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FED8 = {.cp = 0xFED8, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FED8, .cde = &lxb_unicode_decomposition_c_FED8, .kde = &lxb_unicode_decomposition_k_FED8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FED9[1] = {0x0643};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FED9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FED9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FED9[1] = {0x0643};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FED9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FED9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FED9[1] = {0x0643};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FED9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FED9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FED9 = {.cp = 0xFED9, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FED9, .cde = &lxb_unicode_decomposition_c_FED9, .kde = &lxb_unicode_decomposition_k_FED9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEDA[1] = {0x0643};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEDA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FEDA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEDA[1] = {0x0643};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEDA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FEDA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEDA[1] = {0x0643};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEDA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FEDA, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEDA = {.cp = 0xFEDA, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEDA, .cde = &lxb_unicode_decomposition_c_FEDA, .kde = &lxb_unicode_decomposition_k_FEDA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEDB[1] = {0x0643};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEDB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_c_FEDB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEDB[1] = {0x0643};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEDB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_k_FEDB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEDB[1] = {0x0643};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEDB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp__FEDB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEDB = {.cp = 0xFEDB, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEDB, .cde = &lxb_unicode_decomposition_c_FEDB, .kde = &lxb_unicode_decomposition_k_FEDB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEDC[1] = {0x0643};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEDC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FEDC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEDC[1] = {0x0643};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEDC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FEDC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEDC[1] = {0x0643};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEDC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FEDC, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEDC = {.cp = 0xFEDC, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEDC, .cde = &lxb_unicode_decomposition_c_FEDC, .kde = &lxb_unicode_decomposition_k_FEDC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEDD[1] = {0x0644};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEDD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FEDD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEDD[1] = {0x0644};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEDD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FEDD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEDD[1] = {0x0644};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEDD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FEDD, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEDD = {.cp = 0xFEDD, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEDD, .cde = &lxb_unicode_decomposition_c_FEDD, .kde = &lxb_unicode_decomposition_k_FEDD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEDE[1] = {0x0644};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEDE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FEDE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEDE[1] = {0x0644};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEDE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FEDE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEDE[1] = {0x0644};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEDE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FEDE, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEDE = {.cp = 0xFEDE, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEDE, .cde = &lxb_unicode_decomposition_c_FEDE, .kde = &lxb_unicode_decomposition_k_FEDE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEDF[1] = {0x0644};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEDF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_c_FEDF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEDF[1] = {0x0644};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEDF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_k_FEDF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEDF[1] = {0x0644};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEDF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp__FEDF, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEDF = {.cp = 0xFEDF, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEDF, .cde = &lxb_unicode_decomposition_c_FEDF, .kde = &lxb_unicode_decomposition_k_FEDF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEE0[1] = {0x0644};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEE0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FEE0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEE0[1] = {0x0644};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEE0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FEE0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEE0[1] = {0x0644};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEE0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FEE0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEE0 = {.cp = 0xFEE0, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEE0, .cde = &lxb_unicode_decomposition_c_FEE0, .kde = &lxb_unicode_decomposition_k_FEE0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEE1[1] = {0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEE1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FEE1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEE1[1] = {0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEE1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FEE1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEE1[1] = {0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEE1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FEE1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEE1 = {.cp = 0xFEE1, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEE1, .cde = &lxb_unicode_decomposition_c_FEE1, .kde = &lxb_unicode_decomposition_k_FEE1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEE2[1] = {0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEE2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FEE2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEE2[1] = {0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEE2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FEE2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEE2[1] = {0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEE2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FEE2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEE2 = {.cp = 0xFEE2, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEE2, .cde = &lxb_unicode_decomposition_c_FEE2, .kde = &lxb_unicode_decomposition_k_FEE2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEE3[1] = {0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEE3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_c_FEE3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEE3[1] = {0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEE3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_k_FEE3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEE3[1] = {0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEE3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp__FEE3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEE3 = {.cp = 0xFEE3, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEE3, .cde = &lxb_unicode_decomposition_c_FEE3, .kde = &lxb_unicode_decomposition_k_FEE3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEE4[1] = {0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEE4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FEE4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEE4[1] = {0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEE4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FEE4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEE4[1] = {0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEE4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FEE4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEE4 = {.cp = 0xFEE4, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEE4, .cde = &lxb_unicode_decomposition_c_FEE4, .kde = &lxb_unicode_decomposition_k_FEE4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEE5[1] = {0x0646};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEE5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FEE5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEE5[1] = {0x0646};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEE5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FEE5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEE5[1] = {0x0646};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEE5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FEE5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEE5 = {.cp = 0xFEE5, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEE5, .cde = &lxb_unicode_decomposition_c_FEE5, .kde = &lxb_unicode_decomposition_k_FEE5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEE6[1] = {0x0646};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEE6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FEE6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEE6[1] = {0x0646};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEE6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FEE6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEE6[1] = {0x0646};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEE6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FEE6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEE6 = {.cp = 0xFEE6, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEE6, .cde = &lxb_unicode_decomposition_c_FEE6, .kde = &lxb_unicode_decomposition_k_FEE6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEE7[1] = {0x0646};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEE7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_c_FEE7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEE7[1] = {0x0646};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEE7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_k_FEE7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEE7[1] = {0x0646};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEE7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp__FEE7, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEE7 = {.cp = 0xFEE7, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEE7, .cde = &lxb_unicode_decomposition_c_FEE7, .kde = &lxb_unicode_decomposition_k_FEE7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEE8[1] = {0x0646};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEE8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FEE8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEE8[1] = {0x0646};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEE8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FEE8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEE8[1] = {0x0646};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEE8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FEE8, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEE8 = {.cp = 0xFEE8, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEE8, .cde = &lxb_unicode_decomposition_c_FEE8, .kde = &lxb_unicode_decomposition_k_FEE8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEE9[1] = {0x0647};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEE9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FEE9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEE9[1] = {0x0647};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEE9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FEE9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEE9[1] = {0x0647};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEE9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FEE9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEE9 = {.cp = 0xFEE9, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEE9, .cde = &lxb_unicode_decomposition_c_FEE9, .kde = &lxb_unicode_decomposition_k_FEE9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEEA[1] = {0x0647};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEEA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FEEA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEEA[1] = {0x0647};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEEA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FEEA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEEA[1] = {0x0647};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEEA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FEEA, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEEA = {.cp = 0xFEEA, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEEA, .cde = &lxb_unicode_decomposition_c_FEEA, .kde = &lxb_unicode_decomposition_k_FEEA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEEB[1] = {0x0647};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEEB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_c_FEEB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEEB[1] = {0x0647};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEEB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_k_FEEB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEEB[1] = {0x0647};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEEB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp__FEEB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEEB = {.cp = 0xFEEB, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEEB, .cde = &lxb_unicode_decomposition_c_FEEB, .kde = &lxb_unicode_decomposition_k_FEEB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEEC[1] = {0x0647};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEEC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FEEC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEEC[1] = {0x0647};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEEC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FEEC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEEC[1] = {0x0647};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEEC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FEEC, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEEC = {.cp = 0xFEEC, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEEC, .cde = &lxb_unicode_decomposition_c_FEEC, .kde = &lxb_unicode_decomposition_k_FEEC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEED[1] = {0x0648};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEED = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FEED, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEED[1] = {0x0648};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEED = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FEED, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEED[1] = {0x0648};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEED = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FEED, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEED = {.cp = 0xFEED, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEED, .cde = &lxb_unicode_decomposition_c_FEED, .kde = &lxb_unicode_decomposition_k_FEED};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEEE[1] = {0x0648};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEEE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FEEE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEEE[1] = {0x0648};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEEE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FEEE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEEE[1] = {0x0648};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEEE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FEEE, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEEE = {.cp = 0xFEEE, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEEE, .cde = &lxb_unicode_decomposition_c_FEEE, .kde = &lxb_unicode_decomposition_k_FEEE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEEF[1] = {0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEEF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FEEF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEEF[1] = {0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEEF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FEEF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEEF[1] = {0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEEF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FEEF, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEEF = {.cp = 0xFEEF, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEEF, .cde = &lxb_unicode_decomposition_c_FEEF, .kde = &lxb_unicode_decomposition_k_FEEF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEF0[1] = {0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEF0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FEF0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEF0[1] = {0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEF0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FEF0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEF0[1] = {0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEF0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FEF0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEF0 = {.cp = 0xFEF0, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEF0, .cde = &lxb_unicode_decomposition_c_FEF0, .kde = &lxb_unicode_decomposition_k_FEF0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEF1[1] = {0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEF1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FEF1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEF1[1] = {0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEF1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FEF1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEF1[1] = {0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEF1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FEF1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEF1 = {.cp = 0xFEF1, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEF1, .cde = &lxb_unicode_decomposition_c_FEF1, .kde = &lxb_unicode_decomposition_k_FEF1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEF2[1] = {0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEF2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FEF2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEF2[1] = {0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEF2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FEF2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEF2[1] = {0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEF2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FEF2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEF2 = {.cp = 0xFEF2, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEF2, .cde = &lxb_unicode_decomposition_c_FEF2, .kde = &lxb_unicode_decomposition_k_FEF2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEF3[1] = {0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEF3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_c_FEF3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEF3[1] = {0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEF3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_k_FEF3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEF3[1] = {0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEF3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp__FEF3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEF3 = {.cp = 0xFEF3, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEF3, .cde = &lxb_unicode_decomposition_c_FEF3, .kde = &lxb_unicode_decomposition_k_FEF3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEF4[1] = {0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEF4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FEF4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEF4[1] = {0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEF4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FEF4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEF4[1] = {0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEF4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FEF4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FEF4 = {.cp = 0xFEF4, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEF4, .cde = &lxb_unicode_decomposition_c_FEF4, .kde = &lxb_unicode_decomposition_k_FEF4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEF5[3] = {0x0644, 0x0627, 0x0653};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEF5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FEF5, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEF5[3] = {0x0644, 0x0627, 0x0653};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEF5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FEF5, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEF5[2] = {0x0644, 0x0622};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEF5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FEF5, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FEF5 = {.cp = 0xFEF5, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEF5, .cde = &lxb_unicode_decomposition_c_FEF5, .kde = &lxb_unicode_decomposition_k_FEF5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEF6[3] = {0x0644, 0x0627, 0x0653};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEF6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FEF6, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEF6[3] = {0x0644, 0x0627, 0x0653};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEF6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FEF6, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEF6[2] = {0x0644, 0x0622};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEF6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FEF6, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FEF6 = {.cp = 0xFEF6, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEF6, .cde = &lxb_unicode_decomposition_c_FEF6, .kde = &lxb_unicode_decomposition_k_FEF6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEF7[3] = {0x0644, 0x0627, 0x0654};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEF7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FEF7, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEF7[3] = {0x0644, 0x0627, 0x0654};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEF7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FEF7, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEF7[2] = {0x0644, 0x0623};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEF7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FEF7, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FEF7 = {.cp = 0xFEF7, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEF7, .cde = &lxb_unicode_decomposition_c_FEF7, .kde = &lxb_unicode_decomposition_k_FEF7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEF8[3] = {0x0644, 0x0627, 0x0654};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEF8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FEF8, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEF8[3] = {0x0644, 0x0627, 0x0654};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEF8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FEF8, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEF8[2] = {0x0644, 0x0623};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEF8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FEF8, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FEF8 = {.cp = 0xFEF8, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEF8, .cde = &lxb_unicode_decomposition_c_FEF8, .kde = &lxb_unicode_decomposition_k_FEF8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEF9[3] = {0x0644, 0x0627, 0x0655};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEF9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FEF9, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEF9[3] = {0x0644, 0x0627, 0x0655};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEF9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FEF9, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEF9[2] = {0x0644, 0x0625};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEF9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FEF9, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FEF9 = {.cp = 0xFEF9, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEF9, .cde = &lxb_unicode_decomposition_c_FEF9, .kde = &lxb_unicode_decomposition_k_FEF9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEFA[3] = {0x0644, 0x0627, 0x0655};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEFA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FEFA, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEFA[3] = {0x0644, 0x0627, 0x0655};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEFA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FEFA, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEFA[2] = {0x0644, 0x0625};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEFA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FEFA, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FEFA = {.cp = 0xFEFA, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEFA, .cde = &lxb_unicode_decomposition_c_FEFA, .kde = &lxb_unicode_decomposition_k_FEFA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEFB[2] = {0x0644, 0x0627};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEFB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FEFB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEFB[2] = {0x0644, 0x0627};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEFB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FEFB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEFB[2] = {0x0644, 0x0627};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEFB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FEFB, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FEFB = {.cp = 0xFEFB, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEFB, .cde = &lxb_unicode_decomposition_c_FEFB, .kde = &lxb_unicode_decomposition_k_FEFB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FEFC[2] = {0x0644, 0x0627};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FEFC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FEFC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FEFC[2] = {0x0644, 0x0627};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FEFC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FEFC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FEFC[2] = {0x0644, 0x0627};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FEFC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FEFC, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FEFC = {.cp = 0xFEFC, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FEFC, .cde = &lxb_unicode_decomposition_c_FEFC, .kde = &lxb_unicode_decomposition_k_FEFC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF01[1] = {0x0021};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF01 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF01, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF01[1] = {0x0021};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF01 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF01, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF01[1] = {0x0021};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF01 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF01, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF01 = {.cp = 0xFF01, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF01, .cde = &lxb_unicode_decomposition_c_FF01, .kde = &lxb_unicode_decomposition_k_FF01};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF02[1] = {0x0022};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF02 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF02, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF02[1] = {0x0022};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF02 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF02, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF02[1] = {0x0022};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF02 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF02, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF02 = {.cp = 0xFF02, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF02, .cde = &lxb_unicode_decomposition_c_FF02, .kde = &lxb_unicode_decomposition_k_FF02};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF03[1] = {0x0023};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF03 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF03, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF03[1] = {0x0023};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF03 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF03, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF03[1] = {0x0023};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF03 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF03, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF03 = {.cp = 0xFF03, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF03, .cde = &lxb_unicode_decomposition_c_FF03, .kde = &lxb_unicode_decomposition_k_FF03};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF04[1] = {0x0024};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF04 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF04, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF04[1] = {0x0024};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF04 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF04, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF04[1] = {0x0024};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF04 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF04, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF04 = {.cp = 0xFF04, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF04, .cde = &lxb_unicode_decomposition_c_FF04, .kde = &lxb_unicode_decomposition_k_FF04};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF05[1] = {0x0025};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF05 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF05, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF05[1] = {0x0025};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF05 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF05, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF05[1] = {0x0025};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF05 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF05, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF05 = {.cp = 0xFF05, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF05, .cde = &lxb_unicode_decomposition_c_FF05, .kde = &lxb_unicode_decomposition_k_FF05};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF06[1] = {0x0026};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF06 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF06, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF06[1] = {0x0026};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF06 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF06, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF06[1] = {0x0026};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF06 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF06, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF06 = {.cp = 0xFF06, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF06, .cde = &lxb_unicode_decomposition_c_FF06, .kde = &lxb_unicode_decomposition_k_FF06};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF07[1] = {0x0027};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF07 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF07, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF07[1] = {0x0027};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF07 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF07, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF07[1] = {0x0027};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF07 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF07, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF07 = {.cp = 0xFF07, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF07, .cde = &lxb_unicode_decomposition_c_FF07, .kde = &lxb_unicode_decomposition_k_FF07};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF08[1] = {0x0028};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF08 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF08, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF08[1] = {0x0028};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF08 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF08, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF08[1] = {0x0028};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF08 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF08, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF08 = {.cp = 0xFF08, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF08, .cde = &lxb_unicode_decomposition_c_FF08, .kde = &lxb_unicode_decomposition_k_FF08};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF09[1] = {0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF09 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF09, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF09[1] = {0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF09 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF09, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF09[1] = {0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF09 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF09, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF09 = {.cp = 0xFF09, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF09, .cde = &lxb_unicode_decomposition_c_FF09, .kde = &lxb_unicode_decomposition_k_FF09};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF0A[1] = {0x002A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF0A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF0A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF0A[1] = {0x002A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF0A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF0A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF0A[1] = {0x002A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF0A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF0A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF0A = {.cp = 0xFF0A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF0A, .cde = &lxb_unicode_decomposition_c_FF0A, .kde = &lxb_unicode_decomposition_k_FF0A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF0B[1] = {0x002B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF0B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF0B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF0B[1] = {0x002B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF0B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF0B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF0B[1] = {0x002B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF0B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF0B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF0B = {.cp = 0xFF0B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF0B, .cde = &lxb_unicode_decomposition_c_FF0B, .kde = &lxb_unicode_decomposition_k_FF0B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF0C[1] = {0x002C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF0C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF0C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF0C[1] = {0x002C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF0C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF0C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF0C[1] = {0x002C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF0C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF0C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF0C = {.cp = 0xFF0C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF0C, .cde = &lxb_unicode_decomposition_c_FF0C, .kde = &lxb_unicode_decomposition_k_FF0C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF0D[1] = {0x002D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF0D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF0D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF0D[1] = {0x002D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF0D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF0D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF0D[1] = {0x002D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF0D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF0D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF0D = {.cp = 0xFF0D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF0D, .cde = &lxb_unicode_decomposition_c_FF0D, .kde = &lxb_unicode_decomposition_k_FF0D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF0E[1] = {0x002E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF0E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF0E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF0E[1] = {0x002E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF0E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF0E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF0E[1] = {0x002E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF0E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF0E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF0E = {.cp = 0xFF0E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF0E, .cde = &lxb_unicode_decomposition_c_FF0E, .kde = &lxb_unicode_decomposition_k_FF0E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF0F[1] = {0x002F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF0F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF0F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF0F[1] = {0x002F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF0F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF0F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF0F[1] = {0x002F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF0F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF0F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF0F = {.cp = 0xFF0F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF0F, .cde = &lxb_unicode_decomposition_c_FF0F, .kde = &lxb_unicode_decomposition_k_FF0F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF10[1] = {0x0030};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF10 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF10, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF10[1] = {0x0030};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF10 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF10, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF10[1] = {0x0030};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF10 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF10, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF10 = {.cp = 0xFF10, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF10, .cde = &lxb_unicode_decomposition_c_FF10, .kde = &lxb_unicode_decomposition_k_FF10};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF11[1] = {0x0031};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF11 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF11, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF11[1] = {0x0031};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF11 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF11, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF11[1] = {0x0031};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF11 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF11, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF11 = {.cp = 0xFF11, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF11, .cde = &lxb_unicode_decomposition_c_FF11, .kde = &lxb_unicode_decomposition_k_FF11};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF12[1] = {0x0032};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF12 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF12, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF12[1] = {0x0032};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF12 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF12, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF12[1] = {0x0032};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF12 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF12, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF12 = {.cp = 0xFF12, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF12, .cde = &lxb_unicode_decomposition_c_FF12, .kde = &lxb_unicode_decomposition_k_FF12};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF13[1] = {0x0033};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF13 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF13, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF13[1] = {0x0033};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF13 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF13, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF13[1] = {0x0033};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF13 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF13, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF13 = {.cp = 0xFF13, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF13, .cde = &lxb_unicode_decomposition_c_FF13, .kde = &lxb_unicode_decomposition_k_FF13};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF14[1] = {0x0034};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF14 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF14, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF14[1] = {0x0034};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF14 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF14, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF14[1] = {0x0034};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF14 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF14, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF14 = {.cp = 0xFF14, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF14, .cde = &lxb_unicode_decomposition_c_FF14, .kde = &lxb_unicode_decomposition_k_FF14};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF15[1] = {0x0035};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF15 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF15, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF15[1] = {0x0035};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF15 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF15, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF15[1] = {0x0035};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF15 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF15, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF15 = {.cp = 0xFF15, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF15, .cde = &lxb_unicode_decomposition_c_FF15, .kde = &lxb_unicode_decomposition_k_FF15};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF16[1] = {0x0036};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF16 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF16, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF16[1] = {0x0036};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF16 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF16, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF16[1] = {0x0036};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF16 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF16, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF16 = {.cp = 0xFF16, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF16, .cde = &lxb_unicode_decomposition_c_FF16, .kde = &lxb_unicode_decomposition_k_FF16};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF17[1] = {0x0037};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF17 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF17, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF17[1] = {0x0037};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF17 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF17, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF17[1] = {0x0037};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF17 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF17, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF17 = {.cp = 0xFF17, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF17, .cde = &lxb_unicode_decomposition_c_FF17, .kde = &lxb_unicode_decomposition_k_FF17};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF18[1] = {0x0038};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF18 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF18, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF18[1] = {0x0038};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF18 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF18, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF18[1] = {0x0038};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF18 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF18, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF18 = {.cp = 0xFF18, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF18, .cde = &lxb_unicode_decomposition_c_FF18, .kde = &lxb_unicode_decomposition_k_FF18};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF19[1] = {0x0039};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF19 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF19, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF19[1] = {0x0039};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF19 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF19, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF19[1] = {0x0039};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF19 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF19, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF19 = {.cp = 0xFF19, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF19, .cde = &lxb_unicode_decomposition_c_FF19, .kde = &lxb_unicode_decomposition_k_FF19};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF1A[1] = {0x003A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF1A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF1A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF1A[1] = {0x003A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF1A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF1A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF1A[1] = {0x003A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF1A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF1A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF1A = {.cp = 0xFF1A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF1A, .cde = &lxb_unicode_decomposition_c_FF1A, .kde = &lxb_unicode_decomposition_k_FF1A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF1B[1] = {0x003B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF1B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF1B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF1B[1] = {0x003B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF1B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF1B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF1B[1] = {0x003B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF1B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF1B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF1B = {.cp = 0xFF1B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF1B, .cde = &lxb_unicode_decomposition_c_FF1B, .kde = &lxb_unicode_decomposition_k_FF1B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF1C[1] = {0x003C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF1C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF1C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF1C[1] = {0x003C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF1C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF1C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF1C[1] = {0x003C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF1C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF1C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF1C = {.cp = 0xFF1C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF1C, .cde = &lxb_unicode_decomposition_c_FF1C, .kde = &lxb_unicode_decomposition_k_FF1C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF1D[1] = {0x003D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF1D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF1D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF1D[1] = {0x003D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF1D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF1D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF1D[1] = {0x003D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF1D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF1D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF1D = {.cp = 0xFF1D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF1D, .cde = &lxb_unicode_decomposition_c_FF1D, .kde = &lxb_unicode_decomposition_k_FF1D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF1E[1] = {0x003E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF1E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF1E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF1E[1] = {0x003E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF1E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF1E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF1E[1] = {0x003E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF1E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF1E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF1E = {.cp = 0xFF1E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF1E, .cde = &lxb_unicode_decomposition_c_FF1E, .kde = &lxb_unicode_decomposition_k_FF1E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF1F[1] = {0x003F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF1F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF1F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF1F[1] = {0x003F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF1F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF1F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF1F[1] = {0x003F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF1F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF1F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF1F = {.cp = 0xFF1F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF1F, .cde = &lxb_unicode_decomposition_c_FF1F, .kde = &lxb_unicode_decomposition_k_FF1F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF20[1] = {0x0040};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF20 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF20, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF20[1] = {0x0040};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF20 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF20, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF20[1] = {0x0040};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF20 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF20, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF20 = {.cp = 0xFF20, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF20, .cde = &lxb_unicode_decomposition_c_FF20, .kde = &lxb_unicode_decomposition_k_FF20};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF21[1] = {0x0041};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF21 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF21, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF21[1] = {0x0041};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF21 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF21, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF21[1] = {0x0041};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF21 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF21, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF21 = {.cp = 0xFF21, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF21, .cde = &lxb_unicode_decomposition_c_FF21, .kde = &lxb_unicode_decomposition_k_FF21};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF22[1] = {0x0042};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF22 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF22, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF22[1] = {0x0042};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF22 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF22, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF22[1] = {0x0042};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF22 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF22, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF22 = {.cp = 0xFF22, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF22, .cde = &lxb_unicode_decomposition_c_FF22, .kde = &lxb_unicode_decomposition_k_FF22};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF23[1] = {0x0043};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF23 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF23, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF23[1] = {0x0043};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF23 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF23, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF23[1] = {0x0043};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF23 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF23, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF23 = {.cp = 0xFF23, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF23, .cde = &lxb_unicode_decomposition_c_FF23, .kde = &lxb_unicode_decomposition_k_FF23};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF24[1] = {0x0044};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF24 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF24, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF24[1] = {0x0044};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF24 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF24, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF24[1] = {0x0044};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF24 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF24, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF24 = {.cp = 0xFF24, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF24, .cde = &lxb_unicode_decomposition_c_FF24, .kde = &lxb_unicode_decomposition_k_FF24};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF25[1] = {0x0045};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF25 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF25, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF25[1] = {0x0045};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF25 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF25, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF25[1] = {0x0045};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF25 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF25, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF25 = {.cp = 0xFF25, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF25, .cde = &lxb_unicode_decomposition_c_FF25, .kde = &lxb_unicode_decomposition_k_FF25};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF26[1] = {0x0046};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF26 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF26, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF26[1] = {0x0046};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF26 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF26, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF26[1] = {0x0046};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF26 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF26, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF26 = {.cp = 0xFF26, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF26, .cde = &lxb_unicode_decomposition_c_FF26, .kde = &lxb_unicode_decomposition_k_FF26};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF27[1] = {0x0047};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF27 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF27, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF27[1] = {0x0047};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF27 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF27, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF27[1] = {0x0047};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF27 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF27, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF27 = {.cp = 0xFF27, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF27, .cde = &lxb_unicode_decomposition_c_FF27, .kde = &lxb_unicode_decomposition_k_FF27};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF28[1] = {0x0048};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF28 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF28, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF28[1] = {0x0048};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF28 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF28, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF28[1] = {0x0048};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF28 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF28, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF28 = {.cp = 0xFF28, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF28, .cde = &lxb_unicode_decomposition_c_FF28, .kde = &lxb_unicode_decomposition_k_FF28};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF29[1] = {0x0049};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF29 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF29, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF29[1] = {0x0049};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF29 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF29, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF29[1] = {0x0049};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF29 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF29, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF29 = {.cp = 0xFF29, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF29, .cde = &lxb_unicode_decomposition_c_FF29, .kde = &lxb_unicode_decomposition_k_FF29};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF2A[1] = {0x004A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF2A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF2A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF2A[1] = {0x004A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF2A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF2A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF2A[1] = {0x004A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF2A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF2A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF2A = {.cp = 0xFF2A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF2A, .cde = &lxb_unicode_decomposition_c_FF2A, .kde = &lxb_unicode_decomposition_k_FF2A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF2B[1] = {0x004B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF2B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF2B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF2B[1] = {0x004B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF2B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF2B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF2B[1] = {0x004B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF2B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF2B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF2B = {.cp = 0xFF2B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF2B, .cde = &lxb_unicode_decomposition_c_FF2B, .kde = &lxb_unicode_decomposition_k_FF2B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF2C[1] = {0x004C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF2C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF2C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF2C[1] = {0x004C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF2C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF2C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF2C[1] = {0x004C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF2C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF2C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF2C = {.cp = 0xFF2C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF2C, .cde = &lxb_unicode_decomposition_c_FF2C, .kde = &lxb_unicode_decomposition_k_FF2C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF2D[1] = {0x004D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF2D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF2D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF2D[1] = {0x004D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF2D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF2D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF2D[1] = {0x004D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF2D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF2D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF2D = {.cp = 0xFF2D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF2D, .cde = &lxb_unicode_decomposition_c_FF2D, .kde = &lxb_unicode_decomposition_k_FF2D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF2E[1] = {0x004E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF2E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF2E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF2E[1] = {0x004E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF2E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF2E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF2E[1] = {0x004E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF2E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF2E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF2E = {.cp = 0xFF2E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF2E, .cde = &lxb_unicode_decomposition_c_FF2E, .kde = &lxb_unicode_decomposition_k_FF2E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF2F[1] = {0x004F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF2F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF2F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF2F[1] = {0x004F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF2F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF2F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF2F[1] = {0x004F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF2F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF2F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF2F = {.cp = 0xFF2F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF2F, .cde = &lxb_unicode_decomposition_c_FF2F, .kde = &lxb_unicode_decomposition_k_FF2F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF30[1] = {0x0050};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF30 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF30, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF30[1] = {0x0050};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF30 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF30, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF30[1] = {0x0050};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF30 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF30, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF30 = {.cp = 0xFF30, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF30, .cde = &lxb_unicode_decomposition_c_FF30, .kde = &lxb_unicode_decomposition_k_FF30};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF31[1] = {0x0051};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF31 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF31, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF31[1] = {0x0051};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF31 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF31, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF31[1] = {0x0051};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF31 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF31, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF31 = {.cp = 0xFF31, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF31, .cde = &lxb_unicode_decomposition_c_FF31, .kde = &lxb_unicode_decomposition_k_FF31};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF32[1] = {0x0052};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF32 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF32, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF32[1] = {0x0052};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF32 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF32, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF32[1] = {0x0052};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF32 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF32, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF32 = {.cp = 0xFF32, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF32, .cde = &lxb_unicode_decomposition_c_FF32, .kde = &lxb_unicode_decomposition_k_FF32};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF33[1] = {0x0053};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF33 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF33, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF33[1] = {0x0053};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF33 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF33, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF33[1] = {0x0053};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF33 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF33, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF33 = {.cp = 0xFF33, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF33, .cde = &lxb_unicode_decomposition_c_FF33, .kde = &lxb_unicode_decomposition_k_FF33};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF34[1] = {0x0054};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF34 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF34, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF34[1] = {0x0054};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF34 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF34, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF34[1] = {0x0054};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF34 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF34, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF34 = {.cp = 0xFF34, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF34, .cde = &lxb_unicode_decomposition_c_FF34, .kde = &lxb_unicode_decomposition_k_FF34};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF35[1] = {0x0055};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF35 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF35, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF35[1] = {0x0055};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF35 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF35, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF35[1] = {0x0055};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF35 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF35, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF35 = {.cp = 0xFF35, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF35, .cde = &lxb_unicode_decomposition_c_FF35, .kde = &lxb_unicode_decomposition_k_FF35};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF36[1] = {0x0056};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF36 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF36, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF36[1] = {0x0056};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF36 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF36, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF36[1] = {0x0056};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF36 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF36, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF36 = {.cp = 0xFF36, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF36, .cde = &lxb_unicode_decomposition_c_FF36, .kde = &lxb_unicode_decomposition_k_FF36};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF37[1] = {0x0057};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF37 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF37, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF37[1] = {0x0057};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF37 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF37, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF37[1] = {0x0057};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF37 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF37, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF37 = {.cp = 0xFF37, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF37, .cde = &lxb_unicode_decomposition_c_FF37, .kde = &lxb_unicode_decomposition_k_FF37};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF38[1] = {0x0058};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF38 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF38, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF38[1] = {0x0058};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF38 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF38, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF38[1] = {0x0058};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF38 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF38, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF38 = {.cp = 0xFF38, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF38, .cde = &lxb_unicode_decomposition_c_FF38, .kde = &lxb_unicode_decomposition_k_FF38};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF39[1] = {0x0059};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF39 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF39, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF39[1] = {0x0059};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF39 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF39, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF39[1] = {0x0059};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF39 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF39, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF39 = {.cp = 0xFF39, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF39, .cde = &lxb_unicode_decomposition_c_FF39, .kde = &lxb_unicode_decomposition_k_FF39};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF3A[1] = {0x005A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF3A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF3A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF3A[1] = {0x005A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF3A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF3A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF3A[1] = {0x005A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF3A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF3A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF3A = {.cp = 0xFF3A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF3A, .cde = &lxb_unicode_decomposition_c_FF3A, .kde = &lxb_unicode_decomposition_k_FF3A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF3B[1] = {0x005B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF3B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF3B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF3B[1] = {0x005B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF3B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF3B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF3B[1] = {0x005B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF3B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF3B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF3B = {.cp = 0xFF3B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF3B, .cde = &lxb_unicode_decomposition_c_FF3B, .kde = &lxb_unicode_decomposition_k_FF3B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF3C[1] = {0x005C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF3C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF3C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF3C[1] = {0x005C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF3C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF3C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF3C[1] = {0x005C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF3C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF3C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF3C = {.cp = 0xFF3C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF3C, .cde = &lxb_unicode_decomposition_c_FF3C, .kde = &lxb_unicode_decomposition_k_FF3C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF3D[1] = {0x005D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF3D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF3D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF3D[1] = {0x005D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF3D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF3D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF3D[1] = {0x005D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF3D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF3D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF3D = {.cp = 0xFF3D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF3D, .cde = &lxb_unicode_decomposition_c_FF3D, .kde = &lxb_unicode_decomposition_k_FF3D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF3E[1] = {0x005E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF3E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF3E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF3E[1] = {0x005E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF3E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF3E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF3E[1] = {0x005E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF3E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF3E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF3E = {.cp = 0xFF3E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF3E, .cde = &lxb_unicode_decomposition_c_FF3E, .kde = &lxb_unicode_decomposition_k_FF3E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF3F[1] = {0x005F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF3F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF3F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF3F[1] = {0x005F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF3F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF3F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF3F[1] = {0x005F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF3F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF3F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF3F = {.cp = 0xFF3F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF3F, .cde = &lxb_unicode_decomposition_c_FF3F, .kde = &lxb_unicode_decomposition_k_FF3F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF40[1] = {0x0060};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF40 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF40, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF40[1] = {0x0060};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF40 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF40, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF40[1] = {0x0060};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF40 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF40, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF40 = {.cp = 0xFF40, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF40, .cde = &lxb_unicode_decomposition_c_FF40, .kde = &lxb_unicode_decomposition_k_FF40};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF41[1] = {0x0061};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF41 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF41, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF41[1] = {0x0061};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF41 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF41, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF41[1] = {0x0061};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF41 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF41, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF41 = {.cp = 0xFF41, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF41, .cde = &lxb_unicode_decomposition_c_FF41, .kde = &lxb_unicode_decomposition_k_FF41};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF42[1] = {0x0062};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF42 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF42, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF42[1] = {0x0062};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF42 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF42, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF42[1] = {0x0062};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF42 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF42, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF42 = {.cp = 0xFF42, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF42, .cde = &lxb_unicode_decomposition_c_FF42, .kde = &lxb_unicode_decomposition_k_FF42};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF43[1] = {0x0063};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF43 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF43, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF43[1] = {0x0063};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF43 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF43, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF43[1] = {0x0063};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF43 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF43, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF43 = {.cp = 0xFF43, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF43, .cde = &lxb_unicode_decomposition_c_FF43, .kde = &lxb_unicode_decomposition_k_FF43};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF44[1] = {0x0064};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF44 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF44, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF44[1] = {0x0064};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF44 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF44, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF44[1] = {0x0064};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF44 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF44, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF44 = {.cp = 0xFF44, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF44, .cde = &lxb_unicode_decomposition_c_FF44, .kde = &lxb_unicode_decomposition_k_FF44};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF45[1] = {0x0065};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF45 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF45, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF45[1] = {0x0065};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF45 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF45, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF45[1] = {0x0065};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF45 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF45, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF45 = {.cp = 0xFF45, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF45, .cde = &lxb_unicode_decomposition_c_FF45, .kde = &lxb_unicode_decomposition_k_FF45};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF46[1] = {0x0066};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF46 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF46, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF46[1] = {0x0066};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF46 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF46, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF46[1] = {0x0066};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF46 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF46, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF46 = {.cp = 0xFF46, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF46, .cde = &lxb_unicode_decomposition_c_FF46, .kde = &lxb_unicode_decomposition_k_FF46};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF47[1] = {0x0067};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF47 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF47, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF47[1] = {0x0067};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF47 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF47, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF47[1] = {0x0067};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF47 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF47, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF47 = {.cp = 0xFF47, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF47, .cde = &lxb_unicode_decomposition_c_FF47, .kde = &lxb_unicode_decomposition_k_FF47};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF48[1] = {0x0068};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF48 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF48, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF48[1] = {0x0068};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF48 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF48, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF48[1] = {0x0068};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF48 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF48, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF48 = {.cp = 0xFF48, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF48, .cde = &lxb_unicode_decomposition_c_FF48, .kde = &lxb_unicode_decomposition_k_FF48};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF49[1] = {0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF49 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF49, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF49[1] = {0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF49 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF49, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF49[1] = {0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF49 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF49, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF49 = {.cp = 0xFF49, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF49, .cde = &lxb_unicode_decomposition_c_FF49, .kde = &lxb_unicode_decomposition_k_FF49};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF4A[1] = {0x006A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF4A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF4A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF4A[1] = {0x006A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF4A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF4A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF4A[1] = {0x006A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF4A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF4A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF4A = {.cp = 0xFF4A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF4A, .cde = &lxb_unicode_decomposition_c_FF4A, .kde = &lxb_unicode_decomposition_k_FF4A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF4B[1] = {0x006B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF4B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF4B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF4B[1] = {0x006B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF4B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF4B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF4B[1] = {0x006B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF4B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF4B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF4B = {.cp = 0xFF4B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF4B, .cde = &lxb_unicode_decomposition_c_FF4B, .kde = &lxb_unicode_decomposition_k_FF4B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF4C[1] = {0x006C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF4C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF4C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF4C[1] = {0x006C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF4C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF4C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF4C[1] = {0x006C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF4C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF4C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF4C = {.cp = 0xFF4C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF4C, .cde = &lxb_unicode_decomposition_c_FF4C, .kde = &lxb_unicode_decomposition_k_FF4C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF4D[1] = {0x006D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF4D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF4D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF4D[1] = {0x006D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF4D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF4D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF4D[1] = {0x006D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF4D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF4D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF4D = {.cp = 0xFF4D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF4D, .cde = &lxb_unicode_decomposition_c_FF4D, .kde = &lxb_unicode_decomposition_k_FF4D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF4E[1] = {0x006E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF4E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF4E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF4E[1] = {0x006E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF4E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF4E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF4E[1] = {0x006E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF4E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF4E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF4E = {.cp = 0xFF4E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF4E, .cde = &lxb_unicode_decomposition_c_FF4E, .kde = &lxb_unicode_decomposition_k_FF4E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF4F[1] = {0x006F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF4F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF4F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF4F[1] = {0x006F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF4F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF4F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF4F[1] = {0x006F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF4F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF4F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF4F = {.cp = 0xFF4F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF4F, .cde = &lxb_unicode_decomposition_c_FF4F, .kde = &lxb_unicode_decomposition_k_FF4F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF50[1] = {0x0070};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF50 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF50, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF50[1] = {0x0070};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF50 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF50, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF50[1] = {0x0070};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF50 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF50, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF50 = {.cp = 0xFF50, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF50, .cde = &lxb_unicode_decomposition_c_FF50, .kde = &lxb_unicode_decomposition_k_FF50};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF51[1] = {0x0071};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF51 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF51, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF51[1] = {0x0071};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF51 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF51, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF51[1] = {0x0071};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF51 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF51, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF51 = {.cp = 0xFF51, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF51, .cde = &lxb_unicode_decomposition_c_FF51, .kde = &lxb_unicode_decomposition_k_FF51};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF52[1] = {0x0072};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF52 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF52, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF52[1] = {0x0072};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF52 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF52, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF52[1] = {0x0072};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF52 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF52, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF52 = {.cp = 0xFF52, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF52, .cde = &lxb_unicode_decomposition_c_FF52, .kde = &lxb_unicode_decomposition_k_FF52};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF53[1] = {0x0073};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF53 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF53, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF53[1] = {0x0073};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF53 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF53, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF53[1] = {0x0073};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF53 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF53, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF53 = {.cp = 0xFF53, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF53, .cde = &lxb_unicode_decomposition_c_FF53, .kde = &lxb_unicode_decomposition_k_FF53};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF54[1] = {0x0074};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF54 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF54, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF54[1] = {0x0074};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF54 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF54, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF54[1] = {0x0074};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF54 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF54, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF54 = {.cp = 0xFF54, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF54, .cde = &lxb_unicode_decomposition_c_FF54, .kde = &lxb_unicode_decomposition_k_FF54};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF55[1] = {0x0075};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF55 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF55, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF55[1] = {0x0075};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF55 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF55, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF55[1] = {0x0075};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF55 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF55, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF55 = {.cp = 0xFF55, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF55, .cde = &lxb_unicode_decomposition_c_FF55, .kde = &lxb_unicode_decomposition_k_FF55};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF56[1] = {0x0076};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF56 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF56, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF56[1] = {0x0076};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF56 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF56, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF56[1] = {0x0076};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF56 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF56, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF56 = {.cp = 0xFF56, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF56, .cde = &lxb_unicode_decomposition_c_FF56, .kde = &lxb_unicode_decomposition_k_FF56};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF57[1] = {0x0077};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF57 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF57, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF57[1] = {0x0077};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF57 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF57, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF57[1] = {0x0077};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF57 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF57, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF57 = {.cp = 0xFF57, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF57, .cde = &lxb_unicode_decomposition_c_FF57, .kde = &lxb_unicode_decomposition_k_FF57};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF58[1] = {0x0078};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF58 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF58, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF58[1] = {0x0078};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF58 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF58, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF58[1] = {0x0078};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF58 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF58, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF58 = {.cp = 0xFF58, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF58, .cde = &lxb_unicode_decomposition_c_FF58, .kde = &lxb_unicode_decomposition_k_FF58};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF59[1] = {0x0079};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF59 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF59, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF59[1] = {0x0079};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF59 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF59, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF59[1] = {0x0079};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF59 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF59, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF59 = {.cp = 0xFF59, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF59, .cde = &lxb_unicode_decomposition_c_FF59, .kde = &lxb_unicode_decomposition_k_FF59};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF5A[1] = {0x007A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF5A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF5A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF5A[1] = {0x007A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF5A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF5A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF5A[1] = {0x007A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF5A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF5A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF5A = {.cp = 0xFF5A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF5A, .cde = &lxb_unicode_decomposition_c_FF5A, .kde = &lxb_unicode_decomposition_k_FF5A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF5B[1] = {0x007B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF5B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF5B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF5B[1] = {0x007B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF5B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF5B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF5B[1] = {0x007B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF5B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF5B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF5B = {.cp = 0xFF5B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF5B, .cde = &lxb_unicode_decomposition_c_FF5B, .kde = &lxb_unicode_decomposition_k_FF5B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF5C[1] = {0x007C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF5C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF5C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF5C[1] = {0x007C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF5C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF5C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF5C[1] = {0x007C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF5C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF5C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF5C = {.cp = 0xFF5C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF5C, .cde = &lxb_unicode_decomposition_c_FF5C, .kde = &lxb_unicode_decomposition_k_FF5C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF5D[1] = {0x007D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF5D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF5D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF5D[1] = {0x007D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF5D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF5D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF5D[1] = {0x007D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF5D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF5D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF5D = {.cp = 0xFF5D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF5D, .cde = &lxb_unicode_decomposition_c_FF5D, .kde = &lxb_unicode_decomposition_k_FF5D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF5E[1] = {0x007E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF5E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF5E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF5E[1] = {0x007E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF5E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF5E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF5E[1] = {0x007E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF5E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF5E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF5E = {.cp = 0xFF5E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF5E, .cde = &lxb_unicode_decomposition_c_FF5E, .kde = &lxb_unicode_decomposition_k_FF5E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF5F[1] = {0x2985};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF5F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF5F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF5F[1] = {0x2985};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF5F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF5F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF5F[1] = {0x2985};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF5F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF5F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF5F = {.cp = 0xFF5F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF5F, .cde = &lxb_unicode_decomposition_c_FF5F, .kde = &lxb_unicode_decomposition_k_FF5F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF60[1] = {0x2986};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF60 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FF60, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF60[1] = {0x2986};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF60 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FF60, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF60[1] = {0x2986};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF60 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FF60, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF60 = {.cp = 0xFF60, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF60, .cde = &lxb_unicode_decomposition_c_FF60, .kde = &lxb_unicode_decomposition_k_FF60};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF61[1] = {0x3002};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF61 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF61, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF61[1] = {0x3002};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF61 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF61, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF61[1] = {0x3002};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF61 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF61, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF61 = {.cp = 0xFF61, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF61, .cde = &lxb_unicode_decomposition_c_FF61, .kde = &lxb_unicode_decomposition_k_FF61};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF62[1] = {0x300C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF62 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF62, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF62[1] = {0x300C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF62 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF62, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF62[1] = {0x300C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF62 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF62, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF62 = {.cp = 0xFF62, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF62, .cde = &lxb_unicode_decomposition_c_FF62, .kde = &lxb_unicode_decomposition_k_FF62};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF63[1] = {0x300D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF63 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF63, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF63[1] = {0x300D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF63 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF63, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF63[1] = {0x300D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF63 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF63, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF63 = {.cp = 0xFF63, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF63, .cde = &lxb_unicode_decomposition_c_FF63, .kde = &lxb_unicode_decomposition_k_FF63};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF64[1] = {0x3001};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF64 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF64, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF64[1] = {0x3001};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF64 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF64, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF64[1] = {0x3001};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF64 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF64, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF64 = {.cp = 0xFF64, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF64, .cde = &lxb_unicode_decomposition_c_FF64, .kde = &lxb_unicode_decomposition_k_FF64};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF65[1] = {0x30FB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF65 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF65, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF65[1] = {0x30FB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF65 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF65, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF65[1] = {0x30FB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF65 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF65, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF65 = {.cp = 0xFF65, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF65, .cde = &lxb_unicode_decomposition_c_FF65, .kde = &lxb_unicode_decomposition_k_FF65};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF66[1] = {0x30F2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF66 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF66, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF66[1] = {0x30F2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF66 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF66, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF66[1] = {0x30F2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF66 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF66, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF66 = {.cp = 0xFF66, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF66, .cde = &lxb_unicode_decomposition_c_FF66, .kde = &lxb_unicode_decomposition_k_FF66};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF67[1] = {0x30A1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF67 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF67, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF67[1] = {0x30A1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF67 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF67, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF67[1] = {0x30A1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF67 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF67, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF67 = {.cp = 0xFF67, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF67, .cde = &lxb_unicode_decomposition_c_FF67, .kde = &lxb_unicode_decomposition_k_FF67};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF68[1] = {0x30A3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF68 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF68, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF68[1] = {0x30A3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF68 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF68, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF68[1] = {0x30A3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF68 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF68, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF68 = {.cp = 0xFF68, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF68, .cde = &lxb_unicode_decomposition_c_FF68, .kde = &lxb_unicode_decomposition_k_FF68};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF69[1] = {0x30A5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF69 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF69, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF69[1] = {0x30A5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF69 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF69, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF69[1] = {0x30A5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF69 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF69, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF69 = {.cp = 0xFF69, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF69, .cde = &lxb_unicode_decomposition_c_FF69, .kde = &lxb_unicode_decomposition_k_FF69};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF6A[1] = {0x30A7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF6A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF6A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF6A[1] = {0x30A7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF6A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF6A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF6A[1] = {0x30A7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF6A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF6A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF6A = {.cp = 0xFF6A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF6A, .cde = &lxb_unicode_decomposition_c_FF6A, .kde = &lxb_unicode_decomposition_k_FF6A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF6B[1] = {0x30A9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF6B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF6B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF6B[1] = {0x30A9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF6B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF6B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF6B[1] = {0x30A9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF6B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF6B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF6B = {.cp = 0xFF6B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF6B, .cde = &lxb_unicode_decomposition_c_FF6B, .kde = &lxb_unicode_decomposition_k_FF6B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF6C[1] = {0x30E3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF6C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF6C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF6C[1] = {0x30E3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF6C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF6C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF6C[1] = {0x30E3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF6C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF6C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF6C = {.cp = 0xFF6C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF6C, .cde = &lxb_unicode_decomposition_c_FF6C, .kde = &lxb_unicode_decomposition_k_FF6C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF6D[1] = {0x30E5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF6D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF6D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF6D[1] = {0x30E5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF6D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF6D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF6D[1] = {0x30E5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF6D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF6D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF6D = {.cp = 0xFF6D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF6D, .cde = &lxb_unicode_decomposition_c_FF6D, .kde = &lxb_unicode_decomposition_k_FF6D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF6E[1] = {0x30E7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF6E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF6E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF6E[1] = {0x30E7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF6E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF6E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF6E[1] = {0x30E7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF6E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF6E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF6E = {.cp = 0xFF6E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF6E, .cde = &lxb_unicode_decomposition_c_FF6E, .kde = &lxb_unicode_decomposition_k_FF6E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF6F[1] = {0x30C3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF6F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF6F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF6F[1] = {0x30C3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF6F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF6F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF6F[1] = {0x30C3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF6F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF6F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF6F = {.cp = 0xFF6F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF6F, .cde = &lxb_unicode_decomposition_c_FF6F, .kde = &lxb_unicode_decomposition_k_FF6F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF70[1] = {0x30FC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF70 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF70, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF70[1] = {0x30FC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF70 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF70, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF70[1] = {0x30FC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF70 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF70, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF70 = {.cp = 0xFF70, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF70, .cde = &lxb_unicode_decomposition_c_FF70, .kde = &lxb_unicode_decomposition_k_FF70};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF71[1] = {0x30A2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF71 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF71, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF71[1] = {0x30A2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF71 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF71, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF71[1] = {0x30A2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF71 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF71, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF71 = {.cp = 0xFF71, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF71, .cde = &lxb_unicode_decomposition_c_FF71, .kde = &lxb_unicode_decomposition_k_FF71};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF72[1] = {0x30A4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF72 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF72, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF72[1] = {0x30A4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF72 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF72, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF72[1] = {0x30A4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF72 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF72, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF72 = {.cp = 0xFF72, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF72, .cde = &lxb_unicode_decomposition_c_FF72, .kde = &lxb_unicode_decomposition_k_FF72};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF73[1] = {0x30A6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF73 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF73, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF73[1] = {0x30A6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF73 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF73, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF73[1] = {0x30A6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF73 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF73, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF73 = {.cp = 0xFF73, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF73, .cde = &lxb_unicode_decomposition_c_FF73, .kde = &lxb_unicode_decomposition_k_FF73};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF74[1] = {0x30A8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF74 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF74, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF74[1] = {0x30A8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF74 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF74, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF74[1] = {0x30A8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF74 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF74, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF74 = {.cp = 0xFF74, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF74, .cde = &lxb_unicode_decomposition_c_FF74, .kde = &lxb_unicode_decomposition_k_FF74};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF75[1] = {0x30AA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF75 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF75, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF75[1] = {0x30AA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF75 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF75, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF75[1] = {0x30AA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF75 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF75, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF75 = {.cp = 0xFF75, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF75, .cde = &lxb_unicode_decomposition_c_FF75, .kde = &lxb_unicode_decomposition_k_FF75};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF76[1] = {0x30AB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF76 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF76, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF76[1] = {0x30AB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF76 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF76, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF76[1] = {0x30AB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF76 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF76, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF76 = {.cp = 0xFF76, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF76, .cde = &lxb_unicode_decomposition_c_FF76, .kde = &lxb_unicode_decomposition_k_FF76};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF77[1] = {0x30AD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF77 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF77, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF77[1] = {0x30AD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF77 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF77, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF77[1] = {0x30AD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF77 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF77, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF77 = {.cp = 0xFF77, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF77, .cde = &lxb_unicode_decomposition_c_FF77, .kde = &lxb_unicode_decomposition_k_FF77};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF78[1] = {0x30AF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF78 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF78, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF78[1] = {0x30AF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF78 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF78, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF78[1] = {0x30AF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF78 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF78, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF78 = {.cp = 0xFF78, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF78, .cde = &lxb_unicode_decomposition_c_FF78, .kde = &lxb_unicode_decomposition_k_FF78};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF79[1] = {0x30B1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF79 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF79, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF79[1] = {0x30B1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF79 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF79, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF79[1] = {0x30B1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF79 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF79, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF79 = {.cp = 0xFF79, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF79, .cde = &lxb_unicode_decomposition_c_FF79, .kde = &lxb_unicode_decomposition_k_FF79};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF7A[1] = {0x30B3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF7A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF7A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF7A[1] = {0x30B3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF7A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF7A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF7A[1] = {0x30B3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF7A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF7A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF7A = {.cp = 0xFF7A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF7A, .cde = &lxb_unicode_decomposition_c_FF7A, .kde = &lxb_unicode_decomposition_k_FF7A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF7B[1] = {0x30B5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF7B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF7B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF7B[1] = {0x30B5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF7B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF7B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF7B[1] = {0x30B5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF7B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF7B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF7B = {.cp = 0xFF7B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF7B, .cde = &lxb_unicode_decomposition_c_FF7B, .kde = &lxb_unicode_decomposition_k_FF7B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF7C[1] = {0x30B7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF7C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF7C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF7C[1] = {0x30B7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF7C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF7C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF7C[1] = {0x30B7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF7C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF7C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF7C = {.cp = 0xFF7C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF7C, .cde = &lxb_unicode_decomposition_c_FF7C, .kde = &lxb_unicode_decomposition_k_FF7C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF7D[1] = {0x30B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF7D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF7D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF7D[1] = {0x30B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF7D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF7D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF7D[1] = {0x30B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF7D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF7D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF7D = {.cp = 0xFF7D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF7D, .cde = &lxb_unicode_decomposition_c_FF7D, .kde = &lxb_unicode_decomposition_k_FF7D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF7E[1] = {0x30BB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF7E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF7E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF7E[1] = {0x30BB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF7E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF7E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF7E[1] = {0x30BB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF7E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF7E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF7E = {.cp = 0xFF7E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF7E, .cde = &lxb_unicode_decomposition_c_FF7E, .kde = &lxb_unicode_decomposition_k_FF7E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF7F[1] = {0x30BD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF7F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF7F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF7F[1] = {0x30BD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF7F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF7F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF7F[1] = {0x30BD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF7F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF7F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF7F = {.cp = 0xFF7F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF7F, .cde = &lxb_unicode_decomposition_c_FF7F, .kde = &lxb_unicode_decomposition_k_FF7F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF80[1] = {0x30BF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF80 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF80, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF80[1] = {0x30BF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF80 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF80, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF80[1] = {0x30BF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF80 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF80, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF80 = {.cp = 0xFF80, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF80, .cde = &lxb_unicode_decomposition_c_FF80, .kde = &lxb_unicode_decomposition_k_FF80};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF81[1] = {0x30C1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF81 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF81, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF81[1] = {0x30C1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF81 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF81, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF81[1] = {0x30C1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF81 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF81, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF81 = {.cp = 0xFF81, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF81, .cde = &lxb_unicode_decomposition_c_FF81, .kde = &lxb_unicode_decomposition_k_FF81};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF82[1] = {0x30C4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF82 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF82, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF82[1] = {0x30C4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF82 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF82, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF82[1] = {0x30C4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF82 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF82, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF82 = {.cp = 0xFF82, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF82, .cde = &lxb_unicode_decomposition_c_FF82, .kde = &lxb_unicode_decomposition_k_FF82};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF83[1] = {0x30C6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF83 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF83, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF83[1] = {0x30C6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF83 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF83, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF83[1] = {0x30C6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF83 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF83, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF83 = {.cp = 0xFF83, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF83, .cde = &lxb_unicode_decomposition_c_FF83, .kde = &lxb_unicode_decomposition_k_FF83};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF84[1] = {0x30C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF84 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF84, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF84[1] = {0x30C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF84 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF84, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF84[1] = {0x30C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF84 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF84, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF84 = {.cp = 0xFF84, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF84, .cde = &lxb_unicode_decomposition_c_FF84, .kde = &lxb_unicode_decomposition_k_FF84};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF85[1] = {0x30CA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF85 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF85, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF85[1] = {0x30CA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF85 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF85, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF85[1] = {0x30CA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF85 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF85, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF85 = {.cp = 0xFF85, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF85, .cde = &lxb_unicode_decomposition_c_FF85, .kde = &lxb_unicode_decomposition_k_FF85};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF86[1] = {0x30CB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF86 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF86, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF86[1] = {0x30CB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF86 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF86, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF86[1] = {0x30CB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF86 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF86, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF86 = {.cp = 0xFF86, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF86, .cde = &lxb_unicode_decomposition_c_FF86, .kde = &lxb_unicode_decomposition_k_FF86};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF87[1] = {0x30CC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF87 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF87, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF87[1] = {0x30CC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF87 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF87, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF87[1] = {0x30CC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF87 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF87, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF87 = {.cp = 0xFF87, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF87, .cde = &lxb_unicode_decomposition_c_FF87, .kde = &lxb_unicode_decomposition_k_FF87};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF88[1] = {0x30CD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF88 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF88, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF88[1] = {0x30CD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF88 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF88, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF88[1] = {0x30CD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF88 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF88, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF88 = {.cp = 0xFF88, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF88, .cde = &lxb_unicode_decomposition_c_FF88, .kde = &lxb_unicode_decomposition_k_FF88};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF89[1] = {0x30CE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF89 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF89, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF89[1] = {0x30CE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF89 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF89, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF89[1] = {0x30CE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF89 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF89, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF89 = {.cp = 0xFF89, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF89, .cde = &lxb_unicode_decomposition_c_FF89, .kde = &lxb_unicode_decomposition_k_FF89};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF8A[1] = {0x30CF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF8A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF8A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF8A[1] = {0x30CF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF8A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF8A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF8A[1] = {0x30CF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF8A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF8A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF8A = {.cp = 0xFF8A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF8A, .cde = &lxb_unicode_decomposition_c_FF8A, .kde = &lxb_unicode_decomposition_k_FF8A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF8B[1] = {0x30D2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF8B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF8B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF8B[1] = {0x30D2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF8B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF8B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF8B[1] = {0x30D2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF8B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF8B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF8B = {.cp = 0xFF8B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF8B, .cde = &lxb_unicode_decomposition_c_FF8B, .kde = &lxb_unicode_decomposition_k_FF8B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF8C[1] = {0x30D5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF8C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF8C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF8C[1] = {0x30D5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF8C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF8C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF8C[1] = {0x30D5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF8C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF8C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF8C = {.cp = 0xFF8C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF8C, .cde = &lxb_unicode_decomposition_c_FF8C, .kde = &lxb_unicode_decomposition_k_FF8C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF8D[1] = {0x30D8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF8D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF8D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF8D[1] = {0x30D8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF8D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF8D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF8D[1] = {0x30D8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF8D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF8D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF8D = {.cp = 0xFF8D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF8D, .cde = &lxb_unicode_decomposition_c_FF8D, .kde = &lxb_unicode_decomposition_k_FF8D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF8E[1] = {0x30DB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF8E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF8E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF8E[1] = {0x30DB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF8E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF8E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF8E[1] = {0x30DB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF8E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF8E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF8E = {.cp = 0xFF8E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF8E, .cde = &lxb_unicode_decomposition_c_FF8E, .kde = &lxb_unicode_decomposition_k_FF8E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF8F[1] = {0x30DE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF8F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF8F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF8F[1] = {0x30DE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF8F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF8F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF8F[1] = {0x30DE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF8F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF8F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF8F = {.cp = 0xFF8F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF8F, .cde = &lxb_unicode_decomposition_c_FF8F, .kde = &lxb_unicode_decomposition_k_FF8F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF90[1] = {0x30DF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF90 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF90, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF90[1] = {0x30DF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF90 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF90, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF90[1] = {0x30DF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF90 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF90, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF90 = {.cp = 0xFF90, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF90, .cde = &lxb_unicode_decomposition_c_FF90, .kde = &lxb_unicode_decomposition_k_FF90};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF91[1] = {0x30E0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF91 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF91, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF91[1] = {0x30E0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF91 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF91, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF91[1] = {0x30E0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF91 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF91, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF91 = {.cp = 0xFF91, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF91, .cde = &lxb_unicode_decomposition_c_FF91, .kde = &lxb_unicode_decomposition_k_FF91};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF92[1] = {0x30E1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF92 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF92, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF92[1] = {0x30E1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF92 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF92, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF92[1] = {0x30E1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF92 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF92, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF92 = {.cp = 0xFF92, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF92, .cde = &lxb_unicode_decomposition_c_FF92, .kde = &lxb_unicode_decomposition_k_FF92};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF93[1] = {0x30E2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF93 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF93, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF93[1] = {0x30E2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF93 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF93, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF93[1] = {0x30E2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF93 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF93, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF93 = {.cp = 0xFF93, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF93, .cde = &lxb_unicode_decomposition_c_FF93, .kde = &lxb_unicode_decomposition_k_FF93};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF94[1] = {0x30E4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF94 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF94, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF94[1] = {0x30E4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF94 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF94, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF94[1] = {0x30E4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF94 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF94, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF94 = {.cp = 0xFF94, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF94, .cde = &lxb_unicode_decomposition_c_FF94, .kde = &lxb_unicode_decomposition_k_FF94};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF95[1] = {0x30E6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF95 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF95, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF95[1] = {0x30E6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF95 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF95, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF95[1] = {0x30E6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF95 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF95, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF95 = {.cp = 0xFF95, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF95, .cde = &lxb_unicode_decomposition_c_FF95, .kde = &lxb_unicode_decomposition_k_FF95};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF96[1] = {0x30E8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF96 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF96, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF96[1] = {0x30E8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF96 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF96, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF96[1] = {0x30E8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF96 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF96, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF96 = {.cp = 0xFF96, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF96, .cde = &lxb_unicode_decomposition_c_FF96, .kde = &lxb_unicode_decomposition_k_FF96};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF97[1] = {0x30E9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF97 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF97, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF97[1] = {0x30E9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF97 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF97, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF97[1] = {0x30E9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF97 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF97, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF97 = {.cp = 0xFF97, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF97, .cde = &lxb_unicode_decomposition_c_FF97, .kde = &lxb_unicode_decomposition_k_FF97};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF98[1] = {0x30EA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF98 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF98, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF98[1] = {0x30EA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF98 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF98, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF98[1] = {0x30EA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF98 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF98, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF98 = {.cp = 0xFF98, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF98, .cde = &lxb_unicode_decomposition_c_FF98, .kde = &lxb_unicode_decomposition_k_FF98};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF99[1] = {0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF99 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF99, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF99[1] = {0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF99 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF99, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF99[1] = {0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF99 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF99, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF99 = {.cp = 0xFF99, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF99, .cde = &lxb_unicode_decomposition_c_FF99, .kde = &lxb_unicode_decomposition_k_FF99};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF9A[1] = {0x30EC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF9A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF9A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF9A[1] = {0x30EC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF9A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF9A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF9A[1] = {0x30EC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF9A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF9A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF9A = {.cp = 0xFF9A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF9A, .cde = &lxb_unicode_decomposition_c_FF9A, .kde = &lxb_unicode_decomposition_k_FF9A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF9B[1] = {0x30ED};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF9B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF9B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF9B[1] = {0x30ED};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF9B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF9B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF9B[1] = {0x30ED};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF9B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF9B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF9B = {.cp = 0xFF9B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF9B, .cde = &lxb_unicode_decomposition_c_FF9B, .kde = &lxb_unicode_decomposition_k_FF9B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF9C[1] = {0x30EF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF9C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF9C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF9C[1] = {0x30EF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF9C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF9C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF9C[1] = {0x30EF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF9C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF9C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF9C = {.cp = 0xFF9C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF9C, .cde = &lxb_unicode_decomposition_c_FF9C, .kde = &lxb_unicode_decomposition_k_FF9C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF9D[1] = {0x30F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF9D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF9D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF9D[1] = {0x30F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF9D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF9D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF9D[1] = {0x30F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF9D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF9D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF9D = {.cp = 0xFF9D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF9D, .cde = &lxb_unicode_decomposition_c_FF9D, .kde = &lxb_unicode_decomposition_k_FF9D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF9E[1] = {0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF9E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF9E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF9E[1] = {0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF9E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF9E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF9E[1] = {0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF9E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF9E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF9E = {.cp = 0xFF9E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF9E, .cde = &lxb_unicode_decomposition_c_FF9E, .kde = &lxb_unicode_decomposition_k_FF9E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FF9F[1] = {0x309A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FF9F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FF9F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FF9F[1] = {0x309A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FF9F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FF9F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FF9F[1] = {0x309A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FF9F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FF9F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FF9F = {.cp = 0xFF9F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FF9F, .cde = &lxb_unicode_decomposition_c_FF9F, .kde = &lxb_unicode_decomposition_k_FF9F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFA0[1] = {0x3164};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFA0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFA0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFA0[1] = {0x1160};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFA0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFA0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFA0[1] = {0x3164};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFA0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFA0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFA0 = {.cp = 0xFFA0, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFA0, .cde = &lxb_unicode_decomposition_c_FFA0, .kde = &lxb_unicode_decomposition_k_FFA0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFA1[1] = {0x3131};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFA1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFA1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFA1[1] = {0x1100};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFA1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFA1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFA1[1] = {0x3131};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFA1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFA1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFA1 = {.cp = 0xFFA1, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFA1, .cde = &lxb_unicode_decomposition_c_FFA1, .kde = &lxb_unicode_decomposition_k_FFA1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFA2[1] = {0x3132};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFA2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFA2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFA2[1] = {0x1101};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFA2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFA2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFA2[1] = {0x3132};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFA2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFA2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFA2 = {.cp = 0xFFA2, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFA2, .cde = &lxb_unicode_decomposition_c_FFA2, .kde = &lxb_unicode_decomposition_k_FFA2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFA3[1] = {0x3133};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFA3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFA3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFA3[1] = {0x11AA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFA3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFA3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFA3[1] = {0x3133};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFA3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFA3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFA3 = {.cp = 0xFFA3, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFA3, .cde = &lxb_unicode_decomposition_c_FFA3, .kde = &lxb_unicode_decomposition_k_FFA3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFA4[1] = {0x3134};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFA4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFA4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFA4[1] = {0x1102};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFA4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFA4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFA4[1] = {0x3134};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFA4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFA4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFA4 = {.cp = 0xFFA4, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFA4, .cde = &lxb_unicode_decomposition_c_FFA4, .kde = &lxb_unicode_decomposition_k_FFA4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFA5[1] = {0x3135};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFA5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFA5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFA5[1] = {0x11AC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFA5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFA5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFA5[1] = {0x3135};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFA5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFA5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFA5 = {.cp = 0xFFA5, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFA5, .cde = &lxb_unicode_decomposition_c_FFA5, .kde = &lxb_unicode_decomposition_k_FFA5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFA6[1] = {0x3136};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFA6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFA6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFA6[1] = {0x11AD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFA6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFA6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFA6[1] = {0x3136};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFA6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFA6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFA6 = {.cp = 0xFFA6, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFA6, .cde = &lxb_unicode_decomposition_c_FFA6, .kde = &lxb_unicode_decomposition_k_FFA6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFA7[1] = {0x3137};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFA7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFA7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFA7[1] = {0x1103};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFA7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFA7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFA7[1] = {0x3137};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFA7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFA7, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFA7 = {.cp = 0xFFA7, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFA7, .cde = &lxb_unicode_decomposition_c_FFA7, .kde = &lxb_unicode_decomposition_k_FFA7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFA8[1] = {0x3138};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFA8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFA8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFA8[1] = {0x1104};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFA8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFA8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFA8[1] = {0x3138};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFA8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFA8, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFA8 = {.cp = 0xFFA8, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFA8, .cde = &lxb_unicode_decomposition_c_FFA8, .kde = &lxb_unicode_decomposition_k_FFA8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFA9[1] = {0x3139};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFA9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFA9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFA9[1] = {0x1105};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFA9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFA9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFA9[1] = {0x3139};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFA9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFA9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFA9 = {.cp = 0xFFA9, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFA9, .cde = &lxb_unicode_decomposition_c_FFA9, .kde = &lxb_unicode_decomposition_k_FFA9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFAA[1] = {0x313A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFAA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFAA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFAA[1] = {0x11B0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFAA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFAA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFAA[1] = {0x313A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFAA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFAA, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFAA = {.cp = 0xFFAA, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFAA, .cde = &lxb_unicode_decomposition_c_FFAA, .kde = &lxb_unicode_decomposition_k_FFAA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFAB[1] = {0x313B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFAB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFAB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFAB[1] = {0x11B1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFAB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFAB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFAB[1] = {0x313B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFAB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFAB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFAB = {.cp = 0xFFAB, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFAB, .cde = &lxb_unicode_decomposition_c_FFAB, .kde = &lxb_unicode_decomposition_k_FFAB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFAC[1] = {0x313C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFAC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFAC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFAC[1] = {0x11B2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFAC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFAC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFAC[1] = {0x313C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFAC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFAC, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFAC = {.cp = 0xFFAC, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFAC, .cde = &lxb_unicode_decomposition_c_FFAC, .kde = &lxb_unicode_decomposition_k_FFAC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFAD[1] = {0x313D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFAD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFAD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFAD[1] = {0x11B3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFAD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFAD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFAD[1] = {0x313D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFAD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFAD, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFAD = {.cp = 0xFFAD, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFAD, .cde = &lxb_unicode_decomposition_c_FFAD, .kde = &lxb_unicode_decomposition_k_FFAD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFAE[1] = {0x313E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFAE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFAE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFAE[1] = {0x11B4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFAE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFAE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFAE[1] = {0x313E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFAE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFAE, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFAE = {.cp = 0xFFAE, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFAE, .cde = &lxb_unicode_decomposition_c_FFAE, .kde = &lxb_unicode_decomposition_k_FFAE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFAF[1] = {0x313F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFAF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFAF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFAF[1] = {0x11B5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFAF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFAF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFAF[1] = {0x313F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFAF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFAF, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFAF = {.cp = 0xFFAF, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFAF, .cde = &lxb_unicode_decomposition_c_FFAF, .kde = &lxb_unicode_decomposition_k_FFAF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFB0[1] = {0x3140};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFB0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFB0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFB0[1] = {0x111A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFB0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFB0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFB0[1] = {0x3140};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFB0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFB0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFB0 = {.cp = 0xFFB0, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFB0, .cde = &lxb_unicode_decomposition_c_FFB0, .kde = &lxb_unicode_decomposition_k_FFB0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFB1[1] = {0x3141};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFB1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFB1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFB1[1] = {0x1106};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFB1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFB1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFB1[1] = {0x3141};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFB1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFB1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFB1 = {.cp = 0xFFB1, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFB1, .cde = &lxb_unicode_decomposition_c_FFB1, .kde = &lxb_unicode_decomposition_k_FFB1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFB2[1] = {0x3142};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFB2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFB2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFB2[1] = {0x1107};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFB2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFB2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFB2[1] = {0x3142};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFB2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFB2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFB2 = {.cp = 0xFFB2, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFB2, .cde = &lxb_unicode_decomposition_c_FFB2, .kde = &lxb_unicode_decomposition_k_FFB2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFB3[1] = {0x3143};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFB3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFB3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFB3[1] = {0x1108};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFB3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFB3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFB3[1] = {0x3143};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFB3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFB3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFB3 = {.cp = 0xFFB3, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFB3, .cde = &lxb_unicode_decomposition_c_FFB3, .kde = &lxb_unicode_decomposition_k_FFB3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFB4[1] = {0x3144};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFB4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFB4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFB4[1] = {0x1121};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFB4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFB4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFB4[1] = {0x3144};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFB4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFB4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFB4 = {.cp = 0xFFB4, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFB4, .cde = &lxb_unicode_decomposition_c_FFB4, .kde = &lxb_unicode_decomposition_k_FFB4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFB5[1] = {0x3145};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFB5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFB5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFB5[1] = {0x1109};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFB5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFB5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFB5[1] = {0x3145};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFB5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFB5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFB5 = {.cp = 0xFFB5, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFB5, .cde = &lxb_unicode_decomposition_c_FFB5, .kde = &lxb_unicode_decomposition_k_FFB5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFB6[1] = {0x3146};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFB6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFB6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFB6[1] = {0x110A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFB6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFB6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFB6[1] = {0x3146};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFB6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFB6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFB6 = {.cp = 0xFFB6, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFB6, .cde = &lxb_unicode_decomposition_c_FFB6, .kde = &lxb_unicode_decomposition_k_FFB6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFB7[1] = {0x3147};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFB7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFB7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFB7[1] = {0x110B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFB7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFB7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFB7[1] = {0x3147};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFB7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFB7, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFB7 = {.cp = 0xFFB7, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFB7, .cde = &lxb_unicode_decomposition_c_FFB7, .kde = &lxb_unicode_decomposition_k_FFB7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFB8[1] = {0x3148};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFB8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFB8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFB8[1] = {0x110C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFB8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFB8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFB8[1] = {0x3148};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFB8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFB8, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFB8 = {.cp = 0xFFB8, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFB8, .cde = &lxb_unicode_decomposition_c_FFB8, .kde = &lxb_unicode_decomposition_k_FFB8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFB9[1] = {0x3149};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFB9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFB9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFB9[1] = {0x110D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFB9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFB9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFB9[1] = {0x3149};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFB9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFB9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFB9 = {.cp = 0xFFB9, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFB9, .cde = &lxb_unicode_decomposition_c_FFB9, .kde = &lxb_unicode_decomposition_k_FFB9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFBA[1] = {0x314A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFBA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFBA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFBA[1] = {0x110E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFBA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFBA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFBA[1] = {0x314A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFBA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFBA, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFBA = {.cp = 0xFFBA, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFBA, .cde = &lxb_unicode_decomposition_c_FFBA, .kde = &lxb_unicode_decomposition_k_FFBA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFBB[1] = {0x314B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFBB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFBB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFBB[1] = {0x110F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFBB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFBB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFBB[1] = {0x314B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFBB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFBB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFBB = {.cp = 0xFFBB, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFBB, .cde = &lxb_unicode_decomposition_c_FFBB, .kde = &lxb_unicode_decomposition_k_FFBB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFBC[1] = {0x314C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFBC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFBC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFBC[1] = {0x1110};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFBC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFBC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFBC[1] = {0x314C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFBC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFBC, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFBC = {.cp = 0xFFBC, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFBC, .cde = &lxb_unicode_decomposition_c_FFBC, .kde = &lxb_unicode_decomposition_k_FFBC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFBD[1] = {0x314D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFBD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFBD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFBD[1] = {0x1111};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFBD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFBD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFBD[1] = {0x314D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFBD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFBD, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFBD = {.cp = 0xFFBD, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFBD, .cde = &lxb_unicode_decomposition_c_FFBD, .kde = &lxb_unicode_decomposition_k_FFBD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFBE[1] = {0x314E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFBE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFBE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFBE[1] = {0x1112};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFBE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFBE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFBE[1] = {0x314E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFBE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFBE, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFBE = {.cp = 0xFFBE, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFBE, .cde = &lxb_unicode_decomposition_c_FFBE, .kde = &lxb_unicode_decomposition_k_FFBE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFC2[1] = {0x314F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFC2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFC2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFC2[1] = {0x1161};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFC2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFC2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFC2[1] = {0x314F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFC2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFC2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFC2 = {.cp = 0xFFC2, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFC2, .cde = &lxb_unicode_decomposition_c_FFC2, .kde = &lxb_unicode_decomposition_k_FFC2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFC3[1] = {0x3150};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFC3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFC3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFC3[1] = {0x1162};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFC3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFC3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFC3[1] = {0x3150};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFC3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFC3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFC3 = {.cp = 0xFFC3, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFC3, .cde = &lxb_unicode_decomposition_c_FFC3, .kde = &lxb_unicode_decomposition_k_FFC3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFC4[1] = {0x3151};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFC4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFC4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFC4[1] = {0x1163};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFC4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFC4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFC4[1] = {0x3151};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFC4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFC4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFC4 = {.cp = 0xFFC4, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFC4, .cde = &lxb_unicode_decomposition_c_FFC4, .kde = &lxb_unicode_decomposition_k_FFC4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFC5[1] = {0x3152};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFC5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFC5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFC5[1] = {0x1164};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFC5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFC5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFC5[1] = {0x3152};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFC5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFC5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFC5 = {.cp = 0xFFC5, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFC5, .cde = &lxb_unicode_decomposition_c_FFC5, .kde = &lxb_unicode_decomposition_k_FFC5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFC6[1] = {0x3153};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFC6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFC6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFC6[1] = {0x1165};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFC6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFC6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFC6[1] = {0x3153};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFC6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFC6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFC6 = {.cp = 0xFFC6, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFC6, .cde = &lxb_unicode_decomposition_c_FFC6, .kde = &lxb_unicode_decomposition_k_FFC6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFC7[1] = {0x3154};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFC7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFC7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFC7[1] = {0x1166};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFC7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFC7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFC7[1] = {0x3154};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFC7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFC7, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFC7 = {.cp = 0xFFC7, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFC7, .cde = &lxb_unicode_decomposition_c_FFC7, .kde = &lxb_unicode_decomposition_k_FFC7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFCA[1] = {0x3155};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFCA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFCA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFCA[1] = {0x1167};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFCA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFCA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFCA[1] = {0x3155};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFCA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFCA, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFCA = {.cp = 0xFFCA, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFCA, .cde = &lxb_unicode_decomposition_c_FFCA, .kde = &lxb_unicode_decomposition_k_FFCA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFCB[1] = {0x3156};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFCB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFCB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFCB[1] = {0x1168};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFCB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFCB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFCB[1] = {0x3156};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFCB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFCB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFCB = {.cp = 0xFFCB, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFCB, .cde = &lxb_unicode_decomposition_c_FFCB, .kde = &lxb_unicode_decomposition_k_FFCB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFCC[1] = {0x3157};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFCC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFCC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFCC[1] = {0x1169};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFCC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFCC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFCC[1] = {0x3157};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFCC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFCC, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFCC = {.cp = 0xFFCC, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFCC, .cde = &lxb_unicode_decomposition_c_FFCC, .kde = &lxb_unicode_decomposition_k_FFCC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFCD[1] = {0x3158};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFCD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFCD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFCD[1] = {0x116A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFCD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFCD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFCD[1] = {0x3158};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFCD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFCD, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFCD = {.cp = 0xFFCD, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFCD, .cde = &lxb_unicode_decomposition_c_FFCD, .kde = &lxb_unicode_decomposition_k_FFCD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFCE[1] = {0x3159};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFCE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFCE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFCE[1] = {0x116B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFCE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFCE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFCE[1] = {0x3159};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFCE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFCE, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFCE = {.cp = 0xFFCE, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFCE, .cde = &lxb_unicode_decomposition_c_FFCE, .kde = &lxb_unicode_decomposition_k_FFCE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFCF[1] = {0x315A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFCF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFCF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFCF[1] = {0x116C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFCF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFCF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFCF[1] = {0x315A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFCF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFCF, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFCF = {.cp = 0xFFCF, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFCF, .cde = &lxb_unicode_decomposition_c_FFCF, .kde = &lxb_unicode_decomposition_k_FFCF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFD2[1] = {0x315B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFD2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFD2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFD2[1] = {0x116D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFD2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFD2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFD2[1] = {0x315B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFD2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFD2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFD2 = {.cp = 0xFFD2, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFD2, .cde = &lxb_unicode_decomposition_c_FFD2, .kde = &lxb_unicode_decomposition_k_FFD2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFD3[1] = {0x315C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFD3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFD3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFD3[1] = {0x116E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFD3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFD3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFD3[1] = {0x315C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFD3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFD3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFD3 = {.cp = 0xFFD3, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFD3, .cde = &lxb_unicode_decomposition_c_FFD3, .kde = &lxb_unicode_decomposition_k_FFD3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFD4[1] = {0x315D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFD4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFD4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFD4[1] = {0x116F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFD4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFD4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFD4[1] = {0x315D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFD4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFD4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFD4 = {.cp = 0xFFD4, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFD4, .cde = &lxb_unicode_decomposition_c_FFD4, .kde = &lxb_unicode_decomposition_k_FFD4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFD5[1] = {0x315E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFD5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFD5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFD5[1] = {0x1170};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFD5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFD5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFD5[1] = {0x315E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFD5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFD5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFD5 = {.cp = 0xFFD5, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFD5, .cde = &lxb_unicode_decomposition_c_FFD5, .kde = &lxb_unicode_decomposition_k_FFD5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFD6[1] = {0x315F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFD6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFD6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFD6[1] = {0x1171};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFD6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFD6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFD6[1] = {0x315F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFD6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFD6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFD6 = {.cp = 0xFFD6, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFD6, .cde = &lxb_unicode_decomposition_c_FFD6, .kde = &lxb_unicode_decomposition_k_FFD6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFD7[1] = {0x3160};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFD7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFD7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFD7[1] = {0x1172};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFD7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFD7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFD7[1] = {0x3160};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFD7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFD7, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFD7 = {.cp = 0xFFD7, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFD7, .cde = &lxb_unicode_decomposition_c_FFD7, .kde = &lxb_unicode_decomposition_k_FFD7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFDA[1] = {0x3161};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFDA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFDA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFDA[1] = {0x1173};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFDA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFDA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFDA[1] = {0x3161};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFDA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFDA, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFDA = {.cp = 0xFFDA, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFDA, .cde = &lxb_unicode_decomposition_c_FFDA, .kde = &lxb_unicode_decomposition_k_FFDA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFDB[1] = {0x3162};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFDB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFDB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFDB[1] = {0x1174};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFDB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFDB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFDB[1] = {0x3162};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFDB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFDB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFDB = {.cp = 0xFFDB, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFDB, .cde = &lxb_unicode_decomposition_c_FFDB, .kde = &lxb_unicode_decomposition_k_FFDB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFDC[1] = {0x3163};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFDC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFDC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFDC[1] = {0x1175};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFDC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFDC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFDC[1] = {0x3163};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFDC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFDC, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFDC = {.cp = 0xFFDC, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFDC, .cde = &lxb_unicode_decomposition_c_FFDC, .kde = &lxb_unicode_decomposition_k_FFDC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFE0[1] = {0x00A2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFE0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FFE0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFE0[1] = {0x00A2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFE0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FFE0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFE0[1] = {0x00A2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFE0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FFE0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFE0 = {.cp = 0xFFE0, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFE0, .cde = &lxb_unicode_decomposition_c_FFE0, .kde = &lxb_unicode_decomposition_k_FFE0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFE1[1] = {0x00A3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFE1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FFE1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFE1[1] = {0x00A3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFE1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FFE1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFE1[1] = {0x00A3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFE1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FFE1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFE1 = {.cp = 0xFFE1, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFE1, .cde = &lxb_unicode_decomposition_c_FFE1, .kde = &lxb_unicode_decomposition_k_FFE1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFE2[1] = {0x00AC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFE2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FFE2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFE2[1] = {0x00AC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFE2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FFE2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFE2[1] = {0x00AC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFE2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FFE2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFE2 = {.cp = 0xFFE2, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFE2, .cde = &lxb_unicode_decomposition_c_FFE2, .kde = &lxb_unicode_decomposition_k_FFE2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFE3[1] = {0x00AF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFE3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FFE3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFE3[2] = {0x0020, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFE3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FFE3, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFE3[1] = {0x00AF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFE3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FFE3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFE3 = {.cp = 0xFFE3, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFE3, .cde = &lxb_unicode_decomposition_c_FFE3, .kde = &lxb_unicode_decomposition_k_FFE3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFE4[1] = {0x00A6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFE4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FFE4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFE4[1] = {0x00A6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFE4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FFE4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFE4[1] = {0x00A6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFE4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FFE4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFE4 = {.cp = 0xFFE4, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFE4, .cde = &lxb_unicode_decomposition_c_FFE4, .kde = &lxb_unicode_decomposition_k_FFE4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFE5[1] = {0x00A5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFE5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FFE5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFE5[1] = {0x00A5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFE5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FFE5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFE5[1] = {0x00A5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFE5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FFE5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFE5 = {.cp = 0xFFE5, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFE5, .cde = &lxb_unicode_decomposition_c_FFE5, .kde = &lxb_unicode_decomposition_k_FFE5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFE6[1] = {0x20A9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFE6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_FFE6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFE6[1] = {0x20A9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFE6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_FFE6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFE6[1] = {0x20A9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFE6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__FFE6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFE6 = {.cp = 0xFFE6, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFE6, .cde = &lxb_unicode_decomposition_c_FFE6, .kde = &lxb_unicode_decomposition_k_FFE6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFE8[1] = {0x2502};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFE8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFE8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFE8[1] = {0x2502};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFE8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFE8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFE8[1] = {0x2502};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFE8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFE8, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFE8 = {.cp = 0xFFE8, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFE8, .cde = &lxb_unicode_decomposition_c_FFE8, .kde = &lxb_unicode_decomposition_k_FFE8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFE9[1] = {0x2190};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFE9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFE9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFE9[1] = {0x2190};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFE9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFE9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFE9[1] = {0x2190};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFE9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFE9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFE9 = {.cp = 0xFFE9, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFE9, .cde = &lxb_unicode_decomposition_c_FFE9, .kde = &lxb_unicode_decomposition_k_FFE9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFEA[1] = {0x2191};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFEA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFEA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFEA[1] = {0x2191};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFEA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFEA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFEA[1] = {0x2191};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFEA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFEA, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFEA = {.cp = 0xFFEA, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFEA, .cde = &lxb_unicode_decomposition_c_FFEA, .kde = &lxb_unicode_decomposition_k_FFEA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFEB[1] = {0x2192};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFEB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFEB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFEB[1] = {0x2192};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFEB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFEB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFEB[1] = {0x2192};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFEB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFEB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFEB = {.cp = 0xFFEB, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFEB, .cde = &lxb_unicode_decomposition_c_FFEB, .kde = &lxb_unicode_decomposition_k_FFEB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFEC[1] = {0x2193};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFEC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFEC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFEC[1] = {0x2193};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFEC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFEC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFEC[1] = {0x2193};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFEC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFEC, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFEC = {.cp = 0xFFEC, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFEC, .cde = &lxb_unicode_decomposition_c_FFEC, .kde = &lxb_unicode_decomposition_k_FFEC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFED[1] = {0x25A0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFED = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFED, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFED[1] = {0x25A0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFED = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFED, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFED[1] = {0x25A0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFED = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFED, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFED = {.cp = 0xFFED, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFED, .cde = &lxb_unicode_decomposition_c_FFED, .kde = &lxb_unicode_decomposition_k_FFED};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FFEE[1] = {0x25CB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FFEE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_c_FFEE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FFEE[1] = {0x25CB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FFEE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp_k_FFEE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FFEE[1] = {0x25CB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FFEE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NARROW, .mapping = lxb_unicode_decomposition_cp__FFEE, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FFEE = {.cp = 0xFFEE, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FFEE, .cde = &lxb_unicode_decomposition_c_FFEE, .kde = &lxb_unicode_decomposition_k_FFEE};

static const lxb_unicode_entry_t lxb_unicode_entry_101FD = {.cp = 0x101FD, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_102E0 = {.cp = 0x102E0, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_10376 = {.cp = 0x10376, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_10377 = {.cp = 0x10377, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_10378 = {.cp = 0x10378, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_10379 = {.cp = 0x10379, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1037A = {.cp = 0x1037A, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_10781[1] = {0x02D0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_10781 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_10781, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_10781[1] = {0x02D0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_10781 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_10781, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__10781[1] = {0x02D0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__10781 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__10781, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_10781 = {.cp = 0x10781, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__10781, .cde = &lxb_unicode_decomposition_c_10781, .kde = &lxb_unicode_decomposition_k_10781};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_10782[1] = {0x02D1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_10782 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_10782, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_10782[1] = {0x02D1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_10782 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_10782, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__10782[1] = {0x02D1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__10782 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__10782, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_10782 = {.cp = 0x10782, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__10782, .cde = &lxb_unicode_decomposition_c_10782, .kde = &lxb_unicode_decomposition_k_10782};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_10783[1] = {0x00E6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_10783 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_10783, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_10783[1] = {0x00E6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_10783 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_10783, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__10783[1] = {0x00E6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__10783 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__10783, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_10783 = {.cp = 0x10783, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__10783, .cde = &lxb_unicode_decomposition_c_10783, .kde = &lxb_unicode_decomposition_k_10783};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_10784[1] = {0x0299};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_10784 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_10784, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_10784[1] = {0x0299};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_10784 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_10784, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__10784[1] = {0x0299};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__10784 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__10784, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_10784 = {.cp = 0x10784, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__10784, .cde = &lxb_unicode_decomposition_c_10784, .kde = &lxb_unicode_decomposition_k_10784};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_10785[1] = {0x0253};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_10785 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_10785, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_10785[1] = {0x0253};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_10785 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_10785, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__10785[1] = {0x0253};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__10785 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__10785, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_10785 = {.cp = 0x10785, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__10785, .cde = &lxb_unicode_decomposition_c_10785, .kde = &lxb_unicode_decomposition_k_10785};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_10787[1] = {0x02A3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_10787 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_10787, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_10787[1] = {0x02A3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_10787 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_10787, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__10787[1] = {0x02A3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__10787 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__10787, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_10787 = {.cp = 0x10787, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__10787, .cde = &lxb_unicode_decomposition_c_10787, .kde = &lxb_unicode_decomposition_k_10787};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_10788[1] = {0xAB66};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_10788 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_10788, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_10788[1] = {0xAB66};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_10788 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_10788, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__10788[1] = {0xAB66};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__10788 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__10788, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_10788 = {.cp = 0x10788, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__10788, .cde = &lxb_unicode_decomposition_c_10788, .kde = &lxb_unicode_decomposition_k_10788};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_10789[1] = {0x02A5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_10789 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_10789, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_10789[1] = {0x02A5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_10789 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_10789, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__10789[1] = {0x02A5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__10789 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__10789, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_10789 = {.cp = 0x10789, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__10789, .cde = &lxb_unicode_decomposition_c_10789, .kde = &lxb_unicode_decomposition_k_10789};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1078A[1] = {0x02A4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1078A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1078A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1078A[1] = {0x02A4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1078A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1078A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1078A[1] = {0x02A4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1078A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1078A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1078A = {.cp = 0x1078A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1078A, .cde = &lxb_unicode_decomposition_c_1078A, .kde = &lxb_unicode_decomposition_k_1078A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1078B[1] = {0x0256};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1078B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1078B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1078B[1] = {0x0256};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1078B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1078B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1078B[1] = {0x0256};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1078B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1078B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1078B = {.cp = 0x1078B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1078B, .cde = &lxb_unicode_decomposition_c_1078B, .kde = &lxb_unicode_decomposition_k_1078B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1078C[1] = {0x0257};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1078C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1078C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1078C[1] = {0x0257};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1078C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1078C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1078C[1] = {0x0257};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1078C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1078C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1078C = {.cp = 0x1078C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1078C, .cde = &lxb_unicode_decomposition_c_1078C, .kde = &lxb_unicode_decomposition_k_1078C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1078D[1] = {0x1D91};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1078D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1078D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1078D[1] = {0x1D91};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1078D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1078D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1078D[1] = {0x1D91};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1078D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1078D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1078D = {.cp = 0x1078D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1078D, .cde = &lxb_unicode_decomposition_c_1078D, .kde = &lxb_unicode_decomposition_k_1078D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1078E[1] = {0x0258};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1078E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1078E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1078E[1] = {0x0258};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1078E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1078E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1078E[1] = {0x0258};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1078E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1078E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1078E = {.cp = 0x1078E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1078E, .cde = &lxb_unicode_decomposition_c_1078E, .kde = &lxb_unicode_decomposition_k_1078E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1078F[1] = {0x025E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1078F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1078F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1078F[1] = {0x025E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1078F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1078F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1078F[1] = {0x025E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1078F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1078F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1078F = {.cp = 0x1078F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1078F, .cde = &lxb_unicode_decomposition_c_1078F, .kde = &lxb_unicode_decomposition_k_1078F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_10790[1] = {0x02A9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_10790 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_10790, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_10790[1] = {0x02A9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_10790 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_10790, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__10790[1] = {0x02A9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__10790 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__10790, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_10790 = {.cp = 0x10790, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__10790, .cde = &lxb_unicode_decomposition_c_10790, .kde = &lxb_unicode_decomposition_k_10790};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_10791[1] = {0x0264};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_10791 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_10791, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_10791[1] = {0x0264};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_10791 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_10791, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__10791[1] = {0x0264};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__10791 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__10791, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_10791 = {.cp = 0x10791, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__10791, .cde = &lxb_unicode_decomposition_c_10791, .kde = &lxb_unicode_decomposition_k_10791};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_10792[1] = {0x0262};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_10792 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_10792, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_10792[1] = {0x0262};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_10792 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_10792, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__10792[1] = {0x0262};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__10792 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__10792, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_10792 = {.cp = 0x10792, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__10792, .cde = &lxb_unicode_decomposition_c_10792, .kde = &lxb_unicode_decomposition_k_10792};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_10793[1] = {0x0260};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_10793 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_10793, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_10793[1] = {0x0260};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_10793 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_10793, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__10793[1] = {0x0260};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__10793 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__10793, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_10793 = {.cp = 0x10793, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__10793, .cde = &lxb_unicode_decomposition_c_10793, .kde = &lxb_unicode_decomposition_k_10793};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_10794[1] = {0x029B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_10794 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_10794, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_10794[1] = {0x029B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_10794 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_10794, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__10794[1] = {0x029B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__10794 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__10794, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_10794 = {.cp = 0x10794, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__10794, .cde = &lxb_unicode_decomposition_c_10794, .kde = &lxb_unicode_decomposition_k_10794};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_10795[1] = {0x0127};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_10795 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_10795, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_10795[1] = {0x0127};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_10795 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_10795, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__10795[1] = {0x0127};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__10795 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__10795, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_10795 = {.cp = 0x10795, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__10795, .cde = &lxb_unicode_decomposition_c_10795, .kde = &lxb_unicode_decomposition_k_10795};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_10796[1] = {0x029C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_10796 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_10796, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_10796[1] = {0x029C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_10796 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_10796, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__10796[1] = {0x029C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__10796 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__10796, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_10796 = {.cp = 0x10796, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__10796, .cde = &lxb_unicode_decomposition_c_10796, .kde = &lxb_unicode_decomposition_k_10796};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_10797[1] = {0x0267};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_10797 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_10797, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_10797[1] = {0x0267};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_10797 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_10797, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__10797[1] = {0x0267};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__10797 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__10797, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_10797 = {.cp = 0x10797, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__10797, .cde = &lxb_unicode_decomposition_c_10797, .kde = &lxb_unicode_decomposition_k_10797};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_10798[1] = {0x0284};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_10798 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_10798, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_10798[1] = {0x0284};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_10798 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_10798, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__10798[1] = {0x0284};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__10798 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__10798, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_10798 = {.cp = 0x10798, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__10798, .cde = &lxb_unicode_decomposition_c_10798, .kde = &lxb_unicode_decomposition_k_10798};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_10799[1] = {0x02AA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_10799 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_10799, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_10799[1] = {0x02AA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_10799 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_10799, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__10799[1] = {0x02AA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__10799 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__10799, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_10799 = {.cp = 0x10799, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__10799, .cde = &lxb_unicode_decomposition_c_10799, .kde = &lxb_unicode_decomposition_k_10799};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1079A[1] = {0x02AB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1079A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1079A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1079A[1] = {0x02AB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1079A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1079A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1079A[1] = {0x02AB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1079A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1079A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1079A = {.cp = 0x1079A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1079A, .cde = &lxb_unicode_decomposition_c_1079A, .kde = &lxb_unicode_decomposition_k_1079A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1079B[1] = {0x026C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1079B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1079B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1079B[1] = {0x026C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1079B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1079B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1079B[1] = {0x026C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1079B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1079B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1079B = {.cp = 0x1079B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1079B, .cde = &lxb_unicode_decomposition_c_1079B, .kde = &lxb_unicode_decomposition_k_1079B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1079C[1] = {0x1DF04};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1079C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1079C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1079C[1] = {0x1DF04};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1079C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1079C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1079C[1] = {0x1DF04};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1079C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1079C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1079C = {.cp = 0x1079C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1079C, .cde = &lxb_unicode_decomposition_c_1079C, .kde = &lxb_unicode_decomposition_k_1079C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1079D[1] = {0xA78E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1079D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1079D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1079D[1] = {0xA78E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1079D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1079D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1079D[1] = {0xA78E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1079D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1079D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1079D = {.cp = 0x1079D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1079D, .cde = &lxb_unicode_decomposition_c_1079D, .kde = &lxb_unicode_decomposition_k_1079D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1079E[1] = {0x026E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1079E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1079E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1079E[1] = {0x026E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1079E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1079E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1079E[1] = {0x026E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1079E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1079E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1079E = {.cp = 0x1079E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1079E, .cde = &lxb_unicode_decomposition_c_1079E, .kde = &lxb_unicode_decomposition_k_1079E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1079F[1] = {0x1DF05};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1079F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1079F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1079F[1] = {0x1DF05};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1079F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1079F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1079F[1] = {0x1DF05};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1079F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1079F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1079F = {.cp = 0x1079F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1079F, .cde = &lxb_unicode_decomposition_c_1079F, .kde = &lxb_unicode_decomposition_k_1079F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_107A0[1] = {0x028E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_107A0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_107A0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_107A0[1] = {0x028E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_107A0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_107A0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__107A0[1] = {0x028E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__107A0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__107A0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_107A0 = {.cp = 0x107A0, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__107A0, .cde = &lxb_unicode_decomposition_c_107A0, .kde = &lxb_unicode_decomposition_k_107A0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_107A1[1] = {0x1DF06};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_107A1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_107A1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_107A1[1] = {0x1DF06};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_107A1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_107A1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__107A1[1] = {0x1DF06};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__107A1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__107A1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_107A1 = {.cp = 0x107A1, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__107A1, .cde = &lxb_unicode_decomposition_c_107A1, .kde = &lxb_unicode_decomposition_k_107A1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_107A2[1] = {0x00F8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_107A2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_107A2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_107A2[1] = {0x00F8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_107A2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_107A2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__107A2[1] = {0x00F8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__107A2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__107A2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_107A2 = {.cp = 0x107A2, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__107A2, .cde = &lxb_unicode_decomposition_c_107A2, .kde = &lxb_unicode_decomposition_k_107A2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_107A3[1] = {0x0276};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_107A3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_107A3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_107A3[1] = {0x0276};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_107A3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_107A3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__107A3[1] = {0x0276};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__107A3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__107A3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_107A3 = {.cp = 0x107A3, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__107A3, .cde = &lxb_unicode_decomposition_c_107A3, .kde = &lxb_unicode_decomposition_k_107A3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_107A4[1] = {0x0277};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_107A4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_107A4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_107A4[1] = {0x0277};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_107A4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_107A4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__107A4[1] = {0x0277};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__107A4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__107A4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_107A4 = {.cp = 0x107A4, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__107A4, .cde = &lxb_unicode_decomposition_c_107A4, .kde = &lxb_unicode_decomposition_k_107A4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_107A5[1] = {0x0071};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_107A5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_107A5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_107A5[1] = {0x0071};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_107A5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_107A5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__107A5[1] = {0x0071};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__107A5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__107A5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_107A5 = {.cp = 0x107A5, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__107A5, .cde = &lxb_unicode_decomposition_c_107A5, .kde = &lxb_unicode_decomposition_k_107A5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_107A6[1] = {0x027A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_107A6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_107A6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_107A6[1] = {0x027A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_107A6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_107A6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__107A6[1] = {0x027A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__107A6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__107A6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_107A6 = {.cp = 0x107A6, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__107A6, .cde = &lxb_unicode_decomposition_c_107A6, .kde = &lxb_unicode_decomposition_k_107A6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_107A7[1] = {0x1DF08};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_107A7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_107A7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_107A7[1] = {0x1DF08};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_107A7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_107A7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__107A7[1] = {0x1DF08};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__107A7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__107A7, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_107A7 = {.cp = 0x107A7, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__107A7, .cde = &lxb_unicode_decomposition_c_107A7, .kde = &lxb_unicode_decomposition_k_107A7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_107A8[1] = {0x027D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_107A8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_107A8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_107A8[1] = {0x027D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_107A8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_107A8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__107A8[1] = {0x027D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__107A8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__107A8, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_107A8 = {.cp = 0x107A8, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__107A8, .cde = &lxb_unicode_decomposition_c_107A8, .kde = &lxb_unicode_decomposition_k_107A8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_107A9[1] = {0x027E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_107A9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_107A9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_107A9[1] = {0x027E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_107A9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_107A9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__107A9[1] = {0x027E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__107A9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__107A9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_107A9 = {.cp = 0x107A9, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__107A9, .cde = &lxb_unicode_decomposition_c_107A9, .kde = &lxb_unicode_decomposition_k_107A9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_107AA[1] = {0x0280};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_107AA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_107AA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_107AA[1] = {0x0280};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_107AA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_107AA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__107AA[1] = {0x0280};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__107AA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__107AA, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_107AA = {.cp = 0x107AA, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__107AA, .cde = &lxb_unicode_decomposition_c_107AA, .kde = &lxb_unicode_decomposition_k_107AA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_107AB[1] = {0x02A8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_107AB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_107AB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_107AB[1] = {0x02A8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_107AB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_107AB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__107AB[1] = {0x02A8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__107AB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__107AB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_107AB = {.cp = 0x107AB, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__107AB, .cde = &lxb_unicode_decomposition_c_107AB, .kde = &lxb_unicode_decomposition_k_107AB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_107AC[1] = {0x02A6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_107AC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_107AC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_107AC[1] = {0x02A6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_107AC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_107AC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__107AC[1] = {0x02A6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__107AC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__107AC, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_107AC = {.cp = 0x107AC, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__107AC, .cde = &lxb_unicode_decomposition_c_107AC, .kde = &lxb_unicode_decomposition_k_107AC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_107AD[1] = {0xAB67};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_107AD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_107AD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_107AD[1] = {0xAB67};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_107AD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_107AD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__107AD[1] = {0xAB67};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__107AD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__107AD, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_107AD = {.cp = 0x107AD, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__107AD, .cde = &lxb_unicode_decomposition_c_107AD, .kde = &lxb_unicode_decomposition_k_107AD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_107AE[1] = {0x02A7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_107AE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_107AE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_107AE[1] = {0x02A7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_107AE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_107AE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__107AE[1] = {0x02A7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__107AE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__107AE, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_107AE = {.cp = 0x107AE, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__107AE, .cde = &lxb_unicode_decomposition_c_107AE, .kde = &lxb_unicode_decomposition_k_107AE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_107AF[1] = {0x0288};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_107AF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_107AF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_107AF[1] = {0x0288};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_107AF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_107AF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__107AF[1] = {0x0288};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__107AF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__107AF, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_107AF = {.cp = 0x107AF, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__107AF, .cde = &lxb_unicode_decomposition_c_107AF, .kde = &lxb_unicode_decomposition_k_107AF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_107B0[1] = {0x2C71};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_107B0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_107B0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_107B0[1] = {0x2C71};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_107B0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_107B0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__107B0[1] = {0x2C71};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__107B0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__107B0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_107B0 = {.cp = 0x107B0, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__107B0, .cde = &lxb_unicode_decomposition_c_107B0, .kde = &lxb_unicode_decomposition_k_107B0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_107B2[1] = {0x028F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_107B2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_107B2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_107B2[1] = {0x028F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_107B2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_107B2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__107B2[1] = {0x028F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__107B2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__107B2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_107B2 = {.cp = 0x107B2, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__107B2, .cde = &lxb_unicode_decomposition_c_107B2, .kde = &lxb_unicode_decomposition_k_107B2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_107B3[1] = {0x02A1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_107B3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_107B3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_107B3[1] = {0x02A1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_107B3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_107B3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__107B3[1] = {0x02A1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__107B3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__107B3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_107B3 = {.cp = 0x107B3, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__107B3, .cde = &lxb_unicode_decomposition_c_107B3, .kde = &lxb_unicode_decomposition_k_107B3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_107B4[1] = {0x02A2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_107B4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_107B4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_107B4[1] = {0x02A2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_107B4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_107B4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__107B4[1] = {0x02A2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__107B4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__107B4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_107B4 = {.cp = 0x107B4, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__107B4, .cde = &lxb_unicode_decomposition_c_107B4, .kde = &lxb_unicode_decomposition_k_107B4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_107B5[1] = {0x0298};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_107B5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_107B5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_107B5[1] = {0x0298};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_107B5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_107B5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__107B5[1] = {0x0298};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__107B5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__107B5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_107B5 = {.cp = 0x107B5, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__107B5, .cde = &lxb_unicode_decomposition_c_107B5, .kde = &lxb_unicode_decomposition_k_107B5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_107B6[1] = {0x01C0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_107B6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_107B6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_107B6[1] = {0x01C0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_107B6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_107B6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__107B6[1] = {0x01C0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__107B6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__107B6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_107B6 = {.cp = 0x107B6, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__107B6, .cde = &lxb_unicode_decomposition_c_107B6, .kde = &lxb_unicode_decomposition_k_107B6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_107B7[1] = {0x01C1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_107B7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_107B7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_107B7[1] = {0x01C1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_107B7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_107B7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__107B7[1] = {0x01C1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__107B7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__107B7, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_107B7 = {.cp = 0x107B7, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__107B7, .cde = &lxb_unicode_decomposition_c_107B7, .kde = &lxb_unicode_decomposition_k_107B7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_107B8[1] = {0x01C2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_107B8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_107B8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_107B8[1] = {0x01C2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_107B8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_107B8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__107B8[1] = {0x01C2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__107B8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__107B8, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_107B8 = {.cp = 0x107B8, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__107B8, .cde = &lxb_unicode_decomposition_c_107B8, .kde = &lxb_unicode_decomposition_k_107B8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_107B9[1] = {0x1DF0A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_107B9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_107B9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_107B9[1] = {0x1DF0A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_107B9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_107B9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__107B9[1] = {0x1DF0A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__107B9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__107B9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_107B9 = {.cp = 0x107B9, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__107B9, .cde = &lxb_unicode_decomposition_c_107B9, .kde = &lxb_unicode_decomposition_k_107B9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_107BA[1] = {0x1DF1E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_107BA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_107BA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_107BA[1] = {0x1DF1E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_107BA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_107BA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__107BA[1] = {0x1DF1E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__107BA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__107BA, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_107BA = {.cp = 0x107BA, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__107BA, .cde = &lxb_unicode_decomposition_c_107BA, .kde = &lxb_unicode_decomposition_k_107BA};

static const lxb_unicode_entry_t lxb_unicode_entry_10A0D = {.cp = 0x10A0D, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_10A0F = {.cp = 0x10A0F, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_10A38 = {.cp = 0x10A38, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_10A39 = {.cp = 0x10A39, .ccc = 1, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_10A3A = {.cp = 0x10A3A, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_10A3F = {.cp = 0x10A3F, .ccc = 9, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_10AE5 = {.cp = 0x10AE5, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_10AE6 = {.cp = 0x10AE6, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_10D24 = {.cp = 0x10D24, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_10D25 = {.cp = 0x10D25, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_10D26 = {.cp = 0x10D26, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_10D27 = {.cp = 0x10D27, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_10EAB = {.cp = 0x10EAB, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_10EAC = {.cp = 0x10EAC, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_10EFD = {.cp = 0x10EFD, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_10EFE = {.cp = 0x10EFE, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_10EFF = {.cp = 0x10EFF, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_10F46 = {.cp = 0x10F46, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_10F47 = {.cp = 0x10F47, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_10F48 = {.cp = 0x10F48, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_10F49 = {.cp = 0x10F49, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_10F4A = {.cp = 0x10F4A, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_10F4B = {.cp = 0x10F4B, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_10F4C = {.cp = 0x10F4C, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_10F4D = {.cp = 0x10F4D, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_10F4E = {.cp = 0x10F4E, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_10F4F = {.cp = 0x10F4F, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_10F50 = {.cp = 0x10F50, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_10F82 = {.cp = 0x10F82, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_10F83 = {.cp = 0x10F83, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_10F84 = {.cp = 0x10F84, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_10F85 = {.cp = 0x10F85, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_11046 = {.cp = 0x11046, .ccc = 9, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_11070 = {.cp = 0x11070, .ccc = 9, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1107F = {.cp = 0x1107F, .ccc = 9, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1109A[2] = {0x11099, 0x110BA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1109A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1109A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1109A[2] = {0x11099, 0x110BA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1109A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1109A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1109A[2] = {0x11099, 0x110BA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1109A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1109A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1109A = {.cp = 0x1109A, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1109A, .cde = &lxb_unicode_decomposition_c_1109A, .kde = &lxb_unicode_decomposition_k_1109A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1109C[2] = {0x1109B, 0x110BA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1109C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1109C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1109C[2] = {0x1109B, 0x110BA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1109C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1109C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1109C[2] = {0x1109B, 0x110BA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1109C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1109C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1109C = {.cp = 0x1109C, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1109C, .cde = &lxb_unicode_decomposition_c_1109C, .kde = &lxb_unicode_decomposition_k_1109C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_110AB[2] = {0x110A5, 0x110BA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_110AB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_110AB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_110AB[2] = {0x110A5, 0x110BA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_110AB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_110AB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__110AB[2] = {0x110A5, 0x110BA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__110AB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__110AB, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_110AB = {.cp = 0x110AB, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__110AB, .cde = &lxb_unicode_decomposition_c_110AB, .kde = &lxb_unicode_decomposition_k_110AB};

static const lxb_unicode_entry_t lxb_unicode_entry_110B9 = {.cp = 0x110B9, .ccc = 9, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_110BA = {.cp = 0x110BA, .ccc = 7, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_11100 = {.cp = 0x11100, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_11101 = {.cp = 0x11101, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_11102 = {.cp = 0x11102, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_11127 = {.cp = 0x11127, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1112E[2] = {0x11131, 0x11127};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1112E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1112E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1112E[2] = {0x11131, 0x11127};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1112E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1112E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1112E[2] = {0x11131, 0x11127};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1112E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1112E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1112E = {.cp = 0x1112E, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1112E, .cde = &lxb_unicode_decomposition_c_1112E, .kde = &lxb_unicode_decomposition_k_1112E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1112F[2] = {0x11132, 0x11127};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1112F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1112F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1112F[2] = {0x11132, 0x11127};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1112F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1112F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1112F[2] = {0x11132, 0x11127};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1112F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1112F, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1112F = {.cp = 0x1112F, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1112F, .cde = &lxb_unicode_decomposition_c_1112F, .kde = &lxb_unicode_decomposition_k_1112F};

static const lxb_unicode_entry_t lxb_unicode_entry_11133 = {.cp = 0x11133, .ccc = 9, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_11134 = {.cp = 0x11134, .ccc = 9, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_unicode_data_t lxb_unicode_data_FDF0 = {&lxb_unicode_entry_FDF0, &lxb_unicode_idna_map_FDF0};
static const lxb_unicode_data_t lxb_unicode_data_FDF1 = {&lxb_unicode_entry_FDF1, &lxb_unicode_idna_map_FDF1};
static const lxb_unicode_data_t lxb_unicode_data_FDF2 = {&lxb_unicode_entry_FDF2, &lxb_unicode_idna_map_FDF2};
static const lxb_unicode_data_t lxb_unicode_data_FDF3 = {&lxb_unicode_entry_FDF3, &lxb_unicode_idna_map_FDF3};
static const lxb_unicode_data_t lxb_unicode_data_FDF4 = {&lxb_unicode_entry_FDF4, &lxb_unicode_idna_map_FDF4};
static const lxb_unicode_data_t lxb_unicode_data_FDF5 = {&lxb_unicode_entry_FDF5, &lxb_unicode_idna_map_FDF5};
static const lxb_unicode_data_t lxb_unicode_data_FDF6 = {&lxb_unicode_entry_FDF6, &lxb_unicode_idna_map_FDF6};
static const lxb_unicode_data_t lxb_unicode_data_FDF7 = {&lxb_unicode_entry_FDF7, &lxb_unicode_idna_map_FDF7};
static const lxb_unicode_data_t lxb_unicode_data_FDF8 = {&lxb_unicode_entry_FDF8, &lxb_unicode_idna_map_FDF8};
static const lxb_unicode_data_t lxb_unicode_data_FDF9 = {&lxb_unicode_entry_FDF9, &lxb_unicode_idna_map_FDF9};
static const lxb_unicode_data_t lxb_unicode_data_FDFA = {&lxb_unicode_entry_FDFA, &lxb_unicode_idna_map_FDFA};
static const lxb_unicode_data_t lxb_unicode_data_FDFB = {&lxb_unicode_entry_FDFB, &lxb_unicode_idna_map_FDFB};
static const lxb_unicode_data_t lxb_unicode_data_FDFC = {&lxb_unicode_entry_FDFC, &lxb_unicode_idna_map_FDFC};
static const lxb_unicode_data_t lxb_unicode_data_FE10 = {&lxb_unicode_entry_FE10, &lxb_unicode_idna_map_FE10};
static const lxb_unicode_data_t lxb_unicode_data_FE11 = {&lxb_unicode_entry_FE11, &lxb_unicode_idna_map_FE11};
static const lxb_unicode_data_t lxb_unicode_data_FE12 = {&lxb_unicode_entry_FE12, NULL};
static const lxb_unicode_data_t lxb_unicode_data_FE13 = {&lxb_unicode_entry_FE13, &lxb_unicode_idna_map_FE13};
static const lxb_unicode_data_t lxb_unicode_data_FE14 = {&lxb_unicode_entry_FE14, &lxb_unicode_idna_map_FE14};
static const lxb_unicode_data_t lxb_unicode_data_FE15 = {&lxb_unicode_entry_FE15, &lxb_unicode_idna_map_FE15};
static const lxb_unicode_data_t lxb_unicode_data_FE16 = {&lxb_unicode_entry_FE16, &lxb_unicode_idna_map_FE16};
static const lxb_unicode_data_t lxb_unicode_data_FE17 = {&lxb_unicode_entry_FE17, &lxb_unicode_idna_map_FE17};
static const lxb_unicode_data_t lxb_unicode_data_FE18 = {&lxb_unicode_entry_FE18, &lxb_unicode_idna_map_FE18};
static const lxb_unicode_data_t lxb_unicode_data_FE19 = {&lxb_unicode_entry_FE19, NULL};
static const lxb_unicode_data_t lxb_unicode_data_FE20 = {&lxb_unicode_entry_FE20, NULL};
static const lxb_unicode_data_t lxb_unicode_data_FE21 = {&lxb_unicode_entry_FE21, NULL};
static const lxb_unicode_data_t lxb_unicode_data_FE22 = {&lxb_unicode_entry_FE22, NULL};
static const lxb_unicode_data_t lxb_unicode_data_FE23 = {&lxb_unicode_entry_FE23, NULL};
static const lxb_unicode_data_t lxb_unicode_data_FE24 = {&lxb_unicode_entry_FE24, NULL};
static const lxb_unicode_data_t lxb_unicode_data_FE25 = {&lxb_unicode_entry_FE25, NULL};
static const lxb_unicode_data_t lxb_unicode_data_FE26 = {&lxb_unicode_entry_FE26, NULL};
static const lxb_unicode_data_t lxb_unicode_data_FE27 = {&lxb_unicode_entry_FE27, NULL};
static const lxb_unicode_data_t lxb_unicode_data_FE28 = {&lxb_unicode_entry_FE28, NULL};
static const lxb_unicode_data_t lxb_unicode_data_FE29 = {&lxb_unicode_entry_FE29, NULL};
static const lxb_unicode_data_t lxb_unicode_data_FE2A = {&lxb_unicode_entry_FE2A, NULL};
static const lxb_unicode_data_t lxb_unicode_data_FE2B = {&lxb_unicode_entry_FE2B, NULL};
static const lxb_unicode_data_t lxb_unicode_data_FE2C = {&lxb_unicode_entry_FE2C, NULL};
static const lxb_unicode_data_t lxb_unicode_data_FE2D = {&lxb_unicode_entry_FE2D, NULL};
static const lxb_unicode_data_t lxb_unicode_data_FE2E = {&lxb_unicode_entry_FE2E, NULL};
static const lxb_unicode_data_t lxb_unicode_data_FE2F = {&lxb_unicode_entry_FE2F, NULL};
static const lxb_unicode_data_t lxb_unicode_data_FE30 = {&lxb_unicode_entry_FE30, NULL};
static const lxb_unicode_data_t lxb_unicode_data_FE31 = {&lxb_unicode_entry_FE31, &lxb_unicode_idna_map_FE31};
static const lxb_unicode_data_t lxb_unicode_data_FE32 = {&lxb_unicode_entry_FE32, &lxb_unicode_idna_map_FE32};
static const lxb_unicode_data_t lxb_unicode_data_FE33 = {&lxb_unicode_entry_FE33, &lxb_unicode_idna_map_FE33};
static const lxb_unicode_data_t lxb_unicode_data_FE34 = {&lxb_unicode_entry_FE34, &lxb_unicode_idna_map_FE34};
static const lxb_unicode_data_t lxb_unicode_data_FE35 = {&lxb_unicode_entry_FE35, &lxb_unicode_idna_map_FE35};
static const lxb_unicode_data_t lxb_unicode_data_FE36 = {&lxb_unicode_entry_FE36, &lxb_unicode_idna_map_FE36};
static const lxb_unicode_data_t lxb_unicode_data_FE37 = {&lxb_unicode_entry_FE37, &lxb_unicode_idna_map_FE37};
static const lxb_unicode_data_t lxb_unicode_data_FE38 = {&lxb_unicode_entry_FE38, &lxb_unicode_idna_map_FE38};
static const lxb_unicode_data_t lxb_unicode_data_FE39 = {&lxb_unicode_entry_FE39, &lxb_unicode_idna_map_FE39};
static const lxb_unicode_data_t lxb_unicode_data_FE3A = {&lxb_unicode_entry_FE3A, &lxb_unicode_idna_map_FE3A};
static const lxb_unicode_data_t lxb_unicode_data_FE3B = {&lxb_unicode_entry_FE3B, &lxb_unicode_idna_map_FE3B};
static const lxb_unicode_data_t lxb_unicode_data_FE3C = {&lxb_unicode_entry_FE3C, &lxb_unicode_idna_map_FE3C};
static const lxb_unicode_data_t lxb_unicode_data_FE3D = {&lxb_unicode_entry_FE3D, &lxb_unicode_idna_map_FE3D};
static const lxb_unicode_data_t lxb_unicode_data_FE3E = {&lxb_unicode_entry_FE3E, &lxb_unicode_idna_map_FE3E};
static const lxb_unicode_data_t lxb_unicode_data_FE3F = {&lxb_unicode_entry_FE3F, &lxb_unicode_idna_map_FE3F};
static const lxb_unicode_data_t lxb_unicode_data_FE40 = {&lxb_unicode_entry_FE40, &lxb_unicode_idna_map_FE40};
static const lxb_unicode_data_t lxb_unicode_data_FE41 = {&lxb_unicode_entry_FE41, &lxb_unicode_idna_map_FE41};
static const lxb_unicode_data_t lxb_unicode_data_FE42 = {&lxb_unicode_entry_FE42, &lxb_unicode_idna_map_FE42};
static const lxb_unicode_data_t lxb_unicode_data_FE43 = {&lxb_unicode_entry_FE43, &lxb_unicode_idna_map_FE43};
static const lxb_unicode_data_t lxb_unicode_data_FE44 = {&lxb_unicode_entry_FE44, &lxb_unicode_idna_map_FE44};
static const lxb_unicode_data_t lxb_unicode_data_FE47 = {&lxb_unicode_entry_FE47, &lxb_unicode_idna_map_FE47};
static const lxb_unicode_data_t lxb_unicode_data_FE48 = {&lxb_unicode_entry_FE48, &lxb_unicode_idna_map_FE48};
static const lxb_unicode_data_t lxb_unicode_data_FE49 = {&lxb_unicode_entry_FE49, &lxb_unicode_idna_map_FE49};
static const lxb_unicode_data_t lxb_unicode_data_FE4A = {&lxb_unicode_entry_FE4A, &lxb_unicode_idna_map_FE4A};
static const lxb_unicode_data_t lxb_unicode_data_FE4B = {&lxb_unicode_entry_FE4B, &lxb_unicode_idna_map_FE4B};
static const lxb_unicode_data_t lxb_unicode_data_FE4C = {&lxb_unicode_entry_FE4C, &lxb_unicode_idna_map_FE4C};
static const lxb_unicode_data_t lxb_unicode_data_FE4D = {&lxb_unicode_entry_FE4D, &lxb_unicode_idna_map_FE4D};
static const lxb_unicode_data_t lxb_unicode_data_FE4E = {&lxb_unicode_entry_FE4E, &lxb_unicode_idna_map_FE4E};
static const lxb_unicode_data_t lxb_unicode_data_FE4F = {&lxb_unicode_entry_FE4F, &lxb_unicode_idna_map_FE4F};
static const lxb_unicode_data_t lxb_unicode_data_FE50 = {&lxb_unicode_entry_FE50, &lxb_unicode_idna_map_FE50};
static const lxb_unicode_data_t lxb_unicode_data_FE51 = {&lxb_unicode_entry_FE51, &lxb_unicode_idna_map_FE51};
static const lxb_unicode_data_t lxb_unicode_data_FE52 = {&lxb_unicode_entry_FE52, NULL};
static const lxb_unicode_data_t lxb_unicode_data_FE54 = {&lxb_unicode_entry_FE54, &lxb_unicode_idna_map_FE54};
static const lxb_unicode_data_t lxb_unicode_data_FE55 = {&lxb_unicode_entry_FE55, &lxb_unicode_idna_map_FE55};
static const lxb_unicode_data_t lxb_unicode_data_FE56 = {&lxb_unicode_entry_FE56, &lxb_unicode_idna_map_FE56};
static const lxb_unicode_data_t lxb_unicode_data_FE57 = {&lxb_unicode_entry_FE57, &lxb_unicode_idna_map_FE57};
static const lxb_unicode_data_t lxb_unicode_data_FE58 = {&lxb_unicode_entry_FE58, &lxb_unicode_idna_map_FE58};
static const lxb_unicode_data_t lxb_unicode_data_FE59 = {&lxb_unicode_entry_FE59, &lxb_unicode_idna_map_FE59};
static const lxb_unicode_data_t lxb_unicode_data_FE5A = {&lxb_unicode_entry_FE5A, &lxb_unicode_idna_map_FE5A};
static const lxb_unicode_data_t lxb_unicode_data_FE5B = {&lxb_unicode_entry_FE5B, &lxb_unicode_idna_map_FE5B};
static const lxb_unicode_data_t lxb_unicode_data_FE5C = {&lxb_unicode_entry_FE5C, &lxb_unicode_idna_map_FE5C};
static const lxb_unicode_data_t lxb_unicode_data_FE5D = {&lxb_unicode_entry_FE5D, &lxb_unicode_idna_map_FE5D};
static const lxb_unicode_data_t lxb_unicode_data_FE5E = {&lxb_unicode_entry_FE5E, &lxb_unicode_idna_map_FE5E};
static const lxb_unicode_data_t lxb_unicode_data_FE5F = {&lxb_unicode_entry_FE5F, &lxb_unicode_idna_map_FE5F};
static const lxb_unicode_data_t lxb_unicode_data_FE60 = {&lxb_unicode_entry_FE60, &lxb_unicode_idna_map_FE60};
static const lxb_unicode_data_t lxb_unicode_data_FE61 = {&lxb_unicode_entry_FE61, &lxb_unicode_idna_map_FE61};
static const lxb_unicode_data_t lxb_unicode_data_FE62 = {&lxb_unicode_entry_FE62, &lxb_unicode_idna_map_FE62};
static const lxb_unicode_data_t lxb_unicode_data_FE63 = {&lxb_unicode_entry_FE63, &lxb_unicode_idna_map_FE63};
static const lxb_unicode_data_t lxb_unicode_data_FE64 = {&lxb_unicode_entry_FE64, &lxb_unicode_idna_map_FE64};
static const lxb_unicode_data_t lxb_unicode_data_FE65 = {&lxb_unicode_entry_FE65, &lxb_unicode_idna_map_FE65};
static const lxb_unicode_data_t lxb_unicode_data_FE66 = {&lxb_unicode_entry_FE66, &lxb_unicode_idna_map_FE66};
static const lxb_unicode_data_t lxb_unicode_data_FE68 = {&lxb_unicode_entry_FE68, &lxb_unicode_idna_map_FE68};
static const lxb_unicode_data_t lxb_unicode_data_FE69 = {&lxb_unicode_entry_FE69, &lxb_unicode_idna_map_FE69};
static const lxb_unicode_data_t lxb_unicode_data_FE6A = {&lxb_unicode_entry_FE6A, &lxb_unicode_idna_map_FE6A};
static const lxb_unicode_data_t lxb_unicode_data_FE6B = {&lxb_unicode_entry_FE6B, &lxb_unicode_idna_map_FE6B};
static const lxb_unicode_data_t lxb_unicode_data_FE70 = {&lxb_unicode_entry_FE70, &lxb_unicode_idna_map_FE70};
static const lxb_unicode_data_t lxb_unicode_data_FE71 = {&lxb_unicode_entry_FE71, &lxb_unicode_idna_map_FE71};
static const lxb_unicode_data_t lxb_unicode_data_FE72 = {&lxb_unicode_entry_FE72, &lxb_unicode_idna_map_FE72};
static const lxb_unicode_data_t lxb_unicode_data_FE74 = {&lxb_unicode_entry_FE74, &lxb_unicode_idna_map_FE74};
static const lxb_unicode_data_t lxb_unicode_data_FE76 = {&lxb_unicode_entry_FE76, &lxb_unicode_idna_map_FE76};
static const lxb_unicode_data_t lxb_unicode_data_FE77 = {&lxb_unicode_entry_FE77, &lxb_unicode_idna_map_FE77};
static const lxb_unicode_data_t lxb_unicode_data_FE78 = {&lxb_unicode_entry_FE78, &lxb_unicode_idna_map_FE78};
static const lxb_unicode_data_t lxb_unicode_data_FE79 = {&lxb_unicode_entry_FE79, &lxb_unicode_idna_map_FE79};
static const lxb_unicode_data_t lxb_unicode_data_FE7A = {&lxb_unicode_entry_FE7A, &lxb_unicode_idna_map_FE7A};
static const lxb_unicode_data_t lxb_unicode_data_FE7B = {&lxb_unicode_entry_FE7B, &lxb_unicode_idna_map_FE7B};
static const lxb_unicode_data_t lxb_unicode_data_FE7C = {&lxb_unicode_entry_FE7C, &lxb_unicode_idna_map_FE7C};
static const lxb_unicode_data_t lxb_unicode_data_FE7D = {&lxb_unicode_entry_FE7D, &lxb_unicode_idna_map_FE7D};
static const lxb_unicode_data_t lxb_unicode_data_FE7E = {&lxb_unicode_entry_FE7E, &lxb_unicode_idna_map_FE7E};
static const lxb_unicode_data_t lxb_unicode_data_FE7F = {&lxb_unicode_entry_FE7F, &lxb_unicode_idna_map_FE7F};
static const lxb_unicode_data_t lxb_unicode_data_FE80 = {&lxb_unicode_entry_FE80, &lxb_unicode_idna_map_FE80};
static const lxb_unicode_data_t lxb_unicode_data_FE81 = {&lxb_unicode_entry_FE81, &lxb_unicode_idna_map_FE81};
static const lxb_unicode_data_t lxb_unicode_data_FE82 = {&lxb_unicode_entry_FE82, &lxb_unicode_idna_map_FE82};
static const lxb_unicode_data_t lxb_unicode_data_FE83 = {&lxb_unicode_entry_FE83, &lxb_unicode_idna_map_FE83};
static const lxb_unicode_data_t lxb_unicode_data_FE84 = {&lxb_unicode_entry_FE84, &lxb_unicode_idna_map_FE84};
static const lxb_unicode_data_t lxb_unicode_data_FE85 = {&lxb_unicode_entry_FE85, &lxb_unicode_idna_map_FE85};
static const lxb_unicode_data_t lxb_unicode_data_FE86 = {&lxb_unicode_entry_FE86, &lxb_unicode_idna_map_FE86};
static const lxb_unicode_data_t lxb_unicode_data_FE87 = {&lxb_unicode_entry_FE87, &lxb_unicode_idna_map_FE87};
static const lxb_unicode_data_t lxb_unicode_data_FE88 = {&lxb_unicode_entry_FE88, &lxb_unicode_idna_map_FE88};
static const lxb_unicode_data_t lxb_unicode_data_FE89 = {&lxb_unicode_entry_FE89, &lxb_unicode_idna_map_FE89};
static const lxb_unicode_data_t lxb_unicode_data_FE8A = {&lxb_unicode_entry_FE8A, &lxb_unicode_idna_map_FE8A};
static const lxb_unicode_data_t lxb_unicode_data_FE8B = {&lxb_unicode_entry_FE8B, &lxb_unicode_idna_map_FE8B};
static const lxb_unicode_data_t lxb_unicode_data_FE8C = {&lxb_unicode_entry_FE8C, &lxb_unicode_idna_map_FE8C};
static const lxb_unicode_data_t lxb_unicode_data_FE8D = {&lxb_unicode_entry_FE8D, &lxb_unicode_idna_map_FE8D};
static const lxb_unicode_data_t lxb_unicode_data_FE8E = {&lxb_unicode_entry_FE8E, &lxb_unicode_idna_map_FE8E};
static const lxb_unicode_data_t lxb_unicode_data_FE8F = {&lxb_unicode_entry_FE8F, &lxb_unicode_idna_map_FE8F};
static const lxb_unicode_data_t lxb_unicode_data_FE90 = {&lxb_unicode_entry_FE90, &lxb_unicode_idna_map_FE90};
static const lxb_unicode_data_t lxb_unicode_data_FE91 = {&lxb_unicode_entry_FE91, &lxb_unicode_idna_map_FE91};
static const lxb_unicode_data_t lxb_unicode_data_FE92 = {&lxb_unicode_entry_FE92, &lxb_unicode_idna_map_FE92};
static const lxb_unicode_data_t lxb_unicode_data_FE93 = {&lxb_unicode_entry_FE93, &lxb_unicode_idna_map_FE93};
static const lxb_unicode_data_t lxb_unicode_data_FE94 = {&lxb_unicode_entry_FE94, &lxb_unicode_idna_map_FE94};
static const lxb_unicode_data_t lxb_unicode_data_FE95 = {&lxb_unicode_entry_FE95, &lxb_unicode_idna_map_FE95};
static const lxb_unicode_data_t lxb_unicode_data_FE96 = {&lxb_unicode_entry_FE96, &lxb_unicode_idna_map_FE96};
static const lxb_unicode_data_t lxb_unicode_data_FE97 = {&lxb_unicode_entry_FE97, &lxb_unicode_idna_map_FE97};
static const lxb_unicode_data_t lxb_unicode_data_FE98 = {&lxb_unicode_entry_FE98, &lxb_unicode_idna_map_FE98};
static const lxb_unicode_data_t lxb_unicode_data_FE99 = {&lxb_unicode_entry_FE99, &lxb_unicode_idna_map_FE99};
static const lxb_unicode_data_t lxb_unicode_data_FE9A = {&lxb_unicode_entry_FE9A, &lxb_unicode_idna_map_FE9A};
static const lxb_unicode_data_t lxb_unicode_data_FE9B = {&lxb_unicode_entry_FE9B, &lxb_unicode_idna_map_FE9B};
static const lxb_unicode_data_t lxb_unicode_data_FE9C = {&lxb_unicode_entry_FE9C, &lxb_unicode_idna_map_FE9C};
static const lxb_unicode_data_t lxb_unicode_data_FE9D = {&lxb_unicode_entry_FE9D, &lxb_unicode_idna_map_FE9D};
static const lxb_unicode_data_t lxb_unicode_data_FE9E = {&lxb_unicode_entry_FE9E, &lxb_unicode_idna_map_FE9E};
static const lxb_unicode_data_t lxb_unicode_data_FE9F = {&lxb_unicode_entry_FE9F, &lxb_unicode_idna_map_FE9F};
static const lxb_unicode_data_t lxb_unicode_data_FEA0 = {&lxb_unicode_entry_FEA0, &lxb_unicode_idna_map_FEA0};
static const lxb_unicode_data_t lxb_unicode_data_FEA1 = {&lxb_unicode_entry_FEA1, &lxb_unicode_idna_map_FEA1};
static const lxb_unicode_data_t lxb_unicode_data_FEA2 = {&lxb_unicode_entry_FEA2, &lxb_unicode_idna_map_FEA2};
static const lxb_unicode_data_t lxb_unicode_data_FEA3 = {&lxb_unicode_entry_FEA3, &lxb_unicode_idna_map_FEA3};
static const lxb_unicode_data_t lxb_unicode_data_FEA4 = {&lxb_unicode_entry_FEA4, &lxb_unicode_idna_map_FEA4};
static const lxb_unicode_data_t lxb_unicode_data_FEA5 = {&lxb_unicode_entry_FEA5, &lxb_unicode_idna_map_FEA5};
static const lxb_unicode_data_t lxb_unicode_data_FEA6 = {&lxb_unicode_entry_FEA6, &lxb_unicode_idna_map_FEA6};
static const lxb_unicode_data_t lxb_unicode_data_FEA7 = {&lxb_unicode_entry_FEA7, &lxb_unicode_idna_map_FEA7};
static const lxb_unicode_data_t lxb_unicode_data_FEA8 = {&lxb_unicode_entry_FEA8, &lxb_unicode_idna_map_FEA8};
static const lxb_unicode_data_t lxb_unicode_data_FEA9 = {&lxb_unicode_entry_FEA9, &lxb_unicode_idna_map_FEA9};
static const lxb_unicode_data_t lxb_unicode_data_FEAA = {&lxb_unicode_entry_FEAA, &lxb_unicode_idna_map_FEAA};
static const lxb_unicode_data_t lxb_unicode_data_FEAB = {&lxb_unicode_entry_FEAB, &lxb_unicode_idna_map_FEAB};
static const lxb_unicode_data_t lxb_unicode_data_FEAC = {&lxb_unicode_entry_FEAC, &lxb_unicode_idna_map_FEAC};
static const lxb_unicode_data_t lxb_unicode_data_FEAD = {&lxb_unicode_entry_FEAD, &lxb_unicode_idna_map_FEAD};
static const lxb_unicode_data_t lxb_unicode_data_FEAE = {&lxb_unicode_entry_FEAE, &lxb_unicode_idna_map_FEAE};
static const lxb_unicode_data_t lxb_unicode_data_FEAF = {&lxb_unicode_entry_FEAF, &lxb_unicode_idna_map_FEAF};
static const lxb_unicode_data_t lxb_unicode_data_FEB0 = {&lxb_unicode_entry_FEB0, &lxb_unicode_idna_map_FEB0};
static const lxb_unicode_data_t lxb_unicode_data_FEB1 = {&lxb_unicode_entry_FEB1, &lxb_unicode_idna_map_FEB1};
static const lxb_unicode_data_t lxb_unicode_data_FEB2 = {&lxb_unicode_entry_FEB2, &lxb_unicode_idna_map_FEB2};
static const lxb_unicode_data_t lxb_unicode_data_FEB3 = {&lxb_unicode_entry_FEB3, &lxb_unicode_idna_map_FEB3};
static const lxb_unicode_data_t lxb_unicode_data_FEB4 = {&lxb_unicode_entry_FEB4, &lxb_unicode_idna_map_FEB4};
static const lxb_unicode_data_t lxb_unicode_data_FEB5 = {&lxb_unicode_entry_FEB5, &lxb_unicode_idna_map_FEB5};
static const lxb_unicode_data_t lxb_unicode_data_FEB6 = {&lxb_unicode_entry_FEB6, &lxb_unicode_idna_map_FEB6};
static const lxb_unicode_data_t lxb_unicode_data_FEB7 = {&lxb_unicode_entry_FEB7, &lxb_unicode_idna_map_FEB7};
static const lxb_unicode_data_t lxb_unicode_data_FEB8 = {&lxb_unicode_entry_FEB8, &lxb_unicode_idna_map_FEB8};
static const lxb_unicode_data_t lxb_unicode_data_FEB9 = {&lxb_unicode_entry_FEB9, &lxb_unicode_idna_map_FEB9};
static const lxb_unicode_data_t lxb_unicode_data_FEBA = {&lxb_unicode_entry_FEBA, &lxb_unicode_idna_map_FEBA};
static const lxb_unicode_data_t lxb_unicode_data_FEBB = {&lxb_unicode_entry_FEBB, &lxb_unicode_idna_map_FEBB};
static const lxb_unicode_data_t lxb_unicode_data_FEBC = {&lxb_unicode_entry_FEBC, &lxb_unicode_idna_map_FEBC};
static const lxb_unicode_data_t lxb_unicode_data_FEBD = {&lxb_unicode_entry_FEBD, &lxb_unicode_idna_map_FEBD};
static const lxb_unicode_data_t lxb_unicode_data_FEBE = {&lxb_unicode_entry_FEBE, &lxb_unicode_idna_map_FEBE};
static const lxb_unicode_data_t lxb_unicode_data_FEBF = {&lxb_unicode_entry_FEBF, &lxb_unicode_idna_map_FEBF};
static const lxb_unicode_data_t lxb_unicode_data_FEC0 = {&lxb_unicode_entry_FEC0, &lxb_unicode_idna_map_FEC0};
static const lxb_unicode_data_t lxb_unicode_data_FEC1 = {&lxb_unicode_entry_FEC1, &lxb_unicode_idna_map_FEC1};
static const lxb_unicode_data_t lxb_unicode_data_FEC2 = {&lxb_unicode_entry_FEC2, &lxb_unicode_idna_map_FEC2};
static const lxb_unicode_data_t lxb_unicode_data_FEC3 = {&lxb_unicode_entry_FEC3, &lxb_unicode_idna_map_FEC3};
static const lxb_unicode_data_t lxb_unicode_data_FEC4 = {&lxb_unicode_entry_FEC4, &lxb_unicode_idna_map_FEC4};
static const lxb_unicode_data_t lxb_unicode_data_FEC5 = {&lxb_unicode_entry_FEC5, &lxb_unicode_idna_map_FEC5};
static const lxb_unicode_data_t lxb_unicode_data_FEC6 = {&lxb_unicode_entry_FEC6, &lxb_unicode_idna_map_FEC6};
static const lxb_unicode_data_t lxb_unicode_data_FEC7 = {&lxb_unicode_entry_FEC7, &lxb_unicode_idna_map_FEC7};
static const lxb_unicode_data_t lxb_unicode_data_FEC8 = {&lxb_unicode_entry_FEC8, &lxb_unicode_idna_map_FEC8};
static const lxb_unicode_data_t lxb_unicode_data_FEC9 = {&lxb_unicode_entry_FEC9, &lxb_unicode_idna_map_FEC9};
static const lxb_unicode_data_t lxb_unicode_data_FECA = {&lxb_unicode_entry_FECA, &lxb_unicode_idna_map_FECA};
static const lxb_unicode_data_t lxb_unicode_data_FECB = {&lxb_unicode_entry_FECB, &lxb_unicode_idna_map_FECB};
static const lxb_unicode_data_t lxb_unicode_data_FECC = {&lxb_unicode_entry_FECC, &lxb_unicode_idna_map_FECC};
static const lxb_unicode_data_t lxb_unicode_data_FECD = {&lxb_unicode_entry_FECD, &lxb_unicode_idna_map_FECD};
static const lxb_unicode_data_t lxb_unicode_data_FECE = {&lxb_unicode_entry_FECE, &lxb_unicode_idna_map_FECE};
static const lxb_unicode_data_t lxb_unicode_data_FECF = {&lxb_unicode_entry_FECF, &lxb_unicode_idna_map_FECF};
static const lxb_unicode_data_t lxb_unicode_data_FED0 = {&lxb_unicode_entry_FED0, &lxb_unicode_idna_map_FED0};
static const lxb_unicode_data_t lxb_unicode_data_FED1 = {&lxb_unicode_entry_FED1, &lxb_unicode_idna_map_FED1};
static const lxb_unicode_data_t lxb_unicode_data_FED2 = {&lxb_unicode_entry_FED2, &lxb_unicode_idna_map_FED2};
static const lxb_unicode_data_t lxb_unicode_data_FED3 = {&lxb_unicode_entry_FED3, &lxb_unicode_idna_map_FED3};
static const lxb_unicode_data_t lxb_unicode_data_FED4 = {&lxb_unicode_entry_FED4, &lxb_unicode_idna_map_FED4};
static const lxb_unicode_data_t lxb_unicode_data_FED5 = {&lxb_unicode_entry_FED5, &lxb_unicode_idna_map_FED5};
static const lxb_unicode_data_t lxb_unicode_data_FED6 = {&lxb_unicode_entry_FED6, &lxb_unicode_idna_map_FED6};
static const lxb_unicode_data_t lxb_unicode_data_FED7 = {&lxb_unicode_entry_FED7, &lxb_unicode_idna_map_FED7};
static const lxb_unicode_data_t lxb_unicode_data_FED8 = {&lxb_unicode_entry_FED8, &lxb_unicode_idna_map_FED8};
static const lxb_unicode_data_t lxb_unicode_data_FED9 = {&lxb_unicode_entry_FED9, &lxb_unicode_idna_map_FED9};
static const lxb_unicode_data_t lxb_unicode_data_FEDA = {&lxb_unicode_entry_FEDA, &lxb_unicode_idna_map_FEDA};
static const lxb_unicode_data_t lxb_unicode_data_FEDB = {&lxb_unicode_entry_FEDB, &lxb_unicode_idna_map_FEDB};
static const lxb_unicode_data_t lxb_unicode_data_FEDC = {&lxb_unicode_entry_FEDC, &lxb_unicode_idna_map_FEDC};
static const lxb_unicode_data_t lxb_unicode_data_FEDD = {&lxb_unicode_entry_FEDD, &lxb_unicode_idna_map_FEDD};
static const lxb_unicode_data_t lxb_unicode_data_FEDE = {&lxb_unicode_entry_FEDE, &lxb_unicode_idna_map_FEDE};
static const lxb_unicode_data_t lxb_unicode_data_FEDF = {&lxb_unicode_entry_FEDF, &lxb_unicode_idna_map_FEDF};
static const lxb_unicode_data_t lxb_unicode_data_FEE0 = {&lxb_unicode_entry_FEE0, &lxb_unicode_idna_map_FEE0};
static const lxb_unicode_data_t lxb_unicode_data_FEE1 = {&lxb_unicode_entry_FEE1, &lxb_unicode_idna_map_FEE1};
static const lxb_unicode_data_t lxb_unicode_data_FEE2 = {&lxb_unicode_entry_FEE2, &lxb_unicode_idna_map_FEE2};
static const lxb_unicode_data_t lxb_unicode_data_FEE3 = {&lxb_unicode_entry_FEE3, &lxb_unicode_idna_map_FEE3};
static const lxb_unicode_data_t lxb_unicode_data_FEE4 = {&lxb_unicode_entry_FEE4, &lxb_unicode_idna_map_FEE4};
static const lxb_unicode_data_t lxb_unicode_data_FEE5 = {&lxb_unicode_entry_FEE5, &lxb_unicode_idna_map_FEE5};
static const lxb_unicode_data_t lxb_unicode_data_FEE6 = {&lxb_unicode_entry_FEE6, &lxb_unicode_idna_map_FEE6};
static const lxb_unicode_data_t lxb_unicode_data_FEE7 = {&lxb_unicode_entry_FEE7, &lxb_unicode_idna_map_FEE7};
static const lxb_unicode_data_t lxb_unicode_data_FEE8 = {&lxb_unicode_entry_FEE8, &lxb_unicode_idna_map_FEE8};
static const lxb_unicode_data_t lxb_unicode_data_FEE9 = {&lxb_unicode_entry_FEE9, &lxb_unicode_idna_map_FEE9};
static const lxb_unicode_data_t lxb_unicode_data_FEEA = {&lxb_unicode_entry_FEEA, &lxb_unicode_idna_map_FEEA};
static const lxb_unicode_data_t lxb_unicode_data_FEEB = {&lxb_unicode_entry_FEEB, &lxb_unicode_idna_map_FEEB};
static const lxb_unicode_data_t lxb_unicode_data_FEEC = {&lxb_unicode_entry_FEEC, &lxb_unicode_idna_map_FEEC};
static const lxb_unicode_data_t lxb_unicode_data_FEED = {&lxb_unicode_entry_FEED, &lxb_unicode_idna_map_FEED};
static const lxb_unicode_data_t lxb_unicode_data_FEEE = {&lxb_unicode_entry_FEEE, &lxb_unicode_idna_map_FEEE};
static const lxb_unicode_data_t lxb_unicode_data_FEEF = {&lxb_unicode_entry_FEEF, &lxb_unicode_idna_map_FEEF};
static const lxb_unicode_data_t lxb_unicode_data_FEF0 = {&lxb_unicode_entry_FEF0, &lxb_unicode_idna_map_FEF0};
static const lxb_unicode_data_t lxb_unicode_data_FEF1 = {&lxb_unicode_entry_FEF1, &lxb_unicode_idna_map_FEF1};
static const lxb_unicode_data_t lxb_unicode_data_FEF2 = {&lxb_unicode_entry_FEF2, &lxb_unicode_idna_map_FEF2};
static const lxb_unicode_data_t lxb_unicode_data_FEF3 = {&lxb_unicode_entry_FEF3, &lxb_unicode_idna_map_FEF3};
static const lxb_unicode_data_t lxb_unicode_data_FEF4 = {&lxb_unicode_entry_FEF4, &lxb_unicode_idna_map_FEF4};
static const lxb_unicode_data_t lxb_unicode_data_FEF5 = {&lxb_unicode_entry_FEF5, &lxb_unicode_idna_map_FEF5};
static const lxb_unicode_data_t lxb_unicode_data_FEF6 = {&lxb_unicode_entry_FEF6, &lxb_unicode_idna_map_FEF6};
static const lxb_unicode_data_t lxb_unicode_data_FEF7 = {&lxb_unicode_entry_FEF7, &lxb_unicode_idna_map_FEF7};
static const lxb_unicode_data_t lxb_unicode_data_FEF8 = {&lxb_unicode_entry_FEF8, &lxb_unicode_idna_map_FEF8};
static const lxb_unicode_data_t lxb_unicode_data_FEF9 = {&lxb_unicode_entry_FEF9, &lxb_unicode_idna_map_FEF9};
static const lxb_unicode_data_t lxb_unicode_data_FEFA = {&lxb_unicode_entry_FEFA, &lxb_unicode_idna_map_FEFA};
static const lxb_unicode_data_t lxb_unicode_data_FEFB = {&lxb_unicode_entry_FEFB, &lxb_unicode_idna_map_FEFB};
static const lxb_unicode_data_t lxb_unicode_data_FEFC = {&lxb_unicode_entry_FEFC, &lxb_unicode_idna_map_FEFC};
static const lxb_unicode_data_t lxb_unicode_data_FF01 = {&lxb_unicode_entry_FF01, &lxb_unicode_idna_map_FF01};
static const lxb_unicode_data_t lxb_unicode_data_FF02 = {&lxb_unicode_entry_FF02, &lxb_unicode_idna_map_FF02};
static const lxb_unicode_data_t lxb_unicode_data_FF03 = {&lxb_unicode_entry_FF03, &lxb_unicode_idna_map_FF03};
static const lxb_unicode_data_t lxb_unicode_data_FF04 = {&lxb_unicode_entry_FF04, &lxb_unicode_idna_map_FF04};
static const lxb_unicode_data_t lxb_unicode_data_FF05 = {&lxb_unicode_entry_FF05, &lxb_unicode_idna_map_FF05};
static const lxb_unicode_data_t lxb_unicode_data_FF06 = {&lxb_unicode_entry_FF06, &lxb_unicode_idna_map_FF06};
static const lxb_unicode_data_t lxb_unicode_data_FF07 = {&lxb_unicode_entry_FF07, &lxb_unicode_idna_map_FF07};
static const lxb_unicode_data_t lxb_unicode_data_FF08 = {&lxb_unicode_entry_FF08, &lxb_unicode_idna_map_FF08};
static const lxb_unicode_data_t lxb_unicode_data_FF09 = {&lxb_unicode_entry_FF09, &lxb_unicode_idna_map_FF09};
static const lxb_unicode_data_t lxb_unicode_data_FF0A = {&lxb_unicode_entry_FF0A, &lxb_unicode_idna_map_FF0A};
static const lxb_unicode_data_t lxb_unicode_data_FF0B = {&lxb_unicode_entry_FF0B, &lxb_unicode_idna_map_FF0B};
static const lxb_unicode_data_t lxb_unicode_data_FF0C = {&lxb_unicode_entry_FF0C, &lxb_unicode_idna_map_FF0C};
static const lxb_unicode_data_t lxb_unicode_data_FF0D = {&lxb_unicode_entry_FF0D, &lxb_unicode_idna_map_FF0D};
static const lxb_unicode_data_t lxb_unicode_data_FF0E = {&lxb_unicode_entry_FF0E, &lxb_unicode_idna_map_FF0E};
static const lxb_unicode_data_t lxb_unicode_data_FF0F = {&lxb_unicode_entry_FF0F, &lxb_unicode_idna_map_FF0F};
static const lxb_unicode_data_t lxb_unicode_data_FF10 = {&lxb_unicode_entry_FF10, &lxb_unicode_idna_map_FF10};
static const lxb_unicode_data_t lxb_unicode_data_FF11 = {&lxb_unicode_entry_FF11, &lxb_unicode_idna_map_FF11};
static const lxb_unicode_data_t lxb_unicode_data_FF12 = {&lxb_unicode_entry_FF12, &lxb_unicode_idna_map_FF12};
static const lxb_unicode_data_t lxb_unicode_data_FF13 = {&lxb_unicode_entry_FF13, &lxb_unicode_idna_map_FF13};
static const lxb_unicode_data_t lxb_unicode_data_FF14 = {&lxb_unicode_entry_FF14, &lxb_unicode_idna_map_FF14};
static const lxb_unicode_data_t lxb_unicode_data_FF15 = {&lxb_unicode_entry_FF15, &lxb_unicode_idna_map_FF15};
static const lxb_unicode_data_t lxb_unicode_data_FF16 = {&lxb_unicode_entry_FF16, &lxb_unicode_idna_map_FF16};
static const lxb_unicode_data_t lxb_unicode_data_FF17 = {&lxb_unicode_entry_FF17, &lxb_unicode_idna_map_FF17};
static const lxb_unicode_data_t lxb_unicode_data_FF18 = {&lxb_unicode_entry_FF18, &lxb_unicode_idna_map_FF18};
static const lxb_unicode_data_t lxb_unicode_data_FF19 = {&lxb_unicode_entry_FF19, &lxb_unicode_idna_map_FF19};
static const lxb_unicode_data_t lxb_unicode_data_FF1A = {&lxb_unicode_entry_FF1A, &lxb_unicode_idna_map_FF1A};
static const lxb_unicode_data_t lxb_unicode_data_FF1B = {&lxb_unicode_entry_FF1B, &lxb_unicode_idna_map_FF1B};
static const lxb_unicode_data_t lxb_unicode_data_FF1C = {&lxb_unicode_entry_FF1C, &lxb_unicode_idna_map_FF1C};
static const lxb_unicode_data_t lxb_unicode_data_FF1D = {&lxb_unicode_entry_FF1D, &lxb_unicode_idna_map_FF1D};
static const lxb_unicode_data_t lxb_unicode_data_FF1E = {&lxb_unicode_entry_FF1E, &lxb_unicode_idna_map_FF1E};
static const lxb_unicode_data_t lxb_unicode_data_FF1F = {&lxb_unicode_entry_FF1F, &lxb_unicode_idna_map_FF1F};
static const lxb_unicode_data_t lxb_unicode_data_FF20 = {&lxb_unicode_entry_FF20, &lxb_unicode_idna_map_FF20};
static const lxb_unicode_data_t lxb_unicode_data_FF21 = {&lxb_unicode_entry_FF21, &lxb_unicode_idna_map_FF21};
static const lxb_unicode_data_t lxb_unicode_data_FF22 = {&lxb_unicode_entry_FF22, &lxb_unicode_idna_map_FF22};
static const lxb_unicode_data_t lxb_unicode_data_FF23 = {&lxb_unicode_entry_FF23, &lxb_unicode_idna_map_FF23};
static const lxb_unicode_data_t lxb_unicode_data_FF24 = {&lxb_unicode_entry_FF24, &lxb_unicode_idna_map_FF24};
static const lxb_unicode_data_t lxb_unicode_data_FF25 = {&lxb_unicode_entry_FF25, &lxb_unicode_idna_map_FF25};
static const lxb_unicode_data_t lxb_unicode_data_FF26 = {&lxb_unicode_entry_FF26, &lxb_unicode_idna_map_FF26};
static const lxb_unicode_data_t lxb_unicode_data_FF27 = {&lxb_unicode_entry_FF27, &lxb_unicode_idna_map_FF27};
static const lxb_unicode_data_t lxb_unicode_data_FF28 = {&lxb_unicode_entry_FF28, &lxb_unicode_idna_map_FF28};
static const lxb_unicode_data_t lxb_unicode_data_FF29 = {&lxb_unicode_entry_FF29, &lxb_unicode_idna_map_FF29};
static const lxb_unicode_data_t lxb_unicode_data_FF2A = {&lxb_unicode_entry_FF2A, &lxb_unicode_idna_map_FF2A};
static const lxb_unicode_data_t lxb_unicode_data_FF2B = {&lxb_unicode_entry_FF2B, &lxb_unicode_idna_map_FF2B};
static const lxb_unicode_data_t lxb_unicode_data_FF2C = {&lxb_unicode_entry_FF2C, &lxb_unicode_idna_map_FF2C};
static const lxb_unicode_data_t lxb_unicode_data_FF2D = {&lxb_unicode_entry_FF2D, &lxb_unicode_idna_map_FF2D};
static const lxb_unicode_data_t lxb_unicode_data_FF2E = {&lxb_unicode_entry_FF2E, &lxb_unicode_idna_map_FF2E};
static const lxb_unicode_data_t lxb_unicode_data_FF2F = {&lxb_unicode_entry_FF2F, &lxb_unicode_idna_map_FF2F};
static const lxb_unicode_data_t lxb_unicode_data_FF30 = {&lxb_unicode_entry_FF30, &lxb_unicode_idna_map_FF30};
static const lxb_unicode_data_t lxb_unicode_data_FF31 = {&lxb_unicode_entry_FF31, &lxb_unicode_idna_map_FF31};
static const lxb_unicode_data_t lxb_unicode_data_FF32 = {&lxb_unicode_entry_FF32, &lxb_unicode_idna_map_FF32};
static const lxb_unicode_data_t lxb_unicode_data_FF33 = {&lxb_unicode_entry_FF33, &lxb_unicode_idna_map_FF33};
static const lxb_unicode_data_t lxb_unicode_data_FF34 = {&lxb_unicode_entry_FF34, &lxb_unicode_idna_map_FF34};
static const lxb_unicode_data_t lxb_unicode_data_FF35 = {&lxb_unicode_entry_FF35, &lxb_unicode_idna_map_FF35};
static const lxb_unicode_data_t lxb_unicode_data_FF36 = {&lxb_unicode_entry_FF36, &lxb_unicode_idna_map_FF36};
static const lxb_unicode_data_t lxb_unicode_data_FF37 = {&lxb_unicode_entry_FF37, &lxb_unicode_idna_map_FF37};
static const lxb_unicode_data_t lxb_unicode_data_FF38 = {&lxb_unicode_entry_FF38, &lxb_unicode_idna_map_FF38};
static const lxb_unicode_data_t lxb_unicode_data_FF39 = {&lxb_unicode_entry_FF39, &lxb_unicode_idna_map_FF39};
static const lxb_unicode_data_t lxb_unicode_data_FF3A = {&lxb_unicode_entry_FF3A, &lxb_unicode_idna_map_FF3A};
static const lxb_unicode_data_t lxb_unicode_data_FF3B = {&lxb_unicode_entry_FF3B, &lxb_unicode_idna_map_FF3B};
static const lxb_unicode_data_t lxb_unicode_data_FF3C = {&lxb_unicode_entry_FF3C, &lxb_unicode_idna_map_FF3C};
static const lxb_unicode_data_t lxb_unicode_data_FF3D = {&lxb_unicode_entry_FF3D, &lxb_unicode_idna_map_FF3D};
static const lxb_unicode_data_t lxb_unicode_data_FF3E = {&lxb_unicode_entry_FF3E, &lxb_unicode_idna_map_FF3E};
static const lxb_unicode_data_t lxb_unicode_data_FF3F = {&lxb_unicode_entry_FF3F, &lxb_unicode_idna_map_FF3F};
static const lxb_unicode_data_t lxb_unicode_data_FF40 = {&lxb_unicode_entry_FF40, &lxb_unicode_idna_map_FF40};
static const lxb_unicode_data_t lxb_unicode_data_FF41 = {&lxb_unicode_entry_FF41, &lxb_unicode_idna_map_FF41};
static const lxb_unicode_data_t lxb_unicode_data_FF42 = {&lxb_unicode_entry_FF42, &lxb_unicode_idna_map_FF42};
static const lxb_unicode_data_t lxb_unicode_data_FF43 = {&lxb_unicode_entry_FF43, &lxb_unicode_idna_map_FF43};
static const lxb_unicode_data_t lxb_unicode_data_FF44 = {&lxb_unicode_entry_FF44, &lxb_unicode_idna_map_FF44};
static const lxb_unicode_data_t lxb_unicode_data_FF45 = {&lxb_unicode_entry_FF45, &lxb_unicode_idna_map_FF45};
static const lxb_unicode_data_t lxb_unicode_data_FF46 = {&lxb_unicode_entry_FF46, &lxb_unicode_idna_map_FF46};
static const lxb_unicode_data_t lxb_unicode_data_FF47 = {&lxb_unicode_entry_FF47, &lxb_unicode_idna_map_FF47};
static const lxb_unicode_data_t lxb_unicode_data_FF48 = {&lxb_unicode_entry_FF48, &lxb_unicode_idna_map_FF48};
static const lxb_unicode_data_t lxb_unicode_data_FF49 = {&lxb_unicode_entry_FF49, &lxb_unicode_idna_map_FF49};
static const lxb_unicode_data_t lxb_unicode_data_FF4A = {&lxb_unicode_entry_FF4A, &lxb_unicode_idna_map_FF4A};
static const lxb_unicode_data_t lxb_unicode_data_FF4B = {&lxb_unicode_entry_FF4B, &lxb_unicode_idna_map_FF4B};
static const lxb_unicode_data_t lxb_unicode_data_FF4C = {&lxb_unicode_entry_FF4C, &lxb_unicode_idna_map_FF4C};
static const lxb_unicode_data_t lxb_unicode_data_FF4D = {&lxb_unicode_entry_FF4D, &lxb_unicode_idna_map_FF4D};
static const lxb_unicode_data_t lxb_unicode_data_FF4E = {&lxb_unicode_entry_FF4E, &lxb_unicode_idna_map_FF4E};
static const lxb_unicode_data_t lxb_unicode_data_FF4F = {&lxb_unicode_entry_FF4F, &lxb_unicode_idna_map_FF4F};
static const lxb_unicode_data_t lxb_unicode_data_FF50 = {&lxb_unicode_entry_FF50, &lxb_unicode_idna_map_FF50};
static const lxb_unicode_data_t lxb_unicode_data_FF51 = {&lxb_unicode_entry_FF51, &lxb_unicode_idna_map_FF51};
static const lxb_unicode_data_t lxb_unicode_data_FF52 = {&lxb_unicode_entry_FF52, &lxb_unicode_idna_map_FF52};
static const lxb_unicode_data_t lxb_unicode_data_FF53 = {&lxb_unicode_entry_FF53, &lxb_unicode_idna_map_FF53};
static const lxb_unicode_data_t lxb_unicode_data_FF54 = {&lxb_unicode_entry_FF54, &lxb_unicode_idna_map_FF54};
static const lxb_unicode_data_t lxb_unicode_data_FF55 = {&lxb_unicode_entry_FF55, &lxb_unicode_idna_map_FF55};
static const lxb_unicode_data_t lxb_unicode_data_FF56 = {&lxb_unicode_entry_FF56, &lxb_unicode_idna_map_FF56};
static const lxb_unicode_data_t lxb_unicode_data_FF57 = {&lxb_unicode_entry_FF57, &lxb_unicode_idna_map_FF57};
static const lxb_unicode_data_t lxb_unicode_data_FF58 = {&lxb_unicode_entry_FF58, &lxb_unicode_idna_map_FF58};
static const lxb_unicode_data_t lxb_unicode_data_FF59 = {&lxb_unicode_entry_FF59, &lxb_unicode_idna_map_FF59};
static const lxb_unicode_data_t lxb_unicode_data_FF5A = {&lxb_unicode_entry_FF5A, &lxb_unicode_idna_map_FF5A};
static const lxb_unicode_data_t lxb_unicode_data_FF5B = {&lxb_unicode_entry_FF5B, &lxb_unicode_idna_map_FF5B};
static const lxb_unicode_data_t lxb_unicode_data_FF5C = {&lxb_unicode_entry_FF5C, &lxb_unicode_idna_map_FF5C};
static const lxb_unicode_data_t lxb_unicode_data_FF5D = {&lxb_unicode_entry_FF5D, &lxb_unicode_idna_map_FF5D};
static const lxb_unicode_data_t lxb_unicode_data_FF5E = {&lxb_unicode_entry_FF5E, &lxb_unicode_idna_map_FF5E};
static const lxb_unicode_data_t lxb_unicode_data_FF5F = {&lxb_unicode_entry_FF5F, &lxb_unicode_idna_map_FF5F};
static const lxb_unicode_data_t lxb_unicode_data_FF60 = {&lxb_unicode_entry_FF60, &lxb_unicode_idna_map_FF60};
static const lxb_unicode_data_t lxb_unicode_data_FF61 = {&lxb_unicode_entry_FF61, &lxb_unicode_idna_map_FF61};
static const lxb_unicode_data_t lxb_unicode_data_FF62 = {&lxb_unicode_entry_FF62, &lxb_unicode_idna_map_FF62};
static const lxb_unicode_data_t lxb_unicode_data_FF63 = {&lxb_unicode_entry_FF63, &lxb_unicode_idna_map_FF63};
static const lxb_unicode_data_t lxb_unicode_data_FF64 = {&lxb_unicode_entry_FF64, &lxb_unicode_idna_map_FF64};
static const lxb_unicode_data_t lxb_unicode_data_FF65 = {&lxb_unicode_entry_FF65, &lxb_unicode_idna_map_FF65};
static const lxb_unicode_data_t lxb_unicode_data_FF66 = {&lxb_unicode_entry_FF66, &lxb_unicode_idna_map_FF66};
static const lxb_unicode_data_t lxb_unicode_data_FF67 = {&lxb_unicode_entry_FF67, &lxb_unicode_idna_map_FF67};
static const lxb_unicode_data_t lxb_unicode_data_FF68 = {&lxb_unicode_entry_FF68, &lxb_unicode_idna_map_FF68};
static const lxb_unicode_data_t lxb_unicode_data_FF69 = {&lxb_unicode_entry_FF69, &lxb_unicode_idna_map_FF69};
static const lxb_unicode_data_t lxb_unicode_data_FF6A = {&lxb_unicode_entry_FF6A, &lxb_unicode_idna_map_FF6A};
static const lxb_unicode_data_t lxb_unicode_data_FF6B = {&lxb_unicode_entry_FF6B, &lxb_unicode_idna_map_FF6B};
static const lxb_unicode_data_t lxb_unicode_data_FF6C = {&lxb_unicode_entry_FF6C, &lxb_unicode_idna_map_FF6C};
static const lxb_unicode_data_t lxb_unicode_data_FF6D = {&lxb_unicode_entry_FF6D, &lxb_unicode_idna_map_FF6D};
static const lxb_unicode_data_t lxb_unicode_data_FF6E = {&lxb_unicode_entry_FF6E, &lxb_unicode_idna_map_FF6E};
static const lxb_unicode_data_t lxb_unicode_data_FF6F = {&lxb_unicode_entry_FF6F, &lxb_unicode_idna_map_FF6F};
static const lxb_unicode_data_t lxb_unicode_data_FF70 = {&lxb_unicode_entry_FF70, &lxb_unicode_idna_map_FF70};
static const lxb_unicode_data_t lxb_unicode_data_FF71 = {&lxb_unicode_entry_FF71, &lxb_unicode_idna_map_FF71};
static const lxb_unicode_data_t lxb_unicode_data_FF72 = {&lxb_unicode_entry_FF72, &lxb_unicode_idna_map_FF72};
static const lxb_unicode_data_t lxb_unicode_data_FF73 = {&lxb_unicode_entry_FF73, &lxb_unicode_idna_map_FF73};
static const lxb_unicode_data_t lxb_unicode_data_FF74 = {&lxb_unicode_entry_FF74, &lxb_unicode_idna_map_FF74};
static const lxb_unicode_data_t lxb_unicode_data_FF75 = {&lxb_unicode_entry_FF75, &lxb_unicode_idna_map_FF75};
static const lxb_unicode_data_t lxb_unicode_data_FF76 = {&lxb_unicode_entry_FF76, &lxb_unicode_idna_map_FF76};
static const lxb_unicode_data_t lxb_unicode_data_FF77 = {&lxb_unicode_entry_FF77, &lxb_unicode_idna_map_FF77};
static const lxb_unicode_data_t lxb_unicode_data_FF78 = {&lxb_unicode_entry_FF78, &lxb_unicode_idna_map_FF78};
static const lxb_unicode_data_t lxb_unicode_data_FF79 = {&lxb_unicode_entry_FF79, &lxb_unicode_idna_map_FF79};
static const lxb_unicode_data_t lxb_unicode_data_FF7A = {&lxb_unicode_entry_FF7A, &lxb_unicode_idna_map_FF7A};
static const lxb_unicode_data_t lxb_unicode_data_FF7B = {&lxb_unicode_entry_FF7B, &lxb_unicode_idna_map_FF7B};
static const lxb_unicode_data_t lxb_unicode_data_FF7C = {&lxb_unicode_entry_FF7C, &lxb_unicode_idna_map_FF7C};
static const lxb_unicode_data_t lxb_unicode_data_FF7D = {&lxb_unicode_entry_FF7D, &lxb_unicode_idna_map_FF7D};
static const lxb_unicode_data_t lxb_unicode_data_FF7E = {&lxb_unicode_entry_FF7E, &lxb_unicode_idna_map_FF7E};
static const lxb_unicode_data_t lxb_unicode_data_FF7F = {&lxb_unicode_entry_FF7F, &lxb_unicode_idna_map_FF7F};
static const lxb_unicode_data_t lxb_unicode_data_FF80 = {&lxb_unicode_entry_FF80, &lxb_unicode_idna_map_FF80};
static const lxb_unicode_data_t lxb_unicode_data_FF81 = {&lxb_unicode_entry_FF81, &lxb_unicode_idna_map_FF81};
static const lxb_unicode_data_t lxb_unicode_data_FF82 = {&lxb_unicode_entry_FF82, &lxb_unicode_idna_map_FF82};
static const lxb_unicode_data_t lxb_unicode_data_FF83 = {&lxb_unicode_entry_FF83, &lxb_unicode_idna_map_FF83};
static const lxb_unicode_data_t lxb_unicode_data_FF84 = {&lxb_unicode_entry_FF84, &lxb_unicode_idna_map_FF84};
static const lxb_unicode_data_t lxb_unicode_data_FF85 = {&lxb_unicode_entry_FF85, &lxb_unicode_idna_map_FF85};
static const lxb_unicode_data_t lxb_unicode_data_FF86 = {&lxb_unicode_entry_FF86, &lxb_unicode_idna_map_FF86};
static const lxb_unicode_data_t lxb_unicode_data_FF87 = {&lxb_unicode_entry_FF87, &lxb_unicode_idna_map_FF87};
static const lxb_unicode_data_t lxb_unicode_data_FF88 = {&lxb_unicode_entry_FF88, &lxb_unicode_idna_map_FF88};
static const lxb_unicode_data_t lxb_unicode_data_FF89 = {&lxb_unicode_entry_FF89, &lxb_unicode_idna_map_FF89};
static const lxb_unicode_data_t lxb_unicode_data_FF8A = {&lxb_unicode_entry_FF8A, &lxb_unicode_idna_map_FF8A};
static const lxb_unicode_data_t lxb_unicode_data_FF8B = {&lxb_unicode_entry_FF8B, &lxb_unicode_idna_map_FF8B};
static const lxb_unicode_data_t lxb_unicode_data_FF8C = {&lxb_unicode_entry_FF8C, &lxb_unicode_idna_map_FF8C};
static const lxb_unicode_data_t lxb_unicode_data_FF8D = {&lxb_unicode_entry_FF8D, &lxb_unicode_idna_map_FF8D};
static const lxb_unicode_data_t lxb_unicode_data_FF8E = {&lxb_unicode_entry_FF8E, &lxb_unicode_idna_map_FF8E};
static const lxb_unicode_data_t lxb_unicode_data_FF8F = {&lxb_unicode_entry_FF8F, &lxb_unicode_idna_map_FF8F};
static const lxb_unicode_data_t lxb_unicode_data_FF90 = {&lxb_unicode_entry_FF90, &lxb_unicode_idna_map_FF90};
static const lxb_unicode_data_t lxb_unicode_data_FF91 = {&lxb_unicode_entry_FF91, &lxb_unicode_idna_map_FF91};
static const lxb_unicode_data_t lxb_unicode_data_FF92 = {&lxb_unicode_entry_FF92, &lxb_unicode_idna_map_FF92};
static const lxb_unicode_data_t lxb_unicode_data_FF93 = {&lxb_unicode_entry_FF93, &lxb_unicode_idna_map_FF93};
static const lxb_unicode_data_t lxb_unicode_data_FF94 = {&lxb_unicode_entry_FF94, &lxb_unicode_idna_map_FF94};
static const lxb_unicode_data_t lxb_unicode_data_FF95 = {&lxb_unicode_entry_FF95, &lxb_unicode_idna_map_FF95};
static const lxb_unicode_data_t lxb_unicode_data_FF96 = {&lxb_unicode_entry_FF96, &lxb_unicode_idna_map_FF96};
static const lxb_unicode_data_t lxb_unicode_data_FF97 = {&lxb_unicode_entry_FF97, &lxb_unicode_idna_map_FF97};
static const lxb_unicode_data_t lxb_unicode_data_FF98 = {&lxb_unicode_entry_FF98, &lxb_unicode_idna_map_FF98};
static const lxb_unicode_data_t lxb_unicode_data_FF99 = {&lxb_unicode_entry_FF99, &lxb_unicode_idna_map_FF99};
static const lxb_unicode_data_t lxb_unicode_data_FF9A = {&lxb_unicode_entry_FF9A, &lxb_unicode_idna_map_FF9A};
static const lxb_unicode_data_t lxb_unicode_data_FF9B = {&lxb_unicode_entry_FF9B, &lxb_unicode_idna_map_FF9B};
static const lxb_unicode_data_t lxb_unicode_data_FF9C = {&lxb_unicode_entry_FF9C, &lxb_unicode_idna_map_FF9C};
static const lxb_unicode_data_t lxb_unicode_data_FF9D = {&lxb_unicode_entry_FF9D, &lxb_unicode_idna_map_FF9D};
static const lxb_unicode_data_t lxb_unicode_data_FF9E = {&lxb_unicode_entry_FF9E, &lxb_unicode_idna_map_FF9E};
static const lxb_unicode_data_t lxb_unicode_data_FF9F = {&lxb_unicode_entry_FF9F, &lxb_unicode_idna_map_FF9F};
static const lxb_unicode_data_t lxb_unicode_data_FFA0 = {&lxb_unicode_entry_FFA0, NULL};
static const lxb_unicode_data_t lxb_unicode_data_FFA1 = {&lxb_unicode_entry_FFA1, &lxb_unicode_idna_map_FFA1};
static const lxb_unicode_data_t lxb_unicode_data_FFA2 = {&lxb_unicode_entry_FFA2, &lxb_unicode_idna_map_FFA2};
static const lxb_unicode_data_t lxb_unicode_data_FFA3 = {&lxb_unicode_entry_FFA3, &lxb_unicode_idna_map_FFA3};
static const lxb_unicode_data_t lxb_unicode_data_FFA4 = {&lxb_unicode_entry_FFA4, &lxb_unicode_idna_map_FFA4};
static const lxb_unicode_data_t lxb_unicode_data_FFA5 = {&lxb_unicode_entry_FFA5, &lxb_unicode_idna_map_FFA5};
static const lxb_unicode_data_t lxb_unicode_data_FFA6 = {&lxb_unicode_entry_FFA6, &lxb_unicode_idna_map_FFA6};
static const lxb_unicode_data_t lxb_unicode_data_FFA7 = {&lxb_unicode_entry_FFA7, &lxb_unicode_idna_map_FFA7};
static const lxb_unicode_data_t lxb_unicode_data_FFA8 = {&lxb_unicode_entry_FFA8, &lxb_unicode_idna_map_FFA8};
static const lxb_unicode_data_t lxb_unicode_data_FFA9 = {&lxb_unicode_entry_FFA9, &lxb_unicode_idna_map_FFA9};
static const lxb_unicode_data_t lxb_unicode_data_FFAA = {&lxb_unicode_entry_FFAA, &lxb_unicode_idna_map_FFAA};
static const lxb_unicode_data_t lxb_unicode_data_FFAB = {&lxb_unicode_entry_FFAB, &lxb_unicode_idna_map_FFAB};
static const lxb_unicode_data_t lxb_unicode_data_FFAC = {&lxb_unicode_entry_FFAC, &lxb_unicode_idna_map_FFAC};
static const lxb_unicode_data_t lxb_unicode_data_FFAD = {&lxb_unicode_entry_FFAD, &lxb_unicode_idna_map_FFAD};
static const lxb_unicode_data_t lxb_unicode_data_FFAE = {&lxb_unicode_entry_FFAE, &lxb_unicode_idna_map_FFAE};
static const lxb_unicode_data_t lxb_unicode_data_FFAF = {&lxb_unicode_entry_FFAF, &lxb_unicode_idna_map_FFAF};
static const lxb_unicode_data_t lxb_unicode_data_FFB0 = {&lxb_unicode_entry_FFB0, &lxb_unicode_idna_map_FFB0};
static const lxb_unicode_data_t lxb_unicode_data_FFB1 = {&lxb_unicode_entry_FFB1, &lxb_unicode_idna_map_FFB1};
static const lxb_unicode_data_t lxb_unicode_data_FFB2 = {&lxb_unicode_entry_FFB2, &lxb_unicode_idna_map_FFB2};
static const lxb_unicode_data_t lxb_unicode_data_FFB3 = {&lxb_unicode_entry_FFB3, &lxb_unicode_idna_map_FFB3};
static const lxb_unicode_data_t lxb_unicode_data_FFB4 = {&lxb_unicode_entry_FFB4, &lxb_unicode_idna_map_FFB4};
static const lxb_unicode_data_t lxb_unicode_data_FFB5 = {&lxb_unicode_entry_FFB5, &lxb_unicode_idna_map_FFB5};
static const lxb_unicode_data_t lxb_unicode_data_FFB6 = {&lxb_unicode_entry_FFB6, &lxb_unicode_idna_map_FFB6};
static const lxb_unicode_data_t lxb_unicode_data_FFB7 = {&lxb_unicode_entry_FFB7, &lxb_unicode_idna_map_FFB7};
static const lxb_unicode_data_t lxb_unicode_data_FFB8 = {&lxb_unicode_entry_FFB8, &lxb_unicode_idna_map_FFB8};
static const lxb_unicode_data_t lxb_unicode_data_FFB9 = {&lxb_unicode_entry_FFB9, &lxb_unicode_idna_map_FFB9};
static const lxb_unicode_data_t lxb_unicode_data_FFBA = {&lxb_unicode_entry_FFBA, &lxb_unicode_idna_map_FFBA};
static const lxb_unicode_data_t lxb_unicode_data_FFBB = {&lxb_unicode_entry_FFBB, &lxb_unicode_idna_map_FFBB};
static const lxb_unicode_data_t lxb_unicode_data_FFBC = {&lxb_unicode_entry_FFBC, &lxb_unicode_idna_map_FFBC};
static const lxb_unicode_data_t lxb_unicode_data_FFBD = {&lxb_unicode_entry_FFBD, &lxb_unicode_idna_map_FFBD};
static const lxb_unicode_data_t lxb_unicode_data_FFBE = {&lxb_unicode_entry_FFBE, &lxb_unicode_idna_map_FFBE};
static const lxb_unicode_data_t lxb_unicode_data_FFC2 = {&lxb_unicode_entry_FFC2, &lxb_unicode_idna_map_FFC2};
static const lxb_unicode_data_t lxb_unicode_data_FFC3 = {&lxb_unicode_entry_FFC3, &lxb_unicode_idna_map_FFC3};
static const lxb_unicode_data_t lxb_unicode_data_FFC4 = {&lxb_unicode_entry_FFC4, &lxb_unicode_idna_map_FFC4};
static const lxb_unicode_data_t lxb_unicode_data_FFC5 = {&lxb_unicode_entry_FFC5, &lxb_unicode_idna_map_FFC5};
static const lxb_unicode_data_t lxb_unicode_data_FFC6 = {&lxb_unicode_entry_FFC6, &lxb_unicode_idna_map_FFC6};
static const lxb_unicode_data_t lxb_unicode_data_FFC7 = {&lxb_unicode_entry_FFC7, &lxb_unicode_idna_map_FFC7};
static const lxb_unicode_data_t lxb_unicode_data_FFCA = {&lxb_unicode_entry_FFCA, &lxb_unicode_idna_map_FFCA};
static const lxb_unicode_data_t lxb_unicode_data_FFCB = {&lxb_unicode_entry_FFCB, &lxb_unicode_idna_map_FFCB};
static const lxb_unicode_data_t lxb_unicode_data_FFCC = {&lxb_unicode_entry_FFCC, &lxb_unicode_idna_map_FFCC};
static const lxb_unicode_data_t lxb_unicode_data_FFCD = {&lxb_unicode_entry_FFCD, &lxb_unicode_idna_map_FFCD};
static const lxb_unicode_data_t lxb_unicode_data_FFCE = {&lxb_unicode_entry_FFCE, &lxb_unicode_idna_map_FFCE};
static const lxb_unicode_data_t lxb_unicode_data_FFCF = {&lxb_unicode_entry_FFCF, &lxb_unicode_idna_map_FFCF};
static const lxb_unicode_data_t lxb_unicode_data_FFD2 = {&lxb_unicode_entry_FFD2, &lxb_unicode_idna_map_FFD2};
static const lxb_unicode_data_t lxb_unicode_data_FFD3 = {&lxb_unicode_entry_FFD3, &lxb_unicode_idna_map_FFD3};
static const lxb_unicode_data_t lxb_unicode_data_FFD4 = {&lxb_unicode_entry_FFD4, &lxb_unicode_idna_map_FFD4};
static const lxb_unicode_data_t lxb_unicode_data_FFD5 = {&lxb_unicode_entry_FFD5, &lxb_unicode_idna_map_FFD5};
static const lxb_unicode_data_t lxb_unicode_data_FFD6 = {&lxb_unicode_entry_FFD6, &lxb_unicode_idna_map_FFD6};
static const lxb_unicode_data_t lxb_unicode_data_FFD7 = {&lxb_unicode_entry_FFD7, &lxb_unicode_idna_map_FFD7};
static const lxb_unicode_data_t lxb_unicode_data_FFDA = {&lxb_unicode_entry_FFDA, &lxb_unicode_idna_map_FFDA};
static const lxb_unicode_data_t lxb_unicode_data_FFDB = {&lxb_unicode_entry_FFDB, &lxb_unicode_idna_map_FFDB};
static const lxb_unicode_data_t lxb_unicode_data_FFDC = {&lxb_unicode_entry_FFDC, &lxb_unicode_idna_map_FFDC};
static const lxb_unicode_data_t lxb_unicode_data_FFE0 = {&lxb_unicode_entry_FFE0, &lxb_unicode_idna_map_FFE0};
static const lxb_unicode_data_t lxb_unicode_data_FFE1 = {&lxb_unicode_entry_FFE1, &lxb_unicode_idna_map_FFE1};
static const lxb_unicode_data_t lxb_unicode_data_FFE2 = {&lxb_unicode_entry_FFE2, &lxb_unicode_idna_map_FFE2};
static const lxb_unicode_data_t lxb_unicode_data_FFE3 = {&lxb_unicode_entry_FFE3, &lxb_unicode_idna_map_FFE3};
static const lxb_unicode_data_t lxb_unicode_data_FFE4 = {&lxb_unicode_entry_FFE4, &lxb_unicode_idna_map_FFE4};
static const lxb_unicode_data_t lxb_unicode_data_FFE5 = {&lxb_unicode_entry_FFE5, &lxb_unicode_idna_map_FFE5};
static const lxb_unicode_data_t lxb_unicode_data_FFE6 = {&lxb_unicode_entry_FFE6, &lxb_unicode_idna_map_FFE6};
static const lxb_unicode_data_t lxb_unicode_data_FFE8 = {&lxb_unicode_entry_FFE8, &lxb_unicode_idna_map_FFE8};
static const lxb_unicode_data_t lxb_unicode_data_FFE9 = {&lxb_unicode_entry_FFE9, &lxb_unicode_idna_map_FFE9};
static const lxb_unicode_data_t lxb_unicode_data_FFEA = {&lxb_unicode_entry_FFEA, &lxb_unicode_idna_map_FFEA};
static const lxb_unicode_data_t lxb_unicode_data_FFEB = {&lxb_unicode_entry_FFEB, &lxb_unicode_idna_map_FFEB};
static const lxb_unicode_data_t lxb_unicode_data_FFEC = {&lxb_unicode_entry_FFEC, &lxb_unicode_idna_map_FFEC};
static const lxb_unicode_data_t lxb_unicode_data_FFED = {&lxb_unicode_entry_FFED, &lxb_unicode_idna_map_FFED};
static const lxb_unicode_data_t lxb_unicode_data_FFEE = {&lxb_unicode_entry_FFEE, &lxb_unicode_idna_map_FFEE};
static const lxb_unicode_data_t lxb_unicode_data_101FD = {&lxb_unicode_entry_101FD, NULL};
static const lxb_unicode_data_t lxb_unicode_data_102E0 = {&lxb_unicode_entry_102E0, NULL};
static const lxb_unicode_data_t lxb_unicode_data_10376 = {&lxb_unicode_entry_10376, NULL};
static const lxb_unicode_data_t lxb_unicode_data_10377 = {&lxb_unicode_entry_10377, NULL};
static const lxb_unicode_data_t lxb_unicode_data_10378 = {&lxb_unicode_entry_10378, NULL};
static const lxb_unicode_data_t lxb_unicode_data_10379 = {&lxb_unicode_entry_10379, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1037A = {&lxb_unicode_entry_1037A, NULL};
static const lxb_unicode_data_t lxb_unicode_data_10400 = {NULL, &lxb_unicode_idna_map_10400};
static const lxb_unicode_data_t lxb_unicode_data_10401 = {NULL, &lxb_unicode_idna_map_10401};
static const lxb_unicode_data_t lxb_unicode_data_10402 = {NULL, &lxb_unicode_idna_map_10402};
static const lxb_unicode_data_t lxb_unicode_data_10403 = {NULL, &lxb_unicode_idna_map_10403};
static const lxb_unicode_data_t lxb_unicode_data_10404 = {NULL, &lxb_unicode_idna_map_10404};
static const lxb_unicode_data_t lxb_unicode_data_10405 = {NULL, &lxb_unicode_idna_map_10405};
static const lxb_unicode_data_t lxb_unicode_data_10406 = {NULL, &lxb_unicode_idna_map_10406};
static const lxb_unicode_data_t lxb_unicode_data_10407 = {NULL, &lxb_unicode_idna_map_10407};
static const lxb_unicode_data_t lxb_unicode_data_10408 = {NULL, &lxb_unicode_idna_map_10408};
static const lxb_unicode_data_t lxb_unicode_data_10409 = {NULL, &lxb_unicode_idna_map_10409};
static const lxb_unicode_data_t lxb_unicode_data_1040A = {NULL, &lxb_unicode_idna_map_1040A};
static const lxb_unicode_data_t lxb_unicode_data_1040B = {NULL, &lxb_unicode_idna_map_1040B};
static const lxb_unicode_data_t lxb_unicode_data_1040C = {NULL, &lxb_unicode_idna_map_1040C};
static const lxb_unicode_data_t lxb_unicode_data_1040D = {NULL, &lxb_unicode_idna_map_1040D};
static const lxb_unicode_data_t lxb_unicode_data_1040E = {NULL, &lxb_unicode_idna_map_1040E};
static const lxb_unicode_data_t lxb_unicode_data_1040F = {NULL, &lxb_unicode_idna_map_1040F};
static const lxb_unicode_data_t lxb_unicode_data_10410 = {NULL, &lxb_unicode_idna_map_10410};
static const lxb_unicode_data_t lxb_unicode_data_10411 = {NULL, &lxb_unicode_idna_map_10411};
static const lxb_unicode_data_t lxb_unicode_data_10412 = {NULL, &lxb_unicode_idna_map_10412};
static const lxb_unicode_data_t lxb_unicode_data_10413 = {NULL, &lxb_unicode_idna_map_10413};
static const lxb_unicode_data_t lxb_unicode_data_10414 = {NULL, &lxb_unicode_idna_map_10414};
static const lxb_unicode_data_t lxb_unicode_data_10415 = {NULL, &lxb_unicode_idna_map_10415};
static const lxb_unicode_data_t lxb_unicode_data_10416 = {NULL, &lxb_unicode_idna_map_10416};
static const lxb_unicode_data_t lxb_unicode_data_10417 = {NULL, &lxb_unicode_idna_map_10417};
static const lxb_unicode_data_t lxb_unicode_data_10418 = {NULL, &lxb_unicode_idna_map_10418};
static const lxb_unicode_data_t lxb_unicode_data_10419 = {NULL, &lxb_unicode_idna_map_10419};
static const lxb_unicode_data_t lxb_unicode_data_1041A = {NULL, &lxb_unicode_idna_map_1041A};
static const lxb_unicode_data_t lxb_unicode_data_1041B = {NULL, &lxb_unicode_idna_map_1041B};
static const lxb_unicode_data_t lxb_unicode_data_1041C = {NULL, &lxb_unicode_idna_map_1041C};
static const lxb_unicode_data_t lxb_unicode_data_1041D = {NULL, &lxb_unicode_idna_map_1041D};
static const lxb_unicode_data_t lxb_unicode_data_1041E = {NULL, &lxb_unicode_idna_map_1041E};
static const lxb_unicode_data_t lxb_unicode_data_1041F = {NULL, &lxb_unicode_idna_map_1041F};
static const lxb_unicode_data_t lxb_unicode_data_10420 = {NULL, &lxb_unicode_idna_map_10420};
static const lxb_unicode_data_t lxb_unicode_data_10421 = {NULL, &lxb_unicode_idna_map_10421};
static const lxb_unicode_data_t lxb_unicode_data_10422 = {NULL, &lxb_unicode_idna_map_10422};
static const lxb_unicode_data_t lxb_unicode_data_10423 = {NULL, &lxb_unicode_idna_map_10423};
static const lxb_unicode_data_t lxb_unicode_data_10424 = {NULL, &lxb_unicode_idna_map_10424};
static const lxb_unicode_data_t lxb_unicode_data_10425 = {NULL, &lxb_unicode_idna_map_10425};
static const lxb_unicode_data_t lxb_unicode_data_10426 = {NULL, &lxb_unicode_idna_map_10426};
static const lxb_unicode_data_t lxb_unicode_data_10427 = {NULL, &lxb_unicode_idna_map_10427};
static const lxb_unicode_data_t lxb_unicode_data_104B0 = {NULL, &lxb_unicode_idna_map_104B0};
static const lxb_unicode_data_t lxb_unicode_data_104B1 = {NULL, &lxb_unicode_idna_map_104B1};
static const lxb_unicode_data_t lxb_unicode_data_104B2 = {NULL, &lxb_unicode_idna_map_104B2};
static const lxb_unicode_data_t lxb_unicode_data_104B3 = {NULL, &lxb_unicode_idna_map_104B3};
static const lxb_unicode_data_t lxb_unicode_data_104B4 = {NULL, &lxb_unicode_idna_map_104B4};
static const lxb_unicode_data_t lxb_unicode_data_104B5 = {NULL, &lxb_unicode_idna_map_104B5};
static const lxb_unicode_data_t lxb_unicode_data_104B6 = {NULL, &lxb_unicode_idna_map_104B6};
static const lxb_unicode_data_t lxb_unicode_data_104B7 = {NULL, &lxb_unicode_idna_map_104B7};
static const lxb_unicode_data_t lxb_unicode_data_104B8 = {NULL, &lxb_unicode_idna_map_104B8};
static const lxb_unicode_data_t lxb_unicode_data_104B9 = {NULL, &lxb_unicode_idna_map_104B9};
static const lxb_unicode_data_t lxb_unicode_data_104BA = {NULL, &lxb_unicode_idna_map_104BA};
static const lxb_unicode_data_t lxb_unicode_data_104BB = {NULL, &lxb_unicode_idna_map_104BB};
static const lxb_unicode_data_t lxb_unicode_data_104BC = {NULL, &lxb_unicode_idna_map_104BC};
static const lxb_unicode_data_t lxb_unicode_data_104BD = {NULL, &lxb_unicode_idna_map_104BD};
static const lxb_unicode_data_t lxb_unicode_data_104BE = {NULL, &lxb_unicode_idna_map_104BE};
static const lxb_unicode_data_t lxb_unicode_data_104BF = {NULL, &lxb_unicode_idna_map_104BF};
static const lxb_unicode_data_t lxb_unicode_data_104C0 = {NULL, &lxb_unicode_idna_map_104C0};
static const lxb_unicode_data_t lxb_unicode_data_104C1 = {NULL, &lxb_unicode_idna_map_104C1};
static const lxb_unicode_data_t lxb_unicode_data_104C2 = {NULL, &lxb_unicode_idna_map_104C2};
static const lxb_unicode_data_t lxb_unicode_data_104C3 = {NULL, &lxb_unicode_idna_map_104C3};
static const lxb_unicode_data_t lxb_unicode_data_104C4 = {NULL, &lxb_unicode_idna_map_104C4};
static const lxb_unicode_data_t lxb_unicode_data_104C5 = {NULL, &lxb_unicode_idna_map_104C5};
static const lxb_unicode_data_t lxb_unicode_data_104C6 = {NULL, &lxb_unicode_idna_map_104C6};
static const lxb_unicode_data_t lxb_unicode_data_104C7 = {NULL, &lxb_unicode_idna_map_104C7};
static const lxb_unicode_data_t lxb_unicode_data_104C8 = {NULL, &lxb_unicode_idna_map_104C8};
static const lxb_unicode_data_t lxb_unicode_data_104C9 = {NULL, &lxb_unicode_idna_map_104C9};
static const lxb_unicode_data_t lxb_unicode_data_104CA = {NULL, &lxb_unicode_idna_map_104CA};
static const lxb_unicode_data_t lxb_unicode_data_104CB = {NULL, &lxb_unicode_idna_map_104CB};
static const lxb_unicode_data_t lxb_unicode_data_104CC = {NULL, &lxb_unicode_idna_map_104CC};
static const lxb_unicode_data_t lxb_unicode_data_104CD = {NULL, &lxb_unicode_idna_map_104CD};
static const lxb_unicode_data_t lxb_unicode_data_104CE = {NULL, &lxb_unicode_idna_map_104CE};
static const lxb_unicode_data_t lxb_unicode_data_104CF = {NULL, &lxb_unicode_idna_map_104CF};
static const lxb_unicode_data_t lxb_unicode_data_104D0 = {NULL, &lxb_unicode_idna_map_104D0};
static const lxb_unicode_data_t lxb_unicode_data_104D1 = {NULL, &lxb_unicode_idna_map_104D1};
static const lxb_unicode_data_t lxb_unicode_data_104D2 = {NULL, &lxb_unicode_idna_map_104D2};
static const lxb_unicode_data_t lxb_unicode_data_104D3 = {NULL, &lxb_unicode_idna_map_104D3};
static const lxb_unicode_data_t lxb_unicode_data_10570 = {NULL, &lxb_unicode_idna_map_10570};
static const lxb_unicode_data_t lxb_unicode_data_10571 = {NULL, &lxb_unicode_idna_map_10571};
static const lxb_unicode_data_t lxb_unicode_data_10572 = {NULL, &lxb_unicode_idna_map_10572};
static const lxb_unicode_data_t lxb_unicode_data_10573 = {NULL, &lxb_unicode_idna_map_10573};
static const lxb_unicode_data_t lxb_unicode_data_10574 = {NULL, &lxb_unicode_idna_map_10574};
static const lxb_unicode_data_t lxb_unicode_data_10575 = {NULL, &lxb_unicode_idna_map_10575};
static const lxb_unicode_data_t lxb_unicode_data_10576 = {NULL, &lxb_unicode_idna_map_10576};
static const lxb_unicode_data_t lxb_unicode_data_10577 = {NULL, &lxb_unicode_idna_map_10577};
static const lxb_unicode_data_t lxb_unicode_data_10578 = {NULL, &lxb_unicode_idna_map_10578};
static const lxb_unicode_data_t lxb_unicode_data_10579 = {NULL, &lxb_unicode_idna_map_10579};
static const lxb_unicode_data_t lxb_unicode_data_1057A = {NULL, &lxb_unicode_idna_map_1057A};
static const lxb_unicode_data_t lxb_unicode_data_1057C = {NULL, &lxb_unicode_idna_map_1057C};
static const lxb_unicode_data_t lxb_unicode_data_1057D = {NULL, &lxb_unicode_idna_map_1057D};
static const lxb_unicode_data_t lxb_unicode_data_1057E = {NULL, &lxb_unicode_idna_map_1057E};
static const lxb_unicode_data_t lxb_unicode_data_1057F = {NULL, &lxb_unicode_idna_map_1057F};
static const lxb_unicode_data_t lxb_unicode_data_10580 = {NULL, &lxb_unicode_idna_map_10580};
static const lxb_unicode_data_t lxb_unicode_data_10581 = {NULL, &lxb_unicode_idna_map_10581};
static const lxb_unicode_data_t lxb_unicode_data_10582 = {NULL, &lxb_unicode_idna_map_10582};
static const lxb_unicode_data_t lxb_unicode_data_10583 = {NULL, &lxb_unicode_idna_map_10583};
static const lxb_unicode_data_t lxb_unicode_data_10584 = {NULL, &lxb_unicode_idna_map_10584};
static const lxb_unicode_data_t lxb_unicode_data_10585 = {NULL, &lxb_unicode_idna_map_10585};
static const lxb_unicode_data_t lxb_unicode_data_10586 = {NULL, &lxb_unicode_idna_map_10586};
static const lxb_unicode_data_t lxb_unicode_data_10587 = {NULL, &lxb_unicode_idna_map_10587};
static const lxb_unicode_data_t lxb_unicode_data_10588 = {NULL, &lxb_unicode_idna_map_10588};
static const lxb_unicode_data_t lxb_unicode_data_10589 = {NULL, &lxb_unicode_idna_map_10589};
static const lxb_unicode_data_t lxb_unicode_data_1058A = {NULL, &lxb_unicode_idna_map_1058A};
static const lxb_unicode_data_t lxb_unicode_data_1058C = {NULL, &lxb_unicode_idna_map_1058C};
static const lxb_unicode_data_t lxb_unicode_data_1058D = {NULL, &lxb_unicode_idna_map_1058D};
static const lxb_unicode_data_t lxb_unicode_data_1058E = {NULL, &lxb_unicode_idna_map_1058E};
static const lxb_unicode_data_t lxb_unicode_data_1058F = {NULL, &lxb_unicode_idna_map_1058F};
static const lxb_unicode_data_t lxb_unicode_data_10590 = {NULL, &lxb_unicode_idna_map_10590};
static const lxb_unicode_data_t lxb_unicode_data_10591 = {NULL, &lxb_unicode_idna_map_10591};
static const lxb_unicode_data_t lxb_unicode_data_10592 = {NULL, &lxb_unicode_idna_map_10592};
static const lxb_unicode_data_t lxb_unicode_data_10594 = {NULL, &lxb_unicode_idna_map_10594};
static const lxb_unicode_data_t lxb_unicode_data_10595 = {NULL, &lxb_unicode_idna_map_10595};
static const lxb_unicode_data_t lxb_unicode_data_10781 = {&lxb_unicode_entry_10781, &lxb_unicode_idna_map_10781};
static const lxb_unicode_data_t lxb_unicode_data_10782 = {&lxb_unicode_entry_10782, &lxb_unicode_idna_map_10782};
static const lxb_unicode_data_t lxb_unicode_data_10783 = {&lxb_unicode_entry_10783, &lxb_unicode_idna_map_10783};
static const lxb_unicode_data_t lxb_unicode_data_10784 = {&lxb_unicode_entry_10784, &lxb_unicode_idna_map_10784};
static const lxb_unicode_data_t lxb_unicode_data_10785 = {&lxb_unicode_entry_10785, &lxb_unicode_idna_map_10785};
static const lxb_unicode_data_t lxb_unicode_data_10787 = {&lxb_unicode_entry_10787, &lxb_unicode_idna_map_10787};
static const lxb_unicode_data_t lxb_unicode_data_10788 = {&lxb_unicode_entry_10788, &lxb_unicode_idna_map_10788};
static const lxb_unicode_data_t lxb_unicode_data_10789 = {&lxb_unicode_entry_10789, &lxb_unicode_idna_map_10789};
static const lxb_unicode_data_t lxb_unicode_data_1078A = {&lxb_unicode_entry_1078A, &lxb_unicode_idna_map_1078A};
static const lxb_unicode_data_t lxb_unicode_data_1078B = {&lxb_unicode_entry_1078B, &lxb_unicode_idna_map_1078B};
static const lxb_unicode_data_t lxb_unicode_data_1078C = {&lxb_unicode_entry_1078C, &lxb_unicode_idna_map_1078C};
static const lxb_unicode_data_t lxb_unicode_data_1078D = {&lxb_unicode_entry_1078D, &lxb_unicode_idna_map_1078D};
static const lxb_unicode_data_t lxb_unicode_data_1078E = {&lxb_unicode_entry_1078E, &lxb_unicode_idna_map_1078E};
static const lxb_unicode_data_t lxb_unicode_data_1078F = {&lxb_unicode_entry_1078F, &lxb_unicode_idna_map_1078F};
static const lxb_unicode_data_t lxb_unicode_data_10790 = {&lxb_unicode_entry_10790, &lxb_unicode_idna_map_10790};
static const lxb_unicode_data_t lxb_unicode_data_10791 = {&lxb_unicode_entry_10791, &lxb_unicode_idna_map_10791};
static const lxb_unicode_data_t lxb_unicode_data_10792 = {&lxb_unicode_entry_10792, &lxb_unicode_idna_map_10792};
static const lxb_unicode_data_t lxb_unicode_data_10793 = {&lxb_unicode_entry_10793, &lxb_unicode_idna_map_10793};
static const lxb_unicode_data_t lxb_unicode_data_10794 = {&lxb_unicode_entry_10794, &lxb_unicode_idna_map_10794};
static const lxb_unicode_data_t lxb_unicode_data_10795 = {&lxb_unicode_entry_10795, &lxb_unicode_idna_map_10795};
static const lxb_unicode_data_t lxb_unicode_data_10796 = {&lxb_unicode_entry_10796, &lxb_unicode_idna_map_10796};
static const lxb_unicode_data_t lxb_unicode_data_10797 = {&lxb_unicode_entry_10797, &lxb_unicode_idna_map_10797};
static const lxb_unicode_data_t lxb_unicode_data_10798 = {&lxb_unicode_entry_10798, &lxb_unicode_idna_map_10798};
static const lxb_unicode_data_t lxb_unicode_data_10799 = {&lxb_unicode_entry_10799, &lxb_unicode_idna_map_10799};
static const lxb_unicode_data_t lxb_unicode_data_1079A = {&lxb_unicode_entry_1079A, &lxb_unicode_idna_map_1079A};
static const lxb_unicode_data_t lxb_unicode_data_1079B = {&lxb_unicode_entry_1079B, &lxb_unicode_idna_map_1079B};
static const lxb_unicode_data_t lxb_unicode_data_1079C = {&lxb_unicode_entry_1079C, &lxb_unicode_idna_map_1079C};
static const lxb_unicode_data_t lxb_unicode_data_1079D = {&lxb_unicode_entry_1079D, &lxb_unicode_idna_map_1079D};
static const lxb_unicode_data_t lxb_unicode_data_1079E = {&lxb_unicode_entry_1079E, &lxb_unicode_idna_map_1079E};
static const lxb_unicode_data_t lxb_unicode_data_1079F = {&lxb_unicode_entry_1079F, &lxb_unicode_idna_map_1079F};
static const lxb_unicode_data_t lxb_unicode_data_107A0 = {&lxb_unicode_entry_107A0, &lxb_unicode_idna_map_107A0};
static const lxb_unicode_data_t lxb_unicode_data_107A1 = {&lxb_unicode_entry_107A1, &lxb_unicode_idna_map_107A1};
static const lxb_unicode_data_t lxb_unicode_data_107A2 = {&lxb_unicode_entry_107A2, &lxb_unicode_idna_map_107A2};
static const lxb_unicode_data_t lxb_unicode_data_107A3 = {&lxb_unicode_entry_107A3, &lxb_unicode_idna_map_107A3};
static const lxb_unicode_data_t lxb_unicode_data_107A4 = {&lxb_unicode_entry_107A4, &lxb_unicode_idna_map_107A4};
static const lxb_unicode_data_t lxb_unicode_data_107A5 = {&lxb_unicode_entry_107A5, &lxb_unicode_idna_map_107A5};
static const lxb_unicode_data_t lxb_unicode_data_107A6 = {&lxb_unicode_entry_107A6, &lxb_unicode_idna_map_107A6};
static const lxb_unicode_data_t lxb_unicode_data_107A7 = {&lxb_unicode_entry_107A7, &lxb_unicode_idna_map_107A7};
static const lxb_unicode_data_t lxb_unicode_data_107A8 = {&lxb_unicode_entry_107A8, &lxb_unicode_idna_map_107A8};
static const lxb_unicode_data_t lxb_unicode_data_107A9 = {&lxb_unicode_entry_107A9, &lxb_unicode_idna_map_107A9};
static const lxb_unicode_data_t lxb_unicode_data_107AA = {&lxb_unicode_entry_107AA, &lxb_unicode_idna_map_107AA};
static const lxb_unicode_data_t lxb_unicode_data_107AB = {&lxb_unicode_entry_107AB, &lxb_unicode_idna_map_107AB};
static const lxb_unicode_data_t lxb_unicode_data_107AC = {&lxb_unicode_entry_107AC, &lxb_unicode_idna_map_107AC};
static const lxb_unicode_data_t lxb_unicode_data_107AD = {&lxb_unicode_entry_107AD, &lxb_unicode_idna_map_107AD};
static const lxb_unicode_data_t lxb_unicode_data_107AE = {&lxb_unicode_entry_107AE, &lxb_unicode_idna_map_107AE};
static const lxb_unicode_data_t lxb_unicode_data_107AF = {&lxb_unicode_entry_107AF, &lxb_unicode_idna_map_107AF};
static const lxb_unicode_data_t lxb_unicode_data_107B0 = {&lxb_unicode_entry_107B0, &lxb_unicode_idna_map_107B0};
static const lxb_unicode_data_t lxb_unicode_data_107B2 = {&lxb_unicode_entry_107B2, &lxb_unicode_idna_map_107B2};
static const lxb_unicode_data_t lxb_unicode_data_107B3 = {&lxb_unicode_entry_107B3, &lxb_unicode_idna_map_107B3};
static const lxb_unicode_data_t lxb_unicode_data_107B4 = {&lxb_unicode_entry_107B4, &lxb_unicode_idna_map_107B4};
static const lxb_unicode_data_t lxb_unicode_data_107B5 = {&lxb_unicode_entry_107B5, &lxb_unicode_idna_map_107B5};
static const lxb_unicode_data_t lxb_unicode_data_107B6 = {&lxb_unicode_entry_107B6, &lxb_unicode_idna_map_107B6};
static const lxb_unicode_data_t lxb_unicode_data_107B7 = {&lxb_unicode_entry_107B7, &lxb_unicode_idna_map_107B7};
static const lxb_unicode_data_t lxb_unicode_data_107B8 = {&lxb_unicode_entry_107B8, &lxb_unicode_idna_map_107B8};
static const lxb_unicode_data_t lxb_unicode_data_107B9 = {&lxb_unicode_entry_107B9, &lxb_unicode_idna_map_107B9};
static const lxb_unicode_data_t lxb_unicode_data_107BA = {&lxb_unicode_entry_107BA, &lxb_unicode_idna_map_107BA};
static const lxb_unicode_data_t lxb_unicode_data_10A0D = {&lxb_unicode_entry_10A0D, NULL};
static const lxb_unicode_data_t lxb_unicode_data_10A0F = {&lxb_unicode_entry_10A0F, NULL};
static const lxb_unicode_data_t lxb_unicode_data_10A38 = {&lxb_unicode_entry_10A38, NULL};
static const lxb_unicode_data_t lxb_unicode_data_10A39 = {&lxb_unicode_entry_10A39, NULL};
static const lxb_unicode_data_t lxb_unicode_data_10A3A = {&lxb_unicode_entry_10A3A, NULL};
static const lxb_unicode_data_t lxb_unicode_data_10A3F = {&lxb_unicode_entry_10A3F, NULL};
static const lxb_unicode_data_t lxb_unicode_data_10AE5 = {&lxb_unicode_entry_10AE5, NULL};
static const lxb_unicode_data_t lxb_unicode_data_10AE6 = {&lxb_unicode_entry_10AE6, NULL};
static const lxb_unicode_data_t lxb_unicode_data_10C80 = {NULL, &lxb_unicode_idna_map_10C80};
static const lxb_unicode_data_t lxb_unicode_data_10C81 = {NULL, &lxb_unicode_idna_map_10C81};
static const lxb_unicode_data_t lxb_unicode_data_10C82 = {NULL, &lxb_unicode_idna_map_10C82};
static const lxb_unicode_data_t lxb_unicode_data_10C83 = {NULL, &lxb_unicode_idna_map_10C83};
static const lxb_unicode_data_t lxb_unicode_data_10C84 = {NULL, &lxb_unicode_idna_map_10C84};
static const lxb_unicode_data_t lxb_unicode_data_10C85 = {NULL, &lxb_unicode_idna_map_10C85};
static const lxb_unicode_data_t lxb_unicode_data_10C86 = {NULL, &lxb_unicode_idna_map_10C86};
static const lxb_unicode_data_t lxb_unicode_data_10C87 = {NULL, &lxb_unicode_idna_map_10C87};
static const lxb_unicode_data_t lxb_unicode_data_10C88 = {NULL, &lxb_unicode_idna_map_10C88};
static const lxb_unicode_data_t lxb_unicode_data_10C89 = {NULL, &lxb_unicode_idna_map_10C89};
static const lxb_unicode_data_t lxb_unicode_data_10C8A = {NULL, &lxb_unicode_idna_map_10C8A};
static const lxb_unicode_data_t lxb_unicode_data_10C8B = {NULL, &lxb_unicode_idna_map_10C8B};
static const lxb_unicode_data_t lxb_unicode_data_10C8C = {NULL, &lxb_unicode_idna_map_10C8C};
static const lxb_unicode_data_t lxb_unicode_data_10C8D = {NULL, &lxb_unicode_idna_map_10C8D};
static const lxb_unicode_data_t lxb_unicode_data_10C8E = {NULL, &lxb_unicode_idna_map_10C8E};
static const lxb_unicode_data_t lxb_unicode_data_10C8F = {NULL, &lxb_unicode_idna_map_10C8F};
static const lxb_unicode_data_t lxb_unicode_data_10C90 = {NULL, &lxb_unicode_idna_map_10C90};
static const lxb_unicode_data_t lxb_unicode_data_10C91 = {NULL, &lxb_unicode_idna_map_10C91};
static const lxb_unicode_data_t lxb_unicode_data_10C92 = {NULL, &lxb_unicode_idna_map_10C92};
static const lxb_unicode_data_t lxb_unicode_data_10C93 = {NULL, &lxb_unicode_idna_map_10C93};
static const lxb_unicode_data_t lxb_unicode_data_10C94 = {NULL, &lxb_unicode_idna_map_10C94};
static const lxb_unicode_data_t lxb_unicode_data_10C95 = {NULL, &lxb_unicode_idna_map_10C95};
static const lxb_unicode_data_t lxb_unicode_data_10C96 = {NULL, &lxb_unicode_idna_map_10C96};
static const lxb_unicode_data_t lxb_unicode_data_10C97 = {NULL, &lxb_unicode_idna_map_10C97};
static const lxb_unicode_data_t lxb_unicode_data_10C98 = {NULL, &lxb_unicode_idna_map_10C98};
static const lxb_unicode_data_t lxb_unicode_data_10C99 = {NULL, &lxb_unicode_idna_map_10C99};
static const lxb_unicode_data_t lxb_unicode_data_10C9A = {NULL, &lxb_unicode_idna_map_10C9A};
static const lxb_unicode_data_t lxb_unicode_data_10C9B = {NULL, &lxb_unicode_idna_map_10C9B};
static const lxb_unicode_data_t lxb_unicode_data_10C9C = {NULL, &lxb_unicode_idna_map_10C9C};
static const lxb_unicode_data_t lxb_unicode_data_10C9D = {NULL, &lxb_unicode_idna_map_10C9D};
static const lxb_unicode_data_t lxb_unicode_data_10C9E = {NULL, &lxb_unicode_idna_map_10C9E};
static const lxb_unicode_data_t lxb_unicode_data_10C9F = {NULL, &lxb_unicode_idna_map_10C9F};
static const lxb_unicode_data_t lxb_unicode_data_10CA0 = {NULL, &lxb_unicode_idna_map_10CA0};
static const lxb_unicode_data_t lxb_unicode_data_10CA1 = {NULL, &lxb_unicode_idna_map_10CA1};
static const lxb_unicode_data_t lxb_unicode_data_10CA2 = {NULL, &lxb_unicode_idna_map_10CA2};
static const lxb_unicode_data_t lxb_unicode_data_10CA3 = {NULL, &lxb_unicode_idna_map_10CA3};
static const lxb_unicode_data_t lxb_unicode_data_10CA4 = {NULL, &lxb_unicode_idna_map_10CA4};
static const lxb_unicode_data_t lxb_unicode_data_10CA5 = {NULL, &lxb_unicode_idna_map_10CA5};
static const lxb_unicode_data_t lxb_unicode_data_10CA6 = {NULL, &lxb_unicode_idna_map_10CA6};
static const lxb_unicode_data_t lxb_unicode_data_10CA7 = {NULL, &lxb_unicode_idna_map_10CA7};
static const lxb_unicode_data_t lxb_unicode_data_10CA8 = {NULL, &lxb_unicode_idna_map_10CA8};
static const lxb_unicode_data_t lxb_unicode_data_10CA9 = {NULL, &lxb_unicode_idna_map_10CA9};
static const lxb_unicode_data_t lxb_unicode_data_10CAA = {NULL, &lxb_unicode_idna_map_10CAA};
static const lxb_unicode_data_t lxb_unicode_data_10CAB = {NULL, &lxb_unicode_idna_map_10CAB};
static const lxb_unicode_data_t lxb_unicode_data_10CAC = {NULL, &lxb_unicode_idna_map_10CAC};
static const lxb_unicode_data_t lxb_unicode_data_10CAD = {NULL, &lxb_unicode_idna_map_10CAD};
static const lxb_unicode_data_t lxb_unicode_data_10CAE = {NULL, &lxb_unicode_idna_map_10CAE};
static const lxb_unicode_data_t lxb_unicode_data_10CAF = {NULL, &lxb_unicode_idna_map_10CAF};
static const lxb_unicode_data_t lxb_unicode_data_10CB0 = {NULL, &lxb_unicode_idna_map_10CB0};
static const lxb_unicode_data_t lxb_unicode_data_10CB1 = {NULL, &lxb_unicode_idna_map_10CB1};
static const lxb_unicode_data_t lxb_unicode_data_10CB2 = {NULL, &lxb_unicode_idna_map_10CB2};
static const lxb_unicode_data_t lxb_unicode_data_10D24 = {&lxb_unicode_entry_10D24, NULL};
static const lxb_unicode_data_t lxb_unicode_data_10D25 = {&lxb_unicode_entry_10D25, NULL};
static const lxb_unicode_data_t lxb_unicode_data_10D26 = {&lxb_unicode_entry_10D26, NULL};
static const lxb_unicode_data_t lxb_unicode_data_10D27 = {&lxb_unicode_entry_10D27, NULL};
static const lxb_unicode_data_t lxb_unicode_data_10EAB = {&lxb_unicode_entry_10EAB, NULL};
static const lxb_unicode_data_t lxb_unicode_data_10EAC = {&lxb_unicode_entry_10EAC, NULL};
static const lxb_unicode_data_t lxb_unicode_data_10EFD = {&lxb_unicode_entry_10EFD, NULL};
static const lxb_unicode_data_t lxb_unicode_data_10EFE = {&lxb_unicode_entry_10EFE, NULL};
static const lxb_unicode_data_t lxb_unicode_data_10EFF = {&lxb_unicode_entry_10EFF, NULL};
static const lxb_unicode_data_t lxb_unicode_data_10F46 = {&lxb_unicode_entry_10F46, NULL};
static const lxb_unicode_data_t lxb_unicode_data_10F47 = {&lxb_unicode_entry_10F47, NULL};
static const lxb_unicode_data_t lxb_unicode_data_10F48 = {&lxb_unicode_entry_10F48, NULL};
static const lxb_unicode_data_t lxb_unicode_data_10F49 = {&lxb_unicode_entry_10F49, NULL};
static const lxb_unicode_data_t lxb_unicode_data_10F4A = {&lxb_unicode_entry_10F4A, NULL};
static const lxb_unicode_data_t lxb_unicode_data_10F4B = {&lxb_unicode_entry_10F4B, NULL};
static const lxb_unicode_data_t lxb_unicode_data_10F4C = {&lxb_unicode_entry_10F4C, NULL};
static const lxb_unicode_data_t lxb_unicode_data_10F4D = {&lxb_unicode_entry_10F4D, NULL};
static const lxb_unicode_data_t lxb_unicode_data_10F4E = {&lxb_unicode_entry_10F4E, NULL};
static const lxb_unicode_data_t lxb_unicode_data_10F4F = {&lxb_unicode_entry_10F4F, NULL};
static const lxb_unicode_data_t lxb_unicode_data_10F50 = {&lxb_unicode_entry_10F50, NULL};
static const lxb_unicode_data_t lxb_unicode_data_10F82 = {&lxb_unicode_entry_10F82, NULL};
static const lxb_unicode_data_t lxb_unicode_data_10F83 = {&lxb_unicode_entry_10F83, NULL};
static const lxb_unicode_data_t lxb_unicode_data_10F84 = {&lxb_unicode_entry_10F84, NULL};
static const lxb_unicode_data_t lxb_unicode_data_10F85 = {&lxb_unicode_entry_10F85, NULL};
static const lxb_unicode_data_t lxb_unicode_data_11046 = {&lxb_unicode_entry_11046, NULL};
static const lxb_unicode_data_t lxb_unicode_data_11070 = {&lxb_unicode_entry_11070, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1107F = {&lxb_unicode_entry_1107F, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1109A = {&lxb_unicode_entry_1109A, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1109C = {&lxb_unicode_entry_1109C, NULL};
static const lxb_unicode_data_t lxb_unicode_data_110AB = {&lxb_unicode_entry_110AB, NULL};
static const lxb_unicode_data_t lxb_unicode_data_110B9 = {&lxb_unicode_entry_110B9, NULL};
static const lxb_unicode_data_t lxb_unicode_data_110BA = {&lxb_unicode_entry_110BA, NULL};
static const lxb_unicode_data_t lxb_unicode_data_11100 = {&lxb_unicode_entry_11100, NULL};
static const lxb_unicode_data_t lxb_unicode_data_11101 = {&lxb_unicode_entry_11101, NULL};
static const lxb_unicode_data_t lxb_unicode_data_11102 = {&lxb_unicode_entry_11102, NULL};
static const lxb_unicode_data_t lxb_unicode_data_11127 = {&lxb_unicode_entry_11127, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1112E = {&lxb_unicode_entry_1112E, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1112F = {&lxb_unicode_entry_1112F, NULL};
static const lxb_unicode_data_t lxb_unicode_data_11133 = {&lxb_unicode_entry_11133, NULL};
static const lxb_unicode_data_t lxb_unicode_data_11134 = {&lxb_unicode_entry_11134, NULL};
static const lxb_unicode_data_t *lxb_unicode_table_13[5000] = {
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_FDF0,
    &lxb_unicode_data_FDF1,
    &lxb_unicode_data_FDF2,
    &lxb_unicode_data_FDF3,
    &lxb_unicode_data_FDF4,
    &lxb_unicode_data_FDF5,
    &lxb_unicode_data_FDF6,
    &lxb_unicode_data_FDF7,
    &lxb_unicode_data_FDF8,
    &lxb_unicode_data_FDF9,
    &lxb_unicode_data_FDFA,
    &lxb_unicode_data_FDFB,
    &lxb_unicode_data_FDFC,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_FE10,
    &lxb_unicode_data_FE11,
    &lxb_unicode_data_FE12,
    &lxb_unicode_data_FE13,
    &lxb_unicode_data_FE14,
    &lxb_unicode_data_FE15,
    &lxb_unicode_data_FE16,
    &lxb_unicode_data_FE17,
    &lxb_unicode_data_FE18,
    &lxb_unicode_data_FE19,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_FE20,
    &lxb_unicode_data_FE21,
    &lxb_unicode_data_FE22,
    &lxb_unicode_data_FE23,
    &lxb_unicode_data_FE24,
    &lxb_unicode_data_FE25,
    &lxb_unicode_data_FE26,
    &lxb_unicode_data_FE27,
    &lxb_unicode_data_FE28,
    &lxb_unicode_data_FE29,
    &lxb_unicode_data_FE2A,
    &lxb_unicode_data_FE2B,
    &lxb_unicode_data_FE2C,
    &lxb_unicode_data_FE2D,
    &lxb_unicode_data_FE2E,
    &lxb_unicode_data_FE2F,
    &lxb_unicode_data_FE30,
    &lxb_unicode_data_FE31,
    &lxb_unicode_data_FE32,
    &lxb_unicode_data_FE33,
    &lxb_unicode_data_FE34,
    &lxb_unicode_data_FE35,
    &lxb_unicode_data_FE36,
    &lxb_unicode_data_FE37,
    &lxb_unicode_data_FE38,
    &lxb_unicode_data_FE39,
    &lxb_unicode_data_FE3A,
    &lxb_unicode_data_FE3B,
    &lxb_unicode_data_FE3C,
    &lxb_unicode_data_FE3D,
    &lxb_unicode_data_FE3E,
    &lxb_unicode_data_FE3F,
    &lxb_unicode_data_FE40,
    &lxb_unicode_data_FE41,
    &lxb_unicode_data_FE42,
    &lxb_unicode_data_FE43,
    &lxb_unicode_data_FE44,
    NULL,
    NULL,
    &lxb_unicode_data_FE47,
    &lxb_unicode_data_FE48,
    &lxb_unicode_data_FE49,
    &lxb_unicode_data_FE4A,
    &lxb_unicode_data_FE4B,
    &lxb_unicode_data_FE4C,
    &lxb_unicode_data_FE4D,
    &lxb_unicode_data_FE4E,
    &lxb_unicode_data_FE4F,
    &lxb_unicode_data_FE50,
    &lxb_unicode_data_FE51,
    &lxb_unicode_data_FE52,
    NULL,
    &lxb_unicode_data_FE54,
    &lxb_unicode_data_FE55,
    &lxb_unicode_data_FE56,
    &lxb_unicode_data_FE57,
    &lxb_unicode_data_FE58,
    &lxb_unicode_data_FE59,
    &lxb_unicode_data_FE5A,
    &lxb_unicode_data_FE5B,
    &lxb_unicode_data_FE5C,
    &lxb_unicode_data_FE5D,
    &lxb_unicode_data_FE5E,
    &lxb_unicode_data_FE5F,
    &lxb_unicode_data_FE60,
    &lxb_unicode_data_FE61,
    &lxb_unicode_data_FE62,
    &lxb_unicode_data_FE63,
    &lxb_unicode_data_FE64,
    &lxb_unicode_data_FE65,
    &lxb_unicode_data_FE66,
    NULL,
    &lxb_unicode_data_FE68,
    &lxb_unicode_data_FE69,
    &lxb_unicode_data_FE6A,
    &lxb_unicode_data_FE6B,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_FE70,
    &lxb_unicode_data_FE71,
    &lxb_unicode_data_FE72,
    NULL,
    &lxb_unicode_data_FE74,
    NULL,
    &lxb_unicode_data_FE76,
    &lxb_unicode_data_FE77,
    &lxb_unicode_data_FE78,
    &lxb_unicode_data_FE79,
    &lxb_unicode_data_FE7A,
    &lxb_unicode_data_FE7B,
    &lxb_unicode_data_FE7C,
    &lxb_unicode_data_FE7D,
    &lxb_unicode_data_FE7E,
    &lxb_unicode_data_FE7F,
    &lxb_unicode_data_FE80,
    &lxb_unicode_data_FE81,
    &lxb_unicode_data_FE82,
    &lxb_unicode_data_FE83,
    &lxb_unicode_data_FE84,
    &lxb_unicode_data_FE85,
    &lxb_unicode_data_FE86,
    &lxb_unicode_data_FE87,
    &lxb_unicode_data_FE88,
    &lxb_unicode_data_FE89,
    &lxb_unicode_data_FE8A,
    &lxb_unicode_data_FE8B,
    &lxb_unicode_data_FE8C,
    &lxb_unicode_data_FE8D,
    &lxb_unicode_data_FE8E,
    &lxb_unicode_data_FE8F,
    &lxb_unicode_data_FE90,
    &lxb_unicode_data_FE91,
    &lxb_unicode_data_FE92,
    &lxb_unicode_data_FE93,
    &lxb_unicode_data_FE94,
    &lxb_unicode_data_FE95,
    &lxb_unicode_data_FE96,
    &lxb_unicode_data_FE97,
    &lxb_unicode_data_FE98,
    &lxb_unicode_data_FE99,
    &lxb_unicode_data_FE9A,
    &lxb_unicode_data_FE9B,
    &lxb_unicode_data_FE9C,
    &lxb_unicode_data_FE9D,
    &lxb_unicode_data_FE9E,
    &lxb_unicode_data_FE9F,
    &lxb_unicode_data_FEA0,
    &lxb_unicode_data_FEA1,
    &lxb_unicode_data_FEA2,
    &lxb_unicode_data_FEA3,
    &lxb_unicode_data_FEA4,
    &lxb_unicode_data_FEA5,
    &lxb_unicode_data_FEA6,
    &lxb_unicode_data_FEA7,
    &lxb_unicode_data_FEA8,
    &lxb_unicode_data_FEA9,
    &lxb_unicode_data_FEAA,
    &lxb_unicode_data_FEAB,
    &lxb_unicode_data_FEAC,
    &lxb_unicode_data_FEAD,
    &lxb_unicode_data_FEAE,
    &lxb_unicode_data_FEAF,
    &lxb_unicode_data_FEB0,
    &lxb_unicode_data_FEB1,
    &lxb_unicode_data_FEB2,
    &lxb_unicode_data_FEB3,
    &lxb_unicode_data_FEB4,
    &lxb_unicode_data_FEB5,
    &lxb_unicode_data_FEB6,
    &lxb_unicode_data_FEB7,
    &lxb_unicode_data_FEB8,
    &lxb_unicode_data_FEB9,
    &lxb_unicode_data_FEBA,
    &lxb_unicode_data_FEBB,
    &lxb_unicode_data_FEBC,
    &lxb_unicode_data_FEBD,
    &lxb_unicode_data_FEBE,
    &lxb_unicode_data_FEBF,
    &lxb_unicode_data_FEC0,
    &lxb_unicode_data_FEC1,
    &lxb_unicode_data_FEC2,
    &lxb_unicode_data_FEC3,
    &lxb_unicode_data_FEC4,
    &lxb_unicode_data_FEC5,
    &lxb_unicode_data_FEC6,
    &lxb_unicode_data_FEC7,
    &lxb_unicode_data_FEC8,
    &lxb_unicode_data_FEC9,
    &lxb_unicode_data_FECA,
    &lxb_unicode_data_FECB,
    &lxb_unicode_data_FECC,
    &lxb_unicode_data_FECD,
    &lxb_unicode_data_FECE,
    &lxb_unicode_data_FECF,
    &lxb_unicode_data_FED0,
    &lxb_unicode_data_FED1,
    &lxb_unicode_data_FED2,
    &lxb_unicode_data_FED3,
    &lxb_unicode_data_FED4,
    &lxb_unicode_data_FED5,
    &lxb_unicode_data_FED6,
    &lxb_unicode_data_FED7,
    &lxb_unicode_data_FED8,
    &lxb_unicode_data_FED9,
    &lxb_unicode_data_FEDA,
    &lxb_unicode_data_FEDB,
    &lxb_unicode_data_FEDC,
    &lxb_unicode_data_FEDD,
    &lxb_unicode_data_FEDE,
    &lxb_unicode_data_FEDF,
    &lxb_unicode_data_FEE0,
    &lxb_unicode_data_FEE1,
    &lxb_unicode_data_FEE2,
    &lxb_unicode_data_FEE3,
    &lxb_unicode_data_FEE4,
    &lxb_unicode_data_FEE5,
    &lxb_unicode_data_FEE6,
    &lxb_unicode_data_FEE7,
    &lxb_unicode_data_FEE8,
    &lxb_unicode_data_FEE9,
    &lxb_unicode_data_FEEA,
    &lxb_unicode_data_FEEB,
    &lxb_unicode_data_FEEC,
    &lxb_unicode_data_FEED,
    &lxb_unicode_data_FEEE,
    &lxb_unicode_data_FEEF,
    &lxb_unicode_data_FEF0,
    &lxb_unicode_data_FEF1,
    &lxb_unicode_data_FEF2,
    &lxb_unicode_data_FEF3,
    &lxb_unicode_data_FEF4,
    &lxb_unicode_data_FEF5,
    &lxb_unicode_data_FEF6,
    &lxb_unicode_data_FEF7,
    &lxb_unicode_data_FEF8,
    &lxb_unicode_data_FEF9,
    &lxb_unicode_data_FEFA,
    &lxb_unicode_data_FEFB,
    &lxb_unicode_data_FEFC,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_FF01,
    &lxb_unicode_data_FF02,
    &lxb_unicode_data_FF03,
    &lxb_unicode_data_FF04,
    &lxb_unicode_data_FF05,
    &lxb_unicode_data_FF06,
    &lxb_unicode_data_FF07,
    &lxb_unicode_data_FF08,
    &lxb_unicode_data_FF09,
    &lxb_unicode_data_FF0A,
    &lxb_unicode_data_FF0B,
    &lxb_unicode_data_FF0C,
    &lxb_unicode_data_FF0D,
    &lxb_unicode_data_FF0E,
    &lxb_unicode_data_FF0F,
    &lxb_unicode_data_FF10,
    &lxb_unicode_data_FF11,
    &lxb_unicode_data_FF12,
    &lxb_unicode_data_FF13,
    &lxb_unicode_data_FF14,
    &lxb_unicode_data_FF15,
    &lxb_unicode_data_FF16,
    &lxb_unicode_data_FF17,
    &lxb_unicode_data_FF18,
    &lxb_unicode_data_FF19,
    &lxb_unicode_data_FF1A,
    &lxb_unicode_data_FF1B,
    &lxb_unicode_data_FF1C,
    &lxb_unicode_data_FF1D,
    &lxb_unicode_data_FF1E,
    &lxb_unicode_data_FF1F,
    &lxb_unicode_data_FF20,
    &lxb_unicode_data_FF21,
    &lxb_unicode_data_FF22,
    &lxb_unicode_data_FF23,
    &lxb_unicode_data_FF24,
    &lxb_unicode_data_FF25,
    &lxb_unicode_data_FF26,
    &lxb_unicode_data_FF27,
    &lxb_unicode_data_FF28,
    &lxb_unicode_data_FF29,
    &lxb_unicode_data_FF2A,
    &lxb_unicode_data_FF2B,
    &lxb_unicode_data_FF2C,
    &lxb_unicode_data_FF2D,
    &lxb_unicode_data_FF2E,
    &lxb_unicode_data_FF2F,
    &lxb_unicode_data_FF30,
    &lxb_unicode_data_FF31,
    &lxb_unicode_data_FF32,
    &lxb_unicode_data_FF33,
    &lxb_unicode_data_FF34,
    &lxb_unicode_data_FF35,
    &lxb_unicode_data_FF36,
    &lxb_unicode_data_FF37,
    &lxb_unicode_data_FF38,
    &lxb_unicode_data_FF39,
    &lxb_unicode_data_FF3A,
    &lxb_unicode_data_FF3B,
    &lxb_unicode_data_FF3C,
    &lxb_unicode_data_FF3D,
    &lxb_unicode_data_FF3E,
    &lxb_unicode_data_FF3F,
    &lxb_unicode_data_FF40,
    &lxb_unicode_data_FF41,
    &lxb_unicode_data_FF42,
    &lxb_unicode_data_FF43,
    &lxb_unicode_data_FF44,
    &lxb_unicode_data_FF45,
    &lxb_unicode_data_FF46,
    &lxb_unicode_data_FF47,
    &lxb_unicode_data_FF48,
    &lxb_unicode_data_FF49,
    &lxb_unicode_data_FF4A,
    &lxb_unicode_data_FF4B,
    &lxb_unicode_data_FF4C,
    &lxb_unicode_data_FF4D,
    &lxb_unicode_data_FF4E,
    &lxb_unicode_data_FF4F,
    &lxb_unicode_data_FF50,
    &lxb_unicode_data_FF51,
    &lxb_unicode_data_FF52,
    &lxb_unicode_data_FF53,
    &lxb_unicode_data_FF54,
    &lxb_unicode_data_FF55,
    &lxb_unicode_data_FF56,
    &lxb_unicode_data_FF57,
    &lxb_unicode_data_FF58,
    &lxb_unicode_data_FF59,
    &lxb_unicode_data_FF5A,
    &lxb_unicode_data_FF5B,
    &lxb_unicode_data_FF5C,
    &lxb_unicode_data_FF5D,
    &lxb_unicode_data_FF5E,
    &lxb_unicode_data_FF5F,
    &lxb_unicode_data_FF60,
    &lxb_unicode_data_FF61,
    &lxb_unicode_data_FF62,
    &lxb_unicode_data_FF63,
    &lxb_unicode_data_FF64,
    &lxb_unicode_data_FF65,
    &lxb_unicode_data_FF66,
    &lxb_unicode_data_FF67,
    &lxb_unicode_data_FF68,
    &lxb_unicode_data_FF69,
    &lxb_unicode_data_FF6A,
    &lxb_unicode_data_FF6B,
    &lxb_unicode_data_FF6C,
    &lxb_unicode_data_FF6D,
    &lxb_unicode_data_FF6E,
    &lxb_unicode_data_FF6F,
    &lxb_unicode_data_FF70,
    &lxb_unicode_data_FF71,
    &lxb_unicode_data_FF72,
    &lxb_unicode_data_FF73,
    &lxb_unicode_data_FF74,
    &lxb_unicode_data_FF75,
    &lxb_unicode_data_FF76,
    &lxb_unicode_data_FF77,
    &lxb_unicode_data_FF78,
    &lxb_unicode_data_FF79,
    &lxb_unicode_data_FF7A,
    &lxb_unicode_data_FF7B,
    &lxb_unicode_data_FF7C,
    &lxb_unicode_data_FF7D,
    &lxb_unicode_data_FF7E,
    &lxb_unicode_data_FF7F,
    &lxb_unicode_data_FF80,
    &lxb_unicode_data_FF81,
    &lxb_unicode_data_FF82,
    &lxb_unicode_data_FF83,
    &lxb_unicode_data_FF84,
    &lxb_unicode_data_FF85,
    &lxb_unicode_data_FF86,
    &lxb_unicode_data_FF87,
    &lxb_unicode_data_FF88,
    &lxb_unicode_data_FF89,
    &lxb_unicode_data_FF8A,
    &lxb_unicode_data_FF8B,
    &lxb_unicode_data_FF8C,
    &lxb_unicode_data_FF8D,
    &lxb_unicode_data_FF8E,
    &lxb_unicode_data_FF8F,
    &lxb_unicode_data_FF90,
    &lxb_unicode_data_FF91,
    &lxb_unicode_data_FF92,
    &lxb_unicode_data_FF93,
    &lxb_unicode_data_FF94,
    &lxb_unicode_data_FF95,
    &lxb_unicode_data_FF96,
    &lxb_unicode_data_FF97,
    &lxb_unicode_data_FF98,
    &lxb_unicode_data_FF99,
    &lxb_unicode_data_FF9A,
    &lxb_unicode_data_FF9B,
    &lxb_unicode_data_FF9C,
    &lxb_unicode_data_FF9D,
    &lxb_unicode_data_FF9E,
    &lxb_unicode_data_FF9F,
    &lxb_unicode_data_FFA0,
    &lxb_unicode_data_FFA1,
    &lxb_unicode_data_FFA2,
    &lxb_unicode_data_FFA3,
    &lxb_unicode_data_FFA4,
    &lxb_unicode_data_FFA5,
    &lxb_unicode_data_FFA6,
    &lxb_unicode_data_FFA7,
    &lxb_unicode_data_FFA8,
    &lxb_unicode_data_FFA9,
    &lxb_unicode_data_FFAA,
    &lxb_unicode_data_FFAB,
    &lxb_unicode_data_FFAC,
    &lxb_unicode_data_FFAD,
    &lxb_unicode_data_FFAE,
    &lxb_unicode_data_FFAF,
    &lxb_unicode_data_FFB0,
    &lxb_unicode_data_FFB1,
    &lxb_unicode_data_FFB2,
    &lxb_unicode_data_FFB3,
    &lxb_unicode_data_FFB4,
    &lxb_unicode_data_FFB5,
    &lxb_unicode_data_FFB6,
    &lxb_unicode_data_FFB7,
    &lxb_unicode_data_FFB8,
    &lxb_unicode_data_FFB9,
    &lxb_unicode_data_FFBA,
    &lxb_unicode_data_FFBB,
    &lxb_unicode_data_FFBC,
    &lxb_unicode_data_FFBD,
    &lxb_unicode_data_FFBE,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_FFC2,
    &lxb_unicode_data_FFC3,
    &lxb_unicode_data_FFC4,
    &lxb_unicode_data_FFC5,
    &lxb_unicode_data_FFC6,
    &lxb_unicode_data_FFC7,
    NULL,
    NULL,
    &lxb_unicode_data_FFCA,
    &lxb_unicode_data_FFCB,
    &lxb_unicode_data_FFCC,
    &lxb_unicode_data_FFCD,
    &lxb_unicode_data_FFCE,
    &lxb_unicode_data_FFCF,
    NULL,
    NULL,
    &lxb_unicode_data_FFD2,
    &lxb_unicode_data_FFD3,
    &lxb_unicode_data_FFD4,
    &lxb_unicode_data_FFD5,
    &lxb_unicode_data_FFD6,
    &lxb_unicode_data_FFD7,
    NULL,
    NULL,
    &lxb_unicode_data_FFDA,
    &lxb_unicode_data_FFDB,
    &lxb_unicode_data_FFDC,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_FFE0,
    &lxb_unicode_data_FFE1,
    &lxb_unicode_data_FFE2,
    &lxb_unicode_data_FFE3,
    &lxb_unicode_data_FFE4,
    &lxb_unicode_data_FFE5,
    &lxb_unicode_data_FFE6,
    NULL,
    &lxb_unicode_data_FFE8,
    &lxb_unicode_data_FFE9,
    &lxb_unicode_data_FFEA,
    &lxb_unicode_data_FFEB,
    &lxb_unicode_data_FFEC,
    &lxb_unicode_data_FFED,
    &lxb_unicode_data_FFEE,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_101FD,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_102E0,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_10376,
    &lxb_unicode_data_10377,
    &lxb_unicode_data_10378,
    &lxb_unicode_data_10379,
    &lxb_unicode_data_1037A,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_10400,
    &lxb_unicode_data_10401,
    &lxb_unicode_data_10402,
    &lxb_unicode_data_10403,
    &lxb_unicode_data_10404,
    &lxb_unicode_data_10405,
    &lxb_unicode_data_10406,
    &lxb_unicode_data_10407,
    &lxb_unicode_data_10408,
    &lxb_unicode_data_10409,
    &lxb_unicode_data_1040A,
    &lxb_unicode_data_1040B,
    &lxb_unicode_data_1040C,
    &lxb_unicode_data_1040D,
    &lxb_unicode_data_1040E,
    &lxb_unicode_data_1040F,
    &lxb_unicode_data_10410,
    &lxb_unicode_data_10411,
    &lxb_unicode_data_10412,
    &lxb_unicode_data_10413,
    &lxb_unicode_data_10414,
    &lxb_unicode_data_10415,
    &lxb_unicode_data_10416,
    &lxb_unicode_data_10417,
    &lxb_unicode_data_10418,
    &lxb_unicode_data_10419,
    &lxb_unicode_data_1041A,
    &lxb_unicode_data_1041B,
    &lxb_unicode_data_1041C,
    &lxb_unicode_data_1041D,
    &lxb_unicode_data_1041E,
    &lxb_unicode_data_1041F,
    &lxb_unicode_data_10420,
    &lxb_unicode_data_10421,
    &lxb_unicode_data_10422,
    &lxb_unicode_data_10423,
    &lxb_unicode_data_10424,
    &lxb_unicode_data_10425,
    &lxb_unicode_data_10426,
    &lxb_unicode_data_10427,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_104B0,
    &lxb_unicode_data_104B1,
    &lxb_unicode_data_104B2,
    &lxb_unicode_data_104B3,
    &lxb_unicode_data_104B4,
    &lxb_unicode_data_104B5,
    &lxb_unicode_data_104B6,
    &lxb_unicode_data_104B7,
    &lxb_unicode_data_104B8,
    &lxb_unicode_data_104B9,
    &lxb_unicode_data_104BA,
    &lxb_unicode_data_104BB,
    &lxb_unicode_data_104BC,
    &lxb_unicode_data_104BD,
    &lxb_unicode_data_104BE,
    &lxb_unicode_data_104BF,
    &lxb_unicode_data_104C0,
    &lxb_unicode_data_104C1,
    &lxb_unicode_data_104C2,
    &lxb_unicode_data_104C3,
    &lxb_unicode_data_104C4,
    &lxb_unicode_data_104C5,
    &lxb_unicode_data_104C6,
    &lxb_unicode_data_104C7,
    &lxb_unicode_data_104C8,
    &lxb_unicode_data_104C9,
    &lxb_unicode_data_104CA,
    &lxb_unicode_data_104CB,
    &lxb_unicode_data_104CC,
    &lxb_unicode_data_104CD,
    &lxb_unicode_data_104CE,
    &lxb_unicode_data_104CF,
    &lxb_unicode_data_104D0,
    &lxb_unicode_data_104D1,
    &lxb_unicode_data_104D2,
    &lxb_unicode_data_104D3,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_10570,
    &lxb_unicode_data_10571,
    &lxb_unicode_data_10572,
    &lxb_unicode_data_10573,
    &lxb_unicode_data_10574,
    &lxb_unicode_data_10575,
    &lxb_unicode_data_10576,
    &lxb_unicode_data_10577,
    &lxb_unicode_data_10578,
    &lxb_unicode_data_10579,
    &lxb_unicode_data_1057A,
    NULL,
    &lxb_unicode_data_1057C,
    &lxb_unicode_data_1057D,
    &lxb_unicode_data_1057E,
    &lxb_unicode_data_1057F,
    &lxb_unicode_data_10580,
    &lxb_unicode_data_10581,
    &lxb_unicode_data_10582,
    &lxb_unicode_data_10583,
    &lxb_unicode_data_10584,
    &lxb_unicode_data_10585,
    &lxb_unicode_data_10586,
    &lxb_unicode_data_10587,
    &lxb_unicode_data_10588,
    &lxb_unicode_data_10589,
    &lxb_unicode_data_1058A,
    NULL,
    &lxb_unicode_data_1058C,
    &lxb_unicode_data_1058D,
    &lxb_unicode_data_1058E,
    &lxb_unicode_data_1058F,
    &lxb_unicode_data_10590,
    &lxb_unicode_data_10591,
    &lxb_unicode_data_10592,
    NULL,
    &lxb_unicode_data_10594,
    &lxb_unicode_data_10595,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_10781,
    &lxb_unicode_data_10782,
    &lxb_unicode_data_10783,
    &lxb_unicode_data_10784,
    &lxb_unicode_data_10785,
    NULL,
    &lxb_unicode_data_10787,
    &lxb_unicode_data_10788,
    &lxb_unicode_data_10789,
    &lxb_unicode_data_1078A,
    &lxb_unicode_data_1078B,
    &lxb_unicode_data_1078C,
    &lxb_unicode_data_1078D,
    &lxb_unicode_data_1078E,
    &lxb_unicode_data_1078F,
    &lxb_unicode_data_10790,
    &lxb_unicode_data_10791,
    &lxb_unicode_data_10792,
    &lxb_unicode_data_10793,
    &lxb_unicode_data_10794,
    &lxb_unicode_data_10795,
    &lxb_unicode_data_10796,
    &lxb_unicode_data_10797,
    &lxb_unicode_data_10798,
    &lxb_unicode_data_10799,
    &lxb_unicode_data_1079A,
    &lxb_unicode_data_1079B,
    &lxb_unicode_data_1079C,
    &lxb_unicode_data_1079D,
    &lxb_unicode_data_1079E,
    &lxb_unicode_data_1079F,
    &lxb_unicode_data_107A0,
    &lxb_unicode_data_107A1,
    &lxb_unicode_data_107A2,
    &lxb_unicode_data_107A3,
    &lxb_unicode_data_107A4,
    &lxb_unicode_data_107A5,
    &lxb_unicode_data_107A6,
    &lxb_unicode_data_107A7,
    &lxb_unicode_data_107A8,
    &lxb_unicode_data_107A9,
    &lxb_unicode_data_107AA,
    &lxb_unicode_data_107AB,
    &lxb_unicode_data_107AC,
    &lxb_unicode_data_107AD,
    &lxb_unicode_data_107AE,
    &lxb_unicode_data_107AF,
    &lxb_unicode_data_107B0,
    NULL,
    &lxb_unicode_data_107B2,
    &lxb_unicode_data_107B3,
    &lxb_unicode_data_107B4,
    &lxb_unicode_data_107B5,
    &lxb_unicode_data_107B6,
    &lxb_unicode_data_107B7,
    &lxb_unicode_data_107B8,
    &lxb_unicode_data_107B9,
    &lxb_unicode_data_107BA,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_10A0D,
    NULL,
    &lxb_unicode_data_10A0F,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_10A38,
    &lxb_unicode_data_10A39,
    &lxb_unicode_data_10A3A,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_10A3F,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_10AE5,
    &lxb_unicode_data_10AE6,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_10C80,
    &lxb_unicode_data_10C81,
    &lxb_unicode_data_10C82,
    &lxb_unicode_data_10C83,
    &lxb_unicode_data_10C84,
    &lxb_unicode_data_10C85,
    &lxb_unicode_data_10C86,
    &lxb_unicode_data_10C87,
    &lxb_unicode_data_10C88,
    &lxb_unicode_data_10C89,
    &lxb_unicode_data_10C8A,
    &lxb_unicode_data_10C8B,
    &lxb_unicode_data_10C8C,
    &lxb_unicode_data_10C8D,
    &lxb_unicode_data_10C8E,
    &lxb_unicode_data_10C8F,
    &lxb_unicode_data_10C90,
    &lxb_unicode_data_10C91,
    &lxb_unicode_data_10C92,
    &lxb_unicode_data_10C93,
    &lxb_unicode_data_10C94,
    &lxb_unicode_data_10C95,
    &lxb_unicode_data_10C96,
    &lxb_unicode_data_10C97,
    &lxb_unicode_data_10C98,
    &lxb_unicode_data_10C99,
    &lxb_unicode_data_10C9A,
    &lxb_unicode_data_10C9B,
    &lxb_unicode_data_10C9C,
    &lxb_unicode_data_10C9D,
    &lxb_unicode_data_10C9E,
    &lxb_unicode_data_10C9F,
    &lxb_unicode_data_10CA0,
    &lxb_unicode_data_10CA1,
    &lxb_unicode_data_10CA2,
    &lxb_unicode_data_10CA3,
    &lxb_unicode_data_10CA4,
    &lxb_unicode_data_10CA5,
    &lxb_unicode_data_10CA6,
    &lxb_unicode_data_10CA7,
    &lxb_unicode_data_10CA8,
    &lxb_unicode_data_10CA9,
    &lxb_unicode_data_10CAA,
    &lxb_unicode_data_10CAB,
    &lxb_unicode_data_10CAC,
    &lxb_unicode_data_10CAD,
    &lxb_unicode_data_10CAE,
    &lxb_unicode_data_10CAF,
    &lxb_unicode_data_10CB0,
    &lxb_unicode_data_10CB1,
    &lxb_unicode_data_10CB2,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_10D24,
    &lxb_unicode_data_10D25,
    &lxb_unicode_data_10D26,
    &lxb_unicode_data_10D27,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_10EAB,
    &lxb_unicode_data_10EAC,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_10EFD,
    &lxb_unicode_data_10EFE,
    &lxb_unicode_data_10EFF,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_10F46,
    &lxb_unicode_data_10F47,
    &lxb_unicode_data_10F48,
    &lxb_unicode_data_10F49,
    &lxb_unicode_data_10F4A,
    &lxb_unicode_data_10F4B,
    &lxb_unicode_data_10F4C,
    &lxb_unicode_data_10F4D,
    &lxb_unicode_data_10F4E,
    &lxb_unicode_data_10F4F,
    &lxb_unicode_data_10F50,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_10F82,
    &lxb_unicode_data_10F83,
    &lxb_unicode_data_10F84,
    &lxb_unicode_data_10F85,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_11046,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_11070,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_1107F,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_1109A,
    NULL,
    &lxb_unicode_data_1109C,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_110AB,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_110B9,
    &lxb_unicode_data_110BA,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_11100,
    &lxb_unicode_data_11101,
    &lxb_unicode_data_11102,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_11127,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_1112E,
    &lxb_unicode_data_1112F,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_11133,
    &lxb_unicode_data_11134,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL
};


#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* LEXBOR_UNICODE_TABLES_13_H */
