/*
    This file is part of the KDE libraries
    SPDX-FileCopyrightText: 2016 Kai Uwe Broulik <kde@privat.broulik.de>

    SPDX-License-Identifier: LGPL-2.0-or-later
*/

#ifndef OPENFILEMANAGERWINDOWJOB_P_H
#define OPENFILEMANAGERWINDOWJOB_P_H

#if defined(Q_OS_LINUX) || defined(Q_OS_FREEBSD)
#define USE_DBUS 1
#else
#define USE_DBUS 0
#endif

#include <KJob>

namespace KIO
{
class OpenFileManagerWindowJob;

class AbstractOpenFileManagerWindowStrategy
{
public:
    explicit AbstractOpenFileManagerWindowStrategy(OpenFileManagerWindowJob *job)
        : m_job(job)
    {
    }

    virtual ~AbstractOpenFileManagerWindowStrategy()
    {
    }
    virtual void start(const QList<QUrl> &urls, const QByteArray &asn) = 0;

    void emitResultProxy(int error = KJob::NoError)
    {
        m_job->setError(error);
        m_job->emitResult();
    }

protected:
    OpenFileManagerWindowJob *m_job;
};

#if USE_DBUS
class OpenFileManagerWindowDBusStrategy : public AbstractOpenFileManagerWindowStrategy
{
public:
    explicit OpenFileManagerWindowDBusStrategy(OpenFileManagerWindowJob *job)
        : AbstractOpenFileManagerWindowStrategy(job)
    {
    }
    void start(const QList<QUrl> &urls, const QByteArray &asn) override;
};
#endif

class OpenFileManagerWindowKRunStrategy : public AbstractOpenFileManagerWindowStrategy
{
public:
    explicit OpenFileManagerWindowKRunStrategy(OpenFileManagerWindowJob *job)
        : AbstractOpenFileManagerWindowStrategy(job)
    {
    }
    void start(const QList<QUrl> &urls, const QByteArray &asn) override;
};

#if defined(Q_OS_WINDOWS)
class OpenFileManagerWindowWindowsShellStrategy : public AbstractOpenFileManagerWindowStrategy
{
public:
    explicit OpenFileManagerWindowWindowsShellStrategy(OpenFileManagerWindowJob *job)
        : AbstractOpenFileManagerWindowStrategy(job)
    {
    }
    void start(const QList<QUrl> &urls, const QByteArray &asn) override;
};
#endif
}

#endif // OPENFILEMANAGERWINDOWJOB_P_H
