ITK Release 4.1
===============

Announcement: ITK 4.1.0 has been released!

We are happy to announce the release of the InsightToolkit 4.1.0!
Download links can be found at:

[`https://itk.org/ITK/resources/software.html`](https://itk.org/ITK/resources/software.html)

This release is the first since ITK 4.0.0 and includes a number of bug
fixes and new features. Related to the transition to Git, it also is the
first release to deviate from the even-only minor release number.

Notable changes:

-   A plethora of bug fixes.
-   VTK Bridge support improved -- currently requires VTK Git master.
-   A number of improvements to the Registrationv4 framework.
-   A new TimeVaryingBSplineVelocityFieldTransform.
-   New Deconvolution filtering module with a number of classes.
-   Performance improvements to the LevelSetsv4 framework.
-   Better WrapITK support.
-   A new video filtering module that includes a method to use standard
    filters in a video pipeline.

Some performance regressions were identified that were related to the
use of GetInput() and GetOutput() in the inner loop of a filter. If you
find similar behavior, please report it to the mailing list and issue
tracker.

On the compiler front, CLang support continues to improve. Issues have
been identified with parallel Visual Studio 10 builds. It appears that
Visual Studio 10 has difficulty handling the many projects that result
when BUILD\_TESTING and BUILD\_EXAMPLES are ON. The current workaround
is to set

`Tools>Options>Projects and Solutions>Build and Run>Maximum number of parallel project builds`

to 1 or turn BUILD\_TESTING or BUILD\_EXAMPLES to OFF.

InsightApplications (from the ITKApps repository) has also seen a number
of updates to ITKv4, mostly thanks to the work of Bill Lorenson and
Arnaud Gelas. When building InsightApplications, it is recommended to
use the “superbuild” by pointing CMake to the directory

` InsightApplications-4.1.1/Superbuild`

as the target source directory.

New contributors with merged patches include

-   Andriy Kot
-   Felix Morency

In the upcoming 4.2 release, we will actively re-engage the community
and will be seeking out new contributors.

Andriy Kot (1):

`     ENH: itkMaskFeaturePointSelectionFilter: initial submission`

Arnaud Gelas (9):

`     DOC: fix doxygen warning`\
`     DOC: Add formula for the curvature term`\
`     DOC: update doxygen configuration file for Doxygen 1.6.1`\
`     ENH: Possibility to provide a propagation image`\
`     PERF: Minor speed improvement in LabelObject / LabelMap`\
`     DOC: fix doxygen warnings`\
`     ENH: Make use of types defined in Histogram to be able to handle 64 bit images`\
`     ENH: Use types from itk::Histogram`\
`     BUG: Lots of classes were undocumented cause of a __itkMacro_h was undefined`

Baohua Wu (1):

`     ENH: added convergence checking in itkGradientDescentOptimizerv4`

Bill Lorensen (6):

`     COMP: Unterminated string causes valgrind defect.`\
`     BUG: Wrong size for parameters.`\
`     BUG: Older versions of VTK do not define VTK_LIBRARIES`\
`     BUG: Older version of VTK cannot be used with ITK`\
`     BUG: zlib 1.2.6 API change`\
`     BUG: CPack was not set up propery for ITKv4`

Brad King (9):

`     ENH: Teach ExternalData to expand DATA{} inside strings`\
`     ENH: ExternalData: Add `“`-stamp`”` suffix to build outputs`\
`     ENH: ExternalData: Add option ExternalData_BINARY_ROOT`\
`     ENH: Teach git-gerrit-(push|merge) to validate topic name`\
`     ENH: Teach git-gerrit-merge to report topic name`\
`     ENH: Simplify local Git hook chaining`\
`     BUG: Fix ITK prepare-commit-msg hook to not erase branch name`\
`     BUG: Fix ITK prepare-commit-msg hook for non-GNU sed`\
`     MetaIO: Always use std:: streams for VTK`

Bradley Lowekamp (26):

`     COMP: Fixing compilation warning in the thresholding calculators`\
`     DOC: Updated documentation for ThresholdMaximumConnectedComponents`\
`     ENH: Adding support for VectorImages to LabelToRGBImageFilter`\
`     ENH: VectorConnectedComponet filter to work with VectorImages`\
`     BUG: Fixing UpperBoundary parameter in ThresholdMaxCC filter`\
`     BUG: Fix mismatch in internal image types for IsolatedWatershed`\
`     BUG: Some Set by scalar methods were not modifing the time of filter`\
`     ENH: adding support to LabelOverlay for VectorImage output`\
`     ENH: Adding Image::Rebind to support smoothing vector images`\
`     ENH: Adding Image::Rebind to support smoothing vector images`\
`     BUG: VotingBinary could not set output pixels before`\
`     COMP: fix comparison between signed and unsigned with cast`\
`     BUG: Restoring adaptor support to SmoothingRecursiveGaussian`\
`     BUG: corrected libtiff to be confgured for big-endian system`\
`     BUG: Adding tolerance to the VectorThreshold level-set test`\
`     COMP: Address warnings in PreWarpTest`\
`     BUG: Adding tolerance to ThresholdSegmentationLevelSetWhiteMatterTest`\
`     COMP: attributes don't do anything in forward declarations`\
`     COMP: fix warning of signed unsigned comparison`\
`     BUG: Adjust intensity tolerance for SimpleImageRegistrationTest`\
`     COMP: Use SizeValueType for indexing in Neighborhoods`\
`     ENH: adding additional dart metric for image error statistics`\
`     BUG: Corretly choose best baseline for difference image`\
`     COMP: Fix warning in BalloonForceFilte about vd being unintialized`\
`     BUG: prevent divide by zero in computing mean`\
`     BUG: Set the number of components-per-pixel for SeriesReader`

Brian Avants (5):

`     ENH: adding a multi-start optimizer`\
`     ENH: multi-optimizers w/registration tests`\
`     ENH: fix jacobian wrt params + img-grad reorientation`\
`     ENH: updates for algorithm correctness.`\
`     BUG: cleaning up the tv field registration`

Cory Quammen (5):

`     STYLE: Fixed typo in test variable name`\
`     COMP: Added undefined type`\
`     ENH: Added Deconvolution module`\
`     ENH: Added linear deconvolution filters`\
`     DOC: Fixed indices in pad image filter diagrams`

David Doria (1):

`     DOC: Add Doxygen comments to some functions.`

Félix C. Morency (1):

`     ENH: Added itkVTKImageToImageFilter and Python wrapper to VtkGlue`

Gang Song (3):

`     BUG: return false if dividing by zero in ANTS CC`\
`     ENH: Clean up the Normalized Cross Correlation in Metricv4`\
`     ENH: add test for validating image gradients in metricv4`

Gaëtan Lehmann (9):

`     ENH: Add required named inputs managements in ProcessObject`\
`     BUG: fix module name in module2module.py`\
`     ENH: add wrapping backward compatibility macros`\
`     STYLE: fix InitializationBiasedParticleSwarmOptimizer doxygen name`\
`     BUG: fix WRAP_ITK_INSTALL_PREFIX content`\
`     BUG: remove SwigPyIterator/PySwigIterator`\
`     COMP: global Clone() architecture compatible with java`\
`     BUG: *InDoxygenGroup tests should be ignored by valgrind`\
`     COMP: fix missing vtkImagingPythonD lib link`

Hans Johnson (13):

`     PERF: Updated lbfgsb to fix bug`\
`     COMP: Be compliant with ANSI standard`\
`     COMP: Removed clang compiler warnings.`\
`     BUG: Remove uninitialized memory print.`\
`     BUG: Virtual was missing on derived class`\
`     COMP: Removed HDF5 unused types.`\
`     COMP: Improve coverage of Kernel`\
`     BUG: 32bit windows bug introduced`\
`     DOC: Fixed documentation to match code behavior`\
`     DOC:  Fixed minor documentation issues`\
`     BUG: Added test to expose overlooked bug`\
`     BUG: Propogated bug from ITKv3 Optimized BSplines`\
`     COMP:  Mismatch array length traversal`

ITK Migration V4 (3):

`     DOC: Modify BinaryMorphologicalOpeningImageFilter comments.`\
`     DOC: Modify ScalarImageToTextureFeaturesFilter comments.`\
`     DOC: Modify IntensityWindowingImageFilter comments.`

Kent Williams (3):

`     COMP: cleanup based on CLang warnings`\
`     COMP: Disable GNU extensions for CLang++`\
`     ENH: Add Clone Method to transform hierarchy.`

Luis Ibanez (1):

`     ENH: Scripts to generate Git Statistics.`

Marius Staring (1):

`     PERF: Switched order of if-statement and for-loop in DetermineRegionOfSupport`

Matthew McCormick (16):

`     ENH: Bump CMakeLists.txt version to 4.1.0.`\
`     DOC: Fix log_{10} e doxygen LaTeX formula.`\
`     PERF: Thread Whitaker level set ComputeIteration.`\
`     BUG: LevelSetDenseImage test recognize zero values.`\
`     COMP: Fixing missing include in itkMaskFeaturePointSelectionFilter.`\
`     BUG: Only add MRC to registration factories with ITK_USE_REVIEW ON.`\
`     BUG: Check pthread_create return value.`\
`     PERF: Thread LevelSetEvolution::ComputeIteration for multiple domains.`\
`     ENH: Use compensated summation in  MutualInformationImageToImageMetric.`\
`     STYLE: Fix KWStyle errors.`\
`     BUG: Fix VideoFileReader memory leak.`\
`     DOC: Fix typo in DifferenceImageFilter migration guide.`\
`     COMP: Fix HDF5 build with Windows NMake JOM generator.`\
`     BUG: Remove CTEST_MEMORYCHECK_SUPPRESSIONS_FILE from CTestCustom.cmake.in`\
`     BUG: Add TimeVaryingBSplineVelocityFieldTransform to wrapping exclusion.`\
`     COMP: Warn about VisualStudio parallel build issues.`

Michael Stauffer (21):

`     ENH: Add itkCompensatedSummationTest2`\
`     BUG: Fix the mapping of sampled points in ImageToImageMetricv4.`\
`     BUG: Fix itkCompensatedSummationTest2`\
`     ENH: Add MattesMutualImageToImageMetricv4`\
`     ENH: Add options for scales & learning rate estimation behavior`\
`     BUG: Fix sampled point list creation in ImageToImageMetricv4`\
`     BUG: Metricsv4: set default metric value to max`\
`     PERF: itkTimeVaryingBSplineVelocityFieldImageRegistrationTest duration`\
`     COMP: Fix warnings`\
`     BUG: Remove zero-point assert in JointHistorgram metricv4`\
`     BUG: Address valgrind errors in V4 registration framework.`\
`     BUG: ANTSNeigh metric - check valid point & test non-overlapping`\
`     BUG: MattesMutual v4 metric bug in number of points`\
`     PERF: TimeVaryingVelocityField - Shorten test time`\
`     BUG: Add debug info to SimpleImageRegistrationTest`\
`     BUG: SimpleImageRegistrationTest - remove versions 2 & 3`\
`     BUG: itkSimpleImageRegistrationTest - more debug changes`\
`     BUG: itkSimpleImageRegistrationTest - still more debug changes`\
`     BUG: ImageToImageMetricv4 - concept check for integer image`\
`     BUG: Rename and fix v4 Demons metric to MeansSquares`\
`     BUG: yet still more debugging for itkSimpleImageRegistrationTest`

Nick Tustison (5):

`     ENH:  Adding time-varying B-spline transform.`\
`     ENH:  Adding SyN registration method.`\
`     BUG: Assignment ordering was not correct.`\
`     ENH:  Adding gaussian interpolators.`\
`     BUG:  array subscript is out of bounds.`

Richard Beare (2):

`     ENH: Masking option for histogram thresholding`\
`     BUG: Errors from dashboard`

Sean McBride (1):

`     BUG: disabled use of undefined signed overflow in nrrd test`

Xiaoxiao Liu (2):

`     ENH: Add a video filtering module.`\
`     BUG: Fix OpenCVVideoIOTest windows compiling errors.`
