/* BEGIN_LEGAL 

Copyright (c) 2024 Intel Corporation

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
  
END_LEGAL */
/// @file xed-export-functions.c

// This file was automatically generated.
// Do not edit this file.


/////////////////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-address-width-enum.h */
/////////////////////////////////////////////////////////////////////////////////
#include "xed-address-width-enum.h"
XED_DLL_EXPORT xed_address_width_enum_t str2xed_address_width_enum_t_py(const char* s) {
    return str2xed_address_width_enum_t(s);
}

XED_DLL_EXPORT const char* xed_address_width_enum_t2str_py(const xed_address_width_enum_t p) {
    return xed_address_width_enum_t2str(p);
}

XED_DLL_EXPORT xed_address_width_enum_t xed_address_width_enum_t_last_py(void) {
    return xed_address_width_enum_t_last();
}

///////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-agen.h */
///////////////////////////////////////////////////////////////////
#include "xed-agen.h"
XED_DLL_EXPORT void xed_agen_register_callback_py(xed_register_callback_fn_t register_fn,
                                               xed_segment_base_callback_fn_t segment_fn) {
    xed_agen_register_callback(register_fn, segment_fn);
}

XED_DLL_EXPORT xed_error_enum_t xed_agen_py(xed_decoded_inst_t* xedd,
                                         unsigned int memop_index,
                                         void* context,
                                         xed_uint64_t* out_address) {
    return xed_agen(xedd, memop_index, context, out_address);
}

/////////////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-attribute-enum.h */
/////////////////////////////////////////////////////////////////////////////
#include "xed-attribute-enum.h"
XED_DLL_EXPORT xed_attribute_enum_t str2xed_attribute_enum_t_py(const char* s) {
    return str2xed_attribute_enum_t(s);
}

XED_DLL_EXPORT const char* xed_attribute_enum_t2str_py(const xed_attribute_enum_t p) {
    return xed_attribute_enum_t2str(p);
}

XED_DLL_EXPORT xed_attribute_enum_t xed_attribute_enum_t_last_py(void) {
    return xed_attribute_enum_t_last();
}

////////////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-category-enum.h */
////////////////////////////////////////////////////////////////////////////
#include "xed-category-enum.h"
XED_DLL_EXPORT xed_category_enum_t str2xed_category_enum_t_py(const char* s) {
    return str2xed_category_enum_t(s);
}

XED_DLL_EXPORT const char* xed_category_enum_t2str_py(const xed_category_enum_t p) {
    return xed_category_enum_t2str(p);
}

XED_DLL_EXPORT xed_category_enum_t xed_category_enum_t_last_py(void) {
    return xed_category_enum_t_last();
}

////////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-chip-enum.h */
////////////////////////////////////////////////////////////////////////
#include "xed-chip-enum.h"
XED_DLL_EXPORT xed_chip_enum_t str2xed_chip_enum_t_py(const char* s) {
    return str2xed_chip_enum_t(s);
}

XED_DLL_EXPORT const char* xed_chip_enum_t2str_py(const xed_chip_enum_t p) {
    return xed_chip_enum_t2str(p);
}

XED_DLL_EXPORT xed_chip_enum_t xed_chip_enum_t_last_py(void) {
    return xed_chip_enum_t_last();
}

////////////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-chip-features.h */
////////////////////////////////////////////////////////////////////////////
#include "xed-chip-features.h"
XED_DLL_EXPORT void xed_get_chip_features_py(xed_chip_features_t* p, xed_chip_enum_t chip) {
    xed_get_chip_features(p, chip);
}

XED_DLL_EXPORT void xed_modify_chip_features_py(xed_chip_features_t* p,
                         xed_isa_set_enum_t isa_set,
                         xed_bool_t present) {
    xed_modify_chip_features(p, isa_set, present);
}

///////////////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-cpuid-group-enum.h */
///////////////////////////////////////////////////////////////////////////////
#include "xed-cpuid-group-enum.h"
XED_DLL_EXPORT xed_cpuid_group_enum_t str2xed_cpuid_group_enum_t_py(const char* s) {
    return str2xed_cpuid_group_enum_t(s);
}

XED_DLL_EXPORT const char* xed_cpuid_group_enum_t2str_py(const xed_cpuid_group_enum_t p) {
    return xed_cpuid_group_enum_t2str(p);
}

XED_DLL_EXPORT xed_cpuid_group_enum_t xed_cpuid_group_enum_t_last_py(void) {
    return xed_cpuid_group_enum_t_last();
}

/////////////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-cpuid-rec-enum.h */
/////////////////////////////////////////////////////////////////////////////
#include "xed-cpuid-rec-enum.h"
XED_DLL_EXPORT xed_cpuid_rec_enum_t str2xed_cpuid_rec_enum_t_py(const char* s) {
    return str2xed_cpuid_rec_enum_t(s);
}

XED_DLL_EXPORT const char* xed_cpuid_rec_enum_t2str_py(const xed_cpuid_rec_enum_t p) {
    return xed_cpuid_rec_enum_t2str(p);
}

XED_DLL_EXPORT xed_cpuid_rec_enum_t xed_cpuid_rec_enum_t_last_py(void) {
    return xed_cpuid_rec_enum_t_last();
}

////////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-cpuid-rec.h */
////////////////////////////////////////////////////////////////////////
#include "xed-cpuid-rec.h"
XED_DLL_EXPORT xed_cpuid_group_enum_t xed_get_cpuid_group_enum_for_isa_set_py(xed_isa_set_enum_t isaset, 
                                     xed_uint_t i) {
    return xed_get_cpuid_group_enum_for_isa_set(isaset, i);
}

XED_DLL_EXPORT xed_cpuid_rec_enum_t xed_get_cpuid_rec_enum_for_group_py(xed_cpuid_group_enum_t group, 
                             xed_uint_t i) {
    return xed_get_cpuid_rec_enum_for_group(group, i);
}

XED_DLL_EXPORT xed_bool_t xed_get_cpuid_rec_py(xed_cpuid_rec_enum_t cpuid_bit,
                  xed_cpuid_rec_t* p) {
    return xed_get_cpuid_rec(cpuid_bit, p);
}

/////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-decode.h */
/////////////////////////////////////////////////////////////////////
#include "xed-decode.h"
XED_DLL_EXPORT xed_error_enum_t xed_decode_py(xed_decoded_inst_t* xedd, 
           const xed_uint8_t* itext, 
           const unsigned int bytes) {
    return xed_decode(xedd, itext, bytes);
}

XED_DLL_EXPORT xed_error_enum_t xed_decode_with_features_py(xed_decoded_inst_t* xedd, 
                         const xed_uint8_t* itext, 
                         const unsigned int bytes,
                         xed_chip_features_t* features) {
    return xed_decode_with_features(xedd, itext, bytes, features);
}

///////////////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-decoded-inst-api.h */
///////////////////////////////////////////////////////////////////////////////
#include "xed-decoded-inst-api.h"
XED_DLL_EXPORT xed_bool_t xed_decoded_inst_valid_py(const xed_decoded_inst_t* p) {
    return xed_decoded_inst_valid(p);
}

XED_DLL_EXPORT const xed_inst_t* xed_decoded_inst_inst_py(const xed_decoded_inst_t* p) {
    return xed_decoded_inst_inst(p);
}

XED_DLL_EXPORT xed_category_enum_t xed_decoded_inst_get_category_py(const xed_decoded_inst_t* p) {
    return xed_decoded_inst_get_category(p);
}

XED_DLL_EXPORT xed_extension_enum_t xed_decoded_inst_get_extension_py(const xed_decoded_inst_t* p) {
    return xed_decoded_inst_get_extension(p);
}

XED_DLL_EXPORT xed_isa_set_enum_t xed_decoded_inst_get_isa_set_py(xed_decoded_inst_t const* const p) {
    return xed_decoded_inst_get_isa_set(p);
}

XED_DLL_EXPORT xed_iclass_enum_t xed_decoded_inst_get_iclass_py(const xed_decoded_inst_t* p) {
    return xed_decoded_inst_get_iclass(p);
}

XED_DLL_EXPORT xed_uint32_t xed_decoded_inst_get_attribute_py(const xed_decoded_inst_t* p,
                               xed_attribute_enum_t attr) {
    return xed_decoded_inst_get_attribute(p, attr);
}

XED_DLL_EXPORT xed_attributes_t xed_decoded_inst_get_attributes_py(const xed_decoded_inst_t* p) {
    return xed_decoded_inst_get_attributes(p);
}

XED_DLL_EXPORT xed_uint32_t xed_decoded_inst_is_xacquire_py(const xed_decoded_inst_t* p) {
    return xed_decoded_inst_is_xacquire(p);
}

XED_DLL_EXPORT xed_uint32_t xed_decoded_inst_is_xrelease_py(const xed_decoded_inst_t* p) {
    return xed_decoded_inst_is_xrelease(p);
}

XED_DLL_EXPORT xed_uint32_t xed_decoded_inst_has_mpx_prefix_py(const xed_decoded_inst_t* p) {
    return xed_decoded_inst_has_mpx_prefix(p);
}

XED_DLL_EXPORT xed_bool_t xed_decoded_inst_is_apx_zu_py(const xed_decoded_inst_t* p) {
    return xed_decoded_inst_is_apx_zu(p);
}

XED_DLL_EXPORT xed_uint8_t xed_decoded_inst_get_modrm_py(const xed_decoded_inst_t* p) {
    return xed_decoded_inst_get_modrm(p);
}

XED_DLL_EXPORT xed_bool_t xed_decoded_inst_masked_vector_operation_py(xed_decoded_inst_t* p) {
    return xed_decoded_inst_masked_vector_operation(p);
}

XED_DLL_EXPORT xed_uint_t xed_decoded_inst_vector_length_bits_py(xed_decoded_inst_t const* const p) {
    return xed_decoded_inst_vector_length_bits(p);
}

XED_DLL_EXPORT xed_uint_t xed_decoded_inst_get_nprefixes_py(const xed_decoded_inst_t* p) {
    return xed_decoded_inst_get_nprefixes(p);
}

XED_DLL_EXPORT const xed_operand_values_t* xed_decoded_inst_operands_const_py(const xed_decoded_inst_t* p) {
    return xed_decoded_inst_operands_const(p);
}

XED_DLL_EXPORT xed_operand_values_t* xed_decoded_inst_operands_py(xed_decoded_inst_t* p) {
    return xed_decoded_inst_operands(p);
}

XED_DLL_EXPORT unsigned int xed_decoded_inst_operand_length_bits_py(const xed_decoded_inst_t* p, 
                                     unsigned int operand_index) {
    return xed_decoded_inst_operand_length_bits(p, operand_index);
}

XED_DLL_EXPORT unsigned int xed_decoded_inst_operand_length_py(const xed_decoded_inst_t* p, 
                                unsigned int operand_index) {
    return xed_decoded_inst_operand_length(p, operand_index);
}

XED_DLL_EXPORT unsigned int xed_decoded_inst_noperands_py(const xed_decoded_inst_t* p) {
    return xed_decoded_inst_noperands(p);
}

XED_DLL_EXPORT unsigned int xed_decoded_inst_operand_elements_py(const xed_decoded_inst_t* p, 
                                  unsigned int operand_index) {
    return xed_decoded_inst_operand_elements(p, operand_index);
}

XED_DLL_EXPORT unsigned int xed_decoded_inst_operand_element_size_bits_py(const xed_decoded_inst_t* p, 
                                           unsigned int operand_index) {
    return xed_decoded_inst_operand_element_size_bits(p, operand_index);
}

XED_DLL_EXPORT xed_operand_element_type_enum_t xed_decoded_inst_operand_element_type_py(const xed_decoded_inst_t* p,
                                      unsigned int operand_index) {
    return xed_decoded_inst_operand_element_type(p, operand_index);
}

XED_DLL_EXPORT xed_operand_action_enum_t xed_decoded_inst_operand_action_py(const xed_decoded_inst_t* p,
                                unsigned int operand_index) {
    return xed_decoded_inst_operand_action(p, operand_index);
}

XED_DLL_EXPORT xed_bool_t xed_decoded_inst_masking_py(const xed_decoded_inst_t* p) {
    return xed_decoded_inst_masking(p);
}

XED_DLL_EXPORT xed_bool_t xed_decoded_inst_merging_py(const xed_decoded_inst_t* p) {
    return xed_decoded_inst_merging(p);
}

XED_DLL_EXPORT xed_bool_t xed_decoded_inst_zeroing_py(const xed_decoded_inst_t* p) {
    return xed_decoded_inst_zeroing(p);
}

XED_DLL_EXPORT xed_uint_t xed_decoded_inst_avx512_dest_elements_py(const xed_decoded_inst_t* p) {
    return xed_decoded_inst_avx512_dest_elements(p);
}

XED_DLL_EXPORT void xed_decoded_inst_zero_set_mode_py(xed_decoded_inst_t* p,
                               const xed_state_t* dstate) {
    xed_decoded_inst_zero_set_mode(p, dstate);
}

XED_DLL_EXPORT void xed_decoded_inst_zero_keep_mode_py(xed_decoded_inst_t* p) {
    xed_decoded_inst_zero_keep_mode(p);
}

XED_DLL_EXPORT void xed_decoded_inst_zero_py(xed_decoded_inst_t* p) {
    xed_decoded_inst_zero(p);
}

XED_DLL_EXPORT void xed_decoded_inst_set_mode_py(xed_decoded_inst_t* p,
                          xed_machine_mode_enum_t mmode,
                          xed_address_width_enum_t stack_addr_width) {
    xed_decoded_inst_set_mode(p, mmode, stack_addr_width);
}

XED_DLL_EXPORT void xed_decoded_inst_zero_keep_mode_from_operands_py(xed_decoded_inst_t* p,
    const xed_operand_values_t* operands) {
    xed_decoded_inst_zero_keep_mode_from_operands(p, operands);
}

XED_DLL_EXPORT xed_uint_t xed_decoded_inst_get_length_py(const xed_decoded_inst_t* p) {
    return xed_decoded_inst_get_length(p);
}

XED_DLL_EXPORT xed_uint8_t xed_decoded_inst_get_byte_py(const xed_decoded_inst_t* p, xed_uint_t byte_index) {
    return xed_decoded_inst_get_byte(p, byte_index);
}

XED_DLL_EXPORT xed_uint_t xed_decoded_inst_get_machine_mode_bits_py(const xed_decoded_inst_t* p) {
    return xed_decoded_inst_get_machine_mode_bits(p);
}

XED_DLL_EXPORT xed_uint_t xed_decoded_inst_get_stack_address_mode_bits_py(const xed_decoded_inst_t* p) {
    return xed_decoded_inst_get_stack_address_mode_bits(p);
}

XED_DLL_EXPORT xed_uint32_t xed_decoded_inst_get_operand_width_py(const xed_decoded_inst_t* p) {
    return xed_decoded_inst_get_operand_width(p);
}

XED_DLL_EXPORT xed_chip_enum_t xed_decoded_inst_get_input_chip_py(const xed_decoded_inst_t* p) {
    return xed_decoded_inst_get_input_chip(p);
}

XED_DLL_EXPORT void xed_decoded_inst_set_input_chip_py(xed_decoded_inst_t* p,
                                xed_chip_enum_t chip) {
    xed_decoded_inst_set_input_chip(p, chip);
}

XED_DLL_EXPORT xed_bool_t xed_decoded_inst_valid_for_chip_py(xed_decoded_inst_t const* const p, 
                                xed_chip_enum_t chip) {
    return xed_decoded_inst_valid_for_chip(p, chip);
}

XED_DLL_EXPORT xed_iform_enum_t xed_decoded_inst_get_iform_enum_py(const xed_decoded_inst_t* p) {
    return xed_decoded_inst_get_iform_enum(p);
}

XED_DLL_EXPORT unsigned int xed_decoded_inst_get_iform_enum_dispatch_py(const xed_decoded_inst_t* p) {
    return xed_decoded_inst_get_iform_enum_dispatch(p);
}

XED_DLL_EXPORT void xed_decoded_inst_dump_py(const xed_decoded_inst_t* p, char* buf,  int buflen) {
    xed_decoded_inst_dump(p, buf, buflen);
}

XED_DLL_EXPORT xed_bool_t xed_decoded_inst_dump_xed_format_py(const xed_decoded_inst_t* p,
                                 char* buf, 
                                 int buflen, 
                                 xed_uint64_t runtime_address) {
    return xed_decoded_inst_dump_xed_format(p, buf, buflen, runtime_address);
}

XED_DLL_EXPORT xed_bool_t xed_format_context_py(xed_syntax_enum_t syntax,
                   const xed_decoded_inst_t* xedd,
                   char* out_buffer,
                   int  buffer_len,
                   xed_uint64_t runtime_instruction_address,
                   void* context,
                   xed_disassembly_callback_fn_t symbolic_callback) {
    return xed_format_context(syntax, xedd, out_buffer, buffer_len, runtime_instruction_address, context, symbolic_callback);
}

XED_DLL_EXPORT xed_bool_t xed_format_generic_py(xed_print_info_t* pi) {
    return xed_format_generic(pi);
}

XED_DLL_EXPORT xed_reg_enum_t xed_decoded_inst_get_seg_reg_py(const xed_decoded_inst_t* p,
                             unsigned int mem_idx) {
    return xed_decoded_inst_get_seg_reg(p, mem_idx);
}

XED_DLL_EXPORT xed_reg_enum_t xed_decoded_inst_get_base_reg_py(const xed_decoded_inst_t* p,
                              unsigned int mem_idx) {
    return xed_decoded_inst_get_base_reg(p, mem_idx);
}

XED_DLL_EXPORT xed_reg_enum_t xed_decoded_inst_get_index_reg_py(const xed_decoded_inst_t* p,
                               unsigned int mem_idx) {
    return xed_decoded_inst_get_index_reg(p, mem_idx);
}

XED_DLL_EXPORT xed_uint_t xed_decoded_inst_get_scale_py(const xed_decoded_inst_t* p,
                           unsigned int mem_idx) {
    return xed_decoded_inst_get_scale(p, mem_idx);
}

XED_DLL_EXPORT xed_int64_t xed_decoded_inst_get_memory_displacement_py(const xed_decoded_inst_t* p,
                                         unsigned int mem_idx) {
    return xed_decoded_inst_get_memory_displacement(p, mem_idx);
}

XED_DLL_EXPORT xed_uint_t xed_decoded_inst_get_memory_displacement_width_py(const xed_decoded_inst_t* p,
                                               unsigned int mem_idx) {
    return xed_decoded_inst_get_memory_displacement_width(p, mem_idx);
}

XED_DLL_EXPORT xed_uint_t xed_decoded_inst_get_memory_displacement_width_bits_py(const xed_decoded_inst_t* p,
                                                    unsigned int mem_idx) {
    return xed_decoded_inst_get_memory_displacement_width_bits(p, mem_idx);
}

XED_DLL_EXPORT xed_int64_t xed_decoded_inst_get_branch_displacement_py(const xed_decoded_inst_t* p) {
    return xed_decoded_inst_get_branch_displacement(p);
}

XED_DLL_EXPORT xed_uint_t xed_decoded_inst_get_branch_displacement_width_py(const xed_decoded_inst_t* p) {
    return xed_decoded_inst_get_branch_displacement_width(p);
}

XED_DLL_EXPORT xed_uint_t xed_decoded_inst_get_branch_displacement_width_bits_py(const xed_decoded_inst_t* p) {
    return xed_decoded_inst_get_branch_displacement_width_bits(p);
}

XED_DLL_EXPORT xed_uint64_t xed_decoded_inst_get_unsigned_immediate_py(const xed_decoded_inst_t* p) {
    return xed_decoded_inst_get_unsigned_immediate(p);
}

XED_DLL_EXPORT xed_uint_t xed_decoded_inst_get_immediate_is_signed_py(const xed_decoded_inst_t* p) {
    return xed_decoded_inst_get_immediate_is_signed(p);
}

XED_DLL_EXPORT xed_uint_t xed_decoded_inst_get_immediate_width_py(const xed_decoded_inst_t* p) {
    return xed_decoded_inst_get_immediate_width(p);
}

XED_DLL_EXPORT xed_uint_t xed_decoded_inst_get_immediate_width_bits_py(const xed_decoded_inst_t* p) {
    return xed_decoded_inst_get_immediate_width_bits(p);
}

XED_DLL_EXPORT xed_int32_t xed_decoded_inst_get_signed_immediate_py(const xed_decoded_inst_t* p) {
    return xed_decoded_inst_get_signed_immediate(p);
}

XED_DLL_EXPORT xed_uint8_t xed_decoded_inst_get_second_immediate_py(const xed_decoded_inst_t* p) {
    return xed_decoded_inst_get_second_immediate(p);
}

XED_DLL_EXPORT xed_reg_enum_t xed_decoded_inst_get_reg_py(const xed_decoded_inst_t* p, 
                         xed_operand_enum_t reg_operand) {
    return xed_decoded_inst_get_reg(p, reg_operand);
}

XED_DLL_EXPORT xed_reg_enum_t xed_decoded_inst_get_dfv_reg_py(const xed_decoded_inst_t* xedd) {
    return xed_decoded_inst_get_dfv_reg(xedd);
}

XED_DLL_EXPORT const xed_simple_flag_t* xed_decoded_inst_get_rflags_info_py(const xed_decoded_inst_t* p) {
    return xed_decoded_inst_get_rflags_info(p);
}

XED_DLL_EXPORT xed_bool_t xed_decoded_inst_uses_rflags_py(const xed_decoded_inst_t* p) {
    return xed_decoded_inst_uses_rflags(p);
}

XED_DLL_EXPORT xed_uint_t xed_decoded_inst_number_of_memory_operands_py(const xed_decoded_inst_t* p) {
    return xed_decoded_inst_number_of_memory_operands(p);
}

XED_DLL_EXPORT xed_bool_t xed_decoded_inst_mem_read_py(const xed_decoded_inst_t* p, unsigned int mem_idx) {
    return xed_decoded_inst_mem_read(p, mem_idx);
}

XED_DLL_EXPORT xed_bool_t xed_decoded_inst_mem_written_py(const xed_decoded_inst_t* p, unsigned int mem_idx) {
    return xed_decoded_inst_mem_written(p, mem_idx);
}

XED_DLL_EXPORT xed_bool_t xed_decoded_inst_mem_written_only_py(const xed_decoded_inst_t* p,
                                  unsigned int mem_idx) {
    return xed_decoded_inst_mem_written_only(p, mem_idx);
}

XED_DLL_EXPORT xed_bool_t xed_decoded_inst_conditionally_writes_registers_py(const xed_decoded_inst_t* p) {
    return xed_decoded_inst_conditionally_writes_registers(p);
}

XED_DLL_EXPORT unsigned int xed_decoded_inst_get_memory_operand_length_py(const xed_decoded_inst_t* p, 
                                           unsigned int memop_idx) {
    return xed_decoded_inst_get_memory_operand_length(p, memop_idx);
}

XED_DLL_EXPORT unsigned int xed_decoded_inst_get_memop_address_width_py(const xed_decoded_inst_t* p,
                                         xed_uint_t memop_idx) {
    return xed_decoded_inst_get_memop_address_width(p, memop_idx);
}

XED_DLL_EXPORT xed_bool_t xed_decoded_inst_is_prefetch_py(const xed_decoded_inst_t* p) {
    return xed_decoded_inst_is_prefetch(p);
}

XED_DLL_EXPORT xed_bool_t xed_decoded_inst_is_broadcast_py(const xed_decoded_inst_t* p) {
    return xed_decoded_inst_is_broadcast(p);
}

XED_DLL_EXPORT xed_bool_t xed_decoded_inst_is_broadcast_instruction_py(const xed_decoded_inst_t* p) {
    return xed_decoded_inst_is_broadcast_instruction(p);
}

XED_DLL_EXPORT xed_bool_t xed_decoded_inst_uses_embedded_broadcast_py(const xed_decoded_inst_t* p) {
    return xed_decoded_inst_uses_embedded_broadcast(p);
}

XED_DLL_EXPORT void xed_decoded_inst_set_scale_py(xed_decoded_inst_t* p, xed_uint_t scale) {
    xed_decoded_inst_set_scale(p, scale);
}

XED_DLL_EXPORT void xed_decoded_inst_set_memory_displacement_py(xed_decoded_inst_t* p,
                                         xed_int64_t disp,
                                         xed_uint_t length_bytes) {
    xed_decoded_inst_set_memory_displacement(p, disp, length_bytes);
}

XED_DLL_EXPORT void xed_decoded_inst_set_branch_displacement_py(xed_decoded_inst_t* p,
                                         xed_int64_t disp,
                                         xed_uint_t length_bytes) {
    xed_decoded_inst_set_branch_displacement(p, disp, length_bytes);
}

XED_DLL_EXPORT void xed_decoded_inst_set_immediate_signed_py(xed_decoded_inst_t* p,
                                      xed_int32_t x,
                                      xed_uint_t length_bytes) {
    xed_decoded_inst_set_immediate_signed(p, x, length_bytes);
}

XED_DLL_EXPORT void xed_decoded_inst_set_immediate_unsigned_py(xed_decoded_inst_t* p,
                                        xed_uint64_t x,
                                        xed_uint_t length_bytes) {
    xed_decoded_inst_set_immediate_unsigned(p, x, length_bytes);
}

XED_DLL_EXPORT void xed_decoded_inst_set_memory_displacement_bits_py(xed_decoded_inst_t* p,
                                              xed_int64_t disp,
                                              xed_uint_t length_bits) {
    xed_decoded_inst_set_memory_displacement_bits(p, disp, length_bits);
}

XED_DLL_EXPORT void xed_decoded_inst_set_branch_displacement_bits_py(xed_decoded_inst_t* p,
                                              xed_int64_t disp,
                                              xed_uint_t length_bits) {
    xed_decoded_inst_set_branch_displacement_bits(p, disp, length_bits);
}

XED_DLL_EXPORT void xed_decoded_inst_set_immediate_signed_bits_py(xed_decoded_inst_t* p,
                                           xed_int32_t x,
                                           xed_uint_t length_bits) {
    xed_decoded_inst_set_immediate_signed_bits(p, x, length_bits);
}

XED_DLL_EXPORT void xed_decoded_inst_set_immediate_unsigned_bits_py(xed_decoded_inst_t* p,
                                             xed_uint64_t x,
                                             xed_uint_t length_bits) {
    xed_decoded_inst_set_immediate_unsigned_bits(p, x, length_bits);
}

XED_DLL_EXPORT xed_uint64_t xed_decoded_inst_get_user_data_py(xed_decoded_inst_t* p) {
    return xed_decoded_inst_get_user_data(p);
}

XED_DLL_EXPORT void xed_decoded_inst_set_user_data_py(xed_decoded_inst_t* p,
                               xed_uint64_t new_value) {
    xed_decoded_inst_set_user_data(p, new_value);
}

XED_DLL_EXPORT xed_bool_t xed_classify_apx_py(const xed_decoded_inst_t* d) {
    return xed_classify_apx(d);
}

XED_DLL_EXPORT xed_bool_t xed_classify_amx_py(const xed_decoded_inst_t* d) {
    return xed_classify_amx(d);
}

XED_DLL_EXPORT xed_bool_t xed_classify_avx512_py(const xed_decoded_inst_t* d) {
    return xed_classify_avx512(d);
}

XED_DLL_EXPORT xed_bool_t xed_classify_avx512_maskop_py(const xed_decoded_inst_t* d) {
    return xed_classify_avx512_maskop(d);
}

XED_DLL_EXPORT xed_bool_t xed_classify_avx_py(const xed_decoded_inst_t* d) {
    return xed_classify_avx(d);
}

XED_DLL_EXPORT xed_bool_t xed_classify_sse_py(const xed_decoded_inst_t* d) {
    return xed_classify_sse(d);
}

////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-disas.h */
////////////////////////////////////////////////////////////////////
#include "xed-disas.h"
/////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-encode.h */
/////////////////////////////////////////////////////////////////////
#include "xed-encode.h"
XED_DLL_EXPORT xed_iclass_enum_t xed_encoder_request_get_iclass_py(const xed_encoder_request_t* p) {
    return xed_encoder_request_get_iclass(p);
}

XED_DLL_EXPORT void xed_encoder_request_set_iclass_py(xed_encoder_request_t* p, 
                                xed_iclass_enum_t iclass) {
    xed_encoder_request_set_iclass(p, iclass);
}

XED_DLL_EXPORT void xed_encoder_request_set_effective_operand_width_py(xed_encoder_request_t* p, 
                                                 xed_uint_t width_bits) {
    xed_encoder_request_set_effective_operand_width(p, width_bits);
}

XED_DLL_EXPORT void xed_encoder_request_set_effective_address_size_py(xed_encoder_request_t* p, 
                                                xed_uint_t width_bits) {
    xed_encoder_request_set_effective_address_size(p, width_bits);
}

XED_DLL_EXPORT void xed_encoder_request_set_reg_py(xed_encoder_request_t* p,
                                                xed_operand_enum_t operand, 
                                                xed_reg_enum_t reg) {
    xed_encoder_request_set_reg(p, operand, reg);
}

XED_DLL_EXPORT void xed_encoder_request_set_operand_order_py(xed_encoder_request_t* p, 
                                      xed_uint_t operand_index, 
                                      xed_operand_enum_t name) {
    xed_encoder_request_set_operand_order(p, operand_index, name);
}

XED_DLL_EXPORT xed_operand_enum_t xed_encoder_request_get_operand_order_py(xed_encoder_request_t* p, 
                                      xed_uint_t operand_index) {
    return xed_encoder_request_get_operand_order(p, operand_index);
}

XED_DLL_EXPORT xed_uint_t xed_encoder_request_operand_order_entries_py(xed_encoder_request_t* p) {
    return xed_encoder_request_operand_order_entries(p);
}

XED_DLL_EXPORT void xed_encoder_request_set_relbr_py(xed_encoder_request_t* p) {
    xed_encoder_request_set_relbr(p);
}

XED_DLL_EXPORT void xed_encoder_request_set_absbr_py(xed_encoder_request_t* p) {
    xed_encoder_request_set_absbr(p);
}

XED_DLL_EXPORT void xed_encoder_request_set_branch_displacement_py(xed_encoder_request_t* p,
                                            xed_int64_t brdisp,
                                            xed_uint_t nbytes) {
    xed_encoder_request_set_branch_displacement(p, brdisp, nbytes);
}

XED_DLL_EXPORT void xed_encoder_request_set_ptr_py(xed_encoder_request_t* p) {
    xed_encoder_request_set_ptr(p);
}

XED_DLL_EXPORT void xed_encoder_request_set_uimm0_py(xed_encoder_request_t* p,
                                                  xed_uint64_t uimm,
                                                  xed_uint_t nbytes) {
    xed_encoder_request_set_uimm0(p, uimm, nbytes);
}

XED_DLL_EXPORT void xed_encoder_request_set_uimm0_bits_py(xed_encoder_request_t* p,
                                                       xed_uint64_t uimm,
                                                       xed_uint_t nbits) {
    xed_encoder_request_set_uimm0_bits(p, uimm, nbits);
}

XED_DLL_EXPORT void xed_encoder_request_set_uimm1_py(xed_encoder_request_t* p,
                                                  xed_uint8_t uimm) {
    xed_encoder_request_set_uimm1(p, uimm);
}

XED_DLL_EXPORT void xed_encoder_request_set_simm_py(xed_encoder_request_t* p,
                                                 xed_int32_t simm,
                                                 xed_uint_t nbytes) {
    xed_encoder_request_set_simm(p, simm, nbytes);
}

XED_DLL_EXPORT void xed_encoder_request_set_memory_displacement_py(xed_encoder_request_t* p,
                                            xed_int64_t memdisp,
                                            xed_uint_t nbytes) {
    xed_encoder_request_set_memory_displacement(p, memdisp, nbytes);
}

XED_DLL_EXPORT void xed_encoder_request_set_agen_py(xed_encoder_request_t* p) {
    xed_encoder_request_set_agen(p);
}

XED_DLL_EXPORT void xed_encoder_request_set_mem0_py(xed_encoder_request_t* p) {
    xed_encoder_request_set_mem0(p);
}

XED_DLL_EXPORT void xed_encoder_request_set_mem1_py(xed_encoder_request_t* p) {
    xed_encoder_request_set_mem1(p);
}

XED_DLL_EXPORT void xed_encoder_request_set_memory_operand_length_py(xed_encoder_request_t* p,
                                              xed_uint_t nbytes) {
    xed_encoder_request_set_memory_operand_length(p, nbytes);
}

XED_DLL_EXPORT void xed_encoder_request_set_seg0_py(xed_encoder_request_t* p,
                                  xed_reg_enum_t seg_reg) {
    xed_encoder_request_set_seg0(p, seg_reg);
}

XED_DLL_EXPORT void xed_encoder_request_set_seg1_py(xed_encoder_request_t* p,
                                  xed_reg_enum_t seg_reg) {
    xed_encoder_request_set_seg1(p, seg_reg);
}

XED_DLL_EXPORT void xed_encoder_request_set_base0_py(xed_encoder_request_t* p,
                                   xed_reg_enum_t base_reg) {
    xed_encoder_request_set_base0(p, base_reg);
}

XED_DLL_EXPORT void xed_encoder_request_set_base1_py(xed_encoder_request_t* p,
                                   xed_reg_enum_t base_reg) {
    xed_encoder_request_set_base1(p, base_reg);
}

XED_DLL_EXPORT void xed_encoder_request_set_index_py(xed_encoder_request_t* p,
                                   xed_reg_enum_t index_reg) {
    xed_encoder_request_set_index(p, index_reg);
}

XED_DLL_EXPORT void xed_encoder_request_set_scale_py(xed_encoder_request_t* p,
                              xed_uint_t scale) {
    xed_encoder_request_set_scale(p, scale);
}

XED_DLL_EXPORT const xed_operand_values_t* xed_encoder_request_operands_const_py(const xed_encoder_request_t* p) {
    return xed_encoder_request_operands_const(p);
}

XED_DLL_EXPORT xed_operand_values_t* xed_encoder_request_operands_py(xed_encoder_request_t* p) {
    return xed_encoder_request_operands(p);
}

XED_DLL_EXPORT void xed_encoder_request_zero_operand_order_py(xed_encoder_request_t* p) {
    xed_encoder_request_zero_operand_order(p);
}

XED_DLL_EXPORT void xed_encoder_request_zero_set_mode_py(xed_encoder_request_t* p,
                                  const xed_state_t* dstate) {
    xed_encoder_request_zero_set_mode(p, dstate);
}

XED_DLL_EXPORT void xed_encoder_request_zero_py(xed_encoder_request_t* p) {
    xed_encoder_request_zero(p);
}

XED_DLL_EXPORT void xed_encoder_request_init_from_decode_py(struct xed_decoded_inst_s* d) {
    xed_encoder_request_init_from_decode(d);
}

XED_DLL_EXPORT void xed_encode_request_print_py(const xed_encoder_request_t* p, 
                                             char* buf, xed_uint_t buflen) {
    xed_encode_request_print(p, buf, buflen);
}

XED_DLL_EXPORT xed_error_enum_t xed_encode_py(xed_encoder_request_t* r,
           xed_uint8_t* array, 
           const unsigned int ilen,
           unsigned int* olen) {
    return xed_encode(r, array, ilen, olen);
}

XED_DLL_EXPORT xed_error_enum_t xed_encode_nop_py(xed_uint8_t* array, 
               const unsigned int ilen) {
    return xed_encode_nop(array, ilen);
}

/////////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-encoder-hl.h */
/////////////////////////////////////////////////////////////////////////
#include "xed-encoder-hl.h"
XED_DLL_EXPORT xed_enc_displacement_t xed_disp_py(xed_int64_t   displacement,
                                xed_uint32_t   displacement_bits) {
    return xed_disp(displacement, displacement_bits);
}

XED_DLL_EXPORT xed_encoder_operand_t xed_relbr_py(xed_int32_t brdisp,
                                                   xed_uint_t width_bits) {
    return xed_relbr(brdisp, width_bits);
}

XED_DLL_EXPORT xed_encoder_operand_t xed_absbr_py(xed_int32_t brdisp,
                                                   xed_uint_t width_bits) {
    return xed_absbr(brdisp, width_bits);
}

XED_DLL_EXPORT xed_encoder_operand_t xed_ptr_py(xed_int32_t brdisp,
                                                 xed_uint_t width_bits) {
    return xed_ptr(brdisp, width_bits);
}

XED_DLL_EXPORT xed_encoder_operand_t xed_reg_py(xed_reg_enum_t reg) {
    return xed_reg(reg);
}

XED_DLL_EXPORT xed_encoder_operand_t xed_imm0_py(xed_uint64_t v,
                                                  xed_uint_t width_bits) {
    return xed_imm0(v, width_bits);
}

XED_DLL_EXPORT xed_encoder_operand_t xed_simm0_py(xed_int32_t v,
                                                   xed_uint_t width_bits) {
    return xed_simm0(v, width_bits);
}

XED_DLL_EXPORT xed_encoder_operand_t xed_imm1_py(xed_uint8_t v) {
    return xed_imm1(v);
}

XED_DLL_EXPORT xed_encoder_operand_t xed_other_py(xed_operand_enum_t operand_name,
                                            xed_int32_t value) {
    return xed_other(operand_name, value);
}

XED_DLL_EXPORT xed_encoder_operand_t xed_seg0_py(xed_reg_enum_t seg0) {
    return xed_seg0(seg0);
}

XED_DLL_EXPORT xed_encoder_operand_t xed_seg1_py(xed_reg_enum_t seg1) {
    return xed_seg1(seg1);
}

XED_DLL_EXPORT xed_encoder_operand_t xed_mem_b_py(xed_reg_enum_t base,
                                                   xed_uint_t width_bits) {
    return xed_mem_b(base, width_bits);
}

XED_DLL_EXPORT xed_encoder_operand_t xed_mem_bd_py(xed_reg_enum_t base, 
                              xed_enc_displacement_t disp,
                              xed_uint_t width_bits) {
    return xed_mem_bd(base, disp, width_bits);
}

XED_DLL_EXPORT xed_encoder_operand_t xed_mem_bisd_py(xed_reg_enum_t base, 
                                xed_reg_enum_t index, 
                                xed_uint_t scale,
                                xed_enc_displacement_t disp,
                                xed_uint_t width_bits) {
    return xed_mem_bisd(base, index, scale, disp, width_bits);
}

XED_DLL_EXPORT xed_encoder_operand_t xed_mem_gb_py(xed_reg_enum_t seg,
                                                    xed_reg_enum_t base,
                                                    xed_uint_t width_bits) {
    return xed_mem_gb(seg, base, width_bits);
}

XED_DLL_EXPORT xed_encoder_operand_t xed_mem_gbd_py(xed_reg_enum_t seg,
                                                  xed_reg_enum_t base, 
                                                  xed_enc_displacement_t disp,
                                                  xed_uint_t width_bits) {
    return xed_mem_gbd(seg, base, disp, width_bits);
}

XED_DLL_EXPORT xed_encoder_operand_t xed_mem_gd_py(xed_reg_enum_t seg,
                               xed_enc_displacement_t disp,
                               xed_uint_t width_bits) {
    return xed_mem_gd(seg, disp, width_bits);
}

XED_DLL_EXPORT xed_encoder_operand_t xed_mem_gbisd_py(xed_reg_enum_t seg, 
                                 xed_reg_enum_t base, 
                                 xed_reg_enum_t index, 
                                 xed_uint_t scale,
                                 xed_enc_displacement_t disp, 
                                 xed_uint_t width_bits) {
    return xed_mem_gbisd(seg, base, index, scale, disp, width_bits);
}

XED_DLL_EXPORT void xed_addr_py(xed_encoder_instruction_t* x, 
                                xed_uint_t width_bits) {
    xed_addr(x, width_bits);
}

XED_DLL_EXPORT void xed_rep_py(xed_encoder_instruction_t* x) {
    xed_rep(x);
}

XED_DLL_EXPORT void xed_repne_py(xed_encoder_instruction_t* x) {
    xed_repne(x);
}

XED_DLL_EXPORT xed_bool_t xed_convert_to_encoder_request_py(xed_encoder_request_t* out,
                               xed_encoder_instruction_t* in) {
    return xed_convert_to_encoder_request(out, in);
}

XED_DLL_EXPORT void xed_inst0_py(xed_encoder_instruction_t* inst,
    xed_state_t mode,
    xed_iclass_enum_t iclass,
    xed_uint_t effective_operand_width) {
    xed_inst0(inst, mode, iclass, effective_operand_width);
}

XED_DLL_EXPORT void xed_inst1_py(xed_encoder_instruction_t* inst,
    xed_state_t mode,
    xed_iclass_enum_t iclass,
    xed_uint_t effective_operand_width,
    xed_encoder_operand_t op0) {
    xed_inst1(inst, mode, iclass, effective_operand_width, op0);
}

XED_DLL_EXPORT void xed_inst2_py(xed_encoder_instruction_t* inst,
    xed_state_t mode,
    xed_iclass_enum_t iclass,
    xed_uint_t effective_operand_width,
    xed_encoder_operand_t op0,
    xed_encoder_operand_t op1) {
    xed_inst2(inst, mode, iclass, effective_operand_width, op0, op1);
}

XED_DLL_EXPORT void xed_inst3_py(xed_encoder_instruction_t* inst,
    xed_state_t mode,
    xed_iclass_enum_t iclass,
    xed_uint_t effective_operand_width,
    xed_encoder_operand_t op0,
    xed_encoder_operand_t op1,
    xed_encoder_operand_t op2) {
    xed_inst3(inst, mode, iclass, effective_operand_width, op0, op1, op2);
}

XED_DLL_EXPORT void xed_inst4_py(xed_encoder_instruction_t* inst,
    xed_state_t mode,
    xed_iclass_enum_t iclass,
    xed_uint_t effective_operand_width,
    xed_encoder_operand_t op0,
    xed_encoder_operand_t op1,
    xed_encoder_operand_t op2,
    xed_encoder_operand_t op3) {
    xed_inst4(inst, mode, iclass, effective_operand_width, op0, op1, op2, op3);
}

XED_DLL_EXPORT void xed_inst5_py(xed_encoder_instruction_t* inst,
    xed_state_t mode,
    xed_iclass_enum_t iclass,
    xed_uint_t effective_operand_width,
    xed_encoder_operand_t op0,
    xed_encoder_operand_t op1,
    xed_encoder_operand_t op2,
    xed_encoder_operand_t op3,
    xed_encoder_operand_t op4) {
    xed_inst5(inst, mode, iclass, effective_operand_width, op0, op1, op2, op3, op4);
}

XED_DLL_EXPORT void xed_inst_py(xed_encoder_instruction_t* inst,
    xed_state_t mode,
    xed_iclass_enum_t iclass,
    xed_uint_t effective_operand_width,
    xed_uint_t number_of_operands,
    const xed_encoder_operand_t* operand_array) {
    xed_inst(inst, mode, iclass, effective_operand_width, number_of_operands, operand_array);
}

/////////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-error-enum.h */
/////////////////////////////////////////////////////////////////////////
#include "xed-error-enum.h"
XED_DLL_EXPORT xed_error_enum_t str2xed_error_enum_t_py(const char* s) {
    return str2xed_error_enum_t(s);
}

XED_DLL_EXPORT const char* xed_error_enum_t2str_py(const xed_error_enum_t p) {
    return xed_error_enum_t2str(p);
}

XED_DLL_EXPORT xed_error_enum_t xed_error_enum_t_last_py(void) {
    return xed_error_enum_t_last();
}

/////////////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-exception-enum.h */
/////////////////////////////////////////////////////////////////////////////
#include "xed-exception-enum.h"
XED_DLL_EXPORT xed_exception_enum_t str2xed_exception_enum_t_py(const char* s) {
    return str2xed_exception_enum_t(s);
}

XED_DLL_EXPORT const char* xed_exception_enum_t2str_py(const xed_exception_enum_t p) {
    return xed_exception_enum_t2str(p);
}

XED_DLL_EXPORT xed_exception_enum_t xed_exception_enum_t_last_py(void) {
    return xed_exception_enum_t_last();
}

/////////////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-extension-enum.h */
/////////////////////////////////////////////////////////////////////////////
#include "xed-extension-enum.h"
XED_DLL_EXPORT xed_extension_enum_t str2xed_extension_enum_t_py(const char* s) {
    return str2xed_extension_enum_t(s);
}

XED_DLL_EXPORT const char* xed_extension_enum_t2str_py(const xed_extension_enum_t p) {
    return xed_extension_enum_t2str(p);
}

XED_DLL_EXPORT xed_extension_enum_t xed_extension_enum_t_last_py(void) {
    return xed_extension_enum_t_last();
}

///////////////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-flag-action-enum.h */
///////////////////////////////////////////////////////////////////////////////
#include "xed-flag-action-enum.h"
XED_DLL_EXPORT xed_flag_action_enum_t str2xed_flag_action_enum_t_py(const char* s) {
    return str2xed_flag_action_enum_t(s);
}

XED_DLL_EXPORT const char* xed_flag_action_enum_t2str_py(const xed_flag_action_enum_t p) {
    return xed_flag_action_enum_t2str(p);
}

XED_DLL_EXPORT xed_flag_action_enum_t xed_flag_action_enum_t_last_py(void) {
    return xed_flag_action_enum_t_last();
}

////////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-flag-enum.h */
////////////////////////////////////////////////////////////////////////
#include "xed-flag-enum.h"
XED_DLL_EXPORT xed_flag_enum_t str2xed_flag_enum_t_py(const char* s) {
    return str2xed_flag_enum_t(s);
}

XED_DLL_EXPORT const char* xed_flag_enum_t2str_py(const xed_flag_enum_t p) {
    return xed_flag_enum_t2str(p);
}

XED_DLL_EXPORT xed_flag_enum_t xed_flag_enum_t_last_py(void) {
    return xed_flag_enum_t_last();
}

////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-flags.h */
////////////////////////////////////////////////////////////////////
#include "xed-flags.h"
XED_DLL_EXPORT xed_bool_t xed_flag_dfv_get_default_flags_values_py(xed_reg_enum_t dfv_reg, xed_flag_dfv_t* p) {
    return xed_flag_dfv_get_default_flags_values(dfv_reg, p);
}

XED_DLL_EXPORT int xed_flag_set_print_py(const xed_flag_set_t* p, char* buf, int buflen) {
    return xed_flag_set_print(p, buf, buflen);
}

XED_DLL_EXPORT xed_bool_t xed_flag_set_is_subset_of_py(const xed_flag_set_t* p,
                               const xed_flag_set_t* other) {
    return xed_flag_set_is_subset_of(p, other);
}

XED_DLL_EXPORT xed_flag_enum_t xed_flag_action_get_flag_name_py(const xed_flag_action_t* p) {
    return xed_flag_action_get_flag_name(p);
}

XED_DLL_EXPORT xed_flag_action_enum_t xed_flag_action_get_action_py(const xed_flag_action_t* p, unsigned int i) {
    return xed_flag_action_get_action(p, i);
}

XED_DLL_EXPORT xed_bool_t xed_flag_action_action_invalid_py(const xed_flag_action_enum_t a) {
    return xed_flag_action_action_invalid(a);
}

XED_DLL_EXPORT int xed_flag_action_print_py(const xed_flag_action_t* p, char* buf, int buflen) {
    return xed_flag_action_print(p, buf, buflen);
}

XED_DLL_EXPORT xed_bool_t xed_flag_action_read_flag_py(const xed_flag_action_t* p) {
    return xed_flag_action_read_flag(p);
}

XED_DLL_EXPORT xed_bool_t xed_flag_action_writes_flag_py(const xed_flag_action_t* p) {
    return xed_flag_action_writes_flag(p);
}

XED_DLL_EXPORT xed_bool_t xed_flag_action_read_action_py(xed_flag_action_enum_t a) {
    return xed_flag_action_read_action(a);
}

XED_DLL_EXPORT xed_bool_t xed_flag_action_write_action_py(xed_flag_action_enum_t a) {
    return xed_flag_action_write_action(a);
}

XED_DLL_EXPORT unsigned int xed_simple_flag_get_nflags_py(const xed_simple_flag_t* p) {
    return xed_simple_flag_get_nflags(p);
}

XED_DLL_EXPORT const xed_flag_set_t* xed_simple_flag_get_read_flag_set_py(const xed_simple_flag_t* p) {
    return xed_simple_flag_get_read_flag_set(p);
}

XED_DLL_EXPORT const xed_flag_set_t* xed_simple_flag_get_written_flag_set_py(const xed_simple_flag_t* p) {
    return xed_simple_flag_get_written_flag_set(p);
}

XED_DLL_EXPORT const xed_flag_set_t* xed_simple_flag_get_undefined_flag_set_py(const xed_simple_flag_t* p) {
    return xed_simple_flag_get_undefined_flag_set(p);
}

XED_DLL_EXPORT xed_bool_t xed_simple_flag_get_may_write_py(const xed_simple_flag_t* p) {
    return xed_simple_flag_get_may_write(p);
}

XED_DLL_EXPORT xed_bool_t xed_simple_flag_get_must_write_py(const xed_simple_flag_t* p) {
    return xed_simple_flag_get_must_write(p);
}

XED_DLL_EXPORT const xed_flag_action_t* xed_simple_flag_get_flag_action_py(const xed_simple_flag_t* p, unsigned int i) {
    return xed_simple_flag_get_flag_action(p, i);
}

XED_DLL_EXPORT xed_bool_t xed_simple_flag_reads_flags_py(const xed_simple_flag_t* p) {
    return xed_simple_flag_reads_flags(p);
}

XED_DLL_EXPORT xed_bool_t xed_simple_flag_writes_flags_py(const xed_simple_flag_t* p) {
    return xed_simple_flag_writes_flags(p);
}

XED_DLL_EXPORT int xed_simple_flag_print_py(const xed_simple_flag_t* p, char* buf, int buflen) {
    return xed_simple_flag_print(p, buf, buflen);
}

XED_DLL_EXPORT unsigned int xed_flag_set_mask_py(const xed_flag_set_t* p) {
    return xed_flag_set_mask(p);
}

/////////////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-format-options.h */
/////////////////////////////////////////////////////////////////////////////
#include "xed-format-options.h"
XED_DLL_EXPORT void xed_format_set_options_py(xed_format_options_t format_options) {
    xed_format_set_options(format_options);
}

///////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-get-time.h */
///////////////////////////////////////////////////////////////////////
#include "xed-get-time.h"
XED_DLL_EXPORT xed_uint64_t xed_get_time_py(void) {
    return xed_get_time();
}

//////////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-iclass-enum.h */
//////////////////////////////////////////////////////////////////////////
#include "xed-iclass-enum.h"
XED_DLL_EXPORT xed_iclass_enum_t str2xed_iclass_enum_t_py(const char* s) {
    return str2xed_iclass_enum_t(s);
}

XED_DLL_EXPORT const char* xed_iclass_enum_t2str_py(const xed_iclass_enum_t p) {
    return xed_iclass_enum_t2str(p);
}

XED_DLL_EXPORT xed_iclass_enum_t xed_iclass_enum_t_last_py(void) {
    return xed_iclass_enum_t_last();
}

/////////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-iform-enum.h */
/////////////////////////////////////////////////////////////////////////
#include "xed-iform-enum.h"
XED_DLL_EXPORT xed_iform_enum_t str2xed_iform_enum_t_py(const char* s) {
    return str2xed_iform_enum_t(s);
}

XED_DLL_EXPORT const char* xed_iform_enum_t2str_py(const xed_iform_enum_t p) {
    return xed_iform_enum_t2str(p);
}

XED_DLL_EXPORT xed_iform_enum_t xed_iform_enum_t_last_py(void) {
    return xed_iform_enum_t_last();
}

////////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-iform-map.h */
////////////////////////////////////////////////////////////////////////
#include "xed-iform-map.h"
XED_DLL_EXPORT const xed_iform_info_t* xed_iform_map_py(xed_iform_enum_t iform) {
    return xed_iform_map(iform);
}

XED_DLL_EXPORT xed_uint32_t xed_iform_max_per_iclass_py(xed_iclass_enum_t iclass) {
    return xed_iform_max_per_iclass(iclass);
}

XED_DLL_EXPORT xed_uint32_t xed_iform_first_per_iclass_py(xed_iclass_enum_t iclass) {
    return xed_iform_first_per_iclass(iclass);
}

XED_DLL_EXPORT xed_iclass_enum_t xed_iform_to_iclass_py(xed_iform_enum_t iform) {
    return xed_iform_to_iclass(iform);
}

XED_DLL_EXPORT xed_category_enum_t xed_iform_to_category_py(xed_iform_enum_t iform) {
    return xed_iform_to_category(iform);
}

XED_DLL_EXPORT xed_extension_enum_t xed_iform_to_extension_py(xed_iform_enum_t iform) {
    return xed_iform_to_extension(iform);
}

XED_DLL_EXPORT xed_isa_set_enum_t xed_iform_to_isa_set_py(xed_iform_enum_t iform) {
    return xed_iform_to_isa_set(iform);
}

XED_DLL_EXPORT char const* xed_iform_to_iclass_string_att_py(xed_iform_enum_t iform) {
    return xed_iform_to_iclass_string_att(iform);
}

XED_DLL_EXPORT char const* xed_iform_to_iclass_string_intel_py(xed_iform_enum_t iform) {
    return xed_iform_to_iclass_string_intel(iform);
}

///////////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-iformfl-enum.h */
///////////////////////////////////////////////////////////////////////////
#include "xed-iformfl-enum.h"
XED_DLL_EXPORT xed_iformfl_enum_t xed_iformfl_enum_t_last_py(void) {
    return xed_iformfl_enum_t_last();
}

///////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-ild-enum.h */
///////////////////////////////////////////////////////////////////////
#include "xed-ild-enum.h"
XED_DLL_EXPORT xed_ild_map_enum_t str2xed_ild_map_enum_t_py(const char* s) {
    return str2xed_ild_map_enum_t(s);
}

XED_DLL_EXPORT const char* xed_ild_map_enum_t2str_py(const xed_ild_map_enum_t p) {
    return xed_ild_map_enum_t2str(p);
}

XED_DLL_EXPORT xed_ild_map_enum_t xed_ild_map_enum_t_last_py(void) {
    return xed_ild_map_enum_t_last();
}

//////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-ild.h */
//////////////////////////////////////////////////////////////////
#include "xed-ild.h"
XED_DLL_EXPORT xed_error_enum_t xed_ild_decode_py(xed_decoded_inst_t* xedd, 
               const xed_uint8_t* itext, 
               const unsigned int bytes) {
    return xed_ild_decode(xedd, itext, bytes);
}

/////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-immdis.h */
/////////////////////////////////////////////////////////////////////
#include "xed-immdis.h"
XED_DLL_EXPORT void xed_immdis_init_py(xed_immdis_t* p, xed_uint_t max_bytes) {
    xed_immdis_init(p, max_bytes);
}

XED_DLL_EXPORT unsigned int xed_immdis_get_bytes_py(const xed_immdis_t* p) {
    return xed_immdis_get_bytes(p);
}

XED_DLL_EXPORT xed_int64_t xed_immdis_get_signed64_py(const xed_immdis_t* p) {
    return xed_immdis_get_signed64(p);
}

XED_DLL_EXPORT xed_uint64_t xed_immdis_get_unsigned64_py(const xed_immdis_t* p) {
    return xed_immdis_get_unsigned64(p);
}

XED_DLL_EXPORT xed_bool_t xed_immdis_is_zero_py(const xed_immdis_t* p) {
    return xed_immdis_is_zero(p);
}

XED_DLL_EXPORT xed_bool_t xed_immdis_is_one_py(const xed_immdis_t* p) {
    return xed_immdis_is_one(p);
}

XED_DLL_EXPORT xed_uint8_t xed_immdis_get_byte_py(const xed_immdis_t* p, unsigned int i) {
    return xed_immdis_get_byte(p, i);
}

XED_DLL_EXPORT void xed_immdis_set_present_py(xed_immdis_t* p) {
    xed_immdis_set_present(p);
}

XED_DLL_EXPORT xed_bool_t xed_immdis_is_present_py(const xed_immdis_t* p) {
    return xed_immdis_is_present(p);
}

XED_DLL_EXPORT void xed_immdis_set_max_len_py(xed_immdis_t* p, unsigned int mx) {
    xed_immdis_set_max_len(p, mx);
}

XED_DLL_EXPORT void xed_immdis_zero_py(xed_immdis_t* p) {
    xed_immdis_zero(p);
}

XED_DLL_EXPORT unsigned int xed_immdis_get_max_length_py(const xed_immdis_t* p) {
    return xed_immdis_get_max_length(p);
}

XED_DLL_EXPORT xed_bool_t xed_immdis_is_unsigned_py(const xed_immdis_t* p) {
    return xed_immdis_is_unsigned(p);
}

XED_DLL_EXPORT xed_bool_t xed_immdis_is_signed_py(const xed_immdis_t* p) {
    return xed_immdis_is_signed(p);
}

XED_DLL_EXPORT void xed_immdis_set_signed_py(xed_immdis_t* p) {
    xed_immdis_set_signed(p);
}

XED_DLL_EXPORT void xed_immdis_set_unsigned_py(xed_immdis_t* p) {
    xed_immdis_set_unsigned(p);
}

XED_DLL_EXPORT void xed_immdis_add_byte_py(xed_immdis_t* p, xed_uint8_t b) {
    xed_immdis_add_byte(p, b);
}

XED_DLL_EXPORT void xed_immdis_add_byte_array_py(xed_immdis_t* p, int nb, xed_uint8_t* ba) {
    xed_immdis_add_byte_array(p, nb, ba);
}

XED_DLL_EXPORT void xed_immdis_add_shortest_width_signed_py(xed_immdis_t* p, xed_int64_t x, xed_uint8_t legal_widths) {
    xed_immdis_add_shortest_width_signed(p, x, legal_widths);
}

XED_DLL_EXPORT void xed_immdis_add_shortest_width_unsigned_py(xed_immdis_t* p, xed_uint64_t x, xed_uint8_t legal_widths) {
    xed_immdis_add_shortest_width_unsigned(p, x, legal_widths);
}

XED_DLL_EXPORT void xed_immdis_add8_py(xed_immdis_t* p, xed_int8_t d) {
    xed_immdis_add8(p, d);
}

XED_DLL_EXPORT void xed_immdis_add16_py(xed_immdis_t* p, xed_int16_t d) {
    xed_immdis_add16(p, d);
}

XED_DLL_EXPORT void xed_immdis_add32_py(xed_immdis_t* p, xed_int32_t d) {
    xed_immdis_add32(p, d);
}

XED_DLL_EXPORT void xed_immdis_add64_py(xed_immdis_t* p, xed_int64_t d) {
    xed_immdis_add64(p, d);
}

XED_DLL_EXPORT int xed_immdis_print_py(const xed_immdis_t* p, char* buf, int buflen) {
    return xed_immdis_print(p, buf, buflen);
}

XED_DLL_EXPORT int xed_immdis_print_signed_or_unsigned_py(const xed_immdis_t* p, char* buf, int buflen) {
    return xed_immdis_print_signed_or_unsigned(p, buf, buflen);
}

XED_DLL_EXPORT int xed_immdis_print_value_signed_py(const xed_immdis_t* p, char* buf, int buflen) {
    return xed_immdis_print_value_signed(p, buf, buflen);
}

XED_DLL_EXPORT int xed_immdis_print_value_unsigned_py(const xed_immdis_t* p, char* buf, int buflen) {
    return xed_immdis_print_value_unsigned(p, buf, buflen);
}

////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-immed.h */
////////////////////////////////////////////////////////////////////
#include "xed-immed.h"
XED_DLL_EXPORT xed_int64_t xed_immed_from_bytes_py(xed_int8_t* bytes, xed_uint_t n) {
    return xed_immed_from_bytes(bytes, n);
}

///////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-init.h */
///////////////////////////////////////////////////////////////////
#include "xed-init.h"
XED_DLL_EXPORT void xed_tables_init_py(void) {
    xed_tables_init();
}

///////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-inst.h */
///////////////////////////////////////////////////////////////////
#include "xed-inst.h"
XED_DLL_EXPORT xed_operand_enum_t xed_operand_name_py(const xed_operand_t* p) {
    return xed_operand_name(p);
}

XED_DLL_EXPORT xed_operand_visibility_enum_t xed_operand_operand_visibility_py(const xed_operand_t* p) {
    return xed_operand_operand_visibility(p);
}

XED_DLL_EXPORT xed_operand_type_enum_t xed_operand_type_py(const xed_operand_t* p) {
    return xed_operand_type(p);
}

XED_DLL_EXPORT xed_operand_element_xtype_enum_t xed_operand_xtype_py(const xed_operand_t* p) {
    return xed_operand_xtype(p);
}

XED_DLL_EXPORT xed_operand_width_enum_t xed_operand_width_py(const xed_operand_t* p) {
    return xed_operand_width(p);
}

XED_DLL_EXPORT xed_uint32_t xed_operand_width_bits_py(const xed_operand_t* p,
                       const xed_uint32_t eosz) {
    return xed_operand_width_bits(p, eosz);
}

XED_DLL_EXPORT xed_nonterminal_enum_t xed_operand_nonterminal_name_py(const xed_operand_t* p) {
    return xed_operand_nonterminal_name(p);
}

XED_DLL_EXPORT xed_reg_enum_t xed_operand_reg_py(const xed_operand_t* p) {
    return xed_operand_reg(p);
}

XED_DLL_EXPORT xed_uint_t xed_operand_template_is_register_py(const xed_operand_t* p) {
    return xed_operand_template_is_register(p);
}

XED_DLL_EXPORT xed_uint32_t xed_operand_imm_py(const xed_operand_t* p) {
    return xed_operand_imm(p);
}

XED_DLL_EXPORT void xed_operand_print_py(const xed_operand_t* p, char* buf, int buflen) {
    xed_operand_print(p, buf, buflen);
}

XED_DLL_EXPORT xed_uint_t xed_operand_is_register_py(xed_operand_enum_t name) {
    return xed_operand_is_register(name);
}

XED_DLL_EXPORT xed_uint_t xed_operand_is_memory_addressing_register_py(xed_operand_enum_t name) {
    return xed_operand_is_memory_addressing_register(name);
}

XED_DLL_EXPORT xed_operand_action_enum_t xed_operand_rw_py(const xed_operand_t* p) {
    return xed_operand_rw(p);
}

XED_DLL_EXPORT xed_uint_t xed_operand_read_py(const xed_operand_t* p) {
    return xed_operand_read(p);
}

XED_DLL_EXPORT xed_uint_t xed_operand_read_only_py(const xed_operand_t* p) {
    return xed_operand_read_only(p);
}

XED_DLL_EXPORT xed_uint_t xed_operand_written_py(const xed_operand_t* p) {
    return xed_operand_written(p);
}

XED_DLL_EXPORT xed_uint_t xed_operand_written_only_py(const xed_operand_t* p) {
    return xed_operand_written_only(p);
}

XED_DLL_EXPORT xed_uint_t xed_operand_read_and_written_py(const xed_operand_t* p) {
    return xed_operand_read_and_written(p);
}

XED_DLL_EXPORT xed_uint_t xed_operand_conditional_read_py(const xed_operand_t* p) {
    return xed_operand_conditional_read(p);
}

XED_DLL_EXPORT xed_uint_t xed_operand_conditional_write_py(const xed_operand_t* p) {
    return xed_operand_conditional_write(p);
}

XED_DLL_EXPORT unsigned int xed_inst_cpl_py(const xed_inst_t* p) {
    return xed_inst_cpl(p);
}

XED_DLL_EXPORT xed_iform_enum_t xed_inst_iform_enum_py(const xed_inst_t* p) {
    return xed_inst_iform_enum(p);
}

XED_DLL_EXPORT xed_iclass_enum_t xed_inst_iclass_py(const xed_inst_t* p) {
    return xed_inst_iclass(p);
}

XED_DLL_EXPORT xed_category_enum_t xed_inst_category_py(const xed_inst_t* p) {
    return xed_inst_category(p);
}

XED_DLL_EXPORT xed_extension_enum_t xed_inst_extension_py(const xed_inst_t* p) {
    return xed_inst_extension(p);
}

XED_DLL_EXPORT xed_isa_set_enum_t xed_inst_isa_set_py(const xed_inst_t* p) {
    return xed_inst_isa_set(p);
}

XED_DLL_EXPORT unsigned int xed_inst_noperands_py(const xed_inst_t* p) {
    return xed_inst_noperands(p);
}

XED_DLL_EXPORT const xed_operand_t* xed_inst_operand_py(const xed_inst_t* p, unsigned int i) {
    return xed_inst_operand(p, i);
}

XED_DLL_EXPORT xed_uint32_t xed_inst_flag_info_index_py(const xed_inst_t* p) {
    return xed_inst_flag_info_index(p);
}

XED_DLL_EXPORT xed_uint32_t xed_inst_get_attribute_py(const xed_inst_t* p, 
                       xed_attribute_enum_t attr) {
    return xed_inst_get_attribute(p, attr);
}

XED_DLL_EXPORT xed_attributes_t xed_inst_get_attributes_py(const xed_inst_t* p) {
    return xed_inst_get_attributes(p);
}

XED_DLL_EXPORT unsigned int xed_attribute_max_py(void) {
    return xed_attribute_max();
}

XED_DLL_EXPORT xed_attribute_enum_t xed_attribute_py(unsigned int i) {
    return xed_attribute(i);
}

XED_DLL_EXPORT xed_exception_enum_t xed_inst_exception_py(const xed_inst_t* p) {
    return xed_inst_exception(p);
}

XED_DLL_EXPORT const xed_inst_t* xed_inst_table_base_py(void) {
    return xed_inst_table_base();
}

///////////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-isa-set-enum.h */
///////////////////////////////////////////////////////////////////////////
#include "xed-isa-set-enum.h"
XED_DLL_EXPORT xed_isa_set_enum_t str2xed_isa_set_enum_t_py(const char* s) {
    return str2xed_isa_set_enum_t(s);
}

XED_DLL_EXPORT const char* xed_isa_set_enum_t2str_py(const xed_isa_set_enum_t p) {
    return xed_isa_set_enum_t2str(p);
}

XED_DLL_EXPORT xed_isa_set_enum_t xed_isa_set_enum_t_last_py(void) {
    return xed_isa_set_enum_t_last();
}

//////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-isa-set.h */
//////////////////////////////////////////////////////////////////////
#include "xed-isa-set.h"
XED_DLL_EXPORT xed_bool_t xed_isa_set_is_valid_for_chip_py(xed_isa_set_enum_t isa_set,
                              xed_chip_enum_t chip) {
    return xed_isa_set_is_valid_for_chip(isa_set, chip);
}

////////////////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-machine-mode-enum.h */
////////////////////////////////////////////////////////////////////////////////
#include "xed-machine-mode-enum.h"
XED_DLL_EXPORT xed_machine_mode_enum_t str2xed_machine_mode_enum_t_py(const char* s) {
    return str2xed_machine_mode_enum_t(s);
}

XED_DLL_EXPORT const char* xed_machine_mode_enum_t2str_py(const xed_machine_mode_enum_t p) {
    return xed_machine_mode_enum_t2str(p);
}

XED_DLL_EXPORT xed_machine_mode_enum_t xed_machine_mode_enum_t_last_py(void) {
    return xed_machine_mode_enum_t_last();
}

////////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-mapu-enum.h */
////////////////////////////////////////////////////////////////////////
#include "xed-mapu-enum.h"
XED_DLL_EXPORT xed_mapu_enum_t str2xed_mapu_enum_t_py(const char* s) {
    return str2xed_mapu_enum_t(s);
}

XED_DLL_EXPORT const char* xed_mapu_enum_t2str_py(const xed_mapu_enum_t p) {
    return xed_mapu_enum_t2str(p);
}

XED_DLL_EXPORT xed_mapu_enum_t xed_mapu_enum_t_last_py(void) {
    return xed_mapu_enum_t_last();
}

///////////////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-nonterminal-enum.h */
///////////////////////////////////////////////////////////////////////////////
#include "xed-nonterminal-enum.h"
XED_DLL_EXPORT xed_nonterminal_enum_t str2xed_nonterminal_enum_t_py(const char* s) {
    return str2xed_nonterminal_enum_t(s);
}

XED_DLL_EXPORT const char* xed_nonterminal_enum_t2str_py(const xed_nonterminal_enum_t p) {
    return xed_nonterminal_enum_t2str(p);
}

XED_DLL_EXPORT xed_nonterminal_enum_t xed_nonterminal_enum_t_last_py(void) {
    return xed_nonterminal_enum_t_last();
}

////////////////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-operand-accessors.h */
////////////////////////////////////////////////////////////////////////////////
#include "xed-operand-accessors.h"
#if defined(XED_OPERAND_SEG_OVD_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_seg_ovd_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_seg_ovd(d);
}
#endif

#if defined(XED_OPERAND_SEG_OVD_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_seg_ovd_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_seg_ovd(d, opval);
}
#endif

#if defined(XED_OPERAND_HINT_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_hint_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_hint(d);
}
#endif

#if defined(XED_OPERAND_HINT_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_hint_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_hint(d, opval);
}
#endif

#if defined(XED_OPERAND_ENCODE_FORCE_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_encode_force_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_encode_force(d);
}
#endif

#if defined(XED_OPERAND_ENCODE_FORCE_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_encode_force_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_encode_force(d, opval);
}
#endif

#if defined(XED_OPERAND_LOCK_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_lock_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_lock(d);
}
#endif

#if defined(XED_OPERAND_LOCK_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_lock_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_lock(d, opval);
}
#endif

#if defined(XED_OPERAND_NEED_MEMDISP_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_need_memdisp_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_need_memdisp(d);
}
#endif

#if defined(XED_OPERAND_NEED_MEMDISP_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_need_memdisp_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_need_memdisp(d, opval);
}
#endif

#if defined(XED_OPERAND_DISP_DEFINED)
XED_DLL_EXPORT xed_int64_t xed3_operand_get_disp_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_disp(d);
}
#endif

#if defined(XED_OPERAND_DISP_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_disp_py(xed_decoded_inst_t* d, xed_int64_t opval) {
    xed3_operand_set_disp(d, opval);
}
#endif

#if defined(XED_OPERAND_DISP_WIDTH_DEFINED)
XED_DLL_EXPORT xed_uint8_t xed3_operand_get_disp_width_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_disp_width(d);
}
#endif

#if defined(XED_OPERAND_DISP_WIDTH_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_disp_width_py(xed_decoded_inst_t* d, xed_uint8_t opval) {
    xed3_operand_set_disp_width(d, opval);
}
#endif

#if defined(XED_OPERAND_BRDISP_WIDTH_DEFINED)
XED_DLL_EXPORT xed_uint8_t xed3_operand_get_brdisp_width_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_brdisp_width(d);
}
#endif

#if defined(XED_OPERAND_BRDISP_WIDTH_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_brdisp_width_py(xed_decoded_inst_t* d, xed_uint8_t opval) {
    xed3_operand_set_brdisp_width(d, opval);
}
#endif

#if defined(XED_OPERAND_DF32_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_df32_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_df32(d);
}
#endif

#if defined(XED_OPERAND_DF32_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_df32_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_df32(d, opval);
}
#endif

#if defined(XED_OPERAND_DF64_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_df64_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_df64(d);
}
#endif

#if defined(XED_OPERAND_DF64_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_df64_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_df64(d, opval);
}
#endif

#if defined(XED_OPERAND_NOREX_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_norex_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_norex(d);
}
#endif

#if defined(XED_OPERAND_NOREX_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_norex_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_norex(d, opval);
}
#endif

#if defined(XED_OPERAND_NOREX2_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_norex2_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_norex2(d);
}
#endif

#if defined(XED_OPERAND_NOREX2_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_norex2_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_norex2(d, opval);
}
#endif

#if defined(XED_OPERAND_NEEDREX_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_needrex_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_needrex(d);
}
#endif

#if defined(XED_OPERAND_NEEDREX_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_needrex_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_needrex(d, opval);
}
#endif

#if defined(XED_OPERAND_REX_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_rex_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_rex(d);
}
#endif

#if defined(XED_OPERAND_REX_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_rex_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_rex(d, opval);
}
#endif

#if defined(XED_OPERAND_REXW_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_rexw_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_rexw(d);
}
#endif

#if defined(XED_OPERAND_REXW_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_rexw_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_rexw(d, opval);
}
#endif

#if defined(XED_OPERAND_REXR_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_rexr_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_rexr(d);
}
#endif

#if defined(XED_OPERAND_REXR_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_rexr_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_rexr(d, opval);
}
#endif

#if defined(XED_OPERAND_REXX_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_rexx_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_rexx(d);
}
#endif

#if defined(XED_OPERAND_REXX_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_rexx_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_rexx(d, opval);
}
#endif

#if defined(XED_OPERAND_REXB_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_rexb_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_rexb(d);
}
#endif

#if defined(XED_OPERAND_REXB_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_rexb_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_rexb(d, opval);
}
#endif

#if defined(XED_OPERAND_REX2_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_rex2_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_rex2(d);
}
#endif

#if defined(XED_OPERAND_REX2_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_rex2_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_rex2(d, opval);
}
#endif

#if defined(XED_OPERAND_REXB4_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_rexb4_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_rexb4(d);
}
#endif

#if defined(XED_OPERAND_REXB4_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_rexb4_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_rexb4(d, opval);
}
#endif

#if defined(XED_OPERAND_REXX4_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_rexx4_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_rexx4(d);
}
#endif

#if defined(XED_OPERAND_REXX4_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_rexx4_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_rexx4(d, opval);
}
#endif

#if defined(XED_OPERAND_REXR4_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_rexr4_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_rexr4(d);
}
#endif

#if defined(XED_OPERAND_REXR4_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_rexr4_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_rexr4(d, opval);
}
#endif

#if defined(XED_OPERAND_HAS_EGPR_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_has_egpr_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_has_egpr(d);
}
#endif

#if defined(XED_OPERAND_HAS_EGPR_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_has_egpr_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_has_egpr(d, opval);
}
#endif

#if defined(XED_OPERAND_REP_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_rep_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_rep(d);
}
#endif

#if defined(XED_OPERAND_REP_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_rep_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_rep(d, opval);
}
#endif

#if defined(XED_OPERAND_OSZ_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_osz_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_osz(d);
}
#endif

#if defined(XED_OPERAND_OSZ_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_osz_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_osz(d, opval);
}
#endif

#if defined(XED_OPERAND_PREFIX66_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_prefix66_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_prefix66(d);
}
#endif

#if defined(XED_OPERAND_PREFIX66_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_prefix66_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_prefix66(d, opval);
}
#endif

#if defined(XED_OPERAND_ASZ_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_asz_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_asz(d);
}
#endif

#if defined(XED_OPERAND_ASZ_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_asz_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_asz(d, opval);
}
#endif

#if defined(XED_OPERAND_EOSZ_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_eosz_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_eosz(d);
}
#endif

#if defined(XED_OPERAND_EOSZ_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_eosz_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_eosz(d, opval);
}
#endif

#if defined(XED_OPERAND_EASZ_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_easz_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_easz(d);
}
#endif

#if defined(XED_OPERAND_EASZ_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_easz_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_easz(d, opval);
}
#endif

#if defined(XED_OPERAND_SKIP_OSZ_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_skip_osz_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_skip_osz(d);
}
#endif

#if defined(XED_OPERAND_SKIP_OSZ_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_skip_osz_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_skip_osz(d, opval);
}
#endif

#if defined(XED_OPERAND_MOD_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_mod_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_mod(d);
}
#endif

#if defined(XED_OPERAND_MOD_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_mod_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_mod(d, opval);
}
#endif

#if defined(XED_OPERAND_REG_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_reg_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_reg(d);
}
#endif

#if defined(XED_OPERAND_REG_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_reg_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_reg(d, opval);
}
#endif

#if defined(XED_OPERAND_SRM_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_srm_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_srm(d);
}
#endif

#if defined(XED_OPERAND_SRM_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_srm_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_srm(d, opval);
}
#endif

#if defined(XED_OPERAND_RM_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_rm_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_rm(d);
}
#endif

#if defined(XED_OPERAND_RM_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_rm_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_rm(d, opval);
}
#endif

#if defined(XED_OPERAND_REALMODE_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_realmode_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_realmode(d);
}
#endif

#if defined(XED_OPERAND_REALMODE_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_realmode_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_realmode(d, opval);
}
#endif

#if defined(XED_OPERAND_CHIP_DEFINED)
XED_DLL_EXPORT xed_chip_enum_t xed3_operand_get_chip_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_chip(d);
}
#endif

#if defined(XED_OPERAND_CHIP_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_chip_py(xed_decoded_inst_t* d, xed_chip_enum_t opval) {
    xed3_operand_set_chip(d, opval);
}
#endif

#if defined(XED_OPERAND_MODE_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_mode_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_mode(d);
}
#endif

#if defined(XED_OPERAND_MODE_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_mode_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_mode(d, opval);
}
#endif

#if defined(XED_OPERAND_SMODE_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_smode_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_smode(d);
}
#endif

#if defined(XED_OPERAND_SMODE_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_smode_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_smode(d, opval);
}
#endif

#if defined(XED_OPERAND_MODEP5_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_modep5_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_modep5(d);
}
#endif

#if defined(XED_OPERAND_MODEP5_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_modep5_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_modep5(d, opval);
}
#endif

#if defined(XED_OPERAND_MODEP55C_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_modep55c_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_modep55c(d);
}
#endif

#if defined(XED_OPERAND_MODEP55C_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_modep55c_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_modep55c(d, opval);
}
#endif

#if defined(XED_OPERAND_P4_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_p4_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_p4(d);
}
#endif

#if defined(XED_OPERAND_P4_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_p4_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_p4(d, opval);
}
#endif

#if defined(XED_OPERAND_LZCNT_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_lzcnt_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_lzcnt(d);
}
#endif

#if defined(XED_OPERAND_LZCNT_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_lzcnt_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_lzcnt(d, opval);
}
#endif

#if defined(XED_OPERAND_TZCNT_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_tzcnt_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_tzcnt(d);
}
#endif

#if defined(XED_OPERAND_TZCNT_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_tzcnt_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_tzcnt(d, opval);
}
#endif

#if defined(XED_OPERAND_MODE_FIRST_PREFIX_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_mode_first_prefix_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_mode_first_prefix(d);
}
#endif

#if defined(XED_OPERAND_MODE_FIRST_PREFIX_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_mode_first_prefix_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_mode_first_prefix(d, opval);
}
#endif

#if defined(XED_OPERAND_MODE_SHORT_UD0_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_mode_short_ud0_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_mode_short_ud0(d);
}
#endif

#if defined(XED_OPERAND_MODE_SHORT_UD0_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_mode_short_ud0_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_mode_short_ud0(d, opval);
}
#endif

#if defined(XED_OPERAND_IMM0_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_imm0_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_imm0(d);
}
#endif

#if defined(XED_OPERAND_IMM0_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_imm0_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_imm0(d, opval);
}
#endif

#if defined(XED_OPERAND_IMM1_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_imm1_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_imm1(d);
}
#endif

#if defined(XED_OPERAND_IMM1_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_imm1_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_imm1(d, opval);
}
#endif

#if defined(XED_OPERAND_IMM0SIGNED_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_imm0signed_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_imm0signed(d);
}
#endif

#if defined(XED_OPERAND_IMM0SIGNED_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_imm0signed_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_imm0signed(d, opval);
}
#endif

#if defined(XED_OPERAND_UIMM0_DEFINED)
XED_DLL_EXPORT xed_uint64_t xed3_operand_get_uimm0_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_uimm0(d);
}
#endif

#if defined(XED_OPERAND_UIMM0_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_uimm0_py(xed_decoded_inst_t* d, xed_uint64_t opval) {
    xed3_operand_set_uimm0(d, opval);
}
#endif

#if defined(XED_OPERAND_UIMM1_DEFINED)
XED_DLL_EXPORT xed_uint8_t xed3_operand_get_uimm1_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_uimm1(d);
}
#endif

#if defined(XED_OPERAND_UIMM1_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_uimm1_py(xed_decoded_inst_t* d, xed_uint8_t opval) {
    xed3_operand_set_uimm1(d, opval);
}
#endif

#if defined(XED_OPERAND_IMM_WIDTH_DEFINED)
XED_DLL_EXPORT xed_uint8_t xed3_operand_get_imm_width_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_imm_width(d);
}
#endif

#if defined(XED_OPERAND_IMM_WIDTH_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_imm_width_py(xed_decoded_inst_t* d, xed_uint8_t opval) {
    xed3_operand_set_imm_width(d, opval);
}
#endif

#if defined(XED_OPERAND_USING_DEFAULT_SEGMENT0_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_using_default_segment0_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_using_default_segment0(d);
}
#endif

#if defined(XED_OPERAND_USING_DEFAULT_SEGMENT0_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_using_default_segment0_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_using_default_segment0(d, opval);
}
#endif

#if defined(XED_OPERAND_USING_DEFAULT_SEGMENT1_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_using_default_segment1_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_using_default_segment1(d);
}
#endif

#if defined(XED_OPERAND_USING_DEFAULT_SEGMENT1_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_using_default_segment1_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_using_default_segment1(d, opval);
}
#endif

#if defined(XED_OPERAND_DEFAULT_SEG_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_default_seg_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_default_seg(d);
}
#endif

#if defined(XED_OPERAND_DEFAULT_SEG_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_default_seg_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_default_seg(d, opval);
}
#endif

#if defined(XED_OPERAND_SEG0_DEFINED)
XED_DLL_EXPORT xed_reg_enum_t xed3_operand_get_seg0_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_seg0(d);
}
#endif

#if defined(XED_OPERAND_SEG0_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_seg0_py(xed_decoded_inst_t* d, xed_reg_enum_t opval) {
    xed3_operand_set_seg0(d, opval);
}
#endif

#if defined(XED_OPERAND_BASE0_DEFINED)
XED_DLL_EXPORT xed_reg_enum_t xed3_operand_get_base0_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_base0(d);
}
#endif

#if defined(XED_OPERAND_BASE0_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_base0_py(xed_decoded_inst_t* d, xed_reg_enum_t opval) {
    xed3_operand_set_base0(d, opval);
}
#endif

#if defined(XED_OPERAND_INDEX_DEFINED)
XED_DLL_EXPORT xed_reg_enum_t xed3_operand_get_index_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_index(d);
}
#endif

#if defined(XED_OPERAND_INDEX_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_index_py(xed_decoded_inst_t* d, xed_reg_enum_t opval) {
    xed3_operand_set_index(d, opval);
}
#endif

#if defined(XED_OPERAND_SCALE_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_scale_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_scale(d);
}
#endif

#if defined(XED_OPERAND_SCALE_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_scale_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_scale(d, opval);
}
#endif

#if defined(XED_OPERAND_NEED_SIB_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_need_sib_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_need_sib(d);
}
#endif

#if defined(XED_OPERAND_NEED_SIB_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_need_sib_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_need_sib(d, opval);
}
#endif

#if defined(XED_OPERAND_SIBSCALE_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_sibscale_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_sibscale(d);
}
#endif

#if defined(XED_OPERAND_SIBSCALE_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_sibscale_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_sibscale(d, opval);
}
#endif

#if defined(XED_OPERAND_SIBBASE_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_sibbase_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_sibbase(d);
}
#endif

#if defined(XED_OPERAND_SIBBASE_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_sibbase_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_sibbase(d, opval);
}
#endif

#if defined(XED_OPERAND_SIBINDEX_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_sibindex_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_sibindex(d);
}
#endif

#if defined(XED_OPERAND_SIBINDEX_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_sibindex_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_sibindex(d, opval);
}
#endif

#if defined(XED_OPERAND_SEG1_DEFINED)
XED_DLL_EXPORT xed_reg_enum_t xed3_operand_get_seg1_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_seg1(d);
}
#endif

#if defined(XED_OPERAND_SEG1_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_seg1_py(xed_decoded_inst_t* d, xed_reg_enum_t opval) {
    xed3_operand_set_seg1(d, opval);
}
#endif

#if defined(XED_OPERAND_BASE1_DEFINED)
XED_DLL_EXPORT xed_reg_enum_t xed3_operand_get_base1_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_base1(d);
}
#endif

#if defined(XED_OPERAND_BASE1_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_base1_py(xed_decoded_inst_t* d, xed_reg_enum_t opval) {
    xed3_operand_set_base1(d, opval);
}
#endif

#if defined(XED_OPERAND_MEM0_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_mem0_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_mem0(d);
}
#endif

#if defined(XED_OPERAND_MEM0_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_mem0_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_mem0(d, opval);
}
#endif

#if defined(XED_OPERAND_MEM1_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_mem1_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_mem1(d);
}
#endif

#if defined(XED_OPERAND_MEM1_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_mem1_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_mem1(d, opval);
}
#endif

#if defined(XED_OPERAND_MEM_WIDTH_DEFINED)
XED_DLL_EXPORT xed_uint16_t xed3_operand_get_mem_width_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_mem_width(d);
}
#endif

#if defined(XED_OPERAND_MEM_WIDTH_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_mem_width_py(xed_decoded_inst_t* d, xed_uint16_t opval) {
    xed3_operand_set_mem_width(d, opval);
}
#endif

#if defined(XED_OPERAND_AGEN_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_agen_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_agen(d);
}
#endif

#if defined(XED_OPERAND_AGEN_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_agen_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_agen(d, opval);
}
#endif

#if defined(XED_OPERAND_RELBR_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_relbr_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_relbr(d);
}
#endif

#if defined(XED_OPERAND_RELBR_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_relbr_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_relbr(d, opval);
}
#endif

#if defined(XED_OPERAND_ABSBR_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_absbr_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_absbr(d);
}
#endif

#if defined(XED_OPERAND_ABSBR_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_absbr_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_absbr(d, opval);
}
#endif

#if defined(XED_OPERAND_PTR_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_ptr_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_ptr(d);
}
#endif

#if defined(XED_OPERAND_PTR_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_ptr_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_ptr(d, opval);
}
#endif

#if defined(XED_OPERAND_REG0_DEFINED)
XED_DLL_EXPORT xed_reg_enum_t xed3_operand_get_reg0_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_reg0(d);
}
#endif

#if defined(XED_OPERAND_REG0_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_reg0_py(xed_decoded_inst_t* d, xed_reg_enum_t opval) {
    xed3_operand_set_reg0(d, opval);
}
#endif

#if defined(XED_OPERAND_REG1_DEFINED)
XED_DLL_EXPORT xed_reg_enum_t xed3_operand_get_reg1_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_reg1(d);
}
#endif

#if defined(XED_OPERAND_REG1_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_reg1_py(xed_decoded_inst_t* d, xed_reg_enum_t opval) {
    xed3_operand_set_reg1(d, opval);
}
#endif

#if defined(XED_OPERAND_REG2_DEFINED)
XED_DLL_EXPORT xed_reg_enum_t xed3_operand_get_reg2_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_reg2(d);
}
#endif

#if defined(XED_OPERAND_REG2_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_reg2_py(xed_decoded_inst_t* d, xed_reg_enum_t opval) {
    xed3_operand_set_reg2(d, opval);
}
#endif

#if defined(XED_OPERAND_REG3_DEFINED)
XED_DLL_EXPORT xed_reg_enum_t xed3_operand_get_reg3_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_reg3(d);
}
#endif

#if defined(XED_OPERAND_REG3_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_reg3_py(xed_decoded_inst_t* d, xed_reg_enum_t opval) {
    xed3_operand_set_reg3(d, opval);
}
#endif

#if defined(XED_OPERAND_REG4_DEFINED)
XED_DLL_EXPORT xed_reg_enum_t xed3_operand_get_reg4_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_reg4(d);
}
#endif

#if defined(XED_OPERAND_REG4_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_reg4_py(xed_decoded_inst_t* d, xed_reg_enum_t opval) {
    xed3_operand_set_reg4(d, opval);
}
#endif

#if defined(XED_OPERAND_REG5_DEFINED)
XED_DLL_EXPORT xed_reg_enum_t xed3_operand_get_reg5_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_reg5(d);
}
#endif

#if defined(XED_OPERAND_REG5_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_reg5_py(xed_decoded_inst_t* d, xed_reg_enum_t opval) {
    xed3_operand_set_reg5(d, opval);
}
#endif

#if defined(XED_OPERAND_REG6_DEFINED)
XED_DLL_EXPORT xed_reg_enum_t xed3_operand_get_reg6_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_reg6(d);
}
#endif

#if defined(XED_OPERAND_REG6_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_reg6_py(xed_decoded_inst_t* d, xed_reg_enum_t opval) {
    xed3_operand_set_reg6(d, opval);
}
#endif

#if defined(XED_OPERAND_REG7_DEFINED)
XED_DLL_EXPORT xed_reg_enum_t xed3_operand_get_reg7_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_reg7(d);
}
#endif

#if defined(XED_OPERAND_REG7_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_reg7_py(xed_decoded_inst_t* d, xed_reg_enum_t opval) {
    xed3_operand_set_reg7(d, opval);
}
#endif

#if defined(XED_OPERAND_REG8_DEFINED)
XED_DLL_EXPORT xed_reg_enum_t xed3_operand_get_reg8_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_reg8(d);
}
#endif

#if defined(XED_OPERAND_REG8_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_reg8_py(xed_decoded_inst_t* d, xed_reg_enum_t opval) {
    xed3_operand_set_reg8(d, opval);
}
#endif

#if defined(XED_OPERAND_REG9_DEFINED)
XED_DLL_EXPORT xed_reg_enum_t xed3_operand_get_reg9_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_reg9(d);
}
#endif

#if defined(XED_OPERAND_REG9_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_reg9_py(xed_decoded_inst_t* d, xed_reg_enum_t opval) {
    xed3_operand_set_reg9(d, opval);
}
#endif

#if defined(XED_OPERAND_OUTREG_DEFINED)
XED_DLL_EXPORT xed_reg_enum_t xed3_operand_get_outreg_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_outreg(d);
}
#endif

#if defined(XED_OPERAND_OUTREG_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_outreg_py(xed_decoded_inst_t* d, xed_reg_enum_t opval) {
    xed3_operand_set_outreg(d, opval);
}
#endif

#if defined(XED_OPERAND_ENCODER_PREFERRED_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_encoder_preferred_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_encoder_preferred(d);
}
#endif

#if defined(XED_OPERAND_ENCODER_PREFERRED_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_encoder_preferred_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_encoder_preferred(d, opval);
}
#endif

#if defined(XED_OPERAND_ERROR_DEFINED)
XED_DLL_EXPORT xed_error_enum_t xed3_operand_get_error_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_error(d);
}
#endif

#if defined(XED_OPERAND_ERROR_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_error_py(xed_decoded_inst_t* d, xed_error_enum_t opval) {
    xed3_operand_set_error(d, opval);
}
#endif

#if defined(XED_OPERAND_ICLASS_DEFINED)
XED_DLL_EXPORT xed_iclass_enum_t xed3_operand_get_iclass_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_iclass(d);
}
#endif

#if defined(XED_OPERAND_ICLASS_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_iclass_py(xed_decoded_inst_t* d, xed_iclass_enum_t opval) {
    xed3_operand_set_iclass(d, opval);
}
#endif

#if defined(XED_OPERAND_NELEM_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_nelem_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_nelem(d);
}
#endif

#if defined(XED_OPERAND_NELEM_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_nelem_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_nelem(d, opval);
}
#endif

#if defined(XED_OPERAND_ELEMENT_SIZE_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_element_size_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_element_size(d);
}
#endif

#if defined(XED_OPERAND_ELEMENT_SIZE_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_element_size_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_element_size(d, opval);
}
#endif

#if defined(XED_OPERAND_MAP_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_map_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_map(d);
}
#endif

#if defined(XED_OPERAND_MAP_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_map_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_map(d, opval);
}
#endif

#if defined(XED_OPERAND_OUT_OF_BYTES_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_out_of_bytes_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_out_of_bytes(d);
}
#endif

#if defined(XED_OPERAND_OUT_OF_BYTES_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_out_of_bytes_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_out_of_bytes(d, opval);
}
#endif

#if defined(XED_OPERAND_FIRST_F2F3_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_first_f2f3_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_first_f2f3(d);
}
#endif

#if defined(XED_OPERAND_FIRST_F2F3_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_first_f2f3_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_first_f2f3(d, opval);
}
#endif

#if defined(XED_OPERAND_LAST_F2F3_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_last_f2f3_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_last_f2f3(d);
}
#endif

#if defined(XED_OPERAND_LAST_F2F3_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_last_f2f3_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_last_f2f3(d, opval);
}
#endif

#if defined(XED_OPERAND_ILD_F2_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_ild_f2_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_ild_f2(d);
}
#endif

#if defined(XED_OPERAND_ILD_F2_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_ild_f2_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_ild_f2(d, opval);
}
#endif

#if defined(XED_OPERAND_ILD_F3_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_ild_f3_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_ild_f3(d);
}
#endif

#if defined(XED_OPERAND_ILD_F3_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_ild_f3_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_ild_f3(d, opval);
}
#endif

#if defined(XED_OPERAND_MAX_BYTES_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_max_bytes_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_max_bytes(d);
}
#endif

#if defined(XED_OPERAND_MAX_BYTES_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_max_bytes_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_max_bytes(d, opval);
}
#endif

#if defined(XED_OPERAND_ILD_SEG_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_ild_seg_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_ild_seg(d);
}
#endif

#if defined(XED_OPERAND_ILD_SEG_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_ild_seg_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_ild_seg(d, opval);
}
#endif

#if defined(XED_OPERAND_NSEG_PREFIXES_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_nseg_prefixes_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_nseg_prefixes(d);
}
#endif

#if defined(XED_OPERAND_NSEG_PREFIXES_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_nseg_prefixes_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_nseg_prefixes(d, opval);
}
#endif

#if defined(XED_OPERAND_NREXES_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_nrexes_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_nrexes(d);
}
#endif

#if defined(XED_OPERAND_NREXES_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_nrexes_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_nrexes(d, opval);
}
#endif

#if defined(XED_OPERAND_NPREFIXES_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_nprefixes_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_nprefixes(d);
}
#endif

#if defined(XED_OPERAND_NPREFIXES_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_nprefixes_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_nprefixes(d, opval);
}
#endif

#if defined(XED_OPERAND_NOMINAL_OPCODE_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_nominal_opcode_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_nominal_opcode(d);
}
#endif

#if defined(XED_OPERAND_NOMINAL_OPCODE_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_nominal_opcode_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_nominal_opcode(d, opval);
}
#endif

#if defined(XED_OPERAND_POS_NOMINAL_OPCODE_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_pos_nominal_opcode_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_pos_nominal_opcode(d);
}
#endif

#if defined(XED_OPERAND_POS_NOMINAL_OPCODE_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_pos_nominal_opcode_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_pos_nominal_opcode(d, opval);
}
#endif

#if defined(XED_OPERAND_HAS_MODRM_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_has_modrm_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_has_modrm(d);
}
#endif

#if defined(XED_OPERAND_HAS_MODRM_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_has_modrm_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_has_modrm(d, opval);
}
#endif

#if defined(XED_OPERAND_HAS_SIB_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_has_sib_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_has_sib(d);
}
#endif

#if defined(XED_OPERAND_HAS_SIB_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_has_sib_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_has_sib(d, opval);
}
#endif

#if defined(XED_OPERAND_POS_MODRM_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_pos_modrm_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_pos_modrm(d);
}
#endif

#if defined(XED_OPERAND_POS_MODRM_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_pos_modrm_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_pos_modrm(d, opval);
}
#endif

#if defined(XED_OPERAND_POS_SIB_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_pos_sib_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_pos_sib(d);
}
#endif

#if defined(XED_OPERAND_POS_SIB_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_pos_sib_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_pos_sib(d, opval);
}
#endif

#if defined(XED_OPERAND_POS_DISP_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_pos_disp_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_pos_disp(d);
}
#endif

#if defined(XED_OPERAND_POS_DISP_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_pos_disp_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_pos_disp(d, opval);
}
#endif

#if defined(XED_OPERAND_POS_IMM_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_pos_imm_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_pos_imm(d);
}
#endif

#if defined(XED_OPERAND_POS_IMM_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_pos_imm_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_pos_imm(d, opval);
}
#endif

#if defined(XED_OPERAND_POS_IMM1_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_pos_imm1_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_pos_imm1(d);
}
#endif

#if defined(XED_OPERAND_POS_IMM1_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_pos_imm1_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_pos_imm1(d, opval);
}
#endif

#if defined(XED_OPERAND_IMM1_BYTES_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_imm1_bytes_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_imm1_bytes(d);
}
#endif

#if defined(XED_OPERAND_IMM1_BYTES_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_imm1_bytes_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_imm1_bytes(d, opval);
}
#endif

#if defined(XED_OPERAND_MODRM_BYTE_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_modrm_byte_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_modrm_byte(d);
}
#endif

#if defined(XED_OPERAND_MODRM_BYTE_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_modrm_byte_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_modrm_byte(d, opval);
}
#endif

#if defined(XED_OPERAND_ESRC_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_esrc_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_esrc(d);
}
#endif

#if defined(XED_OPERAND_ESRC_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_esrc_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_esrc(d, opval);
}
#endif

#if defined(XED_OPERAND_VEXVALID_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_vexvalid_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_vexvalid(d);
}
#endif

#if defined(XED_OPERAND_VEXVALID_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_vexvalid_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_vexvalid(d, opval);
}
#endif

#if defined(XED_OPERAND_DUMMY_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_dummy_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_dummy(d);
}
#endif

#if defined(XED_OPERAND_DUMMY_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_dummy_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_dummy(d, opval);
}
#endif

#if defined(XED_OPERAND_NO_EVEX_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_no_evex_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_no_evex(d);
}
#endif

#if defined(XED_OPERAND_NO_EVEX_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_no_evex_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_no_evex(d, opval);
}
#endif

#if defined(XED_OPERAND_NO_VEX_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_no_vex_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_no_vex(d);
}
#endif

#if defined(XED_OPERAND_NO_VEX_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_no_vex_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_no_vex(d, opval);
}
#endif

#if defined(XED_OPERAND_NO_APX_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_no_apx_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_no_apx(d);
}
#endif

#if defined(XED_OPERAND_NO_APX_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_no_apx_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_no_apx(d, opval);
}
#endif

#if defined(XED_OPERAND_AMD3DNOW_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_amd3dnow_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_amd3dnow(d);
}
#endif

#if defined(XED_OPERAND_AMD3DNOW_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_amd3dnow_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_amd3dnow(d, opval);
}
#endif

#if defined(XED_OPERAND_MPXMODE_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_mpxmode_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_mpxmode(d);
}
#endif

#if defined(XED_OPERAND_MPXMODE_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_mpxmode_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_mpxmode(d, opval);
}
#endif

#if defined(XED_OPERAND_CET_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_cet_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_cet(d);
}
#endif

#if defined(XED_OPERAND_CET_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_cet_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_cet(d, opval);
}
#endif

#if defined(XED_OPERAND_CLDEMOTE_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_cldemote_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_cldemote(d);
}
#endif

#if defined(XED_OPERAND_CLDEMOTE_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_cldemote_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_cldemote(d, opval);
}
#endif

#if defined(XED_OPERAND_VEXDEST3_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_vexdest3_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_vexdest3(d);
}
#endif

#if defined(XED_OPERAND_VEXDEST3_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_vexdest3_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_vexdest3(d, opval);
}
#endif

#if defined(XED_OPERAND_VEXDEST210_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_vexdest210_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_vexdest210(d);
}
#endif

#if defined(XED_OPERAND_VEXDEST210_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_vexdest210_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_vexdest210(d, opval);
}
#endif

#if defined(XED_OPERAND_VL_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_vl_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_vl(d);
}
#endif

#if defined(XED_OPERAND_VL_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_vl_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_vl(d, opval);
}
#endif

#if defined(XED_OPERAND_VEX_PREFIX_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_vex_prefix_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_vex_prefix(d);
}
#endif

#if defined(XED_OPERAND_VEX_PREFIX_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_vex_prefix_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_vex_prefix(d, opval);
}
#endif

#if defined(XED_OPERAND_VEX_C4_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_vex_c4_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_vex_c4(d);
}
#endif

#if defined(XED_OPERAND_VEX_C4_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_vex_c4_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_vex_c4(d, opval);
}
#endif

#if defined(XED_OPERAND_BCAST_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_bcast_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_bcast(d);
}
#endif

#if defined(XED_OPERAND_BCAST_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_bcast_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_bcast(d, opval);
}
#endif

#if defined(XED_OPERAND_MUST_USE_EVEX_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_must_use_evex_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_must_use_evex(d);
}
#endif

#if defined(XED_OPERAND_MUST_USE_EVEX_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_must_use_evex_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_must_use_evex(d, opval);
}
#endif

#if defined(XED_OPERAND_ZEROING_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_zeroing_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_zeroing(d);
}
#endif

#if defined(XED_OPERAND_ZEROING_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_zeroing_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_zeroing(d, opval);
}
#endif

#if defined(XED_OPERAND_LLRC_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_llrc_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_llrc(d);
}
#endif

#if defined(XED_OPERAND_LLRC_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_llrc_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_llrc(d, opval);
}
#endif

#if defined(XED_OPERAND_BCRC_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_bcrc_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_bcrc(d);
}
#endif

#if defined(XED_OPERAND_BCRC_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_bcrc_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_bcrc(d, opval);
}
#endif

#if defined(XED_OPERAND_VEXDEST4_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_vexdest4_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_vexdest4(d);
}
#endif

#if defined(XED_OPERAND_VEXDEST4_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_vexdest4_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_vexdest4(d, opval);
}
#endif

#if defined(XED_OPERAND_MASK_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_mask_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_mask(d);
}
#endif

#if defined(XED_OPERAND_MASK_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_mask_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_mask(d, opval);
}
#endif

#if defined(XED_OPERAND_ROUNDC_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_roundc_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_roundc(d);
}
#endif

#if defined(XED_OPERAND_ROUNDC_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_roundc_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_roundc(d, opval);
}
#endif

#if defined(XED_OPERAND_SAE_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_sae_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_sae(d);
}
#endif

#if defined(XED_OPERAND_SAE_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_sae_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_sae(d, opval);
}
#endif

#if defined(XED_OPERAND_VL_IGN_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_vl_ign_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_vl_ign(d);
}
#endif

#if defined(XED_OPERAND_VL_IGN_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_vl_ign_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_vl_ign(d, opval);
}
#endif

#if defined(XED_OPERAND_UBIT_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_ubit_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_ubit(d);
}
#endif

#if defined(XED_OPERAND_UBIT_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_ubit_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_ubit(d, opval);
}
#endif

#if defined(XED_OPERAND_WBNOINVD_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_wbnoinvd_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_wbnoinvd(d);
}
#endif

#if defined(XED_OPERAND_WBNOINVD_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_wbnoinvd_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_wbnoinvd(d, opval);
}
#endif

#if defined(XED_OPERAND_EVVSPACE_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_evvspace_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_evvspace(d);
}
#endif

#if defined(XED_OPERAND_EVVSPACE_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_evvspace_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_evvspace(d, opval);
}
#endif

#if defined(XED_OPERAND_ND_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_nd_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_nd(d);
}
#endif

#if defined(XED_OPERAND_ND_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_nd_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_nd(d, opval);
}
#endif

#if defined(XED_OPERAND_NF_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_nf_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_nf(d);
}
#endif

#if defined(XED_OPERAND_NF_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_nf_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_nf(d, opval);
}
#endif

#if defined(XED_OPERAND_SCC_DEFINED)
XED_DLL_EXPORT xed_bits_t xed3_operand_get_scc_py(const xed_decoded_inst_t* d) {
    return xed3_operand_get_scc(d);
}
#endif

#if defined(XED_OPERAND_SCC_DEFINED)
XED_DLL_EXPORT void xed3_operand_set_scc_py(xed_decoded_inst_t* d, xed_bits_t opval) {
    xed3_operand_set_scc(d, opval);
}
#endif

#if defined(XED_OPERAND_XED3_GET_GENERIC_OPERAND_DEFINED)
XED_DLL_EXPORT void xed3_get_generic_operand_py(const xed_decoded_inst_t* d, xed_operand_enum_t operand, void* ret_arg) {
    xed3_get_generic_operand(d, operand, ret_arg);
}
#endif

#if defined(XED_OPERAND_XED3_SET_GENERIC_OPERAND_DEFINED)
XED_DLL_EXPORT void xed3_set_generic_operand_py(xed_decoded_inst_t* d, xed_operand_enum_t operand, xed_uint32_t val) {
    xed3_set_generic_operand(d, operand, val);
}
#endif

//////////////////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-operand-action-enum.h */
//////////////////////////////////////////////////////////////////////////////////
#include "xed-operand-action-enum.h"
XED_DLL_EXPORT xed_operand_action_enum_t str2xed_operand_action_enum_t_py(const char* s) {
    return str2xed_operand_action_enum_t(s);
}

XED_DLL_EXPORT const char* xed_operand_action_enum_t2str_py(const xed_operand_action_enum_t p) {
    return xed_operand_action_enum_t2str(p);
}

XED_DLL_EXPORT xed_operand_action_enum_t xed_operand_action_enum_t_last_py(void) {
    return xed_operand_action_enum_t_last();
}

/////////////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-operand-action.h */
/////////////////////////////////////////////////////////////////////////////
#include "xed-operand-action.h"
XED_DLL_EXPORT xed_uint_t xed_operand_action_read_py(const xed_operand_action_enum_t rw) {
    return xed_operand_action_read(rw);
}

XED_DLL_EXPORT xed_uint_t xed_operand_action_read_only_py(const xed_operand_action_enum_t rw) {
    return xed_operand_action_read_only(rw);
}

XED_DLL_EXPORT xed_uint_t xed_operand_action_written_py(const xed_operand_action_enum_t rw) {
    return xed_operand_action_written(rw);
}

XED_DLL_EXPORT xed_uint_t xed_operand_action_written_only_py(const xed_operand_action_enum_t rw) {
    return xed_operand_action_written_only(rw);
}

XED_DLL_EXPORT xed_uint_t xed_operand_action_read_and_written_py(const xed_operand_action_enum_t rw) {
    return xed_operand_action_read_and_written(rw);
}

XED_DLL_EXPORT xed_uint_t xed_operand_action_conditional_read_py(const xed_operand_action_enum_t rw) {
    return xed_operand_action_conditional_read(rw);
}

XED_DLL_EXPORT xed_uint_t xed_operand_action_conditional_write_py(const xed_operand_action_enum_t rw) {
    return xed_operand_action_conditional_write(rw);
}

///////////////////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-operand-convert-enum.h */
///////////////////////////////////////////////////////////////////////////////////
#include "xed-operand-convert-enum.h"
XED_DLL_EXPORT xed_operand_convert_enum_t str2xed_operand_convert_enum_t_py(const char* s) {
    return str2xed_operand_convert_enum_t(s);
}

XED_DLL_EXPORT const char* xed_operand_convert_enum_t2str_py(const xed_operand_convert_enum_t p) {
    return xed_operand_convert_enum_t2str(p);
}

XED_DLL_EXPORT xed_operand_convert_enum_t xed_operand_convert_enum_t_last_py(void) {
    return xed_operand_convert_enum_t_last();
}

/////////////////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-operand-ctype-enum.h */
/////////////////////////////////////////////////////////////////////////////////
#include "xed-operand-ctype-enum.h"
XED_DLL_EXPORT xed_operand_ctype_enum_t str2xed_operand_ctype_enum_t_py(const char* s) {
    return str2xed_operand_ctype_enum_t(s);
}

XED_DLL_EXPORT const char* xed_operand_ctype_enum_t2str_py(const xed_operand_ctype_enum_t p) {
    return xed_operand_ctype_enum_t2str(p);
}

XED_DLL_EXPORT xed_operand_ctype_enum_t xed_operand_ctype_enum_t_last_py(void) {
    return xed_operand_ctype_enum_t_last();
}

////////////////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-operand-ctype-map.h */
////////////////////////////////////////////////////////////////////////////////
#include "xed-operand-ctype-map.h"
XED_DLL_EXPORT xed_operand_ctype_enum_t xed_operand_get_ctype_py(xed_operand_enum_t opname) {
    return xed_operand_get_ctype(opname);
}

XED_DLL_EXPORT unsigned int xed_operand_decider_get_width_py(xed_operand_enum_t opname) {
    return xed_operand_decider_get_width(opname);
}

////////////////////////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-operand-element-type-enum.h */
////////////////////////////////////////////////////////////////////////////////////////
#include "xed-operand-element-type-enum.h"
XED_DLL_EXPORT xed_operand_element_type_enum_t str2xed_operand_element_type_enum_t_py(const char* s) {
    return str2xed_operand_element_type_enum_t(s);
}

XED_DLL_EXPORT const char* xed_operand_element_type_enum_t2str_py(const xed_operand_element_type_enum_t p) {
    return xed_operand_element_type_enum_t2str(p);
}

XED_DLL_EXPORT xed_operand_element_type_enum_t xed_operand_element_type_enum_t_last_py(void) {
    return xed_operand_element_type_enum_t_last();
}

/////////////////////////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-operand-element-xtype-enum.h */
/////////////////////////////////////////////////////////////////////////////////////////
#include "xed-operand-element-xtype-enum.h"
XED_DLL_EXPORT xed_operand_element_xtype_enum_t str2xed_operand_element_xtype_enum_t_py(const char* s) {
    return str2xed_operand_element_xtype_enum_t(s);
}

XED_DLL_EXPORT const char* xed_operand_element_xtype_enum_t2str_py(const xed_operand_element_xtype_enum_t p) {
    return xed_operand_element_xtype_enum_t2str(p);
}

XED_DLL_EXPORT xed_operand_element_xtype_enum_t xed_operand_element_xtype_enum_t_last_py(void) {
    return xed_operand_element_xtype_enum_t_last();
}

///////////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-operand-enum.h */
///////////////////////////////////////////////////////////////////////////
#include "xed-operand-enum.h"
XED_DLL_EXPORT xed_operand_enum_t str2xed_operand_enum_t_py(const char* s) {
    return str2xed_operand_enum_t(s);
}

XED_DLL_EXPORT const char* xed_operand_enum_t2str_py(const xed_operand_enum_t p) {
    return xed_operand_enum_t2str(p);
}

XED_DLL_EXPORT xed_operand_enum_t xed_operand_enum_t_last_py(void) {
    return xed_operand_enum_t_last();
}

////////////////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-operand-type-enum.h */
////////////////////////////////////////////////////////////////////////////////
#include "xed-operand-type-enum.h"
XED_DLL_EXPORT xed_operand_type_enum_t str2xed_operand_type_enum_t_py(const char* s) {
    return str2xed_operand_type_enum_t(s);
}

XED_DLL_EXPORT const char* xed_operand_type_enum_t2str_py(const xed_operand_type_enum_t p) {
    return xed_operand_type_enum_t2str(p);
}

XED_DLL_EXPORT xed_operand_type_enum_t xed_operand_type_enum_t_last_py(void) {
    return xed_operand_type_enum_t_last();
}

///////////////////////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-operand-values-interface.h */
///////////////////////////////////////////////////////////////////////////////////////
#include "xed-operand-values-interface.h"
XED_DLL_EXPORT void xed_operand_values_init_py(xed_operand_values_t* p) {
    xed_operand_values_init(p);
}

XED_DLL_EXPORT void xed_operand_values_init_set_mode_py(xed_operand_values_t* p,
                                                     const xed_state_t* dstate) {
    xed_operand_values_init_set_mode(p, dstate);
}

XED_DLL_EXPORT void xed_operand_values_set_mode_py(xed_operand_values_t* p,
                            const xed_state_t* dstate) {
    xed_operand_values_set_mode(p, dstate);
}

XED_DLL_EXPORT void xed_operand_values_init_keep_mode_py(xed_operand_values_t* dst,
                                   const xed_operand_values_t* src) {
    xed_operand_values_init_keep_mode(dst, src);
}

XED_DLL_EXPORT void xed_operand_values_dump_py(const xed_operand_values_t* ov,
                        char* buf,
                        int buflen) {
    xed_operand_values_dump(ov, buf, buflen);
}

XED_DLL_EXPORT void xed_operand_values_print_short_py(const xed_operand_values_t* ov,
                               char* buf,
                               int buflen) {
    xed_operand_values_print_short(ov, buf, buflen);
}

XED_DLL_EXPORT xed_bool_t xed_operand_values_has_real_rep_py(const xed_operand_values_t* p) {
    return xed_operand_values_has_real_rep(p);
}

XED_DLL_EXPORT xed_bool_t xed_operand_values_has_rep_prefix_py(const xed_operand_values_t* p) {
    return xed_operand_values_has_rep_prefix(p);
}

XED_DLL_EXPORT xed_bool_t xed_operand_values_has_repne_prefix_py(const xed_operand_values_t* p) {
    return xed_operand_values_has_repne_prefix(p);
}

XED_DLL_EXPORT void xed_operand_values_clear_rep_py(xed_operand_values_t* p) {
    xed_operand_values_clear_rep(p);
}

XED_DLL_EXPORT xed_bool_t xed_operand_values_get_atomic_py(const xed_operand_values_t* p) {
    return xed_operand_values_get_atomic(p);
}

XED_DLL_EXPORT xed_bool_t xed_operand_values_has_lock_prefix_py(const xed_operand_values_t* p) {
    return xed_operand_values_has_lock_prefix(p);
}

XED_DLL_EXPORT xed_bool_t xed_operand_values_lockable_py(const xed_operand_values_t* p) {
    return xed_operand_values_lockable(p);
}

XED_DLL_EXPORT xed_bool_t xed_operand_values_using_default_segment_py(const xed_operand_values_t* p,
                                         unsigned int i) {
    return xed_operand_values_using_default_segment(p, i);
}

XED_DLL_EXPORT xed_uint32_t xed_operand_values_get_effective_operand_width_py(const xed_operand_values_t* p) {
    return xed_operand_values_get_effective_operand_width(p);
}

XED_DLL_EXPORT xed_uint32_t xed_operand_values_get_effective_address_width_py(const xed_operand_values_t* p) {
    return xed_operand_values_get_effective_address_width(p);
}

XED_DLL_EXPORT xed_uint32_t xed_operand_values_get_stack_address_width_py(const xed_operand_values_t* p) {
    return xed_operand_values_get_stack_address_width(p);
}

XED_DLL_EXPORT xed_bool_t xed_operand_values_has_memory_displacement_py(const xed_operand_values_t* p) {
    return xed_operand_values_has_memory_displacement(p);
}

XED_DLL_EXPORT xed_bool_t xed_operand_values_has_branch_displacement_py(const xed_operand_values_t* p) {
    return xed_operand_values_has_branch_displacement(p);
}

XED_DLL_EXPORT xed_bool_t xed_operand_values_has_displacement_py(const xed_operand_values_t* p) {
    return xed_operand_values_has_displacement(p);
}

XED_DLL_EXPORT xed_bool_t xed_operand_values_get_displacement_for_memop_py(const xed_operand_values_t* p) {
    return xed_operand_values_get_displacement_for_memop(p);
}

XED_DLL_EXPORT xed_bool_t xed_operand_values_has_immediate_py(const xed_operand_values_t* p) {
    return xed_operand_values_has_immediate(p);
}

XED_DLL_EXPORT xed_bool_t xed_operand_values_has_address_size_prefix_py(const xed_operand_values_t* p) {
    return xed_operand_values_has_address_size_prefix(p);
}

XED_DLL_EXPORT xed_bool_t xed_operand_values_has_operand_size_prefix_py(const xed_operand_values_t* p) {
    return xed_operand_values_has_operand_size_prefix(p);
}

XED_DLL_EXPORT xed_bool_t xed_operand_values_has_66_prefix_py(const xed_operand_values_t* p) {
    return xed_operand_values_has_66_prefix(p);
}

XED_DLL_EXPORT xed_bool_t xed_operand_values_mandatory_66_prefix_py(const xed_operand_values_t* p) {
    return xed_operand_values_mandatory_66_prefix(p);
}

XED_DLL_EXPORT xed_bool_t xed_operand_values_has_rexw_prefix_py(const xed_operand_values_t* p) {
    return xed_operand_values_has_rexw_prefix(p);
}

XED_DLL_EXPORT xed_bool_t xed_operand_values_has_segment_prefix_py(const xed_operand_values_t* p) {
    return xed_operand_values_has_segment_prefix(p);
}

XED_DLL_EXPORT xed_reg_enum_t xed_operand_values_segment_prefix_py(const xed_operand_values_t* p) {
    return xed_operand_values_segment_prefix(p);
}

XED_DLL_EXPORT xed_bool_t xed_operand_values_get_long_mode_py(const xed_operand_values_t* p) {
    return xed_operand_values_get_long_mode(p);
}

XED_DLL_EXPORT xed_bool_t xed_operand_values_get_real_mode_py(const xed_operand_values_t* p) {
    return xed_operand_values_get_real_mode(p);
}

XED_DLL_EXPORT xed_bits_t xed_operand_values_get_pp_vex_prefix_py(const xed_operand_values_t* p) {
    return xed_operand_values_get_pp_vex_prefix(p);
}

XED_DLL_EXPORT xed_bool_t xed_operand_values_accesses_memory_py(const xed_operand_values_t* p) {
    return xed_operand_values_accesses_memory(p);
}

XED_DLL_EXPORT unsigned int xed_operand_values_number_of_memory_operands_py(const xed_operand_values_t* p) {
    return xed_operand_values_number_of_memory_operands(p);
}

XED_DLL_EXPORT unsigned int xed_operand_values_get_memory_operand_length_py(const xed_operand_values_t* p,
                                             unsigned int memop_idx) {
    return xed_operand_values_get_memory_operand_length(p, memop_idx);
}

XED_DLL_EXPORT xed_reg_enum_t xed_operand_values_get_base_reg_py(const xed_operand_values_t* p,
                                unsigned int memop_idx) {
    return xed_operand_values_get_base_reg(p, memop_idx);
}

XED_DLL_EXPORT xed_reg_enum_t xed_operand_values_get_index_reg_py(const xed_operand_values_t* p,
                                 unsigned int memop_idx) {
    return xed_operand_values_get_index_reg(p, memop_idx);
}

XED_DLL_EXPORT xed_reg_enum_t xed_operand_values_get_seg_reg_py(const xed_operand_values_t* p,
                               unsigned int memop_idx) {
    return xed_operand_values_get_seg_reg(p, memop_idx);
}

XED_DLL_EXPORT unsigned int xed_operand_values_get_scale_py(const xed_operand_values_t* p) {
    return xed_operand_values_get_scale(p);
}

XED_DLL_EXPORT xed_bool_t xed_operand_values_memop_without_modrm_py(const xed_operand_values_t* p) {
    return xed_operand_values_memop_without_modrm(p);
}

XED_DLL_EXPORT xed_bool_t xed_operand_values_has_modrm_byte_py(const xed_operand_values_t* p) {
    return xed_operand_values_has_modrm_byte(p);
}

XED_DLL_EXPORT xed_bool_t xed_operand_values_has_sib_byte_py(const xed_operand_values_t* p) {
    return xed_operand_values_has_sib_byte(p);
}

XED_DLL_EXPORT xed_bool_t xed_operand_values_branch_not_taken_hint_py(const xed_operand_values_t* p) {
    return xed_operand_values_branch_not_taken_hint(p);
}

XED_DLL_EXPORT xed_bool_t xed_operand_values_branch_taken_hint_py(const xed_operand_values_t* p) {
    return xed_operand_values_branch_taken_hint(p);
}

XED_DLL_EXPORT xed_bool_t xed_operand_values_ignored_branch_not_taken_hint_py(const xed_operand_values_t* p) {
    return xed_operand_values_ignored_branch_not_taken_hint(p);
}

XED_DLL_EXPORT xed_bool_t xed_operand_values_ignored_branch_taken_hint_py(const xed_operand_values_t* p) {
    return xed_operand_values_ignored_branch_taken_hint(p);
}

XED_DLL_EXPORT xed_bool_t xed_operand_values_cet_no_track_py(const xed_operand_values_t* p) {
    return xed_operand_values_cet_no_track(p);
}

XED_DLL_EXPORT xed_bool_t xed_operand_values_is_nop_py(const xed_operand_values_t* p) {
    return xed_operand_values_is_nop(p);
}

XED_DLL_EXPORT xed_int64_t xed_operand_values_get_immediate_int64_py(const xed_operand_values_t* p) {
    return xed_operand_values_get_immediate_int64(p);
}

XED_DLL_EXPORT xed_uint64_t xed_operand_values_get_immediate_uint64_py(const xed_operand_values_t* p) {
    return xed_operand_values_get_immediate_uint64(p);
}

XED_DLL_EXPORT xed_uint_t xed_operand_values_get_immediate_is_signed_py(const xed_operand_values_t* p) {
    return xed_operand_values_get_immediate_is_signed(p);
}

XED_DLL_EXPORT xed_uint8_t xed_operand_values_get_immediate_byte_py(const xed_operand_values_t* p,
                                      unsigned int i) {
    return xed_operand_values_get_immediate_byte(p, i);
}

XED_DLL_EXPORT xed_uint8_t xed_operand_values_get_second_immediate_py(const xed_operand_values_t* p) {
    return xed_operand_values_get_second_immediate(p);
}

XED_DLL_EXPORT xed_uint32_t xed_operand_values_get_memory_displacement_length_py(const xed_operand_values_t* p) {
    return xed_operand_values_get_memory_displacement_length(p);
}

XED_DLL_EXPORT xed_uint32_t xed_operand_values_get_memory_displacement_length_bits_py(const xed_operand_values_t* p) {
    return xed_operand_values_get_memory_displacement_length_bits(p);
}

XED_DLL_EXPORT xed_uint32_t xed_operand_values_get_memory_displacement_length_bits_raw_py(const xed_operand_values_t* p) {
    return xed_operand_values_get_memory_displacement_length_bits_raw(p);
}

XED_DLL_EXPORT xed_int64_t xed_operand_values_get_memory_displacement_int64_py(const xed_operand_values_t* p) {
    return xed_operand_values_get_memory_displacement_int64(p);
}

XED_DLL_EXPORT xed_int64_t xed_operand_values_get_memory_displacement_int64_raw_py(const xed_operand_values_t* p) {
    return xed_operand_values_get_memory_displacement_int64_raw(p);
}

XED_DLL_EXPORT xed_uint8_t xed_operand_values_get_memory_displacement_byte_py(const xed_operand_values_t* p,
                                                unsigned int i) {
    return xed_operand_values_get_memory_displacement_byte(p, i);
}

XED_DLL_EXPORT xed_uint32_t xed_operand_values_get_branch_displacement_length_py(const xed_operand_values_t* p) {
    return xed_operand_values_get_branch_displacement_length(p);
}

XED_DLL_EXPORT xed_uint32_t xed_operand_values_get_branch_displacement_length_bits_py(const xed_operand_values_t* p) {
    return xed_operand_values_get_branch_displacement_length_bits(p);
}

XED_DLL_EXPORT xed_int64_t xed_operand_values_get_branch_displacement_int64_py(const xed_operand_values_t* p) {
    return xed_operand_values_get_branch_displacement_int64(p);
}

XED_DLL_EXPORT xed_uint8_t xed_operand_values_get_branch_displacement_byte_py(const xed_operand_values_t* p,
                                                unsigned int i) {
    return xed_operand_values_get_branch_displacement_byte(p, i);
}

XED_DLL_EXPORT xed_iclass_enum_t xed_operand_values_get_iclass_py(const xed_operand_values_t* p) {
    return xed_operand_values_get_iclass(p);
}

XED_DLL_EXPORT void xed_operand_values_zero_immediate_py(xed_operand_values_t* p) {
    xed_operand_values_zero_immediate(p);
}

XED_DLL_EXPORT void xed_operand_values_zero_branch_displacement_py(xed_operand_values_t* p) {
    xed_operand_values_zero_branch_displacement(p);
}

XED_DLL_EXPORT void xed_operand_values_zero_memory_displacement_py(xed_operand_values_t* p) {
    xed_operand_values_zero_memory_displacement(p);
}

XED_DLL_EXPORT void xed_operand_values_set_lock_py(xed_operand_values_t* p) {
    xed_operand_values_set_lock(p);
}

XED_DLL_EXPORT void xed_operand_values_zero_segment_override_py(xed_operand_values_t* p) {
    xed_operand_values_zero_segment_override(p);
}

XED_DLL_EXPORT void xed_operand_values_set_iclass_py(xed_operand_values_t* p,
                              xed_iclass_enum_t iclass) {
    xed_operand_values_set_iclass(p, iclass);
}

XED_DLL_EXPORT void xed_operand_values_set_effective_operand_width_py(xed_operand_values_t* p,
                                               unsigned int width) {
    xed_operand_values_set_effective_operand_width(p, width);
}

XED_DLL_EXPORT void xed_operand_values_set_effective_address_width_py(xed_operand_values_t* p,
                                               unsigned int width) {
    xed_operand_values_set_effective_address_width(p, width);
}

XED_DLL_EXPORT void xed_operand_values_set_memory_operand_length_py(xed_operand_values_t* p,
                                             unsigned int memop_length) {
    xed_operand_values_set_memory_operand_length(p, memop_length);
}

XED_DLL_EXPORT void xed_operand_values_set_memory_displacement_py(xed_operand_values_t* p,
                                           xed_int64_t x, unsigned int len) {
    xed_operand_values_set_memory_displacement(p, x, len);
}

XED_DLL_EXPORT void xed_operand_values_set_memory_displacement_bits_py(xed_operand_values_t* p,
                                                xed_int64_t x,
                                                unsigned int len_bits) {
    xed_operand_values_set_memory_displacement_bits(p, x, len_bits);
}

XED_DLL_EXPORT void xed_operand_values_set_relbr_py(xed_operand_values_t* p) {
    xed_operand_values_set_relbr(p);
}

XED_DLL_EXPORT void xed_operand_values_set_absbr_py(xed_operand_values_t* p) {
    xed_operand_values_set_absbr(p);
}

XED_DLL_EXPORT void xed_operand_values_set_branch_displacement_py(xed_operand_values_t* p,
                                           xed_int64_t x,
                                           unsigned int len) {
    xed_operand_values_set_branch_displacement(p, x, len);
}

XED_DLL_EXPORT void xed_operand_values_set_branch_displacement_bits_py(xed_operand_values_t* p,
                                                xed_int64_t x,
                                                unsigned int len_bits) {
    xed_operand_values_set_branch_displacement_bits(p, x, len_bits);
}

XED_DLL_EXPORT void xed_operand_values_set_immediate_signed_py(xed_operand_values_t* p,
                                        xed_int32_t x,
                                        unsigned int bytes) {
    xed_operand_values_set_immediate_signed(p, x, bytes);
}

XED_DLL_EXPORT void xed_operand_values_set_immediate_signed_bits_py(xed_operand_values_t* p,
                                             xed_int32_t x,
                                             unsigned int bits) {
    xed_operand_values_set_immediate_signed_bits(p, x, bits);
}

XED_DLL_EXPORT void xed_operand_values_set_immediate_unsigned_py(xed_operand_values_t* p,
                                          xed_uint64_t x,
                                          unsigned int bytes) {
    xed_operand_values_set_immediate_unsigned(p, x, bytes);
}

XED_DLL_EXPORT void xed_operand_values_set_immediate_unsigned_bits_py(xed_operand_values_t* p,
                                               xed_uint64_t x,
                                               unsigned int bits) {
    xed_operand_values_set_immediate_unsigned_bits(p, x, bits);
}

XED_DLL_EXPORT void xed_operand_values_set_base_reg_py(xed_operand_values_t* p,
                                                    unsigned int memop_idx,
                                                    xed_reg_enum_t new_base) {
    xed_operand_values_set_base_reg(p, memop_idx, new_base);
}

XED_DLL_EXPORT void xed_operand_values_set_seg_reg_py(xed_operand_values_t* p,
                                                   unsigned int memop_idx,
                                                   xed_reg_enum_t new_seg) {
    xed_operand_values_set_seg_reg(p, memop_idx, new_seg);
}

XED_DLL_EXPORT void xed_operand_values_set_index_reg_py(xed_operand_values_t* p,
                                                     unsigned int memop_idx,
                                                     xed_reg_enum_t new_index) {
    xed_operand_values_set_index_reg(p, memop_idx, new_index);
}

XED_DLL_EXPORT void xed_operand_values_set_scale_py(xed_operand_values_t* p, 
                                                 xed_uint_t memop_idx,
                                                 xed_uint_t new_scale) {
    xed_operand_values_set_scale(p, memop_idx, new_scale);
}

XED_DLL_EXPORT void xed_operand_values_set_operand_reg_py(xed_operand_values_t* p,
                                   xed_operand_enum_t operand_name,
                                   xed_reg_enum_t reg_name) {
    xed_operand_values_set_operand_reg(p, operand_name, reg_name);
}

//////////////////////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-operand-visibility-enum.h */
//////////////////////////////////////////////////////////////////////////////////////
#include "xed-operand-visibility-enum.h"
XED_DLL_EXPORT xed_operand_visibility_enum_t str2xed_operand_visibility_enum_t_py(const char* s) {
    return str2xed_operand_visibility_enum_t(s);
}

XED_DLL_EXPORT const char* xed_operand_visibility_enum_t2str_py(const xed_operand_visibility_enum_t p) {
    return xed_operand_visibility_enum_t2str(p);
}

XED_DLL_EXPORT xed_operand_visibility_enum_t xed_operand_visibility_enum_t_last_py(void) {
    return xed_operand_visibility_enum_t_last();
}

/////////////////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-operand-width-enum.h */
/////////////////////////////////////////////////////////////////////////////////
#include "xed-operand-width-enum.h"
XED_DLL_EXPORT xed_operand_width_enum_t str2xed_operand_width_enum_t_py(const char* s) {
    return str2xed_operand_width_enum_t(s);
}

XED_DLL_EXPORT const char* xed_operand_width_enum_t2str_py(const xed_operand_width_enum_t p) {
    return xed_operand_width_enum_t2str(p);
}

XED_DLL_EXPORT xed_operand_width_enum_t xed_operand_width_enum_t_last_py(void) {
    return xed_operand_width_enum_t_last();
}

////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-patch.h */
////////////////////////////////////////////////////////////////////
#include "xed-patch.h"
XED_DLL_EXPORT xed_bool_t xed_patch_disp_py(xed_decoded_inst_t* xedd,
               xed_uint8_t* itext,
               xed_enc_displacement_t disp) {
    return xed_patch_disp(xedd, itext, disp);
}

XED_DLL_EXPORT xed_bool_t xed_patch_brdisp_py(xed_decoded_inst_t* xedd,
                xed_uint8_t* itext,
                xed_encoder_operand_t disp) {
    return xed_patch_brdisp(xedd, itext, disp);
}

XED_DLL_EXPORT xed_bool_t xed_patch_imm0_py(xed_decoded_inst_t* xedd,
               xed_uint8_t* itext,
               xed_encoder_operand_t imm0) {
    return xed_patch_imm0(xedd, itext, imm0);
}

/////////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-print-info.h */
/////////////////////////////////////////////////////////////////////////
#include "xed-print-info.h"
XED_DLL_EXPORT void xed_init_print_info_py(xed_print_info_t* pi) {
    xed_init_print_info(pi);
}

/////////////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-reg-class-enum.h */
/////////////////////////////////////////////////////////////////////////////
#include "xed-reg-class-enum.h"
XED_DLL_EXPORT xed_reg_class_enum_t str2xed_reg_class_enum_t_py(const char* s) {
    return str2xed_reg_class_enum_t(s);
}

XED_DLL_EXPORT const char* xed_reg_class_enum_t2str_py(const xed_reg_class_enum_t p) {
    return xed_reg_class_enum_t2str(p);
}

XED_DLL_EXPORT xed_reg_class_enum_t xed_reg_class_enum_t_last_py(void) {
    return xed_reg_class_enum_t_last();
}

////////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-reg-class.h */
////////////////////////////////////////////////////////////////////////
#include "xed-reg-class.h"
XED_DLL_EXPORT xed_reg_class_enum_t xed_reg_class_py(xed_reg_enum_t r) {
    return xed_reg_class(r);
}

XED_DLL_EXPORT xed_reg_class_enum_t xed_gpr_reg_class_py(xed_reg_enum_t r) {
    return xed_gpr_reg_class(r);
}

XED_DLL_EXPORT xed_reg_enum_t xed_get_largest_enclosing_register_py(xed_reg_enum_t r) {
    return xed_get_largest_enclosing_register(r);
}

XED_DLL_EXPORT xed_reg_enum_t xed_get_largest_enclosing_register32_py(xed_reg_enum_t r) {
    return xed_get_largest_enclosing_register32(r);
}

XED_DLL_EXPORT xed_uint32_t xed_get_register_width_bits_py(xed_reg_enum_t r) {
    return xed_get_register_width_bits(r);
}

XED_DLL_EXPORT xed_uint32_t xed_get_register_width_bits64_py(xed_reg_enum_t r) {
    return xed_get_register_width_bits64(r);
}

///////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-reg-enum.h */
///////////////////////////////////////////////////////////////////////
#include "xed-reg-enum.h"
XED_DLL_EXPORT xed_reg_enum_t str2xed_reg_enum_t_py(const char* s) {
    return str2xed_reg_enum_t(s);
}

XED_DLL_EXPORT const char* xed_reg_enum_t2str_py(const xed_reg_enum_t p) {
    return xed_reg_enum_t2str(p);
}

XED_DLL_EXPORT xed_reg_enum_t xed_reg_enum_t_last_py(void) {
    return xed_reg_enum_t_last();
}

////////////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-reg-role-enum.h */
////////////////////////////////////////////////////////////////////////////
#include "xed-reg-role-enum.h"
XED_DLL_EXPORT xed_reg_role_enum_t str2xed_reg_role_enum_t_py(const char* s) {
    return str2xed_reg_role_enum_t(s);
}

XED_DLL_EXPORT const char* xed_reg_role_enum_t2str_py(const xed_reg_role_enum_t p) {
    return xed_reg_role_enum_t2str(p);
}

XED_DLL_EXPORT xed_reg_role_enum_t xed_reg_role_enum_t_last_py(void) {
    return xed_reg_role_enum_t_last();
}

/////////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-rep-prefix.h */
/////////////////////////////////////////////////////////////////////////
#include "xed-rep-prefix.h"
XED_DLL_EXPORT xed_iclass_enum_t xed_rep_remove_py(xed_iclass_enum_t x) {
    return xed_rep_remove(x);
}

XED_DLL_EXPORT xed_iclass_enum_t xed_repe_map_py(xed_iclass_enum_t iclass) {
    return xed_repe_map(iclass);
}

XED_DLL_EXPORT xed_iclass_enum_t xed_repne_map_py(xed_iclass_enum_t iclass) {
    return xed_repne_map(iclass);
}

XED_DLL_EXPORT xed_iclass_enum_t xed_rep_map_py(xed_iclass_enum_t iclass) {
    return xed_rep_map(iclass);
}

XED_DLL_EXPORT xed_iclass_enum_t xed_norep_map_py(xed_iclass_enum_t iclass) {
    return xed_norep_map(iclass);
}

////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-state.h */
////////////////////////////////////////////////////////////////////
#include "xed-state.h"
XED_DLL_EXPORT void xed_state_init_py(xed_state_t* p,
                                      xed_machine_mode_enum_t arg_mmode,
                                      xed_address_width_enum_t arg_ignored,
                                      xed_address_width_enum_t arg_stack_addr_width) {
    xed_state_init(p, arg_mmode, arg_ignored, arg_stack_addr_width);
}

XED_DLL_EXPORT void xed_state_init2_py(xed_state_t* p,
                                      xed_machine_mode_enum_t arg_mmode,
                                      xed_address_width_enum_t arg_stack_addr_width) {
    xed_state_init2(p, arg_mmode, arg_stack_addr_width);
}

XED_DLL_EXPORT void xed_state_zero_py(xed_state_t* p) {
    xed_state_zero(p);
}

XED_DLL_EXPORT xed_machine_mode_enum_t xed_state_get_machine_mode_py(const xed_state_t* p) {
    return xed_state_get_machine_mode(p);
}

XED_DLL_EXPORT xed_bool_t xed_state_long64_mode_py(const xed_state_t* p) {
    return xed_state_long64_mode(p);
}

XED_DLL_EXPORT xed_bool_t xed_state_mode_width_16_py(const xed_state_t* p) {
    return xed_state_mode_width_16(p);
}

XED_DLL_EXPORT xed_bool_t xed_state_mode_width_32_py(const xed_state_t* p) {
    return xed_state_mode_width_32(p);
}

XED_DLL_EXPORT void xed_state_set_machine_mode_py(xed_state_t* p,
                        xed_machine_mode_enum_t arg_mode) {
    xed_state_set_machine_mode(p, arg_mode);
}

XED_DLL_EXPORT xed_address_width_enum_t xed_state_get_address_width_py(const xed_state_t* p) {
    return xed_state_get_address_width(p);
}

XED_DLL_EXPORT void xed_state_set_stack_address_width_py(xed_state_t* p,
                                  xed_address_width_enum_t arg_addr_width) {
    xed_state_set_stack_address_width(p, arg_addr_width);
}

XED_DLL_EXPORT xed_address_width_enum_t xed_state_get_stack_address_width_py(const xed_state_t* p) {
    return xed_state_get_stack_address_width(p);
}

XED_DLL_EXPORT int xed_state_print_py(const xed_state_t* p, char* buf, int buflen) {
    return xed_state_print(p, buf, buflen);
}

//////////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-syntax-enum.h */
//////////////////////////////////////////////////////////////////////////
#include "xed-syntax-enum.h"
XED_DLL_EXPORT xed_syntax_enum_t str2xed_syntax_enum_t_py(const char* s) {
    return str2xed_syntax_enum_t(s);
}

XED_DLL_EXPORT const char* xed_syntax_enum_t2str_py(const xed_syntax_enum_t p) {
    return xed_syntax_enum_t2str(p);
}

XED_DLL_EXPORT xed_syntax_enum_t xed_syntax_enum_t_last_py(void) {
    return xed_syntax_enum_t_last();
}

//////////////////////////////////////////////////////////////////////
/* Export inlined function from: obj\wkit\include\xed\xed-version.h */
//////////////////////////////////////////////////////////////////////
#include "xed-version.h"
XED_DLL_EXPORT char const* xed_get_version_py(void) {
    return xed_get_version();
}

XED_DLL_EXPORT char const* xed_get_copyright_py(void) {
    return xed_get_copyright();
}

