# HELICS Publications

## Citing HELICS

T. Hardy, B. Palmintier, P. Top, D. Krishnamurthy and J. Fuller, "HELICS: A Co-Simulation Framework for Scalable Multi-Domain Modeling and Analysis," in IEEE Access, doi: 10.1109/ACCESS.2024.3363615, available at [https://ieeexplore.ieee.org/document/10424422](https://ieeexplore.ieee.org/document/10424422)

## Co-Simulation Architecture and Theory with HELICS

B. Palmintier, D. Krishnamurthy, P. Top, S. Smith, J. Daily and J. Fuller, "Design of the HELICS high-performance transmission-distribution-communication-market co-simulation framework", Proc. Workshop Model. Simul. Cyber-Physical Energy Syst. (MSCPES), pp. 1-6, Apr. 2017, available at: [https://ieeexplore.ieee.org/document/8064542/](https://ieeexplore.ieee.org/document/8064542/).

Juan Gilberto Rueda Vasquez. COMPARISON BETWEEN TWO CO-SIMULATION FRAMEWORKS, MOSAIK AND HELICS. Rel. Lorenzo Bottaccioli, Edoardo Patti, Claudia De Vizia. Politecnico di Torino, Corso di laurea magistrale in Ict For Smart Societies (Ict Per La Società Del Futuro), 2022, available at [https://webthesis.biblio.polito.it/25624/](https://webthesis.biblio.polito.it/25624/)

P. Palensky, P. Mancarella, T. Hardy and M. Cvetkovic, "Cosimulating Integrated Energy Systems With Heterogeneous Digital Twins: Matching a Connected World," in IEEE Power and Energy Magazine, vol. 22, no. 1, pp. 52-60, Jan.-Feb. 2024, doi: 10.1109/MPE.2023.3324886, available at [https://ieeexplore.ieee.org/document/10398554](https://ieeexplore.ieee.org/document/10398554).

Barbierato, L., Rando Mazzarino, P., Montarolo, M. et al. A comparison study of co-simulation frameworks for multi-energy systems: the scalability problem. Energy Inform 5 (Suppl 4), 53 (2022). doi: 10.1186/s42162-022-00231-6, available at [https://energyinformatics.springeropen.com/articles/10.1186/s42162-022-00231-6](https://energyinformatics.springeropen.com/articles/10.1186/s42162-022-00231-6).

A. Latif, B. Palmintier, F. Nejabatkhah and P. Jacques, "Multi-federate co-convergence with HELICS," 2024 IEEE Power & Energy Society Innovative Smart Grid Technologies Conference (ISGT), Washington, DC, USA, 2024, pp. 1-5, doi: 10.1109/ISGT59692.2024.10454238, available at [https://ieeexplore.ieee.org/document/10454238](https://ieeexplore.ieee.org/document/10454238)

## HELICS Application papers

The following are a list of some of the published work using HELICS. If you have published work using HELICS you would like to see on this list, email support@helics.org with the citation and we'll review it.

J. R. Theisen, A. Bose, M. Mukherjee, D. Burgess, K. Wilhelm and M. Diedesch, "Community-Based Transactive Coordination Mechanism for Enabling Grid-Edge Systems," 2024 IEEE Texas Power and Energy Conference (TPEC), College Station, TX, USA, 2024, pp. 1-6, doi: 10.1109/TPEC60005.2024.10472237, available at [https://ieeexplore.ieee.org/document/10472237](https://ieeexplore.ieee.org/document/10472237).

A. K. Bharati, V. Ajjarapu, W. Du and Y. Liu, "Role of Distributed Inverter-Based-Resources in Bulk Grid Primary Frequency Response Through HELICS Based SMTD Co-Simulation," in IEEE Systems Journal, vol. 17, no. 1, pp. 1071-1082, March 2023, doi: 10.1109/JSYST.2022.3218117 available at [https://ieeexplore.ieee.org/document/9966492](https://ieeexplore.ieee.org/document/9966492).

Y. Liu, R. Huang, W. Du, A. Singhal and Z. Huang, "Highly-Scalable Transmission and Distribution Dynamic Co-Simulation With 10,000+ Grid-Following and Grid-Forming Inverters," in IEEE Transactions on Power Delivery, vol. 39, no. 1, pp. 578-590, Feb. 2024, doi: 10.1109/TPWRD.2023.3302303, available at [https://ieeexplore.ieee.org/abstract/document/10210125](https://ieeexplore.ieee.org/abstract/document/10210125).

Panossian, N.V.; Laarabi, H.; Moffat, K.; Chang, H.; Palmintier, B.; Meintz, A.; Lipman, T.E.; Waraich, R.A. Architecture for Co-Simulation of Transportation and Distribution Systems with Electric Vehicle Charging at Scale in the San Francisco Bay Area. Energies 2023, 16, 2189. doi: 10.3390/en16052189, available at [https://www.mdpi.com/1996-1073/16/5/2189](https://www.mdpi.com/1996-1073/16/5/2189).

T. Phillips, L. D. Marinovici, C. Rieger and A. Orrell, "Scalable Resilience Analysis Through Power Systems Co-Simulation," in IEEE Access, vol. 11, pp. 18205-18214, 2023, doi: 10.1109/ACCESS.2023.3246486, available at [https://ieeexplore.ieee.org/document/10050105](https://ieeexplore.ieee.org/document/10050105).

William Lardier, "ASGARDS-H: Enabling Advanced Smart Grid cyber-physical Attacks, Risk and Data Studies with HELICS". Masters thesis at Concordia University, 2020, available at [https://spectrum.library.concordia.ca/id/eprint/987690/](https://spectrum.library.concordia.ca/id/eprint/987690/).

Y. Liu, R. Huang, W. Du, A. Singhal and Z. Huang, "High-Performance Transmission and Distribution Co-simulation with 10,000+ Inverter-Based Resources," 2022 IEEE Industry Applications Society Annual Meeting (IAS), Detroit, MI, USA, 2022, pp. 1-5, doi: 10.1109/IAS54023.2022.9940149, available at [https://ieeexplore.ieee.org/document/9940149](https://ieeexplore.ieee.org/document/9940149).

Narayanan, Anantha, and Hardy, Trevor. "Synthetic Data Generation for Machine Learning Model Training for Energy Theft Scenarios Ssing Cosimulation". United Kingdom: N. p., 2022. Web. doi:10.1049/gtd2.12619, available at [https://ietresearch.onlinelibrary.wiley.com/doi/10.1049/gtd2.12619](https://ietresearch.onlinelibrary.wiley.com/doi/10.1049/gtd2.12619).

Jing Wang, Prateek Munankarmi, Jeff Maguire, Chengnan Shi, Wangda Zuo, David Roberts, Xin Jin. "Carbon emission responsive building control: A case study with an all-electric residential community in a cold climate". Applied Energy, Volume 314,2022, 118910,
doi: 10.1016/j.apenergy.2022.118910, available at [https://www.sciencedirect.com/science/article/pii/S0306261922003336](https://www.sciencedirect.com/science/article/pii/S0306261922003336).

A. Singhal, T. L. Vu and W. Du, "Consensus Control for Coordinating Grid-Forming and Grid-Following Inverters in Microgrids," in IEEE Transactions on Smart Grid, vol. 13, no. 5, pp. 4123-4133, Sept. 2022, doi: 10.1109/TSG.2022.3158254, available at [https://ieeexplore.ieee.org/document/9732444](https://ieeexplore.ieee.org/document/9732444).

N. Gray, R. Sadnan, A. Bose and A. Dubey, "Effects of Communication Network Topology on Distributed Optimal Power Flow for Radial Distribution Networks," 2021 North American Power Symposium (NAPS), College Station, TX, USA, 2021, pp. 1-6, doi: 10.1109/NAPS52732.2021.9654692, available at [https://ieeexplore.ieee.org/document/9654692](https://ieeexplore.ieee.org/document/9654692).

A. O. Abbas and B. H. Chowdhury, "A Stochastic Optimization Framework for Realizing Combined Value Streams From Customer-Side Resources," in IEEE Transactions on Smart Grid, vol. 13, no. 2, pp. 1139-1150, March 2022, doi: 10.1109/TSG.2021.3135155, available at [https://ieeexplore.ieee.org/document/9650528](https://ieeexplore.ieee.org/document/9650528).

J. Wang, J. Simpson, R. Yang, B. Palmintier, S. Tiwari and Y. Zhang, "Performance Evaluation of an Advanced Distributed Energy Resource Management Algorithm," 2021 IEEE International Conference on Communications, Control, and Computing Technologies for Smart Grids (SmartGridComm), Aachen, Germany, 2021, pp. 378-384, doi: 10.1109/SmartGridComm51999.2021.9632298, available at [https://ieeexplore.ieee.org/document/9632298](https://ieeexplore.ieee.org/document/9632298).

H. M. Mustafa et al., "Cyber-Power Co-Simulation for End-to-End Synchrophasor Network Analysis and Applications," 2021 IEEE International Conference on Communications, Control, and Computing Technologies for Smart Grids (SmartGridComm), Aachen, Germany, 2021, pp. 164-169, doi: 10.1109/SmartGridComm51999.2021.9632286, available at [https://ieeexplore.ieee.org/document/9632286](https://ieeexplore.ieee.org/document/9632286).

Tuffner, Francis K., Undrill, John, Scoffield, Don, Eto, Joseph H., Kosterev, Dmitry, and Quint, Ryan D. 2021. "Distribution-Level Impacts of Plug-in Electric Vehicle Charging on the Transmission System during Fault Conditions". United States. doi: 10.2172/1832905, avialble at [https://www.osti.gov/servlets/purl/1832905](https://www.osti.gov/servlets/purl/1832905).

M. Mukherjee, T. Hardy, J. Fuller and A. Bose, "Transactive Implementation of Decentralized Electricity Market for Grid-Edge Systems," 2021 IEEE Power & Energy Society General Meeting (PESGM), Washington, DC, USA, 2021, pp. 1-5, doi: 10.1109/PESGM46819.2021.9638098, available at [https://ieeexplore.ieee.org/document/9638098](https://ieeexplore.ieee.org/document/9638098).

Monish Mukherjee, Trevor Hardy, Jason C. Fuller, Anjan Bose. "Implementing Multi-Settlement Decentralized Electricity Market Design for Transactive Communities with Imperfect Communication. Applied Energy, Volume 306, Part A, 2022, 117979, doi: 10.1016/j.apenergy.2021.117979. [https://www.sciencedirect.com/science/article/pii/S0306261921012824](https://www.sciencedirect.com/science/article/pii/S0306261921012824).

Michael Blonsky, Jeff Maguire, Killian McKenna, Dylan Cutler, Sivasathya Pradha Balamurugan, Xin Jin. "OCHRE: The Object-oriented, Controllable, High-resolution Residential Energy Model for Dynamic Integration Studies". Applied Energy, Volume 290, 2021,116732, doi: 10.1016/j.apenergy.2021.116732, available at [https://www.sciencedirect.com/science/article/pii/S0306261921002464](https://www.sciencedirect.com/science/article/pii/S030626192100246).

Prateek Munankarmi, Jeff Maguire, Sivasathya Pradha Balamurugan, Michael Blonsky, David Roberts, Xin Jin. "Community-scale interaction of energy efficiency and demand flexibility in residential buildings". Applied Energy, Volume 298, 2021, 117149, doi: 10.1016/j.apenergy.2021.117149, available at [https://www.sciencedirect.com/science/article/pii/S0306261921005754](https://www.sciencedirect.com/science/article/pii/S0306261921005754).

N. Duan, N. Yee, B. Salazar, J. -Y. Joo, E. Stewart and E. Cortez, "Cybersecurity Analysis of Distribution Grid Operation with Distributed Energy Resources via Co-Simulation," 2020 IEEE Power & Energy Society General Meeting (PESGM), Montreal, QC, Canada, 2020, pp. 1-5, doi: 10.1109/PESGM41954.2020.9281757, available at [https://ieeexplore.ieee.org/document/9281757](https://ieeexplore.ieee.org/document/9281757).

W. Wang, X. Fang and A. Florita, "Impact of DER Communication Delay in AGC: Cyber-Physical Dynamic Co-simulation," 2021 IEEE 48th Photovoltaic Specialists Conference (PVSC), Fort Lauderdale, FL, USA, 2021, pp. 2616-2620, doi: 10.1109/PVSC43889.2021.9518779, available at [https://ieeexplore.ieee.org/document/9518779](https://ieeexplore.ieee.org/document/9518779).

N. Panossian, T. Elgindy, B. Palmintier and D. Wallison, "Synthetic, Realistic Transmission and Distribution Co-Simulation for Voltage Control Benchmarking," 2021 IEEE Texas Power and Energy Conference (TPEC), College Station, TX, USA, 2021, pp. 1-5, doi: 10.1109/TPEC51183.2021.9384935, available at [https://ieeexplore.ieee.org/document/9384935](https://ieeexplore.ieee.org/document/9384935)

A. K. Bharati and V. Ajjarapu, "A Scalable Multi-Timescale T&D Co-Simulation Framework using HELICS," 2021 IEEE Texas Power and Energy Conference (TPEC), College Station, TX, USA, 2021, pp. 1-6, doi: 10.1109/TPEC51183.2021.9384985, available at [https://ieeexplore.ieee.org/document/9384985](https://ieeexplore.ieee.org/document/9384985).

N. Duan, C. Huang, C. -C. Sun and L. Min, "Smart Meters Enabling Voltage Monitoring and Control: The Last-Mile Voltage Stability Issue," in IEEE Transactions on Industrial Informatics, vol. 18, no. 1, pp. 677-687, Jan. 2022, doi: 10.1109/TII.2021.3062628, available at [https://ieeexplore.ieee.org/document/9366429](https://ieeexplore.ieee.org/document/9366429).

Dylan Cutler, Ted Kwasnik, Sivasathya Balamurugan, Tarek Elgindy, Siddharth Swaminathan, Jeff Maguire, Dane Christensen. "Co-Simulation of Transactive Energy Markets: A Framework for Market Testing and Evaluation". International Journal of Electrical Power & Energy Systems,Volume 128, 2021, 106664, doi: 10.1016/j.ijepes.2020.106664, available at [https://www.sciencedirect.com/science/article/pii/S014206152034209](https://www.sciencedirect.com/science/article/pii/S0142061520342095).

J. Zhang et al., "Development of HELICS-based High-Performance Cyber-Physical Co-simulation Framework for Distributed Energy Resources Applications," 2020 IEEE International Conference on Communications, Control, and Computing Technologies for Smart Grids (SmartGridComm), Tempe, AZ, USA, 2020, pp. 1-5, doi: 10.1109/SmartGridComm47815.2020.9302977, available at [https://ieeexplore.ieee.org/abstract/document/9302977](https://ieeexplore.ieee.org/abstract/document/9302977).

Bhattarai B.P., L.D. Marinovici, M. Touhiduzzaman, F.K. Tuffner, K.P. Schneider, J. Xie, and P. Thekkumparambath Mana, et al. "Studying impacts of communication system performance on dynamic stability of networked microgrid". IET Smart Grid 3, no. 5:667 - 676, 2020, doi:10.1049/iet-stg.2019.0303, available at [https://ietresearch.onlinelibrary.wiley.com/doi/10.1049/iet-stg.2019.0303](https://ietresearch.onlinelibrary.wiley.com/doi/10.1049/iet-stg.2019.0303).
