// Copyright 2023 gRPC authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This file is autogenerated: see
// tools/codegen/core/gen_huffman_decompressor.cc

#ifndef GRPC_TEST_CPP_MICROBENCHMARKS_HUFFMAN_GEOMETRIES_DECODE_HUFF_7_16_7_H
#define GRPC_TEST_CPP_MICROBENCHMARKS_HUFFMAN_GEOMETRIES_DECODE_HUFF_7_16_7_H
#include <cstddef>
#include <cstdint>

#include <grpc/support/port_platform.h>
namespace grpc_core {
namespace geometry_7_16_7 {
class HuffDecoderCommon {
 protected:
  static inline uint64_t GetOp2(size_t i) { return table2_0_ops_[i]; }
  static inline uint64_t GetEmit2(size_t, size_t emit) {
    return table2_0_emit_[emit];
  }
  static inline uint64_t GetOp3(size_t i) { return table3_0_ops_[i]; }
  static inline uint64_t GetEmit3(size_t, size_t emit) {
    return table3_0_emit_[emit];
  }
  static inline uint64_t GetOp1(size_t i) {
    return table1_0_inner_[table1_0_outer_[i]];
  }
  static inline uint64_t GetEmit1(size_t, size_t emit) {
    return table1_0_emit_[emit];
  }
  static inline uint64_t GetOp4(size_t i) { return i ? 3 : 1; }
  static inline uint64_t GetEmit4(size_t, size_t emit) {
    return emit ? 42 : 38;
  }
  static inline uint64_t GetOp5(size_t i) { return i ? 3 : 1; }
  static inline uint64_t GetEmit5(size_t, size_t emit) {
    return emit ? 59 : 44;
  }
  static inline uint64_t GetOp6(size_t i) { return i ? 3 : 1; }
  static inline uint64_t GetEmit6(size_t, size_t emit) {
    return emit ? 90 : 88;
  }
  static inline uint64_t GetOp8(size_t i) {
    return table8_0_inner_[(i < 6 ? (i) : ((i - 6) + 5))];
  }
  static inline uint64_t GetEmit8(size_t, size_t emit) {
    return table8_0_emit_[emit];
  }
  static inline uint64_t GetOp9(size_t i) {
    return table9_0_inner_[table9_0_outer_[i]];
  }
  static inline uint64_t GetEmit9(size_t, size_t emit) {
    return table9_0_emit_[emit];
  }
  static inline uint64_t GetOp10(size_t i) { return table10_0_ops_[i]; }
  static inline uint64_t GetEmit10(size_t, size_t emit) {
    return table10_0_emit_[emit];
  }
  static inline uint64_t GetOp11(size_t i) { return table11_0_ops_[i]; }
  static inline uint64_t GetEmit11(size_t, size_t emit) {
    return table11_0_emit_[emit];
  }
  static inline uint64_t GetOp12(size_t i) { return table12_0_ops_[i]; }
  static inline uint64_t GetEmit12(size_t, size_t emit) {
    return table12_0_emit_[emit];
  }
  static inline uint64_t GetOp13(size_t i) {
    return table13_ops_[i >> 6][i & 0x3f];
  }
  static inline uint64_t GetEmit13(size_t i, size_t emit) {
    return table13_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp14(size_t i) {
    return table14_ops_[i >> 6][i & 0x3f];
  }
  static inline uint64_t GetEmit14(size_t i, size_t emit) {
    return table14_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp15(size_t i) {
    return table15_ops_[i >> 6][i & 0x3f];
  }
  static inline uint64_t GetEmit15(size_t i, size_t emit) {
    return table15_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp16(size_t i) {
    return table16_ops_[i >> 6][i & 0x3f];
  }
  static inline uint64_t GetEmit16(size_t i, size_t emit) {
    return table16_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp17(size_t i) {
    return table17_ops_[i >> 7][i & 0x7f];
  }
  static inline uint64_t GetEmit17(size_t i, size_t emit) {
    return table17_emit_[i >> 7][emit];
  }
  static inline uint64_t GetOp18(size_t i) {
    return table18_ops_[i >> 6][i & 0x3f];
  }
  static inline uint64_t GetEmit18(size_t i, size_t emit) {
    return table18_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp19(size_t i) {
    return table19_inner_[i >> 7][table19_outer_[i >> 7][i & 0x7f]];
  }
  static inline uint64_t GetEmit19(size_t i, size_t emit) {
    return table19_emit_[i >> 7][emit];
  }
  static inline uint64_t GetOp20(size_t i) {
    return table20_ops_[i >> 7][i & 0x7f];
  }
  static inline uint64_t GetEmit20(size_t i, size_t emit) {
    return table20_emit_[i >> 7][emit];
  }
  static inline uint64_t GetOp7(size_t i) {
    return table7_ops_[i >> 9][i & 0x1ff];
  }
  static inline uint64_t GetEmit7(size_t i, size_t emit) {
    return table7_emit_[i >> 9][emit];
  }
  static inline uint64_t GetOp21(size_t i) { return i ? 3 : 1; }
  static inline uint64_t GetEmit21(size_t, size_t emit) {
    return emit ? 142 : 9;
  }
  static inline uint64_t GetOp22(size_t i) { return i ? 3 : 1; }
  static inline uint64_t GetEmit22(size_t, size_t emit) { return emit + 144; }
  static inline uint64_t GetOp23(size_t i) { return i ? 3 : 1; }
  static inline uint64_t GetEmit23(size_t, size_t emit) {
    return emit ? 159 : 148;
  }
  static inline uint64_t GetOp24(size_t i) { return i ? 3 : 1; }
  static inline uint64_t GetEmit24(size_t, size_t emit) {
    return emit ? 206 : 171;
  }
  static inline uint64_t GetOp25(size_t i) { return i ? 3 : 1; }
  static inline uint64_t GetEmit25(size_t, size_t emit) {
    return emit ? 225 : 215;
  }
  static inline uint64_t GetOp26(size_t i) { return i ? 3 : 1; }
  static inline uint64_t GetEmit26(size_t, size_t emit) { return emit + 236; }
  static inline uint64_t GetOp27(size_t i) {
    return (i < 2 ? (i ? 6 : 2) : ((i - 2) ? 14 : 10));
  }
  static inline uint64_t GetEmit27(size_t, size_t emit) {
    return (emit < 2 ? (emit ? 207 : 199) : ((emit - 2) + 234));
  }
  static inline uint64_t GetOp28(size_t i) { return table28_0_inner_[i]; }
  static inline uint64_t GetEmit28(size_t, size_t emit) {
    return table28_0_emit_[emit];
  }
  static inline uint64_t GetOp29(size_t i) { return table29_0_inner_[i]; }
  static inline uint64_t GetEmit29(size_t, size_t emit) {
    return table29_0_emit_[emit];
  }
  static inline uint64_t GetOp31(size_t i) {
    return (i < 1 ? (((void)i, 0)) : ((i - 1) / 14 + 1));
  }
  static inline uint64_t GetEmit31(size_t, size_t emit) {
    return ((void)emit, 254);
  }
  static inline uint64_t GetOp32(size_t i) { return table32_0_ops_[i]; }
  static inline uint64_t GetEmit32(size_t, size_t emit) {
    return table32_0_emit_[emit];
  }
  static inline uint64_t GetOp33(size_t i) { return table33_0_ops_[i]; }
  static inline uint64_t GetEmit33(size_t, size_t emit) {
    return table32_0_emit_[emit];
  }
  static inline uint64_t GetOp30(size_t i) {
    return table30_ops_[i >> 5][i & 0x1f];
  }
  static inline uint64_t GetEmit30(size_t i, size_t emit) {
    return table30_emit_[i >> 5][emit];
  }
  static inline uint64_t GetOp35(size_t i) { return table35_0_inner_[i]; }
  static inline uint64_t GetEmit35(size_t, size_t emit) {
    return table35_0_emit_[emit];
  }
  static inline uint64_t GetOp34(size_t i) {
    return table34_0_inner_[(i < 13 ? (i / 2 + 0) : ((i - 13) + 6))];
  }
  static inline uint64_t GetEmit34(size_t, size_t emit) {
    return table34_0_emit_[emit];
  }

 private:
  static const uint8_t table2_0_emit_[10];
  static const uint8_t table2_0_ops_[32];
  static const uint8_t table3_0_emit_[36];
  static const uint8_t table3_0_ops_[64];
  static const uint8_t table1_0_emit_[68];
  static const uint16_t table1_0_inner_[72];
  static const uint8_t table1_0_outer_[128];
  static const uint8_t table8_0_emit_[5];
  static const uint8_t table8_0_inner_[7];
  static const uint8_t table9_0_emit_[8];
  static const uint8_t table9_0_inner_[10];
  static const uint8_t table9_0_outer_[16];
  static const uint8_t table10_0_emit_[10];
  static const uint8_t table10_0_ops_[32];
  static const uint8_t table11_0_emit_[16];
  static const uint8_t table11_0_ops_[64];
  static const uint8_t table12_0_emit_[18];
  static const uint8_t table12_0_ops_[128];
  static const uint8_t table13_0_emit_[40];
  static const uint8_t table13_0_ops_[64];
  static const uint8_t table13_1_emit_[40];
  static const uint8_t table13_2_emit_[22];
  static const uint8_t table13_2_ops_[64];
  static const uint8_t table13_3_emit_[14];
  static const uint8_t table13_3_ops_[64];
  static const uint8_t* const table13_emit_[4];
  static const uint8_t* const table13_ops_[4];
  static const uint8_t table14_0_emit_[72];
  static const uint16_t table14_0_ops_[64];
  static const uint8_t table14_1_emit_[72];
  static const uint8_t table14_2_emit_[72];
  static const uint8_t table14_3_emit_[72];
  static const uint8_t table14_4_emit_[72];
  static const uint8_t table14_5_emit_[40];
  static const uint16_t table14_5_ops_[64];
  static const uint8_t table14_6_emit_[22];
  static const uint16_t table14_6_ops_[64];
  static const uint8_t table14_7_emit_[11];
  static const uint16_t table14_7_ops_[64];
  static const uint8_t* const table14_emit_[8];
  static const uint16_t* const table14_ops_[8];
  static const uint8_t table15_0_emit_[44];
  static const uint16_t table15_0_ops_[64];
  static const uint8_t table15_1_emit_[92];
  static const uint16_t table15_1_ops_[64];
  static const uint8_t table15_2_emit_[44];
  static const uint8_t table15_3_emit_[92];
  static const uint8_t table15_4_emit_[44];
  static const uint8_t table15_5_emit_[92];
  static const uint8_t table15_6_emit_[44];
  static const uint8_t table15_7_emit_[92];
  static const uint8_t table15_8_emit_[44];
  static const uint8_t table15_9_emit_[92];
  static const uint8_t table15_10_emit_[72];
  static const uint8_t table15_11_emit_[72];
  static const uint8_t table15_12_emit_[72];
  static const uint8_t table15_13_emit_[40];
  static const uint8_t table15_14_emit_[4];
  static const uint16_t table15_14_ops_[64];
  static const uint8_t table15_15_emit_[7];
  static const uint16_t table15_15_ops_[64];
  static const uint8_t* const table15_emit_[16];
  static const uint16_t* const table15_ops_[16];
  static const uint8_t table16_0_emit_[16];
  static const uint16_t table16_0_ops_[64];
  static const uint8_t table16_1_emit_[28];
  static const uint16_t table16_1_ops_[64];
  static const uint8_t table16_2_emit_[36];
  static const uint16_t table16_2_ops_[64];
  static const uint8_t table16_3_emit_[68];
  static const uint16_t table16_3_ops_[64];
  static const uint8_t table16_4_emit_[16];
  static const uint8_t table16_5_emit_[28];
  static const uint8_t table16_6_emit_[36];
  static const uint8_t table16_7_emit_[68];
  static const uint8_t table16_8_emit_[16];
  static const uint8_t table16_9_emit_[28];
  static const uint8_t table16_10_emit_[36];
  static const uint8_t table16_11_emit_[68];
  static const uint8_t table16_12_emit_[16];
  static const uint8_t table16_13_emit_[28];
  static const uint8_t table16_14_emit_[36];
  static const uint8_t table16_15_emit_[68];
  static const uint8_t table16_16_emit_[16];
  static const uint8_t table16_17_emit_[28];
  static const uint8_t table16_18_emit_[36];
  static const uint8_t table16_19_emit_[68];
  static const uint8_t table16_20_emit_[44];
  static const uint8_t table16_21_emit_[92];
  static const uint8_t table16_22_emit_[44];
  static const uint8_t table16_23_emit_[92];
  static const uint8_t table16_24_emit_[44];
  static const uint8_t table16_25_emit_[92];
  static const uint8_t table16_26_emit_[72];
  static const uint8_t table16_27_emit_[72];
  static const uint8_t table16_28_emit_[40];
  static const uint8_t table16_29_emit_[40];
  static const uint8_t table16_30_emit_[40];
  static const uint8_t table16_31_emit_[5];
  static const uint16_t table16_31_ops_[64];
  static const uint8_t* const table16_emit_[32];
  static const uint16_t* const table16_ops_[32];
  static const uint16_t table17_0_ops_[128];
  static const uint16_t table17_1_ops_[128];
  static const uint16_t table17_2_ops_[128];
  static const uint16_t table17_3_ops_[128];
  static const uint16_t table17_20_ops_[128];
  static const uint8_t table17_21_emit_[104];
  static const uint16_t table17_21_ops_[128];
  static const uint8_t table17_23_emit_[104];
  static const uint8_t table17_25_emit_[104];
  static const uint8_t table17_26_emit_[136];
  static const uint16_t table17_26_ops_[128];
  static const uint8_t table17_27_emit_[136];
  static const uint8_t table17_28_emit_[144];
  static const uint16_t table17_28_ops_[128];
  static const uint8_t table17_29_emit_[144];
  static const uint8_t table17_30_emit_[144];
  static const uint8_t table17_31_emit_[46];
  static const uint16_t table17_31_ops_[128];
  static const uint8_t* const table17_emit_[32];
  static const uint16_t* const table17_ops_[32];
  static const uint8_t table18_0_emit_[60];
  static const uint16_t table18_0_ops_[64];
  static const uint8_t table18_1_emit_[60];
  static const uint8_t table18_2_emit_[60];
  static const uint8_t table18_3_emit_[60];
  static const uint8_t table18_4_emit_[60];
  static const uint8_t table18_5_emit_[8];
  static const uint16_t table18_5_ops_[64];
  static const uint8_t table18_6_emit_[8];
  static const uint8_t table18_7_emit_[8];
  static const uint8_t table18_8_emit_[8];
  static const uint8_t table18_9_emit_[8];
  static const uint8_t table18_10_emit_[8];
  static const uint8_t table18_11_emit_[12];
  static const uint16_t table18_11_ops_[64];
  static const uint8_t table18_12_emit_[16];
  static const uint16_t table18_12_ops_[64];
  static const uint8_t table18_13_emit_[16];
  static const uint8_t table18_14_emit_[16];
  static const uint8_t table18_15_emit_[29];
  static const uint16_t table18_15_ops_[64];
  static const uint8_t table18_16_emit_[60];
  static const uint8_t table18_17_emit_[60];
  static const uint8_t table18_18_emit_[60];
  static const uint8_t table18_19_emit_[60];
  static const uint8_t table18_20_emit_[60];
  static const uint8_t table18_21_emit_[8];
  static const uint8_t table18_22_emit_[8];
  static const uint8_t table18_23_emit_[8];
  static const uint8_t table18_24_emit_[8];
  static const uint8_t table18_25_emit_[8];
  static const uint8_t table18_26_emit_[8];
  static const uint8_t table18_27_emit_[12];
  static const uint8_t table18_28_emit_[16];
  static const uint8_t table18_29_emit_[16];
  static const uint8_t table18_30_emit_[16];
  static const uint8_t table18_31_emit_[29];
  static const uint16_t table18_31_ops_[64];
  static const uint8_t table18_32_emit_[60];
  static const uint8_t table18_33_emit_[60];
  static const uint8_t table18_34_emit_[60];
  static const uint8_t table18_35_emit_[60];
  static const uint8_t table18_36_emit_[60];
  static const uint8_t table18_37_emit_[8];
  static const uint8_t table18_38_emit_[8];
  static const uint8_t table18_39_emit_[8];
  static const uint8_t table18_40_emit_[8];
  static const uint8_t table18_41_emit_[8];
  static const uint8_t table18_42_emit_[8];
  static const uint8_t table18_43_emit_[12];
  static const uint8_t table18_44_emit_[16];
  static const uint8_t table18_45_emit_[16];
  static const uint8_t table18_46_emit_[16];
  static const uint8_t table18_47_emit_[29];
  static const uint16_t table18_47_ops_[64];
  static const uint8_t table18_48_emit_[60];
  static const uint8_t table18_49_emit_[60];
  static const uint8_t table18_50_emit_[60];
  static const uint8_t table18_51_emit_[60];
  static const uint8_t table18_52_emit_[60];
  static const uint8_t table18_53_emit_[8];
  static const uint8_t table18_54_emit_[8];
  static const uint8_t table18_55_emit_[8];
  static const uint8_t table18_56_emit_[8];
  static const uint8_t table18_57_emit_[8];
  static const uint8_t table18_58_emit_[8];
  static const uint8_t table18_59_emit_[12];
  static const uint8_t table18_60_emit_[16];
  static const uint8_t table18_61_emit_[16];
  static const uint8_t table18_62_emit_[16];
  static const uint8_t table18_63_emit_[29];
  static const uint16_t table18_63_ops_[64];
  static const uint8_t table18_64_emit_[60];
  static const uint8_t table18_65_emit_[60];
  static const uint8_t table18_66_emit_[60];
  static const uint8_t table18_67_emit_[60];
  static const uint8_t table18_68_emit_[60];
  static const uint8_t table18_69_emit_[8];
  static const uint8_t table18_70_emit_[8];
  static const uint8_t table18_71_emit_[8];
  static const uint8_t table18_72_emit_[8];
  static const uint8_t table18_73_emit_[8];
  static const uint8_t table18_74_emit_[8];
  static const uint8_t table18_75_emit_[12];
  static const uint8_t table18_76_emit_[16];
  static const uint8_t table18_77_emit_[16];
  static const uint8_t table18_78_emit_[16];
  static const uint8_t table18_79_emit_[30];
  static const uint16_t table18_79_ops_[64];
  static const uint8_t table18_80_emit_[8];
  static const uint8_t table18_81_emit_[8];
  static const uint8_t table18_82_emit_[12];
  static const uint8_t table18_83_emit_[16];
  static const uint8_t table18_84_emit_[16];
  static const uint8_t table18_85_emit_[20];
  static const uint16_t table18_85_ops_[64];
  static const uint8_t table18_86_emit_[32];
  static const uint16_t table18_86_ops_[64];
  static const uint8_t table18_87_emit_[36];
  static const uint16_t table18_87_ops_[64];
  static const uint8_t table18_88_emit_[8];
  static const uint8_t table18_89_emit_[8];
  static const uint8_t table18_90_emit_[12];
  static const uint8_t table18_91_emit_[16];
  static const uint8_t table18_92_emit_[16];
  static const uint8_t table18_93_emit_[20];
  static const uint8_t table18_94_emit_[32];
  static const uint8_t table18_95_emit_[36];
  static const uint8_t table18_96_emit_[8];
  static const uint8_t table18_97_emit_[8];
  static const uint8_t table18_98_emit_[12];
  static const uint8_t table18_99_emit_[16];
  static const uint8_t table18_100_emit_[16];
  static const uint8_t table18_101_emit_[20];
  static const uint8_t table18_102_emit_[32];
  static const uint8_t table18_103_emit_[36];
  static const uint8_t table18_104_emit_[16];
  static const uint8_t table18_105_emit_[28];
  static const uint16_t table18_105_ops_[64];
  static const uint8_t table18_106_emit_[36];
  static const uint16_t table18_106_ops_[64];
  static const uint8_t table18_107_emit_[68];
  static const uint16_t table18_107_ops_[64];
  static const uint8_t table18_108_emit_[16];
  static const uint8_t table18_109_emit_[28];
  static const uint8_t table18_110_emit_[36];
  static const uint8_t table18_111_emit_[68];
  static const uint8_t table18_112_emit_[44];
  static const uint16_t table18_112_ops_[64];
  static const uint8_t table18_113_emit_[92];
  static const uint16_t table18_113_ops_[64];
  static const uint8_t table18_114_emit_[44];
  static const uint8_t table18_115_emit_[92];
  static const uint8_t table18_116_emit_[44];
  static const uint8_t table18_117_emit_[92];
  static const uint8_t table18_118_emit_[44];
  static const uint8_t table18_119_emit_[92];
  static const uint8_t table18_120_emit_[44];
  static const uint8_t table18_121_emit_[92];
  static const uint8_t table18_122_emit_[44];
  static const uint8_t table18_123_emit_[92];
  static const uint8_t table18_124_emit_[72];
  static const uint16_t table18_124_ops_[64];
  static const uint8_t table18_125_emit_[72];
  static const uint8_t table18_126_emit_[40];
  static const uint16_t table18_126_ops_[64];
  static const uint8_t table18_127_emit_[31];
  static const uint16_t table18_127_ops_[64];
  static const uint8_t* const table18_emit_[128];
  static const uint16_t* const table18_ops_[128];
  static const uint8_t table19_0_emit_[216];
  static const uint16_t table19_0_inner_[75];
  static const uint8_t table19_0_outer_[128];
  static const uint8_t table19_1_emit_[216];
  static const uint8_t table19_2_emit_[216];
  static const uint8_t table19_3_emit_[216];
  static const uint8_t table19_4_emit_[216];
  static const uint8_t table19_5_emit_[120];
  static const uint16_t table19_5_inner_[45];
  static const uint8_t table19_5_outer_[128];
  static const uint8_t table19_6_emit_[120];
  static const uint8_t table19_7_emit_[120];
  static const uint8_t table19_8_emit_[120];
  static const uint8_t table19_9_emit_[120];
  static const uint8_t table19_10_emit_[120];
  static const uint8_t table19_11_emit_[68];
  static const uint16_t table19_11_inner_[27];
  static const uint8_t table19_11_outer_[128];
  static const uint16_t table19_12_inner_[9];
  static const uint8_t table19_12_outer_[128];
  static const uint8_t table19_15_emit_[35];
  static const uint16_t table19_15_inner_[20];
  static const uint8_t table19_15_outer_[128];
  static const uint8_t table19_16_emit_[216];
  static const uint8_t table19_17_emit_[216];
  static const uint8_t table19_18_emit_[216];
  static const uint8_t table19_19_emit_[216];
  static const uint8_t table19_20_emit_[216];
  static const uint8_t table19_21_emit_[120];
  static const uint8_t table19_22_emit_[120];
  static const uint8_t table19_23_emit_[120];
  static const uint8_t table19_24_emit_[120];
  static const uint8_t table19_25_emit_[120];
  static const uint8_t table19_26_emit_[120];
  static const uint8_t table19_27_emit_[68];
  static const uint8_t table19_31_emit_[35];
  static const uint16_t table19_31_inner_[20];
  static const uint8_t table19_32_emit_[216];
  static const uint8_t table19_33_emit_[216];
  static const uint8_t table19_34_emit_[216];
  static const uint8_t table19_35_emit_[216];
  static const uint8_t table19_36_emit_[216];
  static const uint8_t table19_37_emit_[120];
  static const uint8_t table19_38_emit_[120];
  static const uint8_t table19_39_emit_[120];
  static const uint8_t table19_40_emit_[120];
  static const uint8_t table19_41_emit_[120];
  static const uint8_t table19_42_emit_[120];
  static const uint8_t table19_43_emit_[68];
  static const uint8_t table19_47_emit_[35];
  static const uint16_t table19_47_inner_[20];
  static const uint8_t table19_48_emit_[216];
  static const uint8_t table19_49_emit_[216];
  static const uint8_t table19_50_emit_[216];
  static const uint8_t table19_51_emit_[216];
  static const uint8_t table19_52_emit_[216];
  static const uint8_t table19_53_emit_[120];
  static const uint8_t table19_54_emit_[120];
  static const uint8_t table19_55_emit_[120];
  static const uint8_t table19_56_emit_[120];
  static const uint8_t table19_57_emit_[120];
  static const uint8_t table19_58_emit_[120];
  static const uint8_t table19_59_emit_[68];
  static const uint8_t table19_63_emit_[35];
  static const uint16_t table19_63_inner_[20];
  static const uint8_t table19_64_emit_[216];
  static const uint8_t table19_65_emit_[216];
  static const uint8_t table19_66_emit_[216];
  static const uint8_t table19_67_emit_[216];
  static const uint8_t table19_68_emit_[216];
  static const uint8_t table19_69_emit_[120];
  static const uint8_t table19_70_emit_[120];
  static const uint8_t table19_71_emit_[120];
  static const uint8_t table19_72_emit_[120];
  static const uint8_t table19_73_emit_[120];
  static const uint8_t table19_74_emit_[120];
  static const uint8_t table19_75_emit_[68];
  static const uint8_t table19_79_emit_[35];
  static const uint16_t table19_79_inner_[20];
  static const uint8_t table19_80_emit_[120];
  static const uint8_t table19_81_emit_[120];
  static const uint8_t table19_82_emit_[68];
  static const uint16_t table19_85_inner_[11];
  static const uint8_t table19_85_outer_[128];
  static const uint16_t table19_86_inner_[17];
  static const uint8_t table19_86_outer_[128];
  static const uint8_t table19_87_emit_[46];
  static const uint16_t table19_87_inner_[25];
  static const uint8_t table19_87_outer_[128];
  static const uint8_t table19_88_emit_[120];
  static const uint8_t table19_89_emit_[120];
  static const uint8_t table19_90_emit_[68];
  static const uint8_t table19_95_emit_[46];
  static const uint8_t table19_96_emit_[120];
  static const uint8_t table19_97_emit_[120];
  static const uint8_t table19_98_emit_[68];
  static const uint8_t table19_103_emit_[46];
  static const uint16_t table19_105_inner_[15];
  static const uint8_t table19_105_outer_[128];
  static const uint16_t table19_106_inner_[19];
  static const uint8_t table19_106_outer_[128];
  static const uint16_t table19_107_inner_[36];
  static const uint8_t table19_107_outer_[128];
  static const uint16_t table19_112_inner_[23];
  static const uint8_t table19_112_outer_[128];
  static const uint8_t table19_113_emit_[104];
  static const uint16_t table19_113_inner_[54];
  static const uint8_t table19_113_outer_[128];
  static const uint8_t table19_115_emit_[104];
  static const uint8_t table19_117_emit_[104];
  static const uint8_t table19_119_emit_[104];
  static const uint8_t table19_121_emit_[104];
  static const uint8_t table19_123_emit_[104];
  static const uint8_t table19_124_emit_[136];
  static const uint16_t table19_124_inner_[70];
  static const uint8_t table19_124_outer_[128];
  static const uint8_t table19_125_emit_[136];
  static const uint8_t table19_126_emit_[144];
  static const uint16_t table19_126_inner_[75];
  static const uint8_t table19_127_emit_[96];
  static const uint16_t table19_127_inner_[63];
  static const uint8_t table19_127_outer_[128];
  static const uint8_t* const table19_emit_[128];
  static const uint16_t* const table19_inner_[128];
  static const uint8_t* const table19_outer_[128];
  static const uint8_t table20_0_emit_[204];
  static const uint16_t table20_0_ops_[128];
  static const uint8_t table20_1_emit_[204];
  static const uint8_t table20_2_emit_[204];
  static const uint8_t table20_3_emit_[204];
  static const uint8_t table20_4_emit_[204];
  static const uint8_t table20_5_emit_[204];
  static const uint8_t table20_6_emit_[204];
  static const uint8_t table20_7_emit_[204];
  static const uint8_t table20_8_emit_[204];
  static const uint8_t table20_9_emit_[204];
  static const uint8_t table20_10_emit_[216];
  static const uint16_t table20_10_ops_[128];
  static const uint8_t table20_11_emit_[216];
  static const uint8_t table20_12_emit_[216];
  static const uint8_t table20_13_emit_[216];
  static const uint8_t table20_14_emit_[216];
  static const uint8_t table20_15_emit_[216];
  static const uint8_t table20_16_emit_[216];
  static const uint8_t table20_17_emit_[216];
  static const uint8_t table20_18_emit_[216];
  static const uint8_t table20_19_emit_[216];
  static const uint8_t table20_20_emit_[216];
  static const uint8_t table20_21_emit_[216];
  static const uint8_t table20_22_emit_[216];
  static const uint8_t table20_23_emit_[120];
  static const uint16_t table20_23_ops_[128];
  static const uint8_t table20_24_emit_[120];
  static const uint8_t table20_25_emit_[120];
  static const uint8_t table20_26_emit_[120];
  static const uint8_t table20_27_emit_[120];
  static const uint8_t table20_28_emit_[120];
  static const uint8_t table20_29_emit_[120];
  static const uint8_t table20_30_emit_[120];
  static const uint8_t table20_31_emit_[31];
  static const uint16_t table20_31_ops_[128];
  static const uint8_t table20_32_emit_[204];
  static const uint8_t table20_33_emit_[204];
  static const uint8_t table20_34_emit_[204];
  static const uint8_t table20_35_emit_[204];
  static const uint8_t table20_36_emit_[204];
  static const uint8_t table20_37_emit_[204];
  static const uint8_t table20_38_emit_[204];
  static const uint8_t table20_39_emit_[204];
  static const uint8_t table20_40_emit_[204];
  static const uint8_t table20_41_emit_[204];
  static const uint8_t table20_42_emit_[216];
  static const uint8_t table20_43_emit_[216];
  static const uint8_t table20_44_emit_[216];
  static const uint8_t table20_45_emit_[216];
  static const uint8_t table20_46_emit_[216];
  static const uint8_t table20_47_emit_[216];
  static const uint8_t table20_48_emit_[216];
  static const uint8_t table20_49_emit_[216];
  static const uint8_t table20_50_emit_[216];
  static const uint8_t table20_51_emit_[216];
  static const uint8_t table20_52_emit_[216];
  static const uint8_t table20_53_emit_[216];
  static const uint8_t table20_54_emit_[216];
  static const uint8_t table20_55_emit_[120];
  static const uint8_t table20_56_emit_[120];
  static const uint8_t table20_57_emit_[120];
  static const uint8_t table20_58_emit_[120];
  static const uint8_t table20_59_emit_[120];
  static const uint8_t table20_60_emit_[120];
  static const uint8_t table20_61_emit_[120];
  static const uint8_t table20_62_emit_[120];
  static const uint8_t table20_63_emit_[31];
  static const uint16_t table20_63_ops_[128];
  static const uint8_t table20_64_emit_[204];
  static const uint8_t table20_65_emit_[204];
  static const uint8_t table20_66_emit_[204];
  static const uint8_t table20_67_emit_[204];
  static const uint8_t table20_68_emit_[204];
  static const uint8_t table20_69_emit_[204];
  static const uint8_t table20_70_emit_[204];
  static const uint8_t table20_71_emit_[204];
  static const uint8_t table20_72_emit_[204];
  static const uint8_t table20_73_emit_[204];
  static const uint8_t table20_74_emit_[216];
  static const uint8_t table20_75_emit_[216];
  static const uint8_t table20_76_emit_[216];
  static const uint8_t table20_77_emit_[216];
  static const uint8_t table20_78_emit_[216];
  static const uint8_t table20_79_emit_[216];
  static const uint8_t table20_80_emit_[216];
  static const uint8_t table20_81_emit_[216];
  static const uint8_t table20_82_emit_[216];
  static const uint8_t table20_83_emit_[216];
  static const uint8_t table20_84_emit_[216];
  static const uint8_t table20_85_emit_[216];
  static const uint8_t table20_86_emit_[216];
  static const uint8_t table20_87_emit_[120];
  static const uint8_t table20_88_emit_[120];
  static const uint8_t table20_89_emit_[120];
  static const uint8_t table20_90_emit_[120];
  static const uint8_t table20_91_emit_[120];
  static const uint8_t table20_92_emit_[120];
  static const uint8_t table20_93_emit_[120];
  static const uint8_t table20_94_emit_[120];
  static const uint8_t table20_95_emit_[31];
  static const uint16_t table20_95_ops_[128];
  static const uint8_t table20_96_emit_[204];
  static const uint8_t table20_97_emit_[204];
  static const uint8_t table20_98_emit_[204];
  static const uint8_t table20_99_emit_[204];
  static const uint8_t table20_100_emit_[204];
  static const uint8_t table20_101_emit_[204];
  static const uint8_t table20_102_emit_[204];
  static const uint8_t table20_103_emit_[204];
  static const uint8_t table20_104_emit_[204];
  static const uint8_t table20_105_emit_[204];
  static const uint8_t table20_106_emit_[216];
  static const uint8_t table20_107_emit_[216];
  static const uint8_t table20_108_emit_[216];
  static const uint8_t table20_109_emit_[216];
  static const uint8_t table20_110_emit_[216];
  static const uint8_t table20_111_emit_[216];
  static const uint8_t table20_112_emit_[216];
  static const uint8_t table20_113_emit_[216];
  static const uint8_t table20_114_emit_[216];
  static const uint8_t table20_115_emit_[216];
  static const uint8_t table20_116_emit_[216];
  static const uint8_t table20_117_emit_[216];
  static const uint8_t table20_118_emit_[216];
  static const uint8_t table20_119_emit_[120];
  static const uint8_t table20_120_emit_[120];
  static const uint8_t table20_121_emit_[120];
  static const uint8_t table20_122_emit_[120];
  static const uint8_t table20_123_emit_[120];
  static const uint8_t table20_124_emit_[120];
  static const uint8_t table20_125_emit_[120];
  static const uint8_t table20_126_emit_[120];
  static const uint8_t table20_127_emit_[31];
  static const uint16_t table20_127_ops_[128];
  static const uint8_t table20_128_emit_[204];
  static const uint8_t table20_129_emit_[204];
  static const uint8_t table20_130_emit_[204];
  static const uint8_t table20_131_emit_[204];
  static const uint8_t table20_132_emit_[204];
  static const uint8_t table20_133_emit_[204];
  static const uint8_t table20_134_emit_[204];
  static const uint8_t table20_135_emit_[204];
  static const uint8_t table20_136_emit_[204];
  static const uint8_t table20_137_emit_[204];
  static const uint8_t table20_138_emit_[216];
  static const uint8_t table20_139_emit_[216];
  static const uint8_t table20_140_emit_[216];
  static const uint8_t table20_141_emit_[216];
  static const uint8_t table20_142_emit_[216];
  static const uint8_t table20_143_emit_[216];
  static const uint8_t table20_144_emit_[216];
  static const uint8_t table20_145_emit_[216];
  static const uint8_t table20_146_emit_[216];
  static const uint8_t table20_147_emit_[216];
  static const uint8_t table20_148_emit_[216];
  static const uint8_t table20_149_emit_[216];
  static const uint8_t table20_150_emit_[216];
  static const uint8_t table20_151_emit_[120];
  static const uint8_t table20_152_emit_[120];
  static const uint8_t table20_153_emit_[120];
  static const uint8_t table20_154_emit_[120];
  static const uint8_t table20_155_emit_[120];
  static const uint8_t table20_156_emit_[120];
  static const uint8_t table20_157_emit_[120];
  static const uint8_t table20_158_emit_[120];
  static const uint8_t table20_159_emit_[31];
  static const uint16_t table20_159_ops_[128];
  static const uint8_t table20_160_emit_[216];
  static const uint8_t table20_161_emit_[216];
  static const uint8_t table20_162_emit_[216];
  static const uint8_t table20_163_emit_[216];
  static const uint8_t table20_164_emit_[216];
  static const uint8_t table20_165_emit_[120];
  static const uint8_t table20_166_emit_[120];
  static const uint8_t table20_167_emit_[120];
  static const uint8_t table20_168_emit_[120];
  static const uint8_t table20_169_emit_[120];
  static const uint8_t table20_170_emit_[120];
  static const uint8_t table20_171_emit_[68];
  static const uint16_t table20_171_ops_[128];
  static const uint8_t table20_172_emit_[16];
  static const uint16_t table20_172_ops_[128];
  static const uint8_t table20_173_emit_[16];
  static const uint8_t table20_174_emit_[16];
  static const uint8_t table20_175_emit_[35];
  static const uint16_t table20_175_ops_[128];
  static const uint8_t table20_176_emit_[216];
  static const uint8_t table20_177_emit_[216];
  static const uint8_t table20_178_emit_[216];
  static const uint8_t table20_179_emit_[216];
  static const uint8_t table20_180_emit_[216];
  static const uint8_t table20_181_emit_[120];
  static const uint8_t table20_182_emit_[120];
  static const uint8_t table20_183_emit_[120];
  static const uint8_t table20_184_emit_[120];
  static const uint8_t table20_185_emit_[120];
  static const uint8_t table20_186_emit_[120];
  static const uint8_t table20_187_emit_[68];
  static const uint8_t table20_188_emit_[16];
  static const uint8_t table20_189_emit_[16];
  static const uint8_t table20_190_emit_[16];
  static const uint8_t table20_191_emit_[35];
  static const uint16_t table20_191_ops_[128];
  static const uint8_t table20_192_emit_[216];
  static const uint8_t table20_193_emit_[216];
  static const uint8_t table20_194_emit_[216];
  static const uint8_t table20_195_emit_[216];
  static const uint8_t table20_196_emit_[216];
  static const uint8_t table20_197_emit_[120];
  static const uint8_t table20_198_emit_[120];
  static const uint8_t table20_199_emit_[120];
  static const uint8_t table20_200_emit_[120];
  static const uint8_t table20_201_emit_[120];
  static const uint8_t table20_202_emit_[120];
  static const uint8_t table20_203_emit_[68];
  static const uint8_t table20_204_emit_[16];
  static const uint8_t table20_205_emit_[16];
  static const uint8_t table20_206_emit_[16];
  static const uint8_t table20_207_emit_[36];
  static const uint16_t table20_207_ops_[128];
  static const uint8_t table20_208_emit_[120];
  static const uint8_t table20_209_emit_[120];
  static const uint8_t table20_210_emit_[68];
  static const uint8_t table20_211_emit_[16];
  static const uint8_t table20_212_emit_[16];
  static const uint8_t table20_213_emit_[20];
  static const uint16_t table20_213_ops_[128];
  static const uint8_t table20_214_emit_[32];
  static const uint16_t table20_214_ops_[128];
  static const uint8_t table20_215_emit_[46];
  static const uint16_t table20_215_ops_[128];
  static const uint8_t table20_216_emit_[120];
  static const uint8_t table20_217_emit_[120];
  static const uint8_t table20_218_emit_[68];
  static const uint8_t table20_219_emit_[16];
  static const uint8_t table20_220_emit_[16];
  static const uint8_t table20_221_emit_[20];
  static const uint8_t table20_222_emit_[32];
  static const uint8_t table20_223_emit_[46];
  static const uint8_t table20_224_emit_[16];
  static const uint8_t table20_225_emit_[28];
  static const uint16_t table20_225_ops_[128];
  static const uint8_t table20_226_emit_[36];
  static const uint16_t table20_226_ops_[128];
  static const uint8_t table20_227_emit_[68];
  static const uint16_t table20_227_ops_[128];
  static const uint8_t table20_228_emit_[16];
  static const uint8_t table20_229_emit_[28];
  static const uint8_t table20_230_emit_[36];
  static const uint8_t table20_231_emit_[68];
  static const uint8_t table20_232_emit_[16];
  static const uint8_t table20_233_emit_[28];
  static const uint8_t table20_234_emit_[36];
  static const uint8_t table20_235_emit_[68];
  static const uint8_t table20_236_emit_[16];
  static const uint8_t table20_237_emit_[28];
  static const uint8_t table20_238_emit_[36];
  static const uint8_t table20_239_emit_[68];
  static const uint8_t table20_240_emit_[16];
  static const uint8_t table20_241_emit_[28];
  static const uint8_t table20_242_emit_[36];
  static const uint8_t table20_243_emit_[68];
  static const uint8_t table20_244_emit_[16];
  static const uint8_t table20_245_emit_[28];
  static const uint8_t table20_246_emit_[36];
  static const uint8_t table20_247_emit_[68];
  static const uint8_t table20_248_emit_[44];
  static const uint16_t table20_248_ops_[128];
  static const uint8_t table20_249_emit_[104];
  static const uint16_t table20_249_ops_[128];
  static const uint8_t table20_250_emit_[44];
  static const uint8_t table20_251_emit_[104];
  static const uint8_t table20_252_emit_[136];
  static const uint16_t table20_252_ops_[128];
  static const uint8_t table20_253_emit_[136];
  static const uint8_t table20_254_emit_[136];
  static const uint8_t table20_255_emit_[50];
  static const uint16_t table20_255_ops_[128];
  static const uint8_t* const table20_emit_[256];
  static const uint16_t* const table20_ops_[256];
  static const uint8_t table7_0_emit_[1];
  static const uint16_t table7_0_ops_[512];
  static const uint8_t table7_16_emit_[1];
  static const uint8_t table7_32_emit_[1];
  static const uint8_t table7_48_emit_[1];
  static const uint8_t table7_64_emit_[1];
  static const uint8_t table7_80_emit_[1];
  static const uint16_t table7_80_ops_[512];
  static const uint8_t table7_88_emit_[1];
  static const uint8_t table7_96_emit_[1];
  static const uint8_t table7_104_emit_[1];
  static const uint16_t table7_104_ops_[512];
  static const uint8_t table7_108_emit_[1];
  static const uint8_t table7_112_emit_[1];
  static const uint16_t table7_112_ops_[512];
  static const uint8_t table7_114_emit_[1];
  static const uint8_t table7_116_emit_[1];
  static const uint8_t table7_118_emit_[1];
  static const uint8_t table7_120_emit_[1];
  static const uint8_t table7_122_emit_[1];
  static const uint8_t table7_124_emit_[1];
  static const uint16_t table7_124_ops_[512];
  static const uint8_t table7_125_emit_[1];
  static const uint8_t table7_126_emit_[2];
  static const uint16_t table7_126_ops_[512];
  static const uint8_t table7_127_emit_[80];
  static const uint16_t table7_127_ops_[512];
  static const uint8_t* const table7_emit_[128];
  static const uint16_t* const table7_ops_[128];
  static const uint8_t table28_0_emit_[8];
  static const uint8_t table28_0_inner_[8];
  static const uint8_t table29_0_emit_[16];
  static const uint8_t table29_0_inner_[16];
  static const uint8_t table32_0_emit_[30];
  static const uint8_t table32_0_ops_[32];
  static const uint8_t table33_0_ops_[64];
  static const uint8_t table30_0_emit_[7];
  static const uint8_t table30_0_ops_[32];
  static const uint8_t table30_1_emit_[8];
  static const uint8_t table30_1_ops_[32];
  static const uint8_t table30_2_emit_[8];
  static const uint8_t table30_3_emit_[10];
  static const uint8_t table30_3_ops_[32];
  static const uint8_t* const table30_emit_[4];
  static const uint8_t* const table30_ops_[4];
  static const uint8_t table35_0_emit_[7];
  static const uint8_t table35_0_inner_[8];
  static const uint8_t table34_0_emit_[9];
  static const uint8_t table34_0_inner_[9];
};
template <typename F>
class HuffDecoder : public HuffDecoderCommon {
 public:
  HuffDecoder(F sink, const uint8_t* begin, const uint8_t* end)
      : sink_(sink), begin_(begin), end_(end) {}
  bool Run() {
    while (!done_) {
      if (!RefillTo7()) {
        Done0();
        break;
      }
      const auto index = (buffer_ >> (buffer_len_ - 7)) & 0x7f;
      const auto op = GetOp1(index);
      const int consumed = op & 7;
      buffer_len_ -= consumed;
      const auto emit_ofs = op >> 6;
      switch ((op >> 3) & 7) {
        case 0: {
          sink_(GetEmit1(index, emit_ofs + 0));
          break;
        }
        case 1: {
          DecodeStep0();
          break;
        }
        case 2: {
          DecodeStep1();
          break;
        }
        case 3: {
          DecodeStep2();
          break;
        }
        case 4: {
          DecodeStep3();
          break;
        }
      }
    }
    return ok_;
  }

 private:
  bool RefillTo7() {
    switch (buffer_len_) {
      case 0: {
        return Read1to8Bytes();
      }
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6: {
        return Read1to7Bytes();
      }
    }
    return true;
  }
  bool Read1to8Bytes() {
    switch (end_ - begin_) {
      case 0: {
        return false;
      }
      case 1: {
        Fill1();
        return true;
      }
      case 2: {
        Fill2();
        return true;
      }
      case 3: {
        Fill3();
        return true;
      }
      case 4: {
        Fill4();
        return true;
      }
      case 5: {
        Fill5();
        return true;
      }
      case 6: {
        Fill6();
        return true;
      }
      case 7: {
        Fill7();
        return true;
      }
      default: {
        Fill8();
        return true;
      }
    }
  }
  void Fill1() {
    buffer_ = (buffer_ << 8) | (static_cast<uint64_t>(begin_[0]) << 0);
    begin_ += 1;
    buffer_len_ += 8;
  }
  void Fill2() {
    buffer_ = (buffer_ << 16) | (static_cast<uint64_t>(begin_[0]) << 8) |
              (static_cast<uint64_t>(begin_[1]) << 0);
    begin_ += 2;
    buffer_len_ += 16;
  }
  void Fill3() {
    buffer_ = (buffer_ << 24) | (static_cast<uint64_t>(begin_[0]) << 16) |
              (static_cast<uint64_t>(begin_[1]) << 8) |
              (static_cast<uint64_t>(begin_[2]) << 0);
    begin_ += 3;
    buffer_len_ += 24;
  }
  void Fill4() {
    buffer_ = (buffer_ << 32) | (static_cast<uint64_t>(begin_[0]) << 24) |
              (static_cast<uint64_t>(begin_[1]) << 16) |
              (static_cast<uint64_t>(begin_[2]) << 8) |
              (static_cast<uint64_t>(begin_[3]) << 0);
    begin_ += 4;
    buffer_len_ += 32;
  }
  void Fill5() {
    buffer_ = (buffer_ << 40) | (static_cast<uint64_t>(begin_[0]) << 32) |
              (static_cast<uint64_t>(begin_[1]) << 24) |
              (static_cast<uint64_t>(begin_[2]) << 16) |
              (static_cast<uint64_t>(begin_[3]) << 8) |
              (static_cast<uint64_t>(begin_[4]) << 0);
    begin_ += 5;
    buffer_len_ += 40;
  }
  void Fill6() {
    buffer_ = (buffer_ << 48) | (static_cast<uint64_t>(begin_[0]) << 40) |
              (static_cast<uint64_t>(begin_[1]) << 32) |
              (static_cast<uint64_t>(begin_[2]) << 24) |
              (static_cast<uint64_t>(begin_[3]) << 16) |
              (static_cast<uint64_t>(begin_[4]) << 8) |
              (static_cast<uint64_t>(begin_[5]) << 0);
    begin_ += 6;
    buffer_len_ += 48;
  }
  void Fill7() {
    buffer_ = (buffer_ << 56) | (static_cast<uint64_t>(begin_[0]) << 48) |
              (static_cast<uint64_t>(begin_[1]) << 40) |
              (static_cast<uint64_t>(begin_[2]) << 32) |
              (static_cast<uint64_t>(begin_[3]) << 24) |
              (static_cast<uint64_t>(begin_[4]) << 16) |
              (static_cast<uint64_t>(begin_[5]) << 8) |
              (static_cast<uint64_t>(begin_[6]) << 0);
    begin_ += 7;
    buffer_len_ += 56;
  }
  void Fill8() {
    buffer_ = 0 | (static_cast<uint64_t>(begin_[0]) << 56) |
              (static_cast<uint64_t>(begin_[1]) << 48) |
              (static_cast<uint64_t>(begin_[2]) << 40) |
              (static_cast<uint64_t>(begin_[3]) << 32) |
              (static_cast<uint64_t>(begin_[4]) << 24) |
              (static_cast<uint64_t>(begin_[5]) << 16) |
              (static_cast<uint64_t>(begin_[6]) << 8) |
              (static_cast<uint64_t>(begin_[7]) << 0);
    begin_ += 8;
    buffer_len_ += 64;
  }
  bool Read1to7Bytes() {
    switch (end_ - begin_) {
      case 0: {
        return false;
      }
      case 1: {
        Fill1();
        return true;
      }
      case 2: {
        Fill2();
        return true;
      }
      case 3: {
        Fill3();
        return true;
      }
      case 4: {
        Fill4();
        return true;
      }
      case 5: {
        Fill5();
        return true;
      }
      case 6: {
        Fill6();
        return true;
      }
      default: {
        Fill7();
        return true;
      }
    }
  }
  void Done0() {
    done_ = true;
    switch (buffer_len_) {
      case 1:
      case 2:
      case 3:
      case 4: {
        ok_ = (buffer_ & ((1 << buffer_len_) - 1)) == (1 << buffer_len_) - 1;
        return;
      }
      case 5: {
        const auto index = buffer_ & 31;
        const auto op = GetOp2(index);
        switch (op & 3) {
          case 0: {
            sink_(GetEmit2(index, (op >> 2) + 0));
            break;
          }
          case 1: {
            ok_ = false;
            break;
          }
        }
        return;
      }
      case 6: {
        const auto index = buffer_ & 63;
        const auto op = GetOp3(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit3(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 0: {
        return;
      }
    }
  }
  void DecodeStep0() {
    if (!RefillTo1()) {
      Done1();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 1)) & 0x1;
    const auto op = GetOp4(index);
    const int consumed = op & 1;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 1;
    sink_(GetEmit4(index, emit_ofs + 0));
  }
  bool RefillTo1() {
    switch (buffer_len_) {
      case 0: {
        return Read1to8Bytes();
      }
    }
    return true;
  }
  void Done1() {
    done_ = true;
    ok_ = false;
  }
  void DecodeStep1() {
    if (!RefillTo1()) {
      Done2();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 1)) & 0x1;
    const auto op = GetOp5(index);
    const int consumed = op & 1;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 1;
    sink_(GetEmit5(index, emit_ofs + 0));
  }
  void Done2() {
    done_ = true;
    ok_ = false;
  }
  void DecodeStep2() {
    if (!RefillTo1()) {
      Done3();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 1)) & 0x1;
    const auto op = GetOp6(index);
    const int consumed = op & 1;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 1;
    sink_(GetEmit6(index, emit_ofs + 0));
  }
  void Done3() {
    done_ = true;
    ok_ = false;
  }
  void DecodeStep3() {
    if (!RefillTo16()) {
      Done4();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 16)) & 0xffff;
    const auto op = GetOp7(index);
    const int consumed = op & 31;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 9;
    switch ((op >> 5) & 15) {
      case 0: {
        sink_(GetEmit7(index, emit_ofs + 0));
        break;
      }
      case 1: {
        DecodeStep4();
        break;
      }
      case 2: {
        DecodeStep5();
        break;
      }
      case 3: {
        DecodeStep6();
        break;
      }
      case 4: {
        DecodeStep7();
        break;
      }
      case 5: {
        DecodeStep8();
        break;
      }
      case 6: {
        DecodeStep9();
        break;
      }
      case 7: {
        DecodeStep10();
        break;
      }
      case 8: {
        DecodeStep11();
        break;
      }
      case 9: {
        DecodeStep14();
        break;
      }
      case 10: {
        DecodeStep12();
        break;
      }
      case 11: {
        DecodeStep13();
        break;
      }
    }
  }
  bool RefillTo16() {
    switch (buffer_len_) {
      case 0: {
        return Read2to8Bytes();
      }
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7: {
        return Read2to7Bytes();
      }
      case 8: {
        return Read1to7Bytes();
      }
      case 9:
      case 10:
      case 11:
      case 12:
      case 13:
      case 14:
      case 15: {
        return Read1to6Bytes();
      }
    }
    return true;
  }
  bool Read2to8Bytes() {
    switch (end_ - begin_) {
      case 0:
      case 1: {
        return false;
      }
      case 2: {
        Fill2();
        return true;
      }
      case 3: {
        Fill3();
        return true;
      }
      case 4: {
        Fill4();
        return true;
      }
      case 5: {
        Fill5();
        return true;
      }
      case 6: {
        Fill6();
        return true;
      }
      case 7: {
        Fill7();
        return true;
      }
      default: {
        Fill8();
        return true;
      }
    }
  }
  bool Read2to7Bytes() {
    switch (end_ - begin_) {
      case 0:
      case 1: {
        return false;
      }
      case 2: {
        Fill2();
        return true;
      }
      case 3: {
        Fill3();
        return true;
      }
      case 4: {
        Fill4();
        return true;
      }
      case 5: {
        Fill5();
        return true;
      }
      case 6: {
        Fill6();
        return true;
      }
      default: {
        Fill7();
        return true;
      }
    }
  }
  bool Read1to6Bytes() {
    switch (end_ - begin_) {
      case 0: {
        return false;
      }
      case 1: {
        Fill1();
        return true;
      }
      case 2: {
        Fill2();
        return true;
      }
      case 3: {
        Fill3();
        return true;
      }
      case 4: {
        Fill4();
        return true;
      }
      case 5: {
        Fill5();
        return true;
      }
      default: {
        Fill6();
        return true;
      }
    }
  }
  void Done4() {
    done_ = true;
    switch (end_ - begin_) {
      case 1: {
        Fill1();
        break;
      }
    }
    switch (buffer_len_) {
      case 1:
      case 2: {
        ok_ = (buffer_ & ((1 << buffer_len_) - 1)) == (1 << buffer_len_) - 1;
        return;
      }
      case 3: {
        const auto index = buffer_ & 7;
        const auto op = GetOp8(index);
        switch (op & 3) {
          case 0: {
            sink_(GetEmit8(index, (op >> 2) + 0));
            break;
          }
          case 1: {
            ok_ = false;
            break;
          }
        }
        return;
      }
      case 4: {
        const auto index = buffer_ & 15;
        const auto op = GetOp9(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit9(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 5: {
        const auto index = buffer_ & 31;
        const auto op = GetOp10(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit10(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 6: {
        const auto index = buffer_ & 63;
        const auto op = GetOp11(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit11(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 7: {
        const auto index = buffer_ & 127;
        const auto op = GetOp12(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit12(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 8: {
        const auto index = buffer_ & 255;
        const auto op = GetOp13(index);
        switch (op & 3) {
          case 0: {
            sink_(GetEmit13(index, (op >> 2) + 0));
            sink_(GetEmit13(index, (op >> 2) + 1));
            break;
          }
          case 1: {
            ok_ = false;
            break;
          }
          case 2: {
            sink_(GetEmit13(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 9: {
        const auto index = buffer_ & 511;
        const auto op = GetOp14(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit14(index, (op >> 2) + 0));
            sink_(GetEmit14(index, (op >> 2) + 1));
            break;
          }
          case 2: {
            sink_(GetEmit14(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 10: {
        const auto index = buffer_ & 1023;
        const auto op = GetOp15(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit15(index, (op >> 2) + 0));
            sink_(GetEmit15(index, (op >> 2) + 1));
            break;
          }
          case 2: {
            sink_(GetEmit15(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 11: {
        const auto index = buffer_ & 2047;
        const auto op = GetOp16(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit16(index, (op >> 2) + 0));
            sink_(GetEmit16(index, (op >> 2) + 1));
            break;
          }
          case 2: {
            sink_(GetEmit16(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 12: {
        const auto index = buffer_ & 4095;
        const auto op = GetOp17(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit17(index, (op >> 2) + 0));
            sink_(GetEmit17(index, (op >> 2) + 1));
            break;
          }
          case 2: {
            sink_(GetEmit17(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 13: {
        const auto index = buffer_ & 8191;
        const auto op = GetOp18(index);
        switch (op & 7) {
          case 0: {
            sink_(GetEmit18(index, (op >> 3) + 0));
            sink_(GetEmit18(index, (op >> 3) + 1));
            sink_(GetEmit18(index, (op >> 3) + 2));
            break;
          }
          case 1: {
            ok_ = false;
            break;
          }
          case 2: {
            sink_(GetEmit18(index, (op >> 3) + 0));
            sink_(GetEmit18(index, (op >> 3) + 1));
            break;
          }
          case 3: {
            sink_(GetEmit18(index, (op >> 3) + 0));
            break;
          }
        }
        return;
      }
      case 14: {
        const auto index = buffer_ & 16383;
        const auto op = GetOp19(index);
        switch (op & 7) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit19(index, (op >> 3) + 0));
            sink_(GetEmit19(index, (op >> 3) + 1));
            sink_(GetEmit19(index, (op >> 3) + 2));
            break;
          }
          case 2: {
            sink_(GetEmit19(index, (op >> 3) + 0));
            sink_(GetEmit19(index, (op >> 3) + 1));
            break;
          }
          case 3: {
            sink_(GetEmit19(index, (op >> 3) + 0));
            break;
          }
        }
        return;
      }
      case 15: {
        const auto index = buffer_ & 32767;
        const auto op = GetOp20(index);
        switch (op & 7) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit20(index, (op >> 3) + 0));
            sink_(GetEmit20(index, (op >> 3) + 1));
            sink_(GetEmit20(index, (op >> 3) + 2));
            break;
          }
          case 2: {
            sink_(GetEmit20(index, (op >> 3) + 0));
            sink_(GetEmit20(index, (op >> 3) + 1));
            break;
          }
          case 3: {
            sink_(GetEmit20(index, (op >> 3) + 0));
            break;
          }
        }
        return;
      }
      case 0: {
        return;
      }
    }
  }
  void DecodeStep4() {
    if (!RefillTo1()) {
      Done5();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 1)) & 0x1;
    const auto op = GetOp21(index);
    const int consumed = op & 1;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 1;
    sink_(GetEmit21(index, emit_ofs + 0));
  }
  void Done5() {
    done_ = true;
    ok_ = false;
  }
  void DecodeStep5() {
    if (!RefillTo1()) {
      Done6();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 1)) & 0x1;
    const auto op = GetOp22(index);
    const int consumed = op & 1;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 1;
    sink_(GetEmit22(index, emit_ofs + 0));
  }
  void Done6() {
    done_ = true;
    ok_ = false;
  }
  void DecodeStep6() {
    if (!RefillTo1()) {
      Done7();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 1)) & 0x1;
    const auto op = GetOp23(index);
    const int consumed = op & 1;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 1;
    sink_(GetEmit23(index, emit_ofs + 0));
  }
  void Done7() {
    done_ = true;
    ok_ = false;
  }
  void DecodeStep7() {
    if (!RefillTo1()) {
      Done8();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 1)) & 0x1;
    const auto op = GetOp24(index);
    const int consumed = op & 1;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 1;
    sink_(GetEmit24(index, emit_ofs + 0));
  }
  void Done8() {
    done_ = true;
    ok_ = false;
  }
  void DecodeStep8() {
    if (!RefillTo1()) {
      Done9();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 1)) & 0x1;
    const auto op = GetOp25(index);
    const int consumed = op & 1;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 1;
    sink_(GetEmit25(index, emit_ofs + 0));
  }
  void Done9() {
    done_ = true;
    ok_ = false;
  }
  void DecodeStep9() {
    if (!RefillTo1()) {
      Done10();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 1)) & 0x1;
    const auto op = GetOp26(index);
    const int consumed = op & 1;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 1;
    sink_(GetEmit26(index, emit_ofs + 0));
  }
  void Done10() {
    done_ = true;
    ok_ = false;
  }
  void DecodeStep10() {
    if (!RefillTo2()) {
      Done11();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 2)) & 0x3;
    const auto op = GetOp27(index);
    const int consumed = op & 3;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 2;
    sink_(GetEmit27(index, emit_ofs + 0));
  }
  bool RefillTo2() {
    switch (buffer_len_) {
      case 0: {
        return Read1to8Bytes();
      }
      case 1: {
        return Read1to7Bytes();
      }
    }
    return true;
  }
  void Done11() {
    done_ = true;
    switch (buffer_len_) {
      case 1:
      case 0: {
        ok_ = false;
        return;
      }
    }
  }
  void DecodeStep11() {
    if (!RefillTo3()) {
      Done12();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 3)) & 0x7;
    const auto op = GetOp28(index);
    const int consumed = op & 3;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 2;
    sink_(GetEmit28(index, emit_ofs + 0));
  }
  bool RefillTo3() {
    switch (buffer_len_) {
      case 0: {
        return Read1to8Bytes();
      }
      case 1:
      case 2: {
        return Read1to7Bytes();
      }
    }
    return true;
  }
  void Done12() {
    done_ = true;
    switch (buffer_len_) {
      case 1:
      case 2:
      case 0: {
        ok_ = false;
        return;
      }
    }
  }
  void DecodeStep12() {
    if (!RefillTo4()) {
      Done13();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 4)) & 0xf;
    const auto op = GetOp29(index);
    const int consumed = op & 7;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 3;
    sink_(GetEmit29(index, emit_ofs + 0));
  }
  bool RefillTo4() {
    switch (buffer_len_) {
      case 0: {
        return Read1to8Bytes();
      }
      case 1:
      case 2:
      case 3: {
        return Read1to7Bytes();
      }
    }
    return true;
  }
  void Done13() {
    done_ = true;
    switch (buffer_len_) {
      case 1:
      case 2:
      case 3:
      case 0: {
        ok_ = false;
        return;
      }
    }
  }
  void DecodeStep13() {
    if (!RefillTo7()) {
      Done14();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 7)) & 0x7f;
    const auto op = GetOp30(index);
    const int consumed = op & 7;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 4;
    switch ((op >> 3) & 1) {
      case 0: {
        sink_(GetEmit30(index, emit_ofs + 0));
        break;
      }
      case 1: {
        begin_ = end_;
        buffer_len_ = 0;
        break;
      }
    }
  }
  void Done14() {
    done_ = true;
    switch (buffer_len_) {
      case 1:
      case 2:
      case 3: {
        ok_ = (buffer_ & ((1 << buffer_len_) - 1)) == (1 << buffer_len_) - 1;
        return;
      }
      case 4: {
        const auto index = buffer_ & 15;
        const auto op = GetOp31(index);
        switch (op & 3) {
          case 0: {
            sink_(GetEmit31(index, (op >> 2) + 0));
            break;
          }
          case 1: {
            ok_ = false;
            break;
          }
        }
        return;
      }
      case 5: {
        const auto index = buffer_ & 31;
        const auto op = GetOp32(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit32(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 6: {
        const auto index = buffer_ & 63;
        const auto op = GetOp33(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit33(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 0: {
        return;
      }
    }
  }
  void DecodeStep14() {
    if (!RefillTo4()) {
      Done15();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 4)) & 0xf;
    const auto op = GetOp34(index);
    const int consumed = op & 7;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 3;
    sink_(GetEmit34(index, emit_ofs + 0));
  }
  void Done15() {
    done_ = true;
    switch (buffer_len_) {
      case 1:
      case 2:
      case 0: {
        ok_ = false;
        return;
      }
      case 3: {
        const auto index = buffer_ & 7;
        const auto op = GetOp35(index);
        switch (op & 1) {
          case 0: {
            sink_(GetEmit35(index, (op >> 1) + 0));
            break;
          }
          case 1: {
            ok_ = false;
            break;
          }
        }
        return;
      }
    }
  }
  F sink_;
  const uint8_t* begin_;
  const uint8_t* const end_;
  uint64_t buffer_ = 0;
  int buffer_len_ = 0;
  bool ok_ = true;
  bool done_ = false;
};
}  // namespace geometry_7_16_7
}  // namespace grpc_core
#endif  // GRPC_TEST_CPP_MICROBENCHMARKS_HUFFMAN_GEOMETRIES_DECODE_HUFF_7_16_7_H
