// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package capi

import (
	"context"
	"sync"
)

// Ensure, that CapiClientMock does implement CapiClient.
// If this is not the case, regenerate this file with moq.
var _ CapiClient = &CapiClientMock{}

// CapiClientMock is a mock implementation of CapiClient.
//
//	func TestSomethingThatUsesCapiClient(t *testing.T) {
//
//		// make and configure a mocked CapiClient
//		mockedCapiClient := &CapiClientMock{
//			CreateJobFunc: func(ctx context.Context, owner string, repo string, problemStatement string, baseBranch string, customAgent string) (*Job, error) {
//				panic("mock out the CreateJob method")
//			},
//			GetJobFunc: func(ctx context.Context, owner string, repo string, jobID string) (*Job, error) {
//				panic("mock out the GetJob method")
//			},
//			GetPullRequestDatabaseIDFunc: func(ctx context.Context, hostname string, owner string, repo string, number int) (int64, string, error) {
//				panic("mock out the GetPullRequestDatabaseID method")
//			},
//			GetSessionFunc: func(ctx context.Context, id string) (*Session, error) {
//				panic("mock out the GetSession method")
//			},
//			GetSessionLogsFunc: func(ctx context.Context, id string) ([]byte, error) {
//				panic("mock out the GetSessionLogs method")
//			},
//			ListLatestSessionsForViewerFunc: func(ctx context.Context, limit int) ([]*Session, error) {
//				panic("mock out the ListLatestSessionsForViewer method")
//			},
//			ListSessionsByResourceIDFunc: func(ctx context.Context, resourceType string, resourceID int64, limit int) ([]*Session, error) {
//				panic("mock out the ListSessionsByResourceID method")
//			},
//		}
//
//		// use mockedCapiClient in code that requires CapiClient
//		// and then make assertions.
//
//	}
type CapiClientMock struct {
	// CreateJobFunc mocks the CreateJob method.
	CreateJobFunc func(ctx context.Context, owner string, repo string, problemStatement string, baseBranch string, customAgent string) (*Job, error)

	// GetJobFunc mocks the GetJob method.
	GetJobFunc func(ctx context.Context, owner string, repo string, jobID string) (*Job, error)

	// GetPullRequestDatabaseIDFunc mocks the GetPullRequestDatabaseID method.
	GetPullRequestDatabaseIDFunc func(ctx context.Context, hostname string, owner string, repo string, number int) (int64, string, error)

	// GetSessionFunc mocks the GetSession method.
	GetSessionFunc func(ctx context.Context, id string) (*Session, error)

	// GetSessionLogsFunc mocks the GetSessionLogs method.
	GetSessionLogsFunc func(ctx context.Context, id string) ([]byte, error)

	// ListLatestSessionsForViewerFunc mocks the ListLatestSessionsForViewer method.
	ListLatestSessionsForViewerFunc func(ctx context.Context, limit int) ([]*Session, error)

	// ListSessionsByResourceIDFunc mocks the ListSessionsByResourceID method.
	ListSessionsByResourceIDFunc func(ctx context.Context, resourceType string, resourceID int64, limit int) ([]*Session, error)

	// calls tracks calls to the methods.
	calls struct {
		// CreateJob holds details about calls to the CreateJob method.
		CreateJob []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Owner is the owner argument value.
			Owner string
			// Repo is the repo argument value.
			Repo string
			// ProblemStatement is the problemStatement argument value.
			ProblemStatement string
			// BaseBranch is the baseBranch argument value.
			BaseBranch string
			// CustomAgent is the customAgent argument value.
			CustomAgent string
		}
		// GetJob holds details about calls to the GetJob method.
		GetJob []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Owner is the owner argument value.
			Owner string
			// Repo is the repo argument value.
			Repo string
			// JobID is the jobID argument value.
			JobID string
		}
		// GetPullRequestDatabaseID holds details about calls to the GetPullRequestDatabaseID method.
		GetPullRequestDatabaseID []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Hostname is the hostname argument value.
			Hostname string
			// Owner is the owner argument value.
			Owner string
			// Repo is the repo argument value.
			Repo string
			// Number is the number argument value.
			Number int
		}
		// GetSession holds details about calls to the GetSession method.
		GetSession []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// ID is the id argument value.
			ID string
		}
		// GetSessionLogs holds details about calls to the GetSessionLogs method.
		GetSessionLogs []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// ID is the id argument value.
			ID string
		}
		// ListLatestSessionsForViewer holds details about calls to the ListLatestSessionsForViewer method.
		ListLatestSessionsForViewer []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Limit is the limit argument value.
			Limit int
		}
		// ListSessionsByResourceID holds details about calls to the ListSessionsByResourceID method.
		ListSessionsByResourceID []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// ResourceType is the resourceType argument value.
			ResourceType string
			// ResourceID is the resourceID argument value.
			ResourceID int64
			// Limit is the limit argument value.
			Limit int
		}
	}
	lockCreateJob                   sync.RWMutex
	lockGetJob                      sync.RWMutex
	lockGetPullRequestDatabaseID    sync.RWMutex
	lockGetSession                  sync.RWMutex
	lockGetSessionLogs              sync.RWMutex
	lockListLatestSessionsForViewer sync.RWMutex
	lockListSessionsByResourceID    sync.RWMutex
}

// CreateJob calls CreateJobFunc.
func (mock *CapiClientMock) CreateJob(ctx context.Context, owner string, repo string, problemStatement string, baseBranch string, customAgent string) (*Job, error) {
	if mock.CreateJobFunc == nil {
		panic("CapiClientMock.CreateJobFunc: method is nil but CapiClient.CreateJob was just called")
	}
	callInfo := struct {
		Ctx              context.Context
		Owner            string
		Repo             string
		ProblemStatement string
		BaseBranch       string
		CustomAgent      string
	}{
		Ctx:              ctx,
		Owner:            owner,
		Repo:             repo,
		ProblemStatement: problemStatement,
		BaseBranch:       baseBranch,
		CustomAgent:      customAgent,
	}
	mock.lockCreateJob.Lock()
	mock.calls.CreateJob = append(mock.calls.CreateJob, callInfo)
	mock.lockCreateJob.Unlock()
	return mock.CreateJobFunc(ctx, owner, repo, problemStatement, baseBranch, customAgent)
}

// CreateJobCalls gets all the calls that were made to CreateJob.
// Check the length with:
//
//	len(mockedCapiClient.CreateJobCalls())
func (mock *CapiClientMock) CreateJobCalls() []struct {
	Ctx              context.Context
	Owner            string
	Repo             string
	ProblemStatement string
	BaseBranch       string
	CustomAgent      string
} {
	var calls []struct {
		Ctx              context.Context
		Owner            string
		Repo             string
		ProblemStatement string
		BaseBranch       string
		CustomAgent      string
	}
	mock.lockCreateJob.RLock()
	calls = mock.calls.CreateJob
	mock.lockCreateJob.RUnlock()
	return calls
}

// GetJob calls GetJobFunc.
func (mock *CapiClientMock) GetJob(ctx context.Context, owner string, repo string, jobID string) (*Job, error) {
	if mock.GetJobFunc == nil {
		panic("CapiClientMock.GetJobFunc: method is nil but CapiClient.GetJob was just called")
	}
	callInfo := struct {
		Ctx   context.Context
		Owner string
		Repo  string
		JobID string
	}{
		Ctx:   ctx,
		Owner: owner,
		Repo:  repo,
		JobID: jobID,
	}
	mock.lockGetJob.Lock()
	mock.calls.GetJob = append(mock.calls.GetJob, callInfo)
	mock.lockGetJob.Unlock()
	return mock.GetJobFunc(ctx, owner, repo, jobID)
}

// GetJobCalls gets all the calls that were made to GetJob.
// Check the length with:
//
//	len(mockedCapiClient.GetJobCalls())
func (mock *CapiClientMock) GetJobCalls() []struct {
	Ctx   context.Context
	Owner string
	Repo  string
	JobID string
} {
	var calls []struct {
		Ctx   context.Context
		Owner string
		Repo  string
		JobID string
	}
	mock.lockGetJob.RLock()
	calls = mock.calls.GetJob
	mock.lockGetJob.RUnlock()
	return calls
}

// GetPullRequestDatabaseID calls GetPullRequestDatabaseIDFunc.
func (mock *CapiClientMock) GetPullRequestDatabaseID(ctx context.Context, hostname string, owner string, repo string, number int) (int64, string, error) {
	if mock.GetPullRequestDatabaseIDFunc == nil {
		panic("CapiClientMock.GetPullRequestDatabaseIDFunc: method is nil but CapiClient.GetPullRequestDatabaseID was just called")
	}
	callInfo := struct {
		Ctx      context.Context
		Hostname string
		Owner    string
		Repo     string
		Number   int
	}{
		Ctx:      ctx,
		Hostname: hostname,
		Owner:    owner,
		Repo:     repo,
		Number:   number,
	}
	mock.lockGetPullRequestDatabaseID.Lock()
	mock.calls.GetPullRequestDatabaseID = append(mock.calls.GetPullRequestDatabaseID, callInfo)
	mock.lockGetPullRequestDatabaseID.Unlock()
	return mock.GetPullRequestDatabaseIDFunc(ctx, hostname, owner, repo, number)
}

// GetPullRequestDatabaseIDCalls gets all the calls that were made to GetPullRequestDatabaseID.
// Check the length with:
//
//	len(mockedCapiClient.GetPullRequestDatabaseIDCalls())
func (mock *CapiClientMock) GetPullRequestDatabaseIDCalls() []struct {
	Ctx      context.Context
	Hostname string
	Owner    string
	Repo     string
	Number   int
} {
	var calls []struct {
		Ctx      context.Context
		Hostname string
		Owner    string
		Repo     string
		Number   int
	}
	mock.lockGetPullRequestDatabaseID.RLock()
	calls = mock.calls.GetPullRequestDatabaseID
	mock.lockGetPullRequestDatabaseID.RUnlock()
	return calls
}

// GetSession calls GetSessionFunc.
func (mock *CapiClientMock) GetSession(ctx context.Context, id string) (*Session, error) {
	if mock.GetSessionFunc == nil {
		panic("CapiClientMock.GetSessionFunc: method is nil but CapiClient.GetSession was just called")
	}
	callInfo := struct {
		Ctx context.Context
		ID  string
	}{
		Ctx: ctx,
		ID:  id,
	}
	mock.lockGetSession.Lock()
	mock.calls.GetSession = append(mock.calls.GetSession, callInfo)
	mock.lockGetSession.Unlock()
	return mock.GetSessionFunc(ctx, id)
}

// GetSessionCalls gets all the calls that were made to GetSession.
// Check the length with:
//
//	len(mockedCapiClient.GetSessionCalls())
func (mock *CapiClientMock) GetSessionCalls() []struct {
	Ctx context.Context
	ID  string
} {
	var calls []struct {
		Ctx context.Context
		ID  string
	}
	mock.lockGetSession.RLock()
	calls = mock.calls.GetSession
	mock.lockGetSession.RUnlock()
	return calls
}

// GetSessionLogs calls GetSessionLogsFunc.
func (mock *CapiClientMock) GetSessionLogs(ctx context.Context, id string) ([]byte, error) {
	if mock.GetSessionLogsFunc == nil {
		panic("CapiClientMock.GetSessionLogsFunc: method is nil but CapiClient.GetSessionLogs was just called")
	}
	callInfo := struct {
		Ctx context.Context
		ID  string
	}{
		Ctx: ctx,
		ID:  id,
	}
	mock.lockGetSessionLogs.Lock()
	mock.calls.GetSessionLogs = append(mock.calls.GetSessionLogs, callInfo)
	mock.lockGetSessionLogs.Unlock()
	return mock.GetSessionLogsFunc(ctx, id)
}

// GetSessionLogsCalls gets all the calls that were made to GetSessionLogs.
// Check the length with:
//
//	len(mockedCapiClient.GetSessionLogsCalls())
func (mock *CapiClientMock) GetSessionLogsCalls() []struct {
	Ctx context.Context
	ID  string
} {
	var calls []struct {
		Ctx context.Context
		ID  string
	}
	mock.lockGetSessionLogs.RLock()
	calls = mock.calls.GetSessionLogs
	mock.lockGetSessionLogs.RUnlock()
	return calls
}

// ListLatestSessionsForViewer calls ListLatestSessionsForViewerFunc.
func (mock *CapiClientMock) ListLatestSessionsForViewer(ctx context.Context, limit int) ([]*Session, error) {
	if mock.ListLatestSessionsForViewerFunc == nil {
		panic("CapiClientMock.ListLatestSessionsForViewerFunc: method is nil but CapiClient.ListLatestSessionsForViewer was just called")
	}
	callInfo := struct {
		Ctx   context.Context
		Limit int
	}{
		Ctx:   ctx,
		Limit: limit,
	}
	mock.lockListLatestSessionsForViewer.Lock()
	mock.calls.ListLatestSessionsForViewer = append(mock.calls.ListLatestSessionsForViewer, callInfo)
	mock.lockListLatestSessionsForViewer.Unlock()
	return mock.ListLatestSessionsForViewerFunc(ctx, limit)
}

// ListLatestSessionsForViewerCalls gets all the calls that were made to ListLatestSessionsForViewer.
// Check the length with:
//
//	len(mockedCapiClient.ListLatestSessionsForViewerCalls())
func (mock *CapiClientMock) ListLatestSessionsForViewerCalls() []struct {
	Ctx   context.Context
	Limit int
} {
	var calls []struct {
		Ctx   context.Context
		Limit int
	}
	mock.lockListLatestSessionsForViewer.RLock()
	calls = mock.calls.ListLatestSessionsForViewer
	mock.lockListLatestSessionsForViewer.RUnlock()
	return calls
}

// ListSessionsByResourceID calls ListSessionsByResourceIDFunc.
func (mock *CapiClientMock) ListSessionsByResourceID(ctx context.Context, resourceType string, resourceID int64, limit int) ([]*Session, error) {
	if mock.ListSessionsByResourceIDFunc == nil {
		panic("CapiClientMock.ListSessionsByResourceIDFunc: method is nil but CapiClient.ListSessionsByResourceID was just called")
	}
	callInfo := struct {
		Ctx          context.Context
		ResourceType string
		ResourceID   int64
		Limit        int
	}{
		Ctx:          ctx,
		ResourceType: resourceType,
		ResourceID:   resourceID,
		Limit:        limit,
	}
	mock.lockListSessionsByResourceID.Lock()
	mock.calls.ListSessionsByResourceID = append(mock.calls.ListSessionsByResourceID, callInfo)
	mock.lockListSessionsByResourceID.Unlock()
	return mock.ListSessionsByResourceIDFunc(ctx, resourceType, resourceID, limit)
}

// ListSessionsByResourceIDCalls gets all the calls that were made to ListSessionsByResourceID.
// Check the length with:
//
//	len(mockedCapiClient.ListSessionsByResourceIDCalls())
func (mock *CapiClientMock) ListSessionsByResourceIDCalls() []struct {
	Ctx          context.Context
	ResourceType string
	ResourceID   int64
	Limit        int
} {
	var calls []struct {
		Ctx          context.Context
		ResourceType string
		ResourceID   int64
		Limit        int
	}
	mock.lockListSessionsByResourceID.RLock()
	calls = mock.calls.ListSessionsByResourceID
	mock.lockListSessionsByResourceID.RUnlock()
	return calls
}
