#include <winpr/crt.h>
#include <winpr/print.h>
#include <winpr/ssl.h>
#include <winpr/wlog.h>
#include <winpr/platform.h>

#include <freerdp/assistance.h>

static const char TEST_MSRC_INCIDENT_PASSWORD_TYPE1[] = "Password1";

static const char TEST_MSRC_INCIDENT_FILE_TYPE1[] =
    "<?xml version=\"1.0\" encoding=\"Unicode\" ?>"
    "<UPLOADINFO TYPE=\"Escalated\">"
    "<UPLOADDATA "
    "USERNAME=\"Administrator\" "
    "RCTICKET=\"65538,1,10.0.3.105:3389;winxpsp3.contoso3.com:3389,*,"
    "rb+v0oPmEISmi8N2zK/vuhgul/ABqlDt6wW0VxMyxK8=,*,*,IuaRySSbPDNna4+2mKcsKxsbJFI=\""
    "RCTICKETENCRYPTED=\"1\" "
    "DtStart=\"1314905741\" "
    "DtLength=\"180\" "
    "PassStub=\"RT=0PvIndan52*\" "
    "L=\"0\" />"
    "</UPLOADINFO>";

WINPR_PRAGMA_DIAG_PUSH
WINPR_PRAGMA_DIAG_IGNORED_UNUSED_CONST_VAR
static const BYTE TEST_MSRC_INCIDENT_EXPERT_BLOB_TYPE1[32] =
    "\x3C\x9C\xAE\x0B\xCE\x7A\xB1\x5C\x8A\xAC\x01\xD6\x76\x04\x5E\xDF"
    "\x3F\xFA\xF0\x92\xE2\xDE\x36\x8A\x20\x17\xE6\x8A\x0D\xED\x7C\x90";
WINPR_PRAGMA_DIAG_POP

static const char TEST_MSRC_INCIDENT_PASSWORD_TYPE2[] = "48BJQ853X3B4";

static const char TEST_MSRC_INCIDENT_FILE_TYPE2[] =
    "<?xml version=\"1.0\"?>"
    "<UPLOADINFO TYPE=\"Escalated\">"
    "<UPLOADDATA USERNAME=\"awake\" "
    "LHTICKET=\""
    "20FCC407AA53E95F8505AB56D485D26835064B03AF86CDA326248FD304626AD4"
    "DBDBDFFE0C473228EFFF7A1E6CEB445BBEC429294BB6616BBB600854438DDFB5"
    "82FC377CF65A2060EB3221647643C9B29BF5EC320856180B34D1BE9827A528C7"
    "E8F0DCD53C8D38F974160FEE317458FAC9DBDBA7B972D21DF3BC5B1AF0E01878"
    "65F07A3B915618C03E6EAF843FC1185770A1208C29C836DBCA5A040CB276D3C4"
    "1DDE2FA8CA9627E5E74FA750A92C0E01AD6C3D1000A5B1479DEB899BF5BCD402"
    "CE3BB3BF104CE0286C3F985AA711943C88C5EEEEE86F35B63F68883A90ADBCFD"
    "CBBAE3EAB993EFD9148E1A21D092CE9498695943946236D65D20B4A38D724C61"
    "72319E38E19C04E98EBC03F56A4A190E971F8EAEBFE6B415A3A2D8F35F7BF785"
    "26B9BFAAB48D11BDD6C905EFE503D2265678E1EAD2F2F124E570667F04103180"
    "2F63587276C14E6A5AB436CE234F722CE7C9B5D244508F14C012E84A49FE6992"
    "3F30320ABB3641F1EFA66205F3EA709E7E1C3E6874BB9642486FB96D2730CDF4"
    "514AA738167F00FC13B2978AED1D6678413FDF62008B03DD729E36173BE02742"
    "B69CAD44938512D0F56335394759338AF6ADBCF39CE829116D97435085D05BB5"
    "9320A134698050DCDBE01305A6B4712FD6BD48958BD2DC497498FF35CAECC9A8"
    "2C97FD1A5B5EC4BAF5FFB75A1471B765C465B35A7C950019066BB219B391C6E9"
    "8AE8FD2038E774F36F226D9FB9A38BCC313785612165D1EF69D19E2B9CF6E0F7"
    "FE1ECCF00AB81F9E8B626363CA82FAC719A3B7D243325C9D6042B2488EC95B80"
    "A31273FF9B72FBBB86F946E6D3DF8816BE4533F0B547C8BC028309EA9784C1E6\" "
    "RCTICKET=\"65538,1,192.168.1.200:49230;169.254.6.170:49231,*,"
    "+ULZ6ifjoCa6cGPMLQiGHRPwkg6VyJqGwxMnO6GcelwUh9a6/FBq3It5ADSndmLL,"
    "*,*,BNRjdu97DyczQSRuMRrDWoue+HA=\" "
    "PassStub=\"WB^6HsrIaFmEpi\" "
    "RCTICKETENCRYPTED=\"1\" "
    "DtStart=\"1403972263\" "
    "DtLength=\"14400\" "
    "L=\"0\"/>"
    "</UPLOADINFO>";

/**
 * Decrypted Connection String 2:
 *
 * <E>
 * <A KH="BNRjdu97DyczQSRuMRrDWoue+HA="
 * ID="+ULZ6ifjoCa6cGPMLQiGHRPwkg6VyJqGwxMnO6GcelwUh9a6/FBq3It5ADSndmLL"/> <C> <T ID="1" SID="0"> <L
 * P="49228" N="fe80::1032:53d9:5a01:909b%3"/> <L P="49229" N="fe80::3d8f:9b2d:6b4e:6aa%6"/> <L
 * P="49230" N="192.168.1.200"/> <L P="49231" N="169.254.6.170"/>
 * </T>
 * </C>
 * </E>
 */
static const char connectionstr2[] =
    "<E>\n"
    "<A KH=\"YiKwWUY8Ioq5NB3wAQHSbs5kwrM=\"\n"
    "KH2=\"sha256:wKSAkAV3sBfa9WpuRFJcP9q1twJc6wOBuoJ9tsyXwpk=\"\n"
    "ID=\"8rYm30RBW8/4dAWoUsWbFCF5jno/7jr5tNpHQc2goLbw4uuBBJvLsU02YYLlBMg5\"/>\n"
    "<C>\n"
    "<T ID=\"1\" SID=\"1440550163\">\n"
    "<L P=\"49749\" N=\"2001:4898:1a:5:79e2:3356:9b22:3470\"/>\n"
    "<L P=\"49751\" N=\"172.31.250.64\"/>\n"
    "</T>\n"
    "</C>\n"
    "</E>";

static const char* fail_tests[] = {
	"<UPLOADINFOTYPE=\"Escalated\"><UPLOADDATARCTICKET=\"65538,1, ,*,,*,*,\"/></UPLOADINFO>",
	"<UPLOADINFO>(E><UPLOADDATA  "
	"FOTYPE=\"Escalated\"æÁATAPassStub=\"␕:&A&amp;␅RCTICKET=\"65538,1,ü,*,n,*,*,\"am␡/>␂</"
	"UPLOADINFO>"
};

static const char connectionstr3[] =
    "<?xml version=\"1.0\"?>\n"
    "<UPLOADINFO TYPE=\"Escalated\"><UPLOADDATA USERNAME=\"fx\" "
    "LHTICKET="
    "\"F9BBA098D84E1B20E37CD0983D9336B1FF4929925FCE5F3A1A9B9A596A524F2E169AD26D84255C7E8C0B88304A4C"
    "40E0544624AD346A6828D6F2091C36C1315BD11255FE631F3A457F862FFD9948C496BC4B705B0AD2F26D0CDF7128E4"
    "8625C8C501326B33888D42C591434F7ED4BBA0CEE02C8554921E49BCF130E1961F38FD0F0B7333001E639F89471940"
    "93136CA5030EC4A92D05341488B79C40E11B28E1753F38682816EDF756CF5204943FD3F60DDD16416D220CA162B6FB"
    "D43CC00C4F9D3F9FCF68ADAF191470B75EA4E8B37D03D2B9D3D844F54597D75FFF0A6216811518A3D06B26CA95F733"
    "CCE8A46A4B1FF8F514971A1C06A8DC9D1DD0863087707045D3FCB74BB0444AF8B822FD6605DA68D8D628A7D8556212"
    "D10F5BC4B1B7905E863F51346114FFED6A46D67314F3B933DF17F8A2E5EC6DAD2904349AC710E017652171A98C8621"
    "4AF3801B1441E641CDA159BE76D8F2415129773283B5A4E0E7483580E6955B54B0E1432129612CFECD6770201F4206"
    "1732E748B7F8A0C015EA8B36610962AC208C26373A483E830C7E01330492C9CBAB308A5E19272CC06F0F8008068816"
    "78F8FB32667D876F6060C50D1A1251DDB9B339E2F846F48C0C7751BBDFF2138152B7A048AFECB31F6DE340E81EB8A4"
    "EC7F8208B81E11E13033659B885686FEDF6881355679DCD96661201E5BC59D6C6EEFA1608B9E73E75F42D51A26E236"
    "3690714D58A846B48E0AA2C753CA6347BAEA59CDCA5144527F3A69B560980BCC5DB77AC0FD1A68D19F802744D723D8"
    "6595A48D1F72DAD0E3E61BA4D37E24EAAB9F49F21753CD481D6744036CA49DA0E432B961F48810FE90EB49DB0FB450"
    "5FB316DCCAAC51E647B333EBA1C219A68F0A08BD65C9E4ED231D40EA15C2CEB80CB161495A0CADECAF2A00B5916AA9"
    "91B78C7B17F26DA880DE25DFC09D9D823E174A8401CBC846D2A8B29B6B26EE92261C71C37E3C816540F77CB6DE916B"
    "FCC7ED100949503251687B860E4A5F5B51CDADD11FF5CA408FA38E4A2AD6FA09D10E9B85523236D55132CD42936150"
    "51913820DAE06877AC2954651049A157730A1AB67BD9A258CCB3A71909A8686F6F742FBC55312B041342C5475F808A"
    "B04B629B99A1C69200740CDA5FE1602518B3117FB9835060BEF22EBAF20676662C9E0C3ED39C01E2F9A0822A2ADA07"
    "D4718A93516AA04E4527C699A00FA8AFCAC7337F8D42949B3CB9F35A19BF5AC9BBF412C9E4AE82C593897BFF81240C"
    "002486DF0F14845BB12A15966E95A9B6090C6512AF8B717F720F0CE452AA602106B65B98374CBCF9F6B5300FB077E5"
    "554B489F6913E3857E352C94929A69C86EB13A67B872BB69980B9B3A1E05D6B9483C26A0D6D83CCD4C1AB6C21BA625"
    "A5232C25BC1B7EB8B954B52D91B1BDF4277B2DCE039F4DBE2F18AE22533C2B877AB27B157ACE5DF21BC83E72104A31"
    "C253704FDB2536308280D7172313F5D19D088E4C7F4F79C4786D6C65DEAB7FC16DE107AF8C61626502FA940497987F"
    "60759878E40EDFAC98DED90BEA26E3020AA36A7307F2C9A9D5B19FAA34DF3633F643425F16A3615C996691EC705617"
    "97CEB08463CBD0150F6B4C01BF1337E3B8B5E5355F62AD1AF949FCB3671327EA5AABC90081117E6CE11C6C42CF6E0E"
    "DCB4C63EA9433D89F1030F65EDC82D45289C6367BF1E004D338CED13B7643C8708C42FF3671377A79DBFE3E4A39E19"
    "F4759B84AA9CB03D64C2DBF5D2908DE64F5534AC07C11723F3A7602E307625F86B410BC7B54D85145B9F362E181860"
    "AEF3574682CE4F3C57742870ED0B228CAC0E9183BD07BFF0435989263CA7EBF21B8CF25DBC2C7915FEB1000848A52F"
    "94E7B34A416A826BFB1792E64F1CEA7FA3222131C53FA6DE38A786C99C355FE9C9D55B91D11B19087F1574CFF28C4D"
    "AA9DE974A0939F0C13E9C408167ABAB90BD6BB25FA37B1588AAA3687AC86818543FEFD6E46D821D7F68BE1B0793585"
    "4E7A81F6C9A0965159DAFF7B0E79C89A18DA3C52D6259EA711ED6B85CCC207AA35F62CB5D48299DAD003004702716E"
    "65A96390033F8006FC7E7B1A09B9D1C6C17EC20811DE09EC19EB36844E45FCA18CF657A81E5922AB1B805721A5457E"
    "01EB86334877FEDA378EDE6190491015158194ED1DEE3A99770DB8B9A87BC9FAE29A0AC17C4963DF07109B05AABA73"
    "1A6AACDB8A02795CBDA935D51D0A7ABB35D8D1B6E598751E45BD507EC2778E285BEBAB2B50462FED1975B5A87F9751"
    "25A6F272560E756CC941CF6D22FE72F7563CB2687E56F2FA2FC07FE01F3C8E6FCF7D4ECD60C1A53B98CA57AFB5BA18"
    "97D4F530FCDEBDEB015D9CB1DE0BED20B7C3221283E292C252C742C23401B2E5A85EBD63E6916C3051FEAA1DC57975"
    "410487AD7EE6CA0A346FE44F901E8BA81A7B398E94707E094081AE6391696EC42DD3F4B9189AB2A5311811481A48FB"
    "0FAEFC1E9858547D15AA2F6FF01191F8EEC3564C59172605DA16C94F466156BE7A3E98E8C53BE50B671DEC5A3BD8A9"
    "8C2A1B3FF47D27007AB17A4A1E155E094E3EA30FF531FBF6320F23BA57B3CAF8C470E176C93FACEE829C58B2399975"
    "EBC4688B2F55132D102E83E45976C6607A57B90F43A33BCB68C03671E632B0E7C17B18406161AB46A8A0992DA7046A"
    "08135E04142B68312BE3D0F7F5BBAE914E8DC5AAD04D992DA18FAB5B01EA34A0E27B253E92BEFE607578B1C79D4DAC"
    "07DA6F92986F12AE036C227E4495662C46762E66EA3EC71C5C04BADD9DEDCAD725C16710825394179CFD17EDE482BA"
    "11C421D0B4C806A2ED963831FAB4DE14FEAA904A3C5173AB9B86FCFF81E0F60DB45182A2471BC16DA992553EAE99DD"
    "716E85DB11AC0F32BC960D6E8F6BE2250D59EDCAA69C19AF04E21362331225F94BD600EE76E1719417480AB6DC62DF"
    "958DCCE951EBC64B4600DF3A826B9E702C536C0DF9E2952EDA7FAE6076C6F25CF41C0F7751768EC3C3293D727F8541"
    "E997DA23E2D952D782B0472B3BFBC638CBDFDA43F367E3F6A7AAC9C8B07D51459432AEBB11564A669BF2EC1658B361"
    "BE29B47F905352D13705E1E7F06B68A5F247B9FFA3B917CC54F7367386502A42F32CEE474F5E4D35CB5A44C3BA2192"
    "A3F61DC334CE6D91E36D1C891E65A30C1E2B8F66A01B5DA8DDFB5CD051D61BD39B2E0516C6715F9AA7FE262BBD9BA4"
    "CE8B785B42CA9582AD5EE24F8C11D2DA0DC6383506DE46C5187C03A930E5E507812A505884121C8A93C2569B269AE7"
    "A26FDCF0BF7FA996250FFF790C3E97565B27C8DECFE5A15E2ED1A853FBF5D12207B8D3564CDD99549E508E92CB53DB"
    "F6356F6EBF03E6A6672BFDE285A3DF84105F7C7E39577838C06B50D2ABB4F1C0377D45BE016ED022804F6BD9151BCD"
    "883CE5FE8358798EE4EA3C24C67815D535CBCFA36094D7418EC104F90609C7AC008D07FDF89A6B3A0B5EC505E17DEC"
    "57DA6256F4B2CC7DFF4E643FE89E4934440E2A360F035FA9C91F0F657A88AC9E7210A9ABAAAEA26D6B717EEAF231FB"
    "79A0838B4BB85C11C9675F2BC746230F79A88137F911809C472750A5F6BB9415298C638FC3E24FA1763ACB513A4200"
    "CB0BF550BC7DE0D2DC5D45AF18FF6073D96D2E4368A637B78257D087C9A471CC88E3368E810BFC29002D86C898F75D"
    "3F6AE13648841038FDD1D3E8C4D2D5A4E1044614CAF544758A68F4947E3A3E736255CF01FE7A40A6FF136E7458F13D"
    "759086A544FA14B47155511F784A2144E2B139EC5B5F3B0CAB52E511AAF84E00ABB4115644D42B0A7F91DA53F5C54D"
    "744C583F5E838D402512A9644772E256CACCAA90ED300AE1616FDAA8309E5FB3FD92EB09F32216446CA2E737E8C136"
    "C3E773FB986060A78D87CDF7CD92B187188CA7293998F0BC33C13A2FD8C7B0A76C2DAA662F0A71965E25930294D351"
    "947DDE4800A237871F6BBFA77B7440339BFAE36035A84DA6AD87AA57FD52F7CDA342EB3D7B3E46F64592DFF327194C"
    "D80C83272B5159BD97A9254089C90E1AFC7C30265BA814ED485550E4E4157FEDB14D9FB6D05AEE5983C81E799DF134"
    "00766571BDBC8AC719AA2228C9DD592C102DE18A3F1C4B3501C6B29424B83B71D1740B1775967CFC984BC2D22C15\""
    " PassStub=\"e4=3CiFuM6h2qH\" RCTICKETENCRYPTED=\"1\" DtStart=\"1704288424\" DtLength=\"360\" "
    "L=\"0\"/>"
    "</UPLOADINFO>";
static const char connectionpwd3[] = "4X638PTVZTKZ";

static BOOL run_test_parse(wLog* log, const char* input, size_t len, const char* password,
                           BOOL expect)
{
	rdpAssistanceFile* file = freerdp_assistance_file_new();
	if (!file)
		return FALSE;

	const int status = freerdp_assistance_parse_file_buffer(file, input, len, password);
	const BOOL success = status >= 0;

	freerdp_assistance_print_file(file, log, WLOG_INFO);
	freerdp_assistance_file_free(file);
	return success == expect;
}

static BOOL test_file_to_settings(wLog* log, rdpAssistanceFile* file)
{
	rdpSettings* settings = freerdp_settings_new(0);
	if (!settings)
		return FALSE;
	const BOOL rc = freerdp_assistance_populate_settings_from_assistance_file(file, settings);
	freerdp_settings_free(settings);
	return rc;
}

static BOOL test_file_from_buffer(wLog* log, const char* data, size_t size, const char* pwd)
{
	BOOL rc = FALSE;
	int status = 0;
	char* pass = NULL;
	char* expertBlob = NULL;
	const char* EncryptedPassStub = NULL;
	size_t EncryptedPassStubLength = 0;
	rdpAssistanceFile* file = freerdp_assistance_file_new();

	if (!file)
		return FALSE;

	status = freerdp_assistance_parse_file_buffer(file, data, size, pwd);
	WLog_Print(log, WLOG_INFO, "freerdp_assistance_parse_file_buffer: %d", status);

	if (status < 0)
		goto fail;

	freerdp_assistance_print_file(file, WLog_Get("foo"), WLOG_INFO);

	if (!freerdp_assistance_get_encrypted_pass_stub(file, &EncryptedPassStub,
	                                                &EncryptedPassStubLength))
		goto fail;

	if (EncryptedPassStubLength > 0)
	{
		pass = freerdp_assistance_bin_to_hex_string(EncryptedPassStub, EncryptedPassStubLength);

		if (!pass)
			goto fail;

		WLog_Print(log, WLOG_INFO, "freerdp_assistance_decrypt: %d %s [%" PRIdz "]", status, pass,
		           EncryptedPassStubLength);
		expertBlob = freerdp_assistance_construct_expert_blob("Edgar Olougouna", pass);

		WLog_Print(log, WLOG_INFO, "expertBlob='%s'", expertBlob);
	}
	rc = test_file_to_settings(log, file);
fail:
	freerdp_assistance_file_free(file);
	free(pass);
	free(expertBlob);
	return rc;
}

static BOOL test_msrsc_incident_file_type1(wLog* log)
{
	return test_file_from_buffer(log, TEST_MSRC_INCIDENT_FILE_TYPE1,
	                             sizeof(TEST_MSRC_INCIDENT_FILE_TYPE1),
	                             TEST_MSRC_INCIDENT_PASSWORD_TYPE1);
}

static BOOL test_msrsc_incident_file_type2(wLog* log)
{
	if (!test_file_from_buffer(log, connectionstr2, sizeof(connectionstr2),
	                           TEST_MSRC_INCIDENT_PASSWORD_TYPE2))
		return FALSE;
	if (!test_file_from_buffer(log, connectionstr3, sizeof(connectionstr3), connectionpwd3))
		return FALSE;
	if (!test_file_from_buffer(log, TEST_MSRC_INCIDENT_FILE_TYPE2,
	                           sizeof(TEST_MSRC_INCIDENT_FILE_TYPE2),
	                           TEST_MSRC_INCIDENT_PASSWORD_TYPE2))
		return FALSE;
	return TRUE;
}

int TestCommonAssistance(int argc, char* argv[])
{
	wLog* log = NULL;
	WINPR_UNUSED(argc);
	WINPR_UNUSED(argv);
	log = WLog_Get(__func__);
	winpr_InitializeSSL(WINPR_SSL_INIT_DEFAULT);

	for (size_t x = 0; x < ARRAYSIZE(fail_tests); x++)
	{
		const char* test = fail_tests[x];
		const size_t len = strlen(test);

		if (!run_test_parse(log, test, len + 1, NULL, FALSE))
			return -1;
	}

	if (!test_msrsc_incident_file_type1(log))
	{
		WLog_Print(log, WLOG_ERROR, "test_msrsc_incident_file_type1 failed");
		return -1;
	}

	if (!test_msrsc_incident_file_type2(log))
	{
		WLog_Print(log, WLOG_ERROR, "test_msrsc_incident_file_type2 failed");
		return -1;
	}

	return 0;
}
