/** \file wxstreectrl.h
*
* This file is part of wxSmith plugin for Code::Blocks Studio
* Copyright (C) 2006-2007  Bartlomiej Swiecki
*
* wxSmith is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 3 of the License, or
* (at your option) any later version.
*
* wxSmith is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with wxSmith. If not, see <http://www.gnu.org/licenses/>.
*
* $Revision: 8148 $
* $Id: wxstreectrl.h 8148 2012-07-19 19:50:28Z mortenmacfly $
* $HeadURL: svn://svn.code.sf.net/p/codeblocks/code/trunk/src/plugins/contrib/wxSmith/wxwidgets/defitems/wxstreectrl.h $
*/

#ifndef WXSTREECTRL_H
#define WXSTREECTRL_H

#include "../wxswidget.h"

/** \brief Class for wxsTreeCtrl widget */
class wxsTreeCtrl: public wxsWidget
{
    public:

        wxsTreeCtrl(wxsItemResData* Data);

    private:

        virtual void OnBuildCreatingCode();
        virtual wxObject* OnBuildPreview(wxWindow* Parent,long Flags);
        virtual void OnEnumWidgetProperties(long Flags);
        void FindAllImageLists(wxArrayString &aNames);
        void UpdateTreeItemList(void);

        wxArrayString    m_arrItems;            //!< Individual items for the tree control.
        wxString            m_sImageList;    //!< The name of the image list to use for images.
        wxImageList        m_imageList;        //!< The image list.
        bool                    m_bExpand;            //!< Start with everything expanded?

};

#endif
