;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.

;; As in monomorphize-types.wast, test in both "always" mode, which always
;; monomorphizes, and in "careful" mode which does it only when it appears to
;; actually help.

;; This file specifically tests that we optimize constants in MVP mode (most
;; of the pass benefits from other features, but we should still do work in
;; MVP).

;; RUN: foreach %s %t wasm-opt --monomorphize-always -S -o - | filecheck %s --check-prefix ALWAYS
;; RUN: foreach %s %t wasm-opt --monomorphize        -S -o - | filecheck %s --check-prefix CAREFUL

(module
  ;; ALWAYS:      (type $0 (func (param i32) (result i32)))

  ;; ALWAYS:      (type $1 (func (param i32 i32) (result i32)))

  ;; ALWAYS:      (func $call (param $x i32) (result i32)
  ;; ALWAYS-NEXT:  (call $target_2
  ;; ALWAYS-NEXT:   (local.get $x)
  ;; ALWAYS-NEXT:  )
  ;; ALWAYS-NEXT: )
  ;; CAREFUL:      (type $0 (func (param i32) (result i32)))

  ;; CAREFUL:      (type $1 (func (param i32 i32) (result i32)))

  ;; CAREFUL:      (func $call (param $x i32) (result i32)
  ;; CAREFUL-NEXT:  (call $target_2
  ;; CAREFUL-NEXT:   (local.get $x)
  ;; CAREFUL-NEXT:  )
  ;; CAREFUL-NEXT: )
  (func $call (param $x i32) (result i32)
    ;; The second parameter can be monomorphized.
    (call $target
      (local.get $x)
      (i32.const 1)
    )
  )

  ;; ALWAYS:      (func $target (param $x i32) (param $y i32) (result i32)
  ;; ALWAYS-NEXT:  (select
  ;; ALWAYS-NEXT:   (local.get $x)
  ;; ALWAYS-NEXT:   (i32.const 42)
  ;; ALWAYS-NEXT:   (local.get $y)
  ;; ALWAYS-NEXT:  )
  ;; ALWAYS-NEXT: )
  ;; CAREFUL:      (func $target (param $0 i32) (param $1 i32) (result i32)
  ;; CAREFUL-NEXT:  (select
  ;; CAREFUL-NEXT:   (local.get $0)
  ;; CAREFUL-NEXT:   (i32.const 42)
  ;; CAREFUL-NEXT:   (local.get $1)
  ;; CAREFUL-NEXT:  )
  ;; CAREFUL-NEXT: )
  (func $target (param $x i32) (param $y i32) (result i32)
    ;; The monomorphized copies of this function will be able to remove the
    ;; select, in CAREFUL (which optimizes).
    (select
      (local.get $x)
      (i32.const 42)
      (local.get $y)
    )
  )
)

;; ALWAYS:      (func $target_2 (param $0 i32) (result i32)
;; ALWAYS-NEXT:  (local $x i32)
;; ALWAYS-NEXT:  (local $y i32)
;; ALWAYS-NEXT:  (local.set $x
;; ALWAYS-NEXT:   (local.get $0)
;; ALWAYS-NEXT:  )
;; ALWAYS-NEXT:  (local.set $y
;; ALWAYS-NEXT:   (i32.const 1)
;; ALWAYS-NEXT:  )
;; ALWAYS-NEXT:  (select
;; ALWAYS-NEXT:   (local.get $x)
;; ALWAYS-NEXT:   (i32.const 42)
;; ALWAYS-NEXT:   (local.get $y)
;; ALWAYS-NEXT:  )
;; ALWAYS-NEXT: )

;; CAREFUL:      (func $target_2 (param $0 i32) (result i32)
;; CAREFUL-NEXT:  (local.get $0)
;; CAREFUL-NEXT: )
