;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.

;; RUN: wasm-split %s --split-funcs=second-in-table -g -o1 %t.1.wasm -o2 %t.2.wasm -all
;; RUN: wasm-dis %t.1.wasm | filecheck %s --check-prefix PRIMARY
;; RUN: wasm-dis %t.2.wasm | filecheck %s --check-prefix SECONDARY

(module
 (type $func-array (array (mut funcref)))

 ;; PRIMARY:      (type $0 (func))

 ;; PRIMARY:      (import "placeholder" "0" (func $placeholder_0))

 ;; PRIMARY:      (table $table 3 funcref)
 (table $table 3 funcref)

 ;; Workaround for https://github.com/WebAssembly/binaryen/issues/6572 - we
 ;; error without an active segment.
 (elem (i32.const 0))

 ;; PRIMARY:      (elem $0 (i32.const 0) $placeholder_0)

 ;; PRIMARY:      (elem $passive func $in-table $1)
 (elem $passive func $in-table $second-in-table)

 ;; PRIMARY:      (export "table" (table $table))

 ;; PRIMARY:      (func $in-table
 ;; PRIMARY-NEXT:  (nop)
 ;; PRIMARY-NEXT: )
 (func $in-table
  ;; This is in a passive segment, but it is in the main module so we need no
  ;; special handling.
 )

 ;; SECONDARY:      (type $0 (func))

 ;; SECONDARY:      (import "primary" "table" (table $table 3 funcref))

 ;; SECONDARY:      (elem $0 (i32.const 0) $second-in-table)

 ;; SECONDARY:      (func $second-in-table
 ;; SECONDARY-NEXT:  (nop)
 ;; SECONDARY-NEXT: )
 (func $second-in-table
  ;; This is in a passive segment, and it is in the secondary module, so we will
  ;; handle it by adding a trampoline from the segment as a new function "$1".
 )
)
;; PRIMARY:      (func $1
;; PRIMARY-NEXT:  (call_indirect (type $0)
;; PRIMARY-NEXT:   (i32.const 0)
;; PRIMARY-NEXT:  )
;; PRIMARY-NEXT: )
