import ast
from _typeshed import Incomplete

class DecompileError(NotImplementedError): ...

ast_cache: dict[int, tuple[Incomplete | None, set[Incomplete]]]

def decompile(x): ...
def simplify(clause): ...

class InvalidQuery(Exception): ...

def binop(node_type): ...

operator_mapping: dict[str, type[ast.cmpop]]

def clean_assign(node): ...
def make_const(value): ...
def is_const(value) -> bool: ...
def unwrap_str(key) -> str: ...

class Decompiler:
    def __init__(decompiler, code, start: int = 0, end=None) -> None: ...
    def get_instructions(decompiler) -> None: ...
    def analyze_jumps(decompiler) -> None: ...
    def decompile(decompiler) -> None: ...
    def pop_items(decompiler, size): ...
    def store(decompiler, node) -> None: ...
    BINARY_POWER: Incomplete
    BINARY_MULTIPLY: Incomplete
    BINARY_DIVIDE: Incomplete
    BINARY_FLOOR_DIVIDE: Incomplete
    BINARY_ADD: Incomplete
    BINARY_SUBTRACT: Incomplete
    BINARY_LSHIFT: Incomplete
    BINARY_RSHIFT: Incomplete
    BINARY_AND: Incomplete
    BINARY_XOR: Incomplete
    BINARY_OR: Incomplete
    BINARY_TRUE_DIVIDE = BINARY_DIVIDE
    BINARY_MODULO: Incomplete
    def BINARY_OP(decompiler, opcode): ...
    def BINARY_SLICE(decompiler): ...
    def BINARY_SUBSCR(decompiler): ...
    def BUILD_CONST_KEY_MAP(decompiler, length): ...
    def BUILD_LIST(decompiler, size): ...
    def BUILD_MAP(decompiler, length): ...
    def BUILD_SET(decompiler, size): ...
    def BUILD_SLICE(decompiler, size): ...
    def BUILD_TUPLE(decompiler, size): ...
    def BUILD_STRING(decompiler, count): ...
    def CALL_FUNCTION(decompiler, argc, star=None, star2=None): ...
    def CACHE(decompiler) -> None: ...
    def CALL(decompiler, argc): ...
    def CALL_FUNCTION_VAR(decompiler, argc): ...
    def CALL_FUNCTION_KW(decompiler, argc): ...
    def CALL_FUNCTION_VAR_KW(decompiler, argc): ...
    def CALL_FUNCTION_EX(decompiler, argc): ...
    def CALL_METHOD(decompiler, argc): ...
    def COMPARE_OP(decompiler, op): ...
    def COPY(decompiler, _) -> None: ...
    def COPY_FREE_VARS(decompiler, n) -> None: ...
    def CONTAINS_OP(decompiler, invert): ...
    def DUP_TOP(decompiler): ...
    def FOR_ITER(decompiler, endpos): ...
    def FORMAT_VALUE(decompiler, flags): ...
    def GEN_START(decompiler, kind) -> None: ...
    def GET_ITER(decompiler) -> None: ...
    def JUMP_IF_FALSE(decompiler, endpos): ...
    JUMP_IF_FALSE_OR_POP = JUMP_IF_FALSE
    def JUMP_IF_NOT_EXC_MATCH(decompiler, endpos) -> None: ...
    def JUMP_IF_TRUE(decompiler, endpos): ...
    JUMP_IF_TRUE_OR_POP = JUMP_IF_TRUE
    def conditional_jump(decompiler, endpos, if_true): ...
    def conditional_jump_old(decompiler, endpos, if_true): ...
    def conditional_jump_new(decompiler, endpos, if_true): ...
    def conditional_jump_none_impl(decompiler, endpos, negate): ...
    def jump_if_none(decompiler, endpos): ...
    def jump_if_not_none(decompiler, endpos): ...
    def process_target(decompiler, pos, partial: bool = False) -> None: ...
    def JUMP_FORWARD(decompiler, endpos): ...
    def KW_NAMES(decompiler, kw_names) -> None: ...
    def IS_OP(decompiler, invert): ...
    def LIST_APPEND(decompiler, offset) -> None: ...
    def LIST_EXTEND(decompiler, offset): ...
    def LIST_TO_TUPLE(decompiler): ...
    def LOAD_ATTR(decompiler, attr_name, push_null): ...
    def LOAD_CLOSURE(decompiler, freevar): ...
    def LOAD_CONST(decompiler, const_value): ...
    def LOAD_DEREF(decompiler, freevar): ...
    def LOAD_FAST(decompiler, varname): ...
    LOAD_FAST_AND_CLEAR = LOAD_FAST
    def LOAD_GLOBAL(decompiler, varname, push_null): ...
    def LOAD_METHOD(decompiler, methname): ...
    LOOKUP_METHOD = LOAD_METHOD
    def LOAD_NAME(decompiler, varname): ...
    def MAKE_CELL(decompiler, freevar) -> None: ...
    def MAKE_CLOSURE(decompiler, argc): ...
    def MAKE_FUNCTION(decompiler, argc): ...
    POP_JUMP_BACKWARD_IF_FALSE = JUMP_IF_FALSE
    POP_JUMP_BACKWARD_IF_TRUE = JUMP_IF_TRUE
    POP_JUMP_FORWARD_IF_FALSE = JUMP_IF_FALSE
    POP_JUMP_FORWARD_IF_TRUE = JUMP_IF_TRUE
    POP_JUMP_IF_FALSE = JUMP_IF_FALSE
    POP_JUMP_IF_TRUE = JUMP_IF_TRUE
    POP_JUMP_BACKWARD_IF_NONE = jump_if_none
    POP_JUMP_BACKWARD_IF_NOT_NONE = jump_if_not_none
    POP_JUMP_FORWARD_IF_NONE = jump_if_none
    POP_JUMP_FORWARD_IF_NOT_NONE = jump_if_not_none
    def POP_TOP(decompiler) -> None: ...
    def PRECALL(decompiler, argc) -> None: ...
    def PUSH_NULL(decompiler) -> None: ...
    def RETURN_VALUE(decompiler): ...
    def RETURN_CONST(decompiler, val): ...
    def RETURN_GENERATOR(decompiler) -> None: ...
    def RESUME(decompiler, where) -> None: ...
    def ROT_TWO(decompiler) -> None: ...
    def ROT_THREE(decompiler) -> None: ...
    def SETUP_LOOP(decompiler, endpos) -> None: ...
    def STORE_ATTR(decompiler, attrname) -> None: ...
    def STORE_DEREF(decompiler, freevar) -> None: ...
    def STORE_FAST(decompiler, varname) -> None: ...
    def STORE_MAP(decompiler) -> None: ...
    def STORE_SUBSCR(decompiler) -> None: ...
    def SWAP(decompiler, _) -> None: ...
    def UNARY_POSITIVE(decompiler): ...
    def UNARY_NEGATIVE(decompiler): ...
    def UNARY_NOT(decompiler): ...
    def UNARY_INVERT(decompiler): ...
    def UNPACK_SEQUENCE(decompiler, count): ...
    def YIELD_VALUE(decompiler, _=None): ...

test_lines: str

def test(test_line=None) -> None: ...
