﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/bedrock-agent/model/CustomDocumentIdentifier.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace BedrockAgent
{
namespace Model
{

CustomDocumentIdentifier::CustomDocumentIdentifier() : 
    m_idHasBeenSet(false)
{
}

CustomDocumentIdentifier::CustomDocumentIdentifier(JsonView jsonValue)
  : CustomDocumentIdentifier()
{
  *this = jsonValue;
}

CustomDocumentIdentifier& CustomDocumentIdentifier::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("id"))
  {
    m_id = jsonValue.GetString("id");

    m_idHasBeenSet = true;
  }

  return *this;
}

JsonValue CustomDocumentIdentifier::Jsonize() const
{
  JsonValue payload;

  if(m_idHasBeenSet)
  {
   payload.WithString("id", m_id);

  }

  return payload;
}

} // namespace Model
} // namespace BedrockAgent
} // namespace Aws
