﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/bedrock-runtime/BedrockRuntime_EXPORTS.h>
#include <aws/bedrock-runtime/model/ConverseOutput.h>
#include <aws/bedrock-runtime/model/StopReason.h>
#include <aws/bedrock-runtime/model/TokenUsage.h>
#include <aws/bedrock-runtime/model/ConverseMetrics.h>
#include <aws/core/utils/Document.h>
#include <aws/bedrock-runtime/model/ConverseTrace.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace BedrockRuntime
{
namespace Model
{
  class ConverseResult
  {
  public:
    AWS_BEDROCKRUNTIME_API ConverseResult();
    AWS_BEDROCKRUNTIME_API ConverseResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_BEDROCKRUNTIME_API ConverseResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>The result from the call to <code>Converse</code>.</p>
     */
    inline const ConverseOutput& GetOutput() const{ return m_output; }
    inline void SetOutput(const ConverseOutput& value) { m_output = value; }
    inline void SetOutput(ConverseOutput&& value) { m_output = std::move(value); }
    inline ConverseResult& WithOutput(const ConverseOutput& value) { SetOutput(value); return *this;}
    inline ConverseResult& WithOutput(ConverseOutput&& value) { SetOutput(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The reason why the model stopped generating output.</p>
     */
    inline const StopReason& GetStopReason() const{ return m_stopReason; }
    inline void SetStopReason(const StopReason& value) { m_stopReason = value; }
    inline void SetStopReason(StopReason&& value) { m_stopReason = std::move(value); }
    inline ConverseResult& WithStopReason(const StopReason& value) { SetStopReason(value); return *this;}
    inline ConverseResult& WithStopReason(StopReason&& value) { SetStopReason(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The total number of tokens used in the call to <code>Converse</code>. The
     * total includes the tokens input to the model and the tokens generated by the
     * model.</p>
     */
    inline const TokenUsage& GetUsage() const{ return m_usage; }
    inline void SetUsage(const TokenUsage& value) { m_usage = value; }
    inline void SetUsage(TokenUsage&& value) { m_usage = std::move(value); }
    inline ConverseResult& WithUsage(const TokenUsage& value) { SetUsage(value); return *this;}
    inline ConverseResult& WithUsage(TokenUsage&& value) { SetUsage(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>Metrics for the call to <code>Converse</code>.</p>
     */
    inline const ConverseMetrics& GetMetrics() const{ return m_metrics; }
    inline void SetMetrics(const ConverseMetrics& value) { m_metrics = value; }
    inline void SetMetrics(ConverseMetrics&& value) { m_metrics = std::move(value); }
    inline ConverseResult& WithMetrics(const ConverseMetrics& value) { SetMetrics(value); return *this;}
    inline ConverseResult& WithMetrics(ConverseMetrics&& value) { SetMetrics(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>Additional fields in the response that are unique to the model. </p>
     */
    inline Aws::Utils::DocumentView GetAdditionalModelResponseFields() const{ return m_additionalModelResponseFields; }
    inline void SetAdditionalModelResponseFields(const Aws::Utils::Document& value) { m_additionalModelResponseFields = value; }
    inline void SetAdditionalModelResponseFields(Aws::Utils::Document&& value) { m_additionalModelResponseFields = std::move(value); }
    inline ConverseResult& WithAdditionalModelResponseFields(const Aws::Utils::Document& value) { SetAdditionalModelResponseFields(value); return *this;}
    inline ConverseResult& WithAdditionalModelResponseFields(Aws::Utils::Document&& value) { SetAdditionalModelResponseFields(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>A trace object that contains information about the Guardrail behavior.</p>
     */
    inline const ConverseTrace& GetTrace() const{ return m_trace; }
    inline void SetTrace(const ConverseTrace& value) { m_trace = value; }
    inline void SetTrace(ConverseTrace&& value) { m_trace = std::move(value); }
    inline ConverseResult& WithTrace(const ConverseTrace& value) { SetTrace(value); return *this;}
    inline ConverseResult& WithTrace(ConverseTrace&& value) { SetTrace(std::move(value)); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline ConverseResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline ConverseResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline ConverseResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    ConverseOutput m_output;

    StopReason m_stopReason;

    TokenUsage m_usage;

    ConverseMetrics m_metrics;

    Aws::Utils::Document m_additionalModelResponseFields;

    ConverseTrace m_trace;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace BedrockRuntime
} // namespace Aws
