﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/bedrock-agent/model/KnowledgeBaseState.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>

using namespace Aws::Utils;


namespace Aws
{
  namespace BedrockAgent
  {
    namespace Model
    {
      namespace KnowledgeBaseStateMapper
      {

        static const int ENABLED_HASH = HashingUtils::HashString("ENABLED");
        static const int DISABLED_HASH = HashingUtils::HashString("DISABLED");


        KnowledgeBaseState GetKnowledgeBaseStateForName(const Aws::String& name)
        {
          int hashCode = HashingUtils::HashString(name.c_str());
          if (hashCode == ENABLED_HASH)
          {
            return KnowledgeBaseState::ENABLED;
          }
          else if (hashCode == DISABLED_HASH)
          {
            return KnowledgeBaseState::DISABLED;
          }
          EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
          if(overflowContainer)
          {
            overflowContainer->StoreOverflow(hashCode, name);
            return static_cast<KnowledgeBaseState>(hashCode);
          }

          return KnowledgeBaseState::NOT_SET;
        }

        Aws::String GetNameForKnowledgeBaseState(KnowledgeBaseState enumValue)
        {
          switch(enumValue)
          {
          case KnowledgeBaseState::NOT_SET:
            return {};
          case KnowledgeBaseState::ENABLED:
            return "ENABLED";
          case KnowledgeBaseState::DISABLED:
            return "DISABLED";
          default:
            EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
            if(overflowContainer)
            {
              return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
            }

            return {};
          }
        }

      } // namespace KnowledgeBaseStateMapper
    } // namespace Model
  } // namespace BedrockAgent
} // namespace Aws
