﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/apptest/model/ListTestRunsRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/http/URI.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::AppTest::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws::Http;

ListTestRunsRequest::ListTestRunsRequest() : 
    m_testSuiteIdHasBeenSet(false),
    m_testRunIdsHasBeenSet(false),
    m_nextTokenHasBeenSet(false),
    m_maxResults(0),
    m_maxResultsHasBeenSet(false)
{
}

Aws::String ListTestRunsRequest::SerializePayload() const
{
  return {};
}

void ListTestRunsRequest::AddQueryStringParameters(URI& uri) const
{
    Aws::StringStream ss;
    if(m_testSuiteIdHasBeenSet)
    {
      ss << m_testSuiteId;
      uri.AddQueryStringParameter("testSuiteId", ss.str());
      ss.str("");
    }

    if(m_testRunIdsHasBeenSet)
    {
      for(const auto& item : m_testRunIds)
      {
        ss << item;
        uri.AddQueryStringParameter("testrunIds", ss.str());
        ss.str("");
      }
    }

    if(m_nextTokenHasBeenSet)
    {
      ss << m_nextToken;
      uri.AddQueryStringParameter("nextToken", ss.str());
      ss.str("");
    }

    if(m_maxResultsHasBeenSet)
    {
      ss << m_maxResults;
      uri.AddQueryStringParameter("maxResults", ss.str());
      ss.str("");
    }

}



