#ifndef ABINIT_CONFIG_H
#define ABINIT_CONFIG_H 1

/* config.h.  Generated from config.h.cmake by cmake.  */

/* Note: all symbols defined here, are listed in alphabetical order. */

/* Just explicitely state we are building with cmake */
#cmakedefine BUILD_WITH_CMAKE 1

#ifdef __INTEL_COMPILER
#define FC_INTEL 1
#endif

#ifdef __NVCOMPILER
#define FC_NVHPC 1
#endif

/* Abinit target description. */
#cmakedefine ABINIT_TARGET "@ABINIT_TARGET@"

/* Abinit whole version number. */
#cmakedefine ABINIT_VERSION "@ABINIT_VERSION@"

/* Abinit base version number. */
#cmakedefine ABINIT_VERSION_BASE "@ABINIT_VERSION_BASE@"

/* Abinit build date. */
#cmakedefine ABINIT_VERSION_BUILD "@ABINIT_VERSION_BUILD@"

/* Abinit major version number. */
#cmakedefine ABINIT_VERSION_MAJOR "@ABINIT_VERSION_MAJOR@"

/* Abinit micro version number (patch level). */
#cmakedefine ABINIT_VERSION_MICRO "@ABINIT_VERSION_MICRO@"

/* Define if building universal (internal helper macro). TODO: is this still necessary ? */
/*#cmakedefine AC_APPLE_UNIVERSAL_BUILD */

/* Define to 1 if you are using the ARM C compiler. */
#cmakedefine CC_ARM 1

/* Define to 1 if you are using the GNU C compiler. */
#cmakedefine CC_GNU 1

/* Define to 1 if you are using the IBM XL C compiler. */
#cmakedefine CC_IBM 1

/* Define to 1 if you are using the Intel C compiler. */
#cmakedefine CC_INTEL 1

/* Define to 1 if you are using the LLVM Clang C compiler. */
#cmakedefine CC_LLVM 1

/* Define to 1 if you are using the Portland Group C compiler. */
#cmakedefine CC_PGI 1

/* Define to 1 if you are using the Nvidia nvhpc compiler. */
#cmakedefine CC_NVHPC 1

/* Define to 1 if you are using the ARM C++ compiler. */
#cmakedefine CXX_ARM 1

/* Define to 1 if you are using the GNU C++ compiler. */
#cmakedefine CXX_GNU 1

/* Define to 1 if you are using the IBM XL C++ compiler. */
#cmakedefine CXX_IBM 1

/* Define to 1 if you are using the Intel C++ compiler. */
#cmakedefine CXX_INTEL 1

/* Define to 1 if you are using the LLVM Clang++ C++ compiler. */
#cmakedefine CXX_LLVM 1

/* Define to 1 if you are using the Portland Group C++ compiler. */
#cmakedefine CXX_PGI 1

/* Define to 1 if you are using the Nvidia nvhpc compiler. */
#cmakedefine CXX_NVHPC 1

/* Define to 1 if you want to activate design-by-contract debugging tests. */
#cmakedefine DEBUG_CONTRACT 1

/* Define to 1 to build debugging instructions in the source code. */
#cmakedefine DEBUG_MODE 1

/* Define to 1 to turn on verbose debug messages in the source code. */
#cmakedefine DEBUG_VERBOSE 1

/* Define to 1 to turn on verbose debug messages in the GPU source code. */
#cmakedefine DEBUG_VERBOSE_GPU 1

/* Define to 1 if you are using the ABSOFT Fortran compiler. */
#cmakedefine FC_ABSOFT 1

/* Define to 1 if you are using the LLVM Flang Fortran AOCC compiler. */
#cmakedefine FC_AOCC 1

/* Define to 1 if you are using the ARM Fortran compiler. */
#cmakedefine FC_ARM 1

/*
 * Fortran/C mangles names
 * Use cmake macro `FortranCInterface` to adapt autoconf `AC_FC_WRAPPERS`.
 *
 * Note: fc_mangle.h is generated by cmake macro `FortranCInterface_HEADER`
 */
#include "fc_mangle.h"

/* Define to dummy `main' function (if any) required to link to the Fortran
   libraries. */
/* #undef FC_DUMMY_MAIN */

/* Define if F77 and FC dummy `main' functions are identical. */
/* #undef FC_DUMMY_MAIN_EQ_F77 */

/* Define to a macro mangling the given C identifier (in lower and upper
   case), which must not contain underscores, for linking with Fortran. */
#define FC_FUNC FC_FUNC_GLOBAL

/* As FC_FUNC, but for C identifiers containing underscores. */
#define FC_FUNC_ FC_FUNC_GLOBAL_

/* Define to 1 if you are using the GNU Fortran compiler. */
#cmakedefine FC_GNU 1

/* Define to 1 if you are using the IBM XL Fortran compiler. */
#cmakedefine FC_IBM 1

/* Define to 1 if you are using the Intel Fortran compiler. */
#cmakedefine FC_INTEL 1

/* Define to 1 if you are using the LLVM Flang Fortran compiler. */
#cmakedefine FC_LLVM 1

/* Define to 1 if you are using the NAGWare Fortran 95 compiler. */
#cmakedefine FC_NAG 1

/* Define to 1 if you are using the Portland Group Fortran compiler. */
#cmakedefine FC_PGI 1

/* Define to 1 if you are using the Nvidia nvhpc compiler. */
#cmakedefine FC_NVHPC 1

/* Define to 1 if you are using the CRAY Fortran compiler. */
#cmakedefine FC_CRAY 1

/* Define to 1 if you want to enable memory profiling. */
#cmakedefine HAVE_MEM_PROFILING @HAVE_MEM_PROFILING@

/* Define to 1 if you have the ABINIT Common library. */
#cmakedefine HAVE_ABINIT_COMMON

/* Define to 1 if you have the `abort' function. */
#cmakedefine HAVE_ABORT @HAVE_ABORT@

/* Define to 1 if you have the AtomPAW library. */
#cmakedefine HAVE_ATOMPAW @HAVE_ATOMPAW@

/* Define to 1 if you want to disable vectorization in problematic procedures. */
#cmakedefine HAVE_AVX_SAFE_MODE @HAVE_AVX_SAFE_MODE@

/* Define to 1 if you have the BigDFT library. */
#cmakedefine HAVE_BIGDFT @HAVE_BIGDFT@

/* Use C clock for timings. */
#cmakedefine HAVE_CCLOCK @HAVE_CCLOCK@

/* Define to 1 if you have the `clock_gettime' function. */
#cmakedefine HAVE_CLOCK_GETTIME @HAVE_CLOCK_DEFINE@

/* Define to 1 if you want to enable optimize cRPA calculations for ifort <= 17.0. */
#cmakedefine HAVE_CRPA_OPTIM

/* Define to 1 if you have the <cublas.h> header file. */
#cmakedefine HAVE_CUBLAS_H

/* Define to 1 if you have the <cuda_runtime_api.h> header file. */
#cmakedefine HAVE_CUDA_RUNTIME_API_H

/* Define to 1 if you have the <cufft.h> header file. */
#cmakedefine HAVE_CUFFT_H

/* Define to 1 if you have the DFTI library. */
/* #undef HAVE_DFTI */
/*
* TODO: abinit should either
* - include wrapper sources and integrate then into the build system
* - use a more elaborate way to detect/configure fftw as e.g.
*   * https://github.com/ecrc/ecrc_cmake/blob/master/modules/find/FindFFTW.cmake
*   * https://github.com/InsightSoftwareConsortium/ITK/blob/master/CMake/FindFFTW.cmake
*/

/* Define to 1 if you have the PAPI library. */
#cmakedefine HAVE_PAPI @HAVE_PAPI@

/* Define to 1 if you have the <papi.h> header file. */
#cmakedefine HAVE_PAPI_H @HAVE_PAPI_H@

/* Define to 1 if you have the <f90papi.h> header file. */
#cmakedefine HAVE_F90PAPI_H @HAVE_F90PAPI_H@

/* Define to 1 if you have the TRIQS library. */
#cmakedefine HAVE_TRIQS @HAVE_TRIQS@

/* Define to 1 if you want to activate internal support for TRIQS 1.4. */
#cmakedefine HAVE_TRIQS_v1_4 @HAVE_TRIQS_v1_4@

/* Define to 1 if you want to activate internal support for TRIQS 2.0 (This
   option is dominant over the others versions). */
#cmakedefine HAVE_TRIQS_v2_0 @HAVE_TRIQS_v2_0@

/* Define to 1 if you want to activate internal support for TRIQS 3.x (This
   option is dominant over the others versions). */
#cmakedefine HAVE_TRIQS_v3 @HAVE_TRIQS_v3@

/* Define to 1 if your Fortran compiler supports allocatable arrays in datatypes. */
#cmakedefine HAVE_FC_ALLOCATABLE_DTARRAYS @HAVE_FC_ALLOCATABLE_DTARRAYS@

/* Define to 1 if your Fortran compiler supports the asynchronous attribute. */
#cmakedefine HAVE_FC_ASYNC @HAVE_FC_ASYNC@

/* Define to 1 if your Fortran compiler supports BACKTRACE. */
#cmakedefine HAVE_FC_BACKTRACE @HAVE_FC_BACKTRACE@

/* Define to 1 if your Fortran compiler supports GET_COMMAND_ARGUMENT. */
#cmakedefine HAVE_FC_COMMAND_ARGUMENT @HAVE_FC_COMMAND_ARGUMENT@

/* Define to 1 if your Fortran compiler supports the contiguous attribute. */
#cmakedefine HAVE_FC_CONTIGUOUS @HAVE_FC_CONTIGUOUS@

/* Define to 1 if your Fortran compiler supports cpu_time(). */
#cmakedefine HAVE_FC_CPUTIME @HAVE_FC_CPUTIME@

/* Define to 1 if your Fortran compiler supports etime(). */
#cmakedefine HAVE_FC_ETIME @HAVE_FC_ETIME@

/* Define to 1 if your Fortran compiler supports exit(). */
#cmakedefine HAVE_FC_EXIT @HAVE_FC_EXIT@

/* Define to 1 if your Fortran compiler supports flush(). */
#cmakedefine HAVE_FC_FLUSH @HAVE_FC_FLUSH@

/* Define to 1 if your Fortran compiler supports flush_(). */
#cmakedefine HAVE_FC_FLUSH_ @HAVE_FC_FLUSH_@

/* Define to 1 if your Fortran compiler supports gamma(). */
#cmakedefine HAVE_FC_GAMMA @HAVE_FC_GAMMA@

/* Define to 1 if your Fortran compiler supports getenv(). */
#cmakedefine HAVE_FC_GETENV @HAVE_FC_GETENV@

/* Define to 1 if your Fortran compiler supports getpid(). */
#cmakedefine HAVE_FC_GETPID @HAVE_FC_GETPID@

/* Define to 1 if your Fortran compiler supports IEEE_ARITHMETIC module. */
#cmakedefine HAVE_FC_IEEE_ARITHMETIC @HAVE_FC_IEEE_ARITHMETIC@

/* Define to 1 if your Fortran compiler supports IEEE_EXCEPTIONS. */
#cmakedefine HAVE_FC_IEEE_EXCEPTIONS @HAVE_FC_IEEE_EXCEPTIONS@

/* Define to 1 if your Fortran compiler provides the iso_c_binding module. */
#cmakedefine HAVE_FC_ISO_C_BINDING @HAVE_FC_ISO_C_BINDING@

/* Define to 1 if your Fortran compiler supports 2008 standard in
   ISO_FORTRAN_ENV. */
#cmakedefine HAVE_FC_ISO_FORTRAN_2008 @HAVE_FC_ISO_FORTRAN_2008@

/* Define to 1 if your Fortran compiler accepts quadruple integers. */
#cmakedefine HAVE_FC_INT_QUAD @HAVE_FC_INT_QUAD@

/* Define to 1 if your Fortran compiler supports IOMSG. */
#cmakedefine HAVE_FC_IOMSG @HAVE_FC_IOMSG@

/* Define to 1 if your Fortran compiler supports long lines. */
#cmakedefine HAVE_FC_LONG_LINES @HAVE_FC_LONG_LINES@

/* Define to 1 if your Fortran compiler supports \newline in a macros. */
#cmakedefine HAVE_FC_MACRO_NEWLINE @HAVE_FC_MACRO_NEWLINE@

/* Define to 1 if your Fortran compiler supports MOVE_ALLOC (F2003). */
#cmakedefine HAVE_FC_MOVE_ALLOC @HAVE_FC_MOVE_ALLOC@

/* Define to 1 if your Fortran compiler can shape arrays on-the-fly. */
#cmakedefine HAVE_FC_ON_THE_FLY_SHAPE @HAVE_FC_ON_THE_FLY_SHAPE@

/* Define to 1 if your Fortran compiler supports the private attribute. */
#cmakedefine HAVE_FC_PRIVATE @HAVE_FC_PRIVATE@

/* Define to 1 if your Fortran compiler supports the protected attribute. */
#cmakedefine HAVE_FC_PROTECTED @HAVE_FC_PROTECTED@

/* Define to 1 if your Fortran compiler supports shiftl() and shiftr(). */
#cmakedefine  HAVE_FC_SHIFTLR @HAVE_FC_SHIFTLR@

/* Define to 1 if your Fortran compiler supports stream IO. */
#cmakedefine HAVE_FC_STREAM_IO @HAVE_FC_STREAM_IO@

/* Define to 1 if your Fortran compiler supports SYSTEM. */
#cmakedefine HAVE_FC_SYSTEM @HAVE_FC_SYSTEM@

/* Define to 1 if you have the FFTW3 library. */
#cmakedefine HAVE_FFTW3 @HAVE_FFTW3@

/* Define to 1 if you have a MPI-enabled FFTW3 library. */
#cmakedefine HAVE_FFTW3_MPI @HAVE_FFTW3_MPI@

/* Define to 1 if you have a threads-enabled FFTW3 library. */
#cmakedefine HAVE_FFTW3_THREADS @HAVE_FFTW3_THREADS@

/* Define to 1 if your Fortran compiler supports Fortran 2003. */
/* TODO #cmakedefine HAVE_FORTRAN2003 */

/* Define to 1 if you have a GPU library. */
#cmakedefine HAVE_GPU @HAVE_GPU@

/* Define to 1 if you have the Cuda library. */
#cmakedefine HAVE_GPU_CUDA @HAVE_GPU_CUDA@

/* Define to 1 if you have a Cuda version >= 10 (for nvtx v3). */
#cmakedefine HAVE_GPU_CUDA10 @HAVE_GPU_CUDA10@

/* Define to 1 if you have a Cuda version < 4. */
#cmakedefine HAVE_GPU_CUDA3 @HAVE_GPU_CUDA3@

/* Define to 1 if you want to perform double-precision Cuda calculations. */
#cmakedefine HAVE_GPU_CUDA_DP @HAVE_GPU_CUDA_DP@

/* Define to 1 if you want to perform single-precision Cuda calculations. */
#cmakedefine HAVE_GPU_CUDA_SP @HAVE_GPU_CUDA_SP@

/* Define to 1 if you have the HIP library. */
#cmakedefine HAVE_GPU_HIP @HAVE_GPU_HIP@

/* Define to 1 if Kokkos is enabled */
#cmakedefine HAVE_KOKKOS @HAVE_KOKKOS@

/* Define to 1 if YAKL is enabled */
#cmakedefine HAVE_YAKL @HAVE_YAKL@

/* Define to 1 if MPI_EXT (MPI extensions, i.e. mpi_ext.h) is available */
#cmakedefine HAVE_MPI_EXT @HAVE_MPI_EXT@

/* Define to 1 if MPIX_Query_cuda_support is available via mpi-ext.h */
#cmakedefine MPI_HAS_QUERY_CUDA_SUPPORT @MPI_HAS_QUERY_CUDA_SUPPORT@

/* Define to 1 if MPIX_Query_hip_support is available via mpi-ext.h */
#cmakedefine MPI_HAS_QUERY_HIP_SUPPORT @MPI_HAS_QUERY_HIP_SUPPORT@

/* Define to 1 if MPIX_Query_ze_support is available via mpi-ext.h */
#cmakedefine MPI_HAS_QUERY_ZE_SUPPORT @MPI_HAS_QUERY_ZE_SUPPORT@

/* Define to 1 if you have a MPI-aware GPU library. */
/* TODO #cmakedefine HAVE_GPU_MPI */

/* Define to 1 if you have library nvtx (v3). */
#cmakedefine HAVE_GPU_MARKERS @HAVE_GPU_MARKERS@

/* Define to 1 if you have a serial GPU library. */
#cmakedefine HAVE_GPU_SERIAL @HAVE_GPU_SERIAL@

/* Define to 1 if you want to activate support for OpenMP. */
#cmakedefine HAVE_OPENMP @HAVE_OPENMP@

/* Define to 1 if you want to activate support for OpenMP GPU offload. */
#cmakedefine HAVE_OPENMP_OFFLOAD @HAVE_OPENMP_OFFLOAD@

/* Define to 1 if you want to activate support for OpenMP GPU offload. */
#cmakedefine HAVE_OPENMP_OFFLOAD_DATASTRUCTURE @HAVE_OPENMP_OFFLOAD_DATASTRUCTURE@

/* Set to 1 if OpenMP has a working implementation of COLLAPSE. */
#cmakedefine HAVE_OMP_COLLAPSE @HAVE_OMP_COLLAPSE@

/* Define to 1 if you have a working MPI installation. */
#cmakedefine HAVE_MPI @HAVE_MPI@

/* Define to 1 if you have a MPI-1 implementation (obsolete, broken). */
#cmakedefine HAVE_MPI1 @HAVE_MPI1@

/* Define to 1 if you have a MPI-2 implementation. */
#cmakedefine HAVE_MPI2 @HAVE_MPI2@

/* Define to 1 if you want to activate support for MPI_IN_PLACE. */
#cmakedefine HAVE_MPI2_INPLACE @HAVE_MPI2_INPLACE@

/* Define to 1 if you have a MPI-3 implementation. */
#cmakedefine HAVE_MPI3 @HAVE_MPI3@

/* Define to 1 if your MPI implementation provides MPI_Get_library_version. */
#cmakedefine HAVE_MPI_GET_LIBRARY_VERSION @HAVE_MPI_GET_LIBRARY_VERSION@

/* Define to 1 if your MPI library supports MPI_IALLGATHER. */
#cmakedefine HAVE_MPI_IALLGATHER @HAVE_MPI_IALLGATHER@

/* Define to 1 if your MPI library supports MPI_IALLREDUCE. */
#cmakedefine HAVE_MPI_IALLREDUCE @HAVE_MPI_IALLREDUCE@

/* Define to 1 if your MPI library supports MPI_IALLTOALL. */
#cmakedefine HAVE_MPI_IALLTOALL @HAVE_MPI_IALLTOALL@

/* Define to 1 if your MPI library supports MPI_IALLTOALLV. */
#cmakedefine HAVE_MPI_IALLTOALLV @HAVE_MPI_IALLTOALLV@

/* Define to 1 if your MPI library supports MPI_IBCAST. */
#cmakedefine HAVE_MPI_IBCAST @HAVE_MPI_IBCAST@

/* Define to 1 if your MPI library supports MPI_IGATHERV. */
#cmakedefine HAVE_MPI_IGATHERV @HAVE_MPI_IGATHERV@

/* Define to 1 if ..... */
#cmakedefine HAVE_MPI_INCLUDED_ONCE @HAVE_MPI_INCLUDED_ONCE@

/* Define to 1 if your MPI library supports MPI_INTEGER16. */
#cmakedefine HAVE_MPI_INTEGER16 @HAVE_MPI_INTEGER16@

/* Define to 1 if you want MPI I/O support. */
#cmakedefine HAVE_MPI_IO @HAVE_MPI_IO@

/* Define to 1 if you want to use MPI I/O as default I/O library
   (maintainer-only option). */
#cmakedefine HAVE_MPI_IO_DEFAULT @HAVE_MPI_IO_DEFAULT@

/* Define to 1 if your MPI library supports MPI_TYPE_CREATE_STRUCT. */
#cmakedefine HAVE_MPI_TYPE_CREATE_STRUCT @HAVE_MPI_TYPE_CREATE_STRUCT@

/* Define to 1 if your MPI library has buggy interfaces (mishandling scalars). */
#cmakedefine HAVE_MPI_BUGGY_INTERFACES @HAVE_MPI_BUGGY_INTERFACES@

/* Define to 1 if you want to activate possibility to call python scripts
   externally by invoking a python interpreter. */
#cmakedefine HAVE_PYTHON_INVOCATION @HAVE_PYTHON_INVOCATION@

/* ====================================================== */

/* Define to 1 if you have the <dlfcn.h> header file. */
#cmakedefine HAVE_DLFCN_H 1

/* Define to 1 if you have the <inttypes.h> header file. */
#cmakedefine HAVE_INTTYPES_H 1

/* Define to 1 if you have the <memory.h> header file. */
#cmakedefine HAVE_MEMORY_H 1

/* Define to 1 if you have the <stdint.h> header file. */
#cmakedefine HAVE_STDINT_H 1

/* Define to 1 if you have the <stddef.h> header file. */
#cmakedefine HAVE_STDDEF_H 1

/* Define to 1 if you have the <cstdint> header file. */
#cmakedefine HAVE_CSTDINT 1

/* Define to 1 if you have the <stdio.h> header file. */
#cmakedefine HAVE_STDIO_H 1

/* Define to 1 if you have the <stdlib.h> header file. */
#cmakedefine HAVE_STDLIB_H 1

/* Define to 1 if you have the <strings.h> header file. */
#cmakedefine HAVE_STRINGS_H 1

/* Define to 1 if you have the <string.h> header file. */
#cmakedefine HAVE_STRING_H 1

/* Define to 1 if you have the <sys/ioctl.h> header file. */
#cmakedefine HAVE_SYS_IOCTL_H 1

/* Define to 1 if you have the <sys/resource.h> header file. */
#cmakedefine HAVE_SYS_RESOURCE_H 1

/* Define to 1 if you have the <sys/stat.h> header file. */
#cmakedefine HAVE_SYS_STAT_H 1

/* Define to 1 if you have the <sys/time.h> header file. */
#cmakedefine HAVE_SYS_TIME_H 1

/* Define to 1 if you have the <sys/types.h> header file. */
#cmakedefine HAVE_SYS_TYPES_H 1

/* Define to 1 if you have the <termios.h> header file. */
#cmakedefine HAVE_TERMIOS_H 1

/* Define to 1 if you have the <time.h> header file. */
#cmakedefine HAVE_TIME_H 1

/* Define to 1 if you have the <unistd.h> header file. */
#cmakedefine HAVE_UNISTD_H 1

/* Define to 1 if you have the <errno.h> header file. */
#cmakedefine HAVE_ERRNO_H 1

/* The size of `char', as computed by sizeof. */
@SIZEOF_CHAR_CODE@

/* The size of `double', as computed by sizeof. */
@SIZEOF_DOUBLE_CODE@

/* The size of `float', as computed by sizeof. */
@SIZEOF_FLOAT_CODE@

/* The size of `int', as computed by sizeof. */
@SIZEOF_INT_CODE@

/* The size of `long', as computed by sizeof. */
@SIZEOF_LONG_CODE@

/* The size of `long double', as computed by sizeof. */
@SIZEOF_LONG_DOUBLE_CODE@

/* The size of `long long', as computed by sizeof. */
@SIZEOF_LONG_LONG_CODE@

/* The size of `ptrdiff_t', as computed by sizeof. */
@SIZEOF_PTRDIFF_T_CODE@

/* The size of `short', as computed by sizeof. */
@SIZEOF_SHORT_CODE@

/* The size of `size_t', as computed by sizeof. */
@SIZEOF_SIZE_T_CODE@

/* The size of `unsigned int', as computed by sizeof. */
@SIZEOF_UNSIGNED_INT_CODE@

/* The size of `unsigned long', as computed by sizeof. */
@SIZEOF_UNSIGNED_LONG_CODE@

/* The size of `unsigned long long', as computed by sizeof. */
@SIZEOF_UNSIGNED_LONG_LONG_CODE@

/* ====================================================== */
/* ================ External Dependencies =============== */
/* ====================================================== */

/* Define to 1 if you have the LibPAW library. */
#cmakedefine HAVE_LIBPAW @HAVE_LIBPAW@

/* Must be defined to 1 to have LibPAW properly working. */
#cmakedefine HAVE_LIBPAW_ABINIT @HAVE_LIBPAW_ABINIT@

/* Define to 1 if you have the LibXC library. */
#cmakedefine HAVE_LIBXC @HAVE_LIBXC@

/* Define to 1 if you have the ASL linear algebra library. */
#cmakedefine HAVE_LINALG_ASL @HAVE_LINALG_ASL@

/* Define to 1 if you have an AXPBY BLAS1 extensions. */
#cmakedefine HAVE_LINALG_AXPBY @HAVE_LINALG_AXPBY@

/* Define to 1 if you have the ELPA linear algebra library. */
#cmakedefine HAVE_LINALG_ELPA @HAVE_LINALG_ELPA@

/* Define to 1 if you have ELPA 2011-13 API support. */
#cmakedefine HAVE_LINALG_ELPA_2013 @HAVE_LINALG_ELPA_2013@

/* Define to 1 if you have ELPA 2014 API support. */
#cmakedefine HAVE_LINALG_ELPA_2014 @HAVE_LINALG_ELPA_2014@

/* Define to 1 if you have ELPA 2015.02 API support. */
#cmakedefine HAVE_LINALG_ELPA_2015_02 @HAVE_LINALG_ELPA_2015_02@

/* Define to 1 if you have ELPA 2015.11 API support. */
#cmakedefine HAVE_LINALG_ELPA_2015_11 @HAVE_LINALG_ELPA_2015_11@

/* Define to 1 if you have ELPA 2016 API support. */
#cmakedefine HAVE_LINALG_ELPA_2016 @HAVE_LINALG_ELPA_2016@

/* Define to 1 if you have ELPA 2017 API support. */
#cmakedefine HAVE_LINALG_ELPA_2017 @HAVE_LINALG_ELPA_2017@

/* Define to 1 if you have the ELPA Fortran 2008 API support. */
#cmakedefine HAVE_LINALG_ELPA_FORTRAN2008 @HAVE_LINALG_ELPA_FORTRAN2008@

/* Define to 1 if you have the ESSL linear algebra library. */
#cmakedefine HAVE_LINALG_ESSL @HAVE_LINALG_ESSL@

/* Define to 1 if you have GEMM3M BLAS3 extensions. */
#cmakedefine HAVE_LINALG_GEMM3M @HAVE_LINALG_GEMM3M@

/* Define to 1 if you have GEMMT BLAS3 extensions. */
#cmakedefine HAVE_LINALG_GEMMT @HAVE_LINALG_GEMMT@

/* Define to 1 if you have the MAGMA linear algebra library. */
#cmakedefine HAVE_LINALG_MAGMA @HAVE_LINALG_MAGMA@

/* Define to 1 if you have MAGMA >=1.5 API support */
#cmakedefine HAVE_LINALG_MAGMA_15 @HAVE_LINALG_MAGMA_15@

/* Define to 1 if you have MKL imatcopy extensions. */
#cmakedefine HAVE_LINALG_MKL_IMATCOPY @HAVE_LINALG_MKL_IMATCOPY@

/* Define to 1 if you have MKL omatadd extensions. */
#cmakedefine HAVE_LINALG_MKL_OMATADD @HAVE_LINALG_MKL_OMATADD@

/* Define to 1 if you have MKL omatcopy extensions. */
#cmakedefine HAVE_LINALG_MKL_OMATCOPY @HAVE_LINALG_MKL_OMATCOPY@

/* Define to 1 if you have mkl_*threads extensions. */
#cmakedefine HAVE_LINALG_MKL_THREADS @HAVE_LINALG_MKL_THREADS@

/* Define to 1 if you have the PLASMA linear algebra library. */
#cmakedefine HAVE_LINALG_PLASMA @HAVE_LINALG_PLASMA@

/* Define to 1 if you have the ScaLAPACK linear algebra library. */
#cmakedefine HAVE_LINALG_SCALAPACK @HAVE_LINALG_SCALAPACK@

/* Define to 1 if you want to activate workaround for bugged ZDOTC and ZDOTU. */
#cmakedefine HAVE_LINALG_ZDOTC_BUG @HAVE_LINALG_ZDOTC_BUG@

/* Define to 1 if you want to activate workaround for bugged ZDOTC and ZDOTU. */
#cmakedefine HAVE_LINALG_ZDOTU_BUG @HAVE_LINALG_ZDOTU_BUG@

/* Define to 1 if you want to activate internal support for libtetra(hedron)
   in ABINIT. */
#cmakedefine HAVE_LIBTETRA_ABINIT @HAVE_LIBTETRA_ABINIT@

#cmakedefine HAVE_FFTW3 @HAVE_FFTW3@
#cmakedefine HAVE_FFTW3_MPI @HAVE_FFTW3_MPI@
#cmakedefine HAVE_FFTW3_THREADS @HAVE_FFTW3_THREADS@

#cmakedefine HAVE_PFFT @HAVE_PFFT@

#cmakedefine HAVE_LEVMAR @HAVE_LEVMAR@

#cmakedefine HAVE_LIBPSML @HAVE_LIBPSML@

#cmakedefine HAVE_HDF5 @HAVE_HDF5@
#cmakedefine HAVE_HDF5_MPI @HAVE_HDF5_MPI@

#cmakedefine HAVE_NETCDF @HAVE_NETCDF@
#cmakedefine HAVE_NETCDF_DEFAULT @HAVE_NETCDF_DEFAULT@
#cmakedefine HAVE_NETCDF_FORTRAN @HAVE_NETCDF_FORTRAN@
#cmakedefine HAVE_NETCDF_FORTRAN_MPI @HAVE_NETCDF_FORTRAN_MPI@
#cmakedefine HAVE_NETCDF_MPI @HAVE_NETCDF_MPI@

/* Define to 1 if you have the Wannier90 library. */
#cmakedefine HAVE_WANNIER90 @HAVE_WANNIER90@

/* Define to 1 if you want to use LibXML2-based XML I/O. */
#cmakedefine HAVE_XML @HAVE_XML@

/* Define to 1 if you have the XMLF90 library. */
#cmakedefine HAVE_XMLF90 @HAVE_XMLF90@

#endif
