; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:     -mcpu=pwr8 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr < %s | \
; RUN: FileCheck %s --check-prefix=CHECK-P8
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:     -mcpu=pwr9 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr < %s | \
; RUN: FileCheck %s --check-prefix=CHECK-P9
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu \
; RUN:     -mcpu=pwr9 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr < %s | \
; RUN: FileCheck %s --check-prefix=CHECK-BE

define i16 @test2elt(i64 %a.coerce) local_unnamed_addr #0 {
; CHECK-P8-LABEL: test2elt:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    mtvsrd f0, r3
; CHECK-P8-NEXT:    xxswapd v2, vs0
; CHECK-P8-NEXT:    xscvspdpn f0, vs0
; CHECK-P8-NEXT:    xxsldwi vs1, v2, v2, 3
; CHECK-P8-NEXT:    xscvspdpn f1, vs1
; CHECK-P8-NEXT:    xscvdpsxws f0, f0
; CHECK-P8-NEXT:    xscvdpsxws f1, f1
; CHECK-P8-NEXT:    mfvsrwz r4, f0
; CHECK-P8-NEXT:    mfvsrwz r3, f1
; CHECK-P8-NEXT:    mtvsrd f1, r4
; CHECK-P8-NEXT:    mtvsrd f0, r3
; CHECK-P8-NEXT:    xxswapd v3, vs1
; CHECK-P8-NEXT:    xxswapd v2, vs0
; CHECK-P8-NEXT:    vmrglb v2, v3, v2
; CHECK-P8-NEXT:    xxswapd vs0, v2
; CHECK-P8-NEXT:    mfvsrd r3, f0
; CHECK-P8-NEXT:    clrldi r3, r3, 48
; CHECK-P8-NEXT:    sth r3, -2(r1)
; CHECK-P8-NEXT:    lhz r3, -2(r1)
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: test2elt:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    mtvsrd f0, r3
; CHECK-P9-NEXT:    xxswapd v2, vs0
; CHECK-P9-NEXT:    xscvspdpn f0, vs0
; CHECK-P9-NEXT:    xxsldwi vs1, v2, v2, 3
; CHECK-P9-NEXT:    xscvspdpn f1, vs1
; CHECK-P9-NEXT:    xscvdpsxws f1, f1
; CHECK-P9-NEXT:    xscvdpsxws f0, f0
; CHECK-P9-NEXT:    mfvsrwz r3, f1
; CHECK-P9-NEXT:    mtvsrd f1, r3
; CHECK-P9-NEXT:    mfvsrwz r3, f0
; CHECK-P9-NEXT:    mtvsrd f0, r3
; CHECK-P9-NEXT:    xxswapd v2, vs1
; CHECK-P9-NEXT:    xxswapd v3, vs0
; CHECK-P9-NEXT:    vmrglb v2, v3, v2
; CHECK-P9-NEXT:    vsldoi v2, v2, v2, 8
; CHECK-P9-NEXT:    addi r3, r1, -2
; CHECK-P9-NEXT:    stxsihx v2, 0, r3
; CHECK-P9-NEXT:    lhz r3, -2(r1)
; CHECK-P9-NEXT:    blr
;
; CHECK-BE-LABEL: test2elt:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    mtvsrd f0, r3
; CHECK-BE-NEXT:    xscvspdpn f1, vs0
; CHECK-BE-NEXT:    xxsldwi vs0, vs0, vs0, 1
; CHECK-BE-NEXT:    xscvdpsxws f1, f1
; CHECK-BE-NEXT:    xscvspdpn f0, vs0
; CHECK-BE-NEXT:    xscvdpsxws f0, f0
; CHECK-BE-NEXT:    mfvsrwz r3, f1
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    mtvsrd v2, r3
; CHECK-BE-NEXT:    mfvsrwz r3, f0
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    mtvsrd v3, r3
; CHECK-BE-NEXT:    addi r3, r1, -2
; CHECK-BE-NEXT:    vmrghb v2, v2, v3
; CHECK-BE-NEXT:    vsldoi v2, v2, v2, 10
; CHECK-BE-NEXT:    stxsihx v2, 0, r3
; CHECK-BE-NEXT:    lhz r3, -2(r1)
; CHECK-BE-NEXT:    blr
entry:
  %0 = bitcast i64 %a.coerce to <2 x float>
  %1 = fptoui <2 x float> %0 to <2 x i8>
  %2 = bitcast <2 x i8> %1 to i16
  ret i16 %2
}

define i32 @test4elt(<4 x float> %a) local_unnamed_addr #1 {
; CHECK-P8-LABEL: test4elt:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xxsldwi vs0, v2, v2, 3
; CHECK-P8-NEXT:    xscvspdpn f1, v2
; CHECK-P8-NEXT:    xxswapd vs2, v2
; CHECK-P8-NEXT:    xxsldwi vs3, v2, v2, 1
; CHECK-P8-NEXT:    xscvspdpn f0, vs0
; CHECK-P8-NEXT:    xscvspdpn f2, vs2
; CHECK-P8-NEXT:    xscvspdpn f3, vs3
; CHECK-P8-NEXT:    xscvdpsxws f1, f1
; CHECK-P8-NEXT:    xscvdpsxws f0, f0
; CHECK-P8-NEXT:    xscvdpsxws f2, f2
; CHECK-P8-NEXT:    xscvdpsxws f3, f3
; CHECK-P8-NEXT:    mfvsrwz r3, f1
; CHECK-P8-NEXT:    mtvsrd f1, r3
; CHECK-P8-NEXT:    mfvsrwz r3, f0
; CHECK-P8-NEXT:    mfvsrwz r4, f2
; CHECK-P8-NEXT:    xxswapd v4, vs1
; CHECK-P8-NEXT:    mtvsrd f0, r3
; CHECK-P8-NEXT:    mfvsrwz r3, f3
; CHECK-P8-NEXT:    mtvsrd f2, r4
; CHECK-P8-NEXT:    xxswapd v2, vs0
; CHECK-P8-NEXT:    mtvsrd f3, r3
; CHECK-P8-NEXT:    xxswapd v3, vs2
; CHECK-P8-NEXT:    xxswapd v5, vs3
; CHECK-P8-NEXT:    vmrglb v2, v3, v2
; CHECK-P8-NEXT:    vmrglb v3, v4, v5
; CHECK-P8-NEXT:    vmrglh v2, v3, v2
; CHECK-P8-NEXT:    xxswapd vs0, v2
; CHECK-P8-NEXT:    mfvsrwz r3, f0
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: test4elt:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xxsldwi vs0, v2, v2, 3
; CHECK-P9-NEXT:    xscvspdpn f0, vs0
; CHECK-P9-NEXT:    xscvdpsxws f0, f0
; CHECK-P9-NEXT:    mfvsrwz r3, f0
; CHECK-P9-NEXT:    mtvsrd f0, r3
; CHECK-P9-NEXT:    xxswapd v3, vs0
; CHECK-P9-NEXT:    xxswapd vs0, v2
; CHECK-P9-NEXT:    xscvspdpn f0, vs0
; CHECK-P9-NEXT:    xscvdpsxws f0, f0
; CHECK-P9-NEXT:    mfvsrwz r3, f0
; CHECK-P9-NEXT:    mtvsrd f0, r3
; CHECK-P9-NEXT:    xxswapd v4, vs0
; CHECK-P9-NEXT:    xscvspdpn f0, v2
; CHECK-P9-NEXT:    xscvdpsxws f0, f0
; CHECK-P9-NEXT:    mfvsrwz r3, f0
; CHECK-P9-NEXT:    mtvsrd f0, r3
; CHECK-P9-NEXT:    vmrglb v3, v4, v3
; CHECK-P9-NEXT:    xxswapd v4, vs0
; CHECK-P9-NEXT:    xxsldwi vs0, v2, v2, 1
; CHECK-P9-NEXT:    xscvspdpn f0, vs0
; CHECK-P9-NEXT:    xscvdpsxws f0, f0
; CHECK-P9-NEXT:    mfvsrwz r3, f0
; CHECK-P9-NEXT:    mtvsrd f0, r3
; CHECK-P9-NEXT:    li r3, 0
; CHECK-P9-NEXT:    xxswapd v2, vs0
; CHECK-P9-NEXT:    vmrglb v2, v4, v2
; CHECK-P9-NEXT:    vmrglh v2, v2, v3
; CHECK-P9-NEXT:    vextuwrx r3, r3, v2
; CHECK-P9-NEXT:    blr
;
; CHECK-BE-LABEL: test4elt:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    xxsldwi vs0, v2, v2, 3
; CHECK-BE-NEXT:    xscvspdpn f0, vs0
; CHECK-BE-NEXT:    xscvdpsxws f0, f0
; CHECK-BE-NEXT:    mfvsrwz r3, f0
; CHECK-BE-NEXT:    xxswapd vs0, v2
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    xscvspdpn f0, vs0
; CHECK-BE-NEXT:    mtvsrd v3, r3
; CHECK-BE-NEXT:    xscvdpsxws f0, f0
; CHECK-BE-NEXT:    mfvsrwz r3, f0
; CHECK-BE-NEXT:    xscvspdpn f0, v2
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    xscvdpsxws f0, f0
; CHECK-BE-NEXT:    mtvsrd v4, r3
; CHECK-BE-NEXT:    vmrghb v3, v4, v3
; CHECK-BE-NEXT:    mfvsrwz r3, f0
; CHECK-BE-NEXT:    xxsldwi vs0, v2, v2, 1
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    xscvspdpn f0, vs0
; CHECK-BE-NEXT:    mtvsrd v4, r3
; CHECK-BE-NEXT:    xscvdpsxws f0, f0
; CHECK-BE-NEXT:    mfvsrwz r3, f0
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    mtvsrd v2, r3
; CHECK-BE-NEXT:    li r3, 0
; CHECK-BE-NEXT:    vmrghb v2, v4, v2
; CHECK-BE-NEXT:    vmrghh v2, v2, v3
; CHECK-BE-NEXT:    vextuwlx r3, r3, v2
; CHECK-BE-NEXT:    blr
entry:
  %0 = fptoui <4 x float> %a to <4 x i8>
  %1 = bitcast <4 x i8> %0 to i32
  ret i32 %1
}

define i64 @test8elt(<8 x float>* nocapture readonly) local_unnamed_addr #2 {
; CHECK-P8-LABEL: test8elt:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lvx v2, 0, r3
; CHECK-P8-NEXT:    li r4, 16
; CHECK-P8-NEXT:    lvx v5, r3, r4
; CHECK-P8-NEXT:    xxswapd vs1, v2
; CHECK-P8-NEXT:    xxsldwi vs0, v2, v2, 3
; CHECK-P8-NEXT:    xxsldwi vs2, v5, v5, 3
; CHECK-P8-NEXT:    xscvspdpn f4, v5
; CHECK-P8-NEXT:    xxswapd vs3, v5
; CHECK-P8-NEXT:    xxsldwi vs5, v5, v5, 1
; CHECK-P8-NEXT:    xscvspdpn f1, vs1
; CHECK-P8-NEXT:    xscvspdpn f0, vs0
; CHECK-P8-NEXT:    xscvspdpn f2, vs2
; CHECK-P8-NEXT:    xscvspdpn f3, vs3
; CHECK-P8-NEXT:    xscvspdpn f5, vs5
; CHECK-P8-NEXT:    xscvdpsxws f4, f4
; CHECK-P8-NEXT:    xscvdpsxws f1, f1
; CHECK-P8-NEXT:    xscvdpsxws f0, f0
; CHECK-P8-NEXT:    xscvdpsxws f2, f2
; CHECK-P8-NEXT:    xscvdpsxws f3, f3
; CHECK-P8-NEXT:    xscvdpsxws f5, f5
; CHECK-P8-NEXT:    mfvsrwz r4, f4
; CHECK-P8-NEXT:    mfvsrwz r6, f1
; CHECK-P8-NEXT:    mfvsrwz r5, f0
; CHECK-P8-NEXT:    mtvsrd f1, r6
; CHECK-P8-NEXT:    mtvsrd f0, r5
; CHECK-P8-NEXT:    xxswapd v4, vs1
; CHECK-P8-NEXT:    xxsldwi vs1, v2, v2, 1
; CHECK-P8-NEXT:    xxswapd v3, vs0
; CHECK-P8-NEXT:    xscvspdpn f0, v2
; CHECK-P8-NEXT:    mtvsrd f4, r4
; CHECK-P8-NEXT:    xscvspdpn f1, vs1
; CHECK-P8-NEXT:    mfvsrwz r4, f2
; CHECK-P8-NEXT:    xxswapd v1, vs4
; CHECK-P8-NEXT:    vmrglb v2, v4, v3
; CHECK-P8-NEXT:    mtvsrd f2, r4
; CHECK-P8-NEXT:    xscvdpsxws f0, f0
; CHECK-P8-NEXT:    mfvsrwz r4, f5
; CHECK-P8-NEXT:    xxswapd v5, vs2
; CHECK-P8-NEXT:    xscvdpsxws f1, f1
; CHECK-P8-NEXT:    mfvsrwz r3, f0
; CHECK-P8-NEXT:    mtvsrd f0, r3
; CHECK-P8-NEXT:    mfvsrwz r3, f1
; CHECK-P8-NEXT:    xxswapd v3, vs0
; CHECK-P8-NEXT:    mtvsrd f1, r3
; CHECK-P8-NEXT:    mfvsrwz r3, f3
; CHECK-P8-NEXT:    mtvsrd f3, r4
; CHECK-P8-NEXT:    xxswapd v4, vs1
; CHECK-P8-NEXT:    mtvsrd f0, r3
; CHECK-P8-NEXT:    xxswapd v6, vs3
; CHECK-P8-NEXT:    xxswapd v0, vs0
; CHECK-P8-NEXT:    vmrglb v3, v3, v4
; CHECK-P8-NEXT:    vmrglb v4, v0, v5
; CHECK-P8-NEXT:    vmrglb v5, v1, v6
; CHECK-P8-NEXT:    vmrglh v2, v3, v2
; CHECK-P8-NEXT:    vmrglh v3, v5, v4
; CHECK-P8-NEXT:    vmrglw v2, v3, v2
; CHECK-P8-NEXT:    xxswapd vs0, v2
; CHECK-P8-NEXT:    mfvsrd r3, f0
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: test8elt:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lxv vs1, 0(r3)
; CHECK-P9-NEXT:    xxsldwi vs2, vs1, vs1, 3
; CHECK-P9-NEXT:    xscvspdpn f2, vs2
; CHECK-P9-NEXT:    xscvdpsxws f2, f2
; CHECK-P9-NEXT:    lxv vs0, 16(r3)
; CHECK-P9-NEXT:    mfvsrwz r3, f2
; CHECK-P9-NEXT:    mtvsrd f2, r3
; CHECK-P9-NEXT:    xxswapd v2, vs2
; CHECK-P9-NEXT:    xxswapd vs2, vs1
; CHECK-P9-NEXT:    xscvspdpn f2, vs2
; CHECK-P9-NEXT:    xscvdpsxws f2, f2
; CHECK-P9-NEXT:    mfvsrwz r3, f2
; CHECK-P9-NEXT:    mtvsrd f2, r3
; CHECK-P9-NEXT:    xxswapd v3, vs2
; CHECK-P9-NEXT:    xscvspdpn f2, vs1
; CHECK-P9-NEXT:    xxsldwi vs1, vs1, vs1, 1
; CHECK-P9-NEXT:    xscvspdpn f1, vs1
; CHECK-P9-NEXT:    xscvdpsxws f2, f2
; CHECK-P9-NEXT:    xscvdpsxws f1, f1
; CHECK-P9-NEXT:    mfvsrwz r3, f2
; CHECK-P9-NEXT:    mtvsrd f2, r3
; CHECK-P9-NEXT:    mfvsrwz r3, f1
; CHECK-P9-NEXT:    mtvsrd f1, r3
; CHECK-P9-NEXT:    xxswapd v4, vs1
; CHECK-P9-NEXT:    xxsldwi vs1, vs0, vs0, 3
; CHECK-P9-NEXT:    xscvspdpn f1, vs1
; CHECK-P9-NEXT:    xscvdpsxws f1, f1
; CHECK-P9-NEXT:    vmrglb v2, v3, v2
; CHECK-P9-NEXT:    xxswapd v3, vs2
; CHECK-P9-NEXT:    vmrglb v3, v3, v4
; CHECK-P9-NEXT:    vmrglh v2, v3, v2
; CHECK-P9-NEXT:    mfvsrwz r3, f1
; CHECK-P9-NEXT:    mtvsrd f1, r3
; CHECK-P9-NEXT:    xxswapd v3, vs1
; CHECK-P9-NEXT:    xxswapd vs1, vs0
; CHECK-P9-NEXT:    xscvspdpn f1, vs1
; CHECK-P9-NEXT:    xscvdpsxws f1, f1
; CHECK-P9-NEXT:    mfvsrwz r3, f1
; CHECK-P9-NEXT:    mtvsrd f1, r3
; CHECK-P9-NEXT:    xxswapd v4, vs1
; CHECK-P9-NEXT:    xscvspdpn f1, vs0
; CHECK-P9-NEXT:    xxsldwi vs0, vs0, vs0, 1
; CHECK-P9-NEXT:    xscvspdpn f0, vs0
; CHECK-P9-NEXT:    xscvdpsxws f1, f1
; CHECK-P9-NEXT:    xscvdpsxws f0, f0
; CHECK-P9-NEXT:    mfvsrwz r3, f1
; CHECK-P9-NEXT:    mtvsrd f1, r3
; CHECK-P9-NEXT:    mfvsrwz r3, f0
; CHECK-P9-NEXT:    mtvsrd f0, r3
; CHECK-P9-NEXT:    vmrglb v3, v4, v3
; CHECK-P9-NEXT:    xxswapd v4, vs1
; CHECK-P9-NEXT:    xxswapd v5, vs0
; CHECK-P9-NEXT:    vmrglb v4, v4, v5
; CHECK-P9-NEXT:    vmrglh v3, v4, v3
; CHECK-P9-NEXT:    vmrglw v2, v3, v2
; CHECK-P9-NEXT:    mfvsrld r3, v2
; CHECK-P9-NEXT:    blr
;
; CHECK-BE-LABEL: test8elt:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    lxv vs1, 16(r3)
; CHECK-BE-NEXT:    xxsldwi vs2, vs1, vs1, 3
; CHECK-BE-NEXT:    xscvspdpn f2, vs2
; CHECK-BE-NEXT:    xscvdpsxws f2, f2
; CHECK-BE-NEXT:    lxv vs0, 0(r3)
; CHECK-BE-NEXT:    mfvsrwz r3, f2
; CHECK-BE-NEXT:    xxswapd vs2, vs1
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    xscvspdpn f2, vs2
; CHECK-BE-NEXT:    mtvsrd v2, r3
; CHECK-BE-NEXT:    xscvdpsxws f2, f2
; CHECK-BE-NEXT:    mfvsrwz r3, f2
; CHECK-BE-NEXT:    xscvspdpn f2, vs1
; CHECK-BE-NEXT:    xxsldwi vs1, vs1, vs1, 1
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    xscvdpsxws f2, f2
; CHECK-BE-NEXT:    xscvspdpn f1, vs1
; CHECK-BE-NEXT:    mtvsrd v3, r3
; CHECK-BE-NEXT:    xscvdpsxws f1, f1
; CHECK-BE-NEXT:    vmrghb v2, v3, v2
; CHECK-BE-NEXT:    mfvsrwz r3, f2
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    mtvsrd v3, r3
; CHECK-BE-NEXT:    mfvsrwz r3, f1
; CHECK-BE-NEXT:    xxsldwi vs1, vs0, vs0, 3
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    xscvspdpn f1, vs1
; CHECK-BE-NEXT:    mtvsrd v4, r3
; CHECK-BE-NEXT:    xscvdpsxws f1, f1
; CHECK-BE-NEXT:    mfvsrwz r3, f1
; CHECK-BE-NEXT:    xxswapd vs1, vs0
; CHECK-BE-NEXT:    xscvspdpn f1, vs1
; CHECK-BE-NEXT:    xscvdpsxws f1, f1
; CHECK-BE-NEXT:    vmrghb v3, v3, v4
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    vmrghh v2, v3, v2
; CHECK-BE-NEXT:    mtvsrd v3, r3
; CHECK-BE-NEXT:    mfvsrwz r3, f1
; CHECK-BE-NEXT:    xscvspdpn f1, vs0
; CHECK-BE-NEXT:    xxsldwi vs0, vs0, vs0, 1
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    xscvdpsxws f1, f1
; CHECK-BE-NEXT:    xscvspdpn f0, vs0
; CHECK-BE-NEXT:    mtvsrd v4, r3
; CHECK-BE-NEXT:    xscvdpsxws f0, f0
; CHECK-BE-NEXT:    vmrghb v3, v4, v3
; CHECK-BE-NEXT:    mfvsrwz r3, f1
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    mtvsrd v4, r3
; CHECK-BE-NEXT:    mfvsrwz r3, f0
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    mtvsrd v5, r3
; CHECK-BE-NEXT:    vmrghb v4, v4, v5
; CHECK-BE-NEXT:    vmrghh v3, v4, v3
; CHECK-BE-NEXT:    vmrghw v2, v3, v2
; CHECK-BE-NEXT:    mfvsrd r3, v2
; CHECK-BE-NEXT:    blr
entry:
  %a = load <8 x float>, <8 x float>* %0, align 32
  %1 = fptoui <8 x float> %a to <8 x i8>
  %2 = bitcast <8 x i8> %1 to i64
  ret i64 %2
}

define <16 x i8> @test16elt(<16 x float>* nocapture readonly) local_unnamed_addr #3 {
; CHECK-P8-LABEL: test16elt:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lvx v2, 0, r3
; CHECK-P8-NEXT:    li r4, 16
; CHECK-P8-NEXT:    lvx v3, r3, r4
; CHECK-P8-NEXT:    li r4, 32
; CHECK-P8-NEXT:    xscvspdpn f2, v2
; CHECK-P8-NEXT:    xxsldwi vs0, v2, v2, 3
; CHECK-P8-NEXT:    xscvspdpn f4, v3
; CHECK-P8-NEXT:    xxswapd vs1, v2
; CHECK-P8-NEXT:    xxsldwi vs3, v2, v2, 1
; CHECK-P8-NEXT:    xxsldwi vs5, v3, v3, 3
; CHECK-P8-NEXT:    lvx v2, r3, r4
; CHECK-P8-NEXT:    xscvspdpn f0, vs0
; CHECK-P8-NEXT:    xxswapd vs6, v3
; CHECK-P8-NEXT:    xscvspdpn f1, vs1
; CHECK-P8-NEXT:    xxsldwi vs7, v3, v3, 1
; CHECK-P8-NEXT:    xscvspdpn f3, vs3
; CHECK-P8-NEXT:    xxsldwi vs8, v2, v2, 3
; CHECK-P8-NEXT:    xscvdpsxws f2, f2
; CHECK-P8-NEXT:    xxswapd vs9, v2
; CHECK-P8-NEXT:    xscvdpsxws f4, f4
; CHECK-P8-NEXT:    xscvspdpn f5, vs5
; CHECK-P8-NEXT:    xscvdpsxws f0, f0
; CHECK-P8-NEXT:    xscvspdpn f6, vs6
; CHECK-P8-NEXT:    xscvdpsxws f1, f1
; CHECK-P8-NEXT:    mfvsrwz r4, f2
; CHECK-P8-NEXT:    xscvspdpn f7, vs7
; CHECK-P8-NEXT:    mtvsrd f2, r4
; CHECK-P8-NEXT:    mfvsrwz r4, f4
; CHECK-P8-NEXT:    xscvdpsxws f3, f3
; CHECK-P8-NEXT:    xscvspdpn f8, vs8
; CHECK-P8-NEXT:    mtvsrd f4, r4
; CHECK-P8-NEXT:    mfvsrwz r4, f0
; CHECK-P8-NEXT:    xscvdpsxws f0, f5
; CHECK-P8-NEXT:    xxswapd v0, vs4
; CHECK-P8-NEXT:    xscvspdpn f9, vs9
; CHECK-P8-NEXT:    mtvsrd f5, r4
; CHECK-P8-NEXT:    mfvsrwz r4, f1
; CHECK-P8-NEXT:    xscvdpsxws f1, f6
; CHECK-P8-NEXT:    xxswapd v3, vs5
; CHECK-P8-NEXT:    mtvsrd f6, r4
; CHECK-P8-NEXT:    mfvsrwz r4, f3
; CHECK-P8-NEXT:    xscvdpsxws f3, f7
; CHECK-P8-NEXT:    xxswapd v4, vs6
; CHECK-P8-NEXT:    mtvsrd f7, r4
; CHECK-P8-NEXT:    mfvsrwz r4, f0
; CHECK-P8-NEXT:    xscvdpsxws f0, f8
; CHECK-P8-NEXT:    xxswapd v5, vs7
; CHECK-P8-NEXT:    mtvsrd f8, r4
; CHECK-P8-NEXT:    mfvsrwz r4, f1
; CHECK-P8-NEXT:    xscvdpsxws f1, f9
; CHECK-P8-NEXT:    xxswapd v1, vs8
; CHECK-P8-NEXT:    mtvsrd f9, r4
; CHECK-P8-NEXT:    mfvsrwz r4, f3
; CHECK-P8-NEXT:    vmrglb v3, v4, v3
; CHECK-P8-NEXT:    xxswapd v4, vs2
; CHECK-P8-NEXT:    mtvsrd f3, r4
; CHECK-P8-NEXT:    xxswapd v6, vs9
; CHECK-P8-NEXT:    mfvsrwz r4, f0
; CHECK-P8-NEXT:    xscvspdpn f0, v2
; CHECK-P8-NEXT:    xxswapd v7, vs3
; CHECK-P8-NEXT:    mtvsrd f5, r4
; CHECK-P8-NEXT:    mfvsrwz r4, f1
; CHECK-P8-NEXT:    vmrglb v4, v4, v5
; CHECK-P8-NEXT:    xxswapd v5, vs5
; CHECK-P8-NEXT:    mtvsrd f1, r4
; CHECK-P8-NEXT:    li r4, 48
; CHECK-P8-NEXT:    lvx v9, r3, r4
; CHECK-P8-NEXT:    vmrglb v1, v6, v1
; CHECK-P8-NEXT:    xxswapd v8, vs1
; CHECK-P8-NEXT:    xxsldwi vs1, v2, v2, 1
; CHECK-P8-NEXT:    xxsldwi vs2, v9, v9, 3
; CHECK-P8-NEXT:    xscvspdpn f4, v9
; CHECK-P8-NEXT:    xxswapd vs3, v9
; CHECK-P8-NEXT:    xxsldwi vs5, v9, v9, 1
; CHECK-P8-NEXT:    xscvspdpn f1, vs1
; CHECK-P8-NEXT:    xscvspdpn f2, vs2
; CHECK-P8-NEXT:    xscvspdpn f3, vs3
; CHECK-P8-NEXT:    xscvspdpn f5, vs5
; CHECK-P8-NEXT:    xscvdpsxws f0, f0
; CHECK-P8-NEXT:    xscvdpsxws f4, f4
; CHECK-P8-NEXT:    xscvdpsxws f1, f1
; CHECK-P8-NEXT:    xscvdpsxws f2, f2
; CHECK-P8-NEXT:    xscvdpsxws f3, f3
; CHECK-P8-NEXT:    xscvdpsxws f5, f5
; CHECK-P8-NEXT:    mfvsrwz r3, f0
; CHECK-P8-NEXT:    mfvsrwz r4, f4
; CHECK-P8-NEXT:    mtvsrd f0, r3
; CHECK-P8-NEXT:    mtvsrd f4, r4
; CHECK-P8-NEXT:    mfvsrwz r3, f1
; CHECK-P8-NEXT:    mfvsrwz r4, f2
; CHECK-P8-NEXT:    xxswapd v9, vs4
; CHECK-P8-NEXT:    mtvsrd f1, r3
; CHECK-P8-NEXT:    mfvsrwz r3, f3
; CHECK-P8-NEXT:    mtvsrd f2, r4
; CHECK-P8-NEXT:    xxswapd v6, vs1
; CHECK-P8-NEXT:    mfvsrwz r4, f5
; CHECK-P8-NEXT:    vmrglb v2, v0, v7
; CHECK-P8-NEXT:    xxswapd v0, vs0
; CHECK-P8-NEXT:    mtvsrd f0, r3
; CHECK-P8-NEXT:    xxswapd v7, vs2
; CHECK-P8-NEXT:    mtvsrd f3, r4
; CHECK-P8-NEXT:    vmrglb v5, v8, v5
; CHECK-P8-NEXT:    xxswapd v8, vs0
; CHECK-P8-NEXT:    xxswapd v10, vs3
; CHECK-P8-NEXT:    vmrglb v0, v0, v6
; CHECK-P8-NEXT:    vmrglh v3, v4, v3
; CHECK-P8-NEXT:    vmrglb v6, v8, v7
; CHECK-P8-NEXT:    vmrglb v7, v9, v10
; CHECK-P8-NEXT:    vmrglh v2, v2, v1
; CHECK-P8-NEXT:    vmrglh v4, v0, v5
; CHECK-P8-NEXT:    vmrglh v5, v7, v6
; CHECK-P8-NEXT:    vmrglw v2, v2, v3
; CHECK-P8-NEXT:    vmrglw v3, v5, v4
; CHECK-P8-NEXT:    xxmrgld v2, v3, v2
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: test16elt:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lxv vs2, 0(r3)
; CHECK-P9-NEXT:    xxsldwi vs3, vs2, vs2, 3
; CHECK-P9-NEXT:    xscvspdpn f3, vs3
; CHECK-P9-NEXT:    xscvdpsxws f3, f3
; CHECK-P9-NEXT:    lxv vs0, 48(r3)
; CHECK-P9-NEXT:    lxv vs1, 32(r3)
; CHECK-P9-NEXT:    lxv vs4, 16(r3)
; CHECK-P9-NEXT:    mfvsrwz r3, f3
; CHECK-P9-NEXT:    mtvsrd f3, r3
; CHECK-P9-NEXT:    xxswapd v2, vs3
; CHECK-P9-NEXT:    xxswapd vs3, vs2
; CHECK-P9-NEXT:    xscvspdpn f3, vs3
; CHECK-P9-NEXT:    xscvdpsxws f3, f3
; CHECK-P9-NEXT:    mfvsrwz r3, f3
; CHECK-P9-NEXT:    mtvsrd f3, r3
; CHECK-P9-NEXT:    xxswapd v3, vs3
; CHECK-P9-NEXT:    xscvspdpn f3, vs2
; CHECK-P9-NEXT:    xxsldwi vs2, vs2, vs2, 1
; CHECK-P9-NEXT:    xscvspdpn f2, vs2
; CHECK-P9-NEXT:    xscvdpsxws f3, f3
; CHECK-P9-NEXT:    xscvdpsxws f2, f2
; CHECK-P9-NEXT:    mfvsrwz r3, f3
; CHECK-P9-NEXT:    mtvsrd f3, r3
; CHECK-P9-NEXT:    mfvsrwz r3, f2
; CHECK-P9-NEXT:    mtvsrd f2, r3
; CHECK-P9-NEXT:    xxswapd v4, vs2
; CHECK-P9-NEXT:    xxsldwi vs2, vs4, vs4, 3
; CHECK-P9-NEXT:    xscvspdpn f2, vs2
; CHECK-P9-NEXT:    xscvdpsxws f2, f2
; CHECK-P9-NEXT:    vmrglb v2, v3, v2
; CHECK-P9-NEXT:    xxswapd v3, vs3
; CHECK-P9-NEXT:    vmrglb v3, v3, v4
; CHECK-P9-NEXT:    vmrglh v2, v3, v2
; CHECK-P9-NEXT:    mfvsrwz r3, f2
; CHECK-P9-NEXT:    mtvsrd f2, r3
; CHECK-P9-NEXT:    xxswapd v3, vs2
; CHECK-P9-NEXT:    xxswapd vs2, vs4
; CHECK-P9-NEXT:    xscvspdpn f2, vs2
; CHECK-P9-NEXT:    xscvdpsxws f2, f2
; CHECK-P9-NEXT:    mfvsrwz r3, f2
; CHECK-P9-NEXT:    mtvsrd f2, r3
; CHECK-P9-NEXT:    xxswapd v4, vs2
; CHECK-P9-NEXT:    xscvspdpn f2, vs4
; CHECK-P9-NEXT:    xscvdpsxws f2, f2
; CHECK-P9-NEXT:    mfvsrwz r3, f2
; CHECK-P9-NEXT:    mtvsrd f2, r3
; CHECK-P9-NEXT:    vmrglb v3, v4, v3
; CHECK-P9-NEXT:    xxswapd v4, vs2
; CHECK-P9-NEXT:    xxsldwi vs2, vs4, vs4, 1
; CHECK-P9-NEXT:    xscvspdpn f2, vs2
; CHECK-P9-NEXT:    xscvdpsxws f2, f2
; CHECK-P9-NEXT:    mfvsrwz r3, f2
; CHECK-P9-NEXT:    mtvsrd f2, r3
; CHECK-P9-NEXT:    xxswapd v5, vs2
; CHECK-P9-NEXT:    xxsldwi vs2, vs1, vs1, 3
; CHECK-P9-NEXT:    xscvspdpn f2, vs2
; CHECK-P9-NEXT:    xscvdpsxws f2, f2
; CHECK-P9-NEXT:    vmrglb v4, v4, v5
; CHECK-P9-NEXT:    vmrglh v3, v4, v3
; CHECK-P9-NEXT:    vmrglw v2, v3, v2
; CHECK-P9-NEXT:    mfvsrwz r3, f2
; CHECK-P9-NEXT:    mtvsrd f2, r3
; CHECK-P9-NEXT:    xxswapd v3, vs2
; CHECK-P9-NEXT:    xxswapd vs2, vs1
; CHECK-P9-NEXT:    xscvspdpn f2, vs2
; CHECK-P9-NEXT:    xscvdpsxws f2, f2
; CHECK-P9-NEXT:    mfvsrwz r3, f2
; CHECK-P9-NEXT:    mtvsrd f2, r3
; CHECK-P9-NEXT:    xxswapd v4, vs2
; CHECK-P9-NEXT:    xscvspdpn f2, vs1
; CHECK-P9-NEXT:    xxsldwi vs1, vs1, vs1, 1
; CHECK-P9-NEXT:    xscvspdpn f1, vs1
; CHECK-P9-NEXT:    xscvdpsxws f2, f2
; CHECK-P9-NEXT:    xscvdpsxws f1, f1
; CHECK-P9-NEXT:    mfvsrwz r3, f2
; CHECK-P9-NEXT:    mtvsrd f2, r3
; CHECK-P9-NEXT:    mfvsrwz r3, f1
; CHECK-P9-NEXT:    mtvsrd f1, r3
; CHECK-P9-NEXT:    xxswapd v5, vs1
; CHECK-P9-NEXT:    xxsldwi vs1, vs0, vs0, 3
; CHECK-P9-NEXT:    xscvspdpn f1, vs1
; CHECK-P9-NEXT:    xscvdpsxws f1, f1
; CHECK-P9-NEXT:    vmrglb v3, v4, v3
; CHECK-P9-NEXT:    xxswapd v4, vs2
; CHECK-P9-NEXT:    vmrglb v4, v4, v5
; CHECK-P9-NEXT:    vmrglh v3, v4, v3
; CHECK-P9-NEXT:    mfvsrwz r3, f1
; CHECK-P9-NEXT:    mtvsrd f1, r3
; CHECK-P9-NEXT:    xxswapd v4, vs1
; CHECK-P9-NEXT:    xxswapd vs1, vs0
; CHECK-P9-NEXT:    xscvspdpn f1, vs1
; CHECK-P9-NEXT:    xscvdpsxws f1, f1
; CHECK-P9-NEXT:    mfvsrwz r3, f1
; CHECK-P9-NEXT:    mtvsrd f1, r3
; CHECK-P9-NEXT:    xxswapd v5, vs1
; CHECK-P9-NEXT:    xscvspdpn f1, vs0
; CHECK-P9-NEXT:    xxsldwi vs0, vs0, vs0, 1
; CHECK-P9-NEXT:    xscvspdpn f0, vs0
; CHECK-P9-NEXT:    xscvdpsxws f1, f1
; CHECK-P9-NEXT:    xscvdpsxws f0, f0
; CHECK-P9-NEXT:    mfvsrwz r3, f1
; CHECK-P9-NEXT:    mtvsrd f1, r3
; CHECK-P9-NEXT:    mfvsrwz r3, f0
; CHECK-P9-NEXT:    mtvsrd f0, r3
; CHECK-P9-NEXT:    vmrglb v4, v5, v4
; CHECK-P9-NEXT:    xxswapd v5, vs1
; CHECK-P9-NEXT:    xxswapd v0, vs0
; CHECK-P9-NEXT:    vmrglb v5, v5, v0
; CHECK-P9-NEXT:    vmrglh v4, v5, v4
; CHECK-P9-NEXT:    vmrglw v3, v4, v3
; CHECK-P9-NEXT:    xxmrgld v2, v3, v2
; CHECK-P9-NEXT:    blr
;
; CHECK-BE-LABEL: test16elt:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    lxv vs3, 48(r3)
; CHECK-BE-NEXT:    xxsldwi vs4, vs3, vs3, 3
; CHECK-BE-NEXT:    xscvspdpn f4, vs4
; CHECK-BE-NEXT:    xscvdpsxws f4, f4
; CHECK-BE-NEXT:    lxv vs0, 0(r3)
; CHECK-BE-NEXT:    lxv vs1, 16(r3)
; CHECK-BE-NEXT:    lxv vs2, 32(r3)
; CHECK-BE-NEXT:    mfvsrwz r3, f4
; CHECK-BE-NEXT:    xxswapd vs4, vs3
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    xscvspdpn f4, vs4
; CHECK-BE-NEXT:    mtvsrd v2, r3
; CHECK-BE-NEXT:    xscvdpsxws f4, f4
; CHECK-BE-NEXT:    mfvsrwz r3, f4
; CHECK-BE-NEXT:    xscvspdpn f4, vs3
; CHECK-BE-NEXT:    xxsldwi vs3, vs3, vs3, 1
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    xscvdpsxws f4, f4
; CHECK-BE-NEXT:    xscvspdpn f3, vs3
; CHECK-BE-NEXT:    mtvsrd v3, r3
; CHECK-BE-NEXT:    xscvdpsxws f3, f3
; CHECK-BE-NEXT:    vmrghb v2, v3, v2
; CHECK-BE-NEXT:    mfvsrwz r3, f4
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    mtvsrd v3, r3
; CHECK-BE-NEXT:    mfvsrwz r3, f3
; CHECK-BE-NEXT:    xxsldwi vs3, vs2, vs2, 3
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    xscvspdpn f3, vs3
; CHECK-BE-NEXT:    mtvsrd v4, r3
; CHECK-BE-NEXT:    xscvdpsxws f3, f3
; CHECK-BE-NEXT:    mfvsrwz r3, f3
; CHECK-BE-NEXT:    xxswapd vs3, vs2
; CHECK-BE-NEXT:    xscvspdpn f3, vs3
; CHECK-BE-NEXT:    xscvdpsxws f3, f3
; CHECK-BE-NEXT:    vmrghb v3, v3, v4
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    vmrghh v2, v3, v2
; CHECK-BE-NEXT:    mtvsrd v3, r3
; CHECK-BE-NEXT:    mfvsrwz r3, f3
; CHECK-BE-NEXT:    xscvspdpn f3, vs2
; CHECK-BE-NEXT:    xxsldwi vs2, vs2, vs2, 1
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    xscvdpsxws f3, f3
; CHECK-BE-NEXT:    xscvspdpn f2, vs2
; CHECK-BE-NEXT:    mtvsrd v4, r3
; CHECK-BE-NEXT:    xscvdpsxws f2, f2
; CHECK-BE-NEXT:    vmrghb v3, v4, v3
; CHECK-BE-NEXT:    mfvsrwz r3, f3
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    mtvsrd v4, r3
; CHECK-BE-NEXT:    mfvsrwz r3, f2
; CHECK-BE-NEXT:    xxsldwi vs2, vs1, vs1, 3
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    xscvspdpn f2, vs2
; CHECK-BE-NEXT:    mtvsrd v5, r3
; CHECK-BE-NEXT:    xscvdpsxws f2, f2
; CHECK-BE-NEXT:    mfvsrwz r3, f2
; CHECK-BE-NEXT:    xxswapd vs2, vs1
; CHECK-BE-NEXT:    xscvspdpn f2, vs2
; CHECK-BE-NEXT:    xscvdpsxws f2, f2
; CHECK-BE-NEXT:    vmrghb v4, v4, v5
; CHECK-BE-NEXT:    vmrghh v3, v4, v3
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    vmrghw v2, v3, v2
; CHECK-BE-NEXT:    mtvsrd v3, r3
; CHECK-BE-NEXT:    mfvsrwz r3, f2
; CHECK-BE-NEXT:    xscvspdpn f2, vs1
; CHECK-BE-NEXT:    xxsldwi vs1, vs1, vs1, 1
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    xscvdpsxws f2, f2
; CHECK-BE-NEXT:    xscvspdpn f1, vs1
; CHECK-BE-NEXT:    mtvsrd v4, r3
; CHECK-BE-NEXT:    xscvdpsxws f1, f1
; CHECK-BE-NEXT:    vmrghb v3, v4, v3
; CHECK-BE-NEXT:    mfvsrwz r3, f2
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    mtvsrd v4, r3
; CHECK-BE-NEXT:    mfvsrwz r3, f1
; CHECK-BE-NEXT:    xxsldwi vs1, vs0, vs0, 3
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    xscvspdpn f1, vs1
; CHECK-BE-NEXT:    mtvsrd v5, r3
; CHECK-BE-NEXT:    xscvdpsxws f1, f1
; CHECK-BE-NEXT:    mfvsrwz r3, f1
; CHECK-BE-NEXT:    xxswapd vs1, vs0
; CHECK-BE-NEXT:    xscvspdpn f1, vs1
; CHECK-BE-NEXT:    xscvdpsxws f1, f1
; CHECK-BE-NEXT:    vmrghb v4, v4, v5
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    vmrghh v3, v4, v3
; CHECK-BE-NEXT:    mtvsrd v4, r3
; CHECK-BE-NEXT:    mfvsrwz r3, f1
; CHECK-BE-NEXT:    xscvspdpn f1, vs0
; CHECK-BE-NEXT:    xxsldwi vs0, vs0, vs0, 1
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    xscvdpsxws f1, f1
; CHECK-BE-NEXT:    xscvspdpn f0, vs0
; CHECK-BE-NEXT:    mtvsrd v5, r3
; CHECK-BE-NEXT:    xscvdpsxws f0, f0
; CHECK-BE-NEXT:    vmrghb v4, v5, v4
; CHECK-BE-NEXT:    mfvsrwz r3, f1
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    mtvsrd v5, r3
; CHECK-BE-NEXT:    mfvsrwz r3, f0
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    mtvsrd v0, r3
; CHECK-BE-NEXT:    vmrghb v5, v5, v0
; CHECK-BE-NEXT:    vmrghh v4, v5, v4
; CHECK-BE-NEXT:    vmrghw v3, v4, v3
; CHECK-BE-NEXT:    xxmrghd v2, v3, v2
; CHECK-BE-NEXT:    blr
entry:
  %a = load <16 x float>, <16 x float>* %0, align 64
  %1 = fptoui <16 x float> %a to <16 x i8>
  ret <16 x i8> %1
}

define i16 @test2elt_signed(i64 %a.coerce) local_unnamed_addr #0 {
; CHECK-P8-LABEL: test2elt_signed:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    mtvsrd f0, r3
; CHECK-P8-NEXT:    xxswapd v2, vs0
; CHECK-P8-NEXT:    xscvspdpn f0, vs0
; CHECK-P8-NEXT:    xxsldwi vs1, v2, v2, 3
; CHECK-P8-NEXT:    xscvspdpn f1, vs1
; CHECK-P8-NEXT:    xscvdpsxws f0, f0
; CHECK-P8-NEXT:    xscvdpsxws f1, f1
; CHECK-P8-NEXT:    mfvsrwz r4, f0
; CHECK-P8-NEXT:    mfvsrwz r3, f1
; CHECK-P8-NEXT:    mtvsrd f1, r4
; CHECK-P8-NEXT:    mtvsrd f0, r3
; CHECK-P8-NEXT:    xxswapd v3, vs1
; CHECK-P8-NEXT:    xxswapd v2, vs0
; CHECK-P8-NEXT:    vmrglb v2, v3, v2
; CHECK-P8-NEXT:    xxswapd vs0, v2
; CHECK-P8-NEXT:    mfvsrd r3, f0
; CHECK-P8-NEXT:    clrldi r3, r3, 48
; CHECK-P8-NEXT:    sth r3, -2(r1)
; CHECK-P8-NEXT:    lhz r3, -2(r1)
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: test2elt_signed:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    mtvsrd f0, r3
; CHECK-P9-NEXT:    xxswapd v2, vs0
; CHECK-P9-NEXT:    xscvspdpn f0, vs0
; CHECK-P9-NEXT:    xxsldwi vs1, v2, v2, 3
; CHECK-P9-NEXT:    xscvspdpn f1, vs1
; CHECK-P9-NEXT:    xscvdpsxws f1, f1
; CHECK-P9-NEXT:    xscvdpsxws f0, f0
; CHECK-P9-NEXT:    mfvsrwz r3, f1
; CHECK-P9-NEXT:    mtvsrd f1, r3
; CHECK-P9-NEXT:    mfvsrwz r3, f0
; CHECK-P9-NEXT:    mtvsrd f0, r3
; CHECK-P9-NEXT:    xxswapd v2, vs1
; CHECK-P9-NEXT:    xxswapd v3, vs0
; CHECK-P9-NEXT:    vmrglb v2, v3, v2
; CHECK-P9-NEXT:    vsldoi v2, v2, v2, 8
; CHECK-P9-NEXT:    addi r3, r1, -2
; CHECK-P9-NEXT:    stxsihx v2, 0, r3
; CHECK-P9-NEXT:    lhz r3, -2(r1)
; CHECK-P9-NEXT:    blr
;
; CHECK-BE-LABEL: test2elt_signed:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    mtvsrd f0, r3
; CHECK-BE-NEXT:    xscvspdpn f1, vs0
; CHECK-BE-NEXT:    xxsldwi vs0, vs0, vs0, 1
; CHECK-BE-NEXT:    xscvdpsxws f1, f1
; CHECK-BE-NEXT:    xscvspdpn f0, vs0
; CHECK-BE-NEXT:    xscvdpsxws f0, f0
; CHECK-BE-NEXT:    mfvsrwz r3, f1
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    mtvsrd v2, r3
; CHECK-BE-NEXT:    mfvsrwz r3, f0
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    mtvsrd v3, r3
; CHECK-BE-NEXT:    addi r3, r1, -2
; CHECK-BE-NEXT:    vmrghb v2, v2, v3
; CHECK-BE-NEXT:    vsldoi v2, v2, v2, 10
; CHECK-BE-NEXT:    stxsihx v2, 0, r3
; CHECK-BE-NEXT:    lhz r3, -2(r1)
; CHECK-BE-NEXT:    blr
entry:
  %0 = bitcast i64 %a.coerce to <2 x float>
  %1 = fptosi <2 x float> %0 to <2 x i8>
  %2 = bitcast <2 x i8> %1 to i16
  ret i16 %2
}

define i32 @test4elt_signed(<4 x float> %a) local_unnamed_addr #1 {
; CHECK-P8-LABEL: test4elt_signed:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xxsldwi vs0, v2, v2, 3
; CHECK-P8-NEXT:    xscvspdpn f1, v2
; CHECK-P8-NEXT:    xxswapd vs2, v2
; CHECK-P8-NEXT:    xxsldwi vs3, v2, v2, 1
; CHECK-P8-NEXT:    xscvspdpn f0, vs0
; CHECK-P8-NEXT:    xscvspdpn f2, vs2
; CHECK-P8-NEXT:    xscvspdpn f3, vs3
; CHECK-P8-NEXT:    xscvdpsxws f1, f1
; CHECK-P8-NEXT:    xscvdpsxws f0, f0
; CHECK-P8-NEXT:    xscvdpsxws f2, f2
; CHECK-P8-NEXT:    xscvdpsxws f3, f3
; CHECK-P8-NEXT:    mfvsrwz r3, f1
; CHECK-P8-NEXT:    mtvsrd f1, r3
; CHECK-P8-NEXT:    mfvsrwz r3, f0
; CHECK-P8-NEXT:    mfvsrwz r4, f2
; CHECK-P8-NEXT:    xxswapd v4, vs1
; CHECK-P8-NEXT:    mtvsrd f0, r3
; CHECK-P8-NEXT:    mfvsrwz r3, f3
; CHECK-P8-NEXT:    mtvsrd f2, r4
; CHECK-P8-NEXT:    xxswapd v2, vs0
; CHECK-P8-NEXT:    mtvsrd f3, r3
; CHECK-P8-NEXT:    xxswapd v3, vs2
; CHECK-P8-NEXT:    xxswapd v5, vs3
; CHECK-P8-NEXT:    vmrglb v2, v3, v2
; CHECK-P8-NEXT:    vmrglb v3, v4, v5
; CHECK-P8-NEXT:    vmrglh v2, v3, v2
; CHECK-P8-NEXT:    xxswapd vs0, v2
; CHECK-P8-NEXT:    mfvsrwz r3, f0
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: test4elt_signed:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xxsldwi vs0, v2, v2, 3
; CHECK-P9-NEXT:    xscvspdpn f0, vs0
; CHECK-P9-NEXT:    xscvdpsxws f0, f0
; CHECK-P9-NEXT:    mfvsrwz r3, f0
; CHECK-P9-NEXT:    mtvsrd f0, r3
; CHECK-P9-NEXT:    xxswapd v3, vs0
; CHECK-P9-NEXT:    xxswapd vs0, v2
; CHECK-P9-NEXT:    xscvspdpn f0, vs0
; CHECK-P9-NEXT:    xscvdpsxws f0, f0
; CHECK-P9-NEXT:    mfvsrwz r3, f0
; CHECK-P9-NEXT:    mtvsrd f0, r3
; CHECK-P9-NEXT:    xxswapd v4, vs0
; CHECK-P9-NEXT:    xscvspdpn f0, v2
; CHECK-P9-NEXT:    xscvdpsxws f0, f0
; CHECK-P9-NEXT:    mfvsrwz r3, f0
; CHECK-P9-NEXT:    mtvsrd f0, r3
; CHECK-P9-NEXT:    vmrglb v3, v4, v3
; CHECK-P9-NEXT:    xxswapd v4, vs0
; CHECK-P9-NEXT:    xxsldwi vs0, v2, v2, 1
; CHECK-P9-NEXT:    xscvspdpn f0, vs0
; CHECK-P9-NEXT:    xscvdpsxws f0, f0
; CHECK-P9-NEXT:    mfvsrwz r3, f0
; CHECK-P9-NEXT:    mtvsrd f0, r3
; CHECK-P9-NEXT:    li r3, 0
; CHECK-P9-NEXT:    xxswapd v2, vs0
; CHECK-P9-NEXT:    vmrglb v2, v4, v2
; CHECK-P9-NEXT:    vmrglh v2, v2, v3
; CHECK-P9-NEXT:    vextuwrx r3, r3, v2
; CHECK-P9-NEXT:    blr
;
; CHECK-BE-LABEL: test4elt_signed:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    xxsldwi vs0, v2, v2, 3
; CHECK-BE-NEXT:    xscvspdpn f0, vs0
; CHECK-BE-NEXT:    xscvdpsxws f0, f0
; CHECK-BE-NEXT:    mfvsrwz r3, f0
; CHECK-BE-NEXT:    xxswapd vs0, v2
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    xscvspdpn f0, vs0
; CHECK-BE-NEXT:    mtvsrd v3, r3
; CHECK-BE-NEXT:    xscvdpsxws f0, f0
; CHECK-BE-NEXT:    mfvsrwz r3, f0
; CHECK-BE-NEXT:    xscvspdpn f0, v2
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    xscvdpsxws f0, f0
; CHECK-BE-NEXT:    mtvsrd v4, r3
; CHECK-BE-NEXT:    vmrghb v3, v4, v3
; CHECK-BE-NEXT:    mfvsrwz r3, f0
; CHECK-BE-NEXT:    xxsldwi vs0, v2, v2, 1
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    xscvspdpn f0, vs0
; CHECK-BE-NEXT:    mtvsrd v4, r3
; CHECK-BE-NEXT:    xscvdpsxws f0, f0
; CHECK-BE-NEXT:    mfvsrwz r3, f0
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    mtvsrd v2, r3
; CHECK-BE-NEXT:    li r3, 0
; CHECK-BE-NEXT:    vmrghb v2, v4, v2
; CHECK-BE-NEXT:    vmrghh v2, v2, v3
; CHECK-BE-NEXT:    vextuwlx r3, r3, v2
; CHECK-BE-NEXT:    blr
entry:
  %0 = fptosi <4 x float> %a to <4 x i8>
  %1 = bitcast <4 x i8> %0 to i32
  ret i32 %1
}

define i64 @test8elt_signed(<8 x float>* nocapture readonly) local_unnamed_addr #2 {
; CHECK-P8-LABEL: test8elt_signed:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lvx v2, 0, r3
; CHECK-P8-NEXT:    li r4, 16
; CHECK-P8-NEXT:    lvx v5, r3, r4
; CHECK-P8-NEXT:    xxswapd vs1, v2
; CHECK-P8-NEXT:    xxsldwi vs0, v2, v2, 3
; CHECK-P8-NEXT:    xxsldwi vs2, v5, v5, 3
; CHECK-P8-NEXT:    xscvspdpn f4, v5
; CHECK-P8-NEXT:    xxswapd vs3, v5
; CHECK-P8-NEXT:    xxsldwi vs5, v5, v5, 1
; CHECK-P8-NEXT:    xscvspdpn f1, vs1
; CHECK-P8-NEXT:    xscvspdpn f0, vs0
; CHECK-P8-NEXT:    xscvspdpn f2, vs2
; CHECK-P8-NEXT:    xscvspdpn f3, vs3
; CHECK-P8-NEXT:    xscvspdpn f5, vs5
; CHECK-P8-NEXT:    xscvdpsxws f4, f4
; CHECK-P8-NEXT:    xscvdpsxws f1, f1
; CHECK-P8-NEXT:    xscvdpsxws f0, f0
; CHECK-P8-NEXT:    xscvdpsxws f2, f2
; CHECK-P8-NEXT:    xscvdpsxws f3, f3
; CHECK-P8-NEXT:    xscvdpsxws f5, f5
; CHECK-P8-NEXT:    mfvsrwz r4, f4
; CHECK-P8-NEXT:    mfvsrwz r6, f1
; CHECK-P8-NEXT:    mfvsrwz r5, f0
; CHECK-P8-NEXT:    mtvsrd f1, r6
; CHECK-P8-NEXT:    mtvsrd f0, r5
; CHECK-P8-NEXT:    xxswapd v4, vs1
; CHECK-P8-NEXT:    xxsldwi vs1, v2, v2, 1
; CHECK-P8-NEXT:    xxswapd v3, vs0
; CHECK-P8-NEXT:    xscvspdpn f0, v2
; CHECK-P8-NEXT:    mtvsrd f4, r4
; CHECK-P8-NEXT:    xscvspdpn f1, vs1
; CHECK-P8-NEXT:    mfvsrwz r4, f2
; CHECK-P8-NEXT:    xxswapd v1, vs4
; CHECK-P8-NEXT:    vmrglb v2, v4, v3
; CHECK-P8-NEXT:    mtvsrd f2, r4
; CHECK-P8-NEXT:    xscvdpsxws f0, f0
; CHECK-P8-NEXT:    mfvsrwz r4, f5
; CHECK-P8-NEXT:    xxswapd v5, vs2
; CHECK-P8-NEXT:    xscvdpsxws f1, f1
; CHECK-P8-NEXT:    mfvsrwz r3, f0
; CHECK-P8-NEXT:    mtvsrd f0, r3
; CHECK-P8-NEXT:    mfvsrwz r3, f1
; CHECK-P8-NEXT:    xxswapd v3, vs0
; CHECK-P8-NEXT:    mtvsrd f1, r3
; CHECK-P8-NEXT:    mfvsrwz r3, f3
; CHECK-P8-NEXT:    mtvsrd f3, r4
; CHECK-P8-NEXT:    xxswapd v4, vs1
; CHECK-P8-NEXT:    mtvsrd f0, r3
; CHECK-P8-NEXT:    xxswapd v6, vs3
; CHECK-P8-NEXT:    xxswapd v0, vs0
; CHECK-P8-NEXT:    vmrglb v3, v3, v4
; CHECK-P8-NEXT:    vmrglb v4, v0, v5
; CHECK-P8-NEXT:    vmrglb v5, v1, v6
; CHECK-P8-NEXT:    vmrglh v2, v3, v2
; CHECK-P8-NEXT:    vmrglh v3, v5, v4
; CHECK-P8-NEXT:    vmrglw v2, v3, v2
; CHECK-P8-NEXT:    xxswapd vs0, v2
; CHECK-P8-NEXT:    mfvsrd r3, f0
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: test8elt_signed:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lxv vs1, 0(r3)
; CHECK-P9-NEXT:    xxsldwi vs2, vs1, vs1, 3
; CHECK-P9-NEXT:    xscvspdpn f2, vs2
; CHECK-P9-NEXT:    xscvdpsxws f2, f2
; CHECK-P9-NEXT:    lxv vs0, 16(r3)
; CHECK-P9-NEXT:    mfvsrwz r3, f2
; CHECK-P9-NEXT:    mtvsrd f2, r3
; CHECK-P9-NEXT:    xxswapd v2, vs2
; CHECK-P9-NEXT:    xxswapd vs2, vs1
; CHECK-P9-NEXT:    xscvspdpn f2, vs2
; CHECK-P9-NEXT:    xscvdpsxws f2, f2
; CHECK-P9-NEXT:    mfvsrwz r3, f2
; CHECK-P9-NEXT:    mtvsrd f2, r3
; CHECK-P9-NEXT:    xxswapd v3, vs2
; CHECK-P9-NEXT:    xscvspdpn f2, vs1
; CHECK-P9-NEXT:    xxsldwi vs1, vs1, vs1, 1
; CHECK-P9-NEXT:    xscvspdpn f1, vs1
; CHECK-P9-NEXT:    xscvdpsxws f2, f2
; CHECK-P9-NEXT:    xscvdpsxws f1, f1
; CHECK-P9-NEXT:    mfvsrwz r3, f2
; CHECK-P9-NEXT:    mtvsrd f2, r3
; CHECK-P9-NEXT:    mfvsrwz r3, f1
; CHECK-P9-NEXT:    mtvsrd f1, r3
; CHECK-P9-NEXT:    xxswapd v4, vs1
; CHECK-P9-NEXT:    xxsldwi vs1, vs0, vs0, 3
; CHECK-P9-NEXT:    xscvspdpn f1, vs1
; CHECK-P9-NEXT:    xscvdpsxws f1, f1
; CHECK-P9-NEXT:    vmrglb v2, v3, v2
; CHECK-P9-NEXT:    xxswapd v3, vs2
; CHECK-P9-NEXT:    vmrglb v3, v3, v4
; CHECK-P9-NEXT:    vmrglh v2, v3, v2
; CHECK-P9-NEXT:    mfvsrwz r3, f1
; CHECK-P9-NEXT:    mtvsrd f1, r3
; CHECK-P9-NEXT:    xxswapd v3, vs1
; CHECK-P9-NEXT:    xxswapd vs1, vs0
; CHECK-P9-NEXT:    xscvspdpn f1, vs1
; CHECK-P9-NEXT:    xscvdpsxws f1, f1
; CHECK-P9-NEXT:    mfvsrwz r3, f1
; CHECK-P9-NEXT:    mtvsrd f1, r3
; CHECK-P9-NEXT:    xxswapd v4, vs1
; CHECK-P9-NEXT:    xscvspdpn f1, vs0
; CHECK-P9-NEXT:    xxsldwi vs0, vs0, vs0, 1
; CHECK-P9-NEXT:    xscvspdpn f0, vs0
; CHECK-P9-NEXT:    xscvdpsxws f1, f1
; CHECK-P9-NEXT:    xscvdpsxws f0, f0
; CHECK-P9-NEXT:    mfvsrwz r3, f1
; CHECK-P9-NEXT:    mtvsrd f1, r3
; CHECK-P9-NEXT:    mfvsrwz r3, f0
; CHECK-P9-NEXT:    mtvsrd f0, r3
; CHECK-P9-NEXT:    vmrglb v3, v4, v3
; CHECK-P9-NEXT:    xxswapd v4, vs1
; CHECK-P9-NEXT:    xxswapd v5, vs0
; CHECK-P9-NEXT:    vmrglb v4, v4, v5
; CHECK-P9-NEXT:    vmrglh v3, v4, v3
; CHECK-P9-NEXT:    vmrglw v2, v3, v2
; CHECK-P9-NEXT:    mfvsrld r3, v2
; CHECK-P9-NEXT:    blr
;
; CHECK-BE-LABEL: test8elt_signed:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    lxv vs1, 16(r3)
; CHECK-BE-NEXT:    xxsldwi vs2, vs1, vs1, 3
; CHECK-BE-NEXT:    xscvspdpn f2, vs2
; CHECK-BE-NEXT:    xscvdpsxws f2, f2
; CHECK-BE-NEXT:    lxv vs0, 0(r3)
; CHECK-BE-NEXT:    mfvsrwz r3, f2
; CHECK-BE-NEXT:    xxswapd vs2, vs1
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    xscvspdpn f2, vs2
; CHECK-BE-NEXT:    mtvsrd v2, r3
; CHECK-BE-NEXT:    xscvdpsxws f2, f2
; CHECK-BE-NEXT:    mfvsrwz r3, f2
; CHECK-BE-NEXT:    xscvspdpn f2, vs1
; CHECK-BE-NEXT:    xxsldwi vs1, vs1, vs1, 1
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    xscvdpsxws f2, f2
; CHECK-BE-NEXT:    xscvspdpn f1, vs1
; CHECK-BE-NEXT:    mtvsrd v3, r3
; CHECK-BE-NEXT:    xscvdpsxws f1, f1
; CHECK-BE-NEXT:    vmrghb v2, v3, v2
; CHECK-BE-NEXT:    mfvsrwz r3, f2
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    mtvsrd v3, r3
; CHECK-BE-NEXT:    mfvsrwz r3, f1
; CHECK-BE-NEXT:    xxsldwi vs1, vs0, vs0, 3
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    xscvspdpn f1, vs1
; CHECK-BE-NEXT:    mtvsrd v4, r3
; CHECK-BE-NEXT:    xscvdpsxws f1, f1
; CHECK-BE-NEXT:    mfvsrwz r3, f1
; CHECK-BE-NEXT:    xxswapd vs1, vs0
; CHECK-BE-NEXT:    xscvspdpn f1, vs1
; CHECK-BE-NEXT:    xscvdpsxws f1, f1
; CHECK-BE-NEXT:    vmrghb v3, v3, v4
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    vmrghh v2, v3, v2
; CHECK-BE-NEXT:    mtvsrd v3, r3
; CHECK-BE-NEXT:    mfvsrwz r3, f1
; CHECK-BE-NEXT:    xscvspdpn f1, vs0
; CHECK-BE-NEXT:    xxsldwi vs0, vs0, vs0, 1
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    xscvdpsxws f1, f1
; CHECK-BE-NEXT:    xscvspdpn f0, vs0
; CHECK-BE-NEXT:    mtvsrd v4, r3
; CHECK-BE-NEXT:    xscvdpsxws f0, f0
; CHECK-BE-NEXT:    vmrghb v3, v4, v3
; CHECK-BE-NEXT:    mfvsrwz r3, f1
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    mtvsrd v4, r3
; CHECK-BE-NEXT:    mfvsrwz r3, f0
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    mtvsrd v5, r3
; CHECK-BE-NEXT:    vmrghb v4, v4, v5
; CHECK-BE-NEXT:    vmrghh v3, v4, v3
; CHECK-BE-NEXT:    vmrghw v2, v3, v2
; CHECK-BE-NEXT:    mfvsrd r3, v2
; CHECK-BE-NEXT:    blr
entry:
  %a = load <8 x float>, <8 x float>* %0, align 32
  %1 = fptosi <8 x float> %a to <8 x i8>
  %2 = bitcast <8 x i8> %1 to i64
  ret i64 %2
}

define <16 x i8> @test16elt_signed(<16 x float>* nocapture readonly) local_unnamed_addr #3 {
; CHECK-P8-LABEL: test16elt_signed:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lvx v2, 0, r3
; CHECK-P8-NEXT:    li r4, 16
; CHECK-P8-NEXT:    lvx v3, r3, r4
; CHECK-P8-NEXT:    li r4, 32
; CHECK-P8-NEXT:    xscvspdpn f2, v2
; CHECK-P8-NEXT:    xxsldwi vs0, v2, v2, 3
; CHECK-P8-NEXT:    xscvspdpn f4, v3
; CHECK-P8-NEXT:    xxswapd vs1, v2
; CHECK-P8-NEXT:    xxsldwi vs3, v2, v2, 1
; CHECK-P8-NEXT:    xxsldwi vs5, v3, v3, 3
; CHECK-P8-NEXT:    lvx v2, r3, r4
; CHECK-P8-NEXT:    xscvspdpn f0, vs0
; CHECK-P8-NEXT:    xxswapd vs6, v3
; CHECK-P8-NEXT:    xscvspdpn f1, vs1
; CHECK-P8-NEXT:    xxsldwi vs7, v3, v3, 1
; CHECK-P8-NEXT:    xscvspdpn f3, vs3
; CHECK-P8-NEXT:    xxsldwi vs8, v2, v2, 3
; CHECK-P8-NEXT:    xscvdpsxws f2, f2
; CHECK-P8-NEXT:    xxswapd vs9, v2
; CHECK-P8-NEXT:    xscvdpsxws f4, f4
; CHECK-P8-NEXT:    xscvspdpn f5, vs5
; CHECK-P8-NEXT:    xscvdpsxws f0, f0
; CHECK-P8-NEXT:    xscvspdpn f6, vs6
; CHECK-P8-NEXT:    xscvdpsxws f1, f1
; CHECK-P8-NEXT:    mfvsrwz r4, f2
; CHECK-P8-NEXT:    xscvspdpn f7, vs7
; CHECK-P8-NEXT:    mtvsrd f2, r4
; CHECK-P8-NEXT:    mfvsrwz r4, f4
; CHECK-P8-NEXT:    xscvdpsxws f3, f3
; CHECK-P8-NEXT:    xscvspdpn f8, vs8
; CHECK-P8-NEXT:    mtvsrd f4, r4
; CHECK-P8-NEXT:    mfvsrwz r4, f0
; CHECK-P8-NEXT:    xscvdpsxws f0, f5
; CHECK-P8-NEXT:    xxswapd v0, vs4
; CHECK-P8-NEXT:    xscvspdpn f9, vs9
; CHECK-P8-NEXT:    mtvsrd f5, r4
; CHECK-P8-NEXT:    mfvsrwz r4, f1
; CHECK-P8-NEXT:    xscvdpsxws f1, f6
; CHECK-P8-NEXT:    xxswapd v3, vs5
; CHECK-P8-NEXT:    mtvsrd f6, r4
; CHECK-P8-NEXT:    mfvsrwz r4, f3
; CHECK-P8-NEXT:    xscvdpsxws f3, f7
; CHECK-P8-NEXT:    xxswapd v4, vs6
; CHECK-P8-NEXT:    mtvsrd f7, r4
; CHECK-P8-NEXT:    mfvsrwz r4, f0
; CHECK-P8-NEXT:    xscvdpsxws f0, f8
; CHECK-P8-NEXT:    xxswapd v5, vs7
; CHECK-P8-NEXT:    mtvsrd f8, r4
; CHECK-P8-NEXT:    mfvsrwz r4, f1
; CHECK-P8-NEXT:    xscvdpsxws f1, f9
; CHECK-P8-NEXT:    xxswapd v1, vs8
; CHECK-P8-NEXT:    mtvsrd f9, r4
; CHECK-P8-NEXT:    mfvsrwz r4, f3
; CHECK-P8-NEXT:    vmrglb v3, v4, v3
; CHECK-P8-NEXT:    xxswapd v4, vs2
; CHECK-P8-NEXT:    mtvsrd f3, r4
; CHECK-P8-NEXT:    xxswapd v6, vs9
; CHECK-P8-NEXT:    mfvsrwz r4, f0
; CHECK-P8-NEXT:    xscvspdpn f0, v2
; CHECK-P8-NEXT:    xxswapd v7, vs3
; CHECK-P8-NEXT:    mtvsrd f5, r4
; CHECK-P8-NEXT:    mfvsrwz r4, f1
; CHECK-P8-NEXT:    vmrglb v4, v4, v5
; CHECK-P8-NEXT:    xxswapd v5, vs5
; CHECK-P8-NEXT:    mtvsrd f1, r4
; CHECK-P8-NEXT:    li r4, 48
; CHECK-P8-NEXT:    lvx v9, r3, r4
; CHECK-P8-NEXT:    vmrglb v1, v6, v1
; CHECK-P8-NEXT:    xxswapd v8, vs1
; CHECK-P8-NEXT:    xxsldwi vs1, v2, v2, 1
; CHECK-P8-NEXT:    xxsldwi vs2, v9, v9, 3
; CHECK-P8-NEXT:    xscvspdpn f4, v9
; CHECK-P8-NEXT:    xxswapd vs3, v9
; CHECK-P8-NEXT:    xxsldwi vs5, v9, v9, 1
; CHECK-P8-NEXT:    xscvspdpn f1, vs1
; CHECK-P8-NEXT:    xscvspdpn f2, vs2
; CHECK-P8-NEXT:    xscvspdpn f3, vs3
; CHECK-P8-NEXT:    xscvspdpn f5, vs5
; CHECK-P8-NEXT:    xscvdpsxws f0, f0
; CHECK-P8-NEXT:    xscvdpsxws f4, f4
; CHECK-P8-NEXT:    xscvdpsxws f1, f1
; CHECK-P8-NEXT:    xscvdpsxws f2, f2
; CHECK-P8-NEXT:    xscvdpsxws f3, f3
; CHECK-P8-NEXT:    xscvdpsxws f5, f5
; CHECK-P8-NEXT:    mfvsrwz r3, f0
; CHECK-P8-NEXT:    mfvsrwz r4, f4
; CHECK-P8-NEXT:    mtvsrd f0, r3
; CHECK-P8-NEXT:    mtvsrd f4, r4
; CHECK-P8-NEXT:    mfvsrwz r3, f1
; CHECK-P8-NEXT:    mfvsrwz r4, f2
; CHECK-P8-NEXT:    xxswapd v9, vs4
; CHECK-P8-NEXT:    mtvsrd f1, r3
; CHECK-P8-NEXT:    mfvsrwz r3, f3
; CHECK-P8-NEXT:    mtvsrd f2, r4
; CHECK-P8-NEXT:    xxswapd v6, vs1
; CHECK-P8-NEXT:    mfvsrwz r4, f5
; CHECK-P8-NEXT:    vmrglb v2, v0, v7
; CHECK-P8-NEXT:    xxswapd v0, vs0
; CHECK-P8-NEXT:    mtvsrd f0, r3
; CHECK-P8-NEXT:    xxswapd v7, vs2
; CHECK-P8-NEXT:    mtvsrd f3, r4
; CHECK-P8-NEXT:    vmrglb v5, v8, v5
; CHECK-P8-NEXT:    xxswapd v8, vs0
; CHECK-P8-NEXT:    xxswapd v10, vs3
; CHECK-P8-NEXT:    vmrglb v0, v0, v6
; CHECK-P8-NEXT:    vmrglh v3, v4, v3
; CHECK-P8-NEXT:    vmrglb v6, v8, v7
; CHECK-P8-NEXT:    vmrglb v7, v9, v10
; CHECK-P8-NEXT:    vmrglh v2, v2, v1
; CHECK-P8-NEXT:    vmrglh v4, v0, v5
; CHECK-P8-NEXT:    vmrglh v5, v7, v6
; CHECK-P8-NEXT:    vmrglw v2, v2, v3
; CHECK-P8-NEXT:    vmrglw v3, v5, v4
; CHECK-P8-NEXT:    xxmrgld v2, v3, v2
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: test16elt_signed:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lxv vs2, 0(r3)
; CHECK-P9-NEXT:    xxsldwi vs3, vs2, vs2, 3
; CHECK-P9-NEXT:    xscvspdpn f3, vs3
; CHECK-P9-NEXT:    xscvdpsxws f3, f3
; CHECK-P9-NEXT:    lxv vs0, 48(r3)
; CHECK-P9-NEXT:    lxv vs1, 32(r3)
; CHECK-P9-NEXT:    lxv vs4, 16(r3)
; CHECK-P9-NEXT:    mfvsrwz r3, f3
; CHECK-P9-NEXT:    mtvsrd f3, r3
; CHECK-P9-NEXT:    xxswapd v2, vs3
; CHECK-P9-NEXT:    xxswapd vs3, vs2
; CHECK-P9-NEXT:    xscvspdpn f3, vs3
; CHECK-P9-NEXT:    xscvdpsxws f3, f3
; CHECK-P9-NEXT:    mfvsrwz r3, f3
; CHECK-P9-NEXT:    mtvsrd f3, r3
; CHECK-P9-NEXT:    xxswapd v3, vs3
; CHECK-P9-NEXT:    xscvspdpn f3, vs2
; CHECK-P9-NEXT:    xxsldwi vs2, vs2, vs2, 1
; CHECK-P9-NEXT:    xscvspdpn f2, vs2
; CHECK-P9-NEXT:    xscvdpsxws f3, f3
; CHECK-P9-NEXT:    xscvdpsxws f2, f2
; CHECK-P9-NEXT:    mfvsrwz r3, f3
; CHECK-P9-NEXT:    mtvsrd f3, r3
; CHECK-P9-NEXT:    mfvsrwz r3, f2
; CHECK-P9-NEXT:    mtvsrd f2, r3
; CHECK-P9-NEXT:    xxswapd v4, vs2
; CHECK-P9-NEXT:    xxsldwi vs2, vs4, vs4, 3
; CHECK-P9-NEXT:    xscvspdpn f2, vs2
; CHECK-P9-NEXT:    xscvdpsxws f2, f2
; CHECK-P9-NEXT:    vmrglb v2, v3, v2
; CHECK-P9-NEXT:    xxswapd v3, vs3
; CHECK-P9-NEXT:    vmrglb v3, v3, v4
; CHECK-P9-NEXT:    vmrglh v2, v3, v2
; CHECK-P9-NEXT:    mfvsrwz r3, f2
; CHECK-P9-NEXT:    mtvsrd f2, r3
; CHECK-P9-NEXT:    xxswapd v3, vs2
; CHECK-P9-NEXT:    xxswapd vs2, vs4
; CHECK-P9-NEXT:    xscvspdpn f2, vs2
; CHECK-P9-NEXT:    xscvdpsxws f2, f2
; CHECK-P9-NEXT:    mfvsrwz r3, f2
; CHECK-P9-NEXT:    mtvsrd f2, r3
; CHECK-P9-NEXT:    xxswapd v4, vs2
; CHECK-P9-NEXT:    xscvspdpn f2, vs4
; CHECK-P9-NEXT:    xscvdpsxws f2, f2
; CHECK-P9-NEXT:    mfvsrwz r3, f2
; CHECK-P9-NEXT:    mtvsrd f2, r3
; CHECK-P9-NEXT:    vmrglb v3, v4, v3
; CHECK-P9-NEXT:    xxswapd v4, vs2
; CHECK-P9-NEXT:    xxsldwi vs2, vs4, vs4, 1
; CHECK-P9-NEXT:    xscvspdpn f2, vs2
; CHECK-P9-NEXT:    xscvdpsxws f2, f2
; CHECK-P9-NEXT:    mfvsrwz r3, f2
; CHECK-P9-NEXT:    mtvsrd f2, r3
; CHECK-P9-NEXT:    xxswapd v5, vs2
; CHECK-P9-NEXT:    xxsldwi vs2, vs1, vs1, 3
; CHECK-P9-NEXT:    xscvspdpn f2, vs2
; CHECK-P9-NEXT:    xscvdpsxws f2, f2
; CHECK-P9-NEXT:    vmrglb v4, v4, v5
; CHECK-P9-NEXT:    vmrglh v3, v4, v3
; CHECK-P9-NEXT:    vmrglw v2, v3, v2
; CHECK-P9-NEXT:    mfvsrwz r3, f2
; CHECK-P9-NEXT:    mtvsrd f2, r3
; CHECK-P9-NEXT:    xxswapd v3, vs2
; CHECK-P9-NEXT:    xxswapd vs2, vs1
; CHECK-P9-NEXT:    xscvspdpn f2, vs2
; CHECK-P9-NEXT:    xscvdpsxws f2, f2
; CHECK-P9-NEXT:    mfvsrwz r3, f2
; CHECK-P9-NEXT:    mtvsrd f2, r3
; CHECK-P9-NEXT:    xxswapd v4, vs2
; CHECK-P9-NEXT:    xscvspdpn f2, vs1
; CHECK-P9-NEXT:    xxsldwi vs1, vs1, vs1, 1
; CHECK-P9-NEXT:    xscvspdpn f1, vs1
; CHECK-P9-NEXT:    xscvdpsxws f2, f2
; CHECK-P9-NEXT:    xscvdpsxws f1, f1
; CHECK-P9-NEXT:    mfvsrwz r3, f2
; CHECK-P9-NEXT:    mtvsrd f2, r3
; CHECK-P9-NEXT:    mfvsrwz r3, f1
; CHECK-P9-NEXT:    mtvsrd f1, r3
; CHECK-P9-NEXT:    xxswapd v5, vs1
; CHECK-P9-NEXT:    xxsldwi vs1, vs0, vs0, 3
; CHECK-P9-NEXT:    xscvspdpn f1, vs1
; CHECK-P9-NEXT:    xscvdpsxws f1, f1
; CHECK-P9-NEXT:    vmrglb v3, v4, v3
; CHECK-P9-NEXT:    xxswapd v4, vs2
; CHECK-P9-NEXT:    vmrglb v4, v4, v5
; CHECK-P9-NEXT:    vmrglh v3, v4, v3
; CHECK-P9-NEXT:    mfvsrwz r3, f1
; CHECK-P9-NEXT:    mtvsrd f1, r3
; CHECK-P9-NEXT:    xxswapd v4, vs1
; CHECK-P9-NEXT:    xxswapd vs1, vs0
; CHECK-P9-NEXT:    xscvspdpn f1, vs1
; CHECK-P9-NEXT:    xscvdpsxws f1, f1
; CHECK-P9-NEXT:    mfvsrwz r3, f1
; CHECK-P9-NEXT:    mtvsrd f1, r3
; CHECK-P9-NEXT:    xxswapd v5, vs1
; CHECK-P9-NEXT:    xscvspdpn f1, vs0
; CHECK-P9-NEXT:    xxsldwi vs0, vs0, vs0, 1
; CHECK-P9-NEXT:    xscvspdpn f0, vs0
; CHECK-P9-NEXT:    xscvdpsxws f1, f1
; CHECK-P9-NEXT:    xscvdpsxws f0, f0
; CHECK-P9-NEXT:    mfvsrwz r3, f1
; CHECK-P9-NEXT:    mtvsrd f1, r3
; CHECK-P9-NEXT:    mfvsrwz r3, f0
; CHECK-P9-NEXT:    mtvsrd f0, r3
; CHECK-P9-NEXT:    vmrglb v4, v5, v4
; CHECK-P9-NEXT:    xxswapd v5, vs1
; CHECK-P9-NEXT:    xxswapd v0, vs0
; CHECK-P9-NEXT:    vmrglb v5, v5, v0
; CHECK-P9-NEXT:    vmrglh v4, v5, v4
; CHECK-P9-NEXT:    vmrglw v3, v4, v3
; CHECK-P9-NEXT:    xxmrgld v2, v3, v2
; CHECK-P9-NEXT:    blr
;
; CHECK-BE-LABEL: test16elt_signed:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    lxv vs3, 48(r3)
; CHECK-BE-NEXT:    xxsldwi vs4, vs3, vs3, 3
; CHECK-BE-NEXT:    xscvspdpn f4, vs4
; CHECK-BE-NEXT:    xscvdpsxws f4, f4
; CHECK-BE-NEXT:    lxv vs0, 0(r3)
; CHECK-BE-NEXT:    lxv vs1, 16(r3)
; CHECK-BE-NEXT:    lxv vs2, 32(r3)
; CHECK-BE-NEXT:    mfvsrwz r3, f4
; CHECK-BE-NEXT:    xxswapd vs4, vs3
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    xscvspdpn f4, vs4
; CHECK-BE-NEXT:    mtvsrd v2, r3
; CHECK-BE-NEXT:    xscvdpsxws f4, f4
; CHECK-BE-NEXT:    mfvsrwz r3, f4
; CHECK-BE-NEXT:    xscvspdpn f4, vs3
; CHECK-BE-NEXT:    xxsldwi vs3, vs3, vs3, 1
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    xscvdpsxws f4, f4
; CHECK-BE-NEXT:    xscvspdpn f3, vs3
; CHECK-BE-NEXT:    mtvsrd v3, r3
; CHECK-BE-NEXT:    xscvdpsxws f3, f3
; CHECK-BE-NEXT:    vmrghb v2, v3, v2
; CHECK-BE-NEXT:    mfvsrwz r3, f4
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    mtvsrd v3, r3
; CHECK-BE-NEXT:    mfvsrwz r3, f3
; CHECK-BE-NEXT:    xxsldwi vs3, vs2, vs2, 3
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    xscvspdpn f3, vs3
; CHECK-BE-NEXT:    mtvsrd v4, r3
; CHECK-BE-NEXT:    xscvdpsxws f3, f3
; CHECK-BE-NEXT:    mfvsrwz r3, f3
; CHECK-BE-NEXT:    xxswapd vs3, vs2
; CHECK-BE-NEXT:    xscvspdpn f3, vs3
; CHECK-BE-NEXT:    xscvdpsxws f3, f3
; CHECK-BE-NEXT:    vmrghb v3, v3, v4
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    vmrghh v2, v3, v2
; CHECK-BE-NEXT:    mtvsrd v3, r3
; CHECK-BE-NEXT:    mfvsrwz r3, f3
; CHECK-BE-NEXT:    xscvspdpn f3, vs2
; CHECK-BE-NEXT:    xxsldwi vs2, vs2, vs2, 1
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    xscvdpsxws f3, f3
; CHECK-BE-NEXT:    xscvspdpn f2, vs2
; CHECK-BE-NEXT:    mtvsrd v4, r3
; CHECK-BE-NEXT:    xscvdpsxws f2, f2
; CHECK-BE-NEXT:    vmrghb v3, v4, v3
; CHECK-BE-NEXT:    mfvsrwz r3, f3
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    mtvsrd v4, r3
; CHECK-BE-NEXT:    mfvsrwz r3, f2
; CHECK-BE-NEXT:    xxsldwi vs2, vs1, vs1, 3
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    xscvspdpn f2, vs2
; CHECK-BE-NEXT:    mtvsrd v5, r3
; CHECK-BE-NEXT:    xscvdpsxws f2, f2
; CHECK-BE-NEXT:    mfvsrwz r3, f2
; CHECK-BE-NEXT:    xxswapd vs2, vs1
; CHECK-BE-NEXT:    xscvspdpn f2, vs2
; CHECK-BE-NEXT:    xscvdpsxws f2, f2
; CHECK-BE-NEXT:    vmrghb v4, v4, v5
; CHECK-BE-NEXT:    vmrghh v3, v4, v3
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    vmrghw v2, v3, v2
; CHECK-BE-NEXT:    mtvsrd v3, r3
; CHECK-BE-NEXT:    mfvsrwz r3, f2
; CHECK-BE-NEXT:    xscvspdpn f2, vs1
; CHECK-BE-NEXT:    xxsldwi vs1, vs1, vs1, 1
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    xscvdpsxws f2, f2
; CHECK-BE-NEXT:    xscvspdpn f1, vs1
; CHECK-BE-NEXT:    mtvsrd v4, r3
; CHECK-BE-NEXT:    xscvdpsxws f1, f1
; CHECK-BE-NEXT:    vmrghb v3, v4, v3
; CHECK-BE-NEXT:    mfvsrwz r3, f2
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    mtvsrd v4, r3
; CHECK-BE-NEXT:    mfvsrwz r3, f1
; CHECK-BE-NEXT:    xxsldwi vs1, vs0, vs0, 3
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    xscvspdpn f1, vs1
; CHECK-BE-NEXT:    mtvsrd v5, r3
; CHECK-BE-NEXT:    xscvdpsxws f1, f1
; CHECK-BE-NEXT:    mfvsrwz r3, f1
; CHECK-BE-NEXT:    xxswapd vs1, vs0
; CHECK-BE-NEXT:    xscvspdpn f1, vs1
; CHECK-BE-NEXT:    xscvdpsxws f1, f1
; CHECK-BE-NEXT:    vmrghb v4, v4, v5
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    vmrghh v3, v4, v3
; CHECK-BE-NEXT:    mtvsrd v4, r3
; CHECK-BE-NEXT:    mfvsrwz r3, f1
; CHECK-BE-NEXT:    xscvspdpn f1, vs0
; CHECK-BE-NEXT:    xxsldwi vs0, vs0, vs0, 1
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    xscvdpsxws f1, f1
; CHECK-BE-NEXT:    xscvspdpn f0, vs0
; CHECK-BE-NEXT:    mtvsrd v5, r3
; CHECK-BE-NEXT:    xscvdpsxws f0, f0
; CHECK-BE-NEXT:    vmrghb v4, v5, v4
; CHECK-BE-NEXT:    mfvsrwz r3, f1
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    mtvsrd v5, r3
; CHECK-BE-NEXT:    mfvsrwz r3, f0
; CHECK-BE-NEXT:    sldi r3, r3, 56
; CHECK-BE-NEXT:    mtvsrd v0, r3
; CHECK-BE-NEXT:    vmrghb v5, v5, v0
; CHECK-BE-NEXT:    vmrghh v4, v5, v4
; CHECK-BE-NEXT:    vmrghw v3, v4, v3
; CHECK-BE-NEXT:    xxmrghd v2, v3, v2
; CHECK-BE-NEXT:    blr
entry:
  %a = load <16 x float>, <16 x float>* %0, align 64
  %1 = fptosi <16 x float> %a to <16 x i8>
  ret <16 x i8> %1
}
