from .. import Provider as AddressProvider


class Provider(AddressProvider):
    address_formats = ["{{street_address}}, {{city_name}}, {{postcode}}"]
    building_number_formats = ["#", "##", "###"]
    city_formats = ["{{city_prefix}} {{city_name}}"]
    street_address_formats = (
        "{{street_prefix}} {{street_name}}, буд. {{building_number}}",
        "{{street_prefix}} {{street_name}}, буд. {{building_number}} кв. {{building_number}}",
    )

    street_name_formats = "{{street_prefix}} {{street_title}}"

    city_prefixes = ["місто", "село", "селище", "хутір"]

    city_names = (
        "Авдіївка",
        "Алмазна",
        "Алупка",
        "Алушта",
        "Алчевськ",
        "Амвросіївка",
        "Ананьїв",
        "Андрушівка",
        "Антрацит",
        "Апостолове",
        "Армянськ",
        "Арциз",
        "Балаклія",
        "Балта",
        "Бар",
        "Баранівка",
        "Барвінкове",
        "Батурин",
        "Бахмач",
        "Бахмут",
        "Бахчисарай",
        "Баштанка",
        "Белз",
        "Бердичів",
        "Бердянськ",
        "Берегове",
        "Бережани",
        "Березань",
        "Березівка",
        "Березне",
        "Берестечко",
        "Берислав",
        "Бершадь",
        "Бібрка",
        "Біла Церква",
        "Білгород-Дністровський",
        "Білицьке",
        "Білогірськ",
        "Білозерське",
        "Білопілля",
        "Біляївка",
        "Благовіщенське",
        "Бобринець",
        "Бобровиця",
        "Богодухів",
        "Богуслав",
        "Боково-Хрустальне",
        "Болград",
        "Болехів",
        "Борзна",
        "Борислав",
        "Бориспіль",
        "Борщів",
        "Боярка",
        "Бровари",
        "Броди",
        "Брянка",
        "Бунге",
        "Буринь",
        "Бурштин",
        "Буськ",
        "Буча",
        "Бучач",
        "Валки",
        "Вараш",
        "Василівка",
        "Васильків",
        "Багачеве",
        "Вашківці",
        "Великі Мости",
        "Верхівцеве",
        "Верхньодніпровськ",
        "Вижниця",
        "Вилкове",
        "Винники",
        "Виноградів",
        "Вишгород",
        "Вишневе",
        "Вільногірськ",
        "Вільнянськ",
        "Вінниця",
        "Вовчанськ",
        "Вознесенівка",
        "Вознесенськ",
        "Волноваха",
        "Володимир-Волинський",
        "Волочиськ",
        "Ворожба",
        "Вуглегірськ",
        "Вугледар",
        "Гадяч",
        "Гайворон",
        "Гайсин",
        "Галич",
        "Генічеськ",
        "Герца",
        "Гірник",
        "Гірське",
        "Глиняни",
        "Глобине",
        "Глухів",
        "Гнівань",
        "Гола Пристань",
        "Голубівка",
        "Горішні Плавні",
        "Горлівка",
        "Городенка",
        "Городище",
        "Городня",
        "Городок",
        "Горохів",
        "Гребінка",
        "Гуляйполе",
        "Дебальцеве",
        "Деражня",
        "Дергачі",
        "Джанкой",
        "Дніпро",
        "Дніпрорудне",
        "Добромиль",
        "Добропілля",
        "Довжанськ",
        "Докучаєвськ",
        "Долина",
        "Долинська",
        "Донецьк",
        "Дрогобич",
        "Хутір-Михайлівський",
        "Дружківка",
        "Дубляни",
        "Дубно",
        "Дубровиця",
        "Дунаївці",
        "Енергодар",
        "Євпаторія",
        "Єнакієве",
        "Жашків",
        "Жданівка",
        "Жидачів",
        "Житомир",
        "Жмеринка",
        "Жовква",
        "Жовті Води",
        "Заводське",
        "Залізне",
        "Заліщики",
        "Запоріжжя",
        "Заставна",
        "Збараж",
        "Зборів",
        "Звенигородка",
        "Здолбунів",
        "Зеленодольськ",
        "Зимогір'я",
        "Зіньків",
        "Зміїв",
        "Знам'янка",
        "Золоте",
        "Золотоноша",
        "Золочів",
        "Зоринськ",
        "Зугрес",
        "Івано-Франківськ",
        "Ізмаїл",
        "Ізюм",
        "Ізяслав",
        "Іллінці",
        "Іловайськ",
        "Інкерман",
        "Ірміно",
        "Ірпінь",
        "Іршава",
        "Ічня",
        "Кагарлик",
        "Кадіївка",
        "Калинівка",
        "Калуш",
        "Кальміуське",
        "Кам'янець-Подільський",
        "Кам'янка (Черкаська область)",
        "Кам'янка-Бузька",
        "Кам'янка-Дніпровська",
        "Кам'янське",
        "Камінь-Каширський",
        "Канів",
        "Карлівка",
        "Каховка",
        "Керч",
        "Київ",
        "Кипуче",
        "Ківерці",
        "Кілія",
        "Кіцмань",
        "Кобеляки",
        "Ковель",
        "Кодима",
        "Козятин",
        "Коломия",
        "Комарно",
        "Конотоп",
        "Копичинці",
        "Корець",
        "Коростень",
        "Коростишів",
        "Корсунь-Шевченківський",
        "Корюківка",
        "Косів",
        "Костопіль",
        "Костянтинівка",
        "Краматорськ",
        "Красилів",
        "Красногорівка",
        "Берестин",
        "Красноперекопськ",
        "Кременець",
        "Кременчук",
        "Кремінна",
        "Кривий Ріг",
        "Кролевець",
        "Кропивницький",
        "Куп'янськ",
        "Курахове",
        "Ладижин",
        "Ланівці",
        "Лебедин",
        "Лиман",
        "Липовець",
        "Лисичанськ",
        "Лозова",
        "Лохвиця",
        "Лубни",
        "Луганськ",
        "Лутугине",
        "Луцьк",
        "Львів",
        "Любомль",
        "Люботин",
        "Макіївка",
        "Мала Виска",
        "Малин",
        "Мар'їнка",
        "Марганець",
        "Маріуполь",
        "Мелітополь",
        "Мена",
        "Мерефа",
        "Миколаїв",
        "Миколаївка",
        "Миргород",
        "Мирноград",
        "Миронівка",
        "Міусинськ",
        "Могилів-Подільський",
        "Отаманівка",
        "Молочанськ",
        "Монастириська",
        "Монастирище",
        "Моршин",
        "Моспине",
        "Мостиська",
        "Мукачево",
        "Надвірна",
        "Немирів",
        "Нетішин",
        "Ніжин",
        "Нікополь",
        "Нова Каховка",
        "Нова Одеса",
        "Новгород-Сіверський",
        "Нове Давидково",
        "Новий Буг",
        "Новий Калинів",
        "Новий Розділ",
        "Новоазовськ",
        "Нововолинськ",
        "Новоград-Волинський",
        "Новогродівка",
        "Новодністровськ",
        "Новодружеськ",
        "Новомиргород",
        "Самар",
        "Новоселиця",
        "Новоукраїнка",
        "Новояворівськ",
        "Носівка",
        "Обухів",
        "Овруч",
        "Одеса",
        "Олевськ",
        "Олександрівськ",
        "Олександрія",
        "Олешки",
        "Оріхів",
        "Остер",
        "Острог",
        "Охтирка",
        "Очаків",
        "П'ятихатки",
        "Павлоград",
        "Сокологірськ",
        "Златопіль",
        "Перевальськ",
        "Перемишляни",
        "Перечин",
        "Перещепине",
        "Переяслав",
        "Шахтарське",
        "Петрово-Красносілля",
        "Пирятин",
        "Південне",
        "Підгайці",
        "Підгородне",
        "Погребище",
        "Подільськ",
        "Покров",
        "Покровськ",
        "Пологи",
        "Полонне",
        "Полтава",
        "Помічна",
        "Попасна",
        "Почаїв",
        "Привілля",
        "Прилуки",
        "Приморськ",
        "Прип'ять",
        "Пустомити",
        "Путивль",
        "Рава-Руська",
        "Радехів",
        "Радивилів",
        "Радомишль",
        "Рахів",
        "Рені",
        "Решетилівка",
        "Ржищів",
        "Рівне",
        "Ровеньки",
        "Рогатин",
        "Родинське",
        "Рожище",
        "Роздільна",
        "Ромни",
        "Рубіжне",
        "Рудки",
        "Саки",
        "Самбір",
        "Сарни",
        "Свалява",
        "Сватове",
        "Світловодськ",
        "Світлодарськ",
        "Святогірськ",
        "Севастополь",
        "Селидове",
        "Семенівка",
        "Середина-Буда",
        "Сіверськодонецьк",
        "Синельникове",
        "Сіверськ",
        "Сімферополь",
        "Скадовськ",
        "Скалат",
        "Сквира",
        "Сколе",
        "Славута",
        "Славутич",
        "Слов'янськ",
        "Сміла",
        "Снігурівка",
        "Сніжне",
        "Сновськ",
        "Снятин",
        "Сокаль",
        "Сокиряни",
        "Соледар",
        "Сорокине",
        "Соснівка",
        "Старий Крим",
        "Старий Самбір",
        "Старобільськ",
        "Старокостянтинів",
        "Стебник",
        "Сторожинець",
        "Стрий",
        "Судак",
        "Судова Вишня",
        "Суми",
        "Суходільськ",
        "Таврійськ",
        "Тальне",
        "Тараща",
        "Татарбунари",
        "Теплодар",
        "Теребовля",
        "Тернівка",
        "Тернопіль",
        "Тетіїв",
        "Тиврів",
        "Тисмениця",
        "Тлумач",
        "Токмак",
        "Торецьк",
        "Тростянець",
        "Трускавець",
        "Тульчин",
        "Турка",
        "Тячів",
        "Угнів",
        "Ужгород",
        "Узин",
        "Українка",
        "Українськ",
        "Умань",
        "Устилуг",
        "Фастів",
        "Федорівка",
        "Феодосія",
        "Харків",
        "Харцизьк",
        "Херсон",
        "Хирів",
        "Хмельницький",
        "Хмільник",
        "Ходорів",
        "Хорол",
        "Хоростків",
        "Хотин",
        "Хрестівка",
        "Христинівка",
        "Хрустальний",
        "Хуст",
        "Часів Яр",
        "Шептицький",
        "Черкаси",
        "Чернівці",
        "Чернігів",
        "Чигирин",
        "Чистякове",
        "Чоп",
        "Чорнобиль",
        "Чорноморськ",
        "Чортків",
        "Чугуїв",
        "Чуднів",
        "Шаргород",
        "Шахтарськ",
        "Шепетівка",
        "Шостка",
        "Шпола",
        "Шумськ",
        "Щастя",
        "Щолкіне",
        "Южне",
        "Южноукраїнськ",
        "Яворів",
        "Яготин",
        "Ялта",
        "Ямпіль",
        "Яремче",
        "Ясинувата",
    )

    region_names = (
        "Автономна Республіка Крим",
        "Вінницька область",
        "Волинська область",
        "Дніпропетровська область",
        "Донецька область",
        "Житомирська область",
        "Закарпатська область",
        "Запорізька область",
        "Івано-Франківська область",
        "Київська область",
        "Кіровоградська область",
        "Луганська область",
        "Львівська область",
        "Миколаївська область",
        "Одеська область",
        "Полтавська область",
        "Рівненська область",
        "Сумська область",
        "Тернопільська область",
        "Харківська область",
        "Херсонська область",
        "Хмельницька область",
        "Черкаська область",
        "Чернівецька область",
        "Чернігівська область",
    )

    countries = [
        "Австралія",
        "Австрія",
        "Азербайджан",
        "Албанія",
        "Алжир",
        "Ангола",
        "Андорра",
        "Антигуа і Барбуда",
        "Аргентина",
        "Афганістан",
        "Багамські Острови",
        "Бангладеш",
        "Барбадос",
        "Бахрейн",
        "Беліз",
        "Бельгія",
        "Бенін",
        "Білорусь",
        "Болгарія",
        "Болівія",
        "Боснія і Герцеговина",
        "Ботсвана",
        "Бразилія",
        "Бруней",
        "Буркіна-Фасо",
        "Бурунді",
        "Бутан",
        "Вануату",
        "Ватикан",
        "Велика Британія",
        "Венесуела",
        "В'єтнам",
        "Вірменія",
        "Габон",
        "Гаїті",
        "Гаяна",
        "Гамбія",
        "Гана",
        "Гватемала",
        "Гвінея",
        "Гвінея-Бісау",
        "Гондурас",
        "Гренада",
        "Греція",
        "Грузія",
        "Данія",
        "Джибуті",
        "Домініка",
        "Домініканська Республіка",
        "Еквадор",
        "Екваторіальна Гвінея",
        "Еритрея",
        "Естонія",
        "Ефіопія",
        "Єгипет",
        "Ємен",
        "Замбія",
        "Західна Сахара",
        "Зімбабве",
        "Ізраїль",
        "Індія",
        "Індонезія",
        "Ірак",
        "Іран",
        "Ірландія",
        "Ісландія",
        "Іспанія",
        "Італія",
        "Йорданія",
        "Кабо-Верде",
        "Казахстан",
        "Камбоджа",
        "Камерун",
        "Канада",
        "Катар",
        "Кенія",
        "Киргизстан",
        "КНР",
        "Кіпр",
        "Кірибаті",
        "Колумбія",
        "Коморські Острови",
        "Конго",
        "ДР Конго",
        "Південна Корея",
        "Північна Корея",
        "Косово",
        "Коста-Рика",
        "Кот-д'Івуар",
        "Куба",
        "Кувейт",
        "Лаос",
        "Латвія",
        "Лесото",
        "Литва",
        "Ліберія",
        "Ліван",
        "Лівія",
        "Ліхтенштейн",
        "Люксембург",
        "Маврикій",
        "Мавританія",
        "Мадагаскар",
        "Малаві",
        "Малайзія",
        "Малі",
        "Мальдіви",
        "Мальта",
        "Марокко",
        "Маршаллові Острови",
        "Мексика",
        "Федеративні Штати Мікронезії",
        "Мозамбік",
        "Молдова",
        "Монако",
        "Монголія",
        "М'янма",
        "Намібія",
        "Науру",
        "Непал",
        "Нігер",
        "Нігерія",
        "Нідерланди",
        "Нікарагуа",
        "Німеччина",
        "Нова Зеландія",
        "Норвегія",
        "ОАЕ",
        "Оман",
        "Пакистан",
        "Палау",
        "Палестинська держава",
        "Панама",
        "Папуа Нова Гвінея",
        "ПАР",
        "Парагвай",
        "Перу",
        "Південний Судан",
        "Польща",
        "Португалія",
        "Північна Республіка Македонія",
        "Росія",
        "Руанда",
        "Румунія",
        "Сальвадор",
        "Самоа",
        "Сан-Марино",
        "Сан-Томе і Принсіпі",
        "Саудівська Аравія",
        "Свазіленд",
        "Сейшельські Острови",
        "Сенегал",
        "Сент-Вінсент і Гренадини",
        "Сент-Кіттс і Невіс",
        "Сент-Люсія",
        "Сербія",
        "Сінгапур",
        "Сирія",
        "Словаччина",
        "Словенія",
        "Соломонові Острови",
        "Сомалі",
        "Судан",
        "Суринам",
        "Східний Тимор",
        "США",
        "Сьєрра-Леоне",
        "Таджикистан",
        "Таїланд",
        "Тайвань",
        "Танзанія",
        "Того",
        "Тонга",
        "Тринідад і Тобаго",
        "Тувалу",
        "Туніс",
        "Туреччина",
        "Туркменістан",
        "Уганда",
        "Угорщина",
        "Узбекистан",
        "Україна",
        "Уругвай",
        "Фіджі",
        "Філіппіни",
        "Фінляндія",
        "Франція",
        "Хорватія",
        "Центральноафриканська Республіка",
        "Чад",
        "Чехія",
        "Чилі",
        "Чорногорія",
        "Швейцарія",
        "Швеція",
        "Шрі-Ланка",
        "Ямайка",
        "Японія",
    ]
    street_prefixes = [
        "вулиця",
        "набережна",
        "провулок",
        "площа",
        "проспект",
        "узвіз",
        "сквер",
        "парк",
        "шосе",
    ]

    # https://data.gov.ua/en/dataset/__-120/resource/76e2684f-e75c-45e5-a0b2-6d5596ab47f8
    # https://opendata.drohobych-rada.gov.ua/sites/default/files/%D0%90%D0%B4%D1%80%D0%B5%D1%81%D0%B8%20%D0%94%D1%80%D0%BE%D0%B3%D0%BE%D0%B1%D0%B8%D1%87.xlsx
    street_titles = [
        "1-ша Лінія 4-ї ст. Люстдорфської дороги",
        "1-ша Лінія 6-й ст. Люстдорфської дороги",
        "1-ша Лінія Марії Демченко",
        "Олександра Болдирєва",
        "1-й Академічний тупик",
        "10-та Лінія 6-й ст. Люстдорфської дороги",
        "10-та Лінія Марії Демченко",
        "Олександра Богомольця",
        "11-ша Лінія 6-й ст. Люстдорфської дороги",
        "11-та Лінія Марії Демченко",
        "11-та ст. Великого Фонтану пляж",
        "Яна Длугоша",
        "12-та Лінія 6-й ст. Люстдорфської дороги",
        "12-та ст. Великого Фонтану пляж",
        "Юрія Кондратюка",
        "13-та Лінія 6-й ст. Люстдорфської дороги",
        "13-та ст. Великого Фонтану пляж",
        "Миколи Костомарова",
        "14-та Лінія 6-й ст. Люстдорфської дороги",
        "14-та ст. Великого Фонтану пляж",
        "Марка Крейна",
        "15-та Лінія 6-й ст. Люстдорфської дороги",
        "15-та ст. Великого Фонтану пляж",
        "Скліфосовського",
        "16-та Лінія 6-й ст. Люстдорфської дороги",
        "17-та Лінія 6-й ст. Люстдорфської дороги",
        "18-та Лінія 6-й ст. Люстдорфської дороги",
        "19-та Лінія",
        "19-й км Старокиївської дороги",
        "2-га Лінія 4-ї ст. Люстдорфської дороги",
        "2-га Лінія 6-й ст. Люстдорфської дороги",
        "2-га Лінія Марії Демченко",
        "Бардаха",
        "2-й Академічний тупик",
        "21-й км Старокиївської дороги",
        "3-тя Лінія 4-ї ст. Люстдорфської дороги",
        "3-тя Лінія 6-й ст. Люстдорфської дороги",
        "3-тя Лінія Марії Демченко",
        "Миколи Пильчикова",
        "4-та Лінія 6-й ст. Люстдорфської дороги",
        "4-та Лінія Марії Демченко",
        "Йосипа Фішера",
        "40-річчя оборони Одеси",
        "411-ї батареї",
        "5-та Лінія 6-й ст. Люстдорфської дороги",
        "5-та Лінія Марії Демченко",
        "Цесевича",
        "6-та Лінія 6-й ст. Люстдорфської дороги",
        "6-та Лінія Марії Демченко",
        "Баринштейна",
        "7-ма Лінія 6-й ст. Люстдорфської дороги",
        "7-ма Лінія Дачі Ковалевського",
        "Євгена Крамаренка",
        "8-ма Лінія 6-й ст. Люстдорфської дороги",
        "8-ма Лінія Дачі Ковалевського",
        "Володимира Антоновича",
        "9-та Лінія Дачі Ковалевського",
        "Квітки-Основ’яненка",
        "Абрикосова",
        "Абрикосовий",
        "Авангардна",
        "Одеської громади",
        "Авіаторів",
        "Авіаційна",
        "Аграрна",
        "Агрономічна",
        "Агрономічний",
        "Адміральський",
        "Аеродромна",
        "Аеродромний 1-й",
        "Аеродромний 2-й",
        "Аеродромний 3-й",
        "Аеропортівська",
        "Аеропортівський 1-й",
        "Аеропортівський 2-й",
        "Аеропортівський 3-й",
        "Аеропортівський 4-й",
        "Аеропортівський 5-й",
        "Аеропортівський 6-й",
        "Азербайджан",
        "Азовський",
        "Академіка Богатського",
        "Сергія Єфремова",
        "Академіка Векслера",
        "Карпенка-Карого",
        "Віталія Нестеренка",
        "Житомирська",
        "Князя Ярослава Мудрого",
        "Академіка Заболотного",
        "Академіка Корольова",
        "Дмитра Сигаревича",
        "Академіка Сахарова",
        "Академіка Філатова",
        "Академіка Ясиновського",
        "Академічна",
        "Академічний",
        "Акордна",
        "Алмазна",
        "Альпіністів",
        "Амбулаторна",
        "Амбулаторний",
        "Амбулаторний 1-й",
        "Амбулаторний 2-й",
        "Амундсена, 1-й",
        "Амундсена, 2-й",
        "Амундсена, 3-й",
        "Острозька",
        "Кам’янецький",
        "Глухівський",
        "Волинський",
        "Кременецький",
        "Ананьївська",
        "Буджацька",
        "Андреєвського",
        "Олега Андрійця",
        "Андросовський",
        "Ганни Ахматової",
        "Зої Пасічної",
        "Аптекарський",
        "Аркадіївський",
        "Аркадійська",
        "Аркаса Миколи",
        "Армійська",
        "Артезіанська",
        "Артилерійська",
        "Артилерійський 2-й",
        "Архітекторська",
        "Архітектурна",
        "Юрія Асєєва",
        "Асташкіна",
        "Астрономічна",
        "Астрономічний",
        "Ашгабатська",
        "Дмитра Іванова",
        "Багрицького",
        "Базарна",
        "Байдарочний",
        "Байкал тупик",
        "Юрія Єгорова",
        "Балківська",
        "Балтська дорога",
        "Балтський 1-й",
        "Балтський 2-й",
        "Балтський 3-й",
        "Балтський 4-й",
        "Балтський 5-й",
        "Балтський 6-й",
        "Балтський 7-й",
        "Балтський 8-й",
        "Банний",
        "Баркасний",
        "Басейна",
        "Басейний 1-й",
        "Басейний 2-й",
        "Басейний 3-й",
        "Басейний 4-й",
        "Басейний 6-й",
        "Бахчева",
        "Баштанна",
        "Безіменний",
        "Берегова",
        "Березова",
        "Березовий",
        "Бернардацці",
        "Бессарабська",
        "Данила Самойловича",
        "Бібліотечна",
        "Кастуся Калиновського",
        "Савранський",
        "Біляївська",
        "Ігоря Іванова",
        "Бісквітний",
        "Бітумна",
        "Ольги Благовидової",
        "Богдана Хмельницького",
        "Богуна",
        "Бодаревського",
        "Бокаріуса",
        "Болгарська",
        "Болградська",
        "Бориса Дерев'янка",
        "Бориса Літвака",
        "Героїв Зміїного",
        "Ботанічний",
        "Василя Фащенка",
        "Вінницька",
        "Берестейська",
        "Бреуса Якова",
        "Бригадна",
        "Бугаївська",
        "Будівельна",
        "Будівельний",
        "Бузкова",
        "Бузковий",
        "Бузковий 1-й",
        "Бузковий 2-й",
        "Ніни Строкатої",
        "Бучми",
        "Кінбурнський",
        "В’ячеслава Чорновола",
        "Валіховський",
        "Ванний",
        "Миколи Куліша",
        "Гіацинтовий",
        "Вапняна",
        "Вапняне селище",
        "Вапняний 1-й",
        "Вапняний 2-й",
        "Вапняний 3-й",
        "Варненська",
        "Василя Кандинського",
        "Василя Кандинського 1-й",
        "Василя Кандинського 2-й",
        "Василя Кандинського 3-й",
        "Василя Кандинського 4-й",
        "Василя Кандинського 5-й",
        "Василя Симоненка",
        "Василя Стуса",
        "Ждахи",
        "Михайла Слабченка",
        "Ватманський",
        "Велика Арнаутська",
        "Велика Садова",
        "Венгера",
        "Академіка Липського",
        "Вернидуба",
        "Верстатобудівна",
        "Вертелецького",
        "Верф’яний",
        "Верхня",
        "Вершинна",
        "Весела",
        "Весняна",
        "Ветеранів праці",
        "Назарівська",
        "Ігоря Ветрогонова",
        "Виїзна",
        "Виноградна",
        "Виноградна 1-ша",
        "Виноградна 2-га",
        "Виноградна 3-тя",
        "Виноградний",
        "Виноградний тупик",
        "Висока",
        "Високий",
        "Ярослава Баїса",
        "Виставочна",
        "Вишнева",
        "Вишневий",
        "Відважних",
        "Військовий узвіз",
        "Вільгельма Габсбурга",
        "Віри Інбер",
        "Буковецького",
        "Віри Холодної",
        "Вірського",
        "Вітчизняна",
        "Андрія Гулого-Гуленка",
        "Івана Луценка",
        "Водний",
        "Водопровідна",
        "Водопровідний 1-й",
        "Водопровідний 2-й",
        "Водопровідний 3-й",
        "Вознесенський",
        "Вокзальна",
        "Вокзальний",
        "Олександрійський",
        "тупик Хвиля",
        "Хвиляста",
        "Володимира Вінниченка",
        "Володимира Хавкіна",
        "Володі Дубініна",
        "Батуринська",
        "Ізюмська",
        "Байгородський",
        "Восьмого березня",
        "Восьмого березня 1-й",
        "Восьмого березня 2-й",
        "Восьмого березня 3-й",
        "Восьмого березня 4-й",
        "Кодимський",
        "Восьмого березня 6-й",
        "Бейтельсбахера",
        "Восьмого березня 8-й",
        "Волтона",
        "Восьмого Березня Лінія 1-ша",
        "Килимова",
        "Гобеленова",
        "Фахова",
        "Бондарна",
        "Віктора Скаржинського узвіз",
        "Вузький",
        "Вчительська",
        "Вчительської, 2-й",
        "Гаванна",
        "Газова",
        "Газовий",
        "Павла Клепацького",
        "Давида Бурлюка",
        "Соні Делоне",
        "Андрія Музичка",
        "Гвоздична",
        "Гвоздичний",
        "Гена Іоганна",
        "Генуезька",
        "Геологічна",
        "Георгія Гамова",
        "Геранієва",
        "Героїв Крут",
        "Героїв Небесної Сотні",
        "Героїв оборони Одеси",
        "Героїв прикордонників",
        "Галини Могильницької",
        "Гетьманський",
        "Гілельса",
        "Гімназична",
        "Каменярів",
        "Бориса Нечерди",
        "Дмитра Годзенка",
        "Кафедральна",
        "Глиняна",
        "Глухий міст",
        "Гоголя",
        "Головківська",
        "Головна",
        "Гонтаренко",
        "Горбатий міст",
        "Горбиста",
        "Горизонтальна",
        "Горіхова",
        "Городня",
        "Хортицька",
        "Марка Твена",
        "Госпітальний",
        "Тараса Кузьміна",
        "Гранатна",
        "Гранатний",
        "Грецька",
        "Грецька",
        "Грецький",
        "Джинестрівська",
        "Грузинська",
        "Грузовий",
        "Давида Ойстраха",
        "Трусовська",
        "Дальницька",
        "Дальницьке",
        "Дальній",
        "Дальня",
        "Данила Крижанівського",
        "Проектуєма",
        "Дача Ковалевського",
        "Дачна",
        "Дачний",
        "Дачний 1-й",
        "Дачний 2-й",
        "Всеволода Змієнка",
        "Дев’ята",
        "Деволанівська",
        "Деволанівський узвіз",
        "Миргородський",
        "Дельфін",
        "Грушева",
        "Демократична",
        "Депутатський",
        "Деревообробна",
        "Деревообробний 1-й",
        "Деревообробний 2-й",
        "Деревообробний 3-й",
        "Деревообробний 4-й",
        "Деревообробний 5-й",
        "Глаубермана",
        "Квантовий",
        "Дерибасівська",
        "Десантний",
        "Десята",
        "Десятого квітня",
        "Десятого квітня",
        "Джерельна",
        "Джутовий",
        "Дзвінка",
        "Дігтярна",
        "Дідріхсона",
        "Діхтієвського Віктора",
        "Дмитріївська",
        "Лазурського",
        "Дніпровська",
        "Дніпропетровська дорога",
        "Дністровська",
        "Князя Володимира Великого ",
        "Довга",
        "Довженка",
        "Докова",
        "Долинська",
        "Донецька",
        "Донцова Дмитра",
        "Дорбуду",
        "Дорожня",
        "Друга",
        "Дружний",
        "Дубова",
        "Дубовий гай",
        "Дукова",
        "Біржова",
        "Панаса Саксаганського",
        "Мирослава Скорика",
        "Олександра Кошиця",
        "Лятошинського",
        "Дунайська",
        "Дюківська",
        "Дюківський сад",
        "Економічний",
        "Елеваторна",
        "Естафетна",
        "Естонська",
        "Естонський",
        "Єврейська",
        "Халайджогло",
        "Ференца Ліста",
        "Юрія Коваленка",
        "Охтирський",
        "Єфімова",
        "Жаботинського",
        "Жасминна",
        "Жевахова",
        "Владислава Домбровського",
        "Братів Малакових",
        "Житомирська",
        "Житомирський 3-й",
        "Житомирський 4-й",
        "Жоліо-Кюрі",
        "Жолкова Бориса",
        "Леопольда Ященка",
        "Заводська",
        "Заводська 1-ша",
        "Заводська 2-га",
        "Заводська 3-тя",
        "Заводська 4-та",
        "Заводська 5-та",
        "Задніпровського",
        "Закарпатська",
        "Залізнична",
        "Залізничний 3-й",
        "Заньковецької",
        "Запорізька",
        "Зарічна",
        "Західний 1-й",
        "Західний 2-й",
        "Західний 3-й",
        "Західний 4-й",
        "Зелена",
        "Зелена балка",
        "Зелена гірка",
        "Зелений",
        "Зернова",
        "Злакова",
        "Змієнка Всеволода",
        "Золотий берег",
        "Зоопаркова",
        "Караїмська",
        "Зоряна",
        "Івана Вазова",
        "Івана Микитенка",
        "Івана Франка",
        "Іванівська",
        "Іванівський переїзд",
        "Бутишів",
        "Мерло",
        "Каберне",
        "Іванова Ігоря",
        "Івасюка Володимира",
        "Івахненка Петра",
        "Сім'ї Глодан",
        "Інглезі",
        "Індійська",
        "Сергія Коновалова",
        "Іподромний",
        "Іспанська",
        "Іспанський",
        "Історія Футболу",
        "Італійський",
        "Рабіна Іцхака",
        "Йосипа Тимченка",
        "Кавказька",
        "Кавказький",
        "Кавунова",
        "Ізмаїльська",
        "Казковий",
        "Калинова",
        "Петра Калнишевського",
        "Валерія Самофалова",
        "Кортацці",
        "Камишова",
        "Канатна",
        "Канатний",
        "Капітана Гаврікова",
        "Капітана Кузнецова",
        "Кар’єрна",
        "Карантинна",
        "Карантинний узвіз",
        "Каретний",
        "Каркашадзе",
        "Карпатська",
        "Картамишевська",
        "Картамишевський",
        "Європейська",
        "Каховський",
        "Симфонічна",
        "Каштанова",
        "Квіткова",
        "Квітковий",
        "Квітнева",
        "Кедровий",
        "Керченська",
        "Керченський 1-й",
        "Керченський 2-й",
        "Керченський 3-й",
        "Луїджі Іоріні",
        "Київське",
        "Килимовий",
        "Кипарисний 1-й",
        "Кипарисний 2-й",
        "Кипарисний 3-й",
        "Китобійна",
        "Китобійний 1-й",
        "Китобійний 2-й",
        "Бориса Кифоренка",
        "Кишинівська",
        "Кільовий",
        "Кільцева",
        "Кінна",
        "Ігоря Кисельова",
        "Кладовищенська",
        "Кладовищний",
        "Кленова",
        "Клинова",
        "Ключовий 1-й",
        "Ключовий 2-й",
        "Книжковий",
        "Князівська",
        "Князівський",
        "Павла Зеленого",
        "Пішонівська",
        "Ковиловий",
        "Колективний",
        "Колекційна",
        "Колонічна",
        "Колонтаївська",
        "Василя Капніста",
        "Компасний",
        "Музична",
        "Мелодійний",
        "Ніщинського Композитора",
        "Кондрашина",
        "Конструкторський",
        "Віталія Гуляєва",
        "Кордонна",
        "Кордонний",
        "Корнюшина",
        "Ігоря Балмагії",
        "Короткий",
        "Кобзаря",
        "Косий",
        "Любомира Гузара",
        "Космонавтів",
        "Косовська",
        "Косовський",
        "Костанді",
        "Костанді 2-й",
        "Костанді 3-й",
        "Ольги Благовидової",
        "Олексія Косяченко",
        "Котляревського",
        "Коцюбинського",
        "Кощового отамана",
        "Крайня",
        "Красива",
        "Красний",
        "Краснова",
        "Ольвійська",
        "Краснослобідська",
        "Краснослобідський",
        "Кредитний",
        "Дур'янівський",
        "Кривобалківська",
        "Крижанівський",
        "Юзефа Крашевського",
        "Кримська",
        "Кримський",
        "Кристаловського",
        "Кришталева",
        "Кришталевий",
        "Кропивницького",
        "Кругова",
        "Круговий",
        "Крутоярська",
        "Крушельницької",
        "Кузнечна",
        "Куликове поле",
        "Куликовський 2-й",
        "Куниці",
        "Купріна",
        "Сотника Лугіна",
        "Курортний",
        "Курортний 6-й",
        "Бахмутська",
        "Кустанайська",
        "Кустанайський 2-й",
        "Кутова",
        "Генерала Алмазова",
        "Куяльницький міст",
        "Лавкова",
        "Лазурний 1-й",
        "Лазурний 2-й",
        "Лазурний 3-й",
        "Лазурний 4-й",
        "Лазурний 5-й",
        "Лазурний 6-й",
        "Ламаний",
        "Ланжерон",
        "Ланжеронівська",
        "Ланжеронівський узвіз",
        "Латвійський узвіз",
        "Левадна",
        "Гонсіоровського",
        "Толвінського",
        "Миколи Бурачека",
        "Левкоєва",
        "Олександра Станкова",
        "Олешківська",
        "Леонтовича",
        "Джевецького",
        "Госпітальєрів",
        "Лесі Українки",
        "Леха Качинського",
        "Лиманна",
        "Лиманний",
        "Лиманчик 2-й Лінія 1-ша",
        "Лиманчик 2-й Лінія 11-та",
        "Лиманчик 2-й Лінія 2-га",
        "Лиманчик 2-й Лінія 3-тя",
        "Лиманчик 2-й Лінія 4-та",
        "Лиманчик 2-й Лінія 5-та",
        "Лиманчик 2-й Лінія 8-ма",
        "Лиманчик 2-й Лінія 9-та",
        "Ф. Пішеніна",
        "Липнева",
        "Листяна",
        "Листяний",
        "Литовська",
        "Ліверпульський",
        "Гетьмана Сагайдачного",
        "Шевальових",
        "Лінійна",
        "Лінійний",
        "Лїнія 1-ша",
        "Лінія 22-га",
        "Лінія 23-тя",
        "Лінія 24-та",
        "Лінія 25-та",
        "Лінія 26-та",
        "Лінія 27-ма",
        "Лінія 28-ма",
        "Лінія 29-та",
        "Лінія 30-та",
        "Лінія 31-ша",
        "Лінія 32-га",
        "Лінія 33-тя",
        "Лінія 35-та",
        "Лінія 36-та",
        "Лінія 37-ма",
        "Лінія 38-ма",
        "Лінія 39-та",
        "Лінія 40-ва",
        "Лінія 41-ша",
        "Лінія 42-га",
        "Лінія 43-тя",
        "Лінія 44-та",
        "Лінія 45-та",
        "Лінія 46-та",
        "Лінія 47-ма",
        "Лінія 48-ма",
        "Лінія 49-та",
        "Лінія 50-та",
        "Лінія 51-ша",
        "Лінія 52-га",
        "Лінія 53-тя",
        "Лінія 54-та",
        "Лінія 55-та",
        "Літакова",
        "Літературна",
        "Літній",
        "Літня",
        "Лобачевського",
        "Лодочний",
        "Локальна",
        "Локомотивна",
        "Локомотивний 1-й",
        "Локомотивний 2-й",
        "Локомотивний 3-й",
        "Локомотивний 4-й",
        "Луганська",
        "Лугова",
        "Лузанівка",
        "Лузанівка",
        "Лузанівська",
        "Лузанівський",
        "Лузанівський 1-й",
        "Лузанівський 2-й",
        "Місячний",
        "Луценка Івана",
        "Луцька",
        "Лучиста",
        "Льва Симиренка",
        "Менделе Сфоріма",
        "Львівська",
        "Львівський",
        "Любашівський",
        "Людмили Гінзбург",
        "Люстдорфська дорога",
        "Люстдорфський",
        "Лютеранський",
        "Лютнева",
        "Лютневий 1-й",
        "Лютневий 2-й",
        "Хортицька",
        "Остапа Вишні",
        "Олександра Ройтбурда",
        "М’ясоєдовська",
        "Магістральна",
        "Михайла Врубеля",
        "Адольфа Лози",
        "Сергія Параджанова",
        "Мазепи Івана",
        "Майстерний",
        "Лігінська",
        "Контрадмірала Остроградського",
        "Макова",
        "Маковий",
        "Мала",
        "Мала Арнаутська",
        "Мала Садова",
        "Маланова",
        "Хаджибейський",
        "Маловського",
        "Манежна",
        "Манежний",
        "Маразліївська",
        "Фруктова",
        "Сливовий",
        "Чорничний",
        "узвіз Віталія Блажка",
        "Мариністів",
        "Дениса Максишка",
        "Михайла Омеляновича-Павленка",
        "Марсельська",
        "Добровольців",
        "Маршрутна",
        "Матеріальний 1-й",
        "Матроська Слободка ",
        "Матроський узвіз",
        "Матюшенка",
        "Віталія Блажка",
        "Мацієвської",
        "Мацієвської узвіз",
        "Машинобудівний",
        "Маячний",
        "Мелітопольська",
        "Мельницька",
        "Металістів",
        "Флейтовий",
        "Петра Болбочана",
        "Мечникова",
        "Мигдальна",
        "Миколаївська дорога",
        "Миколаївський 1-й",
        "Миколи Бажана",
        "Миколи Боровського",
        "Миколи Вороного",
        "Ганса Германа",
        "Миколи Гумільова",
        "Миколи Огренича",
        "Миколи Плигуна",
        "Мирна",
        "Митна",
        "Митракова",
        "Михайла Божія",
        "Михайла Грушевського",
        "Військово-морських сил",
        "Михайлівська",
        "Йозефа Прибіка",
        "Місячна",
        "Миколи Міхновського",
        "Міцкевича",
        "Матроський",
        "Бєлякова",
        "Волова",
        "Могилівська",
        "Молоді",
        "Молодіжна",
        "Чайкова",
        "Молокова",
        "Монастирський",
        "Монгольська",
        "Морехідна",
        "Морехідний",
        "Морська",
        "Морський",
        "Морський 2-й",
        "Литавровий",
        "Москеті",
        "Мостовий",
        "Моторна",
        "Моторний 1-й",
        "Моторний 2-й",
        "Моторний 3-й",
        "Мукачівський",
        "Мусіна",
        "Набережна",
        "Навігаційний",
        "Надіїі",
        "Наклонна",
        "Наливна",
        "Нафтовиків",
        "Нафтовиків",
        "Нафтовиків 1-й",
        "Нафтовиків 2-й",
        "Нафтовиків 3-й",
        "Миколи Кравченка",
        "Наявний 1-й",
        "Наявний 2-й",
        "Наявний 3-й",
        "Наявний 4-й",
        "Наявний 5-й",
        "Наявний 6-й",
        "Наявний 7-й",
        "Небесної Сотні",
        "Анатолія Бачинського",
        "Заможна",
        "Ромський",
        "Незалежності",
        "Отонівський",
        "Немировича-Данченка",
        "Неплія",
        "Нерубайська",
        "Нескучна",
        "Нечипуренка",
        "Ніжинська",
        "Шполянська",
        "Нова",
        "Новаторів",
        "Михайла Жука",
        "Дворникова",
        "Теофіла Фраєрмана",
        "Новий",
        "Новиков міст",
        "Ірини Жиленко",
        "Родоканакі",
        "Новобазарний",
        "Новоберегова",
        "Чигиринська",
        "Новоселів",
        "Новосельского",
        "Новоукраїнський",
        "Новощіпний ряд",
        "Об'їзна дорога",
        "Обільна",
        "Обільний 1-й",
        "Обільний 2-й",
        "Обривиста",
        "Обсерваторний",
        "Овідіопольська",
        "Овідіопольська дорога",
        "Овідіопольська дуга",
        "Овідіопольський",
        "Одарія",
        "Одеса-Головна",
        "Одеська",
        "Одеський",
        "Озерна",
        "Окружна",
        "Олександра Блока",
        "Композитора Вербицького",
        "Олександра Кутузакія",
        "Валерія Лобановського",
        "Сергія Шелухина",
        "Климовича",
        "Чехівського",
        "Василя Кричевського",
        "Павла Чубинського",
        "Майка Йогансена",
        "Леоніда Осики",
        "Олександра Тимошенка",
        "Українських Героїв",
        "Олексіївська",
        "Ольгіївська",
        "Ольгіївський узвіз",
        "Василя Берладяну",
        "Евлії Челебі",
        "Онілової",
        "Оранжерейний",
        "Орликова",
        "Олешківська",
        "Надії Пучковської",
        "Осипова",
        "Осіння",
        "Остапа Вишні",
        "Отамана Головатого",
        "Отамана Чепіги",
        "Отрада",
        "Отрадна",
        "Офіцерська",
        "Офіцерський 1-й",
        "Офіцерський 2-й",
        "П'ята",
        "Пiвденний",
        "Павла Кравцова",
        "Павла Шклярука",
        "Павлова",
        "Павлодарська",
        "Палія Семена",
        "Палубна",
        "Палубний",
        "Панаса Мирного",
        "Пантелеймонівська",
        "Панченка",
        "Парашутний",
        "Паркова",
        "Парковий",
        "Партизанська",
        "Партизанської слави",
        "Парусна",
        "Пассіонарії",
        "Пастера",
        "Патріотична",
        "Педагогічна",
        "Педагогічний",
        "Пейзажна",
        "Добровольців",
        "Рятувальників",
        "Перепечка",
        "Пересипський міст",
        "Пересипська 1-ша",
        "Пересипська 10-та",
        "Пересипська 2-га",
        "Пересипська 3-тя",
        "Пересипська 4-та",
        "Пересипська 5-та",
        "Пересипська 6-та",
        "Пересипська 7-ма",
        "Пересипська 8-ма",
        "Пересипська 9-та",
        "Пересипський 1-й",
        "Пересипський 2-й",
        "Пересипський узвіз",
        "Перлинна",
        "Перша",
        "Перший Кришталевий",
        "Миколи Леонтовича",
        "Саймона Літмана",
        "Цукровий",
        "Петра Лещенка",
        "Леся Курбаса",
        "Пироговська",
        "Пироговський",
        "Бориса Едуардса",
        "Південна",
        "Південна дорога",
        "Південно-Санаторний",
        "Північна",
        "Північний",
        "Підйомний",
        "Пілотна",
        "Пісочна",
        "Пісочний",
        "Пішонівська",
        "Планетна",
        "Платанова",
        "Бродська",
        "Пляжна",
        "Побратимів",
        "Подільська",
        "Поїзна",
        "Покровський",
        "Буковинська",
        "Хотинський",
        "Політкаторжан",
        "Полтавська",
        "Полуничний",
        "Польова",
        "Польовий 1-й",
        "Польська",
        "Польський узвіз",
        "Поперечний",
        "Посівна",
        "Балтиморська",
        "Поштова",
        "Поштовий",
        "Преображенська",
        "Пресича Олександра",
        "Стрийський",
        "Прибережний",
        "Привозна",
        "Привокзальна",
        "Привокзальний",
        "Приморська",
        "Приморський",
        "Приморський",
        "Прирейкова",
        "Проектна 1-ша",
        "Проектна 2-га",
        "Проектний 5-й",
        "Проектований 3-й",
        "Проектований 4-й",
        "Проїзний 1-й",
        "Проїзний 2-й",
        "Проїзний 3-й",
        "Прокатна",
        "Іони Отаманського",
        "Географічний",
        "Промислова",
        "Промисловий",
        "Прорізна",
        "Прорізний",
        "Просвіти",
        "Путівна",
        "Проточний",
        "Професора Каришковського",
        "Професора Коровицького",
        "Профспілкова",
        "Прохоровська",
        "Прохоровський",
        "Прохоровський",
        "Проценка",
        "Почаївська",
        "Опішнянський",
        "Персикова",
        "Путьова",
        "Рози вітрів",
        "Пшенична",
        "Прилуцький",
        "Радіальна",
        "Радіальний",
        "Радіо",
        "Радісна",
        "Радісний",
        "Разумовська",
        "Раїси Сергієнко",
        "Райдужна",
        "Ракетна",
        "Рачкова",
        "Регенсбург",
        "Рекордний",
        "Рельєфна",
        "Ремонтна",
        "Республіканська",
        "Рєпіна",
        "Рибальська",
        "Рибальська балка",
        "Рибальський",
        "Ризька",
        "Рівний",
        "Рівності",
        "Рівності",
        "Рівності 1-й",
        "Рівності 2-й",
        "Різдвяна",
        "Різницький",
        "Різовська",
        "Рішельєвська",
        "Рожева",
        "Роздольна",
        "Розкидайлівська",
        "Розумовський 1-й",
        "Розумовський 2-й",
        "Решата Аметова",
        "Романтиків",
        "Романтичний",
        "Ромашкова",
        "Маріупольська",
        "Гайова",
        "Рульовий",
        "Миколи Савича",
        "Сабанський",
        "Савицький",
        "Савранська",
        "Садиковська",
        "Садова",
        "Садова 1-ша",
        "Садова 2-га",
        "Садова 3-тя",
        "Садова 4-та",
        "Садова 5-та",
        "Садова 6-та",
        "Садовий",
        "Садовського",
        "Саксаганського",
        "Пилипа Орлика",
        "Обліпихова",
        "Самодіяльна",
        "Санаторний",
        "Санітарна",
        "Сашка Хорошенка",
        "Світанку",
        "Світла",
        "Світлий",
        "Свободи",
        "Святослава Ріхтера",
        "Севастопольський",
        "Сегедська",
        "Селекційна",
        "Селекційний",
        "Селищна",
        "Селищний",
        "Семафорний",
        "Семінарська",
        "Сергія Ейзенштейна",
        "Сергія Уточкіна",
        "Сергія Ядова",
        "Серединський",
        "Середньофонтанська",
        "Середньофонтанський",
        "Середня",
        "Сірожупанників",
        "Сєрогодського",
        "Зої Бутенко",
        "Поліська",
        "Сирітський",
        "Сирітський 2-й",
        "Сільська",
        "Сільськогосподарський",
        "Сімферопольська",
        "Сінна",
        "Новопланівська",
        "Скидановська",
        "Скидановський узвіз",
        "Складська",
        "Скляна",
        "Скляний 1-й",
        "Скляний 2-й",
        "Скляний 3-й",
        "Скрипковий",
        "Слави",
        "Слави",
        "Донорська",
        "Сливова",
        "Слобідська",
        "Слобідський узвіз",
        "Слов'янська",
        "Сміливий",
        "Почаївська",
        "Павла Вірського",
        "Соборна",
        "Совіньйонівський",
        "Солонцюватий",
        "Солонцюватий 1-й",
        "Соляна",
        "Соляний 1-й",
        "Соляний 2-й",
        "Соляний 3-й",
        "Соляний 4-й",
        "Соляний 5-й",
        "Соляний 6-й",
        "Соляний 7-й",
        "Сонячна",
        "Сортувальна 1-ша",
        "Сортувальна 2-га",
        "Сосюри",
        "Софії Перовської",
        "Софіївська",
        "Соціальна",
        "Бахчисарайська",
        "Ярмарковий",
        "Спаський",
        "Спиридонівська",
        "Спортивна",
        "Спортивний",
        "Сталепрокатна",
        "Стамбульський",
        "Станційна 1-ша",
        "Станційна 2-га",
        "Станційна 3-тя",
        "Старицького",
        "Старобазарний",
        "Старокінний",
        "Старопортофранківська",
        "Старорізнична",
        "Старосінна",
        "Школярський",
        "Стельмаха",
        "Степана Олійника узвіз",
        "Малинова",
        "Степна",
        "Степний 2-й",
        "Степова",
        "Стеценко",
        "Томатна",
        "Стовпова",
        "Стороженка Олега",
        "Стражеска Миколи",
        "Строганов міст",
        "Максима Чайки",
        "Студена",
        "Студентський",
        "Студентський 1-й",
        "Студентський 2-й",
        "Студентський 3-й",
        "Студентський 4-й",
        "Студентський 5-й",
        "Петра Біциллі",
        "Суднобудівна",
        "Суднобудівний",
        "Сумська",
        "Сумський",
        "Суперфосфатна",
        "Супутників",
        "Лірний",
        "Бандурний",
        "Сухолиманна",
        "Східний",
        "Східний 1-й",
        "Східний 2-й",
        "Східчастий 3-й",
        "Східчастий 4-й",
        "Східчастий",
        "Сьома",
        "Таїрова",
        "Танкерна",
        "Танкістів",
        "Танфільєва",
        "Тарутинська",
        "Творча",
        "Текстильників",
        "Олени Теліги",
        "Тепла",
        "Теплична",
        "Тепличний 1-й",
        "Тепличний 2-й",
        "Володимира Терещенка",
        "Тетяни Тесс",
        "Технічний",
        "Тещин міст",
        "Айвазовського",
        "Тираспольська",
        "Тиха",
        "Тіниста",
        "Тінистий",
        "Ткачова",
        "Товарний",
        "Трибуни героїв",
        "Георгія Липського",
        "Василя Данилевича",
        "Тополина",
        "Тополиний",
        "Топольського",
        "Торгова",
        "Травневий",
        "Травневий 1-й",
        "Травневий 2-й",
        "Травневий 3-й",
        "Травневий 4-й",
        "Травневий 5-й",
        "Тракторна",
        "Трамвайна",
        "Трамвайний",
        "Транспортна",
        "Траса Здоров'я",
        "Троїцька",
        "Миколи Троїцького",
        "Тролейбусна",
        "Трояндова",
        "Трудова",
        "Трудовий",
        "Олександра Білостінного",
        "Героїв УПА",
        "Тупиковий",
        "Тупиковий 1-й",
        "Тупиковий 2-й",
        "Андрія Сови",
        "Туристська",
        "Туристський",
        "Тюльпанний",
        "Угорська",
        "Удільний",
        "Українська",
        "Український 1-й",
        "Український 2-й",
        "Український 3-й",
        "Улицька",
        "Уманська",
        "Умова",
        "Університетський",
        "Уральська",
        "Уральський",
        "Урожайна",
        "Усатівська",
        "Успенська",
        "Успенський",
        "Ніли Крюкової",
        "Училищна",
        "Учительський",
        "Учнівська",
        "Багринова",
        "Ушинського",
        "Затишна",
        "Ф. Пішеніна",
        "Фабрична",
        "Фестивальний",
        "Флотська",
        "Флотський 1-й",
        "Флотський 2-й",
        "Флотський 3-й",
        "Флотський 4-й",
        "Фонтанська дорога",
        "Французький",
        "Фруктовий",
        "Хаджибейська дорога",
        "Хаджибейський 1-й",
        "Хаджибейський 2-й",
        "Хаджибейський 3-й",
        "Харківська",
        "Хвойний",
        "Херсонський",
        "Херсонський сквер",
        "Хімічна",
        "Хімічний 1-й",
        "Хімічний 2-й",
        "Хімічний 3-й",
        "Хлібна гавань",
        "Художника Федорова",
        "Хутірська",
        "Хутірський",
        "Цебриківська",
        "Цегельнозаводська",
        "Цегляна",
        "Цементний",
        "Центральна",
        "Центральний аеропорт",
        "Церковна",
        "Цимлянська",
        "Йоганна Ансельма",
        "Театральний",
        "Барвінковий",
        "Черешнева",
        "Черкаська",
        "Чернишевського",
        "Чернівецький",
        "Чернігівська",
        "Чернігівський",
        "Артура Савельєва",
        "Четверта",
        "Журавлина",
        "Чорноморка",
        "Чорноморська",
        "Чорноморський",
        "Чорноморський",
        "Чорноморський 1-й",
        "Чорноморський 10-й",
        "Чорноморський 11-й",
        "Чорноморський 12-й",
        "Чорноморський 13-й",
        "Чорноморський 2-й",
        "Чорноморський 3-й",
        "Чорноморський 4-й",
        "Чорноморський 5-й",
        "Чорноморський 6-й",
        "Чорноморський 7-й",
        "Чорноморський 8-й",
        "Чорноморський 9-й",
        "Чорноморського козацтва",
        "Чубаївська",
        "Чубаївський",
        "Чумацька",
        "Шампанський",
        "Шахтинський",
        "Шебелінський",
        "Шевченка",
        "Шевченка парк",
        "Шептицького",
        "Шефська",
        "Шилова",
        "В'ячеслава Липинського",
        "Ширяївський",
        "Незамаївська",
        "Олександра Мурашка",
        "Шкільний",
        "Шкільний аеродром",
        "Шкіперська",
        "Шкодова гора",
        "Шовкуненка",
        "Волокидіна",
        "Шоста",
        "Шостої 1-й",
        "Шостої 2-й",
        "Шота Руставелі",
        "Штабний",
        "Штильова",
        "Штурвальна",
        "Штурманська",
        "Шухевича Романа",
        "Щіпний",
        "Щоглова",
        "Щоголєва",
        "Медовий",
        "Ювілейний 1-й",
        "Ювілейний 2-й",
        "Юннатів",
        "Юннатів 1-й",
        "Юннатів 2-й",
        "Юннатів 3-й",
        "Олександра Юрженка",
        "Юрія Олеші",
        "Юрія Яновського",
        "Юхима Геллера",
        "Юхима Фесенка",
        "Альтовий",
        "Яблунева",
        "Яблучна",
        "Якірний",
        "Ігоря Бедзая",
        "Ялинкова",
        "Ялинковий",
        "Ігоря Бедзая",
        "Ямчитського",
        "Ярморочна площа",
        "Яружний",
        "Ясна",
        "Семена Яхненка",
        "Яші Гордієнка",
    ]

    def city_prefix(self) -> str:
        return self.random_element(self.city_prefixes)

    def city_name(self) -> str:
        return self.random_element(self.city_names)

    def postcode(self) -> str:
        """The code consists of five digits (01000-99999)"""
        return f"{self.generator.random.randrange(1000, 99999):05}"

    def street_prefix(self) -> str:
        return self.random_element(self.street_prefixes)

    def street_name(self) -> str:
        return self.random_element(self.street_titles)

    def street_title(self) -> str:
        prefix = self.street_prefix()
        street = self.street_name()
        return prefix + " " + street

    def region(self) -> str:
        return self.random_element(self.region_names)
