#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmeshtocellgraph_ MATMESHTOCELLGRAPH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmeshtocellgraph_ matmeshtocellgraph
#endif
PETSC_EXTERN void matmeshtocellgraph_(Mat *a, PetscInt *b, Mat *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = MatMeshToCellGraph(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matpartitioningparmetissetcoarsesequential_ MATPARTITIONINGPARMETISSETCOARSESEQUENTIAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matpartitioningparmetissetcoarsesequential_ matpartitioningparmetissetcoarsesequential
#endif
PETSC_EXTERN void matpartitioningparmetissetcoarsesequential_(MatPartitioning *a, PetscErrorCode *ierr)
{
  *ierr = MatPartitioningParmetisSetCoarseSequential(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matpartitioningparmetissetrepartition_ MATPARTITIONINGPARMETISSETREPARTITION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matpartitioningparmetissetrepartition_ matpartitioningparmetissetrepartition
#endif
PETSC_EXTERN void matpartitioningparmetissetrepartition_(MatPartitioning *a, PetscErrorCode *ierr)
{
  *ierr = MatPartitioningParmetisSetRepartition(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matpartitioningparmetisgetedgecut_ MATPARTITIONINGPARMETISGETEDGECUT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matpartitioningparmetisgetedgecut_ matpartitioningparmetisgetedgecut
#endif
PETSC_EXTERN void matpartitioningparmetisgetedgecut_(MatPartitioning *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = MatPartitioningParmetisGetEdgeCut(*a, b);
  if (*ierr) return;
}
