#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcomputebandwidth_ MATCOMPUTEBANDWIDTH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcomputebandwidth_ matcomputebandwidth
#endif
PETSC_EXTERN void matcomputebandwidth_(Mat *a, PetscReal *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = MatComputeBandwidth(*a, *b, c);
  if (*ierr) return;
}
