#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewersetoptionsprefix_ PETSCVIEWERSETOPTIONSPREFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewersetoptionsprefix_ petscviewersetoptionsprefix
#endif
PETSC_EXTERN void petscviewersetoptionsprefix_(PetscViewer *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerSetOptionsPrefix(v_a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewersetup_ PETSCVIEWERSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewersetup_ petscviewersetup
#endif
PETSC_EXTERN void petscviewersetup_(PetscViewer *a, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerSetUp(v_a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerfinalizepackage_ PETSCVIEWERFINALIZEPACKAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerfinalizepackage_ petscviewerfinalizepackage
#endif
PETSC_EXTERN void petscviewerfinalizepackage_(PetscErrorCode *ierr)
{
  *ierr = PetscViewerFinalizePackage();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerinitializepackage_ PETSCVIEWERINITIALIZEPACKAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerinitializepackage_ petscviewerinitializepackage
#endif
PETSC_EXTERN void petscviewerinitializepackage_(PetscErrorCode *ierr)
{
  *ierr = PetscViewerInitializePackage();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerdestroy_ PETSCVIEWERDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerdestroy_ petscviewerdestroy
#endif
PETSC_EXTERN void petscviewerdestroy_(PetscViewer *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = PetscViewerDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewergettype_ PETSCVIEWERGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewergettype_ petscviewergettype
#endif
PETSC_EXTERN void petscviewergettype_(PetscViewer *a, char * b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerGetType(v_a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerappendoptionsprefix_ PETSCVIEWERAPPENDOPTIONSPREFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerappendoptionsprefix_ petscviewerappendoptionsprefix
#endif
PETSC_EXTERN void petscviewerappendoptionsprefix_(PetscViewer *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerAppendOptionsPrefix(v_a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewergetoptionsprefix_ PETSCVIEWERGETOPTIONSPREFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewergetoptionsprefix_ petscviewergetoptionsprefix
#endif
PETSC_EXTERN void petscviewergetoptionsprefix_(PetscViewer *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerGetOptionsPrefix(v_a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerviewfromoptions_ PETSCVIEWERVIEWFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerviewfromoptions_ petscviewerviewfromoptions
#endif
PETSC_EXTERN void petscviewerviewfromoptions_(PetscViewer *a, PetscObject *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerViewFromOptions(v_a, *b, c_c);
  if (*ierr) return;
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerview_ PETSCVIEWERVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerview_ petscviewerview
#endif
PETSC_EXTERN void petscviewerview_(PetscViewer *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = PetscViewerView(v_a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerread_ PETSCVIEWERREAD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerread_ petscviewerread
#endif
PETSC_EXTERN void petscviewerread_(PetscViewer *a, void *b, PetscInt *c, PetscInt *d, PetscDataType *e, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  CHKFORTRANNULLINTEGER(d);
  *ierr = PetscViewerRead(v_a, b, *c, d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerreadable_ PETSCVIEWERREADABLE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerreadable_ petscviewerreadable
#endif
PETSC_EXTERN void petscviewerreadable_(PetscViewer *a, PetscBool *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscViewerReadable(v_a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerwritable_ PETSCVIEWERWRITABLE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerwritable_ petscviewerwritable
#endif
PETSC_EXTERN void petscviewerwritable_(PetscViewer *a, PetscBool *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscViewerWritable(v_a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewercheckreadable_ PETSCVIEWERCHECKREADABLE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewercheckreadable_ petscviewercheckreadable
#endif
PETSC_EXTERN void petscviewercheckreadable_(PetscViewer *a, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerCheckReadable(v_a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewercheckwritable_ PETSCVIEWERCHECKWRITABLE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewercheckwritable_ petscviewercheckwritable
#endif
PETSC_EXTERN void petscviewercheckwritable_(PetscViewer *a, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerCheckWritable(v_a);
  if (*ierr) return;
}
