#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewergetsubviewer_ PETSCVIEWERGETSUBVIEWER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewergetsubviewer_ petscviewergetsubviewer
#endif
PETSC_EXTERN void petscviewergetsubviewer_(PetscViewer *a, MPI_Fint *b, PetscViewer *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  CHKFORTRANNULLOBJECT(c);
  *ierr = PetscViewerGetSubViewer(v_a, MPI_Comm_f2c(*(b)), c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerrestoresubviewer_ PETSCVIEWERRESTORESUBVIEWER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerrestoresubviewer_ petscviewerrestoresubviewer
#endif
PETSC_EXTERN void petscviewerrestoresubviewer_(PetscViewer *a, MPI_Fint *b, PetscViewer *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  CHKFORTRANNULLOBJECT(c);
  *ierr = PetscViewerRestoreSubViewer(v_a, MPI_Comm_f2c(*(b)), c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
