/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import type { ExtensionInstallMetadata, GeminiCLIExtension } from '@google/gemini-cli-core';
import { ExtensionUpdateState } from '../../ui/state/extensions.js';
/**
 * Clones a Git repository to a specified local path.
 * @param installMetadata The metadata for the extension to install.
 * @param destination The destination path to clone the repository to.
 */
export declare function cloneFromGit(installMetadata: ExtensionInstallMetadata, destination: string): Promise<void>;
export declare function parseGitHubRepoForReleases(source: string): {
    owner: string;
    repo: string;
};
export declare function fetchReleaseFromGithub(owner: string, repo: string, ref?: string, allowPreRelease?: boolean): Promise<GithubReleaseData>;
export declare function checkForExtensionUpdate(extension: GeminiCLIExtension, cwd?: string): Promise<ExtensionUpdateState>;
export interface GitHubDownloadResult {
    tagName: string;
    type: 'git' | 'github-release';
}
export declare function downloadFromGitHubRelease(installMetadata: ExtensionInstallMetadata, destination: string): Promise<GitHubDownloadResult>;
interface GithubReleaseData {
    assets: Asset[];
    tag_name: string;
    tarball_url?: string;
    zipball_url?: string;
}
interface Asset {
    name: string;
    browser_download_url: string;
}
export declare function findReleaseAsset(assets: Asset[]): Asset | undefined;
export declare function extractFile(file: string, dest: string): Promise<void>;
export {};
