set(PASTIX_VERSION 6.3.1)

# relocatable package

####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was PASTIXConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

set_and_check(PASTIX_BIN_DIR "${PACKAGE_PREFIX_DIR}/bin/")
set_and_check(PASTIX_INC_DIR "${PACKAGE_PREFIX_DIR}/include/")
set_and_check(PASTIX_LIB_DIR "${PACKAGE_PREFIX_DIR}/lib/")

check_required_components(PASTIX)

# dependencies of PASTIX
include(CMakeFindDependencyMacro)

# Threads
if( NOT ON )
  find_dependency(Threads)
endif()

# Math libraries
include("${CMAKE_CURRENT_LIST_DIR}/mTargets.cmake")
include("${CMAKE_CURRENT_LIST_DIR}/cblasTargets.cmake")
include("${CMAKE_CURRENT_LIST_DIR}/lapackeTargets.cmake")

# HwLoc libraries
if (TRUE AND NOT ON)
  include("${CMAKE_CURRENT_LIST_DIR}/hwlocTargets.cmake")
endif()

# MPI library
if (OFF)
  include("${CMAKE_CURRENT_LIST_DIR}/mpicTargets.cmake")
  if (ON)
    include("${CMAKE_CURRENT_LIST_DIR}/mpifTargets.cmake")
  endif()
endif()

# GPU libraries
if (OFF)
  include("${CMAKE_CURRENT_LIST_DIR}/cudaTargets.cmake")
  include("${CMAKE_CURRENT_LIST_DIR}/cublasTargets.cmake")
  include("${CMAKE_CURRENT_LIST_DIR}/pastix_kernels_cudaTargets.cmake")
endif()

# Runtime libraries
if (OFF)
  include("${CMAKE_CURRENT_LIST_DIR}/parsecTargets.cmake")
endif()
if (ON)
  include("${CMAKE_CURRENT_LIST_DIR}/starpuTargets.cmake")
endif()

# Ordering libraries
if (ON AND NOT ON)
  include("${CMAKE_CURRENT_LIST_DIR}/scotchTargets.cmake")
endif()
if (OFF AND NOT ON)
  include("${CMAKE_CURRENT_LIST_DIR}/ptscotchTargets.cmake")
endif()
if (ON AND NOT ON)
  include("${CMAKE_CURRENT_LIST_DIR}/metisTargets.cmake")
endif()

# add the targets file
if ( FALSE )
  include("/spmTargets.cmake")
  if (ON)
    include("/spmfTargets.cmake")
  endif()
else()
  include("${CMAKE_CURRENT_LIST_DIR}/../spm/spmTargets.cmake")
  if (ON)
    include("${CMAKE_CURRENT_LIST_DIR}/../spm/spmfTargets.cmake")
  endif()
endif()

include("${CMAKE_CURRENT_LIST_DIR}/pastix_kernelsTargets.cmake")
if (OFF)
  include("${CMAKE_CURRENT_LIST_DIR}/pastix_parsecTargets.cmake")
endif()
if (ON)
  include("${CMAKE_CURRENT_LIST_DIR}/pastix_starpuTargets.cmake")
endif()

include("${CMAKE_CURRENT_LIST_DIR}/pastixTargets.cmake")
include("${CMAKE_CURRENT_LIST_DIR}/pastixfTargets.cmake")
