Object.assign(window.search, {"doc_urls":["introduction.html#introduction","cli.html#using-the-wasmtime-cli","cli-install.html#installing-wasmtime","cli-install.html#download-precompiled-binaries","cli-install.html#compiling-from-source","cli-options.html#cli-options-for-wasmtime","cli-options.html#help","cli-options.html#run","cli-options.html#serve","cli-options.html#wast","cli-options.html#config","cli-options.html#compile","cli-options.html#settings","cli-logging.html#logging-in-the-wasmtime-cli","cli-cache.html#cache-configuration-of-wasmtime","cli-cache.html#setting-enabled","cli-cache.html#setting-directory","cli-cache.html#setting-worker-event-queue-size","cli-cache.html#setting-baseline-compression-level","cli-cache.html#setting-optimized-compression-level","cli-cache.html#setting-optimized-compression-usage-counter-threshold","cli-cache.html#setting-cleanup-interval","cli-cache.html#setting-optimizing-compression-task-timeout","cli-cache.html#setting-allowed-clock-drift-for-files-from-future","cli-cache.html#locks","cli-cache.html#cache-files","cli-cache.html#setting-file-count-soft-limit","cli-cache.html#setting-files-total-size-soft-limit","cli-cache.html#setting-file-count-limit-percent-if-deleting","cli-cache.html#setting-files-total-size-limit-percent-if-deleting","cli-cache.html#how-does-the-cache-work","cli-cache.html#cache-system","cli-cache.html#cache-worker","cli-cache.html#on-get-request","cli-cache.html#on-update-request","cli-cache.html#metadata-files","lang.html#using-the-wasmtime-api","lang-rust.html#using-webassembly-from-rust","lang-rust.html#creating-the-webassembly-to-execute","lang-rust.html#hello-world","lang-rust.html#importing-host-functionality","examples-rust-hello-world.html#hello-world","examples-rust-hello-world.html#hellowat","examples-rust-hello-world.html#hellors","examples-rust-gcd.html#calculating-the-gcd","examples-rust-gcd.html#gcdwat","examples-rust-gcd.html#gcdrs","examples-rust-memory.html#using-linear-memory","examples-rust-memory.html#memorywat","examples-rust-memory.html#memoryrs","examples-rust-wasi.html#wasi","examples-rust-wasi.html#webassembly-module-source-code","examples-rust-wasi.html#invoke-the-wasm-module","examples-rust-wasi.html#wasi-state-with-other-custom-host-state","examples-rust-wasi.html#wasi-preview-2","examples-rust-wasi.html#async-example","examples-rust-linking.html#linking-modules","examples-rust-linking.html#linking1wat","examples-rust-linking.html#linking2wat","examples-rust-linking.html#linkingrs","examples-rust-debugging.html#debugging","examples-rust-debugging.html#mainrs","examples-rust-core-dumps.html#core-dumps","examples-rust-core-dumps.html#mainrs","examples-rust-multi-value.html#using-multi-value","examples-rust-multi-value.html#multiwat","examples-rust-multi-value.html#multirs","lang-c.html#embedding-in-c","examples-c-hello-world.html#hello-world","examples-c-hello-world.html#hellowat","examples-c-hello-world.html#helloc","examples-c-gcd.html#calculating-the-gcd","examples-c-gcd.html#gcdwat","examples-c-gcd.html#gcdc","examples-c-memory.html#using-linear-memory","examples-c-memory.html#memorywat","examples-c-memory.html#memoryc","examples-c-wasi.html#wasi","examples-c-wasi.html#wasm-source-code","examples-c-wasi.html#wasic","examples-c-linking.html#linking-modules","examples-c-linking.html#linking1wat","examples-c-linking.html#linking2wat","examples-c-linking.html#linkingc","examples-c-debugging.html#debugging","examples-c-debugging.html#mainc","examples-c-multi-value.html#using-multi-value","examples-c-multi-value.html#multiwat","examples-c-multi-value.html#multic","lang-python.html#using-webassembly-from-python","lang-python.html#getting-started-and-simple-example","lang-python.html#more-examples-and-contributing","lang-dotnet.html#using-webassembly-from-net","lang-dotnet.html#getting-started-and-simple-example","lang-dotnet.html#more-examples-and-contributing","lang-go.html#using-webassembly-from-go","lang-go.html#getting-started-and-simple-example","lang-go.html#more-examples-and-contributing","lang-bash.html#using-webassembly-from-bash","lang-bash.html#getting-started-and-simple-example","lang-bash.html#gcdwat","lang-bash.html#gcdsh","lang-ruby.html#using-webassembly-from-ruby","lang-ruby.html#getting-started-and-simple-example","lang-ruby.html#more-examples-and-contributing","lang-elixir.html#using-webassembly-from-elixir","lang-elixir.html#getting-started-and-simple-example","lang-elixir.html#more-examples-and-contributing","examples.html#further-examples","examples-debugging.html#debugging-webassembly","examples-debugging-native-debugger.html#debugging-with-gdb-and-lldb","examples-debugging-core-dumps.html#debugging-webassembly-with-core-dumps","examples-profiling.html#profiling-webassembly","examples-profiling-perf.html#using-perf-on-linux","examples-profiling-perf.html#profiling-with-perfmap","examples-profiling-perf.html#profiling-with-jitdump","examples-profiling-perf.html#perf-and-dwarf-information","examples-profiling-perf.html#perf-example","examples-profiling-vtune.html#using-vtune","examples-profiling-vtune.html#turn-on-vtune-support","examples-profiling-vtune.html#profiling-wasmtime-itself","examples-profiling-vtune.html#example-getting-started","examples-profiling-vtune.html#example-cli-collection","examples-profiling-vtune.html#example-importing-results-into-gui","examples-profiling-vtune.html#example-gui-collection","examples-profiling-samply.html#using-samply-on-linuxmacos","examples-profiling-samply.html#profiling-with-perfmap","examples-profiling-guest.html#using-wasmtimes-cross-platform-profiler","wmemcheck.html#wasm-memcheck-wmemcheck","examples-minimal.html#building-a-minimal-wasmtime-embedding","examples-minimal.html#building-a-minimal-cli","examples-minimal.html#minimizing-further","examples-minimal.html#building-wasmtime-for-a-custom-platform","stability.html#stability","stability-release.html#release-process","stability-release.html#whats-released","stability-tiers.html#tiers-of-support-in-wasmtime","stability-tiers.html#current-tier-status","stability-tiers.html#tier-details","stability-platform-support.html#platform-support","stability-platform-support.html#compiler-support","stability-platform-support.html#interpreter-support","stability-platform-support.html#support-for-no_std","security.html#security","security.html#webassembly-core","security.html#defense-in-depth","security.html#filesystem-access","security.html#terminal-output","security.html#spectre","security-disclosure.html#disclosure-policy","security-what-is-considered-a-security-vulnerability.html#what-is-considered-a-security-vulnerability","security-what-is-considered-a-security-vulnerability.html#cheat-sheet-is-this-bug-considered-a-security-vulnerability","contributing.html#contributing","contributing.html#join-our-chat","contributing.html#finding-something-to-hack-on","contributing.html#mentoring","contributing-architecture.html#architecture-of-wasmtime","contributing-architecture.html#the-wasmtime-crate","contributing-architecture.html#important-concepts","contributing-architecture.html#compiling-a-module","contributing-architecture.html#trampolines","contributing-architecture.html#type-interning-and-vmsharedsignatureindex","contributing-architecture.html#instantiating-a-module","contributing-architecture.html#traps","contributing-architecture.html#linear-memory","contributing-architecture.html#tables-and-externref","contributing-architecture.html#gc-and-externref","contributing-architecture.html#index-of-crates","contributing-building.html#building","contributing-building.html#prerequisites","contributing-building.html#git-submodules","contributing-building.html#the-rust-toolchain","contributing-building.html#libclang-optional","contributing-building.html#building-the-wasmtime-cli","contributing-building.html#building-the-wasmtime-c-api","contributing-building.html#building-other-wasmtime-crates","contributing-testing.html#testing","contributing-testing.html#installing-wasm32-targets","contributing-testing.html#running-tests","contributing-testing.html#testing-a-specific-crate","contributing-testing.html#running-the-wasm-spec-tests","contributing-testing.html#running-wasi-integration-tests","contributing-testing.html#adding-new-tests","contributing-testing.html#adding-rusts-test-style-tests","contributing-testing.html#adding-specification-style-wast-tests","contributing-testing.html#adding-wasi-integration-tests","contributing-fuzzing.html#fuzzing","contributing-fuzzing.html#test-case-generators-and-oracles","contributing-fuzzing.html#libfuzzer-and-cargo-fuzz-fuzz-targets","contributing-ci.html#continuous-integration-ci","contributing-ci.html#prs-and-ci","contributing-ci.html#tests-run-on-ci","contributing-ci.html#artifacts-produced-on-ci","contributing-reducing-test-cases.html#reducing-test-cases","contributing-reducing-test-cases.html#case-study--issue-7779","contributing-cross-compiling.html#cross-compiling","contributing-cross-compiling.html#install-rust-targets","contributing-cross-compiling.html#install-gcc-cross-compilation-toolchains","contributing-cross-compiling.html#install-qemu","contributing-cross-compiling.html#configure-cargo","contributing-cross-compiling.html#cross-compile-tests-and-run-them","contributing-coding-guidelines.html#coding-guidelines","contributing-coding-guidelines.html#rustfmt","contributing-coding-guidelines.html#compiler-warnings-and-lints","contributing-coding-guidelines.html#clippy","contributing-coding-guidelines.html#minimum-supported-rustc-version","contributing-coding-guidelines.html#dependencies-of-wasmtime","contributing-coding-guidelines.html#cargo-vet-for-contributors","contributing-coding-guidelines.html#cargo-vet-for-maintainers","contributing-coding-guidelines.html#policy-for-adding-cargo-vet-entries","contributing-development-process.html#development-process","contributing-development-process.html#before-submitting-a-pr","contributing-development-process.html#when-submitting-prs","contributing-development-process.html#focused-commits-or-squashing","contributing-development-process.html#review-and-merge","contributing-implementing-wasm-proposals.html#implementing-webassembly-proposals","contributing-implementing-wasm-proposals.html#adding-new-support-for-a-wasm-proposal","contributing-implementing-wasm-proposals.html#enabling-support-for-a-proposal-by-default","contributing-implementing-wasm-proposals.html#adding-component-functionality-to-wasi","contributing-maintainer-guidelines.html#maintainer-guidelines","contributing-code-review.html#code-review","contributing-code-review.html#auto-assigned-reviewers","contributing-code-review.html#general-advice","contributing-release-process.html#release-process","contributing-release-process.html#releasing-a-major-version","contributing-release-process.html#releasing-a-patch-version","contributing-release-process.html#releasing-a-security-patch","contributing-release-process.html#releasing-notes","contributing-governance.html#governance","contributing-coc.html#contributor-covenant-code-of-conduct","contributing-coc.html#our-pledge","contributing-coc.html#our-standards","contributing-coc.html#our-responsibilities","contributing-coc.html#scope","contributing-coc.html#enforcement","contributing-coc.html#attribution"],"index":{"documentStore":{"docInfo":{"0":{"body":175,"breadcrumbs":2,"title":1},"1":{"body":64,"breadcrumbs":6,"title":3},"10":{"body":30,"breadcrumbs":6,"title":1},"100":{"body":65,"breadcrumbs":5,"title":1},"101":{"body":43,"breadcrumbs":5,"title":1},"102":{"body":28,"breadcrumbs":7,"title":3},"103":{"body":148,"breadcrumbs":8,"title":4},"104":{"body":15,"breadcrumbs":7,"title":3},"105":{"body":19,"breadcrumbs":7,"title":3},"106":{"body":125,"breadcrumbs":8,"title":4},"107":{"body":14,"breadcrumbs":7,"title":3},"108":{"body":9,"breadcrumbs":4,"title":2},"109":{"body":31,"breadcrumbs":6,"title":2},"11":{"body":38,"breadcrumbs":6,"title":1},"110":{"body":140,"breadcrumbs":10,"title":3},"111":{"body":224,"breadcrumbs":11,"title":4},"112":{"body":130,"breadcrumbs":6,"title":2},"113":{"body":51,"breadcrumbs":9,"title":3},"114":{"body":159,"breadcrumbs":8,"title":2},"115":{"body":219,"breadcrumbs":8,"title":2},"116":{"body":78,"breadcrumbs":9,"title":3},"117":{"body":122,"breadcrumbs":8,"title":2},"118":{"body":115,"breadcrumbs":8,"title":2},"119":{"body":52,"breadcrumbs":9,"title":3},"12":{"body":22,"breadcrumbs":6,"title":1},"120":{"body":36,"breadcrumbs":9,"title":3},"121":{"body":70,"breadcrumbs":9,"title":3},"122":{"body":156,"breadcrumbs":9,"title":3},"123":{"body":21,"breadcrumbs":10,"title":4},"124":{"body":53,"breadcrumbs":9,"title":3},"125":{"body":31,"breadcrumbs":9,"title":3},"126":{"body":119,"breadcrumbs":8,"title":2},"127":{"body":42,"breadcrumbs":12,"title":5},"128":{"body":150,"breadcrumbs":9,"title":3},"129":{"body":21,"breadcrumbs":9,"title":4},"13":{"body":100,"breadcrumbs":8,"title":3},"130":{"body":870,"breadcrumbs":8,"title":3},"131":{"body":352,"breadcrumbs":7,"title":2},"132":{"body":200,"breadcrumbs":9,"title":4},"133":{"body":3,"breadcrumbs":2,"title":1},"134":{"body":210,"breadcrumbs":5,"title":2},"135":{"body":55,"breadcrumbs":5,"title":2},"136":{"body":62,"breadcrumbs":6,"title":3},"137":{"body":544,"breadcrumbs":6,"title":3},"138":{"body":671,"breadcrumbs":5,"title":2},"139":{"body":82,"breadcrumbs":5,"title":2},"14":{"body":88,"breadcrumbs":8,"title":3},"140":{"body":113,"breadcrumbs":5,"title":2},"141":{"body":24,"breadcrumbs":5,"title":2},"142":{"body":113,"breadcrumbs":5,"title":2},"143":{"body":72,"breadcrumbs":2,"title":1},"144":{"body":114,"breadcrumbs":3,"title":2},"145":{"body":205,"breadcrumbs":3,"title":2},"146":{"body":45,"breadcrumbs":3,"title":2},"147":{"body":92,"breadcrumbs":3,"title":2},"148":{"body":71,"breadcrumbs":2,"title":1},"149":{"body":9,"breadcrumbs":5,"title":2},"15":{"body":24,"breadcrumbs":7,"title":2},"150":{"body":178,"breadcrumbs":7,"title":3},"151":{"body":135,"breadcrumbs":10,"title":6},"152":{"body":40,"breadcrumbs":2,"title":1},"153":{"body":76,"breadcrumbs":3,"title":2},"154":{"body":51,"breadcrumbs":4,"title":3},"155":{"body":86,"breadcrumbs":2,"title":1},"156":{"body":28,"breadcrumbs":4,"title":2},"157":{"body":137,"breadcrumbs":4,"title":2},"158":{"body":539,"breadcrumbs":4,"title":2},"159":{"body":358,"breadcrumbs":4,"title":2},"16":{"body":14,"breadcrumbs":7,"title":2},"160":{"body":135,"breadcrumbs":3,"title":1},"161":{"body":79,"breadcrumbs":5,"title":3},"162":{"body":264,"breadcrumbs":4,"title":2},"163":{"body":274,"breadcrumbs":3,"title":1},"164":{"body":253,"breadcrumbs":4,"title":2},"165":{"body":108,"breadcrumbs":4,"title":2},"166":{"body":107,"breadcrumbs":4,"title":2},"167":{"body":146,"breadcrumbs":4,"title":2},"168":{"body":7,"breadcrumbs":3,"title":1},"169":{"body":11,"breadcrumbs":3,"title":1},"17":{"body":24,"breadcrumbs":10,"title":5},"170":{"body":18,"breadcrumbs":4,"title":2},"171":{"body":9,"breadcrumbs":4,"title":2},"172":{"body":25,"breadcrumbs":4,"title":2},"173":{"body":42,"breadcrumbs":5,"title":3},"174":{"body":4,"breadcrumbs":6,"title":4},"175":{"body":38,"breadcrumbs":5,"title":3},"176":{"body":20,"breadcrumbs":3,"title":1},"177":{"body":28,"breadcrumbs":5,"title":3},"178":{"body":86,"breadcrumbs":4,"title":2},"179":{"body":37,"breadcrumbs":5,"title":3},"18":{"body":22,"breadcrumbs":9,"title":4},"180":{"body":93,"breadcrumbs":6,"title":4},"181":{"body":39,"breadcrumbs":6,"title":4},"182":{"body":0,"breadcrumbs":5,"title":3},"183":{"body":118,"breadcrumbs":7,"title":5},"184":{"body":104,"breadcrumbs":7,"title":5},"185":{"body":116,"breadcrumbs":6,"title":4},"186":{"body":0,"breadcrumbs":3,"title":1},"187":{"body":98,"breadcrumbs":6,"title":4},"188":{"body":50,"breadcrumbs":7,"title":5},"189":{"body":44,"breadcrumbs":5,"title":3},"19":{"body":17,"breadcrumbs":9,"title":4},"190":{"body":156,"breadcrumbs":4,"title":2},"191":{"body":135,"breadcrumbs":5,"title":3},"192":{"body":121,"breadcrumbs":5,"title":3},"193":{"body":108,"breadcrumbs":7,"title":3},"194":{"body":341,"breadcrumbs":8,"title":4},"195":{"body":84,"breadcrumbs":5,"title":2},"196":{"body":25,"breadcrumbs":6,"title":3},"197":{"body":27,"breadcrumbs":8,"title":5},"198":{"body":12,"breadcrumbs":5,"title":2},"199":{"body":90,"breadcrumbs":5,"title":2},"2":{"body":84,"breadcrumbs":6,"title":2},"20":{"body":24,"breadcrumbs":11,"title":6},"200":{"body":57,"breadcrumbs":7,"title":4},"201":{"body":16,"breadcrumbs":5,"title":2},"202":{"body":23,"breadcrumbs":4,"title":1},"203":{"body":126,"breadcrumbs":6,"title":3},"204":{"body":144,"breadcrumbs":4,"title":1},"205":{"body":64,"breadcrumbs":7,"title":4},"206":{"body":166,"breadcrumbs":5,"title":2},"207":{"body":115,"breadcrumbs":6,"title":3},"208":{"body":180,"breadcrumbs":6,"title":3},"209":{"body":185,"breadcrumbs":8,"title":5},"21":{"body":36,"breadcrumbs":8,"title":3},"210":{"body":18,"breadcrumbs":5,"title":2},"211":{"body":32,"breadcrumbs":6,"title":3},"212":{"body":108,"breadcrumbs":5,"title":2},"213":{"body":66,"breadcrumbs":6,"title":3},"214":{"body":42,"breadcrumbs":5,"title":2},"215":{"body":0,"breadcrumbs":7,"title":3},"216":{"body":165,"breadcrumbs":9,"title":5},"217":{"body":95,"breadcrumbs":8,"title":4},"218":{"body":118,"breadcrumbs":8,"title":4},"219":{"body":15,"breadcrumbs":5,"title":2},"22":{"body":43,"breadcrumbs":10,"title":5},"220":{"body":167,"breadcrumbs":7,"title":2},"221":{"body":193,"breadcrumbs":8,"title":3},"222":{"body":98,"breadcrumbs":7,"title":2},"223":{"body":17,"breadcrumbs":7,"title":2},"224":{"body":292,"breadcrumbs":8,"title":3},"225":{"body":186,"breadcrumbs":8,"title":3},"226":{"body":210,"breadcrumbs":8,"title":3},"227":{"body":62,"breadcrumbs":7,"title":2},"228":{"body":3,"breadcrumbs":3,"title":1},"229":{"body":11,"breadcrumbs":7,"title":4},"23":{"body":10,"breadcrumbs":11,"title":6},"230":{"body":35,"breadcrumbs":4,"title":1},"231":{"body":67,"breadcrumbs":4,"title":1},"232":{"body":44,"breadcrumbs":4,"title":1},"233":{"body":43,"breadcrumbs":4,"title":1},"234":{"body":55,"breadcrumbs":4,"title":1},"235":{"body":10,"breadcrumbs":4,"title":1},"24":{"body":52,"breadcrumbs":6,"title":1},"25":{"body":34,"breadcrumbs":7,"title":2},"26":{"body":29,"breadcrumbs":10,"title":5},"27":{"body":41,"breadcrumbs":11,"title":6},"28":{"body":45,"breadcrumbs":11,"title":6},"29":{"body":49,"breadcrumbs":12,"title":7},"3":{"body":84,"breadcrumbs":7,"title":3},"30":{"body":21,"breadcrumbs":7,"title":2},"31":{"body":48,"breadcrumbs":7,"title":2},"32":{"body":14,"breadcrumbs":7,"title":2},"33":{"body":53,"breadcrumbs":6,"title":1},"34":{"body":78,"breadcrumbs":7,"title":2},"35":{"body":7,"breadcrumbs":7,"title":2},"36":{"body":27,"breadcrumbs":6,"title":3},"37":{"body":23,"breadcrumbs":7,"title":3},"38":{"body":36,"breadcrumbs":7,"title":3},"39":{"body":252,"breadcrumbs":6,"title":2},"4":{"body":19,"breadcrumbs":6,"title":2},"40":{"body":272,"breadcrumbs":7,"title":3},"41":{"body":32,"breadcrumbs":8,"title":2},"42":{"body":10,"breadcrumbs":7,"title":1},"43":{"body":182,"breadcrumbs":7,"title":1},"44":{"body":19,"breadcrumbs":8,"title":2},"45":{"body":58,"breadcrumbs":7,"title":1},"46":{"body":56,"breadcrumbs":7,"title":1},"47":{"body":21,"breadcrumbs":10,"title":3},"48":{"body":37,"breadcrumbs":8,"title":1},"49":{"body":207,"breadcrumbs":8,"title":1},"5":{"body":16,"breadcrumbs":8,"title":3},"50":{"body":25,"breadcrumbs":6,"title":1},"51":{"body":25,"breadcrumbs":9,"title":4},"52":{"body":94,"breadcrumbs":8,"title":3},"53":{"body":79,"breadcrumbs":10,"title":5},"54":{"body":33,"breadcrumbs":8,"title":3},"55":{"body":176,"breadcrumbs":7,"title":2},"56":{"body":23,"breadcrumbs":8,"title":2},"57":{"body":65,"breadcrumbs":7,"title":1},"58":{"body":90,"breadcrumbs":7,"title":1},"59":{"body":103,"breadcrumbs":7,"title":1},"6":{"body":30,"breadcrumbs":6,"title":1},"60":{"body":23,"breadcrumbs":6,"title":1},"61":{"body":97,"breadcrumbs":6,"title":1},"62":{"body":26,"breadcrumbs":8,"title":2},"63":{"body":179,"breadcrumbs":7,"title":1},"64":{"body":20,"breadcrumbs":10,"title":3},"65":{"body":73,"breadcrumbs":8,"title":1},"66":{"body":167,"breadcrumbs":8,"title":1},"67":{"body":14,"breadcrumbs":6,"title":2},"68":{"body":17,"breadcrumbs":8,"title":2},"69":{"body":10,"breadcrumbs":7,"title":1},"7":{"body":83,"breadcrumbs":6,"title":1},"70":{"body":402,"breadcrumbs":7,"title":1},"71":{"body":19,"breadcrumbs":8,"title":2},"72":{"body":58,"breadcrumbs":7,"title":1},"73":{"body":291,"breadcrumbs":7,"title":1},"74":{"body":21,"breadcrumbs":10,"title":3},"75":{"body":37,"breadcrumbs":8,"title":1},"76":{"body":711,"breadcrumbs":8,"title":1},"77":{"body":18,"breadcrumbs":6,"title":1},"78":{"body":4,"breadcrumbs":8,"title":3},"79":{"body":287,"breadcrumbs":6,"title":1},"8":{"body":58,"breadcrumbs":6,"title":1},"80":{"body":17,"breadcrumbs":8,"title":2},"81":{"body":65,"breadcrumbs":7,"title":1},"82":{"body":90,"breadcrumbs":7,"title":1},"83":{"body":404,"breadcrumbs":7,"title":1},"84":{"body":23,"breadcrumbs":6,"title":1},"85":{"body":234,"breadcrumbs":6,"title":1},"86":{"body":20,"breadcrumbs":10,"title":3},"87":{"body":73,"breadcrumbs":8,"title":1},"88":{"body":399,"breadcrumbs":8,"title":1},"89":{"body":34,"breadcrumbs":7,"title":3},"9":{"body":29,"breadcrumbs":6,"title":1},"90":{"body":154,"breadcrumbs":8,"title":4},"91":{"body":26,"breadcrumbs":7,"title":3},"92":{"body":32,"breadcrumbs":7,"title":3},"93":{"body":163,"breadcrumbs":8,"title":4},"94":{"body":27,"breadcrumbs":7,"title":3},"95":{"body":24,"breadcrumbs":7,"title":3},"96":{"body":162,"breadcrumbs":8,"title":4},"97":{"body":23,"breadcrumbs":7,"title":3},"98":{"body":0,"breadcrumbs":7,"title":3},"99":{"body":32,"breadcrumbs":8,"title":4}},"docs":{"0":{"body":"Wasmtime is a standalone runtime for WebAssembly, WASI, and the Component Model by the Bytecode Alliance . WebAssembly (abbreviated Wasm) is a binary instruction format that is designed to be a portable compilation target for programming languages. Wasm binaries typically have a .wasm file extension. In this documentation, we'll also use the textual representation of the binary files, which have a .wat file extension. WASI (the WebAssembly System Interface) defines interfaces that provide a secure and portable way to access several operating-system-like features such as filesystems, networking, clocks, and random numbers. The Component Model is a Wasm architecture that provides a binary format for portable, cross-language composition. More specifically, it supports the use of interfaces via which components can communicate with each other. WASI is defined in terms of component model interfaces. Wasmtime runs WebAssembly code outside of the Web , and can be used both as a command-line utility or as a library embedded in a larger application. It strives to be Fast : Wasmtime is built on the optimizing Cranelift code generator. Secure : Wasmtime's development is strongly focused on correctness and security. Configurable : Wasmtime uses sensible defaults, but can also be configured to provide more fine-grained control over things like CPU and memory consumption. Standards Compliant : Wasmtime passes the official WebAssembly test suite and the Wasmtime developers are intimately engaged with the WebAssembly standards process. This documentation is intended to serve a number of purposes and within you'll find: How to use Wasmtime from a number of languages How to install and use the wasmtime CLI Information about stability and security in Wasmtime. Documentation about contributing to Wasmtime. ... and more! The source for this guide lives on GitHub and contributions are welcome!","breadcrumbs":"Introduction » Introduction","id":"0","title":"Introduction"},"1":{"body":"In addition to the embedding API which allows you to use Wasmtime as a library, the Wasmtime project also provides a wasmtime CLI tool to conveniently execute WebAssembly modules from the command line. This section will provide a guide to the wasmtime CLI and major functionality that it contains. In short, however, you can execute a WebAssembly file (actually doing work as part of the start function) like so: $ wasmtime foo.wasm Or similarly if you want to invoke a \"start\" function, such as with WASI modules, you can execute $ wasmtime --invoke _start foo.wasm For more information be sure to check out how to install the CLI , the list of options you can pass , and how to enable logging .","breadcrumbs":"Using the Wasmtime CLI » Using the wasmtime CLI","id":"1","title":"Using the wasmtime CLI"},"10":{"body":"This subcommand is used to control and edit local Wasmtime configuration settings. The primary purpose of this currently is to configure how Wasmtime's code caching works . You can create a new configuration file for you to edit with: $ wasmtime config new And that'll print out the path to the file you can edit.","breadcrumbs":"Using the Wasmtime CLI » CLI Options » config","id":"10","title":"config"},"100":{"body":"(module (func $gcd (param i32 i32) (result i32) (local i32) block ;; label = @1 block ;; label = @2 local.get 0 br_if 0 (;@2;) local.get 1 local.set 2 br 1 (;@1;) end loop ;; label = @2 local.get 1 local.get 0 local.tee 2 i32.rem_u local.set 0 local.get 2 local.set 1 local.get 0 br_if 0 (;@2;) end end local.get 2 ) (export \"gcd\" (func $gcd))\n) Create a bash script that will invoke GCD three times.","breadcrumbs":"Using the Wasmtime API » Bash » gcd.wat","id":"100","title":"gcd.wat"},"101":{"body":"#!/bin/bash function gcd() { # Cast to number; default = 0 local x=$(($1)) local y=$(($2)) # Invoke GCD from module; suppress stderr local result=$(wasmtime --invoke gcd examples/gcd.wat $x $y 2>/dev/null) echo \"$result\"\n} # main\nfor num in \"27 6\" \"6 27\" \"42 12\"; do set -- $num echo \"gcd($1, $2) = $(gcd \"$1\" \"$2\")\"\ndone","breadcrumbs":"Using the Wasmtime API » Bash » gcd.sh","id":"101","title":"gcd.sh"},"102":{"body":"Wasmtime is available on RubyGems and can be used programmatically to interact with Wasm modules. This guide will go over installing the Wasmtime gem and running a simple Wasm module from Ruby. Make sure you've got Ruby 3.0 or newer installed locally, and we can get started!","breadcrumbs":"Using the Wasmtime API » Ruby » Using WebAssembly from Ruby","id":"102","title":"Using WebAssembly from Ruby"},"103":{"body":"First, copy this example WebAssembly text module into your project. It exports a function for calculating the greatest common denominator of two numbers. (module (func $gcd (param i32 i32) (result i32) (local i32) block ;; label = @1 block ;; label = @2 local.get 0 br_if 0 (;@2;) local.get 1 local.set 2 br 1 (;@1;) end loop ;; label = @2 local.get 1 local.get 0 local.tee 2 i32.rem_u local.set 0 local.get 2 local.set 1 local.get 0 br_if 0 (;@2;) end end local.get 2 ) (export \"gcd\" (func $gcd))\n) Next, install the Wasmtime Ruby gems by either adding it your project's Gemfile: bundle add wasmtime Or by using the gem command directly: gem install wasmtime The gem has a Rust-based native extension, but thanks to precompiled gems, you should not have to compile anything. It'll just work! Now that you have the Wasmtime gem installed, let's create a Ruby script to execute the gcd module from before. require \"wasmtime\" engine = Wasmtime::Engine.new\nmod = Wasmtime::Module.from_file(engine, \"gcd.wat\")\nstore = Wasmtime::Store.new(engine)\ninstance = Wasmtime::Instance.new(store, mod) puts \"gcd(27, 6) = #{instance.invoke(\"gcd\", 27, 6)}\" This script should output gcd(27, 6) = 3 If this is the output you see, congrats! You've successfully ran your first WebAssembly code in Ruby!","breadcrumbs":"Using the Wasmtime API » Ruby » Getting started and simple example","id":"103","title":"Getting started and simple example"},"104":{"body":"To learn more, check out the more advanced examples and the API documentation . If you have any questions, do not hesitate to open an issue on the GitHub repository .","breadcrumbs":"Using the Wasmtime API » Ruby » More examples and contributing","id":"104","title":"More examples and contributing"},"105":{"body":"Wasmtime is available on Hex and can be used programmatically to interact with Wasm modules. This guide will go over installing the wasmex package and running a simple Wasm module from Elixir.","breadcrumbs":"Using the Wasmtime API » Elixir » Using WebAssembly from Elixir","id":"105","title":"Using WebAssembly from Elixir"},"106":{"body":"First, copy this example WebAssembly text module into the current directory. It exports a function for calculating the greatest common denominator of two numbers. (module (func $gcd (param i32 i32) (result i32) (local i32) block ;; label = @1 block ;; label = @2 local.get 0 br_if 0 (;@2;) local.get 1 local.set 2 br 1 (;@1;) end loop ;; label = @2 local.get 1 local.get 0 local.tee 2 i32.rem_u local.set 0 local.get 2 local.set 1 local.get 0 br_if 0 (;@2;) end end local.get 2 ) (export \"gcd\" (func $gcd))\n) The library has a Rust-based native extension, but thanks to rustler_precompiled, you should not have to compile anything. It'll just work! This WAT file can be executed in iex: Mix.install([:wasmex])\nbytes = File.read!(\"gcd.wat\")\n{:ok, pid} = Wasmex.start_link(%{bytes: bytes}) # starts a GenServer running a WASM instance\nWasmex.call_function(pid, \"gcd\", [27, 6]) The last command should output: iex(5)> Wasmex.call_function(pid, \"gcd\", [27, 6])\n{:ok, [3]} If this is the output you see, congrats! You've successfully ran your first WebAssembly code in Elixir!","breadcrumbs":"Using the Wasmtime API » Elixir » Getting started and simple example","id":"106","title":"Getting started and simple example"},"107":{"body":"To learn more, check out an another example and the API documentation . If you have any questions, do not hesitate to open an issue on the GitHub repository .","breadcrumbs":"Using the Wasmtime API » Elixir » More examples and contributing","id":"107","title":"More examples and contributing"},"108":{"body":"The examples contained in this section explain how to use Wasmtime in several common scenarios.","breadcrumbs":"Further Examples » Further Examples","id":"108","title":"Further Examples"},"109":{"body":"Wasmtime currently provides the following support for debugging misbehaving WebAssembly: We can live debug and step through the guest Wasm and the host at the same time with gdb or lldb. When a Wasm guest traps, we can generate Wasm core dumps , that can be consumed by other tools for post-mortem analysis.","breadcrumbs":"Further Examples » Debugging WebAssembly » Debugging WebAssembly","id":"109","title":"Debugging WebAssembly"},"11":{"body":"This subcommand is used to Ahead-Of-Time (AOT) compile a WebAssembly module to produce a \"compiled wasm\" (.cwasm) file. The wasmtime run subcommand can then be used to run a AOT-compiled WebAssembly module: $ wasmtime compile foo.wasm\n$ wasmtime foo.cwasm AOT-compiled modules can be run from hosts that are compatible with the target environment of the AOT-completed module.","breadcrumbs":"Using the Wasmtime CLI » CLI Options » compile","id":"11","title":"compile"},"110":{"body":"The following steps describe how to use gdb or lldb to debug both the Wasm guest and the host (i.e. the Wasmtime CLI or your Wasmtime-embedding program) at the same time: Compile your WebAssembly with debug info enabled, usually -g; for example: clang foo.c -g -o foo.wasm Run Wasmtime with the debug info enabled; this is -D debug-info from the CLI and Config::debug_info(true) in an embedding (e.g. see debugging in a Rust embedding ). It's also recommended to use -O opt-level=0 for better inspection of local variables if desired. Use a supported debugger: lldb -- wasmtime run -D debug-info foo.wasm gdb --args wasmtime run -D debug-info -O opt-level=0 foo.wasm If you run into trouble, the following discussions might help: On MacOS with LLDB you may need to run: settings set plugin.jit-loader.gdb.enable on ( #1953 ) With LLDB, call __vmctx.set() to set the current context before calling any dereference operators ( #1482 ): (lldb) p __vmctx->set()\n(lldb) p *foo The address of the start of instance memory can be found in __vmctx->memory On Windows you may experience degraded WASM compilation throughput due to the enablement of additional native heap checks when under the debugger by default. You can set the environment variable _NO_DEBUG_HEAP to 1 to disable them.","breadcrumbs":"Further Examples » Debugging WebAssembly » Debugging with gdb and lldb » Debugging with gdb and lldb","id":"110","title":"Debugging with gdb and lldb"},"111":{"body":"Wasmtime can be configured to generate the standard Wasm core dump format whenever guest Wasm programs trap. These core dumps can then be consumed by external tooling (such as wasmgdb ) for post-mortem analysis. This page focuses on generating and inspecting core dumps via the Wasmtime command-line interface. For details on how to generate core dumps via the wasmtime embedding API, see Core Dumps in a Rust Embedding . First, we need to compile some code to Wasm that can trap. Consider the following Rust code: // trap.rs fn main() { foo(42);\n} fn foo(x: u32) { bar(x);\n} fn bar(x: u32) { baz(x);\n} fn baz(x: u32) { assert!(x != 42);\n} We can compile it to Wasm with the following command: $ rustc --target wasm32-wasip1 -o ./trap.wasm ./trap.rs Next, we can run it in Wasmtime and capture a core dump when it traps: $ wasmtime -D coredump=./trap.coredump ./trap.wasm\nthread 'main' panicked at /home/nick/scratch/trap.rs:14:5:\nassertion failed: x != 42\nnote: run with `RUST_BACKTRACE=1` environment variable to display a backtrace\nError: failed to run main module `/home/nick/scratch/trap.wasm` Caused by: 0: core dumped at /home/nick/scratch/trap.coredump 1: failed to invoke command default 2: wasm coredump generated while executing store_name: modules: <module> instances: Instance(store=1, index=1) memories: Memory(store=1, index=1) globals: Global(store=1, index=0) backtrace: error while executing at wasm backtrace: 0: 0x5961 - <unknown>!__rust_start_panic 1: 0x562a - <unknown>!rust_panic 2: 0x555d - <unknown>!std::panicking::rust_panic_with_hook::h58e7d0b3d70e95b6 3: 0x485d - <unknown>!std::panicking::begin_panic_handler::{{closure}}::h1853004619879cfd 4: 0x47bd - <unknown>!std::sys_common::backtrace::__rust_end_short_backtrace::hed32bc5557405634 5: 0x4f02 - <unknown>!rust_begin_unwind 6: 0xac01 - <unknown>!core::panicking::panic_fmt::h53ca5bf48b428895 7: 0xb1c5 - <unknown>!core::panicking::panic::h62c2c2bb054da7e1 8: 0x661 - <unknown>!trap::baz::h859f39b65389c077 9: 0x616 - <unknown>!trap::bar::h7ad12f9c5b730d17 10: 0x60a - <unknown>!trap::foo::ha69c95723611c1a0 11: 0x5fe - <unknown>!trap::main::hdfcd9f2d150fc3dc 12: 0x434 - <unknown>!core::ops::function::FnOnce::call_once::h24336e950fb97d1e 13: 0x40b - <unknown>!std::sys_common::backtrace::__rust_begin_short_backtrace::h2b37384d2b1a57ff 14: 0x4ec - <unknown>!std::rt::lang_start::{{closure}}::he86eb1b6ac6d7501 15: 0x24f7 - <unknown>!std::rt::lang_start_internal::h21f6a1d8f3633b54 16: 0x497 - <unknown>!std::rt::lang_start::h7d256f21902ff32b 17: 0x687 - <unknown>!__main_void 18: 0x3e6 - <unknown>!_start note: using the `WASMTIME_BACKTRACE_DETAILS=1` environment variable may show more debugging information You now have a core dump at ./trap.coredump that can be consumed by external tooling to do post-mortem analysis of the failure.","breadcrumbs":"Further Examples » Debugging WebAssembly » Debugging with Core Dumps » Debugging WebAssembly with Core Dumps","id":"111","title":"Debugging WebAssembly with Core Dumps"},"112":{"body":"One of WebAssembly's major goals is to be quite close to native code in terms of performance, so typically when executing Wasm you'll be quite interested in how well your Wasm module is performing! From time to time you might want to dive a bit deeper into the performance of your Wasm, and this is where profiling comes into the picture. For best results, ideally you'd use hardware performance counters for your timing measurements. However, that requires special support from your CPU and operating system. Because Wasmtime is a JIT, that also requires hooks from Wasmtime to your platform's native profiling tools. As a result, Wasmtime support for native profiling is limited to certain platforms. See the following sections of this book if you're using these platforms: On Linux, we support perf . For Intel's x86 CPUs on Linux or Windows, we support VTune . For Linux and macOS, we support samply . For everything else, see the cross-platform profiler . The native profilers can measure time spent in WebAssembly guest code as well as time spent in the Wasmtime host and potentially even time spent in the kernel. This provides a comprehensive view of performance. The cross-platform-profiler can only measure time spent in WebAssembly guest code, and its timing measurements are not as precise as the native profilers. However, it works on every platform that Wasmtime supports.","breadcrumbs":"Further Examples » Profiling WebAssembly » Profiling WebAssembly","id":"112","title":"Profiling WebAssembly"},"113":{"body":"One profiler supported by Wasmtime is the perf profiler for Linux. This is an extremely powerful profiler with lots of documentation on the web, but for the rest of this section we'll assume you're running on Linux and already have perf installed. There are two profiling agents for perf: a very simple one that will map code regions to symbol names: perfmap. a more detailed one that can provide additional information and mappings between the source language statements and generated JIT code: jitdump.","breadcrumbs":"Further Examples » Profiling WebAssembly » Profiling with Perf » Using perf on Linux","id":"113","title":"Using perf on Linux"},"114":{"body":"Simple profiling support with perf generates a \"perf map\" file that the perf CLI will automatically look for, when running into unresolved symbols. This requires runtime support from Wasmtime itself, so you will need to manually change a few things to enable profiling support in your application. Enabling runtime support depends on how you're using Wasmtime: Rust API - you'll want to call the [Config::profiler] method with ProfilingStrategy::PerfMap to enable profiling of your wasm modules. C API - you'll want to call the wasmtime_config_profiler_set API with a WASMTIME_PROFILING_STRATEGY_PERFMAP value. Command Line - you'll want to pass the --profile=perfmap flag on the command line. Once perfmap support is enabled, you'll use perf record like usual to record your application's performance. For example if you're using the CLI, you'll execute: $ perf record -k mono wasmtime --profile=perfmap foo.wasm This will create a perf.data file as per usual, but it will also create a /tmp/perf-XXXX.map file. This extra .map file is the perf map file which is specified by perf and Wasmtime generates at runtime. After that you can explore the perf.data profile as you usually would, for example with: $ perf report --input perf.data You should be able to see time spent in wasm functions, generate flamegraphs based on that, etc.. You should also see entries for wasm functions show up as one function and the name of each function matches the debug name section in the wasm file. Note that support for perfmap is still relatively new in Wasmtime, so if you have any problems, please don't hesitate to file an issue !","breadcrumbs":"Further Examples » Profiling WebAssembly » Profiling with Perf » Profiling with perfmap","id":"114","title":"Profiling with perfmap"},"115":{"body":"Profiling support with perf uses the \"jitdump\" support in the perf CLI. This requires runtime support from Wasmtime itself, so you will need to manually change a few things to enable profiling support in your application. First you'll want to make sure that Wasmtime is compiled with the jitdump Cargo feature (which is enabled by default). Otherwise enabling runtime support depends on how you're using Wasmtime: Rust API - you'll want to call the [Config::profiler] method with ProfilingStrategy::JitDump to enable profiling of your wasm modules. C API - you'll want to call the wasmtime_config_profiler_set API with a WASMTIME_PROFILING_STRATEGY_JITDUMP value. Command Line - you'll want to pass the --profile=jitdump flag on the command line. Once jitdump support is enabled, you'll use perf record like usual to record your application's performance. You'll need to also be sure to pass the --clockid mono or -k mono flag to perf record. For example if you're using the CLI, you'll execute: $ perf record -k mono wasmtime --profile=jitdump foo.wasm This will create a perf.data file as per usual, but it will also create a jit-XXXX.dump file. This extra *.dump file is the jitdump file which is specified by perf and Wasmtime generates at runtime. The next thing you need to do is to merge the *.dump file into the perf.data file, which you can do with the perf inject command: $ perf inject --jit --input perf.data --output perf.jit.data This will read perf.data, automatically pick up the *.dump file that's correct, and then create perf.jit.data which merges all the JIT information together. This should also create a lot of jitted-XXXX-N.so files in the current directory which are ELF images for all the JIT functions that were created by Wasmtime. After that you can explore the perf.jit.data profile as you usually would, for example with: $ perf report --input perf.jit.data You should be able to annotate wasm functions and see their raw assembly. You should also see entries for wasm functions show up as one function and the name of each function matches the debug name section in the wasm file. Note that support for jitdump is still relatively new in Wasmtime, so if you have any problems, please don't hesitate to file an issue !","breadcrumbs":"Further Examples » Profiling WebAssembly » Profiling with Perf » Profiling with jitdump","id":"115","title":"Profiling with jitdump"},"116":{"body":"If the jitdump profile doesn't give you enough information by default, you can also enable dwarf debug information to be generated for JIT code which should give the perf profiler more information about what's being profiled. This can include information like more descriptive function names, filenames, and line numbers. Enabling dwarf debug information for JIT code depends on how you're using Wasmtime: Rust API - you'll want to call the Config::debug_info method. C API - you'll want to call the wasmtime_config_debug_info_set API. Command Line - you'll want to pass the -g flag on the command line. You shouldn't need to do anything else to get this information into perf. The perf collection data should automatically pick up all this dwarf debug information.","breadcrumbs":"Further Examples » Profiling WebAssembly » Profiling with Perf » perf and DWARF information","id":"116","title":"perf and DWARF information"},"117":{"body":"Let's run through a quick example with perf to get the feel for things. First let's take a look at some wasm: fn main() { let n = 42; println!(\"fib({}) = {}\", n, fib(n));\n} fn fib(n: u32) -> u32 { if n <= 2 { 1 } else { fib(n - 1) + fib(n - 2) }\n} To collect perf information for this wasm module we'll execute: $ rustc --target wasm32-wasip1 fib.rs -O\n$ perf record -k mono wasmtime --profile=jitdump fib.wasm\nfib(42) = 267914296\n[ perf record: Woken up 1 times to write data ]\n[ perf record: Captured and wrote 0.147 MB perf.data (3435 samples) ]\n$ perf inject --jit --input perf.data --output perf.jit.data And we should have all our information now! We can execute perf report for example to see that 99% of our runtime (as expected) is spent in our fib function. Note that the symbol has been demangled to fib::fib which is what the Rust symbol is: $ perf report --input perf.jit.data perf report output Alternatively we could also use perf annotate to take a look at the disassembly of the fib function, seeing what the JIT generated: $ perf annotate --input perf.jit.data perf annotate output","breadcrumbs":"Further Examples » Profiling WebAssembly » Profiling with Perf » perf example","id":"117","title":"perf example"},"118":{"body":"VTune is a popular performance profiling tool that targets both 32-bit and 64-bit x86 architectures. The tool collects profiling data during runtime and then, either through the command line or GUI, provides a variety of options for viewing and analyzing that data. VTune Profiler is available in both commercial and free options. The free, downloadable version is available here and is backed by a community forum for support. This version is appropriate for detailed analysis of your Wasm program. VTune support in Wasmtime is provided through the JIT profiling APIs from the ittapi library. This library provides code generators (or the runtimes that use them) a way to report JIT activities. The APIs are implemented in a static library (see ittapi source) which Wasmtime links to when VTune support is specified through the vtune Cargo feature flag; this feature is not enabled by default. When the VTune collector is run, the ittapi library collects Wasmtime's reported JIT activities. This connection to ittapi is provided by the ittapi-rs crate. For more information on VTune and the analysis tools it provides see its documentation .","breadcrumbs":"Further Examples » Profiling WebAssembly » Profiling with VTune » Using VTune","id":"118","title":"Using VTune"},"119":{"body":"For JIT profiling with VTune, Wasmtime currently builds with the vtune feature enabled by default. This ensures the compiled binary understands how to inform the ittapi library of JIT events. But it must still be enabled at runtime--enable runtime support based on how you use Wasmtime: Rust API - call the [Config::profiler] method with ProfilingStrategy::VTune to enable profiling of your wasm modules. C API - call the wasmtime_config_profiler_set API with a WASMTIME_PROFILING_STRATEGY_VTUNE value. Command Line - pass the --profile=vtune flag on the command line.","breadcrumbs":"Further Examples » Profiling WebAssembly » Profiling with VTune » Turn on VTune support","id":"119","title":"Turn on VTune support"},"12":{"body":"This subcommand is used to print the available Cranelift settings for a given target. When run without options, it will print the settings for the host target and also display what Cranelift settings are inferred for the host: $ wasmtime settings","breadcrumbs":"Using the Wasmtime CLI » CLI Options » settings","id":"12","title":"settings"},"120":{"body":"Note that VTune is capable of profiling a single process or all system processes. Like perf, VTune is capable of profiling the Wasmtime runtime itself without any added support. However, the ittapi APIs also provide an interface for marking the start and stop of code regions for easy isolation in the VTune Profiler. Support for these APIs is expected to be added in the future.","breadcrumbs":"Further Examples » Profiling WebAssembly » Profiling with VTune » Profiling Wasmtime itself","id":"120","title":"Profiling Wasmtime itself"},"121":{"body":"With VTune properly installed , if you are using the CLI execute: $ cargo build\n$ vtune -run-pass-thru=--no-altstack -collect hotspots target/debug/wasmtime --profile=vtune foo.wasm This command tells the VTune collector (vtune) to collect hot spot profiling data as Wasmtime is executing foo.wasm. The --profile=vtune flag enables VTune support in Wasmtime so that the collector is also alerted to JIT events that take place during runtime. The first time this is run, the result of the command is a results directory r000hs/ which contains profiling data for Wasmtime and the execution of foo.wasm. This data can then be read and displayed via the command line or via the VTune GUI by importing the result.","breadcrumbs":"Further Examples » Profiling WebAssembly » Profiling with VTune » Example: Getting Started","id":"121","title":"Example: Getting Started"},"122":{"body":"Using a familiar algorithm, we'll start with the following Rust code: fn main() { let n = 45; println!(\"fib({}) = {}\", n, fib(n));\n} fn fib(n: u32) -> u32 { if n <= 2 { 1 } else { fib(n - 1) + fib(n - 2) }\n} We compile the example to Wasm: $ rustc --target wasm32-wasip1 fib.rs -C opt-level=z -C lto=yes Then we execute the Wasmtime runtime (built with the vtune feature and executed with the --profile=vtune flag to enable reporting) inside the VTune CLI application, vtune, which must already be installed and available on the path. To collect hot spot profiling information, we execute: $ rustc --target wasm32-wasip1 fib.rs -C opt-level=z -C lto=yes\n$ vtune -run-pass-thru=--no-altstack -v -collect hotspots target/debug/wasmtime --profile=vtune fib.wasm\nfib(45) = 1134903170\namplxe: Collection stopped.\namplxe: Using result path /home/jlb6740/wasmtime/r000hs\namplxe: Executing actions 7 % Clearing the database\namplxe: The database has been cleared, elapsed time is 0.239 seconds.\namplxe: Executing actions 14 % Updating precomputed scalar metrics\namplxe: Raw data has been loaded to the database, elapsed time is 0.792 seconds.\namplxe: Executing actions 19 % Processing profile metrics and debug information\n...\nTop Hotspots\nFunction Module CPU Time\n-------------------------------------------------------------------------------------------- -------------- --------\nh2bacf53cb3845acf [Dynamic code] 3.480s\n__memmove_avx_unaligned_erms libc.so.6 0.222s\ncranelift_codegen::ir::instructions::InstructionData::opcode::hee6f5b6a72fc684e wasmtime 0.122s\ncore::ptr::slice_from_raw_parts::hc5cb6f1b39a0e7a1 wasmtime 0.066s\n_$LT$usize$u20$as$u20$core..slice..SliceIndex$LT$$u5b$T$u5d$$GT$$GT$::get::h70c7f142eeeee8bd wasmtime 0.066s","breadcrumbs":"Further Examples » Profiling WebAssembly » Profiling with VTune » Example: CLI Collection","id":"122","title":"Example: CLI Collection"},"123":{"body":"Results directories created by the vtune CLI can be imported in the VTune GUI by clicking \"Open > Result\". Below is a visualization of the collected data as seen in VTune's GUI: vtune report output","breadcrumbs":"Further Examples » Profiling WebAssembly » Profiling with VTune » Example: Importing Results into GUI","id":"123","title":"Example: Importing Results into GUI"},"124":{"body":"VTune can collect data in multiple ways (see vtune CLI discussion above); another way is to use the VTune GUI directly. A standard work flow might look like: Open VTune Profiler \"Configure Analysis\" with \"Application\" set to /path/to/wasmtime (e.g., target/debug/wasmtime) \"Application parameters\" set to --profile=vtune /path/to/module.wasm \"Working directory\" set as appropriate Enable \"Hardware Event-Based Sampling,\" which may require some system configuration, e.g. sysctl -w kernel.perf_event_paranoid=0 Start the analysis","breadcrumbs":"Further Examples » Profiling WebAssembly » Profiling with VTune » Example: GUI Collection","id":"124","title":"Example: GUI Collection"},"125":{"body":"One profiler supported by Wasmtime is samply for Linux and macOS. As of 17th July 2023, the latest version of samply (on crates.io) is 0.11.0 which does not seem to support perfmaps. To use this, you either need a newer version of samply, if by the time you read this, a newer version has been released, or you can build samply from source.","breadcrumbs":"Further Examples » Profiling WebAssembly » Profiling with samply » Using samply on Linux/macOS","id":"125","title":"Using samply on Linux/macOS"},"126":{"body":"Simple profiling support with samply generates a \"perfmap\" file that the samply CLI will automatically look for, when running into unresolved symbols. This requires runtime support from Wasmtime itself, so you will need to manually change a few things to enable profiling support in your application. Enabling runtime support depends on how you're using Wasmtime: Rust API - you'll want to call the [Config::profiler] method with ProfilingStrategy::PerfMap to enable profiling of your wasm modules. C API - you'll want to call the wasmtime_config_profiler_set API with a WASMTIME_PROFILING_STRATEGY_PERFMAP value. Command Line - you'll want to pass the --profile=perfmap flag on the command line. Once perfmap support is enabled, you'll use samply record like usual to record your application's performance. For example if you're using the CLI, you'll execute: $ samply record wasmtime --profile=perfmap foo.wasm This will record your application's performance and open the Firefox profiler UI to view the results. It will also dump its own profile data to a json file (called profile.json) in the current directory. Note that support for perfmap is still relatively new in Wasmtime, so if you have any problems, please don't hesitate to file an issue !","breadcrumbs":"Further Examples » Profiling WebAssembly » Profiling with samply » Profiling with perfmap","id":"126","title":"Profiling with perfmap"},"127":{"body":"The guest profiling strategy enables in-process sampling and will write the captured profile to a file which can be viewed at https://profiler.firefox.com/ . To use this profiler with the Wasmtime CLI, pass the --profile=guest[,path[,interval]] flag. path is where to write the profile, wasmtime-guest-profile.json by default interval is the duration between samples, 10ms by default When used with -W timeout=N, the timeout will be rounded up to the nearest multiple of the profiling interval.","breadcrumbs":"Further Examples » Profiling WebAssembly » Cross-platform Profiling » Using Wasmtime's cross-platform profiler","id":"127","title":"Using Wasmtime's cross-platform profiler"},"128":{"body":"wmemcheck provides the ability to check for invalid mallocs, reads, and writes inside a Wasm module, as long as Wasmtime is able to make certain assumptions (malloc and free functions are visible and your program uses only the default allocator). This is analogous to the Valgrind tool's memory checker (memcheck) tool for native programs. How to use: When building Wasmtime, add the CLI flag \"--features wmemcheck\" to compile with wmemcheck configured. cargo build --features wmemcheck When running your wasm module, add the CLI flag \"-W wmemcheck\". wasmtime run -W wmemcheck test.wasm If your program executes an invalid operation (load or store to non-allocated address, double-free, or an internal error in malloc that allocates the same memory twice) you will see an error that looks like a Wasm trap. For example, given the program #include <stdlib.h> int main() { char* p = malloc(1024); *p = 0; free(p); *p = 0;\n} compiled with WASI-SDK via $ /opt/wasi-sdk/bin/clang -o test.wasm test.c you can observe the memory checker working like so: $ wasmtime run -W wmemcheck ./test.wasm\nError: failed to run main module `./test.wasm` Caused by: 0: failed to invoke command default 1: error while executing at wasm backtrace: 0: 0x103 - <unknown>!__original_main 1: 0x87 - <unknown>!_start 2: 0x2449 - <unknown>!_start.command_export 2: Invalid store at addr 0x10610 of size 1","breadcrumbs":"Further Examples » Checking Guests' Memory Accesses » Wasm memcheck (wmemcheck)","id":"128","title":"Wasm memcheck (wmemcheck)"},"129":{"body":"Wasmtime embeddings may wish to optimize for binary size and runtime footprint to fit on a small system. This documentation is intended to guide some features of Wasmtime and how to best produce a minimal build of Wasmtime.","breadcrumbs":"Further Examples » Building a minimal embedding » Building a Minimal Wasmtime embedding","id":"129","title":"Building a Minimal Wasmtime embedding"},"13":{"body":"Wasmtime's libraries use Rust's log crate to log diagnostic information, and the wasmtime CLI executable uses tracing-subscriber for displaying this information on the console. Basic logging is controlled by the WASMTIME_LOG environment variable. For example, To enable logging of WASI system calls, similar to the strace command on Linux, set WASMTIME_LOG=wasmtime_wasi=trace. For more information on specifying filters, see tracing-subscriber's EnvFilter docs . $ WASMTIME_LOG=wasmtime_wasi=trace wasmtime hello.wasm\n[...]\nTRACE wiggle abi{module=\"wasi_snapshot_preview1\" function=\"fd_write\"} wasmtime_wasi::preview1::wasi_snapshot_preview1 > fd=Fd(1) iovs=*guest 0x14/1\nHello, world!\nTRACE wiggle abi{module=\"wasi_snapshot_preview1\" function=\"fd_write\"}: wasmtime_wasi::preview1::wasi_snapshot_preview1: result=Ok(14)\nTRACE wiggle abi{module=\"wasi_snapshot_preview1\" function=\"proc_exit\"}: wasmtime_wasi::preview1::wasi_snapshot_preview1: rval=1\nTRACE wiggle abi{module=\"wasi_snapshot_preview1\" function=\"proc_exit\"}: wasmtime_wasi::preview1::wasi_snapshot_preview1: result=Exited with i32 exit status 1 Wasmtime can also redirect the log messages into log files, with the -D log-to-files option. It creates one file per thread within Wasmtime, with the files named wasmtime.dbg.*.","breadcrumbs":"Using the Wasmtime CLI » CLI Logging » Logging in the wasmtime CLI","id":"13","title":"Logging in the wasmtime CLI"},"130":{"body":"Note : the exact numbers in this section were last updated on 2023-10-18 on a macOS aarch64 host. For up-to-date numbers consult the artifacts in the dev release of Wasmtime where the wasmtime-min executable represents the culmination of these steps. Many Wasmtime embeddings go through the wasmtime crate as opposed to the wasmtime CLI executable, but to start out let's take a look at minimizing the command line executable. By default the wasmtime command line executable is relatively large: $ cargo build\n$ ls -l ./target/debug/wasmtime\n-rwxr-xr-x@ 1 root root 140M Oct 18 08:33 target/debug/wasmtime The easiest size optimization is to compile with optimizations. This will strip lots of dead code and additionally generate much less debug information by default $ cargo build --release\n$ ls -l ./target/release/wasmtime\n-rwxr-xr-x@ 1 root root 33M Oct 18 08:34 target/release/wasmtime Much better, but still relatively large! The next thing that can be done is to disable the default features of the wasmtime-cli crate. This will remove all optional functionality from the crate and strip it down to the bare bones functionality. Note though that run is included to keep the ability to run precompiled WebAssembly files as otherwise the CLI doesn't have any functionality which isn't too useful. $ cargo build --release --no-default-features --features run\n$ ls -l ./target/release/wasmtime\n-rwxr-xr-x@ 1 root root 6.7M Oct 18 08:37 target/release/wasmtime Note that this executable is stripped to the bare minimum of functionality which notably means it does not have a compiler for WebAssembly files. This means that wasmtime compile is no longer supported meaning that *.cwasm files must be fed to wasmtime run to execute files. Additionally error messages will be worse in this mode as less contextual information is provided. The final Wasmtime-specific optimization you can apply is to disable logging statements. Wasmtime and its dependencies make use of the log crate and tracing crate for debugging and diagnosing. For a minimal build this isn't needed though so this can all be disabled through Cargo features to shave off a small amount of code. Note that for custom embeddings you'd need to replicate the disable-logging feature which sets the max_level_off feature for the log and tracing crate. $ cargo build --release --no-default-features --features run,disable-logging\n$ ls -l ./target/release/wasmtime\n-rwxr-xr-x@ 1 root root 6.7M Oct 18 08:37 target/release/wasmtime At this point the next line of tricks to apply to minimize binary size are general tricks-of-the-trade for Rust programs and are no longer specific to Wasmtime. For example the first thing that can be done is to optimize for size rather than speed via rustc's s optimization level. This uses Cargo's environment-variable based configuration via the CARGO_PROFILE_RELEASE_OPT_LEVEL=s environment variable to configure this. $ export CARGO_PROFILE_RELEASE_OPT_LEVEL=s\n$ cargo build --release --no-default-features --features run,disable-logging\n$ ls -l ./target/release/wasmtime\n-rwxr-xr-x@ 1 root root 6.8M Oct 18 08:40 target/release/wasmtime Note that the size has increased here slightly instead of going down. Optimizing for speed-vs-size can affect a number of heuristics in LLVM so it's best to test out locally what's best for your embedding. Further examples below continue to pass this flag since by the end it will produce a smaller binary than the default optimization level of \"3\" for release mode. You may wish to also try an optimization level of \"2\" and see which produces a smaller build for you. After optimizations levels the next compilation setting to configure is Rust's \"panic=abort\" mode where panics translate to process aborts rather than unwinding. This removes landing pads from code as well as unwind tables from the executable. $ export CARGO_PROFILE_RELEASE_OPT_LEVEL=s\n$ export CARGO_PROFILE_RELEASE_PANIC=abort\n$ cargo build --release --no-default-features --features run,disable-logging\n$ ls -l ./target/release/wasmtime\n-rwxr-xr-x@ 1 root root 5.0M Oct 18 08:40 target/release/wasmtime Next, if the compile time hit is acceptable, LTO can be enabled to provide deeper opportunities for compiler optimizations to remove dead code and deduplicate. Do note that this will take a significantly longer amount of time to compile than previously. Here LTO is configured with CARGO_PROFILE_RELEASE_LTO=true. $ export CARGO_PROFILE_RELEASE_OPT_LEVEL=s\n$ export CARGO_PROFILE_RELEASE_PANIC=abort\n$ export CARGO_PROFILE_RELEASE_LTO=true\n$ cargo build --release --no-default-features --features run,disable-logging\n$ ls -l ./target/release/wasmtime\n-rwxr-xr-x@ 1 root root 3.3M Oct 18 08:42 target/release/wasmtime Similar to LTO above rustc can be further instructed to place all crates into their own single object file instead of multiple by default. This again increases compile times. Here that's done with CARGO_PROFILE_RELEASE_CODEGEN_UNITS=1. $ export CARGO_PROFILE_RELEASE_OPT_LEVEL=s\n$ export CARGO_PROFILE_RELEASE_PANIC=abort\n$ export CARGO_PROFILE_RELEASE_LTO=true\n$ export CARGO_PROFILE_RELEASE_CODEGEN_UNITS=1\n$ cargo build --release --no-default-features --features run,disable-logging\n$ ls -l ./target/release/wasmtime\n-rwxr-xr-x@ 1 root root 3.3M Oct 18 08:43 target/release/wasmtime Note that with LTO using a single codegen unit may only have marginal benefit. If not using LTO, however, a single codegen unit will likely provide benefit over the default 16 codegen units. One final flag before getting to nightly features is to strip debug information from the standard library. In --release mode Cargo by default doesn't generate debug information for local crates, but the Rust standard library may have debug information still included with it. This is configured via CARGO_PROFILE_RELEASE_STRIP=debuginfo $ export CARGO_PROFILE_RELEASE_OPT_LEVEL=s\n$ export CARGO_PROFILE_RELEASE_PANIC=abort\n$ export CARGO_PROFILE_RELEASE_LTO=true\n$ export CARGO_PROFILE_RELEASE_CODEGEN_UNITS=1\n$ export CARGO_PROFILE_RELEASE_STRIP=debuginfo\n$ cargo build --release --no-default-features --features run,disable-logging\n$ ls -l ./target/release/wasmtime\n-rwxr-xr-x@ 1 root root 2.4M Oct 18 08:44 target/release/wasmtime Next, if your use case allows it, the Nightly Rust toolchain provides a number of other options to minimize the size of binaries. Note the usage of +nightly here to the cargo command to use a Nightly toolchain (assuming your local toolchain is installed with rustup). Also note that due to the nature of nightly the exact flags here may not work in the future. Please open an issue with Wasmtime if these commands don't work and we'll update the documentation. The first nightly feature we can leverage is to remove filename and line number information in panics with -Zlocation-detail=none $ export CARGO_PROFILE_RELEASE_OPT_LEVEL=s\n$ export CARGO_PROFILE_RELEASE_PANIC=abort\n$ export CARGO_PROFILE_RELEASE_LTO=true\n$ export CARGO_PROFILE_RELEASE_CODEGEN_UNITS=1\n$ export CARGO_PROFILE_RELEASE_STRIP=debuginfo\n$ export RUSTFLAGS=\"-Zlocation-detail=none\"\n$ cargo +nightly build --release --no-default-features --features run,disable-logging\n$ ls -l ./target/release/wasmtime\n-rwxr-xr-x@ 1 root root 2.4M Oct 18 08:43 target/release/wasmtime Further along the line of nightly features the next optimization will recompile the standard library without unwinding information, trimming out a bit more from the standard library. This uses the -Zbuild-std flag to Cargo. Note that this additionally requires --target as well which will need to be configured for your particular platform. $ export CARGO_PROFILE_RELEASE_OPT_LEVEL=s\n$ export CARGO_PROFILE_RELEASE_PANIC=abort\n$ export CARGO_PROFILE_RELEASE_LTO=true\n$ export CARGO_PROFILE_RELEASE_CODEGEN_UNITS=1\n$ export CARGO_PROFILE_RELEASE_STRIP=debuginfo\n$ export RUSTFLAGS=\"-Zlocation-detail=none\"\n$ cargo +nightly build --release --no-default-features --features run,disable-logging \\ -Z build-std=std,panic_abort --target aarch64-apple-darwin\n$ ls -l ./target/aarch64-apple-darwin/release/wasmtime\n-rwxr-xr-x@ 1 root root 2.3M Oct 18 09:39 target/aarch64-apple-darwin/release/wasmtime Next the Rust standard library has some optional features in addition to Wasmtime, such as printing of backtraces. This may not be required in minimal environments so the features of the standard library can be disabled with the -Zbuild-std-features= flag which configures the set of enabled features to be empty. $ export CARGO_PROFILE_RELEASE_OPT_LEVEL=s\n$ export CARGO_PROFILE_RELEASE_PANIC=abort\n$ export CARGO_PROFILE_RELEASE_LTO=true\n$ export CARGO_PROFILE_RELEASE_CODEGEN_UNITS=1\n$ export CARGO_PROFILE_RELEASE_STRIP=debuginfo\n$ export RUSTFLAGS=\"-Zlocation-detail=none\"\n$ cargo +nightly build --release --no-default-features --features run,disable-logging \\ -Z build-std=std,panic_abort --target aarch64-apple-darwin \\ -Z build-std-features=\n$ ls -l ./target/aarch64-apple-darwin/release/wasmtime\n-rwxr-xr-x@ 1 root root 2.1M Oct 18 09:39 target/aarch64-apple-darwin/release/wasmtime","breadcrumbs":"Further Examples » Building a minimal embedding » Building a minimal CLI","id":"130","title":"Building a minimal CLI"},"131":{"body":"Above shows an example of taking the default cargo build result of 130M down to a 2.1M binary for the wasmtime executable. Similar steps can be done to reduce the size of the C API binary artifact as well which currently produces a ~2.8M dynamic library. This is currently the smallest size with the source code as-is, but there are more size reductions which haven't been implemented yet. This is a listing of some example sources of binary size. Some sources of binary size may not apply to custom embeddings since, for example, your custom embedding might already not use WASI and might already not be included. WASI in the Wasmtime CLI - currently the CLI includes all of WASI. This includes two separate implementations of WASI - one for preview2 and one for preview1. This accounts for 1M+ of space which is a significant chunk of the remaining 2.1M. While removing just preview2 or preview1 would be easy enough with a Cargo feature, the resulting executable wouldn't be able to do anything. Something like a plugin feature for the CLI , however, would enable removing WASI while still being a usable executable. Argument parsing in the Wasmtime CLI - as a command line executable wasmtime contains parsing of command line arguments which currently uses the clap crate. This contributes ~200k of binary size to the final executable which would likely not be present in a custom embedding of Wasmtime. While this can't be removed from Wasmtime it's something to consider when evaluating the size of CI artifacts. Cranelift in the C API - one of the features of Wasmtime is the ability to have a runtime without Cranelift that only supports precompiled (AOT) wasm modules. It's not possible to build the C API without Cranelift though because defining host functions requires Cranelift at this time to emit some stubs. This means that the C API is significantly larger than a custom Rust embedding which doesn't suffer from the same restriction. This means that while it's still possible to build an embedding of Wasmtime which doesn't have Cranelift it's not easy to see what it might look like size-wise from looking at the C API artifacts. Formatting strings in Wasmtime - Wasmtime makes extensive use of formatting strings for error messages and other purposes throughout the implementation. Most of this is intended for debugging and understanding more when something goes wrong, but much of this is not necessary for a truly minimal embedding. In theory much of this could be conditionally compiled out of the Wasmtime project to produce a smaller executable. Just how much of the final binary size is accounted for by formatting string is unknown, but it's well known in Rust that std::fmt is not the slimmest of modules. Cranelift vs Winch - the \"min\" builds on CI try to exclude Cranelift from their binary footprint (e.g. the CLI excludes it) but this comes at a cost of the final executable not supporting compilation of wasm modules. If this is required then no effort has yet been put into minimizing the code size of Cranelift itself. One possible tradeoff that can be made though is to choose between the Winch baseline compiler vs Cranelift. Winch should be much smaller from a compiled footprint point of view while not sacrificing everything in terms of performance. Note though that Winch is still under development. Above are some future avenues to take in terms of reducing the binary size of Wasmtime and various tradeoffs that can be made. The Wasmtime project is eager to hear embedder use cases/profiles if Wasmtime is not suitable for binary size reasons today. Please feel free to open an issue and let us know and we'd be happy to discuss more how best to handle a particular use case.","breadcrumbs":"Further Examples » Building a minimal embedding » Minimizing further","id":"131","title":"Minimizing further"},"132":{"body":"If you're not running on a built-in supported platform such as Windows, macOS, or Linux, then Wasmtime won't work out-of-the-box for you. Wasmtime includes a compilation mode, however, that enables you to define how to work with the platform externally. This mode is enabled when --cfg wasmtime_custom_platform is passed to rustc, via RUSTFLAGS for example when building through Cargo, when an existing platform is not matched. This means that with this configuration Wasmtime may be compiled for custom or previously unknown targets. Wasmtime's current \"platform embedding API\" which is required to operate is defined at examples/min-platform/embedding/wasmtime-platform.h. That directory additionally has an example of building a minimal *.so on Linux which has the platform API implemented in C using Linux syscalls. While a bit contrived it effectively shows a minimal Wasmtime embedding which has no dependencies other than the platform API. Building Wasmtime for a custom platform is not a turnkey process right now, there are a number of points that need to be considered: For a truly custom platform you'll probably want to create a custom Rust target . This means that Nightly Rust will be required. Wasmtime and its dependencies require the Rust standard library std to be available. The Rust standard library can be compiled for any target with unsupported functionality being stubbed out. This mode of compiling the Rust standard library is not stable, however. Currently this is done through the -Zbuild-std argument to Cargo along with a +RUSTC_BOOTSTRAP_SYNTHETIC_TARGET=1 environment variable. Wasmtime additionally depends on the availability of a memory allocator (e.g. malloc). Wasmtime assumes that failed memory allocation aborts the process. Not all features for Wasmtime can be built for custom targets. For example WASI support does not work on custom targets. When building Wasmtime you'll probably want --no-default-features and will then want to incrementally add features back in as needed. The examples/min-platform directory has an example of building this minimal embedding and some necessary steps. Combined with the above features about producing a minimal build currently produces a 400K library on Linux.","breadcrumbs":"Further Examples » Building a minimal embedding » Building Wasmtime for a Custom Platform","id":"132","title":"Building Wasmtime for a Custom Platform"},"133":{"body":"... more coming soon","breadcrumbs":"Stability » Stability","id":"133","title":"Stability"},"134":{"body":"Wasmtime's release process was originally designed in an RFC and this page is intended to serve as documentation for the current process as-is today. The high-level summary of Wasmtime's release process is: A new major version of Wasmtime will be made available once a month. Security bugs and correctness fixes will be backported to the latest two releases of Wasmtime and issued as patch releases. Once a month Wasmtime will issue a new major version. This will be issued with a semver-major version update, such as 4.0.0 to 5.0.0. The precise schedule of Wasmtime's release is currently an automated PR is sent to bump the version on the 5th of every month and a release is made when the PR is merged. The PR typically gets merged within a few days. Each major release of Wasmtime reserves the right to break both behavior and API backwards-compatibility. This is not expected to happen frequently, however, and any breaking change will follow these criteria: Minor breaking changes, either behavior or with APIs, will be documented in the RELEASES.md release notes. Minor changes will require some degree of consensus but are not required to go through the entire RFC process. Major breaking changes, such as major refactorings to the API, will be required to go through the RFC process . These changes are intended to be broadly communicated to those interested and provides an opportunity to give feedback about embeddings. Release notes will clearly indicate if any major breaking changes through accepted RFCs are included in a release. Patch releases of Wasmtime will only be issued for security and critical correctness issues for on-by-default behavior in the previous releases. If Wasmtime is currently at version 5.0.0 then 5.0.1 and 4.0.1 will be issued as patch releases if a bug is found. Patch releases are guaranteed to maintain API and behavior backwards-compatibility and are intended to be trivial for users to upgrade to. Patch releases for Cranelift will be made for any miscompilations found by Cranelift, even those that Wasmtime itself may not exercise. Due to the current release process a patch release for Cranelift will issue a patch release for Wasmtime as well.","breadcrumbs":"Stability » Release Process » Release Process","id":"134","title":"Release Process"},"135":{"body":"At this time the release process of Wasmtime encompasses: The wasmtime Rust crate The C API of Wasmtime The wasmtime CLI tool through the wasmtime-cli Rust crate Other projects maintained by the Bytecode Alliance will also likely be released, with the same version numbers, with the main Wasmtime project soon after a release is made, such as: wasmtime-dotnet wasmtime-py wasmtime-go wasmtime-cpp wasmtime-rb Note, though, that bugs and security issues in these projects do not at this time warrant patch releases for Wasmtime.","breadcrumbs":"Stability » Release Process » What's released?","id":"135","title":"What's released?"},"136":{"body":"Wasmtime's support for platforms and features can be distinguished with three different tiers of support. The description of these tiers are intended to be inspired by the Rust compiler's support tiers for targets but are additionally tailored for Wasmtime. Wasmtime's tiered support additionally applies not only to platforms/targets themselves but additionally features implemented within Wasmtime itself. The purpose of this document is to provide a means by which to evaluate the inclusion of new features and support for existing features within Wasmtime. This should not be used to \"lawyer\" a change into Wasmtime on a precise technical detail or similar since this document is itself not 100% precise and will change over time.","breadcrumbs":"Stability » Tiers of support » Tiers of Support in Wasmtime","id":"136","title":"Tiers of Support in Wasmtime"},"137":{"body":"For explanations of what each tier means see below. Tier 1 Category Description Target x86_64-apple-darwin Target x86_64-pc-windows-msvc Target x86_64-unknown-linux-gnu Compiler Backend Cranelift WebAssembly Proposal mutable-globals WebAssembly Proposal sign-extension-ops WebAssembly Proposal nontrapping-float-to-int-conversion WebAssembly Proposal multi-value WebAssembly Proposal bulk-memory WebAssembly Proposal reference-types WebAssembly Proposal simd WebAssembly Proposal component-model WebAssembly Proposal relaxed-simd WebAssembly Proposal multi-memory WebAssembly Proposal threads WebAssembly Proposal tail-call WASI Proposal wasi-io WASI Proposal wasi-clocks WASI Proposal wasi-filesystem WASI Proposal wasi-random WASI Proposal wasi-sockets WASI Proposal wasi-http WASI Proposal wasi_snapshot_preview1 WASI Proposal wasi_unstable Tier 2 Category Description Missing Tier 1 Requirements Target aarch64-unknown-linux-gnu Continuous fuzzing Target aarch64-apple-darwin Continuous fuzzing Target s390x-unknown-linux-gnu Continuous fuzzing Target x86_64-pc-windows-gnu Clear owner of the target Target Support for #![no_std] Support beyond CI checks WebAssembly Proposal memory64 Unstable wasm proposal WebAssembly Proposal function-references Unstable wasm proposal Tier 3 Category Description Missing Tier 2 Requirements Target aarch64-pc-windows-msvc CI testing, unwinding, full-time maintainer Target riscv64gc-unknown-linux-gnu full-time maintainer Target wasm32-wasip1 [1] Supported but not tested Target aarch64-linux-android CI testing, full-time maintainer Target x86_64-linux-android CI testing, full-time maintainer Target x86_64-unknown-linux-musl [2] CI testing, full-time maintainer Compiler Backend Winch on x86_64 WebAssembly proposals (simd, relaxed-simd, tail-call, reference-types, threads) Compiler Backend Winch on aarch64 Complete implementation WebAssembly Proposal gc Complete implementation WASI Proposal wasi-nn More expansive CI testing WASI Proposal wasi-threads More CI, unstable proposal WASI Proposal wasi-runtime-config unstable proposal WASI Proposal wasi-keyvalue unstable proposal misc Non-Wasmtime Cranelift usage [3] CI testing, full-time maintainer misc DWARF debugging [4] CI testing, full-time maintainer, improved quality This is intended to encompass features that Cranelift supports as a general-purpose code generator such as integer value types other than i32 and i64, non-Wasmtime calling conventions, code model settings, relocation restrictions, etc. These features aren't covered by Wasmtime's usage of Cranelift because the WebAssembly instruction set doesn't leverage them. This means that they receive far less testing and fuzzing than the parts of Cranelift exercised by Wasmtime. Currently there is no active maintainer of DWARF debugging support and support is currently best-effort. Additionally there are known shortcomings and bugs. At this time there's no developer time to improve the situation here as well. Wasmtime's cranelift and winch features can be compiled to WebAssembly but not the runtime feature at this time. This means that Wasmtime-compiled-to-wasm can itself compile wasm but cannot execute wasm. Binary artifacts for MUSL are dynamically linked, not statically linked, meaning that they are not suitable for \"run on any linux distribution\" style use cases. Wasmtime does not have static binary artifacts at this time and that will require building from source. Unsupported features and platforms While this is not an exhaustive list, Wasmtime does not currently have support for the following features. Note that this is intended to document Wasmtime's current state and does not mean Wasmtime does not want to ever support these features; rather design discussion and PRs are welcome for many of the below features to figure out how best to implement them and at least move them to Tier 3 above. Target: ARM 32-bit Target: FreeBSD Target: NetBSD/OpenBSD Target: i686 (32-bit Intel targets) Target: Android Target: MIPS Target: SPARC Target: PowerPC Target: RISC-V 32-bit WebAssembly proposal: branch-hinting WebAssembly proposal: exception-handling WebAssembly proposal: extended-const WebAssembly proposal: flexible-vectors WebAssembly proposal: memory-control WebAssembly proposal: stack-switching WASI proposal: proxy-wasm WASI proposal: wasi-blob-store WASI proposal: wasi-crypto WASI proposal: wasi-data WASI proposal: wasi-distributed-lock-service WASI proposal: wasi-grpc WASI proposal: wasi-message-queue WASI proposal: wasi-parallel WASI proposal: wasi-pubsub WASI proposal: wasi-sql WASI proposal: wasi-url","breadcrumbs":"Stability » Tiers of support » Current Tier Status","id":"137","title":"Current Tier Status"},"138":{"body":"Wasmtime's precise definitions of tiers are not guaranteed to be constant over time, so these descriptions are likely to change over time. Tier 1 is classified as the highest level of support, confidence, and correctness for a component. Each tier additionally encompasses all the guarantees of previous tiers. Features classified under a particular tier may already meet the criteria for later tiers as well. In situations like this it's not intended to use these guidelines to justify removal of a feature at any one point in time. Guidance is provided here for phasing out unmaintained features but it should be clear under what circumstances work \"can be avoided\" for each tier. Tier 3 - Not Production Ready The general idea behind Tier 3 is that this is the baseline for inclusion of code into the Wasmtime project. This is not intended to be a catch-all \"if a patch is sent it will be merged\" tier. Instead the goal of this tier is to outline what is expected of contributors adding new features to Wasmtime which might be experimental at the time of addition. This is intentionally not a relaxed tier of restrictions but already implies a significant commitment of effort to a feature being included within Wasmtime. Tier 3 features include: Inclusion of a feature does not impose unnecessary maintenance overhead on other components/features. Some examples of additions to Wasmtime which would not be accepted are: An experimental feature doubles the time of CI for all PRs. A change which makes it significantly more difficult to architecturally change Wasmtime's internal implementation. A change which makes building Wasmtime more difficult for unrelated developers. In general Tier 3 features are off-by-default at compile time but still tested-by-default on CI. New features of Wasmtime cannot have major known bugs at the time of inclusion. Landing a feature in Wasmtime requires the feature to be correct and bug-free as best can be evaluated at the time of inclusion. Inevitably bugs will be found and that's ok, but anything identified during review must be addressed. Code included into the Wasmtime project must be of an acceptable level of quality relative to the rest of the code in Wasmtime. There must be a path to a feature being finished at the time of inclusion. Adding a new backend to Cranelift for example is a significant undertaking which may not be able to be done in a single PR. Partial implementations of a feature are acceptable so long as there's a clear path forward and schedule for completing the feature. New components in Wasmtime must have a clearly identified owner who is willing to be \"on the hook\" for review, updates to the internals of Wasmtime, etc. For example a new backend in Cranelift would need to have a maintainer who is willing to respond to changes in Cranelift's interfaces and the needs of Wasmtime. This baseline level of support notably does not require any degree of testing, fuzzing, or verification. As a result components classified as Tier 3 are generally not production-ready as they have not been battle-tested much. Features classified as Tier 3 may be disabled in CI or removed from the repository as well. If a Tier 3 feature is preventing development of other features then the owner will be notified. If no response is heard from within a week then the feature will be disabled in CI. If no further response happens for a month then the feature may be removed from the repository. Tier 2 - Almost Production Ready This tier is meant to encompass features and components of Wasmtime which are well-maintained, tested well, but don't necessarily meet the stringent criteria for Tier 1. Features in this category may already be \"production ready\" and safe to use. Tier 2 features include: Tests are run in CI for the Wasmtime project for this feature and everything passes. For example a Tier 2 platform runs in CI directly or via emulation. Features are otherwise fully tested on CI. Complete implementations for anything that's part of Tier 1. For example all Tier 2 targets must implement all of the Tier 1 WebAssembly proposals, and all Tier 2 features must be implemented on all Tier 1 targets. All existing developers are expected to handle minor changes which affect Tier 2 components. For example if Cranelift's interfaces change then the developer changing the interface is expected to handle the changes for Tier 2 architectures so long as the affected part is relatively minor. Note that if a more substantial change is required to a Tier 2 component then that falls under the next bullet. Maintainers of a Tier 2 feature are responsive (reply to requests within a week) and are available to accommodate architectural changes that affect their component. For example more expansive work beyond the previous bullet where contributors can't easily handle changes are expected to be guided or otherwise implemented by Tier 2 maintainers. Major changes otherwise requiring an RFC that affect Tier 2 components are required to consult Tier 2 maintainers in the course of the RFC. Major changes to Tier 2 components themselves do not require an RFC, however. Features at this tier generally are not turned off or disabled for very long. Maintainers are already required to be responsive to changes and will be notified of any unrelated change which affects their component. It's recommended that if a component breaks for one reason or another due to an unrelated change that the maintainer either contributes to the PR-in-progress or otherwise has a schedule for the implementation of the feature. Tier 1 - Production Ready This tier is intended to be the highest level of support in Wasmtime for any particular feature, indicating that it is suitable for production environments. This conveys a high level of confidence in the Wasmtime project about the specified features. Tier 1 features include: Continuous fuzzing is required for WebAssembly proposals. This means that any WebAssembly proposal must have support in the wasm-smith crate and existing fuzz targets must be running and exercising the new code paths. Where possible differential fuzzing should also be implemented to compare results with other implementations. Continuous fuzzing is required for the architecture of supported targets. For example currently there are three x86_64 targets that are considered Tier 1 but only x86_64-unknown-linux-gnu is fuzzed. CVEs and security releases will be performed as necessary for any bugs found in features and targets. Major changes affecting this component may require help from maintainers with specialized expertise, but otherwise it should be reasonable to expect most Wasmtime developers to be able to maintain Tier 1 features. Major changes affecting Tier 1 features require an RFC and prior agreement on the change before an implementation is committed. A major inclusion point for this tier is intended to be the continuous fuzzing of Wasmtime. This implies a significant commitment of resources for fixing issues, hardware to execute Wasmtime, etc. Additionally this tier comes with the broadest expectation of \"burden on everyone else\" in terms of what changes everyone is generally expected to handle. Features classified as Tier 1 are rarely, if ever, turned off or removed from Wasmtime.","breadcrumbs":"Stability » Tiers of support » Tier Details","id":"138","title":"Tier Details"},"139":{"body":"This page is intended to give a high-level overview of Wasmtime's platform support along with some aspirations of Wasmtime. For more details see the documentation on tiers of stability which has specific information about what's supported in Wasmtime on a per-matrix-combination basis. Wasmtime strives to support hardware that anyone wants to run WebAssembly on. Maintainers of Wasmtime support a number of \"major\" platforms themselves but porting work may be required to support platforms that maintainers are not themselves familiar with. Out-of-the box Wasmtime supports: Linux x86_64, aarch64, s390x, and riscv64 macOS x86_64, aarch64 Windows x86_64 Other platforms such as Android, iOS, and the BSD family of OSes are not built-in yet. PRs for porting are welcome and maintainers are happy to add more entries to the CI matrix for these platforms.","breadcrumbs":"Stability » Platform Support » Platform Support","id":"139","title":"Platform Support"},"14":{"body":"The configuration file uses the toml format. You can create a configuration file at the default location with: $ wasmtime config new It will print the location regardless of the success. Please refer to the --help message for using a custom location. All settings, except enabled, are optional . If the setting is not specified, the default value is used. Thus, if you don't know what values to use, don't specify them. The default values might be tuned in the future. Wasmtime assumes all the options are in the cache section. Example config: [cache]\nenabled = true\ndirectory = \"/nfs-share/wasmtime-cache/\"\ncleanup-interval = \"30m\"\nfiles-total-size-soft-limit = \"1Gi\" Please refer to the cache system section to learn how it works. If you think some default value should be tuned, some new settings should be introduced or some behavior should be changed, you are welcome to discuss it and contribute to the Wasmtime repository .","breadcrumbs":"Using the Wasmtime CLI » Cache Configuration » Cache Configuration of wasmtime","id":"14","title":"Cache Configuration of wasmtime"},"140":{"body":"Cranelift supports x86_64, aarch64, s390x, and riscv64. No 32-bit platform is currently supported. Building a new backend for Cranelift is a relatively large undertaking which maintainers are willing to help with but it's recommended to reach out to Cranelift maintainers first to discuss this. Winch supports x86_64. The aarch64 backend is in development. Winch is built on Cranelift's support for emitting instructions so Winch's possible backend list is currently limited to what Cranelift supports. Usage of the Cranelift or Winch requires a host operating system which supports creating executable memory pages on-the-fly. Support for statically linking in a single precompiled module is not supported at this time. Both Cranelift and Winch can be used either in AOT or JIT mode. In AOT mode one process precompiles a module/component and then loads it into another process. In JIT mode this is all done within the same process. Neither Cranelift nor Winch support tiering at this time in the sense of having a WebAssembly module start from a Winch compilation and automatically switch to a Cranelift compilation. Modules are either entirely compiled with Winch or Cranelift.","breadcrumbs":"Stability » Platform Support » Compiler Support","id":"140","title":"Compiler Support"},"141":{"body":"At this time wasmtime does not have a mode in which it simply interprets WebAssembly code. It is desired to add support for an interpreter, however, and this will have minimal system dependencies. It is planned that the system will need to support some form of dynamic memory allocation, but other than that not much else will be needed.","breadcrumbs":"Stability » Platform Support » Interpreter support","id":"141","title":"Interpreter support"},"142":{"body":"The wasmtime crate supports being build on no_std platforms in Rust, but only for a subset of its compile-time Cargo features. Currently supported Cargo features are: runtime gc component-model This notably does not include the default feature which means that when depending on Wasmtime you'll need to specify default-features = false. This also notably does not include Cranelift or Winch at this time meaning that no_std platforms must be used in AOT mode where the module is precompiled elsewhere. Wasmtime's support for no_std requires the embedder to implement the equivalent of a C header file to indicate how to perform basic OS operations such as allocating virtual memory. This API can be found as wasmtime-platform.h in Wasmtime's release artifacts or at examples/min-platform/embedding/wasmtime-platform.h in the source tree. Note that this API is not guaranteed to be stable at this time, it'll need to be updated when Wasmtime is updated. Wasmtime's runtime will use the symbols defined in this file meaning that if they're not defined then a link-time error will be generated. Embedders are required to implement these functions in accordance with their documentation to enable Wasmtime to run on custom platforms.","breadcrumbs":"Stability » Platform Support » Support for #![no_std]","id":"142","title":"Support for #![no_std]"},"143":{"body":"One of WebAssembly (and Wasmtime's) main goals is to execute untrusted code in a safe manner inside of a sandbox. WebAssembly is inherently sandboxed by design (must import all functionality, etc). This document is intended to cover the various sandboxing implementation strategies that Wasmtime has as they are developed. This has also been documented in a historical blog post too. At this time Wasmtime implements what's necessary for the WebAssembly specification, for example memory isolation between instances. Additionally the safe Rust API is intended to mitigate accidental bugs in hosts. Different sandboxing implementation techniques will also come with different tradeoffs in terms of performance and feature limitations, and Wasmtime plans to offer users choices of which tradeoffs they want to make.","breadcrumbs":"Security » Security","id":"143","title":"Security"},"144":{"body":"The core WebAssembly spec has several features which create a unique sandboxed environment: The callstack is inaccessible. Unlike most native execution environments, return addresses from calls and spilled registers are not stored in memory accessible to applications. They are stored in memory that only the implementation has access to, which makes traditional stack-smashing attacks targeting return addresses impossible. Pointers, in source languages which have them, are compiled to offsets into linear memory, so implementations details such as virtual addresses are hidden from applications. And all accesses within linear memory are checked to ensure they stay in bounds. All control transfers—direct and indirect branches, as well as direct and indirect calls—are to known and type-checked destinations, so it's not possible to accidentally call into the middle of a function or branch outside of a function. All interaction with the outside world is done through imports and exports. There is no raw access to system calls or other forms of I/O; the only thing a WebAssembly instance can do is what is available through interfaces it has been explicitly linked with. There is no undefined behavior. Even where the WebAssembly spec permits multiple possible behaviors, it doesn't permit arbitrary behavior.","breadcrumbs":"Security » WebAssembly Core","id":"144","title":"WebAssembly Core"},"145":{"body":"While WebAssembly is designed to be sandboxed bugs or issues inevitably arise so Wasmtime also implements a number of mitigations which are not required for correct execution of WebAssembly but can help mitigate issues if bugs are found: Linear memories by default are preceded with a 2GB guard region. WebAssembly has no means of ever accessing this memory but this can protect against accidental sign-extension bugs in Cranelift where if an offset is accidentally interpreted as a signed 32-bit offset instead of an unsigned offset it could access memory before the addressable memory for WebAssembly. Wasmtime uses explicit checks to determine if a WebAssembly function should be considered to stack overflow, but it still uses guard pages on all native thread stacks. These guard pages are never intended to be hit and will abort the program if they're hit. Hitting a guard page within WebAssembly indicates a bug in host configuration or a bug in Cranelift itself. Where it can Wasmtime will zero memory used by a WebAssembly instance after it's finished. This is not necessary unless the memory is actually reused for instantiation elsewhere but this is done to prevent accidental leakage of information between instances in the face of other bugs. This applies to linear memories, tables, and the memory used to store instance information itself. The choice of implementation language, Rust, for Wasmtime is also a defense in protecting the authors for Wasmtime from themselves in addition to protecting embedders from themselves. Rust helps catch mistakes when writing Wasmtime itself at compile time. Rust additionally enables Wasmtime developers to create an API that means that embedders can't get it wrong. For example it's guaranteed that Wasmtime won't segfault when using its public API, empowering embedders with confidence that even if the embedding has bugs all of the security guarantees of WebAssembly are still upheld. Wasmtime is in the process of implementing control-flow-integrity mechanisms to leverage hardware state for further guaranteeing that WebAssembly stays within its sandbox. In the event of a bug in Cranelift this can help mitigate the impact of where control flow can go to.","breadcrumbs":"Security » Defense-in-depth","id":"145","title":"Defense-in-depth"},"146":{"body":"Wasmtime implements the WASI APIs for filesystem access, which follow a capability-based security model, which ensures that applications can only access files and directories they've been given access to. WASI's security model keeps users safe today, and also helps us prepare for shared-nothing linking and nanoprocesses in the future. Wasmtime developers are intimately engaged with the WASI standards process, libraries, and tooling development, all along the way too.","breadcrumbs":"Security » Filesystem Access","id":"146","title":"Filesystem Access"},"147":{"body":"If untrusted code is allowed to print text which is displayed to a terminal, it may emit ANSI-style escape sequences and other control sequences which, depending on the terminal the user is using and how it is configured, can have side effects including writing to files, executing commands, injecting text into the stream as if the user had typed it, or reading the output of previous commands. ANSI-style escape sequences can also confuse or mislead users, making other vulnerabilities easier to exploit. Our first priority is to protect users, so Wasmtime now filters writes to output streams when they are connected to a terminal to translate escape sequences into inert replacement sequences. Some applications need ANSI-style escape sequences, such as terminal-based editors and programs that use colors, so we are also developing a proposal for the WASI Subgroup for safe and portable ANSI-style escape sequence support, which we hope to post more about soon.","breadcrumbs":"Security » Terminal Output","id":"147","title":"Terminal Output"},"148":{"body":"Wasmtime implements a few forms of basic spectre mitigations at this time: Bounds checks when accessing entries in a function table (e.g. the call_indirect instruction) are mitigated. The br_table instruction is mitigated to ensure that speculation goes to a deterministic location. Wasmtime's default configuration for linear memory means that bounds checks will not be present for memory accesses due to the reliance on page faults to instead detect out-of-bounds accesses. When Wasmtime is configured with \"dynamic\" memories, however, Cranelift will insert spectre mitigation for the bounds checks performed for all memory accesses. Mitigating Spectre continues to be a subject of ongoing research, and Wasmtime will likely grow more mitigations in the future as well.","breadcrumbs":"Security » Spectre","id":"148","title":"Spectre"},"149":{"body":"The disclosure policy for security issues in Wasmtime is documented on the Bytecode Alliance website .","breadcrumbs":"Security » Disclosure Policy » Disclosure Policy","id":"149","title":"Disclosure Policy"},"15":{"body":"type : boolean format : true | false default : true Specifies whether the cache system is used or not. This field is mandatory . The default value is used when configuration file is not specified and none exists at the default location.","breadcrumbs":"Using the Wasmtime CLI » Cache Configuration » Setting enabled","id":"15","title":"Setting enabled"},"150":{"body":"If you are still unsure whether an issue you are filing is a security vulnerability or not after reading this page, always err on the side of caution and report it as a security vulnerability! Bugs must affect a tier 1 platform or feature to be considered a security vulnerability. The security of the host and integrity of the sandbox when executing Wasm is paramount. Anything that undermines the Wasm execution sandbox is a security vulnerability. On the other hand, execution that diverges from Wasm semantics (such as computing incorrect values) are not considered security vulnerabilities so long as they remain confined within the sandbox. This has a couple repercussions that are worth highlighting: Even though it is safe from the host's point of view, an incorrectly computed value could lead to classic memory unsafety bugs from the Wasm guest's point of view, such as corruption of its malloc's free list or reading past the end of a source-level array. Wasmtime embedders should never blindly trust values from the guest — no matter how trusted the guest program is, even if it was written by the embedders themselves — and should always validate these values before performing unsafe operations on behalf of the guest. Denials of service when executing Wasm (either originating inside compiled Wasm code or Wasmtime's runtime subroutines) are considered security vulnerabilities. For example, if you configure Wasmtime to run Wasm guests with the async fuel mechanism, and then executing the Wasm goes into an infinite loop that never yields, that is considered a security vulnerability. Denials of service when compiling Wasm, however, are not considered security vulnerabilities. For example, an infinite loop during register allocation is not a security vulnerability. Any kind of memory unsafety (e.g. use-after-free bugs, out-of-bounds memory accesses, etc...) in the host is always a security vulnerability.","breadcrumbs":"Security » What is considered a security bug? » What is considered a security vulnerability?","id":"150","title":"What is considered a security vulnerability?"},"151":{"body":"Type of bug At Wasm Compile Time At Wasm Execution Time Sandbox escape - Yes Uncaught out-of-bounds memory access - Yes Uncaught out-of-bounds table access - Yes Failure to uphold Wasm's control-flow integrity - Yes File system access outside of the WASI file system's mapped directories - Yes Use of a WASI resource without having been given the associated WASI capability - Yes Etc... - Yes Divergence from Wasm semantics (without escaping the sandbox) - No Computing incorrect value - No Raising errant trap - No Etc... - No Memory unsafety Yes Yes Use-after-free Yes Yes Out-of-bounds memory access Yes Yes Use of uninitialized memory Yes Yes Etc... Yes Yes Denial of service No Yes Panic No Yes Process abort No Yes Uninterruptible infinite loops No Yes User-controlled memory exhaustion No Yes Uncontrolled recursion over user-supplied input No Yes Etc... No Yes Note that we still want to fix every bug mentioned above even if it is not a security vulnerability! We appreciate when issues are filed for non-vulnerability bugs, particularly when they come with test cases and steps to reproduce!","breadcrumbs":"Security » What is considered a security bug? » Cheat Sheet: Is this bug considered a security vulnerability?","id":"151","title":"Cheat Sheet: Is this bug considered a security vulnerability?"},"152":{"body":"We're excited to work on Wasmtime and/or Cranelift together with you! This guide should help you get up and running with Wasmtime and Cranelift development. But first, make sure you've read the Code of Conduct ! Wasmtime and Cranelift are very ambitious projects with many goals, and while we're confident we can achieve some of them, we see many opportunities for people to get involved and help us achieve even more.","breadcrumbs":"Contributing » Contributing","id":"152","title":"Contributing"},"153":{"body":"We chat about Wasmtime and Cranelift development on Zulip — join us! . You can also join specific streams: #wasmtime #cranelift If you're having trouble building Wasmtime or Cranelift, aren't sure why a test is failing, or have any other questions, feel free to ask on Zulip. Not everything we hope to do with these projects is reflected in the code or documentation yet, so if you see things that seem missing or that don't make sense, or even that just don't work the way you expect them to, we're also interested to hear about that! As always, you're more than welcome to open an issue too! Finally, we have biweekly project meetings, hosted on Zoom, for Wasmtime and Cranelift. For more information, see our meetings agendas/minutes repository . Please feel free to contact us via Zulip if you're interested in joining!","breadcrumbs":"Contributing » Join Our Chat","id":"153","title":"Join Our Chat"},"154":{"body":"If you're looking for something to do, these are great places to start: Issues labeled \"good first issue\" — these issues tend to be simple, what needs to be done is well known, and are good for new contributors to tackle. The goal is to learn Wasmtime's development workflow and make sure that you can build and test Wasmtime. Issues labeled \"help wanted\" — these are issues that we need a little help with! If you're unsure if an issue is a good fit for you or not, feel free to ask in a comment on the issue, or in chat.","breadcrumbs":"Contributing » Finding Something to Hack On","id":"154","title":"Finding Something to Hack On"},"155":{"body":"We're happy to mentor people, whether you're learning Rust, learning about compiler backends, learning about machine code, learning about wasm, learning about how Cranelift does things, or all together at once. We categorize issues in the issue tracker using a tag scheme inspired by Rust's issue tags . For example, the E-easy marks good beginner issues, and E-rust marks issues which likely require some familiarity with Rust, though not necessarily Cranelift-specific or even compiler-specific experience. E-compiler-easy marks issues good for beginners who have some familiarity with compilers, or are interested in gaining some :-). See also the full list of Cranelift labels . Also, we encourage people to just look around and find things they're interested in. This a good time to get involved, as there aren't a lot of things set in stone yet.","breadcrumbs":"Contributing » Mentoring","id":"155","title":"Mentoring"},"156":{"body":"This document is intended to give an overview of the implementation of Wasmtime. This will explain the purposes of the various wasmtime-* crates that the main wasmtime crate depends on. For even more detailed information it's recommended to review the code itself and find the comments contained within.","breadcrumbs":"Contributing » Architecture » Architecture of Wasmtime","id":"156","title":"Architecture of Wasmtime"},"157":{"body":"The main entry point for Wasmtime is the wasmtime crate itself. Wasmtime is designed such that the wasmtime crate is nearly a 100% safe API (safe in the Rust sense) modulo some small and well-documented functions as to why they're unsafe. The wasmtime crate provides features and access to WebAssembly primitives and functionality, such as compiling modules, instantiating them, calling functions, etc. At this time the wasmtime crate is the first crate that is intended to be consumed by users. First in this sense means that everything wasmtime depends on is thought of as an internal dependency. We publish crates to crates.io but put very little effort into having a \"nice\" API for internal crates or worrying about breakage between versions of internal crates. This primarily means that all the other crates discussed here are considered internal dependencies of Wasmtime and don't show up in the public API of Wasmtime at all. To use some Cargo terminology, all the wasmtime-* crates that wasmtime depends on are \"private\" dependencies. Additionally at this time the safe/unsafe boundary between Wasmtime's internal crates is not the most well-defined. There are methods that should be marked unsafe which aren't, and unsafe methods do not have exhaustive documentation as to why they are unsafe. This is an ongoing matter of improvement, however, where the goal is to have safe methods be actually safe in the Rust sense, as well as having documentation for unsafe methods which clearly lists why they are unsafe.","breadcrumbs":"Contributing » Architecture » The wasmtime crate","id":"157","title":"The wasmtime crate"},"158":{"body":"To preface discussion of more nitty-gritty internals, it's important to have a few concepts in the back of your head. These are some of the important types and their implications in Wasmtime: wasmtime::Engine - this is a global compilation context which is sort of the \"root context\". An Engine is typically created once per program and is expected to be shared across many threads (internally it's atomically reference counted). Each Engine stores configuration values and other cross-thread data such as type interning for Module instances. The main thing to remember for Engine is that any mutation of its internals typically involves acquiring a lock, whereas for Store below no locks are necessary. wasmtime::Store - this is the concept of a \"store\" in WebAssembly. While there's also a formal definition to go off of, it can be thought of as a bag of related WebAssembly objects. This includes instances, globals, memories, tables, etc. A Store does not implement any form of garbage collection of the internal items (there is a gc function but that's just for externref values). This means that once you create an Instance or a Table the memory is not actually released until the Store itself is deallocated. A Store is sort of a \"context\" used for almost all wasm operations. Store also contains instance handles which recursively refer back to the Store, leading to a good bit of aliasing of pointers within the Store. The important thing for now, though, is to know that Store is a unit of isolation. WebAssembly objects are always entirely contained within a Store, and at this time nothing can cross between stores (except scalars if you manually hook it up). In other words, wasm objects from different stores cannot interact with each other. A Store cannot be used simultaneously from multiple threads (almost all operations require &mut self). wasmtime::runtime::vm::InstanceHandle - this is the low-level representation of a WebAssembly instance. At the same time this is also used as the representation for all host-defined objects. For example if you call wasmtime::Memory::new it'll create an InstanceHandle under the hood. This is a very unsafe type that should probably have all of its functions marked unsafe or otherwise have more strict guarantees documented about it, but it's an internal type that we don't put much thought into for public consumption at this time. An InstanceHandle doesn't know how to deallocate itself and relies on the caller to manage its memory. Currently this is either allocated on-demand (with malloc) or in a pooling fashion (using the pooling allocator). The deallocate method is different in these two paths (as well as the allocate method). An InstanceHandle is laid out in memory with some Rust-owned values first capturing the dynamic state of memories/tables/etc. Most of these fields are unused for host-defined objects that serve one purpose (e.g. a wasmtime::Table::new), but for an instantiated WebAssembly module these fields will have more information. After an InstanceHandle in memory is a VMContext, which will be discussed next. InstanceHandle values are the main internal runtime representation and what the crate::runtime::vm code works with. The wasmtime::Store holds onto all these InstanceHandle values and deallocates them at the appropriate time. From the runtime perspective it simplifies things so the graph of wasm modules communicating to each other is reduced to simply InstanceHandle values all talking to themselves. crate::runtime::vm::VMContext - this is a raw pointer, within an allocation of an InstanceHandle, that is passed around in JIT code. A VMContext does not have a structure defined in Rust (it's a 0-sized structure) because its contents are dynamically determined based on the VMOffsets, or the source wasm module it came from. Each InstanceHandle has a \"shape\" of a VMContext corresponding with it. For example a VMContext stores all values of WebAssembly globals, but if a wasm module has no globals then the size of this array will be 0 and it won't be allocated. The intention of a VMContext is to be an efficient in-memory representation of all wasm module state that JIT code may access. The layout of VMContext is dynamically determined by a module and JIT code is specialized for this one structure. This means that the structure is efficiently accessed by JIT code, but less efficiently accessed by native host code. A non-exhaustive list of purposes of the VMContext is to: Store WebAssembly instance state such as global values, pointers to tables, pointers to memory, and pointers to other JIT functions. Separate wasm imports and local state. Imported values have pointers stored to their actual values, and local state has the state defined inline. Hold a pointer to the stack limit at which point JIT code will trigger a stack overflow. Hold a pointer to a VMExternRefActivationsTable for fast-path insertion of externref values into the table. Hold a pointer to a *mut dyn crate::runtime::vm::Store so store-level operations can be performed in libcalls. A comment about the layout of a VMContext can be found in the vmoffsets.rs file. wasmtime::Module - this is the representation of a compiled WebAssembly module. At this time Wasmtime always assumes that a wasm module is always compiled to native JIT code. Module holds the results of said compilation, and currently Cranelift can be used for compiling. It is a goal of Wasmtime to support other modes of representing modules but those are not implemented today just yet, only Cranelift is implemented and supported. wasmtime_environ::Module - this is a descriptor of a wasm module's type and structure without holding any actual JIT code. An instance of this type is created very early on in the compilation process, and it is not modified when functions themselves are actually compiled. This holds the internal type representation and state about functions, globals, etc. In a sense this can be thought of as the result of validation or typechecking a wasm module, although it doesn't have information such as the types of each opcode or minute function-level details like that.","breadcrumbs":"Contributing » Architecture » Important concepts","id":"158","title":"Important concepts"},"159":{"body":"With a high-level overview and some background information of types, this will next walk through the steps taken to compile a WebAssembly module. The main entry point for this is the wasmtime::Module::from_binary API. There are a number of other entry points that deal with surface-level details like translation from text-to-binary, loading from the filesystem, etc. Compilation is roughly broken down into a few phases: First compilation walks over the WebAssembly module validating everything except function bodies. This synchronous pass over a wasm module creates a wasmtime_environ::Module instance and additionally prepares for function compilation. Note that with the module linking proposal one input module may end up creating a number of output modules to process. Each module is processed independently and all further steps are parallelized on a per-module basis. Note that parsing and validation of the WebAssembly module happens with the wasmparser crate. Validation is interleaved with parsing, validating parsed values before using them. Next all functions within a module are validated and compiled in parallel. No inter-procedural analysis is done and each function is compiled as its own little island of code at this time. This is the point where the meat of Cranelift is invoked on a per-function basis. The compilation results at this point are all woven into a wasmtime_jit::CompilationArtifacts structure. This holds module information (wasmtime_environ::Module), compiled JIT code (stored as an ELF image), and miscellaneous other information about functions such as platform-agnostic unwinding information, per-function trap tables (indicating which JIT instructions can trap and what the trap means), per-function address maps (mapping from JIT addresses back to wasm offsets), and debug information (parsed from DWARF information in the wasm module). These results are inert and can't actually be executed, but they're appropriate at this point to serialize to disk or begin the next phase... The final step is to actually place all code into a form that's ready to get executed. This starts from the CompilationArtifacts of the previous step. Here a new memory mapping is allocated and the JIT code is copied into this memory mapping. This memory mapping is then switched from read/write to read/execute so it's actually executable JIT code at this point. This is where various hooks like loading debuginfo, informing JIT profilers of new code, etc, all happens. At this point a wasmtime_jit::CompiledModule is produced and this is itself wrapped up in a wasmtime::Module. At this point the module is ready to be instantiated. A wasmtime::Module is an atomically-reference-counted object where upon instantiation into a Store, the Store will hold a strong reference to the internals of the module. This means that all instances of a wasmtime::Module share the same compiled code. Additionally a wasmtime::Module is one of the few objects that lives outside of a wasmtime::Store. This means that wasmtime::Module's reference counting is its own form of memory management. Note that the property of sharing a module's compiled code across all instantiations has interesting implications on what the compiled code can assume. For example Wasmtime implements a form of type interning, but the interned types happen at a few different levels. Within a module we deduplicate function types, but across modules in a Store types need to be represented with the same value. This means that if the same module is instantiated into many stores its same function type may take on many values, so the compiled code can't assume a particular value for a function type. (more on type information later). The general gist though is that compiled code leans relatively heavily on the VMContext for contextual input because the JIT code is intended to be so widely reusable.","breadcrumbs":"Contributing » Architecture » Compiling a module","id":"159","title":"Compiling a module"},"16":{"body":"type : string (path) default : look up cache_dir in directories crate Specifies where the cache directory is. Must be an absolute path.","breadcrumbs":"Using the Wasmtime CLI » Cache Configuration » Setting directory","id":"16","title":"Setting directory"},"160":{"body":"An important aspect to also cover for compilation is the creation of trampolines. Trampolines in this case refer to code executed by Wasmtime to enter WebAssembly code. The host may not always have prior knowledge about the signature of the WebAssembly function that it wants to call. Wasmtime JIT code is compiled with native ABIs (e.g. params/results in registers according to System V on Unix), which means that a Wasmtime embedding doesn't have an easy way to enter JIT code. This problem is what the trampolines compiled into a module solve, which is to provide a function with a known ABI that will call into a function with a specific other type signature/ABI. Wasmtime collects all the exported functions of a module and creates a set of their type signatures. Note that exported in this context actually means \"possibly exported\" which includes things like insertion into a global/function table, conversion to a funcref, etc. A trampoline is generated for each of these type signatures and stored along with the JIT code for the rest of the module. These trampolines are then used with the wasmtime::Func::call API where in that specific case because we don't know the ABI of the target function the trampoline (with a known ABI) is used and has all the parameters/results passed through the stack. Another point of note is that trampolines are not deduplicated at this time. Each compiled module contains its own set of trampolines, and if two compiled modules have the same types then they'll have different copies of the same trampoline.","breadcrumbs":"Contributing » Architecture » Trampolines","id":"160","title":"Trampolines"},"161":{"body":"One important point to talk about with compilation is the VMSharedSignatureIndex type and how it's used. The call_indirect opcode in wasm compares an actual function's signature against the function signature of the instruction, trapping if the signatures mismatch. This is implemented in Wasmtime as an integer comparison, and the comparison happens on a VMSharedSignatureIndex value. This index is an intern'd representation of a function type. The scope of interning for VMSharedSignatureIndex happens at the wasmtime::Engine level. Modules are compiled into an Engine. Insertion of a Module into an Engine will assign a VMSharedSignatureIndex to all of the types found within the module. The VMSharedSignatureIndex values for a module are local to that one instantiation of a Module (and they may change on each insertion of a Module into a different Engine). These are used during the instantiation process by the runtime to assign a type ID effectively to all functions for imports and such.","breadcrumbs":"Contributing » Architecture » Type Interning and VMSharedSignatureIndex","id":"161","title":"Type Interning and VMSharedSignatureIndex"},"162":{"body":"Once a module has been compiled it's typically then instantiated to actually get access to the exports and call wasm code. Instantiation always happens within a wasmtime::Store and the created instance (plus all exports) are tied to the Store. Instantiation itself (crates/wasmtime/src/instance.rs) may look complicated, but this is primarily due to the implementation of the Module Linking proposal. The rough flow of instantiation looks like: First all imports are type-checked. The provided list of imports is cross-referenced with the list of imports recorded in the wasmtime_environ::Module and all types are verified to line up and match (according to the core wasm specification's definition of type matching). Each wasmtime_environ::Module has a list of initializers that need to be completed before instantiation is finished. For MVP wasm this only involves loading the import into the correct index array, but for module linking this could involve instantiating other modules, handling alias fields, etc. In any case the result of this step is a crate::runtime::vm::Imports array which has the values for all imported items into the wasm module. Note that in this case an import is typically some sort of raw pointer to the actual state plus the VMContext of the instance that was imported from. The final result of this step is an InstanceAllocationRequest, which is then submitted to the configured instance allocator, either on-demand or pooling. The InstanceHandle corresponding to this instance is allocated. How this is allocated depends on the strategy (malloc for on-demand, slab allocation for pooling). In addition to initialization of the fields of InstanceHandle this also initializes all the fields of the VMContext for this handle (which as mentioned above is adjacent to the InstanceHandle allocation after it in memory). This does not process any data segments, element segments, or the start function at this time. At this point the InstanceHandle is stored within the Store. This is the \"point of no return\" where the handle must be kept alive for the same lifetime as the Store itself. If an initialization step fails then the instance may still have had its functions, for example, inserted into an imported table via an element segment. This means that even if we fail to initialize this instance its state could still be visible to other instances/objects so we need to keep it alive regardless. The final step is performing wasm-defined instantiation. This involves processing element segments, data segments, the start function, etc. Most of this is just translating from Wasmtime's internal representation to the specification's required behavior. Another part worth pointing out for instantiating a module is that a ModuleRegistry is maintained within a Store of all instantiated modules into the store. The purpose of this registry is to retain a strong reference to items in the module needed to run instances. This includes the JIT code primarily but also has information such as the VMSharedSignatureIndex registration, metadata about function addresses and such, etc. Much of this data is stored into a GLOBAL_MODULES map for later access during traps.","breadcrumbs":"Contributing » Architecture » Instantiating a module","id":"162","title":"Instantiating a module"},"163":{"body":"Once instances have been created and wasm starts running most things are fairly standard. Trampolines are used to enter wasm (or we can enter with a known ABI if using wasmtime::TypedFunc) and JIT code generally does what it does to execute wasm. An important aspect of the implementation to cover, however, is traps. Wasmtime today implements traps with longjmp and setjmp. The setjmp function cannot be defined in Rust (even unsafely -- (https://github.com/rust-lang/rfcs/issues/2625) so the crates/wasmtime/src/runtime/vm/helpers.c file actually calls setjmp/longjmp. Note that in general the operation of longjmp is not safe to execute in Rust because it skips stack-based destructors, so after setjmp when we call back into Rust to execute wasm we need to be careful in Wasmtime to not have any significant destructors on the stack once wasm is called. Traps can happen from a few different sources: Explicit traps - these can happen when a host call returns a trap, for example. These bottom out in raise_user_trap or raise_lib_trap, both of which immediately call longjmp to go back to the wasm starting point. Note that these, like when calling wasm, have to have callers be very careful to not have any destructors on the stack. Signals - this is the main vector for trap. Basically we use segfault and illegal instructions to implement traps in wasm code itself. Segfaults arise when linear memory accesses go out of bounds and illegal instructions are how the wasm unreachable instruction is implemented. In both of these cases Wasmtime installs a platform-specific signal handler to catch the signal, inspect the state of the signal, and then handle it. Note that Wasmtime tries to only catch signals that happen from JIT code itself as to not accidentally cover up other bugs. Exiting a signal handler happens via longjmp to get back to the original wasm call-site. The general idea is that Wasmtime has very tight control over the stack frames of wasm (naturally via Cranelift) and also very tight control over the code that executes just before we enter wasm (aka before the setjmp) and just after we reenter back into wasm (aka frames before a possible longjmp). The signal handler for Wasmtime uses the GLOBAL_MODULES map populated during instantiation to determine whether a program counter that triggered a signal is indeed a valid wasm trap. This should be true except for cases where the host program has another bug that triggered the signal. A final note worth mentioning is that Wasmtime uses the Rust backtrace crate to capture a stack trace when a wasm exception occurs. This forces Wasmtime to generate native platform-specific unwinding information to correctly unwind the stack and generate a stack trace for wasm code. This does have other benefits as well such as improving generic sampling profilers when used with Wasmtime.","breadcrumbs":"Contributing » Architecture » Traps","id":"163","title":"Traps"},"164":{"body":"Linear memory in Wasmtime is implemented effectively with mmap (or the platform equivalent thereof), but there are some subtle nuances that are worth pointing out here too. The implementation of linear memory is relatively configurable which gives rise to a number of situations that both the runtime and generated code need to handle. First there are a number of properties about linear memory which can be configured: wasmtime::Config::static_memory_maximum_size wasmtime::Config::static_memory_guard_size wasmtime::Config::dynamic_memory_guard_size wasmtime::Config::guard_before_linear_memory The methods on Config have a good bit of documentation to go over some nitty-gritty, but the general gist is that Wasmtime has two modes of memory: static and dynamic. Static memories represent an address space reservation that never moves and pages are committed to represent memory growth. Dynamic memories represent allocations where the committed portion exactly matches the wasm memory's size and growth happens by allocating a bigger chunk of memory. The guard size configuration indicates the size of the guard region that happens after linear memory. This guard size affects whether generated JIT code emits bounds checks or not. Bounds checks are elided if out-of-bounds addresses provably encounter the guard pages. The guard_before_linear_memory configuration additionally places guard pages in front of linear memory as well as after linear memory (the same size on both ends). This is only used to protect against possible Cranelift bugs and otherwise serves no purpose. The defaults for Wasmtime on 64-bit platforms are: 4GB static maximum size meaning all 32-bit memories are static and 64-bit memories are dynamic. 2GB static guard size meaning all loads/stores with less than 2GB offset don't need bounds checks with 32-bit memories. Guard pages before linear memory are enabled. Altogether this means that 32-bit linear memories result in an 8GB virtual address space reservation by default in Wasmtime. With the pooling allocator where we know that linear memories are contiguous this results in a 6GB reservation per memory because the guard region after one memory is the guard region before the next. Note that 64-bit memories (the memory64 proposal for WebAssembly) can be configured to be static but will never be able to elide bounds checks at this time. This configuration is possible through the static_memory_forced configuration option. Additionally note that support for 64-bit memories in Wasmtime is functional but not yet tuned at this time so there's probably still some performance work and better defaults to manage.","breadcrumbs":"Contributing » Architecture » Linear Memory","id":"164","title":"Linear Memory"},"165":{"body":"WebAssembly tables contain reference types, currently either funcref or externref. A funcref in Wasmtime is represented as *mut VMCallerCheckedFuncRef and an externref is represented as VMExternRef (which is internally *mut VMExternData). Tables are consequently represented as vectors of pointers. Table storage memory management by default goes through Rust's Vec which uses malloc and friends for memory. With the pooling allocator this uses preallocated memory for storage. As mentioned previously Store has no form of internal garbage collection for wasm objects themselves so a funcref table in wasm is pretty simple in that there's no lifetime management of any of the pointers stored within, they're simply assumed to be valid for as long as the table is in use. For tables of externref the story is more complicated. The VMExternRef is a version of Arc<dyn Any> but specialized in Wasmtime so JIT code knows where the offset of the reference count field to directly manipulate it is. Furthermore tables of externref values need to manage the reference count field themselves, since the pointer stored in the table is required to have a strong reference count allocated to it.","breadcrumbs":"Contributing » Architecture » Tables and externref","id":"165","title":"Tables and externref"},"166":{"body":"Wasmtime implements the externref type of WebAssembly with an atomically-reference-counted pointer. Note that the atomic part is not needed by wasm itself but rather from the Rust embedding environment where it must be safe to send ExternRef values to other threads. Wasmtime also does not come with a cycle collector so cycles of host-allocated ExternRef objects will leak. Despite reference counting, though, a Store::gc method exists. This is an implementation detail of how reference counts are managed while wasm code is executing. Instead of managing the reference count of an externref value individually as it moves around on the stack Wasmtime implements \"deferred reference counting\" where there's an overly conservative list of ExternRef values that may be in use, and periodically a GC is performed to make this overly conservative list a precise one. This leverages the stack map support of Cranelift plus the backtracing support of backtrace to determine live roots on the stack. The Store::gc method forces the possibly-overly-conservative list to become a precise list of externref values that are actively in use on the stack.","breadcrumbs":"Contributing » Architecture » GC and externref","id":"166","title":"GC and externref"},"167":{"body":"The main Wasmtime internal crates are: wasmtime - the safe public API of wasmtime. wasmtime::runtime::vm - low-level runtime implementation of Wasmtime. This is where VMContext and InstanceHandle live. This module used to be a crate, but has since been folding into wasmtime. wasmtime-environ - low-level compilation support. This is where translation of the Module and its environment happens, although no compilation actually happens in this crate (although it defines an interface for compilers). The results of this crate are handed off to other crates for actual compilation. wasmtime-cranelift - implementation of function-level compilation using Cranelift. Note that at this time Cranelift is a required dependency of wasmtime. Most of the types exported from wasmtime-environ use cranelift types in their API. One day it's a goal, though, to remove the required cranelift dependency and have wasmtime-environ be a relatively standalone crate. In addition to the above crates there are some other miscellaneous crates that wasmtime depends on: wasmtime-cache - optional dependency to manage default caches on the filesystem. This is enabled in the CLI by default but not enabled in the wasmtime crate by default. wasmtime-fiber - implementation of stack-switching used by async support in Wasmtime wasmtime-debug - implementation of mapping wasm dwarf debug information to native dwarf debug information. wasmtime-profiling - implementation of hooking up generated JIT code to standard profiling runtimes. wasmtime-obj - implementation of creating an ELF image from compiled functions.","breadcrumbs":"Contributing » Architecture » Index of crates","id":"167","title":"Index of crates"},"168":{"body":"This section describes everything required to build and run Wasmtime.","breadcrumbs":"Contributing » Building » Building","id":"168","title":"Building"},"169":{"body":"Before we can actually build Wasmtime, we'll need to make sure these things are installed first.","breadcrumbs":"Contributing » Building » Prerequisites","id":"169","title":"Prerequisites"},"17":{"body":"type : string (SI prefix) format : \"{integer}(K | M | G | T | P)?\" default : \"16\" Size of cache worker event queue. If the queue is full, incoming cache usage events will be dropped.","breadcrumbs":"Using the Wasmtime CLI » Cache Configuration » Setting worker-event-queue-size","id":"17","title":"Setting worker-event-queue-size"},"170":{"body":"The Wasmtime repository contains a number of git submodules. To build Wasmtime and most other crates in the repository, you have to ensure that those are initialized with this command: git submodule update --init","breadcrumbs":"Contributing » Building » Git Submodules","id":"170","title":"Git Submodules"},"171":{"body":"Install the Rust toolchain here. This includes rustup, cargo, rustc, etc...","breadcrumbs":"Contributing » Building » The Rust Toolchain","id":"171","title":"The Rust Toolchain"},"172":{"body":"The wasmtime-fuzzing crate transitively depends on bindgen, which requires that your system has a libclang installed. Therefore, if you want to hack on Wasmtime's fuzzing infrastructure, you'll need libclang. Details on how to get libclang and make it available for bindgen are here.","breadcrumbs":"Contributing » Building » libclang (optional)","id":"172","title":"libclang (optional)"},"173":{"body":"To make an unoptimized, debug build of the wasmtime CLI tool, go to the root of the repository and run this command: cargo build The built executable will be located at target/debug/wasmtime. To make an optimized build, run this command in the root of the repository: cargo build --release The built executable will be located at target/release/wasmtime. You can also build and run a local wasmtime CLI by replacing cargo build with cargo run.","breadcrumbs":"Contributing » Building » Building the wasmtime CLI","id":"173","title":"Building the wasmtime CLI"},"174":{"body":"See crates/c-api/README.md for details.","breadcrumbs":"Contributing » Building » Building the Wasmtime C API","id":"174","title":"Building the Wasmtime C API"},"175":{"body":"You can build any of the Wasmtime crates by appending -p wasmtime-whatever to the cargo build invocation. For example, to build the wasmtime-environ crate, execute this command: cargo build -p wasmtime-environ Alternatively, you can cd into the crate's directory, and run cargo build there, without needing to supply the -p flag: cd crates/environ/\ncargo build","breadcrumbs":"Contributing » Building » Building Other Wasmtime Crates","id":"175","title":"Building Other Wasmtime Crates"},"176":{"body":"This section describes how to run Wasmtime's tests and add new tests. Before continuing, make sure you can build Wasmtime successfully. Can't run the tests if you can't build it!","breadcrumbs":"Contributing » Testing » Testing","id":"176","title":"Testing"},"177":{"body":"To compile the tests, you'll need the wasm32-wasip1 and wasm32-unknown-unknown targets installed, which, assuming you're using rustup.rs to manage your Rust versions, can be done as follows: rustup target add wasm32-wasip1 wasm32-unknown-unknown","breadcrumbs":"Contributing » Testing » Installing wasm32 Targets","id":"177","title":"Installing wasm32 Targets"},"178":{"body":"Depending on what you're modifying there's a few commands you may be the most interested: cargo test - used to run the tests/* folder at the top-level. This tests the CLI and contains most tests for the wasmtime crate itself. This will also run all spec tests. Note that this does not run all tests in the repository, but it's generally a good starting point. cargo test -p cranelift-tools - used if you're working on Cranelift and this will run all the tests at cranelift/filetests/filetests. You can also, within the cranelift folder, run cargo run test ./filetests to run these tests. cargo test -p wasmtime-wasi - this will run all WASI tests for the wasmtime-wasi crate. At this time not all of the crates in the Wasmtime workspace can be tested, so running all tests is a little non-standard. To match what CI does and run all tests you'll need to execute ./ci/run-tests.sh","breadcrumbs":"Contributing » Testing » Running Tests","id":"178","title":"Running Tests"},"179":{"body":"You can test a particular Wasmtime crate with cargo test -p wasmtime-whatever. For example, to test the wasmtime-environ crate, execute this command: cargo test -p wasmtime-environ Alternatively, you can cd into the crate's directory, and run cargo test there, without needing to supply the -p flag: cd crates/environ/\ncargo test","breadcrumbs":"Contributing » Testing » Testing a Specific Crate","id":"179","title":"Testing a Specific Crate"},"18":{"body":"type : integer default : 3, the default zstd compression level Compression level used when a new cache file is being written by the cache system . Wasmtime uses zstd compression.","breadcrumbs":"Using the Wasmtime CLI » Cache Configuration » Setting baseline-compression-level","id":"18","title":"Setting baseline-compression-level"},"180":{"body":"The spec testsuite itself is in a git submodule, so make sure you've checked it out and initialized its submodule: git submodule update --init When the submodule is checked out, Wasmtime runs the Wasm spec testsuite as part of testing the wasmtime-cli crate at the crate root, meaning in the root of the repository you can execute: cargo test --test wast You can pass an additional CLI argument to act as a filter on which tests to run. For example to only run the spec tests themselves (excluding handwritten Wasmtime-specific tests) and only in Cranelift you can run: cargo test --test wast Cranelift/tests/spec Note that in general spec tests are executed regardless of whether they pass or not. In tests/wast.rs there's a should_fail function which indicates the expected result of the test. When adding new spec tests or implementing features this function will need to be updated as tests change from failing to passing.","breadcrumbs":"Contributing » Testing » Running the Wasm Spec Tests","id":"180","title":"Running the Wasm Spec Tests"},"181":{"body":"WASI integration tests can be run separately from all other tests which can be useful when working on the wasmtime-wasi crate. This can be done by executing this command: cargo test -p wasmtime-wasi Similarly if you're testing HTTP-related functionality you can execute: cargo test -p wasmtime-wasi-http Note that these tests will compile programs in crates/test-programs to run.","breadcrumbs":"Contributing » Testing » Running WASI Integration Tests","id":"181","title":"Running WASI Integration Tests"},"182":{"body":"","breadcrumbs":"Contributing » Testing » Adding New Tests","id":"182","title":"Adding New Tests"},"183":{"body":"For very \"unit-y\" tests, we add test modules in the same .rs file as the code that is being tested. These test modules are configured to only get compiled during testing with #[cfg(test)]. // some code... #[cfg(test)]\nmod tests { use super::*; #[test] fn some_test_for_that_code() { // ... }\n} If you're writing a unit test and a test module doesn't already exist, you can create one. For more \"integration-y\" tests, each crate supports a separate tests directory within the crate, and put the tests inside there. Most integration tests in Wasmtime are located in the root tests/*.rs location, notably tests/all/*.rs. This tests much of the wasmtime crate for example and facilitates cargo test at the repository root running most tests. Some tests make more sense to live per-crate, though. For example, many WASI tests are at crates/wasi/tests/*.rs. For adding a test feel free to add it wherever feels best, there's not really a strong reason to put it in one place over another. While it's easiest to add to existing tests it's ok to add a new tests directory with tests too.","breadcrumbs":"Contributing » Testing » Adding Rust's #[test]-Style Tests","id":"183","title":"Adding Rust's #[test]-Style Tests"},"184":{"body":"We use the spec testsuite as-is and without custom patches or a forked version via a submodule at tests/spec_testsuite. This probably isn't what you want to modify when adding a new Wasmtime test! When you have a Wasmtime-specific test that you'd like to write in Wast and use the Wast-style assertions, you can add it to our \"misc testsuite\". The misc testsuite uses the same syntax and assertions as the spec testsuite, but lives in tests/misc_testsuite. Feel free to add new tests to existing tests/misc_testsuite/*.wast files or create new ones as needed. These tests are run from the crate root: cargo test --test wast If you have a new test that you think really belongs in the spec testsuite, make sure it makes sense for every Wasm implementation to run your test (i.e. it isn't Wasmtime-specific) and send a pull request upstream . Once it is accepted in the upstream repo, it'll make its way to the test-specific mirror at WebAssembly/testsuite and then we can update our git submodule and we'll start running the new tests.","breadcrumbs":"Contributing » Testing » Adding Specification-Style Wast Tests","id":"184","title":"Adding Specification-Style Wast Tests"},"185":{"body":"When you have a WASI-specific test program that you'd like to include as a test case to run against our WASI implementation, you can add it to our test-programs crate. In particular, you should drop a main-style Rust source file into crates/test-programs/src/bin/PREFIX_some_new_test.rs. Here the PREFIX indicates what test suite it's going to run as. For example preview2_* tests are run as part of wasmtime-wasi crate tests. The cli_* tests are run as part of tests/all/cli_tests.rs. It's probably easiest to use a preexisting prefix. The some_new_test name is arbitrary and is selected as appropriate by you. One a test file is added you'll need to add some code to execute the tests as well. For example if you added a new test crates/test-programs/src/bin/cli_my_test.rs then you'll need to add a new function to tests/all/cli_tests.rs such as: #[test]\nfn my_test() { // ...\n} The path to the compiled WebAssembly of your test case will be available in a Rust-level const named CLI_MY_TEST. There is also a component version at CLI_MY_TEST_COMPONENT. These are used to pass as arguments to wasmtime-the-CLI for example or you can use Module::from_file. When in doubt feel free to copy existing tests and then modify them to suit your needs.","breadcrumbs":"Contributing » Testing » Adding WASI Integration Tests","id":"185","title":"Adding WASI Integration Tests"},"186":{"body":"","breadcrumbs":"Contributing » Fuzzing » Fuzzing","id":"186","title":"Fuzzing"},"187":{"body":"Test case generators and oracles live in the wasmtime-fuzzing crate, located in the crates/fuzzing directory. A test case generator takes raw, unstructured input from a fuzzer and translates that into a test case. This might involve interpreting the raw input as \"DNA\" or pre-determined choices through a decision tree and using it to generate an in-memory data structure, or it might be a no-op where we interpret the raw bytes as if they were Wasm. An oracle takes a test case and determines whether we have a bug. For example, one of the simplest oracles is to take a Wasm binary as an input test case, validate and instantiate it, and (implicitly) check that no assertions failed or segfaults happened. A more complicated oracle might compare the result of executing a Wasm file with and without optimizations enabled, and make sure that the two executions are observably identical. Our test case generators and oracles strive to be fuzzer-agnostic: they can be reused with libFuzzer or AFL or any other fuzzing engine or driver.","breadcrumbs":"Contributing » Fuzzing » Test Case Generators and Oracles","id":"187","title":"Test Case Generators and Oracles"},"188":{"body":"We combine a test case generator and one more more oracles into a fuzz target . Because the target needs to pipe the raw input from a fuzzer into the test case generator, it is specific to a particular fuzzer. This is generally fine, since they're only a couple of lines of glue code. Currently, all of our fuzz targets are written for libFuzzer and cargo fuzz . They are defined in the fuzz subdirectory. See fuzz/README.md for details on how to run these fuzz targets and set up a corpus of seed inputs.","breadcrumbs":"Contributing » Fuzzing » libFuzzer and cargo fuzz Fuzz Targets","id":"188","title":"libFuzzer and cargo fuzz Fuzz Targets"},"189":{"body":"The Wasmtime and Cranelift projects heavily rely on Continuous Integration (CI) to ensure everything keeps working and keep the final end state of the code at consistently high quality. The CI setup for this repository is relatively involved and extensive, and so it's worth covering here how it's organized and what's expected of contributors. All CI currently happens on GitHub Actions and is configured in the .github directory of the repository.","breadcrumbs":"Contributing » CI » Continuous Integration (CI)","id":"189","title":"Continuous Integration (CI)"},"19":{"body":"type : integer default : 20 Compression level used when the cache worker decides to recompress a cache file. Wasmtime uses zstd compression.","breadcrumbs":"Using the Wasmtime CLI » Cache Configuration » Setting optimized-compression-level","id":"19","title":"Setting optimized-compression-level"},"190":{"body":"Currently on sample of the full CI test suite is run on every Pull Request. CI on PRs is intended to be relatively quick and catch the majority of mistakes and errors. By default the test suite is run on x86_64 Linux but this may change depending on what files the PR is modifying. The intention is to run \"mostly relevant\" CI on a PR by default. PR authors are expected to fix CI failures in their PR, unless the CI failure is systemic and unrelated to the PR. In that case other maintainers should be alerted to ensure that the problem can be addressed. Some reviewers may also wait to perform a review until CI is green on the PR as otherwise it may indicate changes are needed. The Wasmtime repository uses GitHub's Merge Queue feature to merge PRs which. Entry in to the merge queue requires green CI on the PR beforehand. Maintainers who have approved a PR will flag it for entry into the merge queue, and the PR will automatically enter the merge queue once CI is green. When entering the merge queue a PR will have the full test suite executed which may include tests that weren't previously run on the PR. This may surface new failures, and contributors are expected to fix these failures as well. To force PRs to execute the full test suite, which takes longer than the default test suite for PRs, then contributors can place the string \"prtest:full\" somewhere in any commit of the PR. From that point on the PR will automatically run the full test suite as-if it were in the merge queue. Note that when going through the merge queue this will rerun tests.","breadcrumbs":"Contributing » CI » PRs and CI","id":"190","title":"PRs and CI"},"191":{"body":"While this may not be fully exhaustive, the general idea of all the checks we run on CI looks like this: Code formatting - we run cargo fmt -- --check on CI to ensure that all code in the repository is formatted with rustfmt. All PRs are expected to be formatted with the latest stable version of rustfmt. Book documentation tests - code snippets (Rust ones at least) in the book documentation ( the docs folder ) are tested on CI to ensure they are working. Crate tests - the moral equivalent of cargo test --all and cargo test --all --release is executed on CI. This means that all workspace crates have their entire test suite run, documentation tests and all, in both debug and release mode. Additionally we execute all crate tests on macOS, Windows, and Linux, to ensure that everything works on all the platforms. Fuzz regression tests - we take a random sampling of the fuzz corpus and run it through the fuzzers. This is mostly intended to be a pretty quick regression test and testing the fuzzers still build, most of our fuzzing happens on oss-fuzz . Found issues are recorded in the oss-fuzz bug tracker While we do run more tests here and there, this is the general shape of what you can be expected to get tested on CI for all commits and all PRs. You can of course always feel free to expand our CI coverage by editing the CI files themselves, we always like to run more tests!","breadcrumbs":"Contributing » CI » Tests run on CI","id":"191","title":"Tests run on CI"},"192":{"body":"Our CI system is also responsible for producing all binary releases and documentation of Wasmtime and Cranelift. Currently this consists of: Tarballs of the wasmtime CLI - produced for macOS, Windows, and Linux we try to make these \"binary compatible\" wherever possible, for example producing the Linux build in a really old CentOS container to have a very low glibc requirement. Tarballs of the Wasmtime C API - produced for the same set of platforms as the CLI above. Book and API documentation - the book is rendered with mdbook and we also build all documentation with cargo doc. A source code tarball which is entirely self-contained. This source tarball has all dependencies vendored so the network is not needed to build it. WebAssembly adapters for the component model to translate wasi_snapshot_preview1 to WASI Preview 2. Artifacts are produced as part of the full CI suite. This means that artifacts are not produced on a PR by default but can be requested via \"prtest:full\". All runs through the merge queue though, which means all merges to main, will produce a full suite of artifacts. The latest artifacts are available through Wasmtime's dev release and downloads are also available for recent CI runs through the CI page in GitHub Actions.","breadcrumbs":"Contributing » CI » Artifacts produced on CI","id":"192","title":"Artifacts produced on CI"},"193":{"body":"When reporting a bug, or investing a bug report, in Wasmtime it is easier for everyone involved when there is a test case that reproduces the bug. It is even better when that test case is as small as possible, so that developers don't need to wade through megabytes of unrelated Wasm that isn't necessary to showcase the bug. The process of taking a large test case and stripping out the unnecessary bits is called test case reduction . The wasm-tools shrink tool can automatically reduce Wasm test cases when given the original, unreduced test case, and a predicate script to determine whether the bug reproduces on a given reduced test case candidate. If the test case causes Wasmtime to segfault, the script can run Wasmtime and check its exit code. If the test case produces a different result in Wasmtime vs another Wasm engine, the script can run both engines and compare their results. It is also often useful to grep through the candidate's WAT disassembly to make sure that relevant features and instructions are present.","breadcrumbs":"Contributing » Reducing Test Cases » Reducing Test Cases","id":"193","title":"Reducing Test Cases"},"194":{"body":"A bug was reported involving the memory.init instruction. The attached test case was larger than it needed to be and contained a bunch of functions and other things that were irrelevant. A perfect use case for wasm-tools shrink! First, we needed a predicate script to identify the reported buggy behavior. The script is given the candidate test case as its first argument and must exit zero if the candidate exhibits the bug and non-zero otherwise. #!/usr/bin/env bash # Propagate failure: exit non-zero if any individual command exits non-zero.\nset -e # Disassembly the candidate into WAT. Make sure the `memory.init` instruction\n# is present, since the bug report is about that instruction. Additionally, make\n# sure it is referencing the same data segment.\nwasm-tools print $1 | grep -q 'memory.init 2' # Make sure that the data segment in question remains unchanged, as mutating its\n# length can change the semantics of the `memory.init` instruction.\nwasm-tools print $1 | grep -Eq '\\(data \\(;2;\\) \\(i32\\.const 32\\) \"\\\\01\\\\02\\\\03\\\\04\\\\05\\\\06\\\\07\\\\08\\\\ff\"\\)' # Make sure that the `_start` function that contains the `memory.init` is still\n# exported, so that running the Wasm will run the `memory.init` instruction.\nwasm-tools print $1 | grep -Eq '\\(export \"_start\" \\(func 0\\)\\)' # Run the testcase in Wasmtime and make sure that it traps the same way as the\n# original test case.\ncargo run --manifest-path ~/wasmtime/Cargo.toml -- run $1 2>&1 \\ | grep -q 'wasm trap: out of bounds memory access' Note that this script is a little fuzzy! It just checks for memory.init and a particular trap. That trap can correctly occur according to Wasm semantics when memory.init is given certain inputs! This means we need to double check that the reduced test case actually exhibits a real bug and its inputs haven't been transformed into something that Wasm semantics specify should indeed trap. Sometimes writing very precise predicate scripts is difficult, but we do the best we can and usually it works out fine. With the predicate script in hand, we can automatically reduce the original test case: $ wasm-tools shrink predicate.sh test-case.wasm\n369 bytes (1.07% smaller)\n359 bytes (3.75% smaller)\n357 bytes (4.29% smaller)\n354 bytes (5.09% smaller)\n344 bytes (7.77% smaller)\n...\n118 bytes (68.36% smaller)\n106 bytes (71.58% smaller)\n94 bytes (74.80% smaller)\n91 bytes (75.60% smaller)\n90 bytes (75.87% smaller) test-case.shrunken.wasm :: 90 bytes (75.87% smaller)\n================================================================================\n(module (type (;0;) (func)) (func (;0;) (type 0) (local i32 f32 i64 f64) i32.const 0 i32.const 9 i32.const 0 memory.init 2 ) (memory (;0;) 1 5) (export \"_start\" (func 0)) (data (;0;) (i32.const 8) \"\") (data (;1;) (i32.const 16) \"\") (data (;2;) (i32.const 32) \"\\01\\02\\03\\04\\05\\06\\07\\08\\ff\")\n)\n================================================================================ In this case, the arguments to the original memory.init instruction haven't changed, and neither has the relevant data segment, so the reduced test case should exhibit the same behavior as the original. In the end, it was determined that Wasmtime was behaving as expected , but the presence of the reduced test case makes it much easier to make that determination.","breadcrumbs":"Contributing » Reducing Test Cases » Case Study: Issue #7779","id":"194","title":"Case Study: Issue #7779"},"195":{"body":"When contributing to Wasmtime and Cranelift you may run into issues that only reproduce on a different architecture from your development machine. Luckily, cargo makes cross compilation and running tests under QEMU pretty easy. This guide will assume you are on an x86-64 with Ubuntu/Debian as your OS. The basic approach (with commands, paths, and package names appropriately tweaked) applies to other Linux distributions as well. On Windows you can install build tools for AArch64 Windows, but targeting platforms like Linux or macOS is not easy. While toolchains exist for targeting non-Windows platforms you'll have to hunt yourself to find the right one. On macOS you can install, through Xcode, toolchains for iOS but the main x86_64-apple-darwin is really the only easy target to install. You'll need to hunt for toolchains if you want to compile for Linux or Windows.","breadcrumbs":"Contributing » Cross Compiling » Cross Compiling","id":"195","title":"Cross Compiling"},"196":{"body":"First, use rustup to install Rust targets for the other architectures that Wasmtime and Cranelift support: $ rustup target add \\ s390x-unknown-linux-gnu \\ riscv64gc-unknown-linux-gnu \\ aarch64-unknown-linux-gnu","breadcrumbs":"Contributing » Cross Compiling » Install Rust Targets","id":"196","title":"Install Rust Targets"},"197":{"body":"Next, you'll need to install a gcc for each cross-compilation target to serve as a linker for rustc. $ sudo apt install \\ gcc-s390x-linux-gnu \\ gcc-riscv64-linux-gnu \\ gcc-aarch64-linux-gnu","breadcrumbs":"Contributing » Cross Compiling » Install GCC Cross-Compilation Toolchains","id":"197","title":"Install GCC Cross-Compilation Toolchains"},"198":{"body":"You will also need to install qemu to emulate the cross-compilation targets. $ sudo apt install qemu-user","breadcrumbs":"Contributing » Cross Compiling » Install qemu","id":"198","title":"Install qemu"},"199":{"body":"The final bit to get out of the way is to configure cargo to use the appropriate gcc and qemu when cross-compiling and running tests for other architectures. Add this to .cargo/config.toml in the Wasmtime repository (or create that file if none already exists). [target.aarch64-unknown-linux-gnu]\nlinker = \"aarch64-linux-gnu-gcc\"\nrunner = \"qemu-aarch64 -L /usr/aarch64-linux-gnu -E LD_LIBRARY_PATH=/usr/aarch64-linux-gnu/lib -E WASMTIME_TEST_NO_HOG_MEMORY=1\" [target.riscv64gc-unknown-linux-gnu]\nlinker = \"riscv64-linux-gnu-gcc\"\nrunner = \"qemu-riscv64 -L /usr/riscv64-linux-gnu -E LD_LIBRARY_PATH=/usr/riscv64-linux-gnu/lib -E WASMTIME_TEST_NO_HOG_MEMORY=1\" [target.s390x-unknown-linux-gnu]\nlinker = \"s390x-linux-gnu-gcc\"\nrunner = \"qemu-s390x -L /usr/s390x-linux-gnu -E LD_LIBRARY_PATH=/usr/s390x-linux-gnu/lib -E WASMTIME_TEST_NO_HOG_MEMORY=1\"","breadcrumbs":"Contributing » Cross Compiling » Configure Cargo","id":"199","title":"Configure Cargo"},"2":{"body":"Here we'll show you how to install the wasmtime command line tool. Note that this is distinct from embedding the Wasmtime project into another, for that you'll want to consult the embedding documentation . The easiest way to install the wasmtime CLI tool is through our installation script. Linux and macOS users can execute the following: $ curl https://wasmtime.dev/install.sh -sSf | bash This will download a precompiled version of wasmtime, place it in $HOME/.wasmtime, and update your shell configuration to place the right directory in PATH. Windows users will want to visit our releases page and can download the MSI installer (wasmtime-dev-x86_64-windows.msi for example) and use that to install. You can confirm your installation works by executing: $ wasmtime -V\nwasmtime 0.12.0 And now you're off to the races! Be sure to check out the various CLI options as well.","breadcrumbs":"Using the Wasmtime CLI » Installation » Installing wasmtime","id":"2","title":"Installing wasmtime"},"20":{"body":"type : string (SI prefix) format : \"{integer}(K | M | G | T | P)?\" default : \"256\" One of the conditions for the cache worker to recompress a cache file is to have usage count of the file exceeding this threshold.","breadcrumbs":"Using the Wasmtime CLI » Cache Configuration » Setting optimized-compression-usage-counter-threshold","id":"20","title":"Setting optimized-compression-usage-counter-threshold"},"200":{"body":"Now you can use cargo build, cargo run, and cargo test as you normally would for any crate inside the Wasmtime repository, just add the appropriate --target flag! A few examples: Build the wasmtime binary for aarch64: $ cargo build --target aarch64-unknown-linux-gnu Run the tests under riscv emulation: $ cargo test --target riscv64gc-unknown-linux-gnu Run the wasmtime binary under s390x emulation: $ cargo run --target s390x-unknown-linux-gnu -- compile example.wasm","breadcrumbs":"Contributing » Cross Compiling » Cross-Compile Tests and Run Them!","id":"200","title":"Cross-Compile Tests and Run Them!"},"201":{"body":"For the most part, Wasmtime and Cranelift follow common Rust conventions and pull request (PR) workflows, though we do have a few additional things to be aware of.","breadcrumbs":"Contributing » Coding Guidelines » Coding guidelines","id":"201","title":"Coding guidelines"},"202":{"body":"All PRs must be formatted according to rustfmt, and this is checked in the continuous integration tests. You can format code locally with: $ cargo fmt at the root of the repository. You can find more information about rustfmt online too, such as how to configure your editor.","breadcrumbs":"Contributing » Coding Guidelines » rustfmt","id":"202","title":"rustfmt"},"203":{"body":"Wasmtime promotes all compiler warnings to errors in CI, meaning that the main branch will never have compiler warnings for the version of Rust that's being tested on CI. Compiler warnings change over time, however, so it's not always guaranteed that Wasmtime will build with zero warnings given an arbitrary version of Rust. If you encounter compiler warnings on your version of Rust please feel free to send a PR fixing them. During local development, however, compiler warnings are simply warnings and the build and tests can still succeed despite the presence of warnings. This can be useful because warnings are often quite prevalent in the middle of a refactoring, for example. By the time you make a PR, though, we'll require that all warnings are resolved or otherwise CI will fail and the PR cannot land. Compiler lints are controlled through the [workspace.lints.rust] table in the Cargo.toml at the root of the Wasmtime repository. A few allow-by-default lints are enabled such as trivial_numeric_casts, and you're welcome to enable more lints as applicable. Lints can additionally be enabled on a per-crate basis such as placing this in a src/lib.rs file: #![warn(trivial_numeric_casts)] Using warn here will allow local development to continue while still causing CI to promote this warning to an error.","breadcrumbs":"Contributing » Coding Guidelines » Compiler Warnings and Lints","id":"203","title":"Compiler Warnings and Lints"},"204":{"body":"All PRs are gated on cargo clippy passing for all workspace crates and targets. All clippy lints, however, are allow-by-default and thus disabled. The Wasmtime project selectively enables Clippy lints on an opt-in basis. Lints can be controlled for the entire workspace via [workspace.lints.clippy]: [workspace.lints.clippy]\n# ...\nmanual_strip = 'warn' or on a per-crate or module basis by using attributes: #![warn(clippy::manual_strip)] In Wasmtime we've found that the default set of Clippy lints is too noisy to productively use other Clippy lints, hence the allow-by-default behavior. Despite this though there are numerous useful Clippy lints which are desired for all crates or in some cases for a single crate or module. Wasmtime encourages contributors to enable Clippy lints they find useful through workspace or per-crate configuration. Like compiler warnings in the above section all Clippy warnings are turned into errors in CI. This means that cargo clippy should always produce no warnings on Wasmtime's main branch if you're using the same compiler version that CI does (typically current stable Rust). This means, however, that if you enable a new Clippy lint for the workspace you'll be required to fix the lint for all crates in the workspace to land the PR in CI. Clippy can be run locally with: $ cargo clippy --workspace --all-targets Contributors are welcome to enable new lints and send PRs for this. Feel free to reach out if you're not sure about a lint as well.","breadcrumbs":"Contributing » Coding Guidelines » Clippy","id":"204","title":"Clippy"},"205":{"body":"Wasmtime and Cranelift support the latest three stable releases of Rust. This means that if the latest version of Rust is 1.72.0 then Wasmtime supports Rust 1.70.0, 1.71.0, and 1.72.0. CI will test by default with 1.72.0 and there will be one job running the full test suite on Linux x86_64 on 1.70.0. Some of the CI jobs depend on nightly Rust, for example to run rustdoc with nightly features, however these use pinned versions in CI that are updated periodically and the general repository does not depend on nightly features. Updating Wasmtime's MSRV is done by editing the rust-version field in the workspace root's Cargo.toml","breadcrumbs":"Contributing » Coding Guidelines » Minimum Supported rustc Version","id":"205","title":"Minimum Supported rustc Version"},"206":{"body":"Wasmtime and Cranelift have a higher threshold than default for adding dependencies to the project. All dependencies are required to be \"vetted\" through the cargo vet tool . This is checked on CI and will run on all modifications to Cargo.lock. A \"vet\" for Wasmtime is not a meticulous code review of a dependency for correctness but rather it is a statement that the crate does not contain malicious code and is safe for us to run during development and (optionally) users to run when they run Wasmtime themselves. Wasmtime's vet entries are used by other organizations which means that this isn't simply for our own personal use. Wasmtime additionally uses vet entries from other organizations as well which means we don't have to vet everything ourselves. New vet entries are required to be made by trusted contributors to Wasmtime. This is all configured in the supply-chain folder of Wasmtime. These files generally aren't hand-edited though and are instead managed through the cargo vet tool itself. Note that our supply-chain/audits.toml additionally contains entries which indicates that authors are trusted as opposed to vets of individual crates. This lowers the burden of updating version of a crate from a trusted author. When put together this means that contributions to Wasmtime and Cranelift which update existing dependencies or add new dependencies will not be mergeable by default (CI will fail). This is expected from our project's configuration and this situation will be handled one of a few ways: Note that this process is not in place to prevent new dependencies or prevent updates, but rather it ensures that development of Wasmtime is done with a trusted set of code that has been reviewed by trusted parties. We welcome dependency updates and new functionality, so please don't be too alarmed when contributing and seeing a failure of cargo vet on CI!","breadcrumbs":"Contributing » Coding Guidelines » Dependencies of Wasmtime","id":"206","title":"Dependencies of Wasmtime"},"207":{"body":"If you're a contributor to Wasmtime and you've landed on this documentation, hello and thanks for your contribution! Here's some guidelines for changing the set of dependencies in Wasmtime: If a new dependency is being added it might be worth trying to slim down what's required or avoiding the dependency altogether. Avoiding new dependencies is best when reasonable, but it is not always reasonable to do so. This is left to the judgement of the author and reviewer. When updating dependencies this should be done for a specific purpose relevant to the PR-at-hand. For example if the PR implements a new feature then the dependency update should be required for the new feature. Otherwise it's best to leave dependency updates to their own PRs. It's ok to update dependencies \"just for the update\" but we prefer to have that as separate PRs. Dependency additions or updates require action on behalf of project maintainers so we ask that you don't run cargo vet yourself or update the supply-chain folder yourself. Instead a maintainer will review your PR and perform the cargo vet entries themselves. Reviewers will typically make a separate pull request to add cargo vet entries and once that lands yours will be added to the queue.","breadcrumbs":"Contributing » Coding Guidelines » cargo vet for Contributors","id":"207","title":"cargo vet for Contributors"},"208":{"body":"Maintainers of Wasmtime are required to explicitly vet and approve all dependency updates and modifications to Wasmtime. This means that when reviewing a PR you should ensure that contributors are not modifying the supply-chain directory themselves outside of commits authored by other maintainers. Otherwise though to add vet entries this is done through one of a few methods: For a PR where maintainers themselves are modifying dependencies the cargo vet entries can be included inline with the PR itself by the author. The reviewer knows that the author of the PR is themself a maintainer. PRs that \"just update dependencies\" are ok to have at any time. You can do this in preparation for a future feature or for a future contributor. This more-or-less is the same as the previous categories. For contributors who should not add vet entries themselves maintainers should review the PR and add vet entries either in a separate PR or as part of the contributor's PR itself. As a separate PR you'll check out the branch, run cargo vet, then rebase away the contributor's commits and push your cargo vet commit alone to merge. For pushing directly to the contributor's own PR be sure to read the notes below. Note for the last case it's important to ensure that if you push directly to a contributor's PR any future updates pushed by the contributor either contain or don't overwrite your vet entries. Also verify that if the PR branch is rebased or force-pushed, the details of your previously pushed vetting remain the same: e.g., versions were not bumped and descriptive reasons remain the same. If pushing a vetting commit to a contributor's PR and also asking for more changes, request that the contributor make the requested fixes in an additional commit rather than force-pushing a rewritten history, so your existing vetting commit remains untouched. These guidelines make it easier to verify no tampering has occurred.","breadcrumbs":"Contributing » Coding Guidelines » cargo vet for Maintainers","id":"208","title":"cargo vet for Maintainers"},"209":{"body":"For maintainers this is intended to document the project's policy on adding cargo vet entries. The goal of this policy is to not make dependency updates so onerous that they never happen while still achieving much of the intended benefit of cargo vet in protection against supply-chain style attacks. For dependencies that receive at least 10,000 downloads a day on crates.io it's ok to add an entry to exemptions in supply-chain/config.toml. This does not require careful review or review at all of these dependencies. The assumption here is that a supply chain attack against a popular crate is statistically likely to be discovered relatively quickly. Changes to main in Wasmtime take at least 2 weeks to be released due to our release process, so the assumption is that popular crates that are victim of a supply chain attack would be discovered during this time. This policy additionally greatly helps when updating dependencies on popular crates that are common to see without increasing the burden too much on maintainers. For other dependencies a manual vet is required. The cargo vet tool will assist in adding a vet by pointing you towards the source code, as published on crates.io, to be browsed online. Manual review should be done to ensure that \"nothing nefarious\" is happening. For example unsafe should be inspected as well as use of ambient system capabilities such as std::fs, std::net, or std::process, and build scripts. Note that you're not reviewing for correctness, instead only for whether a supply-chain attack appears to be present. This policy intends to strike a rough balance between usability and security. It's always recommended to add vet entries where possible, but the first bullet above can be used to update an exemptions entry or add a new entry. Note that when the \"popular threshold\" is used do not add a vet entry because the crate is, in fact, not vetted. This is required to go through an [[exemptions]] entry.","breadcrumbs":"Contributing » Coding Guidelines » Policy for adding cargo vet entries","id":"209","title":"Policy for adding cargo vet entries"},"21":{"body":"type : string (duration) format : \"{integer}(s | m | h | d)\" default : \"1h\" When the cache worker is notified about a cache file being updated by the cache system and this interval has already passed since last cleaning up, the worker will attempt a new cleanup. Please also refer to allowed-clock-drift-for-files-from-future .","breadcrumbs":"Using the Wasmtime CLI » Cache Configuration » Setting cleanup-interval","id":"21","title":"Setting cleanup-interval"},"210":{"body":"We use issues for asking questions ( open one here !) and tracking bugs and unimplemented features, and pull requests (PRs) for tracking and reviewing code submissions.","breadcrumbs":"Contributing » Development Process » Development Process","id":"210","title":"Development Process"},"211":{"body":"Consider opening an issue to talk about it. PRs without corresponding issues are appropriate for fairly narrow technical matters, not for fixes to user-facing bugs or for feature implementations, especially when those features might have multiple implementation strategies that usefully could be discussed. Our issue templates might help you through the process.","breadcrumbs":"Contributing » Development Process » Before submitting a PR","id":"211","title":"Before submitting a PR"},"212":{"body":"Please answer the questions in the pull request template. They are the minimum information we need to know in order to understand your changes. Write clear commit messages that start with a one-line summary of the change (and if it's difficult to summarize in one line, consider splitting the change into multiple PRs), optionally followed by additional context. Good things to mention include which areas of the code are affected, which features are affected, and anything that reviewers might want to pay special attention to. If there is code which needs explanation, prefer to put the explanation in a comment in the code, or in documentation, rather than in the commit message. Commit messages should explain why the new version is better than the old. Please include new test cases that cover your changes, if you can. If you're not sure how to do that, we'll help you during our review process. For pull requests that fix existing issues, use issue keywords . Note that not all pull requests need to have accompanying issues. When updating your pull request, please make sure to re-request review if the request has been cancelled.","breadcrumbs":"Contributing » Development Process » When submitting PRs","id":"212","title":"When submitting PRs"},"213":{"body":"We are not picky about how your git commits are structured. When we merge your PR, we will squash all of your commits into one, so it's okay if you add fixes in new commits. We appreciate it if you can organize your work into separate commits which each make one focused change, because then we can more easily understand your changes during review. But we don't require this. Once someone has reviewed your PR, it's easier for us if you don't rebase it when making further changes. Instead, at that point we prefer that you make new commits on top of the already-reviewed work. That said, sometimes we may need to ask you to rebase for various technical reasons. If you need help doing that, please ask!","breadcrumbs":"Contributing » Development Process » Focused commits or squashing","id":"213","title":"Focused commits or squashing"},"214":{"body":"Anyone may submit a pull request, and anyone may comment on or review others' pull requests. However, one review from somebody in the Core Team is required before the Core Team merges it. Even Core Team members must create PRs and get review from another Core Team member for every change, including minor work items such as version bumps, removing warnings, etc.","breadcrumbs":"Contributing » Development Process » Review and merge","id":"214","title":"Review and merge"},"215":{"body":"","breadcrumbs":"Contributing » Implementing Wasm Proposals » Implementing WebAssembly Proposals","id":"215","title":"Implementing WebAssembly Proposals"},"216":{"body":"The following checkboxes enumerate the steps required to add support for a new WebAssembly proposal to Wasmtime. They can be completed over the course of multiple pull requests. Add support to the wasmparser crate. Add support to the wat and wast crates. Add support to the wasmprinter crate. Add support to the wasm-encoder crate. Add support to the wasm-smith crate. Add a wasmtime::Config::enable_foo_bar method to the wasmtime crate. Add a --enable-foo-bar command line flag to the wasmtime binary. Enable the spec tests in build.rs but mark them as ignored for now. Stop ignoring individual spec tests and get them passing one by one. Enable the proposal in the fuzz targets . Add examples from the spec tests to the relevant corpora . The wast2json tool from WABT is useful for this. Write a custom fuzz target, oracle, and/or test case generator for fuzzing this proposal in particular. For example, we wrote a custom generator , oracle , and fuzz target for exercising table.{get,set} instructions and their interaction with GC while implementing the reference types proposal. Expose the proposal's new functionality in the wasmtime crate's API. For example, the bulk memory operations proposal introduced a table.copy instruction, and we exposed its functionality as the wasmtime::Table::copy method. Expose the proposal's new functionality in the C API. This may require extensions to the standard C API, and if so, should be defined in wasmtime.h and prefixed with wasmtime_. Use the C API to expose the proposal's new functionality in the other language embedding APIs: Python Go .NET Document support for the proposal in wasmtime/docs/stability-wasm-proposals-support.md.","breadcrumbs":"Contributing » Implementing Wasm Proposals » Adding New Support for a Wasm Proposal","id":"216","title":"Adding New Support for a Wasm Proposal"},"217":{"body":"These are the standards that must be met to enable support for a proposal by default in Wasmtime, and can be used as a review checklist. The proposal must be in phase 4, or greater, of the WebAssembly standardization process . All spec tests must be passing in Wasmtime. No open questions, design concerns, or serious known bugs. Has been fuzzed for at least a week minimum. We are confident that the fuzzers are fully exercising the proposal's functionality. For example, it would not have been enough to simply enable reference types in the compile fuzz target to enable that proposal by default. Compiling a module that uses reference types but not instantiating it nor running any of its functions doesn't exercise any of the GC implementation and does not run the inline fast paths for table operations emitted by the JIT. Exercising these things was the motivation for writing the custom fuzz target for table.{get,set} instructions. The proposal's functionality is exposed in the wasmtime crate's API. The proposal's functionality is exposed in the C API. The proposal's functionality is exposed in at least one of the other languages' APIs.","breadcrumbs":"Contributing » Implementing Wasm Proposals » Enabling Support for a Proposal by Default","id":"217","title":"Enabling Support for a Proposal by Default"},"218":{"body":"The cap-std repository contains crates which implement the capability-based version of the Rust standard library and extensions to that functionality. Once the functionality has been added to the relevant crates of that repository, they can be added into wasmtime by including them in the preview2 directory of the wasi crate . Currently, WebAssembly modules which rely on preview2 ABI cannot be directly executed by the wasmtime command. The following steps allow for testing such changes. Build wasmtime with the changes cargo build --release Create a simple Webassembly module to test the new component functionality by compiling your test code to the wasm32-wasip1 build target. Build the wasi-preview1-component-adapter as a command adapter. cargo build -p wasi-preview1-component-adapter --target wasm32-wasip1 --release --features command --no-default-features Use wasm-tools to convert the test module to a component. wasm-tools component new --adapt wasi_snapshot_preview1=wasi_snapshot_preview1.command.wasm -o component.wasm path/to/test/module Run the test component created in the previous step with the locally built wasmtime. wasmtime -W component-model=y -S preview2=y component.wasm","breadcrumbs":"Contributing » Implementing Wasm Proposals » Adding component functionality to WASI","id":"218","title":"Adding component functionality to WASI"},"219":{"body":"This section describes procedures and expectations for Core Team members. It may be of interest if you just want to understand how we work, or if you are joining the Core Team yourself.","breadcrumbs":"Contributing » Maintainer Guidelines » Maintainer Guidelines","id":"219","title":"Maintainer Guidelines"},"22":{"body":"type : string (duration) format : \"{integer}(s | m | h | d)\" default : \"30m\" When the cache worker decides to recompress a cache file, it makes sure that no other worker has started the task for this file within the last optimizing-compression-task-timeout interval. If some worker has started working on it, other workers are skipping this task. Please also refer to the allowed-clock-drift-for-files-from-future section.","breadcrumbs":"Using the Wasmtime CLI » Cache Configuration » Setting optimizing-compression-task-timeout","id":"22","title":"Setting optimizing-compression-task-timeout"},"220":{"body":"We only merge changes submitted as GitHub Pull Requests, and only after they've been approved by at least one Core Team reviewer who did not author the PR. This section covers expectations for the people performing those reviews. These guidelines are in addition to expectations which apply to everyone in the community, such as following the Code of Conduct. It is our goal to respond to every contribution in a timely fashion. Although we make no guarantees, we aim to usually provide some kind of response within about one business day. That's important because we appreciate all the contributions we receive, made by a diverse collection of people from all over the world. One way to show our appreciation, and our respect for the effort that goes into contributing to this project, is by not keeping contributors waiting. It's no fun to submit a pull request and then sit around wondering if anyone is ever going to look at it. That does not mean we will review every PR promptly, let alone merge them. Some contributions have needed weeks of discussion and changes before they were ready to merge. For some other contributions, we've had to conclude that we could not merge them, no matter how much we appreciate the effort that went into them. What this does mean is that we will communicate with each contributor to set expectations around the review process. Some examples of good communication are: \"I intend to review this but I can't yet. Please leave me a message if I haven't responded by (a specific date in the near future).\" \"I think (a specific other contributor) should review this.\" \"I'm having difficulty reviewing this PR because of (a specific reason, if it's something the contributor might reasonably be able to help with). Are you able to change that? If not, I'll ask my colleagues for help (or some other concrete resolution).\" If you are able to quickly review the PR, of course, you can just do that. You can find open Wasmtime pull requests for which your review has been requested with this search: https://github.com/bytecodealliance/wasmtime/pulls?q=is:open+type:pr+user-review-requested:@me","breadcrumbs":"Contributing » Maintainer Guidelines » Code Review » Code Review","id":"220","title":"Code Review"},"221":{"body":"We automatically assign a reviewer to every newly opened pull request. We do this to avoid the problem of diffusion of responsibility, where everyone thinks somebody else will respond to the PR, so nobody does. To be in the pool of auto-assigned reviewers, a Core Team member must commit to following the above goals and guidelines around communicating in a timely fashion. We don't ask everyone to make this commitment. In particular, we don't believe it's fair to expect quick responses from unpaid contributors, although we gratefully accept any review work they do have time to contribute. If you are in the auto-assignment pool, remember: You are not necessarily expected to review the pull requests which are assigned to you. Your only responsibility is to ensure that contributors know what to expect from us, and to arrange that somebody reviews each PR. We have several different teams that reviewers may be auto-assigned from. You should be in teams where you are likely to know who to re-assign a PR to, if you can't review it yourself. The teams are determined by the CODEOWNERS file at the root of the Wasmtime repository. But despite the name, membership in these teams is not about who is an authority or \"owner\" in a particular area. So rather than creating a team for each fine-grained division in the repository such as individual target architectures or WASI extensions, we use a few coarse-grained teams: wasmtime-compiler-reviewers : Cranelift and Winch wasmtime-core-reviewers : Wasmtime, including WASI wasmtime-fuzz-reviewers : Fuzz testing targets wasmtime-default-reviewers : Anything else, including CI and documentation Ideally, auto-assigned reviewers should be attending the regular Wasmtime or Cranelift meetings, as appropriate for the areas they're reviewing. This is to help these reviewers stay aware of who is working on what, to more easily hand off PRs to the most relevant reviewer for the work. However, this is only advice, not a hard requirement. If you are not sure who to hand off a PR review to, you can look at GitHub's suggestions for reviewers, or look at git log for the paths that the PR affects. You can also just ask other Core Team members for advice.","breadcrumbs":"Contributing » Maintainer Guidelines » Code Review » Auto-assigned reviewers","id":"221","title":"Auto-assigned reviewers"},"222":{"body":"This is a collection of general advice for people who are reviewing pull requests. Feel free to take any that you find works for you and ignore the rest. You can also open pull requests to suggest more references for this section. The Gentle Art of Patch Review suggests a \"Three-Phase Contribution Review\" process: Is the idea behind the contribution sound? Is the contribution architected correctly? Is the contribution polished? Phase one should be a quick check for whether the pull request should move forward at all, or needs a significantly different approach. If it needs significant changes or is not going to be accepted, there's no point reviewing in detail until those issues are addressed. On the other end, it's a good idea to defer reviewing for typos or bikeshedding about variable names until phase three. If there need to be significant structural changes, entire paragraphs or functions might disappear, and then any minor errors that were in them won't matter. The full essay has much more advice and is recommended reading.","breadcrumbs":"Contributing » Maintainer Guidelines » Code Review » General advice","id":"222","title":"General advice"},"223":{"body":"This is intended to serve as documentation for Wasmtime's release process. It's largely an internal checklist for those of us performing a Wasmtime release, but others might be curious in this as well!","breadcrumbs":"Contributing » Maintainer Guidelines » Release Process » Release Process","id":"223","title":"Release Process"},"224":{"body":"Major versions of Wasmtime are released once-a-month. Most of this is automatic and all that needs to be done is to merge GitHub PRs that CI will generate. At a high-level the structure of Wasmtime's release process is: On the 5th of every month a new release-X.Y.Z branch is created with the current contents of main. On the 20th of every month this release branch is published to crates.io and release artifacts are built. This means that Wasmtime releases are always at least two weeks behind development on main and additionally happen once a month. The lag time behind main is intended to give time to fuzz changes on main as well as allow testing for any users using main. It's expected, though, that most consumers will likely use the release branches of wasmtime. A detailed list of all the steps in the release automation process are below. The steps requiring interactions are bolded , otherwise everything else is automatic and this is documenting what automation does. On the 5th of every month, (configured via .github/workflows/release-process.yml) a CI job will run and do these steps: Download the current main branch Push the main branch to release-X.Y.Z Run ./scripts/publish.rs with the bump argument Commit the changes Push these changes to a temporary ci/* branch Open a PR with this branch against main This step can also be triggered manually with the main branch and the cut argument. A maintainer of Wasmtime merges this PR It's intended that this PR can be immediately merged as the release branch has been created and all it's doing is bumping the version. Time passes and the release-X.Y.Z branch is maintained All changes land on main first, then are backported to release-X.Y.Z as necessary. On the 20th of every month (same CI job as before) another CI job will run performing: Reset to release-X.Y.Z Update the release date of X.Y.Z to today in RELEASES.md Add a special marker to the commit message to indicate a tag should be made. Open a PR against release-X.Y.Z for this change This step can also be triggered manually with the main branch and the release-latest argument. A maintainer of Wasmtime merges this PR When merged, will trigger the next steps due to the marker in the commit message. A maintainer should double-check there are no open security issues , but otherwise it's expected that all other release issues are resolved by this point. The main CI workflow at .github/workflow/main.yml has special logic at the end such that pushes to the release-* branch will scan the git logs of pushed changes for the special marker added by release-process.yml. If found and CI passes a tag is created and pushed. Once a tag is created the .github/workflows/publish-* workflows run. One publishes all crates as-is to crates.io and the other will download all artifacts from the main.yml workflow and then upload them all as an official release . If all goes well you won't have to read up much on this and after hitting the Big Green Button for the automatically created PRs everything will merrily carry on its way.","breadcrumbs":"Contributing » Maintainer Guidelines » Release Process » Releasing a major version","id":"224","title":"Releasing a major version"},"225":{"body":"Making a patch release is somewhat more manual than a major version, but like before there's automation to help guide the process as well and take care of more mundane bits. This is a list of steps taken to perform a patch release for 2.0.1 for example. Like above human interaction is indicated with bold text in these steps. Necessary changes are backported to the release-2.0.0 branch from main All changes must land on main first (if applicable) and then get backported to an older branch. Release branches should already exist from the above major release steps. CI may not have been run in some time for release branches so it may be necessary to backport CI fixes and updates from main as well. When merging backports maintainers need to double-check that the PUBLIC_CRATES listed in scripts/publish.rs do not have semver-API-breaking changes (in the strictest sense). All security fixes must be done in such a way that the API doesn't break between the patch version and the original version. Don't forget to write patch notes in RELEASES.md for backported changes. The patch release process is triggered manually with the release-2.0.0 branch and the release-patch argument This will run the release-process.yml workflow. The scripts/publish.rs script will be run with the bump-patch argument. The changes will be committed with a special marker indicating a release needs to be made. A PR will be created from a temporary ci/* branch to the release-2.0.0 branch which, when merged, will trigger the release process. Review the generated PR and merge it This will resume from step 6 above in the major release process where the special marker in the commit message generated by CI will trigger a tag to get pushed which will further trigger the rest of the release process. Please make sure to update the RELEASES.md at this point to include the Released on date by pushing directly to the branch associated with the PR.","breadcrumbs":"Contributing » Maintainer Guidelines » Release Process » Releasing a patch version","id":"225","title":"Releasing a patch version"},"226":{"body":"When making a patch release that has a security-related fix the contents of the patch are often kept private until the day of the patch release which means that the process here is slightly different from the patch release process above. In addition the precise runbook is currently under discussion in an RFC for security patches, so this intends to document what we've been doing so far and it'll get updated when the runbook is merged. The fix for the security issue is developed in a GitHub Security Advisory This will not have any CI run, it's recommended to run ./ci/run-tests.sh locally at least. Develop fixes for all branches that will get a patch release in the advisory, one PR per branch. When the advisory is published all branches will be merged simultaneously. Be sure to run ./ci/run-tests.sh in each branch. Don't forget to update RELEASES.md with notes about the release on each branch. Send a PR for the version bump when an email goes out announcing there will be a security release An email is sent to the bytecodealliance security mailing list ahead of a patch release to announce that a patch release will happen. At this time you should trigger the version bump against the appropriate release-x.y.z branches with the release-patch argument. This will send a PR, but you should not merge it. Instead use this PR and the time ahead of the security release to fix any issues with CI. Older release-x.y.z branches haven't run CI in awhile so they may need to backport fixes of one variety or another. DO NOT include the actual fix for the security issue into the PR, that comes in the next step. Make the advisories/patches public Publishing the GitHub Security Advisory will merge all the PRs into each branch from the advisory. Note that CI will run for release branches but main will probably fail CI since it expected to be merged through the merge queue, but that's ok. Double-check that CI for release branches finishes and completes successfully. Merge the version-bump PR Like the patch release process this will kick everything else into motion. Note that the actual security fixes should be merged either before or as part of this PR.","breadcrumbs":"Contributing » Maintainer Guidelines » Release Process » Releasing a security patch","id":"226","title":"Releasing a security patch"},"227":{"body":"Release notes for Wasmtime are written in the RELEASES.md file in the root of the repository. Management of this file looks like: (theoretically) All changes on main which need to write an entry in RELEASES.md. When the main branch gets a version the RELEASES.md file is emptied and replaced with ci/RELEASES-template.md. An entry for the upcoming release is added to the bulleted list at the bottom. (realistically) After a release-X.Y.Z branch is created release notes are updated and edited on the release branch. This means that RELEASES.md only has release notes for the release branch that it is on. Historical release notes can be found through links at the bottom to previous copies of RELEASES.md","breadcrumbs":"Contributing » Maintainer Guidelines » Release Process » Releasing Notes","id":"227","title":"Releasing Notes"},"228":{"body":"... more coming soon","breadcrumbs":"Contributing » Governance » Governance","id":"228","title":"Governance"},"229":{"body":"Note : this Code of Conduct pertains to individuals' behavior. Please also see the Organizational Code of Conduct .","breadcrumbs":"Contributing » Code of Conduct » Contributor Covenant Code of Conduct","id":"229","title":"Contributor Covenant Code of Conduct"},"23":{"body":"type : string (duration) format : \"{integer}(s | m | h | d)\" default : \"1d\"","breadcrumbs":"Using the Wasmtime CLI » Cache Configuration » Setting allowed-clock-drift-for-files-from-future","id":"23","title":"Setting allowed-clock-drift-for-files-from-future"},"230":{"body":"In the interest of fostering an open and welcoming environment, we as contributors and maintainers pledge to making participation in our project and our community a harassment-free experience for everyone, regardless of age, body size, disability, ethnicity, gender identity and expression, level of experience, nationality, personal appearance, race, religion, or sexual identity and orientation.","breadcrumbs":"Contributing » Code of Conduct » Our Pledge","id":"230","title":"Our Pledge"},"231":{"body":"Examples of behavior that contributes to creating a positive environment include: Using welcoming and inclusive language Being respectful of differing viewpoints and experiences Gracefully accepting constructive criticism Focusing on what is best for the community Showing empathy towards other community members Examples of unacceptable behavior by participants include: The use of sexualized language or imagery and unwelcome sexual attention or advances Trolling, insulting/derogatory comments, and personal or political attacks Public or private harassment Publishing others' private information, such as a physical or electronic address, without explicit permission Other conduct which could reasonably be considered inappropriate in a professional setting","breadcrumbs":"Contributing » Code of Conduct » Our Standards","id":"231","title":"Our Standards"},"232":{"body":"Project maintainers are responsible for clarifying the standards of acceptable behavior and are expected to take appropriate and fair corrective action in response to any instances of unacceptable behavior. Project maintainers have the right and responsibility to remove, edit, or reject comments, commits, code, wiki edits, issues, and other contributions that are not aligned to this Code of Conduct, or to ban temporarily or permanently any contributor for other behaviors that they deem inappropriate, threatening, offensive, or harmful.","breadcrumbs":"Contributing » Code of Conduct » Our Responsibilities","id":"232","title":"Our Responsibilities"},"233":{"body":"This Code of Conduct applies both within project spaces and in public spaces when an individual is representing the project or its community. Examples of representing a project or community include using an official project e-mail address, posting via an official social media account, or acting as an appointed representative at an online or offline event. Representation of a project may be further defined and clarified by project maintainers.","breadcrumbs":"Contributing » Code of Conduct » Scope","id":"233","title":"Scope"},"234":{"body":"Instances of abusive, harassing, or otherwise unacceptable behavior may be reported by contacting the Bytecode Alliance CoC team at report@bytecodealliance.org . The CoC team will review and investigate all complaints, and will respond in a way that it deems appropriate to the circumstances. The CoC team is obligated to maintain confidentiality with regard to the reporter of an incident. Further details of specific enforcement policies may be posted separately. Project maintainers who do not follow or enforce the Code of Conduct in good faith may face temporary or permanent repercussions as determined by other members of the Bytecode Alliance's leadership.","breadcrumbs":"Contributing » Code of Conduct » Enforcement","id":"234","title":"Enforcement"},"235":{"body":"This Code of Conduct is adapted from the Contributor Covenant , version 1.4, available at http://contributor-covenant.org/version/1/4","breadcrumbs":"Contributing » Code of Conduct » Attribution","id":"235","title":"Attribution"},"24":{"body":"When the cache worker attempts acquiring a lock for some task, it checks if some other worker has already acquired such a lock. To be fault tolerant and eventually execute every task, the locks expire after some interval. However, because of clock drifts and different timezones, it would happen that some lock was created in the future. This setting defines a tolerance limit for these locks. If the time has been changed in the system (i.e. two years backwards), the cache system should still work properly. Thus, these locks will be treated as expired (assuming the tolerance is not too big).","breadcrumbs":"Using the Wasmtime CLI » Cache Configuration » Locks","id":"24","title":"Locks"},"25":{"body":"Similarly to the locks, the cache files or their metadata might have modification time in distant future. The cache system tries to keep these files as long as possible. If the limits are not reached, the cache files will not be deleted. Otherwise, they will be treated as the oldest files, so they might survive. If the user actually uses the cache file, the modification time will be updated.","breadcrumbs":"Using the Wasmtime CLI » Cache Configuration » Cache files","id":"25","title":"Cache files"},"26":{"body":"type : string (SI prefix) format : \"{integer}(K | M | G | T | P)?\" default : \"65536\" Soft limit for the file count in the cache directory. This doesn't include files with metadata. To learn more, please refer to the cache system section.","breadcrumbs":"Using the Wasmtime CLI » Cache Configuration » Setting file-count-soft-limit","id":"26","title":"Setting file-count-soft-limit"},"27":{"body":"type : string (disk space) format : \"{integer}(K | Ki | M | Mi | G | Gi | T | Ti | P | Pi)?\" default : \"512Mi\" Soft limit for the total size* of files in the cache directory. This doesn't include files with metadata. To learn more, please refer to the cache system section. *this is the file size, not the space physically occupied on the disk.","breadcrumbs":"Using the Wasmtime CLI » Cache Configuration » Setting files-total-size-soft-limit","id":"27","title":"Setting files-total-size-soft-limit"},"28":{"body":"type : string (percent) format : \"{integer}%\" default : \"70%\" If file-count-soft-limit is exceeded and the cache worker performs the cleanup task, then the worker will delete some cache files, so after the task, the file count should not exceed file-count-soft-limit * file-count-limit-percent-if-deleting . This doesn't include files with metadata. To learn more, please refer to the cache system section.","breadcrumbs":"Using the Wasmtime CLI » Cache Configuration » Setting file-count-limit-percent-if-deleting","id":"28","title":"Setting file-count-limit-percent-if-deleting"},"29":{"body":"type : string (percent) format : \"{integer}%\" default : \"70%\" If files-total-size-soft-limit is exceeded and cache worker performs the cleanup task, then the worker will delete some cache files, so after the task, the files total size should not exceed files-total-size-soft-limit * files-total-size-limit-percent-if-deleting . This doesn't include files with metadata. To learn more, please refer to the cache system section.","breadcrumbs":"Using the Wasmtime CLI » Cache Configuration » Setting files-total-size-limit-percent-if-deleting","id":"29","title":"Setting files-total-size-limit-percent-if-deleting"},"3":{"body":"If you'd prefer to not use an installation script, or you're perhaps orchestrating something in CI, you can also download one of our precompiled binaries of wasmtime. We have two channels of releases right now for precompiled binaries: Each tagged release will have a full set of release artifacts on the GitHub releases page . The dev release is also continuously updated with the latest build of the main branch. If you want the latest-and-greatest and don't mind a bit of instability, this is the release for you. When downloading binaries you'll likely want one of the following archives (for the dev release) Linux users - [wasmtime-dev-x86_64-linux.tar.xz] macOS users - [wasmtime-dev-x86_64-macos.tar.xz] Windows users - [wasmtime-dev-x86_64-windows.zip] Each of these archives has a wasmtime binary placed inside which can be executed normally as the CLI would.","breadcrumbs":"Using the Wasmtime CLI » Installation » Download Precompiled Binaries","id":"3","title":"Download Precompiled Binaries"},"30":{"body":"This is an implementation detail and might change in the future. Information provided here is meant to help understanding the big picture and configuring the cache. There are two main components - the cache system and the cache worker .","breadcrumbs":"Using the Wasmtime CLI » Cache Configuration » How does the cache work?","id":"30","title":"How does the cache work?"},"31":{"body":"Handles GET and UPDATE cache requests. GET request - simply loads the cache from disk if it is there. UPDATE request - compresses received data with zstd and baseline-compression-level , then writes the data to the disk. In case of successful handling of a request, it notifies the cache worker about this event using the queue. The queue has a limited size of worker-event-queue-size . If it is full, it will drop new events until the cache worker pops some event from the queue.","breadcrumbs":"Using the Wasmtime CLI » Cache Configuration » Cache system","id":"31","title":"Cache system"},"32":{"body":"The cache worker runs in a single thread with lower priority and pops events from the queue in a loop handling them one by one.","breadcrumbs":"Using the Wasmtime CLI » Cache Configuration » Cache worker","id":"32","title":"Cache worker"},"33":{"body":"Read the statistics file for the cache file, increase the usage counter and write it back to the disk. Attempt recompressing the cache file if all of the following conditions are met: usage counter exceeds optimized-compression-usage-counter-threshold , the file is compressed with compression level lower than optimized-compression-level , no other worker has started working on this particular task within the last optimizing-compression-task-timeout interval. When recompressing, optimized-compression-level is used as a compression level.","breadcrumbs":"Using the Wasmtime CLI » Cache Configuration » On GET request","id":"33","title":"On GET request"},"34":{"body":"Write a fresh statistics file for the cache file. Clean up the cache if no worker has attempted to do this within the last cleanup-interval . During this task: all unrecognized files and expired task locks in cache directory will be deleted if file-count-soft-limit or files-total-size-soft-limit is exceeded, then recognized files will be deleted according to file-count-limit-percent-if-deleting and files-total-size-limit-percent-if-deleting . Wasmtime uses Least Recently Used (LRU) cache replacement policy and requires that the filesystem maintains proper mtime (modification time) of the files. Files with future mtimes are treated specially - more details in allowed-clock-drift-for-files-from-future .","breadcrumbs":"Using the Wasmtime CLI » Cache Configuration » On UPDATE request","id":"34","title":"On UPDATE request"},"35":{"body":"every cached WebAssembly module has its own statistics file every lock is a file","breadcrumbs":"Using the Wasmtime CLI » Cache Configuration » Metadata files","id":"35","title":"Metadata files"},"36":{"body":"Wasmtime can be used as a library to embed WebAssembly execution support within applications. Wasmtime is written in Rust, but bindings are available through a C API for a number of other languages too: Rust C Python .NET Go Bash Ruby Elixir","breadcrumbs":"Using the Wasmtime API » Using the Wasmtime API","id":"36","title":"Using the Wasmtime API"},"37":{"body":"This document shows an example of how to embed Wasmtime using the Rust API to execute a simple wasm program. Be sure to also check out the full API documentation for a full listing of what the wasmtime crate has to offer.","breadcrumbs":"Using the Wasmtime API » Rust » Using WebAssembly from Rust","id":"37","title":"Using WebAssembly from Rust"},"38":{"body":"We'll just assume that you've already got a wasm file on hand for the rest of this tutorial. To make things simple we'll also just assume you've got a hello.wat file which looks like this: (module (func (export \"answer\") (result i32) i32.const 42 )\n) Here we're just exporting one function which returns an integer that we'll read from Rust.","breadcrumbs":"Using the Wasmtime API » Rust » Creating the WebAssembly to execute","id":"38","title":"Creating the WebAssembly to execute"},"39":{"body":"First up let's create a rust project $ cargo new --bin wasmtime_hello\n$ cd wasmtime_hello Next you'll want to add hello.wat to the root of your project. We will be using the wasmtime crate to run the wasm file. Please execute the command cargo add wasmtime to use the latest version of the crate. The dependencies block in the Cargo.toml file will appear as follows: [dependencies]\nwasmtime = \"19.0.0\" Next up let's write the code that we need to execute this wasm file. The simplest version of this looks like so: # extern crate wasmtime;\nuse std::error::Error;\nuse wasmtime::*; fn main() -> Result<(), Box<dyn Error>> { // An engine stores and configures global compilation settings like // optimization level, enabled wasm features, etc. let engine = Engine::default(); # if false { // We start off by creating a `Module` which represents a compiled form // of our input wasm module. In this case it'll be JIT-compiled after // we parse the text format. let module = Module::from_file(&engine, \"hello.wat\")?;\n# }\n# let module = Module::new(&engine, r#\"(module (func (export \"answer\") (result i32) i32.const 42))\"#)?; // A `Store` is what will own instances, functions, globals, etc. All wasm // items are stored within a `Store`, and it's what we'll always be using to // interact with the wasm world. Custom data can be stored in stores but for // now we just use `()`. let mut store = Store::new(&engine, ()); // With a compiled `Module` we can then instantiate it, creating // an `Instance` which we can actually poke at functions on. let instance = Instance::new(&mut store, &module, &[])?; // The `Instance` gives us access to various exported functions and items, // which we access here to pull out our `answer` exported function and // run it. let answer = instance.get_func(&mut store, \"answer\") .expect(\"`answer` was not an exported function\"); // There's a few ways we can call the `answer` `Func` value. The easiest // is to statically assert its signature with `typed` (in this case // asserting it takes no arguments and returns one i32) and then call it. let answer = answer.typed::<(), i32>(&store)?; // And finally we can call our function! Note that the error propagation // with `?` is done to handle the case where the wasm function traps. let result = answer.call(&mut store, ())?; println!(\"Answer: {:?}\", result); Ok(())\n} We can build and execute our example with cargo run. Note that by depending on wasmtime you're depending on a JIT compiler, so it may take a moment to build all of its dependencies: $ cargo run Compiling ... ... Finished dev [unoptimized + debuginfo] target(s) in 42.32s Running `wasmtime_hello/target/debug/wasmtime_hello`\nAnswer: 42 and there we go! We've now executed our first WebAssembly in wasmtime and gotten the result back.","breadcrumbs":"Using the Wasmtime API » Rust » Hello, World!","id":"39","title":"Hello, World!"},"4":{"body":"If you'd prefer to compile the wasmtime CLI from source, you'll want to consult the contributing documentation for building . Be sure to use a --release build if you're curious to do benchmarking!","breadcrumbs":"Using the Wasmtime CLI » Installation » Compiling from Source","id":"4","title":"Compiling from Source"},"40":{"body":"What we've just seen is a pretty small example of how to call a wasm function and take a look at the result. Most interesting wasm modules, however, are going to import some functions to do something a bit more interesting. For that you'll need to provide imported functions from Rust for wasm to call! Let's take a look at a wasm module which imports a logging function as well as some simple arithmetic from the environment. (module (import \"\" \"log\" (func $log (param i32))) (import \"\" \"double\" (func $double (param i32) (result i32))) (func (export \"run\") i32.const 0 call $log i32.const 1 call $log i32.const 2 call $double call $log )\n) This wasm module will call our \"log\" import a few times and then also call the \"double\" import. We can compile and instantiate this module with code that looks like this: # extern crate wasmtime;\nuse std::error::Error;\nuse wasmtime::*; struct Log { integers_logged: Vec<u32>,\n} fn main() -> Result<(), Box<dyn Error>> { let engine = Engine::default();\n# if false { let module = Module::from_file(&engine, \"hello.wat\")?;\n# }\n# let module = Module::new(&engine, r#\"(module (import \"\" \"log\" (func $log (param i32))) (import \"\" \"double\" (func $double (param i32) (result i32))) (func (export \"run\") i32.const 0 call $log i32.const 1 call $log i32.const 2 call $double call $log))\"#)?; // For host-provided functions it's recommended to use a `Linker` which does // name-based resolution of functions. let mut linker = Linker::new(&engine); // First we create our simple \"double\" function which will only multiply its // input by two and return it. linker.func_wrap(\"\", \"double\", |param: i32| param * 2)?; // Next we define a `log` function. Note that we're using a // Wasmtime-provided `Caller` argument to access the state on the `Store`, // which allows us to record the logged information. linker.func_wrap(\"\", \"log\", |mut caller: Caller<'_, Log>, param: u32| { println!(\"log: {}\", param); caller.data_mut().integers_logged.push(param); })?; // As above, instantiation always happens within a `Store`. This means to // actually instantiate with our `Linker` we'll need to create a store. Note // that we're also initializing the store with our custom data here too. // // Afterwards we use the `linker` to create the instance. let data = Log { integers_logged: Vec::new() }; let mut store = Store::new(&engine, data); let instance = linker.instantiate(&mut store, &module)?; // Like before, we can get the run function and execute it. let run = instance.get_typed_func::<(), ()>(&mut store, \"run\")?; run.call(&mut store, ())?; // We can also inspect what integers were logged: println!(\"logged integers: {:?}\", store.data().integers_logged); Ok(())\n} Note that there's a number of ways to define a Func, be sure to consult its documentation for other ways to create a host-defined function.","breadcrumbs":"Using the Wasmtime API » Rust » Importing Host Functionality","id":"40","title":"Importing Host Functionality"},"41":{"body":"You can also browse this source code online and clone the wasmtime repository to run the example locally. This example shows off how to instantiate a simple wasm module and interact with it. For more information about the types used here be sure to review the core concepts of the wasmtime API as well as the general API documentation .","breadcrumbs":"Using the Wasmtime API » Rust » Hello, world! » Hello, world!","id":"41","title":"Hello, world!"},"42":{"body":"(module (func $hello (import \"\" \"hello\")) (func (export \"run\") (call $hello))\n)","breadcrumbs":"Using the Wasmtime API » Rust » Hello, world! » hello.wat","id":"42","title":"hello.wat"},"43":{"body":"//! Small example of how to instantiate a wasm module that imports one function,\n//! showing how you can fill in host functionality for a wasm module. // You can execute this example with `cargo run --example hello` use wasmtime::*; struct MyState { name: String, count: usize,\n} fn main() -> Result<()> { // First the wasm module needs to be compiled. This is done with a global // \"compilation environment\" within an `Engine`. Note that engines can be // further configured through `Config` if desired instead of using the // default like this is here. println!(\"Compiling module...\"); let engine = Engine::default(); let module = Module::from_file(&engine, \"examples/hello.wat\")?; // After a module is compiled we create a `Store` which will contain // instantiated modules and other items like host functions. A Store // contains an arbitrary piece of host information, and we use `MyState` // here. println!(\"Initializing...\"); let mut store = Store::new( &engine, MyState { name: \"hello, world!\".to_string(), count: 0, }, ); // Our wasm module we'll be instantiating requires one imported function. // the function takes no parameters and returns no results. We create a host // implementation of that function here, and the `caller` parameter here is // used to get access to our original `MyState` value. println!(\"Creating callback...\"); let hello_func = Func::wrap(&mut store, |mut caller: Caller<'_, MyState>| { println!(\"Calling back...\"); println!(\"> {}\", caller.data().name); caller.data_mut().count += 1; }); // Once we've got that all set up we can then move to the instantiation // phase, pairing together a compiled module as well as a set of imports. // Note that this is where the wasm `start` function, if any, would run. println!(\"Instantiating module...\"); let imports = [hello_func.into()]; let instance = Instance::new(&mut store, &module, &imports)?; // Next we poke around a bit to extract the `run` function from the module. println!(\"Extracting export...\"); let run = instance.get_typed_func::<(), ()>(&mut store, \"run\")?; // And last but not least we can call it! println!(\"Calling export...\"); run.call(&mut store, ())?; println!(\"Done.\"); Ok(())\n}","breadcrumbs":"Using the Wasmtime API » Rust » Hello, world! » hello.rs","id":"43","title":"hello.rs"},"44":{"body":"You can also browse this source code online and clone the wasmtime repository to run the example locally. This example shows off how run a wasm program which calculates the GCD of two numbers.","breadcrumbs":"Using the Wasmtime API » Rust » Calculating the GCD » Calculating the GCD","id":"44","title":"Calculating the GCD"},"45":{"body":"(module (func $gcd (param i32 i32) (result i32) (local i32) block ;; label = @1 block ;; label = @2 local.get 0 br_if 0 (;@2;) local.get 1 local.set 2 br 1 (;@1;) end loop ;; label = @2 local.get 1 local.get 0 local.tee 2 i32.rem_u local.set 0 local.get 2 local.set 1 local.get 0 br_if 0 (;@2;) end end local.get 2 ) (export \"gcd\" (func $gcd))\n)","breadcrumbs":"Using the Wasmtime API » Rust » Calculating the GCD » gcd.wat","id":"45","title":"gcd.wat"},"46":{"body":"//! Example of instantiating of the WebAssembly module and invoking its exported\n//! function. // You can execute this example with `cargo run --example gcd` use wasmtime::*; fn main() -> Result<()> { // Load our WebAssembly (parsed WAT in our case), and then load it into a // `Module` which is attached to a `Store` cache. After we've got that we // can instantiate it. let mut store = Store::<()>::default(); let module = Module::from_file(store.engine(), \"examples/gcd.wat\")?; let instance = Instance::new(&mut store, &module, &[])?; // Invoke `gcd` export let gcd = instance.get_typed_func::<(i32, i32), i32>(&mut store, \"gcd\")?; println!(\"gcd(6, 27) = {}\", gcd.call(&mut store, (6, 27))?); Ok(())\n}","breadcrumbs":"Using the Wasmtime API » Rust » Calculating the GCD » gcd.rs","id":"46","title":"gcd.rs"},"47":{"body":"You can also browse this source code online and clone the wasmtime repository to run the example locally. This example shows off how to interact with wasm memory in a module. Be sure to read the documentation for Memory as well.","breadcrumbs":"Using the Wasmtime API » Rust » Using Linear Memory » Using linear memory","id":"47","title":"Using linear memory"},"48":{"body":"(module (memory (export \"memory\") 2 3) (func (export \"size\") (result i32) (memory.size)) (func (export \"load\") (param i32) (result i32) (i32.load8_s (local.get 0)) ) (func (export \"store\") (param i32 i32) (i32.store8 (local.get 0) (local.get 1)) ) (data (i32.const 0x1000) \"\\01\\02\\03\\04\")\n)","breadcrumbs":"Using the Wasmtime API » Rust » Using Linear Memory » memory.wat","id":"48","title":"memory.wat"},"49":{"body":"//! An example of how to interact with wasm memory.\n//!\n//! Here a small wasm module is used to show how memory is initialized, how to\n//! read and write memory through the `Memory` object, and how wasm functions\n//! can trap when dealing with out-of-bounds addresses. // You can execute this example with `cargo run --example memory` use wasmtime::*; fn main() -> Result<()> { // Create our `store_fn` context and then compile a module and create an // instance from the compiled module all in one go. let mut store: Store<()> = Store::default(); let module = Module::from_file(store.engine(), \"examples/memory.wat\")?; let instance = Instance::new(&mut store, &module, &[])?; // load_fn up our exports from the instance let memory = instance .get_memory(&mut store, \"memory\") .ok_or(anyhow::format_err!(\"failed to find `memory` export\"))?; let size = instance.get_typed_func::<(), i32>(&mut store, \"size\")?; let load_fn = instance.get_typed_func::<i32, i32>(&mut store, \"load\")?; let store_fn = instance.get_typed_func::<(i32, i32), ()>(&mut store, \"store\")?; println!(\"Checking memory...\"); assert_eq!(memory.size(&store), 2); assert_eq!(memory.data_size(&store), 0x20000); assert_eq!(memory.data_mut(&mut store)[0], 0); assert_eq!(memory.data_mut(&mut store)[0x1000], 1); assert_eq!(memory.data_mut(&mut store)[0x1003], 4); assert_eq!(size.call(&mut store, ())?, 2); assert_eq!(load_fn.call(&mut store, 0)?, 0); assert_eq!(load_fn.call(&mut store, 0x1000)?, 1); assert_eq!(load_fn.call(&mut store, 0x1003)?, 4); assert_eq!(load_fn.call(&mut store, 0x1ffff)?, 0); assert!(load_fn.call(&mut store, 0x20000).is_err()); // out of bounds trap println!(\"Mutating memory...\"); memory.data_mut(&mut store)[0x1003] = 5; store_fn.call(&mut store, (0x1002, 6))?; assert!(store_fn.call(&mut store, (0x20000, 0)).is_err()); // out of bounds trap assert_eq!(memory.data(&store)[0x1002], 6); assert_eq!(memory.data(&store)[0x1003], 5); assert_eq!(load_fn.call(&mut store, 0x1002)?, 6); assert_eq!(load_fn.call(&mut store, 0x1003)?, 5); // Grow memory. println!(\"Growing memory...\"); memory.grow(&mut store, 1)?; assert_eq!(memory.size(&store), 3); assert_eq!(memory.data_size(&store), 0x30000); assert_eq!(load_fn.call(&mut store, 0x20000)?, 0); store_fn.call(&mut store, (0x20000, 0))?; assert!(load_fn.call(&mut store, 0x30000).is_err()); assert!(store_fn.call(&mut store, (0x30000, 0)).is_err()); assert!(memory.grow(&mut store, 1).is_err()); assert!(memory.grow(&mut store, 0).is_ok()); println!(\"Creating stand-alone memory...\"); let memorytype = MemoryType::new(5, Some(5)); let memory2 = Memory::new(&mut store, memorytype)?; assert_eq!(memory2.size(&store), 5); assert!(memory2.grow(&mut store, 1).is_err()); assert!(memory2.grow(&mut store, 0).is_ok()); Ok(())\n}","breadcrumbs":"Using the Wasmtime API » Rust » Using Linear Memory » memory.rs","id":"49","title":"memory.rs"},"5":{"body":"The wasmtime CLI is organized into a few subcommands. If no subcommand is provided it'll assume run, which is to execute a wasm file. The subcommands supported by wasmtime are:","breadcrumbs":"Using the Wasmtime CLI » CLI Options » CLI Options for wasmtime","id":"5","title":"CLI Options for wasmtime"},"50":{"body":"You can also browse this source code online and clone the wasmtime repository to run the example locally. This example shows how to use the wasi-common crate to define WASI functions within a Linker which can then be used to instantiate a WebAssembly module.","breadcrumbs":"Using the Wasmtime API » Rust » WASI » WASI","id":"50","title":"WASI"},"51":{"body":"For this WASI example, this Hello World program is compiled to a WebAssembly module using the WASI Preview 1 API. wasi.rs fn main() { println!(\"Hello, world!\");\n} Building this program generates target/wasm32-wasip1/debug/wasi.wasm, used below.","breadcrumbs":"Using the Wasmtime API » Rust » WASI » WebAssembly module source code","id":"51","title":"WebAssembly module source code"},"52":{"body":"This example shows adding and configuring the WASI imports to invoke the above WASM module. main.rs //! Example of instantiating a wasm module which uses WASI imports. /*\nYou can execute this example with: cmake examples/ cargo run --example wasi\n*/ use wasi_common::sync::WasiCtxBuilder;\nuse wasmtime::*; fn main() -> Result<()> { // Define the WASI functions globally on the `Config`. let engine = Engine::default(); let mut linker = Linker::new(&engine); wasi_common::sync::add_to_linker(&mut linker, |s| s)?; // Create a WASI context and put it in a Store; all instances in the store // share this context. `WasiCtxBuilder` provides a number of ways to // configure what the target program will have access to. let wasi = WasiCtxBuilder::new() .inherit_stdio() .inherit_args()? .build(); let mut store = Store::new(&engine, wasi); // Instantiate our module with the imports we've created, and run it. let module = Module::from_file(&engine, \"target/wasm32-wasip1/debug/wasi.wasm\")?; linker.module(&mut store, \"\", &module)?; linker .get_default(&mut store, \"\")? .typed::<(), ()>(&store)? .call(&mut store, ())?; Ok(())\n}","breadcrumbs":"Using the Wasmtime API » Rust » WASI » Invoke the WASM module","id":"52","title":"Invoke the WASM module"},"53":{"body":"The add_to_linker takes a second argument which is a closure to access &mut WasiCtx from within the T stored in the Store<T> itself. In the above example this is trivial because the T in Store<T> is WasiCtx itself, but you can also store other state in Store like so: # extern crate wasmtime;\n# extern crate wasi_common;\n# extern crate anyhow;\nuse anyhow::Result;\nuse std::borrow::{Borrow, BorrowMut};\nuse wasmtime::*;\nuse wasi_common::{WasiCtx, sync::WasiCtxBuilder}; struct MyState { message: String, wasi: WasiCtx,\n} fn main() -> Result<()> { let engine = Engine::default(); let mut linker = Linker::new(&engine); wasi_common::sync::add_to_linker(&mut linker, |state: &mut MyState| &mut state.wasi)?; let wasi = WasiCtxBuilder::new() .inherit_stdio() .inherit_args()? .build(); let mut store = Store::new(&engine, MyState { message: format!(\"hello!\"), wasi, }); // ... # let _linker: Linker<MyState> = linker; Ok(())\n}","breadcrumbs":"Using the Wasmtime API » Rust » WASI » WASI state with other custom host state","id":"53","title":"WASI state with other custom host state"},"54":{"body":"An experimental implementation of the WASI Preview 2 API is also available, along with an adapter layer for WASI Preview 1 WebAssembly modules. In future this preview2 API will become the default. There are some features which are currently only accessible through the preview2 API such as async support and overriding the clock and random implementations.","breadcrumbs":"Using the Wasmtime API » Rust » WASI » WASI Preview 2","id":"54","title":"WASI Preview 2"},"55":{"body":"This async example code shows how to use the wasmtime-wasi::preview2 module to execute the same WASI Preview 1 WebAssembly module from the example above. This example requires the wasmtime crate async feature to be enabled. This does not require any change to the WebAssembly module, it's just the WASI API host functions which are implemented to be async. See wasmtime async support . //! Example of instantiating a wasm module which uses WASI preview1 imports\n//! implemented through the async preview2 WASI implementation. /*\nYou can execute this example with: cmake examples/ cargo run --example wasi-async\n*/ use anyhow::Result;\nuse wasmtime::{Config, Engine, Linker, Module, Store};\nuse wasmtime_wasi::preview1::{self, WasiP1Ctx};\nuse wasmtime_wasi::WasiCtxBuilder; #[tokio::main]\nasync fn main() -> Result<()> { // Construct the wasm engine with async support enabled. let mut config = Config::new(); config.async_support(true); let engine = Engine::new(&config)?; // Add the WASI preview1 API to the linker (will be implemented in terms of // the preview2 API) let mut linker: Linker<WasiP1Ctx> = Linker::new(&engine); preview1::add_to_linker_async(&mut linker, |t| t)?; // Add capabilities (e.g. filesystem access) to the WASI preview2 context // here. Here only stdio is inherited, but see docs of `WasiCtxBuilder` for // more. let wasi_ctx = WasiCtxBuilder::new().inherit_stdio().build_p1(); let mut store = Store::new(&engine, wasi_ctx); // Instantiate our 'Hello World' wasm module. // Note: This is a module built against the preview1 WASI API. let module = Module::from_file(&engine, \"target/wasm32-wasip1/debug/wasi.wasm\")?; let func = linker .module_async(&mut store, \"\", &module) .await? .get_default(&mut store, \"\")? .typed::<(), ()>(&store)?; // Invoke the WASI program default function. func.call_async(&mut store, ()).await?; Ok(())\n} You can also browse this source code online and clone the wasmtime repository to run the example locally.","breadcrumbs":"Using the Wasmtime API » Rust » WASI » Async example","id":"55","title":"Async example"},"56":{"body":"You can also browse this source code online and clone the wasmtime repository to run the example locally. This example shows off how to compile and instantiate modules which link together. Be sure to read the API documentation for Linker as well.","breadcrumbs":"Using the Wasmtime API » Rust » Linking Modules » Linking modules","id":"56","title":"Linking modules"},"57":{"body":"(module (import \"linking2\" \"double\" (func $double (param i32) (result i32))) (import \"linking2\" \"log\" (func $log (param i32 i32))) (import \"linking2\" \"memory\" (memory 1)) (import \"linking2\" \"memory_offset\" (global $offset i32)) (func (export \"run\") ;; Call into the other module to double our number, and we could print it ;; here but for now we just drop it i32.const 2 call $double drop ;; Our `data` segment initialized our imported memory, so let's print the ;; string there now. global.get $offset i32.const 14 call $log ) (data (global.get $offset) \"Hello, world!\\n\")\n)","breadcrumbs":"Using the Wasmtime API » Rust » Linking Modules » linking1.wat","id":"57","title":"linking1.wat"},"58":{"body":"(module (type $fd_write_ty (func (param i32 i32 i32 i32) (result i32))) (import \"wasi_snapshot_preview1\" \"fd_write\" (func $fd_write (type $fd_write_ty))) (func (export \"double\") (param i32) (result i32) local.get 0 i32.const 2 i32.mul ) (func (export \"log\") (param i32 i32) ;; store the pointer in the first iovec field i32.const 4 local.get 0 i32.store ;; store the length in the first iovec field i32.const 4 local.get 1 i32.store offset=4 ;; call the `fd_write` import i32.const 1 ;; stdout fd i32.const 4 ;; iovs start i32.const 1 ;; number of iovs i32.const 0 ;; where to write nwritten bytes call $fd_write drop ) (memory (export \"memory\") 2) (global (export \"memory_offset\") i32 (i32.const 65536))\n)","breadcrumbs":"Using the Wasmtime API » Rust » Linking Modules » linking2.wat","id":"58","title":"linking2.wat"},"59":{"body":"//! Example of instantiating two modules which link to each other. // You can execute this example with `cargo run --example linking` use wasi_common::sync::WasiCtxBuilder;\nuse wasmtime::*; fn main() -> Result<()> { let engine = Engine::default(); // First set up our linker which is going to be linking modules together. We // want our linker to have wasi available, so we set that up here as well. let mut linker = Linker::new(&engine); wasi_common::sync::add_to_linker(&mut linker, |s| s)?; // Load and compile our two modules let linking1 = Module::from_file(&engine, \"examples/linking1.wat\")?; let linking2 = Module::from_file(&engine, \"examples/linking2.wat\")?; // Configure WASI and insert it into a `Store` let wasi = WasiCtxBuilder::new() .inherit_stdio() .inherit_args()? .build(); let mut store = Store::new(&engine, wasi); // Instantiate our first module which only uses WASI, then register that // instance with the linker since the next linking will use it. let linking2 = linker.instantiate(&mut store, &linking2)?; linker.instance(&mut store, \"linking2\", linking2)?; // And with that we can perform the final link and the execute the module. let linking1 = linker.instantiate(&mut store, &linking1)?; let run = linking1.get_typed_func::<(), ()>(&mut store, \"run\")?; run.call(&mut store, ())?; Ok(())\n}","breadcrumbs":"Using the Wasmtime API » Rust » Linking Modules » linking.rs","id":"59","title":"linking.rs"},"6":{"body":"This is a general subcommand used to print help information to the terminal. You can execute any number of the following: $ wasmtime help\n$ wasmtime --help\n$ wasmtime -h\n$ wasmtime help run\n$ wasmtime run -h When in doubt, try running the help command to learn more about functionality!","breadcrumbs":"Using the Wasmtime CLI » CLI Options » help","id":"6","title":"help"},"60":{"body":"You can also browse this source code online and clone the wasmtime repository to run the example locally. This example shows off how to set up a module for dynamic runtime debugging via a native debugger like GDB or LLDB.","breadcrumbs":"Using the Wasmtime API » Rust » Debugging » Debugging","id":"60","title":"Debugging"},"61":{"body":"//! Example of enabling debuginfo for wasm code which allows interactive\n//! debugging of the wasm code. When using recent versions of LLDB\n//! you can debug this executable and set breakpoints in wasm code and look at\n//! the rust source code as input. // To execute this example you'll need to run two commands:\n//\n// cargo build -p example-fib-debug-wasm --target wasm32-unknown-unknown\n// cargo run --example fib-debug use wasmtime::*; fn main() -> Result<()> { // Load our previously compiled wasm file (built previously with Cargo) and // also ensure that we generate debuginfo so this executable can be // debugged in GDB. let engine = Engine::new( Config::new() .debug_info(true) .cranelift_opt_level(OptLevel::None), )?; let mut store = Store::new(&engine, ()); let module = Module::from_file(&engine, \"target/wasm32-unknown-unknown/debug/fib.wasm\")?; let instance = Instance::new(&mut store, &module, &[])?; // Invoke `fib` export let fib = instance.get_typed_func::<i32, i32>(&mut store, \"fib\")?; println!(\"fib(6) = {}\", fib.call(&mut store, 6)?); Ok(())\n}","breadcrumbs":"Using the Wasmtime API » Rust » Debugging » main.rs","id":"61","title":"main.rs"},"62":{"body":"You can also browse this source code online and clone the wasmtime repository to run the example locally. This examples shows how to configure capturing core dumps when a Wasm guest traps that can then be passed to external tools (like wasmgdb ) for post-mortem analysis.","breadcrumbs":"Using the Wasmtime API » Rust » Core Dumps » Core Dumps","id":"62","title":"Core Dumps"},"63":{"body":"//! An example of how to configure capturing core dumps when the guest Wasm\n//! traps that can then be passed to external tools for post-mortem analysis. // You can execute this example with `cargo run --example coredump`. use wasmtime::*; fn main() -> Result<()> { println!(\"Configure core dumps to be captured on trap.\"); let mut config = Config::new(); config.coredump_on_trap(true); let engine = Engine::new(&config)?; let mut store = Store::new(&engine, ()); println!(\"Define a Wasm module that will mutate local state and then trap.\"); let module = Module::new( store.engine(), r#\" (module $trapper (memory 10) (global $g (mut i32) (i32.const 0)) (func (export \"run\") call $a ) (func $a i32.const 0x1234 i64.const 42 i64.store call $b ) (func $b i32.const 36 global.set $g call $c ) (func $c unreachable ) ) \"#, )?; println!(\"Instantiate the module.\"); let instance = Instance::new(&mut store, &module, &[])?; println!(\"Invoke its 'run' function.\"); let run = instance .get_func(&mut store, \"run\") .expect(\"should have 'run' export\"); let args = &[]; let results = &mut []; let ok = run.call(&mut store, args, results); println!(\"Calling that function trapped.\"); assert!(ok.is_err()); let err = ok.unwrap_err(); assert!(err.is::<Trap>()); println!(\"Extract the captured core dump.\"); let dump = err .downcast_ref::<WasmCoreDump>() .expect(\"should have an attached core dump, since we configured core dumps on\"); println!( \"Number of memories in the core dump: {}\", dump.memories().len() ); for (i, mem) in dump.memories().iter().enumerate() { if let Some(addr) = mem.data(&store).iter().position(|byte| *byte != 0) { let val = mem.data(&store)[addr]; println!(\" First nonzero byte for memory {i}: {val} @ {addr:#x}\"); } else { println!(\" Memory {i} is all zeroes.\"); } } println!( \"Number of globals in the core dump: {}\", dump.globals().len() ); for (i, global) in dump.globals().iter().enumerate() { let val = global.get(&mut store); println!(\" Global {i} = {val:?}\"); } println!(\"Serialize the core dump and write it to ./example.coredump\"); let serialized = dump.serialize(&mut store, \"trapper.wasm\"); std::fs::write(\"./example.coredump\", serialized)?; Ok(())\n}","breadcrumbs":"Using the Wasmtime API » Rust » Core Dumps » main.rs","id":"63","title":"main.rs"},"64":{"body":"You can also browse this source code online and clone the wasmtime repository to run the example locally. This example shows off how to interact with a wasm module that uses multi-value exports and imports.","breadcrumbs":"Using the Wasmtime API » Rust » Using Multi-Value » Using multi-value","id":"64","title":"Using multi-value"},"65":{"body":"(module (func $f (import \"\" \"f\") (param i32 i64) (result i64 i32)) (func $g (export \"g\") (param i32 i64) (result i64 i32) (call $f (local.get 0) (local.get 1)) ) (func $round_trip_many (export \"round_trip_many\") (param i64 i64 i64 i64 i64 i64 i64 i64 i64 i64) (result i64 i64 i64 i64 i64 i64 i64 i64 i64 i64) local.get 0 local.get 1 local.get 2 local.get 3 local.get 4 local.get 5 local.get 6 local.get 7 local.get 8 local.get 9)\n)","breadcrumbs":"Using the Wasmtime API » Rust » Using Multi-Value » multi.wat","id":"65","title":"multi.wat"},"66":{"body":"//! This is an example of working with multi-value modules and dealing with\n//! multi-value functions.\n//!\n//! Note that the `Func::wrap*` interfaces cannot be used to return multiple\n//! values just yet, so we need to use the more dynamic `Func::new` and\n//! `Func::call` methods. // You can execute this example with `cargo run --example multi` use anyhow::Result; fn main() -> Result<()> { use wasmtime::*; println!(\"Initializing...\"); let engine = Engine::default(); let mut store = Store::new(&engine, ()); // Compile. println!(\"Compiling module...\"); let module = Module::from_file(&engine, \"examples/multi.wat\")?; // Create a host function which takes multiple parameters and returns // multiple results. println!(\"Creating callback...\"); let callback_func = Func::wrap(&mut store, |a: i32, b: i64| -> (i64, i32) { (b + 1, a + 1) }); // Instantiate. println!(\"Instantiating module...\"); let instance = Instance::new(&mut store, &module, &[callback_func.into()])?; // Extract exports. println!(\"Extracting export...\"); let g = instance.get_typed_func::<(i32, i64), (i64, i32)>(&mut store, \"g\")?; // Call `$g`. println!(\"Calling export \\\"g\\\"...\"); let (a, b) = g.call(&mut store, (1, 3))?; println!(\"Printing result...\"); println!(\"> {a} {b}\"); assert_eq!(a, 4); assert_eq!(b, 2); // Call `$round_trip_many`. println!(\"Calling export \\\"round_trip_many\\\"...\"); let round_trip_many = instance .get_typed_func::< (i64, i64, i64, i64, i64, i64, i64, i64, i64, i64), (i64, i64, i64, i64, i64, i64, i64, i64, i64, i64), > (&mut store, \"round_trip_many\")?; let results = round_trip_many.call(&mut store, (0, 1, 2, 3, 4, 5, 6, 7, 8, 9))?; println!(\"Printing result...\"); println!(\"> {results:?}\"); assert_eq!(results, (0, 1, 2, 3, 4, 5, 6, 7, 8, 9)); Ok(())\n}","breadcrumbs":"Using the Wasmtime API » Rust » Using Multi-Value » multi.rs","id":"66","title":"multi.rs"},"67":{"body":"This section is intended to showcase the C embedding API for Wasmtime. Full reference documentation for the C API can be found online .","breadcrumbs":"Using the Wasmtime API » C » Embedding in C","id":"67","title":"Embedding in C"},"68":{"body":"You can also browse this source code online and clone the wasmtime repository to run the example locally. This example shows off how to instantiate a simple wasm module and interact with it.","breadcrumbs":"Using the Wasmtime API » C » Hello, World! » Hello, world!","id":"68","title":"Hello, world!"},"69":{"body":"(module (func $hello (import \"\" \"hello\")) (func (export \"run\") (call $hello))\n)","breadcrumbs":"Using the Wasmtime API » C » Hello, World! » hello.wat","id":"69","title":"hello.wat"},"7":{"body":"This is the wasmtime CLI's main subcommand, and it's also the default if no other subcommand is provided. The run command will execute a WebAssembly module. This means that the module will be compiled to native code, instantiated, and then optionally have an export executed. The wasmtime CLI will automatically hook up any WASI-related imported functionality, but at this time if your module imports anything else it will fail instantiation. The run command takes one positional argument which is the name of the module to run: $ wasmtime run foo.wasm\n$ wasmtime foo.wasm Note that the wasmtime CLI can take both a binary WebAssembly file (*.wasm) as well as the text format for WebAssembly (*.wat): $ wasmtime foo.wat The run command accepts an optional invoke argument which is the name of an exported function of the module to run. $ wasmtime run foo.wasm --invoke initialize","breadcrumbs":"Using the Wasmtime CLI » CLI Options » run","id":"7","title":"run"},"70":{"body":"/*\nExample of instantiating of the WebAssembly module and invoking its exported\nfunction. You can compile and run this example on Linux with: cargo build --release -p wasmtime-c-api cc examples/hello.c \\ -I crates/c-api/include \\ target/release/libwasmtime.a \\ -lpthread -ldl -lm \\ -o hello ./hello Note that on Windows and macOS the command will be similar, but you'll need\nto tweak the `-lpthread` and such annotations as well as the name of the\n`libwasmtime.a` file on Windows. You can also build using cmake: mkdir build && cd build && cmake .. && cmake --build . --target wasmtime-hello\n*/ #include <assert.h>\n#include <stdio.h>\n#include <stdlib.h>\n#include <wasm.h>\n#include <wasmtime.h> static void exit_with_error(const char *message, wasmtime_error_t *error, wasm_trap_t *trap); static wasm_trap_t *hello_callback(void *env, wasmtime_caller_t *caller, const wasmtime_val_t *args, size_t nargs, wasmtime_val_t *results, size_t nresults) { printf(\"Calling back...\\n\"); printf(\"> Hello World!\\n\"); return NULL;\n} int main() { int ret = 0; // Set up our compilation context. Note that we could also work with a // `wasm_config_t` here to configure what feature are enabled and various // compilation settings. printf(\"Initializing...\\n\"); wasm_engine_t *engine = wasm_engine_new(); assert(engine != NULL); // With an engine we can create a *store* which is a long-lived group of wasm // modules. Note that we allocate some custom data here to live in the store, // but here we skip that and specify NULL. wasmtime_store_t *store = wasmtime_store_new(engine, NULL, NULL); assert(store != NULL); wasmtime_context_t *context = wasmtime_store_context(store); // Read our input file, which in this case is a wasm text file. FILE *file = fopen(\"examples/hello.wat\", \"r\"); assert(file != NULL); fseek(file, 0L, SEEK_END); size_t file_size = ftell(file); fseek(file, 0L, SEEK_SET); wasm_byte_vec_t wat; wasm_byte_vec_new_uninitialized(&wat, file_size); if (fread(wat.data, file_size, 1, file) != 1) { printf(\"> Error loading module!\\n\"); return 1; } fclose(file); // Parse the wat into the binary wasm format wasm_byte_vec_t wasm; wasmtime_error_t *error = wasmtime_wat2wasm(wat.data, wat.size, &wasm); if (error != NULL) exit_with_error(\"failed to parse wat\", error, NULL); wasm_byte_vec_delete(&wat); // Now that we've got our binary webassembly we can compile our module. printf(\"Compiling module...\\n\"); wasmtime_module_t *module = NULL; error = wasmtime_module_new(engine, (uint8_t *)wasm.data, wasm.size, &module); wasm_byte_vec_delete(&wasm); if (error != NULL) exit_with_error(\"failed to compile module\", error, NULL); // Next up we need to create the function that the wasm module imports. Here // we'll be hooking up a thunk function to the `hello_callback` native // function above. Note that we can assign custom data, but we just use NULL // for now). printf(\"Creating callback...\\n\"); wasm_functype_t *hello_ty = wasm_functype_new_0_0(); wasmtime_func_t hello; wasmtime_func_new(context, hello_ty, hello_callback, NULL, NULL, &hello); // With our callback function we can now instantiate the compiled module, // giving us an instance we can then execute exports from. Note that // instantiation can trap due to execution of the `start` function, so we need // to handle that here too. printf(\"Instantiating module...\\n\"); wasm_trap_t *trap = NULL; wasmtime_instance_t instance; wasmtime_extern_t import; import.kind = WASMTIME_EXTERN_FUNC; import.of.func = hello; error = wasmtime_instance_new(context, module, &import, 1, &instance, &trap); if (error != NULL || trap != NULL) exit_with_error(\"failed to instantiate\", error, trap); // Lookup our `run` export function printf(\"Extracting export...\\n\"); wasmtime_extern_t run; bool ok = wasmtime_instance_export_get(context, &instance, \"run\", 3, &run); assert(ok); assert(run.kind == WASMTIME_EXTERN_FUNC); // And call it! printf(\"Calling export...\\n\"); error = wasmtime_func_call(context, &run.of.func, NULL, 0, NULL, 0, &trap); if (error != NULL || trap != NULL) exit_with_error(\"failed to call function\", error, trap); // Clean up after ourselves at this point printf(\"All finished!\\n\"); ret = 0; wasmtime_module_delete(module); wasmtime_store_delete(store); wasm_engine_delete(engine); return ret;\n} static void exit_with_error(const char *message, wasmtime_error_t *error, wasm_trap_t *trap) { fprintf(stderr, \"error: %s\\n\", message); wasm_byte_vec_t error_message; if (error != NULL) { wasmtime_error_message(error, &error_message); wasmtime_error_delete(error); } else { wasm_trap_message(trap, &error_message); wasm_trap_delete(trap); } fprintf(stderr, \"%.*s\\n\", (int)error_message.size, error_message.data); wasm_byte_vec_delete(&error_message); exit(1);\n}","breadcrumbs":"Using the Wasmtime API » C » Hello, World! » hello.c","id":"70","title":"hello.c"},"71":{"body":"You can also browse this source code online and clone the wasmtime repository to run the example locally. This example shows off how run a wasm program which calculates the GCD of two numbers.","breadcrumbs":"Using the Wasmtime API » C » Calculating the GCD » Calculating the GCD","id":"71","title":"Calculating the GCD"},"72":{"body":"(module (func $gcd (param i32 i32) (result i32) (local i32) block ;; label = @1 block ;; label = @2 local.get 0 br_if 0 (;@2;) local.get 1 local.set 2 br 1 (;@1;) end loop ;; label = @2 local.get 1 local.get 0 local.tee 2 i32.rem_u local.set 0 local.get 2 local.set 1 local.get 0 br_if 0 (;@2;) end end local.get 2 ) (export \"gcd\" (func $gcd))\n)","breadcrumbs":"Using the Wasmtime API » C » Calculating the GCD » gcd.wat","id":"72","title":"gcd.wat"},"73":{"body":"/*\nExample of instantiating of the WebAssembly module and invoking its exported\nfunction. You can compile and run this example on Linux with: cargo build --release -p wasmtime-c-api cc examples/gcd.c \\ -I crates/c-api/include \\ target/release/libwasmtime.a \\ -lpthread -ldl -lm \\ -o gcd ./gcd Note that on Windows and macOS the command will be similar, but you'll need\nto tweak the `-lpthread` and such annotations. You can also build using cmake: mkdir build && cd build && cmake .. && cmake --build . --target wasmtime-gcd\n*/ #include <assert.h>\n#include <stdio.h>\n#include <stdlib.h>\n#include <wasm.h>\n#include <wasmtime.h> static void exit_with_error(const char *message, wasmtime_error_t *error, wasm_trap_t *trap); int main() { int ret = 0; // Set up our context wasm_engine_t *engine = wasm_engine_new(); assert(engine != NULL); wasmtime_store_t *store = wasmtime_store_new(engine, NULL, NULL); assert(store != NULL); wasmtime_context_t *context = wasmtime_store_context(store); // Load our input file to parse it next FILE *file = fopen(\"examples/gcd.wat\", \"r\"); if (!file) { printf(\"> Error loading file!\\n\"); return 1; } fseek(file, 0L, SEEK_END); size_t file_size = ftell(file); fseek(file, 0L, SEEK_SET); wasm_byte_vec_t wat; wasm_byte_vec_new_uninitialized(&wat, file_size); if (fread(wat.data, file_size, 1, file) != 1) { printf(\"> Error loading module!\\n\"); return 1; } fclose(file); // Parse the wat into the binary wasm format wasm_byte_vec_t wasm; wasmtime_error_t *error = wasmtime_wat2wasm(wat.data, wat.size, &wasm); if (error != NULL) exit_with_error(\"failed to parse wat\", error, NULL); wasm_byte_vec_delete(&wat); // Compile and instantiate our module wasmtime_module_t *module = NULL; error = wasmtime_module_new(engine, (uint8_t *)wasm.data, wasm.size, &module); if (module == NULL) exit_with_error(\"failed to compile module\", error, NULL); wasm_byte_vec_delete(&wasm); wasm_trap_t *trap = NULL; wasmtime_instance_t instance; error = wasmtime_instance_new(context, module, NULL, 0, &instance, &trap); if (error != NULL || trap != NULL) exit_with_error(\"failed to instantiate\", error, trap); // Lookup our `gcd` export function wasmtime_extern_t gcd; bool ok = wasmtime_instance_export_get(context, &instance, \"gcd\", 3, &gcd); assert(ok); assert(gcd.kind == WASMTIME_EXTERN_FUNC); // And call it! int a = 6; int b = 27; wasmtime_val_t params[2]; params[0].kind = WASMTIME_I32; params[0].of.i32 = a; params[1].kind = WASMTIME_I32; params[1].of.i32 = b; wasmtime_val_t results[1]; error = wasmtime_func_call(context, &gcd.of.func, params, 2, results, 1, &trap); if (error != NULL || trap != NULL) exit_with_error(\"failed to call gcd\", error, trap); assert(results[0].kind == WASMTIME_I32); printf(\"gcd(%d, %d) = %d\\n\", a, b, results[0].of.i32); // Clean up after ourselves at this point ret = 0; wasmtime_module_delete(module); wasmtime_store_delete(store); wasm_engine_delete(engine); return ret;\n} static void exit_with_error(const char *message, wasmtime_error_t *error, wasm_trap_t *trap) { fprintf(stderr, \"error: %s\\n\", message); wasm_byte_vec_t error_message; if (error != NULL) { wasmtime_error_message(error, &error_message); } else { wasm_trap_message(trap, &error_message); } fprintf(stderr, \"%.*s\\n\", (int)error_message.size, error_message.data); wasm_byte_vec_delete(&error_message); exit(1);\n}","breadcrumbs":"Using the Wasmtime API » C » Calculating the GCD » gcd.c","id":"73","title":"gcd.c"},"74":{"body":"You can also browse this source code online and clone the wasmtime repository to run the example locally. This example shows off how to interact with wasm memory in a module. Be sure to read the documentation for Memory as well.","breadcrumbs":"Using the Wasmtime API » C » Using Linear Memory » Using linear memory","id":"74","title":"Using linear memory"},"75":{"body":"(module (memory (export \"memory\") 2 3) (func (export \"size\") (result i32) (memory.size)) (func (export \"load\") (param i32) (result i32) (i32.load8_s (local.get 0)) ) (func (export \"store\") (param i32 i32) (i32.store8 (local.get 0) (local.get 1)) ) (data (i32.const 0x1000) \"\\01\\02\\03\\04\")\n)","breadcrumbs":"Using the Wasmtime API » C » Using Linear Memory » memory.wat","id":"75","title":"memory.wat"},"76":{"body":"/*\nExample of instantiating of the WebAssembly module and invoking its exported\nfunction. You can compile and run this example on Linux with: cargo build --release -p wasmtime-c-api cc examples/memory.c \\ -I crates/c-api/include \\ target/release/libwasmtime.a \\ -lpthread -ldl -lm \\ -o memory ./memory Note that on Windows and macOS the command will be similar, but you'll need\nto tweak the `-lpthread` and such annotations. You can also build using cmake: mkdir build && cd build && cmake .. && cmake --build . --target wasmtime-memory Also note that this example was taken from\nhttps://github.com/WebAssembly/wasm-c-api/blob/master/example/memory.c\noriginally\n*/ #include <inttypes.h>\n#include <stdio.h>\n#include <stdlib.h>\n#include <string.h>\n#include <wasm.h>\n#include <wasmtime.h> static void exit_with_error(const char *message, wasmtime_error_t *error, wasm_trap_t *trap); void check(bool success) { if (!success) { printf(\"> Error, expected success\\n\"); exit(1); }\n} void check_call(wasmtime_context_t *store, wasmtime_func_t *func, const wasmtime_val_t *args, size_t nargs, int32_t expected) { wasmtime_val_t results[1]; wasm_trap_t *trap = NULL; wasmtime_error_t *error = wasmtime_func_call(store, func, args, nargs, results, 1, &trap); if (error != NULL || trap != NULL) exit_with_error(\"failed to call function\", error, trap); if (results[0].of.i32 != expected) { printf(\"> Error on result\\n\"); exit(1); }\n} void check_call0(wasmtime_context_t *store, wasmtime_func_t *func, int32_t expected) { check_call(store, func, NULL, 0, expected);\n} void check_call1(wasmtime_context_t *store, wasmtime_func_t *func, int32_t arg, int32_t expected) { wasmtime_val_t args[1]; args[0].kind = WASMTIME_I32; args[0].of.i32 = arg; check_call(store, func, args, 1, expected);\n} void check_call2(wasmtime_context_t *store, wasmtime_func_t *func, int32_t arg1, int32_t arg2, int32_t expected) { wasmtime_val_t args[2]; args[0].kind = WASMTIME_I32; args[0].of.i32 = arg1; args[1].kind = WASMTIME_I32; args[1].of.i32 = arg2; check_call(store, func, args, 2, expected);\n} void check_ok(wasmtime_context_t *store, wasmtime_func_t *func, const wasmtime_val_t *args, size_t nargs) { wasm_trap_t *trap = NULL; wasmtime_error_t *error = wasmtime_func_call(store, func, args, nargs, NULL, 0, &trap); if (error != NULL || trap != NULL) exit_with_error(\"failed to call function\", error, trap);\n} void check_ok2(wasmtime_context_t *store, wasmtime_func_t *func, int32_t arg1, int32_t arg2) { wasmtime_val_t args[2]; args[0].kind = WASMTIME_I32; args[0].of.i32 = arg1; args[1].kind = WASMTIME_I32; args[1].of.i32 = arg2; check_ok(store, func, args, 2);\n} void check_trap(wasmtime_context_t *store, wasmtime_func_t *func, const wasmtime_val_t *args, size_t nargs, size_t num_results) { assert(num_results <= 1); wasmtime_val_t results[1]; wasm_trap_t *trap = NULL; wasmtime_error_t *error = wasmtime_func_call(store, func, args, nargs, results, num_results, &trap); if (error != NULL) exit_with_error(\"failed to call function\", error, NULL); if (trap == NULL) { printf(\"> Error on result, expected trap\\n\"); exit(1); } wasm_trap_delete(trap);\n} void check_trap1(wasmtime_context_t *store, wasmtime_func_t *func, int32_t arg) { wasmtime_val_t args[1]; args[0].kind = WASMTIME_I32; args[0].of.i32 = arg; check_trap(store, func, args, 1, 1);\n} void check_trap2(wasmtime_context_t *store, wasmtime_func_t *func, int32_t arg1, int32_t arg2) { wasmtime_val_t args[2]; args[0].kind = WASMTIME_I32; args[0].of.i32 = arg1; args[1].kind = WASMTIME_I32; args[1].of.i32 = arg2; check_trap(store, func, args, 2, 0);\n} int main(int argc, const char *argv[]) { // Initialize. printf(\"Initializing...\\n\"); wasm_engine_t *engine = wasm_engine_new(); wasmtime_store_t *store = wasmtime_store_new(engine, NULL, NULL); wasmtime_context_t *context = wasmtime_store_context(store); // Load our input file to parse it next FILE *file = fopen(\"examples/memory.wat\", \"r\"); if (!file) { printf(\"> Error loading file!\\n\"); return 1; } fseek(file, 0L, SEEK_END); size_t file_size = ftell(file); fseek(file, 0L, SEEK_SET); wasm_byte_vec_t wat; wasm_byte_vec_new_uninitialized(&wat, file_size); if (fread(wat.data, file_size, 1, file) != 1) { printf(\"> Error loading module!\\n\"); return 1; } fclose(file); // Parse the wat into the binary wasm format wasm_byte_vec_t binary; wasmtime_error_t *error = wasmtime_wat2wasm(wat.data, wat.size, &binary); if (error != NULL) exit_with_error(\"failed to parse wat\", error, NULL); wasm_byte_vec_delete(&wat); // Compile. printf(\"Compiling module...\\n\"); wasmtime_module_t *module = NULL; error = wasmtime_module_new(engine, (uint8_t *)binary.data, binary.size, &module); if (error) exit_with_error(\"failed to compile module\", error, NULL); wasm_byte_vec_delete(&binary); // Instantiate. printf(\"Instantiating module...\\n\"); wasmtime_instance_t instance; wasm_trap_t *trap = NULL; error = wasmtime_instance_new(context, module, NULL, 0, &instance, &trap); if (error != NULL || trap != NULL) exit_with_error(\"failed to instantiate\", error, trap); wasmtime_module_delete(module); // Extract export. printf(\"Extracting exports...\\n\"); wasmtime_memory_t memory; wasmtime_func_t size_func, load_func, store_func; wasmtime_extern_t item; bool ok; ok = wasmtime_instance_export_get(context, &instance, \"memory\", strlen(\"memory\"), &item); assert(ok && item.kind == WASMTIME_EXTERN_MEMORY); memory = item.of.memory; ok = wasmtime_instance_export_get(context, &instance, \"size\", strlen(\"size\"), &item); assert(ok && item.kind == WASMTIME_EXTERN_FUNC); size_func = item.of.func; ok = wasmtime_instance_export_get(context, &instance, \"load\", strlen(\"load\"), &item); assert(ok && item.kind == WASMTIME_EXTERN_FUNC); load_func = item.of.func; ok = wasmtime_instance_export_get(context, &instance, \"store\", strlen(\"store\"), &item); assert(ok && item.kind == WASMTIME_EXTERN_FUNC); store_func = item.of.func; // Check initial memory. printf(\"Checking memory...\\n\"); check(wasmtime_memory_size(context, &memory) == 2); check(wasmtime_memory_data_size(context, &memory) == 0x20000); check(wasmtime_memory_data(context, &memory)[0] == 0); check(wasmtime_memory_data(context, &memory)[0x1000] == 1); check(wasmtime_memory_data(context, &memory)[0x1003] == 4); check_call0(context, &size_func, 2); check_call1(context, &load_func, 0, 0); check_call1(context, &load_func, 0x1000, 1); check_call1(context, &load_func, 0x1003, 4); check_call1(context, &load_func, 0x1ffff, 0); check_trap1(context, &load_func, 0x20000); // Mutate memory. printf(\"Mutating memory...\\n\"); wasmtime_memory_data(context, &memory)[0x1003] = 5; check_ok2(context, &store_func, 0x1002, 6); check_trap2(context, &store_func, 0x20000, 0); check(wasmtime_memory_data(context, &memory)[0x1002] == 6); check(wasmtime_memory_data(context, &memory)[0x1003] == 5); check_call1(context, &load_func, 0x1002, 6); check_call1(context, &load_func, 0x1003, 5); // Grow memory. printf(\"Growing memory...\\n\"); uint64_t old_size; error = wasmtime_memory_grow(context, &memory, 1, &old_size); if (error != NULL) exit_with_error(\"failed to grow memory\", error, trap); check(wasmtime_memory_size(context, &memory) == 3); check(wasmtime_memory_data_size(context, &memory) == 0x30000); check_call1(context, &load_func, 0x20000, 0); check_ok2(context, &store_func, 0x20000, 0); check_trap1(context, &load_func, 0x30000); check_trap2(context, &store_func, 0x30000, 0); error = wasmtime_memory_grow(context, &memory, 1, &old_size); assert(error != NULL); wasmtime_error_delete(error); error = wasmtime_memory_grow(context, &memory, 0, &old_size); if (error != NULL) exit_with_error(\"failed to grow memory\", error, trap); // Create stand-alone memory. printf(\"Creating stand-alone memory...\\n\"); wasm_limits_t limits = {5, 5}; wasm_memorytype_t *memorytype = wasm_memorytype_new(&limits); wasmtime_memory_t memory2; error = wasmtime_memory_new(context, memorytype, &memory2); if (error != NULL) exit_with_error(\"failed to create memory\", error, trap); wasm_memorytype_delete(memorytype); check(wasmtime_memory_size(context, &memory2) == 5); // Shut down. printf(\"Shutting down...\\n\"); wasmtime_store_delete(store); wasm_engine_delete(engine); // All done. printf(\"Done.\\n\"); return 0;\n} static void exit_with_error(const char *message, wasmtime_error_t *error, wasm_trap_t *trap) { fprintf(stderr, \"error: %s\\n\", message); wasm_byte_vec_t error_message; if (error != NULL) { wasmtime_error_message(error, &error_message); wasmtime_error_delete(error); } else { wasm_trap_message(trap, &error_message); wasm_trap_delete(trap); } fprintf(stderr, \"%.*s\\n\", (int)error_message.size, error_message.data); wasm_byte_vec_delete(&error_message); exit(1);\n}","breadcrumbs":"Using the Wasmtime API » C » Using Linear Memory » memory.c","id":"76","title":"memory.c"},"77":{"body":"You can also browse this source code online and clone the wasmtime repository to run the example locally. This example shows off how to instantiate a wasm module using WASI imports.","breadcrumbs":"Using the Wasmtime API » C » WASI » WASI","id":"77","title":"WASI"},"78":{"body":"fn main() { println!(\"Hello, world!\");\n}","breadcrumbs":"Using the Wasmtime API » C » WASI » Wasm Source code","id":"78","title":"Wasm Source code"},"79":{"body":"/*\nExample of instantiating a WebAssembly which uses WASI imports. You can compile and run this example on Linux with: cmake examples/ cargo build --release -p wasmtime-c-api cc examples/wasi/main.c \\ -I crates/c-api/include \\ target/release/libwasmtime.a \\ -lpthread -ldl -lm \\ -o wasi ./wasi Note that on Windows and macOS the command will be similar, but you'll need\nto tweak the `-lpthread` and such annotations. You can also build using cmake: mkdir build && cd build && cmake .. && cmake --build . --target wasmtime-wasi\n*/ #include <assert.h>\n#include <stdio.h>\n#include <stdlib.h>\n#include <wasi.h>\n#include <wasm.h>\n#include <wasmtime.h> #define MIN(a, b) ((a) < (b) ? (a) : (b)) static void exit_with_error(const char *message, wasmtime_error_t *error, wasm_trap_t *trap); int main() { // Set up our context wasm_engine_t *engine = wasm_engine_new(); assert(engine != NULL); wasmtime_store_t *store = wasmtime_store_new(engine, NULL, NULL); assert(store != NULL); wasmtime_context_t *context = wasmtime_store_context(store); // Create a linker with WASI functions defined wasmtime_linker_t *linker = wasmtime_linker_new(engine); wasmtime_error_t *error = wasmtime_linker_define_wasi(linker); if (error != NULL) exit_with_error(\"failed to link wasi\", error, NULL); wasm_byte_vec_t wasm; // Load our input file to parse it next FILE *file = fopen(\"target/wasm32-wasip1/debug/wasi.wasm\", \"rb\"); if (!file) { printf(\"> Error loading file!\\n\"); exit(1); } fseek(file, 0L, SEEK_END); size_t file_size = ftell(file); wasm_byte_vec_new_uninitialized(&wasm, file_size); fseek(file, 0L, SEEK_SET); if (fread(wasm.data, file_size, 1, file) != 1) { printf(\"> Error loading module!\\n\"); exit(1); } fclose(file); // Compile our modules wasmtime_module_t *module = NULL; error = wasmtime_module_new(engine, (uint8_t *)wasm.data, wasm.size, &module); if (!module) exit_with_error(\"failed to compile module\", error, NULL); wasm_byte_vec_delete(&wasm); // Instantiate wasi wasi_config_t *wasi_config = wasi_config_new(); assert(wasi_config); wasi_config_inherit_argv(wasi_config); wasi_config_inherit_env(wasi_config); wasi_config_inherit_stdin(wasi_config); wasi_config_inherit_stdout(wasi_config); wasi_config_inherit_stderr(wasi_config); wasm_trap_t *trap = NULL; error = wasmtime_context_set_wasi(context, wasi_config); if (error != NULL) exit_with_error(\"failed to instantiate WASI\", error, NULL); // Instantiate the module error = wasmtime_linker_module(linker, context, \"\", 0, module); if (error != NULL) exit_with_error(\"failed to instantiate module\", error, NULL); // Run it. wasmtime_func_t func; error = wasmtime_linker_get_default(linker, context, \"\", 0, &func); if (error != NULL) exit_with_error(\"failed to locate default export for module\", error, NULL); error = wasmtime_func_call(context, &func, NULL, 0, NULL, 0, &trap); if (error != NULL || trap != NULL) exit_with_error(\"error calling default export\", error, trap); // Clean up after ourselves at this point wasmtime_module_delete(module); wasmtime_store_delete(store); wasm_engine_delete(engine); return 0;\n} static void exit_with_error(const char *message, wasmtime_error_t *error, wasm_trap_t *trap) { fprintf(stderr, \"error: %s\\n\", message); wasm_byte_vec_t error_message; if (error != NULL) { wasmtime_error_message(error, &error_message); wasmtime_error_delete(error); } else { wasm_trap_message(trap, &error_message); wasm_trap_delete(trap); } fprintf(stderr, \"%.*s\\n\", (int)error_message.size, error_message.data); wasm_byte_vec_delete(&error_message); exit(1);\n}","breadcrumbs":"Using the Wasmtime API » C » WASI » wasi.c","id":"79","title":"wasi.c"},"8":{"body":"The serve subcommand runs a WebAssembly component in the wasi:http/proxy world via the WASI HTTP API, which is available since Wasmtime 18.0.0. The goal of this world is to support sending and receiving HTTP requests. The serve command takes one positional argument which is the name of the component to run: $ wasmtime serve foo.wasm Furthermore, an address can be specified via: $ wasmtime serve --addr=0.0.0.0:8081 foo.wasm At the time of writing, the wasi:http/proxy world is still experimental and requires setup of some wit dependencies. For more information, see the hello-wasi-http example.","breadcrumbs":"Using the Wasmtime CLI » CLI Options » serve","id":"8","title":"serve"},"80":{"body":"You can also browse this source code online and clone the wasmtime repository to run the example locally. This example shows off how to compile and instantiate modules which link together.","breadcrumbs":"Using the Wasmtime API » C » Linking Modules » Linking modules","id":"80","title":"Linking modules"},"81":{"body":"(module (import \"linking2\" \"double\" (func $double (param i32) (result i32))) (import \"linking2\" \"log\" (func $log (param i32 i32))) (import \"linking2\" \"memory\" (memory 1)) (import \"linking2\" \"memory_offset\" (global $offset i32)) (func (export \"run\") ;; Call into the other module to double our number, and we could print it ;; here but for now we just drop it i32.const 2 call $double drop ;; Our `data` segment initialized our imported memory, so let's print the ;; string there now. global.get $offset i32.const 14 call $log ) (data (global.get $offset) \"Hello, world!\\n\")\n)","breadcrumbs":"Using the Wasmtime API » C » Linking Modules » linking1.wat","id":"81","title":"linking1.wat"},"82":{"body":"(module (type $fd_write_ty (func (param i32 i32 i32 i32) (result i32))) (import \"wasi_snapshot_preview1\" \"fd_write\" (func $fd_write (type $fd_write_ty))) (func (export \"double\") (param i32) (result i32) local.get 0 i32.const 2 i32.mul ) (func (export \"log\") (param i32 i32) ;; store the pointer in the first iovec field i32.const 4 local.get 0 i32.store ;; store the length in the first iovec field i32.const 4 local.get 1 i32.store offset=4 ;; call the `fd_write` import i32.const 1 ;; stdout fd i32.const 4 ;; iovs start i32.const 1 ;; number of iovs i32.const 0 ;; where to write nwritten bytes call $fd_write drop ) (memory (export \"memory\") 2) (global (export \"memory_offset\") i32 (i32.const 65536))\n)","breadcrumbs":"Using the Wasmtime API » C » Linking Modules » linking2.wat","id":"82","title":"linking2.wat"},"83":{"body":"/*\nExample of compiling, instantiating, and linking two WebAssembly modules\ntogether. You can compile and run this example on Linux with: cargo build --release -p wasmtime-c-api cc examples/linking.c \\ -I crates/c-api/include \\ target/release/libwasmtime.a \\ -lpthread -ldl -lm \\ -o linking ./linking Note that on Windows and macOS the command will be similar, but you'll need\nto tweak the `-lpthread` and such annotations. You can also build using cmake: mkdir build && cd build && cmake .. && cmake --build . --target wasmtime-linking\n*/ #include <assert.h>\n#include <stdio.h>\n#include <stdlib.h>\n#include <wasi.h>\n#include <wasm.h>\n#include <wasmtime.h> #define MIN(a, b) ((a) < (b) ? (a) : (b)) static void exit_with_error(const char *message, wasmtime_error_t *error, wasm_trap_t *trap);\nstatic void read_wat_file(wasm_engine_t *engine, wasm_byte_vec_t *bytes, const char *file); int main() { // Set up our context wasm_engine_t *engine = wasm_engine_new(); assert(engine != NULL); wasmtime_store_t *store = wasmtime_store_new(engine, NULL, NULL); assert(store != NULL); wasmtime_context_t *context = wasmtime_store_context(store); wasm_byte_vec_t linking1_wasm, linking2_wasm; read_wat_file(engine, &linking1_wasm, \"examples/linking1.wat\"); read_wat_file(engine, &linking2_wasm, \"examples/linking2.wat\"); // Compile our two modules wasmtime_error_t *error; wasmtime_module_t *linking1_module = NULL; wasmtime_module_t *linking2_module = NULL; error = wasmtime_module_new(engine, (uint8_t *)linking1_wasm.data, linking1_wasm.size, &linking1_module); if (error != NULL) exit_with_error(\"failed to compile linking1\", error, NULL); error = wasmtime_module_new(engine, (uint8_t *)linking2_wasm.data, linking2_wasm.size, &linking2_module); if (error != NULL) exit_with_error(\"failed to compile linking2\", error, NULL); wasm_byte_vec_delete(&linking1_wasm); wasm_byte_vec_delete(&linking2_wasm); // Configure WASI and store it within our `wasmtime_store_t` wasi_config_t *wasi_config = wasi_config_new(); assert(wasi_config); wasi_config_inherit_argv(wasi_config); wasi_config_inherit_env(wasi_config); wasi_config_inherit_stdin(wasi_config); wasi_config_inherit_stdout(wasi_config); wasi_config_inherit_stderr(wasi_config); wasm_trap_t *trap = NULL; error = wasmtime_context_set_wasi(context, wasi_config); if (error != NULL) exit_with_error(\"failed to instantiate wasi\", NULL, trap); // Create our linker which will be linking our modules together, and then add // our WASI instance to it. wasmtime_linker_t *linker = wasmtime_linker_new(engine); error = wasmtime_linker_define_wasi(linker); if (error != NULL) exit_with_error(\"failed to link wasi\", error, NULL); // Instantiate `linking2` with our linker. wasmtime_instance_t linking2; error = wasmtime_linker_instantiate(linker, context, linking2_module, &linking2, &trap); if (error != NULL || trap != NULL) exit_with_error(\"failed to instantiate linking2\", error, trap); // Register our new `linking2` instance with the linker error = wasmtime_linker_define_instance(linker, context, \"linking2\", strlen(\"linking2\"), &linking2); if (error != NULL) exit_with_error(\"failed to link linking2\", error, NULL); // Instantiate `linking1` with the linker now that `linking2` is defined wasmtime_instance_t linking1; error = wasmtime_linker_instantiate(linker, context, linking1_module, &linking1, &trap); if (error != NULL || trap != NULL) exit_with_error(\"failed to instantiate linking1\", error, trap); // Lookup our `run` export function wasmtime_extern_t run; bool ok = wasmtime_instance_export_get(context, &linking1, \"run\", 3, &run); assert(ok); assert(run.kind == WASMTIME_EXTERN_FUNC); error = wasmtime_func_call(context, &run.of.func, NULL, 0, NULL, 0, &trap); if (error != NULL || trap != NULL) exit_with_error(\"failed to call run\", error, trap); // Clean up after ourselves at this point wasmtime_linker_delete(linker); wasmtime_module_delete(linking1_module); wasmtime_module_delete(linking2_module); wasmtime_store_delete(store); wasm_engine_delete(engine); return 0;\n} static void read_wat_file(wasm_engine_t *engine, wasm_byte_vec_t *bytes, const char *filename) { wasm_byte_vec_t wat; // Load our input file to parse it next FILE *file = fopen(filename, \"r\"); if (!file) { printf(\"> Error loading file!\\n\"); exit(1); } fseek(file, 0L, SEEK_END); size_t file_size = ftell(file); wasm_byte_vec_new_uninitialized(&wat, file_size); fseek(file, 0L, SEEK_SET); if (fread(wat.data, file_size, 1, file) != 1) { printf(\"> Error loading module!\\n\"); exit(1); } fclose(file); // Parse the wat into the binary wasm format wasmtime_error_t *error = wasmtime_wat2wasm(wat.data, wat.size, bytes); if (error != NULL) exit_with_error(\"failed to parse wat\", error, NULL); wasm_byte_vec_delete(&wat);\n} static void exit_with_error(const char *message, wasmtime_error_t *error, wasm_trap_t *trap) { fprintf(stderr, \"error: %s\\n\", message); wasm_byte_vec_t error_message; if (error != NULL) { wasmtime_error_message(error, &error_message); wasmtime_error_delete(error); } else { wasm_trap_message(trap, &error_message); wasm_trap_delete(trap); } fprintf(stderr, \"%.*s\\n\", (int)error_message.size, error_message.data); wasm_byte_vec_delete(&error_message); exit(1);\n}","breadcrumbs":"Using the Wasmtime API » C » Linking Modules » linking.c","id":"83","title":"linking.c"},"84":{"body":"You can also browse this source code online and clone the wasmtime repository to run the example locally. This example shows off how to set up a module for dynamic runtime debugging via a native debugger like GDB or LLDB.","breadcrumbs":"Using the Wasmtime API » C » Debugging » Debugging","id":"84","title":"Debugging"},"85":{"body":"#include <inttypes.h>\n#include <stdio.h>\n#include <stdlib.h>\n#include <string.h>\n#include <wasm.h>\n#include <wasmtime.h> #define own static void exit_with_error(const char *message, wasmtime_error_t *error, wasm_trap_t *trap); int main(int argc, const char *argv[]) { // Configuring engine to support generating of DWARF info. // lldb can be used to attach to the program and observe // original fib-wasm.c source code and variables. wasm_config_t *config = wasm_config_new(); wasmtime_config_debug_info_set(config, true); wasmtime_config_cranelift_opt_level_set(config, WASMTIME_OPT_LEVEL_NONE); // Initialize. printf(\"Initializing...\\n\"); wasm_engine_t *engine = wasm_engine_new_with_config(config); wasmtime_store_t *store = wasmtime_store_new(engine, NULL, NULL); wasmtime_context_t *context = wasmtime_store_context(store); // Load binary. printf(\"Loading binary...\\n\"); FILE *file = fopen(\"target/wasm32-unknown-unknown/debug/fib.wasm\", \"rb\"); if (!file) { printf(\"> Error opening module!\\n\"); return 1; } fseek(file, 0L, SEEK_END); size_t file_size = ftell(file); fseek(file, 0L, SEEK_SET); wasm_byte_vec_t binary; wasm_byte_vec_new_uninitialized(&binary, file_size); if (fread(binary.data, file_size, 1, file) != 1) { printf(\"> Error reading module!\\n\"); return 1; } fclose(file); // Compile. printf(\"Compiling module...\\n\"); wasmtime_module_t *module = NULL; wasmtime_error_t *error = wasmtime_module_new(engine, (uint8_t *)binary.data, binary.size, &module); if (!module) exit_with_error(\"failed to compile module\", error, NULL); wasm_byte_vec_delete(&binary); // Instantiate. printf(\"Instantiating module...\\n\"); wasmtime_instance_t instance; wasm_trap_t *trap = NULL; error = wasmtime_instance_new(context, module, NULL, 0, &instance, &trap); if (error != NULL || trap != NULL) exit_with_error(\"failed to instantiate\", error, trap); wasmtime_module_delete(module); // Extract export. wasmtime_extern_t fib; bool ok = wasmtime_instance_export_get(context, &instance, \"fib\", 3, &fib); assert(ok); // Call. printf(\"Calling fib...\\n\"); wasmtime_val_t params[1]; params[0].kind = WASMTIME_I32; params[0].of.i32 = 6; wasmtime_val_t results[1]; error = wasmtime_func_call(context, &fib.of.func, params, 1, results, 1, &trap); if (error != NULL || trap != NULL) exit_with_error(\"failed to call function\", error, trap); assert(results[0].kind == WASMTIME_I32); printf(\"> fib(6) = %d\\n\", results[0].of.i32); // Shut down. printf(\"Shutting down...\\n\"); wasmtime_store_delete(store); wasm_engine_delete(engine); // All done. printf(\"Done.\\n\"); return 0;\n} static void exit_with_error(const char *message, wasmtime_error_t *error, wasm_trap_t *trap) { fprintf(stderr, \"error: %s\\n\", message); wasm_byte_vec_t error_message; if (error != NULL) { wasmtime_error_message(error, &error_message); } else { wasm_trap_message(trap, &error_message); } fprintf(stderr, \"%.*s\\n\", (int)error_message.size, error_message.data); wasm_byte_vec_delete(&error_message); exit(1);\n}","breadcrumbs":"Using the Wasmtime API » C » Debugging » main.c","id":"85","title":"main.c"},"86":{"body":"You can also browse this source code online and clone the wasmtime repository to run the example locally. This example shows off how to interact with a wasm module that uses multi-value exports and imports.","breadcrumbs":"Using the Wasmtime API » C » Using Multi-Value » Using multi-value","id":"86","title":"Using multi-value"},"87":{"body":"(module (func $f (import \"\" \"f\") (param i32 i64) (result i64 i32)) (func $g (export \"g\") (param i32 i64) (result i64 i32) (call $f (local.get 0) (local.get 1)) ) (func $round_trip_many (export \"round_trip_many\") (param i64 i64 i64 i64 i64 i64 i64 i64 i64 i64) (result i64 i64 i64 i64 i64 i64 i64 i64 i64 i64) local.get 0 local.get 1 local.get 2 local.get 3 local.get 4 local.get 5 local.get 6 local.get 7 local.get 8 local.get 9)\n)","breadcrumbs":"Using the Wasmtime API » C » Using Multi-Value » multi.wat","id":"87","title":"multi.wat"},"88":{"body":"/*\nExample of instantiating of the WebAssembly module and invoking its exported\nfunction. You can compile and run this example on Linux with: cargo build --release -p wasmtime-c-api cc examples/multi.c \\ -I crates/c-api/include \\ target/release/libwasmtime.a \\ -lpthread -ldl -lm \\ -o multi ./multi Note that on Windows and macOS the command will be similar, but you'll need\nto tweak the `-lpthread` and such annotations. You can also build using cmake: mkdir build && cd build && cmake .. && cmake --build . --target wasmtime-multi Also note that this example was taken from\nhttps://github.com/WebAssembly/wasm-c-api/blob/master/example/multi.c\noriginally\n*/ #include <inttypes.h>\n#include <stdio.h>\n#include <stdlib.h>\n#include <string.h>\n#include <wasm.h>\n#include <wasmtime.h> static void exit_with_error(const char *message, wasmtime_error_t *error, wasm_trap_t *trap); // A function to be called from Wasm code.\nwasm_trap_t *callback(void *env, wasmtime_caller_t *caller, const wasmtime_val_t *args, size_t nargs, wasmtime_val_t *results, size_t nresults) { printf(\"Calling back...\\n\"); printf(\"> %\" PRIu32 \" %\" PRIu64 \"\\n\", args[0].of.i32, args[1].of.i64); printf(\"\\n\"); results[0] = args[1]; results[1] = args[0]; return NULL;\n} // A function closure.\nwasm_trap_t *closure_callback(void *env, wasmtime_caller_t *caller, const wasmtime_val_t *args, size_t nargs, wasmtime_val_t *results, size_t nresults) { int i = *(int *)env; printf(\"Calling back closure...\\n\"); printf(\"> %d\\n\", i); results[0].kind = WASMTIME_I32; results[0].of.i32 = (int32_t)i; return NULL;\n} int main(int argc, const char *argv[]) { // Initialize. printf(\"Initializing...\\n\"); wasm_engine_t *engine = wasm_engine_new(); wasmtime_store_t *store = wasmtime_store_new(engine, NULL, NULL); wasmtime_context_t *context = wasmtime_store_context(store); // Load our input file to parse it next FILE *file = fopen(\"examples/multi.wat\", \"r\"); if (!file) { printf(\"> Error loading file!\\n\"); return 1; } fseek(file, 0L, SEEK_END); size_t file_size = ftell(file); fseek(file, 0L, SEEK_SET); wasm_byte_vec_t wat; wasm_byte_vec_new_uninitialized(&wat, file_size); if (fread(wat.data, file_size, 1, file) != 1) { printf(\"> Error loading module!\\n\"); return 1; } fclose(file); // Parse the wat into the binary wasm format wasm_byte_vec_t binary; wasmtime_error_t *error = wasmtime_wat2wasm(wat.data, wat.size, &binary); if (error != NULL) exit_with_error(\"failed to parse wat\", error, NULL); wasm_byte_vec_delete(&wat); // Compile. printf(\"Compiling module...\\n\"); wasmtime_module_t *module = NULL; error = wasmtime_module_new(engine, (uint8_t *)binary.data, binary.size, &module); if (error) exit_with_error(\"failed to compile module\", error, NULL); wasm_byte_vec_delete(&binary); // Create external print functions. printf(\"Creating callback...\\n\"); wasm_functype_t *callback_type = wasm_functype_new_2_2(wasm_valtype_new_i32(), wasm_valtype_new_i64(), wasm_valtype_new_i64(), wasm_valtype_new_i32()); wasmtime_func_t callback_func; wasmtime_func_new(context, callback_type, callback, NULL, NULL, &callback_func); wasm_functype_delete(callback_type); // Instantiate. printf(\"Instantiating module...\\n\"); wasmtime_extern_t imports[1]; imports[0].kind = WASMTIME_EXTERN_FUNC; imports[0].of.func = callback_func; wasmtime_instance_t instance; wasm_trap_t *trap = NULL; error = wasmtime_instance_new(context, module, imports, 1, &instance, &trap); if (error != NULL || trap != NULL) exit_with_error(\"failed to instantiate\", error, trap); wasmtime_module_delete(module); // Extract export. printf(\"Extracting export...\\n\"); wasmtime_extern_t run; bool ok = wasmtime_instance_export_get(context, &instance, \"g\", 1, &run); assert(ok); assert(run.kind == WASMTIME_EXTERN_FUNC); // Call. printf(\"Calling export...\\n\"); wasmtime_val_t args[2]; args[0].kind = WASMTIME_I32; args[0].of.i32 = 1; args[1].kind = WASMTIME_I64; args[1].of.i64 = 2; wasmtime_val_t results[2]; error = wasmtime_func_call(context, &run.of.func, args, 2, results, 2, &trap); if (error != NULL || trap != NULL) exit_with_error(\"failed to call run\", error, trap); // Print result. printf(\"Printing result...\\n\"); printf(\"> %\" PRIu64 \" %\" PRIu32 \"\\n\", results[0].of.i64, results[1].of.i32); assert(results[0].kind == WASMTIME_I64); assert(results[0].of.i64 == 2); assert(results[1].kind == WASMTIME_I32); assert(results[1].of.i32 == 1); // Shut down. printf(\"Shutting down...\\n\"); wasmtime_store_delete(store); wasm_engine_delete(engine); // All done. printf(\"Done.\\n\"); return 0;\n} static void exit_with_error(const char *message, wasmtime_error_t *error, wasm_trap_t *trap) { fprintf(stderr, \"error: %s\\n\", message); wasm_byte_vec_t error_message; if (error != NULL) { wasmtime_error_message(error, &error_message); wasmtime_error_delete(error); } else { wasm_trap_message(trap, &error_message); wasm_trap_delete(trap); } fprintf(stderr, \"%.*s\\n\", (int)error_message.size, error_message.data); wasm_byte_vec_delete(&error_message); exit(1);\n}","breadcrumbs":"Using the Wasmtime API » C » Using Multi-Value » multi.c","id":"88","title":"multi.c"},"89":{"body":"Wasmtime is available on PyPI and can be used programmatically or as a python module loader, which allows almost any WebAssembly module to be used as a python module. This guide will go over adding Wasmtime to your project, and some provided examples of what can be done with WebAssembly modules. Make sure you've got Python 3.5 or newer installed locally, and we can get started!","breadcrumbs":"Using the Wasmtime API » Python » Using WebAssembly from Python","id":"89","title":"Using WebAssembly from Python"},"9":{"body":"The wast command executes a *.wast file which is the test format for the official WebAssembly spec test suite. This subcommand will execute the script file which has a number of directives supported to instantiate modules, link tests, etc. Executing this looks like: $ wasmtime wast foo.wast","breadcrumbs":"Using the Wasmtime CLI » CLI Options » wast","id":"9","title":"wast"},"90":{"body":"First, copy this example WebAssembly text module into your project with the filename gcd.wat. It exports a function for calculating the greatest common denominator of two numbers. (module (func $gcd (param i32 i32) (result i32) (local i32) block ;; label = @1 block ;; label = @2 local.get 0 br_if 0 (;@2;) local.get 1 local.set 2 br 1 (;@1;) end loop ;; label = @2 local.get 1 local.get 0 local.tee 2 i32.rem_u local.set 0 local.get 2 local.set 1 local.get 0 br_if 0 (;@2;) end end local.get 2 ) (export \"gcd\" (func $gcd))\n) Next, install the Wasmtime package from PyPi. It can be installed as a dependency through Pip or related tools such as Pipenv. pip install wasmtime Or pipenv install wasmtime After you have Wasmtime installed and you've imported wasmtime, you can import WebAssembly modules in your project like any other python module. import wasmtime.loader\nimport gcd print(\"gcd(27, 6) =\", gcd.gcd(27, 6)) This script should output gcd(27, 6) = 3 If this is the output you see, congrats! You've successfully ran your first WebAssembly code in python! You can also alternatively use the wasmtime package's API : from wasmtime import Store, Module, Instance store = Store()\nmodule = Module.from_file(store.engine, 'gcd.wat')\ninstance = Instance(store, module, [])\ngcd = instance.exports(store)['gcd']\nprint(\"gcd(27, 6) = %d\" % gcd(store, 27, 6))","breadcrumbs":"Using the Wasmtime API » Python » Getting started and simple example","id":"90","title":"Getting started and simple example"},"91":{"body":"The wasmtime Python package currently lives in its own repository outside of wasmtime and has a number of other more advanced examples as well. Feel free to browse those, but if you find anything missing don't hesitate to open an issue and let us know if you have any questions!","breadcrumbs":"Using the Wasmtime API » Python » More examples and contributing","id":"91","title":"More examples and contributing"},"92":{"body":"The Wasmtime NuGet package can be used to programmatically interact with WebAssembly modules. This guide will go over adding Wasmtime to your project and demonstrate a simple example of using a WebAssembly module from C#. Make sure you have a .NET Core SDK 3.0 SDK or later installed before we get started!","breadcrumbs":"Using the Wasmtime API » .NET » Using WebAssembly from .NET","id":"92","title":"Using WebAssembly from .NET"},"93":{"body":"Start by creating a new .NET Core console project: $ mkdir gcd\n$ cd gcd\n$ dotnet new console Next, add a reference to the Wasmtime NuGet package to your project: $ dotnet add package --version 0.19.0-preview1 wasmtime Copy this example WebAssembly text module into your project directory as gcd.wat. (module (func $gcd (param i32 i32) (result i32) (local i32) block ;; label = @1 block ;; label = @2 local.get 0 br_if 0 (;@2;) local.get 1 local.set 2 br 1 (;@1;) end loop ;; label = @2 local.get 1 local.get 0 local.tee 2 i32.rem_u local.set 0 local.get 2 local.set 1 local.get 0 br_if 0 (;@2;) end end local.get 2 ) (export \"gcd\" (func $gcd))\n) This module exports a function for calculating the greatest common denominator of two numbers. Replace the code in Program.cs with the following: using System;\nusing Wasmtime; namespace Tutorial\n{ class Program { static void Main(string[] args) { using var engine = new Engine(); using var module = Module.FromTextFile(engine, \"gcd.wat\"); using var host = new Host(engine); using dynamic instance = host.Instantiate(module); Console.WriteLine($\"gcd(27, 6) = {instance.gcd(27, 6)}\"); } }\n} Run the .NET core program: $ dotnet run The program should output: gcd(27, 6) = 3 If this is the output you see, congrats! You've successfully ran your first WebAssembly code in .NET!","breadcrumbs":"Using the Wasmtime API » .NET » Getting started and simple example","id":"93","title":"Getting started and simple example"},"94":{"body":"The .NET embedding of Wasmtime repository contains the source code for the Wasmtime NuGet package. The repository also has more examples as well. Feel free to browse those, but if you find anything missing don't hesitate to open an issue and let us know if you have any questions!","breadcrumbs":"Using the Wasmtime API » .NET » More examples and contributing","id":"94","title":"More examples and contributing"},"95":{"body":"Wasmtime is available as a Go Module . This guide will go over adding Wasmtime to your project, and some provided examples of what can be done with WebAssembly modules. Make sure you're using Go 1.12 or later with modules support.","breadcrumbs":"Using the Wasmtime API » Go » Using WebAssembly from Go","id":"95","title":"Using WebAssembly from Go"},"96":{"body":"First up you'll want to start a new module: $ mkdir hello-wasm\n$ cd hello-wasm\n$ go mod init hello-wasm\n$ go get github.com/bytecodealliance/wasmtime-go Next, copy this example WebAssembly text module into your project. It exports a function for calculating the greatest common denominator of two numbers. (module (func $gcd (param i32 i32) (result i32) (local i32) block ;; label = @1 block ;; label = @2 local.get 0 br_if 0 (;@2;) local.get 1 local.set 2 br 1 (;@1;) end loop ;; label = @2 local.get 1 local.get 0 local.tee 2 i32.rem_u local.set 0 local.get 2 local.set 1 local.get 0 br_if 0 (;@2;) end end local.get 2 ) (export \"gcd\" (func $gcd))\n) Next, we can write our code in main.go which reads this file and runs it: package main import ( \"fmt\" \"github.com/bytecodealliance/wasmtime-go\"\n) func main() { engine := wasmtime.NewEngine() store := wasmtime.NewStore(engine) module, err := wasmtime.NewModuleFromFile(engine, \"gcd.wat\") check(err) instance, err := wasmtime.NewInstance(store, module, []wasmtime.AsExtern{}) check(err) gcd := instance.GetExport(store, \"gcd\").Func() val, err := gcd.Call(store, 6, 27) check(err) fmt.Printf(\"gcd(6, 27) = %d\\n\", val.(int32))\n} func check(err error) { if err != nil { panic(err) }\n} And finally we can build and run it: $ go run main.go\ngcd(6, 27) = 3 If this is the output you see, congrats! You've successfully ran your first WebAssembly code in Go!","breadcrumbs":"Using the Wasmtime API » Go » Getting started and simple example","id":"96","title":"Getting started and simple example"},"97":{"body":"The wasmtime Go package lives in its own repository and has a number of other more advanced examples as well. Feel free to browse those, but if you find anything missing don't hesitate to open an issue and let us know if you have any questions!","breadcrumbs":"Using the Wasmtime API » Go » More examples and contributing","id":"97","title":"More examples and contributing"},"98":{"body":"","breadcrumbs":"Using the Wasmtime API » Bash » Using WebAssembly from Bash","id":"98","title":"Using WebAssembly from Bash"},"99":{"body":"First up you'll want to start a new module: $ mkdir -p gcd-bash\n$ cd gcd-bash\n$ touch gcd.wat gcd.sh Next, copy this example WebAssembly text module into your project. It exports a function for calculating the greatest common denominator of two numbers.","breadcrumbs":"Using the Wasmtime API » Bash » Getting started and simple example","id":"99","title":"Getting started and simple example"}},"length":236,"save":true},"fields":["title","body","breadcrumbs"],"index":{"body":{"root":{"0":{")":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},".":{"0":{"6":{"6":{"df":1,"docs":{"122":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"1":{".":{"0":{"df":1,"docs":{"125":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{".":{"0":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}},"2":{"df":1,"docs":{"122":{"tf":1.0}}},"df":0,"docs":{}},"4":{"7":{"df":1,"docs":{"117":{"tf":1.0}}},"df":0,"docs":{}},"9":{".":{"0":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"2":{"2":{"df":1,"docs":{"122":{"tf":1.0}}},"df":0,"docs":{}},"3":{"9":{"df":1,"docs":{"122":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{"9":{"2":{"df":1,"docs":{"122":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"\\":{"0":{"2":{"\\":{"0":{"3":{"\\":{"0":{"4":{"\\":{"0":{"5":{"\\":{"0":{"6":{"\\":{"0":{"7":{"\\":{"0":{"8":{"\\":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"194":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"48":{"tf":1.0},"75":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"\\":{"0":{"2":{"\\":{"\\":{"0":{"3":{"\\":{"\\":{"0":{"4":{"\\":{"\\":{"0":{"5":{"\\":{"\\":{"0":{"6":{"\\":{"\\":{"0":{"7":{"\\":{"\\":{"0":{"8":{"\\":{"\\":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"194":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{":":{"3":{"3":{"df":1,"docs":{"130":{"tf":1.0}}},"4":{"df":1,"docs":{"130":{"tf":1.0}}},"7":{"df":1,"docs":{"130":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"4":{"0":{"df":1,"docs":{"130":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"130":{"tf":1.0}}},"3":{"df":1,"docs":{"130":{"tf":1.4142135623730951}}},"4":{"df":1,"docs":{"130":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{":":{"3":{"9":{"df":1,"docs":{"130":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":31,"docs":{"100":{"tf":2.449489742783178},"101":{"tf":1.0},"103":{"tf":2.449489742783178},"106":{"tf":2.449489742783178},"111":{"tf":1.4142135623730951},"128":{"tf":2.0},"158":{"tf":1.4142135623730951},"194":{"tf":3.0},"40":{"tf":1.4142135623730951},"43":{"tf":1.0},"45":{"tf":2.449489742783178},"48":{"tf":1.4142135623730951},"49":{"tf":2.449489742783178},"58":{"tf":1.7320508075688772},"63":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"70":{"tf":2.0},"72":{"tf":2.449489742783178},"73":{"tf":1.7320508075688772},"75":{"tf":1.4142135623730951},"76":{"tf":3.7416573867739413},"79":{"tf":2.23606797749979},"82":{"tf":1.7320508075688772},"83":{"tf":1.7320508075688772},"85":{"tf":1.4142135623730951},"87":{"tf":1.4142135623730951},"88":{"tf":1.0},"90":{"tf":2.449489742783178},"93":{"tf":2.449489742783178},"96":{"tf":2.449489742783178}},"l":{"df":7,"docs":{"70":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"85":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951}}},"x":{"1":{"0":{"0":{"0":{"df":4,"docs":{"48":{"tf":1.0},"49":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0}}},"2":{"df":2,"docs":{"49":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951}}},"3":{"df":2,"docs":{"49":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"3":{"df":1,"docs":{"128":{"tf":1.0}}},"6":{"1":{"0":{"df":1,"docs":{"128":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"3":{"4":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"/":{"1":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":2,"docs":{"49":{"tf":1.0},"76":{"tf":1.0}}}}}}},"2":{"0":{"0":{"0":{"0":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":2,"docs":{"49":{"tf":2.0},"76":{"tf":2.23606797749979}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"4":{"9":{"df":1,"docs":{"128":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"7":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"3":{"0":{"0":{"0":{"0":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":2,"docs":{"49":{"tf":1.4142135623730951},"76":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"6":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}}},"4":{"0":{"b":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"3":{"4":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"7":{"b":{"d":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"5":{"d":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"7":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"f":{"0":{"2":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"5":{"5":{"5":{"d":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"2":{"a":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"6":{"1":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":1,"docs":{"111":{"tf":1.0}}}}},"6":{"0":{"a":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"1":{"6":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"6":{"1":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"8":{"7":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"7":{"df":1,"docs":{"128":{"tf":1.0}}},"df":0,"docs":{}},"a":{"c":{"0":{"1":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{"1":{"c":{"5":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"1":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},".":{"0":{"7":{"df":1,"docs":{"194":{"tf":1.0}}},"df":0,"docs":{}},"1":{"2":{"df":1,"docs":{"95":{"tf":1.0}}},"df":0,"docs":{}},"4":{"df":1,"docs":{"235":{"tf":1.0}}},"7":{"0":{".":{"0":{"df":1,"docs":{"205":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{".":{"0":{"df":1,"docs":{"205":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{".":{"0":{"df":1,"docs":{"205":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{",":{"0":{"0":{"0":{"df":1,"docs":{"209":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"df":2,"docs":{"136":{"tf":1.0},"157":{"tf":1.0}}},"6":{"df":1,"docs":{"194":{"tf":1.0}}},"df":3,"docs":{"111":{"tf":1.0},"130":{"tf":1.0},"63":{"tf":1.0}},"m":{"df":1,"docs":{"127":{"tf":1.0}}}},"1":{"3":{"4":{"9":{"0":{"3":{"1":{"7":{"0":{"df":1,"docs":{"122":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"df":1,"docs":{"194":{"tf":1.0}}},"df":1,"docs":{"111":{"tf":1.0}}},"2":{"df":2,"docs":{"101":{"tf":1.0},"111":{"tf":1.0}}},"3":{"0":{"df":0,"docs":{},"m":{"df":1,"docs":{"131":{"tf":1.0}}}},"df":1,"docs":{"111":{"tf":1.0}}},"4":{"0":{"df":0,"docs":{},"m":{"df":1,"docs":{"130":{"tf":1.0}}}},"8":{"2":{"df":1,"docs":{"110":{"tf":1.0}}},"df":0,"docs":{}},"df":4,"docs":{"111":{"tf":1.0},"122":{"tf":1.0},"57":{"tf":1.0},"81":{"tf":1.0}}},"5":{"df":1,"docs":{"111":{"tf":1.0}}},"6":{"df":4,"docs":{"111":{"tf":1.0},"130":{"tf":1.0},"17":{"tf":1.0},"194":{"tf":1.0}}},"7":{"df":1,"docs":{"111":{"tf":1.0}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"125":{"tf":1.0}}}}},"8":{".":{"0":{".":{"0":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"111":{"tf":1.0},"130":{"tf":3.605551275463989}}},"9":{".":{"0":{".":{"0":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"3":{"df":1,"docs":{"110":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"122":{"tf":1.0}}},"d":{"df":1,"docs":{"23":{"tf":1.0}}},"df":42,"docs":{"100":{"tf":2.449489742783178},"101":{"tf":1.0},"103":{"tf":2.449489742783178},"106":{"tf":2.449489742783178},"110":{"tf":1.0},"111":{"tf":1.4142135623730951},"117":{"tf":1.7320508075688772},"122":{"tf":1.4142135623730951},"128":{"tf":1.7320508075688772},"13":{"tf":1.0},"130":{"tf":3.4641016151377544},"137":{"tf":1.7320508075688772},"138":{"tf":3.3166247903554},"150":{"tf":1.0},"194":{"tf":2.449489742783178},"40":{"tf":1.4142135623730951},"43":{"tf":1.0},"45":{"tf":2.449489742783178},"48":{"tf":1.0},"49":{"tf":1.7320508075688772},"51":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.7320508075688772},"65":{"tf":1.4142135623730951},"66":{"tf":2.23606797749979},"70":{"tf":2.0},"72":{"tf":2.449489742783178},"73":{"tf":2.23606797749979},"75":{"tf":1.0},"76":{"tf":3.605551275463989},"79":{"tf":1.4142135623730951},"81":{"tf":1.0},"82":{"tf":1.7320508075688772},"83":{"tf":1.4142135623730951},"85":{"tf":2.449489742783178},"87":{"tf":1.4142135623730951},"88":{"tf":2.8284271247461903},"90":{"tf":2.449489742783178},"93":{"tf":2.449489742783178},"96":{"tf":2.449489742783178}},"g":{"df":0,"docs":{},"i":{"df":1,"docs":{"14":{"tf":1.0}}}},"h":{"df":1,"docs":{"21":{"tf":1.0}}},"m":{"df":1,"docs":{"131":{"tf":1.0}}}},"2":{".":{"0":{".":{"0":{"df":1,"docs":{"225":{"tf":1.7320508075688772}}},"1":{"df":1,"docs":{"225":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"df":0,"docs":{},"m":{"df":2,"docs":{"130":{"tf":1.0},"131":{"tf":1.4142135623730951}}}},"3":{"df":0,"docs":{},"m":{"df":1,"docs":{"130":{"tf":1.0}}}},"4":{"df":0,"docs":{},"m":{"df":1,"docs":{"130":{"tf":1.4142135623730951}}}},"8":{"df":0,"docs":{},"m":{"df":1,"docs":{"131":{"tf":1.0}}}},"df":0,"docs":{}},"0":{"0":{"df":0,"docs":{},"k":{"df":1,"docs":{"131":{"tf":1.0}}}},"2":{"3":{"df":2,"docs":{"125":{"tf":1.0},"130":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"19":{"tf":1.0}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"224":{"tf":1.4142135623730951}}}}},"5":{"6":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}},"6":{"7":{"9":{"1":{"4":{"2":{"9":{"6":{"df":1,"docs":{"117":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{"df":7,"docs":{"101":{"tf":1.4142135623730951},"103":{"tf":1.0},"106":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"73":{"tf":1.0},"90":{"tf":1.0},"96":{"tf":1.7320508075688772}}},">":{"&":{"1":{"df":1,"docs":{"194":{"tf":1.0}}},"df":0,"docs":{}},"/":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"/":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"101":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":34,"docs":{"100":{"tf":2.8284271247461903},"101":{"tf":1.4142135623730951},"103":{"tf":2.8284271247461903},"106":{"tf":2.8284271247461903},"111":{"tf":1.4142135623730951},"117":{"tf":1.4142135623730951},"122":{"tf":1.4142135623730951},"128":{"tf":1.4142135623730951},"130":{"tf":1.0},"137":{"tf":1.7320508075688772},"138":{"tf":3.605551275463989},"192":{"tf":1.0},"194":{"tf":2.0},"209":{"tf":1.0},"40":{"tf":1.7320508075688772},"45":{"tf":2.8284271247461903},"48":{"tf":1.0},"49":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"57":{"tf":1.0},"58":{"tf":1.4142135623730951},"65":{"tf":1.0},"66":{"tf":1.7320508075688772},"72":{"tf":2.8284271247461903},"73":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":2.23606797749979},"81":{"tf":1.0},"82":{"tf":1.4142135623730951},"87":{"tf":1.0},"88":{"tf":2.0},"90":{"tf":2.8284271247461903},"93":{"tf":2.8284271247461903},"96":{"tf":2.8284271247461903}},"g":{"b":{"df":2,"docs":{"145":{"tf":1.0},"164":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"3":{".":{"0":{"df":2,"docs":{"102":{"tf":1.0},"92":{"tf":1.0}}},"3":{"df":0,"docs":{},"m":{"df":1,"docs":{"130":{"tf":1.4142135623730951}}}},"4":{"8":{"0":{"df":1,"docs":{"122":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"df":1,"docs":{"89":{"tf":1.0}}},"7":{"5":{"df":1,"docs":{"194":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"df":0,"docs":{},"m":{"df":2,"docs":{"14":{"tf":1.0},"22":{"tf":1.0}}}},"2":{"df":6,"docs":{"118":{"tf":1.0},"137":{"tf":1.7320508075688772},"140":{"tf":1.0},"145":{"tf":1.0},"164":{"tf":1.7320508075688772},"194":{"tf":1.4142135623730951}}},"3":{"df":0,"docs":{},"m":{"df":1,"docs":{"130":{"tf":1.0}}}},"4":{"3":{"5":{"df":1,"docs":{"117":{"tf":1.0}}},"df":0,"docs":{}},"4":{"df":1,"docs":{"194":{"tf":1.0}}},"df":0,"docs":{}},"5":{"4":{"df":1,"docs":{"194":{"tf":1.0}}},"7":{"df":1,"docs":{"194":{"tf":1.0}}},"9":{"df":1,"docs":{"194":{"tf":1.0}}},"df":0,"docs":{}},"6":{"9":{"df":1,"docs":{"194":{"tf":1.0}}},"df":1,"docs":{"63":{"tf":1.0}}},"df":21,"docs":{"103":{"tf":1.0},"106":{"tf":1.0},"111":{"tf":1.0},"130":{"tf":1.0},"137":{"tf":1.7320508075688772},"138":{"tf":2.6457513110645907},"18":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.7320508075688772},"70":{"tf":1.0},"73":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"87":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0}}},"4":{".":{"0":{".":{"0":{"df":1,"docs":{"134":{"tf":1.0}}},"1":{"df":1,"docs":{"134":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"9":{"df":1,"docs":{"194":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"0":{"df":0,"docs":{},"k":{"df":1,"docs":{"132":{"tf":1.0}}}},"df":0,"docs":{}},"2":{".":{"3":{"2":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"101":{"tf":1.0},"111":{"tf":1.4142135623730951},"117":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.4142135623730951},"63":{"tf":1.0}}},"5":{"df":1,"docs":{"122":{"tf":1.0}}},"df":10,"docs":{"111":{"tf":1.0},"137":{"tf":1.0},"217":{"tf":1.0},"49":{"tf":1.4142135623730951},"58":{"tf":1.7320508075688772},"65":{"tf":1.0},"66":{"tf":1.7320508075688772},"76":{"tf":1.4142135623730951},"82":{"tf":1.7320508075688772},"87":{"tf":1.0}},"g":{"b":{"df":1,"docs":{"164":{"tf":1.0}}},"df":0,"docs":{}}},"5":{".":{"0":{".":{"0":{"df":1,"docs":{"134":{"tf":1.4142135623730951}}},"1":{"df":1,"docs":{"134":{"tf":1.0}}},"df":0,"docs":{}},"9":{"df":1,"docs":{"194":{"tf":1.0}}},"df":0,"docs":{},"m":{"df":1,"docs":{"130":{"tf":1.0}}}},"df":0,"docs":{}},"1":{"2":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{}},"df":7,"docs":{"111":{"tf":1.0},"194":{"tf":1.0},"49":{"tf":2.0},"65":{"tf":1.0},"66":{"tf":1.4142135623730951},"76":{"tf":2.449489742783178},"87":{"tf":1.0}},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"134":{"tf":1.0},"224":{"tf":1.4142135623730951}}}}},"6":{".":{"7":{"df":0,"docs":{},"m":{"df":1,"docs":{"130":{"tf":1.4142135623730951}}}},"8":{"df":0,"docs":{},"m":{"df":1,"docs":{"130":{"tf":1.0}}}},"df":0,"docs":{}},"4":{"df":3,"docs":{"118":{"tf":1.0},"164":{"tf":2.0},"195":{"tf":1.0}}},"5":{"5":{"3":{"6":{"df":3,"docs":{"26":{"tf":1.0},"58":{"tf":1.0},"82":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{".":{"3":{"6":{"df":1,"docs":{"194":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":17,"docs":{"101":{"tf":1.4142135623730951},"103":{"tf":1.7320508075688772},"106":{"tf":1.4142135623730951},"111":{"tf":1.0},"225":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.7320508075688772},"61":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.4142135623730951},"73":{"tf":1.0},"76":{"tf":1.7320508075688772},"85":{"tf":1.0},"87":{"tf":1.0},"90":{"tf":2.23606797749979},"93":{"tf":1.7320508075688772},"96":{"tf":1.0}},"g":{"b":{"df":1,"docs":{"164":{"tf":1.0}}},"df":0,"docs":{}}},"7":{".":{"7":{"7":{"df":1,"docs":{"194":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"df":2,"docs":{"28":{"tf":1.0},"29":{"tf":1.0}}},"1":{".":{"5":{"8":{"df":1,"docs":{"194":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{".":{"8":{"0":{"df":1,"docs":{"194":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{".":{"6":{"0":{"df":1,"docs":{"194":{"tf":1.0}}},"df":0,"docs":{}},"8":{"7":{"df":1,"docs":{"194":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{"7":{"9":{"df":1,"docs":{"194":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":5,"docs":{"111":{"tf":1.0},"122":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.4142135623730951},"87":{"tf":1.0}}},"8":{"df":5,"docs":{"111":{"tf":1.0},"194":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.4142135623730951},"87":{"tf":1.0}},"g":{"b":{"df":1,"docs":{"164":{"tf":1.0}}},"df":0,"docs":{}}},"9":{"0":{"df":1,"docs":{"194":{"tf":1.4142135623730951}}},"1":{"df":1,"docs":{"194":{"tf":1.0}}},"4":{"df":1,"docs":{"194":{"tf":1.0}}},"9":{"df":1,"docs":{"117":{"tf":1.0}}},"df":5,"docs":{"111":{"tf":1.0},"194":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.4142135623730951},"87":{"tf":1.0}}},"_":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"x":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"122":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"v":{"df":0,"docs":{},"m":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"110":{"tf":1.0}}}}}},"df":1,"docs":{"110":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"53":{"tf":1.0}}}}}}}},"n":{"df":0,"docs":{},"o":{"_":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"110":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.0},"194":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}}},"a":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"6":{"4":{"df":9,"docs":{"130":{"tf":1.7320508075688772},"137":{"tf":2.23606797749979},"139":{"tf":1.4142135623730951},"140":{"tf":1.4142135623730951},"195":{"tf":1.0},"196":{"tf":1.0},"197":{"tf":1.0},"199":{"tf":1.4142135623730951},"200":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"b":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":3,"docs":{"160":{"tf":2.0},"163":{"tf":1.0},"218":{"tf":1.0}},"l":{"df":3,"docs":{"128":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.0}}},"{":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"=":{"\"":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"1":{"df":1,"docs":{"13":{"tf":2.0}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":4,"docs":{"130":{"tf":1.0},"132":{"tf":1.0},"145":{"tf":1.0},"151":{"tf":1.0}}}},"v":{"df":19,"docs":{"124":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.4142135623730951},"132":{"tf":1.0},"137":{"tf":1.0},"151":{"tf":1.0},"162":{"tf":1.0},"167":{"tf":1.0},"192":{"tf":1.0},"204":{"tf":1.0},"209":{"tf":1.0},"221":{"tf":1.0},"225":{"tf":1.7320508075688772},"226":{"tf":1.0},"40":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"70":{"tf":1.0}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"234":{"tf":1.0}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":9,"docs":{"130":{"tf":1.0},"134":{"tf":1.0},"138":{"tf":1.7320508075688772},"184":{"tf":1.0},"221":{"tf":1.0},"222":{"tf":1.0},"231":{"tf":1.0},"232":{"tf":1.0},"7":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":19,"docs":{"0":{"tf":1.0},"144":{"tf":2.0},"145":{"tf":1.4142135623730951},"146":{"tf":2.0},"148":{"tf":2.0},"150":{"tf":1.0},"151":{"tf":2.0},"157":{"tf":1.0},"158":{"tf":1.7320508075688772},"162":{"tf":1.4142135623730951},"163":{"tf":1.0},"194":{"tf":1.0},"39":{"tf":1.4142135623730951},"40":{"tf":1.0},"43":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"143":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.7320508075688772},"163":{"tf":1.0}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"138":{"tf":1.0}}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"212":{"tf":1.0}}}}},"df":0,"docs":{}}},"r":{"d":{"df":6,"docs":{"142":{"tf":1.0},"160":{"tf":1.0},"162":{"tf":1.0},"194":{"tf":1.0},"202":{"tf":1.0},"34":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"131":{"tf":1.4142135623730951},"233":{"tf":1.0}}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":2,"docs":{"152":{"tf":1.4142135623730951},"209":{"tf":1.0}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"158":{"tf":1.0},"24":{"tf":1.4142135623730951}}}}}},"t":{"df":2,"docs":{"180":{"tf":1.0},"233":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"122":{"tf":1.7320508075688772},"189":{"tf":1.0},"192":{"tf":1.0},"207":{"tf":1.0},"232":{"tf":1.0}}}},"v":{"df":3,"docs":{"118":{"tf":1.4142135623730951},"137":{"tf":1.0},"166":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":16,"docs":{"1":{"tf":1.0},"145":{"tf":1.0},"157":{"tf":1.0},"158":{"tf":2.0},"159":{"tf":1.7320508075688772},"160":{"tf":1.0},"161":{"tf":1.0},"162":{"tf":1.4142135623730951},"163":{"tf":1.0},"167":{"tf":1.4142135623730951},"169":{"tf":1.0},"194":{"tf":1.0},"226":{"tf":1.4142135623730951},"25":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":4,"docs":{"192":{"tf":1.0},"218":{"tf":2.0},"235":{"tf":1.0},"54":{"tf":1.0}}}}},"d":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"53":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":24,"docs":{"103":{"tf":1.0},"128":{"tf":1.4142135623730951},"132":{"tf":1.0},"139":{"tf":1.0},"141":{"tf":1.0},"176":{"tf":1.0},"177":{"tf":1.0},"183":{"tf":2.0},"184":{"tf":1.4142135623730951},"185":{"tf":1.7320508075688772},"196":{"tf":1.0},"199":{"tf":1.0},"200":{"tf":1.0},"206":{"tf":1.0},"207":{"tf":1.0},"208":{"tf":1.7320508075688772},"209":{"tf":2.0},"213":{"tf":1.0},"216":{"tf":3.0},"224":{"tf":1.0},"39":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951},"83":{"tf":1.0},"93":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"t":{"df":15,"docs":{"1":{"tf":1.0},"110":{"tf":1.0},"113":{"tf":1.0},"130":{"tf":1.0},"138":{"tf":1.4142135623730951},"145":{"tf":1.0},"162":{"tf":1.0},"167":{"tf":1.0},"180":{"tf":1.0},"201":{"tf":1.0},"207":{"tf":1.0},"208":{"tf":1.0},"212":{"tf":1.0},"220":{"tf":1.0},"226":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":16,"docs":{"130":{"tf":1.7320508075688772},"132":{"tf":1.4142135623730951},"136":{"tf":1.7320508075688772},"137":{"tf":1.0},"138":{"tf":1.4142135623730951},"143":{"tf":1.0},"145":{"tf":1.0},"157":{"tf":1.0},"159":{"tf":1.4142135623730951},"164":{"tf":1.4142135623730951},"191":{"tf":1.0},"194":{"tf":1.0},"203":{"tf":1.0},"206":{"tf":1.4142135623730951},"209":{"tf":1.0},"224":{"tf":1.0}}}}}}},"r":{":":{"#":{"df":0,"docs":{},"x":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":0,"docs":{}},"=":{"0":{".":{"0":{".":{"0":{".":{"0":{":":{"8":{"0":{"8":{"1":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"128":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":14,"docs":{"110":{"tf":1.0},"128":{"tf":1.0},"138":{"tf":1.0},"144":{"tf":1.7320508075688772},"145":{"tf":1.0},"159":{"tf":1.4142135623730951},"162":{"tf":1.0},"164":{"tf":1.7320508075688772},"190":{"tf":1.0},"222":{"tf":1.0},"231":{"tf":1.0},"233":{"tf":1.0},"49":{"tf":1.0},"8":{"tf":1.0}}}}}}},"df":19,"docs":{"103":{"tf":1.0},"120":{"tf":1.4142135623730951},"138":{"tf":1.4142135623730951},"180":{"tf":1.0},"182":{"tf":1.0},"183":{"tf":1.4142135623730951},"184":{"tf":1.4142135623730951},"185":{"tf":1.7320508075688772},"206":{"tf":1.0},"207":{"tf":1.4142135623730951},"209":{"tf":1.7320508075688772},"216":{"tf":1.0},"218":{"tf":1.7320508075688772},"224":{"tf":1.0},"227":{"tf":1.0},"52":{"tf":1.0},"89":{"tf":1.0},"92":{"tf":1.0},"95":{"tf":1.0}},"j":{"a":{"c":{"df":1,"docs":{"162":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"v":{"a":{"df":0,"docs":{},"n":{"c":{"df":4,"docs":{"104":{"tf":1.0},"231":{"tf":1.0},"91":{"tf":1.0},"97":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"221":{"tf":1.4142135623730951},"222":{"tf":1.7320508075688772}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"226":{"tf":2.23606797749979}},"e":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"226":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":6,"docs":{"130":{"tf":1.0},"138":{"tf":2.6457513110645907},"150":{"tf":1.0},"164":{"tf":1.0},"212":{"tf":1.4142135623730951},"221":{"tf":1.0}}}},"df":0,"docs":{}}},"l":{"df":1,"docs":{"187":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"130":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"df":8,"docs":{"145":{"tf":1.0},"161":{"tf":1.0},"164":{"tf":1.0},"185":{"tf":1.0},"209":{"tf":1.4142135623730951},"224":{"tf":1.4142135623730951},"226":{"tf":1.0},"55":{"tf":1.0}}}}}}},"df":1,"docs":{"230":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"153":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":1,"docs":{"113":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"159":{"tf":1.0},"187":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"138":{"tf":1.0}}}}}}}}}},"h":{"df":0,"docs":{},"e":{"a":{"d":{"df":2,"docs":{"11":{"tf":1.0},"226":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"220":{"tf":1.0}}}},"k":{"a":{"df":1,"docs":{"163":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"206":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"121":{"tf":1.0},"190":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":1,"docs":{"122":{"tf":1.0}}}}}}}}},"i":{"a":{"df":1,"docs":{"162":{"tf":1.0}},"s":{"df":1,"docs":{"158":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"232":{"tf":1.0}}}},"v":{"df":1,"docs":{"162":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"c":{"df":4,"docs":{"0":{"tf":1.0},"135":{"tf":1.0},"149":{"tf":1.0},"234":{"tf":1.0}},"e":{"'":{"df":1,"docs":{"234":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"o":{"c":{"df":12,"docs":{"128":{"tf":1.7320508075688772},"132":{"tf":1.4142135623730951},"141":{"tf":1.0},"142":{"tf":1.0},"150":{"tf":1.0},"158":{"tf":2.23606797749979},"159":{"tf":1.0},"162":{"tf":2.23606797749979},"164":{"tf":1.7320508075688772},"165":{"tf":1.4142135623730951},"166":{"tf":1.0},"70":{"tf":1.0}}},"df":0,"docs":{},"w":{"df":14,"docs":{"1":{"tf":1.0},"130":{"tf":1.0},"147":{"tf":1.0},"203":{"tf":1.4142135623730951},"204":{"tf":1.4142135623730951},"21":{"tf":1.0},"218":{"tf":1.0},"22":{"tf":1.0},"224":{"tf":1.0},"23":{"tf":1.0},"34":{"tf":1.0},"40":{"tf":1.0},"61":{"tf":1.0},"89":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"208":{"tf":1.0},"220":{"tf":1.0},"49":{"tf":1.0},"76":{"tf":1.4142135623730951}},"g":{"df":6,"docs":{"130":{"tf":1.0},"132":{"tf":1.0},"139":{"tf":1.0},"146":{"tf":1.0},"160":{"tf":1.0},"54":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":11,"docs":{"113":{"tf":1.0},"122":{"tf":1.0},"131":{"tf":1.4142135623730951},"138":{"tf":2.0},"183":{"tf":1.0},"199":{"tf":1.0},"21":{"tf":1.0},"213":{"tf":1.0},"225":{"tf":1.0},"24":{"tf":1.0},"38":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":4,"docs":{"117":{"tf":1.0},"175":{"tf":1.0},"179":{"tf":1.0},"90":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":4,"docs":{"158":{"tf":1.0},"167":{"tf":1.4142135623730951},"220":{"tf":1.0},"221":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"164":{"tf":1.0},"207":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"121":{"tf":1.0},"122":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":13,"docs":{"150":{"tf":1.7320508075688772},"153":{"tf":1.0},"158":{"tf":1.7320508075688772},"160":{"tf":1.0},"162":{"tf":1.0},"191":{"tf":1.4142135623730951},"203":{"tf":1.0},"204":{"tf":1.0},"207":{"tf":1.0},"209":{"tf":1.0},"224":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"209":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"152":{"tf":1.0}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"130":{"tf":1.4142135623730951}}}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"x":{"df":1,"docs":{"122":{"tf":2.6457513110645907}}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"128":{"tf":1.0}}}},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":7,"docs":{"109":{"tf":1.0},"111":{"tf":1.4142135623730951},"118":{"tf":1.4142135623730951},"124":{"tf":1.4142135623730951},"159":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0}}}},"z":{"df":1,"docs":{"118":{"tf":1.0}}}}}},"d":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"152":{"tf":1.0},"216":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"137":{"tf":1.7320508075688772},"139":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":8,"docs":{"115":{"tf":1.0},"117":{"tf":1.7320508075688772},"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0}}},"u":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"226":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":13,"docs":{"107":{"tf":1.0},"124":{"tf":1.0},"138":{"tf":1.0},"140":{"tf":1.0},"160":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":1.0},"183":{"tf":1.0},"193":{"tf":1.0},"2":{"tf":1.0},"214":{"tf":1.0},"224":{"tf":1.0},"226":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"147":{"tf":2.0}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":3,"docs":{"212":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":2.6457513110645907}}}}}},"y":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":3,"docs":{"53":{"tf":1.0},"55":{"tf":1.0},"66":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"53":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"139":{"tf":1.0},"214":{"tf":1.4142135623730951},"220":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":12,"docs":{"103":{"tf":1.0},"106":{"tf":1.0},"116":{"tf":1.0},"131":{"tf":1.0},"138":{"tf":1.4142135623730951},"150":{"tf":1.0},"212":{"tf":1.0},"221":{"tf":1.0},"7":{"tf":1.0},"91":{"tf":1.0},"94":{"tf":1.0},"97":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"t":{"df":4,"docs":{"11":{"tf":2.0},"131":{"tf":1.0},"140":{"tf":1.4142135623730951},"142":{"tf":1.0}}}},"p":{"df":0,"docs":{},"i":{"/":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"b":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{".":{"c":{"df":1,"docs":{"76":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{".":{"c":{"df":1,"docs":{"88":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":6,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"174":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":44,"docs":{"1":{"tf":1.0},"104":{"tf":1.0},"107":{"tf":1.0},"111":{"tf":1.0},"114":{"tf":1.7320508075688772},"115":{"tf":1.7320508075688772},"116":{"tf":1.7320508075688772},"118":{"tf":1.4142135623730951},"119":{"tf":1.7320508075688772},"120":{"tf":1.4142135623730951},"126":{"tf":1.7320508075688772},"131":{"tf":2.23606797749979},"132":{"tf":1.7320508075688772},"134":{"tf":2.0},"135":{"tf":1.0},"142":{"tf":1.4142135623730951},"143":{"tf":1.0},"145":{"tf":1.4142135623730951},"146":{"tf":1.0},"157":{"tf":1.7320508075688772},"159":{"tf":1.0},"160":{"tf":1.0},"167":{"tf":1.4142135623730951},"174":{"tf":1.0},"192":{"tf":1.4142135623730951},"216":{"tf":2.23606797749979},"217":{"tf":1.7320508075688772},"225":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"51":{"tf":1.0},"54":{"tf":1.7320508075688772},"55":{"tf":2.0},"56":{"tf":1.0},"67":{"tf":1.4142135623730951},"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0},"90":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"209":{"tf":1.0},"230":{"tf":1.0},"39":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"175":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":3,"docs":{"130":{"tf":2.449489742783178},"137":{"tf":1.4142135623730951},"195":{"tf":1.0}},"i":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":3,"docs":{"114":{"tf":1.0},"115":{"tf":1.0},"126":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}},"df":12,"docs":{"0":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"122":{"tf":1.0},"124":{"tf":1.4142135623730951},"126":{"tf":1.0},"144":{"tf":1.4142135623730951},"146":{"tf":1.0},"147":{"tf":1.0},"203":{"tf":1.0},"225":{"tf":1.0},"36":{"tf":1.0}}},"df":7,"docs":{"130":{"tf":1.4142135623730951},"131":{"tf":1.0},"136":{"tf":1.0},"145":{"tf":1.0},"195":{"tf":1.0},"220":{"tf":1.0},"233":{"tf":1.0}}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"233":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":3,"docs":{"151":{"tf":1.0},"213":{"tf":1.0},"220":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"o":{"a":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"195":{"tf":1.0},"222":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":13,"docs":{"118":{"tf":1.0},"124":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.0},"185":{"tf":1.0},"195":{"tf":1.0},"199":{"tf":1.0},"200":{"tf":1.0},"211":{"tf":1.0},"221":{"tf":1.0},"226":{"tf":1.0},"232":{"tf":1.0},"234":{"tf":1.0}}}}},"v":{"df":3,"docs":{"190":{"tf":1.0},"208":{"tf":1.0},"220":{"tf":1.0}}}}}},"t":{"df":2,"docs":{"197":{"tf":1.0},"198":{"tf":1.0}}}},"r":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"144":{"tf":1.0},"185":{"tf":1.0},"203":{"tf":1.0},"43":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"c":{"<":{"d":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"df":1,"docs":{"165":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"222":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":8,"docs":{"0":{"tf":1.0},"118":{"tf":1.0},"138":{"tf":2.0},"156":{"tf":1.0},"195":{"tf":1.0},"196":{"tf":1.0},"199":{"tf":1.0},"221":{"tf":1.0}}}}}},"df":0,"docs":{}}},"v":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"e":{"a":{"df":2,"docs":{"212":{"tf":1.0},"221":{"tf":1.4142135623730951}}},"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":5,"docs":{"137":{"tf":1.0},"153":{"tf":1.0},"155":{"tf":1.0},"157":{"tf":1.0},"206":{"tf":1.0}}}},"df":0,"docs":{}}},"g":{"1":{"df":1,"docs":{"76":{"tf":2.449489742783178}}},"2":{"df":1,"docs":{"76":{"tf":2.449489742783178}}},"c":{"df":3,"docs":{"76":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}},"df":6,"docs":{"110":{"tf":1.0},"63":{"tf":1.4142135623730951},"70":{"tf":1.0},"76":{"tf":3.872983346207417},"88":{"tf":1.7320508075688772},"93":{"tf":1.0}},"s":{"[":{"0":{"]":{".":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"76":{"tf":2.23606797749979},"88":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"i":{"3":{"2":{"df":2,"docs":{"76":{"tf":2.23606797749979},"88":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"88":{"tf":1.0}}},"1":{"]":{".":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"76":{"tf":1.7320508075688772},"88":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"76":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"6":{"4":{"df":1,"docs":{"88":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":2,"docs":{"76":{"tf":1.4142135623730951},"88":{"tf":1.0}}},"2":{"df":2,"docs":{"76":{"tf":1.7320508075688772},"88":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":13,"docs":{"131":{"tf":1.4142135623730951},"132":{"tf":1.0},"180":{"tf":1.0},"185":{"tf":1.0},"194":{"tf":1.4142135623730951},"224":{"tf":1.7320508075688772},"225":{"tf":1.4142135623730951},"226":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"53":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}}}},"v":{"df":3,"docs":{"76":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}}},"i":{"df":0,"docs":{},"s":{"df":2,"docs":{"145":{"tf":1.0},"163":{"tf":1.0}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}}}}}},"m":{"df":1,"docs":{"137":{"tf":1.0}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":6,"docs":{"155":{"tf":1.0},"158":{"tf":1.0},"166":{"tf":1.0},"220":{"tf":1.4142135623730951},"221":{"tf":1.0},"43":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"221":{"tf":1.0}}}},"y":{"df":3,"docs":{"150":{"tf":1.0},"158":{"tf":1.0},"162":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"t":{"df":1,"docs":{"222":{"tf":1.0}},"i":{"df":0,"docs":{},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":7,"docs":{"130":{"tf":1.0},"131":{"tf":1.7320508075688772},"137":{"tf":1.4142135623730951},"142":{"tf":1.0},"192":{"tf":2.23606797749979},"224":{"tf":1.4142135623730951},"3":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"k":{"df":8,"docs":{"153":{"tf":1.0},"154":{"tf":1.0},"207":{"tf":1.0},"208":{"tf":1.0},"210":{"tf":1.0},"213":{"tf":1.4142135623730951},"220":{"tf":1.0},"221":{"tf":1.4142135623730951}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"160":{"tf":1.0},"163":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"139":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"115":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"!":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{":":{":":{"<":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"o":{"a":{"d":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{".":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"2":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"o":{"df":0,"docs":{},"k":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{".":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"x":{"df":1,"docs":{"111":{"tf":1.0}}}},"df":0,"docs":{}},"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"76":{"tf":1.0}}}}}}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"70":{"tf":1.0}}}}},"g":{"c":{"d":{".":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"k":{"df":6,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":2.0},"83":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"[":{"0":{"]":{".":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"73":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"i":{"6":{"4":{"df":1,"docs":{"88":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"]":{".":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"88":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"88":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"u":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"70":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0}}}}}},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":2,"docs":{"79":{"tf":1.0},"83":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},".":{"df":0,"docs":{},"h":{"df":4,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0}}}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"!":{"(":{"a":{"df":1,"docs":{"66":{"tf":1.0}}},"b":{"df":1,"docs":{"66":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{".":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":2.6457513110645907}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{".":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{")":{"[":{"0":{"df":0,"docs":{},"x":{"1":{"0":{"0":{"2":{"df":1,"docs":{"49":{"tf":1.0}}},"3":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"2":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"49":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{".":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":4,"docs":{"111":{"tf":1.0},"184":{"tf":1.4142135623730951},"187":{"tf":1.0},"39":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":3,"docs":{"161":{"tf":1.4142135623730951},"221":{"tf":2.8284271247461903},"70":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"209":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"i":{"df":2,"docs":{"151":{"tf":1.0},"225":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":12,"docs":{"113":{"tf":1.0},"130":{"tf":1.0},"132":{"tf":1.0},"14":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.4142135623730951},"165":{"tf":1.0},"177":{"tf":1.0},"195":{"tf":1.0},"24":{"tf":1.0},"38":{"tf":1.4142135623730951},"5":{"tf":1.0}},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"128":{"tf":1.0},"209":{"tf":1.4142135623730951}}}}}}},"y":{"df":0,"docs":{},"n":{"c":{"df":4,"docs":{"150":{"tf":1.0},"167":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":3.0}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":3,"docs":{"158":{"tf":1.0},"159":{"tf":1.0},"166":{"tf":1.4142135623730951}}}},"t":{"a":{"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"194":{"tf":1.0},"46":{"tf":1.0},"63":{"tf":1.0},"85":{"tf":1.0}}},"k":{"df":3,"docs":{"144":{"tf":1.0},"209":{"tf":2.0},"231":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":4,"docs":{"21":{"tf":1.0},"24":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0}}}}},"n":{"d":{"df":1,"docs":{"221":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":2,"docs":{"212":{"tf":1.0},"231":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"204":{"tf":1.0},"235":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":7,"docs":{"145":{"tf":1.0},"190":{"tf":1.0},"206":{"tf":1.4142135623730951},"207":{"tf":1.0},"208":{"tf":1.7320508075688772},"220":{"tf":1.0},"221":{"tf":1.0}}}}},"o":{"df":1,"docs":{"221":{"tf":2.23606797749979}},"m":{"a":{"df":0,"docs":{},"t":{"df":11,"docs":{"114":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"126":{"tf":1.0},"140":{"tf":1.0},"190":{"tf":1.4142135623730951},"193":{"tf":1.0},"194":{"tf":1.0},"221":{"tf":1.0},"224":{"tf":1.7320508075688772},"7":{"tf":1.0}}}},"df":3,"docs":{"134":{"tf":1.0},"224":{"tf":1.4142135623730951},"225":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":19,"docs":{"102":{"tf":1.0},"105":{"tf":1.0},"118":{"tf":1.4142135623730951},"12":{"tf":1.0},"122":{"tf":1.0},"132":{"tf":1.4142135623730951},"134":{"tf":1.0},"138":{"tf":1.0},"144":{"tf":1.0},"172":{"tf":1.0},"185":{"tf":1.0},"192":{"tf":1.4142135623730951},"235":{"tf":1.0},"36":{"tf":1.0},"54":{"tf":1.0},"59":{"tf":1.0},"8":{"tf":1.0},"89":{"tf":1.0},"95":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"131":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"138":{"tf":1.0},"207":{"tf":1.4142135623730951},"221":{"tf":1.0}}},"df":0,"docs":{}}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.4142135623730951}}}},"r":{"df":2,"docs":{"201":{"tf":1.0},"221":{"tf":1.0}}},"y":{"df":1,"docs":{"208":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"226":{"tf":1.0}}}}}}},"b":{"a":{"c":{"df":0,"docs":{},"k":{".":{".":{".":{"\\":{"df":0,"docs":{},"n":{"df":2,"docs":{"70":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":9,"docs":{"118":{"tf":1.0},"132":{"tf":1.0},"158":{"tf":1.4142135623730951},"159":{"tf":1.0},"163":{"tf":2.0},"33":{"tf":1.0},"39":{"tf":1.0},"43":{"tf":1.0},"88":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"137":{"tf":1.7320508075688772},"138":{"tf":1.4142135623730951},"140":{"tf":1.7320508075688772},"155":{"tf":1.0}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"159":{"tf":1.0}}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":4,"docs":{"134":{"tf":1.0},"224":{"tf":1.0},"225":{"tf":2.23606797749979},"226":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":5,"docs":{"111":{"tf":1.7320508075688772},"128":{"tf":1.0},"130":{"tf":1.0},"163":{"tf":1.0},"166":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"134":{"tf":1.4142135623730951},"24":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"158":{"tf":1.0}}},"l":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"209":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"n":{"df":1,"docs":{"232":{"tf":1.0}}},"r":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"111":{"tf":1.4142135623730951}}}},"df":1,"docs":{"216":{"tf":1.0}},"e":{"df":1,"docs":{"130":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"e":{"df":12,"docs":{"103":{"tf":1.0},"106":{"tf":1.0},"114":{"tf":1.0},"119":{"tf":1.0},"124":{"tf":1.0},"130":{"tf":1.0},"146":{"tf":1.0},"147":{"tf":1.0},"158":{"tf":1.0},"163":{"tf":1.0},"218":{"tf":1.0},"40":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"131":{"tf":1.0},"138":{"tf":1.4142135623730951},"18":{"tf":1.0},"31":{"tf":1.0}}}}}},"h":{"df":6,"docs":{"100":{"tf":1.0},"194":{"tf":1.0},"2":{"tf":1.0},"36":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.4142135623730951}}},"i":{"c":{"df":5,"docs":{"13":{"tf":1.0},"142":{"tf":1.0},"148":{"tf":1.0},"163":{"tf":1.0},"195":{"tf":1.0}}},"df":4,"docs":{"139":{"tf":1.0},"159":{"tf":1.4142135623730951},"203":{"tf":1.0},"204":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"138":{"tf":1.0}}}}},"z":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"111":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":5,"docs":{"63":{"tf":1.4142135623730951},"66":{"tf":2.0},"73":{"tf":1.7320508075688772},"79":{"tf":1.7320508075688772},"83":{"tf":1.7320508075688772}},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"166":{"tf":1.0},"54":{"tf":1.0}}}}},"df":11,"docs":{"116":{"tf":1.0},"131":{"tf":1.0},"132":{"tf":1.0},"138":{"tf":1.4142135623730951},"142":{"tf":1.0},"18":{"tf":1.0},"183":{"tf":1.0},"203":{"tf":1.0},"207":{"tf":1.0},"21":{"tf":1.0},"231":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":20,"docs":{"103":{"tf":1.0},"110":{"tf":1.0},"130":{"tf":1.0},"138":{"tf":1.0},"145":{"tf":1.0},"150":{"tf":1.0},"159":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":1.7320508075688772},"164":{"tf":1.4142135623730951},"169":{"tf":1.0},"176":{"tf":1.0},"211":{"tf":1.0},"214":{"tf":1.0},"220":{"tf":1.0},"224":{"tf":1.0},"225":{"tf":1.0},"226":{"tf":1.0},"40":{"tf":1.0},"92":{"tf":1.0}},"e":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"190":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"159":{"tf":1.0}},"n":{"df":1,"docs":{"155":{"tf":1.4142135623730951}}}}}},"h":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":2,"docs":{"150":{"tf":1.0},"207":{"tf":1.0}}}},"v":{"df":1,"docs":{"194":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":10,"docs":{"134":{"tf":2.0},"14":{"tf":1.0},"144":{"tf":1.7320508075688772},"162":{"tf":1.0},"194":{"tf":1.4142135623730951},"204":{"tf":1.0},"229":{"tf":1.0},"231":{"tf":1.4142135623730951},"232":{"tf":1.7320508075688772},"234":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"138":{"tf":1.0},"222":{"tf":1.0},"224":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"221":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"184":{"tf":1.0}}}},"w":{"df":7,"docs":{"123":{"tf":1.0},"130":{"tf":1.0},"137":{"tf":1.4142135623730951},"158":{"tf":1.0},"208":{"tf":1.0},"224":{"tf":1.0},"51":{"tf":1.0}}}}},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"4":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"130":{"tf":1.4142135623730951},"163":{"tf":1.0},"209":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":10,"docs":{"112":{"tf":1.0},"129":{"tf":1.0},"130":{"tf":1.4142135623730951},"131":{"tf":1.0},"137":{"tf":1.4142135623730951},"138":{"tf":1.0},"183":{"tf":1.0},"194":{"tf":1.0},"207":{"tf":1.4142135623730951},"231":{"tf":1.0}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"110":{"tf":1.0},"130":{"tf":1.0},"164":{"tf":1.0},"193":{"tf":1.0},"212":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":9,"docs":{"113":{"tf":1.0},"127":{"tf":1.0},"131":{"tf":1.0},"143":{"tf":1.0},"145":{"tf":1.0},"157":{"tf":1.4142135623730951},"158":{"tf":1.0},"209":{"tf":1.0},"225":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"137":{"tf":1.0},"138":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"g":{"df":3,"docs":{"224":{"tf":1.0},"24":{"tf":1.0},"30":{"tf":1.0}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"164":{"tf":1.0}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"222":{"tf":1.0}}},"df":0,"docs":{}}}}}},"n":{"/":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"101":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":19,"docs":{"0":{"tf":2.0},"119":{"tf":1.0},"129":{"tf":1.0},"130":{"tf":1.7320508075688772},"131":{"tf":3.0},"137":{"tf":1.4142135623730951},"159":{"tf":1.0},"187":{"tf":1.0},"192":{"tf":1.4142135623730951},"200":{"tf":1.4142135623730951},"216":{"tf":1.0},"3":{"tf":2.23606797749979},"7":{"tf":1.0},"70":{"tf":1.4142135623730951},"73":{"tf":1.0},"76":{"tf":1.7320508075688772},"83":{"tf":1.0},"85":{"tf":1.4142135623730951},"88":{"tf":1.7320508075688772}}},"y":{".":{".":{".":{"\\":{"df":0,"docs":{},"n":{"df":1,"docs":{"85":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":3,"docs":{"76":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":3,"docs":{"76":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"df":1,"docs":{"36":{"tf":1.0}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"172":{"tf":1.4142135623730951}}}}}},"df":1,"docs":{"39":{"tf":1.0}}},"t":{"df":15,"docs":{"112":{"tf":1.0},"118":{"tf":1.4142135623730951},"130":{"tf":1.0},"132":{"tf":1.0},"137":{"tf":1.7320508075688772},"140":{"tf":1.0},"145":{"tf":1.0},"158":{"tf":1.0},"164":{"tf":2.8284271247461903},"193":{"tf":1.0},"199":{"tf":1.0},"225":{"tf":1.0},"3":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"k":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"153":{"tf":1.0}}}}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"150":{"tf":1.0}}}}},"df":0,"docs":{}}},"o":{"b":{"df":1,"docs":{"137":{"tf":1.0}}},"c":{"df":0,"docs":{},"k":{"df":9,"docs":{"100":{"tf":1.4142135623730951},"103":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"39":{"tf":1.0},"45":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951},"90":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951},"96":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"143":{"tf":1.0}}}}},"o":{"d":{"df":0,"docs":{},"i":{"df":2,"docs":{"159":{"tf":1.0},"230":{"tf":1.0}}}},"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"224":{"tf":1.0},"225":{"tf":1.0}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"130":{"tf":1.0}}}},"o":{"df":0,"docs":{},"k":{"df":3,"docs":{"112":{"tf":1.0},"191":{"tf":1.4142135623730951},"192":{"tf":1.4142135623730951}}},"l":{"df":6,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.0}}}}}}}}},"t":{"df":0,"docs":{},"h":{"df":11,"docs":{"0":{"tf":1.0},"110":{"tf":1.0},"118":{"tf":1.4142135623730951},"134":{"tf":1.0},"140":{"tf":1.0},"163":{"tf":1.4142135623730951},"164":{"tf":1.4142135623730951},"191":{"tf":1.0},"193":{"tf":1.0},"233":{"tf":1.0},"7":{"tf":1.0}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"163":{"tf":1.0},"227":{"tf":1.4142135623730951}}}}}},"u":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"157":{"tf":1.0}}}}},"df":8,"docs":{"144":{"tf":1.0},"148":{"tf":2.0},"150":{"tf":1.0},"151":{"tf":1.7320508075688772},"163":{"tf":1.0},"164":{"tf":2.23606797749979},"194":{"tf":1.0},"49":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"x":{"<":{"d":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"df":2,"docs":{"39":{"tf":1.0},"40":{"tf":1.0}}}}},"df":0,"docs":{}},"df":2,"docs":{"132":{"tf":1.0},"139":{"tf":1.0}}}},"r":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":8,"docs":{"100":{"tf":1.4142135623730951},"103":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951},"90":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951},"96":{"tf":1.4142135623730951}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"148":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":10,"docs":{"137":{"tf":1.0},"144":{"tf":1.4142135623730951},"203":{"tf":1.0},"204":{"tf":1.0},"208":{"tf":1.4142135623730951},"224":{"tf":3.4641016151377544},"225":{"tf":2.8284271247461903},"226":{"tf":3.1622776601683795},"227":{"tf":2.0},"3":{"tf":1.0}}}},"df":0,"docs":{}}},"df":8,"docs":{"100":{"tf":1.0},"103":{"tf":1.0},"106":{"tf":1.0},"45":{"tf":1.0},"72":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"157":{"tf":1.0}}}},"df":3,"docs":{"134":{"tf":2.23606797749979},"138":{"tf":1.0},"225":{"tf":1.4142135623730951}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"o":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"138":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"134":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"159":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"s":{"df":20,"docs":{"209":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.0},"50":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.0},"80":{"tf":1.0},"84":{"tf":1.0},"86":{"tf":1.0},"91":{"tf":1.0},"94":{"tf":1.0},"97":{"tf":1.0}}}}}},"s":{"d":{"df":1,"docs":{"139":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"g":{"df":17,"docs":{"134":{"tf":1.4142135623730951},"135":{"tf":1.0},"137":{"tf":1.0},"138":{"tf":2.0},"143":{"tf":1.0},"145":{"tf":2.8284271247461903},"150":{"tf":1.7320508075688772},"151":{"tf":2.0},"163":{"tf":1.4142135623730951},"164":{"tf":1.0},"187":{"tf":1.0},"191":{"tf":1.0},"193":{"tf":2.23606797749979},"194":{"tf":2.0},"210":{"tf":1.0},"211":{"tf":1.0},"217":{"tf":1.0}},"g":{"df":0,"docs":{},"i":{"df":1,"docs":{"194":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"l":{"d":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"216":{"tf":1.0}}}},"df":43,"docs":{"119":{"tf":1.0},"121":{"tf":1.0},"125":{"tf":1.0},"128":{"tf":1.4142135623730951},"129":{"tf":1.4142135623730951},"130":{"tf":4.242640687119285},"131":{"tf":2.0},"132":{"tf":2.6457513110645907},"137":{"tf":1.0},"138":{"tf":1.0},"140":{"tf":1.0},"142":{"tf":1.0},"153":{"tf":1.0},"154":{"tf":1.0},"168":{"tf":1.4142135623730951},"169":{"tf":1.0},"170":{"tf":1.0},"173":{"tf":2.6457513110645907},"174":{"tf":1.0},"175":{"tf":2.6457513110645907},"176":{"tf":1.4142135623730951},"191":{"tf":1.0},"192":{"tf":1.7320508075688772},"195":{"tf":1.0},"200":{"tf":1.7320508075688772},"203":{"tf":1.4142135623730951},"209":{"tf":1.0},"218":{"tf":2.23606797749979},"3":{"tf":1.0},"39":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"59":{"tf":1.0},"61":{"tf":1.0},"70":{"tf":2.23606797749979},"73":{"tf":2.23606797749979},"76":{"tf":2.23606797749979},"79":{"tf":2.23606797749979},"83":{"tf":2.23606797749979},"88":{"tf":2.23606797749979},"96":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":10,"docs":{"0":{"tf":1.0},"122":{"tf":1.0},"132":{"tf":1.4142135623730951},"139":{"tf":1.0},"140":{"tf":1.0},"173":{"tf":1.4142135623730951},"218":{"tf":1.0},"224":{"tf":1.0},"55":{"tf":1.0},"61":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"k":{"df":2,"docs":{"137":{"tf":1.0},"216":{"tf":1.0}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":3,"docs":{"138":{"tf":1.4142135623730951},"209":{"tf":1.0},"227":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"p":{"df":6,"docs":{"134":{"tf":1.0},"208":{"tf":1.0},"214":{"tf":1.0},"224":{"tf":1.4142135623730951},"225":{"tf":1.0},"226":{"tf":1.7320508075688772}}}},"n":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"194":{"tf":1.0}}}},"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"103":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"138":{"tf":1.0},"206":{"tf":1.0},"209":{"tf":1.0}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"220":{"tf":1.0}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"224":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"d":{"df":4,"docs":{"0":{"tf":1.0},"135":{"tf":1.0},"149":{"tf":1.0},"234":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"226":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":7,"docs":{"106":{"tf":1.4142135623730951},"187":{"tf":1.0},"194":{"tf":3.3166247903554},"58":{"tf":1.0},"63":{"tf":1.4142135623730951},"82":{"tf":1.0},"83":{"tf":1.7320508075688772}}}}}},"c":{"a":{"c":{"df":0,"docs":{},"h":{"df":24,"docs":{"10":{"tf":1.0},"14":{"tf":2.23606797749979},"15":{"tf":1.0},"16":{"tf":1.0},"167":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"21":{"tf":1.7320508075688772},"22":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"25":{"tf":2.23606797749979},"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"28":{"tf":1.7320508075688772},"29":{"tf":1.7320508075688772},"30":{"tf":2.0},"31":{"tf":2.23606797749979},"32":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"34":{"tf":2.0},"35":{"tf":1.0},"46":{"tf":1.0}},"e":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"16":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":8,"docs":{"103":{"tf":1.0},"106":{"tf":1.0},"44":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"90":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0},"99":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"52":{"tf":1.0}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"148":{"tf":1.0},"161":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"b":{"a":{"c":{"df":0,"docs":{},"k":{"(":{"df":0,"docs":{},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"88":{"tf":1.0}}},"df":0,"docs":{}}}}},".":{".":{".":{"\\":{"df":0,"docs":{},"n":{"df":2,"docs":{"70":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"66":{"tf":1.0}}}}}}},"df":2,"docs":{"66":{"tf":1.0},"88":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"88":{"tf":1.4142135623730951}}}}}},"df":4,"docs":{"43":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":35,"docs":{"110":{"tf":1.4142135623730951},"114":{"tf":1.4142135623730951},"115":{"tf":1.4142135623730951},"116":{"tf":1.4142135623730951},"119":{"tf":1.4142135623730951},"126":{"tf":1.7320508075688772},"13":{"tf":1.0},"137":{"tf":1.7320508075688772},"144":{"tf":1.7320508075688772},"157":{"tf":1.0},"158":{"tf":1.0},"160":{"tf":1.4142135623730951},"162":{"tf":1.0},"163":{"tf":2.6457513110645907},"193":{"tf":1.0},"39":{"tf":1.7320508075688772},"40":{"tf":3.4641016151377544},"42":{"tf":1.0},"43":{"tf":1.0},"57":{"tf":1.7320508075688772},"58":{"tf":1.4142135623730951},"63":{"tf":1.7320508075688772},"65":{"tf":1.0},"66":{"tf":1.4142135623730951},"69":{"tf":1.0},"70":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951},"76":{"tf":1.7320508075688772},"79":{"tf":1.0},"81":{"tf":1.7320508075688772},"82":{"tf":1.4142135623730951},"83":{"tf":1.0},"85":{"tf":1.4142135623730951},"87":{"tf":1.0},"88":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{".":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"(":{")":{".":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{")":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"d":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"(":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"<":{"'":{"_":{"df":2,"docs":{"40":{"tf":1.0},"43":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"158":{"tf":1.0},"163":{"tf":1.0},"40":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"70":{"tf":1.0},"88":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"144":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"—":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"144":{"tf":1.0}}}},"df":0,"docs":{}}}}},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"158":{"tf":1.0}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":7,"docs":{"131":{"tf":1.0},"138":{"tf":1.0},"145":{"tf":1.0},"159":{"tf":1.4142135623730951},"176":{"tf":1.4142135623730951},"220":{"tf":1.0},"221":{"tf":1.0}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"212":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"193":{"tf":1.0}}},"df":0,"docs":{}}}},"df":2,"docs":{"193":{"tf":1.0},"194":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":0,"docs":{}},"p":{"a":{"b":{"df":0,"docs":{},"l":{"df":6,"docs":{"120":{"tf":1.4142135623730951},"146":{"tf":1.0},"151":{"tf":1.0},"209":{"tf":1.0},"218":{"tf":1.0},"55":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"218":{"tf":1.0}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":7,"docs":{"111":{"tf":1.0},"117":{"tf":1.0},"127":{"tf":1.0},"158":{"tf":1.0},"163":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.7320508075688772}}}}}},"r":{"df":0,"docs":{},"e":{"df":3,"docs":{"163":{"tf":1.4142135623730951},"209":{"tf":1.0},"225":{"tf":1.0}}},"g":{"df":0,"docs":{},"o":{"'":{"df":1,"docs":{"130":{"tf":1.0}}},".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"206":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":3,"docs":{"203":{"tf":1.0},"205":{"tf":1.0},"39":{"tf":1.0}}}}}}},"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"199":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"=":{"1":{"df":1,"docs":{"130":{"tf":2.449489742783178}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"130":{"tf":2.6457513110645907}}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"=":{"df":1,"docs":{"130":{"tf":3.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"=":{"a":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"130":{"tf":2.6457513110645907}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"=":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":1,"docs":{"130":{"tf":2.23606797749979}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}},"df":48,"docs":{"115":{"tf":1.0},"118":{"tf":1.0},"121":{"tf":1.0},"128":{"tf":1.0},"130":{"tf":4.0},"131":{"tf":1.4142135623730951},"132":{"tf":1.4142135623730951},"142":{"tf":1.4142135623730951},"157":{"tf":1.0},"171":{"tf":1.0},"173":{"tf":2.0},"175":{"tf":2.0},"178":{"tf":2.0},"179":{"tf":2.0},"180":{"tf":1.4142135623730951},"181":{"tf":1.4142135623730951},"183":{"tf":1.0},"184":{"tf":1.0},"188":{"tf":1.4142135623730951},"191":{"tf":1.7320508075688772},"192":{"tf":1.0},"194":{"tf":1.0},"195":{"tf":1.0},"199":{"tf":1.4142135623730951},"200":{"tf":2.449489742783178},"202":{"tf":1.0},"204":{"tf":1.7320508075688772},"206":{"tf":1.7320508075688772},"207":{"tf":2.0},"208":{"tf":2.0},"209":{"tf":2.0},"218":{"tf":1.4142135623730951},"39":{"tf":2.0},"43":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0},"59":{"tf":1.0},"61":{"tf":1.7320508075688772},"63":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"224":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"194":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"194":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":21,"docs":{"130":{"tf":1.0},"131":{"tf":1.0},"137":{"tf":1.0},"151":{"tf":1.0},"160":{"tf":1.4142135623730951},"162":{"tf":1.4142135623730951},"163":{"tf":1.4142135623730951},"185":{"tf":1.4142135623730951},"187":{"tf":2.6457513110645907},"188":{"tf":1.4142135623730951},"190":{"tf":1.0},"193":{"tf":3.1622776601683795},"194":{"tf":3.1622776601683795},"204":{"tf":1.0},"208":{"tf":1.0},"212":{"tf":1.0},"216":{"tf":1.0},"31":{"tf":1.0},"39":{"tf":1.7320508075688772},"46":{"tf":1.0},"70":{"tf":1.0}},"s":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"131":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"101":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"138":{"tf":1.0},"145":{"tf":1.0},"163":{"tf":1.4142135623730951},"190":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"155":{"tf":1.0}},"i":{"df":3,"docs":{"137":{"tf":1.7320508075688772},"138":{"tf":1.0},"208":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"s":{"df":4,"docs":{"111":{"tf":1.0},"128":{"tf":1.0},"193":{"tf":1.0},"203":{"tf":1.0}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"150":{"tf":1.0}}}}}}}},"c":{"df":6,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0}}},"d":{"df":12,"docs":{"175":{"tf":1.4142135623730951},"179":{"tf":1.4142135623730951},"39":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0},"99":{"tf":1.0}}},"df":24,"docs":{"114":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.0},"122":{"tf":2.0},"126":{"tf":1.0},"131":{"tf":2.23606797749979},"132":{"tf":1.0},"135":{"tf":1.0},"142":{"tf":1.0},"174":{"tf":1.0},"192":{"tf":1.0},"216":{"tf":1.7320508075688772},"217":{"tf":1.0},"36":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"67":{"tf":1.7320508075688772},"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.4142135623730951},"79":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.4142135623730951},"92":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"192":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"112":{"tf":1.0},"128":{"tf":1.0},"194":{"tf":1.0}}}}},"df":0,"docs":{}}}},"f":{"df":0,"docs":{},"g":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"183":{"tf":1.4142135623730951}}}}}}},"df":1,"docs":{"132":{"tf":1.0}}}},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"/":{"a":{"df":0,"docs":{},"u":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"206":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"209":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":4,"docs":{"206":{"tf":1.0},"207":{"tf":1.0},"208":{"tf":1.0},"209":{"tf":2.0}}}},"n":{"df":0,"docs":{},"g":{"df":27,"docs":{"114":{"tf":1.0},"115":{"tf":1.0},"126":{"tf":1.0},"134":{"tf":2.449489742783178},"136":{"tf":1.4142135623730951},"138":{"tf":4.58257569495584},"14":{"tf":1.0},"161":{"tf":1.0},"180":{"tf":1.0},"190":{"tf":1.4142135623730951},"194":{"tf":1.4142135623730951},"203":{"tf":1.0},"207":{"tf":1.0},"208":{"tf":1.0},"209":{"tf":1.0},"212":{"tf":2.0},"213":{"tf":1.7320508075688772},"214":{"tf":1.0},"218":{"tf":1.4142135623730951},"220":{"tf":1.7320508075688772},"222":{"tf":1.4142135623730951},"224":{"tf":2.449489742783178},"225":{"tf":2.23606797749979},"227":{"tf":1.0},"24":{"tf":1.0},"30":{"tf":1.0},"55":{"tf":1.0}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"r":{"df":8,"docs":{"128":{"tf":1.0},"70":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951},"76":{"tf":1.7320508075688772},"79":{"tf":1.4142135623730951},"83":{"tf":2.0},"85":{"tf":1.7320508075688772},"88":{"tf":1.7320508075688772}}},"t":{"df":2,"docs":{"153":{"tf":1.4142135623730951},"154":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"151":{"tf":1.0}}}},"c":{"df":0,"docs":{},"k":{"(":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"76":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"96":{"tf":2.0}}}}},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":2.23606797749979}}}}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.7320508075688772}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"76":{"tf":1.7320508075688772}}}}}},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"0":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"1":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":2.6457513110645907}}}}}}}}},"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"2":{"(":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"76":{"tf":1.0}}}}}},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"2":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}}}}},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"1":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"2":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":1,"docs":{"216":{"tf":1.0}}}}},"df":27,"docs":{"1":{"tf":1.0},"104":{"tf":1.0},"107":{"tf":1.0},"110":{"tf":1.0},"128":{"tf":1.0},"137":{"tf":1.0},"144":{"tf":1.4142135623730951},"145":{"tf":1.0},"148":{"tf":1.7320508075688772},"162":{"tf":1.0},"164":{"tf":2.0},"180":{"tf":1.4142135623730951},"187":{"tf":1.0},"191":{"tf":1.4142135623730951},"193":{"tf":1.0},"194":{"tf":1.4142135623730951},"2":{"tf":1.0},"202":{"tf":1.0},"206":{"tf":1.0},"208":{"tf":1.0},"222":{"tf":1.0},"224":{"tf":1.0},"225":{"tf":1.0},"226":{"tf":1.0},"24":{"tf":1.0},"37":{"tf":1.0},"76":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"128":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"217":{"tf":1.0},"223":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"i":{"c":{"df":3,"docs":{"143":{"tf":1.0},"145":{"tf":1.0},"187":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"131":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":2,"docs":{"131":{"tf":1.0},"164":{"tf":1.0}}}}}},"i":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"227":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"df":2,"docs":{"178":{"tf":1.0},"226":{"tf":1.4142135623730951}}}}}},"df":18,"docs":{"131":{"tf":1.4142135623730951},"137":{"tf":3.0},"138":{"tf":2.6457513110645907},"139":{"tf":1.0},"178":{"tf":1.0},"189":{"tf":2.0},"190":{"tf":3.0},"191":{"tf":2.8284271247461903},"192":{"tf":2.23606797749979},"203":{"tf":2.0},"204":{"tf":1.7320508075688772},"205":{"tf":1.7320508075688772},"206":{"tf":1.7320508075688772},"221":{"tf":1.0},"224":{"tf":2.6457513110645907},"225":{"tf":2.0},"226":{"tf":2.449489742783178},"3":{"tf":1.0}},"r":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"138":{"tf":1.0},"234":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"110":{"tf":1.0}}}},"p":{"df":1,"docs":{"131":{"tf":1.0}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"232":{"tf":1.0},"233":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"93":{"tf":1.0}},"i":{"c":{"df":1,"docs":{"150":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"138":{"tf":2.23606797749979}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":6,"docs":{"21":{"tf":1.0},"34":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0}},"u":{"df":0,"docs":{},"p":{"df":5,"docs":{"14":{"tf":1.0},"21":{"tf":1.4142135623730951},"28":{"tf":1.0},"29":{"tf":1.0},"34":{"tf":1.0}}}}},"r":{"df":4,"docs":{"122":{"tf":1.4142135623730951},"137":{"tf":1.0},"138":{"tf":1.4142135623730951},"212":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"134":{"tf":1.0},"138":{"tf":1.0},"157":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"'":{"df":1,"docs":{"7":{"tf":1.0}}},"_":{"df":1,"docs":{"185":{"tf":1.0}},"m":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"185":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"185":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"123":{"tf":1.0}}}},"df":27,"docs":{"0":{"tf":1.0},"1":{"tf":2.0},"110":{"tf":1.4142135623730951},"114":{"tf":1.4142135623730951},"115":{"tf":1.4142135623730951},"121":{"tf":1.0},"122":{"tf":1.4142135623730951},"123":{"tf":1.0},"124":{"tf":1.0},"126":{"tf":1.4142135623730951},"127":{"tf":1.0},"128":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"130":{"tf":2.0},"131":{"tf":2.23606797749979},"135":{"tf":1.4142135623730951},"167":{"tf":1.0},"173":{"tf":1.7320508075688772},"178":{"tf":1.0},"180":{"tf":1.4142135623730951},"185":{"tf":1.0},"192":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"3":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"204":{"tf":3.605551275463989}}}}}},"o":{"c":{"df":0,"docs":{},"k":{"df":8,"docs":{"0":{"tf":1.0},"137":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"34":{"tf":1.0},"54":{"tf":1.0}},"i":{"d":{"df":1,"docs":{"115":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":16,"docs":{"41":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.0},"50":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.0},"80":{"tf":1.0},"84":{"tf":1.0},"86":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"112":{"tf":1.0}}},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"53":{"tf":1.0},"88":{"tf":1.0}},"e":{".":{".":{".":{"\\":{"df":0,"docs":{},"n":{"df":1,"docs":{"88":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"(":{"df":0,"docs":{},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"88":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"m":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":8,"docs":{"52":{"tf":1.0},"55":{"tf":1.0},"70":{"tf":1.7320508075688772},"73":{"tf":1.7320508075688772},"76":{"tf":1.7320508075688772},"79":{"tf":2.0},"83":{"tf":1.7320508075688772},"88":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"o":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"221":{"tf":1.0}}}}},"c":{"df":1,"docs":{"234":{"tf":1.7320508075688772}}},"d":{"df":0,"docs":{},"e":{"df":80,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":1.0},"103":{"tf":1.0},"106":{"tf":1.0},"111":{"tf":1.4142135623730951},"112":{"tf":1.7320508075688772},"113":{"tf":1.4142135623730951},"116":{"tf":1.4142135623730951},"118":{"tf":1.0},"120":{"tf":1.0},"122":{"tf":1.4142135623730951},"130":{"tf":2.0},"131":{"tf":1.4142135623730951},"137":{"tf":1.4142135623730951},"138":{"tf":2.0},"141":{"tf":1.0},"143":{"tf":1.0},"147":{"tf":1.0},"150":{"tf":1.0},"152":{"tf":1.0},"153":{"tf":1.0},"155":{"tf":1.0},"156":{"tf":1.0},"158":{"tf":3.0},"159":{"tf":3.4641016151377544},"160":{"tf":2.23606797749979},"162":{"tf":1.4142135623730951},"163":{"tf":2.23606797749979},"164":{"tf":1.4142135623730951},"165":{"tf":1.0},"166":{"tf":1.0},"167":{"tf":1.0},"183":{"tf":1.4142135623730951},"185":{"tf":1.0},"188":{"tf":1.0},"189":{"tf":1.0},"191":{"tf":1.7320508075688772},"192":{"tf":1.0},"193":{"tf":1.0},"201":{"tf":1.0},"202":{"tf":1.0},"206":{"tf":1.7320508075688772},"209":{"tf":1.0},"210":{"tf":1.0},"212":{"tf":1.7320508075688772},"218":{"tf":1.0},"220":{"tf":1.4142135623730951},"229":{"tf":1.7320508075688772},"232":{"tf":1.4142135623730951},"233":{"tf":1.0},"234":{"tf":1.0},"235":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"55":{"tf":1.4142135623730951},"56":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":2.0},"62":{"tf":1.0},"64":{"tf":1.0},"68":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.4142135623730951},"94":{"tf":1.0},"96":{"tf":1.4142135623730951}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"130":{"tf":1.7320508075688772}}}}},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"221":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"220":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"t":{"df":12,"docs":{"116":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.4142135623730951},"121":{"tf":1.4142135623730951},"122":{"tf":2.0},"123":{"tf":1.0},"124":{"tf":1.4142135623730951},"158":{"tf":1.0},"160":{"tf":1.0},"165":{"tf":1.0},"220":{"tf":1.0},"222":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"118":{"tf":1.0},"121":{"tf":1.4142135623730951},"166":{"tf":1.0}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"147":{"tf":1.0}}}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"132":{"tf":1.0},"139":{"tf":1.0},"188":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":9,"docs":{"112":{"tf":1.0},"131":{"tf":1.0},"133":{"tf":1.0},"138":{"tf":1.0},"143":{"tf":1.0},"151":{"tf":1.0},"166":{"tf":1.0},"226":{"tf":1.0},"228":{"tf":1.0}}},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":40,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"103":{"tf":1.0},"106":{"tf":1.0},"111":{"tf":1.7320508075688772},"114":{"tf":1.4142135623730951},"115":{"tf":1.7320508075688772},"116":{"tf":1.4142135623730951},"118":{"tf":1.0},"119":{"tf":1.4142135623730951},"121":{"tf":1.7320508075688772},"126":{"tf":1.4142135623730951},"128":{"tf":1.0},"13":{"tf":1.0},"130":{"tf":2.0},"131":{"tf":1.4142135623730951},"147":{"tf":1.4142135623730951},"170":{"tf":1.0},"173":{"tf":1.4142135623730951},"175":{"tf":1.0},"178":{"tf":1.0},"179":{"tf":1.0},"181":{"tf":1.0},"194":{"tf":1.0},"195":{"tf":1.0},"2":{"tf":1.0},"216":{"tf":1.0},"218":{"tf":1.7320508075688772},"39":{"tf":1.0},"6":{"tf":1.0},"61":{"tf":1.0},"7":{"tf":1.7320508075688772},"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":7,"docs":{"154":{"tf":1.0},"156":{"tf":1.0},"158":{"tf":1.0},"212":{"tf":1.0},"214":{"tf":1.0},"231":{"tf":1.0},"232":{"tf":1.0}}}},"r":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"118":{"tf":1.0}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"t":{"df":11,"docs":{"138":{"tf":1.7320508075688772},"164":{"tf":1.4142135623730951},"190":{"tf":1.0},"191":{"tf":1.0},"208":{"tf":2.449489742783178},"212":{"tf":1.7320508075688772},"213":{"tf":2.449489742783178},"221":{"tf":1.4142135623730951},"224":{"tf":1.7320508075688772},"225":{"tf":1.4142135623730951},"232":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"df":10,"docs":{"103":{"tf":1.0},"106":{"tf":1.0},"108":{"tf":1.0},"201":{"tf":1.0},"209":{"tf":1.0},"50":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0},"99":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"df":9,"docs":{"0":{"tf":1.0},"118":{"tf":1.0},"134":{"tf":1.0},"158":{"tf":1.0},"220":{"tf":1.7320508075688772},"221":{"tf":1.0},"230":{"tf":1.0},"231":{"tf":1.4142135623730951},"233":{"tf":1.4142135623730951}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":4,"docs":{"138":{"tf":1.0},"161":{"tf":1.0},"187":{"tf":1.0},"193":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"161":{"tf":1.4142135623730951}}}}}}},"t":{"df":3,"docs":{"11":{"tf":1.0},"134":{"tf":1.4142135623730951},"192":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"159":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":62,"docs":{"0":{"tf":1.0},"103":{"tf":1.0},"106":{"tf":1.0},"11":{"tf":2.449489742783178},"110":{"tf":1.4142135623730951},"111":{"tf":1.4142135623730951},"115":{"tf":1.0},"119":{"tf":1.0},"122":{"tf":1.0},"128":{"tf":1.4142135623730951},"130":{"tf":2.8284271247461903},"131":{"tf":2.0},"132":{"tf":2.0},"137":{"tf":2.449489742783178},"138":{"tf":1.0},"140":{"tf":2.0},"142":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.0},"150":{"tf":1.4142135623730951},"151":{"tf":1.0},"155":{"tf":2.0},"157":{"tf":1.0},"158":{"tf":2.6457513110645907},"159":{"tf":3.7416573867739413},"160":{"tf":2.23606797749979},"161":{"tf":1.4142135623730951},"162":{"tf":1.0},"167":{"tf":2.449489742783178},"177":{"tf":1.0},"181":{"tf":1.0},"183":{"tf":1.0},"185":{"tf":1.0},"195":{"tf":1.7320508075688772},"197":{"tf":1.4142135623730951},"198":{"tf":1.0},"199":{"tf":1.0},"200":{"tf":1.4142135623730951},"203":{"tf":2.6457513110645907},"204":{"tf":1.4142135623730951},"217":{"tf":1.4142135623730951},"218":{"tf":1.0},"221":{"tf":1.0},"39":{"tf":2.449489742783178},"4":{"tf":1.4142135623730951},"40":{"tf":1.0},"43":{"tf":2.0},"49":{"tf":1.4142135623730951},"51":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.0},"61":{"tf":1.0},"66":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":2.449489742783178},"73":{"tf":1.7320508075688772},"76":{"tf":1.7320508075688772},"79":{"tf":1.7320508075688772},"80":{"tf":1.0},"83":{"tf":2.23606797749979},"85":{"tf":1.4142135623730951},"88":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"136":{"tf":1.0}}},"df":0,"docs":{}}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"234":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":6,"docs":{"11":{"tf":1.0},"137":{"tf":1.4142135623730951},"138":{"tf":1.4142135623730951},"162":{"tf":1.0},"216":{"tf":1.0},"226":{"tf":1.0}}}},"i":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}},"c":{"df":3,"docs":{"162":{"tf":1.0},"165":{"tf":1.0},"187":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"df":9,"docs":{"0":{"tf":2.0},"137":{"tf":1.0},"138":{"tf":3.4641016151377544},"142":{"tf":1.0},"185":{"tf":1.0},"192":{"tf":1.0},"218":{"tf":2.8284271247461903},"30":{"tf":1.0},"8":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"218":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"138":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"112":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"s":{"df":6,"docs":{"18":{"tf":2.0},"19":{"tf":1.7320508075688772},"20":{"tf":1.0},"22":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"33":{"tf":2.6457513110645907}}}}}},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"150":{"tf":1.4142135623730951},"151":{"tf":1.0}}}}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"158":{"tf":1.7320508075688772},"41":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"217":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"220":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"220":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"20":{"tf":1.0},"33":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"131":{"tf":1.0}}}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":8,"docs":{"152":{"tf":1.0},"220":{"tf":1.0},"229":{"tf":1.7320508075688772},"231":{"tf":1.0},"232":{"tf":1.0},"233":{"tf":1.0},"234":{"tf":1.0},"235":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"d":{"df":4,"docs":{"138":{"tf":1.4142135623730951},"145":{"tf":1.0},"152":{"tf":1.0},"217":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"234":{"tf":1.0}}}}}}},"df":0,"docs":{},"g":{".":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"55":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},":":{":":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"110":{"tf":1.0}}}}}},"df":1,"docs":{"116":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":3,"docs":{"55":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":4,"docs":{"114":{"tf":1.0},"115":{"tf":1.0},"119":{"tf":1.0},"126":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":9,"docs":{"10":{"tf":1.4142135623730951},"137":{"tf":1.0},"14":{"tf":1.4142135623730951},"164":{"tf":1.0},"43":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0},"63":{"tf":1.0},"85":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":34,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":1.7320508075688772},"111":{"tf":1.0},"124":{"tf":1.4142135623730951},"128":{"tf":1.0},"130":{"tf":2.6457513110645907},"132":{"tf":1.0},"14":{"tf":1.7320508075688772},"145":{"tf":1.0},"147":{"tf":1.0},"148":{"tf":1.4142135623730951},"15":{"tf":1.0},"150":{"tf":1.0},"158":{"tf":1.0},"162":{"tf":1.0},"164":{"tf":2.6457513110645907},"183":{"tf":1.0},"189":{"tf":1.0},"199":{"tf":1.4142135623730951},"2":{"tf":1.0},"202":{"tf":1.0},"204":{"tf":1.0},"206":{"tf":1.4142135623730951},"224":{"tf":1.0},"30":{"tf":1.0},"39":{"tf":1.0},"43":{"tf":1.0},"52":{"tf":1.4142135623730951},"59":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.4142135623730951},"70":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0}}}}},"n":{"df":1,"docs":{"150":{"tf":1.0}}},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"2":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"147":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":5,"docs":{"103":{"tf":1.0},"106":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"118":{"tf":1.0},"147":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":1,"docs":{"134":{"tf":1.0}}}}},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"165":{"tf":1.0}}}},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"166":{"tf":1.7320508075688772}}}}},"i":{"d":{"df":11,"docs":{"111":{"tf":1.0},"131":{"tf":1.0},"132":{"tf":1.0},"138":{"tf":1.0},"145":{"tf":1.0},"150":{"tf":2.449489742783178},"151":{"tf":1.0},"157":{"tf":1.0},"211":{"tf":1.0},"212":{"tf":1.0},"231":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"189":{"tf":1.0},"192":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"13":{"tf":1.0},"93":{"tf":1.4142135623730951}},"e":{".":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"(":{"$":{"\"":{"df":0,"docs":{},"g":{"c":{"d":{"(":{"2":{"7":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"138":{"tf":1.0}}}}},"df":7,"docs":{"137":{"tf":1.0},"185":{"tf":1.0},"70":{"tf":1.0},"76":{"tf":2.0},"83":{"tf":1.4142135623730951},"85":{"tf":1.0},"88":{"tf":1.7320508075688772}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"231":{"tf":1.0},"55":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":5,"docs":{"130":{"tf":1.0},"138":{"tf":1.0},"2":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.0}}}},"m":{"df":4,"docs":{"109":{"tf":1.0},"111":{"tf":1.4142135623730951},"157":{"tf":1.0},"224":{"tf":1.0}},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"158":{"tf":1.0}}}}}}},"t":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"153":{"tf":1.0},"234":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":17,"docs":{"1":{"tf":1.0},"108":{"tf":1.0},"121":{"tf":1.0},"131":{"tf":1.0},"156":{"tf":1.0},"158":{"tf":1.4142135623730951},"160":{"tf":1.0},"165":{"tf":1.0},"170":{"tf":1.0},"178":{"tf":1.0},"192":{"tf":1.4142135623730951},"194":{"tf":1.4142135623730951},"206":{"tf":1.4142135623730951},"208":{"tf":1.0},"218":{"tf":1.0},"43":{"tf":1.4142135623730951},"94":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"158":{"tf":1.0},"224":{"tf":1.0},"226":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"df":14,"docs":{"110":{"tf":1.0},"158":{"tf":1.7320508075688772},"160":{"tf":1.0},"212":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.4142135623730951},"55":{"tf":1.0},"70":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951},"76":{"tf":1.0},"79":{"tf":2.0},"83":{"tf":2.23606797749979},"85":{"tf":1.0},"88":{"tf":1.0}},"u":{"df":2,"docs":{"130":{"tf":1.0},"159":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"164":{"tf":1.0}}}},"n":{"df":0,"docs":{},"u":{"df":9,"docs":{"130":{"tf":1.0},"137":{"tf":1.7320508075688772},"138":{"tf":1.7320508075688772},"148":{"tf":1.0},"176":{"tf":1.0},"189":{"tf":1.4142135623730951},"202":{"tf":1.0},"203":{"tf":1.0},"3":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":19,"docs":{"0":{"tf":1.4142135623730951},"104":{"tf":1.0},"107":{"tf":1.0},"131":{"tf":1.0},"138":{"tf":1.0},"14":{"tf":1.0},"152":{"tf":1.0},"195":{"tf":1.0},"206":{"tf":1.4142135623730951},"207":{"tf":1.0},"220":{"tf":2.23606797749979},"221":{"tf":1.0},"222":{"tf":2.0},"231":{"tf":1.0},"232":{"tf":1.0},"4":{"tf":1.0},"91":{"tf":1.0},"94":{"tf":1.0},"97":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"208":{"tf":2.23606797749979}}},"df":14,"docs":{"138":{"tf":1.4142135623730951},"154":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.4142135623730951},"204":{"tf":1.4142135623730951},"206":{"tf":1.0},"207":{"tf":1.4142135623730951},"208":{"tf":2.23606797749979},"220":{"tf":2.0},"221":{"tf":1.4142135623730951},"229":{"tf":1.0},"230":{"tf":1.0},"232":{"tf":1.0},"235":{"tf":1.0}}}}}}},"df":0,"docs":{},"v":{"df":1,"docs":{"132":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"df":11,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"13":{"tf":1.0},"137":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.4142135623730951},"147":{"tf":1.0},"151":{"tf":1.4142135623730951},"163":{"tf":1.4142135623730951},"203":{"tf":1.0},"204":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.0}}},"t":{"df":2,"docs":{"137":{"tf":1.0},"201":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":2,"docs":{"137":{"tf":1.0},"160":{"tf":1.0}}},"t":{"df":1,"docs":{"218":{"tf":1.0}}}},"y":{"df":1,"docs":{"138":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"i":{"df":10,"docs":{"103":{"tf":1.0},"106":{"tf":1.0},"159":{"tf":1.0},"160":{"tf":1.0},"185":{"tf":1.0},"227":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0},"99":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"h":{"c":{"5":{"c":{"b":{"6":{"df":0,"docs":{},"f":{"1":{"b":{"3":{"9":{"a":{"0":{"df":0,"docs":{},"e":{"7":{"a":{"1":{"df":1,"docs":{"122":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"=":{".":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"111":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"111":{"tf":1.0},"63":{"tf":1.0}}}}}},"df":13,"docs":{"109":{"tf":1.0},"111":{"tf":3.0},"144":{"tf":1.4142135623730951},"162":{"tf":1.0},"214":{"tf":2.0},"219":{"tf":1.4142135623730951},"220":{"tf":1.0},"221":{"tf":1.7320508075688772},"41":{"tf":1.0},"62":{"tf":1.4142135623730951},"63":{"tf":2.8284271247461903},"92":{"tf":1.0},"93":{"tf":1.4142135623730951}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"a":{"df":1,"docs":{"216":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"df":2,"docs":{"188":{"tf":1.0},"191":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":9,"docs":{"0":{"tf":1.0},"115":{"tf":1.0},"134":{"tf":1.4142135623730951},"138":{"tf":1.4142135623730951},"145":{"tf":1.0},"162":{"tf":1.0},"206":{"tf":1.0},"209":{"tf":1.0},"232":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"163":{"tf":1.0},"194":{"tf":1.0},"222":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"158":{"tf":1.0},"162":{"tf":1.0},"211":{"tf":1.0}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"150":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"131":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":9,"docs":{"158":{"tf":1.0},"159":{"tf":1.4142135623730951},"165":{"tf":1.7320508075688772},"166":{"tf":2.23606797749979},"20":{"tf":1.0},"26":{"tf":1.4142135623730951},"28":{"tf":2.23606797749979},"34":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"112":{"tf":1.0},"163":{"tf":1.0},"20":{"tf":1.0},"33":{"tf":1.7320508075688772}}}}}},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"150":{"tf":1.0},"188":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":4,"docs":{"138":{"tf":1.0},"191":{"tf":1.0},"216":{"tf":1.0},"220":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"/":{"1":{"/":{"4":{"df":1,"docs":{"235":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":2,"docs":{"229":{"tf":1.0},"235":{"tf":1.0}}},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"191":{"tf":1.0}}}},"df":7,"docs":{"137":{"tf":1.0},"143":{"tf":1.0},"160":{"tf":1.0},"163":{"tf":1.4142135623730951},"189":{"tf":1.0},"212":{"tf":1.0},"220":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"135":{"tf":1.0}}},"u":{"df":3,"docs":{"0":{"tf":1.0},"112":{"tf":1.4142135623730951},"122":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"'":{"df":2,"docs":{"138":{"tf":1.4142135623730951},"140":{"tf":1.0}}},"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"178":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}}}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"180":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"t":{"a":{":":{":":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"6":{"df":0,"docs":{},"f":{"5":{"b":{"6":{"a":{"7":{"2":{"df":0,"docs":{},"f":{"c":{"6":{"8":{"4":{"df":1,"docs":{"122":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"(":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":29,"docs":{"0":{"tf":1.0},"12":{"tf":1.4142135623730951},"131":{"tf":3.0},"134":{"tf":1.7320508075688772},"137":{"tf":2.449489742783178},"138":{"tf":1.4142135623730951},"140":{"tf":3.0},"142":{"tf":1.0},"145":{"tf":1.7320508075688772},"148":{"tf":1.0},"152":{"tf":1.7320508075688772},"153":{"tf":2.0},"155":{"tf":1.7320508075688772},"158":{"tf":1.4142135623730951},"159":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":1.0},"166":{"tf":1.0},"167":{"tf":2.23606797749979},"178":{"tf":1.7320508075688772},"180":{"tf":1.0},"189":{"tf":1.0},"192":{"tf":1.0},"195":{"tf":1.0},"196":{"tf":1.0},"201":{"tf":1.0},"205":{"tf":1.0},"206":{"tf":1.4142135623730951},"221":{"tf":1.4142135623730951}}}}}}}},"t":{"df":0,"docs":{},"e":{"'":{"df":4,"docs":{"175":{"tf":1.0},"179":{"tf":1.0},"216":{"tf":1.0},"217":{"tf":1.0}}},":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"v":{"df":0,"docs":{},"m":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"162":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"158":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"m":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"158":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"158":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":39,"docs":{"118":{"tf":1.0},"13":{"tf":1.0},"130":{"tf":2.8284271247461903},"131":{"tf":1.0},"135":{"tf":1.4142135623730951},"138":{"tf":1.0},"142":{"tf":1.0},"156":{"tf":1.4142135623730951},"157":{"tf":3.4641016151377544},"159":{"tf":1.0},"16":{"tf":1.0},"163":{"tf":1.0},"167":{"tf":3.1622776601683795},"170":{"tf":1.0},"172":{"tf":1.0},"175":{"tf":1.7320508075688772},"178":{"tf":1.7320508075688772},"179":{"tf":1.7320508075688772},"180":{"tf":1.4142135623730951},"181":{"tf":1.0},"183":{"tf":2.0},"184":{"tf":1.0},"185":{"tf":1.4142135623730951},"187":{"tf":1.0},"191":{"tf":1.7320508075688772},"200":{"tf":1.0},"203":{"tf":1.0},"204":{"tf":2.449489742783178},"206":{"tf":1.7320508075688772},"209":{"tf":2.0},"216":{"tf":2.449489742783178},"218":{"tf":1.7320508075688772},"224":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":1.7320508075688772},"40":{"tf":1.0},"50":{"tf":1.0},"53":{"tf":1.7320508075688772},"55":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":4,"docs":{"125":{"tf":1.0},"157":{"tf":1.0},"209":{"tf":1.4142135623730951},"224":{"tf":1.4142135623730951}}}}},"/":{"c":{"df":7,"docs":{"174":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"175":{"tf":1.0},"179":{"tf":1.0}}}}}}}}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"z":{"df":0,"docs":{},"z":{"df":1,"docs":{"187":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"181":{"tf":1.0},"185":{"tf":1.4142135623730951}}}}}},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"/":{"*":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"183":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"c":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"162":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"v":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{".":{"c":{"df":1,"docs":{"163":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":42,"docs":{"10":{"tf":1.0},"100":{"tf":1.0},"103":{"tf":1.0},"114":{"tf":1.4142135623730951},"115":{"tf":2.23606797749979},"123":{"tf":1.0},"13":{"tf":1.0},"132":{"tf":1.0},"14":{"tf":1.0},"140":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.0},"158":{"tf":2.0},"159":{"tf":1.4142135623730951},"160":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":1.0},"167":{"tf":1.0},"183":{"tf":1.0},"184":{"tf":1.0},"199":{"tf":1.0},"214":{"tf":1.0},"218":{"tf":1.4142135623730951},"221":{"tf":1.0},"224":{"tf":2.23606797749979},"225":{"tf":1.0},"227":{"tf":1.0},"231":{"tf":1.0},"24":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.7320508075688772},"40":{"tf":2.0},"43":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"66":{"tf":1.0},"70":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"79":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0},"93":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"160":{"tf":1.0}}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":2,"docs":{"134":{"tf":1.0},"138":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"i":{"c":{"df":2,"docs":{"134":{"tf":1.0},"231":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":10,"docs":{"0":{"tf":1.0},"112":{"tf":1.4142135623730951},"127":{"tf":1.0},"158":{"tf":1.4142135623730951},"162":{"tf":1.0},"195":{"tf":1.4142135623730951},"197":{"tf":1.4142135623730951},"198":{"tf":1.0},"199":{"tf":1.0},"200":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"137":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"130":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":2,"docs":{"223":{"tf":1.0},"4":{"tf":1.0}}}}},"l":{"df":1,"docs":{"2":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":26,"docs":{"10":{"tf":1.0},"106":{"tf":1.0},"109":{"tf":1.0},"110":{"tf":1.0},"115":{"tf":1.0},"119":{"tf":1.0},"126":{"tf":1.0},"131":{"tf":2.0},"132":{"tf":1.7320508075688772},"134":{"tf":2.0},"137":{"tf":2.23606797749979},"138":{"tf":1.0},"140":{"tf":1.4142135623730951},"142":{"tf":1.0},"158":{"tf":1.4142135623730951},"165":{"tf":1.0},"188":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.0},"192":{"tf":1.0},"204":{"tf":1.0},"218":{"tf":1.0},"224":{"tf":1.4142135623730951},"226":{"tf":1.0},"54":{"tf":1.0},"91":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":12,"docs":{"130":{"tf":1.0},"131":{"tf":2.0},"132":{"tf":2.6457513110645907},"14":{"tf":1.0},"142":{"tf":1.0},"184":{"tf":1.0},"216":{"tf":1.4142135623730951},"217":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"53":{"tf":1.0},"70":{"tf":1.4142135623730951}}}}}},"t":{"df":1,"docs":{"224":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"138":{"tf":1.0}}}},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":2,"docs":{"11":{"tf":1.0},"130":{"tf":1.0}}}}},"df":0,"docs":{}},"y":{"c":{"df":0,"docs":{},"l":{"df":1,"docs":{"166":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"d":{"\\":{"df":0,"docs":{},"n":{"df":4,"docs":{"73":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0},"96":{"tf":1.0}}}},"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"130":{"tf":2.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":3,"docs":{"130":{"tf":1.4142135623730951},"137":{"tf":1.4142135623730951},"195":{"tf":1.0}}}}}},"t":{"a":{"b":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"122":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":21,"docs":{"116":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.4142135623730951},"121":{"tf":1.7320508075688772},"122":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.0},"126":{"tf":1.0},"137":{"tf":1.0},"158":{"tf":1.0},"162":{"tf":1.7320508075688772},"187":{"tf":1.0},"194":{"tf":2.6457513110645907},"31":{"tf":1.4142135623730951},"39":{"tf":1.0},"40":{"tf":1.7320508075688772},"48":{"tf":1.0},"57":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"75":{"tf":1.0},"81":{"tf":1.4142135623730951}}},"df":0,"docs":{},"e":{"df":4,"docs":{"130":{"tf":1.0},"220":{"tf":1.0},"224":{"tf":1.0},"225":{"tf":1.0}}}},"y":{"df":5,"docs":{"134":{"tf":1.0},"167":{"tf":1.0},"209":{"tf":1.0},"220":{"tf":1.0},"226":{"tf":1.0}}}},"df":8,"docs":{"110":{"tf":1.7320508075688772},"111":{"tf":1.0},"13":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"73":{"tf":1.0},"90":{"tf":1.0}},"e":{"a":{"d":{"df":1,"docs":{"130":{"tf":1.4142135623730951}}},"df":0,"docs":{},"l":{"df":3,"docs":{"159":{"tf":1.0},"49":{"tf":1.0},"66":{"tf":1.0}},"l":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"158":{"tf":2.0}}},"df":0,"docs":{}}}}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":17,"docs":{"109":{"tf":1.7320508075688772},"110":{"tf":2.8284271247461903},"111":{"tf":1.4142135623730951},"114":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.7320508075688772},"122":{"tf":1.0},"130":{"tf":2.23606797749979},"131":{"tf":1.0},"137":{"tf":1.4142135623730951},"159":{"tf":1.0},"167":{"tf":1.7320508075688772},"173":{"tf":1.0},"191":{"tf":1.0},"60":{"tf":1.4142135623730951},"61":{"tf":2.23606797749979},"84":{"tf":1.4142135623730951}},"g":{"df":3,"docs":{"110":{"tf":1.4142135623730951},"60":{"tf":1.0},"84":{"tf":1.0}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":3,"docs":{"159":{"tf":1.0},"39":{"tf":1.0},"61":{"tf":1.4142135623730951}}}}}}}}},"c":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"19":{"tf":1.0},"22":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"187":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":3,"docs":{"130":{"tf":1.0},"159":{"tf":1.0},"160":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":2,"docs":{"232":{"tf":1.0},"234":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"112":{"tf":1.0},"130":{"tf":1.0}}}}}},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":49,"docs":{"0":{"tf":1.0},"101":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"118":{"tf":1.0},"119":{"tf":1.0},"127":{"tf":1.4142135623730951},"128":{"tf":1.4142135623730951},"130":{"tf":4.123105625617661},"131":{"tf":1.0},"132":{"tf":1.0},"134":{"tf":1.0},"138":{"tf":1.4142135623730951},"14":{"tf":2.0},"142":{"tf":1.4142135623730951},"145":{"tf":1.0},"148":{"tf":1.0},"15":{"tf":1.7320508075688772},"16":{"tf":1.0},"164":{"tf":1.7320508075688772},"165":{"tf":1.0},"167":{"tf":1.7320508075688772},"17":{"tf":1.0},"18":{"tf":1.4142135623730951},"19":{"tf":1.0},"190":{"tf":1.7320508075688772},"192":{"tf":1.0},"20":{"tf":1.0},"203":{"tf":1.0},"204":{"tf":1.7320508075688772},"205":{"tf":1.0},"206":{"tf":1.4142135623730951},"21":{"tf":1.0},"217":{"tf":1.7320508075688772},"218":{"tf":1.0},"22":{"tf":1.0},"221":{"tf":1.0},"23":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"43":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"7":{"tf":1.0},"79":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"145":{"tf":1.4142135623730951}}}},"r":{"df":2,"docs":{"166":{"tf":1.0},"222":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"df":19,"docs":{"0":{"tf":1.4142135623730951},"131":{"tf":1.0},"132":{"tf":1.4142135623730951},"142":{"tf":1.4142135623730951},"157":{"tf":1.0},"158":{"tf":2.0},"162":{"tf":1.0},"163":{"tf":1.0},"167":{"tf":1.0},"188":{"tf":1.0},"216":{"tf":1.0},"233":{"tf":1.0},"24":{"tf":1.0},"40":{"tf":1.7320508075688772},"50":{"tf":1.0},"52":{"tf":1.0},"79":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"85":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"138":{"tf":1.0},"158":{"tf":1.0},"162":{"tf":1.0}}}}}}},"g":{"df":0,"docs":{},"r":{"a":{"d":{"df":1,"docs":{"110":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":2,"docs":{"134":{"tf":1.0},"138":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":4,"docs":{"25":{"tf":1.0},"28":{"tf":1.7320508075688772},"29":{"tf":1.7320508075688772},"34":{"tf":2.0}}}}},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"158":{"tf":1.0},"162":{"tf":1.4142135623730951}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"117":{"tf":1.0}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"92":{"tf":1.0}}}}}}}},"n":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"150":{"tf":1.4142135623730951},"151":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"103":{"tf":1.0},"106":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0},"99":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":25,"docs":{"114":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"126":{"tf":1.0},"130":{"tf":1.0},"132":{"tf":1.7320508075688772},"141":{"tf":1.0},"142":{"tf":1.0},"147":{"tf":1.0},"156":{"tf":1.0},"157":{"tf":2.23606797749979},"162":{"tf":1.0},"167":{"tf":2.0},"172":{"tf":1.0},"178":{"tf":1.0},"190":{"tf":1.0},"192":{"tf":1.0},"205":{"tf":1.4142135623730951},"206":{"tf":2.8284271247461903},"207":{"tf":3.0},"208":{"tf":1.7320508075688772},"209":{"tf":2.23606797749979},"39":{"tf":2.23606797749979},"8":{"tf":1.0},"90":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"145":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"110":{"tf":1.0}}}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":4,"docs":{"110":{"tf":1.0},"168":{"tf":1.0},"176":{"tf":1.0},"219":{"tf":1.0}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":5,"docs":{"116":{"tf":1.0},"136":{"tf":1.0},"137":{"tf":1.7320508075688772},"138":{"tf":1.0},"208":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"158":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":7,"docs":{"0":{"tf":1.0},"134":{"tf":1.0},"137":{"tf":1.0},"143":{"tf":1.0},"145":{"tf":1.0},"157":{"tf":1.0},"217":{"tf":1.0}}}},"r":{"df":4,"docs":{"110":{"tf":1.0},"141":{"tf":1.0},"204":{"tf":1.0},"43":{"tf":1.0}}}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"166":{"tf":1.0},"203":{"tf":1.0},"204":{"tf":1.0},"221":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"144":{"tf":1.0}}}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"163":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"=":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"130":{"tf":2.0}}}}}},"df":20,"docs":{"111":{"tf":1.0},"113":{"tf":1.0},"118":{"tf":1.0},"136":{"tf":1.0},"138":{"tf":1.0},"139":{"tf":1.0},"144":{"tf":1.0},"156":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.0},"166":{"tf":1.0},"172":{"tf":1.0},"174":{"tf":1.0},"188":{"tf":1.0},"208":{"tf":1.0},"222":{"tf":1.0},"224":{"tf":1.0},"234":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"148":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":9,"docs":{"145":{"tf":1.0},"158":{"tf":1.4142135623730951},"163":{"tf":1.0},"166":{"tf":1.0},"187":{"tf":1.4142135623730951},"193":{"tf":1.0},"194":{"tf":1.4142135623730951},"221":{"tf":1.0},"234":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"148":{"tf":1.0}}}}}}}}}}},"v":{"df":5,"docs":{"130":{"tf":1.0},"192":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":2.23606797749979},"39":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":19,"docs":{"0":{"tf":1.4142135623730951},"131":{"tf":1.0},"137":{"tf":1.0},"138":{"tf":2.23606797749979},"140":{"tf":1.0},"143":{"tf":1.0},"145":{"tf":1.0},"146":{"tf":1.4142135623730951},"147":{"tf":1.0},"152":{"tf":1.0},"153":{"tf":1.0},"154":{"tf":1.0},"193":{"tf":1.0},"195":{"tf":1.0},"203":{"tf":1.4142135623730951},"206":{"tf":1.4142135623730951},"210":{"tf":1.0},"224":{"tf":1.0},"226":{"tf":1.4142135623730951}}}}}}}},"i":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"130":{"tf":1.0}},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":14,"docs":{"136":{"tf":1.0},"143":{"tf":1.4142135623730951},"158":{"tf":1.4142135623730951},"159":{"tf":1.0},"160":{"tf":1.0},"161":{"tf":1.0},"163":{"tf":1.0},"193":{"tf":1.0},"195":{"tf":1.0},"221":{"tf":1.0},"222":{"tf":1.0},"226":{"tf":1.0},"231":{"tf":1.0},"24":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"138":{"tf":1.0}}}}}}}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":3,"docs":{"138":{"tf":1.4142135623730951},"194":{"tf":1.0},"212":{"tf":1.0}},"i":{"df":1,"docs":{"220":{"tf":1.0}}}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"221":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"144":{"tf":1.0},"9":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":7,"docs":{"103":{"tf":1.0},"124":{"tf":1.0},"138":{"tf":1.0},"165":{"tf":1.0},"208":{"tf":1.4142135623730951},"218":{"tf":1.0},"225":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":23,"docs":{"106":{"tf":1.0},"115":{"tf":1.0},"121":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.0},"126":{"tf":1.0},"132":{"tf":1.4142135623730951},"14":{"tf":1.0},"146":{"tf":1.0},"151":{"tf":1.0},"16":{"tf":1.7320508075688772},"175":{"tf":1.0},"179":{"tf":1.0},"183":{"tf":1.4142135623730951},"187":{"tf":1.0},"189":{"tf":1.0},"2":{"tf":1.0},"208":{"tf":1.0},"218":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"34":{"tf":1.0},"93":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":5,"docs":{"110":{"tf":1.0},"130":{"tf":2.23606797749979},"138":{"tf":1.7320508075688772},"204":{"tf":1.0},"230":{"tf":1.0}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"222":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"117":{"tf":1.0},"193":{"tf":1.0},"194":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"149":{"tf":1.4142135623730951}}}}}}},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"209":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":11,"docs":{"110":{"tf":1.0},"124":{"tf":1.0},"131":{"tf":1.0},"137":{"tf":1.0},"14":{"tf":1.0},"140":{"tf":1.0},"157":{"tf":1.0},"158":{"tf":1.4142135623730951},"211":{"tf":1.0},"220":{"tf":1.0},"226":{"tf":1.0}}}}}},"df":0,"docs":{},"k":{"df":4,"docs":{"159":{"tf":1.0},"27":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"33":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":5,"docs":{"111":{"tf":1.0},"12":{"tf":1.0},"121":{"tf":1.0},"13":{"tf":1.0},"147":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"25":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"136":{"tf":1.0}}}}}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"137":{"tf":1.4142135623730951},"195":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"112":{"tf":1.0}},"r":{"df":0,"docs":{},"g":{"df":2,"docs":{"150":{"tf":1.0},"151":{"tf":1.0}}},"s":{"df":1,"docs":{"220":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"221":{"tf":1.0}}}}}},"n":{"a":{"df":1,"docs":{"187":{"tf":1.0}}},"df":0,"docs":{}},"o":{"c":{"df":4,"docs":{"13":{"tf":1.0},"191":{"tf":1.0},"192":{"tf":1.0},"55":{"tf":1.0}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":38,"docs":{"0":{"tf":1.7320508075688772},"104":{"tf":1.0},"107":{"tf":1.0},"113":{"tf":1.0},"118":{"tf":1.0},"129":{"tf":1.0},"130":{"tf":1.0},"134":{"tf":1.4142135623730951},"136":{"tf":1.4142135623730951},"137":{"tf":1.0},"139":{"tf":1.0},"142":{"tf":1.0},"143":{"tf":1.4142135623730951},"149":{"tf":1.0},"153":{"tf":1.0},"156":{"tf":1.0},"157":{"tf":1.7320508075688772},"158":{"tf":1.0},"164":{"tf":1.0},"191":{"tf":1.7320508075688772},"192":{"tf":1.7320508075688772},"2":{"tf":1.0},"207":{"tf":1.0},"209":{"tf":1.0},"212":{"tf":1.0},"216":{"tf":1.0},"221":{"tf":1.0},"223":{"tf":1.0},"224":{"tf":1.0},"226":{"tf":1.0},"37":{"tf":1.4142135623730951},"4":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"47":{"tf":1.0},"56":{"tf":1.0},"67":{"tf":1.0},"74":{"tf":1.0}}}}}}}},"df":4,"docs":{"1":{"tf":1.0},"213":{"tf":1.0},"224":{"tf":1.0},"226":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":14,"docs":{"116":{"tf":1.0},"130":{"tf":1.4142135623730951},"131":{"tf":1.4142135623730951},"137":{"tf":1.0},"144":{"tf":1.0},"158":{"tf":1.4142135623730951},"160":{"tf":1.0},"183":{"tf":1.0},"217":{"tf":1.0},"225":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":23,"docs":{"114":{"tf":1.0},"115":{"tf":1.0},"126":{"tf":1.0},"130":{"tf":1.0},"138":{"tf":1.0},"14":{"tf":1.4142135623730951},"153":{"tf":1.4142135623730951},"157":{"tf":1.0},"158":{"tf":1.0},"160":{"tf":1.0},"164":{"tf":1.0},"193":{"tf":1.0},"206":{"tf":1.4142135623730951},"207":{"tf":1.0},"208":{"tf":1.0},"213":{"tf":1.4142135623730951},"221":{"tf":1.4142135623730951},"225":{"tf":1.0},"226":{"tf":1.0},"3":{"tf":1.0},"91":{"tf":1.0},"94":{"tf":1.0},"97":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":26,"docs":{"101":{"tf":1.0},"130":{"tf":1.7320508075688772},"131":{"tf":1.0},"132":{"tf":1.0},"138":{"tf":1.0},"140":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.0},"154":{"tf":1.0},"159":{"tf":1.0},"177":{"tf":1.0},"181":{"tf":1.0},"205":{"tf":1.0},"206":{"tf":1.0},"207":{"tf":1.0},"208":{"tf":1.0},"209":{"tf":1.0},"224":{"tf":1.0},"225":{"tf":1.0},"39":{"tf":1.0},"43":{"tf":1.0},"76":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"95":{"tf":1.0}}}},"t":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"135":{"tf":1.0},"93":{"tf":1.7320508075688772}}}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":11,"docs":{"128":{"tf":1.0},"138":{"tf":1.0},"194":{"tf":1.0},"224":{"tf":1.0},"225":{"tf":1.0},"226":{"tf":1.0},"40":{"tf":3.0},"57":{"tf":2.0},"58":{"tf":1.0},"81":{"tf":2.0},"82":{"tf":1.0}}},"t":{"df":2,"docs":{"185":{"tf":1.0},"6":{"tf":1.0}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"n":{".":{".":{".":{"\\":{"df":0,"docs":{},"n":{"df":3,"docs":{"76":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{":":{":":{"<":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":7,"docs":{"130":{"tf":1.4142135623730951},"131":{"tf":1.0},"159":{"tf":1.0},"207":{"tf":1.0},"76":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":6,"docs":{"118":{"tf":1.0},"192":{"tf":1.0},"2":{"tf":1.4142135623730951},"209":{"tf":1.0},"224":{"tf":1.4142135623730951},"3":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":5,"docs":{"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"34":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"187":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"p":{"df":7,"docs":{"17":{"tf":1.0},"185":{"tf":1.0},"31":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":1.0},"81":{"tf":1.4142135623730951},"82":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"e":{"df":9,"docs":{"110":{"tf":1.0},"130":{"tf":1.0},"134":{"tf":1.0},"138":{"tf":1.0},"148":{"tf":1.0},"162":{"tf":1.0},"209":{"tf":1.0},"224":{"tf":1.0},"70":{"tf":1.0}}},"m":{"df":0,"docs":{},"p":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"b":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"(":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"63":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"(":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"63":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":6,"docs":{"109":{"tf":1.0},"111":{"tf":3.0},"115":{"tf":1.7320508075688772},"126":{"tf":1.0},"62":{"tf":1.4142135623730951},"63":{"tf":3.0}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":4,"docs":{"127":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":14,"docs":{"118":{"tf":1.0},"121":{"tf":1.0},"138":{"tf":1.0},"150":{"tf":1.0},"161":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":1.0},"183":{"tf":1.0},"203":{"tf":1.0},"206":{"tf":1.0},"209":{"tf":1.0},"212":{"tf":1.0},"213":{"tf":1.0},"34":{"tf":1.0}}}}},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":5,"docs":{"116":{"tf":2.0},"137":{"tf":1.4142135623730951},"159":{"tf":1.0},"167":{"tf":1.4142135623730951},"85":{"tf":1.0}}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":11,"docs":{"122":{"tf":1.0},"131":{"tf":1.0},"137":{"tf":1.0},"141":{"tf":1.0},"148":{"tf":1.0},"158":{"tf":1.7320508075688772},"164":{"tf":1.7320508075688772},"60":{"tf":1.0},"66":{"tf":1.0},"84":{"tf":1.0},"93":{"tf":1.0}}}},"df":1,"docs":{"158":{"tf":1.0}}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":10,"docs":{"110":{"tf":1.0},"124":{"tf":1.4142135623730951},"131":{"tf":1.0},"132":{"tf":1.0},"148":{"tf":1.0},"150":{"tf":1.0},"158":{"tf":1.0},"160":{"tf":1.0},"208":{"tf":1.0},"55":{"tf":1.0}}}},"a":{"c":{"df":0,"docs":{},"h":{"df":19,"docs":{"0":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"134":{"tf":1.0},"137":{"tf":1.0},"138":{"tf":1.4142135623730951},"158":{"tf":2.23606797749979},"159":{"tf":1.4142135623730951},"160":{"tf":1.4142135623730951},"161":{"tf":1.0},"162":{"tf":1.0},"183":{"tf":1.0},"197":{"tf":1.0},"213":{"tf":1.0},"220":{"tf":1.0},"221":{"tf":1.4142135623730951},"226":{"tf":1.7320508075688772},"3":{"tf":1.4142135623730951},"59":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"131":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"158":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"df":5,"docs":{"120":{"tf":1.0},"131":{"tf":1.4142135623730951},"155":{"tf":1.4142135623730951},"160":{"tf":1.0},"195":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"147":{"tf":1.0},"193":{"tf":1.0},"194":{"tf":1.0},"208":{"tf":1.0},"213":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":5,"docs":{"130":{"tf":1.0},"183":{"tf":1.0},"185":{"tf":1.0},"2":{"tf":1.0},"39":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"138":{"tf":1.0},"213":{"tf":1.0},"221":{"tf":1.0}}}}}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":1,"docs":{"101":{"tf":1.4142135623730951}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":6,"docs":{"10":{"tf":1.7320508075688772},"191":{"tf":1.0},"205":{"tf":1.0},"206":{"tf":1.0},"227":{"tf":1.0},"232":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"147":{"tf":1.0},"202":{"tf":1.0}}}}}}},"df":4,"docs":{"155":{"tf":1.7320508075688772},"194":{"tf":1.0},"199":{"tf":2.449489742783178},"233":{"tf":1.0}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"132":{"tf":1.0},"147":{"tf":1.0},"161":{"tf":1.0},"164":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"158":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":5,"docs":{"131":{"tf":1.0},"137":{"tf":1.0},"138":{"tf":1.0},"157":{"tf":1.0},"220":{"tf":1.4142135623730951}}}}}}},"l":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":1,"docs":{"122":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"231":{"tf":1.0}}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"162":{"tf":1.7320508075688772}}}}}}},"f":{"df":3,"docs":{"115":{"tf":1.0},"159":{"tf":1.0},"167":{"tf":1.0}}},"i":{"d":{"df":1,"docs":{"164":{"tf":1.4142135623730951}}},"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":3,"docs":{"105":{"tf":1.4142135623730951},"106":{"tf":1.0},"36":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"142":{"tf":1.0},"145":{"tf":1.0}}}}}}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"226":{"tf":1.4142135623730951}}}}},"b":{"df":2,"docs":{"36":{"tf":1.0},"37":{"tf":1.0}},"e":{"d":{"d":{"df":4,"docs":{"131":{"tf":1.0},"142":{"tf":1.4142135623730951},"145":{"tf":1.7320508075688772},"150":{"tf":1.4142135623730951}}},"df":16,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"110":{"tf":1.7320508075688772},"111":{"tf":1.4142135623730951},"129":{"tf":1.4142135623730951},"130":{"tf":1.7320508075688772},"131":{"tf":2.449489742783178},"132":{"tf":1.7320508075688772},"134":{"tf":1.0},"145":{"tf":1.0},"160":{"tf":1.0},"166":{"tf":1.0},"2":{"tf":1.4142135623730951},"216":{"tf":1.0},"67":{"tf":1.4142135623730951},"94":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"131":{"tf":1.0},"140":{"tf":1.0},"147":{"tf":1.0},"164":{"tf":1.0},"217":{"tf":1.0}}}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"231":{"tf":1.0}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"145":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"130":{"tf":1.0},"227":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":3,"docs":{"138":{"tf":1.0},"198":{"tf":1.0},"200":{"tf":1.4142135623730951}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":31,"docs":{"1":{"tf":1.0},"110":{"tf":1.7320508075688772},"114":{"tf":2.0},"115":{"tf":2.23606797749979},"116":{"tf":1.4142135623730951},"118":{"tf":1.0},"119":{"tf":2.0},"121":{"tf":1.0},"122":{"tf":1.0},"124":{"tf":1.0},"126":{"tf":2.0},"127":{"tf":1.0},"13":{"tf":1.0},"130":{"tf":1.4142135623730951},"131":{"tf":1.0},"132":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"142":{"tf":1.0},"145":{"tf":1.0},"15":{"tf":1.0},"164":{"tf":1.0},"167":{"tf":1.4142135623730951},"187":{"tf":1.0},"203":{"tf":1.7320508075688772},"204":{"tf":2.0},"216":{"tf":1.7320508075688772},"217":{"tf":2.0},"39":{"tf":1.0},"55":{"tf":1.4142135623730951},"61":{"tf":1.0},"70":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"216":{"tf":1.0}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"135":{"tf":1.0},"137":{"tf":1.0},"138":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"164":{"tf":1.0},"203":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"155":{"tf":1.0},"204":{"tf":1.0}}}},"df":0,"docs":{}}}}},"d":{"df":16,"docs":{"100":{"tf":1.7320508075688772},"103":{"tf":1.7320508075688772},"106":{"tf":1.7320508075688772},"130":{"tf":1.0},"150":{"tf":1.0},"159":{"tf":1.0},"164":{"tf":1.0},"189":{"tf":1.0},"194":{"tf":1.0},"222":{"tf":1.0},"224":{"tf":1.0},"45":{"tf":1.7320508075688772},"72":{"tf":1.7320508075688772},"90":{"tf":1.7320508075688772},"93":{"tf":1.7320508075688772},"96":{"tf":1.7320508075688772}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"234":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"g":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"0":{"tf":1.0},"146":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":24,"docs":{"103":{"tf":1.0},"158":{"tf":1.7320508075688772},"161":{"tf":1.7320508075688772},"187":{"tf":1.0},"193":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"40":{"tf":1.0},"43":{"tf":2.0},"52":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.7320508075688772},"59":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.4142135623730951},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.7320508075688772},"85":{"tf":1.4142135623730951},"88":{"tf":1.0},"93":{"tf":1.4142135623730951},"96":{"tf":1.0}},"e":{":":{":":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":7,"docs":{"39":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"59":{"tf":1.0},"66":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"&":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":2,"docs":{"55":{"tf":1.0},"63":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"61":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":3,"docs":{"116":{"tf":1.0},"131":{"tf":1.0},"217":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":13,"docs":{"119":{"tf":1.0},"144":{"tf":1.0},"146":{"tf":1.0},"148":{"tf":1.0},"170":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.0},"191":{"tf":1.7320508075688772},"206":{"tf":1.0},"208":{"tf":1.4142135623730951},"209":{"tf":1.0},"221":{"tf":1.0},"61":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"160":{"tf":1.4142135623730951},"163":{"tf":1.7320508075688772},"190":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"r":{"df":7,"docs":{"134":{"tf":1.0},"140":{"tf":1.0},"158":{"tf":1.0},"191":{"tf":1.0},"192":{"tf":1.0},"204":{"tf":1.0},"222":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":12,"docs":{"114":{"tf":1.0},"115":{"tf":1.0},"139":{"tf":1.0},"148":{"tf":1.0},"157":{"tf":1.0},"159":{"tf":1.4142135623730951},"190":{"tf":1.4142135623730951},"206":{"tf":2.0},"207":{"tf":1.4142135623730951},"208":{"tf":2.23606797749979},"209":{"tf":2.8284271247461903},"227":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"216":{"tf":1.0}}}}}},"v":{"df":2,"docs":{"70":{"tf":1.0},"88":{"tf":1.7320508075688772}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":16,"docs":{"11":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.4142135623730951},"13":{"tf":1.0},"130":{"tf":1.7320508075688772},"132":{"tf":1.0},"138":{"tf":1.0},"144":{"tf":1.4142135623730951},"166":{"tf":1.0},"167":{"tf":2.0},"175":{"tf":1.4142135623730951},"179":{"tf":1.4142135623730951},"230":{"tf":1.0},"231":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0}}}}}}}},"q":{"df":1,"docs":{"194":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"142":{"tf":1.0},"164":{"tf":1.0},"191":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"151":{"tf":1.0}}}}},"df":3,"docs":{"150":{"tf":1.0},"63":{"tf":1.4142135623730951},"96":{"tf":2.0}},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":7,"docs":{"70":{"tf":1.7320508075688772},"73":{"tf":1.7320508075688772},"76":{"tf":1.7320508075688772},"79":{"tf":1.7320508075688772},"83":{"tf":1.7320508075688772},"85":{"tf":1.7320508075688772},"88":{"tf":1.7320508075688772}},"e":{".":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":7,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":19,"docs":{"111":{"tf":1.4142135623730951},"128":{"tf":2.0},"130":{"tf":1.0},"131":{"tf":1.0},"142":{"tf":1.0},"190":{"tf":1.0},"203":{"tf":1.4142135623730951},"204":{"tf":1.0},"222":{"tf":1.0},"39":{"tf":1.4142135623730951},"40":{"tf":1.0},"70":{"tf":4.123105625617661},"73":{"tf":4.123105625617661},"76":{"tf":6.082762530298219},"79":{"tf":4.795831523312719},"83":{"tf":5.744562646538029},"85":{"tf":3.7416573867739413},"88":{"tf":4.242640687119285},"96":{"tf":1.0}}}}}},"s":{"c":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"147":{"tf":2.23606797749979},"151":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"211":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"222":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"c":{"df":15,"docs":{"114":{"tf":1.0},"137":{"tf":1.0},"138":{"tf":1.4142135623730951},"143":{"tf":1.0},"150":{"tf":1.0},"151":{"tf":2.0},"157":{"tf":1.0},"158":{"tf":1.4142135623730951},"159":{"tf":1.4142135623730951},"160":{"tf":1.0},"162":{"tf":1.7320508075688772},"171":{"tf":1.0},"214":{"tf":1.0},"39":{"tf":1.4142135623730951},"9":{"tf":1.0}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"230":{"tf":1.0}}},"df":0,"docs":{}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":3,"docs":{"131":{"tf":1.0},"136":{"tf":1.0},"138":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":14,"docs":{"112":{"tf":1.0},"134":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.0},"150":{"tf":1.4142135623730951},"151":{"tf":1.0},"152":{"tf":1.0},"153":{"tf":1.0},"155":{"tf":1.0},"156":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":1.0},"193":{"tf":1.0},"214":{"tf":1.0}},"t":{"df":8,"docs":{"119":{"tf":1.0},"121":{"tf":1.0},"124":{"tf":1.0},"145":{"tf":1.0},"17":{"tf":1.7320508075688772},"233":{"tf":1.0},"31":{"tf":2.0},"32":{"tf":1.0}},"u":{"df":1,"docs":{"24":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"138":{"tf":1.4142135623730951},"193":{"tf":1.0},"220":{"tf":1.0},"221":{"tf":1.4142135623730951},"230":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":12,"docs":{"112":{"tf":1.0},"131":{"tf":1.0},"138":{"tf":1.0},"153":{"tf":1.0},"157":{"tf":1.0},"159":{"tf":1.0},"168":{"tf":1.0},"189":{"tf":1.0},"191":{"tf":1.0},"206":{"tf":1.0},"224":{"tf":1.4142135623730951},"226":{"tf":1.0}}}}}}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"130":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"164":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":94,"docs":{"103":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"107":{"tf":1.4142135623730951},"108":{"tf":1.4142135623730951},"110":{"tf":1.0},"114":{"tf":1.4142135623730951},"115":{"tf":1.4142135623730951},"117":{"tf":1.7320508075688772},"121":{"tf":1.0},"122":{"tf":1.4142135623730951},"123":{"tf":1.0},"124":{"tf":1.0},"126":{"tf":1.0},"128":{"tf":1.0},"13":{"tf":1.0},"130":{"tf":1.4142135623730951},"131":{"tf":1.7320508075688772},"132":{"tf":2.0},"138":{"tf":2.8284271247461903},"14":{"tf":1.0},"143":{"tf":1.0},"145":{"tf":1.0},"150":{"tf":1.4142135623730951},"155":{"tf":1.0},"158":{"tf":1.4142135623730951},"159":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":1.0},"175":{"tf":1.0},"179":{"tf":1.0},"180":{"tf":1.0},"183":{"tf":1.4142135623730951},"185":{"tf":1.7320508075688772},"187":{"tf":1.0},"192":{"tf":1.0},"2":{"tf":1.0},"200":{"tf":1.0},"203":{"tf":1.0},"205":{"tf":1.0},"207":{"tf":1.0},"209":{"tf":1.0},"216":{"tf":1.7320508075688772},"217":{"tf":1.0},"220":{"tf":1.0},"225":{"tf":1.0},"231":{"tf":1.4142135623730951},"233":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"43":{"tf":1.7320508075688772},"44":{"tf":1.4142135623730951},"46":{"tf":1.7320508075688772},"47":{"tf":1.4142135623730951},"49":{"tf":1.7320508075688772},"50":{"tf":1.4142135623730951},"51":{"tf":1.0},"52":{"tf":2.23606797749979},"53":{"tf":1.0},"55":{"tf":3.0},"56":{"tf":1.4142135623730951},"59":{"tf":1.7320508075688772},"60":{"tf":1.4142135623730951},"61":{"tf":2.0},"62":{"tf":1.4142135623730951},"63":{"tf":1.7320508075688772},"64":{"tf":1.4142135623730951},"66":{"tf":1.7320508075688772},"68":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"76":{"tf":1.7320508075688772},"77":{"tf":1.4142135623730951},"79":{"tf":1.7320508075688772},"8":{"tf":1.0},"80":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951},"88":{"tf":1.7320508075688772},"89":{"tf":1.0},"90":{"tf":1.4142135623730951},"91":{"tf":1.4142135623730951},"92":{"tf":1.0},"93":{"tf":1.4142135623730951},"94":{"tf":1.4142135623730951},"95":{"tf":1.0},"96":{"tf":1.4142135623730951},"97":{"tf":1.4142135623730951},"99":{"tf":1.4142135623730951}},"e":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"200":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"g":{"c":{"d":{".":{"c":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"101":{"tf":1.0},"46":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{".":{"c":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{".":{"c":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{}},"1":{".":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"59":{"tf":1.0},"83":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"2":{".":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"59":{"tf":1.0},"83":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{".":{"c":{"df":1,"docs":{"76":{"tf":1.0}}},"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"132":{"tf":1.4142135623730951},"142":{"tf":1.0}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{".":{"c":{"df":1,"docs":{"88":{"tf":1.0}}},"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"c":{"df":1,"docs":{"79":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"c":{"df":0,"docs":{},"e":{"df":3,"docs":{"28":{"tf":1.0},"29":{"tf":1.0},"33":{"tf":1.0}},"e":{"d":{"df":4,"docs":{"20":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"34":{"tf":1.0}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"t":{"df":5,"docs":{"137":{"tf":1.0},"14":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.0},"163":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"152":{"tf":1.0}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":2,"docs":{"131":{"tf":1.4142135623730951},"180":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":61,"docs":{"1":{"tf":1.7320508075688772},"103":{"tf":1.0},"106":{"tf":1.0},"111":{"tf":1.4142135623730951},"112":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"117":{"tf":1.4142135623730951},"121":{"tf":1.7320508075688772},"122":{"tf":2.449489742783178},"126":{"tf":1.0},"128":{"tf":1.4142135623730951},"13":{"tf":1.0},"130":{"tf":2.6457513110645907},"131":{"tf":2.6457513110645907},"137":{"tf":1.0},"138":{"tf":1.0},"140":{"tf":1.0},"143":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.0},"147":{"tf":1.0},"150":{"tf":2.23606797749979},"151":{"tf":1.0},"159":{"tf":1.7320508075688772},"160":{"tf":1.0},"163":{"tf":2.0},"166":{"tf":1.0},"173":{"tf":1.4142135623730951},"175":{"tf":1.0},"178":{"tf":1.0},"179":{"tf":1.0},"180":{"tf":1.4142135623730951},"181":{"tf":1.4142135623730951},"185":{"tf":1.0},"187":{"tf":1.4142135623730951},"190":{"tf":1.4142135623730951},"191":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"218":{"tf":1.0},"24":{"tf":1.0},"3":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":2.0},"40":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"6":{"tf":1.0},"61":{"tf":1.7320508075688772},"63":{"tf":1.0},"66":{"tf":1.0},"7":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"9":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"209":{"tf":1.7320508075688772}}}}},"r":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":5,"docs":{"134":{"tf":1.0},"137":{"tf":1.0},"138":{"tf":1.0},"216":{"tf":1.0},"217":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"h":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":5,"docs":{"137":{"tf":1.0},"151":{"tf":1.0},"157":{"tf":1.0},"158":{"tf":1.0},"191":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"194":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":14,"docs":{"132":{"tf":1.0},"136":{"tf":1.0},"138":{"tf":1.4142135623730951},"15":{"tf":1.0},"166":{"tf":1.0},"183":{"tf":1.4142135623730951},"184":{"tf":1.0},"185":{"tf":1.0},"195":{"tf":1.0},"199":{"tf":1.0},"206":{"tf":1.0},"208":{"tf":1.0},"212":{"tf":1.0},"225":{"tf":1.0}}}},"t":{"(":{"1":{"df":7,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":2.0},"79":{"tf":1.7320508075688772},"83":{"tf":1.7320508075688772},"85":{"tf":1.0},"88":{"tf":1.0}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"\"":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"79":{"tf":1.0}}}}}}},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":7,"docs":{"70":{"tf":2.0},"73":{"tf":2.0},"76":{"tf":3.0},"79":{"tf":2.23606797749979},"83":{"tf":3.0},"85":{"tf":1.7320508075688772},"88":{"tf":2.0}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":7,"docs":{"70":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"85":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":4,"docs":{"13":{"tf":1.0},"163":{"tf":1.0},"193":{"tf":1.0},"194":{"tf":1.7320508075688772}}}},"p":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"191":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":2,"docs":{"137":{"tf":1.0},"138":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"`":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"w":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"63":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":19,"docs":{"117":{"tf":1.0},"120":{"tf":1.0},"134":{"tf":1.0},"138":{"tf":2.6457513110645907},"153":{"tf":1.0},"158":{"tf":1.0},"180":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.4142135623730951},"191":{"tf":1.4142135623730951},"194":{"tf":1.0},"206":{"tf":1.0},"219":{"tf":1.0},"220":{"tf":1.7320508075688772},"221":{"tf":1.7320508075688772},"224":{"tf":1.4142135623730951},"226":{"tf":1.0},"232":{"tf":1.0},"76":{"tf":3.1622776601683795}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"110":{"tf":1.0},"155":{"tf":1.0},"230":{"tf":1.4142135623730951},"231":{"tf":1.0}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"138":{"tf":1.4142135623730951},"54":{"tf":1.0},"8":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"138":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"24":{"tf":1.4142135623730951},"34":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"108":{"tf":1.0},"156":{"tf":1.0},"212":{"tf":1.0}}}},"n":{"df":2,"docs":{"137":{"tf":1.0},"212":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"145":{"tf":1.0},"163":{"tf":1.0},"231":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"144":{"tf":1.0},"208":{"tf":1.0}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"147":{"tf":1.0}}}},"r":{"df":2,"docs":{"114":{"tf":1.0},"115":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{".":{".":{".":{"\\":{"df":0,"docs":{},"n":{"df":2,"docs":{"70":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":44,"docs":{"100":{"tf":1.0},"103":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"130":{"tf":5.744562646538029},"144":{"tf":1.0},"160":{"tf":1.7320508075688772},"162":{"tf":1.4142135623730951},"167":{"tf":1.0},"194":{"tf":1.7320508075688772},"38":{"tf":1.4142135623730951},"39":{"tf":2.0},"40":{"tf":1.4142135623730951},"42":{"tf":1.0},"43":{"tf":1.4142135623730951},"45":{"tf":1.0},"46":{"tf":1.4142135623730951},"48":{"tf":2.0},"49":{"tf":1.4142135623730951},"57":{"tf":1.0},"58":{"tf":2.0},"61":{"tf":1.0},"63":{"tf":1.4142135623730951},"64":{"tf":1.0},"65":{"tf":1.4142135623730951},"66":{"tf":2.0},"69":{"tf":1.0},"7":{"tf":1.4142135623730951},"70":{"tf":1.7320508075688772},"72":{"tf":1.0},"73":{"tf":1.4142135623730951},"75":{"tf":2.0},"76":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951},"81":{"tf":1.0},"82":{"tf":2.0},"83":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951},"90":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951},"96":{"tf":1.4142135623730951},"99":{"tf":1.0}},"s":{".":{".":{".":{"\\":{"df":0,"docs":{},"n":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"df":2,"docs":{"216":{"tf":2.0},"217":{"tf":1.7320508075688772}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"230":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"137":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":10,"docs":{"0":{"tf":1.4142135623730951},"103":{"tf":1.0},"106":{"tf":1.0},"131":{"tf":1.0},"137":{"tf":1.0},"145":{"tf":1.0},"189":{"tf":1.0},"216":{"tf":1.0},"218":{"tf":1.0},"221":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":8,"docs":{"111":{"tf":1.4142135623730951},"132":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"53":{"tf":1.7320508075688772},"62":{"tf":1.0},"63":{"tf":1.0},"88":{"tf":1.0}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":3,"docs":{"158":{"tf":1.4142135623730951},"165":{"tf":2.23606797749979},"166":{"tf":2.6457513110645907}}}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":5,"docs":{"43":{"tf":1.0},"66":{"tf":1.0},"76":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}}},"df":2,"docs":{"114":{"tf":1.0},"115":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"113":{"tf":1.0}}}}}}}},"f":{"3":{"2":{"df":1,"docs":{"194":{"tf":1.0}}},"df":0,"docs":{}},"6":{"4":{"df":1,"docs":{"194":{"tf":1.0}}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"e":{"df":3,"docs":{"145":{"tf":1.0},"211":{"tf":1.0},"234":{"tf":1.0}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"183":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"209":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":11,"docs":{"111":{"tf":1.7320508075688772},"128":{"tf":1.4142135623730951},"132":{"tf":1.0},"153":{"tf":1.0},"162":{"tf":1.4142135623730951},"180":{"tf":1.0},"187":{"tf":1.0},"203":{"tf":1.0},"206":{"tf":1.0},"226":{"tf":1.0},"7":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":5,"docs":{"111":{"tf":1.0},"151":{"tf":1.0},"190":{"tf":2.0},"194":{"tf":1.0},"206":{"tf":1.0}}}}},"r":{"df":2,"docs":{"221":{"tf":1.0},"232":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"163":{"tf":1.0},"211":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"234":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"138":{"tf":1.0}}},"s":{"df":4,"docs":{"142":{"tf":1.0},"15":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"122":{"tf":1.0},"139":{"tf":1.0},"155":{"tf":1.4142135623730951}}}},"df":1,"docs":{"139":{"tf":1.0}}}}}},"r":{"df":2,"docs":{"137":{"tf":1.0},"226":{"tf":1.0}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"158":{"tf":1.0},"220":{"tf":1.0},"221":{"tf":1.0}}}}}},"t":{"df":3,"docs":{"0":{"tf":1.0},"158":{"tf":1.0},"217":{"tf":1.0}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"148":{"tf":1.0},"24":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":7,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"d":{"=":{"df":0,"docs":{},"f":{"d":{"(":{"1":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"58":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951}}}}},"df":2,"docs":{"58":{"tf":2.0},"82":{"tf":2.0}}}}}}}},"df":2,"docs":{"58":{"tf":1.0},"82":{"tf":1.0}}},"df":2,"docs":{"65":{"tf":1.7320508075688772},"87":{"tf":1.7320508075688772}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":32,"docs":{"0":{"tf":1.0},"115":{"tf":1.0},"118":{"tf":1.4142135623730951},"119":{"tf":1.0},"122":{"tf":1.0},"128":{"tf":1.4142135623730951},"129":{"tf":1.0},"130":{"tf":5.656854249492381},"131":{"tf":1.7320508075688772},"132":{"tf":2.0},"136":{"tf":2.0},"137":{"tf":2.8284271247461903},"138":{"tf":6.0},"142":{"tf":2.0},"143":{"tf":1.0},"144":{"tf":1.0},"150":{"tf":1.0},"157":{"tf":1.0},"180":{"tf":1.0},"190":{"tf":1.0},"193":{"tf":1.0},"205":{"tf":1.4142135623730951},"207":{"tf":1.4142135623730951},"208":{"tf":1.0},"210":{"tf":1.0},"211":{"tf":1.4142135623730951},"212":{"tf":1.0},"218":{"tf":1.4142135623730951},"39":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"70":{"tf":1.0}}}}}},"d":{"df":1,"docs":{"130":{"tf":1.0}}},"df":0,"docs":{},"e":{"d":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"134":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":14,"docs":{"117":{"tf":1.0},"131":{"tf":1.0},"153":{"tf":1.4142135623730951},"154":{"tf":1.0},"183":{"tf":1.4142135623730951},"184":{"tf":1.0},"185":{"tf":1.0},"191":{"tf":1.0},"203":{"tf":1.0},"204":{"tf":1.0},"222":{"tf":1.0},"91":{"tf":1.0},"94":{"tf":1.0},"97":{"tf":1.0}}}},"w":{"df":18,"docs":{"114":{"tf":1.0},"115":{"tf":1.0},"126":{"tf":1.0},"134":{"tf":1.0},"148":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.7320508075688772},"163":{"tf":1.0},"178":{"tf":1.0},"200":{"tf":1.0},"201":{"tf":1.0},"203":{"tf":1.0},"206":{"tf":1.0},"208":{"tf":1.0},"221":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"5":{"tf":1.0}}}},"i":{"b":{"(":{"4":{"2":{"df":1,"docs":{"117":{"tf":1.0}}},"5":{"df":1,"docs":{"122":{"tf":1.0}}},"df":0,"docs":{}},"6":{"df":1,"docs":{"85":{"tf":1.0}}},"df":0,"docs":{},"n":{"df":2,"docs":{"117":{"tf":2.0},"122":{"tf":2.0}}}},".":{".":{".":{"\\":{"df":0,"docs":{},"n":{"df":1,"docs":{"85":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"85":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"r":{"df":2,"docs":{"117":{"tf":1.0},"122":{"tf":1.4142135623730951}}},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":2,"docs":{"117":{"tf":1.0},"122":{"tf":1.0}}}}},"df":0,"docs":{}}},":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"117":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":3,"docs":{"117":{"tf":1.4142135623730951},"61":{"tf":2.23606797749979},"85":{"tf":2.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"167":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":7,"docs":{"15":{"tf":1.0},"158":{"tf":1.4142135623730951},"162":{"tf":1.7320508075688772},"165":{"tf":1.4142135623730951},"205":{"tf":1.0},"58":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"137":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"e":{"!":{"\\":{"df":0,"docs":{},"n":{"df":5,"docs":{"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}},".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"!":{"(":{"\"":{"df":0,"docs":{},"g":{"c":{"d":{".":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"106":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"_":{"df":0,"docs":{},"s":{"df":7,"docs":{"70":{"tf":1.7320508075688772},"73":{"tf":1.7320508075688772},"76":{"tf":1.7320508075688772},"79":{"tf":1.7320508075688772},"83":{"tf":1.7320508075688772},"85":{"tf":1.7320508075688772},"88":{"tf":1.7320508075688772}}}},"df":59,"docs":{"0":{"tf":1.7320508075688772},"1":{"tf":1.0},"10":{"tf":1.4142135623730951},"106":{"tf":1.0},"11":{"tf":1.0},"114":{"tf":2.6457513110645907},"115":{"tf":3.1622776601683795},"126":{"tf":1.7320508075688772},"127":{"tf":1.0},"13":{"tf":2.0},"130":{"tf":2.23606797749979},"14":{"tf":1.7320508075688772},"142":{"tf":1.4142135623730951},"146":{"tf":1.0},"147":{"tf":1.0},"15":{"tf":1.0},"150":{"tf":1.0},"151":{"tf":1.7320508075688772},"158":{"tf":1.0},"163":{"tf":1.0},"18":{"tf":1.0},"183":{"tf":1.0},"184":{"tf":1.0},"185":{"tf":1.4142135623730951},"187":{"tf":1.0},"19":{"tf":1.0},"190":{"tf":1.0},"191":{"tf":1.0},"199":{"tf":1.0},"20":{"tf":1.4142135623730951},"203":{"tf":1.0},"206":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.7320508075688772},"221":{"tf":1.0},"227":{"tf":1.7320508075688772},"23":{"tf":1.0},"25":{"tf":2.449489742783178},"26":{"tf":1.7320508075688772},"27":{"tf":2.0},"28":{"tf":2.6457513110645907},"29":{"tf":2.6457513110645907},"33":{"tf":2.0},"34":{"tf":3.3166247903554},"35":{"tf":1.7320508075688772},"38":{"tf":1.4142135623730951},"39":{"tf":1.7320508075688772},"5":{"tf":1.0},"61":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":2.449489742783178},"73":{"tf":2.23606797749979},"76":{"tf":2.23606797749979},"79":{"tf":2.23606797749979},"83":{"tf":2.449489742783178},"85":{"tf":2.0},"88":{"tf":2.23606797749979},"9":{"tf":1.4142135623730951},"96":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":4,"docs":{"116":{"tf":1.0},"130":{"tf":1.0},"83":{"tf":1.0},"90":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":7,"docs":{"0":{"tf":1.0},"137":{"tf":1.0},"146":{"tf":1.4142135623730951},"159":{"tf":1.0},"167":{"tf":1.0},"34":{"tf":1.0},"55":{"tf":1.0}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"178":{"tf":1.0}}}}}}},"l":{"df":1,"docs":{"43":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"13":{"tf":1.0},"147":{"tf":1.0},"180":{"tf":1.0}}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":11,"docs":{"130":{"tf":1.4142135623730951},"131":{"tf":1.7320508075688772},"153":{"tf":1.0},"159":{"tf":1.0},"162":{"tf":1.4142135623730951},"163":{"tf":1.0},"189":{"tf":1.0},"199":{"tf":1.0},"39":{"tf":1.0},"59":{"tf":1.0},"96":{"tf":1.0}}}},"d":{"df":13,"docs":{"0":{"tf":1.0},"154":{"tf":1.0},"155":{"tf":1.0},"156":{"tf":1.0},"195":{"tf":1.0},"202":{"tf":1.0},"204":{"tf":1.0},"220":{"tf":1.0},"222":{"tf":1.0},"49":{"tf":1.0},"91":{"tf":1.0},"94":{"tf":1.0},"97":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":4,"docs":{"0":{"tf":1.0},"188":{"tf":1.0},"194":{"tf":1.0},"221":{"tf":1.0}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":5,"docs":{"138":{"tf":1.0},"145":{"tf":1.0},"162":{"tf":1.0},"226":{"tf":1.0},"39":{"tf":1.0}},"e":{"d":{"!":{"\\":{"df":0,"docs":{},"n":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":1,"docs":{"126":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":33,"docs":{"103":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"111":{"tf":1.0},"115":{"tf":1.0},"117":{"tf":1.0},"121":{"tf":1.0},"130":{"tf":1.4142135623730951},"140":{"tf":1.0},"147":{"tf":1.0},"152":{"tf":1.0},"154":{"tf":1.0},"157":{"tf":1.4142135623730951},"158":{"tf":1.0},"159":{"tf":1.0},"162":{"tf":1.0},"164":{"tf":1.0},"169":{"tf":1.0},"194":{"tf":1.4142135623730951},"196":{"tf":1.0},"209":{"tf":1.0},"224":{"tf":1.0},"225":{"tf":1.0},"39":{"tf":1.4142135623730951},"40":{"tf":1.0},"43":{"tf":1.0},"58":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"63":{"tf":1.0},"82":{"tf":1.4142135623730951},"90":{"tf":1.4142135623730951},"93":{"tf":1.0},"96":{"tf":1.4142135623730951},"99":{"tf":1.0}}}}},"t":{"df":2,"docs":{"129":{"tf":1.0},"154":{"tf":1.0}}},"x":{"df":12,"docs":{"134":{"tf":1.0},"138":{"tf":1.0},"151":{"tf":1.0},"190":{"tf":1.4142135623730951},"203":{"tf":1.0},"204":{"tf":1.0},"208":{"tf":1.0},"211":{"tf":1.0},"212":{"tf":1.0},"213":{"tf":1.0},"225":{"tf":1.4142135623730951},"226":{"tf":2.6457513110645907}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":16,"docs":{"114":{"tf":1.0},"115":{"tf":1.4142135623730951},"116":{"tf":1.0},"118":{"tf":1.0},"119":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":1.0},"126":{"tf":1.0},"127":{"tf":1.0},"128":{"tf":1.4142135623730951},"130":{"tf":2.23606797749979},"175":{"tf":1.0},"179":{"tf":1.0},"190":{"tf":1.0},"200":{"tf":1.0},"216":{"tf":1.0}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"114":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"137":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{"df":1,"docs":{"140":{"tf":1.0}}},"o":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"137":{"tf":1.0}}}},"df":0,"docs":{},"w":{"df":4,"docs":{"124":{"tf":1.0},"145":{"tf":1.4142135623730951},"151":{"tf":1.0},"162":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"(":{"\"":{"df":0,"docs":{},"g":{"c":{"d":{"(":{"6":{"df":1,"docs":{"96":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":3,"docs":{"191":{"tf":1.0},"202":{"tf":1.0},"96":{"tf":1.0}}}},"n":{"df":19,"docs":{"111":{"tf":2.0},"117":{"tf":1.4142135623730951},"122":{"tf":1.4142135623730951},"183":{"tf":1.0},"185":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"59":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"66":{"tf":1.0},"78":{"tf":1.0}}},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":4,"docs":{"0":{"tf":1.0},"111":{"tf":1.0},"213":{"tf":1.4142135623730951},"231":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"167":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"178":{"tf":1.4142135623730951},"191":{"tf":1.0},"206":{"tf":1.0},"207":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":22,"docs":{"109":{"tf":1.0},"110":{"tf":1.4142135623730951},"111":{"tf":1.4142135623730951},"112":{"tf":1.0},"122":{"tf":1.0},"134":{"tf":1.0},"137":{"tf":1.0},"146":{"tf":1.0},"177":{"tf":1.0},"2":{"tf":1.0},"201":{"tf":1.0},"212":{"tf":1.0},"216":{"tf":1.0},"218":{"tf":1.0},"220":{"tf":1.0},"221":{"tf":1.0},"234":{"tf":1.0},"3":{"tf":1.0},"33":{"tf":1.0},"39":{"tf":1.0},"6":{"tf":1.0},"93":{"tf":1.0}}}}}},"o":{"(":{"4":{"2":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"x":{"df":1,"docs":{"111":{"tf":1.0}}}},".":{"c":{"df":1,"docs":{"110":{"tf":1.0}},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":9,"docs":{"1":{"tf":1.4142135623730951},"11":{"tf":1.0},"110":{"tf":1.7320508075688772},"114":{"tf":1.0},"115":{"tf":1.0},"121":{"tf":1.7320508075688772},"126":{"tf":1.0},"7":{"tf":1.7320508075688772},"8":{"tf":1.4142135623730951}}},"t":{"df":1,"docs":{"9":{"tf":1.0}}}},"t":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}},"df":2,"docs":{"110":{"tf":1.0},"216":{"tf":1.0}},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"129":{"tf":1.0},"131":{"tf":1.4142135623730951}}}}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"(":{"\"":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"g":{"c":{"d":{".":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"73":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{".":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"88":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"3":{"2":{"df":2,"docs":{"79":{"tf":1.0},"85":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"r":{"c":{"df":4,"docs":{"163":{"tf":1.0},"166":{"tf":1.0},"190":{"tf":1.0},"208":{"tf":1.4142135623730951}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"225":{"tf":1.0},"226":{"tf":1.0}}}}},"k":{"df":1,"docs":{"184":{"tf":1.0}}},"m":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"158":{"tf":1.0}}},"t":{"!":{"(":{"\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"53":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":24,"docs":{"0":{"tf":1.4142135623730951},"111":{"tf":1.0},"131":{"tf":1.7320508075688772},"14":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.0},"191":{"tf":1.7320508075688772},"20":{"tf":1.0},"202":{"tf":1.4142135623730951},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"39":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0},"9":{"tf":1.0}}}},"df":7,"docs":{"141":{"tf":1.0},"144":{"tf":1.0},"148":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.7320508075688772},"165":{"tf":1.0},"39":{"tf":1.0}}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"118":{"tf":1.0}}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"138":{"tf":1.0},"222":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"230":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":12,"docs":{"110":{"tf":1.0},"134":{"tf":1.4142135623730951},"138":{"tf":1.4142135623730951},"142":{"tf":1.0},"145":{"tf":1.0},"158":{"tf":1.0},"161":{"tf":1.0},"191":{"tf":1.0},"204":{"tf":1.0},"224":{"tf":1.0},"227":{"tf":1.0},"67":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":7,"docs":{"70":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"85":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"163":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"a":{"d":{"(":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{".":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"85":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{".":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"79":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{".":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":5,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"p":{"df":1,"docs":{"128":{"tf":1.0}}}},"b":{"df":0,"docs":{},"s":{"d":{"df":1,"docs":{"137":{"tf":1.0}}},"df":0,"docs":{}}},"df":19,"docs":{"118":{"tf":1.4142135623730951},"128":{"tf":1.4142135623730951},"131":{"tf":1.0},"138":{"tf":1.0},"150":{"tf":1.4142135623730951},"151":{"tf":1.0},"153":{"tf":1.4142135623730951},"154":{"tf":1.0},"183":{"tf":1.0},"184":{"tf":1.0},"185":{"tf":1.0},"191":{"tf":1.0},"203":{"tf":1.0},"204":{"tf":1.0},"222":{"tf":1.0},"230":{"tf":1.0},"91":{"tf":1.0},"94":{"tf":1.0},"97":{"tf":1.0}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"134":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"34":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"165":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"164":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"k":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":7,"docs":{"70":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"85":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":7,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"150":{"tf":1.0}}}},"l":{"df":0,"docs":{},"l":{"df":11,"docs":{"137":{"tf":2.6457513110645907},"155":{"tf":1.0},"17":{"tf":1.0},"190":{"tf":2.0},"192":{"tf":1.4142135623730951},"205":{"tf":1.0},"222":{"tf":1.0},"3":{"tf":1.0},"31":{"tf":1.0},"37":{"tf":1.4142135623730951},"67":{"tf":1.0}},"i":{"df":3,"docs":{"138":{"tf":1.0},"191":{"tf":1.0},"217":{"tf":1.0}}}}},"n":{"c":{".":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"_":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},":":{":":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"66":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"66":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"43":{"tf":1.0},"66":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":1,"docs":{"66":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":26,"docs":{"100":{"tf":1.4142135623730951},"103":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"194":{"tf":2.0},"38":{"tf":1.0},"39":{"tf":1.4142135623730951},"40":{"tf":2.6457513110645907},"42":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"48":{"tf":1.7320508075688772},"55":{"tf":1.0},"57":{"tf":1.7320508075688772},"58":{"tf":2.0},"63":{"tf":2.0},"65":{"tf":1.7320508075688772},"69":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951},"75":{"tf":1.7320508075688772},"76":{"tf":4.242640687119285},"79":{"tf":1.7320508075688772},"81":{"tf":1.7320508075688772},"82":{"tf":2.0},"87":{"tf":1.7320508075688772},"90":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951},"96":{"tf":2.0}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":2,"docs":{"160":{"tf":1.0},"165":{"tf":1.7320508075688772}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"161":{"tf":1.0}}},"=":{"\"":{"df":0,"docs":{},"f":{"d":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":61,"docs":{"1":{"tf":1.7320508075688772},"101":{"tf":1.0},"103":{"tf":1.0},"106":{"tf":1.0},"114":{"tf":2.0},"115":{"tf":2.23606797749979},"116":{"tf":1.0},"117":{"tf":1.4142135623730951},"122":{"tf":1.0},"128":{"tf":1.0},"130":{"tf":2.0},"131":{"tf":1.0},"132":{"tf":1.0},"137":{"tf":1.0},"142":{"tf":1.0},"143":{"tf":1.0},"144":{"tf":1.4142135623730951},"145":{"tf":1.0},"148":{"tf":1.0},"157":{"tf":1.7320508075688772},"158":{"tf":2.449489742783178},"159":{"tf":3.3166247903554},"160":{"tf":2.23606797749979},"161":{"tf":1.7320508075688772},"162":{"tf":2.0},"163":{"tf":1.0},"164":{"tf":1.0},"167":{"tf":1.4142135623730951},"180":{"tf":1.4142135623730951},"181":{"tf":1.0},"185":{"tf":1.0},"194":{"tf":1.4142135623730951},"206":{"tf":1.0},"216":{"tf":2.0},"217":{"tf":2.23606797749979},"218":{"tf":2.0},"222":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":2.6457513110645907},"40":{"tf":3.3166247903554},"43":{"tf":2.8284271247461903},"46":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.4142135623730951},"6":{"tf":1.0},"63":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"70":{"tf":2.8284271247461903},"73":{"tf":1.4142135623730951},"76":{"tf":2.0},"79":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":2.0},"90":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0},"99":{"tf":1.0}}}}}}},"df":1,"docs":{"220":{"tf":1.0}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":11,"docs":{"108":{"tf":1.0},"130":{"tf":1.7320508075688772},"131":{"tf":1.0},"138":{"tf":1.0},"145":{"tf":1.0},"159":{"tf":1.0},"213":{"tf":1.0},"225":{"tf":1.0},"233":{"tf":1.0},"234":{"tf":1.0},"43":{"tf":1.0}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"165":{"tf":1.0},"8":{"tf":1.0}}}}}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":16,"docs":{"120":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.0},"14":{"tf":1.0},"146":{"tf":1.0},"148":{"tf":1.0},"208":{"tf":1.7320508075688772},"21":{"tf":1.0},"22":{"tf":1.0},"220":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.4142135623730951},"54":{"tf":1.0}}}}},"z":{"df":0,"docs":{},"z":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"188":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":11,"docs":{"137":{"tf":2.0},"138":{"tf":2.6457513110645907},"172":{"tf":1.4142135623730951},"186":{"tf":1.0},"187":{"tf":1.4142135623730951},"188":{"tf":2.6457513110645907},"191":{"tf":2.23606797749979},"216":{"tf":2.0},"217":{"tf":1.7320508075688772},"221":{"tf":1.4142135623730951},"224":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"187":{"tf":1.4142135623730951},"188":{"tf":1.4142135623730951},"191":{"tf":1.4142135623730951},"217":{"tf":1.0}}}},"i":{"df":1,"docs":{"194":{"tf":1.0}}}}}}},"g":{".":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"155":{"tf":1.0}}}},"r":{"b":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"158":{"tf":1.0},"165":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"204":{"tf":1.0}}}}},"c":{"c":{"df":2,"docs":{"197":{"tf":2.23606797749979},"199":{"tf":2.0}}},"d":{"\"":{")":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"96":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"(":{"$":{"1":{"df":1,"docs":{"101":{"tf":1.0}}},"df":0,"docs":{}},"2":{"7":{"df":3,"docs":{"103":{"tf":1.4142135623730951},"90":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}},"6":{"df":1,"docs":{"96":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"90":{"tf":1.0}}}}}}}},".":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"96":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{},"g":{"c":{"d":{"(":{"2":{"7":{"df":1,"docs":{"90":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"r":{"df":1,"docs":{"46":{"tf":1.0}}},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"101":{"tf":1.0},"99":{"tf":1.0}}}},"w":{"a":{"df":0,"docs":{},"t":{"df":8,"docs":{"100":{"tf":1.0},"103":{"tf":1.0},"45":{"tf":1.0},"72":{"tf":1.0},"90":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951},"96":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{}}},"df":14,"docs":{"100":{"tf":2.0},"101":{"tf":2.0},"103":{"tf":2.0},"106":{"tf":2.23606797749979},"44":{"tf":1.4142135623730951},"45":{"tf":1.7320508075688772},"46":{"tf":2.0},"71":{"tf":1.4142135623730951},"72":{"tf":1.7320508075688772},"73":{"tf":2.8284271247461903},"90":{"tf":2.23606797749979},"93":{"tf":2.23606797749979},"96":{"tf":2.0},"99":{"tf":1.4142135623730951}}},"df":6,"docs":{"137":{"tf":1.0},"142":{"tf":1.0},"158":{"tf":1.0},"166":{"tf":1.4142135623730951},"216":{"tf":1.0},"217":{"tf":1.0}}},"d":{"b":{"df":5,"docs":{"109":{"tf":1.0},"110":{"tf":1.7320508075688772},"60":{"tf":1.0},"61":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{}},"df":11,"docs":{"110":{"tf":1.4142135623730951},"116":{"tf":1.0},"17":{"tf":1.0},"20":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"63":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"66":{"tf":2.0},"87":{"tf":1.4142135623730951},"88":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"df":2,"docs":{"102":{"tf":1.0},"103":{"tf":2.449489742783178}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"103":{"tf":1.0}}}}}},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"230":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":35,"docs":{"0":{"tf":1.0},"109":{"tf":1.0},"111":{"tf":2.0},"113":{"tf":1.0},"114":{"tf":1.7320508075688772},"115":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.0},"126":{"tf":1.0},"130":{"tf":1.7320508075688772},"137":{"tf":1.4142135623730951},"138":{"tf":2.23606797749979},"142":{"tf":1.0},"159":{"tf":1.0},"160":{"tf":1.0},"163":{"tf":2.449489742783178},"164":{"tf":1.7320508075688772},"167":{"tf":1.0},"178":{"tf":1.0},"180":{"tf":1.0},"187":{"tf":2.23606797749979},"188":{"tf":1.7320508075688772},"191":{"tf":1.4142135623730951},"205":{"tf":1.0},"206":{"tf":1.0},"216":{"tf":1.4142135623730951},"222":{"tf":1.4142135623730951},"224":{"tf":1.0},"225":{"tf":1.4142135623730951},"41":{"tf":1.0},"51":{"tf":1.0},"6":{"tf":1.0},"61":{"tf":1.0},"85":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"106":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"222":{"tf":1.0}}}}},"t":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"52":{"tf":1.0},"55":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"66":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":10,"docs":{"103":{"tf":1.0},"106":{"tf":1.0},"121":{"tf":1.0},"130":{"tf":1.0},"134":{"tf":1.0},"227":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0},"99":{"tf":1.0}}}},"i":{"df":1,"docs":{"27":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"159":{"tf":1.0},"164":{"tf":1.0}}}},"t":{"df":6,"docs":{"170":{"tf":1.7320508075688772},"180":{"tf":1.4142135623730951},"184":{"tf":1.0},"213":{"tf":1.0},"221":{"tf":1.0},"224":{"tf":1.0}},"h":{"df":0,"docs":{},"u":{"b":{"'":{"df":2,"docs":{"190":{"tf":1.0},"221":{"tf":1.0}}},".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"96":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"/":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"224":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"224":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"224":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}}}},"df":9,"docs":{"0":{"tf":1.0},"104":{"tf":1.0},"107":{"tf":1.0},"189":{"tf":1.4142135623730951},"192":{"tf":1.0},"220":{"tf":1.0},"224":{"tf":1.0},"226":{"tf":1.4142135623730951},"3":{"tf":1.0}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":8,"docs":{"116":{"tf":1.4142135623730951},"134":{"tf":1.0},"139":{"tf":1.0},"156":{"tf":1.0},"164":{"tf":1.0},"224":{"tf":1.0},"39":{"tf":1.0},"70":{"tf":1.0}},"n":{"df":7,"docs":{"12":{"tf":1.0},"128":{"tf":1.0},"146":{"tf":1.0},"151":{"tf":1.0},"193":{"tf":1.4142135623730951},"194":{"tf":1.4142135623730951},"203":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"i":{"b":{"c":{"df":1,"docs":{"192":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"b":{"a":{"df":0,"docs":{},"l":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"=":{"1":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":2,"docs":{"57":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"160":{"tf":1.0}}}},"df":0,"docs":{}}}}},"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":2,"docs":{"162":{"tf":1.0},"163":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":11,"docs":{"111":{"tf":1.0},"137":{"tf":1.0},"158":{"tf":2.449489742783178},"39":{"tf":1.4142135623730951},"43":{"tf":1.0},"52":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"63":{"tf":2.0},"81":{"tf":1.0},"82":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"188":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"u":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"199":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"df":6,"docs":{"137":{"tf":2.23606797749979},"138":{"tf":1.0},"196":{"tf":1.7320508075688772},"197":{"tf":1.7320508075688772},"199":{"tf":3.0},"200":{"tf":1.7320508075688772}}}},"o":{"a":{"df":0,"docs":{},"l":{"df":12,"docs":{"112":{"tf":1.0},"138":{"tf":1.0},"143":{"tf":1.0},"152":{"tf":1.0},"154":{"tf":1.0},"157":{"tf":1.0},"158":{"tf":1.0},"167":{"tf":1.0},"209":{"tf":1.0},"220":{"tf":1.0},"221":{"tf":1.0},"8":{"tf":1.0}}}},"df":26,"docs":{"102":{"tf":1.0},"105":{"tf":1.0},"130":{"tf":1.4142135623730951},"134":{"tf":1.4142135623730951},"135":{"tf":1.0},"145":{"tf":1.0},"158":{"tf":1.0},"163":{"tf":1.4142135623730951},"164":{"tf":1.0},"173":{"tf":1.0},"185":{"tf":1.0},"190":{"tf":1.0},"209":{"tf":1.0},"216":{"tf":1.0},"220":{"tf":1.0},"222":{"tf":1.0},"36":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"49":{"tf":1.0},"59":{"tf":1.0},"89":{"tf":1.0},"92":{"tf":1.0},"95":{"tf":2.0},"96":{"tf":2.449489742783178},"97":{"tf":1.0}},"e":{"df":7,"docs":{"131":{"tf":1.0},"148":{"tf":1.0},"150":{"tf":1.0},"165":{"tf":1.0},"220":{"tf":1.0},"224":{"tf":1.0},"226":{"tf":1.0}}},"o":{"d":{"df":9,"docs":{"154":{"tf":1.7320508075688772},"155":{"tf":1.7320508075688772},"158":{"tf":1.0},"164":{"tf":1.0},"178":{"tf":1.0},"212":{"tf":1.0},"220":{"tf":1.0},"222":{"tf":1.0},"234":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"228":{"tf":1.0}}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"231":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"0":{"tf":1.0},"221":{"tf":1.4142135623730951}}}},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"158":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"221":{"tf":1.0}}}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"154":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"217":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":7,"docs":{"103":{"tf":1.0},"106":{"tf":1.0},"3":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0},"99":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"209":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"190":{"tf":1.7320508075688772},"224":{"tf":1.0}}}},"p":{"df":2,"docs":{"193":{"tf":1.0},"194":{"tf":2.0}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"158":{"tf":1.0},"164":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"70":{"tf":1.0}}}},"w":{"df":3,"docs":{"148":{"tf":1.0},"49":{"tf":1.0},"76":{"tf":1.7320508075688772}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"164":{"tf":1.4142135623730951}}}}}},"p":{"c":{"df":1,"docs":{"137":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":7,"docs":{"134":{"tf":1.0},"138":{"tf":1.4142135623730951},"142":{"tf":1.0},"145":{"tf":1.7320508075688772},"158":{"tf":1.0},"203":{"tf":1.0},"220":{"tf":1.0}}}}}},"d":{"_":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"164":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"145":{"tf":2.0},"164":{"tf":3.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"150":{"tf":1.0}}},"df":8,"docs":{"109":{"tf":1.4142135623730951},"110":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.4142135623730951},"127":{"tf":1.4142135623730951},"150":{"tf":2.0},"62":{"tf":1.0},"63":{"tf":1.0}}}}},"i":{"d":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"138":{"tf":1.0}}},"df":0,"docs":{}}},"df":12,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"102":{"tf":1.0},"105":{"tf":1.0},"129":{"tf":1.0},"138":{"tf":1.0},"152":{"tf":1.0},"195":{"tf":1.0},"225":{"tf":1.0},"89":{"tf":1.0},"92":{"tf":1.0},"95":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":7,"docs":{"138":{"tf":1.0},"201":{"tf":1.0},"207":{"tf":1.0},"208":{"tf":1.0},"219":{"tf":1.0},"220":{"tf":1.0},"221":{"tf":1.0}}}}}}},"df":4,"docs":{"118":{"tf":1.0},"121":{"tf":1.0},"123":{"tf":1.7320508075688772},"124":{"tf":1.4142135623730951}}}}},"h":{"2":{"b":{"a":{"c":{"df":0,"docs":{},"f":{"5":{"3":{"c":{"b":{"3":{"8":{"4":{"5":{"a":{"c":{"df":0,"docs":{},"f":{"df":1,"docs":{"122":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"154":{"tf":1.0},"172":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"df":7,"docs":{"150":{"tf":1.0},"167":{"tf":1.0},"194":{"tf":1.0},"206":{"tf":1.0},"207":{"tf":1.0},"221":{"tf":1.4142135623730951},"38":{"tf":1.0}},"l":{"df":12,"docs":{"131":{"tf":1.0},"137":{"tf":1.0},"138":{"tf":2.0},"158":{"tf":1.0},"162":{"tf":1.7320508075688772},"163":{"tf":1.0},"164":{"tf":1.0},"206":{"tf":1.0},"31":{"tf":1.4142135623730951},"32":{"tf":1.0},"39":{"tf":1.0},"70":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"163":{"tf":1.7320508075688772}}}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"180":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":16,"docs":{"134":{"tf":1.0},"138":{"tf":1.0},"159":{"tf":1.7320508075688772},"161":{"tf":1.4142135623730951},"162":{"tf":1.0},"163":{"tf":2.0},"164":{"tf":1.4142135623730951},"167":{"tf":1.4142135623730951},"187":{"tf":1.0},"189":{"tf":1.0},"191":{"tf":1.0},"209":{"tf":1.4142135623730951},"224":{"tf":1.0},"226":{"tf":1.0},"24":{"tf":1.0},"40":{"tf":1.0}}}},"i":{"df":3,"docs":{"131":{"tf":1.0},"139":{"tf":1.0},"155":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"230":{"tf":1.0},"231":{"tf":1.0},"234":{"tf":1.0}}}}},"d":{"df":1,"docs":{"221":{"tf":1.0}},"w":{"a":{"df":0,"docs":{},"r":{"df":5,"docs":{"112":{"tf":1.0},"124":{"tf":1.0},"138":{"tf":1.0},"139":{"tf":1.0},"145":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"df":1,"docs":{"232":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":5,"docs":{"140":{"tf":1.0},"151":{"tf":1.0},"153":{"tf":1.0},"157":{"tf":1.4142135623730951},"220":{"tf":1.0}},"n":{"'":{"df":0,"docs":{},"t":{"df":4,"docs":{"131":{"tf":1.0},"194":{"tf":1.4142135623730951},"220":{"tf":1.0},"226":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":4,"docs":{"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"6":{"tf":1.4142135623730951}},"e":{"a":{"d":{"df":1,"docs":{"158":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"142":{"tf":1.0}}}}},"df":0,"docs":{},"p":{"df":1,"docs":{"110":{"tf":1.0}}},"r":{"d":{"df":1,"docs":{"138":{"tf":1.0}}},"df":2,"docs":{"131":{"tf":1.0},"153":{"tf":1.0}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"159":{"tf":1.0},"189":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{".":{"c":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":1,"docs":{"43":{"tf":1.0}}},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"13":{"tf":1.0}}}},"t":{"df":5,"docs":{"38":{"tf":1.0},"39":{"tf":1.4142135623730951},"40":{"tf":1.0},"42":{"tf":1.0},"69":{"tf":1.0}}}},"df":0,"docs":{}}},"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"(":{"df":0,"docs":{},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":1,"docs":{"70":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}}}},"df":15,"docs":{"13":{"tf":1.0},"207":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.7320508075688772},"43":{"tf":1.4142135623730951},"51":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.7320508075688772},"70":{"tf":2.6457513110645907},"8":{"tf":1.0},"81":{"tf":1.0},"96":{"tf":1.7320508075688772}}}},"p":{"df":17,"docs":{"110":{"tf":1.0},"138":{"tf":1.0},"14":{"tf":1.0},"140":{"tf":1.0},"145":{"tf":1.7320508075688772},"146":{"tf":1.0},"152":{"tf":1.4142135623730951},"154":{"tf":1.4142135623730951},"209":{"tf":1.0},"211":{"tf":1.0},"212":{"tf":1.0},"213":{"tf":1.0},"220":{"tf":1.4142135623730951},"221":{"tf":1.0},"225":{"tf":1.0},"30":{"tf":1.0},"6":{"tf":2.449489742783178}}}},"n":{"c":{"df":1,"docs":{"204":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"207":{"tf":1.0}}},"df":29,"docs":{"118":{"tf":1.0},"130":{"tf":2.23606797749979},"137":{"tf":1.0},"138":{"tf":1.0},"157":{"tf":1.0},"159":{"tf":1.0},"164":{"tf":1.0},"171":{"tf":1.0},"172":{"tf":1.0},"185":{"tf":1.0},"189":{"tf":1.0},"191":{"tf":1.0},"2":{"tf":1.0},"203":{"tf":1.0},"209":{"tf":1.0},"210":{"tf":1.0},"226":{"tf":1.0},"30":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":2.0},"49":{"tf":1.0},"55":{"tf":1.4142135623730951},"57":{"tf":1.0},"59":{"tf":1.0},"70":{"tf":2.23606797749979},"81":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":8,"docs":{"104":{"tf":1.0},"107":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"126":{"tf":1.0},"91":{"tf":1.0},"94":{"tf":1.0},"97":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"130":{"tf":1.0}}}}}}},"x":{"df":1,"docs":{"105":{"tf":1.0}}}},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"144":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":6,"docs":{"134":{"tf":1.0},"138":{"tf":1.0},"139":{"tf":1.0},"159":{"tf":1.0},"189":{"tf":1.0},"224":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"206":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"138":{"tf":1.4142135623730951}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"150":{"tf":1.0}}}}}}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"137":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"143":{"tf":1.0},"227":{"tf":1.0}},"i":{"df":1,"docs":{"208":{"tf":1.0}}}}}}},"t":{"df":3,"docs":{"130":{"tf":1.0},"145":{"tf":1.7320508075688772},"224":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"158":{"tf":2.6457513110645907},"159":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"e":{"/":{".":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"j":{"df":0,"docs":{},"l":{"b":{"6":{"7":{"4":{"0":{"/":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"r":{"0":{"0":{"0":{"df":0,"docs":{},"h":{"df":1,"docs":{"122":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"/":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"111":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{"1":{"4":{":":{"5":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"111":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"o":{"d":{"df":1,"docs":{"158":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":7,"docs":{"112":{"tf":1.0},"138":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.0},"167":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0}}}},"p":{"df":0,"docs":{},"e":{"df":2,"docs":{"147":{"tf":1.0},"153":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"150":{"tf":1.0}}},"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"93":{"tf":1.0}}}}}}}},".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"93":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":22,"docs":{"109":{"tf":1.0},"11":{"tf":1.0},"110":{"tf":1.0},"112":{"tf":1.0},"12":{"tf":1.4142135623730951},"130":{"tf":1.0},"131":{"tf":1.0},"140":{"tf":1.0},"143":{"tf":1.0},"145":{"tf":1.0},"150":{"tf":1.4142135623730951},"153":{"tf":1.0},"158":{"tf":1.7320508075688772},"160":{"tf":1.0},"163":{"tf":1.4142135623730951},"166":{"tf":1.0},"40":{"tf":1.7320508075688772},"43":{"tf":2.0},"53":{"tf":1.0},"55":{"tf":1.0},"66":{"tf":1.0},"93":{"tf":1.0}}}},"t":{"df":2,"docs":{"121":{"tf":1.0},"122":{"tf":1.0}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":2,"docs":{"121":{"tf":1.0},"122":{"tf":1.4142135623730951}}}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{":":{"/":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"235":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"137":{"tf":1.0},"181":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772}},"s":{":":{"/":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"?":{"df":0,"docs":{},"q":{"=":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{":":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"+":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"+":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"220":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"163":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"e":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"/":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":2,"docs":{"76":{"tf":1.0},"88":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"127":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}}}}}},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"2":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"225":{"tf":1.0}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"195":{"tf":1.4142135623730951}}}}}},"i":{"'":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"220":{"tf":1.0}}}},"m":{"df":1,"docs":{"220":{"tf":1.0}}}},".":{"df":3,"docs":{"110":{"tf":1.0},"184":{"tf":1.0},"24":{"tf":1.0}}},"/":{"df":0,"docs":{},"o":{"df":1,"docs":{"144":{"tf":1.0}}}},"3":{"2":{")":{">":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":11,"docs":{"194":{"tf":2.449489742783178},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":2.449489742783178},"48":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":2.8284271247461903},"63":{"tf":1.7320508075688772},"75":{"tf":1.0},"81":{"tf":1.4142135623730951},"82":{"tf":2.8284271247461903}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"8":{"_":{"df":2,"docs":{"48":{"tf":1.0},"75":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":2,"docs":{"58":{"tf":1.0},"82":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"u":{"df":8,"docs":{"100":{"tf":1.0},"103":{"tf":1.0},"106":{"tf":1.0},"45":{"tf":1.0},"72":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"58":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951}},"e":{"8":{"df":2,"docs":{"48":{"tf":1.0},"75":{"tf":1.0}}},"df":0,"docs":{}}}}}}},">":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"46":{"tf":1.0},"49":{"tf":1.4142135623730951},"61":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"\\":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"194":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":26,"docs":{"100":{"tf":2.0},"103":{"tf":2.0},"106":{"tf":2.0},"13":{"tf":1.0},"137":{"tf":1.0},"194":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.4142135623730951},"40":{"tf":2.6457513110645907},"45":{"tf":2.0},"46":{"tf":1.0},"48":{"tf":2.23606797749979},"49":{"tf":1.0},"57":{"tf":2.23606797749979},"58":{"tf":3.1622776601683795},"63":{"tf":1.0},"65":{"tf":2.0},"66":{"tf":1.4142135623730951},"72":{"tf":2.0},"75":{"tf":2.23606797749979},"81":{"tf":2.23606797749979},"82":{"tf":3.1622776601683795},"87":{"tf":2.0},"90":{"tf":2.0},"93":{"tf":2.0},"96":{"tf":2.0}}},"df":0,"docs":{}},"6":{"4":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"63":{"tf":1.0}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"63":{"tf":1.0}}}}}}},"df":5,"docs":{"137":{"tf":1.0},"194":{"tf":1.0},"65":{"tf":4.898979485566356},"66":{"tf":4.898979485566356},"87":{"tf":4.898979485566356}}},"8":{"6":{"df":1,"docs":{"137":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"d":{"df":1,"docs":{"161":{"tf":1.0}},"e":{"a":{"df":4,"docs":{"138":{"tf":1.0},"163":{"tf":1.0},"191":{"tf":1.0},"222":{"tf":1.4142135623730951}},"l":{"df":2,"docs":{"112":{"tf":1.0},"221":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"187":{"tf":1.0},"230":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"138":{"tf":1.4142135623730951},"194":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"(":{"5":{"df":1,"docs":{"106":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"106":{"tf":1.0}}}},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"216":{"tf":1.4142135623730951},"222":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"163":{"tf":1.4142135623730951}}}}}},"m":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"115":{"tf":1.0},"159":{"tf":1.0},"167":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"231":{"tf":1.0}}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":2,"docs":{"163":{"tf":1.0},"224":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"145":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":34,"docs":{"118":{"tf":1.0},"131":{"tf":1.7320508075688772},"132":{"tf":1.0},"136":{"tf":1.0},"137":{"tf":1.7320508075688772},"138":{"tf":3.1622776601683795},"142":{"tf":1.4142135623730951},"143":{"tf":1.7320508075688772},"144":{"tf":1.4142135623730951},"145":{"tf":1.7320508075688772},"146":{"tf":1.0},"148":{"tf":1.0},"156":{"tf":1.0},"158":{"tf":1.7320508075688772},"159":{"tf":1.0},"161":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":2.0},"164":{"tf":1.4142135623730951},"166":{"tf":1.7320508075688772},"167":{"tf":2.449489742783178},"180":{"tf":1.0},"184":{"tf":1.0},"185":{"tf":1.0},"207":{"tf":1.0},"211":{"tf":1.4142135623730951},"215":{"tf":1.0},"216":{"tf":1.0},"217":{"tf":1.0},"218":{"tf":1.0},"30":{"tf":1.0},"43":{"tf":1.0},"54":{"tf":1.4142135623730951},"55":{"tf":2.0}}}}}}},"i":{"c":{"df":2,"docs":{"158":{"tf":1.0},"159":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"187":{"tf":1.0}}}}}}},"df":1,"docs":{"138":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":32,"docs":{"121":{"tf":1.0},"123":{"tf":1.4142135623730951},"143":{"tf":1.0},"144":{"tf":1.0},"158":{"tf":2.449489742783178},"160":{"tf":1.0},"161":{"tf":1.4142135623730951},"162":{"tf":2.8284271247461903},"163":{"tf":1.0},"208":{"tf":1.0},"220":{"tf":1.0},"40":{"tf":3.1622776601683795},"42":{"tf":1.0},"43":{"tf":2.23606797749979},"52":{"tf":1.7320508075688772},"55":{"tf":1.0},"57":{"tf":2.23606797749979},"58":{"tf":1.4142135623730951},"64":{"tf":1.0},"65":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.4142135623730951},"70":{"tf":1.7320508075688772},"77":{"tf":1.0},"79":{"tf":1.0},"81":{"tf":2.23606797749979},"82":{"tf":1.4142135623730951},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"90":{"tf":2.23606797749979},"96":{"tf":1.0}},"s":{"[":{"0":{"]":{".":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"88":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"88":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"df":1,"docs":{"88":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"df":1,"docs":{"138":{"tf":1.0}},"s":{"df":1,"docs":{"144":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":3,"docs":{"137":{"tf":1.4142135623730951},"157":{"tf":1.0},"163":{"tf":1.0}}}}}}},"n":{"a":{"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"144":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"231":{"tf":1.0},"232":{"tf":1.0}}}}}}}}}},"c":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"234":{"tf":1.0}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"u":{"d":{"df":35,"docs":{"116":{"tf":1.0},"128":{"tf":1.0},"130":{"tf":1.4142135623730951},"131":{"tf":1.7320508075688772},"132":{"tf":1.0},"134":{"tf":1.0},"138":{"tf":2.23606797749979},"142":{"tf":1.4142135623730951},"147":{"tf":1.0},"158":{"tf":1.0},"160":{"tf":1.0},"162":{"tf":1.0},"171":{"tf":1.0},"185":{"tf":1.0},"190":{"tf":1.0},"208":{"tf":1.0},"212":{"tf":1.4142135623730951},"214":{"tf":1.0},"218":{"tf":1.0},"221":{"tf":1.4142135623730951},"225":{"tf":1.0},"226":{"tf":1.0},"231":{"tf":1.4142135623730951},"233":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"70":{"tf":2.23606797749979},"73":{"tf":2.23606797749979},"76":{"tf":2.449489742783178},"79":{"tf":2.449489742783178},"83":{"tf":2.449489742783178},"85":{"tf":2.449489742783178},"88":{"tf":2.449489742783178}}},"df":0,"docs":{},"s":{"df":3,"docs":{"136":{"tf":1.0},"138":{"tf":2.449489742783178},"231":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"17":{"tf":1.0}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"150":{"tf":1.0},"151":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"150":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":3,"docs":{"130":{"tf":1.4142135623730951},"209":{"tf":1.0},"33":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"132":{"tf":1.0}}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":2,"docs":{"163":{"tf":1.0},"194":{"tf":1.0}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"159":{"tf":1.0}}},"df":0,"docs":{}}}},"x":{"=":{"0":{"df":1,"docs":{"111":{"tf":1.0}}},"1":{"df":1,"docs":{"111":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":3,"docs":{"161":{"tf":1.0},"162":{"tf":1.0},"167":{"tf":1.0}}}},"i":{"c":{"df":12,"docs":{"134":{"tf":1.0},"138":{"tf":1.0},"142":{"tf":1.0},"145":{"tf":1.0},"159":{"tf":1.0},"164":{"tf":1.0},"180":{"tf":1.0},"185":{"tf":1.0},"190":{"tf":1.0},"206":{"tf":1.0},"224":{"tf":1.0},"225":{"tf":1.4142135623730951}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"144":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":7,"docs":{"166":{"tf":1.0},"194":{"tf":1.0},"206":{"tf":1.0},"216":{"tf":1.0},"221":{"tf":1.0},"229":{"tf":1.0},"233":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"147":{"tf":1.0},"159":{"tf":1.0}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"138":{"tf":1.0},"145":{"tf":1.0}}}}}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"150":{"tf":1.4142135623730951},"151":{"tf":1.0}}}}}},"o":{"df":2,"docs":{"110":{"tf":2.23606797749979},"85":{"tf":1.0}},"r":{"df":0,"docs":{},"m":{"df":30,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"111":{"tf":1.0},"113":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":2.8284271247461903},"117":{"tf":1.4142135623730951},"118":{"tf":1.0},"119":{"tf":1.0},"122":{"tf":1.4142135623730951},"13":{"tf":1.7320508075688772},"130":{"tf":2.6457513110645907},"139":{"tf":1.0},"145":{"tf":1.4142135623730951},"153":{"tf":1.0},"156":{"tf":1.0},"158":{"tf":1.4142135623730951},"159":{"tf":2.8284271247461903},"162":{"tf":1.0},"163":{"tf":1.0},"167":{"tf":1.4142135623730951},"202":{"tf":1.0},"212":{"tf":1.0},"231":{"tf":1.0},"30":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"172":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"143":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":3,"docs":{"52":{"tf":1.0},"53":{"tf":1.0},"59":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":3,"docs":{"52":{"tf":1.0},"53":{"tf":1.0},"59":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"55":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"170":{"tf":1.0},"180":{"tf":1.0},"96":{"tf":1.0}},"i":{"df":11,"docs":{"162":{"tf":2.23606797749979},"170":{"tf":1.0},"180":{"tf":1.0},"40":{"tf":1.0},"49":{"tf":1.0},"57":{"tf":1.0},"7":{"tf":1.0},"76":{"tf":1.4142135623730951},"81":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"115":{"tf":1.4142135623730951},"117":{"tf":1.0},"147":{"tf":1.0}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"158":{"tf":1.0},"208":{"tf":1.0},"217":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":17,"docs":{"114":{"tf":1.0},"115":{"tf":1.4142135623730951},"117":{"tf":1.7320508075688772},"151":{"tf":1.0},"159":{"tf":1.4142135623730951},"187":{"tf":1.7320508075688772},"188":{"tf":1.4142135623730951},"194":{"tf":1.4142135623730951},"39":{"tf":1.0},"40":{"tf":1.0},"61":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":6,"docs":{"148":{"tf":1.0},"158":{"tf":1.0},"160":{"tf":1.0},"161":{"tf":1.4142135623730951},"162":{"tf":1.0},"59":{"tf":1.0}}}}},"i":{"d":{"df":7,"docs":{"122":{"tf":1.0},"128":{"tf":1.0},"143":{"tf":1.0},"150":{"tf":1.0},"183":{"tf":1.0},"200":{"tf":1.0},"3":{"tf":1.0}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":5,"docs":{"110":{"tf":1.0},"111":{"tf":1.0},"163":{"tf":1.0},"209":{"tf":1.0},"40":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"136":{"tf":1.0},"155":{"tf":1.0}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":23,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"102":{"tf":1.4142135623730951},"103":{"tf":1.7320508075688772},"105":{"tf":1.0},"113":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":1.0},"130":{"tf":1.0},"163":{"tf":1.0},"169":{"tf":1.0},"171":{"tf":1.0},"172":{"tf":1.0},"177":{"tf":1.4142135623730951},"195":{"tf":1.7320508075688772},"196":{"tf":1.4142135623730951},"197":{"tf":1.7320508075688772},"198":{"tf":1.7320508075688772},"2":{"tf":2.6457513110645907},"3":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":2.23606797749979},"92":{"tf":1.0}}},"n":{"c":{"df":32,"docs":{"103":{"tf":1.0},"106":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"143":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.7320508075688772},"158":{"tf":2.6457513110645907},"159":{"tf":1.4142135623730951},"162":{"tf":2.6457513110645907},"163":{"tf":1.0},"232":{"tf":1.0},"234":{"tf":1.0},"39":{"tf":2.0},"40":{"tf":1.4142135623730951},"43":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":2.0},"52":{"tf":1.0},"59":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"70":{"tf":2.0},"73":{"tf":1.7320508075688772},"76":{"tf":2.449489742783178},"83":{"tf":1.4142135623730951},"85":{"tf":1.7320508075688772},"88":{"tf":1.7320508075688772},"90":{"tf":1.4142135623730951},"93":{"tf":1.0},"96":{"tf":1.0}},"e":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"90":{"tf":1.0}},"e":{"=":{"1":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{")":{"[":{"'":{"df":0,"docs":{},"g":{"c":{"d":{"df":1,"docs":{"90":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}}},"g":{"c":{"d":{"(":{"2":{"7":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{":":{":":{"<":{"(":{"df":0,"docs":{},"i":{"3":{"2":{"df":3,"docs":{"46":{"tf":1.0},"49":{"tf":1.0},"66":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"3":{"2":{"df":2,"docs":{"49":{"tf":1.0},"61":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"40":{"tf":1.0},"43":{"tf":1.0},"49":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"96":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"(":{"\"":{"df":0,"docs":{},"g":{"c":{"d":{"df":1,"docs":{"103":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":7,"docs":{"39":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"66":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"162":{"tf":1.0}}}}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":3,"docs":{"158":{"tf":3.0},"162":{"tf":2.0},"167":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"/":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"162":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":32,"docs":{"145":{"tf":1.0},"157":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":2.0},"161":{"tf":1.4142135623730951},"162":{"tf":3.1622776601683795},"163":{"tf":1.0},"187":{"tf":1.0},"217":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.7320508075688772},"41":{"tf":1.0},"43":{"tf":2.0},"46":{"tf":1.4142135623730951},"50":{"tf":1.0},"52":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951},"56":{"tf":1.0},"59":{"tf":1.4142135623730951},"66":{"tf":1.0},"68":{"tf":1.0},"7":{"tf":1.4142135623730951},"70":{"tf":2.0},"73":{"tf":1.7320508075688772},"76":{"tf":1.7320508075688772},"77":{"tf":1.0},"79":{"tf":2.23606797749979},"80":{"tf":1.0},"83":{"tf":2.449489742783178},"85":{"tf":1.4142135623730951},"88":{"tf":1.7320508075688772},"9":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":11,"docs":{"130":{"tf":1.4142135623730951},"138":{"tf":1.0},"145":{"tf":1.0},"148":{"tf":1.0},"166":{"tf":1.0},"206":{"tf":1.0},"207":{"tf":1.0},"209":{"tf":1.0},"213":{"tf":1.0},"226":{"tf":1.0},"43":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":12,"docs":{"0":{"tf":1.0},"130":{"tf":1.0},"137":{"tf":1.0},"140":{"tf":1.0},"148":{"tf":1.4142135623730951},"159":{"tf":1.0},"161":{"tf":1.0},"163":{"tf":1.7320508075688772},"193":{"tf":1.0},"194":{"tf":2.449489742783178},"216":{"tf":1.4142135623730951},"217":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"/":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"231":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"t":{")":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"s":{"df":7,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"3":{"2":{"_":{"df":0,"docs":{},"t":{")":{"df":0,"docs":{},"i":{"df":1,"docs":{"88":{"tf":1.0}}}},"df":1,"docs":{"76":{"tf":3.4641016151377544}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":9,"docs":{"128":{"tf":1.0},"137":{"tf":1.0},"70":{"tf":1.4142135623730951},"73":{"tf":2.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"g":{"df":8,"docs":{"137":{"tf":1.0},"161":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"}":{"(":{"df":3,"docs":{"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0}},"k":{"df":4,"docs":{"17":{"tf":1.0},"20":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":8,"docs":{"145":{"tf":1.0},"150":{"tf":1.0},"151":{"tf":1.0},"181":{"tf":1.4142135623730951},"183":{"tf":1.4142135623730951},"185":{"tf":1.0},"189":{"tf":1.4142135623730951},"202":{"tf":1.0}}}},"l":{"'":{"df":1,"docs":{"112":{"tf":1.0}}},"df":1,"docs":{"137":{"tf":1.0}}},"n":{"d":{"df":21,"docs":{"0":{"tf":1.0},"129":{"tf":1.0},"131":{"tf":1.0},"134":{"tf":1.7320508075688772},"136":{"tf":1.0},"137":{"tf":1.4142135623730951},"138":{"tf":2.0},"139":{"tf":1.0},"143":{"tf":1.4142135623730951},"145":{"tf":1.0},"156":{"tf":1.0},"157":{"tf":1.0},"159":{"tf":1.0},"190":{"tf":1.0},"191":{"tf":1.0},"209":{"tf":1.7320508075688772},"220":{"tf":1.0},"223":{"tf":1.0},"224":{"tf":1.4142135623730951},"226":{"tf":1.0},"67":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":2,"docs":{"158":{"tf":1.0},"190":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"138":{"tf":1.0}}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":17,"docs":{"102":{"tf":1.0},"105":{"tf":1.0},"144":{"tf":1.0},"158":{"tf":1.0},"216":{"tf":1.0},"224":{"tf":1.0},"225":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0},"61":{"tf":1.0},"64":{"tf":1.0},"68":{"tf":1.0},"74":{"tf":1.0},"86":{"tf":1.0},"92":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"159":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":9,"docs":{"112":{"tf":1.0},"134":{"tf":1.0},"153":{"tf":1.4142135623730951},"155":{"tf":1.4142135623730951},"159":{"tf":1.0},"178":{"tf":1.0},"219":{"tf":1.0},"230":{"tf":1.0},"40":{"tf":1.4142135623730951}}}}},"f":{"a":{"c":{"df":7,"docs":{"0":{"tf":2.0},"111":{"tf":1.0},"120":{"tf":1.0},"138":{"tf":1.7320508075688772},"144":{"tf":1.0},"167":{"tf":1.0},"66":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"v":{"df":1,"docs":{"159":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"'":{"d":{"df":1,"docs":{"161":{"tf":1.0}}},"df":0,"docs":{}},"df":10,"docs":{"128":{"tf":1.0},"138":{"tf":1.4142135623730951},"157":{"tf":2.23606797749979},"158":{"tf":2.8284271247461903},"159":{"tf":1.7320508075688772},"161":{"tf":1.4142135623730951},"162":{"tf":1.0},"165":{"tf":1.4142135623730951},"167":{"tf":1.0},"223":{"tf":1.0}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":3,"docs":{"141":{"tf":1.7320508075688772},"145":{"tf":1.0},"187":{"tf":1.4142135623730951}}}}}},"v":{"df":7,"docs":{"127":{"tf":1.4142135623730951},"14":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"24":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"0":{"tf":1.0},"146":{"tf":1.0}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":2,"docs":{"14":{"tf":1.0},"216":{"tf":1.0}},"t":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"h":{"df":3,"docs":{"76":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"128":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"193":{"tf":1.0}},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"234":{"tf":1.0}}}}}}},"o":{"c":{"df":1,"docs":{"175":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":15,"docs":{"1":{"tf":1.4142135623730951},"100":{"tf":1.0},"101":{"tf":1.4142135623730951},"111":{"tf":1.0},"128":{"tf":1.0},"159":{"tf":1.0},"46":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"55":{"tf":1.0},"61":{"tf":1.0},"7":{"tf":1.4142135623730951},"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"88":{"tf":1.0}}},"l":{"df":0,"docs":{},"v":{"df":8,"docs":{"152":{"tf":1.0},"155":{"tf":1.0},"158":{"tf":1.0},"162":{"tf":1.7320508075688772},"187":{"tf":1.0},"189":{"tf":1.0},"193":{"tf":1.0},"194":{"tf":1.0}}}}}}},"o":{"df":3,"docs":{"137":{"tf":1.0},"139":{"tf":1.0},"195":{"tf":1.0}},"v":{"df":2,"docs":{"58":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951}},"e":{"c":{"df":2,"docs":{"58":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"s":{"=":{"*":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"194":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"159":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"n":{"'":{"df":0,"docs":{},"t":{"df":4,"docs":{"130":{"tf":1.4142135623730951},"184":{"tf":1.4142135623730951},"193":{"tf":1.0},"206":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":3,"docs":{"120":{"tf":1.0},"143":{"tf":1.0},"158":{"tf":1.0}}}},"s":{"df":0,"docs":{},"u":{"df":30,"docs":{"104":{"tf":1.0},"107":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"126":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.0},"134":{"tf":2.6457513110645907},"135":{"tf":1.0},"138":{"tf":1.0},"145":{"tf":1.4142135623730951},"149":{"tf":1.0},"150":{"tf":1.0},"151":{"tf":1.0},"153":{"tf":1.0},"154":{"tf":2.6457513110645907},"155":{"tf":2.449489742783178},"191":{"tf":1.0},"194":{"tf":1.0},"195":{"tf":1.0},"210":{"tf":1.0},"211":{"tf":1.7320508075688772},"212":{"tf":1.7320508075688772},"222":{"tf":1.0},"224":{"tf":1.4142135623730951},"226":{"tf":1.7320508075688772},"232":{"tf":1.0},"91":{"tf":1.0},"94":{"tf":1.0},"97":{"tf":1.0}}}}},"t":{"'":{"df":33,"docs":{"110":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":2.23606797749979},"138":{"tf":1.4142135623730951},"140":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.4142135623730951},"156":{"tf":1.0},"158":{"tf":2.0},"159":{"tf":1.0},"161":{"tf":1.0},"162":{"tf":1.0},"167":{"tf":1.0},"178":{"tf":1.0},"183":{"tf":1.4142135623730951},"185":{"tf":1.4142135623730951},"189":{"tf":1.4142135623730951},"203":{"tf":1.0},"207":{"tf":1.4142135623730951},"208":{"tf":1.0},"209":{"tf":1.4142135623730951},"212":{"tf":1.0},"213":{"tf":1.4142135623730951},"220":{"tf":1.4142135623730951},"221":{"tf":1.0},"222":{"tf":1.0},"223":{"tf":1.0},"224":{"tf":2.0},"226":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"55":{"tf":1.0},"7":{"tf":1.0}},"l":{"df":0,"docs":{},"l":{"df":8,"docs":{"103":{"tf":1.0},"106":{"tf":1.0},"142":{"tf":1.0},"158":{"tf":1.0},"184":{"tf":1.0},"226":{"tf":1.0},"39":{"tf":1.0},"5":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{".":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"76":{"tf":2.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"76":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"76":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"df":6,"docs":{"158":{"tf":1.0},"162":{"tf":1.4142135623730951},"214":{"tf":1.0},"39":{"tf":1.4142135623730951},"43":{"tf":1.0},"76":{"tf":2.23606797749979}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":21,"docs":{"114":{"tf":1.0},"115":{"tf":1.0},"120":{"tf":1.4142135623730951},"126":{"tf":1.0},"131":{"tf":1.0},"134":{"tf":1.0},"136":{"tf":1.4142135623730951},"137":{"tf":1.0},"145":{"tf":1.7320508075688772},"156":{"tf":1.0},"157":{"tf":1.0},"158":{"tf":1.4142135623730951},"159":{"tf":1.0},"162":{"tf":1.4142135623730951},"163":{"tf":1.4142135623730951},"166":{"tf":1.0},"178":{"tf":1.0},"180":{"tf":1.0},"206":{"tf":1.0},"208":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951}}}}}},"t":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":3,"docs":{"118":{"tf":2.23606797749979},"119":{"tf":1.0},"120":{"tf":1.0}}}}},"df":0,"docs":{}}}},"j":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":3,"docs":{"113":{"tf":1.0},"115":{"tf":2.449489742783178},"116":{"tf":1.0}}}}}},"df":19,"docs":{"112":{"tf":1.0},"113":{"tf":1.0},"115":{"tf":2.23606797749979},"116":{"tf":1.4142135623730951},"117":{"tf":1.4142135623730951},"118":{"tf":1.7320508075688772},"119":{"tf":1.4142135623730951},"121":{"tf":1.0},"140":{"tf":1.4142135623730951},"158":{"tf":2.8284271247461903},"159":{"tf":2.6457513110645907},"160":{"tf":1.7320508075688772},"162":{"tf":1.0},"163":{"tf":1.4142135623730951},"164":{"tf":1.0},"165":{"tf":1.0},"167":{"tf":1.0},"217":{"tf":1.0},"39":{"tf":1.4142135623730951}}}},"o":{"b":{"df":2,"docs":{"205":{"tf":1.4142135623730951},"224":{"tf":1.7320508075688772}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"153":{"tf":2.0},"219":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"126":{"tf":1.0}}}}},"u":{"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"207":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"125":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"138":{"tf":1.0}}}}}}}}},"k":{"df":3,"docs":{"114":{"tf":1.0},"115":{"tf":1.4142135623730951},"117":{"tf":1.0}},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":6,"docs":{"130":{"tf":1.0},"146":{"tf":1.0},"162":{"tf":1.0},"189":{"tf":1.4142135623730951},"220":{"tf":1.0},"25":{"tf":1.0}}}},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"162":{"tf":1.0},"226":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"=":{"0":{"df":1,"docs":{"124":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"112":{"tf":1.0}}}}}},"y":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"137":{"tf":1.0}}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"212":{"tf":1.0}}},"df":0,"docs":{}}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"226":{"tf":1.0}}}},"df":1,"docs":{"27":{"tf":1.0}},"n":{"d":{"df":2,"docs":{"150":{"tf":1.0},"220":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":12,"docs":{"131":{"tf":1.0},"14":{"tf":1.0},"158":{"tf":1.4142135623730951},"160":{"tf":1.0},"164":{"tf":1.0},"165":{"tf":1.0},"208":{"tf":1.0},"212":{"tf":1.0},"221":{"tf":1.4142135623730951},"91":{"tf":1.0},"94":{"tf":1.0},"97":{"tf":1.0}},"l":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"160":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":8,"docs":{"131":{"tf":1.0},"137":{"tf":1.0},"138":{"tf":1.0},"144":{"tf":1.0},"154":{"tf":1.0},"160":{"tf":1.4142135623730951},"163":{"tf":1.0},"217":{"tf":1.0}}}}}}},"l":{"a":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":10,"docs":{"100":{"tf":1.7320508075688772},"103":{"tf":1.7320508075688772},"106":{"tf":1.7320508075688772},"154":{"tf":1.4142135623730951},"155":{"tf":1.0},"45":{"tf":1.7320508075688772},"72":{"tf":1.7320508075688772},"90":{"tf":1.7320508075688772},"93":{"tf":1.7320508075688772},"96":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"224":{"tf":1.0}}},"i":{"d":{"df":1,"docs":{"158":{"tf":1.0}}},"df":0,"docs":{}},"n":{"d":{"df":7,"docs":{"130":{"tf":1.0},"138":{"tf":1.0},"203":{"tf":1.0},"204":{"tf":1.0},"207":{"tf":1.4142135623730951},"224":{"tf":1.0},"225":{"tf":1.0}}},"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"c":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"2":{"6":{"2":{"5":{"df":1,"docs":{"163":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":8,"docs":{"0":{"tf":1.7320508075688772},"113":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.0},"216":{"tf":1.0},"217":{"tf":1.0},"231":{"tf":1.4142135623730951},"36":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":4,"docs":{"130":{"tf":1.4142135623730951},"140":{"tf":1.0},"193":{"tf":1.0},"223":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"0":{"tf":1.0},"131":{"tf":1.0},"194":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":8,"docs":{"106":{"tf":1.0},"130":{"tf":1.0},"208":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"43":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"138":{"tf":1.0},"159":{"tf":1.0},"162":{"tf":1.0},"92":{"tf":1.0},"95":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":8,"docs":{"125":{"tf":1.0},"134":{"tf":1.0},"191":{"tf":1.0},"192":{"tf":1.0},"205":{"tf":1.4142135623730951},"224":{"tf":1.0},"3":{"tf":1.4142135623730951},"39":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"y":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"136":{"tf":1.0}}}}}},"y":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"54":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"158":{"tf":1.4142135623730951}}}}}}},"d":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"=":{"/":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"/":{"a":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"6":{"4":{"df":1,"docs":{"199":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"v":{"6":{"4":{"df":1,"docs":{"199":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"s":{"3":{"9":{"0":{"df":0,"docs":{},"x":{"df":1,"docs":{"199":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":6,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0}}}},"df":2,"docs":{"130":{"tf":3.4641016151377544},"199":{"tf":1.7320508075688772}},"e":{"a":{"d":{"df":2,"docs":{"150":{"tf":1.0},"158":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"234":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"145":{"tf":1.0}}}},"df":1,"docs":{"166":{"tf":1.0}}},"n":{"df":1,"docs":{"159":{"tf":1.0}}},"r":{"df":0,"docs":{},"n":{"df":10,"docs":{"104":{"tf":1.0},"107":{"tf":1.0},"14":{"tf":1.0},"154":{"tf":1.0},"155":{"tf":2.23606797749979},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"6":{"tf":1.0}}}},"v":{"df":2,"docs":{"207":{"tf":1.0},"220":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"207":{"tf":1.0}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"194":{"tf":1.0},"58":{"tf":1.0},"82":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"s":{"df":5,"docs":{"130":{"tf":1.4142135623730951},"137":{"tf":1.0},"158":{"tf":1.0},"164":{"tf":1.0},"208":{"tf":1.0}}}},"t":{"'":{"df":7,"docs":{"103":{"tf":1.0},"117":{"tf":1.4142135623730951},"130":{"tf":1.0},"39":{"tf":1.4142135623730951},"40":{"tf":1.0},"57":{"tf":1.0},"81":{"tf":1.0}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"=":{"0":{"df":1,"docs":{"110":{"tf":1.4142135623730951}}},"df":0,"docs":{},"z":{"df":1,"docs":{"122":{"tf":1.4142135623730951}}}},"df":18,"docs":{"130":{"tf":2.0},"134":{"tf":1.0},"138":{"tf":2.23606797749979},"139":{"tf":1.0},"150":{"tf":1.0},"158":{"tf":1.7320508075688772},"159":{"tf":1.7320508075688772},"161":{"tf":1.0},"167":{"tf":1.7320508075688772},"178":{"tf":1.0},"18":{"tf":1.7320508075688772},"185":{"tf":1.0},"19":{"tf":1.4142135623730951},"224":{"tf":1.0},"230":{"tf":1.0},"31":{"tf":1.0},"33":{"tf":2.0},"39":{"tf":1.0}}},"r":{"a":{"df":0,"docs":{},"g":{"df":4,"docs":{"130":{"tf":1.0},"137":{"tf":1.0},"145":{"tf":1.0},"166":{"tf":1.0}}}},"df":0,"docs":{}}}}},"i":{"b":{"c":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{".":{"6":{"df":1,"docs":{"122":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"158":{"tf":1.0}}}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"172":{"tf":2.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"z":{"df":0,"docs":{},"z":{"df":2,"docs":{"187":{"tf":1.0},"188":{"tf":1.4142135623730951}}}}}},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":12,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"106":{"tf":1.0},"118":{"tf":2.0},"119":{"tf":1.0},"13":{"tf":1.0},"130":{"tf":2.449489742783178},"131":{"tf":1.0},"132":{"tf":2.0},"146":{"tf":1.0},"218":{"tf":1.0},"36":{"tf":1.0}}}}},"df":0,"docs":{}},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"a":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"162":{"tf":1.0},"165":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":14,"docs":{"112":{"tf":1.0},"14":{"tf":1.0},"140":{"tf":1.0},"143":{"tf":1.0},"158":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"28":{"tf":2.0},"29":{"tf":2.0},"31":{"tf":1.0},"34":{"tf":2.0},"76":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":7,"docs":{"144":{"tf":1.4142135623730951},"145":{"tf":1.4142135623730951},"148":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":3.1622776601683795},"47":{"tf":1.0},"74":{"tf":1.0}}}},"df":17,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"111":{"tf":1.0},"114":{"tf":1.4142135623730951},"115":{"tf":1.4142135623730951},"116":{"tf":1.7320508075688772},"118":{"tf":1.0},"119":{"tf":1.4142135623730951},"121":{"tf":1.0},"126":{"tf":1.4142135623730951},"130":{"tf":2.23606797749979},"131":{"tf":1.4142135623730951},"162":{"tf":1.0},"188":{"tf":1.0},"2":{"tf":1.0},"212":{"tf":1.4142135623730951},"216":{"tf":1.0}}},"k":{"df":15,"docs":{"118":{"tf":1.0},"137":{"tf":1.4142135623730951},"140":{"tf":1.0},"142":{"tf":1.0},"144":{"tf":1.0},"146":{"tf":1.0},"159":{"tf":1.0},"162":{"tf":1.4142135623730951},"227":{"tf":1.0},"56":{"tf":1.4142135623730951},"59":{"tf":2.23606797749979},"79":{"tf":1.0},"80":{"tf":1.4142135623730951},"83":{"tf":2.6457513110645907},"9":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"40":{"tf":1.0},"59":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"52":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"&":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":5,"docs":{"40":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"59":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.0}}}}}},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"1":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":1,"docs":{"55":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":11,"docs":{"197":{"tf":1.0},"199":{"tf":1.7320508075688772},"40":{"tf":2.0},"50":{"tf":1.0},"52":{"tf":1.7320508075688772},"53":{"tf":1.7320508075688772},"55":{"tf":2.23606797749979},"56":{"tf":1.0},"59":{"tf":2.23606797749979},"79":{"tf":1.4142135623730951},"83":{"tf":2.23606797749979}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{".":{"c":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":1,"docs":{"59":{"tf":1.0}}}},"1":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"59":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"w":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"57":{"tf":1.0},"81":{"tf":1.0}}}},"df":0,"docs":{}}},"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"83":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{".":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":1,"docs":{"83":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":2,"docs":{"59":{"tf":1.7320508075688772},"83":{"tf":2.449489742783178}}},"2":{".":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"58":{"tf":1.0},"82":{"tf":1.0}}}},"df":0,"docs":{}}},"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"83":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{".":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":1,"docs":{"83":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":4,"docs":{"57":{"tf":2.0},"59":{"tf":2.23606797749979},"81":{"tf":2.0},"83":{"tf":3.1622776601683795}}},"df":0,"docs":{}}}}},"t":{"df":2,"docs":{"203":{"tf":2.23606797749979},"204":{"tf":3.3166247903554}}},"u":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"x":{"df":0,"docs":{},"z":{"df":1,"docs":{"3":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"/":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"o":{"df":1,"docs":{"125":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":25,"docs":{"112":{"tf":1.7320508075688772},"113":{"tf":1.7320508075688772},"125":{"tf":1.0},"13":{"tf":1.0},"132":{"tf":2.0},"137":{"tf":2.8284271247461903},"138":{"tf":1.0},"139":{"tf":1.0},"190":{"tf":1.0},"191":{"tf":1.0},"192":{"tf":1.4142135623730951},"195":{"tf":1.7320508075688772},"196":{"tf":1.7320508075688772},"197":{"tf":1.7320508075688772},"199":{"tf":3.4641016151377544},"2":{"tf":1.0},"200":{"tf":1.7320508075688772},"205":{"tf":1.0},"3":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":15,"docs":{"1":{"tf":1.0},"131":{"tf":1.0},"137":{"tf":1.0},"140":{"tf":1.0},"150":{"tf":1.0},"155":{"tf":1.0},"157":{"tf":1.0},"158":{"tf":1.0},"162":{"tf":1.7320508075688772},"166":{"tf":2.0},"224":{"tf":1.0},"225":{"tf":1.4142135623730951},"226":{"tf":1.0},"227":{"tf":1.0},"37":{"tf":1.0}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":5,"docs":{"154":{"tf":1.0},"157":{"tf":1.0},"159":{"tf":1.0},"178":{"tf":1.0},"194":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":11,"docs":{"0":{"tf":1.0},"109":{"tf":1.0},"159":{"tf":1.0},"166":{"tf":1.0},"167":{"tf":1.0},"183":{"tf":1.0},"184":{"tf":1.0},"187":{"tf":1.0},"70":{"tf":1.4142135623730951},"91":{"tf":1.0},"97":{"tf":1.0}}}}},"l":{"d":{"b":{"df":6,"docs":{"109":{"tf":1.0},"110":{"tf":2.6457513110645907},"60":{"tf":1.0},"61":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"v":{"df":0,"docs":{},"m":{"df":1,"docs":{"130":{"tf":1.0}}}}},"m":{"df":6,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0}}},"o":{"a":{"d":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}},"u":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"76":{"tf":3.3166247903554}}},"df":0,"docs":{}}}}},"df":19,"docs":{"122":{"tf":1.0},"128":{"tf":1.0},"140":{"tf":1.0},"159":{"tf":1.4142135623730951},"162":{"tf":1.0},"31":{"tf":1.0},"46":{"tf":1.4142135623730951},"48":{"tf":1.0},"49":{"tf":1.0},"59":{"tf":1.0},"61":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.7320508075688772},"75":{"tf":1.0},"76":{"tf":2.0},"79":{"tf":1.7320508075688772},"83":{"tf":1.7320508075688772},"85":{"tf":1.0},"88":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"g":{"d":{"b":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"110":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"89":{"tf":1.0}}}},"s":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"164":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":14,"docs":{"100":{"tf":2.6457513110645907},"103":{"tf":2.6457513110645907},"106":{"tf":2.6457513110645907},"45":{"tf":2.6457513110645907},"48":{"tf":1.7320508075688772},"58":{"tf":1.7320508075688772},"65":{"tf":3.4641016151377544},"72":{"tf":2.6457513110645907},"75":{"tf":1.7320508075688772},"82":{"tf":1.7320508075688772},"87":{"tf":3.4641016151377544},"90":{"tf":2.6457513110645907},"93":{"tf":2.6457513110645907},"96":{"tf":2.6457513110645907}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":8,"docs":{"100":{"tf":1.7320508075688772},"103":{"tf":1.7320508075688772},"106":{"tf":1.7320508075688772},"45":{"tf":1.7320508075688772},"72":{"tf":1.7320508075688772},"90":{"tf":1.7320508075688772},"93":{"tf":1.7320508075688772},"96":{"tf":1.7320508075688772}}}}},"t":{"df":0,"docs":{},"e":{"df":8,"docs":{"100":{"tf":1.0},"103":{"tf":1.0},"106":{"tf":1.0},"45":{"tf":1.0},"72":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0}}}}},"df":40,"docs":{"10":{"tf":1.0},"100":{"tf":1.0},"101":{"tf":1.7320508075688772},"102":{"tf":1.0},"103":{"tf":1.0},"106":{"tf":1.0},"110":{"tf":1.0},"130":{"tf":1.7320508075688772},"158":{"tf":1.4142135623730951},"161":{"tf":1.0},"173":{"tf":1.0},"194":{"tf":1.0},"202":{"tf":1.0},"203":{"tf":1.4142135623730951},"204":{"tf":1.0},"218":{"tf":1.0},"226":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"47":{"tf":1.0},"50":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.0},"80":{"tf":1.0},"84":{"tf":1.0},"86":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0}}},"t":{"df":7,"docs":{"14":{"tf":1.7320508075688772},"148":{"tf":1.0},"15":{"tf":1.0},"173":{"tf":1.4142135623730951},"183":{"tf":1.4142135623730951},"187":{"tf":1.0},"79":{"tf":1.0}}}},"df":0,"docs":{},"k":{"df":6,"docs":{"137":{"tf":1.0},"158":{"tf":1.4142135623730951},"24":{"tf":2.6457513110645907},"25":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":10,"docs":{"1":{"tf":1.0},"13":{"tf":2.8284271247461903},"130":{"tf":3.605551275463989},"221":{"tf":1.0},"224":{"tf":1.0},"40":{"tf":4.358898943540674},"57":{"tf":1.7320508075688772},"58":{"tf":1.0},"81":{"tf":1.7320508075688772},"82":{"tf":1.0}},"i":{"c":{"df":1,"docs":{"224":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"g":{"df":6,"docs":{"128":{"tf":1.0},"138":{"tf":1.7320508075688772},"150":{"tf":1.0},"165":{"tf":1.0},"25":{"tf":1.0},"70":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"130":{"tf":1.7320508075688772},"190":{"tf":1.0}}}},"j":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"163":{"tf":2.23606797749979}}}}}}},"o":{"df":0,"docs":{},"k":{"df":20,"docs":{"114":{"tf":1.0},"117":{"tf":1.4142135623730951},"124":{"tf":1.0},"126":{"tf":1.0},"128":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.4142135623730951},"154":{"tf":1.0},"155":{"tf":1.0},"16":{"tf":1.0},"162":{"tf":1.4142135623730951},"191":{"tf":1.0},"220":{"tf":1.0},"221":{"tf":1.4142135623730951},"227":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.7320508075688772},"61":{"tf":1.0},"9":{"tf":1.0}},"u":{"df":0,"docs":{},"p":{"df":3,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"83":{"tf":1.0}}}}},"p":{"df":11,"docs":{"100":{"tf":1.0},"103":{"tf":1.0},"106":{"tf":1.0},"150":{"tf":1.4142135623730951},"151":{"tf":1.0},"32":{"tf":1.0},"45":{"tf":1.0},"72":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0}}}},"t":{"df":4,"docs":{"113":{"tf":1.0},"115":{"tf":1.0},"130":{"tf":1.0},"155":{"tf":1.0}}},"w":{"df":3,"docs":{"158":{"tf":1.0},"167":{"tf":1.4142135623730951},"192":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"206":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":6,"docs":{"70":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"34":{"tf":1.0}}}},"s":{"df":1,"docs":{"130":{"tf":3.4641016151377544}}},"t":{"df":0,"docs":{},"o":{"=":{"df":0,"docs":{},"y":{"df":1,"docs":{"122":{"tf":1.4142135623730951}}}},"df":1,"docs":{"130":{"tf":2.23606797749979}}}},"u":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"195":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"m":{"a":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"155":{"tf":1.0},"195":{"tf":1.0}}}}},"o":{"df":17,"docs":{"110":{"tf":1.0},"112":{"tf":1.0},"125":{"tf":1.0},"130":{"tf":1.0},"132":{"tf":1.0},"139":{"tf":1.0},"191":{"tf":1.0},"192":{"tf":1.0},"195":{"tf":1.4142135623730951},"2":{"tf":1.0},"3":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"x":{"df":0,"docs":{},"z":{"df":1,"docs":{"3":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":7,"docs":{"131":{"tf":1.4142135623730951},"134":{"tf":1.7320508075688772},"135":{"tf":1.0},"206":{"tf":1.0},"220":{"tf":1.0},"224":{"tf":1.0},"225":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"226":{"tf":1.0},"233":{"tf":1.0}}},"n":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"76":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"93":{"tf":1.0}}}}}},".":{"c":{"df":1,"docs":{"85":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"96":{"tf":1.4142135623730951}}}},"r":{"df":3,"docs":{"52":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0}}},"y":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"224":{"tf":1.0}}}}}},"df":45,"docs":{"101":{"tf":1.0},"111":{"tf":1.7320508075688772},"117":{"tf":1.0},"122":{"tf":1.0},"128":{"tf":1.4142135623730951},"135":{"tf":1.0},"143":{"tf":1.0},"156":{"tf":1.0},"157":{"tf":1.0},"158":{"tf":1.4142135623730951},"159":{"tf":1.0},"163":{"tf":1.0},"167":{"tf":1.0},"185":{"tf":1.0},"192":{"tf":1.0},"195":{"tf":1.0},"203":{"tf":1.0},"204":{"tf":1.0},"209":{"tf":1.0},"224":{"tf":3.4641016151377544},"225":{"tf":1.7320508075688772},"226":{"tf":1.0},"227":{"tf":1.4142135623730951},"3":{"tf":1.0},"30":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"59":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"66":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"96":{"tf":1.4142135623730951}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":19,"docs":{"134":{"tf":1.0},"135":{"tf":1.0},"137":{"tf":2.8284271247461903},"138":{"tf":3.0},"139":{"tf":1.7320508075688772},"140":{"tf":1.4142135623730951},"162":{"tf":1.0},"190":{"tf":1.4142135623730951},"207":{"tf":1.4142135623730951},"208":{"tf":2.449489742783178},"209":{"tf":1.4142135623730951},"219":{"tf":1.0},"224":{"tf":2.0},"225":{"tf":1.0},"230":{"tf":1.0},"232":{"tf":1.4142135623730951},"233":{"tf":1.0},"234":{"tf":1.4142135623730951},"34":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"138":{"tf":1.0}}}}}}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":8,"docs":{"1":{"tf":1.0},"112":{"tf":1.0},"134":{"tf":2.6457513110645907},"138":{"tf":2.449489742783178},"139":{"tf":1.0},"190":{"tf":1.0},"224":{"tf":1.4142135623730951},"225":{"tf":1.7320508075688772}}}}},"k":{"df":0,"docs":{},"e":{"df":41,"docs":{"102":{"tf":1.0},"115":{"tf":1.0},"128":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.0},"138":{"tf":1.4142135623730951},"143":{"tf":1.0},"144":{"tf":1.0},"147":{"tf":1.0},"152":{"tf":1.0},"153":{"tf":1.0},"154":{"tf":1.0},"166":{"tf":1.0},"169":{"tf":1.0},"172":{"tf":1.0},"173":{"tf":1.4142135623730951},"176":{"tf":1.0},"180":{"tf":1.0},"183":{"tf":1.0},"184":{"tf":1.7320508075688772},"187":{"tf":1.0},"192":{"tf":1.0},"193":{"tf":1.0},"194":{"tf":2.6457513110645907},"195":{"tf":1.0},"203":{"tf":1.0},"207":{"tf":1.0},"208":{"tf":1.4142135623730951},"209":{"tf":1.0},"212":{"tf":1.0},"213":{"tf":1.7320508075688772},"22":{"tf":1.0},"220":{"tf":1.0},"221":{"tf":1.0},"225":{"tf":1.4142135623730951},"226":{"tf":1.4142135623730951},"230":{"tf":1.0},"38":{"tf":1.0},"89":{"tf":1.0},"92":{"tf":1.0},"95":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"206":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"c":{"'":{"df":1,"docs":{"150":{"tf":1.0}}},"(":{"1":{"0":{"2":{"4":{"df":1,"docs":{"128":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":5,"docs":{"128":{"tf":1.7320508075688772},"132":{"tf":1.0},"158":{"tf":1.0},"162":{"tf":1.0},"165":{"tf":1.0}}},"df":0,"docs":{}}}},"n":{"a":{"df":0,"docs":{},"g":{"df":9,"docs":{"158":{"tf":1.0},"159":{"tf":1.0},"164":{"tf":1.0},"165":{"tf":1.7320508075688772},"166":{"tf":1.4142135623730951},"167":{"tf":1.0},"177":{"tf":1.0},"206":{"tf":1.0},"227":{"tf":1.0}}}},"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"15":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":6,"docs":{"130":{"tf":1.0},"137":{"tf":1.0},"152":{"tf":1.4142135623730951},"158":{"tf":1.0},"159":{"tf":1.4142135623730951},"183":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"194":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"165":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"143":{"tf":1.0}}}}},"u":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"204":{"tf":1.0}}}}}}}},"df":7,"docs":{"114":{"tf":1.0},"115":{"tf":1.0},"126":{"tf":1.0},"158":{"tf":1.0},"209":{"tf":1.4142135623730951},"224":{"tf":1.4142135623730951},"225":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"p":{"df":8,"docs":{"113":{"tf":1.4142135623730951},"114":{"tf":1.7320508075688772},"151":{"tf":1.0},"159":{"tf":2.23606797749979},"162":{"tf":1.0},"163":{"tf":1.0},"166":{"tf":1.0},"167":{"tf":1.0}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"130":{"tf":1.0}}}}},"k":{"df":5,"docs":{"120":{"tf":1.0},"155":{"tf":1.7320508075688772},"157":{"tf":1.0},"158":{"tf":1.0},"216":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"224":{"tf":1.7320508075688772},"225":{"tf":1.4142135623730951}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":6,"docs":{"114":{"tf":1.0},"115":{"tf":1.0},"132":{"tf":1.0},"162":{"tf":1.4142135623730951},"164":{"tf":1.0},"178":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"139":{"tf":1.4142135623730951}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"150":{"tf":1.0},"157":{"tf":1.0},"211":{"tf":1.0},"220":{"tf":1.0},"222":{"tf":1.0}}}}}},"x":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"130":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"164":{"tf":1.0}}}}}}}},"b":{"df":1,"docs":{"117":{"tf":1.0}}},"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"192":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":7,"docs":{"17":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"n":{"df":30,"docs":{"130":{"tf":1.7320508075688772},"131":{"tf":1.4142135623730951},"132":{"tf":1.4142135623730951},"136":{"tf":1.0},"137":{"tf":2.23606797749979},"138":{"tf":1.0},"142":{"tf":1.7320508075688772},"145":{"tf":1.4142135623730951},"148":{"tf":1.0},"157":{"tf":1.4142135623730951},"158":{"tf":1.4142135623730951},"159":{"tf":2.0},"160":{"tf":1.4142135623730951},"162":{"tf":1.0},"164":{"tf":1.7320508075688772},"180":{"tf":1.0},"191":{"tf":1.0},"192":{"tf":1.4142135623730951},"194":{"tf":1.0},"203":{"tf":1.0},"204":{"tf":1.4142135623730951},"205":{"tf":1.0},"206":{"tf":1.7320508075688772},"208":{"tf":1.0},"220":{"tf":1.4142135623730951},"224":{"tf":1.0},"226":{"tf":1.0},"227":{"tf":1.0},"40":{"tf":1.0},"7":{"tf":1.0}},"t":{"df":2,"docs":{"138":{"tf":1.0},"30":{"tf":1.0}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"112":{"tf":2.0}}}}},"t":{"df":1,"docs":{"159":{"tf":1.0}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":2,"docs":{"145":{"tf":1.0},"150":{"tf":1.0}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"233":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":3,"docs":{"138":{"tf":1.4142135623730951},"153":{"tf":1.4142135623730951},"221":{"tf":1.0}}}},"g":{"a":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":1,"docs":{"193":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"m":{".":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{")":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"|":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":1,"docs":{"63":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"[":{"a":{"d":{"d":{"df":0,"docs":{},"r":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"214":{"tf":1.4142135623730951},"219":{"tf":1.0},"221":{"tf":1.4142135623730951},"231":{"tf":1.0},"234":{"tf":1.0}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"221":{"tf":1.0}}}}}}}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"128":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":1,"docs":{"63":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":35,"docs":{"0":{"tf":1.0},"110":{"tf":1.4142135623730951},"111":{"tf":1.0},"128":{"tf":1.7320508075688772},"132":{"tf":1.4142135623730951},"137":{"tf":1.7320508075688772},"140":{"tf":1.0},"141":{"tf":1.0},"142":{"tf":1.0},"143":{"tf":1.0},"144":{"tf":2.0},"145":{"tf":2.8284271247461903},"148":{"tf":2.0},"150":{"tf":1.7320508075688772},"151":{"tf":2.23606797749979},"158":{"tf":2.6457513110645907},"159":{"tf":2.0},"162":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":4.69041575982343},"165":{"tf":1.7320508075688772},"187":{"tf":1.0},"194":{"tf":1.4142135623730951},"216":{"tf":1.0},"47":{"tf":1.7320508075688772},"48":{"tf":1.4142135623730951},"49":{"tf":3.605551275463989},"57":{"tf":1.7320508075688772},"58":{"tf":1.4142135623730951},"63":{"tf":2.0},"74":{"tf":1.7320508075688772},"75":{"tf":1.4142135623730951},"76":{"tf":4.47213595499958},"81":{"tf":1.7320508075688772},"82":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"c":{"df":1,"docs":{"158":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"y":{"'":{"df":1,"docs":{"164":{"tf":1.0}}},"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"=":{"1":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},")":{"[":{"0":{"df":1,"docs":{"76":{"tf":1.0}},"x":{"1":{"0":{"0":{"0":{"df":1,"docs":{"76":{"tf":1.0}}},"2":{"df":1,"docs":{"76":{"tf":1.0}}},"3":{"df":1,"docs":{"76":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},".":{".":{".":{"\\":{"df":0,"docs":{},"n":{"df":1,"docs":{"76":{"tf":2.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"df":1,"docs":{"76":{"tf":1.0}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"194":{"tf":3.1622776601683795}}}}}},"r":{"df":1,"docs":{"49":{"tf":1.0}}},"s":{"df":2,"docs":{"48":{"tf":1.0},"75":{"tf":1.0}}},"w":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"48":{"tf":1.0},"75":{"tf":1.0}}}},"df":0,"docs":{}}},"2":{"df":2,"docs":{"49":{"tf":1.0},"76":{"tf":1.7320508075688772}}},"6":{"4":{"df":2,"docs":{"137":{"tf":1.0},"164":{"tf":1.0}}},"df":0,"docs":{}},":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":4,"docs":{"57":{"tf":1.0},"58":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":2,"docs":{"49":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951}},"e":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"5":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"151":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":1.0},"165":{"tf":1.0},"212":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"155":{"tf":1.4142135623730951}}}}}},"r":{"df":0,"docs":{},"g":{"df":12,"docs":{"115":{"tf":1.4142135623730951},"134":{"tf":1.4142135623730951},"138":{"tf":1.0},"190":{"tf":2.8284271247461903},"192":{"tf":1.4142135623730951},"208":{"tf":1.0},"213":{"tf":1.0},"214":{"tf":1.4142135623730951},"220":{"tf":2.0},"224":{"tf":2.23606797749979},"225":{"tf":1.7320508075688772},"226":{"tf":2.8284271247461903}},"e":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"206":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"224":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":17,"docs":{"13":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.0},"137":{"tf":1.0},"14":{"tf":1.0},"212":{"tf":1.7320508075688772},"220":{"tf":1.0},"224":{"tf":1.4142135623730951},"225":{"tf":1.0},"53":{"tf":1.4142135623730951},"70":{"tf":1.7320508075688772},"73":{"tf":1.7320508075688772},"76":{"tf":1.7320508075688772},"79":{"tf":1.7320508075688772},"83":{"tf":1.7320508075688772},"85":{"tf":1.7320508075688772},"88":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"t":{"a":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":7,"docs":{"162":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"35":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"217":{"tf":1.0},"33":{"tf":1.0}},"h":{"df":0,"docs":{},"o":{"d":{"df":12,"docs":{"114":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.0},"126":{"tf":1.0},"157":{"tf":2.0},"158":{"tf":1.4142135623730951},"164":{"tf":1.0},"166":{"tf":1.4142135623730951},"208":{"tf":1.0},"216":{"tf":1.4142135623730951},"66":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"206":{"tf":1.0}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"122":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"i":{"d":{"d":{"df":0,"docs":{},"l":{"df":2,"docs":{"144":{"tf":1.0},"203":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"27":{"tf":1.0}},"n":{"(":{"a":{"df":2,"docs":{"79":{"tf":1.0},"83":{"tf":1.0}}},"df":0,"docs":{}},"d":{"df":1,"docs":{"3":{"tf":1.0}}},"df":2,"docs":{"130":{"tf":1.0},"131":{"tf":1.0}},"i":{"df":0,"docs":{},"m":{"df":5,"docs":{"129":{"tf":1.4142135623730951},"130":{"tf":2.449489742783178},"131":{"tf":1.7320508075688772},"132":{"tf":2.0},"141":{"tf":1.0}},"u":{"df":0,"docs":{},"m":{"df":4,"docs":{"130":{"tf":1.0},"205":{"tf":1.0},"212":{"tf":1.0},"217":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"134":{"tf":1.4142135623730951},"138":{"tf":1.4142135623730951},"214":{"tf":1.0},"222":{"tf":1.0}}}},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"158":{"tf":1.0}}}}},"p":{"df":1,"docs":{"137":{"tf":1.0}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"184":{"tf":1.0}}}}}},"s":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"v":{"df":1,"docs":{"109":{"tf":1.0}}}},"df":0,"docs":{}}}},"c":{"df":2,"docs":{"137":{"tf":1.4142135623730951},"184":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":2,"docs":{"159":{"tf":1.0},"167":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"134":{"tf":1.0}}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"147":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"161":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":5,"docs":{"137":{"tf":1.4142135623730951},"153":{"tf":1.0},"91":{"tf":1.0},"94":{"tf":1.0},"97":{"tf":1.0}}},"t":{"a":{"df":0,"docs":{},"k":{"df":2,"docs":{"145":{"tf":1.0},"190":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":3,"docs":{"143":{"tf":1.0},"145":{"tf":1.7320508075688772},"148":{"tf":2.449489742783178}}}}},"x":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"[":{":":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"106":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"k":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":9,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0},"99":{"tf":1.0}}}}},"df":0,"docs":{}},"m":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"164":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"d":{"df":3,"docs":{"103":{"tf":1.4142135623730951},"183":{"tf":1.0},"96":{"tf":1.0}},"e":{"df":8,"docs":{"130":{"tf":2.0},"132":{"tf":1.7320508075688772},"140":{"tf":1.7320508075688772},"141":{"tf":1.0},"142":{"tf":1.0},"158":{"tf":1.0},"164":{"tf":1.0},"191":{"tf":1.0}},"l":{"=":{"df":0,"docs":{},"i":{"df":1,"docs":{"218":{"tf":1.0}}}},"df":5,"docs":{"0":{"tf":1.7320508075688772},"137":{"tf":1.4142135623730951},"142":{"tf":1.0},"146":{"tf":1.4142135623730951},"192":{"tf":1.0}}}},"i":{"df":0,"docs":{},"f":{"df":4,"docs":{"206":{"tf":1.0},"208":{"tf":1.0},"25":{"tf":1.4142135623730951},"34":{"tf":1.0}},"i":{"df":6,"docs":{"158":{"tf":1.0},"178":{"tf":1.0},"184":{"tf":1.0},"185":{"tf":1.0},"190":{"tf":1.0},"208":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"l":{"df":87,"docs":{"1":{"tf":1.4142135623730951},"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.4142135623730951},"103":{"tf":1.7320508075688772},"105":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"11":{"tf":2.0},"111":{"tf":1.7320508075688772},"112":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"117":{"tf":1.0},"119":{"tf":1.0},"122":{"tf":1.0},"126":{"tf":1.0},"128":{"tf":1.7320508075688772},"131":{"tf":1.7320508075688772},"140":{"tf":1.7320508075688772},"142":{"tf":1.0},"157":{"tf":1.0},"158":{"tf":3.4641016151377544},"159":{"tf":4.242640687119285},"160":{"tf":2.23606797749979},"161":{"tf":2.449489742783178},"162":{"tf":3.0},"167":{"tf":1.4142135623730951},"183":{"tf":1.7320508075688772},"194":{"tf":1.0},"204":{"tf":1.4142135623730951},"217":{"tf":1.0},"218":{"tf":1.7320508075688772},"35":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":2.449489742783178},"40":{"tf":2.8284271247461903},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":3.4641016151377544},"45":{"tf":1.0},"46":{"tf":2.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":2.23606797749979},"50":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":2.449489742783178},"54":{"tf":1.0},"55":{"tf":3.0},"56":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"58":{"tf":1.0},"59":{"tf":2.23606797749979},"60":{"tf":1.0},"61":{"tf":1.4142135623730951},"63":{"tf":2.23606797749979},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":2.23606797749979},"68":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":2.23606797749979},"70":{"tf":3.0},"72":{"tf":1.0},"73":{"tf":2.6457513110645907},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":2.23606797749979},"77":{"tf":1.0},"79":{"tf":3.0},"80":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"82":{"tf":1.0},"83":{"tf":1.7320508075688772},"84":{"tf":1.0},"85":{"tf":2.23606797749979},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":2.23606797749979},"89":{"tf":2.0},"9":{"tf":1.0},"90":{"tf":2.6457513110645907},"92":{"tf":1.4142135623730951},"93":{"tf":2.0},"95":{"tf":1.7320508075688772},"96":{"tf":2.23606797749979},"99":{"tf":1.4142135623730951}},"e":{"!":{"\\":{"df":0,"docs":{},"n":{"df":7,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.4142135623730951},"88":{"tf":1.0}}}},"df":0,"docs":{}},"'":{"df":2,"docs":{"158":{"tf":1.0},"159":{"tf":1.0}}},".":{".":{".":{"\\":{"df":0,"docs":{},"n":{"df":4,"docs":{"70":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"85":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"90":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"93":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}}}}}}}}},"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"140":{"tf":1.0}}}}}}}},"df":0,"docs":{}},":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"185":{"tf":1.0}},"e":{"(":{"&":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":8,"docs":{"39":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0},"59":{"tf":1.4142135623730951},"61":{"tf":1.0},"66":{"tf":1.0}}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"46":{"tf":1.0},"49":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"&":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"39":{"tf":1.0},"40":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"63":{"tf":1.0}}}}}},"df":0,"docs":{}},"_":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"162":{"tf":1.0}}}}}}}}}}},"o":{"df":1,"docs":{"157":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"o":{"df":3,"docs":{"114":{"tf":1.0},"115":{"tf":1.7320508075688772},"117":{"tf":1.0}}},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"134":{"tf":1.7320508075688772},"138":{"tf":1.0},"224":{"tf":2.449489742783178}}}}},"r":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"191":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":49,"docs":{"0":{"tf":1.7320508075688772},"1":{"tf":1.0},"104":{"tf":1.7320508075688772},"107":{"tf":1.4142135623730951},"111":{"tf":1.0},"113":{"tf":1.0},"116":{"tf":1.4142135623730951},"118":{"tf":1.0},"13":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.7320508075688772},"133":{"tf":1.0},"137":{"tf":1.4142135623730951},"138":{"tf":2.0},"139":{"tf":1.4142135623730951},"147":{"tf":1.0},"148":{"tf":1.0},"152":{"tf":1.0},"153":{"tf":1.4142135623730951},"156":{"tf":1.0},"158":{"tf":1.7320508075688772},"159":{"tf":1.0},"165":{"tf":1.0},"183":{"tf":1.4142135623730951},"187":{"tf":1.0},"188":{"tf":1.4142135623730951},"191":{"tf":1.4142135623730951},"202":{"tf":1.0},"203":{"tf":1.0},"208":{"tf":1.4142135623730951},"213":{"tf":1.0},"221":{"tf":1.0},"222":{"tf":1.4142135623730951},"225":{"tf":1.4142135623730951},"228":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"34":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"55":{"tf":1.0},"6":{"tf":1.0},"66":{"tf":1.0},"8":{"tf":1.0},"91":{"tf":1.4142135623730951},"94":{"tf":1.4142135623730951},"97":{"tf":1.4142135623730951}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":4,"docs":{"109":{"tf":1.0},"111":{"tf":1.4142135623730951},"62":{"tf":1.0},"63":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"190":{"tf":1.0},"191":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"226":{"tf":1.0}}}},"v":{"df":1,"docs":{"217":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":5,"docs":{"137":{"tf":1.0},"164":{"tf":1.0},"166":{"tf":1.0},"222":{"tf":1.0},"43":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"2":{"tf":1.0}}},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"205":{"tf":1.0}}}},"v":{"c":{"df":1,"docs":{"137":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"34":{"tf":1.4142135623730951}}}}}},"u":{"c":{"df":0,"docs":{},"h":{"df":12,"docs":{"130":{"tf":1.4142135623730951},"131":{"tf":2.0},"138":{"tf":1.0},"141":{"tf":1.0},"158":{"tf":1.0},"162":{"tf":1.0},"183":{"tf":1.0},"194":{"tf":1.0},"209":{"tf":1.4142135623730951},"220":{"tf":1.0},"222":{"tf":1.0},"224":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{".":{"c":{"df":1,"docs":{"88":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":1,"docs":{"66":{"tf":1.0}}},"w":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"65":{"tf":1.0},"87":{"tf":1.0}}}},"df":0,"docs":{}}},"df":5,"docs":{"137":{"tf":1.4142135623730951},"64":{"tf":1.4142135623730951},"66":{"tf":1.7320508075688772},"86":{"tf":1.4142135623730951},"88":{"tf":1.7320508075688772}},"p":{"df":0,"docs":{},"l":{"df":9,"docs":{"124":{"tf":1.0},"127":{"tf":1.0},"130":{"tf":1.0},"144":{"tf":1.0},"158":{"tf":1.0},"211":{"tf":1.0},"212":{"tf":1.0},"216":{"tf":1.0},"66":{"tf":1.7320508075688772}},"i":{"df":1,"docs":{"40":{"tf":1.0}}}}}}}},"n":{"d":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"225":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"l":{"df":1,"docs":{"137":{"tf":1.4142135623730951}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"137":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":4,"docs":{"158":{"tf":1.0},"194":{"tf":1.0},"63":{"tf":1.0},"76":{"tf":1.0}}}},"df":14,"docs":{"158":{"tf":1.4142135623730951},"165":{"tf":1.4142135623730951},"39":{"tf":1.0},"40":{"tf":2.0},"43":{"tf":1.7320508075688772},"46":{"tf":1.0},"49":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"53":{"tf":2.23606797749979},"55":{"tf":1.7320508075688772},"59":{"tf":1.7320508075688772},"61":{"tf":1.0},"63":{"tf":2.0},"66":{"tf":1.4142135623730951}}}},"v":{"df":0,"docs":{},"p":{"df":1,"docs":{"162":{"tf":1.0}}}},"y":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"185":{"tf":1.0}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"43":{"tf":2.23606797749979},"53":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}},"n":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":1,"docs":{"115":{"tf":1.0}}}}},"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":14,"docs":{"113":{"tf":1.0},"114":{"tf":1.4142135623730951},"115":{"tf":1.4142135623730951},"116":{"tf":1.0},"13":{"tf":1.0},"185":{"tf":1.4142135623730951},"195":{"tf":1.0},"221":{"tf":1.0},"222":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"70":{"tf":1.0},"8":{"tf":1.0}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"146":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"g":{"df":3,"docs":{"70":{"tf":1.0},"76":{"tf":2.449489742783178},"88":{"tf":1.4142135623730951}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"211":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"230":{"tf":1.0}}}},"v":{"df":15,"docs":{"103":{"tf":1.0},"106":{"tf":1.0},"110":{"tf":1.0},"112":{"tf":2.23606797749979},"128":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.0},"158":{"tf":1.4142135623730951},"160":{"tf":1.0},"163":{"tf":1.0},"167":{"tf":1.0},"60":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0},"84":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"130":{"tf":1.0},"163":{"tf":1.0}}}}}},"df":3,"docs":{"117":{"tf":1.7320508075688772},"122":{"tf":1.7320508075688772},"88":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"220":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"127":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"157":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":9,"docs":{"131":{"tf":1.0},"132":{"tf":1.0},"138":{"tf":1.0},"143":{"tf":1.0},"145":{"tf":1.0},"158":{"tf":1.0},"193":{"tf":1.0},"224":{"tf":1.0},"225":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"138":{"tf":1.0},"155":{"tf":1.0},"221":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":56,"docs":{"110":{"tf":1.0},"111":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.7320508075688772},"116":{"tf":1.0},"125":{"tf":1.0},"126":{"tf":1.0},"130":{"tf":1.7320508075688772},"132":{"tf":1.4142135623730951},"138":{"tf":1.4142135623730951},"141":{"tf":1.4142135623730951},"142":{"tf":1.4142135623730951},"147":{"tf":1.0},"154":{"tf":1.4142135623730951},"159":{"tf":1.0},"162":{"tf":1.7320508075688772},"163":{"tf":1.0},"164":{"tf":1.4142135623730951},"165":{"tf":1.0},"166":{"tf":1.0},"169":{"tf":1.0},"172":{"tf":1.0},"175":{"tf":1.0},"177":{"tf":1.0},"178":{"tf":1.0},"179":{"tf":1.0},"180":{"tf":1.0},"184":{"tf":1.0},"185":{"tf":1.7320508075688772},"188":{"tf":1.0},"190":{"tf":1.0},"192":{"tf":1.0},"193":{"tf":1.0},"194":{"tf":1.7320508075688772},"195":{"tf":1.0},"197":{"tf":1.0},"198":{"tf":1.0},"212":{"tf":1.7320508075688772},"213":{"tf":1.4142135623730951},"220":{"tf":1.0},"222":{"tf":1.7320508075688772},"224":{"tf":1.0},"225":{"tf":1.4142135623730951},"226":{"tf":1.0},"227":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.4142135623730951},"43":{"tf":1.0},"61":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.7320508075688772},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0}}},"df":0,"docs":{}},"f":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"209":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"b":{"df":0,"docs":{},"s":{"d":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"b":{"df":0,"docs":{},"s":{"d":{"df":1,"docs":{"137":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":5,"docs":{"216":{"tf":1.0},"36":{"tf":1.0},"92":{"tf":1.4142135623730951},"93":{"tf":1.7320508075688772},"94":{"tf":1.0}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":2,"docs":{"0":{"tf":1.0},"192":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"145":{"tf":1.0},"150":{"tf":1.4142135623730951},"164":{"tf":1.4142135623730951},"203":{"tf":1.0},"209":{"tf":1.0}}}}},"w":{"df":35,"docs":{"10":{"tf":1.4142135623730951},"114":{"tf":1.0},"115":{"tf":1.0},"126":{"tf":1.0},"134":{"tf":1.4142135623730951},"136":{"tf":1.0},"138":{"tf":2.449489742783178},"14":{"tf":1.4142135623730951},"140":{"tf":1.0},"154":{"tf":1.0},"159":{"tf":1.4142135623730951},"176":{"tf":1.0},"18":{"tf":1.0},"180":{"tf":1.0},"182":{"tf":1.0},"183":{"tf":1.0},"184":{"tf":2.23606797749979},"185":{"tf":1.4142135623730951},"190":{"tf":1.0},"204":{"tf":1.4142135623730951},"206":{"tf":2.0},"207":{"tf":2.0},"209":{"tf":1.0},"21":{"tf":1.0},"212":{"tf":1.4142135623730951},"213":{"tf":1.4142135623730951},"216":{"tf":2.23606797749979},"218":{"tf":1.4142135623730951},"224":{"tf":1.0},"31":{"tf":1.0},"39":{"tf":1.0},"83":{"tf":1.0},"93":{"tf":2.0},"96":{"tf":1.0},"99":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"102":{"tf":1.0},"125":{"tf":1.4142135623730951},"89":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"221":{"tf":1.0}}}}},"x":{"df":0,"docs":{},"t":{"df":25,"docs":{"103":{"tf":1.0},"111":{"tf":1.0},"115":{"tf":1.0},"130":{"tf":2.6457513110645907},"138":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.7320508075688772},"164":{"tf":1.0},"197":{"tf":1.0},"224":{"tf":1.0},"226":{"tf":1.0},"39":{"tf":1.4142135623730951},"40":{"tf":1.0},"43":{"tf":1.0},"59":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.4142135623730951},"99":{"tf":1.0}}}}},"f":{"df":1,"docs":{"14":{"tf":1.0}}},"i":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"157":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"130":{"tf":3.1622776601683795},"132":{"tf":1.0},"205":{"tf":1.7320508075688772}}}}}}},"l":{"df":1,"docs":{"96":{"tf":1.0}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"158":{"tf":1.0},"164":{"tf":1.0}}}}}},"n":{"df":1,"docs":{"137":{"tf":1.0}}},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":2,"docs":{"137":{"tf":1.0},"142":{"tf":2.0}}},"df":0,"docs":{}}}},"b":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"221":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"204":{"tf":1.0}}}}},"n":{"df":7,"docs":{"128":{"tf":1.0},"137":{"tf":1.4142135623730951},"151":{"tf":1.0},"158":{"tf":1.0},"178":{"tf":1.0},"194":{"tf":1.7320508075688772},"195":{"tf":1.0}},"e":{"df":2,"docs":{"15":{"tf":1.0},"199":{"tf":1.0}}},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"137":{"tf":1.0}}}},"df":0,"docs":{}}},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"63":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"200":{"tf":1.0},"3":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":4,"docs":{"130":{"tf":1.0},"138":{"tf":1.0},"142":{"tf":1.4142135623730951},"183":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":47,"docs":{"111":{"tf":1.4142135623730951},"114":{"tf":1.0},"115":{"tf":1.0},"117":{"tf":1.0},"120":{"tf":1.0},"126":{"tf":1.0},"130":{"tf":3.1622776601683795},"131":{"tf":1.0},"134":{"tf":1.4142135623730951},"135":{"tf":1.0},"137":{"tf":1.0},"138":{"tf":1.0},"142":{"tf":1.0},"151":{"tf":1.0},"159":{"tf":1.7320508075688772},"160":{"tf":1.4142135623730951},"162":{"tf":1.0},"163":{"tf":2.0},"164":{"tf":1.4142135623730951},"166":{"tf":1.0},"167":{"tf":1.0},"178":{"tf":1.0},"180":{"tf":1.0},"181":{"tf":1.0},"190":{"tf":1.0},"194":{"tf":1.0},"2":{"tf":1.0},"206":{"tf":1.4142135623730951},"208":{"tf":1.4142135623730951},"209":{"tf":1.4142135623730951},"212":{"tf":1.0},"225":{"tf":1.0},"226":{"tf":1.7320508075688772},"227":{"tf":2.23606797749979},"229":{"tf":1.0},"39":{"tf":1.4142135623730951},"40":{"tf":1.7320508075688772},"43":{"tf":1.4142135623730951},"55":{"tf":1.0},"66":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":2.23606797749979},"73":{"tf":1.0},"76":{"tf":1.4142135623730951},"79":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.4142135623730951}}},"h":{"df":3,"docs":{"146":{"tf":1.0},"158":{"tf":1.0},"209":{"tf":1.0}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":3,"docs":{"138":{"tf":1.4142135623730951},"21":{"tf":1.0},"31":{"tf":1.0}}}}}},"w":{"df":15,"docs":{"103":{"tf":1.0},"111":{"tf":1.0},"117":{"tf":1.0},"132":{"tf":1.0},"147":{"tf":1.0},"158":{"tf":1.0},"2":{"tf":1.0},"200":{"tf":1.0},"216":{"tf":1.0},"3":{"tf":1.0},"39":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"70":{"tf":1.7320508075688772},"81":{"tf":1.4142135623730951},"83":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"70":{"tf":1.0},"88":{"tf":1.4142135623730951}}}}}}}},"u":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"164":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":3,"docs":{"92":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"l":{"df":7,"docs":{"70":{"tf":4.795831523312719},"73":{"tf":4.0},"76":{"tf":5.196152422706632},"79":{"tf":4.47213595499958},"83":{"tf":5.291502622129181},"85":{"tf":3.3166247903554},"88":{"tf":4.0}}}},"m":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}}}}}}}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":31,"docs":{"0":{"tf":1.7320508075688772},"101":{"tf":1.0},"103":{"tf":1.0},"106":{"tf":1.0},"116":{"tf":1.0},"130":{"tf":2.23606797749979},"132":{"tf":1.0},"135":{"tf":1.0},"139":{"tf":1.0},"145":{"tf":1.0},"159":{"tf":1.4142135623730951},"164":{"tf":1.4142135623730951},"170":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":1.0},"52":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"6":{"tf":1.0},"63":{"tf":1.4142135623730951},"71":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0},"99":{"tf":1.0}}}}},"df":1,"docs":{"101":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"204":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"58":{"tf":1.0},"82":{"tf":1.0}}}}}}}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":1,"docs":{"167":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"t":{"df":6,"docs":{"130":{"tf":1.0},"158":{"tf":2.23606797749979},"159":{"tf":1.4142135623730951},"165":{"tf":1.0},"166":{"tf":1.0},"49":{"tf":1.0}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"234":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":3,"docs":{"128":{"tf":1.0},"187":{"tf":1.0},"85":{"tf":1.0}}}}}}},"c":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.0}}}},"r":{"df":3,"docs":{"163":{"tf":1.0},"194":{"tf":1.0},"208":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"130":{"tf":3.4641016151377544}}}},"df":11,"docs":{"110":{"tf":1.7320508075688772},"111":{"tf":1.0},"117":{"tf":1.0},"128":{"tf":1.0},"218":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"232":{"tf":1.0}}}},"r":{"df":2,"docs":{"143":{"tf":1.0},"37":{"tf":1.0}}}},"i":{"c":{"df":0,"docs":{},"i":{"df":4,"docs":{"0":{"tf":1.0},"224":{"tf":1.0},"233":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"233":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"=":{"4":{"df":2,"docs":{"58":{"tf":1.0},"82":{"tf":1.0}}},"df":0,"docs":{}},"df":7,"docs":{"144":{"tf":1.0},"145":{"tf":1.7320508075688772},"159":{"tf":1.0},"164":{"tf":1.0},"165":{"tf":1.0},"57":{"tf":1.7320508075688772},"81":{"tf":1.7320508075688772}}}}}}},"k":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"!":{"(":{"\"":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"49":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"213":{"tf":1.0}}}},"df":25,"docs":{"106":{"tf":1.4142135623730951},"138":{"tf":1.0},"183":{"tf":1.0},"207":{"tf":1.0},"208":{"tf":1.0},"209":{"tf":1.0},"226":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"59":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.4142135623730951},"66":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":2.23606797749979},"83":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}},"l":{"d":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"76":{"tf":2.0}}}}}},"df":2,"docs":{"192":{"tf":1.0},"212":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"225":{"tf":1.0},"226":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"25":{"tf":1.0}}}}}},"df":0,"docs":{}},"n":{"c":{"df":15,"docs":{"114":{"tf":1.0},"115":{"tf":1.0},"126":{"tf":1.0},"134":{"tf":1.4142135623730951},"155":{"tf":1.0},"158":{"tf":1.4142135623730951},"162":{"tf":1.0},"163":{"tf":1.4142135623730951},"184":{"tf":1.0},"190":{"tf":1.0},"207":{"tf":1.0},"213":{"tf":1.0},"218":{"tf":1.0},"224":{"tf":1.7320508075688772},"43":{"tf":1.0}}},"df":46,"docs":{"112":{"tf":1.0},"113":{"tf":1.7320508075688772},"114":{"tf":1.0},"115":{"tf":1.0},"125":{"tf":1.0},"13":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":2.0},"138":{"tf":1.4142135623730951},"140":{"tf":1.0},"143":{"tf":1.0},"158":{"tf":1.4142135623730951},"159":{"tf":1.4142135623730951},"161":{"tf":1.4142135623730951},"164":{"tf":1.0},"166":{"tf":1.0},"167":{"tf":1.0},"183":{"tf":1.4142135623730951},"184":{"tf":1.0},"185":{"tf":1.0},"187":{"tf":1.0},"188":{"tf":1.0},"191":{"tf":1.0},"195":{"tf":1.0},"20":{"tf":1.0},"205":{"tf":1.0},"206":{"tf":1.0},"208":{"tf":1.0},"210":{"tf":1.0},"212":{"tf":1.4142135623730951},"213":{"tf":1.4142135623730951},"214":{"tf":1.0},"216":{"tf":1.4142135623730951},"217":{"tf":1.0},"220":{"tf":1.7320508075688772},"222":{"tf":1.0},"224":{"tf":1.0},"226":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"38":{"tf":1.0},"39":{"tf":1.0},"43":{"tf":1.4142135623730951},"49":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"209":{"tf":1.0}}}},"g":{"df":0,"docs":{},"o":{"df":2,"docs":{"148":{"tf":1.0},"157":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":20,"docs":{"202":{"tf":1.0},"209":{"tf":1.0},"233":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.0},"50":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.0},"80":{"tf":1.0},"84":{"tf":1.0},"86":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"158":{"tf":1.0}}}}},"p":{"c":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"158":{"tf":1.0},"161":{"tf":1.0}}},"df":0,"docs":{}}},"df":2,"docs":{"137":{"tf":1.0},"187":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":20,"docs":{"104":{"tf":1.0},"107":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.0},"126":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.0},"153":{"tf":1.0},"210":{"tf":1.0},"211":{"tf":1.0},"217":{"tf":1.0},"220":{"tf":1.0},"221":{"tf":1.0},"222":{"tf":1.0},"224":{"tf":1.7320508075688772},"230":{"tf":1.0},"85":{"tf":1.0},"91":{"tf":1.0},"94":{"tf":1.0},"97":{"tf":1.0}}},"r":{"df":12,"docs":{"0":{"tf":1.0},"110":{"tf":1.0},"112":{"tf":1.0},"128":{"tf":1.0},"132":{"tf":1.0},"140":{"tf":1.0},"142":{"tf":1.0},"150":{"tf":1.0},"158":{"tf":1.7320508075688772},"163":{"tf":1.0},"216":{"tf":1.0},"217":{"tf":1.0}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":3,"docs":{"130":{"tf":1.0},"134":{"tf":1.0},"152":{"tf":1.0}}}}}},"s":{"df":2,"docs":{"130":{"tf":1.0},"206":{"tf":1.0}}}}},"t":{"/":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"128":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":3,"docs":{"110":{"tf":1.4142135623730951},"122":{"tf":1.4142135623730951},"204":{"tf":1.0}},"i":{"df":0,"docs":{},"m":{"df":10,"docs":{"0":{"tf":1.0},"129":{"tf":1.0},"130":{"tf":3.3166247903554},"173":{"tf":1.0},"187":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.4142135623730951},"33":{"tf":2.0},"39":{"tf":1.0}}},"o":{"df":0,"docs":{},"n":{"df":14,"docs":{"1":{"tf":1.0},"118":{"tf":1.4142135623730951},"12":{"tf":1.0},"13":{"tf":1.0},"130":{"tf":1.7320508075688772},"14":{"tf":1.4142135623730951},"164":{"tf":1.0},"167":{"tf":1.0},"172":{"tf":1.0},"2":{"tf":1.0},"206":{"tf":1.0},"212":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"l":{"df":3,"docs":{"187":{"tf":2.449489742783178},"188":{"tf":1.0},"216":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"3":{"tf":1.0}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"212":{"tf":1.0}}}}},"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"n":{"df":4,"docs":{"189":{"tf":1.0},"206":{"tf":1.4142135623730951},"213":{"tf":1.0},"5":{"tf":1.0}},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"229":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"230":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":10,"docs":{"134":{"tf":1.0},"150":{"tf":1.0},"163":{"tf":1.0},"193":{"tf":1.0},"194":{"tf":2.0},"225":{"tf":1.0},"43":{"tf":1.0},"76":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}}}}}},"s":{"df":3,"docs":{"139":{"tf":1.0},"142":{"tf":1.0},"195":{"tf":1.0}},"s":{"df":1,"docs":{"191":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"214":{"tf":1.0},"223":{"tf":1.0},"231":{"tf":1.0}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":13,"docs":{"115":{"tf":1.0},"130":{"tf":1.0},"138":{"tf":2.23606797749979},"158":{"tf":1.0},"164":{"tf":1.0},"190":{"tf":1.0},"194":{"tf":1.0},"203":{"tf":1.0},"207":{"tf":1.0},"208":{"tf":1.0},"224":{"tf":1.4142135623730951},"234":{"tf":1.0},"25":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":5,"docs":{"206":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0}}}}}}},"t":{"df":29,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"104":{"tf":1.0},"107":{"tf":1.0},"130":{"tf":1.7320508075688772},"131":{"tf":1.0},"132":{"tf":1.4142135623730951},"137":{"tf":1.0},"138":{"tf":1.0},"139":{"tf":1.0},"140":{"tf":1.0},"148":{"tf":1.0},"150":{"tf":1.0},"151":{"tf":1.7320508075688772},"158":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":1.4142135623730951},"164":{"tf":1.4142135623730951},"180":{"tf":1.4142135623730951},"193":{"tf":1.0},"194":{"tf":1.4142135623730951},"199":{"tf":1.0},"2":{"tf":1.0},"204":{"tf":1.0},"208":{"tf":1.0},"226":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":1.0},"49":{"tf":1.7320508075688772}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"138":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":10,"docs":{"103":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"115":{"tf":1.0},"117":{"tf":1.7320508075688772},"123":{"tf":1.0},"147":{"tf":1.7320508075688772},"159":{"tf":1.0},"90":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951},"96":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":6,"docs":{"0":{"tf":1.0},"144":{"tf":1.4142135623730951},"151":{"tf":1.0},"159":{"tf":1.0},"208":{"tf":1.0},"91":{"tf":1.0}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":17,"docs":{"0":{"tf":1.0},"102":{"tf":1.0},"105":{"tf":1.0},"130":{"tf":1.0},"136":{"tf":1.0},"138":{"tf":1.4142135623730951},"151":{"tf":1.0},"159":{"tf":1.4142135623730951},"163":{"tf":1.4142135623730951},"164":{"tf":1.0},"183":{"tf":1.0},"203":{"tf":1.0},"216":{"tf":1.0},"220":{"tf":1.0},"89":{"tf":1.0},"92":{"tf":1.0},"95":{"tf":1.0}},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"145":{"tf":1.0},"158":{"tf":1.0}}}}}},"h":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"138":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"166":{"tf":1.7320508075688772}}}},"r":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"54":{"tf":1.0}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":3,"docs":{"139":{"tf":1.0},"156":{"tf":1.0},"159":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"208":{"tf":1.0}}}}}}}}},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"158":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"137":{"tf":1.0},"138":{"tf":1.4142135623730951},"221":{"tf":1.0}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":9,"docs":{"105":{"tf":1.0},"195":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.4142135623730951},"94":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0}},"e":{"'":{"df":1,"docs":{"90":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"d":{"df":1,"docs":{"130":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":11,"docs":{"111":{"tf":1.0},"134":{"tf":1.0},"139":{"tf":1.0},"140":{"tf":1.0},"145":{"tf":1.7320508075688772},"148":{"tf":1.0},"150":{"tf":1.0},"164":{"tf":2.0},"192":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0}}}},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"43":{"tf":1.0}}}},"n":{"df":0,"docs":{},"i":{"c":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"96":{"tf":1.0}}}}}},"=":{"a":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"130":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"130":{"tf":1.4142135623730951},"151":{"tf":1.0}},"k":{"df":1,"docs":{"111":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"222":{"tf":1.0}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":2,"docs":{"137":{"tf":1.0},"159":{"tf":1.4142135623730951}}}}}},"m":{"df":19,"docs":{"100":{"tf":1.0},"103":{"tf":1.0},"106":{"tf":1.0},"40":{"tf":2.8284271247461903},"45":{"tf":1.0},"48":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"58":{"tf":1.7320508075688772},"65":{"tf":1.7320508075688772},"72":{"tf":1.0},"73":{"tf":1.0},"75":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"82":{"tf":1.7320508075688772},"85":{"tf":1.0},"87":{"tf":1.7320508075688772},"90":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0}},"e":{"df":0,"docs":{},"t":{"df":3,"docs":{"124":{"tf":1.0},"43":{"tf":1.4142135623730951},"66":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"160":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"150":{"tf":1.0}}}}}},"s":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"160":{"tf":1.0}}}}}}}}},"[":{"0":{"]":{".":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"73":{"tf":1.0},"85":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"i":{"3":{"2":{"df":2,"docs":{"73":{"tf":1.0},"85":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"]":{".":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"85":{"tf":1.0}}},"2":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"s":{"df":10,"docs":{"131":{"tf":1.4142135623730951},"159":{"tf":2.0},"39":{"tf":1.0},"46":{"tf":1.0},"70":{"tf":1.4142135623730951},"73":{"tf":1.7320508075688772},"76":{"tf":1.7320508075688772},"79":{"tf":1.0},"83":{"tf":1.7320508075688772},"88":{"tf":1.7320508075688772}}},"t":{"df":11,"docs":{"1":{"tf":1.0},"137":{"tf":1.0},"138":{"tf":1.4142135623730951},"162":{"tf":1.0},"166":{"tf":1.0},"180":{"tf":1.0},"185":{"tf":1.4142135623730951},"192":{"tf":1.0},"201":{"tf":1.0},"208":{"tf":1.0},"226":{"tf":1.0}},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"138":{"tf":1.0}}}},"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":2,"docs":{"230":{"tf":1.0},"231":{"tf":1.0}}}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":11,"docs":{"130":{"tf":1.0},"131":{"tf":1.0},"138":{"tf":1.4142135623730951},"159":{"tf":1.0},"179":{"tf":1.0},"185":{"tf":1.0},"188":{"tf":1.0},"194":{"tf":1.0},"216":{"tf":1.0},"221":{"tf":1.4142135623730951},"33":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"151":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"206":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"s":{"df":25,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.4142135623730951},"116":{"tf":1.0},"119":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":1.0},"126":{"tf":1.0},"127":{"tf":1.0},"130":{"tf":1.0},"132":{"tf":1.0},"138":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.0},"160":{"tf":1.0},"180":{"tf":1.7320508075688772},"185":{"tf":1.0},"204":{"tf":1.0},"21":{"tf":1.0},"216":{"tf":1.0},"217":{"tf":1.0},"224":{"tf":1.4142135623730951},"62":{"tf":1.0},"63":{"tf":1.0}}},"t":{"df":1,"docs":{"150":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":7,"docs":{"134":{"tf":2.6457513110645907},"135":{"tf":1.0},"138":{"tf":1.0},"184":{"tf":1.0},"222":{"tf":1.0},"225":{"tf":2.8284271247461903},"226":{"tf":3.3166247903554}}}},"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"124":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"218":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"124":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":12,"docs":{"10":{"tf":1.0},"122":{"tf":1.4142135623730951},"127":{"tf":1.0},"138":{"tf":1.7320508075688772},"158":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"185":{"tf":1.0},"194":{"tf":1.0},"195":{"tf":1.0},"2":{"tf":1.0},"217":{"tf":1.0},"221":{"tf":1.0}}}},"y":{"df":1,"docs":{"212":{"tf":1.0}}}},"c":{"df":1,"docs":{"137":{"tf":1.7320508075688772}}},"df":19,"docs":{"110":{"tf":1.4142135623730951},"128":{"tf":1.7320508075688772},"17":{"tf":1.0},"175":{"tf":1.7320508075688772},"178":{"tf":1.4142135623730951},"179":{"tf":1.7320508075688772},"181":{"tf":1.4142135623730951},"20":{"tf":1.0},"218":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"61":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0},"99":{"tf":1.0}},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":4,"docs":{"152":{"tf":1.0},"155":{"tf":1.4142135623730951},"220":{"tf":1.4142135623730951},"222":{"tf":1.0}}}}},"r":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"28":{"tf":1.7320508075688772},"29":{"tf":1.7320508075688772},"34":{"tf":1.4142135623730951}}}}}},"df":11,"docs":{"114":{"tf":1.0},"115":{"tf":1.0},"13":{"tf":1.0},"139":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":2.0},"164":{"tf":1.0},"183":{"tf":1.0},"203":{"tf":1.0},"204":{"tf":1.4142135623730951},"226":{"tf":1.0}},"f":{".":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":3,"docs":{"114":{"tf":1.7320508075688772},"115":{"tf":2.0},"117":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"j":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{".":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":2,"docs":{"115":{"tf":2.0},"117":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":7,"docs":{"112":{"tf":1.0},"113":{"tf":2.0},"114":{"tf":2.8284271247461903},"115":{"tf":3.0},"116":{"tf":2.0},"117":{"tf":3.605551275463989},"120":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"194":{"tf":1.0}}}},"df":0,"docs":{}},"m":{"a":{"df":0,"docs":{},"p":{"df":4,"docs":{"113":{"tf":1.0},"114":{"tf":1.7320508075688772},"125":{"tf":1.0},"126":{"tf":2.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":24,"docs":{"112":{"tf":2.23606797749979},"114":{"tf":1.0},"115":{"tf":1.0},"118":{"tf":1.0},"126":{"tf":1.4142135623730951},"131":{"tf":1.0},"138":{"tf":1.0},"142":{"tf":1.0},"143":{"tf":1.0},"148":{"tf":1.0},"150":{"tf":1.0},"158":{"tf":1.0},"162":{"tf":1.0},"164":{"tf":1.0},"166":{"tf":1.0},"190":{"tf":1.0},"207":{"tf":1.0},"220":{"tf":1.0},"223":{"tf":1.0},"224":{"tf":1.0},"225":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"59":{"tf":1.0}}}}}},"h":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"166":{"tf":1.0},"205":{"tf":1.0}}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"n":{"df":2,"docs":{"232":{"tf":1.0},"234":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"231":{"tf":1.0}}}},"t":{"df":1,"docs":{"144":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"206":{"tf":1.0},"230":{"tf":1.0},"231":{"tf":1.0}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"158":{"tf":1.0}}}},"df":0,"docs":{}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"229":{"tf":1.0}}}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":5,"docs":{"138":{"tf":1.0},"159":{"tf":1.4142135623730951},"217":{"tf":1.0},"222":{"tf":1.7320508075688772},"43":{"tf":1.0}}}}},"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"231":{"tf":1.0},"27":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"115":{"tf":1.0},"116":{"tf":1.0}},"i":{"df":1,"docs":{"213":{"tf":1.0}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"112":{"tf":1.0},"30":{"tf":1.0}}}}}},"d":{"df":1,"docs":{"106":{"tf":1.0}}},"df":1,"docs":{"27":{"tf":1.0}},"e":{"c":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"n":{"df":1,"docs":{"205":{"tf":1.0}}},"p":{"df":1,"docs":{"90":{"tf":1.4142135623730951}},"e":{"df":1,"docs":{"188":{"tf":1.0}},"n":{"df":0,"docs":{},"v":{"df":1,"docs":{"90":{"tf":1.4142135623730951}}}}}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":11,"docs":{"121":{"tf":1.0},"130":{"tf":1.0},"154":{"tf":1.0},"159":{"tf":1.0},"164":{"tf":1.0},"183":{"tf":1.0},"190":{"tf":1.0},"2":{"tf":1.4142135623730951},"203":{"tf":1.0},"206":{"tf":1.0},"3":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":2,"docs":{"141":{"tf":1.0},"143":{"tf":1.0}}},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"112":{"tf":1.0}}},".":{"df":0,"docs":{},"h":{"df":2,"docs":{"132":{"tf":1.0},"142":{"tf":1.4142135623730951}}}},"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"d":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"132":{"tf":1.0},"142":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":17,"docs":{"112":{"tf":2.23606797749979},"127":{"tf":1.0},"130":{"tf":1.0},"132":{"tf":3.1622776601683795},"136":{"tf":1.0},"137":{"tf":1.0},"138":{"tf":1.0},"139":{"tf":2.449489742783178},"140":{"tf":1.0},"142":{"tf":1.7320508075688772},"150":{"tf":1.0},"159":{"tf":1.0},"163":{"tf":1.4142135623730951},"164":{"tf":1.4142135623730951},"191":{"tf":1.0},"192":{"tf":1.0},"195":{"tf":1.4142135623730951}},"s":{"/":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"136":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":21,"docs":{"114":{"tf":1.0},"115":{"tf":1.0},"126":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.0},"14":{"tf":1.4142135623730951},"153":{"tf":1.0},"203":{"tf":1.0},"206":{"tf":1.0},"21":{"tf":1.0},"212":{"tf":1.7320508075688772},"213":{"tf":1.0},"22":{"tf":1.0},"220":{"tf":1.0},"225":{"tf":1.0},"229":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"39":{"tf":1.0}}}},"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"230":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"u":{"df":2,"docs":{"162":{"tf":1.4142135623730951},"166":{"tf":1.0}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"110":{"tf":1.0}}}}}},"df":1,"docs":{"131":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":24,"docs":{"130":{"tf":1.0},"131":{"tf":1.0},"132":{"tf":1.0},"138":{"tf":1.4142135623730951},"150":{"tf":1.4142135623730951},"157":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":2.8284271247461903},"160":{"tf":1.0},"161":{"tf":1.0},"162":{"tf":1.7320508075688772},"163":{"tf":1.0},"164":{"tf":1.0},"178":{"tf":1.0},"190":{"tf":1.0},"209":{"tf":1.0},"213":{"tf":1.0},"222":{"tf":1.0},"224":{"tf":1.0},"225":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"144":{"tf":1.0},"158":{"tf":3.0},"162":{"tf":1.0},"165":{"tf":1.7320508075688772},"166":{"tf":1.0},"58":{"tf":1.0},"82":{"tf":1.0}}}}}}},"k":{"df":0,"docs":{},"e":{"df":2,"docs":{"39":{"tf":1.0},"43":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":4,"docs":{"149":{"tf":1.4142135623730951},"209":{"tf":2.23606797749979},"234":{"tf":1.0},"34":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"222":{"tf":1.0}}}},"t":{"df":1,"docs":{"231":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":5,"docs":{"158":{"tf":1.4142135623730951},"162":{"tf":1.4142135623730951},"164":{"tf":1.0},"165":{"tf":1.0},"221":{"tf":1.4142135623730951}}}},"p":{"df":2,"docs":{"31":{"tf":1.0},"32":{"tf":1.0}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"118":{"tf":1.0},"209":{"tf":2.0}}}},"df":1,"docs":{"163":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"0":{"tf":1.7320508075688772},"147":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"139":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"164":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"231":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":12,"docs":{"131":{"tf":1.7320508075688772},"138":{"tf":1.0},"140":{"tf":1.0},"144":{"tf":1.4142135623730951},"160":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":1.4142135623730951},"166":{"tf":1.0},"192":{"tf":1.0},"193":{"tf":1.0},"209":{"tf":1.0},"25":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":8,"docs":{"109":{"tf":1.0},"111":{"tf":1.4142135623730951},"143":{"tf":1.0},"147":{"tf":1.0},"233":{"tf":1.0},"234":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"112":{"tf":1.0}}}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"113":{"tf":1.0}},"p":{"c":{"df":1,"docs":{"137":{"tf":1.0}}},"df":0,"docs":{}}}}}},"r":{"df":23,"docs":{"134":{"tf":1.7320508075688772},"137":{"tf":1.0},"138":{"tf":1.7320508075688772},"139":{"tf":1.0},"190":{"tf":4.242640687119285},"191":{"tf":1.4142135623730951},"192":{"tf":1.0},"201":{"tf":1.0},"202":{"tf":1.0},"203":{"tf":1.7320508075688772},"204":{"tf":1.7320508075688772},"207":{"tf":2.23606797749979},"208":{"tf":3.605551275463989},"210":{"tf":1.0},"211":{"tf":1.4142135623730951},"212":{"tf":1.4142135623730951},"213":{"tf":1.4142135623730951},"214":{"tf":1.0},"220":{"tf":2.0},"221":{"tf":2.449489742783178},"224":{"tf":2.6457513110645907},"225":{"tf":1.7320508075688772},"226":{"tf":2.8284271247461903}},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"165":{"tf":1.0}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"145":{"tf":1.0}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":7,"docs":{"112":{"tf":1.0},"134":{"tf":1.0},"136":{"tf":1.4142135623730951},"138":{"tf":1.0},"166":{"tf":1.4142135623730951},"194":{"tf":1.0},"226":{"tf":1.0}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":7,"docs":{"103":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.0},"140":{"tf":1.4142135623730951},"142":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.7320508075688772}}}},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"122":{"tf":1.0}}}}}}}},"d":{"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"194":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":2,"docs":{"193":{"tf":1.0},"194":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":1,"docs":{"187":{"tf":1.0}},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"185":{"tf":1.0}}}}}}},"f":{"a":{"c":{"df":1,"docs":{"158":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"207":{"tf":1.0},"212":{"tf":1.0},"213":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.0}}}},"i":{"df":0,"docs":{},"x":{"df":5,"docs":{"17":{"tf":1.0},"185":{"tf":1.4142135623730951},"20":{"tf":1.0},"216":{"tf":1.0},"26":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"146":{"tf":1.0},"159":{"tf":1.0},"208":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"169":{"tf":1.0}}}}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"194":{"tf":1.0},"203":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":5,"docs":{"131":{"tf":1.0},"148":{"tf":1.0},"193":{"tf":1.0},"194":{"tf":1.0},"209":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":4,"docs":{"165":{"tf":1.0},"191":{"tf":1.0},"195":{"tf":1.0},"40":{"tf":1.0}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"203":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"138":{"tf":1.0},"145":{"tf":1.0},"206":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"1":{":":{":":{"a":{"d":{"d":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":4,"docs":{"131":{"tf":1.4142135623730951},"218":{"tf":1.4142135623730951},"55":{"tf":1.7320508075688772},"93":{"tf":1.0}}},"2":{"=":{"df":0,"docs":{},"i":{"df":1,"docs":{"218":{"tf":1.0}}}},"_":{"df":1,"docs":{"185":{"tf":1.0}}},"df":4,"docs":{"131":{"tf":1.4142135623730951},"218":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"55":{"tf":1.7320508075688772}}},"df":4,"docs":{"192":{"tf":1.0},"51":{"tf":1.0},"54":{"tf":1.7320508075688772},"55":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":7,"docs":{"134":{"tf":1.0},"138":{"tf":1.4142135623730951},"147":{"tf":1.0},"159":{"tf":1.0},"208":{"tf":1.0},"218":{"tf":1.0},"227":{"tf":1.0}},"s":{"df":6,"docs":{"130":{"tf":1.0},"132":{"tf":1.0},"165":{"tf":1.0},"190":{"tf":1.0},"208":{"tf":1.0},"61":{"tf":1.4142135623730951}}}}}}}},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"10":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"157":{"tf":1.0},"162":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"157":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"g":{"c":{"d":{"(":{"2":{"7":{"df":1,"docs":{"90":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":10,"docs":{"10":{"tf":1.0},"12":{"tf":1.4142135623730951},"130":{"tf":1.0},"14":{"tf":1.0},"147":{"tf":1.0},"194":{"tf":1.7320508075688772},"57":{"tf":1.4142135623730951},"6":{"tf":1.0},"81":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951}},"f":{"(":{"\"":{"\\":{"df":0,"docs":{},"n":{"df":1,"docs":{"88":{"tf":1.0}}}},"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"70":{"tf":1.0}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"70":{"tf":1.4142135623730951},"85":{"tf":1.0},"88":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":4,"docs":{"70":{"tf":1.0},"76":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"70":{"tf":1.0},"76":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{".":{"\\":{"df":0,"docs":{},"n":{"df":3,"docs":{"76":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"70":{"tf":1.0},"76":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"g":{"c":{"d":{"(":{"%":{"d":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"76":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{".":{".":{".":{"\\":{"df":0,"docs":{},"n":{"df":4,"docs":{"70":{"tf":1.0},"76":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":4,"docs":{"70":{"tf":1.0},"76":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":1,"docs":{"85":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"88":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"76":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":7,"docs":{"70":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951},"76":{"tf":2.23606797749979},"79":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"85":{"tf":1.7320508075688772},"88":{"tf":2.23606797749979}}},"l":{"df":0,"docs":{},"n":{"!":{"(":{"\"":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"w":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"43":{"tf":1.4142135623730951},"63":{"tf":1.0},"66":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"49":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"43":{"tf":1.0},"66":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"63":{"tf":1.0}}}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"43":{"tf":1.0},"49":{"tf":1.0},"66":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"43":{"tf":1.0},"63":{"tf":1.0},"66":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"f":{"df":0,"docs":{},"i":{"b":{"(":{"6":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}},"df":2,"docs":{"117":{"tf":1.0},"122":{"tf":1.0}}},"df":0,"docs":{}}},"g":{"c":{"d":{"(":{"6":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":2,"docs":{"51":{"tf":1.0},"78":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"43":{"tf":1.0},"66":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":3,"docs":{"43":{"tf":1.0},"63":{"tf":1.0},"66":{"tf":1.0}}}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"63":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"63":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"43":{"tf":1.0},"63":{"tf":2.23606797749979},"66":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"138":{"tf":1.0},"160":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"147":{"tf":1.0},"32":{"tf":1.0}}}}}}},"u":{"3":{"2":{"df":1,"docs":{"88":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"6":{"4":{"df":1,"docs":{"88":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"v":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"157":{"tf":1.0},"226":{"tf":1.0},"231":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"o":{"b":{"a":{"b":{"df":0,"docs":{},"l":{"df":6,"docs":{"132":{"tf":1.4142135623730951},"158":{"tf":1.0},"164":{"tf":1.0},"184":{"tf":1.0},"185":{"tf":1.0},"226":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":6,"docs":{"114":{"tf":1.0},"115":{"tf":1.0},"126":{"tf":1.0},"160":{"tf":1.0},"190":{"tf":1.0},"221":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"159":{"tf":1.0},"219":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"224":{"tf":1.4142135623730951},"225":{"tf":1.0}}}}}},"df":29,"docs":{"0":{"tf":1.0},"120":{"tf":1.4142135623730951},"122":{"tf":1.0},"127":{"tf":1.0},"130":{"tf":1.0},"132":{"tf":1.4142135623730951},"134":{"tf":2.6457513110645907},"135":{"tf":1.0},"140":{"tf":1.7320508075688772},"145":{"tf":1.0},"146":{"tf":1.0},"151":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.4142135623730951},"161":{"tf":1.0},"162":{"tf":1.4142135623730951},"193":{"tf":1.0},"206":{"tf":1.0},"209":{"tf":1.0},"210":{"tf":1.0},"211":{"tf":1.0},"212":{"tf":1.0},"217":{"tf":1.0},"220":{"tf":1.0},"222":{"tf":1.0},"223":{"tf":1.4142135623730951},"224":{"tf":1.4142135623730951},"225":{"tf":2.23606797749979},"226":{"tf":1.7320508075688772}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":9,"docs":{"11":{"tf":1.0},"129":{"tf":1.0},"130":{"tf":1.4142135623730951},"131":{"tf":1.4142135623730951},"132":{"tf":1.4142135623730951},"159":{"tf":1.0},"192":{"tf":2.8284271247461903},"193":{"tf":1.0},"204":{"tf":1.0}},"t":{"df":2,"docs":{"138":{"tf":2.449489742783178},"204":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"231":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"l":{"df":17,"docs":{"112":{"tf":2.8284271247461903},"113":{"tf":2.0},"114":{"tf":2.23606797749979},"115":{"tf":2.23606797749979},"116":{"tf":1.7320508075688772},"118":{"tf":2.0},"119":{"tf":1.4142135623730951},"120":{"tf":2.0},"121":{"tf":1.4142135623730951},"122":{"tf":1.4142135623730951},"124":{"tf":1.0},"125":{"tf":1.0},"126":{"tf":2.449489742783178},"127":{"tf":2.449489742783178},"159":{"tf":1.0},"163":{"tf":1.0},"167":{"tf":1.4142135623730951}},"e":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"126":{"tf":1.0},"127":{"tf":1.0}}}}}}},"=":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"[":{",":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"[":{",":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"127":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"j":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":2,"docs":{"115":{"tf":1.4142135623730951},"117":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"114":{"tf":1.4142135623730951},"126":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"v":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":4,"docs":{"119":{"tf":1.0},"121":{"tf":1.4142135623730951},"122":{"tf":1.4142135623730951},"124":{"tf":1.0}}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"y":{":":{":":{"df":0,"docs":{},"j":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"115":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"114":{"tf":1.0},"126":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"v":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"119":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{".":{"c":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}},"df":21,"docs":{"0":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"118":{"tf":1.0},"128":{"tf":2.0},"130":{"tf":1.0},"145":{"tf":1.0},"147":{"tf":1.0},"150":{"tf":1.0},"158":{"tf":1.0},"163":{"tf":1.4142135623730951},"181":{"tf":1.4142135623730951},"185":{"tf":1.4142135623730951},"37":{"tf":1.0},"44":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"55":{"tf":1.0},"71":{"tf":1.0},"85":{"tf":1.0},"93":{"tf":1.7320508075688772}},"m":{"a":{"df":0,"docs":{},"t":{"df":4,"docs":{"102":{"tf":1.0},"105":{"tf":1.0},"89":{"tf":1.0},"92":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"c":{"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"/":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"185":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"185":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"138":{"tf":1.0}}}}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"'":{"df":3,"docs":{"103":{"tf":1.0},"206":{"tf":1.0},"209":{"tf":1.0}}},"df":25,"docs":{"1":{"tf":1.0},"103":{"tf":1.0},"131":{"tf":1.4142135623730951},"135":{"tf":1.7320508075688772},"138":{"tf":2.0},"152":{"tf":1.0},"153":{"tf":1.4142135623730951},"189":{"tf":1.0},"2":{"tf":1.0},"204":{"tf":1.0},"206":{"tf":1.0},"207":{"tf":1.0},"220":{"tf":1.0},"230":{"tf":1.0},"232":{"tf":1.4142135623730951},"233":{"tf":2.449489742783178},"234":{"tf":1.0},"39":{"tf":1.4142135623730951},"89":{"tf":1.0},"90":{"tf":1.4142135623730951},"92":{"tf":1.0},"93":{"tf":1.7320508075688772},"95":{"tf":1.0},"96":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"203":{"tf":1.4142135623730951}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"220":{"tf":1.0}}}}}}},"p":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"194":{"tf":1.0},"39":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"121":{"tf":1.0},"24":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"159":{"tf":1.0},"164":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"l":{"'":{"df":2,"docs":{"216":{"tf":1.7320508075688772},"217":{"tf":2.0}}},"df":0,"docs":{}}},"df":9,"docs":{"137":{"tf":7.0710678118654755},"138":{"tf":1.7320508075688772},"147":{"tf":1.0},"159":{"tf":1.0},"162":{"tf":1.0},"164":{"tf":1.0},"215":{"tf":1.0},"216":{"tf":2.8284271247461903},"217":{"tf":2.0}}}}},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"145":{"tf":1.7320508075688772},"147":{"tf":1.0},"164":{"tf":1.0},"209":{"tf":1.0}}}},"df":0,"docs":{}}},"v":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"164":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"d":{"df":23,"docs":{"0":{"tf":1.7320508075688772},"1":{"tf":1.4142135623730951},"109":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"118":{"tf":2.23606797749979},"120":{"tf":1.0},"128":{"tf":1.0},"130":{"tf":2.0},"134":{"tf":1.0},"136":{"tf":1.0},"138":{"tf":1.0},"157":{"tf":1.0},"160":{"tf":1.0},"162":{"tf":1.0},"220":{"tf":1.0},"30":{"tf":1.0},"40":{"tf":1.7320508075688772},"5":{"tf":1.0},"52":{"tf":1.0},"7":{"tf":1.0},"89":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{}}},"x":{"df":0,"docs":{},"i":{"df":1,"docs":{"137":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":2,"docs":{"190":{"tf":1.0},"192":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"_":{"c":{"df":0,"docs":{},"r":{"df":1,"docs":{"225":{"tf":1.0}}}},"df":0,"docs":{}},"df":7,"docs":{"145":{"tf":1.0},"157":{"tf":1.0},"158":{"tf":1.0},"167":{"tf":1.0},"226":{"tf":1.0},"231":{"tf":1.0},"233":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":5,"docs":{"157":{"tf":1.0},"209":{"tf":1.0},"224":{"tf":1.4142135623730951},"226":{"tf":1.4142135623730951},"231":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"u":{"b":{"df":1,"docs":{"137":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":12,"docs":{"184":{"tf":1.0},"190":{"tf":1.0},"201":{"tf":1.0},"207":{"tf":1.0},"210":{"tf":1.0},"212":{"tf":2.0},"214":{"tf":1.4142135623730951},"216":{"tf":1.0},"220":{"tf":1.7320508075688772},"221":{"tf":1.4142135623730951},"222":{"tf":1.7320508075688772},"39":{"tf":1.0}}}},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":10,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"131":{"tf":1.0},"136":{"tf":1.0},"137":{"tf":1.0},"156":{"tf":1.0},"158":{"tf":1.4142135623730951},"162":{"tf":1.0},"164":{"tf":1.0},"207":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"h":{"df":3,"docs":{"208":{"tf":2.8284271247461903},"224":{"tf":2.23606797749979},"225":{"tf":1.4142135623730951}}}},"t":{"df":8,"docs":{"103":{"tf":1.0},"131":{"tf":1.0},"157":{"tf":1.0},"158":{"tf":1.0},"183":{"tf":1.4142135623730951},"206":{"tf":1.0},"212":{"tf":1.0},"52":{"tf":1.0}}}},"y":{"df":1,"docs":{"135":{"tf":1.0}},"p":{"df":0,"docs":{},"i":{"df":2,"docs":{"89":{"tf":1.0},"90":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"216":{"tf":1.0},"36":{"tf":1.0},"89":{"tf":2.0},"90":{"tf":1.4142135623730951},"91":{"tf":1.0}}}}}}}},"q":{"df":1,"docs":{"194":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":3,"docs":{"195":{"tf":1.0},"198":{"tf":1.7320508075688772},"199":{"tf":2.0}}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":3,"docs":{"137":{"tf":1.0},"138":{"tf":1.0},"189":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":10,"docs":{"104":{"tf":1.0},"107":{"tf":1.0},"153":{"tf":1.0},"194":{"tf":1.0},"210":{"tf":1.0},"212":{"tf":1.0},"217":{"tf":1.0},"91":{"tf":1.0},"94":{"tf":1.0},"97":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"e":{"df":8,"docs":{"137":{"tf":1.0},"17":{"tf":1.7320508075688772},"190":{"tf":2.6457513110645907},"192":{"tf":1.0},"207":{"tf":1.0},"226":{"tf":1.0},"31":{"tf":2.0},"32":{"tf":1.0}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":5,"docs":{"117":{"tf":1.0},"190":{"tf":1.0},"191":{"tf":1.0},"221":{"tf":1.0},"222":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"209":{"tf":1.0},"220":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":2,"docs":{"112":{"tf":1.4142135623730951},"203":{"tf":1.0}}}}}},"r":{"#":{"\"":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":2,"docs":{"39":{"tf":1.0},"40":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"0":{"0":{"df":0,"docs":{},"h":{"df":1,"docs":{"121":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"2":{"tf":1.0},"230":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"151":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"163":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"163":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":4,"docs":{"0":{"tf":1.0},"137":{"tf":1.0},"191":{"tf":1.0},"54":{"tf":1.0}}}}},"df":5,"docs":{"103":{"tf":1.0},"106":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"138":{"tf":1.0}}}},"w":{"df":7,"docs":{"115":{"tf":1.0},"122":{"tf":1.0},"144":{"tf":1.0},"158":{"tf":1.0},"162":{"tf":1.0},"187":{"tf":1.7320508075688772},"188":{"tf":1.0}}}},"b":{"df":3,"docs":{"135":{"tf":1.0},"79":{"tf":1.0},"85":{"tf":1.0}}},"df":6,"docs":{"63":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0}},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"140":{"tf":1.0},"204":{"tf":1.0},"25":{"tf":1.0}}}},"d":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"159":{"tf":1.0}}}}},"df":0,"docs":{}}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"159":{"tf":1.0}}}}}}},"_":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"83":{"tf":1.4142135623730951}}}}}}},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"83":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":19,"docs":{"115":{"tf":1.0},"121":{"tf":1.0},"125":{"tf":1.0},"128":{"tf":1.0},"147":{"tf":1.0},"150":{"tf":1.4142135623730951},"152":{"tf":1.0},"208":{"tf":1.0},"222":{"tf":1.0},"224":{"tf":1.0},"33":{"tf":1.0},"38":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0},"56":{"tf":1.0},"70":{"tf":1.0},"74":{"tf":1.0},"85":{"tf":1.0},"96":{"tf":1.0}},"i":{"df":3,"docs":{"138":{"tf":2.23606797749979},"159":{"tf":1.4142135623730951},"220":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":1,"docs":{"194":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"227":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":4,"docs":{"183":{"tf":1.0},"184":{"tf":1.0},"192":{"tf":1.0},"195":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":8,"docs":{"131":{"tf":1.0},"138":{"tf":1.4142135623730951},"183":{"tf":1.0},"207":{"tf":1.4142135623730951},"208":{"tf":1.0},"213":{"tf":1.0},"220":{"tf":1.4142135623730951},"231":{"tf":1.0}}}}}},"b":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"208":{"tf":1.4142135623730951},"213":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":5,"docs":{"137":{"tf":1.0},"209":{"tf":1.0},"220":{"tf":1.0},"31":{"tf":1.0},"8":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"192":{"tf":1.0},"34":{"tf":1.0},"61":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"34":{"tf":1.0}}}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":8,"docs":{"110":{"tf":1.0},"138":{"tf":1.0},"140":{"tf":1.0},"156":{"tf":1.0},"209":{"tf":1.0},"222":{"tf":1.0},"226":{"tf":1.0},"40":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"130":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":4,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"33":{"tf":1.4142135623730951}}}}}}}},"r":{"d":{"df":7,"docs":{"114":{"tf":1.7320508075688772},"115":{"tf":2.0},"117":{"tf":1.7320508075688772},"126":{"tf":2.0},"162":{"tf":1.0},"191":{"tf":1.0},"40":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":2,"docs":{"151":{"tf":1.0},"158":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"c":{"df":4,"docs":{"131":{"tf":1.4142135623730951},"158":{"tf":1.0},"193":{"tf":1.7320508075688772},"194":{"tf":2.0}},"t":{"df":2,"docs":{"131":{"tf":1.0},"193":{"tf":1.0}}}},"df":0,"docs":{}}},"df":2,"docs":{"212":{"tf":1.0},"221":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"163":{"tf":1.0}}}}}}},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"134":{"tf":1.0},"203":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":19,"docs":{"137":{"tf":1.7320508075688772},"14":{"tf":1.4142135623730951},"158":{"tf":1.4142135623730951},"159":{"tf":1.7320508075688772},"160":{"tf":1.0},"162":{"tf":1.0},"165":{"tf":2.0},"166":{"tf":2.23606797749979},"21":{"tf":1.0},"216":{"tf":1.0},"217":{"tf":1.4142135623730951},"22":{"tf":1.0},"222":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"67":{"tf":1.0},"93":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"162":{"tf":1.0},"194":{"tf":1.0}}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"153":{"tf":1.0}}}},"df":0,"docs":{}}}},"g":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"234":{"tf":1.0}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":4,"docs":{"14":{"tf":1.0},"162":{"tf":1.0},"180":{"tf":1.0},"230":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"113":{"tf":1.0},"120":{"tf":1.0},"145":{"tf":1.0},"164":{"tf":1.7320508075688772}}}},"s":{"df":0,"docs":{},"t":{"df":5,"docs":{"144":{"tf":1.0},"150":{"tf":1.0},"160":{"tf":1.0},"59":{"tf":1.0},"83":{"tf":1.0}},"r":{"df":1,"docs":{"162":{"tf":1.0}},"i":{"df":1,"docs":{"162":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"191":{"tf":1.4142135623730951}}}}}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"221":{"tf":1.0}}}},"df":0,"docs":{}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"232":{"tf":1.0}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"t":{"df":5,"docs":{"158":{"tf":1.0},"181":{"tf":1.0},"226":{"tf":1.0},"7":{"tf":1.0},"90":{"tf":1.0}}},"x":{"df":2,"docs":{"137":{"tf":1.4142135623730951},"138":{"tf":1.0}}}},"df":12,"docs":{"114":{"tf":1.0},"115":{"tf":1.0},"126":{"tf":1.0},"130":{"tf":1.4142135623730951},"138":{"tf":1.4142135623730951},"140":{"tf":1.0},"159":{"tf":1.0},"164":{"tf":1.0},"167":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.0},"209":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"s":{"df":27,"docs":{"125":{"tf":1.0},"130":{"tf":3.7416573867739413},"134":{"tf":4.358898943540674},"135":{"tf":2.23606797749979},"138":{"tf":1.0},"142":{"tf":1.0},"158":{"tf":1.0},"173":{"tf":1.0},"191":{"tf":1.4142135623730951},"192":{"tf":1.4142135623730951},"2":{"tf":1.0},"205":{"tf":1.0},"209":{"tf":1.4142135623730951},"218":{"tf":1.4142135623730951},"223":{"tf":1.7320508075688772},"224":{"tf":4.58257569495584},"225":{"tf":4.123105625617661},"226":{"tf":4.0},"227":{"tf":3.0},"3":{"tf":2.6457513110645907},"4":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"m":{"d":{"df":5,"docs":{"134":{"tf":1.0},"224":{"tf":1.0},"225":{"tf":1.4142135623730951},"226":{"tf":1.0},"227":{"tf":2.23606797749979}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"v":{"df":7,"docs":{"190":{"tf":1.0},"193":{"tf":1.0},"194":{"tf":1.0},"207":{"tf":1.0},"216":{"tf":1.0},"218":{"tf":1.0},"221":{"tf":1.0}}}},"i":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"148":{"tf":1.0}}},"df":0,"docs":{}}},"df":3,"docs":{"158":{"tf":1.0},"189":{"tf":1.0},"218":{"tf":1.0}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"230":{"tf":1.0}}}}}}},"o":{"c":{"df":1,"docs":{"137":{"tf":1.0}}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"131":{"tf":1.0},"150":{"tf":1.0},"194":{"tf":1.0},"208":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":2,"docs":{"158":{"tf":1.0},"221":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"v":{"df":6,"docs":{"130":{"tf":2.0},"131":{"tf":1.7320508075688772},"138":{"tf":2.0},"167":{"tf":1.0},"214":{"tf":1.0},"232":{"tf":1.0}}}}},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"192":{"tf":1.0}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"150":{"tf":1.0},"234":{"tf":1.0}}}}}},"df":0,"docs":{}}},"l":{"a":{"c":{"df":5,"docs":{"147":{"tf":1.0},"173":{"tf":1.0},"227":{"tf":1.0},"34":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"130":{"tf":1.0}}},"df":1,"docs":{"138":{"tf":1.0}}}},"o":{"df":1,"docs":{"184":{"tf":1.0}},"r":{"df":0,"docs":{},"t":{"@":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"234":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":10,"docs":{"114":{"tf":1.0},"115":{"tf":1.0},"117":{"tf":1.7320508075688772},"118":{"tf":1.4142135623730951},"122":{"tf":1.0},"123":{"tf":1.0},"150":{"tf":1.0},"193":{"tf":1.4142135623730951},"194":{"tf":1.7320508075688772},"234":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":40,"docs":{"104":{"tf":1.0},"107":{"tf":1.0},"138":{"tf":1.4142135623730951},"14":{"tf":1.0},"153":{"tf":1.0},"170":{"tf":1.4142135623730951},"173":{"tf":1.4142135623730951},"178":{"tf":1.0},"180":{"tf":1.0},"183":{"tf":1.0},"189":{"tf":1.4142135623730951},"190":{"tf":1.0},"191":{"tf":1.0},"199":{"tf":1.0},"200":{"tf":1.0},"202":{"tf":1.0},"203":{"tf":1.0},"205":{"tf":1.0},"218":{"tf":1.4142135623730951},"221":{"tf":1.4142135623730951},"227":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.0},"50":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.0},"80":{"tf":1.0},"84":{"tf":1.0},"86":{"tf":1.0},"91":{"tf":1.0},"94":{"tf":1.4142135623730951},"97":{"tf":1.0}}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":7,"docs":{"130":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.0},"164":{"tf":1.7320508075688772},"165":{"tf":1.7320508075688772},"233":{"tf":1.7320508075688772},"39":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"0":{"tf":1.0},"158":{"tf":2.449489742783178},"161":{"tf":1.0},"162":{"tf":1.0},"233":{"tf":1.0}}}}}}},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":3,"docs":{"151":{"tf":1.0},"193":{"tf":1.4142135623730951},"195":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":18,"docs":{"138":{"tf":1.0},"184":{"tf":1.0},"190":{"tf":1.0},"192":{"tf":1.0},"201":{"tf":1.0},"207":{"tf":1.0},"208":{"tf":1.4142135623730951},"210":{"tf":1.0},"212":{"tf":2.449489742783178},"214":{"tf":1.4142135623730951},"216":{"tf":1.0},"220":{"tf":2.0},"221":{"tf":1.4142135623730951},"222":{"tf":1.7320508075688772},"31":{"tf":2.0},"33":{"tf":1.0},"34":{"tf":1.0},"8":{"tf":1.0}},"e":{"d":{":":{"@":{"df":0,"docs":{},"m":{"df":1,"docs":{"220":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"r":{"df":40,"docs":{"103":{"tf":1.0},"112":{"tf":1.4142135623730951},"114":{"tf":1.0},"115":{"tf":1.0},"124":{"tf":1.0},"126":{"tf":1.0},"130":{"tf":1.4142135623730951},"131":{"tf":1.4142135623730951},"132":{"tf":1.7320508075688772},"134":{"tf":1.7320508075688772},"137":{"tf":1.7320508075688772},"138":{"tf":3.3166247903554},"139":{"tf":1.0},"140":{"tf":1.0},"142":{"tf":1.4142135623730951},"145":{"tf":1.0},"155":{"tf":1.0},"158":{"tf":1.0},"162":{"tf":1.0},"165":{"tf":1.0},"167":{"tf":1.4142135623730951},"168":{"tf":1.0},"172":{"tf":1.0},"190":{"tf":1.0},"192":{"tf":1.0},"203":{"tf":1.0},"204":{"tf":1.0},"206":{"tf":1.4142135623730951},"207":{"tf":1.7320508075688772},"208":{"tf":1.0},"209":{"tf":1.7320508075688772},"213":{"tf":1.0},"214":{"tf":1.0},"216":{"tf":1.4142135623730951},"221":{"tf":1.0},"224":{"tf":1.0},"34":{"tf":1.0},"43":{"tf":1.0},"55":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"190":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"148":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":2,"docs":{"134":{"tf":1.0},"164":{"tf":1.7320508075688772}}}},"t":{"df":1,"docs":{"224":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"220":{"tf":1.0},"40":{"tf":1.0}}}},"v":{"df":2,"docs":{"203":{"tf":1.0},"224":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":2,"docs":{"138":{"tf":1.0},"151":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"220":{"tf":1.0},"231":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"138":{"tf":1.0},"220":{"tf":1.4142135623730951},"221":{"tf":1.0},"234":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":5,"docs":{"138":{"tf":2.0},"192":{"tf":1.0},"220":{"tf":1.0},"221":{"tf":1.7320508075688772},"232":{"tf":2.0}}}}}},"t":{"df":6,"docs":{"113":{"tf":1.0},"138":{"tf":1.0},"160":{"tf":1.0},"222":{"tf":1.0},"225":{"tf":1.0},"38":{"tf":1.0}},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"131":{"tf":1.0},"137":{"tf":1.0},"138":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{".":{".":{".":{"\\":{"df":0,"docs":{},"n":{"df":1,"docs":{"88":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"=":{"$":{"(":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"101":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"k":{"(":{"1":{"4":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"\\":{"df":0,"docs":{},"n":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":50,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"103":{"tf":1.0},"106":{"tf":1.0},"112":{"tf":1.4142135623730951},"121":{"tf":1.7320508075688772},"122":{"tf":1.0},"123":{"tf":1.7320508075688772},"126":{"tf":1.0},"131":{"tf":1.4142135623730951},"138":{"tf":1.4142135623730951},"158":{"tf":1.4142135623730951},"159":{"tf":1.4142135623730951},"162":{"tf":1.4142135623730951},"164":{"tf":1.4142135623730951},"167":{"tf":1.0},"180":{"tf":1.0},"187":{"tf":1.0},"193":{"tf":1.4142135623730951},"38":{"tf":1.0},"39":{"tf":2.23606797749979},"40":{"tf":2.0},"43":{"tf":1.4142135623730951},"45":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.4142135623730951},"49":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.4142135623730951},"59":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.7320508075688772},"65":{"tf":1.7320508075688772},"66":{"tf":2.449489742783178},"70":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"75":{"tf":1.4142135623730951},"76":{"tf":1.7320508075688772},"81":{"tf":1.0},"82":{"tf":1.4142135623730951},"85":{"tf":1.0},"87":{"tf":1.7320508075688772},"88":{"tf":2.0},"90":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0}},"s":{"[":{"0":{"]":{".":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"88":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"i":{"3":{"2":{"df":4,"docs":{"73":{"tf":1.0},"76":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}},"df":0,"docs":{}},"6":{"4":{"df":1,"docs":{"88":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"88":{"tf":1.0}}},"1":{"]":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"88":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":4,"docs":{"73":{"tf":1.0},"76":{"tf":1.4142135623730951},"85":{"tf":1.0},"88":{"tf":1.0}}},"2":{"df":1,"docs":{"88":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"m":{"df":1,"docs":{"225":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"162":{"tf":1.0}}}}},"df":2,"docs":{"70":{"tf":1.7320508075688772},"73":{"tf":1.7320508075688772}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":15,"docs":{"144":{"tf":1.4142135623730951},"162":{"tf":1.0},"163":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"66":{"tf":1.4142135623730951},"70":{"tf":1.7320508075688772},"73":{"tf":1.7320508075688772},"76":{"tf":1.7320508075688772},"79":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.7320508075688772},"88":{"tf":2.23606797749979}}}}}},"u":{"df":0,"docs":{},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"159":{"tf":1.0}}}},"df":0,"docs":{}},"df":2,"docs":{"145":{"tf":1.0},"187":{"tf":1.0}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":18,"docs":{"138":{"tf":1.4142135623730951},"156":{"tf":1.0},"190":{"tf":1.4142135623730951},"206":{"tf":1.4142135623730951},"207":{"tf":1.7320508075688772},"208":{"tf":1.7320508075688772},"209":{"tf":2.0},"210":{"tf":1.0},"212":{"tf":1.7320508075688772},"213":{"tf":1.7320508075688772},"214":{"tf":2.0},"217":{"tf":1.0},"220":{"tf":3.3166247903554},"221":{"tf":4.242640687119285},"222":{"tf":2.23606797749979},"225":{"tf":1.0},"234":{"tf":1.0},"41":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"208":{"tf":1.0}}}}}}}}}},"f":{"c":{"df":3,"docs":{"134":{"tf":2.0},"138":{"tf":2.0},"226":{"tf":1.0}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":6,"docs":{"132":{"tf":1.0},"134":{"tf":1.0},"195":{"tf":1.0},"2":{"tf":1.0},"232":{"tf":1.0},"3":{"tf":1.0}}}}},"s":{"c":{"df":1,"docs":{"137":{"tf":1.0}},"v":{"6":{"4":{"df":4,"docs":{"139":{"tf":1.0},"140":{"tf":1.0},"197":{"tf":1.0},"199":{"tf":1.4142135623730951}},"g":{"c":{"df":3,"docs":{"137":{"tf":1.0},"196":{"tf":1.0},"200":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"200":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"164":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"205":{"tf":1.0}}},"df":12,"docs":{"130":{"tf":4.898979485566356},"158":{"tf":1.0},"166":{"tf":1.0},"173":{"tf":1.4142135623730951},"180":{"tf":1.4142135623730951},"183":{"tf":1.4142135623730951},"184":{"tf":1.0},"202":{"tf":1.0},"203":{"tf":1.0},"221":{"tf":1.0},"227":{"tf":1.0},"39":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":2,"docs":{"162":{"tf":1.0},"209":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"159":{"tf":1.0}}}}}},"n":{"d":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":3,"docs":{"65":{"tf":1.4142135623730951},"66":{"tf":2.0},"87":{"tf":1.4142135623730951}}},"y":{".":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"127":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"df":2,"docs":{"118":{"tf":1.0},"183":{"tf":1.0}}},"u":{"b":{"df":0,"docs":{},"i":{"df":3,"docs":{"102":{"tf":1.7320508075688772},"103":{"tf":1.7320508075688772},"36":{"tf":1.0}}},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"102":{"tf":1.0}}}}}}},"df":0,"docs":{},"n":{",":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"130":{"tf":3.0}}}}},"df":0,"docs":{}},".":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"40":{"tf":1.0},"43":{"tf":1.0},"59":{"tf":1.0},"63":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":3,"docs":{"70":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"226":{"tf":1.4142135623730951}}}}}},"df":99,"docs":{"0":{"tf":1.0},"102":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0},"11":{"tf":1.7320508075688772},"110":{"tf":2.23606797749979},"111":{"tf":1.7320508075688772},"113":{"tf":1.0},"114":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.0},"12":{"tf":1.0},"121":{"tf":1.4142135623730951},"122":{"tf":1.0},"126":{"tf":1.0},"128":{"tf":2.0},"130":{"tf":2.0},"132":{"tf":1.0},"137":{"tf":1.0},"138":{"tf":1.7320508075688772},"139":{"tf":1.0},"142":{"tf":1.0},"150":{"tf":1.0},"152":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":1.0},"168":{"tf":1.0},"173":{"tf":2.0},"175":{"tf":1.0},"176":{"tf":1.4142135623730951},"178":{"tf":3.3166247903554},"179":{"tf":1.0},"180":{"tf":2.23606797749979},"181":{"tf":1.7320508075688772},"183":{"tf":1.0},"184":{"tf":1.7320508075688772},"185":{"tf":2.0},"188":{"tf":1.0},"190":{"tf":2.23606797749979},"191":{"tf":2.6457513110645907},"192":{"tf":1.4142135623730951},"193":{"tf":1.4142135623730951},"194":{"tf":2.23606797749979},"195":{"tf":1.4142135623730951},"199":{"tf":1.0},"200":{"tf":2.23606797749979},"204":{"tf":1.0},"205":{"tf":1.4142135623730951},"206":{"tf":2.0},"207":{"tf":1.0},"208":{"tf":1.0},"217":{"tf":1.4142135623730951},"218":{"tf":1.0},"224":{"tf":2.0},"225":{"tf":1.7320508075688772},"226":{"tf":2.23606797749979},"32":{"tf":1.0},"39":{"tf":2.23606797749979},"40":{"tf":2.23606797749979},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":2.23606797749979},"44":{"tf":1.4142135623730951},"46":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951},"56":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.7320508075688772},"6":{"tf":1.7320508075688772},"60":{"tf":1.0},"61":{"tf":1.4142135623730951},"62":{"tf":1.0},"63":{"tf":2.449489742783178},"64":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":2.8284271247461903},"70":{"tf":2.23606797749979},"71":{"tf":1.4142135623730951},"73":{"tf":1.0},"74":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"79":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.0},"83":{"tf":2.449489742783178},"84":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":2.0},"93":{"tf":1.4142135623730951},"96":{"tf":1.7320508075688772}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"199":{"tf":1.7320508075688772}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":21,"docs":{"0":{"tf":1.0},"114":{"tf":1.7320508075688772},"115":{"tf":1.7320508075688772},"117":{"tf":1.0},"118":{"tf":1.4142135623730951},"119":{"tf":1.4142135623730951},"120":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":1.0},"126":{"tf":1.4142135623730951},"129":{"tf":1.0},"131":{"tf":1.0},"137":{"tf":1.4142135623730951},"142":{"tf":1.4142135623730951},"150":{"tf":1.0},"158":{"tf":1.4142135623730951},"161":{"tf":1.0},"164":{"tf":1.0},"167":{"tf":1.4142135623730951},"60":{"tf":1.0},"84":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"'":{"df":5,"docs":{"13":{"tf":1.0},"130":{"tf":1.0},"155":{"tf":1.0},"165":{"tf":1.0},"183":{"tf":1.0}}},"_":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"e":{"=":{"1":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"'":{"df":1,"docs":{"130":{"tf":1.0}}},"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"=":{"1":{"df":1,"docs":{"132":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":8,"docs":{"111":{"tf":1.0},"117":{"tf":1.0},"122":{"tf":1.4142135623730951},"130":{"tf":1.0},"132":{"tf":1.0},"171":{"tf":1.0},"197":{"tf":1.0},"205":{"tf":1.0}}},"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"205":{"tf":1.0}}},"df":0,"docs":{}}},"df":40,"docs":{"103":{"tf":1.0},"106":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.4142135623730951},"114":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"119":{"tf":1.0},"122":{"tf":1.0},"126":{"tf":1.0},"130":{"tf":2.0},"131":{"tf":1.4142135623730951},"132":{"tf":2.23606797749979},"135":{"tf":1.4142135623730951},"136":{"tf":1.0},"142":{"tf":1.0},"143":{"tf":1.0},"145":{"tf":1.7320508075688772},"155":{"tf":1.7320508075688772},"157":{"tf":1.4142135623730951},"158":{"tf":1.4142135623730951},"163":{"tf":2.0},"166":{"tf":1.0},"171":{"tf":1.4142135623730951},"177":{"tf":1.0},"185":{"tf":1.4142135623730951},"191":{"tf":1.0},"196":{"tf":1.4142135623730951},"201":{"tf":1.0},"203":{"tf":1.7320508075688772},"204":{"tf":1.0},"205":{"tf":2.23606797749979},"218":{"tf":1.0},"36":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"61":{"tf":1.0}},"f":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"130":{"tf":1.7320508075688772},"132":{"tf":1.0}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"t":{"df":2,"docs":{"191":{"tf":1.4142135623730951},"202":{"tf":1.7320508075688772}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"106":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"p":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"177":{"tf":1.0}}}},"df":4,"docs":{"130":{"tf":1.0},"171":{"tf":1.0},"177":{"tf":1.0},"196":{"tf":1.4142135623730951}}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"=":{"1":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"x":{"df":0,"docs":{},"r":{"df":1,"docs":{"130":{"tf":3.4641016151377544}}}}}},"s":{"3":{"9":{"0":{"df":0,"docs":{},"x":{"df":7,"docs":{"137":{"tf":1.0},"139":{"tf":1.0},"140":{"tf":1.0},"196":{"tf":1.0},"197":{"tf":1.0},"199":{"tf":1.4142135623730951},"200":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}},"\\":{"df":0,"docs":{},"n":{"df":7,"docs":{"70":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"85":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951}}}},"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"131":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"f":{"df":1,"docs":{"157":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":10,"docs":{"138":{"tf":1.0},"143":{"tf":1.4142135623730951},"146":{"tf":1.0},"147":{"tf":1.0},"150":{"tf":1.0},"157":{"tf":2.0},"163":{"tf":1.0},"166":{"tf":1.0},"167":{"tf":1.0},"206":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":19,"docs":{"109":{"tf":1.0},"110":{"tf":1.0},"128":{"tf":1.0},"131":{"tf":1.0},"135":{"tf":1.0},"140":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":2.0},"160":{"tf":1.4142135623730951},"162":{"tf":1.0},"164":{"tf":1.0},"183":{"tf":1.0},"184":{"tf":1.0},"192":{"tf":1.0},"194":{"tf":1.7320508075688772},"204":{"tf":1.0},"208":{"tf":1.7320508075688772},"224":{"tf":1.0},"55":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"df":6,"docs":{"117":{"tf":1.0},"124":{"tf":1.0},"127":{"tf":1.4142135623730951},"163":{"tf":1.0},"190":{"tf":1.0},"191":{"tf":1.0}},"i":{"df":3,"docs":{"112":{"tf":1.0},"125":{"tf":2.23606797749979},"126":{"tf":2.0}}}}}},"n":{"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":5,"docs":{"143":{"tf":2.0},"144":{"tf":1.0},"145":{"tf":1.4142135623730951},"150":{"tf":1.7320508075688772},"151":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"c":{"a":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"122":{"tf":1.0},"158":{"tf":1.0}}}},"df":0,"docs":{}},"n":{"df":1,"docs":{"224":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"108":{"tf":1.0}}}}}},"df":0,"docs":{}}},"h":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":2,"docs":{"134":{"tf":1.0},"138":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"155":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":2,"docs":{"161":{"tf":1.0},"233":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":10,"docs":{"100":{"tf":1.0},"103":{"tf":1.4142135623730951},"193":{"tf":1.7320508075688772},"194":{"tf":2.23606797749979},"2":{"tf":1.0},"209":{"tf":1.0},"225":{"tf":1.0},"3":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.0}},"s":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{".":{"df":0,"docs":{},"r":{"df":2,"docs":{"224":{"tf":1.0},"225":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"d":{"df":0,"docs":{},"k":{"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"/":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"128":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":2,"docs":{"128":{"tf":1.0},"92":{"tf":1.4142135623730951}}}},"df":4,"docs":{"130":{"tf":1.0},"218":{"tf":1.0},"52":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"220":{"tf":1.0}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"122":{"tf":1.4142135623730951},"53":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":20,"docs":{"1":{"tf":1.0},"108":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"130":{"tf":1.0},"14":{"tf":1.4142135623730951},"168":{"tf":1.0},"176":{"tf":1.0},"204":{"tf":1.0},"219":{"tf":1.0},"22":{"tf":1.0},"220":{"tf":1.0},"222":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"67":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":14,"docs":{"0":{"tf":2.0},"134":{"tf":1.4142135623730951},"135":{"tf":1.0},"138":{"tf":1.0},"143":{"tf":1.0},"145":{"tf":1.0},"146":{"tf":1.4142135623730951},"149":{"tf":1.0},"150":{"tf":3.4641016151377544},"151":{"tf":1.4142135623730951},"209":{"tf":1.0},"224":{"tf":1.0},"225":{"tf":1.0},"226":{"tf":3.3166247903554}}}}},"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"188":{"tf":1.0}}},"df":29,"docs":{"103":{"tf":1.0},"106":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.4142135623730951},"114":{"tf":1.4142135623730951},"115":{"tf":1.4142135623730951},"117":{"tf":1.4142135623730951},"118":{"tf":1.4142135623730951},"124":{"tf":1.0},"128":{"tf":1.0},"13":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.0},"137":{"tf":1.0},"139":{"tf":1.0},"152":{"tf":1.0},"153":{"tf":1.4142135623730951},"155":{"tf":1.0},"174":{"tf":1.0},"188":{"tf":1.0},"206":{"tf":1.0},"209":{"tf":1.0},"229":{"tf":1.0},"55":{"tf":1.4142135623730951},"8":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0}},"k":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":7,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":7,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}}}}},"df":0,"docs":{}},"m":{"df":2,"docs":{"125":{"tf":1.0},"153":{"tf":1.0}}},"n":{"df":2,"docs":{"123":{"tf":1.0},"40":{"tf":1.0}}}},"g":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":4,"docs":{"145":{"tf":1.0},"163":{"tf":1.4142135623730951},"187":{"tf":1.0},"193":{"tf":1.0}}}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"162":{"tf":2.23606797749979},"194":{"tf":1.7320508075688772},"57":{"tf":1.0},"81":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"185":{"tf":1.0},"204":{"tf":1.0}}}},"df":0,"docs":{}},"f":{"df":2,"docs":{"158":{"tf":1.0},"192":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"150":{"tf":1.0},"151":{"tf":1.0},"194":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"134":{"tf":1.0},"225":{"tf":1.0}}}}}},"n":{"d":{"df":6,"docs":{"166":{"tf":1.0},"184":{"tf":1.0},"203":{"tf":1.0},"204":{"tf":1.0},"226":{"tf":1.4142135623730951},"8":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":7,"docs":{"140":{"tf":1.0},"153":{"tf":1.0},"157":{"tf":1.7320508075688772},"158":{"tf":1.0},"183":{"tf":1.0},"184":{"tf":1.0},"225":{"tf":1.0}},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":3,"docs":{"134":{"tf":1.0},"138":{"tf":1.0},"226":{"tf":1.0}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":8,"docs":{"131":{"tf":1.0},"158":{"tf":1.0},"181":{"tf":1.0},"183":{"tf":1.0},"207":{"tf":1.4142135623730951},"208":{"tf":1.4142135623730951},"213":{"tf":1.0},"234":{"tf":1.0}}}},"df":0,"docs":{}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"147":{"tf":2.6457513110645907}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"159":{"tf":1.0},"63":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"217":{"tf":1.0}}}}},"v":{"df":7,"docs":{"0":{"tf":1.0},"134":{"tf":1.0},"158":{"tf":1.0},"164":{"tf":1.0},"197":{"tf":1.0},"223":{"tf":1.0},"8":{"tf":2.23606797749979}},"i":{"c":{"df":3,"docs":{"137":{"tf":1.0},"150":{"tf":1.4142135623730951},"151":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"df":44,"docs":{"10":{"tf":1.0},"101":{"tf":1.0},"110":{"tf":2.23606797749979},"12":{"tf":2.23606797749979},"124":{"tf":1.7320508075688772},"13":{"tf":1.0},"130":{"tf":1.7320508075688772},"137":{"tf":1.4142135623730951},"14":{"tf":1.7320508075688772},"15":{"tf":1.0},"155":{"tf":1.0},"16":{"tf":1.0},"160":{"tf":1.4142135623730951},"17":{"tf":1.0},"18":{"tf":1.0},"188":{"tf":1.0},"19":{"tf":1.0},"192":{"tf":1.0},"194":{"tf":1.0},"20":{"tf":1.0},"204":{"tf":1.0},"206":{"tf":1.0},"207":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"220":{"tf":1.0},"23":{"tf":1.0},"231":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.0},"39":{"tf":1.0},"43":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"60":{"tf":1.0},"61":{"tf":1.0},"70":{"tf":1.4142135623730951},"73":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0}},"j":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"j":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"163":{"tf":1.0}}}}}}}}}},"df":1,"docs":{"163":{"tf":2.0}}}}},"u":{"df":0,"docs":{},"p":{"df":2,"docs":{"189":{"tf":1.0},"8":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"0":{"tf":1.0},"108":{"tf":1.0},"144":{"tf":1.0},"221":{"tf":1.0}}}}},"x":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"230":{"tf":1.0},"231":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":2,"docs":{"158":{"tf":1.0},"191":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"14":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":4,"docs":{"146":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.4142135623730951},"52":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"130":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"151":{"tf":1.0}}}},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"2":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"137":{"tf":1.0}}}}},"df":1,"docs":{"1":{"tf":1.0}}}},"u":{"df":0,"docs":{},"l":{"d":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"180":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"116":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"w":{"c":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"193":{"tf":1.0},"67":{"tf":1.0}}}},"df":0,"docs":{}},"df":29,"docs":{"111":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"131":{"tf":1.0},"132":{"tf":1.0},"157":{"tf":1.0},"2":{"tf":1.0},"220":{"tf":1.0},"231":{"tf":1.0},"37":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.0},"80":{"tf":1.0},"84":{"tf":1.0},"86":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":2,"docs":{"193":{"tf":1.0},"194":{"tf":1.4142135623730951}}}}}},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"76":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":2,"docs":{"147":{"tf":1.0},"150":{"tf":1.0}}}},"df":3,"docs":{"17":{"tf":1.0},"20":{"tf":1.0},"26":{"tf":1.0}},"g":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"163":{"tf":3.0}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"160":{"tf":1.7320508075688772},"161":{"tf":1.7320508075688772},"39":{"tf":1.0}},"e":{"/":{"a":{"b":{"df":0,"docs":{},"i":{"df":1,"docs":{"160":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":2,"docs":{"137":{"tf":1.0},"145":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":4,"docs":{"130":{"tf":1.0},"131":{"tf":1.0},"138":{"tf":1.0},"222":{"tf":1.0}}}}}}},"df":4,"docs":{"131":{"tf":1.0},"138":{"tf":1.7320508075688772},"163":{"tf":1.0},"222":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}},"m":{"d":{"df":1,"docs":{"137":{"tf":2.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":10,"docs":{"13":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.0},"136":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"1":{"tf":1.0},"181":{"tf":1.0},"25":{"tf":1.0}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":20,"docs":{"102":{"tf":1.0},"103":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.0},"126":{"tf":1.0},"154":{"tf":1.0},"165":{"tf":1.0},"218":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.4142135623730951},"41":{"tf":1.0},"68":{"tf":1.0},"90":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0},"99":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"187":{"tf":1.0},"39":{"tf":1.0}}}}},"i":{"df":7,"docs":{"141":{"tf":1.0},"158":{"tf":1.0},"165":{"tf":1.0},"203":{"tf":1.0},"206":{"tf":1.0},"217":{"tf":1.0},"31":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"158":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":2,"docs":{"158":{"tf":1.0},"226":{"tf":1.0}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":6,"docs":{"120":{"tf":1.0},"130":{"tf":1.7320508075688772},"138":{"tf":1.0},"140":{"tf":1.0},"204":{"tf":1.0},"32":{"tf":1.0}}}}},"t":{"df":1,"docs":{"220":{"tf":1.0}},"e":{"df":1,"docs":{"163":{"tf":1.0}}},"u":{"a":{"df":0,"docs":{},"t":{"df":4,"docs":{"137":{"tf":1.0},"138":{"tf":1.0},"164":{"tf":1.0},"206":{"tf":1.0}}}},"df":0,"docs":{}}},"z":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"76":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"t":{"df":7,"docs":{"70":{"tf":1.7320508075688772},"73":{"tf":1.0},"76":{"tf":2.23606797749979},"79":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":2.23606797749979}}}},"df":17,"docs":{"128":{"tf":1.0},"129":{"tf":1.0},"130":{"tf":2.449489742783178},"131":{"tf":3.4641016151377544},"14":{"tf":1.0},"158":{"tf":1.4142135623730951},"164":{"tf":2.6457513110645907},"17":{"tf":1.4142135623730951},"230":{"tf":1.0},"27":{"tf":1.7320508075688772},"29":{"tf":2.23606797749979},"31":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"48":{"tf":1.0},"49":{"tf":1.4142135623730951},"75":{"tf":1.0},"76":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":3,"docs":{"163":{"tf":1.0},"22":{"tf":1.0},"70":{"tf":1.0}}}}},"l":{"a":{"b":{"df":1,"docs":{"162":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"130":{"tf":1.0},"226":{"tf":1.0}}}}}}},"m":{"df":1,"docs":{"207":{"tf":1.0}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"131":{"tf":1.0}}}}}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":7,"docs":{"129":{"tf":1.0},"130":{"tf":1.0},"157":{"tf":1.0},"193":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"49":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"130":{"tf":1.4142135623730951},"131":{"tf":1.4142135623730951},"194":{"tf":3.3166247903554}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"131":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"144":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"138":{"tf":1.0},"216":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"191":{"tf":1.0}}}}}}}},"o":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"233":{"tf":1.0}}}},"df":0,"docs":{}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"137":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":6,"docs":{"14":{"tf":1.0},"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"160":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"(":{"5":{"df":1,"docs":{"49":{"tf":1.0}}},"a":{"d":{"d":{"df":0,"docs":{},"r":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"185":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"183":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"b":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"i":{"df":2,"docs":{"214":{"tf":1.0},"221":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"213":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":6,"docs":{"131":{"tf":1.7320508075688772},"154":{"tf":1.4142135623730951},"194":{"tf":1.0},"220":{"tf":1.0},"3":{"tf":1.0},"40":{"tf":1.0}}},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"194":{"tf":1.0},"213":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"225":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"190":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"133":{"tf":1.0},"135":{"tf":1.0},"147":{"tf":1.0},"228":{"tf":1.0}}}},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"158":{"tf":1.4142135623730951},"162":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"222":{"tf":1.0}}},"df":0,"docs":{}},"r":{"c":{"df":36,"docs":{"0":{"tf":1.0},"113":{"tf":1.0},"118":{"tf":1.0},"125":{"tf":1.0},"131":{"tf":1.7320508075688772},"137":{"tf":1.0},"142":{"tf":1.0},"144":{"tf":1.0},"150":{"tf":1.0},"158":{"tf":1.0},"163":{"tf":1.0},"185":{"tf":1.0},"192":{"tf":1.4142135623730951},"209":{"tf":1.0},"4":{"tf":1.4142135623730951},"41":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"94":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":4,"docs":{"131":{"tf":1.0},"164":{"tf":1.4142135623730951},"233":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"137":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"c":{"df":7,"docs":{"144":{"tf":1.4142135623730951},"178":{"tf":1.0},"180":{"tf":2.449489742783178},"184":{"tf":1.7320508075688772},"216":{"tf":1.7320508075688772},"217":{"tf":1.0},"9":{"tf":1.0}},"i":{"a":{"df":0,"docs":{},"l":{"df":8,"docs":{"112":{"tf":1.0},"138":{"tf":1.0},"158":{"tf":1.0},"165":{"tf":1.0},"212":{"tf":1.0},"224":{"tf":1.7320508075688772},"225":{"tf":1.4142135623730951},"34":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":16,"docs":{"0":{"tf":1.0},"130":{"tf":1.4142135623730951},"139":{"tf":1.0},"143":{"tf":1.0},"153":{"tf":1.0},"155":{"tf":1.4142135623730951},"160":{"tf":1.4142135623730951},"163":{"tf":1.4142135623730951},"179":{"tf":1.0},"180":{"tf":1.0},"184":{"tf":2.0},"185":{"tf":1.0},"188":{"tf":1.0},"207":{"tf":1.0},"220":{"tf":1.7320508075688772},"234":{"tf":1.0}},"i":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"162":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":12,"docs":{"114":{"tf":1.0},"115":{"tf":1.0},"118":{"tf":1.0},"13":{"tf":1.0},"138":{"tf":1.0},"14":{"tf":1.4142135623730951},"142":{"tf":1.0},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"194":{"tf":1.0},"70":{"tf":1.0},"8":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"148":{"tf":2.0}}}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"148":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"130":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"112":{"tf":2.0},"114":{"tf":1.0},"117":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"144":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"212":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"t":{"df":2,"docs":{"121":{"tf":1.0},"122":{"tf":1.0}}}}},"q":{"df":0,"docs":{},"l":{"df":1,"docs":{"137":{"tf":1.0}}},"u":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"213":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"r":{"c":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"203":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"f":{"df":1,"docs":{"2":{"tf":1.0}}}},"t":{"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":3,"docs":{"0":{"tf":1.0},"133":{"tf":1.0},"139":{"tf":1.0}}}},"l":{"df":5,"docs":{"132":{"tf":1.0},"142":{"tf":1.0},"191":{"tf":1.0},"204":{"tf":1.0},"205":{"tf":1.0}}}},"c":{"df":0,"docs":{},"k":{"df":8,"docs":{"137":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.4142135623730951},"158":{"tf":1.4142135623730951},"160":{"tf":1.0},"163":{"tf":2.6457513110645907},"166":{"tf":2.0},"167":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"0":{"tf":1.0},"167":{"tf":1.0}}}}},"r":{"d":{"df":14,"docs":{"0":{"tf":1.4142135623730951},"111":{"tf":1.0},"124":{"tf":1.0},"130":{"tf":2.449489742783178},"132":{"tf":1.7320508075688772},"146":{"tf":1.0},"163":{"tf":1.0},"167":{"tf":1.0},"178":{"tf":1.0},"216":{"tf":1.0},"217":{"tf":1.4142135623730951},"218":{"tf":1.0},"231":{"tf":1.0},"232":{"tf":1.0}}},"df":0,"docs":{}}},"df":2,"docs":{"49":{"tf":1.0},"76":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":31,"docs":{"1":{"tf":1.4142135623730951},"102":{"tf":1.0},"103":{"tf":1.0},"106":{"tf":1.4142135623730951},"110":{"tf":1.0},"120":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":1.0},"124":{"tf":1.0},"130":{"tf":1.0},"140":{"tf":1.0},"154":{"tf":1.0},"159":{"tf":1.0},"162":{"tf":1.4142135623730951},"163":{"tf":1.4142135623730951},"178":{"tf":1.0},"184":{"tf":1.0},"212":{"tf":1.0},"22":{"tf":1.4142135623730951},"33":{"tf":1.0},"39":{"tf":1.0},"43":{"tf":1.0},"58":{"tf":1.0},"70":{"tf":1.0},"82":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.4142135623730951},"96":{"tf":1.4142135623730951},"99":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"53":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":9,"docs":{"137":{"tf":1.0},"145":{"tf":1.0},"158":{"tf":2.6457513110645907},"162":{"tf":1.4142135623730951},"163":{"tf":1.0},"189":{"tf":1.0},"40":{"tf":1.0},"53":{"tf":2.0},"63":{"tf":1.0}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"113":{"tf":1.0},"130":{"tf":1.0},"206":{"tf":1.0}}}}}}},"i":{"c":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"164":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}},"df":13,"docs":{"118":{"tf":1.0},"137":{"tf":1.4142135623730951},"140":{"tf":1.0},"164":{"tf":2.449489742783178},"39":{"tf":1.0},"70":{"tf":1.7320508075688772},"73":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951},"83":{"tf":2.0},"85":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951},"93":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"209":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0}}}}},"u":{"df":2,"docs":{"13":{"tf":1.0},"137":{"tf":1.0}}}},"y":{"df":3,"docs":{"144":{"tf":1.0},"145":{"tf":1.0},"221":{"tf":1.0}}}},"d":{":":{":":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{":":{":":{"df":0,"docs":{},"{":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"53":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"39":{"tf":1.0},"40":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"f":{"df":1,"docs":{"209":{"tf":1.0}},"m":{"df":0,"docs":{},"t":{"df":1,"docs":{"131":{"tf":1.0}}}},"s":{":":{":":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"\"":{".":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"209":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"209":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"=":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{",":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"_":{"a":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"130":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":3,"docs":{"130":{"tf":1.7320508075688772},"132":{"tf":1.4142135623730951},"218":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"101":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"h":{"df":7,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}}},"df":1,"docs":{"55":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"b":{".":{"df":0,"docs":{},"h":{"df":8,"docs":{"128":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"58":{"tf":1.0},"82":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":13,"docs":{"109":{"tf":1.0},"110":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.0},"132":{"tf":1.0},"151":{"tf":1.0},"159":{"tf":2.0},"162":{"tf":2.0},"216":{"tf":1.0},"218":{"tf":1.4142135623730951},"224":{"tf":2.449489742783178},"225":{"tf":2.0},"226":{"tf":1.0}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":18,"docs":{"114":{"tf":1.0},"115":{"tf":1.0},"119":{"tf":1.0},"126":{"tf":1.0},"130":{"tf":1.4142135623730951},"131":{"tf":1.7320508075688772},"138":{"tf":1.0},"145":{"tf":1.4142135623730951},"150":{"tf":1.0},"151":{"tf":1.0},"162":{"tf":1.4142135623730951},"164":{"tf":1.0},"191":{"tf":1.0},"194":{"tf":1.0},"203":{"tf":1.4142135623730951},"209":{"tf":1.0},"24":{"tf":1.0},"8":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"155":{"tf":1.0}}}},"p":{"df":3,"docs":{"120":{"tf":1.0},"122":{"tf":1.0},"216":{"tf":1.0}}},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"165":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{")":{"[":{"0":{"df":1,"docs":{"49":{"tf":1.0}},"x":{"1":{"0":{"0":{"0":{"df":1,"docs":{"49":{"tf":1.0}}},"3":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},".":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"(":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"63":{"tf":1.0}}}}}}}},":":{":":{"<":{"(":{")":{">":{":":{":":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"g":{"c":{"df":1,"docs":{"166":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"&":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":9,"docs":{"39":{"tf":1.0},"40":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"59":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"66":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.4142135623730951}}}},"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{".":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"49":{"tf":1.4142135623730951}}},"u":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"76":{"tf":2.449489742783178}}},"df":0,"docs":{}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"111":{"tf":1.0}}}},"df":0,"docs":{}}},"df":35,"docs":{"103":{"tf":1.0},"128":{"tf":1.4142135623730951},"137":{"tf":1.0},"144":{"tf":1.4142135623730951},"145":{"tf":1.0},"158":{"tf":4.242640687119285},"159":{"tf":2.23606797749979},"160":{"tf":1.0},"162":{"tf":2.6457513110645907},"165":{"tf":1.7320508075688772},"39":{"tf":3.1622776601683795},"40":{"tf":2.8284271247461903},"43":{"tf":2.6457513110645907},"46":{"tf":2.23606797749979},"48":{"tf":1.0},"49":{"tf":5.291502622129181},"52":{"tf":2.6457513110645907},"53":{"tf":2.0},"55":{"tf":2.449489742783178},"58":{"tf":1.4142135623730951},"59":{"tf":2.6457513110645907},"61":{"tf":2.0},"63":{"tf":2.449489742783178},"66":{"tf":2.6457513110645907},"70":{"tf":1.7320508075688772},"73":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":3.3166247903554},"79":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"85":{"tf":1.0},"88":{"tf":1.0},"90":{"tf":1.7320508075688772},"96":{"tf":1.0}}},"i":{"df":1,"docs":{"165":{"tf":1.0}}}}},"r":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":4,"docs":{"127":{"tf":1.0},"143":{"tf":1.0},"162":{"tf":1.0},"211":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"147":{"tf":1.4142135623730951},"153":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"158":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"225":{"tf":1.0}}}}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"209":{"tf":1.0}}}},"n":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"h":{"df":3,"docs":{"76":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}}},"df":16,"docs":{"131":{"tf":1.7320508075688772},"16":{"tf":1.0},"17":{"tf":1.0},"190":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"43":{"tf":1.0},"53":{"tf":1.0},"57":{"tf":1.0},"81":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"138":{"tf":1.0}}}}}}},"p":{"df":2,"docs":{"130":{"tf":2.0},"193":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":3,"docs":{"0":{"tf":1.0},"139":{"tf":1.0},"187":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"(":{"\"":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"2":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"o":{"a":{"d":{"df":1,"docs":{"76":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"76":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"76":{"tf":1.0}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"76":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":4,"docs":{"159":{"tf":1.0},"162":{"tf":1.0},"165":{"tf":1.0},"183":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}}}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"40":{"tf":1.0},"43":{"tf":1.0},"53":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":6,"docs":{"158":{"tf":2.23606797749979},"159":{"tf":1.0},"187":{"tf":1.0},"213":{"tf":1.0},"222":{"tf":1.0},"224":{"tf":1.0}}}}}},"df":0,"docs":{}}},"u":{"b":{"df":2,"docs":{"131":{"tf":1.0},"132":{"tf":1.0}}},"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"194":{"tf":1.0}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":6,"docs":{"137":{"tf":1.0},"147":{"tf":2.0},"183":{"tf":1.0},"184":{"tf":1.4142135623730951},"185":{"tf":1.0},"209":{"tf":1.0}}}}}},"u":{"b":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":8,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"12":{"tf":1.0},"5":{"tf":1.7320508075688772},"6":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"188":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"147":{"tf":1.0}}}}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"148":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"210":{"tf":1.0}}}},"t":{"df":5,"docs":{"162":{"tf":1.0},"211":{"tf":1.0},"212":{"tf":1.0},"214":{"tf":1.0},"220":{"tf":1.4142135623730951}}}},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":3,"docs":{"170":{"tf":1.7320508075688772},"180":{"tf":2.0},"184":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"150":{"tf":1.0}}}}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"13":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"142":{"tf":1.0}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"138":{"tf":1.0}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"164":{"tf":1.0}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"203":{"tf":1.0}},"s":{"df":0,"docs":{},"s":{"\\":{"df":0,"docs":{},"n":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":3,"docs":{"14":{"tf":1.0},"31":{"tf":1.0},"76":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":7,"docs":{"103":{"tf":1.0},"106":{"tf":1.0},"176":{"tf":1.0},"226":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{},"h":{"df":39,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"111":{"tf":1.0},"130":{"tf":1.0},"132":{"tf":1.0},"134":{"tf":1.4142135623730951},"135":{"tf":1.0},"137":{"tf":1.0},"139":{"tf":1.0},"142":{"tf":1.0},"144":{"tf":1.0},"147":{"tf":1.0},"150":{"tf":1.4142135623730951},"157":{"tf":1.4142135623730951},"158":{"tf":1.7320508075688772},"159":{"tf":1.0},"161":{"tf":1.0},"162":{"tf":1.4142135623730951},"163":{"tf":1.0},"185":{"tf":1.0},"202":{"tf":1.0},"203":{"tf":1.4142135623730951},"209":{"tf":1.0},"214":{"tf":1.0},"218":{"tf":1.0},"220":{"tf":1.0},"221":{"tf":1.0},"224":{"tf":1.0},"225":{"tf":1.0},"231":{"tf":1.0},"24":{"tf":1.0},"54":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0},"90":{"tf":1.0}}}},"d":{"df":0,"docs":{},"o":{"df":2,"docs":{"197":{"tf":1.0},"198":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"131":{"tf":1.0}}}}}},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"221":{"tf":1.0},"222":{"tf":1.4142135623730951}}}}}}},"i":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"131":{"tf":1.0},"137":{"tf":1.0},"138":{"tf":1.0}}}},"df":0,"docs":{}},"df":7,"docs":{"0":{"tf":1.0},"185":{"tf":1.4142135623730951},"190":{"tf":2.449489742783178},"191":{"tf":1.0},"192":{"tf":1.4142135623730951},"205":{"tf":1.0},"9":{"tf":1.0}}}},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"212":{"tf":1.0}},"i":{"df":2,"docs":{"134":{"tf":1.0},"212":{"tf":1.0}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"183":{"tf":1.0}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":7,"docs":{"151":{"tf":1.0},"175":{"tf":1.0},"179":{"tf":1.0},"206":{"tf":1.4142135623730951},"207":{"tf":1.0},"208":{"tf":1.0},"209":{"tf":2.23606797749979}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"216":{"tf":1.0}}},"df":0,"docs":{}}},"df":41,"docs":{"0":{"tf":1.0},"109":{"tf":1.0},"110":{"tf":1.0},"112":{"tf":2.449489742783178},"113":{"tf":1.0},"114":{"tf":2.449489742783178},"115":{"tf":2.6457513110645907},"118":{"tf":1.7320508075688772},"119":{"tf":1.4142135623730951},"120":{"tf":1.4142135623730951},"121":{"tf":1.0},"125":{"tf":1.4142135623730951},"126":{"tf":2.449489742783178},"130":{"tf":1.0},"131":{"tf":1.4142135623730951},"132":{"tf":1.4142135623730951},"136":{"tf":2.449489742783178},"137":{"tf":2.8284271247461903},"138":{"tf":2.23606797749979},"139":{"tf":2.6457513110645907},"140":{"tf":3.1622776601683795},"141":{"tf":1.7320508075688772},"142":{"tf":2.0},"147":{"tf":1.0},"158":{"tf":1.4142135623730951},"164":{"tf":1.0},"166":{"tf":1.4142135623730951},"167":{"tf":1.4142135623730951},"183":{"tf":1.0},"196":{"tf":1.0},"205":{"tf":1.7320508075688772},"216":{"tf":2.8284271247461903},"217":{"tf":1.4142135623730951},"36":{"tf":1.0},"5":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.4142135623730951},"8":{"tf":1.0},"85":{"tf":1.0},"9":{"tf":1.0},"95":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"101":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":31,"docs":{"1":{"tf":1.0},"102":{"tf":1.0},"115":{"tf":1.4142135623730951},"152":{"tf":1.0},"153":{"tf":1.0},"154":{"tf":1.0},"169":{"tf":1.0},"176":{"tf":1.0},"180":{"tf":1.0},"184":{"tf":1.0},"187":{"tf":1.0},"193":{"tf":1.0},"194":{"tf":2.23606797749979},"2":{"tf":1.0},"204":{"tf":1.0},"208":{"tf":1.0},"212":{"tf":1.4142135623730951},"22":{"tf":1.0},"221":{"tf":1.0},"225":{"tf":1.0},"226":{"tf":1.0},"37":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"47":{"tf":1.0},"56":{"tf":1.0},"74":{"tf":1.0},"89":{"tf":1.0},"92":{"tf":1.0},"95":{"tf":1.0}}},"f":{"a":{"c":{"df":2,"docs":{"159":{"tf":1.0},"190":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"25":{"tf":1.0}}}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"137":{"tf":1.0},"140":{"tf":1.0},"159":{"tf":1.0},"167":{"tf":1.0}}}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":5,"docs":{"113":{"tf":1.0},"114":{"tf":1.0},"117":{"tf":1.4142135623730951},"126":{"tf":1.0},"142":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"c":{":":{":":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"53":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"159":{"tf":1.0}}}}}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"184":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"132":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"124":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"151":{"tf":1.0}}},"df":28,"docs":{"0":{"tf":1.4142135623730951},"112":{"tf":1.0},"120":{"tf":1.0},"124":{"tf":1.0},"129":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"140":{"tf":1.0},"141":{"tf":1.4142135623730951},"144":{"tf":1.0},"15":{"tf":1.0},"151":{"tf":1.0},"160":{"tf":1.0},"172":{"tf":1.0},"18":{"tf":1.0},"190":{"tf":1.0},"192":{"tf":1.0},"209":{"tf":1.0},"21":{"tf":1.0},"24":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"93":{"tf":1.0}}}}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":11,"docs":{"130":{"tf":1.0},"145":{"tf":1.0},"148":{"tf":1.0},"151":{"tf":1.0},"158":{"tf":2.0},"159":{"tf":1.0},"160":{"tf":1.0},"162":{"tf":1.0},"165":{"tf":3.0},"203":{"tf":1.0},"217":{"tf":1.0}},"e":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"216":{"tf":1.0}}}}}},"df":0,"docs":{},"{":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{",":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"216":{"tf":1.0},"217":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"l":{"df":1,"docs":{"154":{"tf":1.0}}}}},"df":0,"docs":{},"g":{"df":4,"docs":{"155":{"tf":1.4142135623730951},"224":{"tf":1.7320508075688772},"225":{"tf":1.0},"3":{"tf":1.0}}},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"137":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"136":{"tf":1.0}}}}}},"k":{"df":0,"docs":{},"e":{"df":20,"docs":{"117":{"tf":1.4142135623730951},"121":{"tf":1.0},"130":{"tf":1.4142135623730951},"131":{"tf":1.4142135623730951},"159":{"tf":1.0},"187":{"tf":1.7320508075688772},"190":{"tf":1.0},"191":{"tf":1.0},"193":{"tf":1.0},"209":{"tf":1.0},"222":{"tf":1.0},"225":{"tf":1.0},"232":{"tf":1.0},"39":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"43":{"tf":1.0},"53":{"tf":1.0},"66":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.0}},"n":{"df":4,"docs":{"159":{"tf":1.0},"225":{"tf":1.0},"76":{"tf":1.0},"88":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"k":{"df":3,"docs":{"158":{"tf":1.0},"161":{"tf":1.0},"211":{"tf":1.0}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"208":{"tf":1.0}}}}}},"r":{"b":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"192":{"tf":2.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"df":1,"docs":{"39":{"tf":1.0}}},".":{"a":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"6":{"4":{"df":1,"docs":{"199":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"v":{"6":{"4":{"df":0,"docs":{},"g":{"c":{"df":1,"docs":{"199":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"s":{"3":{"9":{"0":{"df":0,"docs":{},"x":{"df":1,"docs":{"199":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"/":{"a":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"6":{"4":{"df":1,"docs":{"130":{"tf":2.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":5,"docs":{"121":{"tf":1.0},"122":{"tf":1.0},"124":{"tf":1.0},"130":{"tf":1.4142135623730951},"173":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"a":{"df":6,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"130":{"tf":4.242640687119285},"173":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"3":{"2":{"df":4,"docs":{"51":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0},"61":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":34,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"111":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.0},"12":{"tf":1.4142135623730951},"122":{"tf":1.4142135623730951},"130":{"tf":1.7320508075688772},"132":{"tf":2.23606797749979},"136":{"tf":1.0},"137":{"tf":5.0},"138":{"tf":2.449489742783178},"144":{"tf":1.0},"160":{"tf":1.0},"177":{"tf":1.7320508075688772},"188":{"tf":2.23606797749979},"195":{"tf":1.7320508075688772},"196":{"tf":1.7320508075688772},"197":{"tf":1.0},"198":{"tf":1.0},"200":{"tf":2.0},"204":{"tf":1.4142135623730951},"216":{"tf":1.7320508075688772},"217":{"tf":1.4142135623730951},"218":{"tf":1.4142135623730951},"221":{"tf":1.4142135623730951},"52":{"tf":1.0},"61":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"k":{"df":6,"docs":{"22":{"tf":2.0},"24":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951}}}}},"df":6,"docs":{"17":{"tf":1.0},"20":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"53":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"m":{"df":5,"docs":{"214":{"tf":2.0},"219":{"tf":1.4142135623730951},"220":{"tf":1.0},"221":{"tf":2.8284271247461903},"234":{"tf":1.7320508075688772}}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":3,"docs":{"136":{"tf":1.0},"211":{"tf":1.0},"213":{"tf":1.0}}},"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"143":{"tf":1.0}}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"121":{"tf":1.0}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"211":{"tf":1.0},"212":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"227":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"224":{"tf":1.0},"225":{"tf":1.0},"234":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"232":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"n":{"d":{"df":1,"docs":{"154":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"m":{"df":6,"docs":{"0":{"tf":1.0},"112":{"tf":1.0},"131":{"tf":1.4142135623730951},"138":{"tf":1.0},"143":{"tf":1.0},"55":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"147":{"tf":2.23606797749979},"6":{"tf":1.0}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"157":{"tf":1.0}}}}}}}}}},"s":{"df":0,"docs":{},"t":{".":{"c":{"df":1,"docs":{"128":{"tf":1.0}}},"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"128":{"tf":2.0}}}}},"df":0,"docs":{}}},"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"194":{"tf":1.0}}}},"df":0,"docs":{}},"df":36,"docs":{"0":{"tf":1.0},"130":{"tf":1.0},"137":{"tf":3.0},"138":{"tf":2.449489742783178},"151":{"tf":1.0},"153":{"tf":1.0},"154":{"tf":1.0},"176":{"tf":2.0},"177":{"tf":1.0},"178":{"tf":4.0},"179":{"tf":2.6457513110645907},"180":{"tf":3.605551275463989},"181":{"tf":2.6457513110645907},"182":{"tf":1.0},"183":{"tf":4.898979485566356},"184":{"tf":3.3166247903554},"185":{"tf":3.7416573867739413},"187":{"tf":2.6457513110645907},"188":{"tf":1.4142135623730951},"190":{"tf":2.8284271247461903},"191":{"tf":3.872983346207417},"193":{"tf":3.1622776601683795},"194":{"tf":3.0},"195":{"tf":1.0},"199":{"tf":1.0},"200":{"tf":2.0},"202":{"tf":1.0},"203":{"tf":1.4142135623730951},"205":{"tf":1.4142135623730951},"212":{"tf":1.0},"216":{"tf":2.0},"217":{"tf":1.0},"218":{"tf":2.23606797749979},"221":{"tf":1.0},"224":{"tf":1.0},"9":{"tf":1.7320508075688772}},"s":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"178":{"tf":1.0},"226":{"tf":1.4142135623730951}}}}},"/":{"*":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"183":{"tf":1.0}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"/":{"*":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"183":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"185":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"c":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"184":{"tf":1.0}},"e":{"/":{"*":{".":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"184":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"184":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"180":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"180":{"tf":1.4142135623730951},"184":{"tf":2.23606797749979}}}}}}}},"x":{"df":0,"docs":{},"t":{"df":12,"docs":{"103":{"tf":1.0},"106":{"tf":1.0},"147":{"tf":1.4142135623730951},"159":{"tf":1.0},"225":{"tf":1.0},"39":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0},"99":{"tf":1.0}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":3,"docs":{"103":{"tf":1.0},"106":{"tf":1.0},"207":{"tf":1.0}}}},"t":{"'":{"df":8,"docs":{"115":{"tf":1.0},"130":{"tf":1.0},"138":{"tf":1.4142135623730951},"158":{"tf":1.0},"159":{"tf":1.0},"203":{"tf":1.0},"220":{"tf":1.0},"226":{"tf":1.0}},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"10":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"208":{"tf":1.0}}},"v":{"df":12,"docs":{"136":{"tf":1.0},"138":{"tf":1.0},"139":{"tf":1.4142135623730951},"145":{"tf":1.4142135623730951},"150":{"tf":1.0},"158":{"tf":1.4142135623730951},"165":{"tf":1.4142135623730951},"180":{"tf":1.0},"191":{"tf":1.0},"206":{"tf":1.0},"207":{"tf":1.0},"208":{"tf":1.7320508075688772}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"227":{"tf":1.0}}}},"i":{"df":1,"docs":{"131":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"'":{"df":13,"docs":{"137":{"tf":1.0},"138":{"tf":1.0},"158":{"tf":1.0},"164":{"tf":1.0},"165":{"tf":1.0},"166":{"tf":1.0},"178":{"tf":1.0},"180":{"tf":1.0},"183":{"tf":1.0},"222":{"tf":1.0},"225":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"172":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"f":{"df":1,"docs":{"164":{"tf":1.0}}}}}},"y":{"'":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"160":{"tf":1.0}}}},"r":{"df":8,"docs":{"142":{"tf":1.0},"145":{"tf":1.0},"155":{"tf":1.0},"157":{"tf":1.0},"159":{"tf":1.0},"165":{"tf":1.0},"188":{"tf":1.0},"221":{"tf":1.0}}},"v":{"df":2,"docs":{"146":{"tf":1.0},"220":{"tf":1.0}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":18,"docs":{"0":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.4142135623730951},"117":{"tf":1.0},"126":{"tf":1.0},"130":{"tf":1.4142135623730951},"144":{"tf":1.0},"153":{"tf":1.0},"155":{"tf":1.7320508075688772},"158":{"tf":1.7320508075688772},"160":{"tf":1.0},"163":{"tf":1.0},"169":{"tf":1.0},"194":{"tf":1.0},"201":{"tf":1.0},"212":{"tf":1.0},"217":{"tf":1.0},"38":{"tf":1.0}}},"k":{"df":4,"docs":{"14":{"tf":1.0},"184":{"tf":1.0},"220":{"tf":1.0},"221":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":10,"docs":{"134":{"tf":1.4142135623730951},"158":{"tf":1.0},"170":{"tf":1.0},"211":{"tf":1.0},"220":{"tf":1.0},"222":{"tf":1.0},"223":{"tf":1.0},"91":{"tf":1.0},"94":{"tf":1.0},"97":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":17,"docs":{"130":{"tf":1.4142135623730951},"131":{"tf":1.7320508075688772},"135":{"tf":1.0},"150":{"tf":1.0},"155":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.0},"166":{"tf":1.0},"167":{"tf":1.0},"183":{"tf":1.0},"192":{"tf":1.0},"201":{"tf":1.0},"203":{"tf":1.0},"204":{"tf":1.0},"206":{"tf":1.0},"208":{"tf":1.0},"224":{"tf":1.0}},"t":{"df":2,"docs":{"157":{"tf":1.0},"158":{"tf":1.7320508075688772}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":7,"docs":{"111":{"tf":1.0},"13":{"tf":1.0},"137":{"tf":1.7320508075688772},"145":{"tf":1.0},"158":{"tf":1.7320508075688772},"166":{"tf":1.0},"32":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"232":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":5,"docs":{"100":{"tf":1.0},"136":{"tf":1.0},"138":{"tf":1.0},"205":{"tf":1.0},"222":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":4,"docs":{"20":{"tf":1.4142135623730951},"206":{"tf":1.0},"209":{"tf":1.0},"33":{"tf":1.0}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":33,"docs":{"109":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.7320508075688772},"130":{"tf":1.4142135623730951},"132":{"tf":1.4142135623730951},"134":{"tf":1.7320508075688772},"135":{"tf":1.0},"144":{"tf":1.4142135623730951},"159":{"tf":1.0},"160":{"tf":1.0},"164":{"tf":1.0},"165":{"tf":1.0},"187":{"tf":1.0},"190":{"tf":1.0},"191":{"tf":1.0},"192":{"tf":1.7320508075688772},"193":{"tf":1.4142135623730951},"195":{"tf":1.0},"2":{"tf":1.0},"203":{"tf":1.0},"204":{"tf":1.0},"206":{"tf":1.4142135623730951},"208":{"tf":1.0},"209":{"tf":1.0},"211":{"tf":1.0},"226":{"tf":1.0},"227":{"tf":1.0},"36":{"tf":1.0},"43":{"tf":1.0},"49":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"90":{"tf":1.0}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"131":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"110":{"tf":1.0}}}}}}}}},"u":{"df":2,"docs":{"121":{"tf":1.0},"122":{"tf":1.0}}}},"u":{"df":3,"docs":{"14":{"tf":1.0},"204":{"tf":1.0},"24":{"tf":1.0}},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"i":{"df":2,"docs":{"162":{"tf":1.0},"27":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"136":{"tf":2.23606797749979},"137":{"tf":2.8284271247461903},"138":{"tf":6.782329983125268},"139":{"tf":1.0},"140":{"tf":1.0},"150":{"tf":1.0}}}},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"163":{"tf":1.4142135623730951}}}}},"m":{"df":0,"docs":{},"e":{"df":46,"docs":{"100":{"tf":1.0},"109":{"tf":1.0},"11":{"tf":1.0},"110":{"tf":1.0},"112":{"tf":2.8284271247461903},"114":{"tf":1.0},"117":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":1.7320508075688772},"125":{"tf":1.0},"130":{"tf":1.7320508075688772},"131":{"tf":1.0},"135":{"tf":1.4142135623730951},"136":{"tf":1.0},"137":{"tf":3.3166247903554},"138":{"tf":3.0},"140":{"tf":1.4142135623730951},"141":{"tf":1.0},"142":{"tf":2.0},"143":{"tf":1.0},"145":{"tf":1.0},"148":{"tf":1.0},"151":{"tf":1.4142135623730951},"155":{"tf":1.0},"157":{"tf":1.4142135623730951},"158":{"tf":2.23606797749979},"159":{"tf":1.0},"160":{"tf":1.0},"162":{"tf":1.0},"164":{"tf":1.4142135623730951},"167":{"tf":1.0},"178":{"tf":1.0},"203":{"tf":1.4142135623730951},"208":{"tf":1.0},"209":{"tf":1.0},"220":{"tf":1.0},"221":{"tf":1.4142135623730951},"224":{"tf":1.7320508075688772},"225":{"tf":1.0},"226":{"tf":1.4142135623730951},"24":{"tf":1.0},"25":{"tf":1.4142135623730951},"34":{"tf":1.0},"40":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"=":{"df":0,"docs":{},"n":{"df":1,"docs":{"127":{"tf":1.0}}}},"df":3,"docs":{"127":{"tf":1.0},"22":{"tf":1.4142135623730951},"33":{"tf":1.0}}}}},"z":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"24":{"tf":1.0}}}}}}}},"m":{"df":0,"docs":{},"p":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":1,"docs":{"114":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"o":{"d":{"a":{"df":0,"docs":{},"y":{"df":6,"docs":{"131":{"tf":1.0},"134":{"tf":1.0},"146":{"tf":1.0},"158":{"tf":1.0},"163":{"tf":1.0},"224":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":9,"docs":{"115":{"tf":1.0},"152":{"tf":1.0},"155":{"tf":1.0},"206":{"tf":1.0},"43":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.0},"80":{"tf":1.0},"83":{"tf":1.4142135623730951}}}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{":":{":":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"55":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"24":{"tf":1.7320508075688772}}}}},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"14":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"128":{"tf":1.0}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"130":{"tf":1.7320508075688772},"171":{"tf":1.4142135623730951},"195":{"tf":1.7320508075688772},"197":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":21,"docs":{"1":{"tf":1.0},"109":{"tf":1.0},"111":{"tf":1.4142135623730951},"112":{"tf":1.0},"118":{"tf":1.7320508075688772},"128":{"tf":1.0},"135":{"tf":1.0},"146":{"tf":1.0},"173":{"tf":1.0},"178":{"tf":1.0},"193":{"tf":1.4142135623730951},"194":{"tf":2.23606797749979},"195":{"tf":1.0},"2":{"tf":1.4142135623730951},"206":{"tf":1.4142135623730951},"209":{"tf":1.0},"216":{"tf":1.0},"218":{"tf":1.4142135623730951},"62":{"tf":1.0},"63":{"tf":1.0},"90":{"tf":1.0}}}},"p":{"df":3,"docs":{"122":{"tf":1.0},"178":{"tf":1.0},"213":{"tf":1.0}}},"t":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"14":{"tf":1.0},"27":{"tf":1.4142135623730951},"29":{"tf":2.23606797749979},"34":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"u":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"99":{"tf":1.0}}}},"df":0,"docs":{}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"209":{"tf":1.0},"231":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"a":{"c":{"df":0,"docs":{},"e":{"df":3,"docs":{"13":{"tf":2.449489742783178},"130":{"tf":1.4142135623730951},"163":{"tf":1.4142135623730951}}},"k":{"df":1,"docs":{"210":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"155":{"tf":1.0},"191":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"130":{"tf":1.0}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":2,"docs":{"131":{"tf":1.4142135623730951},"143":{"tf":1.4142135623730951}}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"144":{"tf":1.0}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"160":{"tf":3.1622776601683795},"163":{"tf":1.0}}}}}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"—":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"144":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"194":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"172":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":7,"docs":{"130":{"tf":1.0},"147":{"tf":1.0},"159":{"tf":1.0},"162":{"tf":1.0},"167":{"tf":1.0},"187":{"tf":1.0},"192":{"tf":1.0}}}},"df":0,"docs":{}}}},"p":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"111":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"r":{"df":1,"docs":{"111":{"tf":1.4142135623730951}}},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"111":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"\\":{"df":0,"docs":{},"n":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":20,"docs":{"109":{"tf":1.0},"111":{"tf":1.7320508075688772},"128":{"tf":1.0},"151":{"tf":1.0},"159":{"tf":1.7320508075688772},"161":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":3.0},"194":{"tf":2.23606797749979},"39":{"tf":1.0},"49":{"tf":1.7320508075688772},"62":{"tf":1.0},"63":{"tf":2.0},"70":{"tf":3.1622776601683795},"73":{"tf":3.0},"76":{"tf":4.47213595499958},"79":{"tf":2.449489742783178},"83":{"tf":3.605551275463989},"85":{"tf":3.0},"88":{"tf":3.0}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"63":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":1,"docs":{"63":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"24":{"tf":1.0},"25":{"tf":1.0},"34":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":2,"docs":{"142":{"tf":1.0},"187":{"tf":1.0}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"130":{"tf":1.4142135623730951}}}},"df":7,"docs":{"130":{"tf":1.0},"131":{"tf":1.0},"163":{"tf":1.0},"192":{"tf":1.0},"207":{"tf":1.0},"25":{"tf":1.0},"6":{"tf":1.0}},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"158":{"tf":1.0},"163":{"tf":1.4142135623730951},"224":{"tf":1.7320508075688772},"225":{"tf":2.0},"226":{"tf":1.0}}}}}},"m":{"df":1,"docs":{"130":{"tf":1.0}}},"v":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"_":{"c":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"203":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":2,"docs":{"134":{"tf":1.0},"53":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"231":{"tf":1.0}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"110":{"tf":1.0},"153":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"e":{"df":4,"docs":{"14":{"tf":1.0},"15":{"tf":1.4142135623730951},"163":{"tf":1.0},"85":{"tf":1.0}}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"131":{"tf":1.0},"132":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"150":{"tf":1.4142135623730951},"206":{"tf":2.23606797749979}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":2,"docs":{"14":{"tf":1.4142135623730951},"164":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"119":{"tf":1.0},"138":{"tf":1.4142135623730951},"204":{"tf":1.0}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"132":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"38":{"tf":1.0},"93":{"tf":1.0}}}}}}},"w":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":7,"docs":{"195":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"128":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":23,"docs":{"103":{"tf":1.0},"106":{"tf":1.0},"113":{"tf":1.0},"131":{"tf":1.0},"134":{"tf":1.0},"158":{"tf":1.0},"160":{"tf":1.0},"164":{"tf":1.0},"187":{"tf":1.0},"224":{"tf":1.0},"24":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":1.0},"59":{"tf":1.4142135623730951},"61":{"tf":1.0},"71":{"tf":1.0},"83":{"tf":1.4142135623730951},"90":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0},"99":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"158":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":34,"docs":{"137":{"tf":1.7320508075688772},"144":{"tf":1.0},"147":{"tf":1.0},"15":{"tf":1.0},"151":{"tf":1.0},"158":{"tf":2.8284271247461903},"159":{"tf":2.8284271247461903},"16":{"tf":1.0},"160":{"tf":2.0},"161":{"tf":2.23606797749979},"162":{"tf":1.7320508075688772},"165":{"tf":1.0},"166":{"tf":1.0},"167":{"tf":1.4142135623730951},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"194":{"tf":1.4142135623730951},"20":{"tf":1.0},"21":{"tf":1.0},"216":{"tf":1.0},"217":{"tf":1.4142135623730951},"22":{"tf":1.0},"23":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951}}},"i":{"c":{"df":7,"docs":{"0":{"tf":1.0},"112":{"tf":1.0},"134":{"tf":1.0},"158":{"tf":1.4142135623730951},"162":{"tf":1.4142135623730951},"204":{"tf":1.0},"207":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":1,"docs":{"222":{"tf":1.0}}}}}},"u":{"3":{"2":{"df":4,"docs":{"111":{"tf":1.7320508075688772},"117":{"tf":1.4142135623730951},"122":{"tf":1.4142135623730951},"40":{"tf":1.0}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"/":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"195":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"df":1,"docs":{"126":{"tf":1.0}},"n":{"df":0,"docs":{},"t":{"6":{"4":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"_":{"df":0,"docs":{},"t":{"df":7,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.4142135623730951},"85":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"n":{"a":{"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":3,"docs":{"231":{"tf":1.0},"232":{"tf":1.0},"234":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"151":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"194":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"151":{"tf":1.0}}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"144":{"tf":1.0}}}}},"r":{"df":7,"docs":{"110":{"tf":1.0},"131":{"tf":1.0},"138":{"tf":1.7320508075688772},"158":{"tf":1.0},"195":{"tf":1.0},"200":{"tf":1.4142135623730951},"226":{"tf":1.0}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"150":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"df":6,"docs":{"119":{"tf":1.0},"131":{"tf":1.0},"212":{"tf":1.0},"213":{"tf":1.0},"219":{"tf":1.0},"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"k":{"df":2,"docs":{"138":{"tf":1.0},"140":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"210":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"151":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"151":{"tf":1.0}}}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"144":{"tf":1.0}}}},"t":{"df":3,"docs":{"130":{"tf":1.7320508075688772},"158":{"tf":1.0},"183":{"tf":1.4142135623730951}}},"x":{"df":1,"docs":{"160":{"tf":1.0}}}},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"/":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"b":{".":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":2,"docs":{"61":{"tf":1.0},"85":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},">":{"!":{"_":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"128":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"111":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"128":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":2,"docs":{"111":{"tf":1.0},"128":{"tf":1.0}}}}},"df":0,"docs":{}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{":":{":":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"h":{"2":{"4":{"3":{"3":{"6":{"df":0,"docs":{},"e":{"9":{"5":{"0":{"df":0,"docs":{},"f":{"b":{"9":{"7":{"d":{"1":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{":":{":":{"df":0,"docs":{},"h":{"6":{"2":{"c":{"2":{"c":{"2":{"b":{"b":{"0":{"5":{"4":{"d":{"a":{"7":{"df":0,"docs":{},"e":{"1":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"h":{"5":{"3":{"c":{"a":{"5":{"b":{"df":0,"docs":{},"f":{"4":{"8":{"b":{"4":{"2":{"8":{"8":{"9":{"5":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"111":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"t":{"d":{":":{":":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{":":{":":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"{":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"}":{"df":0,"docs":{},"}":{":":{":":{"df":0,"docs":{},"h":{"1":{"8":{"5":{"3":{"0":{"0":{"4":{"6":{"1":{"9":{"8":{"7":{"9":{"c":{"df":0,"docs":{},"f":{"d":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{":":{":":{"df":0,"docs":{},"h":{"5":{"8":{"df":0,"docs":{},"e":{"7":{"d":{"0":{"b":{"3":{"d":{"7":{"0":{"df":0,"docs":{},"e":{"9":{"5":{"b":{"6":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"h":{"7":{"d":{"2":{"5":{"6":{"df":0,"docs":{},"f":{"2":{"1":{"9":{"0":{"2":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"3":{"2":{"b":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"{":{"df":0,"docs":{},"{":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"}":{"df":0,"docs":{},"}":{":":{":":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"8":{"6":{"df":0,"docs":{},"e":{"b":{"1":{"b":{"6":{"a":{"c":{"6":{"d":{"7":{"5":{"0":{"1":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{":":{":":{"df":0,"docs":{},"h":{"2":{"1":{"df":0,"docs":{},"f":{"6":{"a":{"1":{"d":{"8":{"df":0,"docs":{},"f":{"3":{"6":{"3":{"3":{"b":{"5":{"4":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{":":{":":{"b":{"a":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"h":{"7":{"a":{"d":{"1":{"2":{"df":0,"docs":{},"f":{"9":{"c":{"5":{"b":{"7":{"3":{"0":{"d":{"1":{"7":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"z":{":":{":":{"df":0,"docs":{},"h":{"8":{"5":{"9":{"df":0,"docs":{},"f":{"3":{"9":{"b":{"6":{"5":{"3":{"8":{"9":{"c":{"0":{"7":{"7":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{":":{":":{"df":0,"docs":{},"h":{"a":{"6":{"9":{"c":{"9":{"5":{"7":{"2":{"3":{"6":{"1":{"1":{"c":{"1":{"a":{"0":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"h":{"d":{"df":0,"docs":{},"f":{"c":{"d":{"9":{"df":0,"docs":{},"f":{"2":{"d":{"1":{"5":{"0":{"df":0,"docs":{},"f":{"c":{"3":{"d":{"c":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":10,"docs":{"131":{"tf":1.0},"132":{"tf":1.0},"137":{"tf":2.23606797749979},"138":{"tf":1.0},"177":{"tf":2.0},"196":{"tf":1.7320508075688772},"199":{"tf":1.7320508075688772},"200":{"tf":1.7320508075688772},"61":{"tf":1.7320508075688772},"85":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"145":{"tf":1.0},"190":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"k":{"df":1,"docs":{"144":{"tf":1.0}}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"138":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"138":{"tf":1.0},"193":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"173":{"tf":1.0},"39":{"tf":1.0}}}}}}},"p":{"a":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"221":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"163":{"tf":1.0},"63":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"193":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":3,"docs":{"138":{"tf":1.7320508075688772},"190":{"tf":1.0},"193":{"tf":1.0}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":2,"docs":{"114":{"tf":1.0},"126":{"tf":1.0}}}}}}}},"s":{"a":{"df":0,"docs":{},"f":{"df":5,"docs":{"150":{"tf":1.0},"157":{"tf":2.449489742783178},"158":{"tf":1.4142135623730951},"163":{"tf":1.0},"209":{"tf":1.0}},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"150":{"tf":1.4142135623730951},"151":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"145":{"tf":1.0}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"137":{"tf":2.23606797749979}}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"187":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"132":{"tf":1.0},"137":{"tf":1.0}}}}}}},"r":{"df":2,"docs":{"150":{"tf":1.0},"154":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":5,"docs":{"158":{"tf":1.0},"190":{"tf":1.0},"222":{"tf":1.4142135623730951},"226":{"tf":1.0},"31":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"208":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"143":{"tf":1.0},"147":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"158":{"tf":1.0}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"231":{"tf":1.0}}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"130":{"tf":1.7320508075688772},"137":{"tf":1.0},"159":{"tf":1.0},"163":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"p":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"227":{"tf":1.0}}}}},"d":{"a":{"df":0,"docs":{},"t":{"df":24,"docs":{"122":{"tf":1.0},"130":{"tf":1.4142135623730951},"134":{"tf":1.0},"138":{"tf":1.0},"142":{"tf":1.4142135623730951},"170":{"tf":1.0},"180":{"tf":1.4142135623730951},"184":{"tf":1.0},"2":{"tf":1.0},"205":{"tf":1.4142135623730951},"206":{"tf":2.0},"207":{"tf":2.6457513110645907},"208":{"tf":1.7320508075688772},"209":{"tf":1.7320508075688772},"21":{"tf":1.0},"212":{"tf":1.0},"224":{"tf":1.0},"225":{"tf":1.4142135623730951},"226":{"tf":1.4142135623730951},"227":{"tf":1.0},"25":{"tf":1.0},"3":{"tf":1.0},"31":{"tf":1.4142135623730951},"34":{"tf":1.0}}}},"df":0,"docs":{}},"df":31,"docs":{"114":{"tf":1.0},"115":{"tf":1.4142135623730951},"116":{"tf":1.0},"117":{"tf":1.0},"127":{"tf":1.0},"130":{"tf":1.0},"152":{"tf":1.0},"157":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.4142135623730951},"16":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":1.0},"167":{"tf":1.0},"188":{"tf":1.0},"21":{"tf":1.0},"224":{"tf":1.0},"34":{"tf":1.0},"39":{"tf":1.4142135623730951},"43":{"tf":1.0},"49":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":2.0},"73":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"84":{"tf":1.0},"96":{"tf":1.0},"99":{"tf":1.0}},"g":{"df":0,"docs":{},"r":{"a":{"d":{"df":1,"docs":{"134":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"145":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"151":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":1,"docs":{"224":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"159":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"184":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"137":{"tf":1.0}}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"131":{"tf":1.0},"209":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":6,"docs":{"130":{"tf":1.0},"137":{"tf":1.4142135623730951},"140":{"tf":1.0},"17":{"tf":1.0},"20":{"tf":1.4142135623730951},"33":{"tf":1.7320508075688772}}}},"df":125,"docs":{"0":{"tf":2.449489742783178},"1":{"tf":1.4142135623730951},"10":{"tf":1.0},"102":{"tf":1.4142135623730951},"103":{"tf":1.0},"105":{"tf":1.4142135623730951},"108":{"tf":1.0},"11":{"tf":1.4142135623730951},"110":{"tf":1.7320508075688772},"111":{"tf":1.0},"112":{"tf":1.4142135623730951},"113":{"tf":1.0},"114":{"tf":1.7320508075688772},"115":{"tf":2.0},"116":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.4142135623730951},"119":{"tf":1.0},"12":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":1.4142135623730951},"124":{"tf":1.0},"125":{"tf":1.4142135623730951},"126":{"tf":1.7320508075688772},"127":{"tf":1.7320508075688772},"128":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"130":{"tf":2.8284271247461903},"131":{"tf":2.23606797749979},"132":{"tf":1.0},"136":{"tf":1.0},"137":{"tf":1.0},"138":{"tf":1.4142135623730951},"14":{"tf":2.0},"140":{"tf":1.0},"142":{"tf":1.4142135623730951},"145":{"tf":2.23606797749979},"147":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"150":{"tf":1.0},"151":{"tf":1.7320508075688772},"155":{"tf":1.0},"157":{"tf":1.0},"158":{"tf":2.23606797749979},"159":{"tf":1.0},"160":{"tf":1.4142135623730951},"161":{"tf":1.4142135623730951},"163":{"tf":2.449489742783178},"164":{"tf":1.0},"165":{"tf":1.7320508075688772},"166":{"tf":1.4142135623730951},"167":{"tf":2.0},"177":{"tf":1.0},"178":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"181":{"tf":1.0},"183":{"tf":1.0},"184":{"tf":1.7320508075688772},"185":{"tf":1.7320508075688772},"187":{"tf":1.0},"19":{"tf":1.4142135623730951},"190":{"tf":1.0},"193":{"tf":1.0},"194":{"tf":1.0},"196":{"tf":1.0},"199":{"tf":1.0},"2":{"tf":1.0},"200":{"tf":1.0},"203":{"tf":1.4142135623730951},"204":{"tf":2.23606797749979},"205":{"tf":1.0},"206":{"tf":1.7320508075688772},"209":{"tf":1.7320508075688772},"210":{"tf":1.0},"212":{"tf":1.0},"216":{"tf":1.4142135623730951},"217":{"tf":1.4142135623730951},"218":{"tf":1.0},"221":{"tf":1.0},"224":{"tf":1.4142135623730951},"226":{"tf":1.0},"231":{"tf":1.4142135623730951},"233":{"tf":1.0},"25":{"tf":1.0},"3":{"tf":1.0},"31":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"39":{"tf":2.449489742783178},"4":{"tf":1.0},"40":{"tf":2.23606797749979},"41":{"tf":1.0},"43":{"tf":2.0},"46":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"52":{"tf":1.7320508075688772},"53":{"tf":2.0},"55":{"tf":2.449489742783178},"59":{"tf":2.0},"6":{"tf":1.0},"61":{"tf":1.4142135623730951},"63":{"tf":1.0},"64":{"tf":1.4142135623730951},"66":{"tf":2.0},"70":{"tf":1.4142135623730951},"73":{"tf":1.0},"74":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"79":{"tf":1.4142135623730951},"83":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.4142135623730951},"88":{"tf":1.0},"89":{"tf":1.7320508075688772},"90":{"tf":1.0},"92":{"tf":1.7320508075688772},"93":{"tf":2.449489742783178},"95":{"tf":1.4142135623730951},"98":{"tf":1.0}},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"211":{"tf":1.0}}}}}}},"r":{"df":13,"docs":{"134":{"tf":1.0},"143":{"tf":1.0},"146":{"tf":1.0},"147":{"tf":2.0},"151":{"tf":1.4142135623730951},"157":{"tf":1.0},"198":{"tf":1.0},"2":{"tf":1.4142135623730951},"206":{"tf":1.0},"211":{"tf":1.0},"224":{"tf":1.0},"25":{"tf":1.0},"3":{"tf":1.7320508075688772}}}},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"43":{"tf":1.0}}}},"r":{"/":{"a":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"6":{"4":{"df":1,"docs":{"199":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":1,"docs":{"194":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"v":{"6":{"4":{"df":1,"docs":{"199":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"s":{"3":{"9":{"0":{"df":0,"docs":{},"x":{"df":1,"docs":{"199":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"u":{"a":{"df":0,"docs":{},"l":{"df":6,"docs":{"110":{"tf":1.0},"114":{"tf":1.7320508075688772},"115":{"tf":1.7320508075688772},"126":{"tf":1.0},"194":{"tf":1.0},"220":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"l":{".":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"3":{"2":{"df":1,"docs":{"96":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":2,"docs":{"63":{"tf":2.0},"96":{"tf":1.0}},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"128":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"d":{"df":6,"docs":{"150":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":2.23606797749979},"163":{"tf":1.0},"165":{"tf":1.0},"187":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":20,"docs":{"114":{"tf":1.0},"115":{"tf":1.0},"119":{"tf":1.0},"126":{"tf":1.0},"137":{"tf":1.4142135623730951},"14":{"tf":2.0},"15":{"tf":1.0},"150":{"tf":2.0},"151":{"tf":1.0},"158":{"tf":3.3166247903554},"159":{"tf":2.0},"161":{"tf":1.4142135623730951},"162":{"tf":1.0},"165":{"tf":1.0},"166":{"tf":2.0},"39":{"tf":1.0},"43":{"tf":1.0},"64":{"tf":1.4142135623730951},"66":{"tf":1.7320508075688772},"86":{"tf":1.4142135623730951}}}},"r":{"df":1,"docs":{"93":{"tf":1.7320508075688772}},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":7,"docs":{"110":{"tf":1.4142135623730951},"111":{"tf":1.4142135623730951},"13":{"tf":1.0},"130":{"tf":1.4142135623730951},"132":{"tf":1.0},"222":{"tf":1.0},"85":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"118":{"tf":1.0},"226":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"df":8,"docs":{"131":{"tf":1.0},"143":{"tf":1.0},"156":{"tf":1.0},"159":{"tf":1.0},"2":{"tf":1.0},"213":{"tf":1.0},"39":{"tf":1.0},"70":{"tf":1.0}}}}}}},"df":4,"docs":{"122":{"tf":1.0},"137":{"tf":1.0},"160":{"tf":1.0},"2":{"tf":1.0}},"e":{"c":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"u":{"3":{"2":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"165":{"tf":1.0}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"137":{"tf":1.0},"163":{"tf":1.0},"165":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"192":{"tf":1.0}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"df":9,"docs":{"113":{"tf":1.0},"138":{"tf":1.0},"152":{"tf":1.0},"157":{"tf":1.0},"158":{"tf":1.4142135623730951},"163":{"tf":1.7320508075688772},"183":{"tf":1.0},"192":{"tf":1.0},"194":{"tf":1.0}},"f":{"df":1,"docs":{"138":{"tf":1.0}},"i":{"df":2,"docs":{"162":{"tf":1.0},"208":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":27,"docs":{"118":{"tf":1.4142135623730951},"125":{"tf":1.7320508075688772},"134":{"tf":2.23606797749979},"135":{"tf":1.0},"157":{"tf":1.0},"165":{"tf":1.0},"177":{"tf":1.0},"184":{"tf":1.0},"185":{"tf":1.0},"191":{"tf":1.0},"2":{"tf":1.0},"203":{"tf":1.7320508075688772},"204":{"tf":1.0},"205":{"tf":2.0},"206":{"tf":1.0},"208":{"tf":1.0},"212":{"tf":1.0},"214":{"tf":1.0},"218":{"tf":1.0},"224":{"tf":1.7320508075688772},"225":{"tf":2.0},"226":{"tf":1.7320508075688772},"227":{"tf":1.0},"235":{"tf":1.0},"39":{"tf":1.4142135623730951},"61":{"tf":1.0},"93":{"tf":1.0}}}}}}},"t":{"df":4,"docs":{"206":{"tf":3.1622776601683795},"207":{"tf":2.0},"208":{"tf":3.4641016151377544},"209":{"tf":3.0}}}},"i":{"a":{"df":18,"docs":{"0":{"tf":1.0},"111":{"tf":1.4142135623730951},"121":{"tf":1.4142135623730951},"128":{"tf":1.0},"130":{"tf":1.7320508075688772},"132":{"tf":1.0},"138":{"tf":1.0},"153":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":1.4142135623730951},"184":{"tf":1.0},"192":{"tf":1.0},"204":{"tf":1.0},"224":{"tf":1.0},"233":{"tf":1.0},"60":{"tf":1.0},"8":{"tf":1.4142135623730951},"84":{"tf":1.0}}},"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"209":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":6,"docs":{"112":{"tf":1.0},"118":{"tf":1.0},"126":{"tf":1.0},"127":{"tf":1.0},"131":{"tf":1.0},"150":{"tf":1.4142135623730951}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"231":{"tf":1.0}}}}}}}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"142":{"tf":1.0},"144":{"tf":1.0},"164":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"128":{"tf":1.0},"162":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"123":{"tf":1.0}}}},"df":0,"docs":{}}}},"m":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"165":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":4,"docs":{"158":{"tf":2.8284271247461903},"159":{"tf":1.0},"162":{"tf":1.4142135623730951},"167":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"165":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"158":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"165":{"tf":1.4142135623730951}}}}}}}}}}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"158":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"158":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"s":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":2,"docs":{"161":{"tf":2.449489742783178},"162":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"i":{"d":{"df":8,"docs":{"70":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951},"76":{"tf":3.4641016151377544},"79":{"tf":1.4142135623730951},"83":{"tf":2.0},"85":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951},"93":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":3,"docs":{"130":{"tf":1.0},"131":{"tf":1.4142135623730951},"193":{"tf":1.0}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"123":{"tf":1.0}}},"df":8,"docs":{"112":{"tf":1.0},"118":{"tf":2.8284271247461903},"119":{"tf":1.7320508075688772},"120":{"tf":1.7320508075688772},"121":{"tf":2.449489742783178},"122":{"tf":2.0},"123":{"tf":1.7320508075688772},"124":{"tf":2.0}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"147":{"tf":1.0},"150":{"tf":3.3166247903554},"151":{"tf":1.7320508075688772}}}}}}}},"w":{"a":{"b":{"df":0,"docs":{},"t":{"df":1,"docs":{"216":{"tf":1.0}}}},"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"193":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"190":{"tf":1.0},"220":{"tf":1.0}}}},"l":{"df":0,"docs":{},"k":{"df":1,"docs":{"159":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"t":{"df":23,"docs":{"1":{"tf":1.0},"112":{"tf":1.0},"114":{"tf":1.7320508075688772},"115":{"tf":2.0},"116":{"tf":1.7320508075688772},"126":{"tf":1.7320508075688772},"132":{"tf":1.7320508075688772},"137":{"tf":1.0},"143":{"tf":1.0},"151":{"tf":1.0},"154":{"tf":1.0},"172":{"tf":1.0},"184":{"tf":1.0},"195":{"tf":1.0},"2":{"tf":1.4142135623730951},"212":{"tf":1.0},"219":{"tf":1.0},"3":{"tf":1.4142135623730951},"39":{"tf":1.0},"4":{"tf":1.0},"59":{"tf":1.0},"96":{"tf":1.0},"99":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"(":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{":":{":":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"204":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"_":{"c":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"203":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":3,"docs":{"203":{"tf":3.605551275463989},"204":{"tf":2.0},"214":{"tf":1.0}}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"135":{"tf":1.0}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"'":{"df":1,"docs":{"146":{"tf":1.0}}},".":{"c":{"df":1,"docs":{"79":{"tf":1.0}}},"df":0,"docs":{},"h":{"df":2,"docs":{"79":{"tf":1.0},"83":{"tf":1.0}}},"r":{"df":1,"docs":{"51":{"tf":1.0}}}},":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"2":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}}}}}},"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{":":{":":{"a":{"d":{"d":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"52":{"tf":1.0},"53":{"tf":1.0},"59":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"52":{"tf":1.0},"59":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"{":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":1,"docs":{"53":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"53":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"v":{"(":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":2,"docs":{"79":{"tf":1.0},"83":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"(":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":2,"docs":{"79":{"tf":1.0},"83":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":2,"docs":{"79":{"tf":1.0},"83":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":2,"docs":{"79":{"tf":1.0},"83":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":2,"docs":{"79":{"tf":1.0},"83":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"79":{"tf":1.0},"83":{"tf":1.0}}}}},"t":{"df":2,"docs":{"79":{"tf":1.0},"83":{"tf":1.0}}}},"df":2,"docs":{"79":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951}}}}}}},"t":{"df":0,"docs":{},"x":{"df":1,"docs":{"55":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"1":{"=":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"1":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{".":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"218":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":4,"docs":{"137":{"tf":1.0},"192":{"tf":1.0},"58":{"tf":1.0},"82":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"137":{"tf":1.0}}}}}}},"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"52":{"tf":1.0},"55":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"(":{")":{".":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"_":{"df":0,"docs":{},"p":{"1":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"52":{"tf":1.0},"53":{"tf":1.0},"59":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"53":{"tf":1.7320508075688772}}}}},"df":29,"docs":{"0":{"tf":1.7320508075688772},"1":{"tf":1.0},"128":{"tf":1.0},"13":{"tf":1.0},"131":{"tf":2.23606797749979},"132":{"tf":1.0},"137":{"tf":6.557438524302},"146":{"tf":1.4142135623730951},"147":{"tf":1.0},"151":{"tf":1.7320508075688772},"178":{"tf":1.7320508075688772},"181":{"tf":2.23606797749979},"183":{"tf":1.0},"185":{"tf":2.0},"192":{"tf":1.0},"218":{"tf":2.0},"221":{"tf":1.4142135623730951},"50":{"tf":1.7320508075688772},"51":{"tf":1.4142135623730951},"52":{"tf":2.6457513110645907},"53":{"tf":2.0},"54":{"tf":1.7320508075688772},"55":{"tf":3.0},"59":{"tf":2.23606797749979},"7":{"tf":1.0},"77":{"tf":1.4142135623730951},"79":{"tf":2.8284271247461903},"8":{"tf":1.4142135623730951},"83":{"tf":2.0}},"p":{"1":{"/":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{".":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":4,"docs":{"51":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0},"79":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":1,"docs":{"55":{"tf":1.0}}}}},"df":6,"docs":{"111":{"tf":1.0},"117":{"tf":1.0},"122":{"tf":1.4142135623730951},"137":{"tf":1.0},"177":{"tf":1.4142135623730951},"218":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"m":{"'":{"df":1,"docs":{"151":{"tf":1.0}}},".":{"c":{"df":1,"docs":{"85":{"tf":1.0}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":3,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"79":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"h":{"df":7,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":3,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"79":{"tf":1.0}}}}}},"3":{"2":{"df":7,"docs":{"111":{"tf":1.0},"117":{"tf":1.0},"122":{"tf":1.4142135623730951},"137":{"tf":1.0},"177":{"tf":2.23606797749979},"218":{"tf":1.4142135623730951},"61":{"tf":1.0}}},"df":0,"docs":{}},"_":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"&":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"76":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":7,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"1":{"_":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"83":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"2":{"_":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"83":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":3,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"79":{"tf":1.0}}}},"t":{"df":5,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"d":{"(":{"&":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"85":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"79":{"tf":1.0}}}},"t":{"df":5,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}},"t":{"df":7,"docs":{"70":{"tf":1.7320508075688772},"73":{"tf":1.7320508075688772},"76":{"tf":1.7320508075688772},"79":{"tf":1.4142135623730951},"83":{"tf":2.23606797749979},"85":{"tf":1.4142135623730951},"88":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"85":{"tf":1.0}}}}},"t":{"df":2,"docs":{"70":{"tf":1.0},"85":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":7,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"85":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":6,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0}}}}},"t":{"df":7,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"88":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"_":{"0":{"_":{"0":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"_":{"2":{"(":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"88":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":2,"docs":{"70":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"76":{"tf":1.0}}}}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"&":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}}}},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":5,"docs":{"70":{"tf":1.0},"76":{"tf":1.4142135623730951},"79":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":7,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"t":{"df":7,"docs":{"70":{"tf":2.0},"73":{"tf":1.7320508075688772},"76":{"tf":2.449489742783178},"79":{"tf":1.7320508075688772},"83":{"tf":1.7320508075688772},"85":{"tf":1.7320508075688772},"88":{"tf":2.23606797749979}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"88":{"tf":1.0}}},"df":0,"docs":{}},"6":{"4":{"df":1,"docs":{"88":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":69,"docs":{"0":{"tf":2.0},"102":{"tf":1.4142135623730951},"105":{"tf":1.4142135623730951},"106":{"tf":1.0},"109":{"tf":1.7320508075688772},"11":{"tf":1.0},"110":{"tf":1.4142135623730951},"111":{"tf":2.449489742783178},"112":{"tf":1.7320508075688772},"114":{"tf":2.0},"115":{"tf":2.0},"117":{"tf":1.4142135623730951},"118":{"tf":1.0},"119":{"tf":1.0},"122":{"tf":1.0},"126":{"tf":1.0},"128":{"tf":2.23606797749979},"131":{"tf":1.4142135623730951},"137":{"tf":2.449489742783178},"138":{"tf":1.0},"150":{"tf":3.0},"151":{"tf":1.7320508075688772},"155":{"tf":1.0},"158":{"tf":3.1622776601683795},"159":{"tf":1.7320508075688772},"161":{"tf":1.0},"162":{"tf":2.23606797749979},"163":{"tf":4.0},"164":{"tf":1.0},"165":{"tf":1.4142135623730951},"166":{"tf":1.4142135623730951},"167":{"tf":1.0},"180":{"tf":1.4142135623730951},"184":{"tf":1.0},"187":{"tf":1.7320508075688772},"193":{"tf":2.0},"194":{"tf":3.0},"216":{"tf":2.0},"218":{"tf":1.4142135623730951},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":2.6457513110645907},"40":{"tf":2.23606797749979},"41":{"tf":1.0},"43":{"tf":2.23606797749979},"44":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.7320508075688772},"5":{"tf":1.0},"52":{"tf":1.7320508075688772},"55":{"tf":1.7320508075688772},"61":{"tf":2.23606797749979},"62":{"tf":1.0},"63":{"tf":1.4142135623730951},"64":{"tf":1.0},"68":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":2.449489742783178},"71":{"tf":1.0},"73":{"tf":1.7320508075688772},"74":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.4142135623730951},"96":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"x":{".":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"106":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"(":{"%":{"df":0,"docs":{},"{":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":1,"docs":{"106":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":1,"docs":{"105":{"tf":1.0}}}},"g":{"d":{"b":{"df":2,"docs":{"111":{"tf":1.0},"62":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":2,"docs":{"159":{"tf":1.0},"216":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"216":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":158,"docs":{"0":{"tf":3.1622776601683795},"1":{"tf":2.6457513110645907},"10":{"tf":1.4142135623730951},"102":{"tf":1.4142135623730951},"103":{"tf":2.23606797749979},"105":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.0},"11":{"tf":1.7320508075688772},"110":{"tf":2.23606797749979},"111":{"tf":2.23606797749979},"112":{"tf":2.23606797749979},"113":{"tf":1.0},"114":{"tf":2.23606797749979},"115":{"tf":2.6457513110645907},"116":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.4142135623730951},"119":{"tf":1.4142135623730951},"12":{"tf":1.0},"120":{"tf":1.4142135623730951},"121":{"tf":1.7320508075688772},"122":{"tf":2.0},"125":{"tf":1.0},"126":{"tf":2.0},"127":{"tf":1.4142135623730951},"128":{"tf":2.0},"129":{"tf":2.0},"13":{"tf":2.23606797749979},"130":{"tf":3.7416573867739413},"131":{"tf":3.7416573867739413},"132":{"tf":3.3166247903554},"134":{"tf":2.8284271247461903},"135":{"tf":3.4641016151377544},"136":{"tf":2.23606797749979},"137":{"tf":2.6457513110645907},"138":{"tf":4.47213595499958},"139":{"tf":2.23606797749979},"14":{"tf":2.0},"141":{"tf":1.0},"142":{"tf":2.23606797749979},"143":{"tf":1.7320508075688772},"145":{"tf":3.0},"146":{"tf":1.4142135623730951},"147":{"tf":1.0},"148":{"tf":1.7320508075688772},"149":{"tf":1.0},"150":{"tf":1.4142135623730951},"152":{"tf":1.7320508075688772},"153":{"tf":2.0},"154":{"tf":1.0},"156":{"tf":2.0},"157":{"tf":3.4641016151377544},"158":{"tf":1.7320508075688772},"159":{"tf":1.0},"160":{"tf":2.0},"161":{"tf":1.0},"163":{"tf":3.0},"164":{"tf":2.23606797749979},"165":{"tf":1.4142135623730951},"166":{"tf":1.7320508075688772},"167":{"tf":4.242640687119285},"168":{"tf":1.0},"169":{"tf":1.0},"170":{"tf":1.4142135623730951},"172":{"tf":1.0},"173":{"tf":1.7320508075688772},"174":{"tf":1.0},"175":{"tf":2.23606797749979},"176":{"tf":1.0},"178":{"tf":2.0},"179":{"tf":2.0},"18":{"tf":1.0},"180":{"tf":1.7320508075688772},"181":{"tf":1.7320508075688772},"183":{"tf":1.4142135623730951},"184":{"tf":1.7320508075688772},"185":{"tf":1.4142135623730951},"187":{"tf":1.0},"189":{"tf":1.0},"19":{"tf":1.0},"190":{"tf":1.0},"192":{"tf":1.7320508075688772},"193":{"tf":2.0},"194":{"tf":1.4142135623730951},"195":{"tf":1.0},"196":{"tf":1.0},"199":{"tf":1.0},"2":{"tf":2.8284271247461903},"200":{"tf":1.7320508075688772},"201":{"tf":1.0},"203":{"tf":1.7320508075688772},"204":{"tf":1.7320508075688772},"205":{"tf":1.4142135623730951},"206":{"tf":3.0},"207":{"tf":1.4142135623730951},"208":{"tf":1.4142135623730951},"209":{"tf":1.0},"216":{"tf":2.0},"217":{"tf":1.7320508075688772},"218":{"tf":2.23606797749979},"220":{"tf":1.0},"221":{"tf":2.6457513110645907},"223":{"tf":1.0},"224":{"tf":2.23606797749979},"227":{"tf":1.0},"3":{"tf":2.23606797749979},"34":{"tf":1.0},"36":{"tf":1.7320508075688772},"37":{"tf":1.4142135623730951},"39":{"tf":2.6457513110645907},"4":{"tf":1.0},"40":{"tf":1.7320508075688772},"41":{"tf":1.4142135623730951},"43":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.7320508075688772},"50":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.4142135623730951},"55":{"tf":2.0},"56":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":2.23606797749979},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"7":{"tf":2.6457513110645907},"70":{"tf":1.4142135623730951},"71":{"tf":1.0},"73":{"tf":1.4142135623730951},"74":{"tf":1.0},"76":{"tf":1.4142135623730951},"77":{"tf":1.0},"79":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772},"80":{"tf":1.0},"83":{"tf":1.4142135623730951},"84":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951},"9":{"tf":1.0},"90":{"tf":2.6457513110645907},"91":{"tf":1.4142135623730951},"92":{"tf":1.4142135623730951},"93":{"tf":1.7320508075688772},"94":{"tf":1.4142135623730951},"95":{"tf":1.4142135623730951},"97":{"tf":1.0}},"e":{"'":{"df":26,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"118":{"tf":1.0},"127":{"tf":1.0},"13":{"tf":1.0},"132":{"tf":1.0},"134":{"tf":1.7320508075688772},"136":{"tf":1.4142135623730951},"137":{"tf":1.7320508075688772},"138":{"tf":1.4142135623730951},"139":{"tf":1.0},"142":{"tf":1.7320508075688772},"143":{"tf":1.0},"148":{"tf":1.0},"150":{"tf":1.0},"154":{"tf":1.0},"157":{"tf":1.0},"162":{"tf":1.0},"172":{"tf":1.0},"176":{"tf":1.0},"192":{"tf":1.0},"204":{"tf":1.0},"205":{"tf":1.0},"206":{"tf":1.0},"223":{"tf":1.0},"224":{"tf":1.0}}},".":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"96":{"tf":1.0}}}}}}}}}},"d":{"b":{"df":0,"docs":{},"g":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"h":{"df":8,"docs":{"216":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":1,"docs":{"90":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"96":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"96":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"96":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}}}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"96":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}}}}},"/":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"194":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"216":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{":":{":":{"d":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"r":{"d":{"_":{"df":0,"docs":{},"s":{"df":1,"docs":{"164":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"_":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"216":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"r":{"d":{"_":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"164":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"r":{"d":{"_":{"df":0,"docs":{},"s":{"df":1,"docs":{"164":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"s":{"df":1,"docs":{"164":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"158":{"tf":1.0},"161":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"103":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{":":{":":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"160":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"103":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"158":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":2,"docs":{"158":{"tf":1.0},"159":{"tf":2.0}},"e":{"'":{"df":1,"docs":{"159":{"tf":1.0}}},".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"103":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"159":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"v":{"df":0,"docs":{},"m":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"158":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":1,"docs":{"167":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"158":{"tf":1.4142135623730951},"159":{"tf":1.0},"162":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"103":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"216":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"158":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"163":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"{":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"55":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"=":{"1":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":2,"docs":{"70":{"tf":1.0},"88":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"_":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"85":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"85":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"116":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":4,"docs":{"114":{"tf":1.0},"115":{"tf":1.0},"119":{"tf":1.0},"126":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"79":{"tf":1.0},"83":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"t":{"df":7,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"132":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":1,"docs":{"216":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":3,"docs":{"158":{"tf":1.0},"159":{"tf":1.4142135623730951},"162":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":5,"docs":{"70":{"tf":1.0},"76":{"tf":1.4142135623730951},"79":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":7,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"t":{"df":7,"docs":{"70":{"tf":1.7320508075688772},"73":{"tf":1.7320508075688772},"76":{"tf":2.449489742783178},"79":{"tf":1.7320508075688772},"83":{"tf":2.0},"85":{"tf":1.7320508075688772},"88":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":5,"docs":{"70":{"tf":1.4142135623730951},"73":{"tf":1.0},"76":{"tf":1.7320508075688772},"83":{"tf":1.0},"88":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"76":{"tf":1.0}}}}}}}},"t":{"df":6,"docs":{"70":{"tf":1.4142135623730951},"73":{"tf":1.0},"76":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":6,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"76":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"70":{"tf":1.0},"88":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":4,"docs":{"70":{"tf":1.0},"76":{"tf":3.1622776601683795},"79":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}}}},"i":{"3":{"2":{"df":4,"docs":{"73":{"tf":1.7320508075688772},"76":{"tf":2.8284271247461903},"85":{"tf":1.4142135623730951},"88":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"6":{"4":{"df":1,"docs":{"88":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":6,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":2.0},"83":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":5,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":6,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"83":{"tf":1.4142135623730951},"85":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"j":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"159":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"159":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"83":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"(":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":2,"docs":{"79":{"tf":1.0},"83":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"83":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"79":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"83":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"79":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"79":{"tf":1.0},"83":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"t":{"df":2,"docs":{"79":{"tf":1.0},"83":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"g":{"=":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":1,"docs":{"13":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.7320508075688772}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"1":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"83":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"2":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"83":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":6,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":7,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.4142135623730951},"85":{"tf":1.0},"88":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"t":{"df":7,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.4142135623730951},"85":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"85":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"j":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"115":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"114":{"tf":1.0},"126":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"v":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"119":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":7,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":7,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":7,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"t":{"df":7,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.4142135623730951},"85":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"=":{"1":{"df":1,"docs":{"199":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"v":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"t":{"df":5,"docs":{"70":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951},"76":{"tf":3.1622776601683795},"85":{"tf":1.4142135623730951},"88":{"tf":2.449489742783178}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"1":{":":{":":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"1":{"df":1,"docs":{"13":{"tf":2.0}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"{":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"55":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"2":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"(":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"t":{".":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":5,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"t":{"2":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"216":{"tf":1.0}}}}}}},"df":4,"docs":{"180":{"tf":1.4142135623730951},"184":{"tf":2.0},"216":{"tf":1.0},"9":{"tf":2.0}}}},"t":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":5,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0}}}}}},"df":12,"docs":{"0":{"tf":1.0},"106":{"tf":1.0},"193":{"tf":1.0},"194":{"tf":1.0},"216":{"tf":1.0},"46":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.7320508075688772},"73":{"tf":1.7320508075688772},"76":{"tf":1.7320508075688772},"83":{"tf":1.7320508075688772},"88":{"tf":1.7320508075688772}}},"y":{"df":18,"docs":{"0":{"tf":1.0},"118":{"tf":1.0},"124":{"tf":1.4142135623730951},"146":{"tf":1.0},"153":{"tf":1.0},"160":{"tf":1.0},"184":{"tf":1.0},"194":{"tf":1.0},"199":{"tf":1.0},"2":{"tf":1.0},"206":{"tf":1.0},"220":{"tf":1.0},"224":{"tf":1.0},"225":{"tf":1.0},"234":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.4142135623730951},"52":{"tf":1.0}}}},"df":4,"docs":{"124":{"tf":1.0},"127":{"tf":1.0},"128":{"tf":1.7320508075688772},"218":{"tf":1.0}},"e":{"'":{"d":{"df":1,"docs":{"131":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":15,"docs":{"0":{"tf":1.0},"113":{"tf":1.0},"117":{"tf":1.0},"122":{"tf":1.0},"130":{"tf":1.0},"169":{"tf":1.0},"184":{"tf":1.0},"2":{"tf":1.0},"203":{"tf":1.0},"212":{"tf":1.0},"38":{"tf":1.7320508075688772},"39":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"70":{"tf":1.0}}}},"r":{"df":5,"docs":{"152":{"tf":1.4142135623730951},"153":{"tf":1.0},"155":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.4142135623730951}}},"v":{"df":9,"docs":{"204":{"tf":1.0},"220":{"tf":1.0},"226":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.0},"52":{"tf":1.0},"70":{"tf":1.0}}}},"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"df":60,"docs":{"0":{"tf":2.449489742783178},"1":{"tf":1.4142135623730951},"102":{"tf":1.0},"103":{"tf":1.4142135623730951},"105":{"tf":1.0},"106":{"tf":1.4142135623730951},"109":{"tf":1.4142135623730951},"11":{"tf":1.4142135623730951},"110":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.7320508075688772},"130":{"tf":1.4142135623730951},"137":{"tf":4.898979485566356},"138":{"tf":1.7320508075688772},"139":{"tf":1.0},"140":{"tf":1.0},"141":{"tf":1.0},"143":{"tf":1.7320508075688772},"144":{"tf":2.0},"145":{"tf":3.0},"157":{"tf":1.0},"158":{"tf":2.8284271247461903},"159":{"tf":1.7320508075688772},"160":{"tf":1.4142135623730951},"164":{"tf":1.0},"165":{"tf":1.0},"166":{"tf":1.0},"185":{"tf":1.0},"192":{"tf":1.0},"215":{"tf":1.0},"216":{"tf":1.0},"217":{"tf":1.0},"218":{"tf":1.4142135623730951},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"46":{"tf":1.4142135623730951},"50":{"tf":1.0},"51":{"tf":1.4142135623730951},"54":{"tf":1.0},"55":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772},"70":{"tf":1.4142135623730951},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.7320508075688772},"9":{"tf":1.0},"90":{"tf":1.7320508075688772},"92":{"tf":1.7320508075688772},"93":{"tf":1.4142135623730951},"95":{"tf":1.4142135623730951},"96":{"tf":1.4142135623730951},"98":{"tf":1.0},"99":{"tf":1.0}},"y":{"'":{"df":1,"docs":{"112":{"tf":1.0}}},"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"184":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":2,"docs":{"0":{"tf":1.0},"113":{"tf":1.0}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"149":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"k":{"df":5,"docs":{"138":{"tf":1.4142135623730951},"209":{"tf":1.0},"217":{"tf":1.0},"220":{"tf":1.0},"224":{"tf":1.0}}}},"l":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":10,"docs":{"0":{"tf":1.0},"137":{"tf":1.0},"139":{"tf":1.0},"14":{"tf":1.0},"153":{"tf":1.0},"203":{"tf":1.0},"204":{"tf":1.0},"206":{"tf":1.0},"230":{"tf":1.0},"231":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":35,"docs":{"112":{"tf":1.4142135623730951},"130":{"tf":1.4142135623730951},"131":{"tf":1.4142135623730951},"134":{"tf":1.0},"137":{"tf":1.0},"138":{"tf":2.0},"144":{"tf":1.0},"148":{"tf":1.0},"154":{"tf":1.0},"157":{"tf":1.7320508075688772},"158":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":1.0},"185":{"tf":1.0},"190":{"tf":1.0},"195":{"tf":1.0},"2":{"tf":1.0},"204":{"tf":1.0},"206":{"tf":1.0},"209":{"tf":1.0},"223":{"tf":1.0},"224":{"tf":1.4142135623730951},"225":{"tf":1.4142135623730951},"40":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.0},"47":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0},"74":{"tf":1.0},"91":{"tf":1.0},"94":{"tf":1.0},"97":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"220":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"190":{"tf":1.0}}}},"df":0,"docs":{}}}}},"h":{"a":{"df":0,"docs":{},"t":{"'":{"df":7,"docs":{"116":{"tf":1.0},"130":{"tf":1.0},"135":{"tf":1.0},"139":{"tf":1.0},"143":{"tf":1.0},"189":{"tf":1.0},"207":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":2,"docs":{"175":{"tf":1.0},"179":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"111":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":1,"docs":{"158":{"tf":1.0}}},"df":0,"docs":{},"v":{"df":2,"docs":{"183":{"tf":1.0},"192":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":10,"docs":{"15":{"tf":1.0},"150":{"tf":1.0},"155":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":1.0},"180":{"tf":1.0},"187":{"tf":1.0},"193":{"tf":1.0},"209":{"tf":1.0},"222":{"tf":1.0}}}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"159":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"13":{"tf":2.0}}}}},"k":{"df":0,"docs":{},"i":{"df":1,"docs":{"232":{"tf":1.0}}}},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"138":{"tf":1.4142135623730951},"140":{"tf":1.0}}}},"n":{"c":{"df":0,"docs":{},"h":{"'":{"df":1,"docs":{"140":{"tf":1.0}}},"df":5,"docs":{"131":{"tf":2.0},"137":{"tf":1.7320508075688772},"140":{"tf":2.6457513110645907},"142":{"tf":1.0},"221":{"tf":1.0}}}},"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":16,"docs":{"110":{"tf":1.0},"112":{"tf":1.0},"132":{"tf":1.0},"137":{"tf":1.7320508075688772},"139":{"tf":1.0},"191":{"tf":1.0},"192":{"tf":1.0},"195":{"tf":2.0},"2":{"tf":1.0},"3":{"tf":1.0},"70":{"tf":1.4142135623730951},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"2":{"tf":1.0}}}}},"z":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"131":{"tf":1.0}}},"h":{"df":2,"docs":{"129":{"tf":1.0},"130":{"tf":1.0}}}},"t":{"df":1,"docs":{"8":{"tf":1.0}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":29,"docs":{"0":{"tf":1.0},"13":{"tf":1.0},"134":{"tf":1.0},"136":{"tf":1.4142135623730951},"138":{"tf":1.7320508075688772},"140":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.4142135623730951},"150":{"tf":1.0},"156":{"tf":1.0},"158":{"tf":1.7320508075688772},"159":{"tf":1.4142135623730951},"161":{"tf":1.0},"162":{"tf":1.7320508075688772},"165":{"tf":1.0},"178":{"tf":1.0},"183":{"tf":1.0},"22":{"tf":1.0},"220":{"tf":1.0},"233":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"50":{"tf":1.0},"53":{"tf":1.0},"83":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":13,"docs":{"12":{"tf":1.0},"120":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.4142135623730951},"151":{"tf":1.4142135623730951},"158":{"tf":1.0},"175":{"tf":1.0},"179":{"tf":1.0},"184":{"tf":1.0},"187":{"tf":1.0},"209":{"tf":1.0},"211":{"tf":1.0},"231":{"tf":1.0}}}}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"128":{"tf":2.8284271247461903}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"117":{"tf":1.0}}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":5,"docs":{"132":{"tf":1.0},"145":{"tf":1.0},"158":{"tf":1.0},"222":{"tf":1.0},"224":{"tf":1.0}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"220":{"tf":1.0}}}}},"df":0,"docs":{}},"r":{"d":{"df":1,"docs":{"158":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":33,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"103":{"tf":1.0},"106":{"tf":1.0},"112":{"tf":1.0},"124":{"tf":1.4142135623730951},"128":{"tf":1.0},"130":{"tf":1.4142135623730951},"132":{"tf":1.7320508075688772},"138":{"tf":1.4142135623730951},"139":{"tf":1.0},"14":{"tf":1.0},"152":{"tf":1.0},"153":{"tf":1.0},"158":{"tf":1.0},"164":{"tf":1.0},"178":{"tf":1.0},"181":{"tf":1.0},"189":{"tf":1.0},"191":{"tf":1.4142135623730951},"194":{"tf":1.0},"2":{"tf":1.0},"213":{"tf":1.4142135623730951},"214":{"tf":1.0},"219":{"tf":1.0},"22":{"tf":1.0},"221":{"tf":1.7320508075688772},"222":{"tf":1.0},"24":{"tf":1.0},"30":{"tf":1.0},"33":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":13,"docs":{"17":{"tf":1.4142135623730951},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":2.0},"24":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"30":{"tf":1.0},"31":{"tf":1.7320508075688772},"32":{"tf":1.4142135623730951},"33":{"tf":1.0},"34":{"tf":1.0}}}},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":4,"docs":{"154":{"tf":1.0},"201":{"tf":1.0},"224":{"tf":1.7320508075688772},"225":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":4,"docs":{"178":{"tf":1.0},"191":{"tf":1.0},"204":{"tf":2.449489742783178},"205":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"204":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"203":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"l":{"d":{"!":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"\\":{"df":0,"docs":{},"n":{"df":3,"docs":{"57":{"tf":1.0},"70":{"tf":1.0},"81":{"tf":1.0}}}},"df":0,"docs":{}},"df":10,"docs":{"13":{"tf":1.0},"144":{"tf":1.0},"220":{"tf":1.0},"39":{"tf":1.4142135623730951},"41":{"tf":1.0},"51":{"tf":1.4142135623730951},"55":{"tf":1.0},"68":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"157":{"tf":1.0}}}},"s":{"df":1,"docs":{"130":{"tf":1.0}}},"t":{"df":0,"docs":{},"h":{"df":6,"docs":{"150":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":1.0},"189":{"tf":1.0},"207":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"131":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"159":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"159":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":23,"docs":{"117":{"tf":1.0},"127":{"tf":1.4142135623730951},"128":{"tf":1.0},"145":{"tf":1.0},"147":{"tf":1.4142135623730951},"183":{"tf":1.0},"184":{"tf":1.0},"194":{"tf":1.0},"212":{"tf":1.0},"216":{"tf":1.0},"217":{"tf":1.0},"225":{"tf":1.0},"227":{"tf":1.0},"31":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"39":{"tf":1.0},"49":{"tf":1.0},"58":{"tf":1.0},"63":{"tf":1.0},"8":{"tf":1.0},"82":{"tf":1.0},"96":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":5,"docs":{"150":{"tf":1.0},"18":{"tf":1.0},"188":{"tf":1.0},"227":{"tf":1.0},"36":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"131":{"tf":1.0},"145":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":2,"docs":{"117":{"tf":1.0},"216":{"tf":1.0}}}}}}},"x":{".":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"z":{"df":3,"docs":{"224":{"tf":2.6457513110645907},"226":{"tf":1.4142135623730951},"227":{"tf":1.0}}}},"df":0,"docs":{}}},"8":{"6":{"_":{"6":{"4":{"df":9,"docs":{"137":{"tf":2.6457513110645907},"138":{"tf":1.4142135623730951},"139":{"tf":1.7320508075688772},"140":{"tf":1.4142135623730951},"190":{"tf":1.0},"195":{"tf":1.0},"2":{"tf":1.0},"205":{"tf":1.0},"3":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"112":{"tf":1.0},"118":{"tf":1.0},"195":{"tf":1.0}}},"df":0,"docs":{}},"=":{"$":{"(":{"(":{"$":{"1":{"df":1,"docs":{"101":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"195":{"tf":1.0}}}},"df":0,"docs":{}}},"df":3,"docs":{"101":{"tf":1.0},"111":{"tf":1.0},"130":{"tf":3.4641016151377544}},"r":{"df":1,"docs":{"130":{"tf":3.4641016151377544}}},"x":{"df":0,"docs":{},"x":{"df":0,"docs":{},"x":{".":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"115":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"114":{"tf":1.0}}}},"df":0,"docs":{}}},"df":1,"docs":{"115":{"tf":1.0}}}}}},"y":{"=":{"$":{"(":{"(":{"$":{"2":{"df":1,"docs":{"101":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"101":{"tf":1.0},"183":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"24":{"tf":1.0}}}},"df":1,"docs":{"151":{"tf":4.898979485566356}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"150":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"u":{"'":{"d":{"df":6,"docs":{"112":{"tf":1.0},"130":{"tf":1.0},"184":{"tf":1.0},"185":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":30,"docs":{"0":{"tf":1.0},"112":{"tf":1.0},"114":{"tf":2.23606797749979},"115":{"tf":2.6457513110645907},"116":{"tf":1.7320508075688772},"126":{"tf":2.23606797749979},"132":{"tf":1.4142135623730951},"142":{"tf":1.0},"172":{"tf":1.0},"177":{"tf":1.0},"178":{"tf":1.0},"185":{"tf":1.4142135623730951},"195":{"tf":1.4142135623730951},"197":{"tf":1.0},"2":{"tf":1.0},"204":{"tf":1.0},"208":{"tf":1.0},"3":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.0},"61":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0},"96":{"tf":1.0},"99":{"tf":1.0}}}},"r":{"df":24,"docs":{"112":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.4142135623730951},"115":{"tf":1.4142135623730951},"116":{"tf":1.0},"126":{"tf":1.4142135623730951},"132":{"tf":1.0},"153":{"tf":1.7320508075688772},"154":{"tf":1.4142135623730951},"155":{"tf":1.0},"177":{"tf":1.0},"178":{"tf":1.4142135623730951},"181":{"tf":1.0},"183":{"tf":1.0},"2":{"tf":1.0},"203":{"tf":1.0},"204":{"tf":1.4142135623730951},"207":{"tf":1.0},"209":{"tf":1.0},"212":{"tf":1.0},"3":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.0},"95":{"tf":1.0}}},"v":{"df":11,"docs":{"102":{"tf":1.0},"103":{"tf":1.0},"106":{"tf":1.0},"152":{"tf":1.0},"180":{"tf":1.0},"207":{"tf":1.0},"38":{"tf":1.4142135623730951},"89":{"tf":1.0},"90":{"tf":1.4142135623730951},"93":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":1,"docs":{"207":{"tf":1.0}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":4,"docs":{"195":{"tf":1.0},"207":{"tf":1.4142135623730951},"219":{"tf":1.0},"221":{"tf":1.0}}}}}}}}}},"z":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"130":{"tf":1.4142135623730951},"132":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":1,"docs":{"130":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":4,"docs":{"145":{"tf":1.0},"194":{"tf":2.0},"203":{"tf":1.0},"63":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"130":{"tf":2.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"153":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"d":{"df":3,"docs":{"18":{"tf":1.4142135623730951},"19":{"tf":1.0},"31":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"153":{"tf":1.7320508075688772}}}}}}}}},"breadcrumbs":{"root":{"0":{")":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},".":{"0":{"6":{"6":{"df":1,"docs":{"122":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"1":{".":{"0":{"df":1,"docs":{"125":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{".":{"0":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}},"2":{"df":1,"docs":{"122":{"tf":1.0}}},"df":0,"docs":{}},"4":{"7":{"df":1,"docs":{"117":{"tf":1.0}}},"df":0,"docs":{}},"9":{".":{"0":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"2":{"2":{"df":1,"docs":{"122":{"tf":1.0}}},"df":0,"docs":{}},"3":{"9":{"df":1,"docs":{"122":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{"9":{"2":{"df":1,"docs":{"122":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"\\":{"0":{"2":{"\\":{"0":{"3":{"\\":{"0":{"4":{"\\":{"0":{"5":{"\\":{"0":{"6":{"\\":{"0":{"7":{"\\":{"0":{"8":{"\\":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"194":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"48":{"tf":1.0},"75":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"\\":{"0":{"2":{"\\":{"\\":{"0":{"3":{"\\":{"\\":{"0":{"4":{"\\":{"\\":{"0":{"5":{"\\":{"\\":{"0":{"6":{"\\":{"\\":{"0":{"7":{"\\":{"\\":{"0":{"8":{"\\":{"\\":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"194":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{":":{"3":{"3":{"df":1,"docs":{"130":{"tf":1.0}}},"4":{"df":1,"docs":{"130":{"tf":1.0}}},"7":{"df":1,"docs":{"130":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"4":{"0":{"df":1,"docs":{"130":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"130":{"tf":1.0}}},"3":{"df":1,"docs":{"130":{"tf":1.4142135623730951}}},"4":{"df":1,"docs":{"130":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{":":{"3":{"9":{"df":1,"docs":{"130":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":31,"docs":{"100":{"tf":2.449489742783178},"101":{"tf":1.0},"103":{"tf":2.449489742783178},"106":{"tf":2.449489742783178},"111":{"tf":1.4142135623730951},"128":{"tf":2.0},"158":{"tf":1.4142135623730951},"194":{"tf":3.0},"40":{"tf":1.4142135623730951},"43":{"tf":1.0},"45":{"tf":2.449489742783178},"48":{"tf":1.4142135623730951},"49":{"tf":2.449489742783178},"58":{"tf":1.7320508075688772},"63":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"70":{"tf":2.0},"72":{"tf":2.449489742783178},"73":{"tf":1.7320508075688772},"75":{"tf":1.4142135623730951},"76":{"tf":3.7416573867739413},"79":{"tf":2.23606797749979},"82":{"tf":1.7320508075688772},"83":{"tf":1.7320508075688772},"85":{"tf":1.4142135623730951},"87":{"tf":1.4142135623730951},"88":{"tf":1.0},"90":{"tf":2.449489742783178},"93":{"tf":2.449489742783178},"96":{"tf":2.449489742783178}},"l":{"df":7,"docs":{"70":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"85":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951}}},"x":{"1":{"0":{"0":{"0":{"df":4,"docs":{"48":{"tf":1.0},"49":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0}}},"2":{"df":2,"docs":{"49":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951}}},"3":{"df":2,"docs":{"49":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"3":{"df":1,"docs":{"128":{"tf":1.0}}},"6":{"1":{"0":{"df":1,"docs":{"128":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"3":{"4":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"/":{"1":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":2,"docs":{"49":{"tf":1.0},"76":{"tf":1.0}}}}}}},"2":{"0":{"0":{"0":{"0":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":2,"docs":{"49":{"tf":2.0},"76":{"tf":2.23606797749979}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"4":{"9":{"df":1,"docs":{"128":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"7":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"3":{"0":{"0":{"0":{"0":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":2,"docs":{"49":{"tf":1.4142135623730951},"76":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"6":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}}},"4":{"0":{"b":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"3":{"4":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"7":{"b":{"d":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"5":{"d":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"7":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"f":{"0":{"2":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"5":{"5":{"5":{"d":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"2":{"a":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"6":{"1":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":1,"docs":{"111":{"tf":1.0}}}}},"6":{"0":{"a":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"1":{"6":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"6":{"1":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"8":{"7":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"7":{"df":1,"docs":{"128":{"tf":1.0}}},"df":0,"docs":{}},"a":{"c":{"0":{"1":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{"1":{"c":{"5":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"1":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},".":{"0":{"7":{"df":1,"docs":{"194":{"tf":1.0}}},"df":0,"docs":{}},"1":{"2":{"df":1,"docs":{"95":{"tf":1.0}}},"df":0,"docs":{}},"4":{"df":1,"docs":{"235":{"tf":1.0}}},"7":{"0":{".":{"0":{"df":1,"docs":{"205":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{".":{"0":{"df":1,"docs":{"205":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{".":{"0":{"df":1,"docs":{"205":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{",":{"0":{"0":{"0":{"df":1,"docs":{"209":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"df":2,"docs":{"136":{"tf":1.0},"157":{"tf":1.0}}},"6":{"df":1,"docs":{"194":{"tf":1.0}}},"df":3,"docs":{"111":{"tf":1.0},"130":{"tf":1.0},"63":{"tf":1.0}},"m":{"df":1,"docs":{"127":{"tf":1.0}}}},"1":{"3":{"4":{"9":{"0":{"3":{"1":{"7":{"0":{"df":1,"docs":{"122":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"df":1,"docs":{"194":{"tf":1.0}}},"df":1,"docs":{"111":{"tf":1.0}}},"2":{"df":2,"docs":{"101":{"tf":1.0},"111":{"tf":1.0}}},"3":{"0":{"df":0,"docs":{},"m":{"df":1,"docs":{"131":{"tf":1.0}}}},"df":1,"docs":{"111":{"tf":1.0}}},"4":{"0":{"df":0,"docs":{},"m":{"df":1,"docs":{"130":{"tf":1.0}}}},"8":{"2":{"df":1,"docs":{"110":{"tf":1.0}}},"df":0,"docs":{}},"df":4,"docs":{"111":{"tf":1.0},"122":{"tf":1.0},"57":{"tf":1.0},"81":{"tf":1.0}}},"5":{"df":1,"docs":{"111":{"tf":1.0}}},"6":{"df":4,"docs":{"111":{"tf":1.0},"130":{"tf":1.0},"17":{"tf":1.0},"194":{"tf":1.0}}},"7":{"df":1,"docs":{"111":{"tf":1.0}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"125":{"tf":1.0}}}}},"8":{".":{"0":{".":{"0":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"111":{"tf":1.0},"130":{"tf":3.605551275463989}}},"9":{".":{"0":{".":{"0":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"3":{"df":1,"docs":{"110":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"122":{"tf":1.0}}},"d":{"df":1,"docs":{"23":{"tf":1.0}}},"df":42,"docs":{"100":{"tf":2.449489742783178},"101":{"tf":1.0},"103":{"tf":2.449489742783178},"106":{"tf":2.449489742783178},"110":{"tf":1.0},"111":{"tf":1.4142135623730951},"117":{"tf":1.7320508075688772},"122":{"tf":1.4142135623730951},"128":{"tf":1.7320508075688772},"13":{"tf":1.0},"130":{"tf":3.4641016151377544},"137":{"tf":1.7320508075688772},"138":{"tf":3.3166247903554},"150":{"tf":1.0},"194":{"tf":2.449489742783178},"40":{"tf":1.4142135623730951},"43":{"tf":1.0},"45":{"tf":2.449489742783178},"48":{"tf":1.0},"49":{"tf":1.7320508075688772},"51":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.7320508075688772},"65":{"tf":1.4142135623730951},"66":{"tf":2.23606797749979},"70":{"tf":2.0},"72":{"tf":2.449489742783178},"73":{"tf":2.23606797749979},"75":{"tf":1.0},"76":{"tf":3.605551275463989},"79":{"tf":1.4142135623730951},"81":{"tf":1.0},"82":{"tf":1.7320508075688772},"83":{"tf":1.4142135623730951},"85":{"tf":2.449489742783178},"87":{"tf":1.4142135623730951},"88":{"tf":2.8284271247461903},"90":{"tf":2.449489742783178},"93":{"tf":2.449489742783178},"96":{"tf":2.449489742783178}},"g":{"df":0,"docs":{},"i":{"df":1,"docs":{"14":{"tf":1.0}}}},"h":{"df":1,"docs":{"21":{"tf":1.0}}},"m":{"df":1,"docs":{"131":{"tf":1.0}}}},"2":{".":{"0":{".":{"0":{"df":1,"docs":{"225":{"tf":1.7320508075688772}}},"1":{"df":1,"docs":{"225":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"df":0,"docs":{},"m":{"df":2,"docs":{"130":{"tf":1.0},"131":{"tf":1.4142135623730951}}}},"3":{"df":0,"docs":{},"m":{"df":1,"docs":{"130":{"tf":1.0}}}},"4":{"df":0,"docs":{},"m":{"df":1,"docs":{"130":{"tf":1.4142135623730951}}}},"8":{"df":0,"docs":{},"m":{"df":1,"docs":{"131":{"tf":1.0}}}},"df":0,"docs":{}},"0":{"0":{"df":0,"docs":{},"k":{"df":1,"docs":{"131":{"tf":1.0}}}},"2":{"3":{"df":2,"docs":{"125":{"tf":1.0},"130":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"19":{"tf":1.0}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"224":{"tf":1.4142135623730951}}}}},"5":{"6":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}},"6":{"7":{"9":{"1":{"4":{"2":{"9":{"6":{"df":1,"docs":{"117":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{"df":7,"docs":{"101":{"tf":1.4142135623730951},"103":{"tf":1.0},"106":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"73":{"tf":1.0},"90":{"tf":1.0},"96":{"tf":1.7320508075688772}}},">":{"&":{"1":{"df":1,"docs":{"194":{"tf":1.0}}},"df":0,"docs":{}},"/":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"/":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"101":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":34,"docs":{"100":{"tf":2.8284271247461903},"101":{"tf":1.4142135623730951},"103":{"tf":2.8284271247461903},"106":{"tf":2.8284271247461903},"111":{"tf":1.4142135623730951},"117":{"tf":1.4142135623730951},"122":{"tf":1.4142135623730951},"128":{"tf":1.4142135623730951},"130":{"tf":1.0},"137":{"tf":1.7320508075688772},"138":{"tf":3.605551275463989},"192":{"tf":1.0},"194":{"tf":2.0},"209":{"tf":1.0},"40":{"tf":1.7320508075688772},"45":{"tf":2.8284271247461903},"48":{"tf":1.0},"49":{"tf":1.4142135623730951},"54":{"tf":1.7320508075688772},"57":{"tf":1.0},"58":{"tf":1.4142135623730951},"65":{"tf":1.0},"66":{"tf":1.7320508075688772},"72":{"tf":2.8284271247461903},"73":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":2.23606797749979},"81":{"tf":1.0},"82":{"tf":1.4142135623730951},"87":{"tf":1.0},"88":{"tf":2.0},"90":{"tf":2.8284271247461903},"93":{"tf":2.8284271247461903},"96":{"tf":2.8284271247461903}},"g":{"b":{"df":2,"docs":{"145":{"tf":1.0},"164":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"3":{".":{"0":{"df":2,"docs":{"102":{"tf":1.0},"92":{"tf":1.0}}},"3":{"df":0,"docs":{},"m":{"df":1,"docs":{"130":{"tf":1.4142135623730951}}}},"4":{"8":{"0":{"df":1,"docs":{"122":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"df":1,"docs":{"89":{"tf":1.0}}},"7":{"5":{"df":1,"docs":{"194":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"df":0,"docs":{},"m":{"df":2,"docs":{"14":{"tf":1.0},"22":{"tf":1.0}}}},"2":{"df":6,"docs":{"118":{"tf":1.0},"137":{"tf":1.7320508075688772},"140":{"tf":1.0},"145":{"tf":1.0},"164":{"tf":1.7320508075688772},"194":{"tf":1.4142135623730951}}},"3":{"df":0,"docs":{},"m":{"df":1,"docs":{"130":{"tf":1.0}}}},"4":{"3":{"5":{"df":1,"docs":{"117":{"tf":1.0}}},"df":0,"docs":{}},"4":{"df":1,"docs":{"194":{"tf":1.0}}},"df":0,"docs":{}},"5":{"4":{"df":1,"docs":{"194":{"tf":1.0}}},"7":{"df":1,"docs":{"194":{"tf":1.0}}},"9":{"df":1,"docs":{"194":{"tf":1.0}}},"df":0,"docs":{}},"6":{"9":{"df":1,"docs":{"194":{"tf":1.0}}},"df":1,"docs":{"63":{"tf":1.0}}},"df":21,"docs":{"103":{"tf":1.0},"106":{"tf":1.0},"111":{"tf":1.0},"130":{"tf":1.0},"137":{"tf":1.7320508075688772},"138":{"tf":2.6457513110645907},"18":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.7320508075688772},"70":{"tf":1.0},"73":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"87":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0}}},"4":{".":{"0":{".":{"0":{"df":1,"docs":{"134":{"tf":1.0}}},"1":{"df":1,"docs":{"134":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"9":{"df":1,"docs":{"194":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"0":{"df":0,"docs":{},"k":{"df":1,"docs":{"132":{"tf":1.0}}}},"df":0,"docs":{}},"2":{".":{"3":{"2":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"101":{"tf":1.0},"111":{"tf":1.4142135623730951},"117":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.4142135623730951},"63":{"tf":1.0}}},"5":{"df":1,"docs":{"122":{"tf":1.0}}},"df":10,"docs":{"111":{"tf":1.0},"137":{"tf":1.0},"217":{"tf":1.0},"49":{"tf":1.4142135623730951},"58":{"tf":1.7320508075688772},"65":{"tf":1.0},"66":{"tf":1.7320508075688772},"76":{"tf":1.4142135623730951},"82":{"tf":1.7320508075688772},"87":{"tf":1.0}},"g":{"b":{"df":1,"docs":{"164":{"tf":1.0}}},"df":0,"docs":{}}},"5":{".":{"0":{".":{"0":{"df":1,"docs":{"134":{"tf":1.4142135623730951}}},"1":{"df":1,"docs":{"134":{"tf":1.0}}},"df":0,"docs":{}},"9":{"df":1,"docs":{"194":{"tf":1.0}}},"df":0,"docs":{},"m":{"df":1,"docs":{"130":{"tf":1.0}}}},"df":0,"docs":{}},"1":{"2":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{}},"df":7,"docs":{"111":{"tf":1.0},"194":{"tf":1.0},"49":{"tf":2.0},"65":{"tf":1.0},"66":{"tf":1.4142135623730951},"76":{"tf":2.449489742783178},"87":{"tf":1.0}},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"134":{"tf":1.0},"224":{"tf":1.4142135623730951}}}}},"6":{".":{"7":{"df":0,"docs":{},"m":{"df":1,"docs":{"130":{"tf":1.4142135623730951}}}},"8":{"df":0,"docs":{},"m":{"df":1,"docs":{"130":{"tf":1.0}}}},"df":0,"docs":{}},"4":{"df":3,"docs":{"118":{"tf":1.0},"164":{"tf":2.0},"195":{"tf":1.0}}},"5":{"5":{"3":{"6":{"df":3,"docs":{"26":{"tf":1.0},"58":{"tf":1.0},"82":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{".":{"3":{"6":{"df":1,"docs":{"194":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":17,"docs":{"101":{"tf":1.4142135623730951},"103":{"tf":1.7320508075688772},"106":{"tf":1.4142135623730951},"111":{"tf":1.0},"225":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.7320508075688772},"61":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.4142135623730951},"73":{"tf":1.0},"76":{"tf":1.7320508075688772},"85":{"tf":1.0},"87":{"tf":1.0},"90":{"tf":2.23606797749979},"93":{"tf":1.7320508075688772},"96":{"tf":1.0}},"g":{"b":{"df":1,"docs":{"164":{"tf":1.0}}},"df":0,"docs":{}}},"7":{".":{"7":{"7":{"df":1,"docs":{"194":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"df":2,"docs":{"28":{"tf":1.0},"29":{"tf":1.0}}},"1":{".":{"5":{"8":{"df":1,"docs":{"194":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{".":{"8":{"0":{"df":1,"docs":{"194":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{".":{"6":{"0":{"df":1,"docs":{"194":{"tf":1.0}}},"df":0,"docs":{}},"8":{"7":{"df":1,"docs":{"194":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{"7":{"9":{"df":1,"docs":{"194":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":5,"docs":{"111":{"tf":1.0},"122":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.4142135623730951},"87":{"tf":1.0}}},"8":{"df":5,"docs":{"111":{"tf":1.0},"194":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.4142135623730951},"87":{"tf":1.0}},"g":{"b":{"df":1,"docs":{"164":{"tf":1.0}}},"df":0,"docs":{}}},"9":{"0":{"df":1,"docs":{"194":{"tf":1.4142135623730951}}},"1":{"df":1,"docs":{"194":{"tf":1.0}}},"4":{"df":1,"docs":{"194":{"tf":1.0}}},"9":{"df":1,"docs":{"117":{"tf":1.0}}},"df":5,"docs":{"111":{"tf":1.0},"194":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.4142135623730951},"87":{"tf":1.0}}},"_":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"x":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"122":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"v":{"df":0,"docs":{},"m":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"110":{"tf":1.0}}}}}},"df":1,"docs":{"110":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"53":{"tf":1.0}}}}}}}},"n":{"df":0,"docs":{},"o":{"_":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"110":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.0},"194":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}}},"a":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"6":{"4":{"df":9,"docs":{"130":{"tf":1.7320508075688772},"137":{"tf":2.23606797749979},"139":{"tf":1.4142135623730951},"140":{"tf":1.4142135623730951},"195":{"tf":1.0},"196":{"tf":1.0},"197":{"tf":1.0},"199":{"tf":1.4142135623730951},"200":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"b":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":3,"docs":{"160":{"tf":2.0},"163":{"tf":1.0},"218":{"tf":1.0}},"l":{"df":3,"docs":{"128":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.0}}},"{":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"=":{"\"":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"1":{"df":1,"docs":{"13":{"tf":2.0}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":4,"docs":{"130":{"tf":1.0},"132":{"tf":1.0},"145":{"tf":1.0},"151":{"tf":1.0}}}},"v":{"df":19,"docs":{"124":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.4142135623730951},"132":{"tf":1.0},"137":{"tf":1.0},"151":{"tf":1.0},"162":{"tf":1.0},"167":{"tf":1.0},"192":{"tf":1.0},"204":{"tf":1.0},"209":{"tf":1.0},"221":{"tf":1.0},"225":{"tf":1.7320508075688772},"226":{"tf":1.0},"40":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"70":{"tf":1.0}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"234":{"tf":1.0}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":9,"docs":{"130":{"tf":1.0},"134":{"tf":1.0},"138":{"tf":1.7320508075688772},"184":{"tf":1.0},"221":{"tf":1.0},"222":{"tf":1.0},"231":{"tf":1.0},"232":{"tf":1.0},"7":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":20,"docs":{"0":{"tf":1.0},"128":{"tf":1.0},"144":{"tf":2.0},"145":{"tf":1.4142135623730951},"146":{"tf":2.23606797749979},"148":{"tf":2.0},"150":{"tf":1.0},"151":{"tf":2.0},"157":{"tf":1.0},"158":{"tf":1.7320508075688772},"162":{"tf":1.4142135623730951},"163":{"tf":1.0},"194":{"tf":1.0},"39":{"tf":1.4142135623730951},"40":{"tf":1.0},"43":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"143":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.7320508075688772},"163":{"tf":1.0}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"138":{"tf":1.0}}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"212":{"tf":1.0}}}}},"df":0,"docs":{}}},"r":{"d":{"df":6,"docs":{"142":{"tf":1.0},"160":{"tf":1.0},"162":{"tf":1.0},"194":{"tf":1.0},"202":{"tf":1.0},"34":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"131":{"tf":1.4142135623730951},"233":{"tf":1.0}}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":2,"docs":{"152":{"tf":1.4142135623730951},"209":{"tf":1.0}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"158":{"tf":1.0},"24":{"tf":1.4142135623730951}}}}}},"t":{"df":2,"docs":{"180":{"tf":1.0},"233":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"122":{"tf":1.7320508075688772},"189":{"tf":1.0},"192":{"tf":1.0},"207":{"tf":1.0},"232":{"tf":1.0}}}},"v":{"df":3,"docs":{"118":{"tf":1.4142135623730951},"137":{"tf":1.0},"166":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":16,"docs":{"1":{"tf":1.0},"145":{"tf":1.0},"157":{"tf":1.0},"158":{"tf":2.0},"159":{"tf":1.7320508075688772},"160":{"tf":1.0},"161":{"tf":1.0},"162":{"tf":1.4142135623730951},"163":{"tf":1.0},"167":{"tf":1.4142135623730951},"169":{"tf":1.0},"194":{"tf":1.0},"226":{"tf":1.4142135623730951},"25":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":4,"docs":{"192":{"tf":1.0},"218":{"tf":2.0},"235":{"tf":1.0},"54":{"tf":1.0}}}}},"d":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"53":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":24,"docs":{"103":{"tf":1.0},"128":{"tf":1.4142135623730951},"132":{"tf":1.0},"139":{"tf":1.0},"141":{"tf":1.0},"176":{"tf":1.0},"177":{"tf":1.0},"183":{"tf":2.0},"184":{"tf":1.4142135623730951},"185":{"tf":1.7320508075688772},"196":{"tf":1.0},"199":{"tf":1.0},"200":{"tf":1.0},"206":{"tf":1.0},"207":{"tf":1.0},"208":{"tf":1.7320508075688772},"209":{"tf":2.0},"213":{"tf":1.0},"216":{"tf":3.0},"224":{"tf":1.0},"39":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951},"83":{"tf":1.0},"93":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"t":{"df":15,"docs":{"1":{"tf":1.0},"110":{"tf":1.0},"113":{"tf":1.0},"130":{"tf":1.0},"138":{"tf":1.4142135623730951},"145":{"tf":1.0},"162":{"tf":1.0},"167":{"tf":1.0},"180":{"tf":1.0},"201":{"tf":1.0},"207":{"tf":1.0},"208":{"tf":1.0},"212":{"tf":1.0},"220":{"tf":1.0},"226":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":16,"docs":{"130":{"tf":1.7320508075688772},"132":{"tf":1.4142135623730951},"136":{"tf":1.7320508075688772},"137":{"tf":1.0},"138":{"tf":1.4142135623730951},"143":{"tf":1.0},"145":{"tf":1.0},"157":{"tf":1.0},"159":{"tf":1.4142135623730951},"164":{"tf":1.4142135623730951},"191":{"tf":1.0},"194":{"tf":1.0},"203":{"tf":1.0},"206":{"tf":1.4142135623730951},"209":{"tf":1.0},"224":{"tf":1.0}}}}}}},"r":{":":{"#":{"df":0,"docs":{},"x":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":0,"docs":{}},"=":{"0":{".":{"0":{".":{"0":{".":{"0":{":":{"8":{"0":{"8":{"1":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"128":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":14,"docs":{"110":{"tf":1.0},"128":{"tf":1.0},"138":{"tf":1.0},"144":{"tf":1.7320508075688772},"145":{"tf":1.0},"159":{"tf":1.4142135623730951},"162":{"tf":1.0},"164":{"tf":1.7320508075688772},"190":{"tf":1.0},"222":{"tf":1.0},"231":{"tf":1.0},"233":{"tf":1.0},"49":{"tf":1.0},"8":{"tf":1.0}}}}}}},"df":19,"docs":{"103":{"tf":1.0},"120":{"tf":1.4142135623730951},"138":{"tf":1.4142135623730951},"180":{"tf":1.0},"182":{"tf":1.4142135623730951},"183":{"tf":1.7320508075688772},"184":{"tf":1.7320508075688772},"185":{"tf":2.0},"206":{"tf":1.0},"207":{"tf":1.4142135623730951},"209":{"tf":2.0},"216":{"tf":1.4142135623730951},"218":{"tf":2.0},"224":{"tf":1.0},"227":{"tf":1.0},"52":{"tf":1.0},"89":{"tf":1.0},"92":{"tf":1.0},"95":{"tf":1.0}},"j":{"a":{"c":{"df":1,"docs":{"162":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"v":{"a":{"df":0,"docs":{},"n":{"c":{"df":4,"docs":{"104":{"tf":1.0},"231":{"tf":1.0},"91":{"tf":1.0},"97":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"221":{"tf":1.4142135623730951},"222":{"tf":2.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"226":{"tf":2.23606797749979}},"e":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"226":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":6,"docs":{"130":{"tf":1.0},"138":{"tf":2.6457513110645907},"150":{"tf":1.0},"164":{"tf":1.0},"212":{"tf":1.4142135623730951},"221":{"tf":1.0}}}},"df":0,"docs":{}}},"l":{"df":1,"docs":{"187":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"130":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"df":8,"docs":{"145":{"tf":1.0},"161":{"tf":1.0},"164":{"tf":1.0},"185":{"tf":1.0},"209":{"tf":1.4142135623730951},"224":{"tf":1.4142135623730951},"226":{"tf":1.0},"55":{"tf":1.0}}}}}}},"df":1,"docs":{"230":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"153":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":1,"docs":{"113":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"159":{"tf":1.0},"187":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"138":{"tf":1.0}}}}}}}}}},"h":{"df":0,"docs":{},"e":{"a":{"d":{"df":2,"docs":{"11":{"tf":1.0},"226":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"220":{"tf":1.0}}}},"k":{"a":{"df":1,"docs":{"163":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"206":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"121":{"tf":1.0},"190":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":1,"docs":{"122":{"tf":1.0}}}}}}}}},"i":{"a":{"df":1,"docs":{"162":{"tf":1.0}},"s":{"df":1,"docs":{"158":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"232":{"tf":1.0}}}},"v":{"df":1,"docs":{"162":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"c":{"df":4,"docs":{"0":{"tf":1.0},"135":{"tf":1.0},"149":{"tf":1.0},"234":{"tf":1.0}},"e":{"'":{"df":1,"docs":{"234":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"o":{"c":{"df":12,"docs":{"128":{"tf":1.7320508075688772},"132":{"tf":1.4142135623730951},"141":{"tf":1.0},"142":{"tf":1.0},"150":{"tf":1.0},"158":{"tf":2.23606797749979},"159":{"tf":1.0},"162":{"tf":2.23606797749979},"164":{"tf":1.7320508075688772},"165":{"tf":1.4142135623730951},"166":{"tf":1.0},"70":{"tf":1.0}}},"df":0,"docs":{},"w":{"df":14,"docs":{"1":{"tf":1.0},"130":{"tf":1.0},"147":{"tf":1.0},"203":{"tf":1.4142135623730951},"204":{"tf":1.4142135623730951},"21":{"tf":1.0},"218":{"tf":1.0},"22":{"tf":1.0},"224":{"tf":1.0},"23":{"tf":1.4142135623730951},"34":{"tf":1.0},"40":{"tf":1.0},"61":{"tf":1.0},"89":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"208":{"tf":1.0},"220":{"tf":1.0},"49":{"tf":1.0},"76":{"tf":1.4142135623730951}},"g":{"df":6,"docs":{"130":{"tf":1.0},"132":{"tf":1.0},"139":{"tf":1.0},"146":{"tf":1.0},"160":{"tf":1.0},"54":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":11,"docs":{"113":{"tf":1.0},"122":{"tf":1.0},"131":{"tf":1.4142135623730951},"138":{"tf":2.0},"183":{"tf":1.0},"199":{"tf":1.0},"21":{"tf":1.0},"213":{"tf":1.0},"225":{"tf":1.0},"24":{"tf":1.0},"38":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":4,"docs":{"117":{"tf":1.0},"175":{"tf":1.0},"179":{"tf":1.0},"90":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":4,"docs":{"158":{"tf":1.0},"167":{"tf":1.4142135623730951},"220":{"tf":1.0},"221":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"164":{"tf":1.0},"207":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"121":{"tf":1.0},"122":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":13,"docs":{"150":{"tf":1.7320508075688772},"153":{"tf":1.0},"158":{"tf":1.7320508075688772},"160":{"tf":1.0},"162":{"tf":1.0},"191":{"tf":1.4142135623730951},"203":{"tf":1.0},"204":{"tf":1.0},"207":{"tf":1.0},"209":{"tf":1.0},"224":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"209":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"152":{"tf":1.0}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"130":{"tf":1.4142135623730951}}}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"x":{"df":1,"docs":{"122":{"tf":2.6457513110645907}}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"128":{"tf":1.0}}}},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":7,"docs":{"109":{"tf":1.0},"111":{"tf":1.4142135623730951},"118":{"tf":1.4142135623730951},"124":{"tf":1.4142135623730951},"159":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0}}}},"z":{"df":1,"docs":{"118":{"tf":1.0}}}}}},"d":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"152":{"tf":1.0},"216":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"137":{"tf":1.7320508075688772},"139":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":8,"docs":{"115":{"tf":1.0},"117":{"tf":1.7320508075688772},"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0}}},"u":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"226":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":13,"docs":{"107":{"tf":1.0},"124":{"tf":1.0},"138":{"tf":1.0},"140":{"tf":1.0},"160":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":1.0},"183":{"tf":1.0},"193":{"tf":1.0},"2":{"tf":1.0},"214":{"tf":1.0},"224":{"tf":1.0},"226":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"147":{"tf":2.0}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":3,"docs":{"212":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":2.6457513110645907}}}}}},"y":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":3,"docs":{"53":{"tf":1.0},"55":{"tf":1.0},"66":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"53":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"139":{"tf":1.0},"214":{"tf":1.4142135623730951},"220":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":12,"docs":{"103":{"tf":1.0},"106":{"tf":1.0},"116":{"tf":1.0},"131":{"tf":1.0},"138":{"tf":1.4142135623730951},"150":{"tf":1.0},"212":{"tf":1.0},"221":{"tf":1.0},"7":{"tf":1.0},"91":{"tf":1.0},"94":{"tf":1.0},"97":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"t":{"df":4,"docs":{"11":{"tf":2.0},"131":{"tf":1.0},"140":{"tf":1.4142135623730951},"142":{"tf":1.0}}}},"p":{"df":0,"docs":{},"i":{"/":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"b":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{".":{"c":{"df":1,"docs":{"76":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{".":{"c":{"df":1,"docs":{"88":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":6,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"174":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":99,"docs":{"1":{"tf":1.0},"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.4142135623730951},"105":{"tf":1.0},"106":{"tf":1.0},"107":{"tf":1.4142135623730951},"111":{"tf":1.0},"114":{"tf":1.7320508075688772},"115":{"tf":1.7320508075688772},"116":{"tf":1.7320508075688772},"118":{"tf":1.4142135623730951},"119":{"tf":1.7320508075688772},"120":{"tf":1.4142135623730951},"126":{"tf":1.7320508075688772},"131":{"tf":2.23606797749979},"132":{"tf":1.7320508075688772},"134":{"tf":2.0},"135":{"tf":1.0},"142":{"tf":1.4142135623730951},"143":{"tf":1.0},"145":{"tf":1.4142135623730951},"146":{"tf":1.0},"157":{"tf":1.7320508075688772},"159":{"tf":1.0},"160":{"tf":1.0},"167":{"tf":1.4142135623730951},"174":{"tf":1.4142135623730951},"192":{"tf":1.4142135623730951},"216":{"tf":2.23606797749979},"217":{"tf":1.7320508075688772},"225":{"tf":1.4142135623730951},"36":{"tf":2.0},"37":{"tf":1.7320508075688772},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.7320508075688772},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":2.0},"55":{"tf":2.23606797749979},"56":{"tf":1.4142135623730951},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.7320508075688772},"68":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.4142135623730951},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.4142135623730951},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.4142135623730951},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.4142135623730951},"8":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.4142135623730951},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.4142135623730951},"89":{"tf":1.0},"90":{"tf":1.4142135623730951},"91":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"209":{"tf":1.0},"230":{"tf":1.0},"39":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"175":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":3,"docs":{"130":{"tf":2.449489742783178},"137":{"tf":1.4142135623730951},"195":{"tf":1.0}},"i":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":3,"docs":{"114":{"tf":1.0},"115":{"tf":1.0},"126":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}},"df":12,"docs":{"0":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"122":{"tf":1.0},"124":{"tf":1.4142135623730951},"126":{"tf":1.0},"144":{"tf":1.4142135623730951},"146":{"tf":1.0},"147":{"tf":1.0},"203":{"tf":1.0},"225":{"tf":1.0},"36":{"tf":1.0}}},"df":7,"docs":{"130":{"tf":1.4142135623730951},"131":{"tf":1.0},"136":{"tf":1.0},"145":{"tf":1.0},"195":{"tf":1.0},"220":{"tf":1.0},"233":{"tf":1.0}}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"233":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":3,"docs":{"151":{"tf":1.0},"213":{"tf":1.0},"220":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"o":{"a":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"195":{"tf":1.0},"222":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":13,"docs":{"118":{"tf":1.0},"124":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.0},"185":{"tf":1.0},"195":{"tf":1.0},"199":{"tf":1.0},"200":{"tf":1.0},"211":{"tf":1.0},"221":{"tf":1.0},"226":{"tf":1.0},"232":{"tf":1.0},"234":{"tf":1.0}}}}},"v":{"df":3,"docs":{"190":{"tf":1.0},"208":{"tf":1.0},"220":{"tf":1.0}}}}}},"t":{"df":2,"docs":{"197":{"tf":1.0},"198":{"tf":1.0}}}},"r":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"144":{"tf":1.0},"185":{"tf":1.0},"203":{"tf":1.0},"43":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"c":{"<":{"d":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"df":1,"docs":{"165":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"222":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":19,"docs":{"0":{"tf":1.0},"118":{"tf":1.0},"138":{"tf":2.0},"156":{"tf":1.7320508075688772},"157":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.0},"160":{"tf":1.0},"161":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":1.0},"165":{"tf":1.0},"166":{"tf":1.0},"167":{"tf":1.0},"195":{"tf":1.0},"196":{"tf":1.0},"199":{"tf":1.0},"221":{"tf":1.0}}}}}},"df":0,"docs":{}}},"v":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"e":{"a":{"df":2,"docs":{"212":{"tf":1.0},"221":{"tf":1.4142135623730951}}},"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":5,"docs":{"137":{"tf":1.0},"153":{"tf":1.0},"155":{"tf":1.0},"157":{"tf":1.0},"206":{"tf":1.0}}}},"df":0,"docs":{}}},"g":{"1":{"df":1,"docs":{"76":{"tf":2.449489742783178}}},"2":{"df":1,"docs":{"76":{"tf":2.449489742783178}}},"c":{"df":3,"docs":{"76":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}},"df":6,"docs":{"110":{"tf":1.0},"63":{"tf":1.4142135623730951},"70":{"tf":1.0},"76":{"tf":3.872983346207417},"88":{"tf":1.7320508075688772},"93":{"tf":1.0}},"s":{"[":{"0":{"]":{".":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"76":{"tf":2.23606797749979},"88":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"i":{"3":{"2":{"df":2,"docs":{"76":{"tf":2.23606797749979},"88":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"88":{"tf":1.0}}},"1":{"]":{".":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"76":{"tf":1.7320508075688772},"88":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"76":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"6":{"4":{"df":1,"docs":{"88":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":2,"docs":{"76":{"tf":1.4142135623730951},"88":{"tf":1.0}}},"2":{"df":2,"docs":{"76":{"tf":1.7320508075688772},"88":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":13,"docs":{"131":{"tf":1.4142135623730951},"132":{"tf":1.0},"180":{"tf":1.0},"185":{"tf":1.0},"194":{"tf":1.4142135623730951},"224":{"tf":1.7320508075688772},"225":{"tf":1.4142135623730951},"226":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"53":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}}}},"v":{"df":3,"docs":{"76":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}}},"i":{"df":0,"docs":{},"s":{"df":2,"docs":{"145":{"tf":1.0},"163":{"tf":1.0}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}}}}}},"m":{"df":1,"docs":{"137":{"tf":1.0}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":6,"docs":{"155":{"tf":1.0},"158":{"tf":1.0},"166":{"tf":1.0},"220":{"tf":1.4142135623730951},"221":{"tf":1.0},"43":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"221":{"tf":1.0}}}},"y":{"df":3,"docs":{"150":{"tf":1.0},"158":{"tf":1.0},"162":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"t":{"df":1,"docs":{"222":{"tf":1.0}},"i":{"df":0,"docs":{},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":7,"docs":{"130":{"tf":1.0},"131":{"tf":1.7320508075688772},"137":{"tf":1.4142135623730951},"142":{"tf":1.0},"192":{"tf":2.449489742783178},"224":{"tf":1.4142135623730951},"3":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"k":{"df":8,"docs":{"153":{"tf":1.0},"154":{"tf":1.0},"207":{"tf":1.0},"208":{"tf":1.0},"210":{"tf":1.0},"213":{"tf":1.4142135623730951},"220":{"tf":1.0},"221":{"tf":1.4142135623730951}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"160":{"tf":1.0},"163":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"139":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"115":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"!":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{":":{":":{"<":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"o":{"a":{"d":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{".":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"2":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"o":{"df":0,"docs":{},"k":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{".":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"x":{"df":1,"docs":{"111":{"tf":1.0}}}},"df":0,"docs":{}},"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"76":{"tf":1.0}}}}}}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"70":{"tf":1.0}}}}},"g":{"c":{"d":{".":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"k":{"df":6,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":2.0},"83":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"[":{"0":{"]":{".":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"73":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"i":{"6":{"4":{"df":1,"docs":{"88":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"]":{".":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"88":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"88":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"u":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"70":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0}}}}}},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":2,"docs":{"79":{"tf":1.0},"83":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},".":{"df":0,"docs":{},"h":{"df":4,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0}}}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"!":{"(":{"a":{"df":1,"docs":{"66":{"tf":1.0}}},"b":{"df":1,"docs":{"66":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{".":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":2.6457513110645907}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{".":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{")":{"[":{"0":{"df":0,"docs":{},"x":{"1":{"0":{"0":{"2":{"df":1,"docs":{"49":{"tf":1.0}}},"3":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"2":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"49":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{".":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":4,"docs":{"111":{"tf":1.0},"184":{"tf":1.4142135623730951},"187":{"tf":1.0},"39":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":3,"docs":{"161":{"tf":1.4142135623730951},"221":{"tf":3.0},"70":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"209":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"i":{"df":2,"docs":{"151":{"tf":1.0},"225":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":12,"docs":{"113":{"tf":1.0},"130":{"tf":1.0},"132":{"tf":1.0},"14":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.4142135623730951},"165":{"tf":1.0},"177":{"tf":1.0},"195":{"tf":1.0},"24":{"tf":1.0},"38":{"tf":1.4142135623730951},"5":{"tf":1.0}},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"128":{"tf":1.0},"209":{"tf":1.4142135623730951}}}}}}},"y":{"df":0,"docs":{},"n":{"c":{"df":4,"docs":{"150":{"tf":1.0},"167":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":3.1622776601683795}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":3,"docs":{"158":{"tf":1.0},"159":{"tf":1.0},"166":{"tf":1.4142135623730951}}}},"t":{"a":{"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"194":{"tf":1.0},"46":{"tf":1.0},"63":{"tf":1.0},"85":{"tf":1.0}}},"k":{"df":3,"docs":{"144":{"tf":1.0},"209":{"tf":2.0},"231":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":4,"docs":{"21":{"tf":1.0},"24":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0}}}}},"n":{"d":{"df":1,"docs":{"221":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":2,"docs":{"212":{"tf":1.0},"231":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"204":{"tf":1.0},"235":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":7,"docs":{"145":{"tf":1.0},"190":{"tf":1.0},"206":{"tf":1.4142135623730951},"207":{"tf":1.0},"208":{"tf":1.7320508075688772},"220":{"tf":1.0},"221":{"tf":1.0}}}}},"o":{"df":1,"docs":{"221":{"tf":2.449489742783178}},"m":{"a":{"df":0,"docs":{},"t":{"df":11,"docs":{"114":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"126":{"tf":1.0},"140":{"tf":1.0},"190":{"tf":1.4142135623730951},"193":{"tf":1.0},"194":{"tf":1.0},"221":{"tf":1.0},"224":{"tf":1.7320508075688772},"7":{"tf":1.0}}}},"df":3,"docs":{"134":{"tf":1.0},"224":{"tf":1.4142135623730951},"225":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":19,"docs":{"102":{"tf":1.0},"105":{"tf":1.0},"118":{"tf":1.4142135623730951},"12":{"tf":1.0},"122":{"tf":1.0},"132":{"tf":1.4142135623730951},"134":{"tf":1.0},"138":{"tf":1.0},"144":{"tf":1.0},"172":{"tf":1.0},"185":{"tf":1.0},"192":{"tf":1.4142135623730951},"235":{"tf":1.0},"36":{"tf":1.0},"54":{"tf":1.0},"59":{"tf":1.0},"8":{"tf":1.0},"89":{"tf":1.0},"95":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"131":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"138":{"tf":1.0},"207":{"tf":1.4142135623730951},"221":{"tf":1.0}}},"df":0,"docs":{}}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.4142135623730951}}}},"r":{"df":2,"docs":{"201":{"tf":1.0},"221":{"tf":1.0}}},"y":{"df":1,"docs":{"208":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"226":{"tf":1.0}}}}}}},"b":{"a":{"c":{"df":0,"docs":{},"k":{".":{".":{".":{"\\":{"df":0,"docs":{},"n":{"df":2,"docs":{"70":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":9,"docs":{"118":{"tf":1.0},"132":{"tf":1.0},"158":{"tf":1.4142135623730951},"159":{"tf":1.0},"163":{"tf":2.0},"33":{"tf":1.0},"39":{"tf":1.0},"43":{"tf":1.0},"88":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"137":{"tf":1.7320508075688772},"138":{"tf":1.4142135623730951},"140":{"tf":1.7320508075688772},"155":{"tf":1.0}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"159":{"tf":1.0}}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":4,"docs":{"134":{"tf":1.0},"224":{"tf":1.0},"225":{"tf":2.23606797749979},"226":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":5,"docs":{"111":{"tf":1.7320508075688772},"128":{"tf":1.0},"130":{"tf":1.0},"163":{"tf":1.0},"166":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"134":{"tf":1.4142135623730951},"24":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"158":{"tf":1.0}}},"l":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"209":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"n":{"df":1,"docs":{"232":{"tf":1.0}}},"r":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"111":{"tf":1.4142135623730951}}}},"df":1,"docs":{"216":{"tf":1.0}},"e":{"df":1,"docs":{"130":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"e":{"df":12,"docs":{"103":{"tf":1.0},"106":{"tf":1.0},"114":{"tf":1.0},"119":{"tf":1.0},"124":{"tf":1.0},"130":{"tf":1.0},"146":{"tf":1.0},"147":{"tf":1.0},"158":{"tf":1.0},"163":{"tf":1.0},"218":{"tf":1.0},"40":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"131":{"tf":1.0},"138":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"31":{"tf":1.0}}}}}},"h":{"df":7,"docs":{"100":{"tf":1.4142135623730951},"101":{"tf":1.0},"194":{"tf":1.0},"2":{"tf":1.0},"36":{"tf":1.0},"98":{"tf":1.7320508075688772},"99":{"tf":1.7320508075688772}}},"i":{"c":{"df":5,"docs":{"13":{"tf":1.0},"142":{"tf":1.0},"148":{"tf":1.0},"163":{"tf":1.0},"195":{"tf":1.0}}},"df":4,"docs":{"139":{"tf":1.0},"159":{"tf":1.4142135623730951},"203":{"tf":1.0},"204":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"138":{"tf":1.0}}}}},"z":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"111":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":5,"docs":{"63":{"tf":1.4142135623730951},"66":{"tf":2.0},"73":{"tf":1.7320508075688772},"79":{"tf":1.7320508075688772},"83":{"tf":1.7320508075688772}},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"166":{"tf":1.0},"54":{"tf":1.0}}}}},"df":11,"docs":{"116":{"tf":1.0},"131":{"tf":1.0},"132":{"tf":1.0},"138":{"tf":1.4142135623730951},"142":{"tf":1.0},"18":{"tf":1.0},"183":{"tf":1.0},"203":{"tf":1.0},"207":{"tf":1.0},"21":{"tf":1.0},"231":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":20,"docs":{"103":{"tf":1.0},"110":{"tf":1.0},"130":{"tf":1.0},"138":{"tf":1.0},"145":{"tf":1.0},"150":{"tf":1.0},"159":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":1.7320508075688772},"164":{"tf":1.4142135623730951},"169":{"tf":1.0},"176":{"tf":1.0},"211":{"tf":1.4142135623730951},"214":{"tf":1.0},"220":{"tf":1.0},"224":{"tf":1.0},"225":{"tf":1.0},"226":{"tf":1.0},"40":{"tf":1.0},"92":{"tf":1.0}},"e":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"190":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"159":{"tf":1.0}},"n":{"df":1,"docs":{"155":{"tf":1.4142135623730951}}}}}},"h":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":2,"docs":{"150":{"tf":1.0},"207":{"tf":1.0}}}},"v":{"df":1,"docs":{"194":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":10,"docs":{"134":{"tf":2.0},"14":{"tf":1.0},"144":{"tf":1.7320508075688772},"162":{"tf":1.0},"194":{"tf":1.4142135623730951},"204":{"tf":1.0},"229":{"tf":1.0},"231":{"tf":1.4142135623730951},"232":{"tf":1.7320508075688772},"234":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"138":{"tf":1.0},"222":{"tf":1.0},"224":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"221":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"184":{"tf":1.0}}}},"w":{"df":7,"docs":{"123":{"tf":1.0},"130":{"tf":1.0},"137":{"tf":1.4142135623730951},"158":{"tf":1.0},"208":{"tf":1.0},"224":{"tf":1.0},"51":{"tf":1.0}}}}},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"4":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"130":{"tf":1.4142135623730951},"163":{"tf":1.0},"209":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":10,"docs":{"112":{"tf":1.0},"129":{"tf":1.0},"130":{"tf":1.4142135623730951},"131":{"tf":1.0},"137":{"tf":1.4142135623730951},"138":{"tf":1.0},"183":{"tf":1.0},"194":{"tf":1.0},"207":{"tf":1.4142135623730951},"231":{"tf":1.0}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"110":{"tf":1.0},"130":{"tf":1.0},"164":{"tf":1.0},"193":{"tf":1.0},"212":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":9,"docs":{"113":{"tf":1.0},"127":{"tf":1.0},"131":{"tf":1.0},"143":{"tf":1.0},"145":{"tf":1.0},"157":{"tf":1.4142135623730951},"158":{"tf":1.0},"209":{"tf":1.0},"225":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"137":{"tf":1.0},"138":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"g":{"df":3,"docs":{"224":{"tf":1.0},"24":{"tf":1.0},"30":{"tf":1.0}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"164":{"tf":1.0}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"222":{"tf":1.0}}},"df":0,"docs":{}}}}}},"n":{"/":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"101":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":19,"docs":{"0":{"tf":2.0},"119":{"tf":1.0},"129":{"tf":1.0},"130":{"tf":1.7320508075688772},"131":{"tf":3.0},"137":{"tf":1.4142135623730951},"159":{"tf":1.0},"187":{"tf":1.0},"192":{"tf":1.4142135623730951},"200":{"tf":1.4142135623730951},"216":{"tf":1.0},"3":{"tf":2.449489742783178},"7":{"tf":1.0},"70":{"tf":1.4142135623730951},"73":{"tf":1.0},"76":{"tf":1.7320508075688772},"83":{"tf":1.0},"85":{"tf":1.4142135623730951},"88":{"tf":1.7320508075688772}}},"y":{".":{".":{".":{"\\":{"df":0,"docs":{},"n":{"df":1,"docs":{"85":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":3,"docs":{"76":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":3,"docs":{"76":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"df":1,"docs":{"36":{"tf":1.0}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"172":{"tf":1.4142135623730951}}}}}},"df":1,"docs":{"39":{"tf":1.0}}},"t":{"df":15,"docs":{"112":{"tf":1.0},"118":{"tf":1.4142135623730951},"130":{"tf":1.0},"132":{"tf":1.0},"137":{"tf":1.7320508075688772},"140":{"tf":1.0},"145":{"tf":1.0},"158":{"tf":1.0},"164":{"tf":2.8284271247461903},"193":{"tf":1.0},"199":{"tf":1.0},"225":{"tf":1.0},"3":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"k":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"153":{"tf":1.0}}}}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"150":{"tf":1.0}}}}},"df":0,"docs":{}}},"o":{"b":{"df":1,"docs":{"137":{"tf":1.0}}},"c":{"df":0,"docs":{},"k":{"df":9,"docs":{"100":{"tf":1.4142135623730951},"103":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"39":{"tf":1.0},"45":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951},"90":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951},"96":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"143":{"tf":1.0}}}}},"o":{"d":{"df":0,"docs":{},"i":{"df":2,"docs":{"159":{"tf":1.0},"230":{"tf":1.0}}}},"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"224":{"tf":1.0},"225":{"tf":1.0}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"130":{"tf":1.0}}}},"o":{"df":0,"docs":{},"k":{"df":3,"docs":{"112":{"tf":1.0},"191":{"tf":1.4142135623730951},"192":{"tf":1.4142135623730951}}},"l":{"df":6,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.0}}}}}}}}},"t":{"df":0,"docs":{},"h":{"df":11,"docs":{"0":{"tf":1.0},"110":{"tf":1.0},"118":{"tf":1.4142135623730951},"134":{"tf":1.0},"140":{"tf":1.0},"163":{"tf":1.4142135623730951},"164":{"tf":1.4142135623730951},"191":{"tf":1.0},"193":{"tf":1.0},"233":{"tf":1.0},"7":{"tf":1.0}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"163":{"tf":1.0},"227":{"tf":1.4142135623730951}}}}}},"u":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"157":{"tf":1.0}}}}},"df":8,"docs":{"144":{"tf":1.0},"148":{"tf":2.0},"150":{"tf":1.0},"151":{"tf":1.7320508075688772},"163":{"tf":1.0},"164":{"tf":2.23606797749979},"194":{"tf":1.0},"49":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"x":{"<":{"d":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"df":2,"docs":{"39":{"tf":1.0},"40":{"tf":1.0}}}}},"df":0,"docs":{}},"df":2,"docs":{"132":{"tf":1.0},"139":{"tf":1.0}}}},"r":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":8,"docs":{"100":{"tf":1.4142135623730951},"103":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951},"90":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951},"96":{"tf":1.4142135623730951}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"148":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":10,"docs":{"137":{"tf":1.0},"144":{"tf":1.4142135623730951},"203":{"tf":1.0},"204":{"tf":1.0},"208":{"tf":1.4142135623730951},"224":{"tf":3.4641016151377544},"225":{"tf":2.8284271247461903},"226":{"tf":3.1622776601683795},"227":{"tf":2.0},"3":{"tf":1.0}}}},"df":0,"docs":{}}},"df":8,"docs":{"100":{"tf":1.0},"103":{"tf":1.0},"106":{"tf":1.0},"45":{"tf":1.0},"72":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"157":{"tf":1.0}}}},"df":3,"docs":{"134":{"tf":2.23606797749979},"138":{"tf":1.0},"225":{"tf":1.4142135623730951}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"o":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"138":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"134":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"159":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"s":{"df":20,"docs":{"209":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.0},"50":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.0},"80":{"tf":1.0},"84":{"tf":1.0},"86":{"tf":1.0},"91":{"tf":1.0},"94":{"tf":1.0},"97":{"tf":1.0}}}}}},"s":{"d":{"df":1,"docs":{"139":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"g":{"df":17,"docs":{"134":{"tf":1.4142135623730951},"135":{"tf":1.0},"137":{"tf":1.0},"138":{"tf":2.0},"143":{"tf":1.0},"145":{"tf":2.8284271247461903},"150":{"tf":2.0},"151":{"tf":2.449489742783178},"163":{"tf":1.4142135623730951},"164":{"tf":1.0},"187":{"tf":1.0},"191":{"tf":1.0},"193":{"tf":2.23606797749979},"194":{"tf":2.0},"210":{"tf":1.0},"211":{"tf":1.0},"217":{"tf":1.0}},"g":{"df":0,"docs":{},"i":{"df":1,"docs":{"194":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"l":{"d":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"216":{"tf":1.0}}}},"df":45,"docs":{"119":{"tf":1.0},"121":{"tf":1.0},"125":{"tf":1.0},"128":{"tf":1.4142135623730951},"129":{"tf":2.0},"130":{"tf":4.47213595499958},"131":{"tf":2.23606797749979},"132":{"tf":3.0},"137":{"tf":1.0},"138":{"tf":1.0},"140":{"tf":1.0},"142":{"tf":1.0},"153":{"tf":1.0},"154":{"tf":1.0},"168":{"tf":2.0},"169":{"tf":1.4142135623730951},"170":{"tf":1.4142135623730951},"171":{"tf":1.0},"172":{"tf":1.0},"173":{"tf":3.0},"174":{"tf":1.7320508075688772},"175":{"tf":3.0},"176":{"tf":1.4142135623730951},"191":{"tf":1.0},"192":{"tf":1.7320508075688772},"195":{"tf":1.0},"200":{"tf":1.7320508075688772},"203":{"tf":1.4142135623730951},"209":{"tf":1.0},"218":{"tf":2.23606797749979},"3":{"tf":1.0},"39":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"59":{"tf":1.0},"61":{"tf":1.0},"70":{"tf":2.23606797749979},"73":{"tf":2.23606797749979},"76":{"tf":2.23606797749979},"79":{"tf":2.23606797749979},"83":{"tf":2.23606797749979},"88":{"tf":2.23606797749979},"96":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":10,"docs":{"0":{"tf":1.0},"122":{"tf":1.0},"132":{"tf":1.4142135623730951},"139":{"tf":1.0},"140":{"tf":1.0},"173":{"tf":1.4142135623730951},"218":{"tf":1.0},"224":{"tf":1.0},"55":{"tf":1.0},"61":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"k":{"df":2,"docs":{"137":{"tf":1.0},"216":{"tf":1.0}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":3,"docs":{"138":{"tf":1.4142135623730951},"209":{"tf":1.0},"227":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"p":{"df":6,"docs":{"134":{"tf":1.0},"208":{"tf":1.0},"214":{"tf":1.0},"224":{"tf":1.4142135623730951},"225":{"tf":1.0},"226":{"tf":1.7320508075688772}}}},"n":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"194":{"tf":1.0}}}},"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"103":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"138":{"tf":1.0},"206":{"tf":1.0},"209":{"tf":1.0}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"220":{"tf":1.0}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"224":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"d":{"df":4,"docs":{"0":{"tf":1.0},"135":{"tf":1.0},"149":{"tf":1.0},"234":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"226":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":7,"docs":{"106":{"tf":1.4142135623730951},"187":{"tf":1.0},"194":{"tf":3.3166247903554},"58":{"tf":1.0},"63":{"tf":1.4142135623730951},"82":{"tf":1.0},"83":{"tf":1.7320508075688772}}}}}},"c":{"a":{"c":{"df":0,"docs":{},"h":{"df":25,"docs":{"10":{"tf":1.0},"14":{"tf":2.6457513110645907},"15":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"167":{"tf":1.4142135623730951},"17":{"tf":1.7320508075688772},"18":{"tf":1.7320508075688772},"19":{"tf":1.7320508075688772},"20":{"tf":1.7320508075688772},"21":{"tf":2.0},"22":{"tf":1.7320508075688772},"23":{"tf":1.0},"24":{"tf":1.7320508075688772},"25":{"tf":2.6457513110645907},"26":{"tf":1.7320508075688772},"27":{"tf":1.7320508075688772},"28":{"tf":2.0},"29":{"tf":2.0},"30":{"tf":2.449489742783178},"31":{"tf":2.6457513110645907},"32":{"tf":2.0},"33":{"tf":1.7320508075688772},"34":{"tf":2.23606797749979},"35":{"tf":1.4142135623730951},"46":{"tf":1.0}},"e":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"16":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":12,"docs":{"103":{"tf":1.0},"106":{"tf":1.0},"44":{"tf":2.0},"45":{"tf":1.0},"46":{"tf":1.0},"71":{"tf":2.0},"72":{"tf":1.0},"73":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0},"99":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"52":{"tf":1.0}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"148":{"tf":1.0},"161":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"b":{"a":{"c":{"df":0,"docs":{},"k":{"(":{"df":0,"docs":{},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"88":{"tf":1.0}}},"df":0,"docs":{}}}}},".":{".":{".":{"\\":{"df":0,"docs":{},"n":{"df":2,"docs":{"70":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"66":{"tf":1.0}}}}}}},"df":2,"docs":{"66":{"tf":1.0},"88":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"88":{"tf":1.4142135623730951}}}}}},"df":4,"docs":{"43":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":35,"docs":{"110":{"tf":1.4142135623730951},"114":{"tf":1.4142135623730951},"115":{"tf":1.4142135623730951},"116":{"tf":1.4142135623730951},"119":{"tf":1.4142135623730951},"126":{"tf":1.7320508075688772},"13":{"tf":1.0},"137":{"tf":1.7320508075688772},"144":{"tf":1.7320508075688772},"157":{"tf":1.0},"158":{"tf":1.0},"160":{"tf":1.4142135623730951},"162":{"tf":1.0},"163":{"tf":2.6457513110645907},"193":{"tf":1.0},"39":{"tf":1.7320508075688772},"40":{"tf":3.4641016151377544},"42":{"tf":1.0},"43":{"tf":1.0},"57":{"tf":1.7320508075688772},"58":{"tf":1.4142135623730951},"63":{"tf":1.7320508075688772},"65":{"tf":1.0},"66":{"tf":1.4142135623730951},"69":{"tf":1.0},"70":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951},"76":{"tf":1.7320508075688772},"79":{"tf":1.0},"81":{"tf":1.7320508075688772},"82":{"tf":1.4142135623730951},"83":{"tf":1.0},"85":{"tf":1.4142135623730951},"87":{"tf":1.0},"88":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{".":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"(":{")":{".":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{")":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"d":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"(":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"<":{"'":{"_":{"df":2,"docs":{"40":{"tf":1.0},"43":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"158":{"tf":1.0},"163":{"tf":1.0},"40":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"70":{"tf":1.0},"88":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"144":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"—":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"144":{"tf":1.0}}}},"df":0,"docs":{}}}}},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"158":{"tf":1.0}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":7,"docs":{"131":{"tf":1.0},"138":{"tf":1.0},"145":{"tf":1.0},"159":{"tf":1.4142135623730951},"176":{"tf":1.4142135623730951},"220":{"tf":1.0},"221":{"tf":1.0}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"212":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"193":{"tf":1.0}}},"df":0,"docs":{}}}},"df":2,"docs":{"193":{"tf":1.0},"194":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":0,"docs":{}},"p":{"a":{"b":{"df":0,"docs":{},"l":{"df":6,"docs":{"120":{"tf":1.4142135623730951},"146":{"tf":1.0},"151":{"tf":1.0},"209":{"tf":1.0},"218":{"tf":1.0},"55":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"218":{"tf":1.0}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":7,"docs":{"111":{"tf":1.0},"117":{"tf":1.0},"127":{"tf":1.0},"158":{"tf":1.0},"163":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.7320508075688772}}}}}},"r":{"df":0,"docs":{},"e":{"df":3,"docs":{"163":{"tf":1.4142135623730951},"209":{"tf":1.0},"225":{"tf":1.0}}},"g":{"df":0,"docs":{},"o":{"'":{"df":1,"docs":{"130":{"tf":1.0}}},".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"206":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":3,"docs":{"203":{"tf":1.0},"205":{"tf":1.0},"39":{"tf":1.0}}}}}}},"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"199":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"=":{"1":{"df":1,"docs":{"130":{"tf":2.449489742783178}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"130":{"tf":2.6457513110645907}}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"=":{"df":1,"docs":{"130":{"tf":3.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"=":{"a":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"130":{"tf":2.6457513110645907}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"=":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":1,"docs":{"130":{"tf":2.23606797749979}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}},"df":48,"docs":{"115":{"tf":1.0},"118":{"tf":1.0},"121":{"tf":1.0},"128":{"tf":1.0},"130":{"tf":4.0},"131":{"tf":1.4142135623730951},"132":{"tf":1.4142135623730951},"142":{"tf":1.4142135623730951},"157":{"tf":1.0},"171":{"tf":1.0},"173":{"tf":2.0},"175":{"tf":2.0},"178":{"tf":2.0},"179":{"tf":2.0},"180":{"tf":1.4142135623730951},"181":{"tf":1.4142135623730951},"183":{"tf":1.0},"184":{"tf":1.0},"188":{"tf":1.7320508075688772},"191":{"tf":1.7320508075688772},"192":{"tf":1.0},"194":{"tf":1.0},"195":{"tf":1.0},"199":{"tf":1.7320508075688772},"200":{"tf":2.449489742783178},"202":{"tf":1.0},"204":{"tf":1.7320508075688772},"206":{"tf":1.7320508075688772},"207":{"tf":2.23606797749979},"208":{"tf":2.23606797749979},"209":{"tf":2.23606797749979},"218":{"tf":1.4142135623730951},"39":{"tf":2.0},"43":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0},"59":{"tf":1.0},"61":{"tf":1.7320508075688772},"63":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"224":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"194":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"194":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":21,"docs":{"130":{"tf":1.0},"131":{"tf":1.0},"137":{"tf":1.0},"151":{"tf":1.0},"160":{"tf":1.4142135623730951},"162":{"tf":1.4142135623730951},"163":{"tf":1.4142135623730951},"185":{"tf":1.4142135623730951},"187":{"tf":2.8284271247461903},"188":{"tf":1.4142135623730951},"190":{"tf":1.0},"193":{"tf":3.4641016151377544},"194":{"tf":3.4641016151377544},"204":{"tf":1.0},"208":{"tf":1.0},"212":{"tf":1.0},"216":{"tf":1.0},"31":{"tf":1.0},"39":{"tf":1.7320508075688772},"46":{"tf":1.0},"70":{"tf":1.0}},"s":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"131":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"101":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"138":{"tf":1.0},"145":{"tf":1.0},"163":{"tf":1.4142135623730951},"190":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"155":{"tf":1.0}},"i":{"df":3,"docs":{"137":{"tf":1.7320508075688772},"138":{"tf":1.0},"208":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"s":{"df":4,"docs":{"111":{"tf":1.0},"128":{"tf":1.0},"193":{"tf":1.0},"203":{"tf":1.0}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"150":{"tf":1.0}}}}}}}},"c":{"df":6,"docs":{"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0}}},"d":{"df":12,"docs":{"175":{"tf":1.4142135623730951},"179":{"tf":1.4142135623730951},"39":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0},"99":{"tf":1.0}}},"df":39,"docs":{"114":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.0},"122":{"tf":2.0},"126":{"tf":1.0},"131":{"tf":2.23606797749979},"132":{"tf":1.0},"135":{"tf":1.0},"142":{"tf":1.0},"174":{"tf":1.4142135623730951},"192":{"tf":1.0},"216":{"tf":1.7320508075688772},"217":{"tf":1.0},"36":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"67":{"tf":2.23606797749979},"68":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.4142135623730951},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.4142135623730951},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.7320508075688772},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.4142135623730951},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.7320508075688772},"92":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"192":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"112":{"tf":1.0},"128":{"tf":1.0},"194":{"tf":1.0}}}}},"df":0,"docs":{}}}},"f":{"df":0,"docs":{},"g":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"183":{"tf":1.4142135623730951}}}}}}},"df":1,"docs":{"132":{"tf":1.0}}}},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"/":{"a":{"df":0,"docs":{},"u":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"206":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"209":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":4,"docs":{"206":{"tf":1.0},"207":{"tf":1.0},"208":{"tf":1.0},"209":{"tf":2.0}}}},"n":{"df":0,"docs":{},"g":{"df":27,"docs":{"114":{"tf":1.0},"115":{"tf":1.0},"126":{"tf":1.0},"134":{"tf":2.449489742783178},"136":{"tf":1.4142135623730951},"138":{"tf":4.58257569495584},"14":{"tf":1.0},"161":{"tf":1.0},"180":{"tf":1.0},"190":{"tf":1.4142135623730951},"194":{"tf":1.4142135623730951},"203":{"tf":1.0},"207":{"tf":1.0},"208":{"tf":1.0},"209":{"tf":1.0},"212":{"tf":2.0},"213":{"tf":1.7320508075688772},"214":{"tf":1.0},"218":{"tf":1.4142135623730951},"220":{"tf":1.7320508075688772},"222":{"tf":1.4142135623730951},"224":{"tf":2.449489742783178},"225":{"tf":2.23606797749979},"227":{"tf":1.0},"24":{"tf":1.0},"30":{"tf":1.0},"55":{"tf":1.0}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"r":{"df":8,"docs":{"128":{"tf":1.0},"70":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951},"76":{"tf":1.7320508075688772},"79":{"tf":1.4142135623730951},"83":{"tf":2.0},"85":{"tf":1.7320508075688772},"88":{"tf":1.7320508075688772}}},"t":{"df":2,"docs":{"153":{"tf":1.7320508075688772},"154":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"151":{"tf":1.4142135623730951}}}},"c":{"df":0,"docs":{},"k":{"(":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"76":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"96":{"tf":2.0}}}}},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":2.23606797749979}}}}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.7320508075688772}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"76":{"tf":1.7320508075688772}}}}}},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"0":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"1":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":2.6457513110645907}}}}}}}}},"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"2":{"(":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"76":{"tf":1.0}}}}}},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"2":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}}}}},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"1":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"2":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":1,"docs":{"216":{"tf":1.0}}}}},"df":27,"docs":{"1":{"tf":1.0},"104":{"tf":1.0},"107":{"tf":1.0},"110":{"tf":1.0},"128":{"tf":1.4142135623730951},"137":{"tf":1.0},"144":{"tf":1.4142135623730951},"145":{"tf":1.0},"148":{"tf":1.7320508075688772},"162":{"tf":1.0},"164":{"tf":2.0},"180":{"tf":1.4142135623730951},"187":{"tf":1.0},"191":{"tf":1.4142135623730951},"193":{"tf":1.0},"194":{"tf":1.4142135623730951},"2":{"tf":1.0},"202":{"tf":1.0},"206":{"tf":1.0},"208":{"tf":1.0},"222":{"tf":1.0},"224":{"tf":1.0},"225":{"tf":1.0},"226":{"tf":1.0},"24":{"tf":1.0},"37":{"tf":1.0},"76":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"128":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"217":{"tf":1.0},"223":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"i":{"c":{"df":3,"docs":{"143":{"tf":1.0},"145":{"tf":1.0},"187":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"131":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":2,"docs":{"131":{"tf":1.0},"164":{"tf":1.0}}}}}},"i":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"227":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"df":2,"docs":{"178":{"tf":1.0},"226":{"tf":1.4142135623730951}}}}}},"df":18,"docs":{"131":{"tf":1.4142135623730951},"137":{"tf":3.0},"138":{"tf":2.6457513110645907},"139":{"tf":1.0},"178":{"tf":1.0},"189":{"tf":2.449489742783178},"190":{"tf":3.3166247903554},"191":{"tf":3.1622776601683795},"192":{"tf":2.6457513110645907},"203":{"tf":2.0},"204":{"tf":1.7320508075688772},"205":{"tf":1.7320508075688772},"206":{"tf":1.7320508075688772},"221":{"tf":1.0},"224":{"tf":2.6457513110645907},"225":{"tf":2.0},"226":{"tf":2.449489742783178},"3":{"tf":1.0}},"r":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"138":{"tf":1.0},"234":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"110":{"tf":1.0}}}},"p":{"df":1,"docs":{"131":{"tf":1.0}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"232":{"tf":1.0},"233":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"93":{"tf":1.0}},"i":{"c":{"df":1,"docs":{"150":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"138":{"tf":2.23606797749979}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":6,"docs":{"21":{"tf":1.0},"34":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0}},"u":{"df":0,"docs":{},"p":{"df":5,"docs":{"14":{"tf":1.0},"21":{"tf":1.7320508075688772},"28":{"tf":1.0},"29":{"tf":1.0},"34":{"tf":1.0}}}}},"r":{"df":4,"docs":{"122":{"tf":1.4142135623730951},"137":{"tf":1.0},"138":{"tf":1.4142135623730951},"212":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"134":{"tf":1.0},"138":{"tf":1.0},"157":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"'":{"df":1,"docs":{"7":{"tf":1.0}}},"_":{"df":1,"docs":{"185":{"tf":1.0}},"m":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"185":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"185":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"123":{"tf":1.0}}}},"df":55,"docs":{"0":{"tf":1.0},"1":{"tf":2.449489742783178},"10":{"tf":1.4142135623730951},"11":{"tf":1.4142135623730951},"110":{"tf":1.4142135623730951},"114":{"tf":1.4142135623730951},"115":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"121":{"tf":1.0},"122":{"tf":1.7320508075688772},"123":{"tf":1.0},"124":{"tf":1.0},"126":{"tf":1.4142135623730951},"127":{"tf":1.0},"128":{"tf":1.4142135623730951},"13":{"tf":2.23606797749979},"130":{"tf":2.23606797749979},"131":{"tf":2.23606797749979},"135":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"167":{"tf":1.0},"17":{"tf":1.0},"173":{"tf":2.0},"178":{"tf":1.0},"18":{"tf":1.0},"180":{"tf":1.4142135623730951},"185":{"tf":1.0},"19":{"tf":1.0},"192":{"tf":1.4142135623730951},"2":{"tf":1.7320508075688772},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.4142135623730951},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"4":{"tf":1.4142135623730951},"5":{"tf":2.23606797749979},"6":{"tf":1.4142135623730951},"7":{"tf":2.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"204":{"tf":3.7416573867739413}}}}}},"o":{"c":{"df":0,"docs":{},"k":{"df":8,"docs":{"0":{"tf":1.0},"137":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"34":{"tf":1.0},"54":{"tf":1.0}},"i":{"d":{"df":1,"docs":{"115":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":16,"docs":{"41":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.0},"50":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.0},"80":{"tf":1.0},"84":{"tf":1.0},"86":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"112":{"tf":1.0}}},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"53":{"tf":1.0},"88":{"tf":1.0}},"e":{".":{".":{".":{"\\":{"df":0,"docs":{},"n":{"df":1,"docs":{"88":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"(":{"df":0,"docs":{},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"88":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"m":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":8,"docs":{"52":{"tf":1.0},"55":{"tf":1.0},"70":{"tf":1.7320508075688772},"73":{"tf":1.7320508075688772},"76":{"tf":1.7320508075688772},"79":{"tf":2.0},"83":{"tf":1.7320508075688772},"88":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"o":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"221":{"tf":1.0}}}}},"c":{"df":1,"docs":{"234":{"tf":1.7320508075688772}}},"d":{"df":0,"docs":{},"e":{"df":89,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":1.0},"103":{"tf":1.0},"106":{"tf":1.0},"111":{"tf":1.4142135623730951},"112":{"tf":1.7320508075688772},"113":{"tf":1.4142135623730951},"116":{"tf":1.4142135623730951},"118":{"tf":1.0},"120":{"tf":1.0},"122":{"tf":1.4142135623730951},"130":{"tf":2.0},"131":{"tf":1.4142135623730951},"137":{"tf":1.4142135623730951},"138":{"tf":2.0},"141":{"tf":1.0},"143":{"tf":1.0},"147":{"tf":1.0},"150":{"tf":1.0},"152":{"tf":1.0},"153":{"tf":1.0},"155":{"tf":1.0},"156":{"tf":1.0},"158":{"tf":3.0},"159":{"tf":3.4641016151377544},"160":{"tf":2.23606797749979},"162":{"tf":1.4142135623730951},"163":{"tf":2.23606797749979},"164":{"tf":1.4142135623730951},"165":{"tf":1.0},"166":{"tf":1.0},"167":{"tf":1.0},"183":{"tf":1.4142135623730951},"185":{"tf":1.0},"188":{"tf":1.0},"189":{"tf":1.0},"191":{"tf":1.7320508075688772},"192":{"tf":1.0},"193":{"tf":1.0},"201":{"tf":1.7320508075688772},"202":{"tf":1.4142135623730951},"203":{"tf":1.0},"204":{"tf":1.0},"205":{"tf":1.0},"206":{"tf":2.0},"207":{"tf":1.0},"208":{"tf":1.0},"209":{"tf":1.4142135623730951},"210":{"tf":1.0},"212":{"tf":1.7320508075688772},"218":{"tf":1.0},"220":{"tf":2.0},"221":{"tf":1.0},"222":{"tf":1.0},"229":{"tf":2.23606797749979},"230":{"tf":1.0},"231":{"tf":1.0},"232":{"tf":1.7320508075688772},"233":{"tf":1.4142135623730951},"234":{"tf":1.4142135623730951},"235":{"tf":1.4142135623730951},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951},"56":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":2.0},"62":{"tf":1.0},"64":{"tf":1.0},"68":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.4142135623730951},"80":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.4142135623730951},"94":{"tf":1.0},"96":{"tf":1.4142135623730951}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"130":{"tf":1.7320508075688772}}}}},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"221":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"220":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"t":{"df":12,"docs":{"116":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.4142135623730951},"121":{"tf":1.4142135623730951},"122":{"tf":2.23606797749979},"123":{"tf":1.0},"124":{"tf":1.7320508075688772},"158":{"tf":1.0},"160":{"tf":1.0},"165":{"tf":1.0},"220":{"tf":1.0},"222":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"118":{"tf":1.0},"121":{"tf":1.4142135623730951},"166":{"tf":1.0}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"147":{"tf":1.0}}}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"132":{"tf":1.0},"139":{"tf":1.0},"188":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":9,"docs":{"112":{"tf":1.0},"131":{"tf":1.0},"133":{"tf":1.0},"138":{"tf":1.0},"143":{"tf":1.0},"151":{"tf":1.0},"166":{"tf":1.0},"226":{"tf":1.0},"228":{"tf":1.0}}},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":40,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"103":{"tf":1.0},"106":{"tf":1.0},"111":{"tf":1.7320508075688772},"114":{"tf":1.4142135623730951},"115":{"tf":1.7320508075688772},"116":{"tf":1.4142135623730951},"118":{"tf":1.0},"119":{"tf":1.4142135623730951},"121":{"tf":1.7320508075688772},"126":{"tf":1.4142135623730951},"128":{"tf":1.0},"13":{"tf":1.0},"130":{"tf":2.0},"131":{"tf":1.4142135623730951},"147":{"tf":1.4142135623730951},"170":{"tf":1.0},"173":{"tf":1.4142135623730951},"175":{"tf":1.0},"178":{"tf":1.0},"179":{"tf":1.0},"181":{"tf":1.0},"194":{"tf":1.0},"195":{"tf":1.0},"2":{"tf":1.0},"216":{"tf":1.0},"218":{"tf":1.7320508075688772},"39":{"tf":1.0},"6":{"tf":1.0},"61":{"tf":1.0},"7":{"tf":1.7320508075688772},"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":7,"docs":{"154":{"tf":1.0},"156":{"tf":1.0},"158":{"tf":1.0},"212":{"tf":1.0},"214":{"tf":1.0},"231":{"tf":1.0},"232":{"tf":1.0}}}},"r":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"118":{"tf":1.0}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"t":{"df":11,"docs":{"138":{"tf":1.7320508075688772},"164":{"tf":1.4142135623730951},"190":{"tf":1.0},"191":{"tf":1.0},"208":{"tf":2.449489742783178},"212":{"tf":1.7320508075688772},"213":{"tf":2.6457513110645907},"221":{"tf":1.4142135623730951},"224":{"tf":1.7320508075688772},"225":{"tf":1.4142135623730951},"232":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"df":10,"docs":{"103":{"tf":1.0},"106":{"tf":1.0},"108":{"tf":1.0},"201":{"tf":1.0},"209":{"tf":1.0},"50":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0},"99":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"df":9,"docs":{"0":{"tf":1.0},"118":{"tf":1.0},"134":{"tf":1.0},"158":{"tf":1.0},"220":{"tf":1.7320508075688772},"221":{"tf":1.0},"230":{"tf":1.0},"231":{"tf":1.4142135623730951},"233":{"tf":1.4142135623730951}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":4,"docs":{"138":{"tf":1.0},"161":{"tf":1.0},"187":{"tf":1.0},"193":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"161":{"tf":1.4142135623730951}}}}}}},"t":{"df":3,"docs":{"11":{"tf":1.0},"134":{"tf":1.4142135623730951},"192":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"159":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":63,"docs":{"0":{"tf":1.0},"103":{"tf":1.0},"106":{"tf":1.0},"11":{"tf":2.6457513110645907},"110":{"tf":1.4142135623730951},"111":{"tf":1.4142135623730951},"115":{"tf":1.0},"119":{"tf":1.0},"122":{"tf":1.0},"128":{"tf":1.4142135623730951},"130":{"tf":2.8284271247461903},"131":{"tf":2.0},"132":{"tf":2.0},"137":{"tf":2.449489742783178},"138":{"tf":1.0},"140":{"tf":2.23606797749979},"142":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.0},"150":{"tf":1.4142135623730951},"151":{"tf":1.0},"155":{"tf":2.0},"157":{"tf":1.0},"158":{"tf":2.6457513110645907},"159":{"tf":3.872983346207417},"160":{"tf":2.23606797749979},"161":{"tf":1.4142135623730951},"162":{"tf":1.0},"167":{"tf":2.449489742783178},"177":{"tf":1.0},"181":{"tf":1.0},"183":{"tf":1.0},"185":{"tf":1.0},"195":{"tf":2.23606797749979},"196":{"tf":1.0},"197":{"tf":2.0},"198":{"tf":1.4142135623730951},"199":{"tf":1.4142135623730951},"200":{"tf":2.0},"203":{"tf":2.8284271247461903},"204":{"tf":1.4142135623730951},"217":{"tf":1.4142135623730951},"218":{"tf":1.0},"221":{"tf":1.0},"39":{"tf":2.449489742783178},"4":{"tf":1.7320508075688772},"40":{"tf":1.0},"43":{"tf":2.0},"49":{"tf":1.4142135623730951},"51":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.0},"61":{"tf":1.0},"66":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":2.449489742783178},"73":{"tf":1.7320508075688772},"76":{"tf":1.7320508075688772},"79":{"tf":1.7320508075688772},"80":{"tf":1.0},"83":{"tf":2.23606797749979},"85":{"tf":1.4142135623730951},"88":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"136":{"tf":1.0}}},"df":0,"docs":{}}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"234":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":6,"docs":{"11":{"tf":1.0},"137":{"tf":1.4142135623730951},"138":{"tf":1.4142135623730951},"162":{"tf":1.0},"216":{"tf":1.0},"226":{"tf":1.0}}}},"i":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}},"c":{"df":3,"docs":{"162":{"tf":1.0},"165":{"tf":1.0},"187":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"df":9,"docs":{"0":{"tf":2.0},"137":{"tf":1.0},"138":{"tf":3.4641016151377544},"142":{"tf":1.0},"185":{"tf":1.0},"192":{"tf":1.0},"218":{"tf":3.0},"30":{"tf":1.0},"8":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"218":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"138":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"112":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"s":{"df":6,"docs":{"18":{"tf":2.23606797749979},"19":{"tf":2.0},"20":{"tf":1.4142135623730951},"22":{"tf":1.7320508075688772},"31":{"tf":1.4142135623730951},"33":{"tf":2.6457513110645907}}}}}},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"150":{"tf":1.4142135623730951},"151":{"tf":1.0}}}}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"158":{"tf":2.0},"41":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"217":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"220":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"220":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"20":{"tf":1.0},"33":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"131":{"tf":1.0}}}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":9,"docs":{"152":{"tf":1.0},"220":{"tf":1.0},"229":{"tf":2.23606797749979},"230":{"tf":1.0},"231":{"tf":1.4142135623730951},"232":{"tf":1.4142135623730951},"233":{"tf":1.4142135623730951},"234":{"tf":1.4142135623730951},"235":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"d":{"df":4,"docs":{"138":{"tf":1.4142135623730951},"145":{"tf":1.0},"152":{"tf":1.0},"217":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"234":{"tf":1.0}}}}}}},"df":0,"docs":{},"g":{".":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"55":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},":":{":":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"110":{"tf":1.0}}}}}},"df":1,"docs":{"116":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":3,"docs":{"55":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":4,"docs":{"114":{"tf":1.0},"115":{"tf":1.0},"119":{"tf":1.0},"126":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":9,"docs":{"10":{"tf":1.7320508075688772},"137":{"tf":1.0},"14":{"tf":1.4142135623730951},"164":{"tf":1.0},"43":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0},"63":{"tf":1.0},"85":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":53,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":1.7320508075688772},"111":{"tf":1.0},"124":{"tf":1.4142135623730951},"128":{"tf":1.0},"130":{"tf":2.6457513110645907},"132":{"tf":1.0},"14":{"tf":2.23606797749979},"145":{"tf":1.0},"147":{"tf":1.0},"148":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"150":{"tf":1.0},"158":{"tf":1.0},"16":{"tf":1.0},"162":{"tf":1.0},"164":{"tf":2.6457513110645907},"17":{"tf":1.0},"18":{"tf":1.0},"183":{"tf":1.0},"189":{"tf":1.0},"19":{"tf":1.0},"199":{"tf":1.7320508075688772},"2":{"tf":1.0},"20":{"tf":1.0},"202":{"tf":1.0},"204":{"tf":1.0},"206":{"tf":1.4142135623730951},"21":{"tf":1.0},"22":{"tf":1.0},"224":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"39":{"tf":1.0},"43":{"tf":1.0},"52":{"tf":1.4142135623730951},"59":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.4142135623730951},"70":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0}}}}},"n":{"df":1,"docs":{"150":{"tf":1.0}}},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"2":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"147":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":5,"docs":{"103":{"tf":1.0},"106":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"118":{"tf":1.0},"147":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":1,"docs":{"134":{"tf":1.0}}}}},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"165":{"tf":1.0}}}},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"166":{"tf":1.7320508075688772}}}}},"i":{"d":{"df":11,"docs":{"111":{"tf":1.0},"131":{"tf":1.0},"132":{"tf":1.0},"138":{"tf":1.0},"145":{"tf":1.0},"150":{"tf":2.8284271247461903},"151":{"tf":1.7320508075688772},"157":{"tf":1.0},"211":{"tf":1.0},"212":{"tf":1.0},"231":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"189":{"tf":1.0},"192":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"13":{"tf":1.0},"93":{"tf":1.4142135623730951}},"e":{".":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"(":{"$":{"\"":{"df":0,"docs":{},"g":{"c":{"d":{"(":{"2":{"7":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"138":{"tf":1.0}}}}},"df":7,"docs":{"137":{"tf":1.0},"185":{"tf":1.0},"70":{"tf":1.0},"76":{"tf":2.0},"83":{"tf":1.4142135623730951},"85":{"tf":1.0},"88":{"tf":1.7320508075688772}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"231":{"tf":1.0},"55":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":5,"docs":{"130":{"tf":1.0},"138":{"tf":1.0},"2":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.0}}}},"m":{"df":4,"docs":{"109":{"tf":1.0},"111":{"tf":1.4142135623730951},"157":{"tf":1.0},"224":{"tf":1.0}},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"158":{"tf":1.0}}}}}}},"t":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"153":{"tf":1.0},"234":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":17,"docs":{"1":{"tf":1.0},"108":{"tf":1.0},"121":{"tf":1.0},"131":{"tf":1.0},"156":{"tf":1.0},"158":{"tf":1.4142135623730951},"160":{"tf":1.0},"165":{"tf":1.0},"170":{"tf":1.0},"178":{"tf":1.0},"192":{"tf":1.4142135623730951},"194":{"tf":1.4142135623730951},"206":{"tf":1.4142135623730951},"208":{"tf":1.0},"218":{"tf":1.0},"43":{"tf":1.4142135623730951},"94":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"158":{"tf":1.0},"224":{"tf":1.0},"226":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"df":14,"docs":{"110":{"tf":1.0},"158":{"tf":1.7320508075688772},"160":{"tf":1.0},"212":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.4142135623730951},"55":{"tf":1.0},"70":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951},"76":{"tf":1.0},"79":{"tf":2.0},"83":{"tf":2.23606797749979},"85":{"tf":1.0},"88":{"tf":1.0}},"u":{"df":2,"docs":{"130":{"tf":1.0},"159":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"164":{"tf":1.0}}}},"n":{"df":0,"docs":{},"u":{"df":9,"docs":{"130":{"tf":1.0},"137":{"tf":1.7320508075688772},"138":{"tf":1.7320508075688772},"148":{"tf":1.0},"176":{"tf":1.0},"189":{"tf":1.7320508075688772},"202":{"tf":1.0},"203":{"tf":1.0},"3":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":94,"docs":{"0":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"107":{"tf":1.4142135623730951},"131":{"tf":1.0},"138":{"tf":1.0},"14":{"tf":1.0},"152":{"tf":1.7320508075688772},"153":{"tf":1.0},"154":{"tf":1.0},"155":{"tf":1.0},"156":{"tf":1.0},"157":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.0},"160":{"tf":1.0},"161":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":1.0},"165":{"tf":1.0},"166":{"tf":1.0},"167":{"tf":1.0},"168":{"tf":1.0},"169":{"tf":1.0},"170":{"tf":1.0},"171":{"tf":1.0},"172":{"tf":1.0},"173":{"tf":1.0},"174":{"tf":1.0},"175":{"tf":1.0},"176":{"tf":1.0},"177":{"tf":1.0},"178":{"tf":1.0},"179":{"tf":1.0},"180":{"tf":1.0},"181":{"tf":1.0},"182":{"tf":1.0},"183":{"tf":1.0},"184":{"tf":1.0},"185":{"tf":1.0},"186":{"tf":1.0},"187":{"tf":1.0},"188":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.0},"191":{"tf":1.0},"192":{"tf":1.0},"193":{"tf":1.0},"194":{"tf":1.0},"195":{"tf":1.4142135623730951},"196":{"tf":1.0},"197":{"tf":1.0},"198":{"tf":1.0},"199":{"tf":1.0},"200":{"tf":1.0},"201":{"tf":1.0},"202":{"tf":1.0},"203":{"tf":1.0},"204":{"tf":1.0},"205":{"tf":1.0},"206":{"tf":1.7320508075688772},"207":{"tf":1.4142135623730951},"208":{"tf":1.0},"209":{"tf":1.0},"210":{"tf":1.0},"211":{"tf":1.0},"212":{"tf":1.0},"213":{"tf":1.0},"214":{"tf":1.0},"215":{"tf":1.0},"216":{"tf":1.0},"217":{"tf":1.0},"218":{"tf":1.0},"219":{"tf":1.0},"220":{"tf":2.449489742783178},"221":{"tf":1.4142135623730951},"222":{"tf":2.23606797749979},"223":{"tf":1.0},"224":{"tf":1.0},"225":{"tf":1.0},"226":{"tf":1.0},"227":{"tf":1.0},"228":{"tf":1.0},"229":{"tf":1.0},"230":{"tf":1.0},"231":{"tf":1.4142135623730951},"232":{"tf":1.4142135623730951},"233":{"tf":1.0},"234":{"tf":1.0},"235":{"tf":1.0},"4":{"tf":1.0},"91":{"tf":1.4142135623730951},"94":{"tf":1.4142135623730951},"97":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"208":{"tf":2.23606797749979}}},"df":14,"docs":{"138":{"tf":1.4142135623730951},"154":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.4142135623730951},"204":{"tf":1.4142135623730951},"206":{"tf":1.0},"207":{"tf":1.7320508075688772},"208":{"tf":2.23606797749979},"220":{"tf":2.0},"221":{"tf":1.4142135623730951},"229":{"tf":1.4142135623730951},"230":{"tf":1.0},"232":{"tf":1.0},"235":{"tf":1.0}}}}}}},"df":0,"docs":{},"v":{"df":1,"docs":{"132":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"df":11,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"13":{"tf":1.0},"137":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.4142135623730951},"147":{"tf":1.0},"151":{"tf":1.4142135623730951},"163":{"tf":1.4142135623730951},"203":{"tf":1.0},"204":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.0}}},"t":{"df":2,"docs":{"137":{"tf":1.0},"201":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":2,"docs":{"137":{"tf":1.0},"160":{"tf":1.0}}},"t":{"df":1,"docs":{"218":{"tf":1.0}}}},"y":{"df":1,"docs":{"138":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"i":{"df":10,"docs":{"103":{"tf":1.0},"106":{"tf":1.0},"159":{"tf":1.0},"160":{"tf":1.0},"185":{"tf":1.0},"227":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0},"99":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"h":{"c":{"5":{"c":{"b":{"6":{"df":0,"docs":{},"f":{"1":{"b":{"3":{"9":{"a":{"0":{"df":0,"docs":{},"e":{"7":{"a":{"1":{"df":1,"docs":{"122":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"=":{".":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"111":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"111":{"tf":1.0},"63":{"tf":1.0}}}}}},"df":13,"docs":{"109":{"tf":1.0},"111":{"tf":3.3166247903554},"144":{"tf":1.7320508075688772},"162":{"tf":1.0},"214":{"tf":2.0},"219":{"tf":1.4142135623730951},"220":{"tf":1.0},"221":{"tf":1.7320508075688772},"41":{"tf":1.0},"62":{"tf":2.0},"63":{"tf":3.0},"92":{"tf":1.0},"93":{"tf":1.4142135623730951}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"a":{"df":1,"docs":{"216":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"df":2,"docs":{"188":{"tf":1.0},"191":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":9,"docs":{"0":{"tf":1.0},"115":{"tf":1.0},"134":{"tf":1.4142135623730951},"138":{"tf":1.4142135623730951},"145":{"tf":1.0},"162":{"tf":1.0},"206":{"tf":1.0},"209":{"tf":1.0},"232":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"163":{"tf":1.0},"194":{"tf":1.0},"222":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"158":{"tf":1.0},"162":{"tf":1.0},"211":{"tf":1.0}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"150":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"131":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":9,"docs":{"158":{"tf":1.0},"159":{"tf":1.4142135623730951},"165":{"tf":1.7320508075688772},"166":{"tf":2.23606797749979},"20":{"tf":1.0},"26":{"tf":1.7320508075688772},"28":{"tf":2.449489742783178},"34":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"112":{"tf":1.0},"163":{"tf":1.0},"20":{"tf":1.4142135623730951},"33":{"tf":1.7320508075688772}}}}}},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"150":{"tf":1.0},"188":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":4,"docs":{"138":{"tf":1.0},"191":{"tf":1.0},"216":{"tf":1.0},"220":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"/":{"1":{"/":{"4":{"df":1,"docs":{"235":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":2,"docs":{"229":{"tf":1.4142135623730951},"235":{"tf":1.0}}},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"191":{"tf":1.0}}}},"df":7,"docs":{"137":{"tf":1.0},"143":{"tf":1.0},"160":{"tf":1.0},"163":{"tf":1.4142135623730951},"189":{"tf":1.0},"212":{"tf":1.0},"220":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"135":{"tf":1.0}}},"u":{"df":3,"docs":{"0":{"tf":1.0},"112":{"tf":1.4142135623730951},"122":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"'":{"df":2,"docs":{"138":{"tf":1.4142135623730951},"140":{"tf":1.0}}},"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"178":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}}}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"180":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":