# @HEADER
# *****************************************************************************
#            TriBITS: Tribal Build, Integrate, and Test System
#
# Copyright 2013-2016 NTESS and the TriBITS contributors.
# SPDX-License-Identifier: BSD-3-Clause
# *****************************************************************************
# @HEADER

##############################################################################
#
# CMake variable for use by Trilinos/ShyLU_NodeTacho clients.
#
# Do not edit: This file was generated automatically by CMake.
#
##############################################################################

if(CMAKE_VERSION VERSION_LESS 3.3)
  set(${CMAKE_FIND_PACKAGE_NAME}_NOT_FOUND_MESSAGE
    "ShyLU_NodeTacho requires CMake 3.3 or later for 'if (... IN_LIST ...)'"
    )
  set(${CMAKE_FIND_PACKAGE_NAME}_FOUND FALSE)
  return()
endif()
cmake_minimum_required(VERSION 3.3...3.23.0)

## ---------------------------------------------------------------------------
## Compilers used by Trilinos/ShyLU_NodeTacho build
## ---------------------------------------------------------------------------

set(ShyLU_NodeTacho_CXX_COMPILER "C:/M/msys64/clangarm64/bin/clang++.exe")

set(ShyLU_NodeTacho_C_COMPILER "C:/M/msys64/clangarm64/bin/clang.exe")

set(ShyLU_NodeTacho_Fortran_COMPILER "C:/M/msys64/clangarm64/bin/flang.exe")
# Deprecated!
set(ShyLU_NodeTacho_FORTRAN_COMPILER "C:/M/msys64/clangarm64/bin/flang.exe") 


## ---------------------------------------------------------------------------
## Compiler flags used by Trilinos/ShyLU_NodeTacho build
## ---------------------------------------------------------------------------

## Give the build type
set(ShyLU_NodeTacho_CMAKE_BUILD_TYPE "Release")

## Set compiler flags, including those determined by build type
set(ShyLU_NodeTacho_CXX_FLAGS [[ ]])

set(ShyLU_NodeTacho_C_FLAGS [[-O2 -pipe -Wp,-D_FORTIFY_SOURCE=2 -fstack-protector-strong -Wp,-D__USE_MINGW_ANSI_STDIO=1 ]])

set(ShyLU_NodeTacho_Fortran_FLAGS [[ ]])
# Deprecated
set(ShyLU_NodeTacho_FORTRAN_FLAGS [[ ]])

## Extra link flags (e.g., specification of fortran libraries)
set(ShyLU_NodeTacho_EXTRA_LD_FLAGS [[]])

## This is the command-line entry used for setting rpaths. In a build
## with static libraries it will be empty.
set(ShyLU_NodeTacho_SHARED_LIB_RPATH_COMMAND "/clangarm64/lib")
set(ShyLU_NodeTacho_BUILD_SHARED_LIBS "ON")

set(ShyLU_NodeTacho_LINKER C:/M/msys64/clangarm64/bin/ld.lld.exe)
set(ShyLU_NodeTacho_AR C:/M/msys64/clangarm64/bin/llvm-ar.exe)

## ---------------------------------------------------------------------------
## Set library specifications and paths
## ---------------------------------------------------------------------------

## Base install location (if not in the build tree)
set(ShyLU_NodeTacho_INSTALL_DIR "/clangarm64")

## List of package libraries
set(ShyLU_NodeTacho_LIBRARIES ShyLU_NodeTacho::all_libs)

## ---------------------------------------------------------------------------
## MPI specific variables
##   These variables are provided to make it easier to get the mpi libraries
##   and includes on systems that do not use the mpi wrappers for compiling
## ---------------------------------------------------------------------------

set(ShyLU_NodeTacho_MPI_LIBRARIES "")
set(ShyLU_NodeTacho_MPI_LIBRARY_DIRS "")
set(ShyLU_NodeTacho_MPI_INCLUDE_DIRS "")
set(ShyLU_NodeTacho_MPI_EXEC "")
set(ShyLU_NodeTacho_MPI_EXEC_MAX_NUMPROCS "")
set(ShyLU_NodeTacho_MPI_EXEC_NUMPROCS_FLAG "")

## ---------------------------------------------------------------------------
## Set useful general variables
## ---------------------------------------------------------------------------

# Enables/Disables for upstream package dependencies
set(ShyLU_NodeTacho_ENABLE_Kokkos ON)
set(ShyLU_NodeTacho_ENABLE_TrilinosSS ON)
set(ShyLU_NodeTacho_ENABLE_METIS OFF)
set(ShyLU_NodeTacho_ENABLE_MKL OFF)
set(ShyLU_NodeTacho_ENABLE_LAPACK ON)
set(ShyLU_NodeTacho_ENABLE_BLAS ON)
set(ShyLU_NodeTacho_ENABLE_Pthread OFF)
set(ShyLU_NodeTacho_ENABLE_QTHREAD OFF)
set(ShyLU_NodeTacho_ENABLE_VTune OFF)
set(ShyLU_NodeTacho_ENABLE_CUSOLVER OFF)
set(ShyLU_NodeTacho_ENABLE_CUSPARSE OFF)
set(ShyLU_NodeTacho_ENABLE_CUBLAS OFF)
set(ShyLU_NodeTacho_ENABLE_CUDA OFF)
set(ShyLU_NodeTacho_ENABLE_ROCSOLVER OFF)
set(ShyLU_NodeTacho_ENABLE_ROCBLAS OFF)
set(ShyLU_NodeTacho_ENABLE_ROCSPARSE OFF)

# Exported cache variables

# Include configuration of dependent packages
if (NOT TARGET Kokkos::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../Kokkos/KokkosConfig.cmake")
endif()
if (NOT TARGET TrilinosSS::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../TrilinosSS/TrilinosSSConfig.cmake")
endif()
if (NOT TARGET LAPACK::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../../external_packages/LAPACK/LAPACKConfig.cmake")
endif()
if (NOT TARGET BLAS::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../../external_packages/BLAS/BLASConfig.cmake")
endif()

# Import ShyLU_NodeTacho targets
include("${CMAKE_CURRENT_LIST_DIR}/ShyLU_NodeTachoTargets.cmake")

# Standard TriBITS-compliant external package variables
set(ShyLU_NodeTacho_IS_TRIBITS_COMPLIANT TRUE)
set(ShyLU_NodeTacho_TRIBITS_COMPLIANT_PACKAGE_CONFIG_FILE "${CMAKE_CURRENT_LIST_FILE}")
set(ShyLU_NodeTacho_TRIBITS_COMPLIANT_PACKAGE_CONFIG_FILE_DIR "${CMAKE_CURRENT_LIST_DIR}")


## ----------------------------------------------------------------------------
## Create deprecated non-namespaced library targets for backwards compatibility
## ----------------------------------------------------------------------------

set(ShyLU_NodeTacho_EXPORTED_PACKAGE_LIBS_NAMES "tacho")

foreach(libname IN LISTS ShyLU_NodeTacho_EXPORTED_PACKAGE_LIBS_NAMES)
  if (NOT TARGET ${libname})
    add_library(${libname} INTERFACE IMPORTED)
    target_link_libraries(${libname}
       INTERFACE ShyLU_NodeTacho::${libname})
    set(deprecationMessage
      "WARNING: The non-namespaced target '${libname}' is deprecated!"
      "  If always using newer versions of the project 'Trilinos', then use the"
      " new namespaced target 'ShyLU_NodeTacho::${libname}', or better yet,"
      " 'ShyLU_NodeTacho::all_libs' to be less sensitive to changes in the definition"
      " of targets in the package 'ShyLU_NodeTacho'.  Or, to maintain compatibility with"
      " older or newer versions the project 'Trilinos', instead link against the"
      " libraries specified by the variable 'ShyLU_NodeTacho_LIBRARIES'."
      )
    string(REPLACE ";" "" deprecationMessage "${deprecationMessage}")
    set_target_properties(${libname}
      PROPERTIES DEPRECATION "${deprecationMessage}" )
  endif()
endforeach()
