from _typeshed import Incomplete
from collections.abc import Generator
from typing import Final, NamedTuple

DIFF_NS: Final[str]
DIFF_PREFIX: Final[str]
INSERT_NAME: Final[Incomplete]
DELETE_NAME: Final[Incomplete]
REPLACE_NAME: Final[Incomplete]
RENAME_NAME: Final[Incomplete]
WS_BOTH: Final[int]
WS_TEXT: Final[int]
WS_TAGS: Final[int]
WS_NONE: Final[int]
T_OPEN: Final[int]
T_CLOSE: Final[int]
T_SINGLE: Final[int]
PLACEHOLDER_START: Final[int]

class BaseFormatter:
    def __init__(self, normalize=1, pretty_print: bool = False) -> None: ...
    def prepare(self, left_tree, right_tree) -> None: ...
    def format(self, diff, orig_tree) -> None: ...

class PlaceholderEntry(NamedTuple):
    element: Incomplete
    ttype: Incomplete
    close_ph: Incomplete

class PlaceholderMaker:
    text_tags: Incomplete
    formatting_tags: Incomplete
    placeholder2tag: Incomplete
    tag2placeholder: Incomplete
    placeholder: Incomplete
    diff_tags: Incomplete
    def __init__(self, text_tags=(), formatting_tags=()) -> None: ...
    def get_placeholder(self, element, ttype, close_ph): ...
    def is_placeholder(self, char): ...
    def is_formatting(self, element): ...
    def do_element(self, element) -> None: ...
    def do_tree(self, tree) -> None: ...
    def split_string(self, text): ...
    def undo_string(self, text): ...
    def undo_element(self, elem) -> None: ...
    def undo_tree(self, tree) -> None: ...
    def mark_diff(self, ph, action, attributes=None): ...
    def wrap_diff(self, text, action, attributes=None): ...

class XMLFormatter(BaseFormatter):
    normalize: Incomplete
    pretty_print: Incomplete
    text_tags: Incomplete
    formatting_tags: Incomplete
    use_replace: Incomplete
    placeholderer: Incomplete
    def __init__(
        self, normalize=0, pretty_print: bool = True, text_tags=(), formatting_tags=(), use_replace: bool = False
    ) -> None: ...
    def prepare(self, left_tree, right_tree) -> None: ...
    def finalize(self, result_tree) -> None: ...
    def format(self, diff, orig_tree, differ=None): ...
    def render(self, result): ...
    def handle_action(self, action, result) -> None: ...

class DiffFormatter(BaseFormatter):
    normalize: Incomplete
    def __init__(self, normalize=1, pretty_print: bool = False) -> None: ...
    def prepare(self, left, right) -> None: ...
    def finalize(self, left, right) -> None: ...
    def format(self, diff, orig_tree): ...
    def handle_action(self, action): ...

class XmlDiffFormatter(BaseFormatter):
    normalize: Incomplete
    def __init__(self, normalize=1, pretty_print: bool = False) -> None: ...
    def prepare(self, left, right) -> None: ...
    def finalize(self, left, right) -> None: ...
    def format(self, diff, orig_tree): ...
    def handle_action(self, action, orig_tree) -> Generator[Incomplete, Incomplete]: ...
