-- mod-version:3
local syntax = require "core.syntax"

syntax.add {
  name = "Blade",
  files = { "%.b$" },
  comment = "#",
  patterns = {
    { pattern = "#.*",                      type = "comment"  },
    { pattern = { "/%*", "%*/" },           type = "comment"  },
    { pattern = { '"', '"', '\\' },         type = "string"   },
    { pattern = { "'", "'", '\\' },         type = "string"   },
    { pattern = "%d+%.%d+",                 type = "number"   },
    { pattern = "0x%x+",                    type = "number"   },
    { pattern = "0c[0-8]+",                 type = "number"   },
    { pattern = "0c[01]+",                  type = "number"   },
    { pattern = "%d+",                      type = "number"   },
    { pattern = "[%+%-=/%*%^%%<>!~|&]",     type = "operator" },
    { pattern = "[%a_][%w_]*%f[(]",         type = "function" },
    { pattern = "%a[%w_]+",                 type = "symbol"   },
  },
  -- https://bladelang.com/tutorial/reserved.html#reserved-words
  symbols = {
    ["and"]       = "keyword",
    ["continue"]  = "keyword",
    ["else"]      = "keyword",
    ["in"]        = "keyword",
    ["self"]      = "keyword2",
    ["when"]      = "keyword",
    ["as"]        = "keyword",
    ["def"]       = "keyword",
    ["iter"]      = "keyword",
    ["static"]    = "keyword",
    ["while"]     = "keyword",
    ["assert"]    = "keyword",
    ["default"]   = "keyword",
    ["finally"]   = "keyword",
    ["break"]     = "keyword",
    ["die"]       = "keyword",
    ["for"]       = "keyword",
    ["or"]        = "keyword",
    ["try"]       = "keyword",
    ["catch"]     = "keyword",
    ["do"]        = "keyword",
    ["if"]        = "keyword",
    ["parent"]    = "keyword",
    ["using"]     = "keyword",
    ["class"]     = "keyword",
    ["echo"]      = "function",
    ["import"]    = "keyword",
    ["return"]    = "keyword",
    ["var"]       = "keyword",
    ["true"]      = "literal",
    ["false"]     = "literal",
    ["nil"]       = "literal",
  },
}
