-- mod-version:3
local syntax = require "core.syntax"

-- Copied from https://github.com/shanoor/vscode-nginx/blob/master/syntaxes/nginx.tmLanguage

syntax.add {
  name = "Nginx",
  files = {
    PATHSEP .. "nginx%.conf$",
    PATHSEP .. "nginx" .. PATHSEP .. ".*%.conf$"
  },
  comment = "#",
  patterns = {
    { pattern = "#.*",             type = "comment"  },
    { pattern = { '"', '"', },     type = "string"   },
    { pattern = { "'", "'", },     type = "string"   },
    { pattern = "[0-9]",           type = "number"   },
    { pattern = "[%a_][%w_]*",     type = "symbol"   },
    { pattern = "%$[%w_]+",        type = "keyword2" }
  },
  symbols = {
    -- constant.language.module.events
    ["events"]    = "keyword",

    -- constant.language.module.http
    ["http"]      = "keyword",

    -- constant.language.directive.module.main
    ["daemon"] = "keyword",
    ["env"] = "keyword",
    ["debug_points"] = "keyword",
    ["error_log"] = "keyword",
    ["log_not_found"] = "keyword",
    ["include"] = "keyword",
    ["lock_file"] = "keyword",
    ["master_process"] = "keyword",
    ["pid"] = "keyword",
    ["ssl_engine"] = "keyword",
    ["timer_resolution"] = "keyword",
    ["types_hash_max_size"] = "keyword",
    ["user"] = "keyword",
    ["worker_cpu_affinity"] = "keyword",
    ["worker_priority"] = "keyword",
    ["worker_processes"] = "keyword",
    ["worker_rlimit_core"] = "keyword",
    ["worker_rlimit_nofile"] = "keyword",
    ["worker_rlimit_sigpending"] = "keyword",
    ["working_directory"] = "keyword",
    ["try_files"] = "keyword",

    -- constant.language.directive.module.events
    ["accept_mutex"] = "keyword",
    ["accept_mutex_delay"] = "keyword",
    ["debug_connection"] = "keyword",
    ["devpoll_changes"] = "keyword",
    ["devpoll_events"] = "keyword",
    ["epoll_events"] = "keyword",
    ["kqueue_changes"] = "keyword",
    ["kqueue_events"] = "keyword",
    ["multi_accept"] = "keyword",
    ["rtsig_signo"] = "keyword",
    ["rtsig_overflow_events"] = "keyword",
    ["rtsig_overflow_test"] = "keyword",
    ["rtsig_overflow_threshold"] = "keyword",
    ["use"] = "keyword",
    ["worker_connections"] = "keyword",

    -- constant.language.directive.module.http
    ["alias"] = "keyword",
    ["chunked_transfer_encoding"] = "keyword",
    ["client_body_in_file_only"] = "keyword",
    ["client_body_buffer_size"] = "keyword",
    ["client_body_temp_path"] = "keyword",
    ["client_body_timeout"] = "keyword",
    ["client_header_buffer_size"] = "keyword",
    ["client_header_timeout"] = "keyword",
    ["client_max_body_size"] = "keyword",
    ["default_type"] = "keyword",
    ["error_page"] = "keyword",
    ["index"] = "keyword",
    ["internal"] = "keyword",
    ["keepalive_timeout"] = "keyword",
    ["keepalive_requests"] = "keyword",
    ["large_client_header_buffers"] = "keyword",
    ["limit_except"] = "keyword",
    ["limit_rate"] = "keyword",
    ["listen"] = "keyword",
    ["location"] = "keyword",
    ["msie_padding"] = "keyword",
    ["msie_refresh"] = "keyword",
    ["optimize_server_names"] = "keyword",
    ["port_in_redirect"] = "keyword",
    ["recursive_error_pages"] = "keyword",
    ["reset_timedout_connection"] = "keyword",
    ["resolver"] = "keyword",
    ["resolver_timeout"] = "keyword",
    ["root"] = "keyword",
    ["satisfy_any"] = "keyword",
    ["send_timeout"] = "keyword",
    ["sendfile"] = "keyword",
    ["server"] = "keyword",
    ["server_name"] = "keyword",
    ["server_names_hash_max_size"] = "keyword",
    ["server_names_hash_bucket_size"] = "keyword",
    ["tcp_nodelay"] = "keyword",
    ["tcp_nopush"] = "keyword",
    ["types"] = "keyword",
    ["try_files"] = "keyword",

    -- constant.language.module.http.addition
    ["add_before_body"] = "keyword",
    ["add_after_body"] = "keyword",
    ["addition_types"] = "keyword",

    -- constant.language.module.http.access
    ["allow"] = "keyword",
    ["deny"] = "keyword",

    -- constant.language.module.http.auth_basic
    ["auth_basic"] = "keyword",
    ["auth_basic_user_file"] = "keyword",

    -- constant.language.module.http.auth_jwt
    ["auth_jwt"] = "keyword",
    ["auth_jwt_header_set"] = "keyword",
    ["auth_jwt_claim_set"] = "keyword",
    ["auth_jwt_key_file"] = "keyword",

    -- constant.language.module.http.autoindex
    ["autoindex"] = "keyword",
    ["autoindex_exact_size"] = "keyword",
    ["autoindex_format"] = "keyword",
    ["autoindex_localtime"] = "keyword",

    -- constant.language.module.http.browser
    ["ancient_browser"] = "keyword",
    ["ancient_browser_value"] = "keyword",
    ["modern_browser"] = "keyword",
    ["modern_browser_value"] = "keyword",

    -- constant.language.module.http.charset
    ["charset"] = "keyword",
    ["charset_map"] = "keyword",
    ["override_charset"] = "keyword",
    ["source_charset"] = "keyword",

    -- constant.language.module.http.empty_gif
    ["empty_gif"] = "keyword",

    -- constant.language.module.http.fastcgi
    ["fastcgi_index"] = "keyword",
    ["fastcgi_hide_header"] = "keyword",
    ["fastcgi_ignore_client_abort"] = "keyword",
    ["fastcgi_intercept_errors"] = "keyword",
    ["fastcgi_param"] = "keyword",
    ["fastcgi_pass"] = "keyword",
    ["fastcgi_pass_header"] = "keyword",
    ["fastcgi_read_timeout"] = "keyword",
    ["fastcgi_redirect_errors"] = "keyword",
    ["fa"] = "keyword",
    ["stcgi_storefastcgi_store_access"] = "keyword",
    ["fastcgi_buffers"] = "keyword",
    ["fastcgi_buffers_size"] = "keyword",
    ["fastcgi_temp_path"] = "keyword",
    ["fastcgi_buffer_size"] = "keyword",
    ["fastcgi_connect_timeout"] = "keyword",
    ["fastcgi_send_timeout"] = "keyword",
    ["fastcgi_split_path_info"] = "keyword",

    -- constant.language.module.http.geo
    ["geo"] = "keyword",

    -- constant.language.module.http.gzip
    ["gzip"] = "keyword",
    ["gzip_buffers"] = "keyword",
    ["gzip_comp_level"] = "keyword",
    ["gzip_disable"] = "keyword",
    ["gzip_http.version"] = "keyword",
    ["gzip_min_length"] = "keyword",
    ["gzip_proxied"] = "keyword",
    ["gzip_types"] = "keyword",
    ["gzip_vary"] = "keyword",
    ["gzip_static"] = "keyword",

    -- constant.language.module.http.headers
    ["add_header"] = "keyword",
    ["expires"] = "keyword",
    ["server_tokens"] = "keyword",

    -- constant.language.module.http.referer
    ["valid_referers"] = "keyword",

    -- constant.language.module.http.limit_zone
    ["limit_zone"] = "keyword",
    ["limit_conn"] = "keyword",

    -- constant.language.module.http.limit_req
    ["limit_req"] = "keyword",
    ["limit_req_log_level"] = "keyword",
    ["limit_req_status"] = "keyword",
    ["limit_req_zone"] = "keyword",

    -- constant.language.module.http.log
    ["access_log"] = "keyword",
    ["log_format"] = "keyword",

    -- constant.language.module.http.map
    ["map"] = "keyword",
    ["map_hash_max_size"] = "keyword",
    ["map_hash_bucket_size"] = "keyword",

    -- constant.language.module.http.memcached
    ["memcached_pass"] = "keyword",
    ["memcached_connect_timeout"] = "keyword",
    ["memcached_send_timeout"] = "keyword",
    ["memcached_read_timeout"] = "keyword",
    ["memcached_buffer_size"] = "keyword",
    ["memcached_next_upstream"] = "keyword",

    -- constant.language.module.http.proxy
    ["proxy_buffer_size"] = "keyword2",
    ["proxy_buffering"] = "keyword2",
    ["proxy_buffers"] = "keyword2",
    ["proxy_busy_buffers_size"] = "keyword2",
    ["proxy_cache"] = "keyword2",
    ["proxy_cache_background_update"] = "keyword2",
    ["proxy_cache_bypass"] = "keyword2",
    ["proxy_cache_convert_head"] = "keyword2",
    ["proxy_cache_key"] = "keyword2",
    ["proxy_cache_lock"] = "keyword2",
    ["proxy_cache_lock_age"] = "keyword2",
    ["proxy_cache_lock_timeout"] = "keyword2",
    ["proxy_cache_max_range_offset"] = "keyword2",
    ["proxy_cache_methods"] = "keyword2",
    ["proxy_cache_min_uses"] = "keyword2",
    ["proxy_cache_path"] = "keyword2",
    ["proxy_cache_purge"] = "keyword2",
    ["proxy_cache_revalidate"] = "keyword2",
    ["proxy_cache_use_stale"] = "keyword2",
    ["proxy_cache_valid"] = "keyword2",
    ["proxy_connect_timeout"] = "keyword2",
    ["proxy_headers_hash_bucket_size"] = "keyword2",
    ["proxy_headers_hash_max_size"] = "keyword2",
    ["proxy_hide_header"] = "keyword2",
    ["proxy_http_version"] = "keyword2",
    ["proxy_ignore_client_abort"] = "keyword2",
    ["proxy_intercept_errors"] = "keyword2",
    ["proxy_max_temp_file_size"] = "keyword2",
    ["proxy_method"] = "keyword2",
    ["proxy_next_upstream"] = "keyword2",
    ["proxy_next_upstream_tries"] = "keyword2",
    ["proxy_next_upstream_timeout"] = "keyword2",
    ["proxy_pass"] = "keyword2",
    ["proxy_pass_header"] = "keyword2",
    ["proxy_pass_request_body"] = "keyword2",
    ["proxy_pass_request_headers"] = "keyword2",
    ["proxy_read_timeout"] = "keyword2",
    ["proxy_redirect"] = "keyword2",
    ["proxy_redirect_errors"] = "keyword2",
    ["proxy_send_lowat"] = "keyword2",
    ["proxy_send_timeout"] = "keyword2",
    ["proxy_set_body"] = "keyword2",
    ["proxy_set_header"] = "keyword2",
    ["proxy_store"] = "keyword2",
    ["proxy_store_access"] = "keyword2",
    ["proxy_temp_file_write_size"] = "keyword2",
    ["proxy_temp_path"] = "keyword2",
    ["proxy_upstream_fail_timeout"] = "keyword2",
    ["proxy_upstream_max_fails"] = "keyword2",
    ["proxy_no_cache"] = "keyword2",

    -- constant.language.module.http.realip
    ["set_real_ip_from"] = "keyword",
    ["real_ip_header"] = "keyword",
    ["real_ip_recursive"] = "keyword",

    -- constant.language.module.http.rewrite
    ["break"] = "keyword",
    ["if"] = "keyword",
    ["return"] = "keyword",
    ["rewrite"] = "keyword",
    ["set"] = "keyword",
    ["uninitialized_variable_warn"] = "keyword",

    -- constant.language.module.http.ssi
    ["ssi"] = "keyword",
    ["ssi_silent_errors"] = "keyword",
    ["ssi_types"] = "keyword",
    ["ssi_value_length"] = "keyword",

    -- constant.language.module.http.upstream
    ["ip_hash"] = "keyword",
    ["upstream"] = "keyword",
    ["server"] = "keyword",

    -- constant.language.module.http.userid
    ["userid"] = "keyword",
    ["userid_domain"] = "keyword",
    ["userid_expires"] = "keyword",
    ["userid_name"] = "keyword",
    ["userid_p3p"] = "keyword",
    ["userid_path"] = "keyword",
    ["userid_service"] = "keyword",

    -- constant.language.module.http.uwsgi
    ["uwsgi_bind"] = "keyword",
    ["uwsgi_buffer_size"] = "keyword",
    ["uwsgi_buffering"] = "keyword",
    ["uwsgi_buffers"] = "keyword",
    ["uwsgi_busy_buffers_size"] = "keyword",
    ["uwsgi_cache"] = "keyword",
    ["uwsgi_cache_background_update"] = "keyword",
    ["uwsgi_cache_bypass"] = "keyword",
    ["uwsgi_cache_key"] = "keyword",
    ["uwsgi_cache_lock"] = "keyword",
    ["uwsgi_cache_lock_age"] = "keyword",
    ["uwsgi_cache_lock_timeout"] = "keyword",
    ["uwsgi_cache_max_range_offset"] = "keyword",
    ["uwsgi_cache_methods"] = "keyword",
    ["uwsgi_cache_min_uses"] = "keyword",
    ["uwsgi_cache_path"] = "keyword",
    ["uwsgi_cache_purge"] = "keyword",
    ["uwsgi_cache_revalidate"] = "keyword",
    ["uwsgi_cache_use_stale"] = "keyword",
    ["uwsgi_cache_valid"] = "keyword",
    ["uwsgi_connect_timeout"] = "keyword",
    ["uwsgi_force_ranges"] = "keyword",
    ["uwsgi_hide_header"] = "keyword",
    ["uwsgi_ignore_client_abort"] = "keyword",
    ["uwsgi_ignore_headers"] = "keyword",
    ["uwsgi_intercept_errors"] = "keyword",
    ["uwsgi_limit_rate"] = "keyword",
    ["uwsgi_max_temp_file_size"] = "keyword",
    ["uwsgi_modifier1"] = "keyword",
    ["uwsgi_modifier2"] = "keyword",
    ["uwsgi_next_upstream"] = "keyword",
    ["uwsgi_next_upstream_timeout"] = "keyword",
    ["uwsgi_next_upstream_tries"] = "keyword",
    ["uwsgi_no_cache"] = "keyword",
    ["uwsgi_param"] = "keyword",
    ["uwsgi_pass"] = "keyword",
    ["uwsgi_pass_header"] = "keyword",
    ["uwsgi_pass_request_body"] = "keyword",
    ["uwsgi_pass_request_headers"] = "keyword",
    ["uwsgi_read_timeout"] = "keyword",
    ["uwsgi_request_buffering"] = "keyword",
    ["uwsgi_send_timeout"] = "keyword",
    ["uwsgi_ssl_certificate"] = "keyword",
    ["uwsgi_ssl_certificate_key"] = "keyword",
    ["uwsgi_ssl_ciphers"] = "keyword",
    ["uwsgi_ssl_crl"] = "keyword",
    ["uwsgi_ssl_name"] = "keyword",
    ["uwsgi_ssl_password_file"] = "keyword",
    ["uwsgi_ssl_protocols"] = "keyword",
    ["uwsgi_ssl_server_name"] = "keyword",
    ["uwsgi_ssl_session_reuse"] = "keyword",
    ["uwsgi_ssl_trusted_certificate"] = "keyword",
    ["uwsgi_ssl_verify"] = "keyword",
    ["uwsgi_ssl_verify_depth"] = "keyword",
    ["uwsgi_store"] = "keyword",
    ["uwsgi_store_access"] = "keyword",
    ["uwsgi_temp_file_write_size"] = "keyword",
    ["uwsgi_temp_path"] = "keyword",

    -- constant.language.directive.module.http
    ["ssl"] = "keyword",
    ["ssl_buffer_size"] = "keyword",
    ["ssl_certificate"] = "keyword",
    ["ssl_certificate_key"] = "keyword",
    ["ssl_ciphers"] = "keyword",
    ["ssl_client_certificate"] = "keyword",
    ["ssl_crl"] = "keyword",
    ["ssl_dhparam"] = "keyword",
    ["ssl_ecdh_curve"] = "keyword",
    ["ssl_password_file"] = "keyword",
    ["ssl_prefer_server_ciphers"] = "keyword",
    ["ssl_protocols"] = "keyword",
    ["ssl_session_cache"] = "keyword",
    ["ssl_session_ticket_key"] = "keyword",
    ["ssl_session_tickets"] = "keyword",
    ["ssl_session_timeout"] = "keyword",
    ["ssl_stapling"] = "keyword",
    ["ssl_stapling_file"] = "keyword",
    ["ssl_stapling_responder"] = "keyword",
    ["ssl_stapling_verify"] = "keyword",
    ["ssl_trusted_certificate"] = "keyword",
    ["ssl_verify_client"] = "keyword",
    ["ssl_verify_depth"] = "keyword",

    ["true"]     = "literal",
    ["false"]    = "literal",
    ["on"]       = "literal",
    ["off"]      = "literal",
    ["all"]      = "literal",
    ["null"]     = "literal"
  },
}
