-- mod-version:3
local syntax = require "core.syntax"

syntax.add {
  name = "Hare",
  files = { "%.ha$" },
  comment = "//",
  patterns = {
    { pattern = "//.*",               type = "comment"  },
    -- { pattern = { "/%*", "%*/" },       type = "comment"  },
    { pattern = { '"', '"', '\\' },     type = "string"   },
    { pattern = { "'", "'", '\\' },     type = "string"   },
    { pattern = "-?0x%x+",              type = "number"   },
    { pattern = "-?%d+[%d%.eE]*f?",     type = "number"   },
    { pattern = "-?%.?%d+f?",           type = "number"   },
    { pattern = "[%+%-=/%*%^%%<>!~|&]", type = "operator" },
    { pattern = "[%a_][%w_]*%f[(]",     type = "function" },
    { pattern = "[%a_][%w_]*",          type = "symbol"   },
    { pattern = "^@",                   type = "keyword"  },
  },
  symbols = {
    ["export"]   = "keyword",
    ["fn"]       = "keyword",
    ["use"]      = "keyword",
    ["const"]    = "keyword",
    ["let"]      = "keyword",
    ["defer"]    = "keyword",
    ["static"]   = "keyword",
    ["yield"]    = "keyword",
    ["case"]     = "keyword",
    ["match"]    = "keyword",
    ["return"]   = "keyword",
    ["switch"]   = "keyword",
    ["for"]      = "keyword",
    ["if"]       = "keyword",
    ["type"]     = "keyword",
    ["abort"]    = "keyword",
    ["align"]    = "keyword",
    ["alloc"]    = "keyword",
    ["break"]    = "keyword",
    ["continue"] = "keyword",
    ["def"]      = "keyword",
    ["delete"]   = "keyword",
    ["else"]     = "keyword",
    ["free"]     = "keyword",
    ["insert"]   = "keyword",
    ["is"]       = "keyword",
    ["len"]      = "keyword",
    ["offset"]   = "keyword",
    ["vaarg"]    = "keyword",
    ["vaend"]    = "keyword",
    ["vastart"]  = "keyword",
    ["fini"]     = "keyword",
    ["init"]     = "keyword",
    ["test"]     = "keyword",

    ["nullable"] = "keyword2",
    ["str"]      = "keyword2",
    ["void"]     = "keyword2",
    ["int"]      = "keyword2",
    ["uint"]     = "keyword2",
    ["struct"]   = "keyword2",
    ["union"]    = "keyword2",
    ["enum"]     = "keyword2",
    ["u8"]       = "keyword2",
    ["u16"]      = "keyword2",
    ["u32"]      = "keyword2",
    ["u64"]      = "keyword2",
    ["i8"]       = "keyword2",
    ["i16"]      = "keyword2",
    ["i32"]      = "keyword2",
    ["i64"]      = "keyword2",
    ["f32"]      = "keyword2",
    ["f64"]      = "keyword2",
    ["size"]     = "keyword2",
    ["rune"]     = "keyword2",
    ["bool"]     = "keyword2",
    ["valist"]   = "keyword2",
    ["uintptr"]  = "keyword2",
    ["rconst"]   = "keyword2",
    ["fconst"]   = "keyword2",
    ["iconst"]   = "keyword2",
    
    ["fmt"]      = "literal",
    ["true"]     = "literal",
    ["false"]    = "literal",
    ["signed"]   = "literal",
    ["unsigned"] = "literal",
    ["null"]     = "literal",
  },
}
