%feature("docstring") OT::WeibullMin
"WeibullMin distribution.

Its cumulative and probability density functions are defined as:

.. math::
    :nowrap:

    \\begin{eqnarray*}
        F_X(x) & = & 1-\\exp \\left(-\\left(\\frac{x - \\gamma}{\\beta}\\right)^{\\alpha}\\right), \\quad x \\in [\\gamma; +\\infty) \\\\
        f_X(x) & = & \\frac{\\alpha}{\\beta}\\left(\\frac{x - \\gamma}{\\beta} \\right) ^ {\\alpha-1} \\exp \\left(-\\left(\\frac{x - \\gamma}{\\beta}\\right)^{\\alpha}\\right), \\quad x \\in [\\gamma; +\\infty)
    \\end{eqnarray*}

with :math:`\\beta > 0` and :math:`\\alpha > 0`.

Its first moments are:

.. math::
    :nowrap:

    \\begin{eqnarray*}
        \\Expect{X} & = &  \\gamma + \\beta \\,\\Gamma\\left(1 + \\frac{1}{\\alpha}\\right) \\\\
        \\Var{X} & = & \\beta^2 \\left( \\Gamma \\left( 1 + \\frac{2}{\\alpha} \\right) -  \\Gamma^2 \\left( 1 + \\frac{1}{\\alpha} \\right) \\right)
    \\end{eqnarray*}

where :math:`\\Gamma` denotes Euler's Gamma function
:meth:`~openturns.SpecFunc.Gamma`.

Parameters
----------
beta : float
    scale parameter :math:`\\beta > 0`.

    Default value is 1.0.
alpha : float
    shape parameter :math:`\\alpha > 0`.

    Default value is 1.0.
gamma : float, optional
    Location parameter.

    Default value is 0.0.

Notes
-----
It is possible to create a WeibullMin distribution from the alternative parametrization :math:`(\\mu, \\sigma, \\gamma)`: see  :class:`~openturns.WeibullMinMuSigma`.
In that case, all the results are presented in that new parametrization.

In order to use the alternative parametrization :math:`(\\mu, \\sigma, \\gamma)` only to create the distribution,
see the example below: all the results will be presented in the native parametrization :math:`(\\beta, \\alpha, \\gamma)`.

Note that if :math:`X` follows a WeibullMin :math:`(\\beta, \\alpha, \\gamma)` distribution,
then :math:`(-X)` follows a WeibullMax :math:`(\\beta, \\alpha, -\\gamma)` distribution.

See also
--------
WeibullMax

Examples
--------
Create a distribution from its native parameters :math:`(\\beta, \\alpha, \\gamma)`:

>>> import openturns as ot
>>> myDist = ot.WeibullMin(2.0, 1.5, 1.0)

Create it from the alternative parametrization :math:`(\\mu, \\sigma, \\gamma)`:

>>> myDist2 = ot.WeibullMin()
>>> myDist2.setParameter(ot.WeibullMinMuSigma()([2.8, 1.2, 1.0]))

Create it from :math:`(\\mu, \\sigma, \\gamma)` and keep that parametrization for the remaining study: 

>>> myParam = ot.WeibullMinMuSigma(2.8, 1.2, 1.0)
>>> myDist3 = ot.ParametrizedDistribution(myParam)

Draw a sample:

>>> sample = myDist.getSample(5)"

// ---------------------------------------------------------------------

%feature("docstring") OT::WeibullMin::getAlpha
"Accessor to the distribution shape parameter :math:`\\alpha`.

Returns
-------
alpha : float
    Shape parameter :math:`\\alpha`."

// ---------------------------------------------------------------------

%feature("docstring") OT::WeibullMin::getBeta
"Accessor to the distribution scale parameter :math:`\\beta`.

Returns
-------
beta : float
    Scale parameter :math:`\\beta`."

// ---------------------------------------------------------------------

%feature("docstring") OT::WeibullMin::getGamma
"Accessor to the distribution location parameter :math:`\\gamma`.

Returns
-------
gamma : float
    Location parameter :math:`\\gamma`."

// ---------------------------------------------------------------------

%feature("docstring") OT::WeibullMin::setAlpha
"Accessor to the distribution shape parameter :math:`\\alpha`.

Parameters
----------
alpha : float, :math:`\\alpha > 0`
    Shape parameter :math:`\\alpha`."

// ---------------------------------------------------------------------

%feature("docstring") OT::WeibullMin::setBeta
"Accessor to the distribution scale parameter :math:`\\beta`.

Parameters
----------
beta : float, :math:`\\beta > 0`
    Scale parameter :math:`\\beta`."

// ---------------------------------------------------------------------

%feature("docstring") OT::WeibullMin::setGamma
"Accessor to the distribution location parameter :math:`\\gamma`.

Parameters
----------
gamma : float
    Location parameter :math:`\\gamma`."
