%define OT_SpaceFillingPhiP_doc
"Space filling PhiP.

Parameters
----------
p : int (default=50)
    Parameter for parametrizing the criterion

Notes
-----
Computes the criterion:

.. math::
    :nowrap:

    \\begin{equation*}
      \\phi_p(X) = \\sum_{i=1}^{j} \\sum_{j=1}^{n} \\left( |x^{(i)} - x^{(j)}|^{-p} \\right)^{\\frac{1}{p}}
    \\end{equation*}

This criterion is known to converge to mindist (minimal distance between two distinct elements of the design) criterion when p tends to infinity.
"

%enddef
%feature("docstring") OT::SpaceFillingPhiP
OT_SpaceFillingPhiP_doc
// ---------------------------------------------------------------------
%define OT_SpaceFillingPhiP_evaluate_doc
"Compute the PhiP criterion for a specific design.

Parameters
----------
design : :class:`~openturns.Sample` or 2d array like
    The design

Returns
-------
crit : float
    The phiP criterion

Examples
--------
>>> import openturns as ot
>>> # Build an LHS using openturns class
>>> lhs = ot.LHSExperiment(ot.Uniform(), 100)
>>> design = lhs.generate()
>>> # Compute the PhiP criterion
>>> crit = ot.SpaceFillingPhiP(50).evaluate(design)"
%enddef
%feature("docstring") OT::SpaceFillingPhiP::evaluate
OT_SpaceFillingPhiP_evaluate_doc
// ---------------------------------------------------------------------
