%define OT_Domain_doc
"Base class for domain objects.

Notes
-----
A Domain object can be created through its derived classes:

- :class:`~openturns.Interval`

- :class:`~openturns.MeshDomain`

- :class:`~openturns.LevelSet`

- :class:`~openturns.DomainUnion`

- :class:`~openturns.DomainDisjunctiveUnion`

- :class:`~openturns.DomainIntersection`

- :class:`~openturns.DomainComplement`

- :class:`~openturns.DomainDifference`"

%enddef
%feature("docstring") OT::DomainImplementation
OT_Domain_doc

// ---------------------------------------------------------------------

%define OT_Domain_contains_doc
"Check if the given point is inside of the domain.

Parameters
----------
point or sample : sequence of float or 2-d sequence of float
    Point or Sample with the same dimension as the current domain's dimension.

Returns
-------
isInside : bool or sequence of bool
    Flag telling whether the given point is inside of the domain."
%enddef
%feature("docstring") OT::DomainImplementation::contains
OT_Domain_contains_doc

// ---------------------------------------------------------------------

%define OT_Domain_computeDistance_doc
"Compute the Euclidean distance of a given point to the domain.

Parameters
----------
point or sample : sequence of float or 2-d sequence of float
    Point or Sample with the same dimension as the current domain's dimension.

Returns
-------
distance : float or Sample
    Euclidean distance of the point to the domain."
%enddef
%feature("docstring") OT::DomainImplementation::computeDistance
OT_Domain_computeDistance_doc

// ---------------------------------------------------------------------

%define OT_Domain_getDimension_doc
"Get the dimension of the domain.

Returns
-------
dim : int
    Dimension of the domain."
%enddef
%feature("docstring") OT::DomainImplementation::getDimension
OT_Domain_getDimension_doc

// ---------------------------------------------------------------------
