
#ifndef KJOBWIDGETS_EXPORT_H
#define KJOBWIDGETS_EXPORT_H

#ifdef KJOBWIDGETS_STATIC_DEFINE
#  define KJOBWIDGETS_EXPORT
#  define KJOBWIDGETS_NO_EXPORT
#else
#  ifndef KJOBWIDGETS_EXPORT
#    ifdef KF6JobWidgets_EXPORTS
        /* We are building this library */
#      define KJOBWIDGETS_EXPORT __declspec(dllexport)
#    else
        /* We are using this library */
#      define KJOBWIDGETS_EXPORT __declspec(dllimport)
#    endif
#  endif

#  ifndef KJOBWIDGETS_NO_EXPORT
#    define KJOBWIDGETS_NO_EXPORT 
#  endif
#endif

#ifndef KJOBWIDGETS_DECL_DEPRECATED
#  define KJOBWIDGETS_DECL_DEPRECATED __declspec(deprecated)
#endif

#ifndef KJOBWIDGETS_DECL_DEPRECATED_EXPORT
#  define KJOBWIDGETS_DECL_DEPRECATED_EXPORT KJOBWIDGETS_EXPORT KJOBWIDGETS_DECL_DEPRECATED
#endif

#ifndef KJOBWIDGETS_DECL_DEPRECATED_NO_EXPORT
#  define KJOBWIDGETS_DECL_DEPRECATED_NO_EXPORT KJOBWIDGETS_NO_EXPORT KJOBWIDGETS_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KJOBWIDGETS_NO_DEPRECATED
#    define KJOBWIDGETS_NO_DEPRECATED
#  endif
#endif
#include <kjobwidgets_version.h>

#define KJOBWIDGETS_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

/* Take any defaults from group settings */
#if !defined(KJOBWIDGETS_NO_DEPRECATED) && !defined(KJOBWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KJOBWIDGETS_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KJOBWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KJOBWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KJOBWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KJOBWIDGETS_NO_DEPRECATED_WARNINGS) && !defined(KJOBWIDGETS_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KJOBWIDGETS_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KJOBWIDGETS_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KJOBWIDGETS_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KJOBWIDGETS_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KJOBWIDGETS_NO_DEPRECATED)
#  undef KJOBWIDGETS_DEPRECATED
#  define KJOBWIDGETS_DEPRECATED_EXPORT KJOBWIDGETS_EXPORT
#  define KJOBWIDGETS_DEPRECATED_NO_EXPORT KJOBWIDGETS_NO_EXPORT
#elif defined(KJOBWIDGETS_NO_DEPRECATED_WARNINGS)
#  define KJOBWIDGETS_DEPRECATED
#  define KJOBWIDGETS_DEPRECATED_EXPORT KJOBWIDGETS_EXPORT
#  define KJOBWIDGETS_DEPRECATED_NO_EXPORT KJOBWIDGETS_NO_EXPORT
#else
#  define KJOBWIDGETS_DEPRECATED KJOBWIDGETS_DECL_DEPRECATED
#  define KJOBWIDGETS_DEPRECATED_EXPORT KJOBWIDGETS_DECL_DEPRECATED_EXPORT
#  define KJOBWIDGETS_DEPRECATED_NO_EXPORT KJOBWIDGETS_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KJOBWIDGETS_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KJOBWIDGETS_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KJOBWIDGETS_NO_DEPRECATED
#  define KJOBWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT KJOBWIDGETS_VERSION
#endif
#ifdef KJOBWIDGETS_NO_DEPRECATED_WARNINGS
#  define KJOBWIDGETS_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KJOBWIDGETS_DEPRECATED_WARNINGS_SINCE
#  ifdef KJOBWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KJOBWIDGETS_DEPRECATED_WARNINGS_SINCE KJOBWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KJOBWIDGETS_DEPRECATED_WARNINGS_SINCE KJOBWIDGETS_VERSION
#  endif
#endif

#ifndef KJOBWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KJOBWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KJOBWIDGETS_DEPRECATED
#  define KJOBWIDGETS_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > KJOBWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KJOBWIDGETS_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* KJOBWIDGETS_EXPORT_H */
