/* gtksourceview-5.vapi generated by vapigen.EXE, do not modify. */

[CCode (cprefix = "GtkSource", gir_namespace = "GtkSource", gir_version = "5", lower_case_cprefix = "gtk_source_")]
namespace GtkSource {
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_buffer_get_type ()")]
	public class Buffer : Gtk.TextBuffer {
		[CCode (has_construct_function = false)]
		public Buffer (Gtk.TextTagTable? table);
		public bool backward_iter_to_source_mark (ref Gtk.TextIter iter, string? category);
		public void change_case (GtkSource.ChangeCaseType case_type, Gtk.TextIter start, Gtk.TextIter end);
		public unowned GtkSource.Mark create_source_mark (string? name, string category, Gtk.TextIter where);
		public void ensure_highlight (Gtk.TextIter start, Gtk.TextIter end);
		public bool forward_iter_to_source_mark (ref Gtk.TextIter iter, string? category);
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] get_context_classes_at_iter (Gtk.TextIter iter);
		public bool get_highlight_matching_brackets ();
		public bool get_highlight_syntax ();
		public bool get_implicit_trailing_newline ();
		public unowned GtkSource.Language? get_language ();
		public bool get_loading ();
		public GLib.SList<weak GtkSource.Mark> get_source_marks_at_iter (Gtk.TextIter iter, string? category);
		public GLib.SList<weak GtkSource.Mark> get_source_marks_at_line (int line, string? category);
		public unowned GtkSource.StyleScheme? get_style_scheme ();
		public bool iter_backward_to_context_class_toggle (ref Gtk.TextIter iter, string context_class);
		public bool iter_forward_to_context_class_toggle (ref Gtk.TextIter iter, string context_class);
		public bool iter_has_context_class (Gtk.TextIter iter, string context_class);
		public void join_lines (Gtk.TextIter start, Gtk.TextIter end);
		public void remove_source_marks (Gtk.TextIter start, Gtk.TextIter end, string? category);
		public void set_highlight_matching_brackets (bool highlight);
		public void set_highlight_syntax (bool highlight);
		public void set_implicit_trailing_newline (bool implicit_trailing_newline);
		public void set_language (GtkSource.Language? language);
		public void set_style_scheme (GtkSource.StyleScheme? scheme);
		public void sort_lines (Gtk.TextIter start, Gtk.TextIter end, GtkSource.SortFlags flags, int column);
		[CCode (has_construct_function = false)]
		public Buffer.with_language (GtkSource.Language language);
		public bool highlight_matching_brackets { get; set; }
		public bool highlight_syntax { get; set; }
		public bool implicit_trailing_newline { get; set construct; }
		public GtkSource.Language language { get; set; }
		[Version (since = "5.10")]
		public bool loading { get; }
		public GtkSource.StyleScheme style_scheme { get; set; }
		public virtual signal void bracket_matched (Gtk.TextIter? iter, GtkSource.BracketMatchType state);
		public signal void cursor_moved ();
		public signal void highlight_updated (Gtk.TextIter start, Gtk.TextIter end);
		public signal void source_mark_updated (Gtk.TextMark mark);
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_completion_get_type ()")]
	public class Completion : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Completion ();
		public void add_provider (GtkSource.CompletionProvider provider);
		public void block_interactive ();
		public static Pango.AttrList? fuzzy_highlight (string haystack, string casefold_query);
		public static bool fuzzy_match (string? haystack, string casefold_needle, out uint priority);
		public unowned GtkSource.Buffer get_buffer ();
		public uint get_page_size ();
		public unowned GtkSource.View get_view ();
		public void remove_provider (GtkSource.CompletionProvider provider);
		public void set_page_size (uint page_size);
		public void unblock_interactive ();
		public Gtk.TextView buffer { get; }
		public uint page_size { get; set; }
		[NoAccessorMethod]
		public bool remember_info_visibility { get; set; }
		[NoAccessorMethod]
		public bool select_on_show { get; set; }
		[NoAccessorMethod]
		public bool show_icons { get; set; }
		public GtkSource.View view { get; construct; }
		[HasEmitter]
		public signal void hide ();
		public signal void provider_added (GtkSource.CompletionProvider provider);
		public signal void provider_removed (GtkSource.CompletionProvider provider);
		[HasEmitter]
		public signal void show ();
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_completion_cell_get_type ()")]
	public class CompletionCell : Gtk.Widget, Gtk.Accessible, Gtk.Buildable, Gtk.ConstraintTarget {
		[CCode (has_construct_function = false)]
		protected CompletionCell ();
		public GtkSource.CompletionColumn get_column ();
		public unowned Gtk.Widget? get_widget ();
		public void set_gicon (GLib.Icon gicon);
		public void set_icon_name (string icon_name);
		public void set_markup (string markup);
		public void set_paintable (Gdk.Paintable paintable);
		public void set_text (string? text);
		public void set_text_with_attributes (string text, Pango.AttrList attrs);
		public void set_widget (Gtk.Widget child);
		public GtkSource.CompletionColumn column { get; construct; }
		[NoAccessorMethod]
		public string markup { owned get; set; }
		[NoAccessorMethod]
		public Gdk.Paintable paintable { owned get; set; }
		[NoAccessorMethod]
		public string text { owned get; set; }
		public Gtk.Widget widget { get; set; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_completion_context_get_type ()")]
	public class CompletionContext : GLib.Object, GLib.ListModel {
		[CCode (has_construct_function = false)]
		protected CompletionContext ();
		public GtkSource.CompletionActivation get_activation ();
		public bool get_bounds (out Gtk.TextIter begin, out Gtk.TextIter end);
		public unowned GtkSource.Buffer? get_buffer ();
		public bool get_busy ();
		public unowned GtkSource.Completion? get_completion ();
		public bool get_empty ();
		public unowned GtkSource.Language? get_language ();
		[Version (since = "5.6")]
		public unowned GLib.ListModel? get_proposals_for_provider (GtkSource.CompletionProvider provider);
		public unowned GtkSource.View? get_view ();
		public string get_word ();
		[Version (since = "5.6")]
		public GLib.ListModel list_providers ();
		public void set_proposals_for_provider (GtkSource.CompletionProvider provider, GLib.ListModel? results);
		public bool busy { get; }
		public GtkSource.Completion completion { get; construct; }
		public bool empty { get; }
		[Version (since = "5.6")]
		public signal void provider_model_changed (GtkSource.CompletionProvider provider, GLib.ListModel? model);
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_completion_snippets_get_type ()")]
	public class CompletionSnippets : GLib.Object, GtkSource.CompletionProvider {
		[CCode (has_construct_function = false)]
		public CompletionSnippets ();
		[NoAccessorMethod]
		public int priority { get; set construct; }
		[NoAccessorMethod]
		public string title { owned get; set construct; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_completion_words_get_type ()")]
	public class CompletionWords : GLib.Object, GtkSource.CompletionProvider {
		[CCode (has_construct_function = false)]
		public CompletionWords (string? title);
		public void register (Gtk.TextBuffer buffer);
		public void unregister (Gtk.TextBuffer buffer);
		[NoAccessorMethod]
		public uint minimum_word_size { get; set construct; }
		[NoAccessorMethod]
		public int priority { get; set construct; }
		[NoAccessorMethod]
		public uint proposals_batch_size { get; set construct; }
		[NoAccessorMethod]
		public uint scan_batch_size { get; set construct; }
		[NoAccessorMethod]
		public string title { owned get; set construct; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gtk_source_encoding_get_type ()")]
	[Compact]
	public class Encoding {
		public GtkSource.Encoding copy ();
		public void free ();
		public static GLib.SList<weak GtkSource.Encoding> get_all ();
		public unowned string get_charset ();
		public static unowned GtkSource.Encoding get_current ();
		public static GLib.SList<weak GtkSource.Encoding> get_default_candidates ();
		public static unowned GtkSource.Encoding? get_from_charset (string charset);
		public unowned string get_name ();
		public static unowned GtkSource.Encoding get_utf8 ();
		public string to_string ();
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_file_get_type ()")]
	public class File : GLib.Object {
		[CCode (has_construct_function = false)]
		public File ();
		public void check_file_on_disk ();
		public GtkSource.CompressionType get_compression_type ();
		public unowned GtkSource.Encoding get_encoding ();
		public unowned GLib.File get_location ();
		public GtkSource.NewlineType get_newline_type ();
		public bool is_deleted ();
		public bool is_externally_modified ();
		public bool is_local ();
		public bool is_readonly ();
		public void set_location (GLib.File? location);
		public GtkSource.CompressionType compression_type { get; }
		public GtkSource.Encoding encoding { get; }
		public GLib.File location { get; set construct; }
		public GtkSource.NewlineType newline_type { get; }
		[NoAccessorMethod]
		public bool read_only { get; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_file_loader_get_type ()")]
	public class FileLoader : GLib.Object {
		[CCode (has_construct_function = false)]
		public FileLoader (GtkSource.Buffer buffer, GtkSource.File file);
		[CCode (has_construct_function = false)]
		public FileLoader.from_stream (GtkSource.Buffer buffer, GtkSource.File file, GLib.InputStream stream);
		public unowned GtkSource.Buffer get_buffer ();
		public GtkSource.CompressionType get_compression_type ();
		public unowned GtkSource.Encoding get_encoding ();
		public unowned GtkSource.File get_file ();
		public unowned GLib.InputStream? get_input_stream ();
		public unowned GLib.File? get_location ();
		public GtkSource.NewlineType get_newline_type ();
		public async bool load_async (int io_priority, GLib.Cancellable? cancellable, owned GLib.FileProgressCallback? progress_callback) throws GLib.Error;
		public void set_candidate_encodings (GLib.SList<GtkSource.Encoding> candidate_encodings);
		public GtkSource.Buffer buffer { get; construct; }
		public GtkSource.File file { get; construct; }
		public GLib.InputStream input_stream { get; construct; }
		public GLib.File location { get; construct; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_file_saver_get_type ()")]
	public class FileSaver : GLib.Object {
		[CCode (has_construct_function = false)]
		public FileSaver (GtkSource.Buffer buffer, GtkSource.File file);
		public unowned GtkSource.Buffer get_buffer ();
		public GtkSource.CompressionType get_compression_type ();
		public unowned GtkSource.Encoding get_encoding ();
		public unowned GtkSource.File get_file ();
		public GtkSource.FileSaverFlags get_flags ();
		public unowned GLib.File get_location ();
		public GtkSource.NewlineType get_newline_type ();
		public async bool save_async (int io_priority, GLib.Cancellable? cancellable, owned GLib.FileProgressCallback? progress_callback) throws GLib.Error;
		public void set_compression_type (GtkSource.CompressionType compression_type);
		public void set_encoding (GtkSource.Encoding? encoding);
		public void set_flags (GtkSource.FileSaverFlags flags);
		public void set_newline_type (GtkSource.NewlineType newline_type);
		[CCode (has_construct_function = false)]
		public FileSaver.with_target (GtkSource.Buffer buffer, GtkSource.File file, GLib.File target_location);
		public GtkSource.Buffer buffer { get; construct; }
		public GtkSource.CompressionType compression_type { get; set construct; }
		public GtkSource.Encoding encoding { get; set construct; }
		public GtkSource.File file { get; construct; }
		public GtkSource.FileSaverFlags flags { get; set construct; }
		public GLib.File location { get; construct; }
		public GtkSource.NewlineType newline_type { get; set construct; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_gutter_get_type ()")]
	public class Gutter : Gtk.Widget, Gtk.Accessible, Gtk.Buildable, Gtk.ConstraintTarget {
		[CCode (has_construct_function = false)]
		protected Gutter ();
		public unowned GtkSource.View get_view ();
		public bool insert (GtkSource.GutterRenderer renderer, int position);
		public void remove (GtkSource.GutterRenderer renderer);
		public void reorder (GtkSource.GutterRenderer renderer, int position);
		public GtkSource.View view { get; construct; }
		[NoAccessorMethod]
		public Gtk.TextWindowType window_type { get; construct; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_gutter_lines_get_type ()")]
	public class GutterLines : GLib.Object {
		[CCode (has_construct_function = false)]
		protected GutterLines ();
		public void add_class (uint line, string name);
		public void add_qclass (uint line, GLib.Quark qname);
		public unowned Gtk.TextBuffer get_buffer ();
		public uint get_first ();
		public void get_iter_at_line (out Gtk.TextIter iter, uint line);
		public uint get_last ();
		public void get_line_yrange (uint line, GtkSource.GutterRendererAlignmentMode mode, out int y, out int height);
		public unowned Gtk.TextView get_view ();
		[Version (since = "5.6")]
		public bool has_any_class (uint line);
		public bool has_class (uint line, string name);
		public bool has_qclass (uint line, GLib.Quark qname);
		public bool is_cursor (uint line);
		public bool is_prelit (uint line);
		public bool is_selected (uint line);
		public void remove_class (uint line, string name);
		public void remove_qclass (uint line, GLib.Quark qname);
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_gutter_renderer_get_type ()")]
	public abstract class GutterRenderer : Gtk.Widget, Gtk.Accessible, Gtk.Buildable, Gtk.ConstraintTarget {
		[CCode (has_construct_function = false)]
		protected GutterRenderer ();
		public void align_cell (uint line, float width, float height, out float x, out float y);
		[NoWrapper]
		public virtual void begin (GtkSource.GutterLines lines);
		[NoWrapper]
		public virtual void change_buffer (GtkSource.Buffer? old_buffer);
		[NoWrapper]
		public virtual void change_view (GtkSource.View? old_view);
		[NoWrapper]
		public virtual void end ();
		public GtkSource.GutterRendererAlignmentMode get_alignment_mode ();
		public unowned GtkSource.Buffer? get_buffer ();
		public unowned GtkSource.View get_view ();
		public float get_xalign ();
		public int get_xpad ();
		public float get_yalign ();
		public int get_ypad ();
		public void set_alignment_mode (GtkSource.GutterRendererAlignmentMode mode);
		public void set_xalign (float xalign);
		public void set_xpad (int xpad);
		public void set_yalign (float yalign);
		public void set_ypad (int ypad);
		[NoWrapper]
		public virtual void snapshot_line (Gtk.Snapshot snapshot, GtkSource.GutterLines lines, uint line);
		public GtkSource.GutterRendererAlignmentMode alignment_mode { get; set; }
		[NoAccessorMethod]
		public GtkSource.GutterLines lines { owned get; }
		public Gtk.TextView view { get; }
		public float xalign { get; set; }
		public int xpad { get; set; }
		public float yalign { get; set; }
		public int ypad { get; set; }
		[HasEmitter]
		public virtual signal void activate (Gtk.TextIter iter, Gdk.Rectangle area, uint button, Gdk.ModifierType state, int n_presses);
		[HasEmitter]
		public virtual signal bool query_activatable (Gtk.TextIter iter, Gdk.Rectangle area);
		public virtual signal void query_data (GLib.Object lines, uint line);
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_gutter_renderer_pixbuf_get_type ()")]
	public class GutterRendererPixbuf : GtkSource.GutterRenderer, Gtk.Accessible, Gtk.Buildable, Gtk.ConstraintTarget {
		[CCode (has_construct_function = false, type = "GtkSourceGutterRenderer*")]
		public GutterRendererPixbuf ();
		public unowned GLib.Icon get_gicon ();
		public unowned string get_icon_name ();
		public unowned Gdk.Paintable? get_paintable ();
		public unowned Gdk.Pixbuf get_pixbuf ();
		public void overlay_paintable (Gdk.Paintable paintable);
		public void set_gicon (GLib.Icon? icon);
		public void set_icon_name (string? icon_name);
		public void set_paintable (Gdk.Paintable? paintable);
		public void set_pixbuf (Gdk.Pixbuf? pixbuf);
		public GLib.Icon gicon { get; set; }
		public string icon_name { get; set; }
		public Gdk.Paintable paintable { get; set; }
		public Gdk.Pixbuf pixbuf { get; set; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_gutter_renderer_text_get_type ()")]
	public class GutterRendererText : GtkSource.GutterRenderer, Gtk.Accessible, Gtk.Buildable, Gtk.ConstraintTarget {
		[CCode (has_construct_function = false, type = "GtkSourceGutterRenderer*")]
		public GutterRendererText ();
		public void measure (string text, out int width, out int height);
		public void measure_markup (string markup, out int width, out int height);
		public void set_markup (string markup, int length);
		public void set_text (string text, int length);
		[NoAccessorMethod]
		public string markup { owned get; set construct; }
		[NoAccessorMethod]
		public string text { owned get; set construct; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_hover_get_type ()")]
	public class Hover : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Hover ();
		public void add_provider (GtkSource.HoverProvider provider);
		public void remove_provider (GtkSource.HoverProvider provider);
		[NoAccessorMethod]
		public uint hover_delay { get; set; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_hover_context_get_type ()")]
	public class HoverContext : GLib.Object {
		[CCode (has_construct_function = false)]
		protected HoverContext ();
		public bool get_bounds (out Gtk.TextIter begin, out Gtk.TextIter end);
		public unowned GtkSource.Buffer get_buffer ();
		public bool get_iter (Gtk.TextIter iter);
		public unowned GtkSource.View get_view ();
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_hover_display_get_type ()")]
	public class HoverDisplay : Gtk.Widget, Gtk.Accessible, Gtk.Buildable, Gtk.ConstraintTarget {
		[CCode (has_construct_function = false)]
		protected HoverDisplay ();
		public void append (Gtk.Widget child);
		public void insert_after (Gtk.Widget child, Gtk.Widget sibling);
		public void prepend (Gtk.Widget child);
		public void remove (Gtk.Widget child);
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_language_get_type ()")]
	public class Language : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Language ();
		[CCode (array_length = false, array_null_terminated = true)]
		public string[]? get_globs ();
		public bool get_hidden ();
		public unowned string get_id ();
		public unowned string? get_metadata (string name);
		[CCode (array_length = false, array_null_terminated = true)]
		public string[]? get_mime_types ();
		public unowned string get_name ();
		public unowned string get_section ();
		public unowned string? get_style_fallback (string style_id);
		[CCode (array_length = false, array_null_terminated = true)]
		public string[]? get_style_ids ();
		public unowned string? get_style_name (string style_id);
		public bool hidden { get; }
		public string id { get; }
		public string name { get; }
		public string section { get; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_language_manager_get_type ()")]
	public class LanguageManager : GLib.Object {
		[CCode (has_construct_function = false)]
		public LanguageManager ();
		[Version (since = "5.4")]
		public void append_search_path (string path);
		public static unowned GtkSource.LanguageManager get_default ();
		public unowned GtkSource.Language? get_language (string id);
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[]? get_language_ids ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_search_path ();
		public unowned GtkSource.Language? guess_language (string? filename, string? content_type);
		[Version (since = "5.4")]
		public void prepend_search_path (string path);
		public void set_search_path ([CCode (array_length = false, array_null_terminated = true)] string[]? dirs);
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] language_ids { get; }
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] search_path { get; set; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_map_get_type ()")]
	public class Map : GtkSource.View, Gtk.Accessible, Gtk.AccessibleText, Gtk.Buildable, Gtk.ConstraintTarget, Gtk.Scrollable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public Map ();
		public unowned GtkSource.View? get_view ();
		public void set_view (GtkSource.View view);
		[NoAccessorMethod]
		public Pango.FontDescription font_desc { owned get; set; }
		public GtkSource.View view { get; set; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_mark_get_type ()")]
	public class Mark : Gtk.TextMark {
		[CCode (has_construct_function = false)]
		public Mark (string? name, string category);
		public unowned string get_category ();
		public unowned GtkSource.Mark? next (string? category);
		public unowned GtkSource.Mark? prev (string? category);
		public string category { get; construct; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_mark_attributes_get_type ()")]
	public class MarkAttributes : GLib.Object {
		[CCode (has_construct_function = false)]
		public MarkAttributes ();
		public bool get_background (out Gdk.RGBA background);
		public unowned GLib.Icon get_gicon ();
		public unowned string get_icon_name ();
		public unowned Gdk.Pixbuf get_pixbuf ();
		public string get_tooltip_markup (GtkSource.Mark mark);
		public string get_tooltip_text (GtkSource.Mark mark);
		public unowned Gdk.Paintable render_icon (Gtk.Widget widget, int size);
		public void set_background (Gdk.RGBA background);
		public void set_gicon (GLib.Icon gicon);
		public void set_icon_name (string icon_name);
		public void set_pixbuf (Gdk.Pixbuf pixbuf);
		[NoAccessorMethod]
		public Gdk.RGBA background { owned get; set; }
		public GLib.Icon gicon { get; set; }
		public string icon_name { get; set; }
		public Gdk.Pixbuf pixbuf { get; set; }
		public signal string query_tooltip_markup (GtkSource.Mark mark);
		public signal string query_tooltip_text (GtkSource.Mark mark);
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_print_compositor_get_type ()")]
	public class PrintCompositor : GLib.Object {
		[CCode (has_construct_function = false)]
		public PrintCompositor (GtkSource.Buffer buffer);
		public void draw_page (Gtk.PrintContext context, int page_nr);
		[CCode (has_construct_function = false)]
		public PrintCompositor.from_view (GtkSource.View view);
		public string get_body_font_name ();
		public double get_bottom_margin (Gtk.Unit unit);
		public unowned GtkSource.Buffer get_buffer ();
		public string get_footer_font_name ();
		public string get_header_font_name ();
		public bool get_highlight_syntax ();
		public double get_left_margin (Gtk.Unit unit);
		public string get_line_numbers_font_name ();
		public int get_n_pages ();
		public double get_pagination_progress ();
		public bool get_print_footer ();
		public bool get_print_header ();
		public uint get_print_line_numbers ();
		public double get_right_margin (Gtk.Unit unit);
		public uint get_tab_width ();
		public double get_top_margin (Gtk.Unit unit);
		public Gtk.WrapMode get_wrap_mode ();
		[Version (since = "5.2")]
		public void ignore_tag (Gtk.TextTag tag);
		public bool paginate (Gtk.PrintContext context);
		public void set_body_font_name (string font_name);
		public void set_bottom_margin (double margin, Gtk.Unit unit);
		public void set_footer_font_name (string? font_name);
		public void set_footer_format (bool separator, string? left, string? center, string? right);
		public void set_header_font_name (string? font_name);
		public void set_header_format (bool separator, string? left, string? center, string? right);
		public void set_highlight_syntax (bool highlight);
		public void set_left_margin (double margin, Gtk.Unit unit);
		public void set_line_numbers_font_name (string? font_name);
		public void set_print_footer (bool print);
		public void set_print_header (bool print);
		public void set_print_line_numbers (uint interval);
		public void set_right_margin (double margin, Gtk.Unit unit);
		public void set_tab_width (uint width);
		public void set_top_margin (double margin, Gtk.Unit unit);
		public void set_wrap_mode (Gtk.WrapMode wrap_mode);
		public string body_font_name { owned get; set; }
		public GtkSource.Buffer buffer { get; construct; }
		public string footer_font_name { owned get; set; }
		public string header_font_name { owned get; set; }
		public bool highlight_syntax { get; set; }
		public string line_numbers_font_name { owned get; set; }
		public int n_pages { get; }
		public bool print_footer { get; set; }
		public bool print_header { get; set; }
		public uint print_line_numbers { get; set; }
		public uint tab_width { get; set; }
		public Gtk.WrapMode wrap_mode { get; set; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_region_get_type ()")]
	public class Region : GLib.Object {
		[CCode (has_construct_function = false)]
		public Region (Gtk.TextBuffer buffer);
		public void add_region (GtkSource.Region? region_to_add);
		public void add_subregion (Gtk.TextIter _start, Gtk.TextIter _end);
		public bool get_bounds (out Gtk.TextIter start, out Gtk.TextIter end);
		public unowned Gtk.TextBuffer? get_buffer ();
		public GtkSource.RegionIter get_start_region_iter ();
		public GtkSource.Region? intersect_region (GtkSource.Region? region2);
		public GtkSource.Region? intersect_subregion (Gtk.TextIter _start, Gtk.TextIter _end);
		public bool is_empty ();
		public void subtract_region (GtkSource.Region? region_to_subtract);
		public void subtract_subregion (Gtk.TextIter _start, Gtk.TextIter _end);
		public string? to_string ();
		public Gtk.TextBuffer buffer { get; construct; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_search_context_get_type ()")]
	public class SearchContext : GLib.Object {
		[CCode (has_construct_function = false)]
		public SearchContext (GtkSource.Buffer buffer, GtkSource.SearchSettings? settings);
		public bool backward (Gtk.TextIter iter, out Gtk.TextIter match_start, out Gtk.TextIter match_end, out bool has_wrapped_around);
		public async bool backward_async (Gtk.TextIter iter, GLib.Cancellable? cancellable, out Gtk.TextIter match_start, out Gtk.TextIter match_end, out bool has_wrapped_around) throws GLib.Error;
		public bool forward (Gtk.TextIter iter, out Gtk.TextIter match_start, out Gtk.TextIter match_end, out bool has_wrapped_around);
		public async bool forward_async (Gtk.TextIter iter, GLib.Cancellable? cancellable, out Gtk.TextIter match_start, out Gtk.TextIter match_end, out bool has_wrapped_around) throws GLib.Error;
		public unowned GtkSource.Buffer get_buffer ();
		public bool get_highlight ();
		public unowned GtkSource.Style get_match_style ();
		public int get_occurrence_position (Gtk.TextIter match_start, Gtk.TextIter match_end);
		public int get_occurrences_count ();
		public GLib.Error? get_regex_error ();
		public unowned GtkSource.SearchSettings get_settings ();
		public bool replace (Gtk.TextIter match_start, Gtk.TextIter match_end, string replace, int replace_length) throws GLib.Error;
		public uint replace_all (string replace, int replace_length) throws GLib.Error;
		public void set_highlight (bool highlight);
		public void set_match_style (GtkSource.Style? match_style);
		public GtkSource.Buffer buffer { get; construct; }
		public bool highlight { get; set construct; }
		public GtkSource.Style match_style { get; set construct; }
		public int occurrences_count { get; }
		public GLib.Error regex_error { owned get; }
		public GtkSource.SearchSettings settings { get; construct; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_search_settings_get_type ()")]
	public class SearchSettings : GLib.Object {
		[CCode (has_construct_function = false)]
		public SearchSettings ();
		public bool get_at_word_boundaries ();
		public bool get_case_sensitive ();
		public bool get_regex_enabled ();
		public unowned string? get_search_text ();
		[Version (since = "5.12")]
		public bool get_visible_only ();
		public bool get_wrap_around ();
		public void set_at_word_boundaries (bool at_word_boundaries);
		public void set_case_sensitive (bool case_sensitive);
		public void set_regex_enabled (bool regex_enabled);
		public void set_search_text (string? search_text);
		[Version (since = "5.12")]
		public void set_visible_only (bool visible_only);
		public void set_wrap_around (bool wrap_around);
		public bool at_word_boundaries { get; set construct; }
		public bool case_sensitive { get; set construct; }
		public bool regex_enabled { get; set construct; }
		public string search_text { get; set construct; }
		[Version (since = "5.12")]
		public bool visible_only { get; set construct; }
		public bool wrap_around { get; set construct; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_snippet_get_type ()")]
	public class Snippet : GLib.Object {
		[CCode (has_construct_function = false)]
		public Snippet (string? trigger, string? language_id);
		public void add_chunk (GtkSource.SnippetChunk chunk);
		public GtkSource.Snippet copy ();
		public unowned GtkSource.SnippetContext? get_context ();
		public unowned string get_description ();
		public int get_focus_position ();
		public unowned string get_language_id ();
		public uint get_n_chunks ();
		public unowned string get_name ();
		public unowned GtkSource.SnippetChunk get_nth_chunk (uint nth);
		public unowned string? get_trigger ();
		[CCode (has_construct_function = false)]
		[Version (since = "5.6")]
		public Snippet.parsed (string text) throws GLib.Error;
		public void set_description (string description);
		public void set_language_id (string language_id);
		public void set_name (string name);
		public void set_trigger (string trigger);
		[NoAccessorMethod]
		public Gtk.TextBuffer buffer { owned get; }
		public string description { get; set; }
		public int focus_position { get; }
		public string language_id { get; set; }
		public string name { get; set; }
		public string trigger { get; set; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_snippet_chunk_get_type ()")]
	public class SnippetChunk : GLib.InitiallyUnowned {
		[CCode (has_construct_function = false)]
		public SnippetChunk ();
		public GtkSource.SnippetChunk copy ();
		public unowned GtkSource.SnippetContext get_context ();
		public int get_focus_position ();
		public unowned string? get_spec ();
		public unowned string get_text ();
		public bool get_text_set ();
		public unowned string get_tooltip_text ();
		public void set_context (GtkSource.SnippetContext context);
		public void set_focus_position (int focus_position);
		public void set_spec (string spec);
		public void set_text (string text);
		public void set_text_set (bool text_set);
		public void set_tooltip_text (string tooltip_text);
		public GtkSource.SnippetContext context { get; set; }
		public int focus_position { get; set; }
		public string spec { get; set; }
		public string text { get; set; }
		public bool text_set { get; set; }
		public string tooltip_text { get; set; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_snippet_context_get_type ()")]
	public class SnippetContext : GLib.Object {
		[CCode (has_construct_function = false)]
		public SnippetContext ();
		public void clear_variables ();
		public string expand (string input);
		public unowned string? get_variable (string key);
		public void set_constant (string key, string value);
		public void set_line_prefix (string line_prefix);
		public void set_tab_width (int tab_width);
		public void set_use_spaces (bool use_spaces);
		public void set_variable (string key, string value);
		public signal void changed ();
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_snippet_manager_get_type ()")]
	public class SnippetManager : GLib.Object {
		[CCode (has_construct_function = false)]
		protected SnippetManager ();
		public static unowned GtkSource.SnippetManager get_default ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_search_path ();
		public GtkSource.Snippet? get_snippet (string? group, string? language_id, string trigger);
		[Version (since = "5.6")]
		public unowned GLib.ListModel list_all ();
		[CCode (array_length = false, array_null_terminated = true)]
		public (unowned string)[] list_groups ();
		public GLib.ListModel list_matching (string? group, string? language_id, string? trigger_prefix);
		public void set_search_path ([CCode (array_length = false, array_null_terminated = true)] string[]? dirs);
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] search_path { get; set; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_space_drawer_get_type ()")]
	public class SpaceDrawer : GLib.Object {
		[CCode (has_construct_function = false)]
		public SpaceDrawer ();
		public void bind_matrix_setting (GLib.Settings settings, string key, GLib.SettingsBindFlags flags);
		public bool get_enable_matrix ();
		public GLib.Variant get_matrix ();
		public GtkSource.SpaceTypeFlags get_types_for_locations (GtkSource.SpaceLocationFlags locations);
		public void set_enable_matrix (bool enable_matrix);
		public void set_matrix (GLib.Variant? matrix);
		public void set_types_for_locations (GtkSource.SpaceLocationFlags locations, GtkSource.SpaceTypeFlags types);
		public bool enable_matrix { get; set construct; }
		public GLib.Variant matrix { owned get; set construct; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_style_get_type ()")]
	public class Style : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Style ();
		public void apply (Gtk.TextTag tag);
		public GtkSource.Style copy ();
		[NoAccessorMethod]
		public string background { owned get; construct; }
		[NoAccessorMethod]
		public bool background_set { get; construct; }
		[NoAccessorMethod]
		public bool bold { get; construct; }
		[NoAccessorMethod]
		public bool bold_set { get; construct; }
		[NoAccessorMethod]
		public string foreground { owned get; construct; }
		[NoAccessorMethod]
		public bool foreground_set { get; construct; }
		[NoAccessorMethod]
		public bool italic { get; construct; }
		[NoAccessorMethod]
		public bool italic_set { get; construct; }
		[NoAccessorMethod]
		public string line_background { owned get; construct; }
		[NoAccessorMethod]
		public bool line_background_set { get; construct; }
		[NoAccessorMethod]
		public Pango.Underline pango_underline { get; construct; }
		[NoAccessorMethod]
		public string scale { owned get; construct; }
		[NoAccessorMethod]
		public bool scale_set { get; construct; }
		[NoAccessorMethod]
		public bool strikethrough { get; construct; }
		[NoAccessorMethod]
		public bool strikethrough_set { get; construct; }
		[NoAccessorMethod]
		public string underline_color { owned get; construct; }
		[NoAccessorMethod]
		public bool underline_color_set { get; construct; }
		[NoAccessorMethod]
		public bool underline_set { get; construct; }
		[NoAccessorMethod]
		public Pango.Weight weight { get; construct; }
		[NoAccessorMethod]
		public bool weight_set { get; construct; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_style_scheme_get_type ()")]
	public class StyleScheme : GLib.Object {
		[CCode (has_construct_function = false)]
		protected StyleScheme ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[]? get_authors ();
		public unowned string? get_description ();
		public unowned string? get_filename ();
		public unowned string get_id ();
		[Version (since = "5.4")]
		public unowned string? get_metadata (string name);
		public unowned string get_name ();
		public unowned GtkSource.Style? get_style (string style_id);
		public string description { get; }
		public string filename { get; }
		public string id { get; construct; }
		public string name { get; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_style_scheme_chooser_button_get_type ()")]
	public class StyleSchemeChooserButton : Gtk.Button, Gtk.Accessible, Gtk.Actionable, Gtk.Buildable, Gtk.ConstraintTarget, GtkSource.StyleSchemeChooser {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public StyleSchemeChooserButton ();
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_style_scheme_chooser_widget_get_type ()")]
	public class StyleSchemeChooserWidget : Gtk.Widget, Gtk.Accessible, Gtk.Buildable, Gtk.ConstraintTarget, GtkSource.StyleSchemeChooser {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public StyleSchemeChooserWidget ();
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_style_scheme_manager_get_type ()")]
	public class StyleSchemeManager : GLib.Object {
		[CCode (has_construct_function = false)]
		public StyleSchemeManager ();
		public void append_search_path (string path);
		public void force_rescan ();
		public static unowned GtkSource.StyleSchemeManager get_default ();
		public unowned GtkSource.StyleScheme? get_scheme (string scheme_id);
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[]? get_scheme_ids ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_search_path ();
		public void prepend_search_path (string path);
		public void set_search_path ([CCode (array_length = false, array_null_terminated = true)] string[]? path);
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] scheme_ids { get; }
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] search_path { get; set; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_style_scheme_preview_get_type ()")]
	[Version (since = "5.4")]
	public class StyleSchemePreview : Gtk.Widget, Gtk.Accessible, Gtk.Actionable, Gtk.Buildable, Gtk.ConstraintTarget {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public StyleSchemePreview (GtkSource.StyleScheme scheme);
		public unowned GtkSource.StyleScheme get_scheme ();
		public bool get_selected ();
		public void set_selected (bool selected);
		public GtkSource.StyleScheme scheme { get; construct; }
		public bool selected { get; set; }
		public signal void activate ();
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_tag_get_type ()")]
	public class Tag : Gtk.TextTag {
		[CCode (has_construct_function = false, type = "GtkTextTag*")]
		public Tag (string? name);
		[NoAccessorMethod]
		public bool draw_spaces { get; set; }
		[NoAccessorMethod]
		public bool draw_spaces_set { get; set; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_view_get_type ()")]
	public class View : Gtk.TextView, Gtk.Accessible, Gtk.AccessibleText, Gtk.Buildable, Gtk.ConstraintTarget, Gtk.Scrollable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public View ();
		public bool get_auto_indent ();
		public GtkSource.BackgroundPatternType get_background_pattern ();
		public unowned GtkSource.Completion get_completion ();
		public bool get_enable_snippets ();
		public unowned GtkSource.Gutter get_gutter (Gtk.TextWindowType window_type);
		public bool get_highlight_current_line ();
		public unowned GtkSource.Hover get_hover ();
		public bool get_indent_on_tab ();
		public int get_indent_width ();
		public unowned GtkSource.Indenter? get_indenter ();
		public bool get_insert_spaces_instead_of_tabs ();
		public unowned GtkSource.MarkAttributes get_mark_attributes (string category, int priority);
		public uint get_right_margin_position ();
		public bool get_show_line_marks ();
		public bool get_show_line_numbers ();
		public bool get_show_right_margin ();
		public bool get_smart_backspace ();
		public GtkSource.SmartHomeEndType get_smart_home_end ();
		public unowned GtkSource.SpaceDrawer get_space_drawer ();
		public uint get_tab_width ();
		public uint get_visual_column (Gtk.TextIter iter);
		public void indent_lines (Gtk.TextIter start, Gtk.TextIter end);
		public void set_auto_indent (bool enable);
		public void set_background_pattern (GtkSource.BackgroundPatternType background_pattern);
		public void set_enable_snippets (bool enable_snippets);
		public void set_highlight_current_line (bool highlight);
		public void set_indent_on_tab (bool enable);
		public void set_indent_width (int width);
		public void set_indenter (GtkSource.Indenter? indenter);
		public void set_insert_spaces_instead_of_tabs (bool enable);
		public void set_mark_attributes (string category, GtkSource.MarkAttributes attributes, int priority);
		public void set_right_margin_position (uint pos);
		public void set_show_line_marks (bool show);
		public void set_show_line_numbers (bool show);
		public void set_show_right_margin (bool show);
		public void set_smart_backspace (bool smart_backspace);
		public void set_smart_home_end (GtkSource.SmartHomeEndType smart_home_end);
		public void set_tab_width (uint width);
		public void unindent_lines (Gtk.TextIter start, Gtk.TextIter end);
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public View.with_buffer (GtkSource.Buffer buffer);
		public bool auto_indent { get; set; }
		public GtkSource.BackgroundPatternType background_pattern { get; set; }
		public GtkSource.Completion completion { get; }
		public bool enable_snippets { get; set; }
		public bool highlight_current_line { get; set; }
		public bool indent_on_tab { get; set; }
		public int indent_width { get; set; }
		public GtkSource.Indenter indenter { get; set; }
		public bool insert_spaces_instead_of_tabs { get; set; }
		public uint right_margin_position { get; set; }
		public bool show_line_marks { get; set; }
		public bool show_line_numbers { get; set; }
		public bool show_right_margin { get; set; }
		public bool smart_backspace { get; set; }
		public GtkSource.SmartHomeEndType smart_home_end { get; set; }
		public GtkSource.SpaceDrawer space_drawer { get; }
		public uint tab_width { get; set; }
		public signal void change_case (GtkSource.ChangeCaseType case_type);
		public signal void change_number (int count);
		public signal void join_lines ();
		public virtual signal void line_mark_activated (Gtk.TextIter iter, uint button, Gdk.ModifierType state, int n_presses);
		public virtual signal void move_lines (bool down);
		public signal void move_to_matching_bracket (bool extend_selection);
		public virtual signal void move_words (int step);
		[HasEmitter]
		public virtual signal void push_snippet (GtkSource.Snippet snippet, ref Gtk.TextIter location);
		public virtual signal void show_completion ();
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_vim_im_context_get_type ()")]
	[Version (since = "5.4")]
	public class VimIMContext : Gtk.IMContext {
		[CCode (has_construct_function = false, type = "GtkIMContext*")]
		public VimIMContext ();
		public unowned string get_command_bar_text ();
		public unowned string get_command_text ();
		public string command_bar_text { get; }
		public string command_text { get; }
		public signal void edit (GtkSource.View view, string? path);
		[HasEmitter]
		public signal bool execute_command (string command);
		public signal void format_text (Gtk.TextIter begin, Gtk.TextIter end);
		public signal void write (GtkSource.View view, string? path);
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_cname = "GtkSourceCompletionProposalInterface", type_id = "gtk_source_completion_proposal_get_type ()")]
	public interface CompletionProposal : GLib.Object {
		[Version (since = "5.6")]
		public virtual string? get_typed_text ();
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_cname = "GtkSourceCompletionProviderInterface", type_id = "gtk_source_completion_provider_get_type ()")]
	public interface CompletionProvider : GLib.Object {
		public abstract void activate (GtkSource.CompletionContext context, GtkSource.CompletionProposal proposal);
		public abstract void display (GtkSource.CompletionContext context, GtkSource.CompletionProposal proposal, GtkSource.CompletionCell cell);
		public virtual int get_priority (GtkSource.CompletionContext context);
		public virtual string? get_title ();
		public virtual bool is_trigger (Gtk.TextIter iter, unichar ch);
		public virtual bool key_activates (GtkSource.CompletionContext context, GtkSource.CompletionProposal proposal, uint keyval, Gdk.ModifierType state);
		public virtual GLib.GenericArray<GtkSource.CompletionProposal>? list_alternates (GtkSource.CompletionContext context, GtkSource.CompletionProposal proposal);
		public abstract async GLib.ListModel populate_async (GtkSource.CompletionContext context, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract void refilter (GtkSource.CompletionContext context, GLib.ListModel model);
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_cname = "GtkSourceHoverProviderInterface", type_id = "gtk_source_hover_provider_get_type ()")]
	public interface HoverProvider : GLib.Object {
		[NoWrapper]
		public abstract bool populate (GtkSource.HoverContext context, GtkSource.HoverDisplay display) throws GLib.Error;
		public abstract async bool populate_async (GtkSource.HoverContext context, GtkSource.HoverDisplay display, GLib.Cancellable? cancellable) throws GLib.Error;
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_cname = "GtkSourceIndenterInterface", type_id = "gtk_source_indenter_get_type ()")]
	public interface Indenter : GLib.Object {
		public abstract void indent (GtkSource.View view, ref Gtk.TextIter iter);
		public abstract bool is_trigger (GtkSource.View view, Gtk.TextIter location, Gdk.ModifierType state, uint keyval);
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_cname = "GtkSourceStyleSchemeChooserInterface", type_id = "gtk_source_style_scheme_chooser_get_type ()")]
	public interface StyleSchemeChooser : GLib.Object {
		public abstract unowned GtkSource.StyleScheme get_style_scheme ();
		public abstract void set_style_scheme (GtkSource.StyleScheme scheme);
		public abstract GtkSource.StyleScheme style_scheme { get; set; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", has_type_id = false)]
	public struct RegionIter {
		public bool get_subregion (out Gtk.TextIter start, out Gtk.TextIter end);
		public bool is_end ();
		public bool next ();
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", cprefix = "GTK_SOURCE_BACKGROUND_PATTERN_TYPE_", type_id = "gtk_source_background_pattern_type_get_type ()")]
	public enum BackgroundPatternType {
		NONE,
		GRID
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", cprefix = "GTK_SOURCE_BRACKET_MATCH_", type_id = "gtk_source_bracket_match_type_get_type ()")]
	public enum BracketMatchType {
		NONE,
		OUT_OF_RANGE,
		NOT_FOUND,
		FOUND
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", cprefix = "GTK_SOURCE_CHANGE_CASE_", type_id = "gtk_source_change_case_type_get_type ()")]
	public enum ChangeCaseType {
		LOWER,
		UPPER,
		TOGGLE,
		TITLE
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", cprefix = "GTK_SOURCE_COMPLETION_ACTIVATION_", type_id = "gtk_source_completion_activation_get_type ()")]
	public enum CompletionActivation {
		NONE,
		INTERACTIVE,
		USER_REQUESTED
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", cprefix = "GTK_SOURCE_COMPLETION_COLUMN_", type_id = "gtk_source_completion_column_get_type ()")]
	public enum CompletionColumn {
		ICON,
		BEFORE,
		TYPED_TEXT,
		AFTER,
		COMMENT,
		DETAILS
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", cprefix = "GTK_SOURCE_COMPRESSION_TYPE_", type_id = "gtk_source_compression_type_get_type ()")]
	public enum CompressionType {
		NONE,
		GZIP
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", cprefix = "GTK_SOURCE_FILE_SAVER_FLAGS_", type_id = "gtk_source_file_saver_flags_get_type ()")]
	[Flags]
	public enum FileSaverFlags {
		NONE,
		IGNORE_INVALID_CHARS,
		IGNORE_MODIFICATION_TIME,
		CREATE_BACKUP
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", cprefix = "GTK_SOURCE_GUTTER_RENDERER_ALIGNMENT_MODE_", type_id = "gtk_source_gutter_renderer_alignment_mode_get_type ()")]
	public enum GutterRendererAlignmentMode {
		CELL,
		FIRST,
		LAST
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", cprefix = "GTK_SOURCE_NEWLINE_TYPE_", type_id = "gtk_source_newline_type_get_type ()")]
	public enum NewlineType {
		LF,
		CR,
		CR_LF
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", cprefix = "GTK_SOURCE_SMART_HOME_END_", type_id = "gtk_source_smart_home_end_type_get_type ()")]
	public enum SmartHomeEndType {
		DISABLED,
		BEFORE,
		AFTER,
		ALWAYS
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", cprefix = "GTK_SOURCE_SORT_FLAGS_", type_id = "gtk_source_sort_flags_get_type ()")]
	[Flags]
	public enum SortFlags {
		NONE,
		CASE_SENSITIVE,
		REVERSE_ORDER,
		REMOVE_DUPLICATES
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", cprefix = "GTK_SOURCE_SPACE_LOCATION_", type_id = "gtk_source_space_location_flags_get_type ()")]
	[Flags]
	public enum SpaceLocationFlags {
		NONE,
		LEADING,
		INSIDE_TEXT,
		TRAILING,
		ALL
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", cprefix = "GTK_SOURCE_SPACE_TYPE_", type_id = "gtk_source_space_type_flags_get_type ()")]
	[Flags]
	public enum SpaceTypeFlags {
		NONE,
		SPACE,
		TAB,
		NEWLINE,
		NBSP,
		ALL
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", cprefix = "GTK_SOURCE_VIEW_GUTTER_POSITION_", type_id = "gtk_source_view_gutter_position_get_type ()")]
	public enum ViewGutterPosition {
		LINES,
		MARKS
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", cprefix = "GTK_SOURCE_FILE_LOADER_ERROR_", type_id = "gtk_source_file_loader_error_get_type ()")]
	public errordomain FileLoaderError {
		TOO_BIG,
		ENCODING_AUTO_DETECTION_FAILED,
		CONVERSION_FALLBACK;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", cprefix = "GTK_SOURCE_FILE_SAVER_ERROR_", type_id = "gtk_source_file_saver_error_get_type ()")]
	public errordomain FileSaverError {
		INVALID_CHARS,
		EXTERNALLY_MODIFIED;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", instance_pos = 1.9)]
	[Version (since = "5.2")]
	public delegate bool SchedulerCallback (int64 deadline);
	[CCode (cheader_filename = "gtksourceview/gtksource.h", cname = "GTK_SOURCE_MAJOR_VERSION")]
	public const int MAJOR_VERSION;
	[CCode (cheader_filename = "gtksourceview/gtksource.h", cname = "GTK_SOURCE_MICRO_VERSION")]
	public const int MICRO_VERSION;
	[CCode (cheader_filename = "gtksourceview/gtksource.h", cname = "GTK_SOURCE_MINOR_VERSION")]
	public const int MINOR_VERSION;
	[CCode (cheader_filename = "gtksourceview/gtksource.h")]
	public static bool check_version (uint major, uint minor, uint micro);
	[CCode (cheader_filename = "gtksourceview/gtksource.h")]
	[Version (replacement = "Encoding.get_all")]
	public static GLib.SList<weak GtkSource.Encoding> encoding_get_all ();
	[CCode (cheader_filename = "gtksourceview/gtksource.h")]
	[Version (replacement = "Encoding.get_current")]
	public static unowned GtkSource.Encoding encoding_get_current ();
	[CCode (cheader_filename = "gtksourceview/gtksource.h")]
	[Version (replacement = "Encoding.get_default_candidates")]
	public static GLib.SList<weak GtkSource.Encoding> encoding_get_default_candidates ();
	[CCode (cheader_filename = "gtksourceview/gtksource.h")]
	[Version (replacement = "Encoding.get_from_charset")]
	public static unowned GtkSource.Encoding? encoding_get_from_charset (string charset);
	[CCode (cheader_filename = "gtksourceview/gtksource.h")]
	[Version (replacement = "Encoding.get_utf8")]
	public static unowned GtkSource.Encoding encoding_get_utf8 ();
	[CCode (cheader_filename = "gtksourceview/gtksource.h")]
	[Version (replacement = "FileLoaderError.quark")]
	public static GLib.Quark file_loader_error_quark ();
	[CCode (cheader_filename = "gtksourceview/gtksource.h")]
	[Version (replacement = "FileSaverError.quark")]
	public static GLib.Quark file_saver_error_quark ();
	[CCode (cheader_filename = "gtksourceview/gtksource.h")]
	public static void finalize ();
	[CCode (cheader_filename = "gtksourceview/gtksource.h")]
	public static uint get_major_version ();
	[CCode (cheader_filename = "gtksourceview/gtksource.h")]
	public static uint get_micro_version ();
	[CCode (cheader_filename = "gtksourceview/gtksource.h")]
	public static uint get_minor_version ();
	[CCode (cheader_filename = "gtksourceview/gtksource.h")]
	public static void init ();
	[CCode (cheader_filename = "gtksourceview/gtksource.h")]
	[Version (since = "5.2")]
	public static size_t scheduler_add ([CCode (scope = "async")] GtkSource.SchedulerCallback callback);
	[CCode (cheader_filename = "gtksourceview/gtksource.h")]
	[Version (since = "5.2")]
	public static size_t scheduler_add_full (owned GtkSource.SchedulerCallback callback);
	[CCode (cheader_filename = "gtksourceview/gtksource.h")]
	[Version (since = "5.2")]
	public static void scheduler_remove (size_t handler_id);
	[CCode (cheader_filename = "gtksourceview/gtksource.h")]
	public static string utils_escape_search_text (string text);
	[CCode (cheader_filename = "gtksourceview/gtksource.h")]
	public static string utils_unescape_search_text (string text);
}
