/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 1998-2016                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  Copyright (c) 2009-2015                                                **
**  German Research School for Simulation Sciences GmbH,                   **
**  Laboratory for Parallel Programming                                    **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/



/**
 * \file ReMapScanner.h
 * \brief Provides a lixical analyzer for remap hierarhy definition file.
 */

#ifndef REMAPSCANNER_H
#define REMAPSCANNER_H

// Flex expects the signature of yylex to be defined in the macro YY_DECL, and
// the C++ parser expects it to be declared. We can factor both as follows.

#ifndef YY_DECL

#define YY_DECL                                         \
    remapparser::ReMapParser::token_type                         \
    remapparser::ReMapScanner::lex(                              \
        remapparser::ReMapParser::semantic_type * yylval,         \
        remapparser::ReMapParser::location_type * yylloc          \
        )
#endif

#ifndef __FLEX_LEXER_H
//#define yyFlexLexer Cube4FlexLexer
#include "FlexLexer.h"
#undef yyFlexLexer
#endif

#include "ReMapParser.hh"

namespace remapparser
{
/** Scanner is a derived class to add some extra function to the scanner
 * class. Flex itself creates a class named yyFlexLexer, which is renamed using
 * macros to CubeparserFlexLexer. However we change the context of the generated
 * yylex() function to be contained within the Scanner class. This is required
 * because the yylex() defined in yyFlexLexer has no parameters. */
class ReMapScanner : public yyFlexLexer
{
public:
    /** Create a new scanner object. The streams arg_yyin and arg_yyout default
     * to cin and cout, but that assignment is only made when initializing in
     * yylex(). */
    ReMapScanner( std::istream*      arg_yyin = 0,
                  std::ostream*      arg_yyout = 0,
                  ReMapParseContext* parseContext = NULL );

    /** Required for virtual functions */
    virtual
    ~ReMapScanner();

    /** This is the main lexing function. It is generated by flex according to
     * the macro declaration YY_DECL above. The generated bison parser then
     * calls this virtual function to fetch new tokens. */
    virtual ReMapParser::token_type
    lex(
        ReMapParser::semantic_type* yylval,
        ReMapParser::location_type* yylloc
        );

private:

    ReMapParseContext* parseContext;
};
} // namespace remapparser

#endif // Cube4SCANNER_H
