﻿!mod$ v1 sum:102fb8eb65577241
module w90_comms
use w90_constants,only:dp
use w90_io,only:io_error
private::dp
private::io_error
logical(4),save::on_root
integer(4),save::num_nodes
integer(4),save::my_node_id
integer(4),parameter::root_id=0_4
integer(4),parameter,private::mpi_send_tag=77_4
private::comms_bcast_int
private::comms_bcast_real
private::comms_bcast_logical
private::comms_bcast_char
private::comms_bcast_cmplx
private::comms_send_logical
private::comms_send_int
private::comms_send_char
private::comms_send_real
private::comms_send_cmplx
private::comms_recv_logical
private::comms_recv_int
private::comms_recv_char
private::comms_recv_real
private::comms_recv_cmplx
private::comms_reduce_int
private::comms_reduce_real
private::comms_reduce_cmplx
private::comms_allreduce_real
private::comms_allreduce_cmplx
private::comms_gatherv_real_1
private::comms_gatherv_real_2
private::comms_gatherv_real_3
private::comms_gatherv_real_2_3
private::comms_gatherv_cmplx_1
private::comms_gatherv_cmplx_2
private::comms_gatherv_cmplx_3
private::comms_gatherv_cmplx_3_4
private::comms_gatherv_cmplx_4
private::comms_gatherv_logical
private::comms_scatterv_real_1
private::comms_scatterv_real_2
private::comms_scatterv_real_3
private::comms_scatterv_cmplx_4
private::comms_scatterv_int_1
private::comms_scatterv_int_2
private::comms_scatterv_int_3
interface comms_bcast
procedure::comms_bcast_int
procedure::comms_bcast_logical
procedure::comms_bcast_real
procedure::comms_bcast_cmplx
procedure::comms_bcast_char
end interface
interface comms_send
procedure::comms_send_int
procedure::comms_send_logical
procedure::comms_send_real
procedure::comms_send_cmplx
procedure::comms_send_char
end interface
interface comms_recv
procedure::comms_recv_int
procedure::comms_recv_logical
procedure::comms_recv_real
procedure::comms_recv_cmplx
procedure::comms_recv_char
end interface
interface comms_reduce
procedure::comms_reduce_int
procedure::comms_reduce_real
procedure::comms_reduce_cmplx
end interface
interface comms_allreduce
procedure::comms_allreduce_real
procedure::comms_allreduce_cmplx
end interface
interface comms_gatherv
procedure::comms_gatherv_logical
procedure::comms_gatherv_real_1
procedure::comms_gatherv_real_2
procedure::comms_gatherv_real_3
procedure::comms_gatherv_real_2_3
procedure::comms_gatherv_cmplx_1
procedure::comms_gatherv_cmplx_2
procedure::comms_gatherv_cmplx_3
procedure::comms_gatherv_cmplx_3_4
procedure::comms_gatherv_cmplx_4
end interface
interface comms_scatterv
procedure::comms_scatterv_int_1
procedure::comms_scatterv_int_2
procedure::comms_scatterv_int_3
procedure::comms_scatterv_real_1
procedure::comms_scatterv_real_2
procedure::comms_scatterv_real_3
procedure::comms_scatterv_cmplx_4
end interface
contains
subroutine comms_setup()
end
subroutine comms_setup_vars()
end
subroutine comms_array_split(numpoints,counts,displs)
integer(4),intent(in)::numpoints
integer(4),intent(out)::counts(0_8:int(num_nodes-1_4,kind=8))
integer(4),intent(out)::displs(0_8:int(num_nodes-1_4,kind=8))
end
subroutine comms_end()
end
subroutine comms_barrier()
end
subroutine comms_bcast_int(array,size)
integer(4),intent(inout)::array
integer(4),intent(in)::size
end
subroutine comms_bcast_real(array,size)
real(8),intent(inout)::array
integer(4),intent(in)::size
end
subroutine comms_bcast_logical(array,size)
logical(4),intent(inout)::array
integer(4),intent(in)::size
end
subroutine comms_bcast_char(array,size)
character(*,1),intent(inout)::array
integer(4),intent(in)::size
end
subroutine comms_bcast_cmplx(array,size)
complex(8),intent(inout)::array
integer(4),intent(in)::size
end
subroutine comms_send_logical(array,size,to)
logical(4),intent(inout)::array
integer(4),intent(in)::size
integer(4),intent(in)::to
end
subroutine comms_send_int(array,size,to)
integer(4),intent(inout)::array
integer(4),intent(in)::size
integer(4),intent(in)::to
end
subroutine comms_send_char(array,size,to)
character(*,1),intent(inout)::array
integer(4),intent(in)::size
integer(4),intent(in)::to
end
subroutine comms_send_real(array,size,to)
real(8),intent(inout)::array
integer(4),intent(in)::size
integer(4),intent(in)::to
end
subroutine comms_send_cmplx(array,size,to)
complex(8),intent(inout)::array
integer(4),intent(in)::size
integer(4),intent(in)::to
end
subroutine comms_recv_logical(array,size,from)
logical(4),intent(inout)::array
integer(4),intent(in)::size
integer(4),intent(in)::from
end
subroutine comms_recv_int(array,size,from)
integer(4),intent(inout)::array
integer(4),intent(in)::size
integer(4),intent(in)::from
end
subroutine comms_recv_char(array,size,from)
character(*,1),intent(inout)::array
integer(4),intent(in)::size
integer(4),intent(in)::from
end
subroutine comms_recv_real(array,size,from)
real(8),intent(inout)::array
integer(4),intent(in)::size
integer(4),intent(in)::from
end
subroutine comms_recv_cmplx(array,size,from)
complex(8),intent(inout)::array
integer(4),intent(in)::size
integer(4),intent(in)::from
end
subroutine comms_reduce_int(array,size,op)
integer(4),intent(inout)::array
integer(4),intent(in)::size
character(*,1),intent(in)::op
end
subroutine comms_reduce_real(array,size,op)
real(8),intent(inout)::array
integer(4),intent(in)::size
character(*,1),intent(in)::op
end
subroutine comms_reduce_cmplx(array,size,op)
complex(8),intent(inout)::array
integer(4),intent(in)::size
character(*,1),intent(in)::op
end
subroutine comms_allreduce_real(array,size,op)
real(8),intent(inout)::array
integer(4),intent(in)::size
character(*,1),intent(in)::op
end
subroutine comms_allreduce_cmplx(array,size,op)
complex(8),intent(inout)::array
integer(4),intent(in)::size
character(*,1),intent(in)::op
end
subroutine comms_gatherv_real_1(array,localcount,rootglobalarray,counts,displs)
real(8),intent(inout)::array(:)
integer(4),intent(in)::localcount
real(8),intent(inout)::rootglobalarray(:)
integer(4),intent(in)::counts(1_8:int(num_nodes,kind=8))
integer(4),intent(in)::displs(1_8:int(num_nodes,kind=8))
end
subroutine comms_gatherv_real_2(array,localcount,rootglobalarray,counts,displs)
real(8),intent(inout)::array(:,:)
integer(4),intent(in)::localcount
real(8),intent(inout)::rootglobalarray(:,:)
integer(4),intent(in)::counts(1_8:int(num_nodes,kind=8))
integer(4),intent(in)::displs(1_8:int(num_nodes,kind=8))
end
subroutine comms_gatherv_real_3(array,localcount,rootglobalarray,counts,displs)
real(8),intent(inout)::array(:,:,:)
integer(4),intent(in)::localcount
real(8),intent(inout)::rootglobalarray(:,:,:)
integer(4),intent(in)::counts(1_8:int(num_nodes,kind=8))
integer(4),intent(in)::displs(1_8:int(num_nodes,kind=8))
end
subroutine comms_gatherv_real_2_3(array,localcount,rootglobalarray,counts,displs)
real(8),intent(inout)::array(:,:)
integer(4),intent(in)::localcount
real(8),intent(inout)::rootglobalarray(:,:,:)
integer(4),intent(in)::counts(1_8:int(num_nodes,kind=8))
integer(4),intent(in)::displs(1_8:int(num_nodes,kind=8))
end
subroutine comms_gatherv_cmplx_1(array,localcount,rootglobalarray,counts,displs)
complex(8),intent(inout)::array(:)
integer(4),intent(in)::localcount
complex(8),intent(inout)::rootglobalarray(:)
integer(4),intent(in)::counts(1_8:int(num_nodes,kind=8))
integer(4),intent(in)::displs(1_8:int(num_nodes,kind=8))
end
subroutine comms_gatherv_cmplx_2(array,localcount,rootglobalarray,counts,displs)
complex(8),intent(inout)::array(:,:)
integer(4),intent(in)::localcount
complex(8),intent(inout)::rootglobalarray(:,:)
integer(4),intent(in)::counts(1_8:int(num_nodes,kind=8))
integer(4),intent(in)::displs(1_8:int(num_nodes,kind=8))
end
subroutine comms_gatherv_cmplx_3(array,localcount,rootglobalarray,counts,displs)
complex(8),intent(inout)::array(:,:,:)
integer(4),intent(in)::localcount
complex(8),intent(inout)::rootglobalarray(:,:,:)
integer(4),intent(in)::counts(1_8:int(num_nodes,kind=8))
integer(4),intent(in)::displs(1_8:int(num_nodes,kind=8))
end
subroutine comms_gatherv_cmplx_3_4(array,localcount,rootglobalarray,counts,displs)
complex(8),intent(inout)::array(:,:,:)
integer(4),intent(in)::localcount
complex(8),intent(inout)::rootglobalarray(:,:,:,:)
integer(4),intent(in)::counts(1_8:int(num_nodes,kind=8))
integer(4),intent(in)::displs(1_8:int(num_nodes,kind=8))
end
subroutine comms_gatherv_cmplx_4(array,localcount,rootglobalarray,counts,displs)
complex(8),intent(inout)::array(:,:,:,:)
integer(4),intent(in)::localcount
complex(8),intent(inout)::rootglobalarray(:,:,:,:)
integer(4),intent(in)::counts(1_8:int(num_nodes,kind=8))
integer(4),intent(in)::displs(1_8:int(num_nodes,kind=8))
end
subroutine comms_gatherv_logical(array,localcount,rootglobalarray,counts,displs)
logical(4),intent(inout)::array
integer(4),intent(in)::localcount
logical(4),intent(inout)::rootglobalarray
integer(4),intent(in)::counts(1_8:int(num_nodes,kind=8))
integer(4),intent(in)::displs(1_8:int(num_nodes,kind=8))
end
subroutine comms_scatterv_real_1(array,localcount,rootglobalarray,counts,displs)
real(8),intent(inout)::array(:)
integer(4),intent(in)::localcount
real(8),intent(inout)::rootglobalarray(:)
integer(4),intent(in)::counts(1_8:int(num_nodes,kind=8))
integer(4),intent(in)::displs(1_8:int(num_nodes,kind=8))
end
subroutine comms_scatterv_real_2(array,localcount,rootglobalarray,counts,displs)
real(8),intent(inout)::array(:,:)
integer(4),intent(in)::localcount
real(8),intent(inout)::rootglobalarray(:,:)
integer(4),intent(in)::counts(1_8:int(num_nodes,kind=8))
integer(4),intent(in)::displs(1_8:int(num_nodes,kind=8))
end
subroutine comms_scatterv_real_3(array,localcount,rootglobalarray,counts,displs)
real(8),intent(inout)::array(:,:,:)
integer(4),intent(in)::localcount
real(8),intent(inout)::rootglobalarray(:,:,:)
integer(4),intent(in)::counts(1_8:int(num_nodes,kind=8))
integer(4),intent(in)::displs(1_8:int(num_nodes,kind=8))
end
subroutine comms_scatterv_cmplx_4(array,localcount,rootglobalarray,counts,displs)
complex(8),intent(inout)::array(:,:,:,:)
integer(4),intent(in)::localcount
complex(8),intent(inout)::rootglobalarray(:,:,:,:)
integer(4),intent(in)::counts(1_8:int(num_nodes,kind=8))
integer(4),intent(in)::displs(1_8:int(num_nodes,kind=8))
end
subroutine comms_scatterv_int_1(array,localcount,rootglobalarray,counts,displs)
integer(4),intent(inout)::array(:)
integer(4),intent(in)::localcount
integer(4),intent(inout)::rootglobalarray(:)
integer(4),intent(in)::counts(1_8:int(num_nodes,kind=8))
integer(4),intent(in)::displs(1_8:int(num_nodes,kind=8))
end
subroutine comms_scatterv_int_2(array,localcount,rootglobalarray,counts,displs)
integer(4),intent(inout)::array(:,:)
integer(4),intent(in)::localcount
integer(4),intent(inout)::rootglobalarray(:,:)
integer(4),intent(in)::counts(1_8:int(num_nodes,kind=8))
integer(4),intent(in)::displs(1_8:int(num_nodes,kind=8))
end
subroutine comms_scatterv_int_3(array,localcount,rootglobalarray,counts,displs)
integer(4),intent(inout)::array(:,:,:)
integer(4),intent(in)::localcount
integer(4),intent(inout)::rootglobalarray(:,:,:)
integer(4),intent(in)::counts(1_8:int(num_nodes,kind=8))
integer(4),intent(in)::displs(1_8:int(num_nodes,kind=8))
end
end
