# - Config file for the TIXI package
# It defines the following variables
#  TIXI_INCLUDE_DIRS - include directories for TIXI
#  TIXI_LIBRARIES    - libraries to link against

include(CMakeFindDependencyMacro)

if(NOT "SHARED_LIBRARY" STREQUAL "SHARED_LIBRARY")
  find_dependency(CURL)
  find_dependency(LibXml2)
  find_dependency(LibXslt)

  if(LibXml2_FOUND AND NOT TARGET LibXml2::LibXml2)
    add_library(LibXml2::LibXml2 UNKNOWN IMPORTED)
    set_target_properties(LibXml2::LibXml2 PROPERTIES INTERFACE_INCLUDE_DIRECTORIES "${LIBXML2_INCLUDE_DIRS}")
    set_property(TARGET LibXml2::LibXml2 APPEND PROPERTY IMPORTED_LOCATION "${LIBXML2_LIBRARIES}")

    if (WIN32)
      string(REGEX MATCH "_a.lib$" LibXml2_STATICLIB ${LIBXML2_LIBRARIES})
      if (LibXml2_STATICLIB)
        set_target_properties(LibXml2::LibXml2
            PROPERTIES INTERFACE_COMPILE_DEFINITIONS "LIBXML_STATIC"
        )
      endif(LibXml2_STATICLIB)
    endif (WIN32)
  endif()

  if(LibXslt_FOUND AND NOT TARGET LibXslt::LibXslt)
    add_library(LibXslt::LibXslt UNKNOWN IMPORTED)
    set_target_properties(LibXslt::LibXslt PROPERTIES INTERFACE_INCLUDE_DIRECTORIES "${LIBXSLT_INCLUDE_DIR}")
    set_property(TARGET LibXslt::LibXslt APPEND PROPERTY IMPORTED_LOCATION "${LIBXSLT_LIBRARIES}")
  endif()
  
  if(CURL_FOUND AND NOT TARGET curllib)
    add_library(curllib UNKNOWN IMPORTED)
    set_target_properties(curllib PROPERTIES
      INTERFACE_INCLUDE_DIRECTORIES ${CURL_INCLUDE_DIR}
      IMPORTED_LOCATION ${CURL_LIBRARY}
      IMPORTED_IMPLIB ${CURL_LIBRARY}
    )
    if (WIN32)
      string(REGEX MATCH "_a.lib$" CURL_STATICLIB ${CURL_LIBRARY})
      if (CURL_STATICLIB)
        set_target_properties(curllib
          PROPERTIES INTERFACE_COMPILE_DEFINITIONS "CURL_STATICLIB"
      )
      endif(CURL_STATICLIB)
    endif (WIN32)
  endif()

endif()

include("${CMAKE_CURRENT_LIST_DIR}/tixi3-targets.cmake")

# This is just for backwards compatibilty with old cmake stuff
set(TIXI_LIBRARIES tixi3)
get_target_property(TIXI_INCLUDE_DIRS tixi3 INTERFACE_INCLUDE_DIRECTORIES)
