/*
 * Decompiled with CFR 0.152.
 */
package org.snakeyaml.engine.v2.events;

import java.util.Optional;
import org.snakeyaml.engine.v2.comments.CommentType;
import org.snakeyaml.engine.v2.events.Event;
import org.snakeyaml.engine.v2.exceptions.Mark;

public final class CommentEvent
extends Event {
    private final CommentType type;
    private final String value;

    public CommentEvent(CommentType type2, String value, Optional<Mark> startMark, Optional<Mark> endMark) {
        super(startMark, endMark);
        if (type2 == null) {
            throw new NullPointerException("Event Type must be provided.");
        }
        this.type = type2;
        if (value == null) {
            throw new NullPointerException("Value must be provided.");
        }
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public CommentType getCommentType() {
        return this.type;
    }

    @Override
    public Event.ID getEventId() {
        return Event.ID.Comment;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("=COM ");
        builder.append((Object)this.type);
        builder.append(" ");
        builder.append(this.value);
        return builder.toString();
    }
}

