/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.clikt.output;

import com.github.ajalt.clikt.core.CliktError;
import com.github.ajalt.clikt.output.Editor;
import com.github.ajalt.clikt.output.EditorKt;
import com.github.ajalt.clikt.output.JvmEditor;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B3\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J#\u0010\u000f\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u00112\u0006\u0010\u000e\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u0012J\u0013\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011H\u0002\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0003H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/github/ajalt/clikt/output/JvmEditor;", "Lcom/github/ajalt/clikt/output/Editor;", "editorPath", "", "env", "", "requireSave", "", "extension", "(Ljava/lang/String;Ljava/util/Map;ZLjava/lang/String;)V", "edit", "text", "editFile", "", "filename", "editFileWithEditor", "editorCmd", "", "([Ljava/lang/String;Ljava/lang/String;)V", "getEditorCommand", "()[Ljava/lang/String;", "getEditorPath", "clikt"})
final class JvmEditor
implements Editor {
    @Nullable
    private final String editorPath;
    @NotNull
    private final Map<String, String> env;
    private final boolean requireSave;
    @NotNull
    private final String extension;

    public JvmEditor(@Nullable String editorPath, @NotNull Map<String, String> env, boolean requireSave, @NotNull String extension) {
        Intrinsics.checkNotNullParameter(env, "env");
        Intrinsics.checkNotNullParameter(extension, "extension");
        this.editorPath = editorPath;
        this.env = env;
        this.requireSave = requireSave;
        this.extension = extension;
    }

    private final String getEditorPath() {
        String string = this.editorPath;
        if (string == null) {
            string = EditorKt.inferEditorPath(getEditorPath.1.INSTANCE);
        }
        return string;
    }

    private final String[] getEditorCommand() {
        String[] stringArray = new String[]{" "};
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)this.getEditorPath())).toString(), stringArray, false, 0, 6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        if (stringArray2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        return stringArray2;
    }

    private final void editFileWithEditor(String[] editorCmd, String filename) {
        try {
            Object object = new SpreadBuilder(2);
            ((SpreadBuilder)object).addSpread(editorCmd);
            ((SpreadBuilder)object).add(filename);
            Object $this$editFileWithEditor_u24lambda_u2d0 = object = new ProcessBuilder((String[])((SpreadBuilder)object).toArray(new String[((SpreadBuilder)object).size()]));
            boolean bl = false;
            Map<String, String> map2 = ((ProcessBuilder)$this$editFileWithEditor_u24lambda_u2d0).environment();
            Intrinsics.checkNotNullExpressionValue(map2, "environment()");
            Map<String, String> map3 = map2;
            map3.putAll(this.env);
            ((ProcessBuilder)$this$editFileWithEditor_u24lambda_u2d0).inheritIO();
            Process process2 = ((ProcessBuilder)object).start();
            int exitCode = process2.waitFor();
            if (exitCode != 0) {
                throw new CliktError(editorCmd[0] + ": Editing failed!", null, 2, null);
            }
        }
        catch (Exception err) {
            if (err instanceof CliktError) {
                throw err;
            }
            throw new CliktError("Error staring editor", err);
        }
    }

    @Override
    public void editFile(@NotNull String filename) {
        Intrinsics.checkNotNullParameter(filename, "filename");
        this.editFileWithEditor(this.getEditorCommand(), filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String edit(@NotNull String text2) {
        Intrinsics.checkNotNullParameter(text2, "text");
        String[] editorCmd = this.getEditorCommand();
        String textToEdit = EditorKt.normalizeEditorText(editorCmd[0], text2);
        File file = FilesKt.createTempFile$default(null, this.extension, null, 5, null);
        try {
            FilesKt.writeText$default(file, textToEdit, null, 2, null);
            long ts = file.lastModified();
            String string = file.getCanonicalPath();
            Intrinsics.checkNotNullExpressionValue(string, "file.canonicalPath");
            this.editFileWithEditor(editorCmd, string);
            if (this.requireSave && file.lastModified() == ts) {
                String string2 = null;
                return string2;
            }
            String string3 = StringsKt.replace$default(FilesKt.readText$default(file, null, 1, null), "\r\n", "\n", false, 4, null);
            return string3;
        }
        catch (Exception err) {
            throw new CliktError("Error staring editor", err);
        }
        finally {
            file.delete();
        }
    }
}

