complete -c rgr -s e -l regexp -d 'A pattern to search for.' -r -f
complete -c rgr -s f -l file -d 'Search for patterns from the given file.' -r -F
complete -c rgr -s A -l after-context -d 'Show NUM lines after each match.' -r -f
complete -c rgr -s B -l before-context -d 'Show NUM lines before each match.' -r -f
complete -c rgr  -l binary -d 'Search binary files.'
complete -c rgr -l no-binary -n '__fish_contains_opt  binary' -d 'Search binary files.'
complete -c rgr  -l block-buffered -d 'Force block buffering.'
complete -c rgr -l no-block-buffered -n '__fish_contains_opt  block-buffered' -d 'Force block buffering.'
complete -c rgr -s b -l byte-offset -d 'Print the byte offset for each matching line.'
complete -c rgr -l no-byte-offset -n '__fish_contains_opt -s b byte-offset' -d 'Print the byte offset for each matching line.'
complete -c rgr -s s -l case-sensitive -d 'Search case sensitively (default).'
complete -c rgr  -l color -d 'When to use color.' -r -f -a 'never auto always ansi'
complete -c rgr  -l colors -d 'Configure color settings and styles.' -r -f
complete -c rgr  -l column -d 'Show column numbers.'
complete -c rgr -l no-column -n '__fish_contains_opt  column' -d 'Show column numbers.'
complete -c rgr -s C -l context -d 'Show NUM lines before and after each match.' -r -f
complete -c rgr  -l context-separator -d 'Set the separator for contextual chunks.' -r -f
complete -c rgr -l no-context-separator -n '__fish_contains_opt  context-separator' -d 'Set the separator for contextual chunks.'
complete -c rgr -s c -l count -d 'Show count of matching lines for each file.'
complete -c rgr  -l count-matches -d 'Show count of every match for each file.'
complete -c rgr  -l crlf -d 'Use CRLF line terminators (nice for Windows).'
complete -c rgr -l no-crlf -n '__fish_contains_opt  crlf' -d 'Use CRLF line terminators (nice for Windows).'
complete -c rgr  -l debug -d 'Show debug messages.'
complete -c rgr  -l dfa-size-limit -d 'The upper size limit of the regex DFA.' -r -f
complete -c rgr -s E -l encoding -d 'Specify the text encoding of files to search.' -r -f -a '# This is impossible to read, but these encodings rarely if ever change, so
# it probably does not matter. They are derived from the list given here:
# https://encoding.spec.whatwg.org/#concept-encoding-get
#
# The globbing here works in both fish and zsh (though they expand it in
# different orders). It may work in other shells too.

{{,us-}ascii,arabic,chinese,cyrillic,greek{,8},hebrew,korean}
logical visual mac {,cs}macintosh x-mac-{cyrillic,roman,ukrainian}
866 ibm{819,866} csibm866
big5{,-hkscs} {cn-,cs}big5 x-x-big5
cp{819,866,125{0,1,2,3,4,5,6,7,8}} x-cp125{0,1,2,3,4,5,6,7,8}
csiso2022{jp,kr} csiso8859{6,8}{e,i}
csisolatin{1,2,3,4,5,6,9} csisolatin{arabic,cyrillic,greek,hebrew}
ecma-{114,118} asmo-708 elot_928 sun_eu_greek
euc-{jp,kr} x-euc-jp cseuckr cseucpkdfmtjapanese
{,x-}gbk csiso58gb231280 gb18030 {,cs}gb2312 gb_2312{,-80} hz-gb-2312
iso-2022-{cn,cn-ext,jp,kr}
iso8859{,-}{1,2,3,4,5,6,7,8,9,10,11,13,14,15}
iso-8859-{1,2,3,4,5,6,7,8,9,10,11,{6,8}-{e,i},13,14,15,16} iso_8859-{1,2,3,4,5,6,7,8,9,15}
iso_8859-{1,2,6,7}:1987 iso_8859-{3,4,5,8}:1988 iso_8859-9:1989
iso-ir-{58,100,101,109,110,126,127,138,144,148,149,157}
koi{,8,8-r,8-ru,8-u,8_r} cskoi8r
ks_c_5601-{1987,1989} ksc{,_}5691 csksc56011987
latin{1,2,3,4,5,6} l{1,2,3,4,5,6,9}
shift{-,_}jis csshiftjis {,x-}sjis ms_kanji ms932
utf{,-}8 utf-16{,be,le} unicode-1-1-utf-8
windows-{31j,874,949,125{0,1,2,3,4,5,6,7,8}} dos-874 tis-620 ansi_x3.4-1968
x-user-defined auto none
'
complete -c rgr -l no-encoding -n '__fish_contains_opt -s E encoding' -d 'Specify the text encoding of files to search.'
complete -c rgr  -l engine -d 'Specify which regex engine to use.' -r -f -a 'default pcre2 auto'
complete -c rgr  -l field-context-separator -d 'Set the field context separator.' -r -f
complete -c rgr  -l field-match-separator -d 'Set the field match separator.' -r -f
complete -c rgr  -l files -d 'Print each file that would be searched.'
complete -c rgr -s l -l files-with-matches -d 'Print the paths with at least one match.'
complete -c rgr  -l files-without-match -d 'Print the paths that contain zero matches.'
complete -c rgr -s F -l fixed-strings -d 'Treat all patterns as literals.'
complete -c rgr -l no-fixed-strings -n '__fish_contains_opt -s F fixed-strings' -d 'Treat all patterns as literals.'
complete -c rgr -s L -l follow -d 'Follow symbolic links.'
complete -c rgr -l no-follow -n '__fish_contains_opt -s L follow' -d 'Follow symbolic links.'
complete -c rgr  -l generate -d 'Generate man pages and completion scripts.' -r -f -a 'man complete-bash complete-zsh complete-fish complete-powershell'
complete -c rgr -s g -l glob -d 'Include or exclude file paths.' -r -f
complete -c rgr  -l glob-case-insensitive -d 'Process all glob patterns case insensitively.'
complete -c rgr -l no-glob-case-insensitive -n '__fish_contains_opt  glob-case-insensitive' -d 'Process all glob patterns case insensitively.'
complete -c rgr  -l heading -d 'Print matches grouped by each file.'
complete -c rgr -l no-heading -n '__fish_contains_opt  heading' -d 'Print matches grouped by each file.'
complete -c rgr -s h -l help -d 'Show help output.'
complete -c rgr -s . -l hidden -d 'Search hidden files and directories.'
complete -c rgr -l no-hidden -n '__fish_contains_opt -s . hidden' -d 'Search hidden files and directories.'
complete -c rgr  -l hostname-bin -d 'Run a program to get this system\'s hostname.' -r -f -a '(__fish_complete_command)'
complete -c rgr  -l hyperlink-format -d 'Set the format of hyperlinks.' -r -f
complete -c rgr  -l iglob -d 'Include/exclude paths case insensitively.' -r -f
complete -c rgr -s i -l ignore-case -d 'Case insensitive search.'
complete -c rgr  -l ignore-file -d 'Specify additional ignore files.' -r -F
complete -c rgr  -l ignore-file-case-insensitive -d 'Process ignore files case insensitively.'
complete -c rgr -l no-ignore-file-case-insensitive -n '__fish_contains_opt  ignore-file-case-insensitive' -d 'Process ignore files case insensitively.'
complete -c rgr  -l include-zero -d 'Include zero matches in summary output.'
complete -c rgr -l no-include-zero -n '__fish_contains_opt  include-zero' -d 'Include zero matches in summary output.'
complete -c rgr -s v -l invert-match -d 'Invert matching.'
complete -c rgr -l no-invert-match -n '__fish_contains_opt -s v invert-match' -d 'Invert matching.'
complete -c rgr  -l json -d 'Show search results in a JSON Lines format.'
complete -c rgr -l no-json -n '__fish_contains_opt  json' -d 'Show search results in a JSON Lines format.'
complete -c rgr  -l line-buffered -d 'Force line buffering.'
complete -c rgr -l no-line-buffered -n '__fish_contains_opt  line-buffered' -d 'Force line buffering.'
complete -c rgr -s n -l line-number -d 'Show line numbers.'
complete -c rgr -s N -l no-line-number -d 'Suppress line numbers.'
complete -c rgr -s x -l line-regexp -d 'Show matches surrounded by line boundaries.'
complete -c rgr -s M -l max-columns -d 'Omit lines longer than this limit.' -r -f
complete -c rgr  -l max-columns-preview -d 'Show preview for lines exceeding the limit.'
complete -c rgr -l no-max-columns-preview -n '__fish_contains_opt  max-columns-preview' -d 'Show preview for lines exceeding the limit.'
complete -c rgr -s m -l max-count -d 'Limit the number of matching lines.' -r -f
complete -c rgr -s d -l max-depth -d 'Descend at most NUM directories.' -r -f
complete -c rgr  -l max-filesize -d 'Ignore files larger than NUM in size.' -r -f
complete -c rgr  -l mmap -d 'Search with memory maps when possible.'
complete -c rgr -l no-mmap -n '__fish_contains_opt  mmap' -d 'Search with memory maps when possible.'
complete -c rgr -s U -l multiline -d 'Enable searching across multiple lines.'
complete -c rgr -l no-multiline -n '__fish_contains_opt -s U multiline' -d 'Enable searching across multiple lines.'
complete -c rgr  -l multiline-dotall -d 'Make \'.\' match line terminators.'
complete -c rgr -l no-multiline-dotall -n '__fish_contains_opt  multiline-dotall' -d 'Make \'.\' match line terminators.'
complete -c rgr  -l no-config -d 'Never read configuration files.'
complete -c rgr  -l no-ignore -d 'Don\'t use ignore files.'
complete -c rgr -l ignore -n '__fish_contains_opt  no-ignore' -d 'Don\'t use ignore files.'
complete -c rgr  -l no-ignore-dot -d 'Don\'t use .ignore or .rgignore files.'
complete -c rgr -l ignore-dot -n '__fish_contains_opt  no-ignore-dot' -d 'Don\'t use .ignore or .rgignore files.'
complete -c rgr  -l no-ignore-exclude -d 'Don\'t use local exclusion files.'
complete -c rgr -l ignore-exclude -n '__fish_contains_opt  no-ignore-exclude' -d 'Don\'t use local exclusion files.'
complete -c rgr  -l no-ignore-files -d 'Don\'t use --ignore-file arguments.'
complete -c rgr -l ignore-files -n '__fish_contains_opt  no-ignore-files' -d 'Don\'t use --ignore-file arguments.'
complete -c rgr  -l no-ignore-global -d 'Don\'t use global ignore files.'
complete -c rgr -l ignore-global -n '__fish_contains_opt  no-ignore-global' -d 'Don\'t use global ignore files.'
complete -c rgr  -l no-ignore-messages -d 'Suppress gitignore parse error messages.'
complete -c rgr -l ignore-messages -n '__fish_contains_opt  no-ignore-messages' -d 'Suppress gitignore parse error messages.'
complete -c rgr  -l no-ignore-parent -d 'Don\'t use ignore files in parent directories.'
complete -c rgr -l ignore-parent -n '__fish_contains_opt  no-ignore-parent' -d 'Don\'t use ignore files in parent directories.'
complete -c rgr  -l no-ignore-vcs -d 'Don\'t use ignore files from source control.'
complete -c rgr -l ignore-vcs -n '__fish_contains_opt  no-ignore-vcs' -d 'Don\'t use ignore files from source control.'
complete -c rgr  -l no-messages -d 'Suppress some error messages.'
complete -c rgr -l messages -n '__fish_contains_opt  no-messages' -d 'Suppress some error messages.'
complete -c rgr  -l no-require-git -d 'Use .gitignore outside of git repositories.'
complete -c rgr -l require-git -n '__fish_contains_opt  no-require-git' -d 'Use .gitignore outside of git repositories.'
complete -c rgr  -l no-unicode -d 'Disable Unicode mode.'
complete -c rgr -l unicode -n '__fish_contains_opt  no-unicode' -d 'Disable Unicode mode.'
complete -c rgr -s 0 -l null -d 'Print a NUL byte after file paths.'
complete -c rgr  -l null-data -d 'Use NUL as a line terminator.'
complete -c rgr  -l one-file-system -d 'Skip directories on other file systems.'
complete -c rgr -l no-one-file-system -n '__fish_contains_opt  one-file-system' -d 'Skip directories on other file systems.'
complete -c rgr -s o -l only-matching -d 'Print only matched parts of a line.'
complete -c rgr  -l path-separator -d 'Set the path separator for printing paths.' -r -f
complete -c rgr  -l passthru -d 'Print both matching and non-matching lines.'
complete -c rgr -s P -l pcre2 -d 'Enable PCRE2 matching.'
complete -c rgr -l no-pcre2 -n '__fish_contains_opt -s P pcre2' -d 'Enable PCRE2 matching.'
complete -c rgr  -l pcre2-version -d 'Print the version of PCRE2 that ripgrep uses.'
complete -c rgr  -l pre -d 'Search output of COMMAND for each PATH.' -r -f -a '(__fish_complete_command)'
complete -c rgr -l no-pre -n '__fish_contains_opt  pre' -d 'Search output of COMMAND for each PATH.'
complete -c rgr  -l pre-glob -d 'Include or exclude files from a preprocessor.' -r -f
complete -c rgr -s p -l pretty -d 'Alias for colors, headings and line numbers.'
complete -c rgr -s q -l quiet -d 'Do not print anything to stdout.'
complete -c rgr  -l regex-size-limit -d 'The size limit of the compiled regex.' -r -f
complete -c rgr -s r -l replace -d 'Replace matches with the given text.' -r -f
complete -c rgr -s z -l search-zip -d 'Search in compressed files.'
complete -c rgr -l no-search-zip -n '__fish_contains_opt -s z search-zip' -d 'Search in compressed files.'
complete -c rgr -s S -l smart-case -d 'Smart case search.'
complete -c rgr  -l sort -d 'Sort results in ascending order.' -r -f -a 'none path modified accessed created'
complete -c rgr  -l sortr -d 'Sort results in descending order.' -r -f -a 'none path modified accessed created'
complete -c rgr  -l stats -d 'Print statistics about the search.'
complete -c rgr -l no-stats -n '__fish_contains_opt  stats' -d 'Print statistics about the search.'
complete -c rgr  -l stop-on-nonmatch -d 'Stop searching after a non-match.'
complete -c rgr -s a -l text -d 'Search binary files as if they were text.'
complete -c rgr -l no-text -n '__fish_contains_opt -s a text' -d 'Search binary files as if they were text.'
complete -c rgr -s j -l threads -d 'Set the approximate number of threads to use.' -r -f
complete -c rgr  -l trace -d 'Show trace messages.'
complete -c rgr  -l trim -d 'Trim prefix whitespace from matches.'
complete -c rgr -l no-trim -n '__fish_contains_opt  trim' -d 'Trim prefix whitespace from matches.'
complete -c rgr -s t -l type -d 'Only search files matching TYPE.' -r -f -a '(rg --type-list | string replace : \t)'
complete -c rgr -s T -l type-not -d 'Do not search files matching TYPE.' -r -f -a '(rg --type-list | string replace : \t)'
complete -c rgr  -l type-add -d 'Add a new glob for a file type.' -r -f
complete -c rgr  -l type-clear -d 'Clear globs for a file type.' -r -f
complete -c rgr  -l type-list -d 'Show all supported file types.'
complete -c rgr -s u -l unrestricted -d 'Reduce the level of "smart" filtering.'
complete -c rgr -s V -l version -d 'Print ripgrep\'s version.'
complete -c rgr  -l vimgrep -d 'Print results im a vim compatible format.'
complete -c rgr -s H -l with-filename -d 'Print the file path with each matching line.'
complete -c rgr -s I -l no-filename -d 'Never print the path with each matching line.'
complete -c rgr -s w -l word-regexp -d 'Show matches surrounded by word boundaries.'
complete -c rgr  -l auto-hybrid-regex -d '(DEPRECATED) Use PCRE2 if appropriate.'
complete -c rgr -l no-auto-hybrid-regex -n '__fish_contains_opt  auto-hybrid-regex' -d '(DEPRECATED) Use PCRE2 if appropriate.'
complete -c rgr  -l no-pcre2-unicode -d '(DEPRECATED) Disable Unicode mode for PCRE2.'
complete -c rgr -l pcre2-unicode -n '__fish_contains_opt  no-pcre2-unicode' -d '(DEPRECATED) Disable Unicode mode for PCRE2.'
complete -c rgr  -l sort-files -d '(DEPRECATED) Sort results by file path.'
complete -c rgr -l no-sort-files -n '__fish_contains_opt  sort-files' -d '(DEPRECATED) Sort results by file path.'
