# WARNING: Please don't edit this file. It was generated by Python/WinRT v1.0.0-beta.10

import enum
import datetime
import sys
import types
import typing

import winsdk.system
import winsdk.windows.foundation
import winsdk.windows.foundation.collections
import winsdk.windows.storage.fileproperties
import winsdk.windows.storage.provider
import winsdk.windows.storage.search
import winsdk.windows.storage.streams
import winsdk.windows.system

class ApplicationDataCreateDisposition(enum.IntEnum):
    ALWAYS = 0
    EXISTING = 1

class ApplicationDataLocality(enum.IntEnum):
    LOCAL = 0
    ROAMING = 1
    TEMPORARY = 2
    LOCAL_CACHE = 3
    SHARED_LOCAL = 4

class CreationCollisionOption(enum.IntEnum):
    GENERATE_UNIQUE_NAME = 0
    REPLACE_EXISTING = 1
    FAIL_IF_EXISTS = 2
    OPEN_IF_EXISTS = 3

class FileAccessMode(enum.IntEnum):
    READ = 0
    READ_WRITE = 1

class FileAttributes(enum.IntFlag):
    NORMAL = 0
    READ_ONLY = 0x1
    DIRECTORY = 0x10
    ARCHIVE = 0x20
    TEMPORARY = 0x100
    LOCALLY_INCOMPLETE = 0x200

class KnownFolderId(enum.IntEnum):
    APP_CAPTURES = 0
    CAMERA_ROLL = 1
    DOCUMENTS_LIBRARY = 2
    HOME_GROUP = 3
    MEDIA_SERVER_DEVICES = 4
    MUSIC_LIBRARY = 5
    OBJECTS3_D = 6
    PICTURES_LIBRARY = 7
    PLAYLISTS = 8
    RECORDED_CALLS = 9
    REMOVABLE_DEVICES = 10
    SAVED_PICTURES = 11
    SCREENSHOTS = 12
    VIDEOS_LIBRARY = 13
    ALL_APP_MODS = 14
    CURRENT_APP_MODS = 15
    DOWNLOADS_FOLDER = 16

class KnownFoldersAccessStatus(enum.IntEnum):
    DENIED_BY_SYSTEM = 0
    NOT_DECLARED_BY_APP = 1
    DENIED_BY_USER = 2
    USER_PROMPT_REQUIRED = 3
    ALLOWED = 4
    ALLOWED_PER_APP_FOLDER = 5

class KnownLibraryId(enum.IntEnum):
    MUSIC = 0
    PICTURES = 1
    VIDEOS = 2
    DOCUMENTS = 3

class NameCollisionOption(enum.IntEnum):
    GENERATE_UNIQUE_NAME = 0
    REPLACE_EXISTING = 1
    FAIL_IF_EXISTS = 2

class StorageDeleteOption(enum.IntEnum):
    DEFAULT = 0
    PERMANENT_DELETE = 1

class StorageItemTypes(enum.IntFlag):
    NONE = 0
    FILE = 0x1
    FOLDER = 0x2

class StorageLibraryChangeType(enum.IntEnum):
    CREATED = 0
    DELETED = 1
    MOVED_OR_RENAMED = 2
    CONTENTS_CHANGED = 3
    MOVED_OUT_OF_LIBRARY = 4
    MOVED_INTO_LIBRARY = 5
    CONTENTS_REPLACED = 6
    INDEXING_STATUS_CHANGED = 7
    ENCRYPTION_CHANGED = 8
    CHANGE_TRACKING_LOST = 9

class StorageOpenOptions(enum.IntFlag):
    NONE = 0
    ALLOW_ONLY_READERS = 0x1
    ALLOW_READERS_AND_WRITERS = 0x2

class StreamedFileFailureMode(enum.IntEnum):
    FAILED = 0
    CURRENTLY_UNAVAILABLE = 1
    INCOMPLETE = 2

Self = typing.TypeVar('Self')

class AppDataPaths(winsdk.system.Object):
    cookies: str
    desktop: str
    documents: str
    favorites: str
    history: str
    internet_cache: str
    local_app_data: str
    program_data: str
    roaming_app_data: str
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> AppDataPaths: ...
    @staticmethod
    def get_default() -> typing.Optional[AppDataPaths]: ...
    @staticmethod
    def get_for_user(user: typing.Optional[winsdk.windows.system.User], /) -> typing.Optional[AppDataPaths]: ...

class ApplicationData(winsdk.system.Object):
    local_folder: typing.Optional[StorageFolder]
    local_settings: typing.Optional[ApplicationDataContainer]
    roaming_folder: typing.Optional[StorageFolder]
    roaming_settings: typing.Optional[ApplicationDataContainer]
    roaming_storage_quota: winsdk.system.UInt64
    temporary_folder: typing.Optional[StorageFolder]
    version: winsdk.system.UInt32
    local_cache_folder: typing.Optional[StorageFolder]
    shared_local_folder: typing.Optional[StorageFolder]
    current: typing.ClassVar[typing.Optional[ApplicationData]]
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> ApplicationData: ...
    @typing.overload
    def clear_async(self) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def clear_async(self, locality: ApplicationDataLocality, /) -> winsdk.windows.foundation.IAsyncAction: ...
    def clear_publisher_cache_folder_async(self, folder_name: str, /) -> winsdk.windows.foundation.IAsyncAction: ...
    def close(self) -> None: ...
    @staticmethod
    def get_for_user_async(user: typing.Optional[winsdk.windows.system.User], /) -> winsdk.windows.foundation.IAsyncOperation[ApplicationData]: ...
    def get_publisher_cache_folder(self, folder_name: str, /) -> typing.Optional[StorageFolder]: ...
    def set_version_async(self, desired_version: winsdk.system.UInt32, handler: typing.Optional[ApplicationDataSetVersionHandler], /) -> winsdk.windows.foundation.IAsyncAction: ...
    def signal_data_changed(self) -> None: ...
    def add_data_changed(self, handler: winsdk.windows.foundation.TypedEventHandler[ApplicationData, winsdk.system.Object], /) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_data_changed(self, token: winsdk.windows.foundation.EventRegistrationToken, /) -> None: ...

class ApplicationDataCompositeValue(winsdk.system.Object, typing.MutableMapping[str, winsdk.system.Object]):
    size: winsdk.system.UInt32
    def __len__(self) -> int: ...
    def __iter__(self) -> typing.Iterator[str]: ...
    def __contains__(self, key: object) -> bool:...
    def __setitem__(self, key: str, value: winsdk.system.Object) -> None: ...
    def __getitem__(self, key: str) -> winsdk.system.Object: ...
    def __delitem__(self, key: str) -> None: ...
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> ApplicationDataCompositeValue: ...
    def __new__(cls: typing.Type[ApplicationDataCompositeValue]) -> ApplicationDataCompositeValue:...
    def clear(self) -> None: ...
    def first(self) -> typing.Optional[winsdk.windows.foundation.collections.IIterator[winsdk.windows.foundation.collections.IKeyValuePair[str, winsdk.system.Object]]]: ...
    def get_view(self) -> typing.Optional[winsdk.windows.foundation.collections.IMapView[str, winsdk.system.Object]]: ...
    def has_key(self, key: str, /) -> winsdk.system.Boolean: ...
    def insert(self, key: str, value: typing.Optional[winsdk.system.Object], /) -> winsdk.system.Boolean: ...
    def lookup(self, key: str, /) -> typing.Optional[winsdk.system.Object]: ...
    def remove(self, key: str, /) -> None: ...
    def add_map_changed(self, vhnd: winsdk.windows.foundation.collections.MapChangedEventHandler[str, winsdk.system.Object], /) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_map_changed(self, token: winsdk.windows.foundation.EventRegistrationToken, /) -> None: ...

class ApplicationDataContainer(winsdk.system.Object):
    containers: typing.Optional[winsdk.windows.foundation.collections.IMapView[str, ApplicationDataContainer]]
    locality: ApplicationDataLocality
    name: str
    values: typing.Optional[winsdk.windows.foundation.collections.IPropertySet]
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> ApplicationDataContainer: ...
    def close(self) -> None: ...
    def create_container(self, name: str, disposition: ApplicationDataCreateDisposition, /) -> typing.Optional[ApplicationDataContainer]: ...
    def delete_container(self, name: str, /) -> None: ...

class ApplicationDataContainerSettings(winsdk.system.Object, typing.MutableMapping[str, winsdk.system.Object]):
    size: winsdk.system.UInt32
    def __len__(self) -> int: ...
    def __iter__(self) -> typing.Iterator[str]: ...
    def __contains__(self, key: object) -> bool:...
    def __setitem__(self, key: str, value: winsdk.system.Object) -> None: ...
    def __getitem__(self, key: str) -> winsdk.system.Object: ...
    def __delitem__(self, key: str) -> None: ...
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> ApplicationDataContainerSettings: ...
    def clear(self) -> None: ...
    def first(self) -> typing.Optional[winsdk.windows.foundation.collections.IIterator[winsdk.windows.foundation.collections.IKeyValuePair[str, winsdk.system.Object]]]: ...
    def get_view(self) -> typing.Optional[winsdk.windows.foundation.collections.IMapView[str, winsdk.system.Object]]: ...
    def has_key(self, key: str, /) -> winsdk.system.Boolean: ...
    def insert(self, key: str, value: typing.Optional[winsdk.system.Object], /) -> winsdk.system.Boolean: ...
    def lookup(self, key: str, /) -> typing.Optional[winsdk.system.Object]: ...
    def remove(self, key: str, /) -> None: ...
    def add_map_changed(self, vhnd: winsdk.windows.foundation.collections.MapChangedEventHandler[str, winsdk.system.Object], /) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_map_changed(self, token: winsdk.windows.foundation.EventRegistrationToken, /) -> None: ...

class CachedFileManager(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> CachedFileManager: ...
    @staticmethod
    def complete_updates_async(file: typing.Optional[IStorageFile], /) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.provider.FileUpdateStatus]: ...
    @staticmethod
    def defer_updates(file: typing.Optional[IStorageFile], /) -> None: ...

class DownloadsFolder(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> DownloadsFolder: ...
    @typing.overload
    @staticmethod
    def create_file_async(desired_name: str, /) -> winsdk.windows.foundation.IAsyncOperation[StorageFile]: ...
    @typing.overload
    @staticmethod
    def create_file_async(desired_name: str, option: CreationCollisionOption, /) -> winsdk.windows.foundation.IAsyncOperation[StorageFile]: ...
    @typing.overload
    @staticmethod
    def create_file_for_user_async(user: typing.Optional[winsdk.windows.system.User], desired_name: str, /) -> winsdk.windows.foundation.IAsyncOperation[StorageFile]: ...
    @typing.overload
    @staticmethod
    def create_file_for_user_async(user: typing.Optional[winsdk.windows.system.User], desired_name: str, option: CreationCollisionOption, /) -> winsdk.windows.foundation.IAsyncOperation[StorageFile]: ...
    @typing.overload
    @staticmethod
    def create_folder_async(desired_name: str, /) -> winsdk.windows.foundation.IAsyncOperation[StorageFolder]: ...
    @typing.overload
    @staticmethod
    def create_folder_async(desired_name: str, option: CreationCollisionOption, /) -> winsdk.windows.foundation.IAsyncOperation[StorageFolder]: ...
    @typing.overload
    @staticmethod
    def create_folder_for_user_async(user: typing.Optional[winsdk.windows.system.User], desired_name: str, /) -> winsdk.windows.foundation.IAsyncOperation[StorageFolder]: ...
    @typing.overload
    @staticmethod
    def create_folder_for_user_async(user: typing.Optional[winsdk.windows.system.User], desired_name: str, option: CreationCollisionOption, /) -> winsdk.windows.foundation.IAsyncOperation[StorageFolder]: ...

class FileIO(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> FileIO: ...
    @typing.overload
    @staticmethod
    def append_lines_async(file: typing.Optional[IStorageFile], lines: typing.Iterable[str], /) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    @staticmethod
    def append_lines_async(file: typing.Optional[IStorageFile], lines: typing.Iterable[str], encoding: winsdk.windows.storage.streams.UnicodeEncoding, /) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    @staticmethod
    def append_text_async(file: typing.Optional[IStorageFile], contents: str, /) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    @staticmethod
    def append_text_async(file: typing.Optional[IStorageFile], contents: str, encoding: winsdk.windows.storage.streams.UnicodeEncoding, /) -> winsdk.windows.foundation.IAsyncAction: ...
    @staticmethod
    def read_buffer_async(file: typing.Optional[IStorageFile], /) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.streams.IBuffer]: ...
    @typing.overload
    @staticmethod
    def read_lines_async(file: typing.Optional[IStorageFile], /) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVector[str]]: ...
    @typing.overload
    @staticmethod
    def read_lines_async(file: typing.Optional[IStorageFile], encoding: winsdk.windows.storage.streams.UnicodeEncoding, /) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVector[str]]: ...
    @typing.overload
    @staticmethod
    def read_text_async(file: typing.Optional[IStorageFile], /) -> winsdk.windows.foundation.IAsyncOperation[str]: ...
    @typing.overload
    @staticmethod
    def read_text_async(file: typing.Optional[IStorageFile], encoding: winsdk.windows.storage.streams.UnicodeEncoding, /) -> winsdk.windows.foundation.IAsyncOperation[str]: ...
    @staticmethod
    def write_buffer_async(file: typing.Optional[IStorageFile], buffer: typing.Optional[winsdk.windows.storage.streams.IBuffer], /) -> winsdk.windows.foundation.IAsyncAction: ...
    @staticmethod
    def write_bytes_async(file: typing.Optional[IStorageFile], buffer: winsdk.system.Array[winsdk.system.UInt8], /) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    @staticmethod
    def write_lines_async(file: typing.Optional[IStorageFile], lines: typing.Iterable[str], /) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    @staticmethod
    def write_lines_async(file: typing.Optional[IStorageFile], lines: typing.Iterable[str], encoding: winsdk.windows.storage.streams.UnicodeEncoding, /) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    @staticmethod
    def write_text_async(file: typing.Optional[IStorageFile], contents: str, /) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    @staticmethod
    def write_text_async(file: typing.Optional[IStorageFile], contents: str, encoding: winsdk.windows.storage.streams.UnicodeEncoding, /) -> winsdk.windows.foundation.IAsyncAction: ...

class KnownFolders(winsdk.system.Object):
    camera_roll: typing.ClassVar[typing.Optional[StorageFolder]]
    playlists: typing.ClassVar[typing.Optional[StorageFolder]]
    saved_pictures: typing.ClassVar[typing.Optional[StorageFolder]]
    documents_library: typing.ClassVar[typing.Optional[StorageFolder]]
    home_group: typing.ClassVar[typing.Optional[StorageFolder]]
    media_server_devices: typing.ClassVar[typing.Optional[StorageFolder]]
    music_library: typing.ClassVar[typing.Optional[StorageFolder]]
    pictures_library: typing.ClassVar[typing.Optional[StorageFolder]]
    removable_devices: typing.ClassVar[typing.Optional[StorageFolder]]
    videos_library: typing.ClassVar[typing.Optional[StorageFolder]]
    app_captures: typing.ClassVar[typing.Optional[StorageFolder]]
    objects3_d: typing.ClassVar[typing.Optional[StorageFolder]]
    recorded_calls: typing.ClassVar[typing.Optional[StorageFolder]]
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> KnownFolders: ...
    @staticmethod
    def get_folder_async(folder_id: KnownFolderId, /) -> winsdk.windows.foundation.IAsyncOperation[StorageFolder]: ...
    @staticmethod
    def get_folder_for_user_async(user: typing.Optional[winsdk.windows.system.User], folder_id: KnownFolderId, /) -> winsdk.windows.foundation.IAsyncOperation[StorageFolder]: ...
    @staticmethod
    def request_access_async(folder_id: KnownFolderId, /) -> winsdk.windows.foundation.IAsyncOperation[KnownFoldersAccessStatus]: ...
    @staticmethod
    def request_access_for_user_async(user: typing.Optional[winsdk.windows.system.User], folder_id: KnownFolderId, /) -> winsdk.windows.foundation.IAsyncOperation[KnownFoldersAccessStatus]: ...

class PathIO(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> PathIO: ...
    @typing.overload
    @staticmethod
    def append_lines_async(absolute_path: str, lines: typing.Iterable[str], /) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    @staticmethod
    def append_lines_async(absolute_path: str, lines: typing.Iterable[str], encoding: winsdk.windows.storage.streams.UnicodeEncoding, /) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    @staticmethod
    def append_text_async(absolute_path: str, contents: str, /) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    @staticmethod
    def append_text_async(absolute_path: str, contents: str, encoding: winsdk.windows.storage.streams.UnicodeEncoding, /) -> winsdk.windows.foundation.IAsyncAction: ...
    @staticmethod
    def read_buffer_async(absolute_path: str, /) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.streams.IBuffer]: ...
    @typing.overload
    @staticmethod
    def read_lines_async(absolute_path: str, /) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVector[str]]: ...
    @typing.overload
    @staticmethod
    def read_lines_async(absolute_path: str, encoding: winsdk.windows.storage.streams.UnicodeEncoding, /) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVector[str]]: ...
    @typing.overload
    @staticmethod
    def read_text_async(absolute_path: str, /) -> winsdk.windows.foundation.IAsyncOperation[str]: ...
    @typing.overload
    @staticmethod
    def read_text_async(absolute_path: str, encoding: winsdk.windows.storage.streams.UnicodeEncoding, /) -> winsdk.windows.foundation.IAsyncOperation[str]: ...
    @staticmethod
    def write_buffer_async(absolute_path: str, buffer: typing.Optional[winsdk.windows.storage.streams.IBuffer], /) -> winsdk.windows.foundation.IAsyncAction: ...
    @staticmethod
    def write_bytes_async(absolute_path: str, buffer: winsdk.system.Array[winsdk.system.UInt8], /) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    @staticmethod
    def write_lines_async(absolute_path: str, lines: typing.Iterable[str], /) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    @staticmethod
    def write_lines_async(absolute_path: str, lines: typing.Iterable[str], encoding: winsdk.windows.storage.streams.UnicodeEncoding, /) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    @staticmethod
    def write_text_async(absolute_path: str, contents: str, /) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    @staticmethod
    def write_text_async(absolute_path: str, contents: str, encoding: winsdk.windows.storage.streams.UnicodeEncoding, /) -> winsdk.windows.foundation.IAsyncAction: ...

class SetVersionDeferral(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> SetVersionDeferral: ...
    def complete(self) -> None: ...

class SetVersionRequest(winsdk.system.Object):
    current_version: winsdk.system.UInt32
    desired_version: winsdk.system.UInt32
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> SetVersionRequest: ...
    def get_deferral(self) -> typing.Optional[SetVersionDeferral]: ...

class StorageFile(winsdk.system.Object):
    content_type: str
    file_type: str
    is_available: winsdk.system.Boolean
    attributes: FileAttributes
    date_created: datetime.datetime
    name: str
    path: str
    display_name: str
    display_type: str
    folder_relative_id: str
    properties: typing.Optional[winsdk.windows.storage.fileproperties.StorageItemContentProperties]
    provider: typing.Optional[StorageProvider]
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> StorageFile: ...
    def copy_and_replace_async(self, file_to_replace: typing.Optional[IStorageFile], /) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def copy_async(self, destination_folder: typing.Optional[IStorageFolder], /) -> winsdk.windows.foundation.IAsyncOperation[StorageFile]: ...
    @typing.overload
    def copy_async(self, destination_folder: typing.Optional[IStorageFolder], desired_new_name: str, /) -> winsdk.windows.foundation.IAsyncOperation[StorageFile]: ...
    @typing.overload
    def copy_async(self, destination_folder: typing.Optional[IStorageFolder], desired_new_name: str, option: NameCollisionOption, /) -> winsdk.windows.foundation.IAsyncOperation[StorageFile]: ...
    @staticmethod
    def create_streamed_file_async(display_name_with_extension: str, data_requested: typing.Optional[StreamedFileDataRequestedHandler], thumbnail: typing.Optional[winsdk.windows.storage.streams.IRandomAccessStreamReference], /) -> winsdk.windows.foundation.IAsyncOperation[StorageFile]: ...
    @staticmethod
    def create_streamed_file_from_uri_async(display_name_with_extension: str, uri: typing.Optional[winsdk.windows.foundation.Uri], thumbnail: typing.Optional[winsdk.windows.storage.streams.IRandomAccessStreamReference], /) -> winsdk.windows.foundation.IAsyncOperation[StorageFile]: ...
    @typing.overload
    def delete_async(self) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def delete_async(self, option: StorageDeleteOption, /) -> winsdk.windows.foundation.IAsyncAction: ...
    def get_basic_properties_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.BasicProperties]: ...
    @staticmethod
    def get_file_from_application_uri_async(uri: typing.Optional[winsdk.windows.foundation.Uri], /) -> winsdk.windows.foundation.IAsyncOperation[StorageFile]: ...
    @staticmethod
    def get_file_from_path_async(path: str, /) -> winsdk.windows.foundation.IAsyncOperation[StorageFile]: ...
    @staticmethod
    def get_file_from_path_for_user_async(user: typing.Optional[winsdk.windows.system.User], path: str, /) -> winsdk.windows.foundation.IAsyncOperation[StorageFile]: ...
    def get_parent_async(self) -> winsdk.windows.foundation.IAsyncOperation[StorageFolder]: ...
    @typing.overload
    def get_scaled_image_as_thumbnail_async(self, mode: winsdk.windows.storage.fileproperties.ThumbnailMode, /) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.StorageItemThumbnail]: ...
    @typing.overload
    def get_scaled_image_as_thumbnail_async(self, mode: winsdk.windows.storage.fileproperties.ThumbnailMode, requested_size: winsdk.system.UInt32, /) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.StorageItemThumbnail]: ...
    @typing.overload
    def get_scaled_image_as_thumbnail_async(self, mode: winsdk.windows.storage.fileproperties.ThumbnailMode, requested_size: winsdk.system.UInt32, options: winsdk.windows.storage.fileproperties.ThumbnailOptions, /) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.StorageItemThumbnail]: ...
    @typing.overload
    def get_thumbnail_async(self, mode: winsdk.windows.storage.fileproperties.ThumbnailMode, /) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.StorageItemThumbnail]: ...
    @typing.overload
    def get_thumbnail_async(self, mode: winsdk.windows.storage.fileproperties.ThumbnailMode, requested_size: winsdk.system.UInt32, /) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.StorageItemThumbnail]: ...
    @typing.overload
    def get_thumbnail_async(self, mode: winsdk.windows.storage.fileproperties.ThumbnailMode, requested_size: winsdk.system.UInt32, options: winsdk.windows.storage.fileproperties.ThumbnailOptions, /) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.StorageItemThumbnail]: ...
    def is_equal(self, item: typing.Optional[IStorageItem], /) -> winsdk.system.Boolean: ...
    def is_of_type(self, type: StorageItemTypes, /) -> winsdk.system.Boolean: ...
    def move_and_replace_async(self, file_to_replace: typing.Optional[IStorageFile], /) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def move_async(self, destination_folder: typing.Optional[IStorageFolder], /) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def move_async(self, destination_folder: typing.Optional[IStorageFolder], desired_new_name: str, /) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def move_async(self, destination_folder: typing.Optional[IStorageFolder], desired_new_name: str, option: NameCollisionOption, /) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def open_async(self, access_mode: FileAccessMode, /) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.streams.IRandomAccessStream]: ...
    @typing.overload
    def open_async(self, access_mode: FileAccessMode, options: StorageOpenOptions, /) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.streams.IRandomAccessStream]: ...
    def open_read_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.streams.IRandomAccessStreamWithContentType]: ...
    def open_sequential_read_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.streams.IInputStream]: ...
    @typing.overload
    def open_transacted_write_async(self) -> winsdk.windows.foundation.IAsyncOperation[StorageStreamTransaction]: ...
    @typing.overload
    def open_transacted_write_async(self, options: StorageOpenOptions, /) -> winsdk.windows.foundation.IAsyncOperation[StorageStreamTransaction]: ...
    @typing.overload
    def rename_async(self, desired_name: str, /) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def rename_async(self, desired_name: str, option: NameCollisionOption, /) -> winsdk.windows.foundation.IAsyncAction: ...
    @staticmethod
    def replace_with_streamed_file_async(file_to_replace: typing.Optional[IStorageFile], data_requested: typing.Optional[StreamedFileDataRequestedHandler], thumbnail: typing.Optional[winsdk.windows.storage.streams.IRandomAccessStreamReference], /) -> winsdk.windows.foundation.IAsyncOperation[StorageFile]: ...
    @staticmethod
    def replace_with_streamed_file_from_uri_async(file_to_replace: typing.Optional[IStorageFile], uri: typing.Optional[winsdk.windows.foundation.Uri], thumbnail: typing.Optional[winsdk.windows.storage.streams.IRandomAccessStreamReference], /) -> winsdk.windows.foundation.IAsyncOperation[StorageFile]: ...

class StorageFolder(winsdk.system.Object):
    attributes: FileAttributes
    date_created: datetime.datetime
    name: str
    path: str
    display_name: str
    display_type: str
    folder_relative_id: str
    properties: typing.Optional[winsdk.windows.storage.fileproperties.StorageItemContentProperties]
    provider: typing.Optional[StorageProvider]
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> StorageFolder: ...
    def are_query_options_supported(self, query_options: typing.Optional[winsdk.windows.storage.search.QueryOptions], /) -> winsdk.system.Boolean: ...
    @typing.overload
    def create_file_async(self, desired_name: str, /) -> winsdk.windows.foundation.IAsyncOperation[StorageFile]: ...
    @typing.overload
    def create_file_async(self, desired_name: str, options: CreationCollisionOption, /) -> winsdk.windows.foundation.IAsyncOperation[StorageFile]: ...
    @typing.overload
    def create_file_query(self) -> typing.Optional[winsdk.windows.storage.search.StorageFileQueryResult]: ...
    @typing.overload
    def create_file_query(self, query: winsdk.windows.storage.search.CommonFileQuery, /) -> typing.Optional[winsdk.windows.storage.search.StorageFileQueryResult]: ...
    def create_file_query_with_options(self, query_options: typing.Optional[winsdk.windows.storage.search.QueryOptions], /) -> typing.Optional[winsdk.windows.storage.search.StorageFileQueryResult]: ...
    @typing.overload
    def create_folder_async(self, desired_name: str, /) -> winsdk.windows.foundation.IAsyncOperation[StorageFolder]: ...
    @typing.overload
    def create_folder_async(self, desired_name: str, options: CreationCollisionOption, /) -> winsdk.windows.foundation.IAsyncOperation[StorageFolder]: ...
    @typing.overload
    def create_folder_query(self) -> typing.Optional[winsdk.windows.storage.search.StorageFolderQueryResult]: ...
    @typing.overload
    def create_folder_query(self, query: winsdk.windows.storage.search.CommonFolderQuery, /) -> typing.Optional[winsdk.windows.storage.search.StorageFolderQueryResult]: ...
    def create_folder_query_with_options(self, query_options: typing.Optional[winsdk.windows.storage.search.QueryOptions], /) -> typing.Optional[winsdk.windows.storage.search.StorageFolderQueryResult]: ...
    def create_item_query(self) -> typing.Optional[winsdk.windows.storage.search.StorageItemQueryResult]: ...
    def create_item_query_with_options(self, query_options: typing.Optional[winsdk.windows.storage.search.QueryOptions], /) -> typing.Optional[winsdk.windows.storage.search.StorageItemQueryResult]: ...
    @typing.overload
    def delete_async(self) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def delete_async(self, option: StorageDeleteOption, /) -> winsdk.windows.foundation.IAsyncAction: ...
    def get_basic_properties_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.BasicProperties]: ...
    def get_file_async(self, name: str, /) -> winsdk.windows.foundation.IAsyncOperation[StorageFile]: ...
    @typing.overload
    def get_files_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[StorageFile]]: ...
    @typing.overload
    def get_files_async(self, query: winsdk.windows.storage.search.CommonFileQuery, /) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[StorageFile]]: ...
    @typing.overload
    def get_files_async(self, query: winsdk.windows.storage.search.CommonFileQuery, start_index: winsdk.system.UInt32, max_items_to_retrieve: winsdk.system.UInt32, /) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[StorageFile]]: ...
    def get_folder_async(self, name: str, /) -> winsdk.windows.foundation.IAsyncOperation[StorageFolder]: ...
    @staticmethod
    def get_folder_from_path_async(path: str, /) -> winsdk.windows.foundation.IAsyncOperation[StorageFolder]: ...
    @staticmethod
    def get_folder_from_path_for_user_async(user: typing.Optional[winsdk.windows.system.User], path: str, /) -> winsdk.windows.foundation.IAsyncOperation[StorageFolder]: ...
    @typing.overload
    def get_folders_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[StorageFolder]]: ...
    @typing.overload
    def get_folders_async(self, query: winsdk.windows.storage.search.CommonFolderQuery, /) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[StorageFolder]]: ...
    @typing.overload
    def get_folders_async(self, query: winsdk.windows.storage.search.CommonFolderQuery, start_index: winsdk.system.UInt32, max_items_to_retrieve: winsdk.system.UInt32, /) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[StorageFolder]]: ...
    def get_indexed_state_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.search.IndexedState]: ...
    def get_item_async(self, name: str, /) -> winsdk.windows.foundation.IAsyncOperation[IStorageItem]: ...
    @typing.overload
    def get_items_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[IStorageItem]]: ...
    @typing.overload
    def get_items_async(self, start_index: winsdk.system.UInt32, max_items_to_retrieve: winsdk.system.UInt32, /) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[IStorageItem]]: ...
    def get_parent_async(self) -> winsdk.windows.foundation.IAsyncOperation[StorageFolder]: ...
    @typing.overload
    def get_scaled_image_as_thumbnail_async(self, mode: winsdk.windows.storage.fileproperties.ThumbnailMode, /) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.StorageItemThumbnail]: ...
    @typing.overload
    def get_scaled_image_as_thumbnail_async(self, mode: winsdk.windows.storage.fileproperties.ThumbnailMode, requested_size: winsdk.system.UInt32, /) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.StorageItemThumbnail]: ...
    @typing.overload
    def get_scaled_image_as_thumbnail_async(self, mode: winsdk.windows.storage.fileproperties.ThumbnailMode, requested_size: winsdk.system.UInt32, options: winsdk.windows.storage.fileproperties.ThumbnailOptions, /) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.StorageItemThumbnail]: ...
    @typing.overload
    def get_thumbnail_async(self, mode: winsdk.windows.storage.fileproperties.ThumbnailMode, /) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.StorageItemThumbnail]: ...
    @typing.overload
    def get_thumbnail_async(self, mode: winsdk.windows.storage.fileproperties.ThumbnailMode, requested_size: winsdk.system.UInt32, /) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.StorageItemThumbnail]: ...
    @typing.overload
    def get_thumbnail_async(self, mode: winsdk.windows.storage.fileproperties.ThumbnailMode, requested_size: winsdk.system.UInt32, options: winsdk.windows.storage.fileproperties.ThumbnailOptions, /) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.StorageItemThumbnail]: ...
    def is_common_file_query_supported(self, query: winsdk.windows.storage.search.CommonFileQuery, /) -> winsdk.system.Boolean: ...
    def is_common_folder_query_supported(self, query: winsdk.windows.storage.search.CommonFolderQuery, /) -> winsdk.system.Boolean: ...
    def is_equal(self, item: typing.Optional[IStorageItem], /) -> winsdk.system.Boolean: ...
    def is_of_type(self, type: StorageItemTypes, /) -> winsdk.system.Boolean: ...
    @typing.overload
    def rename_async(self, desired_name: str, /) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def rename_async(self, desired_name: str, option: NameCollisionOption, /) -> winsdk.windows.foundation.IAsyncAction: ...
    def try_get_change_tracker(self) -> typing.Optional[StorageLibraryChangeTracker]: ...
    def try_get_item_async(self, name: str, /) -> winsdk.windows.foundation.IAsyncOperation[IStorageItem]: ...

class StorageLibrary(winsdk.system.Object):
    folders: typing.Optional[winsdk.windows.foundation.collections.IObservableVector[StorageFolder]]
    save_folder: typing.Optional[StorageFolder]
    change_tracker: typing.Optional[StorageLibraryChangeTracker]
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> StorageLibrary: ...
    def are_folder_suggestions_available_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    @staticmethod
    def get_library_async(library_id: KnownLibraryId, /) -> winsdk.windows.foundation.IAsyncOperation[StorageLibrary]: ...
    @staticmethod
    def get_library_for_user_async(user: typing.Optional[winsdk.windows.system.User], library_id: KnownLibraryId, /) -> winsdk.windows.foundation.IAsyncOperation[StorageLibrary]: ...
    def request_add_folder_async(self) -> winsdk.windows.foundation.IAsyncOperation[StorageFolder]: ...
    def request_remove_folder_async(self, folder: typing.Optional[StorageFolder], /) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    def add_definition_changed(self, handler: winsdk.windows.foundation.TypedEventHandler[StorageLibrary, winsdk.system.Object], /) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_definition_changed(self, event_cookie: winsdk.windows.foundation.EventRegistrationToken, /) -> None: ...

class StorageLibraryChange(winsdk.system.Object):
    change_type: StorageLibraryChangeType
    path: str
    previous_path: str
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> StorageLibraryChange: ...
    def get_storage_item_async(self) -> winsdk.windows.foundation.IAsyncOperation[IStorageItem]: ...
    def is_of_type(self, type: StorageItemTypes, /) -> winsdk.system.Boolean: ...

class StorageLibraryChangeReader(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> StorageLibraryChangeReader: ...
    def accept_changes_async(self) -> winsdk.windows.foundation.IAsyncAction: ...
    def get_last_change_id(self) -> winsdk.system.UInt64: ...
    def read_batch_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[StorageLibraryChange]]: ...

class StorageLibraryChangeTracker(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> StorageLibraryChangeTracker: ...
    def disable(self) -> None: ...
    @typing.overload
    def enable(self) -> None: ...
    @typing.overload
    def enable(self, options: typing.Optional[StorageLibraryChangeTrackerOptions], /) -> None: ...
    def get_change_reader(self) -> typing.Optional[StorageLibraryChangeReader]: ...
    def reset(self) -> None: ...

class StorageLibraryChangeTrackerOptions(winsdk.system.Object):
    track_change_details: winsdk.system.Boolean
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> StorageLibraryChangeTrackerOptions: ...
    def __new__(cls: typing.Type[StorageLibraryChangeTrackerOptions]) -> StorageLibraryChangeTrackerOptions:...

class StorageLibraryLastChangeId(winsdk.system.Object):
    unknown: typing.ClassVar[winsdk.system.UInt64]
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> StorageLibraryLastChangeId: ...

class StorageProvider(winsdk.system.Object):
    display_name: str
    id: str
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> StorageProvider: ...
    def is_property_supported_for_partial_file_async(self, property_canonical_name: str, /) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...

class StorageStreamTransaction(winsdk.system.Object):
    stream: typing.Optional[winsdk.windows.storage.streams.IRandomAccessStream]
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> StorageStreamTransaction: ...
    def close(self) -> None: ...
    def commit_async(self) -> winsdk.windows.foundation.IAsyncAction: ...

class StreamedFileDataRequest(winsdk.system.Object):
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> StreamedFileDataRequest: ...
    def close(self) -> None: ...
    def fail_and_close(self, failure_mode: StreamedFileFailureMode, /) -> None: ...
    def flush_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    def write_async(self, buffer: typing.Optional[winsdk.windows.storage.streams.IBuffer], /) -> winsdk.windows.foundation.IAsyncOperationWithProgress[winsdk.system.UInt32, winsdk.system.UInt32]: ...

class SystemAudioProperties(winsdk.system.Object):
    encoding_bitrate: str
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> SystemAudioProperties: ...

class SystemDataPaths(winsdk.system.Object):
    fonts: str
    program_data: str
    public: str
    public_desktop: str
    public_documents: str
    public_downloads: str
    public_music: str
    public_pictures: str
    public_videos: str
    system: str
    system_arm: str
    system_host: str
    system_x64: str
    system_x86: str
    user_profiles: str
    windows: str
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> SystemDataPaths: ...
    @staticmethod
    def get_default() -> typing.Optional[SystemDataPaths]: ...

class SystemGPSProperties(winsdk.system.Object):
    latitude_decimal: str
    longitude_decimal: str
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> SystemGPSProperties: ...

class SystemImageProperties(winsdk.system.Object):
    horizontal_size: str
    vertical_size: str
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> SystemImageProperties: ...

class SystemMediaProperties(winsdk.system.Object):
    duration: str
    producer: str
    publisher: str
    sub_title: str
    writer: str
    year: str
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> SystemMediaProperties: ...

class SystemMusicProperties(winsdk.system.Object):
    album_artist: str
    album_title: str
    artist: str
    composer: str
    conductor: str
    display_artist: str
    genre: str
    track_number: str
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> SystemMusicProperties: ...

class SystemPhotoProperties(winsdk.system.Object):
    camera_manufacturer: str
    camera_model: str
    date_taken: str
    orientation: str
    people_names: str
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> SystemPhotoProperties: ...

class SystemProperties(winsdk.system.Object):
    audio: typing.ClassVar[typing.Optional[SystemAudioProperties]]
    author: typing.ClassVar[str]
    comment: typing.ClassVar[str]
    g_p_s: typing.ClassVar[typing.Optional[SystemGPSProperties]]
    image: typing.ClassVar[typing.Optional[SystemImageProperties]]
    item_name_display: typing.ClassVar[str]
    keywords: typing.ClassVar[str]
    media: typing.ClassVar[typing.Optional[SystemMediaProperties]]
    music: typing.ClassVar[typing.Optional[SystemMusicProperties]]
    photo: typing.ClassVar[typing.Optional[SystemPhotoProperties]]
    rating: typing.ClassVar[str]
    title: typing.ClassVar[str]
    video: typing.ClassVar[typing.Optional[SystemVideoProperties]]
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> SystemProperties: ...

class SystemVideoProperties(winsdk.system.Object):
    director: str
    frame_height: str
    frame_width: str
    orientation: str
    total_bitrate: str
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> SystemVideoProperties: ...

class UserDataPaths(winsdk.system.Object):
    camera_roll: str
    cookies: str
    desktop: str
    documents: str
    downloads: str
    favorites: str
    history: str
    internet_cache: str
    local_app_data: str
    local_app_data_low: str
    music: str
    pictures: str
    profile: str
    recent: str
    roaming_app_data: str
    saved_pictures: str
    screenshots: str
    templates: str
    videos: str
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> UserDataPaths: ...
    @staticmethod
    def get_default() -> typing.Optional[UserDataPaths]: ...
    @staticmethod
    def get_for_user(user: typing.Optional[winsdk.windows.system.User], /) -> typing.Optional[UserDataPaths]: ...

class IStorageFile(winsdk.system.Object):
    content_type: str
    file_type: str
    attributes: FileAttributes
    date_created: datetime.datetime
    name: str
    path: str
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> IStorageFile: ...
    def copy_and_replace_async(self, file_to_replace: typing.Optional[IStorageFile], /) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def copy_async(self, destination_folder: typing.Optional[IStorageFolder], /) -> winsdk.windows.foundation.IAsyncOperation[StorageFile]: ...
    @typing.overload
    def copy_async(self, destination_folder: typing.Optional[IStorageFolder], desired_new_name: str, /) -> winsdk.windows.foundation.IAsyncOperation[StorageFile]: ...
    @typing.overload
    def copy_async(self, destination_folder: typing.Optional[IStorageFolder], desired_new_name: str, option: NameCollisionOption, /) -> winsdk.windows.foundation.IAsyncOperation[StorageFile]: ...
    @typing.overload
    def delete_async(self) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def delete_async(self, option: StorageDeleteOption, /) -> winsdk.windows.foundation.IAsyncAction: ...
    def get_basic_properties_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.BasicProperties]: ...
    def is_of_type(self, type: StorageItemTypes, /) -> winsdk.system.Boolean: ...
    def move_and_replace_async(self, file_to_replace: typing.Optional[IStorageFile], /) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def move_async(self, destination_folder: typing.Optional[IStorageFolder], /) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def move_async(self, destination_folder: typing.Optional[IStorageFolder], desired_new_name: str, /) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def move_async(self, destination_folder: typing.Optional[IStorageFolder], desired_new_name: str, option: NameCollisionOption, /) -> winsdk.windows.foundation.IAsyncAction: ...
    def open_async(self, access_mode: FileAccessMode, /) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.streams.IRandomAccessStream]: ...
    def open_read_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.streams.IRandomAccessStreamWithContentType]: ...
    def open_sequential_read_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.streams.IInputStream]: ...
    def open_transacted_write_async(self) -> winsdk.windows.foundation.IAsyncOperation[StorageStreamTransaction]: ...
    @typing.overload
    def rename_async(self, desired_name: str, /) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def rename_async(self, desired_name: str, option: NameCollisionOption, /) -> winsdk.windows.foundation.IAsyncAction: ...

class IStorageFile2(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> IStorageFile2: ...
    def open_async(self, access_mode: FileAccessMode, options: StorageOpenOptions, /) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.streams.IRandomAccessStream]: ...
    def open_transacted_write_async(self, options: StorageOpenOptions, /) -> winsdk.windows.foundation.IAsyncOperation[StorageStreamTransaction]: ...

class IStorageFilePropertiesWithAvailability(winsdk.system.Object):
    is_available: winsdk.system.Boolean
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> IStorageFilePropertiesWithAvailability: ...

class IStorageFolder(winsdk.system.Object):
    attributes: FileAttributes
    date_created: datetime.datetime
    name: str
    path: str
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> IStorageFolder: ...
    @typing.overload
    def create_file_async(self, desired_name: str, /) -> winsdk.windows.foundation.IAsyncOperation[StorageFile]: ...
    @typing.overload
    def create_file_async(self, desired_name: str, options: CreationCollisionOption, /) -> winsdk.windows.foundation.IAsyncOperation[StorageFile]: ...
    @typing.overload
    def create_folder_async(self, desired_name: str, /) -> winsdk.windows.foundation.IAsyncOperation[StorageFolder]: ...
    @typing.overload
    def create_folder_async(self, desired_name: str, options: CreationCollisionOption, /) -> winsdk.windows.foundation.IAsyncOperation[StorageFolder]: ...
    @typing.overload
    def delete_async(self) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def delete_async(self, option: StorageDeleteOption, /) -> winsdk.windows.foundation.IAsyncAction: ...
    def get_basic_properties_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.BasicProperties]: ...
    def get_file_async(self, name: str, /) -> winsdk.windows.foundation.IAsyncOperation[StorageFile]: ...
    def get_files_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[StorageFile]]: ...
    def get_folder_async(self, name: str, /) -> winsdk.windows.foundation.IAsyncOperation[StorageFolder]: ...
    def get_folders_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[StorageFolder]]: ...
    def get_item_async(self, name: str, /) -> winsdk.windows.foundation.IAsyncOperation[IStorageItem]: ...
    def get_items_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[IStorageItem]]: ...
    def is_of_type(self, type: StorageItemTypes, /) -> winsdk.system.Boolean: ...
    @typing.overload
    def rename_async(self, desired_name: str, /) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def rename_async(self, desired_name: str, option: NameCollisionOption, /) -> winsdk.windows.foundation.IAsyncAction: ...

class IStorageFolder2(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> IStorageFolder2: ...
    def try_get_item_async(self, name: str, /) -> winsdk.windows.foundation.IAsyncOperation[IStorageItem]: ...

class IStorageItem(winsdk.system.Object):
    attributes: FileAttributes
    date_created: datetime.datetime
    name: str
    path: str
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> IStorageItem: ...
    @typing.overload
    def delete_async(self) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def delete_async(self, option: StorageDeleteOption, /) -> winsdk.windows.foundation.IAsyncAction: ...
    def get_basic_properties_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.BasicProperties]: ...
    def is_of_type(self, type: StorageItemTypes, /) -> winsdk.system.Boolean: ...
    @typing.overload
    def rename_async(self, desired_name: str, /) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def rename_async(self, desired_name: str, option: NameCollisionOption, /) -> winsdk.windows.foundation.IAsyncAction: ...

class IStorageItem2(winsdk.system.Object):
    attributes: FileAttributes
    date_created: datetime.datetime
    name: str
    path: str
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> IStorageItem2: ...
    @typing.overload
    def delete_async(self) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def delete_async(self, option: StorageDeleteOption, /) -> winsdk.windows.foundation.IAsyncAction: ...
    def get_basic_properties_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.BasicProperties]: ...
    def get_parent_async(self) -> winsdk.windows.foundation.IAsyncOperation[StorageFolder]: ...
    def is_equal(self, item: typing.Optional[IStorageItem], /) -> winsdk.system.Boolean: ...
    def is_of_type(self, type: StorageItemTypes, /) -> winsdk.system.Boolean: ...
    @typing.overload
    def rename_async(self, desired_name: str, /) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def rename_async(self, desired_name: str, option: NameCollisionOption, /) -> winsdk.windows.foundation.IAsyncAction: ...

class IStorageItemProperties(winsdk.system.Object):
    display_name: str
    display_type: str
    folder_relative_id: str
    properties: typing.Optional[winsdk.windows.storage.fileproperties.StorageItemContentProperties]
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> IStorageItemProperties: ...
    @typing.overload
    def get_thumbnail_async(self, mode: winsdk.windows.storage.fileproperties.ThumbnailMode, /) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.StorageItemThumbnail]: ...
    @typing.overload
    def get_thumbnail_async(self, mode: winsdk.windows.storage.fileproperties.ThumbnailMode, requested_size: winsdk.system.UInt32, /) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.StorageItemThumbnail]: ...
    @typing.overload
    def get_thumbnail_async(self, mode: winsdk.windows.storage.fileproperties.ThumbnailMode, requested_size: winsdk.system.UInt32, options: winsdk.windows.storage.fileproperties.ThumbnailOptions, /) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.StorageItemThumbnail]: ...

class IStorageItemProperties2(winsdk.system.Object):
    display_name: str
    display_type: str
    folder_relative_id: str
    properties: typing.Optional[winsdk.windows.storage.fileproperties.StorageItemContentProperties]
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> IStorageItemProperties2: ...
    @typing.overload
    def get_scaled_image_as_thumbnail_async(self, mode: winsdk.windows.storage.fileproperties.ThumbnailMode, /) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.StorageItemThumbnail]: ...
    @typing.overload
    def get_scaled_image_as_thumbnail_async(self, mode: winsdk.windows.storage.fileproperties.ThumbnailMode, requested_size: winsdk.system.UInt32, /) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.StorageItemThumbnail]: ...
    @typing.overload
    def get_scaled_image_as_thumbnail_async(self, mode: winsdk.windows.storage.fileproperties.ThumbnailMode, requested_size: winsdk.system.UInt32, options: winsdk.windows.storage.fileproperties.ThumbnailOptions, /) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.StorageItemThumbnail]: ...
    @typing.overload
    def get_thumbnail_async(self, mode: winsdk.windows.storage.fileproperties.ThumbnailMode, /) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.StorageItemThumbnail]: ...
    @typing.overload
    def get_thumbnail_async(self, mode: winsdk.windows.storage.fileproperties.ThumbnailMode, requested_size: winsdk.system.UInt32, /) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.StorageItemThumbnail]: ...
    @typing.overload
    def get_thumbnail_async(self, mode: winsdk.windows.storage.fileproperties.ThumbnailMode, requested_size: winsdk.system.UInt32, options: winsdk.windows.storage.fileproperties.ThumbnailOptions, /) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.StorageItemThumbnail]: ...

class IStorageItemPropertiesWithProvider(winsdk.system.Object):
    provider: typing.Optional[StorageProvider]
    display_name: str
    display_type: str
    folder_relative_id: str
    properties: typing.Optional[winsdk.windows.storage.fileproperties.StorageItemContentProperties]
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> IStorageItemPropertiesWithProvider: ...
    @typing.overload
    def get_thumbnail_async(self, mode: winsdk.windows.storage.fileproperties.ThumbnailMode, /) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.StorageItemThumbnail]: ...
    @typing.overload
    def get_thumbnail_async(self, mode: winsdk.windows.storage.fileproperties.ThumbnailMode, requested_size: winsdk.system.UInt32, /) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.StorageItemThumbnail]: ...
    @typing.overload
    def get_thumbnail_async(self, mode: winsdk.windows.storage.fileproperties.ThumbnailMode, requested_size: winsdk.system.UInt32, options: winsdk.windows.storage.fileproperties.ThumbnailOptions, /) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.StorageItemThumbnail]: ...

class IStreamedFileDataRequest(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> IStreamedFileDataRequest: ...
    def fail_and_close(self, failure_mode: StreamedFileFailureMode, /) -> None: ...

ApplicationDataSetVersionHandler = typing.Callable[[typing.Optional[SetVersionRequest]], None]

StreamedFileDataRequestedHandler = typing.Callable[[typing.Optional[StreamedFileDataRequest]], None]

